<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="<?php print $language ?>" xml:lang="<?php print $language ?>">
<head>
<title><?php print $head_title ?></title>
<meta http-equiv="Content-Style-Type" content="text/css" />
<?php print $head ?>
<style type="text/css" media="all">
<!--
@import url(<?php print $base_path . $directory .'/modules.css'; ?>);
@import url(<?php print $base_path . $directory .'/common.css'; ?>);
-->
</style>
<?php print $styles ?>

</head>

<body <?php print $onload_attributes ?>>
<?php global $user ?>
<div id="header">

  <?php if ($logo) : ?>
    <a href="<?php print $base_path ?>" title="<?php print t('Home') ?>"><img id="logo" src="<?php print($logo) ?>" alt="Logo" /></a>
  <?php endif; ?>

  <?php if ($search_box): ?>
    <?php if ($search_url): ?>
    <form action="<?php print $search_url ?>" method="post">
      <div id="search">
        <input class="form-text" type="text" size="15" value="" name="edit[keys]" /><input class="form-submit" type="submit" value="<?php print $search_button_text ?>" />
      </div>
      <?php print form_token() ?>
    </form>
    <?php else: ?>
      <?php print $search_box ?>
    <?php endif; ?>
  <?php endif; ?>

  <?php if ($site_name) : ?>
    <h1 id="site-name"><a href="<?php print $base_path ?>" title="<?php print t('Home') ?>"><?php print $site_name ?></a></h1>
  <?php endif;?>
  <?php if ($site_slogan) : ?>
    <span id="site-slogan"><?php print $site_slogan ?></span>
  <?php endif;?>
  <br class="clear" />
</div>

<div id="top-nav">
  <?php if (count($secondary_links)) : ?>
  <ul id="secondary">
    <?php foreach ($secondary_links as $link): ?>
      <li><?php print $link ?></li>
    <?php endforeach; ?>
  </ul>
  <?php endif; ?>

  <?php if (count($primary_links)) : ?>
    <ul id="primary">
    <?php foreach ($primary_links as $link): ?>
      <li><?php print $link ?></li>
    <?php endforeach; ?>
    </ul>
    <br class="clear" />
  <?php endif; ?>
</div>

<?php if ($header): ?>
  <div id="header-block"><?php print $header ?><br class="clear" /></div>
<?php endif; ?>

<table id="content"><tr>

<td class="main-content" id="content-<?php print $layout ?>" valign="top">

  <?php print $breadcrumb ?>

  <?php if (($title != "") && (dirname($_GET['q']) != 'node' || $title == t('Page not found'))): ?>
  <h2 class="title"><?php print $title ?></h2>
  <?php endif; ?>

  <?php print $tabs ?>

  <?php if ($mission != ""): ?>
  <div id="mission"><?php print $mission ?></div>
  <?php endif; ?>

  <?php if ($help != ""): ?>
  <p id="help"><?php print $help ?></p>
  <?php endif; ?>

  <?php print $messages ?>
  <?php print($content) ?>

  </td>

</tr>
</table>

<!-- footer -->
<div id="footer">
  <?php print $footer_message; ?>
</div>

  <?php print $closure; ?>
</body>
</html>
