<?php
/**
 * Chinese Language file for PhpGedView.
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2008  PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @version $Id: lang.zh.php 6296 2009-11-04 00:06:28Z canajun2eh $
 * @translation mr_bobwang
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

//-- GENERAL HELP MESSAGES
$pgv_lang["qm"]				= "？";
$pgv_lang["help_for_this_page"]		= "幫助使用這頁";
$pgv_lang["hide_context_help"]		= "隐藏帮助";
$pgv_lang["help_not_exist"]		= "幫助文本, 為這個頁或項目, 不是可利用的";
$pgv_lang["header"]			= "標頭";
$pgv_lang["imageview"]				= "图像浏览器";
$pgv_lang["login_head"] 			= "家谱用户登录";
$pgv_lang["menu"]			= "菜單";
$pgv_lang["resolution"]			= "屏幕尺寸";
$pgv_lang["resolution"]			= "屏幕解決方法";
$pgv_lang["sorry"]			= "對不起, 我們未完成幫助文本為這個頁";
$pgv_lang["show_context_help"]		= "显示帮助";
$pgv_lang["help_contents"]		= "幫助目錄";
$pgv_lang["page_help"]			= "幫助";
//-- CONFIG FILE MESSAGES
$pgv_lang["error_title"]		= "錯誤: 不能打開GEDCOM 文件";
$pgv_lang["for_support"]		= "為技術支持和資訊聯絡";
$pgv_lang["for_contact"]		= "為幫助以譜學問題聯絡";
$pgv_lang["for_all_contact"]		= "如果需要技术支持或其它问题，请联络";
$pgv_lang["build_title"]		= "大廈索引文件";
$pgv_lang["choose_username"]		= "选择用户名";
$pgv_lang["choose_username"]		= "用户名";
$pgv_lang["build_error"]		= "GEDCOM 文件被更新了。";
$pgv_lang["choose_password"]		= "选择密码";
$pgv_lang["lastname"]				= "姓";
$pgv_lang["firstname"]				= "名字";
$pgv_lang["please_wait"]		= "請等待當索引文件必須被重建。";
$pgv_lang["choose_gedcom"]		= "选择GEDCOM 資料集";
$pgv_lang["username"]			= "账号名";
$pgv_lang["invalid_username"]		= "用户名有不允许的字";
$pgv_lang["fullname"]			= "全名";
$pgv_lang["password"]			= "密码";
$pgv_lang["confirm"]			= "确认密码";
$pgv_lang["login"]			= "登陆";
$pgv_lang["logout"]			= "注销";
$pgv_lang["admin"]			= "管理";
$pgv_lang["logged_in_as"]		= "登陆";
$pgv_lang["my_pedigree"]		= "我的家谱";
$pgv_lang["my_indi"]			= "我自己的信息";
$pgv_lang["yes"]			= "是";
$pgv_lang["no"]				= "不";
$pgv_lang["change_theme"]			= "改变背景主题";
//-- INDEX (PEDIGREE_TREE) FILE MESSAGES
$pgv_lang["index_header"]	= "家谱结构树";
$pgv_lang["gen_ped_chart"]	= "#PEDIGREE_GENERATIONS# 生成家譜圖表";
$pgv_lang["generations"]	= "几代人";
$pgv_lang["view"]		= "试图";
$pgv_lang["fam_spouse"]		= "家庭与配偶:";
$pgv_lang["root_person"]	= "根人員身份證:";
$pgv_lang["hide_details"]	= "隱藏詳細資料";
$pgv_lang["show_details"]	= "顯示詳細資料";
$pgv_lang["person_links"]	= "圖表的連結, 家庭, 並且這個人員的近親。";
$pgv_lang["zoom_box"]		= "迅速移動/在這個配件箱。";
$pgv_lang["orientation"]			= "方向";
$pgv_lang["portrait"]			= "竖图表";
$pgv_lang["start_at_parents"]		= "从父母开始";
$pgv_lang["welcome_page"]		= "欢迎界面";
$pgv_lang["lists"]			= "列表";
$pgv_lang["box_width"] 				= "框架宽度";
$pgv_lang["charts"]			= "图表";
$pgv_lang["landscape"]			= "宽图表";
//-- FUNCTIONS FILE MESSAGES
$pgv_lang["unable_to_find_family"]	= "無法找到家庭";
$pgv_lang["unable_to_find_indi"]	= "無法找到單個";
$pgv_lang["unable_to_find_record"]	= "無法查找記錄";
$pgv_lang["unable_to_find_source"]	= "無法查找來源";
$pgv_lang["unable_to_find_repo"]	= "無法查找程式庫";
$pgv_lang["repo_name"]			= "程式庫名字:";
$pgv_lang["address"]			= "地址:";
$pgv_lang["phone"]			= "电话:";
$pgv_lang["source_name"]		= "來源名字:";
$pgv_lang["title"]			= "题目:";
$pgv_lang["author"]			= "作者:";
$pgv_lang["publication"]		= "發行:";
$pgv_lang["call_number"]		= "索書號:";
$pgv_lang["living"]			= "居住";
$pgv_lang["private"]			= "个人隐私";
$pgv_lang["birth"]			= "生日：";
$pgv_lang["death"]			= "去世:";
$pgv_lang["descend_chart"]		= "儿女图表";
$pgv_lang["individual_list"]		= "个人列表";
$pgv_lang["family_list"]		= "家庭列表";
$pgv_lang["source_list"]		= "來源列表";
$pgv_lang["place_list"]			= "地方列表";
$pgv_lang["media_list"]			= "多媒體列表";
$pgv_lang["search"]			= "搜索";
$pgv_lang["clippings_cart"]		= "收集箱功能";
$pgv_lang["not_an_array"]		= "不是列陣";
$pgv_lang["print_preview"]		= "打印预览";
$pgv_lang["cancel_preview"] 		= "回到正常模式";
$pgv_lang["change_lang"]		= "更改語言";
$pgv_lang["print"]			= "打印";
$pgv_lang["total_queries"]		= "總資料庫查詢: ";
$pgv_lang["total_privacy_checks"]	= "总共隐私检查：";
$pgv_lang["back"]			= "返回";
$pgv_lang["aka"]					= "其它名";
//-- INDIVUDUAL FILE MESSAGES
$pgv_lang["male"]			= "男性";
$pgv_lang["female"]			= "女性";
$pgv_lang["temple"]			= "LDS 寺廟";
$pgv_lang["temple_code"]		= "LDS 寺廟編碼:";
$pgv_lang["status"]			= "狀態";
$pgv_lang["source"]			= "來源";
$pgv_lang["citation"]			= "引證:";
$pgv_lang["text"]			= "源文本:";
$pgv_lang["note"]			= "注";
$pgv_lang["NN"] 					= "(未知)";
$pgv_lang["PN"] 					= "(未知)";

$pgv_lang["unrecognized_code"]		= "未被認出的GEDCOM 編碼";
$pgv_lang["indi_info"]			= "个人资料";
$pgv_lang["pedigree_chart"]		= "家谱图表";
$pgv_lang["individual"]				= "个人";
$pgv_lang["desc_chart2"]		= "后代图表";
$pgv_lang["as_spouse"]			= "家庭與配偶";
$pgv_lang["as_child"]			= "这个人的家庭";
$pgv_lang["source_menu"]			= "来源的设置";
$pgv_lang["view_gedcom"]		= "看家谱的纪录";
$pgv_lang["add_to_cart"]		= "加入到图片收集";
$pgv_lang["still_living_error"]		= "這個人員居住或仍然不安排誕生或死亡日期被記錄。  生存人員所有詳細資料被隱藏從公共視圖。<br />為更多資訊聯絡";
$pgv_lang["privacy_error"]		= "詳細資料在這個人員專用。<br />";
$pgv_lang["more_information"]		= "如果需要更多的信息请联系";
$pgv_lang["name"]			= "名字:";
$pgv_lang["given_name"]			= "指定的名字:";
$pgv_lang["surname"]			= "姓氏:";
$pgv_lang["suffix"]			= "後綴:";
$pgv_lang["object_note"]		= "對象附註:";
$pgv_lang["sex"]			= "性別";
$pgv_lang["personal_facts"]		= "个人记录和详细资料";
$pgv_lang["type"]			= "类型";
$pgv_lang["place_description"]		= "安排/說明";
$pgv_lang["parents"] 			= "父母:";
$pgv_lang["siblings"] 			= "兄弟";
$pgv_lang["father"] 			= "父亲";
$pgv_lang["mother"] 			= "母亲";
$pgv_lang["parent"] 				= "家长";
$pgv_lang["self"] 					= "自己";
$pgv_lang["partner"] 				= "配偶";
$pgv_lang["relatives"]			= "近亲";
$pgv_lang["relatives_events"]		= "近亲的事件";
$pgv_lang["historical_facts"]		= "历史纪录";
$pgv_lang["child"]			= "儿女";
$pgv_lang["family"] 				= "家庭";
$pgv_lang["spouse"]			= "配偶";
$pgv_lang["spouses"] 				= "夫妻";
$pgv_lang["surnames"]			= "姓氏";
$pgv_lang["adopted"]			= "adopted 领养";
$pgv_lang["foster"]			= "foster 领养";
$pgv_lang["infant"]					= "幼儿";
$pgv_lang["stillborn"]				= "未出生";
$pgv_lang["deceased"]				= "去世";
$pgv_lang["sealing"]			= "Sealing";
$pgv_lang["link_as"]			= "把这个人连接到一个现有的家庭里去";
$pgv_lang["link_as_child"]		=	"把这个人当作个孩子连接到一个现有的家庭里去";
$pgv_lang["link_as_husband"]	=	"把这个人当作个丈夫连接到一个现有的家庭里去";
$pgv_lang["link_as_wife"]		=	"把这个人当作个妻子连接到一个现有的家庭里去";
//-- FAMILY FILE MESSAGES
$pgv_lang["family_info"]		= "家庭咨询";
$pgv_lang["family_group_info"]		= "家庭组咨询";
$pgv_lang["husband"]			= "丈夫";
$pgv_lang["wife"]			= "妻子";
$pgv_lang["marriage"]			= "婚姻:";
$pgv_lang["lds_sealing"]		= "LDS Sealing:";
$pgv_lang["marriage_license"]		= "结婚证书:";
$pgv_lang["childless_family"]		= "该家庭没有孩子";
$pgv_lang["media_object"]		= "多媒體對象:";
$pgv_lang["children"]			= "孩子";
$pgv_lang["no_children"]		= "沒有孩子";
$pgv_lang["parents_timeline"]		= "在时间表上显示父母";
//-- CLIPPINGS FILE MESSAGES
$pgv_lang["clip_cart"]			= "收集箱";
$pgv_lang["clip_explaination"]		= "你可以收集一些文件和图片以便下载。<br /><br />";
$pgv_lang["item_with_id"]		= "項目與";
$pgv_lang["error_already"]		= "已经在你的收集箱里。";
$pgv_lang["which_links"]		= "從這個家庭您並且會希望哪個連結添加?";
$pgv_lang["just_family"]		= "添加這個家庭記錄。";
$pgv_lang["parents_and_family"]		= "添加父項以這個家庭記錄。";
$pgv_lang["parents_and_child"]		= "添加父項和兒童記錄以這個家庭記錄。";
$pgv_lang["parents_desc"]		= "添加父項和所有後裔記錄以這個家庭記錄。";
$pgv_lang["continue"]			= "继续添加";
$pgv_lang["which_p_links"]		= "從這個人員您並且會希望哪個連結添加?";
$pgv_lang["just_person"]		= "添加这个人。";
$pgv_lang["person_parents_sibs"]	= "添加这个人, 他的父母, 並且兄弟姐妹。";
$pgv_lang["person_ancestors"]		= "添加这个人和他的直接祖先。";
$pgv_lang["person_ancestor_fams"]	="添加这个人, 他的直接祖先, 并且他们的家庭。";
$pgv_lang["person_spouse"]		= "添加这个人, 他的配偶, 並且孩子。";
$pgv_lang["person_desc"]		= "添加这个人, 他的配偶, 並且所有后裔記錄。";
$pgv_lang["unable_to_open"]		= "無法打開剪報文件夾為文字";
$pgv_lang["person_living"]		= "這個人員是生存。  私有詳細資料不會是包括的。";
$pgv_lang["person_private"]		= "關於這個人員的詳細資料專用。  私有詳細資料不會是包括的。";
$pgv_lang["download"]			= "用滑鼠右鍵單擊(控制點擊在Mac) 在連結如下和選擇\"之外目標和\" 下載文件。";
$pgv_lang["media_files"]		= "媒體文件參考在這GEDCOM";
$pgv_lang["cart_is_empty"]		= "您的收集箱是空的。";
$pgv_lang["id"]				= "代码";
$pgv_lang["ID"]				= "代码";
$pgv_lang["name_description"]		= "名字/說明";
$pgv_lang["remove"]			= "去除";
$pgv_lang["empty_cart"]			= "清空收集箱";
$pgv_lang["download_now"]		= "下载";
//-- PLACELIST FILE MESSAGES
$pgv_lang["connections"]		= "地方连接找到";
$pgv_lang["top_level"]			= "最高級";
$pgv_lang["form"]			= "安排被輸入以形式: ";
$pgv_lang["default_form"]		= "城市，省市，国家";
$pgv_lang["default_form_info"]		= "（默认）";
$pgv_lang["unknown"]			= "未知";
$pgv_lang["individuals"]			= "个人";
$pgv_lang["place_list2"] 			= "地方列表";
//-- MEDIALIST FILE MESSAGES
$pgv_lang["multi_title"]		= "多媒體對象列表";
$pgv_lang["media_found"]		= "媒體對象查找了";
$pgv_lang["view_person"]		= "看个人";
$pgv_lang["view_family"]		= "看家庭";
$pgv_lang["view_source"]		= "看來源";
$pgv_lang["view_object"]			= "看项目";
$pgv_lang["prev"]			= "上一个";
$pgv_lang["next"]			= "下一个";
$pgv_lang["next_image"]				= "下个图片";
$pgv_lang["file_not_found"]		= "文件沒被查找。";
$pgv_lang["medialist_show"] 		= "显示";
$pgv_lang["per_page"]				= "每页几个多媒体文件";
$pgv_lang["media_format"]			= "多媒体格式";
$pgv_lang["image_size"]				= "图像大小";
$pgv_lang["media_id"]				= "多媒体代码";
$pgv_lang["invalid_id"]				= "家谱文件中没有此代码";
$pgv_lang["record_updated"]			= "纪录 #pid# 成功被更新";
$pgv_lang["record_added"]			= "纪录 #xref# 成功加入家谱文件";
//-- SEARCH FILE MESSAGES
$pgv_lang["search_gedcom"]		= "搜索家谱文件";
$pgv_lang["search_geds"]			= "选择数据库搜索";
$pgv_lang["search_indis"]			= "个人名字";
$pgv_lang["search_inrecs"]			= "搜索";
$pgv_lang["search_prtall"]			= "全名";
$pgv_lang["search_prthit"]			= "被点击的名字";
$pgv_lang["results_per_page"]		= "每页的搜索结果";
$pgv_lang["enter_terms"]		= "请输入搜寻词语";
$pgv_lang["search_asso_label"]		= "同事";
$pgv_lang["search_asso_text"]		= "显示个人/家庭";
$pgv_lang["search_fams"]			= "姓名";
$pgv_lang["soundex_search"]		= "Soundex 名字搜索:";
$pgv_lang["search_results"]		= "搜索結果";
$pgv_lang["sources"]			= "來源";
$pgv_lang["firstname_search"]		= "名为";
$pgv_lang["search_prtnames"]		= "个人的<br />名字:";
$pgv_lang["other_searches"]			= "其他的搜索";
$pgv_lang["lastname_search"]		= "姓氏: ";
$pgv_lang["search_place"]		= "安排: ";
$pgv_lang["search_year"]		= "年: ";
$pgv_lang["lastname_empty"]		= "請輸入姓氏。";
$pgv_lang["no_results"]			= "結果沒有查找。";
$pgv_lang["search_sources"]			= "来源";
$pgv_lang["repo_list"]				= "文件夹列表";
$pgv_lang["total_repositories"]		= "总共文件夹";
$pgv_lang["soundex_results"]		= "或許以下soundex 符合將是有用的。";
//-- SOURCELIST FILE MESSAGES
$pgv_lang["sources_found"]		= "來源被查找";
//-- SOURCE FILE MESSAGES
$pgv_lang["source_info"]		= "来源资料";
$pgv_lang["other_records"]		= "其他的纪录:";
$pgv_lang["other_repo_records"]		= "把那个连接地址放入记录中";
$pgv_lang["repo_info"]				= "Repository文件夹信息";
$pgv_lang["people"]			= "人们";
$pgv_lang["families"]			= "家庭";
$pgv_lang["total_sources"]			= "总共来源";
//-- BUILDINDEX FILE MESSAGES
$pgv_lang["building_indi"]		= "创建个人和家庭连接标记";
$pgv_lang["building_index"]		= "创建连接标记";
$pgv_lang["importing_records"]		= "读取纪录";
$pgv_lang["detected_change"]		= "发现家谱文件有变化# #GEDCOM#.";
$pgv_lang["flushing"]			= "沖洗的目錄";
$pgv_lang["exec_time"]			= "执行命令时间:";
$pgv_lang["unable_to_create_index"]	="无法创建连接标记。 请确认可以写入权限被打开。 标记文件写后权限可以恢复。";
$pgv_lang["sec"]					= "秒。";
$pgv_lang["indi_complete"]		= "个人索引文件更新完全。";
$pgv_lang["family_complete"]		= "家庭索引文件更新完全。";
$pgv_lang["source_complete"]		= "來源索引文件更新完全。";
$pgv_lang["tables_exist"]		= "家谱表已在数据库里";
$pgv_lang["you_may"]			= "您可以:";
$pgv_lang["drop_tables"]		= "投下當前表";
$pgv_lang["import_multiple"]		= "導入和工作以多GEDCOMs";
$pgv_lang["explain_options"]		= "如果您選擇投下表所有資料用這GEDCOM 將替換。<br />如果您選擇導入和工作以多GEDCOMs, PhpGedView 將清除被導入使用一GEDCOM 以同樣文件名的任一個資料。  這個選項允許您對存儲多個GEDCOM 資料在同樣表中和容易地切換在他們之間。";
$pgv_lang["path_to_gedcom"]		= "家谱文件的连接地址:";
$pgv_lang["gedcom_title"]		= "家谱文件的名称：";
$pgv_lang["index_complete"]		= "连接完毕";
$pgv_lang["updating_is_dead"]		= "更新是死的狀態為INDI ";
$pgv_lang["updating_family_names"]	= "更新姓對於FAM ";
$pgv_lang["processed_for"]		= "被處理的文件為 ";
//-- INDIVIDUAL AND FAMILYLIST FILE MESSAGES
$pgv_lang["total_fams"]			= "总共家庭";
$pgv_lang["total_indis"]		= "总共个人";
$pgv_lang["notes"]					= "记录";
$pgv_lang["ssourcess"]				= "来源";
$pgv_lang["media"]					= "多媒体";
$pgv_lang["starts_with"]		= "开始为:";
$pgv_lang["person_list"]		= "个人名单:";
$pgv_lang["paste_person"]		= "粘贴这个人";
$pgv_lang["notes_sources_media"]	= "筆記, 來源, 並且媒介";
$pgv_lang["name_contains"]		= "名字包含:";
$pgv_lang["filter"]			= "过滤器";
$pgv_lang["find_individual"]		= "寻找个人代码号";
$pgv_lang["find_familyid"]			= "寻找家庭代码号";
$pgv_lang["find_sourceid"]			= "寻找来源代码号";
$pgv_lang["magnify"]				= "放大";
$pgv_lang["skip_surnames"]		= "跳姓氏名單";
$pgv_lang["show_surnames"]		= "顯示姓氏名單";
$pgv_lang["all"]			= "所有";
$pgv_lang["hidden"]					= "隐藏";
$pgv_lang["roots"]		 				= "根目录";
//-- TIMELINE FILE MESSAGES
$pgv_lang["age"]			= "年龄";
$pgv_lang["days"]					= "日";
$pgv_lang["months"]					= "月";
$pgv_lang["years"]					= "年";
$pgv_lang["day1"]					= "日";
$pgv_lang["month1"]					= "月";
$pgv_lang["year1"]					= "年";
$pgv_lang["after_death"]        ="去世后";
$pgv_lang["timeline_title"]		= "家谱时间表";
$pgv_lang["timeline_chart"]		= "時間安排圖";
$pgv_lang["remove_person"]		= "去除人";
$pgv_lang["show_age"]			= "先是年龄标记";
$pgv_lang["add_another"]		= "增加其它人:<br />个人代码号::";
$pgv_lang["find_id"]			= "寻找代码号";
$pgv_lang["show"]			= "显示";
$pgv_lang["year"]			= "年:";
$pgv_lang["timeline_instructions"]	= "新的浏览器可以让你随意摆放方格";
$pgv_lang["zoom_in"]			= "放大";
$pgv_lang["zoom_out"]			= "缩小";
$pgv_lang["timeline_beginYear"] = "开始年";
$pgv_lang["timeline_endYear"] = "结束年";
$pgv_lang["timeline_scrollSpeed"] = "速度";
$pgv_lang["timeline_controls"] = "时间表的控制";
$pgv_lang["include_family"] = "加入近亲的家庭";
$pgv_lang["lifespan_chart"] = "寿命表";
$pgv_lang["cal_none"]                 = "没有日历换算";
$pgv_lang["cal_gregorian"]            = "正常日历";
//-- MONTH NAMES
$pgv_lang["jan"]			= "一月";
$pgv_lang["feb"]			= "二月";
$pgv_lang["mar"]			= "三月";
$pgv_lang["apr"]			= "四月";
$pgv_lang["may"]			= "五月";
$pgv_lang["jun"]			= "六月";
$pgv_lang["jul"]			= "七月";
$pgv_lang["aug"]			= "八月";
$pgv_lang["sep"]			= "九月";
$pgv_lang["oct"]			= "十月";
$pgv_lang["nov"]			= "十一月";
$pgv_lang["dec"]			= "十二月";
$pgv_lang["abt"]			= "关于";
$pgv_lang["aft"]			= "以後";
$pgv_lang["and"]			= "並且";
$pgv_lang["bef"]			= "以前";
$pgv_lang["bet"]			= "之间";
$pgv_lang["cal"]			= "计算";
$pgv_lang["est"]			= "估計";
$pgv_lang["from"]			= "从";
$pgv_lang["int"]			= "解释";
$pgv_lang["to"] 			= "到达";
$pgv_lang["cir"]			= "大約";
$pgv_lang["apx"]			= "大約";
 
//-- chinese numbers
$pgv_lang["0"]			= "零";
$pgv_lang["1"]			= "一";
$pgv_lang["2"]			= "二";
$pgv_lang["3"]			= "三";
$pgv_lang["4"]			= "四";
$pgv_lang["5"]			= "五";
$pgv_lang["6"]			= "六";
$pgv_lang["7"]			= "七";
$pgv_lang["8"]			= "八";
$pgv_lang["9"]			= "九";
$pgv_lang["10"]			= "十";
$pgv_lang["100"]		= "百";
$pgv_lang["1000"]		= "千";
//-- Admin File Messages
$pgv_lang["rebuild_indexes"]		= "重新创建网页连接点";
$pgv_lang["user_admin"]			= "用戶管理";
$pgv_lang["manage_media"]			= "管理媒体";
$pgv_lang["stat_users"]				= "总用户";
$pgv_lang["no_family_facts"]		= "这个家庭没有信息。";
$pgv_lang["stat_females"]			= "总共女性";
$pgv_lang["htmlplus_block_birth"]	= "出生";
$pgv_lang["comments"]				= "注解";
$pgv_lang["support_contact"]		= "技术帮助请联系";
$pgv_lang["show_spouses"]		= "显示夫妻";
$pgv_lang["review_changes_subject"]	= "家谱 - 修改变化";
$pgv_lang["show_pending"]		= "显示等待的变化";
$pgv_lang["review_changes_block"]	= "等待变化";
$pgv_lang["total_names"]			= "总共名字";
$pgv_lang["reorder_families"]		= "重新改动家庭摆列";
$pgv_lang["indis_with_surname"]		= "有 #surname# 姓名的个人";
$pgv_lang["total_memory_usage"]		= "共用记忆";
$pgv_lang["halfsibling"]			= "半兄弟姐妹";
$pgv_lang["halfbrother"]			= "半兄弟";
$pgv_lang["halfsister"]				= "半姐妹";
$pgv_lang["family_timeline"]		= "在时间表上显示家庭";
$pgv_lang["children_timeline"]		= "在时间表上显示孩子";
$pgv_lang["other"]					= "其它";
$pgv_lang["sort_by_marriage"]		= "按结婚日排列";
$pgv_lang["genealogy_contact"]		= "家谱联系";
$pgv_lang["remember_me"]			= "在此电脑记住我";
$pgv_lang["fams_with_surname"]		= "有 #surname# 的家庭";
$pgv_lang["child-family"]			= "父母和兄弟姐妹";
$pgv_lang["spouse-family"]			= "配偶和儿女";
$pgv_lang["direct-ancestors"]		= "直接有联系的祖宗";
$pgv_lang["ancestors"]				= "直接有联系的祖宗和他们的家庭";
$pgv_lang["total_not_born"]			= "总共未出生";
$pgv_lang["total_dead"]				= "总共去世";
$pgv_lang["total_living"]			= "总共活的";
$pgv_lang["choose_relatives"]		= "选择亲戚";
$pgv_lang["relatives_report"]		= "亲戚报表";
$pgv_lang["descendants"]			= "子孙后代";
$pgv_lang["config_block"]			= "调节";
$pgv_lang["enter_comments"]			= "请输入关系";
$pgv_lang["after"]					= "之后";
$pgv_lang["before"]					= "之前";
$pgv_lang["htmlplus_block_burial"]	= "埋葬";
$pgv_lang["htmlplus_block_census"]	= "人口调查加入档案";
$pgv_lang["num_to_show"]			= "文件显示数量";
$pgv_lang["days_to_show"]			= "显示几天";
$pgv_lang["before_or_after"]		= "在名字之前和之后加上数量";
$pgv_lang["htmlplus_block_marrage"]	= "结婚";
$pgv_lang["htmlplus_block_adoption"]= "代养儿女";
$pgv_lang["htmlplus_block_death"]	= "去世";
$pgv_lang["stat_males"]				= "总共男性";


$pgv_lang["edit_source"]			= "编辑该文件";
$pgv_lang["familybook_chart"]		= "家庭册";
$pgv_lang["family_of"]				= ":&nbsp; 的家庭";
$pgv_lang["cancel"]					= "取消";
$pgv_lang["link_remote"]            = "连接远方个人";
$pgv_lang["delete_family"]			= "删除家庭";
$pgv_lang["add_favorite"]			= "添加一个收藏";
$pgv_lang["url"]					= "网络地址";
$pgv_lang["add_fav_enter_id"]		= "输入个人，家庭，或来源代码";
$pgv_lang["remove_child"]			= "从家中删除这个孩子";
$pgv_lang["link_new_husb"]			= "用已有的个人当这人的丈夫";
$pgv_lang["link_new_wife"]			= "用已有的个人当这人的妻子";
$pgv_lang["address_labels"]			= "地址标签";
$pgv_lang["filter_address"]			= "显示拥有这些的地址：";
$pgv_lang["address_list"]			= "地址列表";
$pgv_lang["changelog"]				= "版本 #VERSION# 的变化所在";
$pgv_lang["html_block_name"]		= "网络编程语言HTML";
$pgv_lang["htmlplus_block_name"]	= "网络高级编程语言HTML";
$pgv_lang["htmlplus_block_templates"] = "格式表";
$pgv_lang["htmlplus_block_content"] = "内容";
$pgv_lang["htmlplus_block_keyword"]	= "短句例子（只有英文）";
$pgv_lang["htmlplus_block_current"]	= "现有的";
$pgv_lang["htmlplus_block_default"]	= "默认的";
$pgv_lang["htmlplus_block_gedcom"]	= "家谱";

$pgv_lang["dec_1st"]					= "十二月";
$pgv_lang["nov_1st"]					= "十一月";
$pgv_lang["oct_1st"]					= "十月";
$pgv_lang["sep_1st"]					= "九月";
$pgv_lang["aug_1st"]					= "八月";
$pgv_lang["jul_1st"]					= "七月";
$pgv_lang["jun_1st"]					= "六月";
$pgv_lang["may_1st"]					= "五月";
$pgv_lang["apr_1st"]					= "四月";
$pgv_lang["mar_1st"]					= "三月";
$pgv_lang["feb_1st"]					= "二月";
$pgv_lang["jan_1st"]					= "一月";

$pgv_lang["sunday_1st"]				= "周日";
$pgv_lang["saturday_1st"]			= "周六";
$pgv_lang["friday_1st"]				= "周五";
$pgv_lang["thursday_1st"]			= "周四";
$pgv_lang["wednesday_1st"]			= "周三";
$pgv_lang["tuesday_1st"]			= "周二";
$pgv_lang["monday_1st"]				= "周一";

$pgv_lang["stat_avg_age_at_death"]	= "去世的平均年龄";
$pgv_lang["stat_longest_life"]		= "寿命最长的";
$pgv_lang["stat_most_children"]		= "有最多孩子的家庭";
$pgv_lang["stat_average_children"]	= "平均家庭里的孩子数量";
$pgv_lang["stat_events"]			= "总共事件";
$pgv_lang["stat_media"]				= "多媒体文件";
$pgv_lang["stat_surnames"]			= "总共姓名";
$pgv_lang["loading"]				= "读取中...";
$pgv_lang["clear_chart"]			= "清表格";
$pgv_lang["file_information"]		= "文件信息";
$pgv_lang["choose_file_type"]		= "文件类型";
$pgv_lang["add_individual_by_id"]	= "用代码加入个人";
$pgv_lang["advanced_options"]		= "高级设置";
$pgv_lang["zip_files"]				= "压缩文件";
$pgv_lang["include_media"]			= "加入多媒体（自动创建压缩文件）";
$pgv_lang["roman_surn"]				= "罗马化的姓";
$pgv_lang["roman_givn"]				= "罗马化的名";
$pgv_lang["include"]				= "包括：";
$pgv_lang["page_x_of_y"]				= "现在页数为 #GLOBALS[currentPage]# 总共页数为 #GLOBALS[lastPage]#";
$pgv_lang["options"]				= "选项：";
$pgv_lang["config_update_ok"]			= "设置文件成功修改";
$pgv_lang["page_size"]					= "页面大小";
$pgv_lang["edit_media"]					= "编辑媒体文件";
$pgv_lang["wiki_main_page"]				= "Wiki 主页";
$pgv_lang["wiki_users_guide"]			= "Wiki 用户指导";
$pgv_lang["wiki_admin_guide"]			= "Wiki 管理员的指导";
$pgv_lang["ex-spouse"] = "前夫妻";
$pgv_lang["ex-wife"] = "前妻";
$pgv_lang["ex-husband"] = "前夫";
$pgv_lang["onlyemail"] 				= "只允许电子邮件地址";
$pgv_lang["chart_new"]				= "家谱图表";
$pgv_lang["search_general"]			= "普通搜索";
$pgv_lang["clipping_privacy"]		= "因为隐私，有些信息不能被加入";
$pgv_lang["password_mismatch"]		= "密码不对";
$pgv_lang["enter_username"]		= "你必须输入一个用户名";
$pgv_lang["enter_fullname"]		= "你必须输入全名";
$pgv_lang["enter_password"]		= "你必须输入一个密码。";
$pgv_lang["confirm_password"]		= "您必須證實密碼。";
$pgv_lang["save"]			= "保存";
$pgv_lang["saveandgo"]		= "保存并到新纪录去";
$pgv_lang["delete"]			= "刪除";
$pgv_lang["edit"]			= "编辑";
$pgv_lang["no_login"]			= "無法确认用戶。";
$pgv_lang["basic_realm"]			= "进入家谱系统";
$pgv_lang["basic_auth_failure"]		= "你必须输入一个正确的用户名和密码才可以进入这个资源";
$pgv_lang["file_not_exists"]		= "你输入的用户名不存在";
$pgv_lang["research_assistant"]		= "资料调查助理";
$pgv_lang["import_gedcom"]		= "导入家谱文件";
$pgv_lang["enter_gedcomid"]		= "您必須输入家谱代码。";
$pgv_lang["user_info"]			= "我的用戶信息";
$pgv_lang["upload_help"]		= "選擇一個文件從您的地方電腦上裝對您的伺服器。  所有文件將被上裝對目錄:";
$pgv_lang["research_log"]		= "研究日记";
$pgv_lang["utf8_to_ansi"]		= "您想要轉換這GEDCOM 从UTF-8 到ANSI (ISO-8859-1)?";
$pgv_lang["media_linked"]			= "这个媒体连接到：";

$pgv_lang["view_slideshow"] 		= "看幻灯";
$pgv_lang["download_image"]			= "下载文件";
$pgv_lang["file_size"]				= "文件大小";
$pgv_lang["img_size"]				= "图片大小";
$pgv_lang["button_SEX_F"] = "只要显示女士";
$pgv_lang["button_SEX_M"] = "只要显示男士";

$pgv_lang["hs_search"] 			= "搜索";
$pgv_lang["hs_close"] 			= "关闭窗口";
$pgv_lang["stplmonth"]			 = "月";
$pgv_lang["stplperc"]			 = "百分比";
$pgv_lang["preview"] 			= 	"预览";
$pgv_lang["stplage"]			 = "年龄";

//-- Media item "TYPE" sub-field
$pgv_lang["TYPE__audio"] = "录音";
$pgv_lang["TYPE__book"] = "书";
$pgv_lang["TYPE__card"] = "卡片";
$pgv_lang["TYPE__certificate"] = "证书";
$pgv_lang["TYPE__document"] = "文件";
$pgv_lang["TYPE__electronic"] = "电子文件";
$pgv_lang["TYPE__fiche"] = "微制图";
$pgv_lang["TYPE__film"] = "微制图片";
$pgv_lang["TYPE__magazine"] = "杂志";
$pgv_lang["TYPE__manuscript"] = "原文";
$pgv_lang["TYPE__map"] = "地图";
$pgv_lang["TYPE__newspaper"] = "报纸";
$pgv_lang["TYPE__photo"] = "照片";
$pgv_lang["TYPE__tombstone"] = "墓碑";
$pgv_lang["TYPE__video"] = "录像";
$pgv_lang["TYPE__painting"] = "毛笔画";
$pgv_lang["TYPE__other"] = "其他";

//-- Relationship chart messages
//-- Chinese Translations from--http://www.kwanfamily.info/familytitles/familytitle.html
//-- Chinese RelationShip chart-- http://www.kwanfamily.info/familytitles/familytitlejpg.html
$pgv_lang["relationship_chart"]		= "关系图";
$pgv_lang["person1"]			= "第一个人";
$pgv_lang["person2"]			= "第二个人";
$pgv_lang["no_link_found"]		= "没有发现两者的连接";
//--Sosa came from the lang.sv.php file it is a key value relationship pattern for parents and grandparents
//1st generation
$pgv_lang["sosa_2"]	= "爸爸";
$pgv_lang["sosa_3"] = "妈妈";
//2nd generation
$pgv_lang["sosa_4"] = "爷爷";
$pgv_lang["sosa_5"] = "奶奶";
$pgv_lang["sosa_6"] = "姥爷";
$pgv_lang["sosa_7"] = "姥姥";
//3rd generation
$pgv_lang["sosa_8"] = "曾祖父";
$pgv_lang["sosa_9"] = "曾祖母";
$pgv_lang["sosa_10"] = "曾祖父";
$pgv_lang["sosa_11"] = "曾祖母";
$pgv_lang["sosa_12"] = "曾外公";
$pgv_lang["sosa_13"] = "曾外婆";
$pgv_lang["sosa_14"] = "曾外公";
$pgv_lang["sosa_15"] = "曾外婆";
//4th generation
$pgv_lang["sosa_16"] = "高祖父";
$pgv_lang["sosa_17"] = "高祖母";
$pgv_lang["sosa_18"] = "高祖父";
$pgv_lang["sosa_19"] = "高祖母";
$pgv_lang["sosa_20"] = "高祖父";
$pgv_lang["sosa_21"] = "高祖母";
$pgv_lang["sosa_22"] = "高祖父";
$pgv_lang["sosa_23"] = "高祖母";
$pgv_lang["sosa_24"] = "高外公";
$pgv_lang["sosa_25"] = "高外婆";
$pgv_lang["sosa_26"] = "高外公";
$pgv_lang["sosa_27"] = "高外婆";
$pgv_lang["sosa_28"] = "高外公";
$pgv_lang["sosa_29"] = "高外婆";
$pgv_lang["sosa_30"] = "高外公";
$pgv_lang["sosa_31"] = "高外婆";

//5th generation
$pgv_lang["sosa_32"] = "N/A";
$pgv_lang["sosa_33"] = "N/A";
$pgv_lang["sosa_34"] = "N/A";
$pgv_lang["sosa_35"] = "N/A";
$pgv_lang["sosa_36"] = "N/A";
$pgv_lang["sosa_37"] = "N/A";
$pgv_lang["sosa_38"] = "N/A";
$pgv_lang["sosa_39"] = "N/A";
$pgv_lang["sosa_40"] = "N/A";
$pgv_lang["sosa_41"] = "N/A";
$pgv_lang["sosa_42"] = "N/A";
$pgv_lang["sosa_43"] = "N/A";
$pgv_lang["sosa_44"] = "N/A";
$pgv_lang["sosa_45"] = "N/A";
$pgv_lang["sosa_46"] = "N/A";
$pgv_lang["sosa_47"] = "N/A";
$pgv_lang["sosa_48"] = "N/A";
$pgv_lang["sosa_49"] = "N/A";
$pgv_lang["sosa_50"] = "N/A";
$pgv_lang["sosa_51"] = "N/A";
$pgv_lang["sosa_52"] = "N/A";
$pgv_lang["sosa_53"] = "N/A";
$pgv_lang["sosa_54"] = "N/A";
$pgv_lang["sosa_55"] = "N/A";
$pgv_lang["sosa_56"] = "N/A";
$pgv_lang["sosa_57"] = "N/A";
$pgv_lang["sosa_58"] = "N/A";
$pgv_lang["sosa_59"] = "N/A";
$pgv_lang["sosa_60"] = "N/A";
$pgv_lang["sosa_61"] = "N/A";
$pgv_lang["sosa_62"] = "N/A";
$pgv_lang["sosa_63"] = "N/A";
//--Great-great-grandparnets Generation
$pgv_lang["paternal great great grandfather"]	= "高祖父";
$pgv_lang["paternal great great grandmother"]	= "高祖母";
$pgv_lang["maternal great great grandfather"]	= "高外公";
$pgv_lang["maternal great great grandmother"]	= "高外婆";
//--Great-grandparents Generation
$pgv_lang["paternal great grandfather"]	= "曾祖父";
$pgv_lang["paternal great grandmother"]	= "曾祖母";
$pgv_lang["maternal great grandfather"]	= "曾外公";
$pgv_lang["maternal great grandmother"]	= "曾外婆";
//--Grandparents Generation
$pgv_lang["paternal grandfather"]	= "爷爷";
$pgv_lang["paternal grandmother"]	= "奶奶";
$pgv_lang["maternal grandfather"]	= "老爷";
$pgv_lang["maternal grandmother"]	= "姥姥";
$pgv_lang["paternal elder great uncle"]	= "伯祖父";
$pgv_lang["paternal elder great uncle's wife"]	= "伯祖母";
$pgv_lang["paternal younger great uncle"]	= "叔祖父";
$pgv_lang["paternal younger great uncle's wife"] = "叔祖母";
$pgv_lang["paternal great aunt"]	= "祖姑母";
$pgv_lang["paternal great aunt's husband"] = "祖姑丈";
//--Parents generation
$pgv_lang["father"] = "爸爸";
//could not find paternal uncle translation. this is our best guess.
$pgv_lang["paternal uncle"] = "达达";
$pgv_lang["paternal older uncle"]	= "伯父";
$pgv_lang["paternal older uncle's wife"]	= "伯母";
$pgv_lang["paternal younger uncle"]	= "叔父";
$pgv_lang["paternal younger uncle's wife"] = "嬸母";
$pgv_lang["paternal aunt"] = "姑姑";
$pgv_lang["paternal aunt's husband"] = "姑夫";
$pgv_lang["paternal older aunt"]	= "姑媽";
$pgv_lang["paternal older aunt's husband"] = "姑夫";
$pgv_lang["paternal younger aunt"]	= "姑姑";
$pgv_lang["paternal younger aunt's husband"] = "姑夫";
$pgv_lang["mother"] = "妈妈";
$pgv_lang["maternal uncle"]	= "舅舅";
$pgv_lang["maternal uncle's wife"]	= "舅母";
$pgv_lang["maternal elder aunt"]	= "姨母";
$pgv_lang["maternal elder aunt's husband"] = "姨夫";
$pgv_lang["maternal younger aunt"]	= "姨";
$pgv_lang["maternal younger aunt's husband"] = "姨夫";
//--Your Generations
$pgv_lang["older brother"] = "哥哥";
$pgv_lang["elder brother's wife"] = "嫂子";
$pgv_lang["younger brother"]	= "弟弟";
$pgv_lang["younger brother's wife"]	= "弟婦";
$pgv_lang["elder sister"] = "姐姐";
$pgv_lang["elder sister's husband"]	= "姐夫";
$pgv_lang["younger sister"]	= "妹妹";
$pgv_lang["younger sister's husband"] = "妹夫";

$pgv_lang["paternal male cousin"]	= "堂兄弟";
$pgv_lang["paternal elder male cousin"]	= "堂哥";
$pgv_lang["paternal elder male cousin's wife"]	= "堂嫂";
$pgv_lang["paternal younger male cousin"]	= "堂弟";
$pgv_lang["paternal younger male cousin's wife"] = "堂弟婦";
$pgv_lang["paternal female cousin"]	= "堂姐妹";
$pgv_lang["paternal elder female cousin"]	= "堂姐";
$pgv_lang["paternal elder female cousin's husband"]	= "堂姐夫";
$pgv_lang["paternal younger female cousin"] = "堂妹";
$pgv_lang["paternal younger female cousin's husband"]	= "堂妹夫";

$pgv_lang["maternal male cousin"]	= "表兄弟";
$pgv_lang["maternal elder male cousin"]	= "表哥";
$pgv_lang["maternal elder male cousin's wife"]	= "表嫂";
$pgv_lang["maternal younger male cousin"]	= "表弟";
$pgv_lang["maternal younger male cousin's wife "] = "表夫";
$pgv_lang["maternal female cousin"]	= "表姐妹";
$pgv_lang["maternal elder female cousin"]	= "表姐";
$pgv_lang["maternal elder female cousin's husband"]	= "表姐夫";
$pgv_lang["maternal younger female cousin"]	= "表妹";
$pgv_lang["maternal younger female cousin's husband"]	= "表妹夫";

//--bosa came from the lang.sv.php file it is a key value relationship pattern for parents and children
//--it is made up to follow the sosa pattern, "bosa" has no meaning that we know of.
// add this key to other language files to work with the relationship algorithm
//1st generation
$pgv_lang["bosa_2"]	= "儿子";
$pgv_lang["bosa_3"] = "女儿";
//2nd generation
$pgv_lang["bosa_4"] = "孙子";
$pgv_lang["bosa_5"] = "孙女";
$pgv_lang["bosa_6"] = "外孙子";
$pgv_lang["bosa_7"] = "外孙女";
//3rd generation
$pgv_lang["bosa_8"] = "曾內孫仔";
$pgv_lang["bosa_9"] = "曾內孫女";
$pgv_lang["bosa_10"] = "曾內孫仔";
$pgv_lang["bosa_11"] = "曾內孫女";
$pgv_lang["bosa_12"] = "曾內孫仔";
$pgv_lang["bosa_13"] = "曾內孫女";
$pgv_lang["bosa_14"] = "曾內孫仔";
$pgv_lang["bosa_15"] = "曾內孫女";
//4th generation
$pgv_lang["bosa_16"] = "玄孫";
$pgv_lang["bosa_17"] = "玄孫";
$pgv_lang["bosa_18"] = "玄孫";
$pgv_lang["bosa_19"] = "玄孫";
$pgv_lang["bosa_20"] = "玄孫";
$pgv_lang["bosa_21"] = "玄孫";
$pgv_lang["bosa_22"] = "玄孫";
$pgv_lang["bosa_23"] = "玄孫";
$pgv_lang["bosa_24"] = "玄孫";
$pgv_lang["bosa_25"] = "玄孫";
$pgv_lang["bosa_26"] = "玄孫";
$pgv_lang["bosa_27"] = "玄孫";
$pgv_lang["bosa_28"] = "玄孫";
$pgv_lang["bosa_29"] = "玄孫";
$pgv_lang["bosa_30"] = "玄孫";
$pgv_lang["bosa_31"] = "玄孫";
//--Children's Generation
$pgv_lang["son"]	= "儿子";
$pgv_lang["son's wife"]	= "儿媳妇";
$pgv_lang["daughter"]	= "女儿";
$pgv_lang["daughter's husband"] = "女婿";
$pgv_lang["nephew"] = "外甥";
$pgv_lang["nephew's wife"] = "外甥媳婦";
$pgv_lang["niece"] = "姪女";
$pgv_lang["show_path"]				= "显示连接路线";
$pgv_lang["niece's husband"]	= "姪女婿";
//--Grandchildren's Generation from detail 
$pgv_lang["son's son"]	= "孙子";
$pgv_lang["son's son's wife"]	= "孙媳婦";
$pgv_lang["son's daughter"]	= "孙女";
$pgv_lang["son's daughter's husband"] = "孙女婿";
$pgv_lang["daugghter's son"]	= "外孙";
$pgv_lang["daughter's daughter"]	= "外孙女";
$pgv_lang["Brother's son's son "]	= "姪孙";
$pgv_lang["brother's son's daughter"] = "姪孙女";
//--Greatgrandchildrens Generation from detail of http://www.kwanfamily.info/familytitles/familytitle.html#memc
$pgv_lang["children's children's children"] = "曾孫";
$pgv_lang["children's children's son"] = "曾內孫仔";
$pgv_lang["children's children's daughter"] = "曾內孫女";
//--great-great grandchildren generation
$pgv_lang["children's children's children's children's"] = "玄孙";
$pgv_lang["sibling"]			= "兄弟姐妹";
$pgv_lang["follow_spouse"]		= "经过婚姻关系测验";
$pgv_lang["timeout_error"]		= "找不到关系。";
$pgv_lang["grandchild"]				= "孙子女";
$pgv_lang["grandson"]				= "孙子";
$pgv_lang["granddaughter"]			= "孙女";
$pgv_lang["son"]			= "儿子";
$pgv_lang["daughter"]			= "女儿";
$pgv_lang["brother"]			= "兄弟";
$pgv_lang["sister"]			= "姐妹";
//-- GEDCOM edit utility
$pgv_lang["check_delete"]		= "是否確實要刪除這個GEDCOM 情況嗎?";
$pgv_lang["access_denied"]		= "<b>不允许</b><br />你不允许用这个资源。";
$pgv_lang["changes_exist"]		= "家谱文件被改过。";
$pgv_lang["find_place"]			= "查找安排";
$pgv_lang["close_window"]		= "关闭窗口";
$pgv_lang["close_window_without_refresh"]	= "关闭窗口但不要刷新";
$pgv_lang["place_contains"]		= "安排包含:";
$pgv_lang["now_import"]			= "現在您應該導入GEDCOM 記錄入PhpGedView 由點擊在導入連結如下。";
$pgv_lang["add"]			= "添加";
$pgv_lang["custom_event"]		= "自定义活动";
$pgv_lang["delete_person"]		= "删除这个人";
$pgv_lang["confirm_delete_person"]	= "确认从家铺文件中删除这个人？";
$pgv_lang["find_media"]			= "查找媒體";
$pgv_lang["set_link"]			= "设置连接";
$pgv_lang["delete_source"]		= "删除这个来源";
$pgv_lang["confirm_delete_source"]	= "确认从家铺文件中删除这个来源？";
$pgv_lang["find_family"]		= "找到家庭";
$pgv_lang["find_fam_list"]			= "找到家庭列表";
$pgv_lang["edit_name"]			= "编辑名字";
$pgv_lang["delete_name"]		= "刪除名字";
$pgv_lang["select_date"]			= "选择日期";
$pgv_lang["bdm"]					= "出生，去世，婚姻";
//-- calendar.php messages
$pgv_lang["on_this_day"]		= "在这一天...";
$pgv_lang["in_this_month"]			= "在这个月 ...";
$pgv_lang["in_this_year"]			= "在这年 ...";
$pgv_lang["year_anniversary"]		= "#year_var# 年週年紀念";
$pgv_lang["today"]					= "今天";
$pgv_lang["day"]			= "日:";
$pgv_lang["showcal"]				= "显示事情：";
$pgv_lang["anniversary"]			= "纪念日";
$pgv_lang["month"]			= "月份:";
$pgv_lang["anniversary_calendar"] 	= "週年紀念日历";
$pgv_lang["sunday"]			= "星期天";
$pgv_lang["monday"]			= "星期一";
$pgv_lang["tuesday"]			= "星期二";
$pgv_lang["wednesday"]			= "星期三";
$pgv_lang["thursday"]			= "星期四";
$pgv_lang["friday"]			= "星期五";
$pgv_lang["viewyear"]				= "显示年份";
$pgv_lang["saturday"]			= "星期六";
$pgv_lang["viewday"]			= "试图日";
$pgv_lang["lost_password"]			= "丢失密码？";
$pgv_lang["day_not_set"]			= "没有日子";
$pgv_lang["viewmonth"]			= "试图月份";
$pgv_lang["all_people"]			= "所有人";
$pgv_lang["no_account_yet"] 		= "没有账号？";
$pgv_lang["living_only"]		= "生存人员";
$pgv_lang["recent_events"]		= "近期事件(< 100 年)";
//-- upload media messages
//-- user self registration module
$pgv_lang["mandatory"] 			= "有 * 的必须要添。";
$pgv_lang["requestpassword"]		= "要新的密码";
$pgv_lang["requestaccount"]		= "要新的账户";
$pgv_lang["pls_note01"]			= "Please note: The system is case-sensitive!";
$pgv_lang["min6chars"]			= "Password has to contain at least 6 characters";
$pgv_lang["pls_note02"]			= "Please note: Passwords should contain only letters and numbers. Inclusion of other characters in your password may result in inability to access from some systems.";
$pgv_lang["pls_note03"]			= "This email address will be verified before account activation. It will not be displayed on the site. You will receive a message at this Email adress with your registration data that will forward to this address.";
$pgv_lang["emailadress"]		= "电子邮件地址：";
$pgv_lang["pls_note04"]			= "Fields marked with * are mandatory.";
$pgv_lang["pls_note05"]			= "Pending completion of the form on this page and verification of your answers, you will be sent a confirmation email to the email address you specify on this page. Using the confirmation email, you will activate your account; if you fail to activate your account within seven days, it will be purged (you can register the account again at that point). To use this site, you will need to know your login name and password. You must specify an existing, valid email address on this page in order to receive the account confirmation email.<br /><br />If you encounter an issue in registering an account on this website, please submit a Support Request to the webmaster.";
$pgv_lang["mail01_line01"]		= "你好 #user_fullname# ...";
$pgv_lang["mail01_line02"]		= "A request was made at ( #SERVER_NAME# ) to login with your Email address ( #user_email# ).";
$pgv_lang["mail01_line03"]		= "The following data was used.";
$pgv_lang["mail01_line04"]		= "Please click on the link below and fill in the requested data to verify your Account and Email address.";
$pgv_lang["mail01_line05"]		= "If you didn't request this data you can just delete this message.";
$pgv_lang["mail01_line06"]		= "You won't get any mail again from this system, because the account will be deleted without verification within seven days.";
$pgv_lang["mail01_subject"]		= "Your registration at #SERVER_NAME#";
$pgv_lang["mail02_line01"]		= "你好 管理员...";
$pgv_lang["mail02_line02"]		= "A new user made a new user-registration at ( #SERVER_NAME# ).";
$pgv_lang["mail02_line03"]		= "The user received an email with the necessary data to verify their account.";
$pgv_lang["mail02_line04"]		= "As soon as the user has done this verification you will be informed by mail to give this user the permission to login to your site.";
$pgv_lang["mail02_subject"]		= "New registration at #SERVER_NAME#";
$pgv_lang["hashcode"]			= "Verfification code:";
$pgv_lang["thankyou"]			= "Hello #user_fullname# ...<br />Thank you for your registration";
$pgv_lang["pls_note06"]			= "Now you will receive a confirmation email to the email address ( #user_email# ). Using the confirmation email, you will activate your account; if you fail to activate your account within seven days, it will be purged (you can register the account again at that point). To login to this site, you will need to know your login name and password.";
$pgv_lang["registernew"]		= "新帐户确认";
$pgv_lang["user_verify"]		= "用户确认";
$pgv_lang["send"]			= "发送";
$pgv_lang["pls_note07"]			= "Please type in your username, your password and the verification code you received by email from this system to verify your account request.";
$pgv_lang["pls_note08"]			= "The data for the user #user_name# was checked.";
$pgv_lang["mail03_line01"]		= "你好 管理员 ...";
$pgv_lang["mail03_line02"]		= "#newuser[username]# ( #newuser[fullname]# ) has verified the registration data.";
$pgv_lang["mail03_line03"]		= "Please click on the link below to login to your site edit the user and give him the permission to login to your site.";
$pgv_lang["mail03_subject"]		= "New verification at #SERVER_NAME#";
$pgv_lang["pls_note09"]			= "You were identified as a registered user.";
$pgv_lang["pls_note10"]			= "The Administrator has been informed.<br />As soon as he gives you the permission to login you can login with your username and password.";
$pgv_lang["pls_note10a"]			= "你可以用你的用户名和密码进入网站。";
$pgv_lang["data_incorrect"]		= "Data was not correct!<br />Please try again!";
$pgv_lang["user_not_found"]		= "Could not verify the information you entered.  Please go back and try again.";
$pgv_lang["lost_pw_reset"]		= "Lost password request";
$pgv_lang["pls_note11"]			= "To have your password reset, supply the username and email address for your user account. <br /><br />We will send you a special URL via email, which contains a confirmation hash for your account. By visiting the provided URL, you will be permitted to change your password and login to this site. For reasons of security, you should not provide this confirmation hash to anyone, including the administrators of this site (we won't ask for it).<br /><br />If you require assistance from the administrator of this site, please contact the site administrator.";
$pgv_lang["enter_email"]		= "你必须输入一个电子邮件";
$pgv_lang["mail04_line01"]		= "你好 #user_fullname# ...";
$pgv_lang["mail04_line02"]		= "你已经要了一个新密码";
$pgv_lang["mail04_line03"]		= "建议：";
$pgv_lang["mail04_line04"]		= "Now please click on the link below, login with the new Password and change it to keep the integrity of your data secure.";
$pgv_lang["mgv"]					= "家谱";
$pgv_lang["mail04_subject"]		= "Data request at #SERVER_NAME#";
$pgv_lang["welcome_text_cust_head"] 	= "<center><b>欢迎来到这个家谱网站</b></center><br />只有注册过的可以观看网站。<br />";
$pgv_lang["welcome_text_auth_mode_3"]	= "<center><b>欢迎到这个家谱网站</b></center><br />只有<u>家庭成员</u>才可以看。<br /><br />你可以登陆或申请一个账号<br /><br />注册后要通过网站管理的批准才可以看。";
$pgv_lang["pwreqinfo"]			= "Hello...<br /><br />A mail was sent to the email adress (#user[email]#) including the new password.<br /><br />Please check your mail account because the mail should be received in the next few minutes.<br /><br />Recommendation:<br /><br />After you have requested the mail you should login to this site with your new password and change it to keep the integrity of your data sequrity.";
$pgv_lang["editowndata"]		= "我的账号";
$pgv_lang["savedata"]			= "Save changed data";
$pgv_lang["datachanged"]		= "User data was changed!";
$pgv_lang["datachanged_name"]		= "You may need to relogin with your new username.";
$pgv_lang["myuserdata"]			= "我的账户";
$pgv_lang["user_theme"]			= "我的背景设置";
$pgv_lang["mygedview"]			= "家谱主页";
$pgv_lang["passwordlength"]		= "Password must contain at least 6 characters.";
//-- mygedview page
$pgv_lang["welcome"]			= "欢迎";
$pgv_lang["upcoming_events"]		= "即將来临的活動";
$pgv_lang["living_or_all"]			= "只显示现在活着人的事情？";
$pgv_lang["basic_or_all"]			= "只显示现在出生，去世和婚姻？";
$pgv_lang["style2"]					= "表格";
$pgv_lang["style1"]					= "列表";
$pgv_lang["chat"]			= "聊天";
$pgv_lang["users_logged_in"]		= "用戶被登陆";
$pgv_lang["message"]			= "送信";
$pgv_lang["my_messages"]		= "我的消息";
$pgv_lang["message_from_name"]		= "你的名字：";
$pgv_lang["date_created"]		= "日期被發送:";
$pgv_lang["message_from"]		= "消息从:";
$pgv_lang["message_to"]			= "发消息:";
$pgv_lang["message_subject"]		= "主題:";
$pgv_lang["message_body"]		= "消息:";
$pgv_lang["no_to_user"]			= "接收用戶未被提供。  不能继续";
$pgv_lang["provide_email"]		= "請提供您的電子郵件以便我們能與您聯繫以回應這個消息。  如果您不提供您的電子郵件我們不會能回應您的查詢。  您電子郵件不會被使用在其他方式除回應這次查詢以外。";
$pgv_lang["reply"]			= "回復";
$pgv_lang["message_deleted"]		= "消息被刪除";
$pgv_lang["message_sent"]		= "信被送";
$pgv_lang["reset"]			= "重置";
$pgv_lang["site_default"]		= "站點默認值";
$pgv_lang["favorites"]				= "收藏";
$pgv_lang["mygedview_desc"]		= "您的MyGedView 頁允許您保留您喜愛的人員書簽, 跟蹤即將來臨的活動, 並且與其它PhpGedView 用戶合作。";
$pgv_lang["no_messages"]		= "您沒有待定消息。";
$pgv_lang["no_gedcom_favorites"]	= "现在没有收藏。网络管理可以在这里显示收藏文件。";
$pgv_lang["gedcom_favorites"]		= "此家谱的收藏";
$pgv_lang["clicking_ok"]		= "按下 OK 后你在新的窗口可以联系 #user[fullname]#";
$pgv_lang["my_favorites"]		= "我的收藏";
$pgv_lang["no_favorites"]		= "您未選擇任何收藏頁。  添加單個來您的收藏頁, 找到您想要添加和然後點擊\"添加來我的收藏頁\" 連結或使用身份證配件箱如下添加單個由他們的身份證編號單個的詳細資料。";
$pgv_lang["add_to_my_favorites"] 	= "添加來我的收藏";
$pgv_lang["confirm_fav_remove"]		= "是否確實要從您的收藏頁去除這個項目嗎?";
$pgv_lang["portal"]			= "門戶";
$pgv_lang["invalid_email"]		= "請輸入一封有效電子郵件。";
$pgv_lang["enter_subject"]		= "請進入消息主題。";
$pgv_lang["enter_body"]			= "請輸入一些文本在發送之前。";
$pgv_lang["confirm_message_delete"]	= "是否確實要刪除這個消息嗎?  它無法以後被檢索。";
$pgv_lang["gedcom_news_limit_count"]	= "文件数量";
$pgv_lang["add_journal"]			= "添加日记项目";
$pgv_lang["gedcom_news"]			= "新闻";
$pgv_lang["edit_news"]				= "添加日记或新闻";
$pgv_lang["phpgedview_message"] 	= "家谱短信";
$pgv_lang["common_surnames"]		= "最普及的姓";
$pgv_lang["default_news_title"] 	= "欢迎来到你的家谱";
$pgv_lang["recent_changes"] 		= "近期的改动";
$pgv_lang["recent_changes_block"]	= "近期的改动";
$pgv_lang["delete_selected_messages"]	= "删除选定的短信";
$pgv_lang["add_media_tool"] 		= "添加媒体工具";
$pgv_lang["my_journal"] 			= "我的日记";
$pgv_lang["user_news_block"]		= "用户日记";
$pgv_lang["gedcom_news_archive"] 	= "看纪录";
$pgv_lang["gedcom_news_block"]		= "家谱新闻";
$pgv_lang["theme_select_block"] 	= "选择背景主题";
$pgv_lang["login_block"]			= "登陆";
$pgv_lang["gedcom_stats_show_surnames"]	= "显示普及的姓";
$pgv_lang["gedcom_favorites_block"] = "家谱收藏";
$pgv_lang["gedcom_stats_block"] 	= "家谱统计";
$pgv_lang["gedcom_block"]			= "家谱欢迎";
$pgv_lang["random_media_events"]	= "事件";
$pgv_lang["random_media_persons"]	= "个人";
$pgv_lang["random_media_block"] 	= "随机抽样媒体";
$pgv_lang["welcome_block"]			= "用户欢迎";
$pgv_lang["user_favorites_block"]	= "用户收藏";
$pgv_lang["user_messages_block"]	= "用户短信";
$pgv_lang["upcoming_events_block"]	= "即将来临的事件";
$pgv_lang["todays_events_block"]	= "在这一天";
$pgv_lang["customize_gedcom_page"]	= "用户化这个欢迎界面";
$pgv_lang["customize_page"] 		= "用户化家谱页面";
$pgv_lang["stat_latest_death"] 	= "最近去世";
$pgv_lang["stat_earliest_death"] 	= "最早去世";
$pgv_lang["stat_latest_birth"] 	= "最近出生";
$pgv_lang["stat_earliest_birth"] 	= "最早出生";
$pgv_lang["stat_other"] 			= "其它纪录";
$pgv_lang["stat_sources"]			= "来源";
$pgv_lang["stat_families"]			= "家庭";
$pgv_lang["stat_individuals"]		= "个人";
$pgv_lang["message_email1"]		= "以下消息寄發了到您的PhpGedView 用戶帳號:";
$pgv_lang["message_email2"]		= "您寄發了以下消息到PhpGedView 用戶帳號:";
$pgv_lang["message_email3"]		= "您寄發了以下消息到PhpGedView 管理員:";
$pgv_lang["viewing_url"]		= "這信被送了當觀看以下URL: ";
$pgv_lang["messaging2_help"]		= "當您送這信您將接受複製寄發通過電子郵件到您提供的電子郵件。";
$pgv_lang["random_picture"]		= "任意照片";
$pgv_lang["choose_report"]			= "選擇報表運行";
$pgv_lang["ahnentafel_born_f"]		= "出生";
$pgv_lang["ahnentafel_born_m"]		= "出生";
$pgv_lang["ahnentafel_generation"]	= "几代人";
$pgv_lang["ahnentafel_pronoun_f"]	= "她";
$pgv_lang["ahnentafel_pronoun_m"]	= "他";
$pgv_lang["html_reports"]			= "网页HTML报表";
$pgv_lang["pdf_reports"]			= "PDF 报表";
$pgv_lang["page"]					= "页";
$pgv_lang["with"]					= "和";
$pgv_lang["chart_list"]			= "列表";
$pgv_lang["chart_style"]			= "表的格式";
$pgv_lang["ancestry_chart"] 		= "祖先表";
$pgv_lang["statistics"] 			= "统计";
$pgv_lang["show_photos"]			= "显示照片？";
$pgv_lang["show_notes"] 			= "显示记录？";
$pgv_lang["show_notes"] 			="显示来源？";
$pgv_lang["show_sources"]			= "显示来源？";
$pgv_lang["enter_famid"]			= "输入家庭代码";
$pgv_lang["of"] 					= "从";
$pgv_lang["individual_report"]		= "个人報表";
$pgv_lang["family_group_report"]	= "家庭組報表";
$pgv_lang["reports"]				= "報表";
$pgv_lang["download_report"]		= "下載報表";
$pgv_lang["select_report"]			= "选择報表";
$pgv_lang["update_fact"] = "更新信息";
$pgv_lang["update_fact_restricted"] = "不可以改编此数据";
$pgv_lang["run_report"] 			= "看報表";
$pgv_lang["selected_report"]		= "所選的報表";
$pgv_lang["enter_report_values"]	= "進入報表值";
$pgv_lang["sosa_2"] 				= "爸爸";
$pgv_lang["sosa_3"] 				= "妈妈";
$pgv_lang["upload_file"]			= "上载的文件";
$pgv_lang["update_name"] = "更新名字";
$pgv_lang["quick_update_instructions"] = "你可以修改信息";
$pgv_lang["update_address"] = "更新地址";
$pgv_lang["top10_pageviews"]		= "看得最多的文件";
$pgv_lang["fams_charts"]			= "家庭的选项";
$pgv_lang["indis_charts"]			= "个人的选项";
$pgv_lang["none"]					= "没有";
$pgv_lang["locked"]					= "不更改";
$pgv_lang["privacy"]				= "隐私";
$pgv_lang["select_fact"] = "選擇一個情況...";
$pgv_lang["update_photo"] = "更新相片";
$pgv_lang["quick_update_title"] = "快速更新";
$pgv_lang["stop"]					= "停止";
$pgv_lang["random_media_start_slide"]	= "本也读取时放幻灯图片？";
$pgv_lang["random_media_ajax_controls"]	= "显示幻灯控制？";
$pgv_lang["description"]			= "介绍";
$pgv_lang["current_dir"]			= "现在的文件夹位置";
$pgv_lang["SHOW_ID_NUMBERS"]		= "在名字旁显示代码";
$pgv_lang["SHOW_HIGHLIGHT_IMAGES"]	= "在个人框架里显示图像";
$pgv_lang["view_img_details"]		= "看图片的详细资料";
$pgv_lang["server_folder"]			= "服务器上文件名";
$pgv_lang["medialist_recursive"]	= "子目录的文件";
$pgv_lang["media_options"]			= "媒体选项";
$pgv_lang["age_differences"]		= "显示不同的地方";
$pgv_lang["date_of_entry"]			= "原输入日期";
$pgv_lang["multi_site_search"] 		= "多个网站搜索";
$pgv_lang["switch_lifespan"]		= "显示寿命表";
$pgv_lang["switch_timeline"]		= "显示时间表";
$pgv_lang["differences"]			= "不同之处";
$pgv_lang["charts_block"]			= "表格";
$pgv_lang["charts_block_descr"]		= "这个表格可以让你制作一个欢迎界面。那里可以显示你的祖先，子孙。你也可以选一个家谱的起点。";
$pgv_lang["charts_click_box"]		= "点击任何的方格会得到更多的个人信息";
$pgv_lang["chart_type"]				= "图表类型";
$pgv_lang["changedate1"]			= "改变纪录的最晚时间";
$pgv_lang["changedate2"]			= "改变纪录的最早时间";
$pgv_lang["search_place_word"]		= "只能是整个字";
$pgv_lang["invalid_search_input"] 	= "请加入到这个年份新的名字，姓名或者是地方";
$pgv_lang["duplicate_username"] 	= "用户名重复。已经有一个人用现在的用户名字。请你选另一个用户名。";
$pgv_lang["genealogy"]					= "家谱";
$pgv_lang["activate"]					= "启动";
$pgv_lang["deactivate"]					= "关闭";
$pgv_lang["play"]					= "播放";
?>
