<?php
/**
 * Vietnamese Language file for PhpGedView.
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2010  PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @author Anton Luu
 * @author Lan Nguyen
 * @version $Id: lang.vi.php 6989 2010-11-09 03:26:25Z canajun2eh $
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

$pgv_lang["duplicate_username"] 	= "Đã có tên giống hệt. Đã có một thành viên với tên đó. Xin lựa tên khác";
$pgv_lang["none"]					= "Không hạn chế";
$pgv_lang["family"] 				= "Gia Đình";
$pgv_lang["invalid_search_input"] 	= "Ngoài Năm, xin cho vào Tên Gọi, Tên Họ, hoặc là Nơi ";

//-- GENERAL HELP MESSAGES
$pgv_lang["fullname"]				= "Toàn Bộ Danh Tánh";
$pgv_lang["password"]				= "Mật khẩu";
$pgv_lang["confirm"]				= "Xác nhận mật khẩu";
$pgv_lang["login"]					= "Đăng nhập";
$pgv_lang["login_aut"]				= "Sửa Thành Viên";
$pgv_lang["logout"] 				= "Đăng ra";
$pgv_lang["admin"]					= "Quản trị";
$pgv_lang["logged_in_as"]			= "Đăng nhập là";
$pgv_lang["my_pedigree"]			= "Dòng Giống của Tôi";
$pgv_lang["my_indi"]				= "Ký lục của Tôi";
$pgv_lang["yes"]					= "Có";
$pgv_lang["no"] 					= "Không";
$pgv_lang["no_support"] 			= "Chúng tôi khám phá ra rằng bộ duyệt tìm bạn đang xài không cùng tiêu chuẩn của website PhpGedView này. Hầu hết những bản số mới của bộ duyệt tìm tương hợp với tiêu chuẩn này. Xin nâng cấp bộ duyệt tìm lên bản số mới.";
$pgv_lang["change_theme"]			= "Đổi nền của Website";
$pgv_lang["index_header"]			= "Đồ Thị Dòng Giống";
$pgv_lang["gen_ped_chart"]			= "#PEDIGREE_GENERATIONS# Đồ Thị Đời trong Dòng Giống";
$pgv_lang["generations"]			= "Thế Hệ";
$pgv_lang["view"]					= "Xem";
$pgv_lang["fam_spouse"] 			= " Gia đình của chồng/vợ";
$pgv_lang["root_person"]			= "Nhận Diện của Người Đầu";
$pgv_lang["hide_details"]			= "Giấu Chi Tiết";
$pgv_lang["show_details"]			= "Xem Chi Tiết";
$pgv_lang["person_links"]			= "Những mối liên lạc tới đồ thị, gia đình, và gia quyến của người này. Nhấn vào tượng này đặng xem trang này, bắt đầu bằng người này.";
$pgv_lang["zoom_box"]				= "Phóng ra/thu nhỏ cái hộp này.";
$pgv_lang["orientation"]			= "Phương Hướng";
$pgv_lang["portrait"]				= "Chân Dung";
$pgv_lang["landscape"]				= "Phong Cảnh";
$pgv_lang["start_at_parents"]		= "Bắt Đầu ở Cha Mẹ";
$pgv_lang["charts"] 				= "Đồ Thị";
$pgv_lang["lists"]					= "Danh Sách";
$pgv_lang["welcome_page"]			= "Trang Chào Mừng";
$pgv_lang["max_generation"] 		= "Số đời cao nhất trong dòng giống là #PEDIGREE_GENERATIONS#.";
$pgv_lang["min_generation"] 		= "Số đời nhỏ nhất trong dòng giống là 3.";
$pgv_lang["box_width"] 				= "Chiều ngang của hộp";
$pgv_lang["unable_to_find_family"]	= "Không tìm thấy gia đình với Nhận Diện";
$pgv_lang["unable_to_find_indi"]	= "Không tìm thấy người với Nhận Diện";
$pgv_lang["unable_to_find_record"]	= "Không tìm thấy ký lục với Nhận Diện";
$pgv_lang["unable_to_find_source"]	= "Không tìm thấy nguồn với Nhận Diện";
$pgv_lang["unable_to_find_repo"]	= "Không tìm thấy chổ tàng trữ với Nhận Diện";
$pgv_lang["repo_name"]				= "Tên Chổ Tàng Trữ:";
$pgv_lang["address"]				= "Địa Chỉ:";
$pgv_lang["phone"]					= "Số điện thoại:";
$pgv_lang["source_name"]			= "Tên của nguồn:";
$pgv_lang["title"]					= "Đầu Đề";
$pgv_lang["author"] 				= "Tác giả:";
$pgv_lang["publication"]			= "In bản ở:";
$pgv_lang["call_number"]			= "Số ghi:";
$pgv_lang["living"] 				= "Còn Sống";
$pgv_lang["private"]				= "Không được bộc lộ";
$pgv_lang["birth"]					= "Sinh:";
$pgv_lang["death"]					= "Tử:";
$pgv_lang["descend_chart"]			= "Đồ Thị Con Cái";
$pgv_lang["individual_list"]		= "Danh Sách Từng Người";
$pgv_lang["family_list"]			= "Danh Sách Từng Gia Đình";
$pgv_lang["source_list"]			= "Danh Sách của những Nguồn";
$pgv_lang["place_list"] 			= "Danh Sách của những Nơi";
$pgv_lang["place_list_aft"] 		= "Danh Sách tiếp của những Nơi ";
$pgv_lang["media_list"] 			= "Danh Sách của những Ða Môi Thể";
$pgv_lang["search"] 				= "Tìm Kiếm";
$pgv_lang["search_general"]			= "Tìm đại thể";
$pgv_lang["search_soundex"]			= "Tìm theo âm";
$pgv_lang["clippings_cart"] 		= "Giỏ Lấy Dữ Liệu Dòng Họ";
$pgv_lang["not_an_array"]			= "Không phải là một Giàn";
$pgv_lang["print_preview"]			= "Trang đặng in";
$pgv_lang["cancel_preview"] 		= "Trở lại trang thường";
$pgv_lang["change_lang"]			= "Ðổi Ngôn Ngữ";
$pgv_lang["print"]					= "In";
$pgv_lang["total_queries"]			= "Tổng cộng lần hỏi kho dữ kiện:";
$pgv_lang["total_privacy_checks"]	= "Tổng cộng lần thẩm tra kín đáo:";
$pgv_lang["back"]					= "Quay về";
$pgv_lang["privacy_list_indi_error"]= "Theo điều lệ kín đáo, đã giấu đi một hay nhiều người.";
$pgv_lang["privacy_list_fam_error"] = "Theo điều lệ kín đáo, đã giấu đi một hay nhiều gia đình.";
$pgv_lang["aka"]					= "Còn Gọi Là";
$pgv_lang["male"]					= "Nam";
$pgv_lang["female"] 				= "Nữ";
$pgv_lang["temple"] 				= "Đền LDS ";
$pgv_lang["temple_code"]			= "Biên mã đền LDS";
$pgv_lang["status"] 				= "Tình trạng";
$pgv_lang["source"] 				= "Nguồn";
$pgv_lang["citation"]				= "Trích dẫn:";
$pgv_lang["text"]					= "Bản văn của Nguồn:";
$pgv_lang["note"]					= "Lời ghi";
$pgv_lang["NN"] 					= "(vô danh)";
$pgv_lang["PN"] 					= "(không biết tuổi)";
$pgv_lang["unrecognized_code"]		= "Không nhận ra biên mã GEDCOM";
$pgv_lang["unrecognized_code_msg"]	= "Cái này bị sai, và chúng tôi muốn sửa. Xin báo cáo cho";
$pgv_lang["indi_info"]				= "Chi tiết cá nhân";
$pgv_lang["pedigree_chart"] 		= "Đồ Thị Dòng Giống ";
$pgv_lang["desc_chart2"]			= "Đồ Thị Con Cái";
$pgv_lang["family_with"]			= "Gia đình của";
$pgv_lang["as_spouse"]				= "Chồng/vợ và con";
$pgv_lang["as_child"]				= "Gia đình của cha mẹ";
$pgv_lang["view_gedcom"]			= "Coi ký lục GEDCOM";
$pgv_lang["add_to_cart"]			= "Thêm vào Giỏ Dữ Liệu";
$pgv_lang["still_living_error"] 	= "Hoặc là người này còn sống, hoặc là không có ngày tử. Tất cả chi tiết của những người còn sống đều không được bộc lộ.<br />Đặng có thêm chi tiết, xin liên lạc với";
$pgv_lang["privacy_error"]			= "Chi tiết của người này không được bộc lộ.<br />";
$pgv_lang["more_information"]		= "Đặng có thêm chi tiết, xin liên lạc với";
$pgv_lang["name"]					= "Tên";
$pgv_lang["given_name"] 			= "Tên Gọi:";
$pgv_lang["surname"]				= "Tên Họ:";
$pgv_lang["suffix"] 				= "Hậu Tố:";
$pgv_lang["object_note"]			= "Lời ghi về đồ vật:";
$pgv_lang["sex"]					= "Giới tính";
$pgv_lang["personal_facts"] 		= "Sự Kiện và Chi Tiết Cá Nhân";
$pgv_lang["type"]					= "Loại";
$pgv_lang["place_description"]		= "Nơi / Diễn tả";
$pgv_lang["parents"]				= "Cha; Mẹ:";
$pgv_lang["siblings"]				= "Anh(Chị) Em";
$pgv_lang["father"] 				= "Bố";
$pgv_lang["mother"] 				= "Mẹ";
$pgv_lang["parent"] 				= "Cha Mẹ";
$pgv_lang["relatives"]				= "Gia Quyến";
$pgv_lang["relatives_events"]		= "Sự Kiện về Gia Quyến";
$pgv_lang["child"]					= "Con";
$pgv_lang["spouse"] 				= "Chồng/vợ";
$pgv_lang["surnames"]				= "Tên Họ";
$pgv_lang["adopted"]				= "Nhận làm con nuôi";
$pgv_lang["foster"] 				= "Nuôi nấng";
$pgv_lang["sealing"]				= "Dấu niêm phong";
$pgv_lang["challenged"]				= "Bị thách thức";
$pgv_lang["disproved"]				= "Bị bác bỏ";
$pgv_lang["infant"]					= "Trẻ còn bú";
$pgv_lang["stillborn"]				= "Chết lúc đẻ";
$pgv_lang["deceased"]				= "Đã qua đời";
$pgv_lang["link_as_wife"]			= "Kèm người này vào một gia đình hiện tại như là vợ";
$pgv_lang["link_as"]				= "Kèm người này với một gia đình hiện tồn như là ";
$pgv_lang["no_tab1"]				= "Không có Sự Kiện nào cho người này";
$pgv_lang["no_tab2"]				= "Không có Lời Ghi nào cho người này";
$pgv_lang["no_tab3"]				= "Không có Nguồn nào cho người này";
$pgv_lang["no_tab4"]				= "Không có đồ môi thể nào cho người này";
$pgv_lang["no_tab5"]				= "Không có Thân Bằng nào cho người này";
$pgv_lang["no_tab6"]				= "Không có sổ nghiên cứu nào kèm theo với người này.";
$pgv_lang["family_info"]			= "Chi tiết về gia đình ";
$pgv_lang["family_group_info"]		= "Chi tiết về nhóm gia đình";
$pgv_lang["husband"]				= "Chồng";
$pgv_lang["wife"]					= "Vợ";
$pgv_lang["marriage"]				= "Hôn lễ:";
$pgv_lang["lds_sealing"]			= "Niêm phong LDS:";
$pgv_lang["marriage_license"]		= "Giấy Đăng Ký Kết Hôn:";
$pgv_lang["media_object"]			= "Đồ Đa môi thể";
$pgv_lang["children"]				= "Con";
$pgv_lang["no_children"]			= "Không Có Con";
$pgv_lang["childless_family"]		= "Gia đình này không có con";
$pgv_lang["number_children"]		= "Số con:";
$pgv_lang["parents_timeline"]		= "Coi đồ thị lịch sử đôi vợ chồng";
$pgv_lang["clip_cart"]				= "Giỏ Dữ Liệu";
$pgv_lang["clip_explaination"]		= "Cái Giỏ Lấy Dữ Liệu Dòng Họ dùng cho bạn lấy &quot;clippings&quot; từ dữ liệu dòng họ này và bó chung lại trong một tập tin đặng lấy xuống bằng khổ GEDCOM.<br /><br />";
$pgv_lang["item_with_id"]			= "Tiết Mục với Nhận Diện";
$pgv_lang["error_already"]			= "đã ở trong giỏ dữ liệu của bạn.";
$pgv_lang["which_links"]			= "Bạn muốn thêm mối liên kết nào khác từ gia đình này?";
$pgv_lang["just_family"]			= "Chỉ thêm ký lục của gia đình này.";
$pgv_lang["parents_and_family"] 	= "Thêm ký lục của vợ chồng này cùng với ký lục cha mẹ của hai bên.";
$pgv_lang["parents_and_child"]		= "Thêm ký lục của vợ chồng này cùng với ký lục cha mẹ và con cái của hai bên.";
$pgv_lang["parents_desc"]			= "Thêm ký lục của vợ chồng này cùng với ký lục cha mẹ và tất cả những người nối dõi của hai bên.";
$pgv_lang["continue"]				= "Tiếp tục thêm";
$pgv_lang["which_p_links"]			= "Bạn muốn thêm mối liên kết nào từ người này?";
$pgv_lang["just_person"]			= "Chỉ thêm người này.";
$pgv_lang["person_parents_sibs"]	= "Thêm người này, cha mẹ, và anh/chị/em.";
$pgv_lang["person_ancestors"]		= "Thêm người này, và tổ tiên trực hệ.";
$pgv_lang["person_ancestor_fams"]	= "Thêm người này, tổ tiên trực hệ cùng với gia đình tổ tiên.";
$pgv_lang["person_spouse"]			= "Thêm người này, chồng/vợ, và các con.";
$pgv_lang["person_desc"]			= "Thêm người này, chồng/vợ, và tất cả những người nối dõi.";
$pgv_lang["unable_to_open"] 		= "Không mở được tập tin Dữ Liệu đặng viết vào";
$pgv_lang["person_living"]			= "Người này còn sống. Sẽ không có gồm chi tiết cá nhân.";
$pgv_lang["person_private"] 		= "Chi Tiết của người này không được bộc lộ. Sẽ không có chi tiết cá nhân.";
$pgv_lang["family_private"] 		= "Chi Tiết của gia đình này không được bộc lộ. Sẽ không có chi tiết gia đình.";
$pgv_lang["download"]				= "Nhấn bên phải (CTRL-Nhấn với máy Macintosh) trên mối liên kết dưới này và chọn &quot;Giữ dưới tên&quot; đặng lấy tập tin xuống.";
$pgv_lang["media_files"]			= "Tập Tin Môi Thể ám chỉ bởi GEDCOM này";
$pgv_lang["cart_is_empty"]			= "Giỏ dữ liệu của bạn trống trơn.";
$pgv_lang["id"] 					= "Nhận Diện";
$pgv_lang["ID"] 					= "Nhận Diện";
$pgv_lang["name_description"]		= "Tên / Diễn tả";
$pgv_lang["remove"] 				= "Rút ra";
$pgv_lang["empty_cart"] 			= "Giỏ Trống Trơn";
$pgv_lang["download_now"]			= "Lấy xuống bây giờ";
$pgv_lang["indi_downloaded_from"]	= "Người này đã lấy xuống từ:";
$pgv_lang["family_downloaded_from"] = "Gia Đình này đã lấy xuống từ:";
$pgv_lang["source_downloaded_from"] = "Nguồn này đã lấy xuống từ:";
$pgv_lang["connections"]			= "Tìm thấy mối liên hệ với Nơi này";
$pgv_lang["top_level"]				= "Hàng cao nhất";
$pgv_lang["form"]					= "Những nơi viết xuống theo lối sau đây:";
$pgv_lang["default_form"]			= "Thành phố, Thị Xã, Địa Phận/Tiểu Bang, Nước";
$pgv_lang["default_form_info"]		= "(Mặc định)";
$pgv_lang["unknown"]				= "không biết ngày";
$pgv_lang["individuals"]			= "Nhân Vật";
$pgv_lang["view_records_in_place"]	= "Xem tất cả những ký lục tìm thấy ở chỗ này";
$pgv_lang["place_list2"] 			= "Danh Sách của Nơi";
$pgv_lang["show_place_hierarchy"]	= "Cho Xem Nơi theo Thứ Tự ";
$pgv_lang["show_place_list"]		= "Cho Xem Tất Cả những Nơi trong một Danh Sách";
$pgv_lang["total_unic_places"]		= "Tổng số những Nơi Duy Nhất";
$pgv_lang["multi_title"]			= "Danh Sách Đồ Đa Môi Thể";
$pgv_lang["media_found"]			= "Tìm thấy đồ Môi Thể";
$pgv_lang["view_person"]			= "Cho Xem Cá Nhân";
$pgv_lang["view_family"]			= "Cho Xem Gia Đình";
$pgv_lang["view_source"]			= "Cho Xem Nguồn";
$pgv_lang["prev"]					= "< Trước";
$pgv_lang["next"]					= "Tiếp >";
$pgv_lang["file_not_found"] 		= "Không tìm thấy được tập tin.";
$pgv_lang["medialist_show"] 		= "Cho Xem";
$pgv_lang["per_page"]				= "đồ môi thể trong mỗi trang";
$pgv_lang["search_gedcom"]			= "Tìm những tập tin GEDCOM";
$pgv_lang["enter_terms"]			= "Cho vào những từ muốn Tìm";
$pgv_lang["soundex_search"] 		= "- Hoặc tìm theo âm học (Soundex):";
$pgv_lang["sources"]				= "Nguồn";
$pgv_lang["firstname_search"]		= "Tên Gọi";
$pgv_lang["lastname_search"]		= "Tên Họ";
$pgv_lang["search_place"]			= "Nơi";
$pgv_lang["search_year"]			= "Năm";
$pgv_lang["no_results"] 			= "Không tìm thấy gì hẽt.";
$pgv_lang["search_type"]			= "Loại tìm";
$pgv_lang["sources_found"]			= "Tìm Thấy Căn Nguyên";
$pgv_lang["titles_found"]			= "Đầu Đề";
$pgv_lang["find_source"]			= "Tìm Kiếm Nguồn";
$pgv_lang["repo_list"]				= "Danh Sách của những Chổ Tàng Trữ";
$pgv_lang["repos_found"]			= "Tìm thấy Chổ Tàng Trữ";
$pgv_lang["find_repository"]		= "Tìm Kiếm Chổ Tàng Trữ";
$pgv_lang["total_repositories"]		= "Tổng số Chổ Tàng Trữ";
$pgv_lang["repo_info"]				= "Kiến Thức về Nơi Tàng Trữ";
$pgv_lang["other_repo_records"]		= "Những Ký Lục chỉ vào Nơi Tàng Trữ này:";
$pgv_lang["confirm_delete_repo"]	= "Có chắc là muốn xóa Ký Lục này khỏi kho dữ kiện?";
$pgv_lang["source_info"]			= "Kiến Thức về Nguồn";
$pgv_lang["other_records"]			= "Những Ký lục liên hệ với Nguồn này:";
$pgv_lang["people"] 				= "Người";
$pgv_lang["families"]				= "Gia Đình";
$pgv_lang["total_sources"]			= "Tổng số Nguồn";
$pgv_lang["building_indi"]			= "Đang xây chỉ số Cá Nhân và Gia Đình";
$pgv_lang["building_index"] 		= "Đang làm nên danh sách chỉ số";
$pgv_lang["invalid_gedformat"]		= "Không theo khuôn dạng GEDCOM 5.5";
$pgv_lang["importing_records"]		= "Thu nhập ký lục vào kho dữ kiện";
$pgv_lang["detected_change"]		= "PhpGedView khám phá sự thay đổi trong <b>#GEDCOM#</b>. Phải xây lại tập tin chỉ số trước khi tiếp tục.";
$pgv_lang["flushing"]				= "Đang dẹp nội dung";
$pgv_lang["exec_time"]				= "Thời gian thi hành:";
$pgv_lang["unable_to_create_index"] = "Không làm ra được tập tin chỉ số. Xin kiểm lại rằng có quyền viết trong mục lục PhpGedView. Có thể phục hồi quyền sau khi tập tin chỉ số đã viết xuống.";
$pgv_lang["indi_complete"]			= "Hiện đại hoá tập tin chỉ số của nhân vật hoàn tất.";
$pgv_lang["family_complete"]		= "Hiện đại hoá tập tin chỉ số của gia đình hoàn tất.";
$pgv_lang["source_complete"]		= "Hiện đại hoá tập tin chỉ số của nguồn hoàn tất.";
$pgv_lang["tables_exist"]			= "Bản PhpGedView đã có trong kho dữ kiện";
$pgv_lang["you_may"]				= "Bạn có thể:";
$pgv_lang["drop_tables"]			= "Bỏ những bản hiện tại";
$pgv_lang["import_multiple"]		= "Thu nhập và làm việc với nhiều GEDCOMs";
$pgv_lang["explain_options"]		= "Nếu bạn muốn bỏ bản, <u>tất cả</u> dữ liệu sẽ bị thay thế bởi những gì trong tập tin GEDCOM này.<br /><br /> Nếu bạn chọn thu nhập và làm việc với nhiều GEDCOM, PhpGedView sẽ xoá những dữ liệu đã thu nhập cùng với một tập tin GEDCOM trùng tên. Món này cho phép bạn giữ nhiều gia phả trong cùng bản và đổi giữa cái này sang cái khác dễ dàng.<br /><br /><b>Xin phân biệt chữ thường với chữ hoa trong tên tập tin.</b> Như thế có nghiã là  <b>Test.GED</b> <u>không</u> như <b>test.ged</b>.";
$pgv_lang["path_to_gedcom"] 		= "Xin cho vào đường tới tập tin GEDCOM:";
$pgv_lang["changes_present"]		= "Cái GEDCOM hiện tại có chuyện đổi, đang chờ xét lại. Nếu bạn tiếp tục thu nhập, những chuyện đổi này sẽ giao vào kho dữ kiện tức thì. Bạn  nên xét lại những chuyện đang chờ đổi trước khi thu nhập.";
$pgv_lang["index_complete"] 		= "Chỉ Số hoàn tất.";
$pgv_lang["updating_is_dead"]		= "Cập nhật thế &quot;Tử&quot; cho nhân vật ";
$pgv_lang["updating_family_names"]	= "Cập nhật tên gia đình";
$pgv_lang["processed_for"]			= "Đã xét tập tin cho";
$pgv_lang["run_tools"]				= "Có muốn cho GEDCOM chạy qua những chương trình này trước khi thu nhập:";
$pgv_lang["addmedia"]				= "Thêm dụng cụ Môi Thể";
$pgv_lang["dateconvert"]			= "Dụng cụ hoán cải ngày";
$pgv_lang["xreftorin"]				= "Biến đổi nhận diện XREF sang số RIN";
$pgv_lang["tools_readme"]			= "Coi cái phần Dụng Cụ của cái #README.TXT# có thêm chi tiết.";
$pgv_lang["sec"]					= "giây";
$pgv_lang["total_fams"] 			= "Tổng số những gia đình";
$pgv_lang["total_indis"]			= "Tổng số nhân vật";
$pgv_lang["starts_with"]			= "Bắt đầu với:";
$pgv_lang["person_list"]			= "Danh sách nhân vật:";
$pgv_lang["paste_person"]			= "Niêm yết nhân vật";
$pgv_lang["notes_sources_media"]	= "Lời Ghi, Nguồn, và Môi Thể";
$pgv_lang["notes"]					= "Lời Ghi";
$pgv_lang["ssourcess"]				= "Nguồn";
$pgv_lang["media"]					= "Môi Thể";
$pgv_lang["name_contains"]			= "Trong tên có";
$pgv_lang["filter"] 				= "Lọc";
$pgv_lang["find_individual"]		= "Kiếm Nhận Diện của Nhân Vật";
$pgv_lang["find_familyid"]			= "Kiếm Nhận Diện của Gia Đình";
$pgv_lang["find_sourceid"]			= "Kiếm Nhận Diện của Nguồn";
$pgv_lang["find_specialchar"]		= "Kiếm Chữ Đặc Biệt";
$pgv_lang["magnify"]				= "Phóng Đại";
$pgv_lang["skip_surnames"]			= "Tránh Danh sách Tên Họ";
$pgv_lang["show_surnames"]			= "Xem Danh sách Tên Họ";
$pgv_lang["all"]					= "Tất cả";
$pgv_lang["hidden"]					= "Giấu mất";
$pgv_lang["confidential"]			= "Giữ kín";
$pgv_lang["age"]					= "Tuổi";
$pgv_lang["days"]					= "ngày";
$pgv_lang["years"]					= "năm";
$pgv_lang["year1"]					= "năm";
$pgv_lang["month1"]					= "tháng";
$pgv_lang["day1"]					= "ngày";
$pgv_lang["months"]					= "tháng";
$pgv_lang["timeline_title"] 		= "Lịch sử PhpGedView ";
$pgv_lang["timeline_chart"] 		= "Đồ Thị Lịch Sử";
$pgv_lang["remove_person"]			= "Lấy nhân vật ra";
$pgv_lang["show_age"]				= "Cho xem mức tuổi";
$pgv_lang["add_another"]			= "Thêm người nữa trong đồ thị:<br />Nhận Diện của người đó:";
$pgv_lang["find_id"]				= "Tìm Nhận Diện";
$pgv_lang["show"]					= "Cho xem";
$pgv_lang["year"]					= "Năm:";
$pgv_lang["timeline_instructions"]	= "Với những bộ duyệt tìm tân thời, bạn có thể nhấn và kéo hộp khắp nơi trong đồ thị.";
$pgv_lang["zoom_in"]				= "Phóng to";
$pgv_lang["zoom_out"]				= "Thu nhỏ";
$pgv_lang["jan"]					= "Tháng Giêng";
$pgv_lang["feb"]					= "Tháng Hai";
$pgv_lang["mar"]					= "Tháng Ba";
$pgv_lang["apr"]					= "Tháng Tư";
$pgv_lang["may"]					= "Tháng Nam";
$pgv_lang["jun"]					= "Tháng Sáu";
$pgv_lang["jul"]					= "Tháng Bảy";
$pgv_lang["aug"]					= "Tháng Tám";
$pgv_lang["sep"]					= "Tháng Chín";
$pgv_lang["oct"]					= "Tháng Mười";
$pgv_lang["nov"]					= "Tháng Mười Một";
$pgv_lang["dec"]					= "Tháng Mười Hai";
$pgv_lang["abt"]					= "vào khoảng";
$pgv_lang["aft"]					= "sau";
$pgv_lang["and"]					= "và";
$pgv_lang["bef"]					= "trước";
$pgv_lang["bet"]					= "giữa";
$pgv_lang["cal"]					= "đếm được";
$pgv_lang["est"]					= "ước đoán";
$pgv_lang["from"]					= "từ";
$pgv_lang["int"]					= "Hiểu là";
$pgv_lang["to"] 					= "tới";
$pgv_lang["cir"]					= "vào khoảng";
$pgv_lang["apx"]					= "xấp xỉ";
$pgv_lang["rebuild_indexes"]		= "Xây lại Chỉ Số";
$pgv_lang["user_admin"] 			= "Kiềm Chế Thành Viên";
$pgv_lang["password_mismatch"]		= "Mật khẩu nhập vào không thống nhất.";
$pgv_lang["enter_username"] 		= "Bạn phải nhập tên vào";
$pgv_lang["enter_fullname"] 		= "Bạn phải cho tên toàn diện.";
$pgv_lang["enter_password"] 		= "Bạn phải nhập vào mật khẩu";
$pgv_lang["confirm_password"]		= "Bạn phải xác nhận mật khẩu";
$pgv_lang["save"]					= "Giữ Lại";
$pgv_lang["delete"] 				= "Xoá Đi";
$pgv_lang["edit"]					= "Sửa";
$pgv_lang["no_login"]				= "Không thể xác nhận thành viên.";
$pgv_lang["import_gedcom"]			= "Thu nhận tập tin GEDCOM này";
$pgv_lang["enter_gedcomid"] 		= "Bạn phải cho vào Nhận Diện trong GEDCOM.";
$pgv_lang["user_info"]				= "Chi tiết thành viên của tôi";
$pgv_lang["enter_filename"] 		= "Bạn phải cho tên của tập tin GEDCOM.";
$pgv_lang["file_not_exists"]		= "Tên đánh vào của tập tin không có.";
$pgv_lang["file_not_present"]		= "Không có tập tin .";
$pgv_lang["file_exists"]			= "Đã có một tập tin với tên này. Xin lựa một tên khác hoặc hủy bỏ tập tin củ.";
$pgv_lang["new_gedcom_title"]		= "Bảng Phả Hệ từ [#GEDCOMFILE#]";
$pgv_lang["upload_help"]			= "Chọn tập tin trong máy của bạn đặng gửi lên máy chủ. Tất cả những tập tin sẽ cho vào mục lục:";
$pgv_lang["add_gedcom_instructions"]= "Cho tên của cái tập tin GEDCOM này. Sẽ tạo cái tập tin GEDCOM ở mục lục Chỉ Số:";
$pgv_lang["research_log"]			= "Sổ Nghiên Cứu";
$pgv_lang["utf8_to_ansi"]			= "Có muốn mã hóa từ UTF-8 sang ANSI (ISO-8859-1)??";
$pgv_lang["user_manual"]			= "Sách dùng PhpGedView ";
$pgv_lang["upgrade"]				= "Nâng cấp PhpGedView";
$pgv_lang["step1"]					= "Bước 1 của  4:";
$pgv_lang["step3"]					= "Bước 3 của  4:";
$pgv_lang["step4"]					= "Bước 4 của  4:";
$pgv_lang["cancel_upload"]			= "Bỏ dở chuyện gửi lên";
$pgv_lang["add_media_records"]		= "Thêm Ký Lục Môi Thể";
$pgv_lang["manage_media_files"]		= "Quản Xuyến Tập Tin Môi Thể";
$pgv_lang["link_media_records"]		= "Liên kết Môi Thể với Nhân Vật";
$pgv_lang["add_media_button"]		= "Thêm Môi Thể";
$pgv_lang["relationship_chart"] 	= "Đồ Thị Họ Hàng";
$pgv_lang["person1"]				= "Người 1";
$pgv_lang["person2"]				= "Người 2";
$pgv_lang["no_link_found"]			= "Không tìm thấy liên hệ nào (khác) hai người này.";
$pgv_lang["sibling"]				= "Anh(Chị) Em";
$pgv_lang["follow_spouse"]			= "Theo mối liên hệ bằng sự kết hôn";
$pgv_lang["timeout_error"]			= "Sự tìm kiếm gián đoạn trước khi tìm thấy mối liên hệ.";
$pgv_lang["son"]					= "Con Trai";
$pgv_lang["daughter"]				= "Con Gái";
$pgv_lang["son-in-law"]				= "Con rể";
$pgv_lang["daughter-in-law"]		= "Con dâu";
$pgv_lang["grandchild"]				= "Cháu";
$pgv_lang["granddaughter"]			= "Cháu gái";
$pgv_lang["grandson"]				= "Cháu trai";
$pgv_lang["brother"]				= "Anh (Em) Trai";
$pgv_lang["sister"] 				= "Anh (Em) Gái";
$pgv_lang["aunt"]					= "Cô/dì/thím/mợ";
$pgv_lang["uncle"]				= "Chú/bác/cậu/dượng";
$pgv_lang["firstcousin"]			= "Anh (chị) con bác, em con chú; anh (em) con cô con cậu ruột";
$pgv_lang["relationship_to_me"] 	= "Liên hệ với tôi";
$pgv_lang["rela_husb"]				= "Liên hệ với chồng";
$pgv_lang["rela_wife"]				= "Liên hệ với vợ";
$pgv_lang["next_path"]				= "Tìm đường kế tiếp";
$pgv_lang["show_path"]				= "Cho coi đường";
$pgv_lang["line_up_generations"]	= "Đồng chỉnh những thế hệ cùng như nhau";
$pgv_lang["oldest_top"]             = "Sắp đặt già nhất phía trên";
$pgv_lang["check_delete"]			= "Bạn có chắc là muốn xoá bỏ sự kiện GEDCOM này?";
$pgv_lang["access_denied"]			= "<b>Cấm Vào</b><br />Bạn không có quyền xem tài nguyên này.";
$pgv_lang["changes_exist"]			= "GEDCOM này đã thay đổi.";
$pgv_lang["find_place"] 			= "Tìm Nơi";
$pgv_lang["close_window"]			= "Đóng trang này";
$pgv_lang["close_window_without_refresh"] = "Đóng trang này khỏi chất lại";
$pgv_lang["place_contains"] 		= "Có trong nơi:";
$pgv_lang["now_import"] 			= "Bạn nên thu nhập ký lục GEDCOM vào PhpGedView bằng cái mối thu nhập bên dưới.";
$pgv_lang["add"]					= "Thêm";
$pgv_lang["custom_event"]			= "Sự việc riêng rẽ";
$pgv_lang["delete_person"]			= "Xóa nhân vật này";
$pgv_lang["confirm_delete_person"]	= "Bạn có chắc chắn bạn muốn huỷ người này trong tập tin GEDCOM?";
$pgv_lang["find_media"] 			= "Tìm Môi Thể";
$pgv_lang["set_link"]				= "Đặt mối liên kết";
$pgv_lang["delete_source"]			= "Huỷ Nguồn này";
$pgv_lang["confirm_delete_source"]	= "Bạn có chắc chắn bạn muốn huỷ Nguồn này trong tập tin GEDCOM?";
$pgv_lang["find_family"]			= "Tìm gia đình";
$pgv_lang["find_fam_list"]			= "Tìm danh sách gia đình";
$pgv_lang["edit_name"]				= "Sửa Tên";
$pgv_lang["delete_name"]			= "Xoá Tên";
$pgv_lang["select_date"]			= "Chọn một ngày";
$pgv_lang["user_cannot_edit"]		= "Thành viên với tên này không có quyền sửa GEDCOM này.<br />";
$pgv_lang["ged_noshow"]				= "Trang này lấy đã bỏ ngang bên bởi quản lý của site";
$pgv_lang["bdm"]					= "Sinh, Tử, Kết Hôn";
$pgv_lang["on_this_day"]			= "Trong Ngày Này, trong Quá Khứ Của Bạn...";
$pgv_lang["in_this_month"]			= "Trong Tháng Này, trong Quá Khứ Của Bạn...";
$pgv_lang["in_this_year"]			= "Trong Năm Này, trong Quá Khứ Của Bạn...";
$pgv_lang["year_anniversary"]		= "Kỷ niệm năm #year_var#";
$pgv_lang["today"]					= "Hôm nay";
$pgv_lang["day"]					= "Ngày:";
$pgv_lang["month"]					= "Tháng:";
$pgv_lang["showcal"]				= "Trưng bày sự kiện của:";
$pgv_lang["anniversary_calendar"]	= "Lịch của những Ngày Kỷ Niệm";
$pgv_lang["sunday"] 				= "Chủ Nhật";
$pgv_lang["monday"] 				= "Thứ Hai";
$pgv_lang["tuesday"]				= "Thứ Ba";
$pgv_lang["wednesday"]				= "Thứ Tư";
$pgv_lang["thursday"]				= "Thứ Năm";
$pgv_lang["friday"] 				= "Thứ Sáu";
$pgv_lang["saturday"]				= "Thứ Bảy";
$pgv_lang["viewday"]				= "Coi Ngày";
$pgv_lang["viewmonth"]				= "Coi Tháng";
$pgv_lang["viewyear"]				= "Coi Năm";
$pgv_lang["all_people"] 			= "Mọi Người";
$pgv_lang["living_only"]			= "Người Sống";
$pgv_lang["recent_events"]			= "Những năm gần đây (< 100 năm)";
$pgv_lang["day_not_set"]			= "Ngày chưa đặt vào";
$pgv_lang["year_error"] 			= "Rất là tiếc, những ngày trước năm 1970 không chấp nhận được.";
$pgv_lang["lost_password"]			= "Quên mật khẩu?";
$pgv_lang["requestpassword"]		= "Xin mật khẩu mới";
$pgv_lang["no_account_yet"] 		= "Không có tài khoản?";
$pgv_lang["requestaccount"] 		= "Yêu cầu tài khoản mới";
$pgv_lang["register_info_01"]		= "Dữ kiện xem được bởi quần chúng ở tại cái website này có thể bị hạn chế bởi vì luật pháp bảo vệ quyền kín đáo lưu hành. Nhiều người không muốn dữ kiện riêng tư của họ trưng bày không hạn chế ở trên Internet. Dữ kiện riêng tư có thể bị lạm dụng đặng quảng cáo hay là trộm cắp căn thiết.<br /><br />Đặng xem dữ kiện riêng tư, bạn phải có tài khoản ở cái website này. Đặng có tài khoản, bạn phải đăng ký với những chi tiết cần thiết. Sau khi quản lý đã sét và chấp thuận sự xin đăng ký của bạn, bạn có thể truy nhập và xem dữ kiện riêng tư.<br /><br /> Nếu có Kèm Chế dữ kiện riêng tư theo Liên Hệ, bạn chỉ nhìn được chi tiết riêng tư của dòng họ của bạn sau khi đăng nhập. Quản lý có thể cho phép một vài thành viên sửa kho dữ kiện, đặng họ đổi hoặc thêm chi tiết.<br /><br />Xin chú ý: Bạn sẽ không được xem dữ kiện riêng tư nếu bạn không chứng minh rằng bạn có người gia quyến trong kho dữ kiện. Nếu bạn không là người gia quyến, bạn sẽ không được tài khoản, thành thử bạn nên khỏi mất công.<br /><br />Nếu bạn cần thêm hướng dẫn, xin dùng cái mối thu nhập bên dưới đặng liên lạc với quản lý.";
$pgv_lang["pls_note01"] 			= "Xin chú ý rằng máy sẽ phân biệt chữ thường với chữ hoa";
$pgv_lang["min6chars"]				= "Mật khẩu phải có tối thiểu 6 kí tự";
$pgv_lang["pls_note02"] 			= "Xin chú ý rằng mật khẩu có thể có chữ, số, và chữ đặc biệt.";
$pgv_lang["pls_note03"] 			= "Cái địa chỉ này sẽ phải kiểm trước khi kích hoạt tài khoản. Địa chỉ đó sẽ không phô bày trên Website này . Một cái thư điện tử đựng dữ kiện đăng ký sẽ gửi tới địa chỉ này.";
$pgv_lang["emailadress"]			= "Địa chỉ thư điện tử";
$pgv_lang["pls_note04"] 			= "Những chổ ghi với * là bắt buộc phải điền vào.";
$pgv_lang["pls_note05"] 			= "Bạn phải cho một địa chỉ thư điện tử hợp lệ đặng nhận thư điện tử xác nhận.<br /><br /> Sau khi bạn đã điền cái đơn này và những câu hỏi đã trả lời xong, sẽ gửi một bức thư điện tử xác nhận tới địa chỉ bạn đã cho. Bức thư đó sẽ chỉ dẫn bạn làm sao đặng kích hoạt tài khoản của bạn. Nếu bạn không hoàn tất kích hoạt tài khoản như chỉ dẫn trong vòng bảy ngày, sự xin đăng ký của bạn sẽ tự động bị bạt đi. Bạn sẽ phải bắt đầu xin đăng ký lại.<br /><br />Đặng vào cái site này bạn phải biết tên truy nhập và mật khẩu của bạn.<br /><br />Nếu bạn có trở ngại mở tài khoản trên cái website này, xin nộp một đơn yêu cầu hướng dẫn cho chuyên viên kỹ thuật bên dưới.";
$pgv_lang["mail01_line01"]			= "Chào #user_fullname# ...";
$pgv_lang["mail01_line02"]			= "Đã yêu cầu mở một tài khoản với địa chỉ thư điện tử ( #user_email# ) của bạn tại ( #SERVER_NAME# ).";
$pgv_lang["mail01_line03"]			= "Tin tức về sự yêu cầu tài khoản xem được với mối thu nhập bên dưới.";
$pgv_lang["mail01_line04"]			= "Xin nhấn vào mối liên kết sau đây và điền vào chi tiết cần thiết đặng xác nhận tài khoản cùng với địa chỉ thư điện tử.";
$pgv_lang["mail01_line05"]			= "Nếu bạn không có xin tài khoản, xin xóa thư điện này.";
$pgv_lang["mail01_line06"]			= "Bạn không nhận thêm thư điện nào từ cái site này, vì sự xin tài khoản sẽ huỷ bỏ sau bảy ngày.";
$pgv_lang["mail01_subject"] 		= "Sự đăng ký của bạn tại #SERVER_NAME#";
$pgv_lang["mail02_line01"]			= "Chào Quản Lý ...";
$pgv_lang["mail02_line02"]			= "Một thành viên tương lai đã đăng ký tại ( #SERVER_NAME# ).";
$pgv_lang["mail02_line03"]			= "Thành viên đã nhận thư điện tử đựng tất cả những gì cần thiết đặng xác minh tài khoản của thành viên.";
$pgv_lang["mail02_line04"]			= "Bạn sẽ được báo tin khi thành viên tương lai đã tự xác minh. Sau đó bạn có thể hoàn tất công việc bằng cách kích hoạt tên truy nhập. Thành viên sẽ không truy nhập được cho tới khi bạn kích hoạt tài khoản.";
$pgv_lang["mail02_line04a"]			= "Bạn sẽ được báo tin khi thành viên tương lai đã tự xác minh. Sau khi xác minh, thành viên sẽ có thể truy nhập khỏi cần hành động gì thêm của bạn.";
$pgv_lang["mail02_subject"] 		= "Có đăng ký mới tại #SERVER_NAME#";
$pgv_lang["hashcode"]				= "Mật mã để xác minh:";
$pgv_lang["thankyou"]				= "Chào #user_fullname# ...<br />Cám ơn bạn đã đăng ký";
$pgv_lang["pls_note06"] 			= "Sẽ có một thư điện tử đặng xác nhận gửi tới địa chỉ ( #user_email# ). Bạn phải theo chỉ dẫn trong thư đặng xác nhận việc xin tài khoản. Nếu bạn không kích hoạt tài khoản như chỉ dẫn trong vòng bảy ngày, sự xin đăng ký của bạn sẽ tự động bị bạt đi. Bạn sẽ phải bắt đầu xin đăng ký lại.<br /><br />Sau khi bạn đã làm theo chỉ dẫn trong thư, quản lý còn phải chấp thuận sự yêu cầu của bạn trước khi dùng được tài khoản.<br /><br />Đặng truy nhập vào cái site này bạn phải biết tên truy nhập và mật khẩu của bạn.<br /><br />";
$pgv_lang["pls_note06a"] 			= "Sẽ có một thư điện tử đặng xác nhận gửi tới địa chỉ ( #user_email# ). Bạn phải theo chỉ dẫn trong thư đặng xác nhận việc xin tài khoản. Nếu bạn không kích hoạt tài khoản như chỉ dẫn trong vòng bảy ngày, sự xin đăng ký của bạn sẽ tự động bị bạt đi. Bạn sẽ phải bắt đầu xin đăng ký lại.<br /><br />Sau khi bạn đã làm theo chỉ dẫn trong thư, bạn có thể truy nhập. Đặng truy nhập cái site này, bạn phải biết tên truy nhập và mật khẩu của bạn.<br /><br />";
$pgv_lang["registernew"]			= "Chứng thực Tài Khoản mới";
$pgv_lang["user_verify"]			= "Xác minh thành viên";
$pgv_lang["send"]					= "Gửi";
$pgv_lang["pls_note07"] 			= "Đặng xác nhận sự yêu cầu tài khoản, xin cho vào tên truy nhập, mật khẩu, và mật mã để xác minh đã nhận qua thư điện tử.";
$pgv_lang["pls_note08"] 			= "Dữ Liệu cho thành viên #user_name# đã kiểm lại.";
$pgv_lang["mail03_line01"]			= "Chào Quản Lý ...";
$pgv_lang["mail03_line02"]			= "Thành viên #newuser[username]# ( #newuser[fullname]# ) đã kiểm dữ kiện đăng ký.";
$pgv_lang["mail03_line03"]			= "Xin nhấn vào mối liên kết dưới đây đặng truy nhập cái site của bạn. Bạn phải sửa tài khoản thành viên đặng kích hoạt nó.  Như vậy thành viên mới được truy nhập site của bạn.";
$pgv_lang["mail03_line03a"]			= "Bạn không cần hành không động gì hết; thành viên có thể truy nhập bây giờ.";
$pgv_lang["mail03_subject"] 		= "Có xác minh mới ở tại #SERVER_NAME#";
$pgv_lang["pls_note09"] 			= "Bạn đã chứng thực sự yêu cầu của bạn đặng trở nên thành viên chính thức.";
$pgv_lang["pls_note10"] 			= "Đã báo hiệu quản lý. Ngay sau khi quản lý cho phép bạn truy nhập, bạn có thể truy nhập với tên truy nhập và mật khẩu của bạn.";
$pgv_lang["pls_note10a"]			= "Bây giờ bạn có thể đăng nhập với tên truy nhập và mật khẩu của bạn";
$pgv_lang["data_incorrect"] 		= "Dữ liệu không đúng, xin làm lại";
$pgv_lang["user_not_found"] 		= "Không kiểm lại được những gì bạn đã cho vào. Xin làm lại";
$pgv_lang["lost_pw_reset"]			= "Xin mật khẩu khác đặng thay cái đã mất";
$pgv_lang["pls_note11"] 			= "Đặng đổi mật khẩu mới, xin cho tên truy nhập cùng với địa chỉ thư điện tử.<br /><br />Sẽ có một URL đặc biệt cầm mật mã chứng thực gửi tới bạn bằng thư điện tử. Khi bạn tới cái URL đó, bạn có thể đổi mật khẩu và truy nhập. Vì lý do an ninh, bạn không nên cho bất cứ ai biết cái mật mã chứng thực, ngay cả quản lý của site (quản lý không khi nào hỏi chuyện đó).<br /><br />Nếu bạn cần quản lý hướng dẫn, xin dùng cái mối thu nhập bên dưới.";
$pgv_lang["enter_email"]			= "Bạn phải cho địa chỉ thư điện tử";
$pgv_lang["mail04_line01"]			= "Chào #user_fullname# ...";
$pgv_lang["mail04_line02"]			= "Một mật khẩu mới đã được thỉnh cầu cho tên truy nhập của bạn";
$pgv_lang["mail04_line03"]			= "Đề nghị là:";
$pgv_lang["mail04_line04"]			= "Xin nhấn vào mối liên kết dưới này hoặc dán nó vào bộ duyệt tìm, rồi truy nhập với mật khẩu mới, và đổi nó ngay lập tức đặng bảo vệ dữ liệu.";
$pgv_lang["mail04_subject"] 		= "Xin dữ liệu ở #SERVER_NAME#";
$pgv_lang["pwreqinfo"]				= "Chào bạn...<br /><br />Đã có bức thư điện tử gửi tới địa chỉ (#user[email]#).<br /><br />Xin nhìn trong hộp thư điện tử của bạn; chẳng mấy chốc thư đó phải tới nơi.<br /><br />Lời khuyên:<br />Bạn nên truy nhập nơi đây với mật khẩu mới càng sớm càng tốt, và bạn nên đổi mật khẩu đặng bảo vệ dữ liệu của bạn.<br />";
$pgv_lang["editowndata"]			= "Tài Khoản của Tôi";
$pgv_lang["savedata"]				= "Viết xuống dữ liệu đổi rồi";
$pgv_lang["datachanged"]			= "Dữ liệu của thành viên đổi xong";
$pgv_lang["datachanged_name"]		= "Bạn có thể cần truy nhập lại với tên truy nhập mới.";
$pgv_lang["myuserdata"] 			= "Tài Khoản của Tôi";
$pgv_lang["user_theme"] 			= "Nền Website của Tôi";
$pgv_lang["mgv"]					= "GedView của Tôi";
$pgv_lang["mygedview"]				= "Trang GedView của Tôi";
$pgv_lang["passwordlength"] 		= "Mật khẩu phải có tối thiểu 6 kí tự";
$pgv_lang["welcome_text_auth_mode_1"]	= "<center><b>Kính chào vào cái website Gia Phả này</b></center><br />Chỉ những thành viên nào có tài khoản mới được vào.<br /><br />Nếu bạn không có tài khoản, bạn có thể xin mở một cái bằng cái mối thu nhập thích hợp bên dưới.<br /><br />Sau khi kiểm tra sự xin đăng ký của bạn, quản lý sẽ kích hoạt tài khoản của bạn. Bạn sẽ nhận một bức thư điện tử cho biết sự xin đăng ký của bạn đã được chấp thuận.";
$pgv_lang["welcome_text_auth_mode_2"]	= "<center><b>Kính chào vào cái website Gia Phả này</b></center><br />Chỉ có hội viên <u>đã thừa nhận</u> mới được vào đây.<br /><br />Nếu bạn có tài khoản, xin truy nhập. Nếu bạn không có tài khoản, bạn có thể xin mở một cái bằng cái mối thu nhập thích hợp bên dưới.<br /><br />Sau khi kiểm tra sự xin đăng ký của bạn, quản lý sẽ kích hoạt tài khoản của bạn. Bạn sẽ nhận một bức thư điện tử cho biết sự xin đăng ký của bạn đã được chấp thuận.";
$pgv_lang["welcome_text_auth_mode_3"]	= "<center><b>Kính chào vào cái website Gia Phả này</b></center><br />Chỉ có <u>gia quyến</u> mới được vào đây.<br /><br />Nếu bạn không có tài khoản, bạn có thể xin mở một cái bằng cái mối thu nhập thích hợp bên dưới.<br /><br />Sau khi kiểm tra sự xin đăng ký của bạn, quản lý sẽ kích hoạt tài khoản của bạn. Bạn sẽ nhận một bức thư điện tử cho biết sự xin đăng ký của bạn đã được chấp thuận.";
$pgv_lang["welcome_text_cust_head"] 	= "<center><b>Kính chào vào cái website Gia Phả này</b></center><br />Chỉ có những thành viên cầm tên truy nhập cùng với mật khẩu mới được vào.";
$pgv_lang["welcome"]				= "Chào Mừng";
$pgv_lang["upcoming_events"]		= "Chuyện sắp đến";
$pgv_lang["none_today_living"]		= "Không có chuyện về người sống cho ngày hôm nay.";
$pgv_lang["none_today_all"]			= "Không có chuyện gì cho ngày hôm nay.";
$pgv_lang["chat"]					= "Tán gẫu";
$pgv_lang["users_logged_in"]		= "Thành viên trực tuyến";
$pgv_lang["anon_user"]				= "1 thành viên vô danh trực tuyến";
$pgv_lang["login_user"]				= "1 thành viên trực tuyến";
$pgv_lang["no_login_users"]			= "Không ai trực tuyến và không có thành viên vô danh";
$pgv_lang["message"]				= "Gửi Bức điện";
$pgv_lang["my_messages"]			= "Những Bức điện của tôi:";
$pgv_lang["date_created"]			= "Ngày gửi:";
$pgv_lang["message_from"]			= "Địa chỉ thư điện tử:";
$pgv_lang["message_from_name"]		= "Tên bạn:";
$pgv_lang["message_to"] 			= "Bức điện cho:";
$pgv_lang["message_subject"]		= "Chủ đề:";
$pgv_lang["message_body"]			= "Thân dung:";
$pgv_lang["no_to_user"] 			= "Không cho biết người nhận. Không thể tiếp tục.";
$pgv_lang["provide_email"]			= "Xin cho địa chỉ thư điện tử đặng chúng tôi liên lạc với bạn về thư điện này. Nếu bạn không cho địa chỉ thư điện tử, chúng tôi sẽ không đáp ứng câu hỏi của bạn được. Địa chỉ thư điện tử của bạn sẽ không sài  chuyện gì khác ngoài việc đáp ứng câu hỏi này.";
$pgv_lang["reply"]					= "Trả lời";
$pgv_lang["message_deleted"]		= "Bức điện đã xoá bỏ";
$pgv_lang["message_sent"]			= "Bức điện đã gửi đi";
$pgv_lang["reset"]					= "Đặt lại";
$pgv_lang["site_default"]			= "Mặc định của site";
$pgv_lang["mygedview_desc"] 		= "Trong Trang GedView của Tôi, bạn có thể giữ người ưa chuộng, theo dõi những chuyện sắp đến, và cộng tác cùng với những thành viên PhpGedView khác.";
$pgv_lang["no_messages"]			= "Bạn không có bức điện nào đang chờ.";
$pgv_lang["clicking_ok"]			= "Nhấn vào OK đặng mở trang mới và # liên lạc với #user[fullname]#";
$pgv_lang["my_favorites"]			= "Ưa Chuộng của Tôi";
$pgv_lang["no_favorites"]			= "Bạn chưa có lựa người ưa chuộng. Đặng lựa người ưa chuộng, xin <b>Tìm Kiếm</b> chi tiết người đó và nhấn vào cái mối <b>Thêm vào Ưa Chuộng của Tôi</b> trong mối <b>Cái khác</b>, hay là dùng cái hộp <b>Tìm Nhận Diện</b> dưới đây đặng thêm người theo số Nhận Diện";
$pgv_lang["add_to_my_favorites"]	= "Thêm vào Ưa Chuộng của Tôi";
$pgv_lang["gedcom_favorites"]		= "Ưa Chuộng của GEDCOM này";
$pgv_lang["no_gedcom_favorites"]	= "Tới ngày nay chưa có Người Ưa Chuộng được chọn. Người quản lý có thể lựa Người Ưa Chuộng đặng phô bày khi bắt đầu.";
$pgv_lang["confirm_fav_remove"] 	= "Có chắc là muốn lấy món này ra khỏi sổ Ưa Chuộng?";
$pgv_lang["invalid_email"]			= "Xin cho vào một địa chỉ thư điện tử hợp lệ.";
$pgv_lang["enter_subject"]			= "Xin cho vào chủ đề của thư.";
$pgv_lang["enter_body"] 			= "Xin cho vào vài chữ trong thư trước khi gửi đi.";
$pgv_lang["confirm_message_delete"] = "Có chắc là muốn xóa thư này? Sẽ không tìm lại được sau này.";
$pgv_lang["message_email1"] 		= "Thư này đã tới tài khoản thành viên PhpGedView của bạn từ ";
$pgv_lang["message_email2"] 		= "Bạn đã gửi thư sau đây cho một thành viên PhpGedView:";
$pgv_lang["message_email3"] 		= "Bạn đã gửi thư sau đây cho một quản lý của PhpGedView:";
$pgv_lang["viewing_url"]			= "Thư này đã gửi trong khi xem cái URL sau đây:";
$pgv_lang["messaging2_help"]		= "Khi nào bức điện này gửi đi, bạn sẽ nhận một bản chép tại địa chỉ thư điện tử bạn đã cho<br /><br />";
$pgv_lang["random_picture"] 		= "Bức ảnh tuyển lựa tình cờ";
$pgv_lang["message_instructions"]	= "<b>Xin chú ý:</b>Chuyện riêng tư của người còn sống chỉ cho người có họ hay bạn thân thuộc biết được. Bạn phải cho biết mối liên hệ của bạn trước khi xem được tài liệu giữ kín. Đôi lúc tài liệu của người chết cũng giữ kín. Trong trường hợp này, chắc là không có đủ chuyện biết về người này đặng định rõ là còn sống hay chết và nhiều phần là chúng tôi không biết gì thêm trên người này.<br /><br />Trước khi hỏi chi, bạn nên chắc chắn là trúng người bằng cách kiểm lại ngày, nơi và dòng họ. Nếu như bạn đề nghị thay đổi dữ kiện trong phả hệ, xin gồm nguồn gốc  của dữ kiện bạn kiếm được.";
$pgv_lang["sending_to"] 			= "Bức điện này sẽ gửi cho #TO_USER#";
$pgv_lang["preferred_lang"] 		= "Người này muốn đọc bức điện bằng tiếng #USERLANG#";
$pgv_lang["gedcom_created_using"]	= " Cái GEDCOM này gây ra bởi <b>#SOFTWARE# #VERSION#</b>";
$pgv_lang["gedcom_created_on"]		= " Cái GEDCOM này gây ra từ <b>#DATE#</b>";
$pgv_lang["gedcom_created_on2"] 	= " từ ngày <b>#DATE#</b>";
$pgv_lang["gedcom_stats"]			= "Thống Kê GEDCOM";
$pgv_lang["stat_individuals"]		= "Nhân Vật,";
$pgv_lang["stat_families"]			= "Gia Đình,";
$pgv_lang["stat_sources"]			= "Nguồn,";
$pgv_lang["stat_other"] 			= "Ký lục khác";
$pgv_lang["stat_earliest_birth"] 	= "Năm Sanh Xa Vời Nhất";
$pgv_lang["stat_latest_birth"] 	= "Năm Sanh Gần Đây Nhất";
$pgv_lang["customize_page"] 		= "Tùy biến Trang GedView của Tôi";
$pgv_lang["customize_gedcom_page"]	= "Tùy biến trang Chào Mừng GEDCOM này";
$pgv_lang["upcoming_events_block"]	= "Khối Sự Việc Sắp Xảy Tới ";
$pgv_lang["upcoming_events_descr"]	= "Cái khối Sự Việc Sắp Xảy Tới cho xem danh sách của những sự việc đã xảy đến trong vòng 30 ngày trước đây trong kho dữ kiện đang dùng.<br /><br />Trong Trang GedView của Tôi, khối này ghi kết những người còn sống. Trong Trang Chào Mừng của  GEDCOM, nó sẽ ghi kết tất cả mọi người.";
$pgv_lang["todays_events_block"]	= "Khối Sự Việc Trong Ngày Nay";
$pgv_lang["todays_events_descr"]	= "Cái khối Sự Việc Trong Ngày Nay, trong Quá Khứ Của Bạn... cho xem danh sách của những sự việc đã xảy đến trong ngày hôm nay trong kho dữ kiện đang dùng.<br /><br />Nếu không có sự việc nào hết, sẽ không trưng bày khối nào. Trong Trang GedView của Tôi, khối này ghi kết những người còn sống. Trong Trang Chào Mừng của GEDCOM, nó sẽ ghi kết tất cả mọi người.";
$pgv_lang["logged_in_users_block"]	= "Khối Thành Viên đã  Truy Nhập";
$pgv_lang["logged_in_users_descr"]	= "Cái khối Thành Viên đã Truy Nhập cho xem danh sách của những thành viên đang trên cái Website này.";
$pgv_lang["user_messages_block"]	= "Khối Thư Tín của Thành Viên";
$pgv_lang["user_messages_descr"]	= "Cái khối Thư Tín của Thành Viên cho xem danh sách của những thư điện tử có gửi tới thành viên đã truy nhập.";
$pgv_lang["user_favorites_block"]	= "Khối Ưa Chuộng của Thành Viên";
$pgv_lang["user_favorites_descr"]	= "Cái khối Ưa Chuộng của Thành Viên cho xem danh sách của những người ưa thích bởi thành viên đặng thành viên có thể nhìn người đó nhanh nhẹn.";
$pgv_lang["welcome_block"]			= "Khối Chào Mừng Thành Viên";
$pgv_lang["welcome_descr"]			= "Cái khối Chào Mừng Thành Viên cho thành viên xem ngày và giờ hiện tại, những mối liên lạc đặng thay đổi tài khoản của mình hay là đi đến <b>Đồ Thị Dòng Giống</b> của mình, và mối liên lạc đặng sửa đổi <b>Trang GedView của Tôi</b> của mình.";
$pgv_lang["random_media_block"] 	= "Khối  Môi Thể tuyển lựa tình cờ";
$pgv_lang["random_media_descr"] 	= "Cái khối Môi Thể tuyển lựa Tình Cờ sẽ lựa tình cờ một hình hoặc môi thể  khác đặng phô bày cho thành viên.";
$pgv_lang["gedcom_block"]			= "Khối Chào Mừng GEDCOM";
$pgv_lang["gedcom_descr"]			= "Cái khối Chào Mừng GEDCOM cũng chạy giống như cái khối Chào Mừng Thành Viên. Khối đó chào mừng người đến thăm site và phô trương tên của kho dữ kiện đang dùng cùng với ngày và giờ hiện tại.";
$pgv_lang["gedcom_favorites_block"] = "Khối Ưa Chuộng GEDCOM";
$pgv_lang["gedcom_favorites_descr"] = "Cái khối Ưa Chuộng GEDCOM dùng cho quản lý chỉ định một vài người trong kho dữ kiện đặng chuyện biết về họ có thể xem được một cách nhanh nhẹn bởi tất cả mọi người. Đấy là một cách đề cao những người quan trọng trong lịch sử của gia đình của bạn.<br />";
$pgv_lang["gedcom_stats_block"] 	= "Khối thống kê GEDCOM";
$pgv_lang["gedcom_stats_descr"] 	= "Cái khối thống kê GEDCOM cho khách kiến thức cơ bản về kho dữ kiện, <br />như khi tạo ra và có bao nhiêu người trong đó.<br /><br />Trong đó cũng có danh sách của những tên họ thông thường nhất. Bạn có thể thay đổi khối này đặng không phô bày danh sách tên họ thông thường, và bạn cũng có thể thay đổi GEDCOM đặng thêm hay bớt tên trong danh sách này. Bạn có thể đặt mức thống kê cho danh sách này trong cấu hình GEDCOM.";
$pgv_lang["gedcom_stats_show_surnames"]	= "Cho xem tên họ thông thường?";
$pgv_lang["portal_config_intructions"]	= "Bạn có thể sửa đổi trang bằng cách đưa đổi những khối trong trang tới chỗ bạn muốn.<br /><br />Trang chia ra thành phần <b>Chính</b> và <b>Tay Phải</b>. Những khối trong phần <b>Chính</b> trình diện lớn hơn và nằm dưới chủ đề. Những khối trong phần <b>Tay Phải</b> nằm bên phải của chủ đề.<br /><br />Mỗi phần có một dãy khối riêng sẽ in ra trên trang theo thứ tự đã dải ra. Bạn có thể thêm, bớt, hay sắp đặt  như ý.<br /><br />Khi nào có khối trống, những khối còn lại sẽ lấp đầy chiều ngang của trang.<br /><br />";
$pgv_lang["login_block"]			= "Khối Truy Nhập";
$pgv_lang["login_descr"]			= "Khối Truy Nhập chấp nhận một tên truy nhập cùng với mật khẩu đặng cho thành viên truy nhập.";
$pgv_lang["theme_select_block"] 	= "Khối chọn nền của Website";
$pgv_lang["theme_select_descr"] 	= "Khối Chọn Nền của Website biểu lộ cái món Chọn Nền dù cho đã  tắt phần Đổi Nền.";
$pgv_lang["block_top10_title"]		= "10 tên họ phổ thông nhất";
$pgv_lang["block_top10"]			= "Khối 10 tên họ phổ thông nhất";
$pgv_lang["block_top10_descr"]		= "Khối này cho xem 10 tên họ phổ thông nhất trong kho dữ kiện. Số tên họ trưng bày có thể sửa được. Bạn có thể thay đổi GEDCOM đặng bớt tên trong danh sách này.";
$pgv_lang["gedcom_news_block"]		= "Khối tin tức GEDCOM";
$pgv_lang["gedcom_news_descr"]		= "Khối tin tức GEDCOM cho người thăm viếng xem  những tin tức mới hay là những bài báo đăng lên bởi thành viên quản lý.<br /><br />Nên dùng khối tin tức đặng loan báo một cập nhật quan trọng của kho dữ kiện, một cuộc họp mặt gia đình, hoặc sự ra đời của một đứa bé.";
$pgv_lang["user_news_block"]		= "Khối nhật ký của thành viên";
$pgv_lang["user_news_descr"]		= "Khối nhật ký của thành viên cho phép thành viên ghi chuyện hoặc giữ nhật ký trực tuyến.";
$pgv_lang["my_journal"] 			= "Nhật ký của tôi";
$pgv_lang["no_journal"] 			= "Bạn không có gây ra mục Nhật ký nào.";
$pgv_lang["confirm_journal_delete"] = "Có chắc là muốn xóa mục Nhật ký này?";
$pgv_lang["add_journal"]			= "Cho vào mục Nhật ký mới";
$pgv_lang["gedcom_news"]			= "Tin tức";
$pgv_lang["confirm_news_delete"]	= "Bạn có chắc là muốn xóa cái tin tức mới cho vào không?";
$pgv_lang["add_news"]				= "Thêm một tin tức mới";
$pgv_lang["no_news"]				= "Không ai nộp tin tức nào mới.  ";
$pgv_lang["edit_news"]				= "Thêm/Sửa  Tin Tức/Nhật Ký";
$pgv_lang["enter_title"]			= "Xin cho vào đầu đề.";
$pgv_lang["enter_text"] 			= "Xin cho vài chữ vào món Tin Tức hoặc Nhật Ký này.";
$pgv_lang["news_saved"] 			= "Thành công viết xuống Tin Tức/Nhật Ký";
$pgv_lang["article_text"]			= " Nội dung nhập khẩu:";
$pgv_lang["main_section"]			= "Phần Khối Chính";
$pgv_lang["right_section"]			= "Phần khối bên phải";
$pgv_lang["available_blocks"]		= "Khối Sẵn Có";
$pgv_lang["move_up"]				= "Đi lên";
$pgv_lang["move_down"]				= "Đi xuống";
$pgv_lang["move_right"] 			= "Đi phải";
$pgv_lang["move_left"]				= "Đi trái";
$pgv_lang["add_main_block"] 		= "Thêm khối vào phần chính...";
$pgv_lang["add_right_block"]		= "Thêm khối vào phần bên phải...";
$pgv_lang["broadcast_all"]			= "Loan báo cho tất cả thành viên";
$pgv_lang["hit_count"]				= "Tổng số viếng thăm:";
$pgv_lang["phpgedview_message"] 	= "Thông báo của PhpGedView";
$pgv_lang["common_surnames"]		= "Tên họ thông thường nhất";
$pgv_lang["default_news_title"] 	= "Bản Phả Hệ của Bạn";
$pgv_lang["default_news_text"]		= "Gia Phả ở trên cái website này chu cấp bởi <a href=\"http://www.phpgedview.net/\" target=\"_blank\">PhpGedView</a>. Trang này dùng làm bước đầu vào cái bản phả hệ này.<br /><br /> Đặng bắt đầu làm việc với dữ kiện, hoặc là lựa một trong mấy cái <b>Đồ Thị</b>, hoặc là dùng <b>Danh Sách</b>, hoặc là <b>Tìm Kiếm</b> tên hay là nơi.<br /><br /> Nếu có trở ngại,  hảy dùng tượng <b>Hướng Dẫn</b> đặng có thêm giảng giải làm sao sài cái trang bạn đang coi.<br /><br /> Xin cám ơn đã viếng thăm nơi này.";
$pgv_lang["reset_default_blocks"]	= "Sửa lại như Khối Mặc Định";
$pgv_lang["recent_changes"] 		= "Thay Đổi Mới Đây";
$pgv_lang["recent_changes_block"]	= "Khối Thay Đổi Mới Đây";
$pgv_lang["recent_changes_descr"]	= "Cái khối Thay Đổi Mới Đây sẽ kê khai tất cả những sự biến đổi trong tháng vừa qua. Cái khối này cho phép biết những chuyện sửa đổi hiện hành. Chuyện sửa đổi sẽ tự nhiên khám phá bằng cái thẻ CHAN định rõ trong tiêu chuẩn GEDCOM.";
$pgv_lang["delete_selected_messages"]	= "Bỏ những Thư Điện Đã Lựa";
$pgv_lang["use_blocks_for_default"]	= "Dùng những khối này như khối mặc định cho tất cả thành viên?";
$pgv_lang["block_not_configure"]	=	"Khối này không thể sắp xếp.";
$pgv_lang["upgrade_util"]			= "Phần Nâng Cấp";
$pgv_lang["no_upgrade"] 			= "Không có tập tin nào đặng nâng cấp.";
$pgv_lang["use_version"]			= "Bạn đang coi sài bản số:";
$pgv_lang["current_version"]		= "Bản số vững vàng hiện thời:";
$pgv_lang["upgrade_download"]		= "Lấy xuống:";
$pgv_lang["latest"] 				= "Bạn đang sài bản số mới nhất của PhpGedView.";
$pgv_lang["location"]				= "Vị trí của  tập tin nâng cấp:";
$pgv_lang["include"]				= "Bao gồm:";
$pgv_lang["options"]				= "Món lựa chọn được:";
$pgv_lang["inc_config"] 			= "Tập tin cấu hình";
$pgv_lang["inc_researchlog"]		= "Sổ nghiên cứu";
$pgv_lang["inc_index"]				= "Tập tin chỉ số";
$pgv_lang["inc_themes"] 			= "Nền của Website";
$pgv_lang["inc_docs"]				= "Sách dùng";
$pgv_lang["inc_privacy"]			= "Tập tin điều lệ kín đáo";
$pgv_lang["inc_backup"] 			= "Gây ra dự phòng";
$pgv_lang["upgrade_help"]			= "Hướng dẫn tôi";
$pgv_lang["cannot_read"]			= "Không đọc được tập tin:";
$pgv_lang["not_configured"] 		= "Chưa đặt môi trường của PhpGedView.";
$pgv_lang["location_upgrade"]		= "Xin điền vào địa điểm của những tập tin Nâng Cấp của bạn.";
$pgv_lang["new_variable"]			= "Tìm thấy biến số mới:";
$pgv_lang["file_open_error"]		= "Có chuyện trục trặc khi mở tập tin [#pgv_lang[global_str1]#].";
$pgv_lang["file_write_error"]		= "Có chuyện sai lầm!!! Không thể viết vào tập tin [#pgv_lang[global_str1]#].";
$pgv_lang["config_open_error"]		= "Có sự sai lầm khi mở tập tin Cấu Hình.";
$pgv_lang["config_update_ok"]		= "Cập nhật tập tin Cấu Hình GEDCOM tốt đẹp.";
$pgv_lang["config_uptodate"]		= "Tập tin Cấu Hình của bạn đã hiện đại.";
$pgv_lang["processing"] 			= "Đang xem xét...";
$pgv_lang["privacy_open_error"] 	= "Có sự sai lầm khi mở tập tin [#PRIVACY_MODULE#].";
$pgv_lang["privacy_write_error"]	= "Có sự sai lầm!!! Không viết vào tập tin [#PRIVACY_MODULE#] được.<br />Xin xác định là đã cho quyền viết trong tập tin này.<br />Có thể đặt lại quyền viết sau khi tập tin điều lệ kín đáo đã viết xuống.";
$pgv_lang["privacy_update_ok"]		= "Cập nhật tập tin đặt mực kín đáo: [#PRIVACY_MODULE#] tốt đẹp.";
$pgv_lang["privacy_uptodate"]		= "Tập tin [#PRIVACY_MODULE#] của bạn đã hiện đại.";
$pgv_lang["heading_privacy"]		= "Tập tin đặt mực kín đáo:";
$pgv_lang["heading_phpgedview"] 	= "Tập tin PhpGedView:";
$pgv_lang["heading_image"]			= "Tập tin hình ảnh:";
$pgv_lang["heading_index"]			= "Tập tin chỉ số:";
$pgv_lang["heading_language"]		= "Tập tin ngôn ngữ:";
$pgv_lang["heading_theme"]			= "Tập tin đựng nền của Website:";
$pgv_lang["heading_docs"]			= "Chỉ dẫn sử dụng:";
$pgv_lang["heading_researchlog"]	= "Tập tin nhật ký chuyện đã Nghiên Cứu";
$pgv_lang["heading_researchloglang"]= "Tập tin nhật ký ngôn ngữ đã Nghiên Cứu";
$pgv_lang["copied_success"] 		= "Thành công chép.";
$pgv_lang["backup_copied_success"]	= "tập tin dự phòng tạo ra tốt đẹp.";
$pgv_lang["process_error"]			= "Có trục trặc khảo sát trang. Không thể xác định là bản mới hơn.";
$pgv_lang["upgrade_completed"]		= "Nâng cấp hoàn tất tốt đẹp.";
$pgv_lang["start_using_upgrad"] 	= "Nhấn vào đây đặng  bắt đầu dùng bản số";
$pgv_lang["changed_mac"]			= "Nhận thấy cuối hàng kiểu Macintosh. Mọi hàng chấm dứt với CR (Ctrl M) sẽ đổi đặng chấm dứt với CR (Ctrl M) tiếp theo bởi LF (Ctrl J). Như thế sẽ đổi khổ tập tin từ Macintosh sang DOS theo đòi hỏi của PhpGedView.";
$pgv_lang["changed_places"] 		= "Cách ghi những nơi không đúng. Đã thu dọn những ký lục nơi đặng theo khuôn khổ GEDCOM 5.5. Một cái ví dụ cho vào GEDCOM của bạn là:";
$pgv_lang["optional_tools"] 		= "Bạn cũng có thể dùng những chương trình phụ sau đây trước khi thu nhập.";
$pgv_lang["optional"]				= "Chương Trình Phụ";
$pgv_lang["date_format"]			= "Khuôn Ngày:";
$pgv_lang["add_media_tool"] 		= "Chương Trình Thêm Môi Thể";
$pgv_lang["launch_media_tool"]		= "Nhấn vào đây đặng thi hành Chương Trình Thêm Môi Thể";
$pgv_lang["add_media_descr"]		= "Dùng đặng thêm thẻ OBJE môi thể vào kho dữ kiện. Xin đóng trang này khi xong cho thêm môi thể.";
$pgv_lang["extension"]				= "Phần nối thêm";
$pgv_lang["order"]					= "Ngôi hàng";
$pgv_lang["inject_media_tool"]		= "Thêm môi thể vào tập tin GEDCOM<br /> ";
$pgv_lang["media_table_created"]	= "Hiện đại hoá bản <i>media</i> thành công.";
$pgv_lang["click_to_add_media"] 	= "Nhấn vào đây đặng thêm Môi Thể ở trên vào GEDCOM #GEDCOM#";
$pgv_lang["adds_completed"] 		= "Thêm Môi Thể vào tập tin GEDCOM tốt đẹp.";
$pgv_lang["hourglass_chart"]		= "Bản Đồ Đồng Hồ Cát";
$pgv_lang["choose_report"]			= "Chọn Bản Báo Cáo";
$pgv_lang["enter_report_values"]	= "Cho vào năng suất bản báo cáo";
$pgv_lang["selected_report"]		= "Bản Báo Cáo Đã Chọn";
$pgv_lang["run_report"] 			= "Coi Bản Báo Cáo";
$pgv_lang["select_report"]			= "Lựa bản báo cáo";
$pgv_lang["download_report"]		= "Lấy bản báo cáo xuống";
$pgv_lang["reports"]				= "Bản Báo Cáo";
$pgv_lang["pdf_reports"]			= "Báo Cáo bằng PDF";
$pgv_lang["html_reports"]			= "Báo Cáo bằng HTML";
$pgv_lang["individual_report"]		= "Báo Cáo theo tửng Người";
$pgv_lang["enter_pid"]				= "Cho vào Nhận Diện cá nhân";
$pgv_lang["individual_list_report"]	= "Bản Báo Cáo Danh Sách Từng Người";
$pgv_lang["generated_by"]			= "Tạo ra bởi";
$pgv_lang["list_children"]			= "Liệt kê mỗi con theo thứ tự ngày đẻ.";
$pgv_lang["family_group_report"]	= "Báo Cáo theo Gia Đình";
$pgv_lang["page"]					= "Trang";
$pgv_lang["of"] 					= "của";
$pgv_lang["enter_famid"]			= "Cho vào Nhận Diện Gia Đình";
$pgv_lang["show_sources"]			= "Cho xem nguồn?";
$pgv_lang["show_notes"] 			= "Cho xem lời ghi?";
$pgv_lang["show_basic"] 			= "In sự việc cơ bản khi trống trơn?";
$pgv_lang["show_photos"]			= "Cho xem ảnh?";
$pgv_lang["birth_report"]			= "Báo Cáo theo Ngày và Nơi Đẻ";
$pgv_lang["birthplace"]				= " Trong Nơi Đẻ có";
$pgv_lang["birthdate1"]				= "Giới hạn đầu Ngày Sinh";
$pgv_lang["birthdate2"]				= "Giới hạn cuối Ngày Sinh";
$pgv_lang["sort_by"]				= "Sắp xếp theo";
$pgv_lang["cleanup"]				= "Thu Dọn";
$pgv_lang["dynasty_list"]			= "Khái quát những gia đình";
$pgv_lang["make_slklist"]			= "Tạo ra danh sách EXCEL SLK";
$pgv_lang["excel_list"] 			= "Viết những tập tin sau đây dưới khổ EXCEL (SLK) (dùng danh sách Ông Tổ đầu tiên):";
$pgv_lang["excel_create"]			= "sẽ tạo ra trong tập tin:";
$pgv_lang["patriarch_list"] 		= "Danh Sách Ông Tổ";
$pgv_lang["slk_list"]				= "Danh sách EXCEL SLK";
$pgv_lang["statistics"] 			= "Thống Kê";
$pgv_lang["merge_same"] 			= "Ký Lục không cùng loại. Không hoà Ký Lục khác loại nhau được.";
$pgv_lang["merge_step1"]			= "Hoà vào, bước 1 trong 3 ";
$pgv_lang["merge_step2"]			= "Hoà vào, bước 2 trong 3 ";
$pgv_lang["merge_step3"]			= "Hoà vào, bước 3 trong 3 ";
$pgv_lang["select_gedcom_records"]	= "Chọn hai ký lục GEDCOM đặng hoà với nhau. Ký lục phải cùng loại.";
$pgv_lang["merge_to"]				= "Hoà tới Nhận Diện:";
$pgv_lang["merge_from"] 			= "Hoà từ Nhận Diện:";
$pgv_lang["merge_facts_same"]		= "Những sự kiện trong hai ký lục này y hệt nhau và sẽ tự động hoà với nhau.";
$pgv_lang["no_matches_found"]		= "Không tìm thấy sự kiện xứng hợp";
$pgv_lang["unmatching_facts"]		= "Những sự kiện này không xứng hợp. Xin lựa dữ kiện nào muốn giữ lại.";
$pgv_lang["record"] 				= "Ký lục";
$pgv_lang["adding"] 				= "Đang thêm";
$pgv_lang["updating_linked"]		= "Đang cập nhật ký lục có liên hệ";
$pgv_lang["merge_more"] 			= "Hoà những Ký Lục sau nữa vào nhau.";
$pgv_lang["same_ids"]				= "Cùng nhận diện. Không hoà những ký lục y hệt như nhau được.";
$pgv_lang["ancestry_chart"] 		= "Bản Đồ Tổ Tiên";
$pgv_lang["gen_ancestry_chart"]		= "Đồ Thị Đời Tổ Tông #PEDIGREE_GENERATIONS#";
$pgv_lang["chart_style"]			= "Kiểu đồ thị";
$pgv_lang["ancestry_list"]			= "Danh Sách Tổ Tiên";
$pgv_lang["ancestry_booklet"]   	= "Sổ tổ tiên";
$pgv_lang["show_cousins"]			= "Cho xem các hạ";
$pgv_lang["sosa_2"] 				= "Bố";
$pgv_lang["sosa_3"] 				= "Mẹ";
$pgv_lang["sosa_4"] 				= "Ông nội";
$pgv_lang["sosa_5"] 				= "Bà nội";
$pgv_lang["sosa_6"] 				= "Ông ngoại";
$pgv_lang["sosa_7"] 				= "Bà ngoại";
$pgv_lang["sosa_8"] 				= "Ông cố nội";
$pgv_lang["sosa_9"] 				= "Bà cố nội";
$pgv_lang["sosa_10"]				= "Ông cố nội";
$pgv_lang["sosa_11"]				= "Bà cố nội";
$pgv_lang["sosa_12"]				= "Ông cố ngoại";
$pgv_lang["sosa_13"]				= "Bà cố ngoại";
$pgv_lang["sosa_14"]				= "Ông cố ngoại";
$pgv_lang["sosa_15"]				= "Bà cố ngoại";
$pgv_lang["sosa_16"]				= "Ông cố cố nội";
$pgv_lang["sosa_17"]				= "Bà cố cố nội";
$pgv_lang["sosa_18"]				= "Ông cố cố nội";
$pgv_lang["sosa_19"]				= "Bà cố cố nội";
$pgv_lang["sosa_20"]				= "Ông cố cố nội";
$pgv_lang["sosa_21"]				= "Bà cố cố nội";
$pgv_lang["sosa_22"]				= "Ông cố cố nội";
$pgv_lang["sosa_23"]				= "Bà cố cố nội";
$pgv_lang["sosa_24"]				= "Ông cố cố ngoại";
$pgv_lang["sosa_25"]				= "Bà cố cố ngoại";
$pgv_lang["sosa_26"]				= "Ông cố cố ngoại";
$pgv_lang["sosa_27"]				= "Bà cố cố ngoại";
$pgv_lang["sosa_28"]				= "Ông cố cố ngoại";
$pgv_lang["sosa_29"]				= "Bà cố cố ngoại";
$pgv_lang["sosa_30"]				= "Ông cố cố ngoại";
$pgv_lang["sosa_31"]				= "Bà cố cố ngoại";
$pgv_lang["sosa_32"]			   = "Ông cố cố cố nội";
$pgv_lang["sosa_33"]			   = "Bà cố cố cố nội";
$pgv_lang["sosa_34"]			   = "Ông cố cố cố nội";
$pgv_lang["sosa_35"]			   = "Bà cố cố cố nội";
$pgv_lang["sosa_36"]			   = "Ông cố cố cố nội";
$pgv_lang["sosa_37"]			   = "Bà cố cố cố nội";
$pgv_lang["sosa_39"]			   = "Bà cố cố cố nội";
$pgv_lang["sosa_41"]			   = "Bà cố cố cố nội";
$pgv_lang["sosa_38"]			   = "Ông cố cố cố nội";
$pgv_lang["sosa_40"]			   = "Ông cố cố cố nội";
$pgv_lang["sosa_42"]			   = "Ông cố cố cố nội";
$pgv_lang["sosa_43"]			   = "Bà cố cố cố nội";
$pgv_lang["sosa_44"]			   = "Ông cố cố cố nội";
$pgv_lang["sosa_45"]			   = "Bà cố cố cố nội";
$pgv_lang["sosa_47"]			   = "Bà cố cố cố nội";
$pgv_lang["sosa_48"]			   = "Ông cố cố cố ngoại";
$pgv_lang["sosa_49"]			   = "Bà cố cố cố ngoại";
$pgv_lang["sosa_50"]			   = "Ông cố cố cố ngoại";
$pgv_lang["sosa_51"]			   = "Bà cố cố cố ngoại";
$pgv_lang["sosa_52"]			   = "Ông cố cố cố ngoại";
$pgv_lang["sosa_53"]			   = "Bà cố cố cố ngoại";
$pgv_lang["sosa_54"]			   = "Ông cố cố cố ngoại";
$pgv_lang["sosa_55"]			   = "Bà cố cố cố ngoại";
$pgv_lang["sosa_56"]			   = "Ông cố cố cố ngoại";
$pgv_lang["sosa_57"]			   = "Bà cố cố cố ngoại";
$pgv_lang["sosa_58"]			   = "Ông cố cố cố ngoại";
$pgv_lang["sosa_59"]			   = "Bà cố cố cố ngoại";
$pgv_lang["sosa_60"]			   = "Ông cố cố cố ngoại";
$pgv_lang["sosa_61"]			   = "Bà cố cố cố ngoại";
$pgv_lang["sosa_62"]			   = "Ông cố cố cố ngoại";
$pgv_lang["sosa_63"]			   = "Bà cố cố cố ngoại";
$pgv_lang["fan_chart"]				= "Biểu Đồ Hình Tròn";
$pgv_lang["gen_fan_chart"]  		= "Vòng Thế Hệ #PEDIGREE_GENERATIONS#";
$pgv_lang["fan_width"]				= "Bề ngang của quạt";
$pgv_lang["gd_library"]				= "PHP server không sửa soạn đàng hoàn: cần đến nhóm GD 2.x cho hoạt động hình ảnh.";
$pgv_lang["gd_freetype"]			= "PHP server không sửa soạn đàng hoàn: cần đến nhóm FreeType không mất tiền đặng dùng tuồng chữ TrueType.";
$pgv_lang["sosa_46"]			   = "Ông cố cố cố nội";
$pgv_lang["fontfile_error"]			= "Không tìm thấy được tập tin tuồng chữ in trong server PHP.";
$pgv_lang["fanchart_IE"]			= "Đồ Thị hình Quạt này không có thể in bởi bộ duyệt tìm. Nhấn bên tay phải đặng giữ lại và in.";
$pgv_lang["rss_descr"]				= "Tin tức và  mối liên lạc từ website #GEDCOM_TITLE#";
$pgv_lang["rss_logo_descr"]			= "Cung cấp bởi PhpGedView";
$pgv_lang["rss_feeds"]				= "Nơi cung cấp RSS";
$pgv_lang["RSS_block"]				= "Khối RSS";
$pgv_lang["attendant"] = "Người phục vụ";
$pgv_lang["attending"] = "Người có mặt";
$pgv_lang["circumciser"] = "Người cắt bao quy đầu";
$pgv_lang["civil_registrar"] = "Người giữ sổ cưới dân sự";
$pgv_lang["friend"] = "Bạn";
$pgv_lang["godfather"] = "Cha đỡ đầu";
$pgv_lang["godmother"] = "Mẹ đỡ đầu";
$pgv_lang["godparent"] = "Cha mẹ đỡ đầu";
$pgv_lang["informant"] = "Người cung cấp tin tức";
$pgv_lang["lodger"] = "Người ở trọ";
$pgv_lang["nurse"] = "Y Tá";
$pgv_lang["priest"] = "Thầy tu";
$pgv_lang["rabbi"] = "Giáo sĩ Do thái";
$pgv_lang["registry_officer"] = "Người giữ sổ";
$pgv_lang["servant"] = "Người Hầu";
$pgv_lang["twin"] = "Sinh đôi ";
$pgv_lang["twin_brother"] = "Anh(em) sinh đôi";
$pgv_lang["twin_sister"] = "Chị(em) sinh đôi";
$pgv_lang["witness"] = "Người làm chứng";
$pgv_lang["statutci"]			= "không tạo ra được chỉ số";
$pgv_lang["statnnames"]                = "tổng cộng các tên=";
$pgv_lang["statnfam"]                  = "tổng cộng các gia đình =";
$pgv_lang["statnmale"]                 = "tổng cộng phái nam =";
$pgv_lang["statnfemale"]               = "tổng cộng phái nữ =";
$pgv_lang["statvars"]			 = "Cho những biến số dùng cho đồ thị sau đây";
$pgv_lang["statlxa"]			 = "theo trục-x:";
$pgv_lang["statlya"]			 = "theo trục-y:";
$pgv_lang["statlza"]			 = "theo trục-z:";
$pgv_lang["stat_10_none"]		 = "không cho gì hết";
$pgv_lang["stat_11_mb"]			 = "Tháng sinh";
$pgv_lang["stat_12_md"]			 = "Tháng tử";
$pgv_lang["stat_13_mm"]			 = "Tháng cưới";
$pgv_lang["stat_14_mb1"]		= "Tháng sinh con đầu lòng trong một mối liên hệ";
$pgv_lang["stat_15_mm1"]		= "Tháng cưới lần đầu";
$pgv_lang["stat_16_mmb"]		= "Số tháng giữa đám cưới và con đầu lòng.";
$pgv_lang["stat_17_arb"]			 = "tuổi theo năm sinh.";
$pgv_lang["stat_18_ard"]			 = "tuổi theo năm tử.";
$pgv_lang["stat_19_arm"]			 = "tuổi trong năm cưới.";
$pgv_lang["stat_20_arm1"]			 = "tuổi trong năm cưới lần đầu.";
$pgv_lang["stat_21_nok"]			 = "số con.";
$pgv_lang["stat_gmx"]			= "lựa đơn vị cho tháng";
$pgv_lang["stat_gax"]			= "lựa đơn vị cho tuổi";
$pgv_lang["stat_gnx"]			= "lựa đơn vị cho số";
$pgv_lang["stat_200_none"]			 = "tất cả (hoặc để trống)";
$pgv_lang["stat_201_num"]			 = "số";
$pgv_lang["stat_202_perc"]			 = "tỷ lệ phần trăm";
$pgv_lang["stat_300_none"]		= "không ai";
$pgv_lang["stat_301_mf"]			 = "nam/nữ";
$pgv_lang["stat_302_cgp"]			 = "thời kỳ. Lựa đơn vị cho thời kỳ trên trục z";
$pgv_lang["statmess1"]			 = "<b>Chỉ cần điền vào những hàng tiếp sau có quan hệ với những gì đã lựa trên trục x hay trục z</b>";
$pgv_lang["statar_xgp"]			 = "đơn vị cho thời kỳ (trục x):";
$pgv_lang["statar_xgl"]			 = "đơn vị cho tuổi (trục x):";
$pgv_lang["statar_xgm"]			 = "đơn vị cho tháng (trục x):";
$pgv_lang["statar_xga"]			 = "đơn vị cho số (trục x):";
$pgv_lang["statar_zgp"]			 = "đơn vị cho thời kỳ (trục z):";
$pgv_lang["statreset"]			 = "đặt lại";
$pgv_lang["statsubmit"]			 = "xem sơ đồ";
$pgv_lang["stplGDno"]			 = "Nhóm Trưng Bày Hình Ảnh không sẵn có trong PHP4. Xin liên lạc với quản lý hệ thống điện toán.";
$pgv_lang["stpljpgraphno"]		= "Bộ phận JPgraph không sẵn có trong mục lục <i>phpgedview/jpgraph/</i>. Có thể lấy từ http://www.aditus.nu/jpgraph/jpdownload.php<br /> <h3><i>Đầu tiên phải đặt vào trong mục lục phpgedview/jpgraph/</i></h3><br /><br /> ";
$pgv_lang["stplinfo"]			 = "dữ kiện sơ đồ:";
$pgv_lang["stpltype"]			 = "loại:";
$pgv_lang["stplnoim"]			 = "chưa thực hiện:";
$pgv_lang["stplmf"]			 = "/đàn ông-đàn bà";
$pgv_lang["stplipot"]			 = " /cho mỗi giai đoạn thời gian";
$pgv_lang["stplgzas"]			 = "đi theo trục-z:";
$pgv_lang["stplmonth"]			 = "tháng";
$pgv_lang["stplnumbers"]		 = "số cho một gia đình";
$pgv_lang["stplage"]			 = "tuổi";
$pgv_lang["stplperc"]			 = "tỷ lệ phần trăm";
$pgv_lang["alive_in_year"]			= "Còn Sống trong Năm";
$pgv_lang["is_alive_in"]			= "Còn Sống trong #YEAR#";
$pgv_lang["alive"]					= "Còn Sống";
$pgv_lang["dead"]					= "Chết";
$pgv_lang["maybe"]					= "Có thể";
$pgv_lang["add_directory"]			= "Thêm mục lục";
$pgv_lang["image_size"]				= "Kích thước hình --";
$pgv_lang["manage_media"]			= " Quản Xuyến môi thể";
$pgv_lang["media_id"]			= "Nhận Diện Môi Thể";
$pgv_lang["invalid_id"]			= "Không có Nhận Diện nào như vậy trong cái tập tin GEDCOM này";
$pgv_lang["definitions"]		= "Những Định Nghĩa";
$pgv_lang["description"]			= "Diễn Tả";
$pgv_lang["block_desc"]				= "Diễn Tả Khối ";
$pgv_lang["click_here"]				= "Nhấn đây đặng tiếp tục";
$pgv_lang["account_information"] = "Chi tiết về tài khoản";
$pgv_lang["comments"]				= "Bình Luận";
$pgv_lang["ahnentafel_report"]		= "Bản Báo Cáo Ahnentafel";
$pgv_lang["child-family"]			= "Bố Mẹ và Anh(Chị) Em";
$pgv_lang["spouse-family"]			= "Chồng/Vợ và Con Cái";
$pgv_lang["direct-ancestors"]		= "Tổ tiên trực hệ";
$pgv_lang["ancestors"]				= "Tổ tiên trực hệ cùng gia đình";
$pgv_lang["descendants"]			= "Những người nối dõi";
$pgv_lang["choose_relatives"]		= "Chọn họ hàng";
$pgv_lang["relatives_report"]		= "Báo Cáo theo Họ Hàng";
$pgv_lang["total_living"]			= "Tổng số còn sống";
$pgv_lang["total_dead"]				= "Tổng số chết";
$pgv_lang["total_not_born"]			= "Tổng số chưa sinh";
$pgv_lang["remove_custom_tags"]		= "Bỏ những thẻ của PGV? (eg. _PGVU, _THUM)";
$pgv_lang["cookie_login_help"]		= "Cái site này nhớ bạn từ một kỳ đăng nhập trước.  Vì vậy bạn có thể xem tài liệu giữ kín cùng với làm chuyện dành riêng cho thành viên, tuy vậy, đặng sửa hay là quản trị site này, vì lý do an ninh bạn phải đăng nhập lại.";
$pgv_lang["remember_me"]			= "Nhớ tôi ở trên máy điện toán này";
$pgv_lang["fams_with_surname"]		= "Gia đình với tên họ #surname#";
$pgv_lang["support_contact"]		= "Cần hướng dẫn kỹ thuật";
$pgv_lang["genealogy_contact"]		= "Người đầu mối liên lạc về gia phả";
$pgv_lang["continue_import"]		= "Tiếp tục lấy vào những nơi";
$pgv_lang["importing_places"]		= "Lấy vào những ký lục nơi";
$pgv_lang["common_upload_errors"]	= "Cái tập tin bạn muốn gửi lên gặp sai lầm vì khổ quá hạn chế đặt bởi chỗ lưu trữ web. Hạn chế của PHP là 2MB. Bạn có thể liên lạc với nhóm hỗ trợ của chỗ lưu trữ đặng tăng hạn chế của tập tin php.ini, hoặc là gửi lên bằng FTP. Dùng cái <a href=\"uploadgedcom.php?action=add_form\"><b>Add GEDCOM</b></a> đặng thêm tập tin GEDCOM bạn đã gửi lên bằng FTP.";
$pgv_lang["total_memory_usage"]		= "Tổng số Bộ Nhớ đang sài:";
$pgv_lang["mothers_family_with"]	= "Gia đình của mẹ với ";
$pgv_lang["fathers_family_with"]	= "Gia đình của bố với ";
$pgv_lang["halfbrother"]			= "Anh (em) cùng cha khác mẹ, anh (em) cùng mẹ khác cha";
$pgv_lang["halfsister"]				= "Chị (em) cùng cha khác mẹ, chị (em) cùng mẹ khác cha";
$pgv_lang["family_timeline"]		= "Xem đồ thị lịch sử  gia đình";
$pgv_lang["children_timeline"]		= "Xem đồ thị lịch sử con cái";
$pgv_lang["other"]					= "Cái khác";
$pgv_lang["sort_by_marriage"]		= "Sắp xếp theo ngày kết hôn";
$pgv_lang["reorder_families"]		= "Sắp xếp gia đình theo thứ tự";
$pgv_lang["indis_with_surname"]		= "Nhân vật với tên họ #surname#";
$pgv_lang["first_letter_fname"]		= "Chọn một chữ đặng coi những cá nhân có tên gọi bắt đầu bằng chữ đó";
$pgv_lang["marr_name_import_instr"]	= "Nhấn vào nút dưới này nếu bạn muốn PhpGedView đếm những tên sau khi lập gia-đình trong GEDCOM này. Cái này cho bạn tìm và liệt kê đàn bà theo tên sau khi lập gia-đình.";
$pgv_lang["indis_with_surname"]		= "";
$pgv_lang["total_names"]			= "Tổng số những Tên";
$pgv_lang["upload_file"]			= "Lấy tập tin từ máy điện toán này";
$pgv_lang["top10_pageviews_nohits"]	= "Không có gì tìm thấy đặng xem.";
$pgv_lang["top10_pageviews_msg"]	= "Đặng cho khối này chạy, phải cho bộ phận cộng thăm viếng trong cấu hình GEDCOM chạy.";
$pgv_lang["review_changes_descr"]	= "Khối Chuyện đang Chờ Đổi dùng cho thành viên với quyền Sửa xem danh sách những ký lục đã đổi trực tuyến, còn cần phải kiểm. Những chuyện đổi này chỉ chính thức hoá sau khi được chấp nhận.<br /><br /> Nếu khối này cho chạy, những thành viên với quyền Chấp Thuận sẽ nhận thư điện tử mỗi ngày báo cho biết có chuyện đổi, cần xét lại.";
$pgv_lang["review_changes_block"]	= "Những chuyện đang chờ đổi";
$pgv_lang["review_changes_subject"]	= "PhpGedView - Xét lại những gì thay đổi";
$pgv_lang["review_changes_body"]	= "Có chuyện đổi trực tuyến trong kho dữ kiện của bản phả hệ.  Những chuyện đổi này còn cần phải xét và chấp nhận trước khi mọi người xem được.  Xin dùng cái URL sau đây đặng truy nhập vào PhpGedView để kiểm những chuyện đổi.";
$pgv_lang["show_spouses"]		= "Cho xem Chồng/Vợ";
$pgv_lang["quick_update_title"] = "Sửa nhanh nhẹn";
$pgv_lang["quick_update_instructions"] = "Trang này dùng cho bạn sửa nhanh nhẹn chi tiết về một người. Bạn chỉ cần cho chi tiết mới hay là những gì đã đổi từ cái hiện có trong kho dữ kiện. Sau khi nộp lên, quản lý phải chấp thuận trước khi những sự đổi coi được bởi tất cả mọi người. Xin nhớ là ngày phải cho vào bằng tiếng Anh và sẽ tự động biến đổi sang tiếng đang sử dụng.";
$pgv_lang["update_name"] = "Cập Nhật Tên";
$pgv_lang["update_fact"] = "Cập Nhật một Sự Kiện";
$pgv_lang["update_fact_restricted"] = "Cập nhật của sự kiện này bị cấm:";
$pgv_lang["update_photo"] = "Cập Nhật Hình";
$pgv_lang["select_fact"] = "Chọn một sự việc";
$pgv_lang["update_address"] = "Cập Nhật Địa Chỉ";
$pgv_lang["top10_pageviews_descr"]	= "Đoạn này sẽ trưng bày 10 cái ký lục được viếng nhiều nhất. Đoạn này cần phải có bộ phận Tổng Số Viếng Thăm trong cấu hình GEDCOM chạy.";
$pgv_lang["top10_pageviews"]		= "Trang được nhìn nhiều nhất";
$pgv_lang["top10_pageviews_block"]		= "Đoạn 'Trang được nhìn nhiều nhất'";
$pgv_lang["stepfamily"]				= "Gia đình kế";
$pgv_lang["stepdad"]				= "Dưỡng phụ";
$pgv_lang["stepmom"]				= "Mẹ kế";
$pgv_lang["stepsister"]				= "Chị (em) cùng cha khác mẹ, chị (em) cùng mẹ khác cha";
$pgv_lang["stepbrother"]			= "Anh (em) cùng cha khác mẹ, anh (em) cùng mẹ khác cha";
$pgv_lang["fams_charts"]			= "Món lựa được cho Gia Đình này";
$pgv_lang["indis_charts"]			= "Món lựa được cho nhân vật này";
$pgv_lang["edit_indi"] 				= "Sửa nhân vật";
$pgv_lang["locked"]					= "Không Đổi";
$pgv_lang["privacy"]				= "Không được bộc lộ";
$pgv_lang["page_help"]				= "Hướng dẫn";
$pgv_lang["help_for_this_page"] 	= "Hướng dẫn cho trang này";
$pgv_lang["help_contents"]			= "Nội dung của Hướng dẫn";
$pgv_lang["show_context_help"]		= "Trưng Bày Hướng Dẫn theo Hoàn Cảnh";
$pgv_lang["hide_context_help"]		= "Không Trưng Bày Hướng Dẫn theo Hoàn Cảnh";
$pgv_lang["sorry"]					= "<b>Rất tiếc rằng hướng dẫn cho trang hay món này chưa có.</b>";
$pgv_lang["help_not_exist"] 		= "<b>Hướng dẫn cho trang hay món này chưa có.</b>";
$pgv_lang["var_not_exist"]			= "<span style=font-weight: bold>Biến số của ngôn ngữ này chưa có. Xin báo cáo chuyện này vì đó là sự sai lầm.</span>";
$pgv_lang["resolution"] 			= "Nét Rõ Màn Hình";
$pgv_lang["menu"]					= "Bảng chọn";
$pgv_lang["header"] 				= "Côlectơ";
$pgv_lang["imageview"]				= "Xem hình";
$pgv_lang["login_head"] 			= "Đăng nhập vào PhpGedView";
$pgv_lang["error_title"]			= "Có gì sai: Không thể mở tập tin GEDCOM";
$pgv_lang["for_support"]			= "Đặng hướng dẫn hoặc có thêm chi tiết của chương trình này, xin liên lạc với";
$pgv_lang["for_contact"]			= "Đặng hướng dẫn về gia phả, xin liên lạc với";
$pgv_lang["for_all_contact"]		= "Đặng hướng dẫn về chương trình này hay là hỏi về gia phả, xin liên lạc với";
$pgv_lang["build_title"]			= "Đang xây Tập Tin Chỉ Số.";
$pgv_lang["build_error"]			= "Tập tin GEDCOM đã cập nhật";
$pgv_lang["please_wait"]			= "Xin chờ trong khi đang xây lại tập tin Chỉ Số.";
$pgv_lang["choose_gedcom"]			= "Xin chọn một dải dữ liệu GEDCOM";
$pgv_lang["username"]				= "Tên truy nhập";
$pgv_lang["invalid_username"]		= "Tên truy nhập có kí tự không có thể chấp nhận";
$pgv_lang["lastname"]				= "Tên Họ";
$pgv_lang["firstname"]				= "Tên Gọi";
$pgv_lang["pls_note12"]				= "Xin cho biẽt tại sao bạn muốn tài khoản trên website này và liên hệ của bạn với bảng phả hệ ở đây.";
$pgv_lang["enter_comments"]			= "Xin cho biẽt liên hệ của bạn với tài liệu trong chổ bình luận.";
$pgv_lang["days_to_show"]			= "Số ngày đặng trưng bày";
$pgv_lang["config_block"]			= "Định hình thể của khối";
$pgv_lang["num_to_show"]			= "Số món đặng trưng bày";
$pgv_lang["changelog"]				= "Khác đổi của bản số #VERSION#";
$pgv_lang["html_block_descr"]		= "Đây là một khối HTML bạn có thể để trong trang của bạn đặng thêm bất cứ thông báo nào bạn muốn.";
$pgv_lang["html_block_name"]		= "Khối HTML";
$pgv_lang["stat_most_children"]		= "Gia đình đông con nhất";
$pgv_lang["stat_average_children"]	= "Số con trung bình trong mỗi gia đình";
$pgv_lang["stat_events"]			= "Tổng số sự việc";
$pgv_lang["stat_surnames"]			= "Tổng số tên họ";
$pgv_lang["stat_users"]				= "Tổng số thành viên";
$pgv_lang["no_family_facts"]		= "Không có sự kiện cho gia đình này";
$pgv_lang["sunday_1st"]					= "N";
$pgv_lang["wednesday_1st"]				= "4";
$pgv_lang["saturday_1st"]				= "7";
$pgv_lang["edit_source"]			= "Sửa Đổi Nguồn";
$pgv_lang["source_menu"]			= "Món lựa được cho nguồn";
$pgv_lang["familybook_chart"]		= "Sách Gia Quyến";
$pgv_lang["friday_1st"]					= "6";
$pgv_lang["thursday_1st"]				= "5";
$pgv_lang["tuesday_1st"]				= "3";
$pgv_lang["monday_1st"]					= "2";
$pgv_lang["cancel"]					= "Bãi Bỏ";
$pgv_lang["cookie_help"]			= "Nơi này dùng cookies đặng theo dõi tình trạng gia nhập của bạn.<br /><br />Hình như bộ duyệt tìm của bạn không cho phép cookies. Bạn   phải cho phép cookies của site này trước khi được truy nhập. Bạn có thể tra cứu tài liệu hướng dẫn của bộ duyệt tìm của bạn đặng biết làm sao ho phép cookies.";
$pgv_lang["indi_is_remote"]			= "Chi tiết về nhân vật này liên kết từ site ở chỗ khác.";
$pgv_lang["link_remote"]            = "Liên kết nhân vật từ chỗ khác.";
$pgv_lang["label_accept_changes"]   = "Chấp nhận Mọi Chuyện Sửa Đổi";
$pgv_lang["label_ask_first"]        = "Hỏi Tôi Đầu Tiên";
$pgv_lang["add_favorite"]			= "Thêm người ưa chuộng mới";
$pgv_lang["address_list"]			= "Danh Sách Địa Chỉ";
$pgv_lang["stat_avg_age_at_death"]	= "Tuổi trung bình lúc chết";
$pgv_lang["stat_longest_life"]		= "Người sống lâu nhất";
$pgv_lang["ex-spouse"] = "Vợ/Chồng Trước";
$pgv_lang["ex-wife"] = "Vợ Trước";
$pgv_lang["ex-husband"] = "Chồng Trước";
$pgv_lang["onlyemail"] 				= "Chỉ những địa chỉ với thư điện tử";
$pgv_lang["maxviews_exceeded"]		= "Tỷ lệ số trang trưng bày quá hạn, xin thử lại chốc lát";
$pgv_lang["broadcast_not_logged_6mo"]	= "Gửi bức điện cho thành viên chưa hề truy nhập trong vòng 6 tháng";
$pgv_lang["broadcast_never_logged_in"]	= "Gửi bức điện cho thành viên chưa hề truy nhập";
$pgv_lang["stats_to_show"]			= "Chọn thống kê đặng xem trong khối này";
$pgv_lang["noemail"] 				= "Địa chỉ không có thư điện tử";
?>
