<?php
/**
 * Turkish Language file for PhpGedView.
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2010  PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @author Kurt Norgaz
 * @author Adem GENÇ uzayuydu@gmail.com http://www.muttafi.com
 * @version $Id: lang.tr.php 6989 2010-11-09 03:26:25Z canajun2eh $
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

$pgv_lang["changelog"]			= "v#VERSION# sürümündeki değişiklikler";
$pgv_lang["begins_with"]		= "İle başlayan";
$pgv_lang["contains"]			= "İçerenler";
$pgv_lang["sounds_like"]		= "Gibi araştır";
$pgv_lang["others"]					= "Diğerleri";
$pgv_lang["total_changes"]			= "Toplam değişenler";
$pgv_lang["total_links"]			= "Toplam linkler";
$pgv_lang["skip_marnms"]			= "Evli isimler hariç";
$pgv_lang["show_marnms"]			= "Evli isimler dahil";

$pgv_lang["html_block_descr"]		= "Bu HTML blok PhpGedViewiniz için ziyaretçilerinize mesaj verebileceğiniz blok ve HTML kodlarını kullanabileceğiniz bir blok tur. Bu blok sayesinde ziyaretçilerinize vereceğiniz mesajı istediğiniz gibi HTML kodlarıyla şekillendirerek mesajlarınızı yayınlamanızı sağlar.";
$pgv_lang["html_block_sample_part1"]	= "<p class=\"blockhc\"><b>Başlığınızı buraya yerleştirin</b></p><br /><p>Konfigürasyon düğmesini tıkla";
$pgv_lang["html_block_sample_part2"]	= "açılacak sayfada mesajınızı yazın.</p>";
$pgv_lang["html_block_name"]		= "HTML Blok";
$pgv_lang["htmlplus_block_name"]	= "Gelişmiş HTML Blok";
$pgv_lang["htmlplus_block_descr"]	= "Bu gelişmiş HTML bloğu PhpGedViewin hazırladığı örnek kodlar ve değişkenler içerir bu örnek tablolar ve değişkenler istediklerinizi içinden alarak gelişmiş HTML bloğunda kendinize özel bloklar hazırlamanıza imkan verir.";
$pgv_lang["htmlplus_block_templates"] = "Şablonlar";
$pgv_lang["htmlplus_block_content"] = "İçerik";
$pgv_lang["htmlplus_block_narrative"] = "Soyağacı Öyküsü(Hazır ingilizce)";
$pgv_lang["htmlplus_block_custom"]	= "Özel";
$pgv_lang["htmlplus_block_keyword"]	= "Örnek istatistik(Hazır İngilizce)";
$pgv_lang["htmlplus_block_taglist"]	= "Tag Listesi";
$pgv_lang["htmlplus_block_compat"]	= "Uygunluk Modu";
$pgv_lang["htmlplus_block_current"]	= "Şimdiki";
$pgv_lang["htmlplus_block_default"]	= "Varsayılan";
$pgv_lang["htmlplus_block_gedcom"]	= "Aile Ağacı";
$pgv_lang["htmlplus_block_birth"]	= "doğum";
$pgv_lang["htmlplus_block_death"]	= "ölüm";
$pgv_lang["htmlplus_block_marrage"]	= "evlenme";
$pgv_lang["htmlplus_block_adoption"]= "evlat edinme";
$pgv_lang["htmlplus_block_burial"]	= "defin";
$pgv_lang["htmlplus_block_census"]	= "nüfüs sayımı eklendi";
$pgv_lang["num_to_show"]			= "Gösterilecek adet";
$pgv_lang["days_to_show"]			= "Kaç gelecek gün için";
$pgv_lang["before_or_after"]		= "Sayaç isimlerden önce? veya sonra?";
$pgv_lang["before"]					= "önce";
$pgv_lang["after"]					= "sonra";
$pgv_lang["config_block"]			= "Blok Konfigürasyonu";
$pgv_lang["enter_comments"]			= "Please enter your relationship to the data in the Comments field.";
$pgv_lang["comments"]				= "Çok detaylı kendinizi tanıtın:";
$pgv_lang["ahnentafel_born_m"]		= "in doğumu";
$pgv_lang["ahnentafel_born_f"]		= "in doğumu";
$pgv_lang["ahnentafel_christened_m"] = "Vaftiz edil";
$pgv_lang["ahnentafel_christened_f"] = "Vaftiz edil";
$pgv_lang["ahnentafel_report"]		= "Soy raporu";
$pgv_lang["ahnentafel_header"]		= "Soy raporu için ";
$pgv_lang["ahnentafel_generation"]	= "Nesil";
$pgv_lang["ahnentafel_pronoun_m"]	= "Bay ";
$pgv_lang["ahnentafel_pronoun_f"]	= "Bayan ";
$pgv_lang["ahnentafel_married_m"]	= "evli";
$pgv_lang["ahnentafel_married_f"]	= "evli";
$pgv_lang["ahnentafel_died_m"]		= "öldü";
$pgv_lang["ahnentafel_died_f"]		= "öldü";
$pgv_lang["ahnentafel_buried_m"]	= "gömülü";
$pgv_lang["ahnentafel_buried_f"]	= "gömülü";
$pgv_lang["ahnentafel_place"]		= " yeri ";
$pgv_lang["none"]					= "Hiç biri";
$pgv_lang["ahnentafel_no_details"]	= " Fakat bilinmeyen ayrıntılar";
$pgv_lang["descend_report"]		= "Şahsı İzleyen Nesiller Rapor";
$pgv_lang["descendancy_header"]		= "Şahsı İzleyen Nesiller Rapor için ";
$pgv_lang["child-family"]			= "Ebeveynler ve Kardeşler";
$pgv_lang["spouse-family"]			= "Hayat arkadaşı ve çocuklar";
$pgv_lang["direct-ancestors"]		= "Direk atalara doğru";
$pgv_lang["ancestors"]				= "Direk atalara doğru ve onların aileleri";
$pgv_lang["descendants"]			= "Çocuksuzlar";
$pgv_lang["choose_relatives"]		= "Yakınlık seçimi";
$pgv_lang["relatives_report"]		= "Yakınlık raporu";
$pgv_lang["total_living"]			= "Yaşayanların sayısı";
$pgv_lang["total_dead"]				= "Ölülerin sayısı";
$pgv_lang["total_not_born"]			= "Doğmamışların sayısı";
$pgv_lang["remove_custom_tags"]		= "Özel PGV etiketleri kaldır? (örnek. _PGVU, _THUM)";
$pgv_lang["cookie_login_help"]		= "Bu site bir önceki girişinizden sizi hatırladı. Bu erişim özel bilgiye, siteyi düzenlemek ve yönetmeye  izin verir ancak artırılmış güvenlik olarak tekrar giriş yapmanız gerekiyor, Lütfen Kullanıcı adınızı ve Şifrenizi girerek giriş yapın.";
$pgv_lang["remember_me"]		= "Beni bu bilgisayarda hatırla";
$pgv_lang["fams_with_surname"]		= "#Soyad# Soyad ile aileler";
$pgv_lang["support_contact"]		= "Teknik yardımı için iletişim";
$pgv_lang["genealogy_contact"]		= "Soyağacı yardımı için iletişim";
$pgv_lang["common_upload_errors"]	= "Bu hata büyük ihtimalle sizin yüklemeye çalıştığınız dosya en fazla dosya yükleme kotası aştığı anlama gelir. PHP de varsayılan dosya yükleme kotası 2MD tir. Bu değeri artırmak için sunucu firmanızla görüşerek php.ini dosya içindeki yükleme kotasını artırmasını isteyebilir, Ayrıca dosyayı FTP ile yükleyebilirsiniz. <a href=\"uploadgedcom.php?action=add_form\"><b>GEDCOM ekle</b></a>";
$pgv_lang["total_memory_usage"]		= "Topam Kullanılan Hafıza";
$pgv_lang["mothers_family_with"]	= "Anne için Aile ";
$pgv_lang["fathers_family_with"]	= "Babanın Diğer Ailesi ";
$pgv_lang["halfbrother"]			= "Üvey-Erkek Kardeş";
$pgv_lang["halfsister"]				= "Üvey-Kız Kardeş";
$pgv_lang["halfsibling"]			= "Üvey-Kardeş";
$pgv_lang["family_timeline"]		= "Zaman çizgi şemasında aileye göster";
$pgv_lang["children_timeline"]		= "Zaman çizgi şemasında çocuklara göster";
$pgv_lang["other"]			= "Çeşitli";
$pgv_lang["sort_by_marriage"]		= "Evlilik tarihi yoluyla sırala";
$pgv_lang["reorder_families"]		= "Aileleri Yeniden Sırala";
$pgv_lang["indis_with_surname"]		= "#Soyad# Soyad ile bireyseller";
$pgv_lang["first_letter_fname"]		= "Bireylerin isimlerini göstermek için isimlerin ilk harfini seçin.";
$pgv_lang["total_names"]			= "Toplam isim sayısı";
$pgv_lang["top10_pageviews_nohits"]	= "Şuan burada gösterilecek hiç bir şey yok.";
$pgv_lang["top10_pageviews_msg"]	= "Bu blok için sayaçları çalıştırmak için konfigürasyonda sayaçlar etkinlileştirilmedir.";
$pgv_lang["review_changes_block"]	= "Ilımlıdaki Değişiklikler";
$pgv_lang["review_changes_subject"]	= "PhpGedView de - Değişenleri Tekrar Görüntüle";
$pgv_lang["review_changes_body"]	= "Çevrimiçi değişiklikler, Soyağacındaki GEDCOM içinde bazı değişiklikler yapıldı, Bu değişiklikler diğer ziyaretçilere görünmeden önde yöneticinin onayı gereken değişiklik bekliyor. Aşağıdaki linki kullanarak soyağacına giriş yapıp değişikliği gözden geçirip uygun ise onaylayınız. Soyağacına Giriş için Aşağıdaki Linki Tıklayın.";
$pgv_lang["show_pending"]		= "Ilımlıdaki Değişenleri Göster";
$pgv_lang["show_spouses"]		= "Eşleri göster";
$pgv_lang["quick_update_title"]		= "Hızlı güncelleme";
$pgv_lang["quick_update_instructions"] = "Bu sayfada kişisel bilgilerinizi hızlı güncellemenize izin verir. Sadece şu anda veritabanında olan bilgilerinizi değiştirmek için veya yeni bir bilginizi girme ihtiyacı duyuyorsanız kullanın. Değişimlerinizi veya yeni bilgilerinizi gönderdikten sonra diğer üyelere gösterilmeden önce yönetici tarafından incelenip üygün görüldüğünde onaylacaktır.";
$pgv_lang["update_name"] = "İsmi Güncelle";
$pgv_lang["update_fact"]		= "Hadiseyi güncelle";
$pgv_lang["update_fact_restricted"] = "Bu gerçeğin günceleştirilmesi sınırlıdır:";
$pgv_lang["select_fact"]		= "Hadise seç...";
$pgv_lang["update_address"]		= "Adresi güncelle";
$pgv_lang["top10_pageviews_descr"]	= "Bu blok GEDCOM içinde en çok ziyaret edilen X kişilerin ziyaret edilme sayılarını yani sayaçlarını gösterir.";
$pgv_lang["top10_pageviews"]		= "En Çok Görüntülenler";
$pgv_lang["top10_pageviews_block"]		= "Ençok Görüntülenen Blok Parçaları";
$pgv_lang["stepdad"]				= "Üvey-Baba";
$pgv_lang["stepmom"]				= "Üvey-Anne";
$pgv_lang["stepsister"]				= "Üvey-Kız Kardeş";
$pgv_lang["stepbrother"]			= "Üvey-Erkek Kardeş";
$pgv_lang["fams_charts"]			= "Aile için Seçenekler";
$pgv_lang["indis_charts"]		= "Şahsi seçenekler";
$pgv_lang["locked"]					= "Değiştirme";
$pgv_lang["privacy"]				= "Mahremiyet";
$pgv_lang["number_sign"]			= "#";
$pgv_lang["review_changes_email_freq"]	= "Hatırlatıcı email frekansı (gün)";
$pgv_lang["external_objects"]		= "Dış nesneler";
$pgv_lang["gedcom_favorites_descr"] = "Bilgisine kolayca ulaşmak istediğiniz GEDCOM deki şahısları Sık Kullanılanlar ekleyerek kolayca ulaşılmasını sağlayan blok tur. Aile tarihlerinizde önemli yıl dönümlerini kaçırılmasını engeller.";
$pgv_lang["gedcom_stats_descr"] 	= "GEDCOM İstatistik Bloğu veritabanı hakkında ziyaretçilere bazı temel bilgileri gösterir.<br /><br />Ayrıca en çok olan soy adlar listesine sahiptir. Siz bu bloğun istatistik verilerin gösterim seçenekleri hakkında blok konfigürasyondan ayarlayabilirsiniz.";
$pgv_lang["stepparent"] = "Üvey Ebeveyn";
$pgv_lang["stepmom"] = "Üvey Anne";
$pgv_lang["stepdad"] = "Üvey Baba";

//-- GENERAL HELP MESSAGES
$pgv_lang["qm"]				= "?";
$pgv_lang["qm_ah"]					= "?";
$pgv_lang["page_help"]			= "Yardım";
$pgv_lang["help_for_this_page"]		= "Bu sayfa üzerine yardım";
$pgv_lang["help_contents"]		= "Yardım içeriği";
$pgv_lang["show_context_help"]		= "Yardım <img border=\"0\" src=\"images/small/help.gif\" width=\"14\" height=\"17\"> ikonu GÖSTER";
$pgv_lang["hide_context_help"]		= "Yardım <img border=\"0\" src=\"images/small/help.gif\" width=\"14\" height=\"17\"> ikonu SAKLA";
$pgv_lang["sorry"]			= "<b>Ne yazık ki bu sayfa ya da bölümün yardım mesajı daha tamamlanmamıştır</b>";
$pgv_lang["help_not_exist"]		= "<b>Ne yazık ki bu sayfanın ya da bu bölümün yardım mesajı daha işlenmemiştir</b>";
$pgv_lang["var_not_exist"]			= "<span style=font-weight: bold>Bu lisan değişkeni yok. Lütfen bu hatayı rapor edin.</span>";
$pgv_lang["resolution"]			= "Ekran çözünürlüğü";
$pgv_lang["menu"]			= "Seçenek listesi";
$pgv_lang["header"]			= "Başlık";
$pgv_lang["imageview"]				= "Resim Görüntüle";
$pgv_lang["login_head"]			= "PhpGedView üye girişi";
$pgv_lang["review_changes_email"]	= "Hatırlatıcı emailler gönder?";

//-- CONFIG FILE MESSAGES
$pgv_lang["for_support"]		= "Teknik yardım ve bilgi için danışabileceğiniz kişi:";
$pgv_lang["for_contact"]		= "Soyağacı soru yardım için danışabileceğiniz kişi:";
$pgv_lang["for_all_contact"]		= "Teknik yardım veya seçere ile ilgili sorular için danışabileceğiniz ilişki adresi:";
$pgv_lang["choose_username"]		= "Kullanıcı adı";
$pgv_lang["username"]			= "Kullanıcı Adı";
$pgv_lang["invalid_username"]		= "Kullanıcı adı içinde geçersiz harfler bulunmaktadır";
$pgv_lang["firstname"]				= "Adınız";
$pgv_lang["lastname"]				= "Soyadınız";
$pgv_lang["choose_password"]		= "Şifre";
$pgv_lang["password"]			= "Şifre";
$pgv_lang["confirm"]			= "Şifre tekrarla";
$pgv_lang["login"]			= "Giriş";
$pgv_lang["logout"]			= "Çıkış";
$pgv_lang["admin"]			= "Yönetim";
$pgv_lang["logged_in_as"]		= "Giriş kullanıcı adı";
$pgv_lang["my_pedigree"]		= "Benim soyağacım";
$pgv_lang["my_indi"]			= "Benim sayfam";
$pgv_lang["yes"]			= "Evet";
$pgv_lang["no"]				= "Hayır";
$pgv_lang["change_theme"]		= "Temayı değiştir ";

//-- INDEX (PEDIGREE_TREE) FILE MESSAGES
$pgv_lang["index_header"]		= "Soyağacı Ağaç Çizelgesi";
$pgv_lang["gen_ped_chart"]		= "#PEDIGREE_GENERATIONS# nesil - Soyağacı Ağaç Çizge görüntüsü";
$pgv_lang["generations"]		= "Gösterilecek nesil sayısı";
$pgv_lang["view"]			= "Göster";
$pgv_lang["fam_spouse"]			= "Eş ve aile";
$pgv_lang["root_person"]		= "Kök şahıs numarası";
$pgv_lang["hide_details"]		= "Detayları sakla";
$pgv_lang["show_details"]		= "Detayları göster";
$pgv_lang["person_links"]		= "Bu şahsın Çizgelerine, ailesine ve yakın akrabalarına ulaşan bağlantılar. Bu simgeye tıklayıp şahıs ile ilgili sayfaları izleyin.";
$pgv_lang["zoom_box"]			= "Bu kutuyu genişlet/daralt";
$pgv_lang["orientation"]			= "Yönlendirme";
$pgv_lang["portrait"]			= "Düşey";
$pgv_lang["landscape"]			= "Yatay";
$pgv_lang["start_at_parents"]		= "Anne ve baba ile başla";
$pgv_lang["charts"]			= "Çizgeler";
$pgv_lang["lists"]			= "Listeler";
$pgv_lang["welcome_page"]		= "Karşılama sayfası";


$pgv_lang["box_width"]			= "Kutu eni";

//-- FUNCTIONS FILE MESSAGES
$pgv_lang["unable_to_find_family"]	= "Bu numaraya bağlı aile bulunamadı";
$pgv_lang["unable_to_find_record"]	= "Bu numaraya bağlı kayıt bulunamadı";
$pgv_lang["title"]			= "Başlık";
$pgv_lang["living"]			= "Yaşıyor";
$pgv_lang["private"]			= "Özel";
$pgv_lang["birth"]			= "Doğum:";
$pgv_lang["death"]			= "Vefat:";
$pgv_lang["descend_chart"]		= "Şahsı İzleyen Nesiller Çizelgesi";
$pgv_lang["individual_list"]		= "Şahıs listesi";
$pgv_lang["family_list"]		= "Aile listesi";
$pgv_lang["source_list"]		= "Kaynak listesi";
$pgv_lang["place_list"]			= "Yer listesi";
$pgv_lang["place_list_aft"] 		= "Sonradan Hiyerarşiyi Yerleştirin";
$pgv_lang["media_list"]			= "Medya listesi";
$pgv_lang["search"]			= "Arama";
$pgv_lang["search_general"]			= "Genel Arama";
$pgv_lang["chart_new"]				= "Aile Ağacı Grafiği";
$pgv_lang["loading"]				= "Yükleniyor...";
$pgv_lang["clear_chart"]			= "Grafiği Temizle";
$pgv_lang["file_information"]		= "Dosya Bilgisi";
$pgv_lang["choose_file_type"]		= "Dosya Tipini Seç";
$pgv_lang["add_individual_by_id"]		= "Bireysel Kişi ID Ekle";
$pgv_lang["advanced_options"]		= "Gelişmiş Seçenekler";
$pgv_lang["zip_files"]				= "Zip Dosyası";
$pgv_lang["include_media"]			= "Medyaları içer (otomatikman zip dosyasına)";
$pgv_lang["clipping_privacy"]		= "Bazı maddeler gizlilik kısıtlamalarından dolayı eklenemezler";
$pgv_lang["search_soundex"]			= "Soundex Ara";
$pgv_lang["search_replace"]			= "Ara ve Değiştir";
$pgv_lang["search_inrecs"]			= "Aranacak";
$pgv_lang["search_fams"]			= "Aileler";
$pgv_lang["search_indis"]			= "Kişiseller";
$pgv_lang["search_sources"]			= "Kaynaklar";
$pgv_lang["search_more_chars"]      = "Lütfen bir karakterden fazla girin";
$pgv_lang["search_soundextype"]		= "Tam metin tipi:";
$pgv_lang["search_russell"]			= "Temel";
$pgv_lang["search_prtnames"]		= "Kişiseller'<br />yazdırma isimleri:";
$pgv_lang["search_prthit"]			= "Hit ile isimler";
$pgv_lang["results_per_page"]		= "Sayfadaki sonuçlar";
$pgv_lang["search_prtall"]			= "Tüm isimler";
$pgv_lang["search_tagfilter"]		= "Filtre Hariç";
$pgv_lang["search_tagfon"]			= "Buraya özel olmayan soyağacı bilgiyi hariç et";
$pgv_lang["search_tagfoff"]			= "Kapalı";
$pgv_lang["associate"]				= "birleşik";
$pgv_lang["search_record"]			= "Bütün kayıt";
$pgv_lang["search_to"]				= "den";
$pgv_lang["search_asso_label"]		= "Birleşikler";
$pgv_lang["search_asso_text"]		= "Kişiseller/Aileler ilişkili göster";
$pgv_lang["clippings_cart"]		= "Aile Ağacı Kupürü Taşımak";
$pgv_lang["print_preview"]		= "Baskı ön izleme";
$pgv_lang["cancel_preview"]		= "Normal görüntüye geri dön";
$pgv_lang["change_lang"]		= "Dil seçimi";
$pgv_lang["print"]			= "Yazdır";
$pgv_lang["total_queries"]		= "Veritabanı sorgu sayısı: ";
$pgv_lang["total_privacy_checks"]	= "Toplam denetlenen mahremiyetler: ";
$pgv_lang["back"]			= "geri dön";
$pgv_lang["aka"]			= "Tanındığı diğer isimler";

//-- INDIVIDUAL FILE MESSAGES
$pgv_lang["male"]			= "erkek";
$pgv_lang["female"]			= "Bayan";
$pgv_lang["temple"]			= "LDS Temple";
$pgv_lang["temple_code"]		= "LDS Temple kodu:";
$pgv_lang["status"]			= "Durumu";
$pgv_lang["source"]			= "Kaynak";
$pgv_lang["text"]			= "Kaynak metin:";
$pgv_lang["note"]			= "Not";
$pgv_lang["NN"]				= "Soy isimsiz";
$pgv_lang["PN"]				= "İsimsiz";
$pgv_lang["unrecognized_code"]		= "Tanınmayan GEDCOM kodu";
$pgv_lang["unrecognized_code_msg"]	= "Bu düzeltmek istediğimiz bir hatadır. Bu hatayı lütfen bu adrese bildirin:";
$pgv_lang["indi_info"]			= "Kişisel bilgi";
$pgv_lang["pedigree_chart"]		= "Soyağacı Ağaç Çizelgesi";
$pgv_lang["individual"]				= "Kişisel";
$pgv_lang["family"]			= "Aile";
$pgv_lang["family_with"]			= "Ailesiyle";
$pgv_lang["as_spouse"]			= "Eşiyle Aile Tablosu";
$pgv_lang["as_child"]			= "Ebeveynlerle Aile Tablosu";
$pgv_lang["view_gedcom"]		= "GEDCOM kayıdını göster";
$pgv_lang["add_to_cart"]		= "Kupürleri Taşımaya Ekle";
$pgv_lang["privacy_error"]		= "Bu şahısın detayları şahsidir.<br />Ayrıntılı bilgi için bu adres ile temasa geçin:";
$pgv_lang["more_information"]		= "Ayrıntılı bilgi için danışabileceğiniz ilişki adresi:";
$pgv_lang["name"]			= "İsim";
$pgv_lang["given_name"]			= "İsim:";
$pgv_lang["surname"]			= "Soy isim:";
$pgv_lang["suffix"]			= "Ek isim:";
$pgv_lang["sex"]			= "Cinsiyet";
$pgv_lang["personal_facts"]		= "Kişisel bilgiler ve detaylar";
$pgv_lang["type"]			= "Tip";
$pgv_lang["parents"]			= "Anne ve baba:";
$pgv_lang["siblings"] 			= "Kardeşleri";
$pgv_lang["father"]			= "Baba";
$pgv_lang["mother"]			= "Anne";
$pgv_lang["parent"] 				= "Ebeveyn";
$pgv_lang["self"] 					= "Kendi";
$pgv_lang["relatives"]			= "Yakın akrabalar";
$pgv_lang["relatives_events"]		= "Yakın akrabaların hadiseleri";
$pgv_lang["historical_facts"]		= "Tarihsel gerçekler";
$pgv_lang["partner"] 				= "Ortak";
$pgv_lang["child"]			= "Çocuk";
$pgv_lang["surnames"]			= "Soy isimleri";
$pgv_lang["adopted"]			= "Evlatlık edinme";
$pgv_lang["foster"]			= "Babalık / Analık";
$pgv_lang["sealing"]				= "Mühürle";
$pgv_lang["challenged"]				= "Meydan oku";
$pgv_lang["disproved"]				= "Doğru olmadığını kanıtla";
$pgv_lang["infant"]					= "Bebek";
$pgv_lang["stillborn"]				= "Ölü doğan";
$pgv_lang["deceased"]				= "Merhum";
$pgv_lang["link_as_wife"]			= "Var olan bir aileye bu kişiyi hanımı olarak bağla";
$pgv_lang["no_tab1"]				= "Bu şahıs ile ilgili hiç bir hadise bulunmamaktadır.";
$pgv_lang["no_tab2"]				= "Bu şahıs ile ilgili hiç bir not bulunmamaktadır.";
$pgv_lang["no_tab3"]				= "Bu kişisel için hiç kaynak davetleri yoktur.";
$pgv_lang["no_tab4"]				= "Bu şahıs ile ilgili hiç bir multimedya nesnesi bulunmamaktadır.";
$pgv_lang["no_tab5"]				= "Bu şahıs ile ilgili hiç bir yakın akraba bulunmamaktadır.";
$pgv_lang["no_tab6"]				= "Bu kişisele bağlı hiç araştırma kütüğü yoktur.";
$pgv_lang["show_fact_sources"]		= "Tüm kaynakları göster";
$pgv_lang["show_fact_notes"]		= "Tüm notları göster";
$pgv_lang["spouse"]			= "Eşi";
$pgv_lang["spouses"] 				= "Eşleri";

//-- FAMILY FILE MESSAGES
$pgv_lang["family_info"]		= "Aile bilgisi";
$pgv_lang["family_group_info"]		= "Aile gurubu üzerine bilgi";
$pgv_lang["husband"]			= "Koca";
$pgv_lang["wife"]			= "Hanım";
$pgv_lang["marriage"]			= "Evlilik:";
$pgv_lang["lds_sealing"]			= "LDS Mühürle:";
$pgv_lang["marriage_license"]		= "Evlilik izini:";
$pgv_lang["children"]			= "Çocuklar";
$pgv_lang["no_children"]		= "Kayıt edilmiş çocuk yok";
$pgv_lang["childless_family"]		= "Bu aile çocuksuz kaldı";
$pgv_lang["parents_timeline"]		= "Çifti zaman çizgisinde göster";

//-- CLIPPINGS FILE MESSAGES
$pgv_lang["clip_cart"]			= "Kupürleri Taşımak";
$pgv_lang["which_links"]		= "Bu aile ile ilgili hangi bağlantıyı eklemek istiyorsunuz?";
$pgv_lang["just_family"]		= "Sadece bu aile kayıdını ekle.";
$pgv_lang["parents_and_family"]		= "Anne ve babayı bu aile kayıtı ile ekle.";
$pgv_lang["parents_and_child"]		= "Bu şahsı, annesini, babasını ve çocuklarını ekle.";
$pgv_lang["parents_desc"]		= "Bu şahsı, annesini, babasını ve onu izleyen tüm şahısları ekleyin.";
$pgv_lang["continue"]			= "Eklemeye devam et";
$pgv_lang["which_p_links"]		= "Bu şahısla ilgili hangi bağlantıyı eklemek istiyorsunuz?";
$pgv_lang["just_person"]		= "Bu şahsı ekle.";
$pgv_lang["person_parents_sibs"]	= "Bu şahsı, annesini, babasını ve kardeşlerini ekle.";
$pgv_lang["person_ancestors"]		= "Bu şahsı ve direk öncelerini ekle.";
$pgv_lang["person_ancestor_fams"]	= "Bu şahsı, direk öncelerini ve ailesini ekle.";
$pgv_lang["person_spouse"]		= "Bu şahsı, eşlerini ve çocuklarını ekle.";
$pgv_lang["person_desc"]		= "Bu şahsı, eşlerini ve onu izleyen tüm şahısları ekle.";
$pgv_lang["which_s_links"]			= "Bu kaynağın eklenmesi için hangı kayıda bağlansın?";
$pgv_lang["just_source"]		= "Şimdi bu kaynağı ekle.";
$pgv_lang["linked_source"]		= "Bu kaynağı ekle ve kişi/aileleri ona bağlanır.";
$pgv_lang["person_private"]		= "Bu şahısın detayları şahsidir. Kişisel detaylar eklenmeyecektir.";
$pgv_lang["family_private"]		= "Bu ailenin detayları şahsidir. Kişisel detaylar eklenmeyecektir.";
$pgv_lang["download"]			= "Yeni yaratılmış GEDCOM dosyasını yerel bilgisayarınıza indirebilmek için aşağıdaki bağlantıya farenin sağ tuşu ile basıp (MAC te Control-Click) \"Hedefi Farklı Kaydet...\" emrini seçin.";
$pgv_lang["cart_is_empty"]		= "Kupür Taşıma Alanı Boştur";
$pgv_lang["id"]				= "ID";
$pgv_lang["name_description"]		= "İsim / Tanım";
$pgv_lang["remove"]			= "Kaldır";
$pgv_lang["empty_cart"]			= "Kupür Taşıma Alanı Boşalt";
$pgv_lang["download_now"]		= "Şimdi indir";
$pgv_lang["download_file"]			= "Dosya indir #GLOBALS[whichFile]#";
$pgv_lang["indi_downloaded_from"]	= "Şahısın bilgileri buradan indirildi:";
$pgv_lang["family_downloaded_from"]	= "Ailenin bilgileri buradan indirildi:";
$pgv_lang["source_downloaded_from"]	= "Kaynağın bilgileri buradan indirildi:";

//-- PLACELIST FILE MESSAGES
$pgv_lang["connections"]		= "Yer bağlantısı bulundu<br />Şimdi sonuçlara bak";
$pgv_lang["top_level"]			= "geri dön";
$pgv_lang["form"]			= "Yerlerin sıralanma şekli:";
$pgv_lang["default_form"]		= "Kasaba, İlçe, İl, Ülke";
$pgv_lang["default_form_info"]		= "(Varsayılan / Default)";
$pgv_lang["unknown"]			= "Bilinmeyen";
$pgv_lang["individuals"]		= "Şahıslar";
$pgv_lang["view_records_in_place"]	= "Bu yer ile ilgili tüm kayıtları göster";
$pgv_lang["place_list2"]		= "Yer listesi";
$pgv_lang["show_place_hierarchy"]	= "Hiyerarşide Yerleştirileni Göster";
$pgv_lang["show_place_list"]		= "Tüm yerleri tek liste halinde göster";
$pgv_lang["total_unic_places"]		= "Toplam Tek Yerleşenler";

//-- MEDIALIST FILE MESSAGES
$pgv_lang["multi_title"]		= "Multimedya nesne listesi";
$pgv_lang["media_found"]		= "multimedya nesnesi bulundu";
$pgv_lang["view_person"]		= "Şahsı göster";
$pgv_lang["view_family"]		= "Aileyi göster";
$pgv_lang["view_source"]		= "Kaynağı göster";
$pgv_lang["view_object"]			= "Nesneyi Görüntüle";
$pgv_lang["prev"]			= "&lt; bir sayfa geri dön";
$pgv_lang["next"]			= "bir sayfa ilerle &gt;";
$pgv_lang["next_image"]				= "Sonraki Resim";
$pgv_lang["file_not_found"]		= "Dosya bulunamadı";
$pgv_lang["medialist_show"] 		= "Medya Listeyi Göster";
$pgv_lang["per_page"]			= "sayfadaki nesne sayısı";
$pgv_lang["current_dir"]			= "Geçerli dizin";
$pgv_lang["SHOW_ID_NUMBERS"]		= "Üyelerin GEDCOM Numaraları Göster";
$pgv_lang["SHOW_HIGHLIGHT_IMAGES"]	= "Şahısların kutularında resimleri göster";
$pgv_lang["view_img_details"]		= "Resim detaylarını görüntüle";

//-- SEARCH FILE MESSAGES
$pgv_lang["search_gedcom"]		= "GEDCOM dosyası içinde arama";
$pgv_lang["enter_terms"]		= "Aranacak Terim";
$pgv_lang["soundex_search"]		= "- Ya da isimin yazıldığını düşündüğünüz şekilde arayın (Tam metin):";
$pgv_lang["sources"]			= "Kaynaklar";
$pgv_lang["firstname_search"]		= "İsim";
$pgv_lang["lastname_search"]		= "Soy isim";
$pgv_lang["search_place"]		= "Yer";
$pgv_lang["search_year"]		= "Sene";
$pgv_lang["no_results"]			= "Hiçbir sonuç bulunmadı.";
$pgv_lang["invalid_search_input"]	= "Lütfen sene ile beraber bir isim, soy isim ya da bir yerin ismini ekleyin";
$pgv_lang["search_geds"]			= "GEDCOM larin içinde ara";

//-- SOURCELIST FILE MESSAGES

$pgv_lang["titles_found"]			= "Başlıklar";
$pgv_lang["find_source"]			= "Kaynak Bul";

//-- REPOLIST FILE MESSAGES
$pgv_lang["repo_list"]			= "Veri havuzu listesi";
$pgv_lang["repos_found"]		= "Veri havuzları bulundu";
$pgv_lang["find_repository"]		= "Veri Tabanı Tablosunu Bul";
$pgv_lang["total_repositories"]		= "Toplam Veri Havuzları";
$pgv_lang["repo_info"]				= "Veri Tabanı Tablı Bilgisi";
$pgv_lang["other_repo_records"]		= "Bu veri tabanı tablo link kayıtları:";
$pgv_lang["confirm_delete_repo"]	= "Databaseden bu veri tabanı tablosunu silmek istediğinizden emin misini?";


//-- SOURCE FILE MESSAGES
$pgv_lang["source_info"]		= "Kaynak bilgisi";
$pgv_lang["other_records"]		= "Bu kaynakla ilişkide olan diğer kayıtlar:";
$pgv_lang["people"]			= "Şahıslar";
$pgv_lang["families"]			= "Aileler";
$pgv_lang["total_sources"]		= "Toplam kaynak sayısı";

//-- BUILDINDEX FILE MESSAGES
$pgv_lang["invalid_gedformat"]		= "Hatalı GEDCOM 5.5 biçimi";
$pgv_lang["exec_time"]			= "Toplam işletim süresi:";
$pgv_lang["unable_to_create_index"]	= "İndeks dosyasını yenileyemedim. PhpGedView dizinine yazma izninizin olup olmadığını denetleyin. İzinler indeks dosyalarının yaratılmasından sonra eski duruma geri getirilebilinir.";
$pgv_lang["changes_present"]		= "Geçerli GEDCOM da değişiklikler olmuştur incelemeniz için askıya alınmıştır. Eğer bu içeri aktarıma devam ederseniz buradaki değişiklikler veritabanına gönderip uygulanacaktır. İçeri aktarıma devam etmeden bu değişiklikleri incelemelisiniz.";
$pgv_lang["sec"]			= "saniye.";

//-- INDIVIDUAL AND FAMILYLIST FILE MESSAGES
$pgv_lang["total_fams"]			= "Toplam aile sayısı";
$pgv_lang["total_indis"]		= "Toplam şahıs sayısı";
$pgv_lang["notes"]			= "Notlar";
$pgv_lang["ssourcess"]			= "Kaynaklar";
$pgv_lang["media"]			= "Multimedya";
$pgv_lang["name_contains"]		= "Aranacak İsim:";
$pgv_lang["filter"]			= "Ara";
$pgv_lang["find_sourceid"]		= "Kaynak no'sunu ara";
$pgv_lang["find_specialchar"]		= "Özel Karakterler";
$pgv_lang["magnify"]				= "Büyüt";
$pgv_lang["find_individual"]		= "Şahıs arama listesi";
$pgv_lang["find_familyid"]		= "Aile numarasını ara";
$pgv_lang["skip_surnames"]		= "Soyadı Listeleri Atla";
$pgv_lang["show_surnames"]		= "Soyadı listeleri göster";
$pgv_lang["all"]			= "HEPSİ";
$pgv_lang["hidden"]			= "Saklı";
$pgv_lang["confidential"]		= "Özel";
$pgv_lang["alpha_index"]				= "Alfabetik İndex";
$pgv_lang["name_list"] 				= "İsim Listesi";
$pgv_lang["firstname_alpha_index"] 	= "İlk Ad Alfabetik İndex";
$pgv_lang["roots"]		 				= "Kökler";
$pgv_lang["leaves"] 					= "Ayrılmalar";
$pgv_lang["widow"] 					= "Dul bayan";
$pgv_lang["widower"] 				= "Dul erkek";

//-- TIMELINE FILE MESSAGES
$pgv_lang["age"]			= "Yaş";
$pgv_lang["days"]					= "Gün";
$pgv_lang["months"]					= "Ay";
$pgv_lang["years"]					= "Yıl";
$pgv_lang["day1"]					= "Gün";
$pgv_lang["month1"]					= "Ay";
$pgv_lang["year1"]					= "Yıl";
$pgv_lang["after_death"]        ="ölümden sonra";
$pgv_lang["timeline_title"]		= "PhpGedView zaman çizgisi";
$pgv_lang["timeline_chart"]		= "Zaman içinde çizge";
$pgv_lang["remove_person"]		= "Şahsı sil";
$pgv_lang["show_age"]			= "Yaşını göster";
$pgv_lang["add_another"]		= "Yeni bir şahsı çizgeye ekle:<br />Şahıs numarası:";
$pgv_lang["find_id"]			= "GEDCOM Numara ID Ara";
$pgv_lang["show"]			= "Göster";
$pgv_lang["year"]			= "Sene:";
$pgv_lang["timeline_instructions"]	= "Yeni tarayıcıların çoğunda tıklayarak veyahut kutuları çekerek görüntünün bir yerinden diğerine yerleştirebilirsiniz.";
$pgv_lang["zoom_out"]			= "Görüntüyü küçült";
$pgv_lang["timeline_beginYear"] = "Başlama Yaşı";
$pgv_lang["timeline_endYear"] = "Bitirme Yaşı";
$pgv_lang["timeline_scrollSpeed"] = "Hız";
$pgv_lang["timeline_controls"] = "Zaman yolu Kontrolleri";
$pgv_lang["include_family"] = "Acil Aileyi İçer";
$pgv_lang["lifespan_chart"] = "Ömür Çizelgesi";
$pgv_lang["cal_none"]                 = "Takvim dönüştürme hayır";
$pgv_lang["cal_french"]               = "Fransız";
$pgv_lang["cal_arabic"]               = "Arap";
$pgv_lang["christmas"]  = "Noel";
$pgv_lang["zoom_in"]			= "Görüntüyü büyüt";

//-- MONTH NAMES
$pgv_lang["jan"]			= "Ocak";
$pgv_lang["feb"]			= "Şubat";
$pgv_lang["mar"]			= "Mart";
$pgv_lang["apr"]			= "Nisan";
$pgv_lang["may"]			= "Mayıs";
$pgv_lang["jun"]			= "Haziran";
$pgv_lang["jul"]			= "Temmuz";
$pgv_lang["aug"]			= "Ağustos";
$pgv_lang["sep"]			= "Eylül";
$pgv_lang["oct"]			= "Ekim";
$pgv_lang["nov"]			= "Kasım";
$pgv_lang["dec"]			= "Aralık";
$pgv_lang["safar"]        = "2. Safer Ay";
$pgv_lang["ramad"]        = "9. Ramazan Ay";
$pgv_lang["abt"]			= "civarında";
$pgv_lang["aft"]			= "'#EXT# sonra";
$pgv_lang["and"]			= "ve";
$pgv_lang["bef"]			= "'#EXT# önce";
$pgv_lang["bet"]			= "arasında";
$pgv_lang["cal"]			= "hesaplandı";
$pgv_lang["est"]			= "varsayım";
$pgv_lang["from"]			= "Ebeveyni";
$pgv_lang["int"]			= "herhalde";
$pgv_lang["to"]				= "'#EXT# kadar";
$pgv_lang["apx"]			= "takriben";
$pgv_lang["cir"]			= "dolaylarında";

//-- Admin File Messages
$pgv_lang["user_admin"]			= "Kullanıcı Yönetimi";
$pgv_lang["password_mismatch"]		= "Şifreler birbirine uymuyor.";
$pgv_lang["enter_username"]		= " Bir kullanıcı adı girmelisiniz.";
$pgv_lang["enter_fullname"]		= "Bir ad ve soyadı girmelisiniz.";
$pgv_lang["enter_password"]		= "Bir şifre girmeniz gerekir.";
$pgv_lang["confirm_password"]		= "Bu şifre doğrulamalısınız.";
$pgv_lang["save"]			= "Kaydet";
$pgv_lang["saveandgo"]		= "Yeni kayıdı kaydet ve git";
$pgv_lang["delete"]			= "Sil";
$pgv_lang["edit"]			= "Düzenle";
$pgv_lang["no_login"]			= "İlettiğiniz kullanıcı adı ya da şifre tasdik edilemedi :-(";
$pgv_lang["basic_realm"]			= "PhpGedView Kanıtlama Sistemi";
$pgv_lang["basic_auth_failure"]		= "Bir geçerli giriş ID bilgisi ve bu kaynağa erişmek için parolaya girmelisiniz";
$pgv_lang["basic_auth"]				= "Temel Kanıtlama";
$pgv_lang["digest_auth"]				= "Kanıtlamayı Kabullen";
$pgv_lang["no_auth_needed"]			= "Kanıtlama yok";
$pgv_lang["duplicate_username"]		= "Çifte kullanıcı adı. Siteye bu kullanıcı adı ile başka bir üye kayıtlıdır. Lütfen geri dönüp başka bir kullanıcı adı seçiniz.";
$pgv_lang["cache_life"]				= "Dosya önbellek süresi";
$pgv_lang["genealogy"]					= "soyağacı";
$pgv_lang["activate"]					= "Aktif";
$pgv_lang["deactivate"]					= "Aktif değil";
$pgv_lang["play"]					= "Slayt başlat";
$pgv_lang["stop"]					= "Slayt durdur";
$pgv_lang["random_media_start_slide"]	= "Otomatik Slayt gösterimi başlat?";
$pgv_lang["random_media_ajax_controls"]	= "Slayt başlatma ve Sonraki resim kontrol ikonları göster?";
$pgv_lang["research_assistant"]		= "Araştırma Asıstanı";
$pgv_lang["file_not_exists"]		= "İstenilen isimli dosya mevcut değil.";
$pgv_lang["utf8_to_ansi"]		= "GEDCOM veritabanı UTF-8 den ANSI (ISO-8859-1) e dönüştür";

//-- Relationship chart messages
$pgv_lang["relationship_chart"]		= "Yakınlık Çizelgesi";
$pgv_lang["person1"]			= "1. şahıs";
$pgv_lang["person2"]			= "2. şahıs";
$pgv_lang["no_link_found"]		= "İki şahıs arasında hiç bir bağlantı bulunamadı";
$pgv_lang["sibling"]			= "Kardeş";
$pgv_lang["follow_spouse"]		= "Evlilik ile gelişen akrabalılığı araştır";
$pgv_lang["timeout_error"]		= "Bu scriptte hiçbir yakınlık bağlantısı bulamadan sona erdi!!!";
$pgv_lang["son"]			= "Erkek çocuk";
$pgv_lang["daughter"]			= "Kız çocuk";


$pgv_lang["grandchild"]				= "Torun";
$pgv_lang["grandson"]				= "Erkek torun";
$pgv_lang["granddaughter"]			= "Kız torun";
$pgv_lang["greatgrandchild"]		= "Büyük torun";
$pgv_lang["greatgrandson"]			= "Büyük erkek torun";
$pgv_lang["greatgranddaughter"]		= "Büyük kız torun";
$pgv_lang["brother"]			= "Erkek kardeş";
$pgv_lang["sister"]			= "Kız kardeş";


$pgv_lang["aunt"]					= "Yenge";
$pgv_lang["uncle"]				= "Amca";
$pgv_lang["nephew"]				= "Erkek yeğen";
$pgv_lang["niece"]				= "Kız yeğen";
$pgv_lang["firstcousin"]			= "İlk kuzen";
$pgv_lang["femalecousin"]			= "Bayan kuzen";
$pgv_lang["malecousin"]				= "Erkek kuzen";

$pgv_lang["relationship_to_me"]		= "Benimle olan yakınlığı";
$pgv_lang["rela_husb"]				= "Kocaya ilişki";
$pgv_lang["rela_wife"]				= "Hanıma ilişki";
$pgv_lang["next_path"]				= "Diğer seçeneği bul";
$pgv_lang["show_path"]				= "Diğer Seçenek";
$pgv_lang["line_up_generations"]	= "Ayni kuşaktan olan şahısları bir seviyede göster";
$pgv_lang["oldest_top"]			= "En yaşlıları üstte göster";
$pgv_lang["relationship_male_1_is_the_2_of_3"] = "%3\$s 'in %2\$s 'i   %1\$s";
$pgv_lang["relationship_female_1_is_the_2_of_3"] = "%3\$s 'in %2\$s 'i   %1\$s";
$pgv_lang["mother_in_law"]		    = "Kaynana";
$pgv_lang["father_in_law"]		    = "Kayınpeder";
$pgv_lang["brother_in_law"]		    = "Enişte";
$pgv_lang["sister_in_law"]		    = "Yenge";
$pgv_lang["son_in_law"]		        = "Damat";
$pgv_lang["daughter_in_law"]		= "Gelini";
$pgv_lang["step_son"]		        = "Üvey erkek";
$pgv_lang["step_daughter"]	    	= "Üvey kız";
$pgv_lang["bosa_brothers_offspring_2"] 				= "Erkek yeğen";
$pgv_lang["bosa_brothers_offspring_3"] 				= "Kız yeğen";
$pgv_lang["bosa_brothers_offspring_4"] 				= "büyük erkek yeğen";
$pgv_lang["bosa_brothers_offspring_5"] 				= "büyük kız yeğen";
$pgv_lang["bosa_brothers_offspring_6"] 				= "büyük erkek yeğen";
$pgv_lang["bosa_brothers_offspring_7"] 				= "büyük kız yeğen";
$pgv_lang["n_x_brothers_son"]	  = "%2\$d x büyük erkek yeğen";
$pgv_lang["n_x_brothers_daughter"] = "%2\$d x büyük kız yeğen";
$pgv_lang["bosa_sisters_offspring_2"] 				= "erkek yeğen";
$pgv_lang["bosa_sisters_offspring_3"] 				= "kız yeğen";
$pgv_lang["bosa_sisters_offspring_4"] 				= "büyük erkek yeğen";
$pgv_lang["bosa_sisters_offspring_5"] 				= "büyük kız yeğen";
$pgv_lang["bosa_sisters_offspring_6"] 				= "büyük erkek yeğen";
$pgv_lang["bosa_sisters_offspring_7"] 				= "büyük kız yeğen";
$pgv_lang["n_x_sisters_son"]	  = "%2\$d x büyük erkek yeğen";
$pgv_lang["n_x_sisters_daughter"] = "%2\$d x büyük kız yeğen";
$pgv_lang["bosa_2"] 				= "erkek çocuk";
$pgv_lang["bosa_3"] 				= "kız çocuk";
$pgv_lang["bosa_4"] 				= "erkek torun";
$pgv_lang["bosa_5"] 				= "kız torun";
$pgv_lang["bosa_6"] 				= "erkek torun";
$pgv_lang["bosa_7"] 				= "kız torun";
$pgv_lang["bosa_8"] 				= "büyük erkek torun";
$pgv_lang["bosa_9"] 				= "büyük kız torun";
$pgv_lang["bosa_10"] 				= "büyük erkek torun";
$pgv_lang["bosa_11"] 				= "büyük kız torun";
$pgv_lang["bosa_12"] 				= "büyük erkek torun";
$pgv_lang["bosa_13"] 				= "büyük kız torun";
$pgv_lang["bosa_14"] 				= "büyük erkek torun";
$pgv_lang["bosa_15"] 				= "büyük kız torun";
$pgv_lang["n_x_grandson_from_son"]	  = "%3\$d x büyük erkek torun";
$pgv_lang["n_x_granddaughter_from_son"] = "%3\$d x büyük kız torun";
$pgv_lang["n_x_grandson_from_daughter"]	  = "%3\$d x büyük erkek torun";
$pgv_lang["n_x_granddaughter_from_daughter"] = "%3\$d x büyük kız torun";
$pgv_lang["sosa_uncle_2"] 				= "Amca";
$pgv_lang["sosa_uncle_3"] 				= "Dayı";
$pgv_lang["sosa_uncle_4"] 				= "büyük amca";
$pgv_lang["sosa_uncle_5"] 				= "büyük amca";
$pgv_lang["sosa_uncle_6"] 				= "büyük amca";
$pgv_lang["sosa_uncle_7"] 				= "büyük amca";
$pgv_lang["n_x_paternal_uncle"]		= "%2\$d x büyük amca";
$pgv_lang["n_x_maternal_uncle"]	    = "%2\$d x büyük amca";
$pgv_lang["sosa_aunt_2"] 				= "hala";
$pgv_lang["sosa_aunt_3"] 				= "teyze";
$pgv_lang["sosa_aunt_4"] 				= "büyük teyze";
$pgv_lang["sosa_aunt_5"] 				= "büyük teyze";
$pgv_lang["sosa_aunt_6"] 				= "büyük teyze";
$pgv_lang["sosa_aunt_7"] 				= "büyük teyze";
$pgv_lang["n_x_paternal_aunt"]		= "%2\$d x büyük teyze";
$pgv_lang["n_x_maternal_aunt"]	    = "%2\$d x büyük teyze";
$pgv_lang["sosa_uncle_bm_2"] 				= "amca";
$pgv_lang["sosa_uncle_bm_3"] 				= "amca";
$pgv_lang["sosa_uncle_bm_4"] 				= "büyük amca";
$pgv_lang["sosa_uncle_bm_5"] 				= "büyük amca";
$pgv_lang["sosa_uncle_bm_6"] 				= "büyük amca";
$pgv_lang["sosa_uncle_bm_7"] 				= "büyük amca";
$pgv_lang["n_x_paternal_uncle_bm"]		= "%2\$d x büyük amca";
$pgv_lang["n_x_maternal_uncle_bm"]	    = "%2\$d x büyük amca";
$pgv_lang["sosa_aunt_bm_2"] 				= "teyze";
$pgv_lang["sosa_aunt_bm_3"] 				= "teyze";
$pgv_lang["sosa_aunt_bm_4"] 				= "büyük teyze";
$pgv_lang["sosa_aunt_bm_5"] 				= "büyük teyze";
$pgv_lang["sosa_aunt_bm_6"] 				= "büyük teyze";
$pgv_lang["sosa_aunt_bm_7"] 				= "büyük teyze";
$pgv_lang["n_x_paternal_aunt_bm"]		= "%2\$d x büyük teyze";
$pgv_lang["n_x_maternal_aunt_bm"]	    = "%2\$d x büyük teyze";
$pgv_lang["male_cousin_1"]              = "ilk kuzen";
$pgv_lang["male_cousin_2"]              = "ikinci kuzen";
$pgv_lang["male_cousin_3"]              = "üçüncü kuzen";
$pgv_lang["male_cousin_4"]              = "dördüncü kuzen";
$pgv_lang["male_cousin_5"]              = "beşinci kuzen";
$pgv_lang["male_cousin_6"]              = "altıncı kuzen";
$pgv_lang["male_cousin_7"]              = "yedinci kuzen";
$pgv_lang["male_cousin_8"]              = "sekizinci kuzen";
$pgv_lang["male_cousin_9"]              = "dokuzuncu kuzen";
$pgv_lang["male_cousin_10"]             = "onuncu kuzen";
$pgv_lang["male_cousin_11"]             = "onbirinci kuzen";
$pgv_lang["male_cousin_12"]             = "onikinci kuzen";
$pgv_lang["male_cousin_13"]             = "onüçüncü kuzen";
$pgv_lang["male_cousin_14"]             = "ondördüncü kuzen";
$pgv_lang["male_cousin_15"]             = "onbeşinci kuzen";
$pgv_lang["male_cousin_16"]             = "onaltıncı kuzen";
$pgv_lang["male_cousin_17"]             = "onyedinci kuzen";
$pgv_lang["male_cousin_18"]             = "onsekizinci kuzen";
$pgv_lang["male_cousin_19"]             = "ondokuzuncu kuzen";
$pgv_lang["male_cousin_20"]             = "yirminci kuzen";
$pgv_lang["male_cousin_n"]              = "%d x kuzen";
$pgv_lang["female_cousin_1"]            = "ilk kuzen";
$pgv_lang["female_cousin_20"]           = "yirminci kuzen";
$pgv_lang["female_cousin_n"]            = "%d x kuzen";
$pgv_lang["removed_ascending_1"]   = "birkez yeniden-eskiye kaldırıldı";
$pgv_lang["removed_ascending_2"]   = "ikikez yeniden-eskiye kaldırıldı";
$pgv_lang["removed_ascending_3"]   = "üç zaman yeniden-eskiye kaldırıldı";
$pgv_lang["removed_ascending_4"]   = "dört zaman yeniden-eskiye kaldırıldı";
$pgv_lang["removed_ascending_5"]   = "beş zaman yeniden-eskiye kaldırıldı";
$pgv_lang["removed_ascending_6"]   = "alti zaman yeniden-eskiye kaldırıldı";
$pgv_lang["removed_ascending_7"]   = "yedi zaman yeniden-eskiye kaldırıldı";
$pgv_lang["removed_ascending_8"]   = "sekiz zaman yeniden-eskiye kaldırıldı";
$pgv_lang["removed_ascending_9"]   = "dokuz zaman yeniden-eskiye kaldırıldı";
$pgv_lang["removed_ascending_10"]  = "on zaman yeniden-eskiye kaldırıldı";
$pgv_lang["removed_ascending_11"]  = "onbir zaman yeniden-eskiye kaldırıldı";
$pgv_lang["removed_ascending_12"]  = "oniki zaman yeniden-eskiye kaldırıldı";
$pgv_lang["removed_ascending_13"]  = "onüç zaman yeniden-eskiye kaldırıldı";
$pgv_lang["removed_ascending_14"]  = "ondört zaman yeniden-eskiye kaldırıldı";
$pgv_lang["removed_ascending_15"]  = "onbeş zaman yeniden-eskiye kaldırıldı";
$pgv_lang["removed_ascending_16"]  = "onalti zaman yeniden-eskiye kaldırıldı";
$pgv_lang["removed_ascending_17"]  = "onyedi zaman yeniden-eskiye kaldırıldı";
$pgv_lang["removed_ascending_18"]  = "onsekiz zaman yeniden-eskiye kaldırıldı";
$pgv_lang["removed_ascending_19"]  = "ondokuz zaman yeniden-eskiye kaldırıldı";
$pgv_lang["removed_ascending_20"]  = "yirmi zaman yeniden-eskiye kaldırıldı";
$pgv_lang["removed_descending_1"]  = "birkere eskiden-yeniye kaldırıldı";
$pgv_lang["removed_descending_2"]  = "ikikere eskiden-yeniye kaldırıldı";
$pgv_lang["removed_descending_3"]  = "üç zaman eskiden-yeniye kaldırıldı";
$pgv_lang["removed_descending_4"]  = "dört zaman eskiden-yeniye kaldırıldı";
$pgv_lang["removed_descending_5"]  = "beş zaman eskiden-yeniye kaldırıldı";
$pgv_lang["removed_descending_6"]  = "alti zaman eskiden-yeniye kaldırıldı";
$pgv_lang["removed_descending_7"]  = "yedi zaman eskiden-yeniye kaldırıldı";
$pgv_lang["removed_descending_8"]  = "sekiz zaman eskiden-yeniye kaldırıldı";
$pgv_lang["removed_descending_9"]  = "dokuz zaman eskiden-yeniye kaldırıldı";
$pgv_lang["removed_descending_10"] = "on zaman eskiden-yeniye kaldırıldı";
$pgv_lang["removed_descending_11"] = "onbir zaman eskiden-yeniye kaldırıldı";
$pgv_lang["removed_descending_12"] = "oniki zaman eskiden-yeniye kaldırıldı";
$pgv_lang["removed_descending_13"] = "onüç zaman eskiden-yeniye kaldırıldı";
$pgv_lang["removed_descending_14"] = "ondört zaman eskiden-yeniye kaldırıldı";
$pgv_lang["removed_descending_15"] = "onbeş zaman eskiden-yeniye kaldırıldı";
$pgv_lang["removed_descending_16"] = "onalti zaman eskiden-yeniye kaldırıldı";
$pgv_lang["removed_descending_17"] = "onyedi zaman eskiden-yeniye kaldırıldı";
$pgv_lang["removed_descending_18"] = "onsekiz zaman eskiden-yeniye kaldırıldı";
$pgv_lang["removed_descending_19"] = "ondokuz zaman eskiden-yeniye kaldırıldı";
$pgv_lang["removed_descending_20"] = "yirmi zaman eskiden-yeniye kaldırıldı";
$pgv_lang["female_cousin_19"]           = "ondokuzuncu kuzen";
$pgv_lang["female_cousin_18"]           = "onsekizinci kuzen";
$pgv_lang["female_cousin_17"]           = "onyedinci kuzen";
$pgv_lang["female_cousin_16"]           = "onaltıncı kuzen";
$pgv_lang["female_cousin_15"]           = "onbeşinci kuzen";
$pgv_lang["female_cousin_14"]           = "ondördüncü kuzen";
$pgv_lang["female_cousin_13"]           = "onüçüncü kuzen";
$pgv_lang["female_cousin_12"]           = "onikinci kuzen";
$pgv_lang["female_cousin_11"]           = "onbirinci kuzen";
$pgv_lang["female_cousin_10"]           = "onuncu kuzen";
$pgv_lang["female_cousin_9"]            = "dokuzuncu kuzen";
$pgv_lang["female_cousin_8"]            = "sekizinci kuzen";
$pgv_lang["female_cousin_7"]            = "yedinci kuzen";
$pgv_lang["female_cousin_6"]            = "altıncı kuzen";
$pgv_lang["female_cousin_5"]            = "beşinci kuzen";
$pgv_lang["female_cousin_4"]            = "dördüncü kuzen";
$pgv_lang["female_cousin_3"]            = "üçüncü kuzen";
$pgv_lang["female_cousin_2"]            = "ikinci kuzen";

//-- gedcom edit utility
$pgv_lang["check_delete"]		= "Bu GEDCOM hadisesini gerçekten silmek istiyor musunuz?";
$pgv_lang["access_denied"]			= "Bu kaynağa erişemezsiniz. <br /><b>Erişim Reddedildi</b>";
$pgv_lang["changes_exist"]		= "Bu GEDCOM dosyasında değişiklikler yapılmıştır";
$pgv_lang["place_contains"]		= "Aranacak Yer:";
$pgv_lang["find_place"]			= "Yer ara";
$pgv_lang["close_window"]		= "Pencereyi kapat";
$pgv_lang["close_window_without_refresh"]	= "Pencereyi tazelemeden kapat";
$pgv_lang["add"]			= "Ekle";
$pgv_lang["edit_name"]			= "İsmini düzenle";
$pgv_lang["find_family"]		= "Aile ID ara";
$pgv_lang["find_fam_list"]		= "Aile arama listesi";
$pgv_lang["custom_event"]		= "Kişisel hadise";
$pgv_lang["delete_name"]		= "İsmini sil";
$pgv_lang["select_date"]		= "Bir tarih seçiniz";
$pgv_lang["user_cannot_edit"]		= "Bu kullanıcı adlı üye bu GEDCOM veritabanını düzenleyemez.";
$pgv_lang["ged_noshow"]				= "Bu sayfa yönetici tarafından devre dışı birakıldı.";
$pgv_lang["bdm"]					= "Doğumlar, Ölümler, Evlilikler";
$pgv_lang["delete_source"]		= "Bu kaynağı sil";
$pgv_lang["confirm_delete_source"]	= "Bu kaynağı hakikatten GEDCOM dosyasından silmek istiyor musunuz?";
$pgv_lang["delete_person"]		= "Bu şahsı sil";
$pgv_lang["confirm_delete_person"]	= "Bu şahsı hakikatten GEDCOM dosyasından silmek istiyor musunuz?";
$pgv_lang["find_media"]			= "Multimedya dosyalarını ara";
$pgv_lang["set_link"]			= "Bağlantı ekle";

$pgv_lang["in_this_month"]		= "Bu Ay içinde...";
$pgv_lang["in_this_year"]		= "Bu sene içinde olan hadiseler...";

//-- calendar.php messages
$pgv_lang["on_this_day"]		= "Bugünkü hadiseler...";
$pgv_lang["year_anniversary"]		= "#year_var#. yıl dönümü";
$pgv_lang["today"]			= "Bugün";
$pgv_lang["day"]			= "Gün:";
$pgv_lang["month"]			= "Ay:";
$pgv_lang["showcal"]			= "Gösterilen:";
$pgv_lang["anniversary"]			= "Yıldönümü";
$pgv_lang["anniversary_calendar"]	= "Yıldönümü takvimi";
$pgv_lang["sunday"]			= "Pazar";
$pgv_lang["monday"]			= "Pazartesi";
$pgv_lang["tuesday"]			= "Salı";
$pgv_lang["wednesday"]			= "Çarşamba";
$pgv_lang["thursday"]			= "Perşembe";
$pgv_lang["living_only"]		= "Yaşayan şahısları";
$pgv_lang["recent_events"]		= "Güncel hadiseler (< 100 sene)";
$pgv_lang["day_not_set"]			= "Gün kurulu değil";
$pgv_lang["all_people"]			= "Tüm şahıslar";
$pgv_lang["friday"]			= "Cuma";
$pgv_lang["saturday"]			= "Cumartesi";
$pgv_lang["lost_password"]		= "Şifrenizi unuttunuz mu?";
$pgv_lang["viewday"]			= "Günü göster";
$pgv_lang["viewmonth"]			= "Ayı göster";
$pgv_lang["viewyear"]			= "Seneyi göster";

//-- upload media messages
$pgv_lang["record_updated"]			= "#pid# kayıt başarılı biçimde güncellendi.";
$pgv_lang["record_not_updated"]		= "#pid# kayıdı güncelleyemez.";
$pgv_lang["record_removed"]			= "#xref# kayıdı GEDCOM dan başarılı biçimde kaldırıldı.";
$pgv_lang["record_not_removed"]		= "#xref# kayıdı GEDCOM dan taşıyamaz.";
$pgv_lang["record_added"]			= "#xref# kayıdı GEDCOM a başarılı biçimde eklendi.";
$pgv_lang["record_not_added"]		= "#xref# kayıdı GEDCOM a ekleyemez.";

//-- user self registration module
$pgv_lang["requestpassword"]		= "Şifremi unuttum. Yeni şifre istiyorum";
$pgv_lang["no_account_yet"]		= "Üye değil misiniz?";
$pgv_lang["requestaccount"]		= "Yeni kullanıcı kaydı";
$pgv_lang["emailadress"]		= "E-posta adresi";
$pgv_lang["mandatory"] 			= "* İşaretli alanların doldurulması zorunludur.";
$pgv_lang["myuserdata"]			= "Profil ayarlarım";
$pgv_lang["user_theme"]			= "Şahsi tema";
$pgv_lang["mgv"]			= "Şahsi SoyGörüntüleme";
$pgv_lang["editowndata"]		= "Profil ayarlarım";
$pgv_lang["mail01_line01"]		= "Merhaba: #user_fullname# ...";
$pgv_lang["mail01_line02"]		= "( #SERVER_NAME# ) sitesinde sizin E-posta adresiniz ( #user_email# ) ile üyelik isteminde bulunulmuştur.";
$pgv_lang["mail01_line03"]		= "Aşağıda gösterilen veriler iletilmiştir.";
$pgv_lang["mail01_line04"]		= "Üyelik işlemini tamamlamak için lütfen aşağıdaki bağlantıyı tıklayarak açılacak sayfada kullanıcı adınızı, şifrenizi ve tasdik kodunuzu işleyiniz.";
$pgv_lang["mail01_line05"]		= "Eğer siz bu üyelik isteminde bulunmadıysanız bu mektubu silip unutabilirsiniz.";
$pgv_lang["mail01_line06"]		= "Üyelik verileri başvurudan bir hafta sonra otomatik olarak silineceği için, size bu siteden bir daha harf gönderilmeyecektir.";
$pgv_lang["mail01_subject"]		= "#SERVER_NAME# sitesine kayıdınız";
$pgv_lang["hashcode"]			= "Tasdik kodunuz:";
$pgv_lang["thankyou"]			= "Merhaba #user_fullname# ...<br />Üyelik isteminde bulunduğunuz için teşekkür ederiz.";
$pgv_lang["pls_note06"]			= "Üyelik sırasında verdiğiniz E-posta adresiniz olan (#user_email#) onaylama mesajı gönderdik. Bu mesajın içindeki onaylama verileri 7 gün içinde onaylamak için geçerli olacaktır ve onaylamanız gerekiyor. Aksi taktirde üyeliğiniz silinecek ve yeniden üye olmanız gerekecektir ve aynı kullanıcı adı ve email adresini kullanabilirsiniz. Bu soyağacı sitesine girmek için kullanıcı adı ve şifrenizi unutmamanız gerekir.";
$pgv_lang["registernew"]		= "Yeni üyelik tasdiki";
$pgv_lang["user_verify"]		= "Üyelik tasdiki";
$pgv_lang["mail02_line01"]		= "Merhaba Yönetici ...";
$pgv_lang["mail02_line02"]		= "Yeni bir ziyaretçi ( #SERVER_NAME# ) sitesinde üyelik isteminde bulunmuştur.";
$pgv_lang["mail02_line03"]		= "Bu üyeye üyelik işlemini tamamlaması için gerekli bilgiler gönderilmiştir.";
$pgv_lang["mail02_line04"]		= "Üye kendisini tasdik ettikten sonra onun sitenize giriş yapabilmesi için izin vermeniz gerektiğinden bir mesaj ile bilgilendirileceksiniz.";
$pgv_lang["mail02_line04a"]			= "Bu gelecekteki kullanıcı kendisini doğruladığı zaman elektronik postayla haberdar edileceksiniz. <br />Sağlamadan sonra kullanıcı   bölümünüzdeki aksiyon olmaksızın giriş.";
$pgv_lang["mail02_subject"]		= "#SERVER_NAME# sitesinde yeni üyelik istemi";
$pgv_lang["date_created"]		= "Gönderiliş tarihi:";
$pgv_lang["message_from"]		= "Email adresi:";
$pgv_lang["message_from_name"]		= "İsminiz:";
$pgv_lang["message_to"]			= "Mesajı gönderen";
$pgv_lang["message_subject"]		= "Mesaj konusu:";
$pgv_lang["message_body"]		= "Mesaj içeriği:";
$pgv_lang["no_to_user"] 		= "Alıcı üye işlenmemiştir. Devam edemem.";
$pgv_lang["provide_email"]			= "Bu mesajınıza cevap alabilmeniz için lütfen email adresinizi girin. Email adresinizi girmezseniz sorunuza cevap veremeyiz. Email adresiniz herhangibir yerde veya başka türlü amaçlarda kullanılmayacaktır. Email adresiniz sadece bu sorunuza cevap vermek için kullanılacaktır.";
$pgv_lang["message_sent"]		= "Mesaj gönderildi";
$pgv_lang["reset"]			= "Sıfırla - İlk duruma getir";
$pgv_lang["site_default"]		= "Sitenin standardı";
$pgv_lang["invalid_email"]		= "Lütfen geçerli bir E-posta adresi ekleyiniz";
$pgv_lang["enter_subject"]		= "Lütfen mesajın konusunu ekleyin";
$pgv_lang["enter_body"]			= "Lütfen gönderilmeden mesaja birkaç satır ekleyin ;-)";
$pgv_lang["confirm_message_delete"]	= "Bu mesajı gerçekten silmek mi istiyorsunuz? Bu silme emri ileride geri alınamaz.";
$pgv_lang["message_email1"]		= "Aşağıdaki mesajı sizin PhpGedView üye hesabınıza gönderen: ";
$pgv_lang["message_email2"]		= "Aşağıdaki mesajı bir PhpGedView üye hesabına gönderdiniz:";
$pgv_lang["message_email3"]		= "Aşağıdaki mesajı bir PhpGedView yöneticisine (administrator) gönderdiniz:";
$pgv_lang["viewing_url"]		= "Bu mesaj yandaki URL okunurken yollandı:";
$pgv_lang["messaging2_help"]		= "Bu mesajın bir kopyası belirlediğiniz E-posta adresinize gönderilecektir.";
$pgv_lang["mygedview_desc"]		= "Sizin <b>Benim GedView Anasayfam</b> alanında kısa yoldan devamlı görmek istediğiniz kişileri Sık Kullanılanlara ekleyerek gelecek yıl dönümlerini kaçırmayacaksınız  yada incelemek istediğinizde arama yapmadan kısa yoldan görüntüleyebilirsiniz, Günlüğünüze istediğiniz hadiseleri kaydedebilir bu vesile ile unutmak istemediğiniz notları yazabilirsiniz Günlüğünüzü sizden başka yönetici dahil hiç kimse göremez, Bu anasayfada diğer kayıtlı üyelerin gelecek yıldönümleri yada diğer üyelerden PhpGedView üzerinden size gönderilen mesajları okuyabilir yada diğer kayıtlı üyelere PhpGedView üzerinden mesajlaşma imkanı bulacaksınız. Ayrıca sağda ...<b>Benim GedView Anasayfamı özelleştir</b>... linki tıklatıp <b>Benim GedView Anasayfamda</b> görmek istediğiniz modülleri yükleyin Benim GedView Anasayfanızı zenginleştirebilirsiniz ve dahası.";
$pgv_lang["no_messages"]		= "Okunmamış mesajınız yoktur.";
$pgv_lang["clicking_ok"]		= "OK kelimesini tıklarsanız açılacak pencerede #user[fullname]# ile ilişkiye geçebilirsiniz.";
$pgv_lang["favorites"]				= "Favorilerim";
$pgv_lang["my_favorites"]		= "Benim Sık Kullanılanlar";
$pgv_lang["no_favorites"]		= "Halen <b>#pgv_lang[my_favorites]#</b>a hiç kimseyi eklemediniz. <b>#pgv_lang[my_favorites]#</b>a bir şahsı eklemek için aşağıdaki <b>#pgv_lang[add_favorite]#</b> başındaki \"<b>+</b>\" artı ikona basın açılacak açılacak alanda <b>#pgv_lang[add_fav_enter_id]#</b> in altına ID bilgisi girilir bilmiyorsanız gireceğinize göre sağındaki ikonu seçip arama yapınız veya daha altındaki alana web sitelerinizi ekleyebilirsiniz ve bu <b>#pgv_lang[add_favorite]#</b> alanınıza ekleyecekleriniz hakkında bir açıklama gire bileceğiniz <b>#pgv_lang[add_fav_enter_note]#</b> alana detaylı bilgi girebilirsiniz ve Ekle butona basarak eklemenizi bitirebilirsiniz.";
$pgv_lang["add_to_my_favorites"]	= "\"Sık kullanılanlarıma\" ekle";
$pgv_lang["gedcom_favorites"]		= "Bu GEDCOM veritabanının \"Sık kullanılanları\"";
$pgv_lang["no_gedcom_favorites"]	= "\"Sık kullanılanlar\" bölümüne daha ekleme yapılmamıştır. Buraya ancak sitenin yöneticisi ekleme yapabilir.";
$pgv_lang["confirm_fav_remove"]		= "Bu şahsı hakikatten \"Sık kullanılanlarınızdan\" silmek istiyor musunuz?";
$pgv_lang["message_deleted"]		= "Mesaj silindi";
$pgv_lang["message"]			= "Mesaj gönder";
$pgv_lang["my_messages"]		= "Kişisel mesajlar";
$pgv_lang["send"]			= "Gönder";
$pgv_lang["pls_note07"]			= "Lütfen üyelik isteminizin tamamlanması ve tasdik edilmesi için, size bu siteden gönderiliş olan harf ile elinize geçen kullanıcı adı, şifrenizi ve tasdik kodunuzu işleyin.";
$pgv_lang["pls_note08"]			= "#user_name# kullanıcı adı üyenin verileri gözden geçirildi.";
$pgv_lang["mail03_line01"]		= "Merhaba Yönetici ...";
$pgv_lang["mail03_line02"]		= "#newuser[username]# ( #newuser[fullname]# ) kendisine gönderilen tasdik kodu ile verilerini tasdik etmiştir.";
$pgv_lang["mail03_line03"]		= "Lütfen aşağıdaki bağlantıyı tıklayıp sitenize giriş yapın, üyenin verilerini işleyip tasdik edin ve sitenize girmesine izin verin.";
$pgv_lang["mail03_subject"]		= "#SERVER_NAME# sitesinde yeni tasdik";
$pgv_lang["pls_note09"]			= "Üye olarak tasdik edildiniz.";
$pgv_lang["pls_note10"]			= "Yöneticiye haber verilmiştir.<br />O sizin hesabınızı açıp siteye girmenize izin verdikten sonra kullanıcı adınız ve şifreniz ile siteye giriş yapabilirsiniz.";
$pgv_lang["pls_note10a"]			= "Şimdi giriş yapabilmek için kullanıcı adınız ve şifreniz";
$pgv_lang["data_incorrect"]		= "Verileriniz yanlıştır.<br />Lütfen tekrarlayınız!";
$pgv_lang["user_not_found"]		= "Sistem işlediğiniz verileri tasdik edememiştir. Lütfen bir sayfa geri gidip tekrar deneyiniz.";
$pgv_lang["lost_pw_reset"]		= "Yeni şifre istek sayfası";
$pgv_lang["pls_note11"]			= "Size yeni bir şifre yollanmasını istiyorsaniz, üyelik hesabınızın kullanıcı adınızı ve E-posta adresini işleyin.<br /><br />Bundan sonra biz size E-posta yolu ile hesabınızı onaylayıcı bilgi içeren özel bir URL yollayacağız.<br />Yollanan bu URL adresini ziyaret ettiğinizde bu siteye giriş için gerekli olan şifrenizi değiştirmenize izin verilecektir.<br />Güvenlik nedenleri yüzünden bu özel URL adresini (bu sitenin yöneticileri dahil) kimseye göstermemeniz rica olunur.<br />Biz zaten böyle bir istekte bulunmayız...<br /><br />Bu sitenin yöneticisi tarafından yardıma ihtiyacınız varsa lütfen direk ona danışın.";
$pgv_lang["enter_email"]		= "E-posta adresinizi eklemeniz gerekiyor";
$pgv_lang["mail04_line01"]		= "Merhaba #user_fullname# ...";
$pgv_lang["mail04_line02"]		= "Kullanıcı adınız için yeni bir şifre istenmiştir!";
$pgv_lang["mail04_line03"]		= "Tavsiye:";
$pgv_lang["mail04_line04"]		= "Lütfen şimdi aşağıdaki bağlantıyı tıklayıp yeni şifreniz ile giriş yapın ve sonra şifrenizi güvenlik nedenleri yüzünden tekrar değiştirin.";
$pgv_lang["mail04_line05"]			= "Soyağacı websitesine giriş yaptıktan sonra '#pgv_lang[mygedview]#' nden '#pgv_lang[myuserdata]#' linkini tıklatın açılan sayfada '#pgv_lang[label_password_id]# ve #pgv_lang[confirm]#' her iki alanını yeni aynı şifrenizi girerek aşağıdaki '#pgv_lang[update_myaccount]#' butonunu tıklamanız yeterli olacaktır.";
$pgv_lang["mail04_subject"] 		= "#SERVER_NAME# deki veriyi talep etmek";
$pgv_lang["pwreqinfo"]				= "Merhaba...<br /><br />Yeni şifreniz (#user[email]#) kullanıcı adınıza kayıtlı email adresinize gönderilmiştir.<br /><br />Lütfen email hesabinizi kontrol edin; Mesajımızı yakın zamanda almalızınız.<br /><br />Tavsiye:<br />Siz yeni şifrenizle bu siteye giriş yaptıktan sonra en kısa zamanda güvenliğinizi sürdürmek için şifrenizi değiştirmelisiniz.";
$pgv_lang["mygedview"]			= "Benim GedView Anasayfam";
$pgv_lang["passwordlength"]		= "Şifre en azından 6 harf ya da sayı uzunluğunda olmalıdır";
$pgv_lang["welcome_text_auth_mode_3"]	= "<center><b>Bu soyağacı websitesine hoş geldiniz</b></center><br />Bu siteye giriş sadece <u>aile üyelerine</u> giriş izni verilir.<br /><br />If you have a user account you can login on this page. If you don't have a user account, you can apply for one by clicking on the appropriate link below.<br /><br />After verifying the information you provide, the administrator will either approve or decline your request for an account. You will receive an email when your request is approved.";
$pgv_lang["welcome_text_auth_mode_1"]	= "<center><b>Bu soyağacı web siyesine hoş geldiniz</b></center><br /> permitted to every visitor who has a user account.<br /><br />If you have a user account, you can login on this page. If you don't have a user account, you can apply for one by clicking on the appropriate link below.<br /><br />After verifying your application, the site administrator will activate your account. You will receive an email when your application has been approved.";
$pgv_lang["welcome_text_cust_head"] 	= "<center><b>Soyağacı Websitesine Hoş Geldiniz</b></center><br />Erişim, Bu website için kayıtlı kullanıcı adı ve şifresi olan kullanıcılara giriş inzi verilir.<br />";
$pgv_lang["acceptable_use"]			= "<div class=\"largeError\">ÖNEMLİ LÜTFEN ÜYE OLMADAN ÖNCE OKUYUN: <br /><br /></div><div class=\"error\">Bize katılın: bu soyağacında listelenen bilgilerin gizliliğini korumak için üye olmanız gerekiyor, üye olmak için aşağıdaki formu doğru bilgilerle doldurmanız gerekir.<br /><br /> Bu sitede listelenen soyağacına mensup biri iseniz üye olarak soyağacındaki eksikliklerin veya yanlışların düzeltilmesinde yardım olabileceğiniz gibi soyunuzu daha iyi öğrenmenizi sağlayacaktır.<br /><br />Lütfen aşağıdaki <b>Kendinizi tanıtın</b> alanına bu siteye kabul edilebilmeniz için kendinizi yönetici tanıyabilecek şeklinde çok detaylı yazmanız gerekir aksı taktirde üyeliğinizi onaylayamayacaktır.</div>";

//-- mygedview page
$pgv_lang["welcome"]			= "Hoş geldiniz";
$pgv_lang["upcoming_events"]		= "Gelecek yıldönümleri";
$pgv_lang["living_or_all"]			= "Sadece yaşayanların hadiseleri göster?";
$pgv_lang["basic_or_all"]			= "Sadece Doğum, Ölüm ve Evlilikleri Göster?";
$pgv_lang["style"]					= "Sunma Stili";
$pgv_lang["style1"]					= "Metin";
$pgv_lang["style2"]					= "Tablo";
$pgv_lang["cal_download"]			= "İzin verilen takvim olaylarını indir?";
$pgv_lang["no_events_living"]		= "Yaşayan insanlar için sonraki #pgv_lang[global_num1]# gün için herhangibir hadise yok.";
$pgv_lang["no_events_living1"]		= "Yaşayan insanlar için yarın için herhangibir hadise yok.";
$pgv_lang["no_events_all"]			= "Sonraki #pgv_lang[global_num1]# gün içinde herhangibir hadise yok.";
$pgv_lang["no_events_all1"]			= "Yarın için herhangibir hadise yok.";
$pgv_lang["no_events_privacy"]		= "Sonraki #pgv_lang[global_num1]# gün için hadiseler mevcut, Ancak onları görme yetkiniz kısıtlı olduğu için göremezsiniz.";
$pgv_lang["no_events_privacy1"]		= "Yarın için hadiseler mevcut, Ancak onları görme yetkiniz kısıtlı olduğu için göremezsiniz.";
$pgv_lang["more_events_privacy"]	= "<br />Sonraki #pgv_lang[global_num1]# gün için daha fazla hadiseler mevcut, Ancak onları görme yetkiniz kısıtlı olduğu için göremezsiniz.";
$pgv_lang["more_events_privacy1"]	= "<br />Yarın için daha fazla hadiseler mevcut, Ancak onları görme yetkiniz kısıtlı olduğu için göremezsiniz.";
$pgv_lang["none_today_living"]		= "Yaşayan insanlar için bügün için herhangibir hadise yok.";
$pgv_lang["none_today_all"]			= "Bugün için herhangibir hadise yok.";
$pgv_lang["none_today_privacy"]		= "Bugün için hadiseler mevcut, Ancak onları görme yetkiniz kısıtlı olduğu için göremezsiniz.";
$pgv_lang["more_today_privacy"]		= "<br />Bugün için daha fazla hadiseler mevcut, Ancak onları görme yetkiniz kısıtlı olduğu için göremezsiniz.";
$pgv_lang["chat"]			= "Chat";
$pgv_lang["users_logged_in"]		= "Bağlı bulunan diğer ziyaretçiler";
$pgv_lang["anon_user"]				= "1 gizli kullanıcı";
$pgv_lang["anon_users"]				= "#pgv_lang[global_num1]# gizli kullanıcılar";
$pgv_lang["login_user"]				= "1 kayıtlı kullanıcı";
$pgv_lang["login_users"]			= "#pgv_lang[global_num1]# kayıtlı kullanıcılar";
$pgv_lang["no_login_users"]			= "Kayıtlı veya gizli kullanıcılar yok";
$pgv_lang["reply"]			= "Cevapla";
$pgv_lang["random_picture"]		= "Rastgele fotoğraf";
$pgv_lang["sending_to"]			= "Bu mesaj #TO_USER# kullanıcı adlı üyeye yollanacaktır.";
$pgv_lang["preferred_lang"]		= "Bu üye mesajlarını #USERLANG# dilinde okumayı tercih ediyor.";
$pgv_lang["gedcom_created_using"]	= "Bu GEDCOM veritabanı <b>#SOFTWARE#</b> yazılımının <b>#VERSION#</b> sürümü ile oluşturulmuştur. ";
$pgv_lang["gedcom_created_on"]		= "Bu GEDCOM veritabanı <b>#DATE#</b> tarihinde oluşturulmuştur.";
$pgv_lang["gedcom_created_on2"]		= "Oluşturulma tarihi: <b>#DATE#</b>";
$pgv_lang["gedcom_stats"]		= "GEDCOM veritabanı istatistikleri:";
$pgv_lang["stat_individuals"]		= "Şahıslar";
$pgv_lang["stat_families"]		= "Aileler";
$pgv_lang["stat_sources"]		= "Kaynaklar";
$pgv_lang["stat_other"]			= "Diğer kayıt";
$pgv_lang["stat_earliest_birth"] 	= "İlk Doğan";
$pgv_lang["stat_latest_birth"] 	= "Son Doğan";
$pgv_lang["stat_earliest_death"] 	= "İlk Ölen";
$pgv_lang["stat_latest_death"] 	= "Son Ölen";
$pgv_lang["customize_page"]		= "Benim GedView Anasayfamı özelleştir";
$pgv_lang["customize_gedcom_page"]	= "Bu GEDCOM karşılama sayfasını özelleştirin";
$pgv_lang["upcoming_events_block"]	= "Gelecek olaylar kutusu";
$pgv_lang["upcoming_events_descr"]	= "X gün içinde gelecek hadise yıldönümlerini gösteren blok tur. Bu blok gelecek x gün seçeneği blok konfigürasyondan istediğiniz seçeneği ayarlayarak gelecek yıl dönümleri göstermenize imkan tanır.";
$pgv_lang["todays_events_block"]	= "\"Bugünkü hadise\" kutusu";
$pgv_lang["todays_events_descr"]	= "Bu blok #pgv_lang[on_this_day]# bloğudur bu blok günlük yıl dönümleri Doğum, Ölüm, Evlenme, Hadise vs tüm yıl dönümleri göstermesini sağlar günlük olarak.";
$pgv_lang["logged_in_users_block"]	= "Bağlı bulunan ziyaretçiler kutusu";
$pgv_lang["logged_in_users_descr"]	= "Bu blok kullanıcılara kimler çevrimiçi olduğunu gösteren bir bloktur.";
$pgv_lang["user_messages_block"]	= "Kişisel mesajlar kutusu";
$pgv_lang["user_messages_descr"]	= "Bu blok Kişisel mesajlar kutusu gösterir, Bu blokta diğer üyelere mesaj gönderme ve mesaj alma imkanı sağlar.";
$pgv_lang["user_favorites_block"]	= "Üye - \"Sık Kullanılanlar\" kutusu";
$pgv_lang["user_favorites_descr"]	= "Bu blok üyeye kendine özel favorilerin ekenmesine izin verir.";
$pgv_lang["welcome_block"]		= "Üye - \"Hoş geldin\" kutusu";
$pgv_lang["welcome_descr"]			= "Bu blok üyeye üye adı ile hoş geldin der ve şahsi ayarların linkini verir, tarih verir bu bloğu ister sağda ister solda gösterebilirsiniz.";
$pgv_lang["random_media_block"]		= "\"Rasgele medya\" kutusu";
$pgv_lang["random_media_descr"] 	= "Bu blok rastgele medya dosyaları gösterir, Soyağacında kayıtlı fotoğrafları ve kime ait olduğunu bilgisiyle beraberinde gösterir, Ayrıca manüel olarak bir sonraki resimleri görme, veya sonraki resimleri otomatik olarak değiştirebilir.<br /><br />Bu blokta medya dosyaların gösterilmesi hakkında yönetici veya sahibi kısıtlamış olabilir.";
$pgv_lang["random_media_persons_or_all"]	= "Hepsi veya sadece şahıslar olayları göster?";
$pgv_lang["random_media_persons"]	= "Şahıslar";
$pgv_lang["random_media_events"]	= "Hadiseler";
$pgv_lang["gedcom_block"]		= "GEDCOM - \"Hoş geldin\" kutusu";
$pgv_lang["gedcom_descr"]			= "Bu GEDCOM için Hoş geldiniz bloku. Bu sitedeki bu GEDCOM kayıtları için siteye gelenleri karşılar ve günün tarihi ve saati gösterir.";
$pgv_lang["gedcom_favorites_block"]	= "GEDCOM - \"Sık kullanılanlar\" kutusu";
$pgv_lang["gedcom_stats_block"]		= "GEDCOM - \"İstatistikler\" kutusu";
$pgv_lang["gedcom_stats_show_surnames"]	= "Ençok kullanılan soy isimler listesi göster?";
$pgv_lang["login_block"]		= "\"Giriş\" kutusu";
$pgv_lang["login_descr"]			= "Bu blok giriş bloğudur, üyeler siteye giriş yapmak için kullanıcı adını ve şifresiniz girebileceği bir bloktur.";
$pgv_lang["theme_select_block"]		= "\"Tema seçme\" kutusu";
$pgv_lang["theme_select_descr"] 	= "Bu blok tema seçme bloğudur üyeler kendi zevklerine göre site görümünü mevcut temalar için de seçim yapabilecekleri bir bloktur.";
$pgv_lang["block_top10_title"]		= "Başlıca işlenmiş soy isimleri";
$pgv_lang["block_top10"]		= "Soy isimleri \"Top 10\" kutusu";
$pgv_lang["block_top10_descr"]		= "Bu blok en çok olan soy adların bir listesini yayınlar. Bu blokta gösterilecek soyadların liste adet sayısını blok konfigürasyondan ayarlayabilirsiniz.";
$pgv_lang["gedcom_news_block"]		= "GEDCOM - \"Haberler\" kutusu";
$pgv_lang["gedcom_news_limit"]		= "Kota yoluyla göster:";
$pgv_lang["gedcom_news_limit_nolimit"]	= "Kota yok";
$pgv_lang["gedcom_news_limit_date"]		= "Parçanın yaşı";
$pgv_lang["gedcom_news_limit_count"]	= "Parçaların numarası";
$pgv_lang["gedcom_news_flag"]		= "Kota:";
$pgv_lang["gedcom_news_archive"] 	= "Arşivi görüntüle";
$pgv_lang["user_news_block"]		= "Üye - \"Günlük\" kutusu";
$pgv_lang["user_news_descr"]		= "Kullanıcı günlüğü, bu blok kullanıcı çevrimiçi olduğunda istediği notların tutmasını sağlar isterse bu günlüğünü ekleyerek devam etmesini sağlar";
$pgv_lang["my_journal"]			= "Benim günlüğüm";
$pgv_lang["no_journal"] 			= "Herhangibir günlük oluşturmadınız.";
$pgv_lang["confirm_journal_delete"] = "Bu günlük girişi silmek istediğinizden emin misiniz?";
$pgv_lang["add_journal"]		= "Yeni bir günlük mesajını ekle";
$pgv_lang["gedcom_news"]		= "Haberler";
$pgv_lang["confirm_news_delete"]	= "Bu haberi gerçekten silmek mi istiyorsunuz?";
$pgv_lang["add_news"]			= "Haber mesajı ekle";
$pgv_lang["no_news"]			= "Daha hiçbir haber yayınlanmamıştır.";
$pgv_lang["edit_news"]			= "Günlük ya da haberlere ekleme yap veyahut içerikleri değiştir";
$pgv_lang["enter_title"]		= "Lütfen başlık ekleyin.";
$pgv_lang["enter_text"] 			= "Lütfen bu haberler veya günlük girişi için bazı metin girin.";
$pgv_lang["news_saved"] 		= "Yaptığınız ekleme başarı ile hafıza edilmiştir.";
$pgv_lang["article_text"]		= "Mesaj metni:";
$pgv_lang["main_section"]		= "Ana Bölüm Bloklar";
$pgv_lang["right_section"]		= "Sağ Bölüm Bloklar";
$pgv_lang["available_blocks"]		= "Mevcut Bloklar";
$pgv_lang["move_up"]			= "Bir yukarıya taşı";
$pgv_lang["move_down"]			= "Bir aşağıya taşı";
$pgv_lang["move_right"]			= "Sağa taşı";
$pgv_lang["move_left"]			= "Sola taşı";
$pgv_lang["broadcast_all"]		= "Tüm üyelere mesaj gönder";
$pgv_lang["hit_count"]			= "Sayaç:";
$pgv_lang["phpgedview_message"]		= "PhpGedView mesajı";
$pgv_lang["common_surnames"]		= "Ençok kullanılan soy isimler listesi";
$pgv_lang["default_news_title"]		= "Nesep tetkikine hoş geldiniz";
$pgv_lang["default_news_text"]		= "Bu sitede bulunan seçere bilgileri <a href=\"http://www.phpgedview.net/\" target=\"_blank\">PhpGedView #VERSION#</a> yazılımı ile gösterilmektedir. Bu sayfada bu soyağacını tanıtan bilgiler bulunmaktadır. Bu bilgilere ulaşmak için 'Çizgeler' menüsünden bir çizgeyi seçin, ya da 'Listeler' menüsünden şahıs listesine gidin, veyahut sizi ilgilendiren bir soy ismini ya da yeri arayın.<br /><br />Bu siteyi gezerken bir sorunla karşılaşacak olursanız yardım simgesine tıklayıp bulunduğunuz sayfa hakkında gerekli yardımı bulabilirsiniz.<br /><br />Bu siteyi ziyaret ettiğiniz için teşekkür ederiz.";
$pgv_lang["reset_default_blocks"]	= "Kutuları varsayılan duruma sıfırla";
$pgv_lang["recent_changes"]		= "En Son Değişiklikler";
$pgv_lang["recent_changes_block"]	= "\"En son değişiklikler\" kutusu";
$pgv_lang["recent_changes_descr"]	= "Bu blok son x günden bu yana GEDCOM içinde yapılan değişikliklerin bir listesini yayınlar, Ziyaretçi bu listeye bakarak son x gününden itibaren kimlerin bilgileri güncellendiğini görür.";
$pgv_lang["recent_changes_none"]	= "<b>Son #pgv_lang[global_num1]# gün için hiç değişmeyenler.</b><br />";
$pgv_lang["recent_changes_some"]	= "<b>Son #pgv_lang[global_num1]# gün içinde yapılan değişiklikler</b><br />";
$pgv_lang["show_empty_block"]		= "Blok boş olduğunda gösterilsin mi?";
$pgv_lang["hide_block_warn"]		= "Eğer blok boş olduğu zaman gizle diye ayarlarsanız blok dolup gösterilene kadar tekrar ayarlayamayacaksınız.";
$pgv_lang["delete_selected_messages"]	= "Seçilmiş mesajları sil";
$pgv_lang["use_blocks_for_default"]	= "Bu kutular tüm ziyaretçiler icin varsayılan olarak kullanılsın mı?";
$pgv_lang["block_not_configure"]	=	"Bu blok ayarlanamaz.";
$pgv_lang["review_changes_descr"]	= "Ilımlıdaki Değişiklikler Bloğu çevrimiçin yapılan değişiklilerin bir listesini verir. Bu blokta çevrimiçi iken GEDCOM içinde yapılan değişikliklerin yönetici onayı için askıya alınıp yönetici tarafından görülerek bu değişiklikleri inceler uygunluğuna göre değişiklikleri kabul eder veya ret eder.";

//-- upgrade.php messages
$pgv_lang["options"]			= "Seçenekler:";
$pgv_lang["config_update_ok"]		= "Yapılandırma dosyanız başarı ile güncelleştirilmiştir.";
$pgv_lang["server_folder"]				= "Sunucudaki klasör adı";
$pgv_lang["medialist_recursive"]	= "Alt klasördeki dosyaları listele";
$pgv_lang["media_options"]			= "Media Seçenekleri";
$pgv_lang["page_size"]					= "Sayfa biçimi";
$pgv_lang["record_not_found"]			= "Talep edilen GEDCOM kayıdı bulunamadı. Bu geçersin kişiye bağlantı olabilir veya bozulmuş GEDCOM dosya dosyalanmış olabilir.";
$pgv_lang["result_page"]				= "Sonuç Sayfası";
$pgv_lang["edit_media"]					= "Medya parçaları düzenle";
$pgv_lang["wiki_main_page"]				= "Wiki Ana Sayfa";
$pgv_lang["wiki_users_guide"]			= "Wiki Kullanıcılar Kılavuzu";
$pgv_lang["wiki_admin_guide"]			= "Wiki Yöneticiler Kılavuzu";
$pgv_lang["no_search_for"]			= "Arama seçeneği seçtiğinizden emin olun.";
$pgv_lang["no_search_site"]			= "Başka siteyi seçtiğinizden emin olun.";
$pgv_lang["other_searches"]			= "Diğer Aramalar";
$pgv_lang["multi_site_search"] 		= "Çoklu Site Ara";
$pgv_lang["switch_lifespan"]		= "Yaşam Süresi Çizelgesi Göster";
$pgv_lang["switch_timeline"]		= "Zaman Yolu Çizelgesi Göster";
$pgv_lang["differences"]			= "Farklar";
$pgv_lang["charts_block"]			= "Blok Çizgeleri";
$pgv_lang["charts_block_descr"]		= "Bu blok Çizgeler bloğudur, Hoş geldiniz sayfasında veya <b>#GLOBALS[HOME_SITE_TEXT]#</b>da yerleştirmenize izin verir. Bu bloğa <b>#pgv_lang[index_header]#</b>, <b>#pgv_lang[hourglass_chart]#</b> ve <b>#pgv_lang[descend_chart]#</b> kısa Çizgeleri yerleştirebilirsiniz bu şekilde ziyaretçilerinize kısa bir örneklemede yapabilirsiniz.";
$pgv_lang["charts_click_box"]		= "Kişi hakkında daha detaylı bilgi için kişinin kutusunu tıklayın.";
$pgv_lang["search_sites"] 			= "Siteleri ara";
$pgv_lang["site_list"]				= "Site: ";
$pgv_lang["site_had"]				= "Aşağıdakiyi kapsa";
$pgv_lang["indi_is_remote"]			= "Bu kişisel için bilgi Başka sisteden bağlandı.";
$pgv_lang["link_remote"]            = "Başka siteden kişiyi bağla";
$pgv_lang["label_search_engine_detected"]  = "Arama Motoru Örümcek Oraya Çıkardı";
$pgv_lang["title_search_link"]      = "Yerel Bağlantı Ekle";
$pgv_lang["label_site_url2"]        = "Site URL";
$pgv_lang["ex-spouse"] = "Ex-Eş";
$pgv_lang["ex-wife"] = "Ex-Hanım";
$pgv_lang["ex-husband"] = "Ex-Koca";
$pgv_lang["noemail"] 				= "Emailler olmadan adresleri";
$pgv_lang["onlyemail"] 				= "Sadece emailler ile adresler";
$pgv_lang["maxviews_exceeded"]		= "Oranın aştığı sayfa görüntüsü #GLOBALS[MAX_VIEWS]# her biri için #GLOBALS[MAX_VIEW_TIME]# sonraki sayfayı dene.";
$pgv_lang["broadcast_not_logged_6mo"]	= "6 aydan beri giriş yapmayan kullanıcılara mesaj gönder";
$pgv_lang["broadcast_never_logged_in"]	= "Hiç giriş yapmamış kullanıcılara mesaj gönder";
$pgv_lang["stats_to_show"]			= "Blokta gösterilecekleri seçin";
$pgv_lang["stat_avg_age_at_death"]	= "Ortalama Yaş";
$pgv_lang["stat_longest_life"]		= "Uzun Yaşayan";
$pgv_lang["stat_most_children"]		= "Çok Çocuklu";
$pgv_lang["stat_average_children"]	= "Bir aileye ortalama çocuk sayısı";
$pgv_lang["stat_events"]			= "Hadiseler";
$pgv_lang["stat_media"]				= "Medialar";
$pgv_lang["stat_surnames"]			= "Soyadlar";
$pgv_lang["stat_users"]				= "Üyeler";
$pgv_lang["no_family_facts"]		= "Bu aile için hiç bilgiler yok.";
$pgv_lang["stat_males"]				= "Toplam erkekler";
$pgv_lang["stat_females"]			= "Toplam bayanlar";
$pgv_lang["sunday_1st"]					= "Pz";
$pgv_lang["monday_1st"]					= "P";
$pgv_lang["tuesday_1st"]				= "Sl";
$pgv_lang["wednesday_1st"]				= "Ç";
$pgv_lang["thursday_1st"]				= "Pş";
$pgv_lang["friday_1st"]					= "C";
$pgv_lang["saturday_1st"]				= "Ct";
$pgv_lang["jan_1st"]					= "Oca";
$pgv_lang["feb_1st"]					= "Şub";
$pgv_lang["mar_1st"]					= "Mar";
$pgv_lang["apr_1st"]					= "Nis";
$pgv_lang["edit_source"]			= "Kaynağı Düzenle";
$pgv_lang["source_menu"]			= "Kaynak için seçenekler";
$pgv_lang["familybook_chart"]		= "Ayrı Ayrı Aile Çizelgesi";
$pgv_lang["family_of"]				= "Aile:&nbsp;";
$pgv_lang["descent_steps"]			= "Nesil Adımları";
$pgv_lang["cancel"]					= "Vazgeç";
$pgv_lang["delete_family_confirm"]	= "Bu aileyi silerseniz buna bağlı çocukları, eşleri ve fertler hiç kimse ile bağlantıları kalmayıp ortada kalacaktır. Yinede siz bu aileyi silmek istediğinizden eminmisiniz?";
$pgv_lang["cookie_help"]			= "Bu siteye giriş yapılmış olarak konumunuzu korumak için coikeler/çerezleri kullanır (Giriş yapmış olarak siteyi dolaşabilmeniz için).<br /><br /><br />Coikeler/çerezler tarayıcınızda etkinleştirilmiş olarak belirlemelisiniz. Siteye girmeden önce coikeler/çerezleri etkinleştirmeniz gerekiyor. Coikeleri/çerezleri etkinleştirmek için tarayıcınızın Araçlar>Seçenekler alanında veya tarayıcınızın yardım dokümanından bakabilirsiniz.";
$pgv_lang["delete_family"]			= "Aileyi sil";
$pgv_lang["add_favorite"]			= "Sık Kullanılanlara yeni ekle";
$pgv_lang["url"]					= "URL";
$pgv_lang["add_fav_enter_note"]		= "Bu sık kullanılanlarınız hakkında bir açıklama gir";
$pgv_lang["add_fav_or_enter_url"]	= "VEYA<br />URL ve başlık gir ";
$pgv_lang["add_fav_enter_id"]		= "Kişi, Aile, veya Kaynak ID gir";
$pgv_lang["next_email_sent"]		= "Gelecek hatırlatıcı email gönderileceği zaman ";
$pgv_lang["last_email_sent"]		= "En son hatırlatıcı email gönderilme zamanı ";
$pgv_lang["remove_child"]			= "Aileden bu çocuğu kaldır";
$pgv_lang["address_labels"]			= "Adres Etiketleri";
$pgv_lang["filter_address"]			= "Kapsayacak adres yeri:";
$pgv_lang["address_list"]			= "Adres Listesi";
$pgv_lang["link_new_husb"]			= "Bu kişiye var olan bir koca ekle";
$pgv_lang["link_new_wife"]			= "Var olan kişiden yeni hanım eş ekle";
$pgv_lang["index_edit_advice"]		= "Blok isimini belirt ve sonra gösterilen yönde bloğu belirten yere taşımak için taşıma ikonlarından birini tıklayın.";

$pgv_lang["may_1st"]				= "May";
$pgv_lang["jun_1st"]					= "Haz";
$pgv_lang["jul_1st"]					= "Tem";
$pgv_lang["aug_1st"]					= "Ağu";
$pgv_lang["sep_1st"]					= "Eyl";
$pgv_lang["oct_1st"]					= "Eki";
$pgv_lang["nov_1st"]					= "Kas";
$pgv_lang["dec_1st"]					= "Ara";

//-- validate gedcom
$pgv_lang["add_media_tool"]		= "Medya dosyası ekleme aracı";
$pgv_lang["media_linked"]			= "Bu multimedia nesnesi aşağıdaki kişiye bağlıdır:";
$pgv_lang["media_not_linked"]		= "Bu media öbjesi hiçbir kişiye bağlı değil ve GEDCOM a kayıtlı değil.";
$pgv_lang["media_dir_1"]			= "Bu media nesnesi dış sunucuda lokale yerleştirilir";
$pgv_lang["media_dir_2"]			= "Bu media nesnesi normal media klasöründedir";
$pgv_lang["media_dir_3"]			= "Bu media nesnesi korumalı media klasöründedir";
$pgv_lang["thumb_dir_1"]			= "Bu tırnak önizleme dış sunucuda lokale yerleştirilir";
$pgv_lang["thumb_dir_2"]			= "Bu tırnak önizleme normal media klasöründedir";
$pgv_lang["thumb_dir_3"]			= "Bu tırnak önizleme korumalı media klasöründedir";
$pgv_lang["moveto_2"]				= "Korumalı klasöre taşı";
$pgv_lang["moveto_3"]				= "Normal klasöre taşı";
$pgv_lang["move_standard"]			= "Normale taşı";
$pgv_lang["move_protected"]		= "Korumalıya taşı";
$pgv_lang["move_mediadirs"]			= "Media klasörleri taşı";
$pgv_lang["setperms"]				= "Medya İzinleri Kur";


$pgv_lang["setperms_success"]		= "İzinleri Kur";
$pgv_lang["setperms_failure"]		= "İzinler Kurulmamış";
$pgv_lang["setperms_time_exceeded"]	= "İletişim limiti aşıldı. Küçük klasörle tekrar komutu dene.";
$pgv_lang["move_time_exceeded"]	= "İletişim süre limitine ulaşıldı. Dosyaların bundan sonrası taşımak için tekrar komutu dene.";
$pgv_lang["media_firewall_rootdir_no_exist"]			= "İstediğiniz bu media firewall kök klasörü yok. Önce bunu oluşturun.";
$pgv_lang["media_firewall_protected_dir_no_exist"]		= "Korunmuş media klasöründe media firewall kök klasörü oluşturulamıyor. Lütfen bu klasörü oluştur ve yazılabilir yap.";
$pgv_lang["media_firewall_protected_dir_not_writable"]	= "Media firewall kök klasöründe korunmuş media klasörü yazılabilir değil.";
$pgv_lang["relationship_great"]		= "Büyük";

//-- hourglass chart
$pgv_lang["hourglass_chart"]		= "Kum saati Çizelgesi";

//-- report engine
$pgv_lang["choose_report"]		= "Rapor seçimi";
$pgv_lang["enter_report_values"]	= "Rapor içeriklerini işleyin";
$pgv_lang["selected_report"]		= "Seçilen rapor türü";
$pgv_lang["select_report"]		= "Raporu seç";
$pgv_lang["download_report"]		= "Raporu indir";
$pgv_lang["reports"]			= "Raporlar";
$pgv_lang["pdf_reports"]		= "PDF raporları";
$pgv_lang["html_reports"]		= "HTML raporları";
$pgv_lang["family_group_report"]	= "Aile Grup Raporu";
$pgv_lang["page"]					= "Sayfa";
$pgv_lang["of"] 					= "son";
$pgv_lang["enter_famid"]		= "Aile numarası";
$pgv_lang["show_sources"]		= "Kaynaklar gösterilsin mi?";
$pgv_lang["show_notes"]			= "Notlar gösterilsin mi?";
$pgv_lang["show_basic"]			= "Temel hadiseler, boş olsa da, eklensin mi?";
$pgv_lang["show_photos"]		= "Fotoğraflar gösterilsin mi?";
$pgv_lang["relatives_report_ext"]	= "Detaylı Yakınlık Raporu";
$pgv_lang["with"]					= "ile";
$pgv_lang["on"]						= "de";
$pgv_lang["in"]						= "içine";
$pgv_lang["individual_report"]		= "Şahıs raporu";
$pgv_lang["enter_pid"]			= "Şahıs numarası";
$pgv_lang["generated_by"]		= "Üretenin ismi:";
$pgv_lang["list_children"]		= "Her çocuğu doğum tarihine göre sırala.";
$pgv_lang["birth_report"]		= "Doğum tarihi ve yer raporu";
$pgv_lang["birthplace"]				= "Doğum yeri";
$pgv_lang["birthdate1"]				= "Doğum Tarihinden Başla";
$pgv_lang["birthdate2"]				= "Doğum Tarihinde Bitir";
$pgv_lang["death_report"]			= "Ölüm Tarihi ve Yer Raporu";
$pgv_lang["deathplace"]				= "Ölüm Yeri";
$pgv_lang["deathdate1"]				= "Ölüm Tarihinden Başla";
$pgv_lang["deathdate2"]				= "Ölüm Tarihinden Bitir";
$pgv_lang["marr_report"]			= "Evlilik Tarihi ve Yer Raporu";
$pgv_lang["marrplace"]				= "Evlilik Yeri";
$pgv_lang["marrdate1"]				= "Evlilik Tarihinden Başla";
$pgv_lang["marrdate2"]				= "Evlilik Tarihinden Bitir";
$pgv_lang["sort_by"]			= "Sıralama biçimi:";

$pgv_lang["cleanup"]			= "Temizle";

//-- CONFIGURE (extra) messages for programs patriarch, slklist and statistics


$pgv_lang["statistics"]			= "İstatistikler";

//-- Merge Records
$pgv_lang["merge_same"] 			= "Kayıtlar aynı tip değiller. Aynı tip olmayan kayıtları birleştirilmez.";
$pgv_lang["merge_step1"]		= "Kayıt birleştirme - 3 adımdan 1'incisi";
$pgv_lang["merge_step2"]		= "Kayıt birleştirme - 3 adımdan 2'ncisi";
$pgv_lang["merge_step3"]		= "Kayıt birleştirme - 3 adımdan 3'üncüsü";
$pgv_lang["select_gedcom_records"]	= "Birleştirmek için iki GEDCOM kayıdı seç. Kayıtlar ayn tipden olmalılar.";
$pgv_lang["merge_to"]				= "Birleşecek yerin Kaynak ID:";
$pgv_lang["merge_from"] 			= "Birleştimek için Alınacak Kaynak ID:";
$pgv_lang["merge_facts_same"]		= "Her ikiside tam olarak aynı olan takip eden gerçekler otomatik olarak kaydederek birleştirilecek.";
$pgv_lang["no_matches_found"]		= "Uyan hiç bir hadise bulunamadı";
$pgv_lang["unmatching_facts"]		= "Aşağıdaki gerçekler eşlemediler. Elde tutmak istediğiniz bilgiyi seçin.";
$pgv_lang["record"]			= "Kayıt";
$pgv_lang["adding"] 				= "Eklendi";
$pgv_lang["updating_linked"]		= "Güncellenen kayıt bağlandı";
$pgv_lang["merge_more"]			= "Kayıt birleştirmeye devam et.";
$pgv_lang["same_ids"]				= "Aynı kimlik bilgileri girdiniz. Aynı kayıtlar birleştirilmez.";
$pgv_lang["sosa_paternal_female_n_generations"]	= "%3\$d x büyük büyükbaba";
$pgv_lang["sosa_paternal_male_n_generations"]	= "%3\$d x büyük büyükanne";
$pgv_lang["sosa_maternal_female_n_generations"]	= "%3\$d x büyük büyükbaba";
$pgv_lang["sosa_maternal_male_n_generations"]	= "%3\$d x büyük büyükanne";
$pgv_lang["compact_chart"]			= "Sıkıştırılmış Çizge";

//-- ANCESTRY FILE MESSAGES
$pgv_lang["ancestry_chart"]		= "Atalara Doğru Çizge";
$pgv_lang["gen_ancestry_chart"]		= "#PEDIGREE_GENERATIONS# Nesil Ataların Taslağını Çıkarırlar";
$pgv_lang["chart_style"]		= "Çizge türü";
$pgv_lang["chart_list"]			= "Liste";
$pgv_lang["chart_booklet"]   	= "Broşür";
$pgv_lang["show_cousins"]			= "Kuzenleri göster";

//-- FAN CHART
$pgv_lang["fan_chart"]			= "Diyagram Daire Çizelgesi";
$pgv_lang["gen_fan_chart"]  		= "#PEDIGREE_GENERATIONS# Nesil Çizge Yelpazesi";
$pgv_lang["fan_width"]			= "Değirmi çizge'nin eni";
$pgv_lang["gd_library"]				= "PHH sunucunun konfigürasyon: GD 2.x resim fonksiyonları kullanmak için kütüphane gerektirir.";
$pgv_lang["gd_freetype"]			= "PHP sununun konfigürasyonu: Kütüphaneleri doğru kullanmayı gerektirdiğin serbest tip ve yazı fontları yazar.";
$pgv_lang["gd_helplink"]			= "http://tr.php.net/gd";
$pgv_lang["fontfile_error"]		= "Yazı tipi dosyası PHP sunucusunda bulunamadı";
$pgv_lang["fanchart_IE"]			= "Bu yelpaze harıta görüntüsü tarayıcınız tarafından doğrudan yazılamaz. Bu durumda uygun yeri tıkla kaydet ve yazdır.";

//-- RSS Feed
$pgv_lang["rss_descr"]			= "Haberler ve bağlantılar #GEDCOM_TITLE# sitesindendir";
$pgv_lang["rss_logo_descr"]		= "Feed PhpGedView tarfından yaratılmıştır";
$pgv_lang["rss_feeds"]				= "RSS Kanalları";
$pgv_lang["no_feed_title"]			= "Feed mevcut değil";
$pgv_lang["no_feed"]				= "Bu PhpGedView sitesinde RSS mevcut değil veya kapalıdır";
$pgv_lang["authenticated_feed"]		= "Feed olduğunu onayla";
$pgv_lang["attendant"] = "Bağlı";
$pgv_lang["attending"] = "Katıl";
$pgv_lang["best_man"] = "En iyi Erkek";
$pgv_lang["bridesmaid"] = "Nedime";
$pgv_lang["buyer"] = "Alıcı";
$pgv_lang["circumciser"] = "Sünnet Edilme";
$pgv_lang["civil_registrar"] = "Medeni Sicil";
$pgv_lang["friend"] = "Arkadaş";
$pgv_lang["godfather"] = "Vaftiz Babası";
$pgv_lang["godmother"] = "Vaftiz anası";
$pgv_lang["godparent"] = "Vaftiz veli";
$pgv_lang["informant"] = "Bilgiveren";
$pgv_lang["lodger"] = "Konuk";
$pgv_lang["nurse"] = "Dadı";
$pgv_lang["priest"] = "Papaz";
$pgv_lang["rabbi"] = "Haham";
$pgv_lang["registry_officer"] = "Sicil Memuru";
$pgv_lang["seller"] = "Satıcı";
$pgv_lang["servant"] = "Hizmetçi";
$pgv_lang["twin"] = "İkiz";
$pgv_lang["twin_brother"] = "İkiz erkek kardeş";
$pgv_lang["twin_sister"] = "İkiz kız kardeş";
$pgv_lang["witness"] = "Tanık";

//-- statistics utility
$pgv_lang["statutci"]			= "İndeksi oluşturamadı";
$pgv_lang["statnnames"]			= "Toplam kişi";
$pgv_lang["statnfam"]			= "Toplam aile";
$pgv_lang["statnmale"]			= "Toplam erkek";
$pgv_lang["statnfemale"]		= "Toplam bayan";
$pgv_lang["statvars"]			= "Lütfen çizge için gerekli olan değişkenleri işleyin";
$pgv_lang["statlxa"]			= "X-Ekseni boyunca:";
$pgv_lang["statlya"]			= "Y-Ekseni boyunca";
$pgv_lang["statlza"]			= "Z-Ekseni boyunca";
$pgv_lang["stat_1_map"]			= "Kişisel dağılım";
$pgv_lang["stat_2_map"]			= "Ülkeye göre doğum";
$pgv_lang["stat_3_map"]			= "Ülkeye göre ölüm";
$pgv_lang["stat_4_map"]			= "Ülkeye göre evlilik";
$pgv_lang["stat_8_fam"]			= "Kaynaklar ile aileler";
$pgv_lang["stat_9_indi"]		= "Kaynaklar ile kişiler";
$pgv_lang["stat_10_none"]		= "Hiç biri";
$pgv_lang["stat_11_mb"]			= "Doğum ayı";
$pgv_lang["stat_12_md"]			= "Vefat ayı";
$pgv_lang["stat_13_mm"]			= "Evlenme ayı";
$pgv_lang["stat_14_mb1"]		= "Bir ilişkide doğan 1. çocuğun doğum ayı";
$pgv_lang["stat_15_mm1"]		= "İlk evlenme günlerinin ayı";
$pgv_lang["stat_16_mmb"]		= "Evlilik ile 1. doğum arasındaki ay sayısı.";
$pgv_lang["stat_17_arb"]		= "Doğum senesi bazında yaş.";
$pgv_lang["stat_18_ard"]		= "Vefat senesi bazında yaş.";
$pgv_lang["stat_19_arm"]		= "Evlilik senesi bazında yaş.";
$pgv_lang["stat_20_arm1"]		= "1. Evlilik senesi bazında yaş.";
$pgv_lang["stat_21_nok"]		= "Çocuk sayısı.";
$pgv_lang["stat_200_none"]		= "Hepsi (ya da boş)";
$pgv_lang["stat_201_num"]		= "Miktar";
$pgv_lang["stat_202_perc"]		= "Yüzdelik";
$pgv_lang["stat_300_none"]		= "Hiç biri";
$pgv_lang["stat_301_mf"]		= "Cinsiyet";
$pgv_lang["stat_302_cgp"]		= "Dönemler. Periyorlar z-ekseni için doğru değerleri kontrol et";
$pgv_lang["statar_xgp"]			= "Periyotlar için gerekli olan limit değerler (x-ekseni):";
$pgv_lang["statar_xgl"]			= "Yaşlar için gerekli olan limit değerler (x-ekseni):";
$pgv_lang["statar_xgm"]			= "Aylar için gerekli olan limit değerler (x-ekseni):";
$pgv_lang["statar_xga"]			= "Miktarlar için gerekli olan limit değerler (x-ekseni):";
$pgv_lang["statar_zgp"]			= "Periyotlar için gerekli olan limit değerler (z-ekseni):";
$pgv_lang["statreset"]			= "Sıfırla - İlk duruma getir";
$pgv_lang["statsubmit"]			= "Çizelgesi göster";
$pgv_lang["statistiek_list"]	= "İstatistik Alanı";

//-- statisticsplot utility
$pgv_lang["stpl"]			= "...";
$pgv_lang["stplinfo"]			= "Çizge için değişken";
$pgv_lang["stpltype"]			= "Tipi:";
$pgv_lang["stplnoim"]			= "Uygulanacak yok:";
$pgv_lang["stplmf"]			= " her cinsiyet";
$pgv_lang["stplipot"]			= " / her dönem zamanı";
$pgv_lang["stplmonth"]			= "Ay";
$pgv_lang["stplnumbers"]		= "Sayı";
$pgv_lang["stplage"]			= "Yaş";
$pgv_lang["stplperc"]			= "Yüzdelik";
$pgv_lang["stplnumof"]			 = "Sayımlar";
$pgv_lang["stplmarrbirth"]		 = "Evlilikle ile ilk çocuk arasındaki aylar";
$pgv_lang["alive_in_year"]			= "Yılda yaşayan";
$pgv_lang["is_alive_in"]			= "#YEAR# senesinde hayatta olanlar";
$pgv_lang["alive"]					= "Yaşayan";
$pgv_lang["dead"]					= "Ölü";
$pgv_lang["maybe"]					= "Belki";
$pgv_lang["both_alive"]					= "Her iki canli";
$pgv_lang["both_dead"]					= "Her iki ölü";

//-- alive in year

//-- find media
$pgv_lang["media_format"]			= "Media Biçimi";
$pgv_lang["image_size"]				= "Resim ebatları--";
$pgv_lang["manage_media"]			= "Media Yönetimi";

//-- link media
$pgv_lang["media_id"]			= "Media Kimlik";
$pgv_lang["invalid_id"]			= "Bu GEDCOM da böyle dosya var Dosyalanmaz.";

//-- Help system
$pgv_lang["definitions"]		= "Tanımlar";

//-- Index_edit
$pgv_lang["description"]		= "Açıklaması";
$pgv_lang["block_desc"]				= "Blok Detayları";
$pgv_lang["click_here"]				= "Devam etmek için burayı tıkla";
$pgv_lang["block_summary_table"]	= "&nbsp;";
$pgv_lang["total_places"]			= "Bulunan Yerler";
$pgv_lang["media_contains"]			= "Media içerikleri:";
$pgv_lang["repo_contains"]			= "Saklama yeri kapsa:";
$pgv_lang["source_contains"]		= "Kaynakları kapsa:";
$pgv_lang["display_all"]			= "Hepsini Listele";
$pgv_lang["add_faq_header"] = "SSS Başlık";
$pgv_lang["add_faq_body"] = "SSS Gövde";
$pgv_lang["add_faq_order"] = "SSS Konumu";
$pgv_lang["add_faq_visibility"] = "SSS Hangisi için";
$pgv_lang["no_faq_items"] = "Bu SSS listesi boş.";
$pgv_lang["position_item"] = "Bölümün konumu";
$pgv_lang["faq_list"] = "SSS Listeden Yardım Al";
$pgv_lang["confirm_faq_delete"] = "SSS girişini silmek istediğinizden eminmisiniz";
$pgv_lang["preview"] =  "Önizleme";
$pgv_lang["no_id"] = "Belirtilen hiç SSS ID si yok !";
$pgv_lang["hs_title"] 			= "Yardım Metni Ara";
$pgv_lang["hs_search"] 			= "Arama";
$pgv_lang["hs_close"] 			= "Pencereyi kapat";
$pgv_lang["hs_results"] 		= "Bulunan sonuçlar:";
$pgv_lang["hs_keyword"] 		= "Arama için";
$pgv_lang["hs_searchin"]		= "Aranacak yer";
$pgv_lang["hs_searchuser"]		= "Kullanıcı Yardım";
$pgv_lang["hs_searchmodules"]	= "Modüller Yadımı";
$pgv_lang["hs_searchconfig"]	= "Yönetici Yardım";
$pgv_lang["hs_searchhow"]		= "Arama Tipi";
$pgv_lang["hs_searchall"]		= "Tüm kelimeler";
$pgv_lang["hs_searchany"]		= "Kelimenin biri";
$pgv_lang["hs_searchsentence"]	= "Aynı tabir";
$pgv_lang["hs_intruehelp"]		= "Tek yardım metni";
$pgv_lang["hs_inallhelp"]		= "Tüm metin";
$pgv_lang["choose"] = "Seçin: ";
$pgv_lang["account_information"] = "Hesap Bilgileri";
$pgv_lang["TYPE__audio"] = "Ses";
$pgv_lang["TYPE__book"] = "Kitap";
$pgv_lang["TYPE__card"] = "Kart";
$pgv_lang["TYPE__certificate"] = "Belge";
$pgv_lang["TYPE__document"] = "Doküman";
$pgv_lang["TYPE__electronic"] = "Elektronik";
$pgv_lang["TYPE__film"] = "Mikrofilm";
$pgv_lang["TYPE__magazine"] = "Magazin";
$pgv_lang["TYPE__manuscript"] = "El yazması";
$pgv_lang["TYPE__map"] = "Harita";
$pgv_lang["TYPE__newspaper"] = "Gazete";
$pgv_lang["TYPE__photo"] = "Fotoğraf";
$pgv_lang["TYPE__tombstone"] = "Mezartaşı";
$pgv_lang["TYPE__video"] = "Görüntü (video)";
$pgv_lang["view_slideshow"] = "Slayt olarak görüntüle";
$pgv_lang["download_image"]			= "Resmi İndir";
$pgv_lang["no_media"]				= "Media Bulunamadı";
$pgv_lang["media_privacy"]			= "Mahremiyet kısıtlamaları bu nesneyi görmenizi engeller";
$pgv_lang["relations_heading"]		= "Bu resme bağlı olan kişi:";
$pgv_lang["file_size"]				= "Dosya Boyutu";
$pgv_lang["img_size"]				= "Resim Boyutu";
$pgv_lang["media_broken"]			= "Bu media dosyası bozuk ve PHP ile okunamaz";
$pgv_lang["unknown_mime"]			= "Medya firewall için mediadaki bilinmeyen mimetipi dosyalar, bu problemlere neden oacak.";
$pgv_lang["module_error_unknown_action_v2"] = "Bilinmeyen hareket: [action].";
$pgv_lang["module_error_unknown_type"] = "Bilinmeyen modül tipi.";
$pgv_lang["button_alive_in_year"] = "Yılda yaşayan kişileri göster.";
$pgv_lang["button_BIRT_Y100"] = "Son 100 yıl içinde doğmuş kişileri göster.";
$pgv_lang["button_BIRT_YES"] = "100 yıl önce doğmuş çocukları göster";
$pgv_lang["button_DEAT_H"] = "Sadece ortak evlilik çiftlerin erkek ölüm yerlerini göster.";
$pgv_lang["button_DEAT_N"] = "Her iki ortaklar canlı olduğu yer canlı veya çiftler olan kişileri göster.";
$pgv_lang["button_DEAT_W"] = "Sadece ortak evlilik çiftlerin bayan ölüm yerlerini göster.";
$pgv_lang["button_DEAT_Y"] = "Aniden veya her iki ortakları öldüğü yer çiftleri olan kişileri göster.";
$pgv_lang["button_DEAT_Y100"] = "Son 100 yıl içinde ölenleri göster.";
$pgv_lang["button_DEAT_YES"] = "100 yıl önceden ölen kişileri göster.";
$pgv_lang["button_MARR_DIV"] = "Boşanan çiftleri göster.";
$pgv_lang["button_MARR_U"] = "Evlilik biçimi bilinmeyen çiftleri tarihe göre göster.";
$pgv_lang["button_MARR_Y100"] = "Son 100 yıl içinde evlenen çiftleri göster.";
$pgv_lang["button_MARR_YES"] = "100 yıl önceden evlenen çiftleri göster.";
$pgv_lang["button_reset"] = "Listeyi varsayılan olarak sıfırla.";
$pgv_lang["button_SEX_F"] = "Sadece bayanları göster.";
$pgv_lang["button_SEX_M"] = "Sadece erkekleri göster.";
$pgv_lang["button_SEX_U"] = "Sadece cinsiyeti bilinmeyen kişileri göster.";
$pgv_lang["button_TREE_L"] = "Çiftler veya bireylerden «ayrılan» göster. Bunlar canlı olan bireylerdir ama veri tabanında kaydediler hiç çocukları yok.";
$pgv_lang["button_TREE_R"] = "Çiftler veya bireyler «kökleri» göster. Bu kişiler aynı zamnada aile «reisi» adlandırabilir. Veritabanında keydedilen hiç ebeveynlere sahip olmayan bireylerdir.";
$pgv_lang["sort_column"] = "Buna göre sırala.";
$pgv_lang["sort_column"] = "Buna göre sırala";

// calendar conversion options
$pgv_lang["cal_none"]                 = "Takvim dönüştürme hayır";
$pgv_lang["cal_gregorian"]            = "Miladi";
$pgv_lang["cal_julian"]               = "Jüliyen";
$pgv_lang["cal_french"]               = "Fransız";
$pgv_lang["cal_jewish"]               = "Yahudi";
$pgv_lang["cal_hebrew"]               = "İbrani";
$pgv_lang["cal_jewish_and_gregorian"] = "Yahudice ve Miladi";
$pgv_lang["cal_hebrew_and_gregorian"] = "İbrani ve Miladi";
$pgv_lang["cal_hijri"]                = "Hijri";
$pgv_lang["cal_arabic"]               = "Arapça";


$pgv_lang["include"]				= "İçer:";
$pgv_lang["page_x_of_y"]				= "Sayfa #GLOBALS[currentPage]# son #GLOBALS[lastPage]#";
$pgv_lang["roman_surn"]				= "Latin harfle Soyadı";
$pgv_lang["roman_givn"]				= "Latin Harfle Verilen Adı";
$pgv_lang["search_place_word"]		= "Sadece tüm kelime";
$pgv_lang["changes_report"]			= "Değiştirilenlerin Raporu";
$pgv_lang["changes_pending_tot"]	= "Askıdaki toplam değişiklikler: ";
$pgv_lang["changes_accepted_tot"]	= "Kabul edilen toplam değişiklikler: ";
$pgv_lang["changedate2"]			= "Değişenlerin başlama tarihi";
$pgv_lang["changedate1"]			= "Değişenlerin bitiş tarihi";
$pgv_lang["chart_type"]				= "Çizge Tipi";


// 1st generation
$pgv_lang["sosa_2"]			= "Baba";
$pgv_lang["sosa_3"]			= "Anne";
// 2nd generation
$pgv_lang["sosa_4"]			= "Büyükbaba";
$pgv_lang["sosa_5"]			= "Babaanne";
$pgv_lang["sosa_6"]			= "Dede";
$pgv_lang["sosa_7"]			= "Anneanne";
$pgv_lang["sosa_8"]			= "Büyükbabanın babası";
// 3rd generation
$pgv_lang["sosa_9"]			= "Büyükbabanın annesi";
$pgv_lang["sosa_10"]			= "Babaannenin babası";
$pgv_lang["sosa_11"]			= "Babaannenin annesi";
$pgv_lang["sosa_12"]			= "Dedenin babası";
$pgv_lang["sosa_13"]			= "Dedenin annesi";
$pgv_lang["sosa_14"]			= "Anneannenin babası";
$pgv_lang["sosa_15"]			= "Anneannenin annesi";
// 4th generation
$pgv_lang["sosa_16"]				= "Büyük-büyük-büyükbaba";
$pgv_lang["sosa_17"]				= "Büyük-büyük-büyükanne";
$pgv_lang["sosa_18"]				= "Büyük-büyük-büyükbaba";
$pgv_lang["sosa_19"]				= "Büyük-büyük-büyükanne";
$pgv_lang["sosa_20"]				= "Büyük-büyük-büyükbaba";
$pgv_lang["sosa_21"]				= "Büyük-büyük-büyükanne";
$pgv_lang["sosa_22"]				= "Büyük-büyük-büyükbaba";
$pgv_lang["sosa_23"]				= "Büyük-büyük-büyükanne";
$pgv_lang["sosa_24"]				= "Büyük-büyük-büyükbaba";
$pgv_lang["sosa_25"]				= "Büyük-büyük-büyükanne";
$pgv_lang["sosa_26"]				= "Büyük-büyük-büyükbaba";
$pgv_lang["sosa_27"]				= "Büyük-büyük-büyükanne";
$pgv_lang["sosa_28"]				= "Büyük-büyük-büyükbaba";
$pgv_lang["sosa_29"]				= "Büyük-büyük-büyükanne";
$pgv_lang["sosa_30"]				= "Büyük-büyük-büyükbaba";
$pgv_lang["sosa_31"]				= "Büyük-büyük-büyükanne";

$pgv_lang["age_differences"]		= "Yaş Farklarını Göster";
$pgv_lang["immediate_family"]		= "En Yakın Aile";
$pgv_lang["showUnknown"]			= "Bilinmeyen Cinsiyeti Göster";
$pgv_lang["example"]				= "Örnek:";
$pgv_lang["parent_family"]			= "Ebeveyn Aile";
$pgv_lang["view_fam_nav_details"]	= "Detayları Görüntüleniyor ...";

$pgv_lang["view_fam_nav_notes"]		= "için Notlar Görüntüleniyor ...";
$pgv_lang["view_fam_nav_sources"]	= "için Kaynaklar Görüntüleniyor ...";
$pgv_lang["view_fam_nav_media"]		= "için Media Görüntüleniyor ...";
$pgv_lang["view_fam_nav_album"]		= "için Albüm Görüntüleniyor ...";
$pgv_lang["view_fam_nav_relatives"]	= "için Akrabalar Görüntüleniyor ...";
$pgv_lang["view_fam_nav_tree"]		= "için Ağaç Görüntüleniyor ...";
$pgv_lang["view_fam_nav_research"]	= "için Araştırma Görüntüleniyor ...";
$pgv_lang["view_fam_nav_map"]		= "için Harita Görüntüleniyor ...";
$pgv_lang["view_fam_nav_spare"]		= "için Yedek-bilgi Görüntüleniyor ...";
$pgv_lang["navigator"]				= "Yön Gösterici";

$pgv_lang["show_parents"] 			= "Ebeveynleri göster";
$pgv_lang["years2"]					= "yıl";	// 2 Yıl";
$pgv_lang["advanced_search"] 	= "Gelişmiş Arama";
$pgv_lang["more_fields"]		= "Daha Fazla Alan Ekle";
$pgv_lang["step_parent_family"]		= "Üvey-Ebeveyn Aile";
$pgv_lang["repo_menu"]			= "Depo için Seçenekler";
$pgv_lang["stat_unknown"]			= "Bilinmeyen toplam";
$pgv_lang["total_unknown"]			= "Bilinmeyen toplam";
$pgv_lang["enter_person_generations"] = "Nesillerin sayısı";
$pgv_lang["apply_filter"]			= "Filtreyi uygula";
$pgv_lang["exact"]				= "Aynısı";
$pgv_lang["TYPE__other"] = "Diğer";
$pgv_lang["TYPE__painting"] = "Boyanmış";
$pgv_lang["TYPE__fiche"] = "Mikrofilm";
$pgv_lang["interactive_tree"]		= "Etkileşimli Ağaç";
$pgv_lang["tree"]					= "Ağaç";
$pgv_lang["install_step_8"] 		= "Başlangıç Al";
$pgv_lang["hide_show_spouses"]		= "Çok eşlileri göster veya gizle";
$pgv_lang["load_full_tree"]			= "Tam sayfa birbirini etkileyen ağaç içinde bu ağacı görüntüle";
$pgv_lang["count"]					= "Sayı";
$pgv_lang["htmlplus_block_ui"]		= "Uzatılmış Arabirim";
$pgv_lang["block_givn_top10_title"]		= "Eniyi Belirlenmiş 10 İsimler";
$pgv_lang["block_givn_top10"]			= "Eniyi Belirlenmiş 10 İsimler";
$pgv_lang["todo_show_other"]     = "Diğer kullanıcıların görevlerini göster";
$pgv_lang["todo_show_unassigned"]= "Atanmamış görevleri göster";
$pgv_lang["todo_show_future"]    = "Gelecek görevleri göster";
$pgv_lang["ellipsis"]				= "\xE2\x80\xA6";
$pgv_lang["first_letter_name"]		= "Aileleri göstermek için isimlerin ilk harfini seçin.";
$pgv_lang["first_letter_iname"]		= "Aileleri göstermek için soy isimlerin ilk harfini seçin.";
$pgv_lang["NNthai"] 			= "(bilinmiyor)";
$pgv_lang["PNthai"] 			= "(bilinmiyor)";
$pgv_lang["NNother"] 			= "(bilinmiyor)";
$pgv_lang["PNother"] 			= "(bilinmiyor)";
$pgv_lang["parent_age"] 			= "Ebeveynin yaşı";
$pgv_lang["father_age"]				= "Babanın yaşı";
$pgv_lang["mother_age"]				= "Annenin yaşı";
$pgv_lang["husb_age"]				= "Kocanın yaşı";
$pgv_lang["wife_age"]				= "Hanımın yaşı";
$pgv_lang["at_death_day"]      		= "Ölümün tarihinde";
$pgv_lang["easter"]     = "Pakalya";
$pgv_lang["ascension"]  = "Yükselme";
$pgv_lang["pentecost"]  = "Hamsin bayramı";
$pgv_lang["assumption"] = "Kabulün";
$pgv_lang["all_saints"] = "Tüm ermişler";
$pgv_lang["muhar"]        = "1. Muharrem Ay";
$pgv_lang["setperms_fix"]			= "Düzgün okuma/yazma/izinleri uygula";
$pgv_lang["media_firewall_invalid_dir"]	= "Not: Media Firewall bir dizinden medya dizininden başka yerden başlatıldı.";
$pgv_lang["mail03_line03a"]			= "Siz herhangi bir hareketi almak zorunda değilsiniz. kullanıcı şimdi giriş yapabilir.";
$pgv_lang["style3"]					= "Etiket kümesi";
$pgv_lang["todo_block"] = "&quot;To Do&quot; görevler";
$pgv_lang["todo_descr"] = "Bloğu yapmak veritabanında tüm seçkin _TODO niteliklerini listeler.";
$pgv_lang["yahrzeit_block"]			= "Gelecek Yahrzeiten";
$pgv_lang["yahrzeit_descr"]			= "Gelecek Yahrzeiten bloğu yakın gelecekte meydana gelecek olan ölüm yıldönümlerini gösterir. Siz gösterilen dönemi ayarlayabilirsiniz, bu blok ne kadar uzak gelecekten gösterecek.";
$pgv_lang["block_givn_top10_descr"]		= "Bu blok, sık sık veritabanında meydana gelen ilk 10 çocuğun bir tablosunu gösterir. Bu blokta gösterilen ilk adların asıl sayısı, ayarlanabilirdir.";
$pgv_lang["gedcom_news_descr"]		= "GEDCOM haber bloğu, bir admin kullanıcısı tarafından ilan edilen ziyaretçi haber tahliyeleri veya makaleleri gösterir.<br /><br /><br />Haber bloğu, önemli bir veritabanı güncelleştirmesi, bir aile birleşmesi, veya bir çocuğun doğumunu ilan etmesi için iyi bir yerdir.";
$pgv_lang["feed_login"]				= "Eğer senin, bu PhpGedView site yerinde bir hesabınız varsa özel bilgiyi görmeniz için kullanılan temel HTTP belgelemesinin olduğu sunucuya <a href=\"#AUTH_URL#\">giriş</a> yapabilirsin.";
$pgv_lang["godson"]		= "Vaftiz oğlu";
$pgv_lang["goddaughter"] = "Vaftiz kızı";
$pgv_lang["godchild"]	= "Vaftiz çocuğu";
$pgv_lang["click_here_help"]		= "~#pgv_lang[click_here]#~<br /><br />Değişikliklerinizi kurtarması için bu düğmeyi tıklayın.<br /><br />#pgv_lang[welcome]# veya #pgv_lang[mygedview]# sayfasına dönmüş olacaksınız, ama değişikliklerinizi gösterilmeyebilir. Sayfanın uygun şekilde değişikliklerinizi görmeniz için tarayıcınızın görevini tekrar doldurduğunu kullanmaya ihtiyaç duyabilirsin.";
$pgv_lang["block_summaries"]		= "~#pgv_lang[block_desc]#~<br /><br />Sizin #pgv_lang[welcome]# veya #pgv_lang[mygedview]# sayfasında yerleştirebileceğiniz blokların her birinin kısa bir tanımlaması buradadır.<br /><table border='1' align='center'><tr><td class='list_value'><b>#pgv_lang[name]#</b></td><td class='list_value'><b>#pgv_lang[description]#</b></td></tr>#pgv_lang[block_summary_table]#</table><br /><br />";
$pgv_lang["todo_nothing"]        = "Şuanda &quot;To Do&quot; görevleri yok.";
$pgv_lang["aunt_in_law"]			= "Yenge";
$pgv_lang["f_cousin_in_law"]		= "Kuzeninin hanımı";
$pgv_lang["pls_note06a"] 			= "Şimdi <b>#user_email#</b> email adresinize doğrulama mesajı göndereceğiz. Siz email adresinize mesajın içeriğindeki adımları izleyerek hesabınızı doğrulamalısınız. Eğer siz yedi gün içinde hesabınızı doğrulamazsanız sonrasındaki uygulamanız otomatik olarak reddedilecektir. Yeniden uygulamak zorunda kalacaksınız.<br /><br /> Mesajdaki doğrulama talimatları izledikten sonra giriş yapabilirsiniz. Bu siteye giriş yapabilmeniz için kullanıcı adı ve şifreye ihtiyaç duyacaksınız.<br /><br />";
$pgv_lang["welcome_text_auth_mode_2"]	= "<center><b>Bu Soyağacı Web Sitesine Hoş Geldiniz</b></center><br /> Bu soyağacı web sitesine erişim sadece <u>kayıtlı</u> kullanıcılara izin veriliyor.<br /><br /> Eğer siz bir kullanıcı hesaba sahip iseniz giriş yapabilirsiniz.<br /><br /> Eğer sizin bir kullanıcı hesabınız yoksa aşağıdaki uygun linki tıklatarak kayıt olabilirsiniz.<br /><br /> Kayıt sonrası hesabınızı doğruladıktan sonra son olarak yönetici hesabınızı onaylayacak veya reddedecektir. <br /><br />Yönetici hesabınıza uygulamadan sonra email ile size mesaj gönderilecektir.";
$pgv_lang["message_instructions"]	= "<b>Lütfen Not:</b> Bu soyağacının kurallar çerçevesine göre değişebilen kurala göre genel olarak bireylerin yaşam özel bilgileri yalnızca aile, akraba ve yakın arkadaşına verilebilir. Herhangi bir özel veri almadan önce bu kişinin ilişki durumu doğrulanması istenir. Ölü kişilerinde verileri bazen gizli olabilir. Çünkü bu durumda yeterli bilgi belirlemek için kişi hakkında bilinen veya hayatta değildir ve bebeğin yanındaki bu kişi hakkında daha fazla bilgi olmayabilir.<br /><br /> Soru sormadan önce lütfen tarihleri, yerleri kontrol ederek doğru kişi hakkında sorunuzu sorun ve akraba kapat. Eğer nesiller verisinde yanlışları değiştirilmesi için bilgi gönderiyorsanız lütfen verinin kayak yerini belirtin.<br /><br />";
$pgv_lang["portal_config_intructions"]	= "~#pgv_lang[customize_page]# <br /> #pgv_lang[customize_gedcom_page]#~<br /><br />Bunları istediğiniz gibi sayfaya blokları yerleştirerek sayfayı ihtiyacınıza göre özelleştirebilirsiniz.<br /><br /> Sayfa <b>Ana</b> ve <b>Sağ</b> bölümler içine bölünür. <b>Ana</b> bölüm blokları geniş belirirler ve sayfa başlığın altında belirir. <b>Sağ</b> bölüm sağda belirir ve sayfa başlığın altının sağında listelenir.<br /><br />Her bir bölüm listelendiği düzende sayfada yazılan blokların kendi listesine sahip olur.<br /><br />Blok listelerinin biri boş olduğunda kalan bloklar sayfanın tümünün genişliğini kapsayacaktır.<br /><br />";
$pgv_lang["NNhebrew"] 		= "İbrani";
$pgv_lang["PNhebrew"] 		= "İbrani";
$pgv_lang["NNarabic"] 		= "Arap";
$pgv_lang["PNarabic"] 		= "Arap";
$pgv_lang["stat_sindi"]			= "Kaynaklar ile kişiler";
$pgv_lang["stat_sfam"]			= "Kaynaklar ile aileler";
$pgv_lang["map_type"]			= "Harita tipi";
$pgv_lang["less"]				= "daha az";
$pgv_lang["over"]				= "üzerine";
$pgv_lang["interval"]			= "arası";
$pgv_lang["aft_marr"]			= "evlilikten sonra ay";
$pgv_lang["bef_marr"]			= "evlilikten sonra ve önce ay";
$pgv_lang["quarters"]			= "evlilikten sonra çeyrek";
$pgv_lang["half_year"]			= "evlilikten yarım-yıl sonra";
$pgv_lang["one_child"]			= "bir çocuk arası";
$pgv_lang["two_children"]		= "iki çocuk arası";
$pgv_lang["stplnuch"]			= "çocuk";
$pgv_lang["indi_distribution_chart"]	= "Kişisel dağılım çizelge";
$pgv_lang["surname_distribution_chart"]	= "Soyad dağılım çizelge";
$pgv_lang["g_chart_high"]		= "En Yüksek Nüfuslu";
$pgv_lang["g_chart_low"]		= "En Düşük Nüfuslu";
$pgv_lang["g_chart_nobody"]		= "Hiç kimse hepsi";
$pgv_lang["area_chart"]			= "Coğrafi alan";
$pgv_lang["europe_chart"]		= "Evrupa";
$pgv_lang["s_america_chart"]	= "Güney Amerika";
$pgv_lang["asia_chart"]			= "Asya";
$pgv_lang["middle_east_chart"]	= "Orta Doğu";
$pgv_lang["africa_chart"]		= "Afrika";
$pgv_lang["world_chart"]		= "Dünya";
$pgv_lang["TYPE__coat"] = "Arma";
$pgv_lang["slave"] = "Köle";
$pgv_lang["owner"] = "Sahibi";
$pgv_lang["employer"] = "İşveren";
$pgv_lang["employee"] = "Hizmetli";
$pgv_lang["avg_age"]				= "Ortalama yaş";
$pgv_lang["decade_marriage"]		= "Evliliğin on yılı";
$pgv_lang["decade_death"]			= "Ölümün on yılı";
$pgv_lang["decade_birth"]			= "Doğumun on yılı";
$pgv_lang["show_stats_charts"]		= "İstatistikler çizelgesi göster";
$pgv_lang["rabia"]        = "3. Rebiülevvel Ay";
$pgv_lang["rabit"]        = "4. Rebiülahir Ay";
$pgv_lang["jumaa"]        = "5. Cemaziyelevvel Ay";
$pgv_lang["jumat"]        = "6. Cemaziyelahir Ay";
$pgv_lang["rajab"]        = "7. Recep Ay";
$pgv_lang["shaab"]        = "8. Şaban Ay";
$pgv_lang["shaww"]        = "10. Şevval Ay";
$pgv_lang["dhuaq"]        = "11. Zilkade Ay";
$pgv_lang["dhuah"]        = "12. Zilhicce Ay";
$pgv_lang["search_DM"]				= "Daitch-Mokotoff";
$pgv_lang["week1"]					= "hafta";
$pgv_lang["weeks"]					= "hafta";
$pgv_lang["uncle_in_law"]			= "Enişte";
$pgv_lang["m_cousin_in_law"]		= "Kuzenin kocası";
$pgv_lang["facts"]					= "Olgular";
$pgv_lang["females"]				= "Bayanlar";
$pgv_lang["males"]					= "Erkekler";
$pgv_lang["no_other_link_found"]	= "İki kişi arasında başka herhangi bir bağlantı bulunamadı.";
$pgv_lang["first_letter_sfname"]	= "Bir aile göstermek için bir eşin ilk adının ilk harfini seçin.";
$pgv_lang["sortby"]				= "Ard arda";
$pgv_lang["names"]					= "İsimler";

$pgv_lang["shared_note_menu"]		= "Paylaşılan notlar için seçenekler";
$pgv_lang["search_notes"]			= "Paylaşılan Notlar";
$pgv_lang["edit_shared_note"]		= "Paylaşılan Notu Düzelt";
$pgv_lang["shared_note_list"]		= "Paylaşılan Notlar";
$pgv_lang["shared_notes"]			= "Paylaşılan Notlar";
$pgv_lang["search_shared_notes"]	= "Paylaşılan Notlar";
$pgv_lang["shared_note"]				= "Paylaşılan Not";
$pgv_lang["shared_notes_found"]			= "Bulunan Paylaşılan Notlar";
$pgv_lang["find_shared_note"]			= "Paylaşılan Notu Bul";
$pgv_lang["shared_note_info"]			= "Paylaşılan Not Bilgisi";
$pgv_lang["total_shared_notes"]			= "Toplam Paylaşılan Notlar";
$pgv_lang["delete_shared_note"]		= "Bu Paylaşılan Notu Sil";
$pgv_lang["confirm_delete_shared_note"]		= "Bu paylaşılan notu silmek istediğinizden emin misiniz?";
$pgv_lang["cemetery_report"]		= "Mezarlık Raporu";
$pgv_lang["shared_note_contains"]	= "Paylaşılan Not içerikleri:";
$pgv_lang["gedcomid"]				= "GEDCOM bireysel kayıt numarası";
$pgv_lang["lchildren"]				= "çocuklar";
$pgv_lang["no_date_fam"]		= "bilinmiyor";
$pgv_lang["use_colors"]				= "Renkler kullan";
$pgv_lang["stat_link"]				= "Grafik olarak istatistikleri görüntüle";
$pgv_lang["print_stat_link"]		= "İstatistik çizelgelerin linkleri göster?";
$pgv_lang["landscape_top"]			= "Eneski üste";
$pgv_lang["landscape_down"]			= "Eneski altta";
$pgv_lang["random_surn"]					= "Rastgele soyadı";
$pgv_lang["branch_list"]			= "Dallar";
$pgv_lang["rootid"] 				= "Soyağacının Kök Kişisi";
$pgv_lang["media_private"] 			= "Bu medya ile ilgili Bilgiler gizli tutulur. Medya ayrıntıları dahil edilmezler.";
$pgv_lang["font"]					= "Yazı";
$pgv_lang["backSlashes"]			= "Sola eğik çizgi : \\";
$pgv_lang["forwardSlashes"]			= "Sağa eğik çizgi : /";
$pgv_lang["sort_style"]				= "Stil Sırası";
$pgv_lang["individual_with_rela_report"]		= "Yakın Akrabalar Raporu";
$pgv_lang["stat_22_fwok"]		= "Çocuklar olmadan ailelerden sayı";
$pgv_lang["stat_create"]		= "Kendi grafiğini oluştur";
$pgv_lang["by_alpha"]				= "alfabetik olarak";
$pgv_lang["stat_age"]			= "Yaş";
$pgv_lang["century"]			= "yüzyıl";
$pgv_lang["nanny"] = "Dadı";
$pgv_lang["guardian"]	= "Bakıcı";
$pgv_lang["foster_mother"] = "Süt Anne";
$pgv_lang["foster_father"] = "Süt Baba";
$pgv_lang["foster_child"] = "Evlatlık";
$pgv_lang["burialplace"]			= "Mezar Yeri içer";
$pgv_lang["children_of"]			= "Çocukların";
$pgv_lang["child_of"]				= "Çocuk";
$pgv_lang["daughter_of"]			= "kızının";
$pgv_lang["son_of"]					= "oğlu";
$pgv_lang["by_anniv"]				= "Yıldönümü";
$pgv_lang["convertPath"]			= "Medya yolu dönüştür";
$pgv_lang["convertSlashes"]			= "Medya klasör ayırıcıları dönüştür";
$pgv_lang["stat_5_birth"]		= "Yüzyılda Doğumlar";
$pgv_lang["stat_19_aarm"]		= "Ortalama yüzyılda evlilik yaşı";
$pgv_lang["stat_18_aard"]		= "Ortalama yüzyılda ölüm yaşı";
$pgv_lang["stat_7_marr"]		= "Yüzyılda evlilik";
$pgv_lang["stat_6_death"]		= "Yüzyılda ölüm";
$pgv_lang["stat_countries"]			= "Ülkelerdeki hadiseler";
$pgv_lang["stat_death_places"]		= "Ölüm yeri";
$pgv_lang["stat_marriage_places"]	= "Evlilik yeri";
$pgv_lang["stat_birth_places"]		= "Doğum yeri";
$pgv_lang["stat_places"]			= "Yerler";
$pgv_lang["stat_last_event"]		= "Son hadise";
$pgv_lang["stat_first_event"]		= "İlk hadise";
$pgv_lang["stat_notes"]				= "Notlar";
$pgv_lang["stat_records"]			= "Kayıtlar";
$pgv_lang["events"]					= "Hadiseler";
$pgv_lang["top_givennames"]			= "Üst belirlenmiş isimler";
$pgv_lang["top_surnames"]			= "Üst soy isimler";
$pgv_lang["statngivennames"]		= "Toplam belirlenmiş isimler";
$pgv_lang["statnsurnames"]			= "Toplam soy isimler";
$pgv_lang["stat_names"]				= "İsimler";
$pgv_lang["stat_age_fm_spouse"]		= "Karı ve Koca arasındaki yaş";
$pgv_lang["stat_age_fm_spouse"]		= "Karı ve Koca arasındaki yaş";
$pgv_lang["stat_age_mf_spouse"]		= "Koca ve Karı arasındaki yaş";
$pgv_lang["stat_top_age_siblings"]	= "Üst kardeşler arasındaki yaş";
$pgv_lang["stat_age_siblings"]		= "Kardeşler arasındaki yaş";
$pgv_lang["stat_age_difference"]	= "Yaş farkı";
$pgv_lang["stat_largest_gfamilies"]	= "Engeniş büyük aile";
$pgv_lang["stat_children_in_fam"]	= "Ailede çocuk";
$pgv_lang["stat_oldest_mother"]		= "Büyük anne";
$pgv_lang["stat_oldest_father"]		= "Büyük baba";
$pgv_lang["stat_youngest_mother"]	= "Engenç anne";
$pgv_lang["stat_youngest_father"]	= "Engeç baba";
$pgv_lang["stat_childbirth_age"]	= "Çocuğu doğumundaki yaşı";
$pgv_lang["stat_oldest_female"]		= "Enyaşlı kadın";
$pgv_lang["stat_oldest_male"]		= "Enyaşlı erkek";
$pgv_lang["stat_youngest_female"]	= "Engenç kadın";
$pgv_lang["stat_youngest_male"]		= "Engenç erkek";
$pgv_lang["stat_short_marr_age"]	= "Enkısa evlilik";
$pgv_lang["stat_long_marr_age"]		= "Enuzun evlilik";
$pgv_lang["stat_marr_age"]			= "Evliliğin süresi";
$pgv_lang["stat_live_longest"]		= "Enyaşlı yaşayan insan";
$pgv_lang["stat_lived_longest"]		= "Üst ölüm yaşı";
$pgv_lang["stat_lifespan"]			= "Ömür";
$pgv_lang["stat_last_death"]		= "Son ölüm";
$pgv_lang["stat_last_divorce"]		= "Son boşanma";
$pgv_lang["stat_last_marriage"]		= "Son evlilik";
$pgv_lang["stat_last_birth"]		= "Son doğum";
$pgv_lang["stat_first_death"]		= "Enerken ölüm";
$pgv_lang["stat_first_divorce"]		= "Enerkenboşanma";
$pgv_lang["stat_first_marriage"]	= "Enerken evlilik";
$pgv_lang["stat_first_birth"]		= "Enerken doğum";
$pgv_lang["stat_deaths"]			= "Toplam ölüm";
$pgv_lang["stat_divorces"]			= "Toplam boşanma";
$pgv_lang["stat_marriages"]			= "Toplam evlilik";
$pgv_lang["stat_births"]			= "Toplam doğum";
$pgv_lang["statndead"]				= "Toplam ölü";
$pgv_lang["statnliving"]			= "Toplam yaşamı";
$pgv_lang["stat_own_charts"]		= "Kendi çizelgeleri";
$pgv_lang["stat_largest_families"] = "Engeniş aileler";
$pgv_lang["stat_7_div"]			= "Yüzyılda boşanmalar";
$pgv_lang["without_sources"]	= "Kaynaklar olmadan";
$pgv_lang["with_sources"]		= "Kaynaklar ile";
$pgv_lang["sources_to_events"]		= "Hadiselere kaynaklar";
$pgv_lang["fact_sources_report"]	= "Gerçek Kaynaklar";
$pgv_lang["descendancy_pronoun_f"]	= "Kadın ";
$pgv_lang["descendancy_pronoun_m"]	= "Erkek ";
$pgv_lang["fam_navigator"]			= "Aile Navigasyon";
$pgv_lang["generation_number"]		= "Nesiller";
$pgv_lang["ID"] 					= "ID";
$pgv_lang["ahnentafel_married_post"]= "&nbsp;";
$pgv_lang["missing_facts_report"]	= "Akrabalar gerçekleri eksik";
$pgv_lang["ward"] = "Koğuş";
$pgv_lang["brothers_wife"]		= "Elti"; // brother's wife
$pgv_lang["cousin_in_law"]		= "Kuzen";
$pgv_lang["grandchildren"]			= "torun";
?>
