<?php
/**
 * Russian Language file for PhpGedView.
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2008  PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @author Eugene Fedorov
 * @author Natalia Anikeeva
 * @version $Id: lang.ru.php 6296 2009-11-04 00:06:28Z canajun2eh $
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

$pgv_lang["SHOW_ID_NUMBERS"]		= "Показать ID-номера имен:";
$pgv_lang["download_file"]		= "Загрузить файл.";
$pgv_lang["cancel"]			= "Прервать";
$pgv_lang["family"]			= "Семья";
$pgv_lang["invalid_search_input"] 	= "Пожалуйста укажите имя, фамилию или место nt в дополнение к году";

//-- GENERAL HELP MESSAGES
$pgv_lang["qm"]				= "?";
$pgv_lang["qm_ah"]				= "?";
$pgv_lang["page_help"]			= "Помощник";
$pgv_lang["help_for_this_page"]	= "Помощь по этой странице";
$pgv_lang["help_contents"]		= "Контекстная помощь";
$pgv_lang["show_context_help"]	= "Показать контекстную помощь";
$pgv_lang["hide_context_help"]	= "Спрятать контекстную помощь";
$pgv_lang["sorry"]				= "<b>Извините, текст помощи об этой странице или объекте пока еще не закончен.</b>";
$pgv_lang["help_not_exist"]		= "<b>Текст помощи об этой странице или объекте пока не готов.</b>";
$pgv_lang["resolution"]			= "Разрешение экрана";
$pgv_lang["menu"]				= "Меню";
$pgv_lang["header"]				= "Заголовок";
$pgv_lang["imageview"]			= "Просмотрщик изображений";
$pgv_lang["login_head"]			= "PhpGedView Вход Пользователя";
//-- CONFIG FILE MESSAGES
$pgv_lang["error_title"]		= "ОШИБКА: Невозможно открыть файл GEDCOM";
$pgv_lang["for_support"]		= "За помощью и информацией просьба обращаться по адресу";
$pgv_lang["for_contact"]		= "С вопросами по генеологии (база данных) обращаться по адресу";
$pgv_lang["for_all_contact"]		= "С вопросами по базе данных и по сайту обращаться по адресу";
$pgv_lang["build_title"]		= "Создание индексных файлов";
$pgv_lang["build_error"]		= "Обнаружен новый файл GEDCOM.";
$pgv_lang["please_wait"]		= "Индексные файлы должны быть обновлены, просьба подождать.";
$pgv_lang["choose_gedcom"]		= "Выберите файл GEDCOM";
$pgv_lang["username"]			= "Имя пользователя:";
$pgv_lang["invalid_username"]	= "Имя пользователя имеет недопустимые символы.";
$pgv_lang["password"]			= "Пароль:";
$pgv_lang["confirm"]			= "Подтверждение пароля";
$pgv_lang["login"]			= "Вход в программу";
$pgv_lang["login_aut"]			= "Мои данные";
$pgv_lang["logout"]			= "Выход из программы";
$pgv_lang["admin"]			= "Администрирование";
$pgv_lang["logged_in_as"]		= "Вы зарегистрированы как";
$pgv_lang["my_pedigree"]		= "Мое восходящее дерево";
$pgv_lang["my_indi"]			= "Я";
$pgv_lang["yes"]			= "Да";
$pgv_lang["no"]				= "Нет";
$pgv_lang["no_support"]			= "Ваша версия программ Интернета не достаточна для требований PhpGedView. Большенство современных версий удовлетворяют этим требованиям. Мы советуем Вам установить более новую версию программ Интернета.";
$pgv_lang["change_theme"]		= "Изменить тему";
//-- INDEX (PEDIGREE_TREE) FILE MESSAGES
$pgv_lang["index_header"]		= "Восходящее Древо";
$pgv_lang["gen_ped_chart"]		= "Восходящее Древо из \$PEDIGREE_GENERATIONS поколений";
$pgv_lang["generations"]		= "Поколения:";
$pgv_lang["view"]			= "Показать";
$pgv_lang["fam_spouse"]			= "Семья с супругом:";
$pgv_lang["root_person"]		= "Начинать с персоны под номером ID:";
$pgv_lang["hide_details"]		= "Спрятать детали";
$pgv_lang["show_details"]		= "Показать детали";
$pgv_lang["person_links"]		= "Ссылки на обзор, фамилии и родство с этой персоной.";
$pgv_lang["zoom_box"]			= "Более расширенные/менее расширенные данные.";
$pgv_lang["portrait"]			= "Вертикально";
$pgv_lang["landscape"]			= "Горизонтально";
$pgv_lang["start_at_parents"]	= "Идти на родителей";
$pgv_lang["charts"]				= "Чертежи";
$pgv_lang["lists"]				= "Списки";
$pgv_lang["welcome_page"]		= "Стартовая страница";
$pgv_lang["max_generation"]		= "Максимальное количество поколений равно #PEDIGREE_GENERATIONS#.";
$pgv_lang["min_generation"]		= "Минимальное количество поколений равно 3.";
$pgv_lang["box_width"] 				= "Ширина рамки";
//-- FUNCTIONS FILE MESSAGES
$pgv_lang["unable_to_find_family"]	= "Невозможно найти Семью под номером ID:";
$pgv_lang["unable_to_find_indi"]	= "Невозможно найти Лицо под номером ID:";
$pgv_lang["unable_to_find_record"]	= "Невозможно найти Запись под номером ID:";
$pgv_lang["unable_to_find_source"]	= "Невозможно найти Источник под номером ID:";
$pgv_lang["unable_to_find_repo"]	= "Невозможно найти Архив под номером ID:";
$pgv_lang["repo_name"]			= "Название архива:";
$pgv_lang["address"]			= "Адрес:";
$pgv_lang["phone"]			= "Телефон:";
$pgv_lang["source_name"]		= "Название источника:";
$pgv_lang["title"]			= "Заголовок:";
$pgv_lang["author"]			= "Автор:";
$pgv_lang["publication"]		= "Публикация:";
$pgv_lang["call_number"]		= "Шифр:";
$pgv_lang["living"]			= "Сведения недоступны";
$pgv_lang["private"]			= "Личные сведения (priv&eacute);";
$pgv_lang["birth"]			= "Рождение: ";
$pgv_lang["death"]			= "Кончина: ";
$pgv_lang["descend_chart"]		= "Нисходящее Древо";
$pgv_lang["individual_list"]		= "Список лиц";
$pgv_lang["family_list"]		= "Список семей";
$pgv_lang["place_list"]			= "География лиц";
$pgv_lang["place_list_aft"] 		= "Разместите иерархию после";
$pgv_lang["media_list"]			= "Список фото/аудио/видео";
$pgv_lang["search"]			= "Поиск";
$pgv_lang["clippings_cart"]		= "Вырезать под-древо";
$pgv_lang["not_an_array"]		= "Нет таблицы";
$pgv_lang["print_preview"]		= "Просмотр для печати";
$pgv_lang["cancel_preview"]		= "Назад к нормальному виду";
$pgv_lang["change_lang"]		= "Изменить язык";
$pgv_lang["print"]			= "Печатать";
$pgv_lang["total_queries"]		= "Количество вопросов по базе данных:";
$pgv_lang["total_privacy_checks"]	= "Полная проверка доступа:";
$pgv_lang["back"]			= "Назад";
$pgv_lang["privacy_list_indi_error"]	= "В соответствии с правами доступа, одна или несколько персон скрыты.";
$pgv_lang["privacy_list_fam_error"]	= "В соответствии с правами доступа, одна или несколько семей скрыты.";
$pgv_lang["aka"]				= "Прозвище";
//-- INDIVUDUAL FILE MESSAGES
$pgv_lang["male"]			= "Муж.";
$pgv_lang["female"]			= "Жен.";
$pgv_lang["temple"]			= "Храм мормонов";
$pgv_lang["temple_code"]		= "Код Храма мормонов:";
$pgv_lang["status"]			= "Статус";
$pgv_lang["source"]			= "Источник:";
$pgv_lang["citation"]			= "Цитата:";
$pgv_lang["text"]			= "Текст:<br />";
$pgv_lang["note"]			= "Примечание:";
$pgv_lang["NN"]					= "(неопределено)";
$pgv_lang["PN"]					= "(неопределено)";
$pgv_lang["unrecognized_code"]		= "Неопознанный тэг GEDCOM";
$pgv_lang["unrecognized_code_msg"]	= "Ошибка, надо бы ее исправить. Пожалуйста, сообщите об ошибке";
$pgv_lang["indi_info"]			= "Персональные сведения";
$pgv_lang["pedigree_chart"]		= "Восходящее<br />Древо";
$pgv_lang["desc_chart2"]		= "Нисходящее<br />Древо";
$pgv_lang["family_with"]		= "Семья и";
$pgv_lang["as_spouse"]			= "-я семья<br />в браке";
$pgv_lang["as_child"]			= "-я семья<br />в детстве";
$pgv_lang["view_gedcom"]		= "Запись в<br />формате GEDCOM";
$pgv_lang["add_to_cart"]		= "Вырезать<br />Под-древо";
$pgv_lang["still_living_error"]		= "Сведения о ныне живущих недоступны.<br />За дополнительной информацией просьба обращаться по адресу";
$pgv_lang["privacy_error"]	    	= "Детальные сведения об этой персоне являются личными; <br />";
$pgv_lang["more_information"]		= "Более полную информацию получить здесь";
$pgv_lang["name"]			= "Фамилия, имя, отчество (имена):";
$pgv_lang["given_name"]			= "Имя, отчество (имена):";
$pgv_lang["surname"]			= "Фамилия:";
$pgv_lang["suffix"]			= "Суффикс:";
$pgv_lang["object_note"]		= "Примечание к объекту:";
$pgv_lang["sex"]			= "Пол:";
$pgv_lang["personal_facts"]		= "Подробности биографии";
$pgv_lang["type"]			= "Событие";
$pgv_lang["place_description"]		= "Место / Описание";
$pgv_lang["parents"] 			= "Родители:";
$pgv_lang["siblings"] 			= "Братья/сестры";
$pgv_lang["father"] 			= "Отец";
$pgv_lang["mother"] 			= "Мать";
$pgv_lang["relatives"]			= "Родство";
$pgv_lang["child"]			= "Ребенок";
$pgv_lang["spouse"]			= "Супруг(а)";
$pgv_lang["surnames"]			= "Фамилии";
$pgv_lang["adopted"]			= "Усыновлен/удочерена";
$pgv_lang["foster"]			= "Приемный (не родной по крови)";
$pgv_lang["sealing"]			= "Закреплено документом";
$pgv_lang["link_as"]			= "\"Привязать\" эту персону к существующей семье как:";
$pgv_lang["no_tab1"]				= "Для этой персоны нету фактов.";
$pgv_lang["no_tab2"]				= "Для этой персоны нет заметок.";
$pgv_lang["no_tab3"]				= "Для этой персоны нет источников цитирования.";
$pgv_lang["no_tab4"]				= "Для этой персоны нет медиа-объектов.";
$pgv_lang["no_tab5"]				= "Нет закрытых родственных отношений для этой персоны.";
$pgv_lang["no_tab6"]				= "Никаких исследовательских записей не присоеденено к персоне.";
//-- FAMILY FILE MESSAGES
$pgv_lang["family_info"]	= "Сведения о семье";
$pgv_lang["family_group_info"]	= "Сведения о семье";
$pgv_lang["husband"]		= "Супруг:";
$pgv_lang["wife"]		= "Супруга:";
$pgv_lang["marriage"]		= "Брак:";
$pgv_lang["lds_sealing"]	= "Печать мормонов:";
$pgv_lang["marriage_license"]	= "Разрешение на брак:";
$pgv_lang["media_object"]	= "Фото/аудио/видео объект:";
$pgv_lang["children"]		= "Дети";
$pgv_lang["no_children"]	= "Сведений о детях нет";
$pgv_lang["parents_timeline"]	= "Показать супругов<br />на временной оси";
//-- CLIPPINGS FILE MESSAGES
$pgv_lang["clip_cart"]			= "Вырезание Под-древа";
$pgv_lang["clip_explaination"]		= "Данный инструмент позволяет вырезать &quot;Под-древа&quot; из Генеалогического Древа данной семьи и соединять их в единый файл формата GEDCOM для последующей загрузки на свой компьютер.<br /><br />";
$pgv_lang["item_with_id"]		= "Элемент под номером ID:";
$pgv_lang["error_already"]		= "уже находится в Вашей корзине.";
$pgv_lang["which_links"]		= "Каких родственников этой семьи Вы желали бы добавить?";
$pgv_lang["just_family"]		= "Добавить запись лишь об этой семье.";
$pgv_lang["parents_and_family"]		= "Добавить записи о родителях вместе с записью об этой семье.";
$pgv_lang["parents_and_child"]		= "Добавить записи о родителях и детях вместе с записью об этой семье.";
$pgv_lang["parents_desc"]		= "Добавить записи о родителях и всех потомках вместе с записью об этой семье.";
$pgv_lang["continue"]			= "Продолжить добавление";
$pgv_lang["which_p_links"]		= "Каких родственников этого лица Вы желали бы добавить?";
$pgv_lang["just_person"]		= "Добавить запись лишь об этом лице.";
$pgv_lang["person_parents_sibs"]	= "Добавить записи об этом лице, его родителях, братьях и сестрах.";
$pgv_lang["person_ancestors"]		= "Добавить записи об этом лице и о всех его прямых предках.";
$pgv_lang["person_ancestor_fams"]	= "Добавить записи об этом лице, о всех его прямых предках и об их семьях.";
$pgv_lang["person_spouse"]		= "Добавить записи об этом лице, его супруге и детях.";
$pgv_lang["person_desc"]		= "Добавить записи об этом лице, его супруге и всех потомках.";
$pgv_lang["unable_to_open"]		= "Невозможно открыть каталог Под-древ на запись";
$pgv_lang["person_living"]		= "Это лицо - современник(ца). Персональные сведения о ныне живущих недоступны и включены не будут.";
$pgv_lang["person_private"]		= "Детальные данные об этом лице являются личными. <br />Персональные сведения не доступны и включены не будут.";
$pgv_lang["family_private"]		= "Детальные данные об этой семье являются личными. Персональные сведения об этой семье недоступны и включены не будут.";
$pgv_lang["person_private"]		= "Детальные сведения об этом лице являются личными. Персональные детальные данные не могут быть добавлены.";
$pgv_lang["download"]			= "Щелкните правой кнопкой мыши на нижеследующую ссылку и выберите &quot;Save target as&quot; для загрузки файла.";
$pgv_lang["media_files"]		= "Фото/аудио/видео файлы, на которые ссылается этот файл GEDCOM";
$pgv_lang["cart_is_empty"]		= "Ваша корзина пуста.";
$pgv_lang["id"]				= "Идентификационный номер";
$pgv_lang["ID"]				= "Идентификационный номер";
$pgv_lang["name_description"]		= "Название / Описание";
$pgv_lang["remove"]			= "Убрать";
$pgv_lang["empty_cart"]			= "Освободить корзину";
$pgv_lang["download_now"]		= "Загрузить файл";
$pgv_lang["indi_downloaded_from"]	= "Данные об этом лице загружены из:";
$pgv_lang["family_downloaded_from"]	= "Данные об этой семье загружены из:";
$pgv_lang["source_downloaded_from"]	= "Источник этой информации загружен из:";
//-- PLACELIST FILE MESSAGES
$pgv_lang["connections"]		= "Географическая связь найдена<br />посмотреть результаты";
$pgv_lang["top_level"]			= "Верхний уровень";
$pgv_lang["form"]			= "Географические названия стоят в следующем порядке: ";
$pgv_lang["gedcom_form_info"]			= "(согласно файла GEDCOM)";
$pgv_lang["default_form_info"]			= "(стандарт)";
$pgv_lang["default_form"]		= "населенный пункт, уезд/район(уездн./рай. центр), губерния/область(губ./обл. центр)/штат, страна";
$pgv_lang["unknown"]			= "Неизвестно";
$pgv_lang["individuals"]		= "Список лиц";
$pgv_lang["view_records_in_place"]	= "Посмотреть список всех лиц, проживавших тут";
$pgv_lang["place_list2"] 			= "Список мест";
$pgv_lang["show_place_hierarchy"]	= "Показать иерархию мест";
$pgv_lang["show_place_list"]		= "Показать все места в виде списка.";
$pgv_lang["total_unic_places"]		= "Полностью уникальные места";
//-- MEDIALIST FILE MESSAGES
$pgv_lang["multi_title"]		= "Список фото/аудио/видео объектов";
$pgv_lang["media_found"]		= "фото/аудио/видео объекты найдены";
$pgv_lang["view_person"]		= "Смотреть сведения о лице";
$pgv_lang["view_family"]		= "Смотреть сведения о семье";
$pgv_lang["view_source"]		= "Смотреть источник";
$pgv_lang["prev"]			= "< предыдущий";
$pgv_lang["next"]			= "cледующий>";
$pgv_lang["file_not_found"]		= "Файл не найден.";
$pgv_lang["medialist_show"] 		= "Показать";
$pgv_lang["per_page"]				= "медиа-объектов на странице";
//-- SEARCH FILE MESSAGES
$pgv_lang["search_gedcom"]		= "Поиск по файлу GEDCOM";
$pgv_lang["enter_terms"]		= "Введите ключевое слово для поиска:";
$pgv_lang["soundex_search"]		= "Фонетический поиск по фамилии (Soundex):";
$pgv_lang["search_results"]		= "Результаты поиска";
$pgv_lang["sources"]			= "Источники";
$pgv_lang["firstname_search"]		= "Имя, отчество:";
$pgv_lang["lastname_search"]		= "Фамилия:";
$pgv_lang["search_place"]		= "Место:";
$pgv_lang["search_year"]		= "Год:";
$pgv_lang["lastname_empty"]		= "Укажите фамилию:";
$pgv_lang["no_results"]			= "Информация по запросу не найдена";
$pgv_lang["soundex_results"]		= "Вполне вероятно что следующие мультимедийные результаты являются важными.";
//-- SOURCELIST FILE MESSAGES
$pgv_lang["source_list"]		= "Список источников";
$pgv_lang["sources_found"]		= "Источники найдены";
$pgv_lang["titles_found"]			= "Заголовки";
//-- SOURCE FILE MESSAGES
$pgv_lang["source_info"]		= "Информация по источнику";
$pgv_lang["other_records"]		= "Другие записи, ссылающиеся на этот источник:";
$pgv_lang["people"]			= "ЛИЦА";
$pgv_lang["families"]			= "СЕМЬИ";
$pgv_lang["total_sources"]			= "Общие источники";
//-- BUILDINDEX FILE MESSAGES
$pgv_lang["building_indi"]		= "Создание индексных файлов лиц и семей";
$pgv_lang["building_index"]		= "Создание индексных файлов";
$pgv_lang["invalid_gedformat"]	= "Неправильный формат GEDCOM 5.5";
$pgv_lang["importing_records"]		= "Добавить записи в базу данных";
$pgv_lang["detected_change"]		= "Программа PhpGedView обнаружила изменения в файле GEDCOM \$GEDCOM. Индексные файлы должны быть обновлены.";
$pgv_lang["flushing"]			= "Стирание оглавления";
$pgv_lang["exec_time"]			= "Общее время исполнения:";
$pgv_lang["unable_to_create_index"]	= "Невозможно создать индексный файл. Задайте разрешение на запись для оглавления PhpGedViewDirectory. Запрет может быть восстановлен после записи индексных файлов.";
$pgv_lang["indi_complete"]		= "Создание индексного файла Лиц завершено.";
$pgv_lang["family_complete"]		= "Создание индексного файла Семей завершено.";
$pgv_lang["source_complete"]		= "Создание индексного файла Источников завершено.";
$pgv_lang["tables_exist"]		= "PhpGedView таблицы уже находятся в базе данных";
$pgv_lang["you_may"]			= "Вы можете:";
$pgv_lang["drop_tables"]		= "Расширить существующие таблицы";
$pgv_lang["import_multiple"]		= "работать с несколькими GEDCOMs файлами";
$pgv_lang["explain_options"]		= "Если Вы будете работать с новым GEDCOM файлом, то вся информация в таблицах будет замещена этим GEDCOM файлом. <br />Если вы будете работать с несколькими GEDCOM файлами, то PhpGedView будет удалять все данные, которые имеют такие же имена GEDCOM файлов. Это действие делает возможным иметь несколько GEDCOM файлов в одних и тех же таблицах и просто заменять данные в таблицах. ";
$pgv_lang["path_to_gedcom"]		= "Укажите путь, где находится Ваш GEDCOM файл:";
$pgv_lang["gedcom_title"]		= "Дайте описание Вашего GEDCOM файла:";
$pgv_lang["index_complete"]		= "Индексация завершена.";
$pgv_lang["updating_is_dead"]		= "Изменить информацию о кончине для персоны INDI";
$pgv_lang["tools_readme"]			= "Более полная информация находится в файле #README.TXT#, путь \"tools-section\".";
$pgv_lang["sec"]				= "сек.";
$pgv_lang["xreftorin"]				= "Преобразовать XREF ID' в RIN номер";
$pgv_lang["dateconvert"]			= "Программа преобразования данных";
$pgv_lang["addmedia"]				= "Ввести медиа-инструменты (фото/аудио/видио)";
$pgv_lang["run_tools"]				= "Вы хотите экспортировать следующие программы до того как импортируете GEDCOM файл:";
$pgv_lang["updating_family_names"]	= "Доработать фамилии для FAM";
$pgv_lang["processed_for"]		= "Файл обработан для";
//-- INDIVIDUAL AND FAMILYLIST FILE MESSAGES
$pgv_lang["total_fams"]			= "семей всего";
$pgv_lang["total_indis"]		= "лиц всего";
$pgv_lang["starts_with"]		= "Начинается на:";
$pgv_lang["person_list"]		= "Список лиц:";
$pgv_lang["paste_person"]		= "Добавить лицо";
$pgv_lang["notes_sources_media"]	= "Примечания, источники и мульмедия (фото/аудио/видео)";
$pgv_lang["notes"]				= "Заметки";
$pgv_lang["ssourcess"]			= "Источники";
$pgv_lang["media"]				= "Медиа";
$pgv_lang["filter"]			= "Фильтр";
$pgv_lang["find_individual"]		= "Искать лицо с номером ID";
$pgv_lang["find_familyid"]			= "Найти Id семьи";
$pgv_lang["find_sourceid"]		= "Найти ID источника";
$pgv_lang["skip_surnames"]		= "Пропустить лист списока фамилий";
$pgv_lang["name_contains"]		= "Имя состоит из:";
$pgv_lang["show_surnames"]		= "Показать список фамилий";
$pgv_lang["all"]			= "ВСЕ";
$pgv_lang["hidden"]					= "Скрытый";
$pgv_lang["confidential"]			= "Конфиденциально";
//-- TIMELINE FILE MESSAGES
$pgv_lang["age"]			= "Возраст: ";
$pgv_lang["timeline_title"]		= "Временная ось PhpGedView";
$pgv_lang["timeline_chart"]		= "Временная ось";
$pgv_lang["remove_person"]		= "Удалить персону";
$pgv_lang["show_age"]			= "Включить указатель возраста";
$pgv_lang["add_another"]		= "Добавить еще одно лицо<br />Идентификационный номер:";
$pgv_lang["find_id"]			= "Найти идент. номер";
$pgv_lang["show"]			= "Показать";
$pgv_lang["year"]			= "Год: ";
$pgv_lang["timeline_instructions"]	= "В последних версиях браузеров можно двигать этикетки у оси мышью.";
$pgv_lang["zoom_in"]			= "Расширить информацию<br />";
$pgv_lang["zoom_out"]			= "Сжать информацию";

$pgv_lang["cal_gregorian"]            = "Грегорианский";
$pgv_lang["cal_julian"]               = "Юлианский";
$pgv_lang["cal_french"]               = "Французский";
$pgv_lang["cal_jewish"]               = "Еврейский";
$pgv_lang["cal_hebrew"]               = "Иврит (дневнееврейский)";
$pgv_lang["cal_jewish_and_gregorian"] = "Еврейский и Грегорианский";
$pgv_lang["cal_hebrew_and_gregorian"] = "Иврит и Грегорианский";

$pgv_lang["jan"]      = "январь";
$pgv_lang["feb"]			= "февраль";
$pgv_lang["mar"]			= "март";
$pgv_lang["apr"]			= "апрель";
$pgv_lang["may"]			= "май";
$pgv_lang["jun"]			= "июнь";
$pgv_lang["jul"]			= "июль";
$pgv_lang["aug"]			= "август";
$pgv_lang["sep"]			= "сентябрь";
$pgv_lang["oct"]			= "октябрь";
$pgv_lang["nov"]			= "ноябрь";
$pgv_lang["dec"]			= "декабрь";
$pgv_lang["abt"]			= "приблизительно";
$pgv_lang["aft"]			= "после";
$pgv_lang["and"]			= "и";
$pgv_lang["bef"]			= "до";
$pgv_lang["bet"]			= "между";
$pgv_lang["cal"]			= "сосчитано";
$pgv_lang["est"]			= "предположительно определено";
$pgv_lang["from"]			= "от";
$pgv_lang["int"]			= "производный";
$pgv_lang["to"]				= "до";
$pgv_lang["cir"]			= "приблизительно";
$pgv_lang["apx"]			= "примерно";
$pgv_lang["user_admin"]			= "Управление пользователями";
$pgv_lang["rebuild_indexes"]		= "Индексировать заново";
$pgv_lang["password_mismatch"]		= "Разные пароли.";
$pgv_lang["enter_username"]		= "Введите имя пользователя.";
$pgv_lang["enter_fullname"]		= "Введите полное имя.";
$pgv_lang["enter_password"]		= "Введите пароль.";
$pgv_lang["confirm_password"]		= "Введите пароль два раза.";
$pgv_lang["save"]			= "Сохранить";
$pgv_lang["delete"]			= "Удалить";
$pgv_lang["edit"]			= "Внести изменения";
$pgv_lang["no_login"]			= "Пользователь не авторизирован.";
$pgv_lang["import_gedcom"]		= "Импортировать этот файл GEDCOM";
$pgv_lang["enter_gedcomid"]		= "Вы должны ввести GEDCOM ID.";
$pgv_lang["user_info"]			= "Информация о пользователях";
$pgv_lang["duplicate_username"]		= "Пользователь с таким именем уже существует. Выберете другое имя пользователя.";
$pgv_lang["enter_filename"]		= "Ввести имя GEDCOM файла.";
$pgv_lang["file_not_exists"]	= "Файл с указанным именем не существует.";
$pgv_lang["file_exists"]		= "GEDCOM файл с таким именем уже существует. Выбирете другое имя или откорректируйте старый файл.";
$pgv_lang["new_gedcom_title"]		= "Генеология из [#GEDCOMFILE#] файла";
$pgv_lang["upload_help"]		= "Выбирете файл, находящийся на локальном жестком диске, который Вы хотите послать на сервер. Этот файл перезапишет существующий GEDCOM файл. После этого файл будет автоматически заново проиндексирован в:";
$pgv_lang["add_gedcom_instructions"]	= "Присвойте имя новому GEDCOM файлу. Этот файл будет перемещен в Index-папку.";
$pgv_lang["research_log"]		= "Архив Log-файлов";
$pgv_lang["utf8_to_ansi"]		= "Преобразовать файл GEDCOM из UTF-8 на ANSI (ISO-8859-1)?";
$pgv_lang["user_manual"]		= "Руководство пользователя PhpGedView";
$pgv_lang["upgrade"]			= "Перейти на более новую версию PhpGedView";
$pgv_lang["step5"]				= "Шаг 5 из 5:";
$pgv_lang["step4"]				= "Шаг 4 из 5:";
$pgv_lang["cancel_upload"]			= "Отменить выгрузку";
$pgv_lang["step3"]				= "Шаг 3 из 5:";
$pgv_lang["step1"]				= "Шаг 1 из 5:";
$pgv_lang["relationship_chart"]		= "Родство";
$pgv_lang["person1"]			= "Лицо 1";
$pgv_lang["person2"]			= "Лицо 2";
$pgv_lang["no_link_found"]		= "Родство между двумя персонами не найдено.";
$pgv_lang["sibling"]			= "Брат/сестра";
$pgv_lang["follow_spouse"]		= "Контролируй родство по браку";
$pgv_lang["timeout_error"]		= "Определить максимальное время поиска для нахождения родственных отношений.";
$pgv_lang["son"]			= "Сын";
$pgv_lang["step5"]				= "Шаг 5 из 5";
$pgv_lang["daughter"]			= "Дочь";
$pgv_lang["brother"]			= "Брат";
$pgv_lang["sister"]			= "Сестра";
$pgv_lang["relationship_to_me"]		= "Родственная связь со мной";
$pgv_lang["next_path"]			= "Искать следующую ветвь";
$pgv_lang["show_path"]			= "Показать ветвь";
$pgv_lang["line_up_generations"]	= "Выстроить в линию одинаковые поколения.";
$pgv_lang["oldest_top"]             = "Показать самого старшего главу семьи";
$pgv_lang["check_delete"]		= "Вы уверены что этот факт GEDCOM хотите удалить?";
$pgv_lang["access_denied"]		= "Доступ отклонен. </b><br />У Вас нет доступа к этому источнику.";
$pgv_lang["changes_exist"]		= "Файл GEDCOM изменен.";
$pgv_lang["find_place"]			= "Искать место";
$pgv_lang["close_window"]		= "Закрыть окно";
$pgv_lang["close_window_without_refresh"]	= "Закрыть окно без сохранения изменений";
$pgv_lang["place_contains"]		= "Место состоит из:";
$pgv_lang["now_import"]			= "Кликните здесь если хотите импортировать записи из GEDCOM в PhpGedView";
$pgv_lang["add"]			= "Добавить";
$pgv_lang["custom_event"]		= "Нестандартное событие";
$pgv_lang["delete_person"]		= "Удалить это лицо";
$pgv_lang["confirm_delete_person"]	= "Вы уверены что хотите удалить эту персону из GEDCOM файла?";
$pgv_lang["find_media"]			= "Искать фото/аудио/видио";
$pgv_lang["set_link"]			= "Присоединить";
$pgv_lang["delete_source"]		= "Удалить этот источник";
$pgv_lang["confirm_delete_source"]	= "Вы уверены что хотите удалить этот источник из GEDCOM файла?";
$pgv_lang["find_family"]		= "Искать семью";
$pgv_lang["find_fam_list"]		= "Найти список семей";
$pgv_lang["edit_name"]			= "Изменить имя";
$pgv_lang["delete_name"]		= "Удалить имя";
$pgv_lang["select_date"]		= "Выбрать дату";
$pgv_lang["user_cannot_edit"]		= "Пользователь с таким именем не может редактировать этот GEDCOM файл.";
$pgv_lang["on_this_day"]		= "В этот день, в прошлом...";
$pgv_lang["in_this_month"]		= "В этом месяце, в прошлом...";
$pgv_lang["in_this_year"]		= "В этом году, в Вашей истории...";
$pgv_lang["year_anniversary"]		= "#year_var# года/лет назад";
$pgv_lang["today"]				= "Сегодня";
$pgv_lang["day"]			= "День:";
$pgv_lang["month"]			= "Месяц:";
$pgv_lang["showcal"]			= "Показать события:";
$pgv_lang["anniversary_calendar"] 	= "Календарь событий";
$pgv_lang["sunday"]			= "Воскресенье";
$pgv_lang["monday"]			= "Понедельник";
$pgv_lang["tuesday"]			= "Вторник";
$pgv_lang["wednesday"]			= "Среда";
$pgv_lang["thursday"]			= "Четверг";
$pgv_lang["friday"]			= "Пятница";
$pgv_lang["saturday"]			= "Суббота";
$pgv_lang["viewday"]			= "Показать день";
$pgv_lang["viewmonth"]			= "Показать месяц";
$pgv_lang["viewyear"]			= "Показать год";
$pgv_lang["all_people"]			= "Все лица";
$pgv_lang["living_only"]		= "Живущие ныне лица";
$pgv_lang["living_only"]		= "Лица, живущие ныне";
$pgv_lang["recent_events"]		= "Последние события (< 100 лет)";
$pgv_lang["day_not_set"]			= "День не установлен";
$pgv_lang["year_error"]			= "Извините, даты ранее 1970 года не поддерживаются.";
$pgv_lang["lost_password"]		= "Потеряли пароль?";
$pgv_lang["requestpassword"]		= "Запрос нового пароля";
$pgv_lang["no_account_yet"]		= "Вы еще не являетесь пользователем?";
$pgv_lang["requestaccount"]		= "Запрос на регистрацию нового пользователя";
$pgv_lang["register_info_01"]		= "Сведения этого сайта не полностью доступны для публичного просмотра. <br /><br /> Это соответствует закону по защите личных прав. Многие люди не желают чтобы сведения о них были доступны для публичного просмотра, т.к. они могут быть использованы в целях злоупотребления полученной информации или в коммерческих целях. <br /><br /> Для того, чтобы Вы смогли посмотреть расширенные сведения, Вы должны зарегистрироваться на нашем сайте. Тогда администратор сможет проконтролировать Ваши личные данные. В случае если у вас существуют родственные связи с каким-либо лицом, информация о котором находится в файле, то после регистрации у Вас будет доступ к информации по Вашиму прямому родству. Администратор может предоставить Вам доступ к данным файла, после того, как Вы введете Ваше личные данные. <br /><br /> Примечание: Доступ к информации, запрещенной для просмотра Вы можете получить только если Вас связывает близкое родство с лицом, информация о котором находится в файле. <br /><br /> В остальных случаях мы просим Вас не тратить время и силы на получение разрешения на просмотр информации. Если Вам необходимо более подробное разъяснение, кликните по нижестоящей кнопочке для контакта с администратором. <br /><br />";
$pgv_lang["pls_note01"]			= "Внимание: система различает заглавные и строчные буквы!";
$pgv_lang["min6chars"]			= "Пароль должен содержать минимум 6 символов";
$pgv_lang["pls_note02"]			= "Внимание: Пароль может содержать только буквы и цифры. Использование знаков препинания недопустимо.";
$pgv_lang["pls_note03"]			= "Пользователь будет активизирован после проверки эл.адреса. Это не будет показано на сайте. На этот эл.адрес Вы получите сообщение, в котором будет находиться необходимая для регистрации информация.";
$pgv_lang["emailadress"]		= "Эл. адрес (e-mail):";
$pgv_lang["pls_note04"]			= "Поля со звездочкой * должны быть заполнены";
$pgv_lang["pls_note05"]			= "Вы получите подтверждение на эл.адрес, который вы указали. С данными из этого письма Вы можете активизировать Ваше имя пользователя. Если Вы это не сделаете в течение 7 дней, то Ваш запрос будет удален. Запрос всегда можно подать заново. Для полного доступа на этот сайт, Вы должны иметь имя пользователя и пароль. Вы должны указать на этом сайте Ваш действующий эл.адрес, на который Вы будете получать данные пользователя.<br /><br /> Если у Вас существуют проблемы с запросом имя пользователя для этого сайте, обратитесь к администратору сайта.";
$pgv_lang["pls_note04"]			= "Поля со звездочкой должны быть заполнены.";
$pgv_lang["pls_note03"]			= "Пользователь будет активизирован после проверки этого эл.адреса. Это не будет показано на сайте. Вы получите сообщение на эл.адрес, в котором будет необходимая для регистрации информация.";
$pgv_lang["mail01_line01"]		= "Здравствуйте, #user_fullname# ...";
$pgv_lang["mail01_line02"]		= "На сервер ( #SERVER_NAME# ) пришел запрос на регистрацию с Вашим эл.адресом ( #user_email# ).";
$pgv_lang["mail01_line03"]		= "Используются следующие данные.";
$pgv_lang["mail01_line04"]		= "Кликните по нижестоящей кнопочке и введите данные для проверки соответствия Вашего имя пользователя и эл.адреса (e-mail).";
$pgv_lang["mail01_line05"]		= "Если Вы эти данные не запрашивали, то удалите это сообщение.";
$pgv_lang["mail01_line06"]		= "Вы не получите больше сообщений, т.к. Ваше имя пользователя не прошло подтверждения и было удалено через 7 дней.";
$pgv_lang["mail01_subject"]		= "Ваша регистрация на #SERVER_NAME#";
$pgv_lang["mail02_line01"]		= "Здравствуйте администратор...";
$pgv_lang["mail02_line02"]		= "Новый пользователь сделал запрос имя пользователя на ( #SERVER_NAME# ).";
$pgv_lang["mail02_line03"]		= "Этот пользователь получил e-mail с информацией, необходимой для контроля.";
$pgv_lang["mail02_line04"]		= "Вы получите сообщение как только пользователь пошлет данные для проверки. После этого Вы можете дать пользователю разрешение на вход на сайт.";
$pgv_lang["mail02_subject"]		= "Сделан запрос на ( #SERVER_NAME# ) для регистрации с Вашим эл.адресом ( #user_email# ).";
$pgv_lang["hashcode"]			= "Контрольный код:";
$pgv_lang["thankyou"]			= "Здравствуйте,  #user_fullname#...<br /> Спасибо за Ваше обращение на наш сайт";
$pgv_lang["pls_note06"]			= "Вы получите подтверждающее письмо на Ваш эл.адрес (#user_email#). С данными из этого письма, Вы можете активизировать свое имя пользователя. Если Вы это не сделаете, по истечению семи дней Ваш запрос будет ликвидирован. Вы этом случае Вы можете имя пользователя запросить вторично. Для регистрации на этом сайте Вы должны иметь имя пользователя и пароль.";
$pgv_lang["registernew"]		= "Подтверждение нового пользователя";
$pgv_lang["user_verify"]		= "Проверка пользователя";
$pgv_lang["send"]			= "Отправить";
$pgv_lang["pls_note07"]			= "Введите Ваше имя пользователя, пароль и контрольный код, который Вы получили в эл.письме.";
$pgv_lang["pls_note08"]			= "Данные пользователя #user_name# проверены.";
$pgv_lang["mail03_line01"]		= "Здравствуйте, администратор...";
$pgv_lang["mail03_line02"]		= "Регистрационные данные #newuser[username]# ( #newuser[fullname]# ) сличены.";
$pgv_lang["mail03_line03"]		= "Кликните по нижестоящей кнопочке, зайдите на сайт и дайте разрешение на регистрацию пользователя.";
$pgv_lang["mail03_subject"]		= "Новый контроль на #SERVER_NAME#";
$pgv_lang["pls_note09"]			= "Вы известны как зарегистрированный пользователь.";
$pgv_lang["pls_note10"]			= "Администратор информирован. Как только он разрешит, Вы можете войти в программу, введя имя пользователя и пароль.";
$pgv_lang["data_incorrect"]		= "Данные не корректны! <br /> Попробуйте еще раз!";
$pgv_lang["user_not_found"]		= "Пользователь не найден!";
$pgv_lang["lost_pw_reset"]		= "Запросите новый пароль";
$pgv_lang["pls_note11"]			= "Если Вы потеряете свой пароль, это вызовет ряд трудностей. В первую очередь это проблема защиты данных. Если он попадет в руки к кому-нибудь, то он может получитьдоступ к запретным данным. В случае потери пароля, пошлите эл.письмо с Вашим именем пользователя для запроса нового пароля. Далее кликните по #pgv_lang[lost_pw_reset]#-knop.<br /><br /> Если имя пользователя и эл.адрес корректы, то Вы получите на свой эл.адрес сообщение с кодом. Введя этот код, Вы можете ввести новый пароль. Позаботьтесь чтобы письмо было защищено от посторонних глаз. Если Вы не помните, какой эл.адрес Вы указывали на нашем сайте, Вы можете ввести несколько своих эл.адресов. Сообщение с кодом будет послано Вам только в случае правильной комбинации имя пользователя и эл.адреса. Если у Вас есть проблемы, то Вы можете обратиться к администратору этого сайта.";
$pgv_lang["enter_email"]		= "Введите эл.адрес.";
$pgv_lang["mail04_line01"]		= "Здравствуйте, #user_fullname#...";
$pgv_lang["mail04_line02"]		= "Для Вашего имя пользователя сделан запрос на новый пароль!";
$pgv_lang["mail04_line03"]		= "Совет:";
$pgv_lang["mail04_line04"]		= "Кликните по нижестоящей кнопке, введите новый пароль и вносите изменения далее.";
$pgv_lang["mail04_subject"]		= "Запрос данных на #SERVER_NAME#";
$pgv_lang["pwreqinfo"]			= "Здравствуйте...<br /><br />Новый пароль послан по эл.почте на (#user[email]#).<br /><br />Через несколько минут вы получите его на свой почтовый ящик.<br /><br />Совет: После получения эл.письма, зайдите на сайт со своим именем пользователя и новым паролем и затем измените свой пароль.";
$pgv_lang["pwreqinfo"]			= "Здравствуйте...<br /><br />Новы";
$pgv_lang["editowndata"]		= "Мои данные";
$pgv_lang["savedata"]			= "Сохранить измененные данные";
$pgv_lang["datachanged"]		= "Данные пользователя изменены!";
$pgv_lang["datachanged_name"]		= "Войдите в программу заново с новым именем пользователя";
$pgv_lang["myuserdata"]			= "Мои данные";
$pgv_lang["user_theme"]			= "Мое оформление сайта";
$pgv_lang["mgv"]				= "Мой GedView";
$pgv_lang["mygedview"]			= "Моя GedView страница";
$pgv_lang["passwordlength"]		= "Пароль должен быть минимум 6 символов";
$pgv_lang["welcome_text_auth_mode_1"]	=	"<b>ДОБРО ПОЖАЛОВАТЬ НА ЭТОТ ГЕНЕАЛОГИЧЕСКИЙ САЙТ</b><br /><br />Доступ к данным сайта разрешен посетителям, которые зарегистрированы тут и имеюют свою учетную запись. <br />Если Вы зарегистрированы, пожалуйста войдите на сайт на этой странице.<br /><br />Если Вы не зарегистрированы, то можете послать запрос на регистрацию перейдя по соответствующей ссылке на этой странице.<br />После того как администратор проверит Вашу информацию, он создаст для Вас учетную запись и отправит Вам письмо (email) для активации этой учетной записи.";
$pgv_lang["welcome_text_auth_mode_2"]	=	"<b>ДОБРО ПОЖАЛОВАТЬ НА ЭТОТ ГЕНЕАЛОГИЧЕСКИЙ САЙТ</b><br /><br />Доступ к данным сайта разрешен посетителям, которые зарегистрированы и <b>авторизованы</b> тут. <br />Если Вы зарегистрированы, пожалуйста войдите на сайт на этой странице.<br /><br />Если Вы тут не зарегистрированы, то можете послать запрос на регистрацию перейдя по соответствующей ссылке на этой странице.<br />После того как администратор проверит Вашу информацию, он создаст для Вас учетную запись и отправит Вам письмо (email) для активации этой учетной записи.";
$pgv_lang["welcome_text_auth_mode_3"]	=	"<b>ДОБРО ПОЖАЛОВАТЬ НА ЭТОТ ГЕНЕАЛОГИЧЕСКИЙ САЙТ</b><br /><br />Доступ к данным сайта разрешен только <b>членам семьи</b>. <br />Если Вы зарегистрированы, пожалуйста войдите на сайт на этой странице.<br /><br />Если Вы тут не зарегистрированы, то можете послать запрос на регистрацию перейдя по соответствующей ссылке на этой странице.<br />После того как администратор проверит Вашу информацию, он создаст для Вас учетную запись и отправит Вам письмо (email) для активации этой учетной записи.";
$pgv_lang["welcome_text_cust_head"]		=	" <b>ДОБРО ПОЖАЛОВАТЬ НА ЭТОТ ГЕНЕАЛОГИЧЕСКИЙ САЙТ</b><br /><br />Доступ к данным сайта разрешен только зарегистрированным пользователям, имеющим учетную запись и пароль.";
$pgv_lang["welcome"]			= "Добро пожаловать";
$pgv_lang["upcoming_events"]		= "Скоро...";
$pgv_lang["chat"]			= "Чат (сhat)";
$pgv_lang["users_logged_in"]		= "Пользователи, работающие сейчас на сайте";
$pgv_lang["message"]			= "Послать сообщение";
$pgv_lang["my_messages"]		= "Мои сообщения";
$pgv_lang["date_created"]		= "Дата послания:";
$pgv_lang["message_from"]		= "Эл.адрес (e-mail):";
$pgv_lang["message_from_name"]		= "Ваше имя:";
$pgv_lang["message_to"]			= "Сообщение для:";
$pgv_lang["message_subject"]		= "Тема:";
$pgv_lang["message_body"]		= "содержание:";
$pgv_lang["no_to_user"]			= "Нет адреса получателя.";
$pgv_lang["provide_email"]		= "Сообщите эл.адрес, на который Вы хотите получить ответ на Ваше письмо. Без указания эл.адреса мы не ответим на Ваше сообщение. ";
$pgv_lang["reply"]			= "Ответ";
$pgv_lang["message_deleted"]		= "Сообщение удалено";
$pgv_lang["message_sent"]		= "Сообщение послано";
$pgv_lang["reset"]			= "Восстановление";
$pgv_lang["site_default"]		= "Стандартный сайт";
$pgv_lang["mygedview_desc"]		= "На Вашей личной страничке MyGedView Вы можете указать свои приоритетные персоны; посмотреть события, которые произойдут в скором времени и работать с другими пользователями PhpGedView этого сайта.";
$pgv_lang["no_messages"]		= "У Вас нет непрочитанных сообщений";
$pgv_lang["clicking_ok"]		= "Если Вы кликните по \"OK\", откроется окно для контакта с  ";
$pgv_lang["my_favorites"]		= "Мои фавориты";
$pgv_lang["no_favorites"]		= "У Вас нет выбранных фаворитов. Вы можете добавить персону в свои фавориты следующим образом: Найдите подробности биографии персоны и кликните по \"Добавить в фавориты\". Если Вы знаете ID номер персоны, то Вы просто можете ввести ID в нижестоящее поле ввода.";
$pgv_lang["add_to_my_favorites"] 	= "Добавить в мои фавориты";
$pgv_lang["gedcom_favorites"]	= "Фавориты этого GEDCOM";
$pgv_lang["no_gedcom_favorites"]	= "На данный момент фавориты не выбраны. Администратор может добавить фаворитов, чтобы они отображались на стартовой странице.";
$pgv_lang["confirm_fav_remove"]		= "Вы уверены что хотите удалить это лицо из своих фаворитов?";
$pgv_lang["portal"]			= "Портал";
$pgv_lang["invalid_email"]		= "Ошибка в эл.адресе (e-mail). Введите правильный адрес.";
$pgv_lang["message_instructions"]	= "<b>Внимание:</b>Конфидициальная информация о ныне живущих лицах предоставляется только родственным и другим авторизированным лицам. Прежде чем получить конфидициальную информацию, будет проверено Ваше родство с этим лицом. Иногда информация об уже умершем также является конфидициальной. Это помогает предотвратить недоразумения если установлено не точно, действительно ли этот человек является умершим. Может быть также возможным что об этой персоне нет больше информации. <br /><br /> Прежде чем задавать запрос, проконтролируйте даты, географию и членов семьи чтобы убедиться что вы выбрали дейтсвительно ту персону, которая Вам нужна. Если Вы предоставляете информацию по генеологии, укажите источник получения этой информации.";
$pgv_lang["sending_to"]			= "Это сообщение будет отправлено #TO_USER#";
$pgv_lang["preferred_lang"]	 	= "Этот пользователь предпочитает получать сообщения на языке #USERLANG#";
$pgv_lang["gedcom_created_using"]	= "Эта GEDCOM база данных была создана с помощью <b>#SOFTWARE# #VERSION#</b>";
$pgv_lang["gedcom_created_on"]	= "Эта GEDCOM база данных была создана <b>#DATE#</b>";
$pgv_lang["gedcom_created_on2"]	= "от <b>#DATE#</b>";
$pgv_lang["gedcom_stats"]		= "GEDCOM Статистика";
$pgv_lang["stat_individuals"]	= "Персон,";
$pgv_lang["stat_families"]		= "Семей,";
$pgv_lang["stat_sources"]		= "Источников,";
$pgv_lang["stat_other"]			= "Других записей";
$pgv_lang["customize_page"]		= "Настроить Мой GedView";
$pgv_lang["customize_gedcom_page"]	= "Настроить Стартовую Страницу";
$pgv_lang["upcoming_events_block"]	= "Блок Наступающих Событий";
$pgv_lang["upcoming_events_descr"]	= "Блок Наступающих Событий отображает список событий текущей GEDCOM базы данных, которые произойдут в следующие 30 дней. Для зарегистрированных пользователей этот блок отображает только живущих людей, для остальных - всех.";
$pgv_lang["todays_events_block"]	= "Блок этого дня";
$pgv_lang["todays_events_descr"]	= "Бок этого дня в Вашей истории... Блок отображает список событий текущей GEDCOM базы данных, которые произошли в этот день. Если таких событий нет, то блок не отображается. Для зарегистрированных пользователей этот блок отображает только живущих людей, для остальных - всех.";
$pgv_lang["logged_in_users_block"]	= "Блок активных пользователей";
$pgv_lang["logged_in_users_descr"]	= "Блок активных пользователей показывает список пользователей, которые находятся на сайте в данный момент.";
$pgv_lang["user_messages_block"]	= "Блок сообщений";
$pgv_lang["user_messages_descr"]	= "Блок сообщений отображает список сообщений присланных активному пользователю.";
$pgv_lang["user_favorites_block"]	= "Блок фаворитов";
$pgv_lang["user_favorites_descr"]	= "Блок фаворитов отображает список персон, выбранных активным пользователем в качестве фаворитов для быстрого доступа к ним. ";
$pgv_lang["welcome_block"]		= "Блок приветствия пользователя";
$pgv_lang["welcome_descr"]		= "Блок приветствия пользователя отображает текущую дату, время, ссылку для изменения настроек, учетной записи и ссылку для быстрого перехода к собственному генеалогическому дереву.";
$pgv_lang["random_media_block"]		= "Блок случайного Медиа-объекта";
$pgv_lang["random_media_descr"]		= "Блок случайного Медиа-объекта случайно выбирает фотографию или другой медиа-объект из текущей GEDCOM базы данных и показывает его пользователю.";
$pgv_lang["gedcom_block"]		= "Блок GEDCOM приветствия";
$pgv_lang["gedcom_descr"]		= "Блок GEDCOM приветствия работает так же как Блок приветствия пользователя, приветствую посетителей сайта и отображая заголовок текущей GEDCOM базы данных, текущую дату и время.";
$pgv_lang["gedcom_favorites_block"]	= "Блок GEDCOM фаворитов";
$pgv_lang["gedcom_favorites_descr"]	= "Блок GEDCOM фаворитов позволяет администратору сайта выбрать некоторых персон из текущей GEDCOM базы данных так, чтобы посетители сайта могли быстро перейти к описанию этих персон. Это способ выделить наиболее важных людей в истории семьи.";
$pgv_lang["gedcom_stats_block"]		= "Блок GEDCOM статистики";
$pgv_lang["gedcom_stats_descr"]		= "Блок GEDCOM статистики отображает посетителем некоторую основную ищвормацию об текущей GEDCOM базе данных, такую как дату ее создания или количество персон в ней.";
$pgv_lang["portal_config_intructions"]	= "Здесь Вы можете настроить свою страницу этого сайта, а именно указать какие блоки и где именно Вы хотите расположить. Станица сайта делится на две секции 'Основную' и 'Правую'. 'Основная' секция отображает большие блоки под заголовком и вниз. 'Правая' секция отображает небольшие блоки в правой части страницы. Каждая секция имеет свой список блоков, которые будут выведены на странице в указанном порядке. Вы можете добавить, удалить или пересортировать блоки в секциях.";
$pgv_lang["login_block"]		= "Блок входа";
$pgv_lang["login_descr"]		= "Блок входа выводит поля для ввода имени и пароля пользователя.";
$pgv_lang["theme_select_block"] 	= "Блок выбора темы";
$pgv_lang["theme_select_descr"] 	= "Блок выбора темы отображает механизм выбора темы, даже если изменение темы запрещено.";
$pgv_lang["block_top10_title"]		= "Наиболее общие фамилии";
$pgv_lang["block_top10"]			= "Блок 10 лучших фамилий";
$pgv_lang["block_top10_descr"]		= "Этот блок показывает таблицу 10 фамилий, которые наиболее часто встречаются в  базе данных.";
$pgv_lang["gedcom_news_block"]		= "Блок новостей GEDCOM";
$pgv_lang["gedcom_news_descr"]		= "Блок новостей GEDCOM отображает посетителям новости о новых версиях или статьи добавленные администратором. Новости хорошее место анонсировать обновление данных или воссоединение семьи.";
$pgv_lang["user_news_block"]		= "Блок дневника пользователя";
$pgv_lang["user_news_descr"]		= "Блок дневника пользователя позволяет пользователю сохранять заметки и вести свой дневник в режиме on-line.";
$pgv_lang["my_journal"]			= "Мой дневник";
$pgv_lang["no_journal"]			= "У Вас не создано ни одной заметки для дневника.";
$pgv_lang["confirm_journal_delete"]	= "Вы уверены что хотите удалить эту заметку из дневника?";
$pgv_lang["add_journal"]		= "Добавить новую заметку в дневник";
$pgv_lang["gedcom_news"]		= "Новости";
$pgv_lang["confirm_news_delete"]	= "Вы уверены что хотите удалить эту новость?";
$pgv_lang["add_news"]			= "Добавить новость";
$pgv_lang["no_news"]			= "Нет новостей";
$pgv_lang["edit_news"]			= "Добавить/Удалить заметку для Дневника/Новостей";
$pgv_lang["enter_title"]		= "Пожалуйста введите заголовок.";
$pgv_lang["enter_text"]			= "Пожалуста введите какой-нибудь текст для этой заметки в Дневник или Новости.";
$pgv_lang["news_saved"]			= "Заметка для Дневника/Новостей успешно сохранена.";
$pgv_lang["article_text"]		= "Текст:";
$pgv_lang["main_section"]		= "Блоки основной секции";
$pgv_lang["right_section"]		= "Блоки правой секции";
$pgv_lang["move_up"]			= "Вверх";
$pgv_lang["move_down"]			= "Вниз";
$pgv_lang["move_right"]			= "Вправо";
$pgv_lang["move_left"]			= "Влево";
$pgv_lang["add_main_block"]		= "Добавить блок в основную секцию...";
$pgv_lang["add_right_block"]		= "Добавить блок в правую секцию";
$pgv_lang["broadcast_all"]		= "Сообщение для всех пользователей";
$pgv_lang["hit_count"]			= "Счетчик посещений";
$pgv_lang["phpgedview_message"]		= "PhpGedView сообщение";
$pgv_lang["common_surnames"]		= "Наиболее общие фамилии";
$pgv_lang["default_news_title"]		= "Добро пожаловать в Вашу Генеалогию";
$pgv_lang["default_news_text"]		= "Генеалогическая информация на этом сайте создана и отображается посредством <a href=\"http://www.phpgedview.net/\" target=\"_blank\">PhpGedView</a>. Эта страница представляет краткое описание этой генеалогической информации. Для просмотра данных выбирите чертеж/дерево в меню чертежей или перейдите к искомой персоне поиском по имении или месту проживания. <br /><br />Если Вы имеете сложности при работе с сайтом, нажмите на меню помощи и получите подсказку по рботе с текущей страницей.<br /><br />Спасибо, за визит.";
$pgv_lang["reset_default_blocks"]	= "Установить набор блоков по умолчанию";
$pgv_lang["recent_changes"]		= "Последние изменения";
$pgv_lang["recent_changes_block"]	= "Блок последних изменений";
$pgv_lang["recent_changes_descr"]	= "Блок последних изменений отображает список изменений сделанных в GEDCOM базе данных за последний месяц. Этот блок поможет Вам быть в курсе поледних изменений.";
$pgv_lang["delete_selected_messages"]	= "Удалить выбранные сообщения";
$pgv_lang["use_blocks_for_default"]	= "Использовать эти блоки по умолчанию для всех пользователей?";
$pgv_lang["enter_subject"]		= "Введите тему сообщения";
$pgv_lang["enter_body"]			= "Введите текст сообщения";
$pgv_lang["confirm_message_delete"]	= "Вы уверены что хотите удалить сообщение? Восстановление невозможно.";
$pgv_lang["message_email1"]		= "Слудующее сообщение послано Вашему пользователю PhpGedView:";
$pgv_lang["message_email2"]		= "Вы послали следующее сообщение пользователю PhpGedView:";
$pgv_lang["message_email3"]		= "Вы послали следующее сообщение администратору PhpGedView:";
$pgv_lang["viewing_url"]		= "Сообщение послано со следующего URL:";
$pgv_lang["messaging2_help"]		= "Если Ваше сообщение послано, то Вы получите копию на эл.адрес, который Вы указали. ";
$pgv_lang["random_picture"]		= "Произвольное изображение";
$pgv_lang["upgrade_util"]		= "Программа выгрузки";
$pgv_lang["no_upgrade"]			= "Нет файлов для работы.";
$pgv_lang["use_version"]		= "Вы используете версию:";
$pgv_lang["current_version"]		= "Действующая в настоящем стабильная версия:";
$pgv_lang["upgrade_download"]		= "Загрузка:";
$pgv_lang["upgrade_tar"]		= "TAR";
$pgv_lang["upgrade_zip"]		= "ZIP";
$pgv_lang["latest"]			= "Вы работаете с последней действующей версией PhpGedView.";
$pgv_lang["location"]			= "Место нахождения файлов новой версии:";
$pgv_lang["include"]			= "Добавить:";
$pgv_lang["options"]			= "Опции:";
$pgv_lang["inc_phpgedview"]		= "PhpGedView";
$pgv_lang["inc_config"]			= "Файл конфигурации";
$pgv_lang["inc_researchlog"]		= "Архив Log-файлов";
$pgv_lang["inc_index"]			= "Индексные файлы";
$pgv_lang["inc_themes"]			= "Темы";
$pgv_lang["inc_docs"]			= "Инструкции";
$pgv_lang["inc_privacy"]		= "Персональный(ые) файл(ы)";
$pgv_lang["inc_backup"]			= "Сделать архивную копию";
$pgv_lang["upgrade_help"]		= "Помощник (по выгрузке)";
$pgv_lang["cannot_read"]		= "Нечитаемый файл:";
$pgv_lang["not_configured"]		= "Ваш PhpGedView еще не конфигурирован.";
$pgv_lang["location_upgrade"]		= "Укажите место расположения файлов для обновления версии.";
$pgv_lang["cannot_read"]		= "Нечитаемф";
$pgv_lang["new_variable"]		= "Найдена новая переменная:";
$pgv_lang["config_open_error"] 		= "Ошибка при открытии файла конфигурации.";
$pgv_lang["config_update_ok"]		= "Файл конфигурации доработан.";
$pgv_lang["config_uptodate"]		= "Ваш файл конфигурации доработан.";
$pgv_lang["processing"]			= "Идет обработка...";
$pgv_lang["privacy_open_error"] 	= "Ошибка при открытии файла [#PRIVACY_MODULE#].";
$pgv_lang["privacy_write_error"] 	= "Ошибка!!! Запись в [#PRIVACY_MODULE#] невозможна. <br /> Убедитесь что у Вас установлены полномочия на запись в этот файл. Установить эти полномочия возможнл в личном (персональном) файле.";
$pgv_lang["privacy_update_ok"]		= "Личный файл [#PRIVACY_MODULE#] доработан.";
$pgv_lang["privacy_uptodate"]		= "Ваш [#PRIVACY_MODULE#] файл доработан.";
$pgv_lang["heading_privacy"]		= "Личные файл(ы):";
$pgv_lang["heading_phpgedview"]		= "PhpGedView-файлы";
$pgv_lang["heading_image"]		= "Файлы мультимедиа (фото/аудио/видио):";
$pgv_lang["heading_index"]		= "Индексные файлы:";
$pgv_lang["heading_language"]		= "Файлы языков:";
$pgv_lang["heading_theme"]		= "Файлы тем:";
$pgv_lang["heading_docs"]		= "Руководство:";
$pgv_lang["heading_researchlog"]	= "Log-файлы (архив, статистика):";
$pgv_lang["heading_researchloglang"]	= "Языковые log-файлы (архив, статистика):";
$pgv_lang["heading_language"]		= "Файлы языков";
$pgv_lang["copied_success"]		= "Копирование удачно завершено";
$pgv_lang["backup_copied_success"]	= "Архивное копирование завершена успешно.";
$pgv_lang["process_error"]		= "Проблема с этой страницей. Более новая версия не найдена.";
$pgv_lang["upgrade_completed"]		= "Обновление успешно завершено";
$pgv_lang["start_using_upgrad"]		= "Нажмите сюда, чтобы начать использовать версию";
$pgv_lang["changed_mac"]		= "Обнуружены окончания строк в стиле Макинтош. Замените окончания строк состоящие только из ВВОДа на ВВОД и ПЕРЕВОД КАРЕТКИ.";
$pgv_lang["changed_places"]		= "Обнаружен неправильный формат географических названий. Исправьте записи географический названий в соответствии со спецификацией GEDCOM 5.5. Пример из Ваших GEDCOM данных:";
$pgv_lang["optional_tools"]		= "Вы можете выбрать для запуска следующие необязательные инструменты перед импортированием.";
$pgv_lang["optional"]			= "Необязательные Инструменты";
$pgv_lang["add_media_tool"]		= "Добавить Медиа-инструмент";
$pgv_lang["launch_media_tool"]		= "Нажмите здесь чтобы запустить Добавление Медиа-инструмента.";
$pgv_lang["add_media_descr"]		= "Этот инструмент будет добавлять медиа OBJE ярлыки к GEDCOM данным. Выбирите это окно когда закончите добавлять медиа-объект.";
$pgv_lang["extension"]			= "Расширение";
$pgv_lang["order"]			= "Порядок";
$pgv_lang["add_media_button"]		= "Добавить Медиа-объект";
$pgv_lang["media_table_created"]	= "Таблица <i>Медиа-объектов</i> успешно обновлена.";
$pgv_lang["click_to_add_media"]		= "Нажмите здесь, чтобы добавить Медиа-объект к GEDCOM данным #GEDCOM#.";
$pgv_lang["adds_completed"]		= "Медиа-объект успешно добавлен в GEDCOM файл.";
$pgv_lang["hourglass_chart"]		= "Двунаправленное дерево";
$pgv_lang["choose_report"]		= "Выбирите отчет для запуска";
$pgv_lang["enter_report_values"]	= "Введите значения отчета";
$pgv_lang["selected_report"]		= "Выбранный отчет";
$pgv_lang["run_report"]			= "Посмотреть отчет";
$pgv_lang["select_report"]		= "Выбрать отчет";
$pgv_lang["download_report"]			= "Скачать отчет";
$pgv_lang["reports"]				= "Отчеты";
$pgv_lang["pdf_reports"]			= "PDF Отчеты";
$pgv_lang["html_reports"]			= "HTML Отчеты";
$pgv_lang["family_group_report"]	= "Групповой отчет семьи";
$pgv_lang["family_group_report"]	= "Отчет группы семей";
$pgv_lang["page"]					= "Страница";
$pgv_lang["of"] 					= " ";
$pgv_lang["enter_famid"]			= "Введити ID семьи";
$pgv_lang["show_sources"]			= "Показать источники?";
$pgv_lang["show_notes"] 			= "Показать заметки?";
$pgv_lang["show_basic"] 			= "Печатать основные события в случае пустоты?";
$pgv_lang["show_photos"]			= "Показать фотографии?";
$pgv_lang["individual_report"]		= "Персональный отчет";
$pgv_lang["enter_pid"]				= "Введите ID персоны";
$pgv_lang["individual_list_report"]	= "Персональный отчет списком";
$pgv_lang["generated_by"]			= "Сгенерировано ";
$pgv_lang["list_children"]			= "Список детей в порядке рождения.";
$pgv_lang["birth_report"]			= "Отчет дня и места рождения";
$pgv_lang["birthplace"]				= "Место рождения включает";
$pgv_lang["birthdate1"]				= "Начало линии дней рождения";
$pgv_lang["birthdate2"]				= "Конец линии дней рождения";
$pgv_lang["sort_by"]				= "Сортировать по";
$pgv_lang["cleanup"]			= "Чистка";
$pgv_lang["dynasty_list"]		= "Обзор семей";
$pgv_lang["make_slklist"]		= "Создать список EXCEL (SLK) ";
$pgv_lang["excel_list"]			= "Вывод в EXCEL (slk) формате следующих файлов (сначало используется список основателей):";
$pgv_lang["excel_tab"]			= "tabblad:";
$pgv_lang["excel_create"]		= "будет создано в файле:";
$pgv_lang["patriarch_list"]		= "Список основателей";
$pgv_lang["slk_list"]			= "EXCEL SLK список";
$pgv_lang["statistics"]			= "Статистика";
$pgv_lang["merge_same"] 			= "Записи разных типов. Невозможно объеденить записи разных типов.";
$pgv_lang["merge_step1"]			= "Объединение шаг 1 из 3";
$pgv_lang["merge_step2"]			= "Объединение шаг 2 из 3";
$pgv_lang["merge_step3"]			= "Объединение шаг 3 из 3";
$pgv_lang["select_gedcom_records"]	= "Выберите 2 GEDCOM записи для объединения. Записи должны быть одного типа.";
$pgv_lang["merge_to"]				= "Слить (объеденить) в ID:";
$pgv_lang["merge_from"] 			= "Слить (объеденить) из ID:";
$pgv_lang["merge_facts_same"]		= "Следующие факты абсолютно одинаковы в двух записях и будут автоматически объеденины.";
$pgv_lang["no_matches_found"]		= "Не найдено совпадающих фактов";
$pgv_lang["unmatching_facts"]		= "Следующие факты не совпадают. Выберите информацию, которую хотите оставить.";
$pgv_lang["record"] 				= "Запись";
$pgv_lang["adding"] 				= "Добавление";
$pgv_lang["updating_linked"]		= "Обновление связанных записей";
$pgv_lang["merge_more"] 			= "Объеденить больше записей.";
$pgv_lang["same_ids"]				= "Вы ввели такой же ID. Вы не можете объеденить одинаковые записи.";
$pgv_lang["ancestry_chart"] 		= "Восходящее дерево";
$pgv_lang["gen_ancestry_chart"]		= "#PEDIGREE_GENERATIONS# Воcходящее дерево поколений";
$pgv_lang["chart_style"]			= "Стиль дерева";
$pgv_lang["ancestry_list"]			= "Список предков";
$pgv_lang["ancestry_booklet"]   	= "Буклет предков";
$pgv_lang["sosa_2"] 				= "Отец";
$pgv_lang["sosa_3"] 				= "Мать";
$pgv_lang["fan_chart"]				= "Веерное дерево";
$pgv_lang["gen_fan_chart"]  		= "#PEDIGREE_GENERATIONS# Веерное дерево поколений";
$pgv_lang["fan_width"]				= "Ширина веера";
$pgv_lang["gd_library"]				= "Ошибка конфигурации PHP сервера: требуется GD библиотека для использования функций работы с изображением.";
$pgv_lang["gd_freetype"]			= "Ошибка конфигурации PHP сервера: требуется Freetype библиотека для использования функций работы с TrueType шрифтами.";
$pgv_lang["gd_helplink"]			= "http://www.php.net/gd";
$pgv_lang["fontfile_error"]			= "Файл с шрифтами не найден на PHP сервере";
$pgv_lang["rss_descr"]				= "Новости и ссылки с сайта #GEDCOM_TITLE#";
$pgv_lang["rss_logo_descr"]			= "Создано на базе PhpGedView";
?>
