<?php
/**
 * Romanian texts
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2010  PGV Development Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 * @author Uifălean Mircea
 * @package PhpGedView
 * @subpackage Languages
 * @version $Id: lang.ro.php 6989 2010-11-09 03:26:25Z canajun2eh $
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

$pgv_lang["age_differences"]		= "Arată diferenţele de date";
$pgv_lang["date_of_entry"]			= "Data intrării în sursele originale";
$pgv_lang["multi_site_search"] 		= "Căutare pe mai multe site-uri";
$pgv_lang["switch_lifespan"]		= "Arată diagrama cu durata de viaţă";
$pgv_lang["switch_timeline"]		= "Arată diagrama cu linia temporală";
$pgv_lang["differences"]			= "Diferenţele";
$pgv_lang["charts_block"]			= "Blocul de diagrame";
$pgv_lang["charts_block_descr"]		= "Blocul de diagrame vă permite să plasaţi o diagramă pe pagina de introducere sau pagina MyGedView.  Puteţi considera blocul să arate strămoşi, descendenţi, sau vederea clepsidră.  Puteţi de-asemenea să alegeţi persoana rădăcină pentru diagramă.";
$pgv_lang["charts_click_box"]		= "Daţi click pe oricare din cutii pentru a obţine mai multe informaţii despre acea persoană.";
$pgv_lang["chart_type"]				= "Tipul de diagramă";
$pgv_lang["changedate1"]			= "Marginea superioară pentru datele de modificare";
$pgv_lang["changedate2"]			= "Marginea inferioară pentru datele de modificare";
$pgv_lang["search_place_word"]		= "Doar cuvinte întregi";
$pgv_lang["invalid_search_input"] 	= "Vă rog introduceţi un prenume, nume, sau locaţie pe lângă an";
$pgv_lang["duplicate_username"] 	= "Nume de utilizator duplicat.  Există deja un utilizator cu acest nume.  Vă rugăm alegeţi alt nume de utilizator.";
$pgv_lang["cache_life"]				= "Durata fişierului de cache";
$pgv_lang["genealogy"]				= "genealogie";
$pgv_lang["activate"]				= "Activează";
$pgv_lang["deactivate"]				= "Dezactivează";
$pgv_lang["play"]					= "Start";
$pgv_lang["stop"]					= "Stop";
$pgv_lang["random_media_start_slide"]	= "Începe prezentarea când se încarcă pagina ?";
$pgv_lang["random_media_ajax_controls"]	= "Arată controalele pentru prezentare ?";
$pgv_lang["description"]			= "Descriere";
$pgv_lang["current_dir"]			= "Directorul curent";
$pgv_lang["SHOW_ID_NUMBERS"]		= "Adata ID-urile lângă nume";
$pgv_lang["SHOW_HIGHLIGHT_IMAGES"]	= "Arată imaginile evidenţiate în căsuţele persoanelor";
$pgv_lang["view_img_details"]		= "Vezi detaliile imaginii";
$pgv_lang["server_folder"]			= "Numele directorului pe server";
$pgv_lang["medialist_recursive"]	= "Listeaza fişierele în subdirectoare";
$pgv_lang["media_options"]			= "Optiuni media";
$pgv_lang["confirm_password"]		= "Trebuie să confirmaţi parola.";
$pgv_lang["enter_email"]			= "Trebuie să introduceţi o adresă de email.";
$pgv_lang["enter_fullname"] 		= "Trebuie să introduceţi nume si prenume.";
$pgv_lang["name"]					= "Nume";
$pgv_lang["children"]				= "Copii";
$pgv_lang["child"]					= "Copil";
$pgv_lang["family"] 				= "Familie";
$pgv_lang["as_child"]				= "Familie cu părinţi";
$pgv_lang["source_menu"]			= "Opţiuni pentru sursă";
$pgv_lang["other_records"]			= "Înregistrări care sunt legate de această sursă:";
$pgv_lang["other_repo_records"]		= "Înregistrări care sunt legate de acest depozit:";
$pgv_lang["repo_info"]				= "Informaţii depozit";
$pgv_lang["enter_terms"]			= "Introduceţi termenii de căutare";
$pgv_lang["search_asso_label"]		= "Asociaţi";
$pgv_lang["search_asso_text"]		= "Arată persoanele/familiile înrudite";
$pgv_lang["search_DM"]				= "Daitch-Mokotoff";
$pgv_lang["search_fams"]			= "Numele familiilor";
$pgv_lang["search_gedcom"]			= "Caută în bazele de date";
$pgv_lang["search_geds"]			= "Bazele de date în care se face căutarea";
$pgv_lang["search_indis"]			= "Numele individului";
$pgv_lang["search_inrecs"]			= "Caută după";
$pgv_lang["search_prtall"]			= "Toate numele";
$pgv_lang["search_prthit"]			= "Numele accesate";
$pgv_lang["results_per_page"]		= "Rezultate pe pagină";
$pgv_lang["firstname_search"]		= "Prenume";
$pgv_lang["search_prtnames"]		= "Numele indivizilor<br />de listat:";
$pgv_lang["other_searches"]			= "Alte căutari";
$pgv_lang["add_to_cart"]			= "Adaugă la coşul de decupări";
$pgv_lang["view_gedcom"]			= "Vizualizează înregistrarea GEDCOM";
$pgv_lang["welcome"]				= "Bine aţi venit";
$pgv_lang["son"]					= "Fiu";
$pgv_lang["daughter"]				= "Fiică";
$pgv_lang["welcome_page"]			= "Introducere";
$pgv_lang["editowndata"]			= "Contul meu";
$pgv_lang["user_admin"] 			= "Administrare utilizatori";
$pgv_lang["manage_media"]			= "Management Media";
$pgv_lang["search_general"]			= "Căutare generală";
$pgv_lang["clipping_privacy"]		= "Unele articole nu au putut fi adăugate din cauza restricţiilor de confidenţialitate";
$pgv_lang["chart_new"]				= "Diagrama arborelui genealogic";
$pgv_lang["loading"]				= "Încărcare...";
$pgv_lang["clear_chart"]			= "Goleşte diagrama";
$pgv_lang["file_information"]		= "Informaţia despre fişier";
$pgv_lang["choose_file_type"]		= "Alegeţi tipul fişierului";
$pgv_lang["add_individual_by_id"]	= "Adaugă individ după ID";
$pgv_lang["advanced_options"]		= "Opţiuni avansate";
$pgv_lang["zip_files"]				= "Arhive Zip";
$pgv_lang["include_media"]			= "Include Media (arhivează automat fişierele)";
$pgv_lang["roman_surn"]				= "Nume de familie romanizate";
$pgv_lang["roman_givn"]				= "Prenume romanizate";
$pgv_lang["include"]				= "Include:";
$pgv_lang["page_x_of_y"]			= "Pagina #GLOBALS[currentPage]# din #GLOBALS[lastPage]#";
$pgv_lang["options"]				= "Opţiuni:";
$pgv_lang["config_update_ok"]		= "Fişierul de configurări a fost modificat cu succes.";
$pgv_lang["page_size"]				= "Mărimea paginii";
$pgv_lang["record_not_found"]		= "GEDCOM-ul dorit nu a fost găsit.  Cauza ar putea fi un link către o persoană invalidă sau un fişier GEDCOM corupt.";
$pgv_lang["result_page"]			= "Pagina cu rezultatul";
$pgv_lang["edit_media"]				= "Modificaţi articolul media";
$pgv_lang["wiki_main_page"]			= "Pagina Wiki principală";
$pgv_lang["wiki_users_guide"]		= "Ghidul utilizatorului Wiki";
$pgv_lang["wiki_admin_guide"]		= "Gidul administratorului Wiki";
$pgv_lang["no_search_for"]			= "Asiguraţi-vă că aţi selectat o opţiune după care să căutaţi.";
$pgv_lang["no_search_site"]			= "Asiguraţi-vă că aţi selectat cel puţin un site îndepărtat.";
$pgv_lang["search_sites"] 			= "Caută în siteuri";
$pgv_lang["site_list"]				= "Site: ";
$pgv_lang["site_had"]				= " a conţinut următoarele";
$pgv_lang["label_search_engine_detected"]  = "Am detectat robot de motor de căutare";

$pgv_lang["ex-spouse"] 				= "Fostul soţ";
$pgv_lang["ex-wife"] 				= "Fosta soţie";
$pgv_lang["ex-husband"] 			= "Fostul soţ";
$pgv_lang["noemail"] 				= "Adresele fără email";
$pgv_lang["onlyemail"] 				= "Doar adresele fără email";
$pgv_lang["maxviews_exceeded"]		= "Rata de #GLOBALS[MAX_VIEWS]# de accesări permise în #GLOBALS[MAX_VIEW_TIME]# secunde a fost depăşită.";
$pgv_lang["broadcast_not_logged_6mo"]	= "Trimite mesaje utilizatorilor care nu s-au mai logat în ultimele 6 luni";
$pgv_lang["broadcast_never_logged_in"]	= "Trimite mesaje utilizatorilor care nu s-au logat niciodată";
$pgv_lang["stats_to_show"]			= "Alegeţi statisticile care doriţi să le vedeţi în acest bloc";
$pgv_lang["stat_avg_age_at_death"]	= "Vârsta medie la momentul decesului";
$pgv_lang["stat_longest_life"]		= "Persoana care a trăit cel mai mult";
$pgv_lang["stat_most_children"]		= "Familia cu cei mai mulţi copii";
$pgv_lang["stat_average_children"]	= "Numărul mediu de copii per familie";
$pgv_lang["stat_events"]			= "Totalul de evenimente";
$pgv_lang["stat_media"]				= "Obiecte media";
$pgv_lang["stat_surnames"]			= "Toate numele de familie";
$pgv_lang["stat_users"]				= "Toţi utilizatorii";
$pgv_lang["no_family_facts"]		= "Nici un fapt pentru această familie.";
$pgv_lang["stat_males"]				= "Toţi bărbaţii";
$pgv_lang["stat_females"]			= "Toate femeile";

$pgv_lang["sunday_1st"]				= "D";
$pgv_lang["monday_1st"]				= "L";
$pgv_lang["tuesday_1st"]			= "Ma";
$pgv_lang["wednesday_1st"]			= "Mi";
$pgv_lang["thursday_1st"]			= "J";
$pgv_lang["friday_1st"]				= "V";
$pgv_lang["saturday_1st"]			= "S";

$pgv_lang["jan_1st"]				= "Ian";
$pgv_lang["feb_1st"]				= "Feb";
$pgv_lang["mar_1st"]				= "Mar";
$pgv_lang["apr_1st"]				= "Apr";
$pgv_lang["may_1st"]				= "May";
$pgv_lang["jun_1st"]				= "Jun";
$pgv_lang["jul_1st"]				= "Jul";
$pgv_lang["aug_1st"]				= "Aug";
$pgv_lang["sep_1st"]				= "Sep";
$pgv_lang["oct_1st"]				= "Oct";
$pgv_lang["nov_1st"]				= "Nov";
$pgv_lang["dec_1st"]				= "Dec";

$pgv_lang["edit_source"]			= "Editează sursa";
$pgv_lang["familybook_chart"]		= "Diagrama 'Albumul de familie'";
$pgv_lang["family_of"]				= "Familie din:&nbsp;";
$pgv_lang["descent_steps"]			= "Paşi descendenţi";

$pgv_lang["cancel"]					= "Anulează";
$pgv_lang["cookie_help"]			= "Acest site foloşte cookies pentru a vă menţine logat.<br /><br />Se pare că nu aveţi activate cookies în navigatorul dumneavoastră. Trebuie să activaţi cookies pentru acest site înainte să vă puteţi loga.  Puteţi consulta documentaţia pentru navigatorului dumneavoastră pentru a afla cum să activaţi cookies.";
//new stuff
//Individual
$pgv_lang["indi_is_remote"]			= "Informaţia pentru acest individ a fost legată de de la un site de la distanţă.";
$pgv_lang["link_remote"]            = "Leagă persoană de la distanţă";
//Add Remote Link
$pgv_lang["title_search_link"]      = "Adaugă legătură locală";
$pgv_lang["label_site_url2"]        = "URL-ul siteului";
//new stuff

$pgv_lang["delete_family_confirm"]	= "Prin ştergerea familiei se dezleagă toţi indivizii unul de celălal dar indivizii ramân la locul lor.  Sunteţi sigur(ă) că doriţi să ştergeţi familia ?";
$pgv_lang["delete_family"]			= "Şterge familia";
$pgv_lang["add_favorite"]			= "Adaugă un nou favorit";
$pgv_lang["url"]					= "URL";
$pgv_lang["add_fav_enter_note"]		= "Introduceţi o notă opţională pentru acest favorit";
$pgv_lang["add_fav_or_enter_url"]	= "sau<br />\nIntroduceţi un URL şi un titlu";
$pgv_lang["add_fav_enter_id"]		= "Introduceţi o persoană, familie sau ID sursă";
$pgv_lang["next_email_sent"]		= "Următorul memento va fi trimis prin email după ";
$pgv_lang["last_email_sent"]		= "Ultimul memento a fost trimis prin email la ";
$pgv_lang["remove_child"]			= "Ştergeţi acest copil de la familie";
$pgv_lang["link_new_husb"]			= "Adaugă un soţ folosind o persoană existentă";
$pgv_lang["link_new_wife"]			= "Adaugă o soţie folosind o persoană existentă";
$pgv_lang["address_labels"]			= "Etichete adrese";
$pgv_lang["filter_address"]			= "Arată adresele care conţin:";
$pgv_lang["address_list"]			= "Lista de adrese";
$pgv_lang["autocomplete"]			= "Autocompletare";
$pgv_lang["index_edit_advice"]		= "Selectaţi un bloc din nume si apoi daţi click pe una din icoanele cu săgeţi pentru a muta blocul selectat în direcţia indicată.";
$pgv_lang["changelog"]				= "Schimbările de la versiunea #VERSION#";
$pgv_lang["html_block_descr"]		= "Acesta este un block HTML simplu pe care-l puteţi pune pe pagina dumneavoastră şi să adăugaţi ce mesaje doriţi.";
$pgv_lang["html_block_sample_part1"]	= "<p class=\"blockhc\"><b>Puneţi titlul aici</b></p><br /><p>Daţi click pe butonul de configurare";
$pgv_lang["html_block_sample_part2"]	= "pentru a schimba ce este tipărit aici.</p>";
$pgv_lang["html_block_name"]		= "HTML";
$pgv_lang["htmlplus_block_name"]	= "HTML avansat";
$pgv_lang["htmlplus_block_descr"]	= "Acesta este un block HTML simplu pe care-l puteţi pune pe pagina dumneavoastră şi să adăugaţi ce mesaje doriţi.  Puteţi insera referinţe către informaţii din GEDCOM-ul dv. in textul HTML.";
$pgv_lang["htmlplus_block_templates"] = "Template-uri";
$pgv_lang["htmlplus_block_content"] = "Conţinut";
$pgv_lang["htmlplus_block_narrative"] = "Stil narativ (doar pentru engleză)";
$pgv_lang["htmlplus_block_custom"]	= "Personalizat";
$pgv_lang["htmlplus_block_keyword"]	= "Exemple de cuvinte cheie (doar pentru engleză)";
$pgv_lang["htmlplus_block_taglist"]	= "Lista de etichete";
$pgv_lang["htmlplus_block_compat"]	= "Modul de compatibilitate";
$pgv_lang["htmlplus_block_current"]	= "Curent";
$pgv_lang["htmlplus_block_default"]	= "Implicit";
$pgv_lang["htmlplus_block_gedcom"]	= "Arborele genealogic";
$pgv_lang["htmlplus_block_birth"]	= "nascut";
$pgv_lang["htmlplus_block_death"]	= "decedat";
$pgv_lang["htmlplus_block_marrage"]	= "căsătorie";
$pgv_lang["htmlplus_block_adoption"]= "adopţie";
$pgv_lang["htmlplus_block_burial"]	= "înmormântare";
$pgv_lang["htmlplus_block_census"]	= "adăugare recensământ";
$pgv_lang["num_to_show"]			= "Numarul de elemente de arătat";
$pgv_lang["days_to_show"]			= "Numărul de zile de arătat";
$pgv_lang["before_or_after"]		= "Plasează numerele inainte sau dupa nume ?";
$pgv_lang["before"]					= "înainte";
$pgv_lang["after"]					= "după";
$pgv_lang["config_block"]			= "Configurare";
$pgv_lang["enter_comments"]			= "Vă rog introduceţi relaţia dumneavoastră cu datele în câmpul de Comentarii.";
$pgv_lang["comments"]				= "Comentarii";
$pgv_lang["child-family"]			= "Părinţi şi fraţi";
$pgv_lang["spouse-family"]			= "Soţi şi copii";
$pgv_lang["direct-ancestors"]		= "Linia directă de strămoşi";
$pgv_lang["ancestors"]				= "Linia directă de strămoşi şi familiile lor";
$pgv_lang["descendants"]			= "Descendenţi";
$pgv_lang["choose_relatives"]		= "Alegeţi rudele";
$pgv_lang["relatives_report"]		= "Raportul rudelor";
$pgv_lang["total_living"]			= "Total în viaţă";
$pgv_lang["total_dead"]				= "Total decedaţi";
$pgv_lang["total_not_born"]			= "Total nenăscuţi";
$pgv_lang["remove_custom_tags"]		= "Stergeţi tag-urile PGV personalizate ? (ex. _PGVU, _THUM)";
$pgv_lang["cookie_login_help"]		= "Acest site şi-a adus aminte de dumneavoastră de la o logare anterioară.  Aceasta vă permite să accesaţi informaţii confidenţiale şi alte facilitaţi oferite utilizatorilor înregistraţi, dar în ordine pentru a modifica sau administra siteul, trebuie să vă logaţi din nou din motive de securitate.";
$pgv_lang["remember_me"]			= "Doriţi să mă ţineţi minte pe acest calculator ?";
$pgv_lang["fams_with_surname"]		= "Familiile cu numele de familie #surname#";
$pgv_lang["support_contact"]		= "Contact pentru asistenţă tehnică";
$pgv_lang["genealogy_contact"]		= "Contact pentru genealogie";
$pgv_lang["common_upload_errors"]	= "Această eroare probabil înseamnă că fişierul pe care aţi încercat să-l uploadaţi a depăşit limita setată de serverul dumneavoastră.  Limita implicită este de 2MB în PHP.  Puteţi contacta grupul de asistenţă tehnică al serverului dumneavoastră şi să-i rugaţi să mărească limita în fişierul php.ini, sau puteţi să uploadaţi fişierul folosind FTP.  Folosiţi pagina <a href=\"uploadgedcom.php?action=add_form\"><b>Adaugă GEDCOM</b></a> pentru a adăuga un fişier GEDCOM uploadat prin FTP.";
$pgv_lang["total_memory_usage"]		= "Memorie totală folosită:";
$pgv_lang["mothers_family_with"]	= "Familia mamei cu ";
$pgv_lang["fathers_family_with"]	= "Familia tatălui cu ";
$pgv_lang["family_with"]			= "Familie cu";
$pgv_lang["halfsibling"]			= "Frate vitreg";
$pgv_lang["halfbrother"]			= "Frate vitreg";
$pgv_lang["halfsister"]				= "Soră vitregă";
$pgv_lang["family_timeline"]		= "Arată familia pe diagrama cu linia temporală";
$pgv_lang["children_timeline"]		= "Arată copiii pe diagrama cu linia temporală";
$pgv_lang["other"]					= "Altele";
$pgv_lang["sort_by_marriage"]		= "Sortează după data căsătoriei";
$pgv_lang["reorder_families"]		= "Rearanjează familiile";
$pgv_lang["indis_with_surname"]		= "Indivizii cu numele de familie #surname#";
$pgv_lang["first_letter_fname"]		= "Alegeţi o literă pentru a arăta indivizii al căror prenume începe cu litera respectivă.";
$pgv_lang["total_names"]			= "Toate numele";
$pgv_lang["top10_pageviews_nohits"]	= "Nu există încă accesări de arătat.";
$pgv_lang["top10_pageviews_msg"]	= "Contoarele de accesări trebuie să fie activate în configuraţia GEDCOM-ului, secţiunea Afişare şi Dispunere, grupul Ascunde şi Arată.";
$pgv_lang["review_changes_descr"]	= "Blocul cu Modificările în aşteptare va afişa pentru utilizatorii cu dreptul de Editare o listă cu înregistrările care au fost modificate online şi care aşteaptă verificarea si acceptarea.  Aceste modificări aşteaptă acceptarea sau respingerea.<br /><br />Dacă acest bloc este activat, utilizatorii cu drepturi de Acceptare vor primi un email zilnic care îi va anunţa că există modificări care au nevoie de verificare.";
$pgv_lang["review_changes_block"]	= "Modificări în aşteptare";
$pgv_lang["review_changes_email"]	= "Trimiteţi emailuri pentru memento-uri ?";
$pgv_lang["review_changes_email_freq"]	= "Frecvenţa emailurilor pentru memento-uri (zile)";
$pgv_lang["review_changes_subject"]	= "PhpGedView - Verificaţi modificările";
$pgv_lang["review_changes_body"]	= "Au fost făcute modificări online la o bază de date cu informaţii despre arborele genealogic.  Aceste schimbări trebuiesc verificate şi acceptate înainte să apară pentru toţi utilizatorii.  Vă rugăm folosiţi URL-ul de mai jos pentru a intra în acel site PhpGedView şi autentificaţi-vă pentru a verifica modificările.";
$pgv_lang["show_pending"]			= "Arată modificările în aşteptare";
$pgv_lang["show_spouses"]			= "Arată soţii";
$pgv_lang["quick_update_title"] 	= "Update rapid";
$pgv_lang["quick_update_instructions"] = "Această pagină vă permite să actualizaţi rapid informaţiile pentru un individ.  Trebuie să completaţi doar informaţiile care sunt noi sau care s-au schimbat faţă de ce există în prezent în baza de date.  După ce modificările au fost trimise trebuie să fie verificate de un administrator înainte de a deveni vizibile pentru toată lumea.";
$pgv_lang["update_name"] 			= "Actualizează nume";
$pgv_lang["update_fact"] 			= "Actualizează un fapt";
$pgv_lang["update_fact_restricted"] = "Actualizarea acestui fapt este restricţionată:";
$pgv_lang["update_photo"] 			= "Actualizează foto";
$pgv_lang["select_fact"] 			= "Selectaţi un fapt...";
$pgv_lang["update_address"] 		= "Actualizează adresa";
$pgv_lang["top10_pageviews_descr"]	= "Acest bloc va arăta 10 înregistrări care au fost vizualizate cel mai mult.  Acest bloc necesită activarea Contoarelor de accesare în setările configuraţiei GEDCOM-ului.";
$pgv_lang["top10_pageviews"]		= "Cele mai vizualizate articole";
$pgv_lang["top10_pageviews_block"]	= "Cele mai vizualizate articole";
$pgv_lang["stepdad"]				= "Tatăl vitreg";
$pgv_lang["stepmom"]				= "Mama vitregă";
$pgv_lang["stepsister"]				= "Sora vitregă";
$pgv_lang["stepbrother"]			= "Fratele vitreg";
$pgv_lang["fams_charts"]			= "Opţiuni pentru familie";
$pgv_lang["indis_charts"]			= "Opţiuni pentru individ";
$pgv_lang["none"]					= "Nici unul";
$pgv_lang["locked"]					= "Nu schimbaţi";
$pgv_lang["privacy"]				= "Confidenţialitate";
$pgv_lang["number_sign"]			= "#";

//-- GENERAL HELP MESSAGES
$pgv_lang["qm"] 					= "?";
$pgv_lang["qm_ah"]					= "?";
$pgv_lang["page_help"]				= "Ajutor";
$pgv_lang["help_for_this_page"] 	= "Ajutor pentru această pagină";
$pgv_lang["help_contents"]			= "Cuprins ajutor";
$pgv_lang["show_context_help"]		= "Arată ajutor contextual";
$pgv_lang["hide_context_help"]		= "Ascunde ajutorul contextual";
$pgv_lang["sorry"]					= "<b>Ne pare rău, textul de ajutor pentru această pagină sau articol nu este încă disponibil.</b>";
$pgv_lang["help_not_exist"] 		= "<b>Textul de ajutor pentru această pagină sau articol nu este încă disponibil.</b>";
$pgv_lang["var_not_exist"]			= "<span style=\"font-weight: bold\">Variabila pentru limbă nu există. Vă rugăm raportaţi acest lucru deoarece este o eroare.</span>";
$pgv_lang["resolution"] 			= "Rezoluţia monitorului";
$pgv_lang["menu"]					= "Meniu";
$pgv_lang["header"] 				= "Antet";
$pgv_lang["imageview"]				= "Vizualizator de imagini";

//-- CONFIG FILE MESSAGES
$pgv_lang["login_head"] 			= "Logare utilizator PhpGedView";
$pgv_lang["for_support"]			= "Contact pentru informaţii şi suport tehnic";
$pgv_lang["for_contact"]			= "Contact pentru ajutor cu întrebările legate de genealogie";
$pgv_lang["for_all_contact"]		= "Pentru suport tehnic sau întrebări de genealogie, vă rugăm contactaţi";
$pgv_lang["build_error"]			= "Fişierul GEDCOM a fost actualizat.";
$pgv_lang["choose_username"]		= "Nume utilizator dorit";
$pgv_lang["username"]				= "Nume utilizator";
$pgv_lang["invalid_username"]		= "Numele utilizatorului conţine caractere invalide";
$pgv_lang["firstname"]				= "Prenume";
$pgv_lang["lastname"]				= "Nume";
$pgv_lang["choose_password"]		= "Parola dorită";
$pgv_lang["password"]				= "Parola";
$pgv_lang["confirm"]				= "Confirmaţi parola";
$pgv_lang["login"]					= "Autentificare";
$pgv_lang["logout"] 				= "Ieşire";
$pgv_lang["admin"]					= "Administrator";
$pgv_lang["logged_in_as"]			= "Autentificat ca ";
$pgv_lang["my_pedigree"]			= "Arborele meu genealogic";
$pgv_lang["my_indi"]				= "Înregistrarea mea individuală";
$pgv_lang["yes"]					= "Da";
$pgv_lang["no"] 					= "Nu";
$pgv_lang["change_theme"]			= "Schimbă tema";

//-- INDEX (PEDIGREE_TREE) FILE MESSAGES
$pgv_lang["index_header"]			= "Arborele genealogic";
$pgv_lang["gen_ped_chart"]			= "#PEDIGREE_GENERATIONS# Diagrama cu generaţiile arborelui genealogic";
$pgv_lang["generations"]			= "Generaţiile";
$pgv_lang["view"]					= "Vizualizează";
$pgv_lang["fam_spouse"] 			= "Familie cu soţul/soţia";
$pgv_lang["root_person"]			= "ID-ul persoanei rădăcină";
$pgv_lang["hide_details"]			= "Ascunde detaliile";
$pgv_lang["show_details"]			= "Arată detaliile";
$pgv_lang["person_links"]			= "Linkuri către diagrame, familii, şi rudele apropiate ale acestei persoane. Daţi click pe această icoană pentru a vedea această pagină, începând de la această persoană.";
$pgv_lang["zoom_box"]				= "Măriţi sau micşoraţi cutia aceasta.";
$pgv_lang["orientation"]			= "Orientarea";
$pgv_lang["portrait"]				= "Portret";
$pgv_lang["landscape"]				= "Peisaj";
$pgv_lang["start_at_parents"]		= "Începe la părinţi";
$pgv_lang["charts"] 				= "Diagrame";
$pgv_lang["lists"]					= "Liste";
$pgv_lang["max_generation"] 		= "Numărul maxim de generaţii în arborele genealogic este #PEDIGREE_GENERATIONS#.";
$pgv_lang["min_generation"] 		= "Numărul minim de generaţii în arborele genealogic este 3.";
$pgv_lang["box_width"] 				= "Lăţimea cutiei";

//-- FUNCTIONS FILE MESSAGES
$pgv_lang["unable_to_find_family"]	= "Nu am găsit familia cu ID-ul";
$pgv_lang["unable_to_find_record"]	= "Nu am găsit înregistrarea cu ID-ul";
$pgv_lang["title"]					= "Titlu:";
$pgv_lang["living"] 				= "În viaţă";
$pgv_lang["private"]				= "Privat";
$pgv_lang["birth"]					= "Născut:";
$pgv_lang["death"]					= "Decedat:";
$pgv_lang["descend_chart"]			= "Diagrama descendenţilor";
$pgv_lang["individual_list"]		= "Lista indivizilor";
$pgv_lang["family_list"]			= "Lista familiilor";
$pgv_lang["source_list"]			= "Lista surselor";
$pgv_lang["place_list"] 			= "Ierarhia locurilor";
$pgv_lang["place_list_aft"] 		= "Ierarhia locurilor după";
$pgv_lang["media_list"] 			= "Lista multimedia";
$pgv_lang["search"] 				= "Caută";
$pgv_lang["clippings_cart"] 		= "Căruciorul cu decupaje din arborele familiei";
$pgv_lang["print_preview"]			= "Versiune ce poate fi tipărită";
$pgv_lang["cancel_preview"] 		= "Înapoi la vederea normală";
$pgv_lang["change_lang"]			= "Schimbă limba";
$pgv_lang["print"]					= "Tipăreşte";
$pgv_lang["total_queries"]			= "Total interogări asupra bazei de date: ";
$pgv_lang["total_privacy_checks"]	= "Total verificări de confidenţialitate: ";
$pgv_lang["back"]					= "Înapoi";

//-- INDIVIDUAL FILE MESSAGES
$pgv_lang["aka"]					= "Aliasuri";
$pgv_lang["male"]					= "Bărbat";
$pgv_lang["female"] 				= "Femeie";
$pgv_lang["temple"] 				= "Templu LDS";
$pgv_lang["temple_code"]			= "Codul templului LDS:";
$pgv_lang["status"] 				= "Statut";
$pgv_lang["source"] 				= "Sursă";
$pgv_lang["text"]					= "Sursă text:";
$pgv_lang["note"]					= "Notă";
$pgv_lang["NN"] 					= "(necunoscut)";
$pgv_lang["PN"] 					= "(necunoscut)";
$pgv_lang["unrecognized_code"]		= "Cod GEDCOM nerecunoscut";
$pgv_lang["unrecognized_code_msg"]	= "Aceasta este o eroare şi am dori să o reparăm. Vă rugăm raportaţi această eroare la";
$pgv_lang["indi_info"]				= "Informaţii individ";
$pgv_lang["pedigree_chart"] 		= "Diagrama arborelui de familie";
$pgv_lang["individual"]				= "Individ";
$pgv_lang["as_spouse"]				= "Familie cu soţul/soţia";
$pgv_lang["privacy_error"]			= "Această informaţie este privată şi nu poate fi aratată.";
$pgv_lang["more_information"]		= "Pentru mai multe informaţii contactaţi";
$pgv_lang["given_name"] 			= "Prenume:";
$pgv_lang["surname"]				= "Nume familie:";
$pgv_lang["suffix"] 				= "Sufix:";
$pgv_lang["sex"]					= "Sex";
$pgv_lang["personal_facts"] 		= "Fapte personale şi detalii";
$pgv_lang["type"]					= "Tip";
$pgv_lang["parents"]				= "Părinţi:";
$pgv_lang["siblings"]				= "Frate/soră";
$pgv_lang["father"] 				= "Tată";
$pgv_lang["mother"] 				= "Mamă";
$pgv_lang["parent"] 				= "Părinte";
$pgv_lang["self"] 					= "Sine";
$pgv_lang["relatives"]				= "Rude apropiate";
$pgv_lang["relatives_events"]		= "Evenimentele rudelor apropiate";
$pgv_lang["historical_facts"]		= "Fapte istorice";
$pgv_lang["partner"] 				= "Partener";
$pgv_lang["spouse"] 				= "Soţ/soţie";
$pgv_lang["spouses"] 				= "Soţi";
$pgv_lang["surnames"]				= "Nume familie";
$pgv_lang["adopted"]				= "Adoptat";
$pgv_lang["foster"] 				= "Tutore";
$pgv_lang["sealing"]				= "Sigiliu";
$pgv_lang["challenged"]				= "Provocat";
$pgv_lang["disproved"]				= "Nedovedit";
$pgv_lang["infant"]					= "Prunc";
$pgv_lang["stillborn"]				= "Născut decedat";
$pgv_lang["deceased"]				= "Decedat";
$pgv_lang["link_as_wife"]			= "Legaţi această persoană de o familie existentă ca soţie";
$pgv_lang["no_tab1"]				= "Nu există fapte pentru acest individ.";
$pgv_lang["no_tab2"]				= "Nu există note pentru acest individ.";
$pgv_lang["no_tab3"]				= "Nu există surse citate pentru acest individ.";
$pgv_lang["no_tab4"]				= "Nu există obiecte media pentru acest individ.";
$pgv_lang["no_tab5"]				= "Nu există rude apropiate pentru acest individ.";
$pgv_lang["no_tab6"]				= "Nu există jurnale de cercetare ataşate acestui individ.";
$pgv_lang["show_fact_sources"]		= "Arată toate sursele";
$pgv_lang["show_fact_notes"]		= "Arată toate notele";

//-- FAMILY FILE MESSAGES
$pgv_lang["family_info"]			= "Informaţii familie";
$pgv_lang["family_group_info"]		= "Informaţii grup familie";
$pgv_lang["husband"]				= "Soţ";
$pgv_lang["wife"]					= "Soţie";
$pgv_lang["marriage"]				= "Căsătorie:";
$pgv_lang["lds_sealing"]			= "Sigiliu LDS:";
$pgv_lang["marriage_license"]		= "Certificat căsătorie:";
$pgv_lang["no_children"]			= "Nu există copii înregistraţi";
$pgv_lang["childless_family"]		= "Această familie a rămas fără copii";
$pgv_lang["parents_timeline"]		= "Arată cuplu pe diagrama liniei temporale";

//-- CLIPPINGS FILE MESSAGES
$pgv_lang["clip_cart"]				= "Căruciorul cu decupaje";
$pgv_lang["which_links"]			= "Ce alte linkuri de la această familie mai doriţi să adăugaţi ?";
$pgv_lang["just_family"]			= "Adaugă înregistrarea doar pentru această familie.";
$pgv_lang["parents_and_family"] 	= "Adaugă înregistrările părinţilor împreună cu înregistrearea acestei familii.";
$pgv_lang["parents_and_child"]		= "Adaugă înregistrările copiilor împreună cu înregistrearea acestei familii.";
$pgv_lang["parents_desc"]			= "Adaugă înregistrările părinţilor şi ale tuturor descendenţilor împreună cu înregistrearea acestei familii.";
$pgv_lang["continue"]				= "Continuă adăugarea";
$pgv_lang["which_p_links"]			= "Care linkuri de la această persoană mai doriţi să le adăugaţi ?";
$pgv_lang["just_person"]			= "Adăugaţi doar această persoană.";
$pgv_lang["person_parents_sibs"]	= "Adăugaţi această persoană, părinţii şi fraţii persoanei.";
$pgv_lang["person_ancestors"]		= "Adaugaţi această persoană si linia directă de strămoşi.";
$pgv_lang["person_ancestor_fams"]	= "Adaugaţi această persoană, linia directă de strămoşi şi familiile lor.";
$pgv_lang["person_spouse"]			= "Adaugaţi această persoană, soţul/soţia ei, şi copiii.";
$pgv_lang["person_desc"]			= "Adaugaţi această persoană, soţul/soţia ei, şi toţi descendenţii.";
$pgv_lang["which_s_links"]			= "Care înregistrări legate de această sursă ar trebui adăugate ?";
$pgv_lang["just_source"]			= "Adaugă doar această sursă.";
$pgv_lang["linked_source"]			= "Adaugă această sursă şi familiile/persoanele legate de ea.";
$pgv_lang["person_private"] 		= "Detaliile acestei persoane sunt private. Detaliile personale nu vor fi incluse.";
$pgv_lang["family_private"] 		= "Detaliile acestei familii sunt private. Detaliile familiei nu vor fi incluse.";
$pgv_lang["download"]				= "Daţi clic drept (control-click pe un Macintosh) pe linkurile de mai jos şi selectaţi &quot;Save target as&quot; pentru a downloada fişierele.";
$pgv_lang["cart_is_empty"]			= "Coşul dumneavoastră de decupaje este gol.";
$pgv_lang["id"] 					= "ID";
$pgv_lang["ID"] 					= "ID";
$pgv_lang["name_description"]		= "Nume / Descriere";
$pgv_lang["remove"] 				= "Şterge";
$pgv_lang["empty_cart"] 			= "Goleşte coşul";
$pgv_lang["download_now"]			= "Downloadează acum";
$pgv_lang["download_file"]			= "Downloadează fişierul #GLOBALS[whichFile]#";
$pgv_lang["indi_downloaded_from"]	= "Acest individ a fost downloadat de la:";
$pgv_lang["family_downloaded_from"] = "Această familie a fost downloadată de la:";
$pgv_lang["source_downloaded_from"] = "Această sursă a fost downloadată de la:";

//-- PLACELIST FILE MESSAGES
$pgv_lang["connections"]			= "Plasează conexiunile găsite";
$pgv_lang["top_level"]				= "Nivelul superior";
$pgv_lang["form"]					= "Locurile sunt codificate în forma: ";
$pgv_lang["default_form"]			= "Oraş, Judeţ, Stat/Provincie, Ţară";
$pgv_lang["default_form_info"]		= "(Implicit)";
$pgv_lang["unknown"]				= "necunoscut";
$pgv_lang["individuals"]			= "Indivizi";
$pgv_lang["view_records_in_place"]	= "Vizualizează toate înregistrările găsite în acest loc";
$pgv_lang["place_list2"] 			= "Lista locurilor";
$pgv_lang["show_place_hierarchy"]	= "Arata locurile în ierarhie";
$pgv_lang["show_place_list"]		= "Arată toate locurile într-o listă";
$pgv_lang["total_unic_places"]		= "Toate locurile unice";

//-- MEDIALIST FILE MESSAGES
$pgv_lang["external_objects"]		= "Obiecte externe";
$pgv_lang["multi_title"]			= "Lista obiectelor multimedia";
$pgv_lang["media_found"]			= "Obiecte media găsite";
$pgv_lang["view_person"]			= "Vizualizează persoană";
$pgv_lang["view_family"]			= "Vizualizează familie";
$pgv_lang["view_source"]			= "Vizualizează sursă";
$pgv_lang["view_object"]			= "Vizualizează obiect";
$pgv_lang["prev"]					= "&lt; Anterior";
$pgv_lang["next"]					= "Următor &gt;";
$pgv_lang["next_image"]				= "Următoarea imagine";
$pgv_lang["file_not_found"] 		= "Fişierul nu a fost găsit.";
$pgv_lang["medialist_show"] 		= "Arată";
$pgv_lang["per_page"]				= "obiecte media pe pagină";
$pgv_lang["media_format"]			= "Formatul media";
$pgv_lang["image_size"]				= "Dimensiunile imaginii";
$pgv_lang["media_id"]				= "ID media";
$pgv_lang["invalid_id"]				= "Nu există acest ID în acest fisier GEDCOM.";
$pgv_lang["record_updated"]			= "Înregistrarea #pid# a fost actualizată cu succes.";
$pgv_lang["record_not_updated"]		= "Înregistrarea #pid# nu putut fi actualizată.";
$pgv_lang["record_removed"]			= "Înregistrarea #xref# a fost ştearsă cu succes din GEDCOM.";
$pgv_lang["record_not_removed"]		= "Înregistrarea #xref# nu a putut fi ştearsă din GEDCOM.";
$pgv_lang["record_added"]			= "Înregistrarea #xref# a fost adăugată cu success în GEDCOM.";
$pgv_lang["record_not_added"]		= "Înregistrarea #xref# nu a putut fi adăugată în GEDCOM.";

//-- SEARCH FILE MESSAGES
$pgv_lang["soundex_search"] 		= "Cautare după cum credeţi că se scrie numele (Soundex)";
$pgv_lang["sources"]				= "Surse";
$pgv_lang["lastname_search"]		= "Nume";
$pgv_lang["search_place"]			= "Loc";
$pgv_lang["search_year"]			= "An";
$pgv_lang["no_results"] 			= "Nu au fost găsite rezultate.";
$pgv_lang["search_soundex"]			= "Căutare soundex";
$pgv_lang["search_replace"]			= "Caută şi înlocuieşte";
$pgv_lang["search_sources"]			= "Surse";
$pgv_lang["search_more_chars"]      = "Vă rugăm introduceţi mai mult de un caracter";
$pgv_lang["search_soundextype"]		= "Tip soundex:";
$pgv_lang["search_russell"]			= "De bază";
$pgv_lang["search_tagfilter"]		= "Exclude filtru";
$pgv_lang["search_tagfon"]			= "Exclude unele date care nu sunt de natură genealogică";
$pgv_lang["search_tagfoff"]			= "Oprit";
$pgv_lang["associate"]				= "asociază";
$pgv_lang["search_record"]			= "Înregistrare întreagă";
$pgv_lang["search_to"]				= "până la";

//-- SOURCELIST FILE MESSAGES
$pgv_lang["titles_found"]			= "Titluri";
$pgv_lang["find_source"]			= "Găseşte sursă";

//-- REPOLIST FILE MESSAGES
$pgv_lang["repo_list"]				= "Lista";
$pgv_lang["repos_found"]			= "Găsit depozite";
$pgv_lang["find_repository"]		= "Găseşte depozite";
$pgv_lang["total_repositories"]		= "Toate depozitele";
$pgv_lang["confirm_delete_repo"]	= "Sunteţi sigur(ă) că doriţi să ştergeţi acest depozit din baza de date ?";

//-- SOURCE FILE MESSAGES
$pgv_lang["source_info"]			= "Informaţia despre sursă";
$pgv_lang["people"] 				= "Oameni";
$pgv_lang["families"]				= "Familii";
$pgv_lang["total_sources"]			= "Toate sursele";

//-- BUILDINDEX FILE MESSAGES
$pgv_lang["invalid_gedformat"]		= "Format GEDCOM invalid";
$pgv_lang["exec_time"]				= "Timpul de execuţie:";
$pgv_lang["unable_to_create_index"] = "Nu am putut crea fişiere index.  Asiguraţi-vă că directorul PhpGedView are setate permisiunile de scriere.  Permisiunile pot fi refăcute odată ce fişierele index au fost scrise.";
$pgv_lang["changes_present"]		= "GEDCOM-ul curent are modificări în aşteptare.  Dacă veţi continua acest Import, aceste modificări în aşteptare vor fi salvate în baza de date imediat.  Ar trebui să verificaţi modificările din aşteptare înainte să continuaţi cu Importul.";
$pgv_lang["sec"]					= "sec.";

//-- INDIVIDUAL AND FAMILYLIST FILE MESSAGES
$pgv_lang["total_fams"] 			= "Toate familiile";
$pgv_lang["total_indis"]			= "Toţi indivizii";
$pgv_lang["notes"]					= "Note";
$pgv_lang["ssourcess"]				= "Surse";
$pgv_lang["media"]					= "Media";
$pgv_lang["name_contains"]			= "Numele conţine:";
$pgv_lang["filter"] 				= "Filter";
$pgv_lang["find_individual"]		= "Găseşte ID-ul individului";
$pgv_lang["find_familyid"]			= "Găseşte ID-ul familiei";
$pgv_lang["find_sourceid"]			= "Găseşte ID-ul sursei";
$pgv_lang["find_specialchar"]		= "Găseşte caractere speciale";
$pgv_lang["magnify"]				= "Măreşte";
$pgv_lang["skip_surnames"]			= "Exclude lista de nume de familie";
$pgv_lang["show_surnames"]			= "Arată lista numelor de familie";
$pgv_lang["all"]					= "Toate";
$pgv_lang["hidden"]					= "Ascunse";
$pgv_lang["confidential"]			= "Confidenţial";
$pgv_lang["alpha_index"]			= "Index alfabetic";
$pgv_lang["name_list"] 				= "Lista numelor";
$pgv_lang["firstname_alpha_index"] 	= "Indexul alfabetic al prenumelor";
$pgv_lang["roots"]		 			= "Rădăcini";
$pgv_lang["leaves"] 				= "Frunze";
$pgv_lang["widow"] 					= "Văduvă";
$pgv_lang["widower"] 				= "Văduv";

//-- TIMELINE FILE MESSAGES
$pgv_lang["age"]					= "Vârsta";
$pgv_lang["days"]					= "zile";
$pgv_lang["months"]					= "luni";
$pgv_lang["years"]					= "ani";
$pgv_lang["day1"]					= "zi";
$pgv_lang["month1"]					= "lună";
$pgv_lang["year1"]					= "an";
$pgv_lang["after_death"]        	= "după moarte";
$pgv_lang["timeline_title"] 		= "Linia temporală PhpGedView";
$pgv_lang["timeline_chart"] 		= "Diagrama liniei temporale";
$pgv_lang["remove_person"]			= "Şterge persoană";
$pgv_lang["show_age"]				= "Arată markerul vârstă";
$pgv_lang["add_another"]			= "Adaugă altă persoană la diagramă:<br />ID persoană:";
$pgv_lang["find_id"]				= "Găseşte ID";
$pgv_lang["show"]					= "Arată";
$pgv_lang["year"]					= "An:";
$pgv_lang["timeline_instructions"]	= "În cele mai recente navigatoare puteţi da click şi să trageţi cutiile în jurul diagramei.";
$pgv_lang["zoom_in"]				= "Măreşte";
$pgv_lang["zoom_out"]				= "Micşorează";
$pgv_lang["timeline_beginYear"] 	= "Anul de început";
$pgv_lang["timeline_endYear"] 		= "Anul de sfârşit";
$pgv_lang["timeline_scrollSpeed"] 	= "Viteza";
$pgv_lang["timeline_controls"] 		= "Controalele liniei temporale";
$pgv_lang["include_family"] 		= "Include familia intermediară";
$pgv_lang["lifespan_chart"] 		= "Diagrama duratei de viaţă";

// calendar conversion options
$pgv_lang["cal_none"]                 = "Fără conversie de calendar";
$pgv_lang["cal_gregorian"]            = "Gregorian";
$pgv_lang["cal_julian"]               = "Iulian";
$pgv_lang["cal_french"]               = "Francez";
$pgv_lang["cal_jewish"]               = "Evreiesc";
$pgv_lang["cal_hebrew"]               = "Ebraic";
$pgv_lang["cal_jewish_and_gregorian"] = "Evreiesc şi Gregorian";
$pgv_lang["cal_hebrew_and_gregorian"] = "Ebraic şi Gregorian";
$pgv_lang["cal_hijri"]                = "Hijri";
$pgv_lang["cal_arabic"]               = "Arabic";

// some religious dates
$pgv_lang["easter"]     = "Paşte";
$pgv_lang["ascension"]  = "Ridicarea la cer";
$pgv_lang["pentecost"]  = "Rusaliile";
$pgv_lang["assumption"] = "Presupunerea";
$pgv_lang["all_saints"] = "Toţi sfinţii";
$pgv_lang["christmas"]  = "Crăciunul";

// am/pm suffixes for 12 hour clocks
$pgv_lang["a.m."]       = "am";
$pgv_lang["p.m."]       = "pm";
$pgv_lang["noon"]       = "m";
$pgv_lang["midn"]       = "mn";

//-- MONTH NAMES
$pgv_lang["jan"]		= "Ianuarie";
$pgv_lang["feb"]		= "Februarie";
$pgv_lang["mar"]		= "Martie";
$pgv_lang["apr"]		= "Aprilie";
$pgv_lang["may"]		= "Mai";
$pgv_lang["jun"]		= "Iunie";
$pgv_lang["jul"]		= "Iulie";
$pgv_lang["aug"]		= "August";
$pgv_lang["sep"]		= "Septembrie";
$pgv_lang["oct"]		= "Octombrie";
$pgv_lang["nov"]		= "Noiembrie";
$pgv_lang["dec"]		= "Decembrie";

$pgv_lang["vend"]       = "Vendémiaire";
$pgv_lang["brum"]       = "Brumaire";
$pgv_lang["frim"]       = "Frimaire";
$pgv_lang["nivo"]       = "Nivôse";
$pgv_lang["pluv"]       = "Pluviôse";
$pgv_lang["vent"]       = "Ventôse";
$pgv_lang["germ"]       = "Germinal";
$pgv_lang["flor"]       = "Floréal";
$pgv_lang["prai"]       = "Prairial";
$pgv_lang["mess"]       = "Messidor";
$pgv_lang["ther"]       = "Thermidor";
$pgv_lang["fruc"]       = "Fructidor";
$pgv_lang["comp"]       = "jours complémentaires";

$pgv_lang["tsh"]        = "Tishrei";
$pgv_lang["csh"]        = "Heshvan";
$pgv_lang["ksl"]        = "Kislev";
$pgv_lang["tvt"]        = "Tevet";
$pgv_lang["shv"]        = "Shevat";
$pgv_lang["adr"]        = "Adar";
$pgv_lang["adr_leap_year"]= "Adar I";
$pgv_lang["ads"]        = "Adar II";
$pgv_lang["nsn"]        = "Nissan";
$pgv_lang["iyr"]        = "Iyar";
$pgv_lang["svn"]        = "Sivan";
$pgv_lang["tmz"]        = "Tamuz";
$pgv_lang["aav"]        = "Av";
$pgv_lang["ell"]        = "Elul";

$pgv_lang["muhar"]      = "Muharram";
$pgv_lang["safar"]      = "Safar";
$pgv_lang["rabia"]      = "Rabi' al-awwal";
$pgv_lang["rabit"]      = "Rabi' al-thani";
$pgv_lang["jumaa"]      = "Jumada al-awwal";
$pgv_lang["jumat"]      = "Jumada al-thani";
$pgv_lang["rajab"]      = "Rajab";
$pgv_lang["shaab"]      = "Sha'aban";
$pgv_lang["ramad"]      = "Ramadan";
$pgv_lang["shaww"]      = "Shawwal";
$pgv_lang["dhuaq"]      = "Dhu al-Qi'dah";
$pgv_lang["dhuah"]      = "Dhu al-Hijjah";

$pgv_lang["b.c."]       = "î.e.n.";

$pgv_lang["abt"]		= "despre";
$pgv_lang["aft"]		= "după";
$pgv_lang["and"]		= "şi";
$pgv_lang["bef"]		= "înainte";
$pgv_lang["bet"]		= "între";
$pgv_lang["cal"]		= "calculat";
$pgv_lang["est"]		= "estimat";
$pgv_lang["from"]		= "de la";
$pgv_lang["int"]		= "interpretat";
$pgv_lang["to"] 		= "către";
$pgv_lang["cir"]		= "circa";
$pgv_lang["apx"]		= "aprox.";

//-- Admin File Messages
$pgv_lang["rebuild_indexes"]		= "Reconstruieşte indexurile";
$pgv_lang["password_mismatch"]		= "Parolele nu corespund.";
$pgv_lang["enter_username"] 		= "Trebuie să introduceţi un nume de utilizator.";
$pgv_lang["enter_password"] 		= "Trebuie să introduceţi o parolă.";
$pgv_lang["save"]					= "Salvează";
$pgv_lang["saveandgo"]				= "Salvează şi trece la următoarea înregistrare";
$pgv_lang["delete"] 				= "Şterge";
$pgv_lang["edit"]					= "Editează";
$pgv_lang["no_login"]				= "Nu am putut autentifica utilizatorul.";
$pgv_lang["basic_realm"]			= "Sistemul de autentificare PhpGedView";
$pgv_lang["basic_auth_failure"]		= "Trebuie să introduceţi un ID de logare valid şi parolă pentru a accesa această resursă";
$pgv_lang["basic_auth"]				= "Autentificare de bază";
$pgv_lang["digest_auth"]			= "Autentificare Digest"; //not used in code yet
$pgv_lang["no_auth_needed"]			= "Fără autentificare";
$pgv_lang["file_not_exists"]		= "Numele de fişier introdus nu există.";
$pgv_lang["research_assistant"]		= "Asistent cercetare";
$pgv_lang["utf8_to_ansi"]			= "Converteşte din UTF-8 în ANSI (ISO-8859-1)";
$pgv_lang["media_linked"]			= "Acest obiect media este legat de următoarele:";
$pgv_lang["media_not_linked"]		= "Acest obiect media nu este legat de nici o înregistrare GEDCOM.";
$pgv_lang["media_dir_1"]			= "Acest obiect media este localizat pe un server extern";
$pgv_lang["media_dir_2"]			= "Acest obiect media este în directorul media standard";
$pgv_lang["media_dir_3"]			= "Acest obiect media este în directorul media protejat";
$pgv_lang["thumb_dir_1"]			= "Acest thumbnail este localizat pe un server extern";
$pgv_lang["thumb_dir_2"]			= "Acest thumbnail este în directorul media standard";
$pgv_lang["thumb_dir_3"]			= "Acest thumbnail este în directorul media protejat";
$pgv_lang["moveto_2"]				= "Mută în directorul protejat";
$pgv_lang["moveto_3"]				= "Mută în directorul standard";
$pgv_lang["move_standard"]			= "Mută în standard";
$pgv_lang["move_protected"]			= "Mută în protejat";
$pgv_lang["move_mediadirs"]			= "Muta directoarele media";
$pgv_lang["setperms"]				= "Setează permisiunile media";
$pgv_lang["setperms_writable"]		= "Fă să se poată scrie de către lume";
$pgv_lang["setperms_readonly"]		= "Fa să se poata doar citi de către lume";
$pgv_lang["setperms_success"]		= "Permisiunile au fost setate";
$pgv_lang["setperms_failure"]		= "Permisiunile nu au fost setate";
$pgv_lang["setperms_time_exceeded"]	= "Limita timpului de execuţie a fost atinsă.  Încercaţi din nou comanda pe un director mai mic.";
$pgv_lang["move_time_exceeded"]		= "Limita timpului de execuţie a fost atinsă.  Încercaţi din nou comanda pentru a muta restul de fişiere.";
$pgv_lang["media_firewall_rootdir_no_exist"]			= "Directorul rădăcină Media Firewall cerut nu există.  Trebuie să-l creaţi prima dată.";
$pgv_lang["media_firewall_protected_dir_no_exist"]		= "Directorul media protejat nu a putut fi creat în directorul radăcina Media Firewall.  Vă rugăm creaţi acest director şi faceţi-l să poată fi scris de către lume.";
$pgv_lang["media_firewall_protected_dir_not_writable"]	= "Directorul media protejat din directorul rădăcină Media Firewall nu se poate scrie de către lume. ";
$pgv_lang["media_firewall_invalid_dir"]	= "Eroare: Media Firewall a fost lansat dintr-un director diferit de directorul media.";

//-- Relationship chart messages
$pgv_lang["relationship_great"]		= "Grozav";
$pgv_lang["relationship_chart"] 	= "Diagrama relaţiilor";
$pgv_lang["person1"]				= "Persoana 1";
$pgv_lang["person2"]				= "Persoana 2";
$pgv_lang["no_link_found"]			= "Nu s-a găsit nici o (altă) legătură între cei doi indivizi.";
$pgv_lang["sibling"]				= "Frate/soră";
$pgv_lang["follow_spouse"]			= "Verifică relaţiile după căsătorie";
$pgv_lang["timeout_error"]			= "Scriptul a expirat înainte ca o relaţie să fie găsită.";
$pgv_lang["grandchild"]				= "Nepot";
$pgv_lang["grandson"]				= "Nepot";
$pgv_lang["granddaughter"]			= "Nepoată";
$pgv_lang["greatgrandchild"]		= "Strănepot";
$pgv_lang["greatgrandson"]			= "Strănepot";
$pgv_lang["greatgranddaughter"]		= "Strănepoată";
$pgv_lang["brother"]				= "Frate";
$pgv_lang["sister"] 				= "Soră";
$pgv_lang["aunt"]					= "Mătuşă";
$pgv_lang["uncle"]					= "Unchi";
$pgv_lang["nephew"]					= "Nepot";
$pgv_lang["niece"]					= "Nepoată";
$pgv_lang["firstcousin"]			= "Verişor dulce";
$pgv_lang["femalecousin"]			= "Verişoară";
$pgv_lang["malecousin"]				= "Verişor";
$pgv_lang["relationship_to_me"] 	= "Relaţia cu mine";
$pgv_lang["rela_husb"]				= "Relaţia cu soţul";
$pgv_lang["rela_wife"]				= "Relaţia cu soţia";
$pgv_lang["next_path"]				= "Gaseşte calea următoare";
$pgv_lang["show_path"]				= "Arată calea";
$pgv_lang["line_up_generations"]	= "Aliniază aceleaşi generaţii";
$pgv_lang["oldest_top"]             = "Arată pe cel mai bătrân deasupra";

// %1\$s replaced by first person, %2\$s by the relationship and %3\$s by the second person.
$pgv_lang["relationship_male_1_is_the_2_of_3"] = "%1\$s is the %2\$s of %3\$s.";
$pgv_lang["relationship_female_1_is_the_2_of_3"] = "%1\$s is the %2\$s of %3\$s.";

$pgv_lang["mother_in_law"]		    = "Mother-in-law";
$pgv_lang["father_in_law"]		    = "Father-in-law";
$pgv_lang["brother_in_law"]		    = "Brother-in-law";
$pgv_lang["sister_in_law"]		    = "Sister-in-law";
$pgv_lang["son_in_law"]		        = "Son-in-law";
$pgv_lang["daughter_in_law"]		= "Daughter-in-law";
$pgv_lang["cousin_in_law"]			= "Cousin-in-law";

$pgv_lang["step_son"]		        = "step son";
$pgv_lang["step_daughter"]	    	= "step daughter";

// the bosa_brothers_offspring name is used for fraternal nephews and nieces - the names below can be extended to any number
// of generations just by adding more translations.
// 1st generation
$pgv_lang["bosa_brothers_offspring_2"] 				= "nepot";             // brother's son
$pgv_lang["bosa_brothers_offspring_3"] 				= "nepoată";              // brother's daughter
// 2nd generation
$pgv_lang["bosa_brothers_offspring_4"] 				= "strănepot";       // brother's son's son
$pgv_lang["bosa_brothers_offspring_5"] 				= "strănepoată";        // brother's son's daughter
$pgv_lang["bosa_brothers_offspring_6"] 				= "strănepot";       // brother's daughter's son
$pgv_lang["bosa_brothers_offspring_7"] 				= "strănepoată";        // brother's daughter's daughter
// for the general case of offspring of the nth generation use the text below
// in this text %1\$d is replaced with the number of generations
//              %2\$d is replaced with the number of generations - 1
//              %3\$d is replaced with the number of generations - 2
$pgv_lang["n_x_brothers_son"]	  = "%2\$d x strănepot";
$pgv_lang["n_x_brothers_daughter"] = "%2\$d x strănepoată";
// the bosa_sisters_offspring name is used for sisters nephews and nieces - the names below can be extended to any number
// of generations just by adding more translations.
// 1st generation
$pgv_lang["bosa_sisters_offspring_2"] 				= "nepot";             // sister's son
$pgv_lang["bosa_sisters_offspring_3"] 				= "nepoată";              // sister's daughter
// 2nd generation
$pgv_lang["bosa_sisters_offspring_4"] 				= "strănepot";       // sister's son's son
$pgv_lang["bosa_sisters_offspring_5"] 				= "strănepoată";        // sister's son's daughter
$pgv_lang["bosa_sisters_offspring_6"] 				= "strănepot";       // sister's daughter's son
$pgv_lang["bosa_sisters_offspring_7"] 				= "strănepoată";        // sister's daughter's daughter
// for the general case of offspring of the nth generation use the text below
// in this text %1\$d is replaced with the number of generations
//              %2\$d is replaced with the number of generations - 1
//              %3\$d is replaced with the number of generations - 2
$pgv_lang["n_x_sisters_son"]	  = "%2\$d x strănepot";
$pgv_lang["n_x_sisters_daughter"] = "%2\$d x strănepoată";

// the bosa name is used for offspring - the names below can be extended to any number
// of generations just by adding more translations.
// 1st generation
$pgv_lang["bosa_2"] 				= "fiu";                   // son
$pgv_lang["bosa_3"] 				= "fiică";              // daughter
// 2nd generation
$pgv_lang["bosa_4"] 				= "nepot";              // son's son
$pgv_lang["bosa_5"] 				= "nepoată";         // son's daughter
$pgv_lang["bosa_6"] 				= "nepot";              // daughter's son
$pgv_lang["bosa_7"] 				= "nepoată";         // daughter's daughter
// 3rd generation
$pgv_lang["bosa_8"] 				= "strănepot";        // son's son's son
$pgv_lang["bosa_9"] 				= "strănepoată";   // son's son's daughter
$pgv_lang["bosa_10"] 				= "strănepot";		   // son's daughter's son
$pgv_lang["bosa_11"] 				= "strănepoată";   // son's daughter's daughter
$pgv_lang["bosa_12"] 				= "strănepot";        // daughter's son's son
$pgv_lang["bosa_13"] 				= "strănepoată";   // daughter's son's daughter
$pgv_lang["bosa_14"] 				= "strănepot";		   // daughter's daughter's son
$pgv_lang["bosa_15"] 				= "strănepoată";   // daughter's daughter's daughter
// for the general case of offspring of the nth generation use the text below
// in this text %1\$d is replaced with the number of generations
//              %2\$d is replaced with the number of generations - 1
//              %3\$d is replaced with the number of generations - 2
$pgv_lang["n_x_grandson_from_son"]	  = "%3\$d x strănepot";
$pgv_lang["n_x_granddaughter_from_son"] = "%3\$d x strănepoată";
$pgv_lang["n_x_grandson_from_daughter"]	  = "%3\$d x strănepot";
$pgv_lang["n_x_granddaughter_from_daughter"] = "%3\$d x strănepoată";

// the sosa_uncle name is used for uncles - the names below can be extended to any number
// of generations just by adding more translations.
// to allow fo language variations we specify different relationships for paternal and maternal
// aunts and uncles
// 1st generation
$pgv_lang["sosa_uncle_2"] 				= "unchi";            // father's brother
$pgv_lang["sosa_uncle_3"] 				= "unchi";            // mother's brother
// 2nd generation
$pgv_lang["sosa_uncle_4"] 				= "unchi";      // fathers's father's brother
$pgv_lang["sosa_uncle_5"] 				= "unchi";      // father's mother's brother
$pgv_lang["sosa_uncle_6"] 				= "unchi";      // mother's father's brother
$pgv_lang["sosa_uncle_7"] 				= "unchi";      // mother's mother's brother
// for the general case of uncles of the nth degree use the text below
// in this text %1\$d is replaced with the number of generations
//              %2\$d is replaced with the number of generations - 1
//              %3\$d is replaced with the number of generations - 2
$pgv_lang["n_x_paternal_uncle"]		= "%2\$d x unchi";
$pgv_lang["n_x_maternal_uncle"]	    = "%2\$d x unchi";

// the sosa_aunt name is used for aunts - the names below can be extended to any number
// of generations just by adding more translations.
// to allow fo language variations we specify different relationships for paternal and maternal
// aunts and aunts
// 1st generation
$pgv_lang["sosa_aunt_2"] 				= "mătuşă";            // father's sister
$pgv_lang["sosa_aunt_3"] 				= "mătuşă";            // mother's sister
// 2nd generation
$pgv_lang["sosa_aunt_4"] 				= "mătuşă";      // fathers's father's sister
$pgv_lang["sosa_aunt_5"] 				= "mătuşă";      // father's mother's sister
$pgv_lang["sosa_aunt_6"] 				= "mătuşă";      // mother's father's sister
$pgv_lang["sosa_aunt_7"] 				= "mătuşă";      // mother's mother's sister
// for the general case of aunts of the nth degree use the text below
// in this text %1\$d is replaced with the number of generations
//              %2\$d is replaced with the number of generations - 1
//              %3\$d is replaced with the number of generations - 2
$pgv_lang["n_x_paternal_aunt"]		= "%2\$d x mătuşă";
$pgv_lang["n_x_maternal_aunt"]	    = "%2\$d x mătuşă";

// the sosa_uncle name is used for uncles(by marriage) - the names below can be extended to any number
// of generations just by adding more translations.
// to allow fo language variations we specify different relationships for paternal and maternal
// aunts and uncles
// 1st generation
$pgv_lang["sosa_uncle_bm_2"] 				= "unchi";            // father's brother
$pgv_lang["sosa_uncle_bm_3"] 				= "unchi";            // mother's brother
// 2nd generation
$pgv_lang["sosa_uncle_bm_4"] 				= "unchi";      // fathers's father's brother
$pgv_lang["sosa_uncle_bm_5"] 				= "unchi";      // father's mother's brother
$pgv_lang["sosa_uncle_bm_6"] 				= "unchi";      // mother's father's brother
$pgv_lang["sosa_uncle_bm_7"] 				= "unchi";      // mother's mother's brother
// for the general case of uncles of the nth degree use the text below
// in this text %1\$d is replaced with the number of generations
//              %2\$d is replaced with the number of generations - 1
//              %3\$d is replaced with the number of generations - 2
$pgv_lang["n_x_paternal_uncle_bm"]		= "%2\$d x great uncle";
$pgv_lang["n_x_maternal_uncle_bm"]	    = "%2\$d x great uncle";

// the sosa_aunt name is used for aunts (by marriage)- the names below can be extended to any number
// of generations just by adding more translations.
// to allow fo language variations we specify different relationships for paternal and maternal
// aunts and aunts
// 1st generation
$pgv_lang["sosa_aunt_bm_2"] 				= "mătuşă";            // father's sister
$pgv_lang["sosa_aunt_bm_3"] 				= "mătuşă";            // mother's sister
// 2nd generation
$pgv_lang["sosa_aunt_bm_4"] 				= "mătuşă";      // fathers's father's sister
$pgv_lang["sosa_aunt_bm_5"] 				= "mătuşă";      // father's mother's sister
$pgv_lang["sosa_aunt_bm_6"] 				= "mătuşă";      // mother's father's sister
$pgv_lang["sosa_aunt_bm_7"] 				= "mătuşă";      // mother's mother's sister
// for the general case of aunts of the nth degree use the text below
// in this text %1\$d is replaced with the number of generations
//              %2\$d is replaced with the number of generations - 1
//              %3\$d is replaced with the number of generations - 2
$pgv_lang["n_x_paternal_aunt_bm"]		= "%2\$d x mătuşă";
$pgv_lang["n_x_maternal_aunt_bm"]	    = "%2\$d x mătuşă";

// if a specific cousin relationship cannot be represented in a language translate as "";
$pgv_lang["male_cousin_1"]              = "primul verişor";
$pgv_lang["male_cousin_2"]              = "al doilea verişor";
$pgv_lang["male_cousin_3"]              = "al treilea verişor";
$pgv_lang["male_cousin_4"]              = "al patrulea verişor";
$pgv_lang["male_cousin_5"]              = "al cincelea verişor";
$pgv_lang["male_cousin_6"]              = "al şaselea verişor";
$pgv_lang["male_cousin_7"]              = "al şaptelea verişor";
$pgv_lang["male_cousin_8"]              = "al optulea verişor";
$pgv_lang["male_cousin_9"]              = "al nouăleav";
$pgv_lang["male_cousin_10"]             = "al zeceleav";
$pgv_lang["male_cousin_11"]             = "al unsprezecelea verişor";
$pgv_lang["male_cousin_12"]             = "al doisprezecelea verişor";
$pgv_lang["male_cousin_13"]             = "al treisprezecelea verişor";
$pgv_lang["male_cousin_14"]             = "al paisprezecelea verişor";
$pgv_lang["male_cousin_15"]             = "al cinsprezecelea verişor";
$pgv_lang["male_cousin_16"]             = "al şaisprezecelea verişor";
$pgv_lang["male_cousin_17"]             = "al şaptesprezecelea verişor";
$pgv_lang["male_cousin_18"]             = "al optusprezecelea verişor";
$pgv_lang["male_cousin_19"]             = "al nouăsprezecelea verişor";
$pgv_lang["male_cousin_20"]             = "al douăzecelea verişor";
$pgv_lang["male_cousin_n"]              = "%d x verişor";
$pgv_lang["female_cousin_1"]            = "prima verişoară";
$pgv_lang["female_cousin_2"]            = "a doua verişoară";
$pgv_lang["female_cousin_3"]            = "a treia verişoară";
$pgv_lang["female_cousin_4"]            = "a patra verişoară";
$pgv_lang["female_cousin_5"]            = "a cincea verişoară";
$pgv_lang["female_cousin_6"]            = "a şasea verişoară";
$pgv_lang["female_cousin_7"]            = "a şaptea verişoară";
$pgv_lang["female_cousin_8"]            = "a opta verişoară";
$pgv_lang["female_cousin_9"]            = "a noua verişoară";
$pgv_lang["female_cousin_10"]           = "a zecea verişoară";
$pgv_lang["female_cousin_11"]           = "a unsprezecea verişoară";
$pgv_lang["female_cousin_12"]           = "a doisprezecea verişoară";
$pgv_lang["female_cousin_13"]           = "a treisprezecea verişoară";
$pgv_lang["female_cousin_14"]           = "a paisprezecea verişoară";
$pgv_lang["female_cousin_15"]           = "a cinsprezecea verişoară";
$pgv_lang["female_cousin_16"]           = "a şaisprezecea verişoară";
$pgv_lang["female_cousin_17"]           = "a şaptesprezecea verişoară";
$pgv_lang["female_cousin_18"]           = "a optusprezecea verişoară";
$pgv_lang["female_cousin_19"]           = "a nouăsprezecea verişoară";
$pgv_lang["female_cousin_20"]           = "a douăzecea verişoară";
$pgv_lang["female_cousin_n"]            = "%d x verişoară";

// Only referenced from english specific functions
$pgv_lang["removed_ascending_1"]   = " şters crescător o dată";
$pgv_lang["removed_ascending_2"]   = " şters crescător de 2 ori";
$pgv_lang["removed_ascending_3"]   = " şters crescător de 3 ori";
$pgv_lang["removed_ascending_4"]   = " şters crescător de 4 ori";
$pgv_lang["removed_ascending_5"]   = " şters crescător de 5 ori";
$pgv_lang["removed_ascending_6"]   = " şters crescător de 6 ori";
$pgv_lang["removed_ascending_7"]   = " şters crescător de 7 ori";
$pgv_lang["removed_ascending_8"]   = " şters crescător de 8 ori";
$pgv_lang["removed_ascending_9"]   = " şters crescător de 9 ori";
$pgv_lang["removed_ascending_10"]  = " şters crescător de 10 ori";
$pgv_lang["removed_ascending_11"]  = " şters crescător de 11 ori";
$pgv_lang["removed_ascending_12"]  = " şters crescător de 12 ori";
$pgv_lang["removed_ascending_13"]  = " şters crescător de 13 ori";
$pgv_lang["removed_ascending_14"]  = " şters crescător de 14 ori";
$pgv_lang["removed_ascending_15"]  = " şters crescător de 15 ori";
$pgv_lang["removed_ascending_16"]  = " şters crescător de 16 ori";
$pgv_lang["removed_ascending_17"]  = " şters crescător de 17 ori";
$pgv_lang["removed_ascending_18"]  = " şters crescător de 18 ori";
$pgv_lang["removed_ascending_19"]  = " şters crescător de 19 ori";
$pgv_lang["removed_ascending_20"]  = " şters crescător de 20 ori";
$pgv_lang["removed_descending_1"]  = " şters descrescător o dată";
$pgv_lang["removed_descending_2"]  = " şters descrescător de 2 ori";
$pgv_lang["removed_descending_3"]  = " şters descrescător de 3 ori";
$pgv_lang["removed_descending_4"]  = " şters descrescător de 4 ori";
$pgv_lang["removed_descending_5"]  = " şters descrescător de 5 ori";
$pgv_lang["removed_descending_6"]  = " şters descrescător de 6 ori";
$pgv_lang["removed_descending_7"]  = " şters descrescător de 7 ori";
$pgv_lang["removed_descending_8"]  = " şters descrescător de 8 ori";
$pgv_lang["removed_descending_9"]  = " şters descrescător de 9 ori";
$pgv_lang["removed_descending_10"] = " şters descrescător de 10 ori";
$pgv_lang["removed_descending_11"] = " şters descrescător de 11 ori";
$pgv_lang["removed_descending_12"] = " şters descrescător de 12 ori";
$pgv_lang["removed_descending_13"] = " şters descrescător de 13 ori";
$pgv_lang["removed_descending_14"] = " şters descrescător de 14 ori";
$pgv_lang["removed_descending_15"] = " şters descrescător de 15 ori";
$pgv_lang["removed_descending_16"] = " şters descrescător de 16 ori";
$pgv_lang["removed_descending_17"] = " şters descrescător de 17 ori";
$pgv_lang["removed_descending_18"] = " şters descrescător de 18 ori";
$pgv_lang["removed_descending_19"] = " şters descrescător de 19 ori";
$pgv_lang["removed_descending_20"] = " şters descrescător de 20 ori";

//-- GEDCOM edit utility
$pgv_lang["check_delete"]			= "Sunteţi sigur(ă) că doriţi să ştergeţi acest fapt GEDCOM ?";
$pgv_lang["access_denied"]			= "<b>Acces interzis</b><br />Nu aveţi acces la această resursă.";
$pgv_lang["changes_exist"]			= "Acest GEDCOM a suferit modificări.";
$pgv_lang["find_place"] 			= "Găsiţi loc";
$pgv_lang["close_window"]			= "Închide fereastra";
$pgv_lang["close_window_without_refresh"] = "Închide fereastra fără reîncărcare";
$pgv_lang["place_contains"] 		= "Locul conţine:"; 
$pgv_lang["add"]					= "Adaugă";
$pgv_lang["custom_event"]			= "Eveniment personalizat";
$pgv_lang["delete_person"]			= "Şterge acest individ";
$pgv_lang["confirm_delete_person"]	= "Sunteţi sigur(ă) că doriţi să ştergeţi această persoană din fişierul GEDCOM ?";
$pgv_lang["find_media"] 			= "Găseşte media";
$pgv_lang["set_link"]				= "Setează link";
$pgv_lang["delete_source"]			= "Şterge această sursă";
$pgv_lang["confirm_delete_source"]	= "Sunteţi sigur(ă) că doriţi să ştergeţi această sursă din fişierul GEDCOM ?";
$pgv_lang["find_family"]			= "Găseşte familie";
$pgv_lang["find_fam_list"]			= "Găseşte listă de familii";
$pgv_lang["edit_name"]				= "Editează numele";
$pgv_lang["delete_name"]			= "Şterge numele";
$pgv_lang["select_date"]			= "Selectaţi o dată";
$pgv_lang["user_cannot_edit"]		= "Acest utilizator nu poate edita acest GEDCOM.";
$pgv_lang["ged_noshow"]				= "Această pagină a fost dezactivată de administratorul siteului.";

//-- calendar.php messages
$pgv_lang["bdm"]					= "Naşteri, Decese, Căsătorii";
$pgv_lang["on_this_day"]			= "În această zi ...";
$pgv_lang["in_this_month"]			= "În această lună ...";
$pgv_lang["in_this_year"]			= "În acest an ...";
$pgv_lang["year_anniversary"]		= "#year_var# aniversare anuală";
$pgv_lang["today"]					= "Astăzi";
$pgv_lang["day"]					= "Zi:";
$pgv_lang["month"]					= "Lună:";
$pgv_lang["showcal"]				= "Arată evenimentele din:";
$pgv_lang["anniversary"]			= "Aniversar";
$pgv_lang["anniversary_calendar"]	= "Calendar aniversar";
$pgv_lang["sunday"] 				= "Duminică";
$pgv_lang["monday"] 				= "Luni";
$pgv_lang["tuesday"]				= "Marţi";
$pgv_lang["wednesday"]				= "Miercuri";
$pgv_lang["thursday"]				= "Joi";
$pgv_lang["friday"] 				= "Vineri";
$pgv_lang["saturday"]				= "Sâmbătă";
$pgv_lang["viewday"]				= "Vezi ziua";
$pgv_lang["viewmonth"]				= "Vezi luna";
$pgv_lang["viewyear"]				= "Vezi anul";
$pgv_lang["all_people"] 			= "Toate persoanele";
$pgv_lang["living_only"]			= "Persoanele în viaţă";
$pgv_lang["recent_events"]			= "Anii recenţi (&lt; 100 ani)";
$pgv_lang["day_not_set"]			= "Nu seta";

//-- user self registration module
$pgv_lang["lost_password"]			= "Aţi uitat parola ?";
$pgv_lang["requestpassword"]		= "Cereţi o nouă parolă";
$pgv_lang["no_account_yet"] 		= "Nu aveţi cont ?";
$pgv_lang["requestaccount"] 		= "Cereţi un nou cont";
$pgv_lang["emailadress"]			= "Adresă email";
$pgv_lang["mandatory"] 				= "Câmpurile marcate cu * sunt obligatorii.";
$pgv_lang["mail01_line01"]			= "Salut #user_fullname# ...";
$pgv_lang["mail01_line02"]			= "O cerere a fost primită la #SERVER_NAME# pentru a crea un cont PhpGedView cu adresa voastră de email #user_email#.";
$pgv_lang["mail01_line03"]			= "Informaţia despre cerere este arătată sub linkul de mai jos.";
$pgv_lang["mail01_line04"]			= "Vă rugăm daţi click pe următorul link şi completaţi datele cerute şi adresa de email.";
$pgv_lang["mail01_line05"]			= "Dacă nu aţi cerut un cont, puteţi să ştergeţi acest mesaj.";
$pgv_lang["mail01_line06"]			= "Nu veţi mai primi nici un email de la acest site, deoarece contul cerut va fi şters automat după 7 zile.";
$pgv_lang["mail01_subject"] 		= "Înregistrarea dumneavoastră la #SERVER_NAME#";

$pgv_lang["mail02_line01"]			= "Bună administratore ...";
$pgv_lang["mail02_line02"]			= "Un utilizator prospectiv s-a înregistrat la PhpGedView pe #SERVER_NAME#.";
$pgv_lang["mail02_line03"]			= "Utilizatorul a primit un email cu informaţia necesară pentru a confirma cererea lui de acces.";
$pgv_lang["mail02_line04"]			= "Veţi fi informat prin email cand acest utilizator prospectiv a confirmat cererea sa.  Puteţi apoi să completaţi procesul prin activarea sa.  Noul utilizator nu va putea să se autentifice până nu veţi activa contul său.";
$pgv_lang["mail02_line04a"]			= "Veţi fi informat prin email cand acest utilizator prospectiv a confirmat cererea sa.  După aceasta, utilizatorul va putea să se autentifice fără nici o acţiune din partea voastră.";
$pgv_lang["mail02_subject"] 		= "Înregistrare nouă la #SERVER_NAME#";

$pgv_lang["hashcode"]				= "Codul de verificare:";
$pgv_lang["thankyou"]				= "Salut #user_fullname# ...<br />Mulţumesc pentru înregistrare.";
$pgv_lang["pls_note06"] 			= "Acum vă vom trimite un email de confirmare la adresa <b>#user_email#</b>. Trebuie să verificaţi cererea pentru cont prin urmarea instrucţiunilor din emailul de confirmare. Dacă nu confirmaţi cererea pentru cont in cel mult 7 zile, cererea va fi respinsă automat.  Va trebui să faceţi o altă cerere din nou.<br /><br />După ce aţi urmărit instrucţiunile din emailul de confirmare, administratorul trebuie să aprobe cererea dumneavoastră înainte să puteţi folosi contul.<br /><br />Pentru a vă autentifica pe acest site, va trebui să ştiti userul si parola dumneavoastră.<br /><br />";
$pgv_lang["pls_note06a"] 			= "Acum vă vom trimite un email de confirmare la adresa <b>#user_email#</b>. Trebuie să verificaţi cererea pentru cont prin urmarea instrucţiunilor din emailul de confirmare. Dacă nu confirmaţi cererea pentru cont in cel mult 7 zile, cererea va fi respinsă automat.  Va trebui să faceţi o altă cerere din nou.<br /><br />După ce aţi urmărit instrucţiunile din emailul de confirmare, vă puteţi autentifica.  Pentru a vă autentifica pe acest site, va trebui să ştiti userul si parola dumneavoastră.<br /><br />";

$pgv_lang["registernew"]			= "O nouă confirmare de cont";
$pgv_lang["user_verify"]			= "Verificarea utilizatorului";
$pgv_lang["send"]					= "Trimite";

$pgv_lang["pls_note07"] 			= "~#pgv_lang[user_verify]#~<br /><br />Pentru a confirma cererea pentru cont, vă rog să tastaţi numele utilizatorului, parola dumneavoastră, şi codul de verificare care l-aţi primit prin email.";
$pgv_lang["pls_note08"] 			= "Datele pentru utilizatorul <b>#user_name#</b> au fost verificate.";

$pgv_lang["mail03_line01"]			= "Bună administratore ...";
$pgv_lang["mail03_line02"]			= "Utilizatorul #newuser[username]# (#newuser[fullname]#) a confirmat cererea sa pentru cont.";
$pgv_lang["mail03_line03"]			= "Vă rugăm daţi clic pe linkul de mai jos pentru a vă loga pe siteul dumneavoastră.  Trebuie să editaţi utilizatorul pentru a-i activa contul, astfel încât să se poată autentifica pe siteul dumneavoastră.";
$pgv_lang["mail03_line03a"]			= "Nu trebuie să faceţi nimic; utilizatorul se poate autentifica acum.";
$pgv_lang["mail03_subject"] 		= "Utilizator nou la #SERVER_NAME#";

$pgv_lang["pls_note09"] 			= "Aţi confirmat cererea dumneavoastră pentru a deveni un utilizator înregistrat.";
$pgv_lang["pls_note10"] 			= "Administratorul a fost notificat.  De îndată ce vă dă permisiunea să vă autentificaţi, puteţi să vă autentificaţi cu utilizatorul si parola dumneavoastră.";
$pgv_lang["pls_note10a"]			= "Acum vă puteţi autentifica folosind utilizatorul si parola dumneavoastră.";
$pgv_lang["data_incorrect"] 		= "Datele nu au fost corecte, vă rugăm încercaţi din nou";
$pgv_lang["user_not_found"] 		= "Nu am putut verifica informaţiile introduse de dumneavoastră.  Vă rugăm încercaţi din nou sau contactaţi administratorul siteului pentru mai multe informaţii.";

$pgv_lang["lost_pw_reset"]			= "Cerere pentru parolă uitată";
$pgv_lang["pls_note11"] 			= "Pentru a vă reseta parola, introduceţi numele de utilizator.<br /><br />Vă vom cu un email trimis la adresa folosită pentru înregistrare.  Emailul va conţine un URL şi codul de confirmare pentru contul dumneavoastră. Când accesaţi acest URL, puteţi să vă schimbaţi parola si să vă autentificaţi pe acest site. Din motive de securitate, nu trebuie să daţi nimănui acest cod de confirmare.<br /><br />Dacă aveţi nevoie de ajutor din partea administratorului, vă rugăm folosiţi linkul de contact de mai jos.";

$pgv_lang["mail04_line01"]			= "Bună #user_fullname# ...";
$pgv_lang["mail04_line02"]			= "O nouă parolă a fost cerută pentru dumneavoastră.";
$pgv_lang["mail04_line03"]			= "Recomandare:";
$pgv_lang["mail04_line04"]			= "Vă rugăm să daţi click pe linkul de mai jos sau sa-l copiaţi si să-l lipiţi în navigatorul dumneavoastră, să vă autentificaţi cu noua parolă, şi s-o schimbaţi imediat pentru a vă păstra datele sigure.";
$pgv_lang["mail04_line05"]			= "După ce v-aţi autentificat, selectaţi linkul «#pgv_lang[editowndata]#» de sub meniul «#pgv_lang[mygedview]#» şi completaţi câmpurile de parole pentru a vă schimba parola.";
$pgv_lang["mail04_subject"] 		= "Cerere de date la #SERVER_NAME#";

$pgv_lang["pwreqinfo"]				= "Bună...<br /><br />Un email cu parola nouă a fost trimis la adresa care o avem pentru  <b>#user[email]#</b>.<br /><br />Vă rugăm verificaţi adresa de email; ar trebui să primiţi mesajul nostru în curând.<br /><br />Recomandare:<br />Ar trebui să vă logaţi pe acest site cu noua parolă cât mai curând şi ar trebui să schimbaţi parola pentru a vă menţine datele în siguranţă.";

$pgv_lang["myuserdata"] 			= "Contul meu";
$pgv_lang["user_theme"] 			= "Tema mea";
$pgv_lang["mgv"]					= "MyGedView";
$pgv_lang["mygedview"]				= "Portalul MyGedView";
$pgv_lang["passwordlength"] 		= "Parolele trebuie să conţină cel puţin 6 caractere.";
$pgv_lang["welcome_text_auth_mode_1"]	= "<center><b>Bine aţi venit pe acest site de genealogie</b></center><br />Accesul la acest site este permis oricărui vizitator care are un cont.<br /><br />Dacă aveţi un cont, puteţi să vă autentificaţi pe această pagină.  Dacă nu aveţi un cont, puteţi să cereţi unul dacă daţi click pe linkul potrivit de mai jos.<br /><br />După ce este verificată cererea dumneavoastră, administratorul siteului va activa contul dumneavoastră.  Veţi primi un email când cererea a fost aprobată.";
$pgv_lang["welcome_text_auth_mode_2"]	= "<center><b>Bine aţi venit pe acest site de genealogie</b></center><br />Accesul la acest site este permis doar utilizatorilor <u>autorizaţi</u>.<br /><br />Dacă aveţi un cont, puteţi să vă autentificaţi pe această pagină.  Dacă nu aveţi un cont, puteţi să cereţi unul dacă daţi click pe linkul potrivit de mai jos.<br /><br />După ce este verificată cererea dumneavoastră, administratorul siteului fie va aproba fie va respinge cererea dumneavoastră.  Veţi primi un email când cererea a fost aprobată.";
$pgv_lang["welcome_text_auth_mode_3"]	= "<center><b>Bine aţi venit pe acest site de genealogie</b></center><br />Accesul la acest site este permis doar <u>membrilor familiei</u>.<br /><br />Dacă aveţi un cont, puteţi să vă autentificaţi pe această pagină.  Dacă nu aveţi un cont, puteţi să cereţi unul dacă daţi click pe linkul potrivit de mai jos.<br /><br />După ce sunt verificate informaţiile furnizate, administratorul siteului fie va aproba fie va respinge cererea dumneavoastră.  Veţi primi un email când cererea a fost aprobată.";
$pgv_lang["welcome_text_cust_head"] 	= "<center><b>Bine aţi venit pe acest site de genealogie</b></center><br />Access is permitted to users who have an account and a password for this website.<br />";
$pgv_lang["acceptable_use"]			= "<div class=\"largeError\">Aviz:</div><div class=\"error\">Prin completarea si trimiterea acestui formular, sunteţi de-acord:<ul><li>să protejaţi intimitatea persoanelor în viaţă listate pe siteul nostru;</li><li>şi în căsuţa de text de mai jos, să explicaţi cu cine sunteţi înrudit, sau să ne spuneţi despre cineva care ar trebui să fie listat pe siteul nostru.</li></ul></div>";


//-- mygedview page
$pgv_lang["upcoming_events"]		= "Evenimentele următoare";
$pgv_lang["living_or_all"]			= "Arăta doar evenimentele legate de persoanele în viaţă ?";
$pgv_lang["basic_or_all"]			= "Arată doar naşterile, decesele şi căsătoriile ?";
$pgv_lang["style"]					= "Stilul de prezentare";
$pgv_lang["style1"]					= "Listă";
$pgv_lang["style2"]					= "Tabel";
$pgv_lang["style3"]					= "Nor de etichete";
$pgv_lang["cal_download"]			= "Permiteţi descărcarea evenimentelor din calendar ?";
$pgv_lang["no_events_living"]		= "Nu există evenimente pentru persoanele în viaţă pentru următoarele #pgv_lang[global_num1]# zile.";
$pgv_lang["no_events_living1"]		= "Nu există evenimente pentru persoanele în viaţă pentru mâine.";
$pgv_lang["no_events_all"]			= "Nu există evenimente pentru următoarele #pgv_lang[global_num1]# zile.";
$pgv_lang["no_events_all1"]			= "Nu există evenimente pentru mâine.";
$pgv_lang["no_events_privacy"]		= "Există evenimente pentru următoarele #pgv_lang[global_num1]# zile, dar restricţiile de confidenţialitate vă împiedică să le vedeţi.";
$pgv_lang["no_events_privacy1"]		= "Există evenimente pentru mâine, dar restricţiile de confidenţialitate vă împiedică să le vedeţi.";
$pgv_lang["more_events_privacy"]	= "<br />Există mai multe evenimente pentru următoarele #pgv_lang[global_num1]# zile, dar restricţiile de confidenţialitate vă împiedică să le vedeţi.";
$pgv_lang["more_events_privacy1"]	= "<br />Există mai multe evenimente pentru mâine, dar restricţiile de confidenţialitate vă împiedică să le vedeţi.";
$pgv_lang["none_today_living"]		= "Nu există evenimente pentru persoanele în viaţă pentru azi.";
$pgv_lang["none_today_all"]			= "Nu există evenimente pentru astăzi.";
$pgv_lang["none_today_privacy"]		= "Există evenimente pentru astăzi, dar restricţiile de confidenţialitate vă împiedică să le vedeţi.";
$pgv_lang["more_today_privacy"]		= "<br />Există mai multe evenimente pentru astăzi, dar restricţiile de confidenţialitate vă împiedică să le vedeţi.";
$pgv_lang["chat"]					= "Dialog";
$pgv_lang["users_logged_in"]		= "Utilizatorii autentificaţi";
$pgv_lang["anon_user"]				= "Un utilizator anonim autentificat";
$pgv_lang["anon_users"]				= "#pgv_lang[global_num1]# utilizatori anonimi autentificaţi";
$pgv_lang["login_user"]				= "Un utilizator autentificat";
$pgv_lang["login_users"]			= "#pgv_lang[global_num1]# utilizatori autentificaţi";
$pgv_lang["no_login_users"]			= "Nu există utilizatori autentificaţi şi nici utilizatori anonimi";
$pgv_lang["message"]				= "Trimite mesaj";
$pgv_lang["my_messages"]			= "Mesajele mele";
$pgv_lang["date_created"]			= "Data trimiterii:";
$pgv_lang["message_from"]			= "Adresa de email:";
$pgv_lang["message_from_name"]		= "Numele dumneavoastră:";
$pgv_lang["message_to"] 			= "Mesaj către:";
$pgv_lang["message_subject"]		= "Subiect:";
$pgv_lang["message_body"]			= "Conţinut:";
$pgv_lang["no_to_user"] 			= "Nu a fost specificat nici un destinatar.  Nu se poate continua.";
$pgv_lang["provide_email"]			= "Vă rugăm furnizaţi adresa dumneavoastră de email pentru a vă putea contacta în legătură cu acest mesaj.  Dacă nu furnizaţi adresa dumneavoastră de email nu vom putea să vă răspundem la întrebare.  Adresa dumneavoastră de email nu va fi folosită în nici un alt scop în afară de a vă răspunde la întrebare.";
$pgv_lang["reply"]					= "Răspunde";
$pgv_lang["message_deleted"]		= "Mesaj şters";
$pgv_lang["message_sent"]			= "Mesajul a fost trimis la #TO_USER# cu succes";
$pgv_lang["reset"]					= "Resetare";
$pgv_lang["site_default"]			= "Setarea implicită";
$pgv_lang["mygedview_desc"] 		= "Pagina dumneavoastră MyGedView vă permite să păstraţi marcaje către persoanele dumneavoastră favorite, să urmăriţi evenimentele următoare, şi să colaboraţi cu alti utilizatori PhpGedView.";
$pgv_lang["no_messages"]			= "Nu aveţi nici un mesaj în aşteptare.";
$pgv_lang["clicking_ok"]			= "Când daţi click pe OK, se va deschide o altă fereastra şi veţi putea să contactaţi utilizatorul #user[fullname]#";
$pgv_lang["favorites"]				= "Favoriţi";
$pgv_lang["my_favorites"]			= "Favoriţii mei";
$pgv_lang["no_favorites"]			= "Nu aţi selectat nici un favorit.<br /><br />Pentru a adăuga un individ, o familie, sau o sursă la favoriţi, daţi click pe linkul <b>#pgv_lang[add_favorite]#</b> pentru a afişa câteva câmpuri unde puteţi introduce sau căuta după un ID.  În loc de un ID, puteţi introduce un URL şi un titlu.";
$pgv_lang["add_to_my_favorites"]	= "Adaugă la favoriţii mei";
$pgv_lang["gedcom_favorites"]		= "Favoriţii acestui GEDCOM";
$pgv_lang["no_gedcom_favorites"]	= "În acest moment nu există selectat nici un favorit.	Administratorul poate adăuga favoriţi care să fie afişaţi la început.";
$pgv_lang["confirm_fav_remove"] 	= "Sunteţi sigur(ă) că doriţi să ştergeţi acest element din lista dumneavoastră de favoriţi ?";
$pgv_lang["invalid_email"]			= "Vă rugăm introduceţi o adresă de email validă.";
$pgv_lang["enter_subject"]			= "Vă rugăm introduceţi un subiect de mesaj.";
$pgv_lang["enter_body"] 			= "Vă rugăm introduceţi textul mesalului înainte de a trimite.";
$pgv_lang["confirm_message_delete"] = "Sunteţi sigur(ă) că doriţi să ştergeţi acest mesaj ?  Nu poate fi recuperat mai târziu.";
$pgv_lang["message_email1"] 		= "Următorul mesaj a fost trimis către contul dumneavoastră PhpGedView de la ";
$pgv_lang["message_email2"] 		= "Aţi trimis următorul mesaj către un utilizator PhpGedView:";
$pgv_lang["message_email3"] 		= "Aţi trimis următorul mesaj către un administrator PhpGedView:";
$pgv_lang["viewing_url"]			= "Acest mesaj a fost trimis în timp ce se viziona următorul URL: ";
$pgv_lang["messaging2_help"]		= "Când trimiteţi acest mesaj veţi primi o copie trimisă prin email la adresa furnizată de dumneavoastră.";
$pgv_lang["random_picture"] 		= "Poză aleatoare";
$pgv_lang["message_instructions"]	= "<b>Vă rugăm tineţi minte:</b> Informaţiile private ale indivizilor aflaţi în viaţă vor fi date doar rudelor familiei şi prietenilor apropiaţi.  Veţi fi rugat(ă) să verificaţi relaţia dumneavoastră înainte să primiţi orice date private.  Câteodată informaţiile persoanelor decedate pot de-asemenea să fie private.  Dacă acesta este cazul, este din cauză că nu se cunosc destule informaţii despre persoană pentru a determina dacă sunt în viaţă sau nu şi probabil nu avem mai multe informaţii despre această persoană.<br /><br />Înainte de a pune o întrebare, vă rugăm verificaţi că puneţi întrebarea despre persoana corectă prin verificarea datelor, locurilor, şi a rudelor apropiate.  Dacă trimiteţi modificări la datele genealogice, vă rugăm includeţi sursele de unde le-aţi obţinut.<br /><br />";
$pgv_lang["sending_to"] 			= "Acest mesaj va fi trimis către #TO_USER#";
$pgv_lang["preferred_lang"] 		= "Acest utilizator preferă să primească mesaje în #USERLANG#";
$pgv_lang["gedcom_created_using"]	= "Acest GEDCOM a fost creat folosind <b>#CREATED_SOFTWARE# #CREATED_VERSION#</b>";
$pgv_lang["gedcom_created_on"]		= "Acest GEDCOM a fost creat în <b>#CREATED_DATE#</b>";
$pgv_lang["gedcom_created_on2"] 	= " în <b>#CREATED_DATE#</b>";
$pgv_lang["gedcom_stats"]			= "Statistici GEDCOM";
$pgv_lang["stat_individuals"]		= "Indivizi";
$pgv_lang["stat_families"]			= "Familii";
$pgv_lang["stat_sources"]			= "Surse";
$pgv_lang["stat_other"] 			= "Alte înregistrări";
$pgv_lang["stat_earliest_birth"] 	= "Cel mai devreme an al naşterii";
$pgv_lang["stat_latest_birth"] 		= "Cel mai târziu an al naşterii";
$pgv_lang["stat_earliest_death"] 	= "Cel mai devreme an al morţii";
$pgv_lang["stat_latest_death"] 		= "Cel mai târziu an al morţii";
$pgv_lang["customize_page"] 		= "Personalizaţi portalul MyGedView";
$pgv_lang["customize_gedcom_page"]	= "Personalizaţi această pagină GEDCOM de introducere";
$pgv_lang["upcoming_events_block"]	= "Evenimentele următoare";
$pgv_lang["upcoming_events_descr"]	= "Blocul cu evenimentele următoare arată aniversări pentru evenimentele care se vor produce în viitorul apropiat.  Puteţi să configuraţi ce detalii for fi afişate, şi administratorul poate să configureze de cât de departe din viitor va afişa acest bloc detaliile.";
$pgv_lang["todays_events_block"]	= "În această zi";
$pgv_lang["todays_events_descr"]	= "Blocul 'În această zi', în istoricul dumneavoastră... arată aniversările evenimentelor pentru astăzi.  Puteţi configura ce detalii vor fi afişate.";
$pgv_lang["yahrzeit_block"]			= "Yahrzeiten următoare";
$pgv_lang["yahrzeit_descr"]			= "Blocul cu următoarele Yahrzeiten arată aniversările dăţilor deceselor care vor avea loc în viitor.  Puteţi configura peroada arătată, şi administratorul poate configura de cât de departe din viitor va afişa acest bloc detaliile.";
$pgv_lang["logged_in_users_block"]	= "Utilizatorii autentificaţi";
$pgv_lang["logged_in_users_descr"]	= "Blocul cu utilizatorii autentificaţi arată o listă cu utilizatorii care sunt autentificaţi în acest moment.";
$pgv_lang["user_messages_block"]	= "Mesajele utilizatorilor";
$pgv_lang["user_messages_descr"]	= "Blocul cu mesajele utilizatorilor arată o listă cu mesaje care au fost trimise către utilizatorul activ.";
$pgv_lang["user_favorites_block"]	= "Favoriţii utilizatorului";
$pgv_lang["user_favorites_descr"]	= "Blocul cu favoriţii utilizatorului arată utilizatorului o listă cu persoanele sale favorite ca să poată face uşor legături către ei.";
$pgv_lang["welcome_block"]			= "Introducere utilizator";
$pgv_lang["welcome_descr"]			= "Blocul cu introducerea pentru utilizator arată data si ora curentă, linkuri rapide pentru a-şi edita contul sau să meargă la diagrama sa proprie cu arborele genealogic, şi un link pentru a-şi personaliza pagina sa de portal MyGedView.";
$pgv_lang["random_media_block"] 	= "Media aleatoare";
$pgv_lang["random_media_descr"] 	= "Blocul cu media aleatoare selectează la întâmplare o fotografie sau alte elemente media din baza de date curentă şi le afişează utilizatorului.<br /><br />Administratorul determină dacă acest bloc poate arata elemente media asociate cu persoane sau evenimente.";
$pgv_lang["random_media_persons_or_all"]	= "Arată doar persoane, evenimente, sau toate ";
$pgv_lang["random_media_persons"]	= "Persoane";
$pgv_lang["random_media_events"]	= "Evenimente";
$pgv_lang["gedcom_block"]			= "Introducere GEDCOM";
$pgv_lang["gedcom_descr"]			= "Blocul de introducere GEDCOM funcţionează la fel ca blocul cu introducerea pentru utilizator.  Urează 'Bine ai venit' utilizatorului şi arată titlul bazei de date active, precum si data si ora curentă.";
$pgv_lang["gedcom_favorites_block"] = "Favoriţii GEDCOM";
$pgv_lang["gedcom_favorites_descr"] = "Blocul cu favoriţii GEDCOM oferă administratorului posibilitatea de a desemna indivizi din baza de date individuals astfel încât informaţiile despre ei sunt uşor accesibile de către restul de utilizatori.  Aceasta este o metodă de a evidenţia persoane care sunt importante în istoria familiei voastre.";
$pgv_lang["gedcom_stats_block"] 	= "Statistici GEDCOM";
$pgv_lang["gedcom_stats_descr"] 	= "Blocul cu statistici GEDCOM arată vizitatorului informaţii de bază despre baza de date, cum ar fi când a fost creată şi câţi oameni sunt în ea.<br /><br />Are de-asemenea şi o lista cu cele mai frecvente nume de familie.  Puteţi configura acest bloc să nu arate lista numelor de familie frecvente, şi puteţi de-asemenea să configuraţi GEDCOM-ul să şteargă sau să adauge nume la această listă.  Puteţi seta pragul de repetiţie pentru această listă în configuraţia GEDCOM-ului.";
$pgv_lang["gedcom_stats_show_surnames"]	= "Arată lista de nume de familie comune ?";
$pgv_lang["portal_config_intructions"]	= "~#pgv_lang[customize_page]# <br /> #pgv_lang[customize_gedcom_page]#~<br /><br />Puteţi personaliza pagina prin poziţionarea blocurilor în pagină aşa cum doriţi.<br /><br />Pagina este împărţită în secţiunea <b>principală</b> şi <b>dreaptă</b>.	Blocurile din secţiunea <b>principală</b> apar mai mari şi sub titlul paginii.  Secţiunea din <b>dreapta</b> începe de la dreapta titlului si continuă în jos pe partea dreaptă a paginii.<br /><br />Fiecare secţiune are propria listă de blocuri care vor fi afişate pe pagină în ordinea în care sunt listate.  Puteţi adăuga, şterge, şi să rearanjaţi blocurile cum doriţi.<br /><br />Când una din listele de blocuri este goală, Blocurile rămase vor ocupa lăţimea întreagă a paginii.<br /><br />";
$pgv_lang["login_block"]			= "Autentificare";
$pgv_lang["login_descr"]			= "Blocul de autentificare acceptă un nume de utilizator si o parolă pentru ca utilizatorii să se poată autentifica.";
$pgv_lang["theme_select_block"] 	= "Alege tema";
$pgv_lang["theme_select_descr"] 	= "Blocul pentru ales tema afişează lista cu teme chiar şi când opţiunea 'Alege tema' este dezactivată.";
$pgv_lang["block_top10_title"]		= "Top 10 nume familie";
$pgv_lang["block_top10"]			= "Top 10 nume familie";
$pgv_lang["block_top10_descr"]		= "Acest bloc arată un tabel cu 10 din cele mai frecvente nume de familie din baza de date.  Numărul efectiv de nume de familie afişate în acest bloc este configurabil.  Puteţi să configuraţi GEDCOMul să şteargă nume din listă.";

$pgv_lang["gedcom_news_block"]		= "Ştiri GEDCOM";
$pgv_lang["gedcom_news_descr"]		= "Blocul cu ştirile GEDCOM arată vizitatorilor ştirile sau articolele postate de un administrator.<br /><br />Blocul pentru ştiri este un loc bun pentru a anunţa un update la baza de date, o reuniune de familie, sau naşterea unui copil.";
$pgv_lang["gedcom_news_limit"]		= "Limitează afişarea după:";
$pgv_lang["gedcom_news_limit_nolimit"]	= "Fără limită";
$pgv_lang["gedcom_news_limit_date"]		= "Vârsta articolului";
$pgv_lang["gedcom_news_limit_count"]	= "Numărul de articole";
$pgv_lang["gedcom_news_flag"]		= "Limita:";
$pgv_lang["gedcom_news_archive"] 	= "Vizualizează arhiva";
$pgv_lang["user_news_block"]		= "Jurnalul utilizatorului";
$pgv_lang["user_news_descr"]		= "Blocul cu jurnalul utilizatorului lasă utilizatorul să păstreze notiţe sau un jurnal online.";
$pgv_lang["my_journal"] 			= "Jurnalul meu";
$pgv_lang["no_journal"] 			= "Nu aţi creat încă nici un articol de jurnal.";
$pgv_lang["confirm_journal_delete"] = "Sunteţi sigur(ă) că doriţi să stergeţi această intrare din jurnal ?";
$pgv_lang["add_journal"]			= "Adaugă o intrare nouă în jurnal";
$pgv_lang["gedcom_news"]			= "Ştiri";
$pgv_lang["confirm_news_delete"]	= "Sunteţi sigur(ă) că doriţi să ştergeţi această ştire ?";
$pgv_lang["add_news"]				= "Adaugă o nouă ştire";
$pgv_lang["no_news"]				= "Nu a fost trimisă nici o ştire.";
$pgv_lang["edit_news"]				= "Adaugă/Modifică articolul de jurnal/ştire";
$pgv_lang["enter_title"]			= "Vă rugăm să introduceţi un titlu.";
$pgv_lang["enter_text"] 			= "Vă rugăm introduceţi nişte text pentru această ştire / jurnal.";
$pgv_lang["news_saved"] 			= "Intrarea nouă pentru ştiri/jurnal a fost salvată cu succes.";
$pgv_lang["article_text"]			= "Textul intrării:";
$pgv_lang["main_section"]			= "Blocurile din secţiunea principală";
$pgv_lang["right_section"]			= "Blocurile din secţiunea din dreapta";
$pgv_lang["available_blocks"]		= "Blocurile disponibile";
$pgv_lang["move_up"]				= "Mută în sus";
$pgv_lang["move_down"]				= "Mută în jos";
$pgv_lang["move_right"] 			= "Mută la dreapta";
$pgv_lang["move_left"]				= "Mută la stânga";
$pgv_lang["broadcast_all"]			= "Trimite tuturor utilizatorilor";
$pgv_lang["hit_count"]				= "Contorul de accesări:";
$pgv_lang["phpgedview_message"] 	= "Mesaj PhpGedView";
$pgv_lang["common_surnames"]		= "Cele mai comune nume de familie";
$pgv_lang["default_news_title"] 	= "Bine aţi venit la arborele dumneavoastră genealogic";
$pgv_lang["default_news_text"]		= "Informaţiile de pe acest site sunt create de <a href=\"http://www.phpgedview.net/\" target=\"_blank\">PhpGedView #VERSION#</a>.  Această pagină furnizează o introducere şi un cuprins pentru acest arbore genealogic.<br /><br />Pentru a începe să lucraţi cu date, alegeţi una din diagramele din meniul de diagrame, mergeţi la lista indivizilor, sau căutaţi după un nume sau locaţie.<br /><br />Dacă aveţi probleme folosind acest site, puteţi să daţi clic pe iconiţa de ajutor şi veţi primi informaţii despre cum să utilizaţi pagina la care vă aflaţi.<br /><br />Mulţumim că aţi vizitat acest site.";
$pgv_lang["reset_default_blocks"]	= "Resetaţi la blocurile implicite";
$pgv_lang["recent_changes"] 		= "Schimbările recente";
$pgv_lang["recent_changes_block"]	= "Schimbările recente";
$pgv_lang["recent_changes_descr"]	= "Blocul cu schimbările recente afişează toate schimbările care au fost făcute la baza de date in ultima lunăâ.  Acest bloc vă poate ajuta să fiţi la curent cu schimbările care au fost făcute.  Schimbarile sunt detectate automat, folosind tagul chan definit in standardul GEDCOM.";
$pgv_lang["recent_changes_none"]	= "<b>Nu au existat schimbări în ultimele #pgv_lang[global_num1]# zile.</b><br />";

$pgv_lang["recent_changes_some"]	= "<b>Schimbări făcute în ultimele #pgv_lang[global_num1]# zile</b><br />";
$pgv_lang["show_empty_block"]		= "Ascunde blocul când este gol ?";
$pgv_lang["hide_block_warn"]		= "Dacă ascundeţi un bloc gol, nu veţi putea să-i schimbaţi configuraţia până când devine vizibil (când nu mai este gol).";
$pgv_lang["delete_selected_messages"]	= "Ştergeţi mesajele selectate";
$pgv_lang["use_blocks_for_default"]	= "Folosiţi aceste blocuri ca şi configuraţii iniţiale pentru blocurile tuturor utilizatorilor ?";
$pgv_lang["block_not_configure"]	= "Acest bloc nu poate fi configurat.";

//-- validate GEDCOM
$pgv_lang["add_media_tool"] 		= "Unealta pentru adăugare media";

//-- hourglass chart
$pgv_lang["hourglass_chart"]		= "Diagrama clepsidră";

//-- report engine
$pgv_lang["choose_report"]			= "Alegeţi ce raport doriţi să rulaţi";
$pgv_lang["enter_report_values"]	= "Introduceţi valorile raportului";
$pgv_lang["selected_report"]		= "Alegeţi raport";
$pgv_lang["select_report"]			= "Selectaţi report";
$pgv_lang["download_report"]		= "Descărcaţi report";
$pgv_lang["reports"]				= "Rapoarte";
$pgv_lang["pdf_reports"]			= "Rapoarte PDF";
$pgv_lang["html_reports"]			= "Rapoarte HTML";

//-- Ahnentafel report
$pgv_lang["ahnentafel_report"]		= "Raport Ahnentafel";
$pgv_lang["ahnentafel_header"]		= "Raport Ahnentafel pentru ";
$pgv_lang["ahnentafel_generation"]	= "Generaţia ";
$pgv_lang["ahnentafel_pronoun_m"]	= "El ";
$pgv_lang["ahnentafel_pronoun_f"]	= "Ea ";
$pgv_lang["ahnentafel_born_m"]		= "a fost născut";		// male
$pgv_lang["ahnentafel_born_f"]		= "a fost născută";		// female
$pgv_lang["ahnentafel_christened_m"] = "a fost botezat";	// male
$pgv_lang["ahnentafel_christened_f"] = "a fost botezată";	// female
$pgv_lang["ahnentafel_married_m"]	= "căsătorit";			// male
$pgv_lang["ahnentafel_married_f"]	= "căsătorită";			// female
$pgv_lang["ahnentafel_died_m"]		= "a murit";			// male
$pgv_lang["ahnentafel_died_f"]		= "a murit";			// female
$pgv_lang["ahnentafel_buried_m"]	= "a fost înmormântat";	// male
$pgv_lang["ahnentafel_buried_f"]	= "a fost înmormântată";// female
$pgv_lang["ahnentafel_place"]		= " în ";				// place name follows this
$pgv_lang["ahnentafel_no_details"]	= " dar detaliile nu sunt cunoscute";

//-- Changes report
$pgv_lang["changes_report"]			= "Raportul schimbărilor";
$pgv_lang["changes_pending_tot"]	= "Total schimbări în aşteptare: ";
$pgv_lang["changes_accepted_tot"]	= "Total schimbări acceptate: ";

//-- Descendancy report
$pgv_lang["descend_report"]			= "Raportul descendenţilor";
$pgv_lang["descendancy_header"]		= "Raportul descendenţilor pentru ";

$pgv_lang["family_group_report"]	= "Raportul de grup pentru familie";
$pgv_lang["page"]					= "Pagina";
$pgv_lang["of"] 					= "din";
$pgv_lang["enter_famid"]			= "Introduceţi ID-ul familiei";
$pgv_lang["show_sources"]			= "Arată sursele ?";
$pgv_lang["show_notes"] 			= "Arată notele ?";
$pgv_lang["show_basic"] 			= "Afişaţi evenimentele de bază când sunt goale ?";
$pgv_lang["show_photos"]			= "Arată fotografiile ?";
$pgv_lang["relatives_report_ext"]	= "Raportul extins al rudelor";
$pgv_lang["with"]					= "cu";
$pgv_lang["on"]						= "la";			// for precise dates
$pgv_lang["in"]						= "în";			// for imprecise dates
$pgv_lang["individual_report"]		= "Raportul individului";
$pgv_lang["enter_pid"]				= "Introduceţi ID-ul individului";
$pgv_lang["generated_by"]			= "Generat de către";
$pgv_lang["list_children"]			= "Afişează fiecare copil în ordinea naşterii.";
$pgv_lang["birth_report"]			= "Raportul cu zilele şi locurile de naştere";
$pgv_lang["birthplace"]				= "Locul naşterii conţine";
$pgv_lang["birthdate1"]				= "Data de început pentru zilele de naştere";
$pgv_lang["birthdate2"]				= "Data de sfârşit pentru zilele de naştere";
$pgv_lang["death_report"]			= "Raportul cu zilele şi locurile deceselor";
$pgv_lang["deathplace"]				= "Locul morţii conţine";
$pgv_lang["deathdate1"]				= "Data de început pentru zilele decesului";
$pgv_lang["deathdate2"]				= "Data de sfârşit pentru zilele decesului";
$pgv_lang["marr_report"]			= "Raportul cu datele şi locurile căsătoriilor";
$pgv_lang["marrplace"]				= "Locul căsătoriei conţine";
$pgv_lang["marrdate1"]				= "Data de început pentru zilele căsătoriei";
$pgv_lang["marrdate2"]				= "Data de sfârşit pentru zilele căsătoriei";
$pgv_lang["sort_by"]				= "Sortează după";

$pgv_lang["cleanup"]				= "Curăţenie";

//-- CONFIGURE (extra) messages for programs patriarch and statistics
$pgv_lang["dynasty_list"]			= "Prezentare generală a familiilor";
$pgv_lang["patriarch_list"] 		= "Lista de patriarhi";
$pgv_lang["statistics"] 			= "Statistici";

//-- Merge Records
$pgv_lang["merge_same"] 			= "Înregistrările nu au acelaşi tip.  Nu se pot contopi înregistrările care nu au acelaşi tip.";
$pgv_lang["merge_step1"]			= "Pasul de contopire 1 din 3";
$pgv_lang["merge_step2"]			= "Pasul de contopire 2 din 3";
$pgv_lang["merge_step3"]			= "Pasul de contopire 3 din 3";
$pgv_lang["select_gedcom_records"]	= "Selectaţi două înregistrări GEDCOM pentru contopire.  Înregistrările trebuie sa fie de acelaşi tip.";
$pgv_lang["merge_to"]				= "Contopiţi în ID-ul:";
$pgv_lang["merge_from"] 			= "Contopiţi de la ID-ul:";
$pgv_lang["merge_facts_same"]		= "Următoarele fapte au fost exact la fel în ambele înregistrări şi vor fi contopite automat.";
$pgv_lang["no_matches_found"]		= "Nu au fost găsite fapte care să se potrivească";
$pgv_lang["unmatching_facts"]		= "Faptele următoare nu s-au potrivit.  Selectaţi informaţiile care aţi dori să le păstraţi.";
$pgv_lang["record"] 				= "Înregistrarea";
$pgv_lang["adding"] 				= "Adaug";
$pgv_lang["updating_linked"]		= "Actualizez înregistrarea ataşată";
$pgv_lang["merge_more"] 			= "Contopeşte mai multe înregistrări.";
$pgv_lang["same_ids"]				= "Aţi introdus aceleaşi ID-uriYou .  Nu puteţi contopi aceleaşi înregistrări.";

//-- ANCESTRY FILE MESSAGES
$pgv_lang["ancestry_chart"] 		= "Diagrama strămoşilor";
$pgv_lang["gen_ancestry_chart"]		= "Diagrama generaţiei de strămoşi #PEDIGREE_GENERATIONS#";
$pgv_lang["chart_style"]			= "Stilul diagramei";
$pgv_lang["chart_list"]				= "Listă";
$pgv_lang["chart_booklet"]   		= "Broşură";
$pgv_lang["show_cousins"]			= "Arată verişorii";
// 1st generation
$pgv_lang["sosa_2"] 				= "Tatăl";
$pgv_lang["sosa_3"] 				= "Mama";
// 2nd generation
$pgv_lang["sosa_4"] 				= "Bunicul";
$pgv_lang["sosa_5"] 				= "Bunica";
$pgv_lang["sosa_6"] 				= "Bunicul";
$pgv_lang["sosa_7"] 				= "Bunica";
// 3rd generation
$pgv_lang["sosa_8"] 				= "Străbunicul";
$pgv_lang["sosa_9"] 				= "Străbunica";
$pgv_lang["sosa_10"]				= "Străbunicul";
$pgv_lang["sosa_11"]				= "Străbunica";
$pgv_lang["sosa_12"]				= "Străbunicul";
$pgv_lang["sosa_13"]				= "Străbunica";
$pgv_lang["sosa_14"]				= "Străbunicul";
$pgv_lang["sosa_15"]				= "Străbunica";
// 4th generation
$pgv_lang["sosa_16"]				= "Străstrăbunicul";
$pgv_lang["sosa_17"]				= "Străstrăbunica";
$pgv_lang["sosa_18"]				= "Străstrăbunicul";
$pgv_lang["sosa_19"]				= "Străstrăbunica";
$pgv_lang["sosa_20"]				= "Străstrăbunicul";
$pgv_lang["sosa_21"]				= "Străstrăbunica";
$pgv_lang["sosa_22"]				= "Străstrăbunicul";
$pgv_lang["sosa_23"]				= "Străstrăbunica";
$pgv_lang["sosa_24"]				= "Străstrăbunicul";
$pgv_lang["sosa_25"]				= "Străstrăbunica";
$pgv_lang["sosa_26"]				= "Străstrăbunicul";
$pgv_lang["sosa_27"]				= "Străstrăbunica";
$pgv_lang["sosa_28"]				= "Străstrăbunicul";
$pgv_lang["sosa_29"]				= "Străstrăbunica";
$pgv_lang["sosa_30"]				= "Străstrăbunicul";
$pgv_lang["sosa_31"]				= "Străstrăbunica";

// for the general case of ancestors of the nth generation use the text below
// in this text %1\$d is replaced with the number of generations
//              %2\$d is replaced with the number of generations - 1
//              %3\$d is replaced with the number of generations - 2
$pgv_lang["sosa_paternal_male_n_generations"]	= "%3\$d x străbunicul din partea tatălui";
$pgv_lang["sosa_paternal_female_n_generations"]	= "%3\$d x străbunica din partea tatălui";
$pgv_lang["sosa_maternal_male_n_generations"]	= "%3\$d x străbunicul din partea mamei";
$pgv_lang["sosa_maternal_female_n_generations"]	= "%3\$d x străbunica din partea mamei";

//-- FAN CHART
$pgv_lang["compact_chart"]			= "Diagrama compactă";
$pgv_lang["fan_chart"]				= "Diagrama cerc";
$pgv_lang["gen_fan_chart"]  		= "Diagrama cerc a generaţiilor #PEDIGREE_GENERATIONS#";
$pgv_lang["fan_width"]				= "Lăţime";
$pgv_lang["gd_library"]				= "Serverul PHP este configurat greşit: librăria GD 2.x este necesară pentru a folosi funcţiile de imagini.";
$pgv_lang["gd_freetype"]			= "Serverul PHP este configurat greşit: librăria FreeType este necesară pentru a folosi fonturi TrueType.";
$pgv_lang["gd_helplink"]			= "http://www.php.net/gd";
$pgv_lang["fontfile_error"]			= "Fişierul cu fontul nu a fost găsit pe serverul PHP";
$pgv_lang["fanchart_IE"]			= "Această imagine diagramă-evantai nu poate fi afişată direct pe în navigatorul dumneavoastră. Folosiţi clicul drept şi apoi salvează si tipăreşte.";

//-- RSS Feed
$pgv_lang["rss_descr"]				= "Ştiri si linkuri de la siteul #GEDCOM_TITLE#";
$pgv_lang["rss_logo_descr"]			= "Feed creat de PhpGedView";
$pgv_lang["rss_feeds"]				= "Feed RSS";
$pgv_lang["no_feed_title"]			= "Feed-ul nu este disponibil";
$pgv_lang["no_feed"]				= "Nu există nici un feed RSS disponibil pentru acest site PhpGedView";
$pgv_lang["feed_login"]				= "Dacă aveţi un cont pe acest site PhpGedView, puteţi să vă <a href=\"#AUTH_URL#\">autentificaţi</a> folosind autentificarea HTTP pentru a vedea informaţiile private.";
$pgv_lang["authenticated_feed"]		= "Feed autentificat";

//-- ASSOciates RELAtionship
// After any change in the following list, please check $assokeys in edit_interface.php
$pgv_lang["attendant"] = "Însoţitor";
$pgv_lang["attending"] = "Participând la";
$pgv_lang["best_man"] = "Cavaler de onoare";
$pgv_lang["bridesmaid"] = "Domnişoară de onoare";
$pgv_lang["buyer"] = "Cumpărător";
$pgv_lang["circumciser"] = "Persoana care circumcide";
$pgv_lang["civil_registrar"] = "Ofiţerul de la starea civilă";
$pgv_lang["friend"] = "Prieten";
$pgv_lang["godfather"] = "Naş";
$pgv_lang["godmother"] = "Naşă";
$pgv_lang["godparent"] = "Naş";
$pgv_lang["informant"] = "Informator";
$pgv_lang["lodger"] = "Locatar";
$pgv_lang["nurse"] = "Asistentă";
$pgv_lang["priest"] = "Preot";
$pgv_lang["rabbi"] = "Rabin";
$pgv_lang["registry_officer"] = "Ofiţerul de la înregistrare";
$pgv_lang["seller"] = "Vânzător";
$pgv_lang["servant"] = "Servitor";
$pgv_lang["twin"] = "Geamăn";
$pgv_lang["twin_brother"] = "Frate geamăn";
$pgv_lang["twin_sister"] = "Soră geamănă";
$pgv_lang["witness"] = "Martor";

//-- statistics utility
$pgv_lang["statutci"]			 = "nu am putut crea indexul";
$pgv_lang["statnnames"]          = "numărul de nume    =";
$pgv_lang["statnfam"]            = "numărul de familii =";
$pgv_lang["statnmale"]           = "numărul de bărbaţi =";
$pgv_lang["statnfemale"]         = "numărul de femei   =";
$pgv_lang["statvars"]			 = "Completaţi următorii parametri pentru grafic";
$pgv_lang["statlxa"]			 = "de-a lungul axei X:";
$pgv_lang["statlya"]			 = "de-a lungul axei Y:";
$pgv_lang["statlza"]			 = "de-a lungul axei Z";
$pgv_lang["stat_10_none"]		 = "nimic";
$pgv_lang["stat_11_mb"]			 = "Luna naşterii";
$pgv_lang["stat_12_md"]			 = "Luna decesului";
$pgv_lang["stat_13_mm"]			 = "Luna căsătoriei";
$pgv_lang["stat_14_mb1"]		 = "Luna naşterii primului copil într-o relaţie";
$pgv_lang["stat_15_mm1"]		 = "Luna primei căsătorii";
$pgv_lang["stat_16_mmb"]		 = "Lunile dintre căsătorie şi primul copil";
$pgv_lang["stat_17_arb"]		 = "vârsta în relaţie cu anul naşterii";
$pgv_lang["stat_18_ard"]		 = "vârsta în relaţie cu anul decesului";
$pgv_lang["stat_19_arm"]		 = "vârsta în anul căsătoriei";
$pgv_lang["stat_20_arm1"]		 = "vârsta în anul primei căsătorii";
$pgv_lang["stat_21_nok"]		 = "numărul de copii";
$pgv_lang["stat_200_none"]		 = "toate (sau gol)";
$pgv_lang["stat_201_num"]		 = "numere";
$pgv_lang["stat_202_perc"]		 = "procentaje";
$pgv_lang["stat_300_none"]		 = "nimic";
$pgv_lang["stat_301_mf"]		 = "sex";
$pgv_lang["stat_302_cgp"]		 = "perioade de date";
$pgv_lang["statmess1"]			 = "<b>Următoarele intrări sunt in relaţie cu parametrii graficului de mai sus pentru axele X şi Z</b>";
$pgv_lang["statar_xgp"]			 = "Limitele axei X (perioadele):";
$pgv_lang["statar_xgl"]			 = "Limitele axei X (vârste):";
$pgv_lang["statar_xgm"]			 = "Limitele axei X (luna):";
$pgv_lang["statar_xga"]			 = "Limitele axei X (numere):";
$pgv_lang["statar_zgp"]			 = "Limitele axei X (perioade de date):";
$pgv_lang["statreset"]			 = "resetează";
$pgv_lang["statsubmit"]			 = "arată graficul";

//-- statisticsplot utility
$pgv_lang["statistiek_list"]	 = "Graficul statisticilor";
$pgv_lang["stpl"]			 	 = "...";
$pgv_lang["stplGDno"]			 = "Librăria pentru afişat grafice nu este instalată pe server. Vă rugăm contactaţi administratorul de sistem.";
$pgv_lang["stpljpgraphno"]		 = "Librăria JPgraph nu este instalată în PhpGedView. Vă rugăm să o descărcaţi de la http://www.aditus.nu/jpgraph/jpdownload.php<br /> şi să o copiaţi în subdirectorul <i>jpgraph/</i> pe server.";
$pgv_lang["stplinfo"]			 = "informaţiile despre grafic:";
$pgv_lang["stpltype"]			 = "tipul:";
$pgv_lang["stplnoim"]			 = " nu este implementat:";
$pgv_lang["stplmf"]			 = " / bărbat-femeie";
$pgv_lang["stplipot"]			 = " / pe perioada de timp";
$pgv_lang["stplgzas"]			 = "limitele axei Z:";
$pgv_lang["stplmonth"]			 = "luna";
$pgv_lang["stplnumbers"]		 = "numerele pentru o familie";
$pgv_lang["stplage"]			 = "vârsta";
$pgv_lang["stplperc"]			 = "procentaj";
$pgv_lang["stplnumof"]			 = "Numără ";
$pgv_lang["stplmarrbirth"]		 = "Luni între căsătorie şi naşterea primului copil";

//-- alive in year
$pgv_lang["alive_in_year"]			= "În viaţă în anul";
$pgv_lang["is_alive_in"]			= "Este în viaţă în #YEAR#";
$pgv_lang["alive"]					= "În viaţă ";
$pgv_lang["dead"]					= "Decedat ";
$pgv_lang["maybe"]					= "Poate ";
$pgv_lang["both_alive"]				= "Ambii în viaţă ";
$pgv_lang["both_dead"]				= "Ambii decedaţi ";

//-- Help system
$pgv_lang["definitions"]			= "Definiţii";

//-- Index_edit
$pgv_lang["block_desc"]				= "Bloc descrieri";
$pgv_lang["click_here"]				= "Daţi click aici pentru a continua";
$pgv_lang["click_here_help"]		= "~#pgv_lang[click_here]#~<br /><br />Daţi clic pe acest buton pentru a vă salva schimbările.<br /><br />Vă veţi întoarce la pagina #pgv_lang[welcome]# sau pagina #pgv_lang[mygedview]#, dar schimbările dumneavoastră s-ar putea să nu fie arătate.  S-ar putea să trebuiască să folosiţi funţia de reîncărcare de la navigatorul dumneavoastră pentru a vedea corect schimbările dumneavoastră.";
$pgv_lang["block_summaries"]		= "~#pgv_lang[block_desc]#~<br /><br />Aici este o scurtă descriere de la fiecare bloc pe care-l puteţi pune pe pagina #pgv_lang[welcome]# sau pagina #pgv_lang[mygedview]#.<br /><table border='1' align='center'><tr><td class='list_value'><b>#pgv_lang[name]#</b></td><td class='list_value'><b>#pgv_lang[description]#</b></td></tr>#pgv_lang[block_summary_table]#</table><br /><br />";
// Built in index_edit.php
$pgv_lang["block_summary_table"]	= "&nbsp;";

//-- Find page
$pgv_lang["total_places"]			= "Locurile găsite";
$pgv_lang["media_contains"]			= "Media conţine:";
$pgv_lang["repo_contains"]			= "Depozitul conţine:";
$pgv_lang["source_contains"]		= "Sursa conţine:";
$pgv_lang["display_all"]			= "Afişeaza toate";

// FAQ Page
$pgv_lang["add_faq_header"] = "Antet FAQ";
$pgv_lang["add_faq_body"] = "Conţinut FAQ";
$pgv_lang["add_faq_order"] = "Poziţia FAQ";
$pgv_lang["add_faq_visibility"] = "Vizibilitatea FAQ";
$pgv_lang["no_faq_items"] = "Lista FAQ este goală.";
$pgv_lang["position_item"] = "Poziţionează elementul";
$pgv_lang["faq_list"] = "Lista FAQ";
$pgv_lang["confirm_faq_delete"] = "Sunteţi sigur(ă) că doriţi să ştergeţi intrarea FAQ";
$pgv_lang["preview"] =  "Previzualizare";
$pgv_lang["no_id"] = "Nu a fost specificat nici un ID pentru FAQ !";

// Help search
$pgv_lang["hs_title"] 			= "Textul de ajutor pentru căutare";
$pgv_lang["hs_search"] 			= "Caută";
$pgv_lang["hs_close"] 			= "Închide fereastra";
$pgv_lang["hs_results"] 		= "Rezultatele găsite:";
$pgv_lang["hs_keyword"] 		= "Căutare pentru";
$pgv_lang["hs_searchin"]		= "Caută în";
$pgv_lang["hs_searchuser"]		= "Ajutorul pentru utilizator";
$pgv_lang["hs_searchmodules"]	= "Ajutorul pentru module";
$pgv_lang["hs_searchconfig"]	= "Ajutorul pentru administrator";
$pgv_lang["hs_searchhow"]		= "Tipul căutării";
$pgv_lang["hs_searchall"]		= "Toate cuvintele";
$pgv_lang["hs_searchany"]		= "Orice cuvânt";
$pgv_lang["hs_searchsentence"]	= "Fraza exactă";
$pgv_lang["hs_intruehelp"]		= "Doar textul de ajutor";
$pgv_lang["hs_inallhelp"]		= "Tot textul";

// Media import
$pgv_lang["choose"] = "Alegeţi: ";
$pgv_lang["account_information"] = "Informaţia despre cont";

//-- Media item "TYPE" sub-field
$pgv_lang["TYPE__audio"] = "Audio";
$pgv_lang["TYPE__book"] = "Carte";
$pgv_lang["TYPE__card"] = "Card";
$pgv_lang["TYPE__certificate"] = "Certificat";
$pgv_lang["TYPE__document"] = "Document";
$pgv_lang["TYPE__electronic"] = "Electronic";
$pgv_lang["TYPE__fiche"] = "Microfişă";
$pgv_lang["TYPE__film"] = "Microfilm";
$pgv_lang["TYPE__magazine"] = "Revistă";
$pgv_lang["TYPE__manuscript"] = "Manuscris";
$pgv_lang["TYPE__map"] = "Hartă";
$pgv_lang["TYPE__newspaper"] = "Ziar";
$pgv_lang["TYPE__photo"] = "Foto";
$pgv_lang["TYPE__tombstone"] = "Piatră funerară";
$pgv_lang["TYPE__video"] = "Video";
$pgv_lang["TYPE__painting"] = "Tablou";
$pgv_lang["TYPE__other"] = "Altele";

//-- Other media suff
$pgv_lang["view_slideshow"] 		= "Vizionează ca prezentare";
$pgv_lang["download_image"]			= "Descarcă fişier";
$pgv_lang["no_media"]				= "Nu am găsit media";
$pgv_lang["media_privacy"]			= "Restricţiile de confidenţialitate vă împiedică să vedeţi acest articol";
$pgv_lang["relations_heading"]		= "Imaginea se referă la:";
$pgv_lang["file_size"]				= "Mărimea fişierului";
$pgv_lang["img_size"]				= "Mărimea imaginii";
$pgv_lang["media_broken"]			= "Acest fişier media este corupt şi nu poate fi marcat";
$pgv_lang["unknown_mime"]			= "Eroare firewall media: >Mimetype necunoscut< pentru fişier";

//-- Modules
$pgv_lang["module_error_unknown_action_v2"] = "Acţiune necunoscută: [action].";
$pgv_lang["module_error_unknown_type"] = "Tipul modulului necunoscut.";

//-- sortable tables buttons
$pgv_lang["button_alive_in_year"] = "Arată persoanele în viaţă în anul indicat.";
$pgv_lang["button_BIRT_Y100"] = "Arată persoanele născute în ultimi 100 de ani.";
$pgv_lang["button_BIRT_YES"] = "Arată persoanele născute cu mai mult de 100 de ani în urmă.";
$pgv_lang["button_DEAT_H"] = "Arată cuplurile unde doar bărbatul este decedat.";
$pgv_lang["button_DEAT_N"] = "Arată persoanele care sunt în viaţă sau cuplurile unde ambii parteneri sunt în viaţă.";
$pgv_lang["button_DEAT_W"] = "Arată cuplurile unde doar femeia este decedată.";
$pgv_lang["button_DEAT_Y"] = "Arată persoanele decedate sau cuplurile unde ambii parteneri sunt decedaţi.";
$pgv_lang["button_DEAT_Y100"] = "Arată persoanele care au murit în ultimii 100 de ani.";
$pgv_lang["button_DEAT_YES"] = "Arată oamenii care au murit cu peste 100 de ani în urmă.";
$pgv_lang["button_MARR_DIV"] = "Arată cuplurile divorţate.";
$pgv_lang["button_MARR_U"] = "Arată cuplurile cu data căsătoriei necunoscută.";
$pgv_lang["button_MARR_Y100"] = "Arată cuplurile care s-au căsătorit în ultimii 100 de ani.";
$pgv_lang["button_MARR_YES"] = "Arată cuplurile care s-au căsătorit cu peste 100 de ani în urmă.";
$pgv_lang["button_reset"] = "Resetează la valorile implicite ale listei.";
$pgv_lang["button_SEX_F"] = "Arată doar femeile.";
$pgv_lang["button_SEX_M"] = "Arată doar bărbaţii.";
$pgv_lang["button_SEX_U"] = "Arată doar persoanele al căror sex este necunoscut.";
$pgv_lang["button_TREE_L"] = "Arată cuplurile sau indivizii «frunză».  Aceştia sunt indivizi care sunt în viaţă dar nu au copii înregistraţi în baza de date.";
$pgv_lang["button_TREE_R"] = "Arată cuplurile sau indivizii «rădăcini».  Aceste persoane se pot numi şi «patriarhi».  Ei sunt indivizii care nu au părinţi înregistraţi în baza de date.";
$pgv_lang["sort_column"] = "Sortează după această coloană.";
?>
