<?php
/**
 * Portugese Language file for PhpGedView.
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2010  PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @author Maurício Menegazzo Rosa
 * @author Anderson Wilson and Clovis Bombardelli
 * @version $Id: lang.pt.php 6989 2010-11-09 03:26:25Z canajun2eh $
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

$pgv_lang["SHOW_ID_NUMBERS"]="Exibir números de ID ao lado dos nomes";
$pgv_lang["SHOW_HIGHLIGHT_IMAGES"]="Exibir imagens de destaque na página de pessoas";
$pgv_lang["duplicate_username"]="Nome de Usuário duplicado.  Já existe um usuário com este nome. Por favor escolha outro nome de usuário.";
$pgv_lang["none"]="Nenhum";
$pgv_lang["family"]="Família";
$pgv_lang["invalid_search_input"]="Favor informar um Nome, Sobrenome ou Local. Opcionalmente informe o Ano";
$pgv_lang["multi_site_search"]="Pesquisa Multi-Site";

$pgv_lang["date_of_entry"]				= "Data do registro na fonte original";
$pgv_lang["roman_surn"]="Sobrenome Románico";
$pgv_lang["roman_givn"]="Nomes Románicos";
$pgv_lang["include"]="Incluir:";
$pgv_lang["page_x_of_y"]="Página #GLOBALS[currentPage]# de #GLOBALS[lastPage]#";
$pgv_lang["options"]="Opções:";
$pgv_lang["config_update_ok"]="Arquivo de configuração atualizado com sucesso.";
$pgv_lang["server_folder"]="Nome da pasta no servidor";
$pgv_lang["descend_report"]="Relatório de Descendentes";
$pgv_lang["descendancy_header"]		= "Descendentes de ";
$pgv_lang["page_size"]="Tamanho da Página";
$pgv_lang["record_not_found"]="O registro GEDCOM solicitado não foi encontrado. a causa provável é de uma ligação com uma pessoa inexistente ou por um arquivo  GEDCOM corrompido.";
$pgv_lang["result_page"]="Página de Resultado";
$pgv_lang["edit_media"]="Editar Mídia";
$pgv_lang["wiki_main_page"]="Página principal do Wiki";
$pgv_lang["wiki_users_guide"]="Guia do Wiki para Usuários";
$pgv_lang["wiki_admin_guide"]="Guia Wiki para Administradores";
$pgv_lang["no_search_for"]="Assegure-se de marcar uma opção para a pesquisa.";
$pgv_lang["no_search_site"]="Selecione pelo menos um site remoto.";
$pgv_lang["other_searches"]="Outras Pesquisas";
$pgv_lang["search_sites"]="Sites onde pesquisar";
$pgv_lang["search_sites_discription"]="Pesquise em sites conhecidos";
$pgv_lang["search_asso_text_unavailable"]="Associação<br /> ainda não é permitida com <br /> pesquisa de site";
$pgv_lang["advanced_search"]="Pesquisa avançada de site";
$pgv_lang["site_list"]="Site:";
$pgv_lang["site_had"]="contendo o seguinte:";
$pgv_lang["indi_is_remote"]="A informação desta pessoa está ligada a um site remoto.";
$pgv_lang["link_remote"]="Ligar a uma pessoa remota";
$pgv_lang["label_accept_changes"]="Aceitar todas as alterações";
$pgv_lang["label_ask_first"]="Pergunte-me primeiro";
$pgv_lang["label_merge_options"]="Opções de Fusão";
$pgv_lang["error_view_connections"]="Selecione o site que deseja exibir.";
$pgv_lang["error_delete_server"]="Selecione o site a ser excluido.";
$pgv_lang["label_search_engine_detected"]="Detetado Robo de Site de Pesquisa";
$pgv_lang["label_search_engine_spider"]    = "Robo de Site de Pesquisa";
$pgv_lang["label_ban_view_links"]="Exibir ligações com este site banido";
$pgv_lang["error_url"]="Um site deve ter uma URL/IP";
$pgv_lang["error_exists_server"]="Este site já existe.";
$pgv_lang["ex-spouse"]="Ex-Cônjuge";
$pgv_lang["ex-wife"]="Ex-Espôsa";
$pgv_lang["ex-husband"]="Ex-Marido";
$pgv_lang["noemail"]="Endereços sem emails";
$pgv_lang["onlyemail"]="Somente endereços com emails";
$pgv_lang["maxviews_exceeded"]="Máximo de visualizações da página excedido, tente mais tarde.";
$pgv_lang["broadcast_not_logged_6mo"]="Enviar mensagem aos usuários que não acessam o site a 6 mêses";
$pgv_lang["broadcast_never_logged_in"]="Enviar mensagem aos usuários que nunca acessaram o site.";
$pgv_lang["stats_to_show"]="Escolha a estatística a ser mostrada neste bloco";
$pgv_lang["stat_avg_age_at_death"]="Média De Vida";
$pgv_lang["stat_longest_life"]="Pessoa Que Mais Viveu";
$pgv_lang["stat_most_children"]="Família Com Mais Filhos";
$pgv_lang["stat_average_children"]="Média de Filhos Por Família";
$pgv_lang["stat_events"]="Total de Eventos";
$pgv_lang["stat_media"]= "Mídias";
$pgv_lang["stat_surnames"]="Sobrenomes";
$pgv_lang["stat_users"]="Total de Usuários";
$pgv_lang["no_family_facts"]="Não a fatos para esta família.";
$pgv_lang["sunday_1st"]="Dom";
$pgv_lang["monday_1st"]="Seg";
$pgv_lang["tuesday_1st"]="Ter";
$pgv_lang["wednesday_1st"]="Qua";
$pgv_lang["thursday_1st"]="Qui";
$pgv_lang["friday_1st"]="Sex";
$pgv_lang["saturday_1st"]="Sab";
$pgv_lang["jan_1st"]="Jan";
$pgv_lang["feb_1st"]="Fev";
$pgv_lang["mar_1st"]="Março";
$pgv_lang["apr_1st"]="Abril";
$pgv_lang["may_1st"]="Maio";
$pgv_lang["jun_1st"]="Junho";
$pgv_lang["jul_1st"]="Julho";
$pgv_lang["aug_1st"]="Ago";
$pgv_lang["sep_1st"]="Set";
$pgv_lang["oct_1st"]="Out";
$pgv_lang["nov_1st"]="Nov";
$pgv_lang["dec_1st"]="Dez";
$pgv_lang["edit_source"]="Editar a Fonte";
$pgv_lang["source_menu"]="Opções para fonte";
$pgv_lang["familybook_chart"]="Álbum de Família";
$pgv_lang["family_of"]="Família de:&nbsp;";
$pgv_lang["descent_steps"]="Máximo de Quebras";
$pgv_lang["cancel"]="Cancelar";
$pgv_lang["cookie_help"]="Este site faz uso de cookies para seu correto funcionamento.<br /><br />Aparentemente o uso de Cookies está desabilitado em seu Navegador. Consulte a Ajuda de seu Navegador e habilite o uso de cookies.";
$pgv_lang["title_search_link"]="Adicionar Ligação Local";
$pgv_lang["label_site_url2"]="Endereço do Site";
$pgv_lang["error_server_exists"]="O site adicionado já existe; selecione o site da lista ?&laquo;Usar um site que já exista?&raquo;.";
$pgv_lang["delete_family_confirm"]="Excluir uma família significa que <b>somente<b> a ligação entre as pessoas desta família é que será excluída. Confirma a exclusão desta Família?";
$pgv_lang["delete_family"]="Excluir Família";
$pgv_lang["add_favorite"]="Adicionar Favorito";
$pgv_lang["url"]="URL";
$pgv_lang["add_fav_enter_note"]="Observação deste favorito - opcional";
$pgv_lang["add_fav_or_enter_url"]="ou<br />\nInforme uma URL e um título";
$pgv_lang["add_fav_enter_id"]="Informe a ID da Pessoa, Família ou Fonte";
$pgv_lang["next_email_sent"]="O próximo aviso por email será enviado após ";
$pgv_lang["last_email_sent"]="O último aviso por email foi enviado ";
$pgv_lang["remove_child"]="Remover este filho da Famíla";
$pgv_lang["link_new_husb"]="Adicionar um marido a partir de uma pessoa da árvore";
$pgv_lang["link_new_wife"]="Adicionar uma esposa a partir de uma pessoa da árvore";
$pgv_lang["address_labels"]="Etiquetas de Endereço";
$pgv_lang["filter_address"]="Exibir endereços contendo:";
$pgv_lang["address_list"]="Lista de Endereços";
$pgv_lang["autocomplete"]="Auto-completar";
$pgv_lang["index_edit_advice"]="Clique em uma das setas para mover o Bloco selecionado na direção desejada.";
$pgv_lang["importing_dates"]="Importando registros de Data";
$pgv_lang["changelog"]="Modificações na Versão #VERSION#";
$pgv_lang["html_block_descr"]="O bloco de HTML simples, permite que você inclua uma mensagem qualquer na sua página.";
$pgv_lang["html_block_sample_part1"]="<p class=\"blockhc\"><b>Informe o título aqui</b></p><br /><p>Clique o botão configurar";
$pgv_lang["html_block_sample_part2"]="para alterar o que está impresso aqui.</p>";
$pgv_lang["html_block_name"]="HTML";
$pgv_lang["htmlplus_block_name"]="HTML Avançado";
$pgv_lang["htmlplus_block_descr"]="Este é um blobo de HTML, que permite incluir qualquer mensagem em sua página. A mensagem pode conter informações extraidas diretamente do GEDCOM.";
$pgv_lang["htmlplus_block_templates"]="Modelos";
$pgv_lang["htmlplus_block_content"]="Conteúdo";
$pgv_lang["htmlplus_block_narrative"]="Tipo narrativa (só em inglês)";
$pgv_lang["num_to_show"]="Qtde de itens exibidos";
$pgv_lang["days_to_show"]="Qtde de dias exibidos";
$pgv_lang["before_or_after"]="Contadores, antes ou depois do nome?";
$pgv_lang["before"]="antes";
$pgv_lang["after"]="depois";
$pgv_lang["config_block"]="Configurar";
$pgv_lang["pls_note12"]="Neste campo, descreva a razão pela qual deseja ter acesso a este site e de que forma você está relacionado a esta árvore genealógica.";
$pgv_lang["enter_comments"]="Por favor, em Comentários, informe seu relacionamento com a árvore.";
$pgv_lang["comments"]="Comentários";
$pgv_lang["child-family"]="Pais e Parentes";
$pgv_lang["spouse-family"]="Cônjuge e filhos";
$pgv_lang["direct-ancestors"]="Ancestrais diretos";
$pgv_lang["ancestors"]="Ancestrais diretos e suas famílias";
$pgv_lang["descendants"]="Descendentes";
$pgv_lang["choose_relatives"]="Escolha os parentes";
$pgv_lang["relatives_report"]="Relatório de Parentes";
$pgv_lang["total_living"]="Vivos";
$pgv_lang["total_dead"]="Mortos";
$pgv_lang["total_not_born"]="Por Nascer";
$pgv_lang["remove_custom_tags"]="Remover tags específicas do PGV? (ex. _PGVU, _THUM)";
$pgv_lang["download_zipped"]="Compactar GECOM (zip) antes do download ?";
$pgv_lang["cookie_login_help"]="Este site reconheceu você como um usuário autorizado a acessa-lo. Porém, por questão de segurança, para efetuar alterações será necessário identificar-se informando Usuário/Senha.";
$pgv_lang["remember_me"]="Associe este computador a mim";
$pgv_lang["fams_with_surname"]="Famílias com o sobrenome #surname#";
$pgv_lang["support_contact"]="Contato para ajuda técnica";
$pgv_lang["genealogy_contact"]="Contato para ajuda genealógica";
$pgv_lang["continue_import"]="Continue a importar";
$pgv_lang["importing_places"]="Importando registros de lugar";
$pgv_lang["common_upload_errors"]="Este êrro indica que o arquivo enviado excedeu o tamanho máximo permitido pelo provedor do site. O limite padrão do PHP é de 2MB. Peça ao suporte de seu provedor para aumentar este limite no arquivo php.ini, ou tente enviar o arquivo por FTP. Use a página <a href=\"uploadgedcom.php?action=add_form\"><b>Adicionar GEDCOM</b></a> para processar o arquivo GEDCOM enviado por FTP.";
$pgv_lang["total_memory_usage"]="Total de Memória Utilizada:";
$pgv_lang["mothers_family_with"]="Família Materna com ";
$pgv_lang["fathers_family_with"]="Família Paterna com ";
$pgv_lang["halfsibling"]="Meio-Irmão";
$pgv_lang["halfbrother"]="Meio-Irmão";
$pgv_lang["halfsister"]="Meia-Irmã";
$pgv_lang["family_timeline"]="Exibir a família no gráfico Cronológico";
$pgv_lang["children_timeline"]="Exibir filhos no gráfico Cronológico";
$pgv_lang["other"]="Outros";
$pgv_lang["sort_by_marriage"]="Ordenar pela data de casamento";
$pgv_lang["reorder_families"]="Reordenar Famílias";
$pgv_lang["indis_with_surname"]="Pessoas com o sobrenome #surname#";
$pgv_lang["first_letter_fname"]="Escolha a letra inical do nome das pessoas a serem exibidas.";
$pgv_lang["marr_name_import_instr"]="Clique o botão abaixo para forçar o PhpGedView a deduzir o nome de casada para as mulheres deste arquivo GEDCOM. Desta forma será possível pesquisar e listar as mulheres pelo seus nomes de casada. <i>Obs: Nomes de casada, somente serão exibidos na lista, caso a opção correspondente seja habilitada na configuração da GEDCOM. <b>Este procedimento é opcional.</b></i>";
$pgv_lang["total_names"]="Total de Nomes";
$pgv_lang["top10_pageviews_nohits"]="Não há hits para exibir";
$pgv_lang["top10_pageviews_msg"]="Contadores de hit devem ser habilitados na configuração da GEDCOM, nas seções Exibição e Formatação, nos grupos Esconder e Exibir.";
$pgv_lang["review_changes_descr"]="O Bloco de Pendências permite aos usuários, com permissão de Edição Imediata, de rever a lista de registros com as alterações pendentes. Estas alterações precisam ser aceitas ou rejeitadas.<br /><br />Caso este bloco seja habilitado, usuários com permissão de Edição Imediata, receberão um email uma vez ao dia para lembra-los das pendências.";
$pgv_lang["review_changes_block"]="Alterações Pendentes";
$pgv_lang["review_changes_email"]="Enviar lembrete por emails?";
$pgv_lang["review_changes_email_freq"]="Frequência de envio dos lembretes (dias)";
$pgv_lang["review_changes_subject"]="PhpGedView - Revisar alterações ";
$pgv_lang["review_changes_body"]="Foram feitas alterações no banco de dados genealógico. Estas alterações precisam ser revisadas antes que sejam exibidas para todos os usuários. Use a URL abaixo para acessar o site e revisar as alterações.";
$pgv_lang["show_spouses"]="Exibir cônjuges";
$pgv_lang["quick_update_title"]="Edição Simplificada";
$pgv_lang["quick_update_instructions"]="Está página permite que você atualize rapidamente informações de uma pessoa. As alterações efetuadas, serão revisadas pelo administrador do site e somente após a aceitação destas é que os demais usuários poderão ver suas alterações.";
$pgv_lang["update_name"]="Atualizar Nome";
$pgv_lang["update_fact"]="Atualizar o Fato";
$pgv_lang["update_fact_restricted"]="Atualização deste fato é restrito:";
$pgv_lang["update_photo"]="Atualizar a Foto";
$pgv_lang["select_fact"]="Selecione um fato...";
$pgv_lang["update_address"]="Atualizar o Endereço";
$pgv_lang["top10_pageviews_descr"]="Este bloco mostrará os 10 registros mais visualizados. Este bloco requer, que a opção Contadores de Acesso, localizada na configuração da GEDCOM, esteja habilitada.";
$pgv_lang["top10_pageviews"]="Os mais vistos";
$pgv_lang["top10_pageviews_block"]="Os mais visitados";
$pgv_lang["stepfamily"]="Família Adotiva";
$pgv_lang["stepdad"]="Pai Adotivo";
$pgv_lang["stepmom"]="Mãe Adotiva";
$pgv_lang["stepsister"]="Irmã Adotiva";
$pgv_lang["stepbrother"]="Irmão Adotivo";
$pgv_lang["fams_charts"]="Opções para esta família";
$pgv_lang["indis_charts"]="Opções para esta pessoa";
$pgv_lang["edit_indi"]="Alterar a pessoa";
$pgv_lang["locked"]="Não alterar";
$pgv_lang["privacy"]="Privacidade";
$pgv_lang["number_sign"]="#";
$pgv_lang["qm"]="?";
$pgv_lang["qm_ah"]="?";
$pgv_lang["page_help"]="Ajuda";
$pgv_lang["help_for_this_page"]="Ajuda desta página";
$pgv_lang["help_contents"]="Índice da Ajuda";
$pgv_lang["show_context_help"]="Exibir link de Ajuda";
$pgv_lang["hide_context_help"]="Não exibir link de Ajuda";
$pgv_lang["sorry"]="<b>Desculpe, mas ainda não há texto de ajuda para esta página ou ítem</b>";
$pgv_lang["help_not_exist"]="<b>Não há texto de Ajuda para esta página ou ítem</b>";
$pgv_lang["var_not_exist"]="<span style=font-weight: bold>Não existe a váriavel neste idioma. Por favor comunique o êrro.</span>";
$pgv_lang["resolution"]="Resolução de tela";
$pgv_lang["menu"]="Menu";
$pgv_lang["header"]="Cabeçalho";
$pgv_lang["imageview"]="Visualizador de Imagens";
$pgv_lang["login_head"]="Indentificação de Usuário";
$pgv_lang["error_title"]="ERRO: Não pude abrir o Arquivo GEDCOM";
$pgv_lang["for_support"]="Para Suporte Técnico e Informações entre em contato com";
$pgv_lang["for_contact"]="Para Ajuda sobre questões Genealógicas entre em contato com";
$pgv_lang["for_all_contact"]="Para suporte técnico ou questões Genealógicas, por favor entre em contato com";
$pgv_lang["build_title"]="Gerando Arquivo de Índices";
$pgv_lang["build_error"]="O Arquivo GEDCOM foi atualizado.";
$pgv_lang["please_wait"]="Por Favor aguarde enquanto os arquivos de índices são regerados.";
$pgv_lang["choose_gedcom"]="Escolha o arquivo GEDCOM";
$pgv_lang["username"]="Usuário";
$pgv_lang["invalid_username"]="Nome do Usuário contém caracteres inválidos";
$pgv_lang["firstname"]="Nome";
$pgv_lang["lastname"]="Sobrenome";
$pgv_lang["password"]="Senha";
$pgv_lang["confirm"]="Confirme a Senha";
$pgv_lang["login"]="Conectar";
$pgv_lang["login_aut"]="Alterar Usuário";
$pgv_lang["logout"]="Desconectar";
$pgv_lang["admin"]="Administrador";
$pgv_lang["logged_in_as"]="Conectado como ";
$pgv_lang["my_pedigree"]="Minha Árvore";
$pgv_lang["my_indi"]="Meus Dados";
$pgv_lang["yes"]="Sim";
$pgv_lang["no"]="Não";
$pgv_lang["change_theme"]="Temas";
$pgv_lang["index_header"]="Árvore Genealógica";
$pgv_lang["gen_ped_chart"]="#PEDIGREE_GENERATIONS# Gerações";
$pgv_lang["generations"]="Gerações";
$pgv_lang["view"]="Exibir";
$pgv_lang["fam_spouse"]="Família com cônjuge:";
$pgv_lang["root_person"]="ID Raiz";
$pgv_lang["hide_details"]="Esconder Detalhes";
$pgv_lang["show_details"]="Exibir Detalhes";
$pgv_lang["person_links"]="Links para gráficos, famílias e parentes próximos desta pessoa. Clique neste ícone para ver a página começando nesta pessoa.";
$pgv_lang["zoom_box"]="Zoom +/- nesta caixa";
$pgv_lang["orientation"]="Orientação da página";
$pgv_lang["portrait"]="Retrato";
$pgv_lang["landscape"]="Paisagem";
$pgv_lang["start_at_parents"]="Iniciar nos Pais";
$pgv_lang["charts"]="Gráficos";
$pgv_lang["lists"]="Listas";
$pgv_lang["welcome_page"]="Página Inicial";
$pgv_lang["max_generation"]="O número máximo de gerações é #PEDIGREE_GENERATIONS#.";
$pgv_lang["min_generation"]="O número mínimo de gerações é 3.";
$pgv_lang["box_width"]="Largura";
$pgv_lang["unable_to_find_family"]="Incapaz de localizar família com este ID";
$pgv_lang["unable_to_find_indi"]="Incapaz de localizar pessoa com este ID";
$pgv_lang["unable_to_find_record"]="Incapaz de localizar registro com este ID";
$pgv_lang["unable_to_find_source"]="Incapaz de localizar fonte com este ID";
$pgv_lang["unable_to_find_repo"]="Incapaz de localizar um Repositório com este ID";
$pgv_lang["repo_name"]="Nome do Repositório:";
$pgv_lang["address"]="Endereço:";
$pgv_lang["phone"]="Telefone:";
$pgv_lang["source_name"]="Nome da Fonte:";
$pgv_lang["title"]="Título";
$pgv_lang["author"]="Autor:";
$pgv_lang["publication"]="Publicação:";
$pgv_lang["call_number"]="Número da Chamada:";
$pgv_lang["living"]="Vivo";
$pgv_lang["private"]="Privado";
$pgv_lang["birth"]="Nascimento:";
$pgv_lang["death"]="Falecimento:";
$pgv_lang["descend_chart"]="Descendentes";
$pgv_lang["individual_list"]="Pessoas";
$pgv_lang["family_list"]="Famílias";
$pgv_lang["source_list"]="Fontes";
$pgv_lang["place_list"]="Locais";
$pgv_lang["place_list_aft"]="Locais abaixo de";
$pgv_lang["media_list"]="Mídias";
$pgv_lang["search"]="Pesquisar";
$pgv_lang["clippings_cart"]="Extração de Dados";
$pgv_lang["print_preview"]="Exibir formato de Impressão";
$pgv_lang["cancel_preview"]="Voltar ao modo normal de exibição";
$pgv_lang["change_lang"]="Trocar o Idioma";
$pgv_lang["print"]="Imprimir";
$pgv_lang["total_queries"]="Nº de consultas ao Banco de Dados: ";
$pgv_lang["total_privacy_checks"]="Quantidade de verificações de privacidade:";
$pgv_lang["back"]="Voltar";
$pgv_lang["privacy_list_indi_error"]="De acordo com as regras de privacidade, estarão ocultas informações de uma ou mais pessoas.";
$pgv_lang["privacy_list_fam_error"]="De acordo com as regras de privacidade, estarão ocultas informações de uma ou mais famílias.";
$pgv_lang["aka"]="AKA('s) Também conhecido(s) como";
$pgv_lang["male"]="Masculino";
$pgv_lang["female"]="Feminino";
$pgv_lang["status"]="Status";
$pgv_lang["source"]="Fonte";
$pgv_lang["citation"]="Citação:";
$pgv_lang["text"]="Texto da Fonte:";
$pgv_lang["note"]="Nota";
$pgv_lang["NN"]="(desconhecido)";
$pgv_lang["PN"]="(Prenome desconhecido)";
$pgv_lang["unrecognized_code"]="Código GEDCOM Desconhecido";
$pgv_lang["unrecognized_code_msg"]="Isto é um erro, e nós gostaríamos de corrigí-lo. Por favor, informe esse erro para";
$pgv_lang["indi_info"]="Informação Pessoal";
$pgv_lang["pedigree_chart"]="Árvore Genealógica";
$pgv_lang["individual"]="Pessoa";
$pgv_lang["family_with"]="Família com";
$pgv_lang["as_spouse"]="Família com Cônjuge";
$pgv_lang["as_child"]="Família com Pais";
$pgv_lang["view_gedcom"]="Exibir registro GEDCOM";
$pgv_lang["add_to_cart"]="Adicionar ao Carrinho de Recortes";
$pgv_lang["still_living_error"]="Esta pessoa ainda está viva ou não tem data de aniversário ou falecimento registrada. Todos os detalhes de pessoas vivas são privados para o público<br />Para maiores informações entre em contato com";
$pgv_lang["privacy_error"]="Os detalhes desta pessoa são privados.<br />";
$pgv_lang["more_information"]="Para maiores informações entre em contato com";
$pgv_lang["name"]="Nome";
$pgv_lang["given_name"]="Prenome:";
$pgv_lang["surname"]="Sobrenome:";
$pgv_lang["suffix"]="Sufixo:";
$pgv_lang["object_note"]="Notas sobre o Objeto:";
$pgv_lang["sex"]="Sexo";
$pgv_lang["personal_facts"]="Dados Pessoais e Detalhes";
$pgv_lang["type"]="Tipo";
$pgv_lang["place_description"]="Local / Descrição";
$pgv_lang["parents"]="Pais:";
$pgv_lang["siblings"]="Irmãos";
$pgv_lang["father"]="Pai";
$pgv_lang["mother"]="Mãe";
$pgv_lang["parent"]="Pais";
$pgv_lang["relatives"]="Parentes Próximos";
$pgv_lang["relatives_events"]="Eventos de parentes próximos";
$pgv_lang["child"]="Filho";
$pgv_lang["spouse"]="Cônjuge";
$pgv_lang["surnames"]="Sobrenomes";
$pgv_lang["adopted"]="Adotado";
$pgv_lang["foster"]="Adotivo";
$pgv_lang["sealing"]="Sealing";
$pgv_lang["challenged"]="Desafiado";
$pgv_lang["disproved"]="Refutado";
$pgv_lang["infant"]="Criança";
$pgv_lang["stillborn"]="Natimorto";
$pgv_lang["deceased"]="Falecido";
$pgv_lang["link_as_wife"]="Ligar esta pessoa como a Esposa de uma Família da árvore";
$pgv_lang["no_tab1"]="Não há nenhum Fato para essa pessoa.";
$pgv_lang["no_tab2"]="Não há nenhuma Nota para essa pessoa.";
$pgv_lang["no_tab3"]="Não há nenhuma Fonte para essa pessoa.";
$pgv_lang["no_tab4"]="Não há nenhuma Mídia para essa pessoa.";
$pgv_lang["no_tab5"]="Não há nenhum Parente Próximo para essa pessoa.";
$pgv_lang["no_tab6"]="Não há log de pesquisa para esta pessoa.";
$pgv_lang["family_info"]="Informações da Família";
$pgv_lang["family_group_info"]="Informações do Grupo Familiar";
$pgv_lang["husband"]="Marido";
$pgv_lang["wife"]="Esposa";
$pgv_lang["marriage"]="Casamento:";
$pgv_lang["marriage_license"]="Licença Matrimonial:";
$pgv_lang["media_object"]="Mídia:";
$pgv_lang["children"]="Filhos";
$pgv_lang["no_children"]="Sem Filhos";
$pgv_lang["childless_family"]="Esta família não deixou descendentes";
$pgv_lang["number_children"]="Qtde de filhos: ";
$pgv_lang["parents_timeline"]="Exibir casal no<br />gráfico Linha do Tempo";
$pgv_lang["clip_cart"]="Carrinho de Recortes";
$pgv_lang["clip_explaination"]="A Extração de Dados permite a você extrair pedaços desta árvore genealógica e formar um novo arquivo GEDCOM para download.<br /><br />";
$pgv_lang["item_with_id"]="Item com ID";
$pgv_lang["error_already"]="já está no seu Carrinho de Recortes.";
$pgv_lang["which_links"]="Quais os links desta família que você gostaria de adicionar?";
$pgv_lang["just_family"]="Adicione somente este registro desta família.";
$pgv_lang["parents_and_family"]="Adicione os registros dos pais desta família.";
$pgv_lang["parents_and_child"]="Adicione os registros dos pais e filhos desta família.";
$pgv_lang["parents_desc"]="Adicione os registros dos pais e todos descendentes desta família.";
$pgv_lang["continue"]="Continue Adicionando";
$pgv_lang["which_p_links"]="Quais links desta pessoa você deseja adicionar?";
$pgv_lang["just_person"]="Somente esta pessoa.";
$pgv_lang["person_parents_sibs"]="Adiciona esta pessoa, seus pais e irmãos.";
$pgv_lang["person_ancestors"]="Adicione esta pessoa e seus ancestrais diretos.";
$pgv_lang["person_ancestor_fams"]="Adiciona esta pessoa, seus ancestrais diretos e suas famílias.";
$pgv_lang["person_spouse"]="Adiciona esta pessoa, seu cônjuge e filhos.";
$pgv_lang["person_desc"]="Adiciona esta pessoa, seu cônjuge e todos os registros de descendentes.";
$pgv_lang["unable_to_open"]="Incapaz de abrir a pasta de recortes para gravação";
$pgv_lang["person_living"]="Esta pessoa está viva. Detalhes pessoais não serão incluidos.";
$pgv_lang["person_private"]="Detalhes sobre esta pessoa são privados. Detalhes pessoais não serão incluidos.";
$pgv_lang["family_private"]="Detalhes sobre esta Família são privados. Detalhes de Família não serão Incluidos.";
$pgv_lang["download"]="Clique com o botão direito (control-click no Mac) nos links abaixo e selecione \"Salvar arquivo como ...\" para fazer o download dos arquivos.";
$pgv_lang["media_files"]="Mídias referenciadas neste GEDCOM";
$pgv_lang["cart_is_empty"]="Seu carrinho de recortes está vazio.";
$pgv_lang["id"]="ID";
$pgv_lang["ID"]="ID";
$pgv_lang["name_description"]="Nome / Descrição";
$pgv_lang["remove"]="Remover";
$pgv_lang["empty_cart"]="Esvaziar o carrinho";
$pgv_lang["download_now"]="Fazer Download agora";
$pgv_lang["indi_downloaded_from"]="Download desta Pessoa feito de:";
$pgv_lang["family_downloaded_from"]="Download desta Família feito de:";
$pgv_lang["source_downloaded_from"]="Download desta Fonte feito de:";
$pgv_lang["connections"]="locais encontrados";
$pgv_lang["top_level"]="Países";
$pgv_lang["form"]="Locais são classificados da seguinte forma: ";
$pgv_lang["default_form"]="Cidade, Estado, País";
$pgv_lang["default_form_info"]="(Padrão)";
$pgv_lang["gedcom_form_info"]="(GEDCOM)";
$pgv_lang["unknown"]="Desconhecido";
$pgv_lang["individuals"]="Pessoas";
$pgv_lang["view_records_in_place"]="Exibir os registros deste Local";
$pgv_lang["place_list2"]="Lista de Locais";
$pgv_lang["show_place_hierarchy"]="Exibir Hierarquia dos Locais";
$pgv_lang["show_place_list"]="Exibir lista de todos os Locais";
$pgv_lang["total_unic_places"]="Total Locais";
$pgv_lang["external_objects"]="Objetos externos";
$pgv_lang["multi_title"]="Titulo da Mídia";
$pgv_lang["media_found"]="Mídias encontradas";
$pgv_lang["view_person"]="Exibir a Pessoa";
$pgv_lang["view_family"]="Exibir a Família";
$pgv_lang["view_source"]="Exibir a Fonte";
$pgv_lang["view_object"]="Exibir Objeto";
$pgv_lang["prev"]="&lt; Anterior";
$pgv_lang["next"]="Próximo &gt;";
$pgv_lang["file_not_found"]="Arquivo não encontrado.";
$pgv_lang["medialist_show"]="Exibir";
$pgv_lang["per_page"]="mídia por página";
$pgv_lang["delete_directory"]="Excluir Pasta";
$pgv_lang["current_dir"]="Pasta Atual";
$pgv_lang["add_directory"]="Nova Pasta";
$pgv_lang["image_format"]="Formato da Imagem";
$pgv_lang["media_format"]="Formato da Mídia";
$pgv_lang["image_size"]="Dimensão da Imagem";
$pgv_lang["media_file_size"]="Dimensão da Mídia";
$pgv_lang["manage_media"]="Gerenciar Mídias";
$pgv_lang["media_id"]="ID da Mídia";
$pgv_lang["invalid_id"]="Esta ID não existe neste GEDCOM.";
$pgv_lang["upload_file"]="Enviar arquivo do seu computador";
$pgv_lang["media_record_deleted"]="Registro de Mídia #xref# e suas ligações foram excluidos com sucesso.";
$pgv_lang["media_record_not_deleted"]="Não foi possível excluir o registro de Mídia #xref# nem suas ligações.";
$pgv_lang["record_updated"]="Registro #pid# atualizado com sucesso.";
$pgv_lang["record_not_updated"]="Não foi possível atualizar o registro #pid#.";
$pgv_lang["record_removed"]="Registro #xref# foi excluido deste GEDCOM.";
$pgv_lang["record_not_removed"]="Não foi possível excluir o registro #xref# do GEDCOM.";
$pgv_lang["record_added"]="Registro #xref# adicionado com sucesso ao GEDCOM.";
$pgv_lang["record_not_added"]="Registro #xref# não pôde ser adicionado ao GEDCOM.";
$pgv_lang["search_gedcom"]="Pesquisar arquivos GEDCOM";
$pgv_lang["enter_terms"]="Informe os Argumentos da Pesquisa";
$pgv_lang["soundex_search"]="Pesquisa Fonética de Nomes";
$pgv_lang["sources"]="Fontes";
$pgv_lang["firstname_search"]="Nome";
$pgv_lang["lastname_search"]="Sobrenome";
$pgv_lang["search_place"]="Local";
$pgv_lang["search_year"]="Ano";
$pgv_lang["no_results"]="Nenhum resultado encontrado.";
$pgv_lang["search_options"]="Opções de Pesquisa";
$pgv_lang["search_geds"]="Pesquisar nos seguintes GEDCOMS";
$pgv_lang["search_type"]="Tipo de Pesquisa";
$pgv_lang["search_general"]="Pesquisa Normal";
$pgv_lang["search_soundex"]="Pesquisa Fonética";
$pgv_lang["search_replace"]="Pesquisar e Substituir";
$pgv_lang["search_inrecs"]="Pesquisar por";
$pgv_lang["search_fams"]="Famílias";
$pgv_lang["search_indis"]="Pessoas";
$pgv_lang["search_sources"]="Fontes";
$pgv_lang["search_more_chars"]="Informe mais de caracter";
$pgv_lang["search_soundextype"]="Tipo fonético:";
$pgv_lang["search_russell"]="Russell";
$pgv_lang["search_DM"]="Daitch-Mokotoff";
$pgv_lang["search_prtnames"]="Nome das pessoas<br />a serem impressas:";
$pgv_lang["search_prthit"]="Nomes com hit";
$pgv_lang["search_prtall"]="Todos os nomes";
$pgv_lang["search_tagfilter"]="Excluir Filtro";
$pgv_lang["search_tagfon"]="Excluir dados não genealógicos";
$pgv_lang["search_tagfoff"]="Desligado";
$pgv_lang["associate"]="testemunha";
$pgv_lang["search_asso_label"]="Testemunhas";
$pgv_lang["search_asso_text"]="Exibir pessoas/familias relacionadas";
$pgv_lang["results_per_page"]= "Resultados por página";
$pgv_lang["sources_found"]="Locais encontrados";
$pgv_lang["titles_found"]="Títulos";
$pgv_lang["find_source"]="Procurar pela Fonte";
$pgv_lang["repo_list"]="Reposição";
$pgv_lang["repos_found"]="Reposições encontradas";
$pgv_lang["find_repository"]="Procurar por Reposição";
$pgv_lang["total_repositories"]="Total de Reposições";
$pgv_lang["repo_info"]="Informação da Reposição";
$pgv_lang["other_repo_records"]="Registros ligados a esta Reposição:";
$pgv_lang["confirm_delete_repo"]="Confirma a exclusão desta Reposição?";
$pgv_lang["source_info"]="Informações da Fonte";
$pgv_lang["other_records"]="Outros registros relacionados a esta fonte:";
$pgv_lang["people"]="Pessoas";
$pgv_lang["families"]="Famílias";
$pgv_lang["total_sources"]="Total de Fontes";
$pgv_lang["building_indi"]="Gerando Índice de Pessoas e Famílias";
$pgv_lang["building_index"]="Gerando Índice de Listas";
$pgv_lang["invalid_gedformat"]="Formato de arquivo GEDCOM 5.5 inválido";
$pgv_lang["importing_records"]="Importando registros para o Banco do Dados";
$pgv_lang["detected_change"]="PhpGedView descobriu uma alteração no arquivo GEDCOM #GEDCOM#. Arquivos de índices devem ser regerados antes de prosseguir.";
$pgv_lang["flushing"]="Esvaziando conteúdo";
$pgv_lang["exec_time"]="Tempo total de execução";
$pgv_lang["unable_to_create_index"]="Impossibilitado de criar arquivo de índice.  Certifique-se que premissões de escrita estejam disponíveis ao PhpGedViewDirectory.  Permissões podem/devem ser restauradas após gravação dos arquivos de índice.";
$pgv_lang["indi_complete"]="Geração do índice de Pessoas terminado.";
$pgv_lang["family_complete"]="Geração do índice de Famílias terminado.";
$pgv_lang["source_complete"]="Geração do índice de Fontes terminado.";
$pgv_lang["tables_exist"]="Tabelas PhpGedView já existem no Banco de Dados";
$pgv_lang["you_may"]="Você pode:";
$pgv_lang["drop_tables"]="Excluir as tabelas atuais";
$pgv_lang["import_multiple"]="Importar e trabalhar com múltiplos arquivos GEDCOM";
$pgv_lang["explain_options"]="Se você escolher excluir as tabelas todos os dados serão substituidos por este GEDCOM.<br />Se você escolher Importar e trabalhar com múltiplos arquivos GEDCOM, PhpGedView apagará todo dado importado usando o GEDCOM com o mesmo nome.  Esta opção permite você armazenar múltiplas informações GEDCOM na mesma tabela e facilmente alternar entre as mesmas.";
$pgv_lang["path_to_gedcom"]="Informe o caminho do seu arquivo GEDCOM:";
$pgv_lang["changes_present"]="Esta árvore (GEDCOM) tem alterações pendentes, que serão aceitas automaticamente, caso a importação prossiga. Revise as alterações pendentes antes de continuar com a importação.";
$pgv_lang["index_complete"]="Geração de índices terminada.";
$pgv_lang["updating_is_dead"]="Updating is dead status for INDI ";
$pgv_lang["updating_family_names"]="Atualizando nomes de família para FAM ";
$pgv_lang["processed_for"]="Arquivo processado por ";
$pgv_lang["run_tools"]="Você deseja executar alguma destas ferramentas no seu GEDCOM antes de importá-lo:";
$pgv_lang["addmedia"]="Ferramenta de Adição de Fotos";
$pgv_lang["dateconvert"]="Ferramenta de Conversão de Datas";
$pgv_lang["xreftorin"]="Converte XREF IDs para números RIN";
$pgv_lang["tools_readme"]="Veja a seção de Ferramentas no arquivo &lt;a href=&quot;readme.txt&quot;&gt;readme.txt&lt;/a&gt; para maiores informações.";
$pgv_lang["sec"]="segundos.";
$pgv_lang["total_fams"]="Total Famílias";
$pgv_lang["total_indis"]="Total Pessoas";
$pgv_lang["starts_with"]="Começar Com:";
$pgv_lang["person_list"]="Listar Pessoa:";
$pgv_lang["paste_person"]="Colar Pessoa";
$pgv_lang["notes_sources_media"]="Notas, Fontes e Mídia";
$pgv_lang["notes"]="Notas";
$pgv_lang["ssourcess"]="Fontes";
$pgv_lang["media"]="Mídia";
$pgv_lang["name_contains"]="Nome Contendo:";
$pgv_lang["filter"]="Pesquisar";
$pgv_lang["find_individual"]="Procurar ID de Pessoa";
$pgv_lang["find_familyid"]="Procurar ID de Família";
$pgv_lang["find_sourceid"]="Procurar ID de Fonte";
$pgv_lang["find_specialchar"]="Procura por Caracteres Especiais";
$pgv_lang["magnify"]="Ampliar";
$pgv_lang["skip_surnames"]="Mostre Lista de Pessoas";
$pgv_lang["show_surnames"]="Exibir Lista de Sobrenomes";
$pgv_lang["all"]="Todos";
$pgv_lang["hidden"]="Secreto";
$pgv_lang["confidential"]="Confidencial";
$pgv_lang["alpha_index"]="Índice Alfabético";
$pgv_lang["name_list"]="Lista de Nomes";
$pgv_lang["firstname_alpha_index"]="Índice Alfabético de Nomes";
$pgv_lang["age"]="Idade";
$pgv_lang["days"]="dias";
$pgv_lang["months"]="meses";
$pgv_lang["years"]="anos";
$pgv_lang["day1"]="dia";
$pgv_lang["month1"]="mês";
$pgv_lang["year1"]="ano";
$pgv_lang["timeline_title"]="Linha do Tempo";
$pgv_lang["timeline_chart"]="Linha do Tempo";
$pgv_lang["remove_person"]="Remover Pessoa";
$pgv_lang["show_age"]="Exibir Marcador de Idade";
$pgv_lang["add_another"]="Adicione uma outra pessoa ao gráfico:<br />ID da Pessoa:";
$pgv_lang["find_id"]="Procurar ID";
$pgv_lang["show"]="Exibir";
$pgv_lang["year"]="Ano:";
$pgv_lang["timeline_instructions"]=">>> Em Browsers mais novos você pode clicar e mover as caixas na linha do tempo com o mouse <<<";
$pgv_lang["zoom_in"]="Mais Zoom";
$pgv_lang["timeline_scrollSpeed"] = "Velocidade";
$pgv_lang["timeline_endYear"] = "Ano de Término";
$pgv_lang["timeline_beginYear"] = "Ano de Início";
$pgv_lang["zoom_out"]="Menos Zoom";

$pgv_lang["cal_gregorian"]="Gregoriano";
$pgv_lang["cal_julian"]="Juliano";
$pgv_lang["cal_french"]="Francês";
$pgv_lang["cal_jewish"]="Judeu";
$pgv_lang["cal_hebrew"]="Hebreu";
$pgv_lang["cal_jewish_and_gregorian"]="Judeu e Gregoriano";
$pgv_lang["cal_hebrew_and_gregorian"]="Hebreu e Gregoriano";
$pgv_lang["cal_hijri"]="Hijri";

$pgv_lang["jan"]="Janeiro";
$pgv_lang["feb"]="Fevereiro";
$pgv_lang["mar"]="Março";
$pgv_lang["apr"]="Abril";
$pgv_lang["may"]="Maio";
$pgv_lang["jun"]="Junho";
$pgv_lang["jul"]="Julho";
$pgv_lang["aug"]="Agosto";
$pgv_lang["sep"]="Setembro";
$pgv_lang["oct"]="Outubro";
$pgv_lang["nov"]="Novembro";
$pgv_lang["dec"]="Dezembro";
$pgv_lang["abt"]="ao redor de";
$pgv_lang["aft"]="após";
$pgv_lang["and"]="e";
$pgv_lang["bef"]="antes de";
$pgv_lang["bet"]="entre";
$pgv_lang["cal"]="calculado";
$pgv_lang["est"]="estimado em";
$pgv_lang["from"]="de";
$pgv_lang["int"]="interpretado";
$pgv_lang["to"]="até";
$pgv_lang["cir"]="aproximadamente";
$pgv_lang["apx"]="aprox.";
$pgv_lang["rebuild_indexes"]="Reconstruir Índices";
$pgv_lang["user_admin"]="Gerenciar Usuários";
$pgv_lang["password_mismatch"]="Senhas não conferem.";
$pgv_lang["enter_username"]="Informe o nome do usuário.";
$pgv_lang["enter_fullname"]="Informe o nome completo.";
$pgv_lang["enter_password"]="Informe sua senha.";
$pgv_lang["confirm_password"]="Confirme sua senha.";
$pgv_lang["save"]="Gravar";
$pgv_lang["delete"]="Excluir";
$pgv_lang["edit"]="Editar";
$pgv_lang["no_login"]="Incapaz de autenticar o usuário.";
$pgv_lang["basic_realm"]="Sistema de Autenticação do PhpGedView";
$pgv_lang["basic_auth_failure"]="Para acessar este recurso é necessário indentificar-se, informando usuário/senha.";
$pgv_lang["basic_auth"]="Autenticação Básica";
$pgv_lang["digest_auth"]="Autenticação Digest";
$pgv_lang["no_auth_needed"]="Não usar Autenticação";
$pgv_lang["import_gedcom"]="Importar este arquivo GEDCOM";
$pgv_lang["enter_gedcomid"]="Informe uma ID da GEDCOM.";
$pgv_lang["user_info"]="Minhas Informações";
$pgv_lang["enter_filename"]="Informe o nome do arquivo GEDCOM.";
$pgv_lang["file_not_exists"]="O nome do arquivo informado não existe.";
$pgv_lang["file_not_present"]="Arquivo inexistente.";
$pgv_lang["file_exists"]="Já existe um arquivo GEDCOM com esse nome. Por favor escolha um nome diferente ou exclua o outro arquivo.";
$pgv_lang["new_gedcom_title"]="Genealogia de [#GEDCOMFILE#]";
$pgv_lang["upload_gedcom_help"]="Selecione, em seu computador, o arquivo GEDCOM ou ZIP a ser enviado para o servidor e gravado na pasta <b>#INDEX_DIRECTORY#</b>.<br /><br />Caso o arquivo esteja no formato ZIP, este deve conter apenas um arquivo GEDCOM e é este arquivo que será utilizado nos próximos passos.<br /><br />";
$pgv_lang["add_gedcom_instructions"]="Informe um novo nome para este novo arquivo GEDCOM.  O novo arquivo GEDCOM será criado no diretório Index: ";
$pgv_lang["research_assistant"]="Assistente de Pesquisa";
$pgv_lang["utf8_to_ansi"]="Converter o arquivo GEDCOM do formato UTF-8 para ANSI (ISO-8859-1)?";
$pgv_lang["user_manual"]="PhpGedView Manual do Usuário";
$pgv_lang["upgrade"]="Atualizar PhpGedView/ResearchLog";
$pgv_lang["step1"]="Passo 1 de 4:";
$pgv_lang["step3"]="Passo 3 de 4:";
$pgv_lang["step4"]="Passo 4 de 4:";
$pgv_lang["cancel_upload"]="Cancelar Envio";
$pgv_lang["add_media_records"]="Adicionar registros de Mídia";
$pgv_lang["manage_media_files"]="Gerenciar arquivos de Mídia";
$pgv_lang["link_media_records"]="Ligações de Mídia";
$pgv_lang["add_media_button"]="Adicionar Mídia";
$pgv_lang["media_linked"]="Esta Mídia esta ligada a:";
$pgv_lang["media_not_linked"]="Esta Mídia não está ligada a nenhum registro da árvore (GEDCOM).";
$pgv_lang["relationship_chart"]="Relacionamentos";
$pgv_lang["person1"]="Pessoa 1";
$pgv_lang["person2"]="Pessoa 2";
$pgv_lang["no_link_found"]="Nenhum (outro) relacionamento entre estas duas pessoas foi localizado.";
$pgv_lang["sibling"]="Irmãos";
$pgv_lang["follow_spouse"]="Verificar relacionamentos por casamento";
$pgv_lang["timeout_error"]="O tempo destinado à pesquisa encerrou antes de encontrar um relacionamento.";
$pgv_lang["son"]="Filho";
$pgv_lang["daughter"]="Filha";
$pgv_lang["son-in-law"]="Genro";
$pgv_lang["daughter-in-law"]="Nora";
$pgv_lang["grandchild"]="Neto";
$pgv_lang["grandson"]="Neto";
$pgv_lang["granddaughter"]="Neta";
$pgv_lang["brother"]="Irmão";
$pgv_lang["sister"]="Irmã";
$pgv_lang["brother-in-law"]="Cunhado";
$pgv_lang["sister-in-law"]="Cunhada";
$pgv_lang["aunt"]="Tia";
$pgv_lang["uncle"]="Tio";
$pgv_lang["firstcousin"]="Primo";
$pgv_lang["femalecousin"]="Prima";
$pgv_lang["malecousin"]="Primo";
$pgv_lang["cousin-in-law"]="Irmã(o) da(o) Cunhada(o)";
$pgv_lang["relationship_to_me"]="Relacionamento Comigo";
$pgv_lang["rela_husb"]="Relação com o marido";
$pgv_lang["rela_wife"]="Relação com a esposa";
$pgv_lang["next_path"]="Localizar novo caminho ";
$pgv_lang["show_path"]="Exibir caminho";
$pgv_lang["line_up_generations"]="Alinhar as mesmas generações";
$pgv_lang["oldest_top"]="Exibir mais velho no topo";
// %1\$s replaced by first person, %2\$s by the relationship and %3\$s by the second person.
$pgv_lang["relationship_male_1_is_the_2_of_3"] = "%1\$s é o %2\$s de %3\$s.";
$pgv_lang["relationship_female_1_is_the_2_of_3"] = "%1\$s é o %2\$s de %3\$s.";
$pgv_lang["mother_in_law"]		    = "sogra";
$pgv_lang["father_in_law"]		    = "sogro";
$pgv_lang["brother_in_law"]		    = "cunhado";
$pgv_lang["sister_in_law"]		    = "cunhada";
$pgv_lang["son_in_law"]		        = "genro";
$pgv_lang["daughter_in_law"]		= "nora";
$pgv_lang["step_father"]	        = "padrastro";
$pgv_lang["step_mother"]	        = "madrastra";
$pgv_lang["step_son"]		        = "enteado";
$pgv_lang["step_daughter"]	    	= "enteada";
$pgv_lang["step_brother"]		    = "meio-irmão";
$pgv_lang["step_daughter"]	        = "meia-irmã";
// NOTE in the translations below %d is replaced with the number of greats
$pgv_lang["n_x_great_grandfather"]	= "%d x bis-avô";
$pgv_lang["n_x_great_grandmother"]	= "%d x bis-avó";
// the bosa_brothers_offspring name is used for fraternal nephews and nieces - the names below can be extended to any number
// of generations just by adding more translations.
// 1st generation
$pgv_lang["bosa_brothers_offspring_2"] 				= "sobrinho";            // brother's son
$pgv_lang["bosa_brothers_offspring_3"] 				= "sobrinha";            // brother's daughter
// 2nd generation
$pgv_lang["bosa_brothers_offspring_4"] 				= "great nephew";       // brother's son's son 
$pgv_lang["bosa_brothers_offspring_5"] 				= "great niece";        // brother's son's daughter
$pgv_lang["bosa_brothers_offspring_6"] 				= "great nephew";       // brother's daughter's son
$pgv_lang["bosa_brothers_offspring_7"] 				= "great niece";        // brother's daughter's daughter
// for the general case of offspring of the nth generation use the text below
// in this text %1\$d is replaced with the number of generations
//              %2\$d is replaced with the number of generations - 1
//              %3\$d is replaced with the number of generations - 2
$pgv_lang["n_x_brothers_son"]	  = "%2\$d x great nephew";
$pgv_lang["n_x_brothers_daughter"] = "%2\$d x great niece";
// the bosa_sisters_offspring name is used for sisters nephews and nieces - the names below can be extended to any number
// of generations just by adding more translations.
// 1st generation
$pgv_lang["bosa_sisters_offspring_2"] 				= "sobrinho";             // sister's son
$pgv_lang["bosa_sisters_offspring_3"] 				= "sobrinha";             // sister's daughter
// 2nd generation
$pgv_lang["bosa_sisters_offspring_4"] 				= "great nephew";       // sister's son's son 
$pgv_lang["bosa_sisters_offspring_5"] 				= "great niece";        // sister's son's daughter
$pgv_lang["bosa_sisters_offspring_6"] 				= "great nephew";       // sister's daughter's son
$pgv_lang["bosa_sisters_offspring_7"] 				= "great niece";        // sister's daughter's daughter
// for the general case of offspring of the nth generation use the text below
// in this text %1\$d is replaced with the number of generations
//              %2\$d is replaced with the number of generations - 1
//              %3\$d is replaced with the number of generations - 2
$pgv_lang["n_x_sisters_son"]	  = "%2\$d x great nephew";
$pgv_lang["n_x_sisters_daughter"] = "%2\$d x great niece";
// the bosa name is used for offspring - the names below can be extended to any number
// of generations just by adding more translations.
// 1st generation
$pgv_lang["bosa_2"] 				= $pgv_lang["son"];                   // son
$pgv_lang["bosa_3"] 				= $pgv_lang["daughter"];              // daughter
// 2nd generation
$pgv_lang["bosa_4"] 				= $pgv_lang["grandson"];              // son's son 
$pgv_lang["bosa_5"] 				= $pgv_lang["granddaughter"];         // son's daughter
$pgv_lang["bosa_6"] 				= $pgv_lang["grandson"];              // daughter's son
$pgv_lang["bosa_7"] 				= $pgv_lang["granddaughter"];         // daughter's daughter
// 3rd generation
$pgv_lang["bosa_8"] 				= "bis-neto";   // son's son's son   
$pgv_lang["bosa_9"] 				= "bis-neta";   // son's son's daughter
$pgv_lang["bosa_10"] 				= "bis-neto";	// son's daughters son
$pgv_lang["bosa_11"] 				= "bis-neta";   // son's daughters daughter
$pgv_lang["bosa_12"] 				= "bis-neto";   // daughter's son's son 
$pgv_lang["bosa_13"] 				= "bis-neta";   // daughter's son's daughter
$pgv_lang["bosa_14"] 				= "bis-neto";   // daughter's daughters son
$pgv_lang["bosa_15"] 				= "bis-neta";   // daughter's daughters daughter
// for the general case of offspring of the nth generation use the text below
// in this text %1\$d is replaced with the number of generations
//              %2\$d is replaced with the number of generations - 1
//              %3\$d is replaced with the number of generations - 2
$pgv_lang["n_x_grandson_from_son"]	  = "%3\$d x bis-neto";
$pgv_lang["n_x_granddaughter_from_son"] = "%3\$d x bis-neta";
$pgv_lang["n_x_grandson_from_daughter"]	  = "%3\$d x bis-neto";
$pgv_lang["n_x_granddaughter_from_daughter"] = "%3\$d x bis-neta";
// the sosa_uncle name is used for uncles - the names below can be extended to any number
// of generations just by adding more translations.
// to allow fo language variations we specify different relationships for paternal and maternal
// aunts and uncles
// 1st generation
$pgv_lang["sosa_uncle_2"] 				= $pgv_lang["uncle"];            // fathers brother
$pgv_lang["sosa_uncle_3"] 				= $pgv_lang["uncle"];            // mothers brother
// 2nd generation
$pgv_lang["sosa_uncle_4"] 				= "tio-avô";      // fathers's fathers brother 
$pgv_lang["sosa_uncle_5"] 				= "tio-avô";      // fathers mothers brother
$pgv_lang["sosa_uncle_6"] 				= "tio-avô";      // mothers fathers brother
$pgv_lang["sosa_uncle_7"] 				= "tio-avô";      // mothers mothers brother
// for the general case of uncles of the nth degree use the text below
// in this text %1\$d is replaced with the number of generations
//              %2\$d is replaced with the number of generations - 1
//              %3\$d is replaced with the number of generations - 2
$pgv_lang["n_x_paternal_uncle"]		= "%2\$d x great uncle";
$pgv_lang["n_x_maternal_uncle"]	    = "%2\$d x great uncle";
// the sosa_aunt name is used for aunts - the names below can be extended to any number
// of generations just by adding more translations.
// to allow fo language variations we specify different relationships for paternal and maternal
// aunts and aunts
// 1st generation
$pgv_lang["sosa_aunt_2"] 				= $pgv_lang["aunt"];            // fathers sister
$pgv_lang["sosa_aunt_3"] 				= $pgv_lang["aunt"];            // mothers sister
// 2nd generation
$pgv_lang["sosa_aunt_4"] 				= "tia-avó";      // fathers's fathers sister 
$pgv_lang["sosa_aunt_5"] 				= "tia-avó";      // fathers mothers sister
$pgv_lang["sosa_aunt_6"] 				= "tia-avó";      // mothers fathers sister
$pgv_lang["sosa_aunt_7"] 				= "tia-avó";      // mothers mothers sister
// for the general case of aunts of the nth degree use the text below
// in this text %1\$d is replaced with the number of generations
//              %2\$d is replaced with the number of generations - 1
//              %3\$d is replaced with the number of generations - 2
$pgv_lang["n_x_paternal_aunt"]		= "%2\$d x great aunt";
$pgv_lang["n_x_maternal_aunt"]	    = "%2\$d x great aunt";
// the sosa_uncle_bm name is used for uncles (by marriage) - the names below can be extended to any number
// of generations just by adding more translations.
// to allow fo language variations we specify different relationships for paternal and maternal
// aunts and uncles
// 1st generation
$pgv_lang["sosa_uncle_bm_2"] 				= $pgv_lang["uncle"];            // fathers brother
$pgv_lang["sosa_uncle_bm_3"] 				= $pgv_lang["uncle"];            // mothers brother
// 2nd generation
$pgv_lang["sosa_uncle_bm_4"] 				= "tio-avô";      // fathers's fathers brother 
$pgv_lang["sosa_uncle_bm_5"] 				= "tio-avô";      // fathers mothers brother
$pgv_lang["sosa_uncle_bm_6"] 				= "tio-avô";      // mothers fathers brother
$pgv_lang["sosa_uncle_bm_7"] 				= "tio-avô";      // mothers mothers brother
// for the general case of uncles of the nth degree use the text below
// in this text %1\$d is replaced with the number of generations
//              %2\$d is replaced with the number of generations - 1
//              %3\$d is replaced with the number of generations - 2
$pgv_lang["n_x_paternal_uncle_bm"]		= "%2\$d x great uncle";
$pgv_lang["n_x_maternal_uncle_bm"]	    = "%2\$d x great uncle";
// the sosa_aunt_bm name is used for aunts (by marriage) - the names below can be extended to any number
// of generations just by adding more translations.
// to allow fo language variations we specify different relationships for paternal and maternal
// aunts and aunts
// 1st generation
$pgv_lang["sosa_aunt_bm_2"] 				= $pgv_lang["aunt"];            // fathers sister
$pgv_lang["sosa_aunt_bm_3"] 				= $pgv_lang["aunt"];            // mothers sister
// 2nd generation
$pgv_lang["sosa_aunt_bm_4"] 				= "tia-avó";      // fathers's fathers sister 
$pgv_lang["sosa_aunt_bm_5"] 				= "tia-avó";      // fathers mothers sister
$pgv_lang["sosa_aunt_bm_6"] 				= "tia-avó";      // mothers fathers sister
$pgv_lang["sosa_aunt_bm_7"] 				= "tia-avó";      // mothers mothers sister
// for the general case of aunts of the nth degree use the text below
// in this text %1\$d is replaced with the number of generations
//              %2\$d is replaced with the number of generations - 1
//              %3\$d is replaced with the number of generations - 2
$pgv_lang["n_x_paternal_aunt_bm"]		= "%2\$d x great aunt";
$pgv_lang["n_x_maternal_aunt_bm"]	    = "%2\$d x great aunt";
// if a specific cousin relationship cannot be represented in a language translate as "";
$pgv_lang["male_cousin_1"]              = "primo";
$pgv_lang["male_cousin_2"]              = "primo do 2º gravi";
$pgv_lang["male_cousin_3"]              = "primo do 3º gravi";
$pgv_lang["male_cousin_4"]              = "primo do 4º gravi";
$pgv_lang["male_cousin_5"]              = "primo do 5º gravi";
$pgv_lang["male_cousin_6"]              = "primo do 6º gravi";
$pgv_lang["male_cousin_7"]              = "primo do 7º gravi";
$pgv_lang["male_cousin_8"]              = "primo do 8º gravi";
$pgv_lang["male_cousin_9"]              = "primo do 9º gravi";
$pgv_lang["male_cousin_10"]             = "primo do 10º gravi";
$pgv_lang["male_cousin_11"]             = "primo do 11º gravi";
$pgv_lang["male_cousin_12"]             = "primo do 12º gravi";
$pgv_lang["male_cousin_13"]             = "primo do 13º gravi";
$pgv_lang["male_cousin_14"]             = "primo do 14º gravi";
$pgv_lang["male_cousin_15"]             = "primo do 15º gravi";
$pgv_lang["male_cousin_16"]             = "primo do 16º gravi";
$pgv_lang["male_cousin_17"]             = "primo do 17º gravi";
$pgv_lang["male_cousin_18"]             = "primo do 18º gravi";
$pgv_lang["male_cousin_19"]             = "primo do 19º gravi";
$pgv_lang["male_cousin_20"]             = "primo do 20º gravi";
$pgv_lang["male_cousin_n"]              = "primo do %dº gravi";
$pgv_lang["female_cousin_1"]            = "prima";
$pgv_lang["female_cousin_2"]            = "prima do 2º gravi";
$pgv_lang["female_cousin_3"]            = "prima do 3º gravi";
$pgv_lang["female_cousin_4"]            = "prima do 4º gravi";
$pgv_lang["female_cousin_5"]            = "prima do 5º gravi";
$pgv_lang["female_cousin_6"]            = "prima do 6º gravi";
$pgv_lang["female_cousin_7"]            = "prima do 7º gravi";
$pgv_lang["female_cousin_8"]            = "prima do 8º gravi";
$pgv_lang["female_cousin_9"]            = "prima do 9º gravi";
$pgv_lang["female_cousin_10"]           = "prima do 10º gravi";
$pgv_lang["female_cousin_11"]           = "prima do 11º gravi";
$pgv_lang["female_cousin_12"]           = "prima do 12º gravi";
$pgv_lang["female_cousin_13"]           = "prima do 13º gravi";
$pgv_lang["female_cousin_14"]           = "prima do 14º gravi";
$pgv_lang["female_cousin_15"]           = "prima do 15º gravi";
$pgv_lang["female_cousin_16"]           = "prima do 16º gravi";
$pgv_lang["female_cousin_17"]           = "prima do 17º gravi";
$pgv_lang["female_cousin_18"]           = "prima do 18º gravi";
$pgv_lang["female_cousin_19"]           = "prima do 19º gravi";
$pgv_lang["female_cousin_20"]           = "prima do 20º gravi";
$pgv_lang["female_cousin_n"]            = "prima do %dº gravi";
$pgv_lang["check_delete"]="Confirma a exclusão deste fato do arquivo GEDCOM?";
$pgv_lang["access_denied"]="<b>Acesso Negado</b><br />Você não tem acesso a este recurso.";
$pgv_lang["changes_exist"]="Foram feitas alterações neste arquivo GEDCOM.";
$pgv_lang["find_place"]="Procurar Local";
$pgv_lang["close_window"]="Fechar Janela";
$pgv_lang["close_window_without_refresh"]="Fechar Janela sem Recarregar";
$pgv_lang["place_contains"]="Locais contendo:";
$pgv_lang["now_import"]="Agora importe os registros GEDCOM para o PhpGedView clicando no link de importação abaixo.";
$pgv_lang["add"]="Adicionar";
$pgv_lang["custom_event"]="Configurar Evento";
$pgv_lang["delete_person"]="Excluir esta Pessoa";
$pgv_lang["confirm_delete_person"]="Confirma exclusão desta pessoa do arquivo GEDCOM?";
$pgv_lang["find_media"]="Localizar Mídia";
$pgv_lang["set_link"]="Preparar Link";
$pgv_lang["delete_source"]="Excluir esta Fonte";
$pgv_lang["confirm_delete_source"]="Confirma exclusão desta fonte do arquivo GEDCOM?";
$pgv_lang["find_family"]="Pesquisar Família";
$pgv_lang["find_fam_list"]="Pesquisar lista de Famílias";
$pgv_lang["edit_name"]="Alterar Nome";
$pgv_lang["delete_name"]="Excluir Nome";
$pgv_lang["select_date"]="Selecionar uma data";
$pgv_lang["user_cannot_edit"]="Este usuário não tem permissão para edição do GEDCOM.";
$pgv_lang["ged_noshow"]="Esta página foi desabiltada pelo administrador.";
$pgv_lang["bdm"]="Nascimentos, Falecimentos e Casamentos";
$pgv_lang["on_this_day"]="Este Dia em nossa História ...";
$pgv_lang["in_this_month"]="Este Mês em nossa História ...";
$pgv_lang["in_this_year"]="Este Ano em nossa História ...";
$pgv_lang["year_anniversary"]="#year_var# anos";
$pgv_lang["today"]="Hoje";
$pgv_lang["day"]="Dia:";
$pgv_lang["month"]="Mês:";
$pgv_lang["showcal"]="Exibir Eventos de:";
$pgv_lang["anniversary_calendar"]="Calendário";
$pgv_lang["sunday"]="Domingo";
$pgv_lang["monday"]="Segunda";
$pgv_lang["tuesday"]="Terça";
$pgv_lang["wednesday"]="Quarta";
$pgv_lang["thursday"]="Quinta";
$pgv_lang["friday"]="Sexta";
$pgv_lang["saturday"]="Sábado";
$pgv_lang["viewday"]="Exibir Dia";
$pgv_lang["viewmonth"]="Exibir Mês";
$pgv_lang["viewyear"]="Exibir Ano";
$pgv_lang["all_people"]="Todas as Pessoas";
$pgv_lang["living_only"]="Pessoas Vivas";
$pgv_lang["recent_events"]="Eventos Recentes (< 100 anos)";
$pgv_lang["day_not_set"]="Dia não configurado";
$pgv_lang["year_error"]="Desculpas, datas anteriores a 1970 não são permitidas.";
$pgv_lang["lost_password"]="Perdeu sua senha?";
$pgv_lang["requestpassword"]="Solicitação de cadastramento de nova senha";
$pgv_lang["no_account_yet"]="Ainda não é um usuário cadastrado?";
$pgv_lang["requestaccount"]="Solicitação de cadastramento de novo Usuário";
$pgv_lang["emailadress"]="E-mail";
$pgv_lang["mandatory"]="Campos com * são obrigatórios.";
$pgv_lang["mail01_line01"]="Olá #user_fullname# ...";
$pgv_lang["mail01_line02"]="Um pedido de cadastramento de conta feito em ( #SERVER_NAME# ) está utilizando seu endereço de E-mail ( #user_email# ).";
$pgv_lang["mail01_line03"]="Os seguintes dados estão sendo usuados.";
$pgv_lang["mail01_line04"]="Por favor clique no link abaixo e preencha o formulário para validar sua Conta e endereço de E-mail.";
$pgv_lang["mail01_line05"]="Ignore esta mensagem caso você não tenha solicitado esse cadastramento.";
$pgv_lang["mail01_line06"]="Você não receberá mais nenhum outro E-mail deste site. Contas não validadas em até 7 dias, são eliminadas automaticamente.";
$pgv_lang["mail01_subject"]="Seu registro em #SERVER_NAME#";
$pgv_lang["mail02_line01"]="Olá Administrador ...";
$pgv_lang["mail02_line02"]="Existe um registro de novo usuário em ( #SERVER_NAME# ).";
$pgv_lang["mail02_line03"]="O usuário recebeu um e-mail com os dados necessários para confirmar sua conta.";
$pgv_lang["mail02_line04"]="Tão logo o usuário faça a validação da conta você será informado por e-mail. O novo usuário só conseguirá acessar o site, após você ativar a conta dele.";
$pgv_lang["mail02_line04a"]="Você será informado por email quando este usuário confirmar sua adesão ao site. Após a adesão, o usuário poderá se conectar sem necessitar de sua intervenção.";
$pgv_lang["mail02_subject"]="Novo registro em #SERVER_NAME#";
$pgv_lang["hashcode"]="Código de validação";
$pgv_lang["thankyou"]="Olá #user_fullname# ...<br />Obrigado por seu registro";
$pgv_lang["pls_note06"]="Você receberá um e-mail de confirmação no endereço ( #user_email# ). Siga as instruções do e-mail de confirmação para validar seu pedido de uma conta. Você terá até 7 dias para validar seu pedido, após este prazo seu pedido será eliminado. Sua validação será enviada para ser aprovada pelo Administrador do site. Após aprovada a conta, você precisará saber seu nome de usuário e senha para acessar o site.";
$pgv_lang["pls_note06a"]="Um email será enviado para o endereço #user_email#, com as instruções para desbloquear sua conta. A conta será removida se não for desbloqueada em 7 dias.<br /><br />Após o desbloqueio, informe seu Nome de Usuário/Senha e entre no site.<br /><br />";
$pgv_lang["registernew"]="Confirmação de nova conta";
$pgv_lang["user_verify"]="Validação de Usuário";
$pgv_lang["send"]="Enviar";
$pgv_lang["pls_note07"]="Por favor, digite nome de Usuário, Senha e Código de validação para receber deste sistema, por E-mail, a validação de seu cadastramento.";
$pgv_lang["pls_note08"]="Os dados do Usuário <b>#user_name#</b> foram validados.";
$pgv_lang["mail03_line01"]="Olá Administrador ...";
$pgv_lang["mail03_line02"]="#newuser[username]# ( #newuser[fullname]# ) verificou os dados de registro.";
$pgv_lang["mail03_line03"]="Por favor, clique no link abaixo para conectar ao seu site e verificar os dados do usuário para permitir-lhe acesso ao seu site.";
$pgv_lang["mail03_line03a"]="Conta ativada, o usuário já pode acessar o site.";
$pgv_lang["mail03_subject"]="Nova verificação em #SERVER_NAME#";
$pgv_lang["pls_note09"]="Você foi identificado como um usuário registrado.";
$pgv_lang["pls_note10"]="O Administrador será informado e tão logo ele dê permissão, você poderá acessar o site usando seu nome de usuário e senha.";
$pgv_lang["pls_note10a"]="Sua conta foi desbloqueada, informe Nome de Usuário/Senha e entre no site.";
$pgv_lang["data_incorrect"]="Dados incorretos!<br />Por favor tente novamente!";
$pgv_lang["user_not_found"]="Não foi possível verificar as informações.  Por favor retorne e tente novamente.";
$pgv_lang["lost_pw_reset"]="Solicitação de cadastramento de nova senha";
$pgv_lang["pls_note11"]="Para refazer sua senha perdida, forneça os nome de usuário e endereço de e-mail de sua conta. <br /><br />Nós enviaremos via e-mail uma URL especial, a qual contém uma confirmação para sua conta. Visitando a URL fornecida, nós permitiremos a mudança de sua senha e nome de usuário para este site. Por medida de segurança, você não deve fornecer informações desse e-mail para ninguém, incluindo os administradores desse site.<br /><br />Se você precisar de ajuda, por favor, entre em contato com o administrator do site.";
$pgv_lang["enter_email"]="Informer seu e-mail.";
$pgv_lang["mail04_line01"]="Oi #user_fullname# ...";
$pgv_lang["mail04_line02"]="Uma nova senha foi solicitada para o seu nome de usuário!";
$pgv_lang["mail04_line03"]="Recomendações:";
$pgv_lang["mail04_line04"]="Agora clique no link abaixo, conecte com sua nova senha e altere-a para manter segura a integridade de seus dados.";
$pgv_lang["mail04_line05"]="Após identificar-se, clique em '#pgv_lang[myuserdata]#' da opção de menu '#pgv_lang[mygedview]#' e altere sua senha.";
$pgv_lang["mail04_subject"]="Requisição de Dados de #SERVER_NAME#";
$pgv_lang["pwreqinfo"]="Olá ...<br /><br />Um e-mail foi enviado para seu endereço (#user[email]#) contendo a nova senha.<br /><br />Verifique no seu programa de e-mails o recebimento do mesmo.<br /><br />Recomendação:<br /><br />Após receber o e-mail, acesse o site utilizando a nova senha e altere-a para manter segura a integridade de seus dados.";
$pgv_lang["editowndata"]="Minha Conta";
$pgv_lang["savedata"]="Gravar dados alterados";
$pgv_lang["datachanged"]="User data was changed!";
$pgv_lang["datachanged_name"]="Identifique-se novamente utilizando seu novo nome de usuário.";
$pgv_lang["myuserdata"]="Minha Conta";
$pgv_lang["user_theme"]="Meu Tema";
$pgv_lang["mgv"]="Meu Portal";
$pgv_lang["mygedview"]="Meu Portal";
$pgv_lang["passwordlength"]="Senha precisa conter ao menos 6 caracteres.";
$pgv_lang["welcome_text_auth_mode_1"]="<b>BEM-VINDO A ESTE SITE GENEALÓGICO</b><br /><br />O acesso a este site é permitido a qualquer visitante, desde que tenha uma conta.<br />Se já tem uma conta, basta identificar-se, caso contrário clique no link apropriado nesta página e solicite a sua.<br />Sua solicitação será enviada ao Administrador do site que ativará sua conta e lhe enviará um email instruindo-o de como acessar o site.";
$pgv_lang["welcome_text_auth_mode_2"]="<b>BEM-VINDO A ESTE SITE GENEALÓGICO</b><br /><br />Para acessar este site é necessário ter uma conta.<br />Se já tem uma, basta identificar-se, caso contrério, clique no link apropriado nesta página e solicite a sua conta.<br />Sua solicitação será enviada ao Administrador do site e pode ser aceita ou não.<br />Um email será enviado informando-o da decisão do Administrador.";
$pgv_lang["welcome_text_auth_mode_3"]="<b>BEM-VINDO A ESTE SITE GENEALÓGICO</b><br /><br />O acesso a este site é permitido <b>somente a pessoas da família</b>.<br />Se já tem uma conta, basta identificar-se, caso contrário clique no link apropriado nesta página e solicite a sua.<br />Sua solicitação será enviada ao Administrador do site e pode ser aceita ou não.<br />Um email será enviado informando-o da decisão do Administrador.";
$pgv_lang["welcome_text_cust_head"]="<b>BEM-VINDO A ESTE SITE GENEALÓGICO</b><br /><br />O acesso é permitido a todos que tenham uma conta.<br />";
$pgv_lang["welcome"]="Bem-Vindo";
$pgv_lang["upcoming_events"]="Próximos Eventos";
$pgv_lang["living_or_all"]="Exibir somente eventos dos Vivos.";
$pgv_lang["basic_or_all"]="Exibir apenas Nascimentos, Falecimentos e Casamentos?";
$pgv_lang["no_events_living"]="Não há eventos de pessoas vivas para os próximos #pgv_lang[global_num1]# dias.";
$pgv_lang["no_events_living1"]="Para amanhã, não há eventos com pessoas vivas.";
$pgv_lang["no_events_all"]="Não eventos cadastrados para os próximos #pgv_lang[global_num1]# dias.";
$pgv_lang["no_events_all1"]="Para amanhã não eventos cadastrados.";
$pgv_lang["no_events_privacy"]="Apesar de haver eventos para os próximos #pgv_lang[global_num1]# dias, por uma questão de privacidade você não pode ve-los.<br />";
$pgv_lang["no_events_privacy1"]="Há eventos para amanhã, mas por uma questão de privacidade você não pode ve-los.";
$pgv_lang["more_events_privacy"]="<br />Existem mais eventos para os próximos #pgv_lang[global_num1]# dias, mas por uma questão de privacidade você não pode ve-los.";
$pgv_lang["more_events_privacy1"]="br />Ha mais eventos para amanhã, mas por uma questão de privacidade você não pode ve-los.";
$pgv_lang["none_today_living"]="No dia de hoje, não há eventos com pessoas vivas.";
$pgv_lang["none_today_all"]="Não há eventos para o dia de hoje.";
$pgv_lang["none_today_privacy"]="Há eventos na data de hoje, mas por uma questão de privacidade você nãopode ve-los.";
$pgv_lang["more_today_privacy"]="<br />Há mais eventos no dia de hoje, mas por uma questão de privacidade você não pode ve-los.";
$pgv_lang["chat"]="Bate-papo";
$pgv_lang["users_logged_in"]="Usuários Conectados";
$pgv_lang["anon_user"]="1 usuário anônimo conectado";
$pgv_lang["anon_users"]="#pgv_lang[global_num1]# usuários anônimos conectados";
$pgv_lang["login_user"]="1 usuário conectado";
$pgv_lang["login_users"]="#pgv_lang[global_num1]# usuários conectados";
$pgv_lang["no_login_users"]="Nenhum usuário conectado";
$pgv_lang["message"]="Enviar Mensagem";
$pgv_lang["my_messages"]="Minhas Mensagens";
$pgv_lang["date_created"]="Data";
$pgv_lang["message_from"]="E-mail";
$pgv_lang["message_from_name"]="Seu Nome";
$pgv_lang["message_to"]="Para";
$pgv_lang["message_subject"]="Assunto";
$pgv_lang["message_body"]="Corpo";
$pgv_lang["no_to_user"]="Nenhum recipiente de usuário foi fornecido.  Impossível continuar.";
$pgv_lang["provide_email"]="Favor fornecer seu endereço de e-mail de forma que possamos responder sua mensagem.  Seu endereço de e-mail <b>não</b> será usado para outros fins a não ser para responder sua mensagem.";
$pgv_lang["reply"]="Responder";
$pgv_lang["message_deleted"]="Mensagem Excluida";
$pgv_lang["message_sent"]="Mensagem Enviada";
$pgv_lang["reset"]="Restaurar";
$pgv_lang["site_default"]="Padrão do Site";
$pgv_lang["mygedview_desc"]="A página <b>\"Meu Portal\"</b> permite que você faça 'Bookmarks' de suas pessoas favoritas, veja os próximos eventos e colabore com outros usuários.";
$pgv_lang["no_messages"]="Não há novas mensagens.";
$pgv_lang["clicking_ok"]="Clicando OK, será aberta uma outra janela onde você poderá contatar <br />#user[fullname]# ";
$pgv_lang["favorites"]="Favoritos";
$pgv_lang["my_favorites"]="Meus Favoritos";
$pgv_lang["no_favorites"]="Não há favoritos. Para adicionar uma pessoa ao <b>Meus Favoritos</b>, procure os detalhes da Pessoa que você deseja adicionar e clique em \"Adicione aos Meus Favoritos\" ou use a caixa abaixo para adicioná-lo pelo seu ID (ex: I21), ou informe uma URL e um título.";
$pgv_lang["add_to_my_favorites"]="Adicione aos Meus Favoritos";
$pgv_lang["gedcom_favorites"]="Favoritos do Site";
$pgv_lang["no_gedcom_favorites"]="Até este momento não existe nenhum Favorito selecionado.  O Administrador pode adicionar Favoritos que serão exibidos na inicialização.";
$pgv_lang["confirm_fav_remove"]="Tem certeza que deseja remover este item de Meus Favoritos?";
$pgv_lang["invalid_email"]="Por favor informe um e-mail válido.";
$pgv_lang["enter_subject"]="Por favor informe o Assunto da mensagem.";
$pgv_lang["enter_body"]="Por favor, informe algum texto antes de enviar.";
$pgv_lang["confirm_message_delete"]="Confirma a exclusão destas mensagens? Isto não poderá ser desfeito.";
$pgv_lang["message_email1"]="Esta mensagem foi enviada por ";
$pgv_lang["message_email2"]="Mensagem enviada para:";
$pgv_lang["message_email3"]="Mensagem enviada para o Administrador:";
$pgv_lang["viewing_url"]="Esta mensagem foi enviada quando navegava pelo seguinte endereço: ";
$pgv_lang["messaging2_help"]="Após confirmar o envio da mensagem, uma cópia será enviada para seu e-mail.";
$pgv_lang["random_picture"]="Imagem Aleatória";
$pgv_lang["message_instructions"]="<b>Importante:</b> Informações privadas de pessoas vivas somente serão fornecidas aos parentes e amigos próximos.  Será solicitado confirmação de seu parentesco antes de você receber qualquer dado privado.  Ocasionalmente informações de pessoas já falecidas podem ser privadas.  Se esse for o caso, é porquê não há informação suficiente a respeito da pessoa que permita determinar se a mesma está viva ou não e nós provavelmente não temos mais informações sobre essa pessoa.<br /><br />Antecipadamente, por favor, verifique se o que está pesquisando sobre a pessoa está correto, verificando datas, locais e parentesco.  Se você está enviando alterações sobre dados de genealogia, por favor informe as fontes de onde obteve os dados.<br /><br />";
$pgv_lang["sending_to"]="Esta mensagem será enviada para #TO_USER#";
$pgv_lang["preferred_lang"]="Este usuário prefere receber mensagens em #USERLANG#";
$pgv_lang["gedcom_created_using"]="Este arquivo GEDCOM foi criado usando <b>#SOFTWARE# #VERSION#</b>.";
$pgv_lang["gedcom_created_on"]="Este arquivo GEDCOM foi criado em <b>#DATE#</b>.";
$pgv_lang["gedcom_created_on2"]=" em <b>#DATE#</b>";
$pgv_lang["gedcom_stats"]="Dados Estatísticos";
$pgv_lang["stat_individuals"]="Pessoas";
$pgv_lang["stat_families"]="Famílias";
$pgv_lang["stat_sources"]="Fontes";
$pgv_lang["stat_other"]="Outros registros";
$pgv_lang["stat_earliest_birth"]="Pessoa Mais Antiga";
$pgv_lang["stat_latest_birth"]="Pessoa Mais Nova";
$pgv_lang["stat_earliest_death"]="Primeiro Falecimento";
$pgv_lang["stat_latest_death"]="Último Falecimento";
$pgv_lang["customize_page"]="Configurar Meu Portal";
$pgv_lang["customize_gedcom_page"]="Configurar esta Página Inicial";
$pgv_lang["upcoming_events_block"]="Próximos Eventos";
$pgv_lang["upcoming_events_descr"]="o bloco 'Próximos Eventos' exibe uma lista dos eventos deste banco de dados que ocorrerão dentro dos próximos 30 dias.  Em <b>Meu Portal</b> o bloco somente exibirá a lista das pessoas vivas.  Na <b>Página Inicial</b> exibirá a lista de todas as pessoas.";
$pgv_lang["todays_events_block"]="Este dia em nossa História";
$pgv_lang["todays_events_descr"]="o bloco 'Este dia em nossa História' mostra uma lista de eventos deste banco de dados que ocorram hoje.  Se não for encontrado nenhum evento, este bloco não será exibido.  Em <b>Meu Portal</b> o bloco somente exibirá a lista das pessoas vivas.  Na <b>Página Inicial</b> exibirá a lista de todas as pessoas.";
$pgv_lang["logged_in_users_block"]="Usuários Conectados";
$pgv_lang["logged_in_users_descr"]="O bloco 'Usuários Conectados' exibe a lista dos usuários que estão conectados.";
$pgv_lang["user_messages_block"]="Minhas Mensagens";
$pgv_lang["user_messages_descr"]="O bloco 'Minhas Mensagens' exibe a lista das mensagens que foram enviadas ao usuário.";
$pgv_lang["user_favorites_block"]="Meus Favoritos";
$pgv_lang["user_favorites_descr"]="O bloco 'Meus Favoritos' exibe a lista de favoritos do usuário no sistema. Isto permite um fácil acesso aos mesmos.";
$pgv_lang["welcome_block"]="Bem-Vindo - Usuário";
$pgv_lang["welcome_descr"]="O bloco 'Bem-Vindo - Usuário' exibe o nome do usuário, data e hora corrente, bem como links que permitem acessar rapidamente a sua conta, seus dados, sua árvore genealógica e link para customizar a página <b>Meu Portal<b/>.";
$pgv_lang["random_media_block"]="Imagem Aleatória";
$pgv_lang["random_media_descr"]="O bloco 'Imagem Aleatória' exibe aleatoriamente uma foto ou outra mídia do banco de dados.";
$pgv_lang["random_media_persons_or_all"]="Exibir apenas pessoas, eventos ou tudo?";
$pgv_lang["random_media_persons"]="Pessoas";
$pgv_lang["random_media_events"]="Eventos";
$pgv_lang["gedcom_block"]="Bem-Vindo - Site";
$pgv_lang["gedcom_descr"]="O bloco 'Bem-Vindo - Site' funciona da mesma forma que o o bloco 'Bem-Vindo - Usuário'. Exibe o titulo do arquivo de genealogia, bem como a data e hora corrente.";
$pgv_lang["gedcom_favorites_block"]="Favoritos - Site";
$pgv_lang["gedcom_favorites_descr"]="O bloco 'Favoritos - Site' permite ao administrador a  capacidade de selecionar suas pessoas favoritas do banco de dados de forma que os visitantes possam facilmente encontrá-los. Esta é uma forma de evidenciar as pessoas que são importantes em sua história.";
$pgv_lang["gedcom_stats_block"]="Dados Estatísticos";
$pgv_lang["gedcom_stats_descr"]="O bloco 'Dados Estatísticos' exibe ao visitante algumas informações básicas sobre do banco de dados como por exemplo quando foi criado e quantas pessoas estão cadastradas no mesmo e sobrenomes mais comuns.";
$pgv_lang["gedcom_stats_show_surnames"]="Exibir Sobrenomes mais comuns?";
$pgv_lang["portal_config_intructions"]="Adapte a página <b>Meu Portal</b> posicionando os blocos na página da maneira que quiser. A página é dividida em duas seções: A seção  'Principal' e a seção 'Auxiliar'.  Os blocos da seção 'Principal' são mostrados em destaque e abaixo do título da página. A seção 'Auxiliar' ocupa o lado direito da página. Cada seção tem sua própria lista de blocos que serão mostrados na página na ordem que forem relacionados.  Você pode adicionar, remover e reordenar de acordo com sua preferência.";
$pgv_lang["login_block"]="Conectar";
$pgv_lang["login_descr"]="O bloco 'Conectar' solicita Nome e Senha para os usuários conectaram-se ao site.";
$pgv_lang["theme_select_block"]="Seleção de Temas";
$pgv_lang["theme_select_descr"]="O bloco Seleção de Temas permite selecionar outro tema para o site.";
$pgv_lang["block_top10_title"]="Sobrenomes mais Populares";
$pgv_lang["block_top10"]="Sobrenomes Populares";
$pgv_lang["block_top10_descr"]="Este bloco mostra uma tabela com os 10 sobrenomes mais populares do banco de dados.";
$pgv_lang["gedcom_news_block"]="Notícias";
$pgv_lang["gedcom_news_descr"]="O bloco 'Notícias' mostrará aos visitantes notícias ou artigos publicados pelo usuário Administrador.  'Notícias' é um bom local para anunciar alterações no banco de dados ou uma reunião familiar.";
$pgv_lang["gedcom_news_limit"]="Limitar a exibição por:";
$pgv_lang["gedcom_news_limit_nolimit"]="Sem Limite";
$pgv_lang["gedcom_news_limit_date"]="Idade do Item";
$pgv_lang["gedcom_news_limit_count"]="Qtde de Itens";
$pgv_lang["gedcom_news_flag"]="Limite";
$pgv_lang["gedcom_news_archive"]="Exibir arquivo";
$pgv_lang["user_news_block"]="Minhas Notícias";
$pgv_lang["user_news_descr"]="O bloco 'Meu Jornal' permite ao usuário a manutenção de notícias ou um Jornal on-line.";
$pgv_lang["my_journal"]="Meu Diário";
$pgv_lang["no_journal"]="Diário vazio.";
$pgv_lang["confirm_journal_delete"]="Confirma a exclusão desta informação do Diário?";
$pgv_lang["add_journal"]="Adicionar informação ao Diário";
$pgv_lang["gedcom_news"]="Notícias";
$pgv_lang["confirm_news_delete"]="Conforma exclusão desta Notícia?";
$pgv_lang["add_news"]="Adicionar Notícia";
$pgv_lang["no_news"]="Não há novos artigos.";
$pgv_lang["edit_news"]="Adicionar/Editar Notícias ou Diário";
$pgv_lang["enter_title"]="Favor informar um título.";
$pgv_lang["enter_text"]="Digite um texto para essa Notícia ou Diário.";
$pgv_lang["news_saved"]="Notícia/Jornal salvo com sucesso.";
$pgv_lang["article_text"]="Texto";
$pgv_lang["main_section"]="Blocos da seção Principal";
$pgv_lang["right_section"]="Blocos da seção Auxiliar";
$pgv_lang["available_blocks"]="Blocos Disponíveis";
$pgv_lang["move_up"]="Subir";
$pgv_lang["move_down"]="Baixar";
$pgv_lang["move_right"]="Mover para Direita";
$pgv_lang["move_left"]="Mover para Esquerda";
$pgv_lang["broadcast_all"]="Enviar para todos os usuários";
$pgv_lang["hit_count"]="Nº de Visitas:";
$pgv_lang["phpgedview_message"]="Mensagem PhpGedView";
$pgv_lang["common_surnames"]="Sobrenomes Mais Comuns";
$pgv_lang["default_news_title"]="Bem-vindo à sua Árvore Genealógica ";
$pgv_lang["default_news_text"]="As informações de genealogia deste website são produzidas  por <a href=\"http://www.phpgedview.net/\" target=\"_blank\">PhpGedView</a>.  Esta página fornece uma introdução e visão geral desta genealogia.<br /><br />Para explorar as informações do site você pode escolher um dos gráficos a partir do menu de <b>Gráficos</b>, mostrar <b>Listas</b> de pessoas, famílias, locais, mídias ou também <b>Pesquisar</b> um nome ou local.<br /><br />Se tiver dúvida ao usar o site, clicando no menu de <b>Ajuda</b> você receberá informações de como usar a página que está sendo visualizada no momento.<br /><br />Obrigado por visitar este site !!!";
$pgv_lang["reset_default_blocks"]="Restaurar padrão de Blocos";
$pgv_lang["recent_changes"]="Últimas Atualizações";
$pgv_lang["recent_changes_block"]="Últimas Atualizações";
$pgv_lang["recent_changes_descr"]="O bloco 'Últimas Alterações' mostrará uma lista das últimas atualizações que foram efetuadas no banco de dados no último mês.  Este bloco pode ajudá-lo a ficar em dia com as mudanças do site.  As mudanças se baseiam na expressão CHAN.";
$pgv_lang["recent_changes_none"]="<b>Não há alterações a pelo menos #pgv_lang[global_num1]# dias.</b><br />";
$pgv_lang["recent_changes_some"]="<b>Alterações feitas nos últimos #pgv_lang[global_num1]# dias</b><br />";
$pgv_lang["show_empty_block"]="Este bloco não deverá ser exibido se estiver vazio?";
$pgv_lang["hide_block_warn"]="Se um bloco não é exibido quando está vazio, então ele só poderá ser configurado se não estiver vazio.";
$pgv_lang["delete_selected_messages"]="Excluir Mensagens Selecionadas";
$pgv_lang["use_blocks_for_default"]="Usar esses blocos como padrão de configuração para todos os usuários?";
$pgv_lang["block_not_configure"]="Este bloco não pode ser configurado.";
$pgv_lang["changed_mac"]="Detectado 'Macintosh line endings'. Todos os registros terminados apenas por CR foram alterados para CR/LF.";
$pgv_lang["changed_places"]="Detectado codificação inválida de Local. Registro de Locais foram adequados às especificações do GEDCOM 5.5.  Um exemplo de seu GEDCOM é:";
$pgv_lang["optional_tools"]="As ferramentas a seguir podem ser usadas opcionalmente antes da importação.";
$pgv_lang["optional"]="Ferramentas Opcionais";
$pgv_lang["add_media_tool"]="Ferramenta para adicionar Mídia";
$pgv_lang["launch_media_tool"]="Clique aqui para executar Ferramenta Adicionar Mídia.";
$pgv_lang["add_media_descr"]="Esta ferramenta adicionará 'OBJE tags' ao GEDCOM. Adicione todas as Mídias e então feche esta janela.";
$pgv_lang["extension"]="Extensão";
$pgv_lang["order"]="Ordem";
$pgv_lang["inject_media_tool"]="Adicionar Mídia ao arquivo GEDCOM";
$pgv_lang["media_table_created"]="Criada tabela de <i>mídia</i>.";
$pgv_lang["click_to_add_media"]="Clique aqui para Adicionar Mídia informada acima ao GEDCOM #GEDCOM#";
$pgv_lang["adds_completed"]="Mídia adiconada com sucesso ao arquivo GEDCOM.";
$pgv_lang["import_options_help"]="Você pode selecionar outras opções a serem usadas durante a importação do GEDCOM.";
$pgv_lang["verify_gedcom_help"]="Neste momento você pode continuar ou cancelar o envio e importação deste GEDCOM.";
$pgv_lang["hourglass_chart"]="Ampulheta";
$pgv_lang["choose_report"]="Escolha o Relatório a executar";
$pgv_lang["enter_report_values"]="Informe os dados do Relatório";
$pgv_lang["selected_report"]="Relatório selecionado";
$pgv_lang["run_report"]="Exibir Relatório";
$pgv_lang["select_report"]="Selecione Relatório";
$pgv_lang["download_report"]="Salvar Relatório";
$pgv_lang["reports"]="Relatórios";
$pgv_lang["pdf_reports"]="Relatórios PDF";
$pgv_lang["html_reports"]="Relatórios HTML";
$pgv_lang["ahnentafel_report"]="Relatório Ahnentafel";
$pgv_lang["ahnentafel_header"]="Relatório Ahnentafel de ";
$pgv_lang["ahnentafel_generation"]="Geração";
$pgv_lang["ahnentafel_pronoun_m"]="Ele ";
$pgv_lang["ahnentafel_pronoun_f"]="Ela ";
$pgv_lang["ahnentafel_born_m"]="nasceu";
$pgv_lang["ahnentafel_born_f"]="nasceu";
$pgv_lang["ahnentafel_christened_m"]="foi critianizado";
$pgv_lang["ahnentafel_christened_f"]="foi cristianizada";
$pgv_lang["ahnentafel_married_m"]="casou";
$pgv_lang["ahnentafel_married_f"]="casou";
$pgv_lang["ahnentafel_died_m"]="faleceu";
$pgv_lang["ahnentafel_died_f"]="faleceu";
$pgv_lang["ahnentafel_buried_m"]="foi sepultado";
$pgv_lang["ahnentafel_buried_f"]="foi sepultada";
$pgv_lang["ahnentafel_place"]=" em ";
$pgv_lang["ahnentafel_no_details"]=" porém os detalhes são desconhecidos";
$pgv_lang["family_group_report"]="Relatório de Grupo Familiar";
$pgv_lang["page"]="Página";
$pgv_lang["of"]="de";
$pgv_lang["enter_famid"]="Informe ID da Família";
$pgv_lang["show_sources"]="Exibir fontes?";
$pgv_lang["show_notes"]="Exibir notas?";
$pgv_lang["show_basic"]="Imprimir eventos básicos mesmo em branco?";
$pgv_lang["show_photos"]="Exibir fotos?";
$pgv_lang["relatives_report_ext"]="Relatório de Parentes (expandido)";
$pgv_lang["with"]="com";
$pgv_lang["on"]="em";
$pgv_lang["in"]="em";
$pgv_lang["individual_report"]="Relatório de Pessoa";
$pgv_lang["enter_pid"]="Informe ID da Pessoa";
$pgv_lang["individual_list_report"]="Individual List Report";
$pgv_lang["generated_by"]="Gerado por";
$pgv_lang["list_children"]="Lista em ordem de nascimento.";
$pgv_lang["birth_report"]="Relatório Data e Local de Nascimento";
$pgv_lang["birthplace"]="Local de Nascimento contendo";
$pgv_lang["birthdate1"]="Data de Nascimento inicial";
$pgv_lang["birthdate2"]="Data de Nascimento final";
$pgv_lang["death_report"]="Relatório de Data de Falecimento e Lugar";
$pgv_lang["deathplace"]="Lugar do Falecimento contendo";
$pgv_lang["deathdate1"]="Data do Falecimento Inicial";
$pgv_lang["deathdate2"]="Data do Falecimento Final";
$pgv_lang["marr_report"]="Relatório de Data de Casamento e Lugar";
$pgv_lang["marrplace"]="Lugar do Casamento contendo";
$pgv_lang["marrdate1"]="Data de Casamento Inicial";
$pgv_lang["marrdate2"]="Data de Casamento Final";
$pgv_lang["sort_by"]="Classificado por";
$pgv_lang["cleanup"]="Limpar";
$pgv_lang["dynasty_list"]="Lista dos Patriarcas";
$pgv_lang["make_slklist"]="Criar lista EXCEL (SLK)";
$pgv_lang["excel_list"]="Os arquivos abaixo serão criados no formato EXCEL (SLK) (primeiro use a Lista dos Patriarcas):";
$pgv_lang["excel_tab"]="ficha:";
$pgv_lang["excel_create"]=" será criado no seguinte arquivo:";
$pgv_lang["patriarch_list"]="Patriarcas";
$pgv_lang["slk_list"]="Lista EXCEL SLK";
$pgv_lang["statistics"]="Estatísticas";
$pgv_lang["merge_same"]="Registros não são do mesmo tipo.  Não é possível consolidar registros que não sejam do mesmo tipo.";
$pgv_lang["merge_step1"]="Consolidação Passo 1 de 3";
$pgv_lang["merge_step2"]="Consolidação Passo 2 de 3";
$pgv_lang["merge_step3"]="Consolidação Passo 3 de 3";
$pgv_lang["select_gedcom_records"]="Selecionar 2 registros GEDCOM para consolidação.  Registros devem ser do mesmo tipo.";
$pgv_lang["merge_to"]="Consolidar para ID:";
$pgv_lang["merge_from"]="Consolidar de ID:";
$pgv_lang["merge_facts_same"]="Os fatos seguintes são exatamente os mesmos em ambos registros e serão automaticamente consolidados";
$pgv_lang["no_matches_found"]="Não encontrada nenhuma combinação de fatos";
$pgv_lang["unmatching_facts"]="Os seguintes fatos são conflitantes. Selecione qual deles deve ser mantido.";
$pgv_lang["record"]="Registro";
$pgv_lang["adding"]="Adicionando";
$pgv_lang["updating_linked"]="Atualizando registro combinado";
$pgv_lang["merge_more"]="Consolidar mais registros.";
$pgv_lang["same_ids"]="Você informou os mesmos IDs. Consolidação funciona somente com IDs diferentes.";
$pgv_lang["ancestry_chart"]="Ancestrais";
$pgv_lang["gen_ancestry_chart"]="#PEDIGREE_GENERATIONS# Gerações de Ancestrais";
$pgv_lang["chart_style"]="Tipo de gráfico";
$pgv_lang["chart_list"]="Estilo Lista";
$pgv_lang["chart_booklet"]="Estilo Livreto";
$pgv_lang["show_cousins"]="Exibir Primos";
$pgv_lang["sosa_2"]="Pai";
$pgv_lang["sosa_3"]="Mãe";
$pgv_lang["sosa_4"]="Avô";
$pgv_lang["sosa_5"]="Avó";
$pgv_lang["sosa_6"]="Avô";
$pgv_lang["sosa_7"]="Avó";
$pgv_lang["sosa_8"]="Bisavô";
$pgv_lang["sosa_9"]="Bisavó";
$pgv_lang["sosa_10"]="Bisavô";
$pgv_lang["sosa_11"]="Bisavó";
$pgv_lang["sosa_12"]="Bisavô";
$pgv_lang["sosa_13"]="Bisavó";
$pgv_lang["sosa_14"]="Bisavô";
$pgv_lang["sosa_15"]="Bisavó";
$pgv_lang["sosa_16"]="Trisavô";
$pgv_lang["sosa_17"]="Trisavó";
$pgv_lang["sosa_18"]="Trisavô";
$pgv_lang["sosa_19"]="Trisavó";
$pgv_lang["sosa_20"]="Trisavô";
$pgv_lang["sosa_21"]="Trisavó";
$pgv_lang["sosa_22"]="Trisavô";
$pgv_lang["sosa_23"]="Trisavó";
$pgv_lang["sosa_24"]="Trisavô";
$pgv_lang["sosa_25"]="Trisavó";
$pgv_lang["sosa_26"]="Trisavô";
$pgv_lang["sosa_27"]="Trisavó";
$pgv_lang["sosa_28"]="Trisavô";
$pgv_lang["sosa_29"]="Trisavó";
$pgv_lang["sosa_30"]="Trisavô";
$pgv_lang["sosa_31"]="Trisavó";
$pgv_lang["sosa_32"]="Tataravó";
$pgv_lang["sosa_33"]="Tataravô";
$pgv_lang["sosa_34"]="Tataravó";
$pgv_lang["sosa_35"]="Tataravô";
$pgv_lang["sosa_36"]="Tataravó";
$pgv_lang["sosa_37"]="Tataravô";
$pgv_lang["sosa_38"]="Tataravó";
$pgv_lang["sosa_39"]="Tataravô";
$pgv_lang["sosa_40"]="Tataravó";
$pgv_lang["sosa_41"]="Tataravô";
$pgv_lang["sosa_42"]="Tataravó";
$pgv_lang["sosa_43"]="Tataravô";
$pgv_lang["sosa_44"]="Tataravó";
$pgv_lang["sosa_45"]="Tataravô";
$pgv_lang["sosa_46"]="Tataravó";
$pgv_lang["sosa_47"]="Tataravô";
$pgv_lang["sosa_48"]="Tataravó";
$pgv_lang["sosa_49"]="Tataravô";
$pgv_lang["sosa_50"]="Tataravó";
$pgv_lang["sosa_51"]="Tataravô";
$pgv_lang["sosa_52"]="Tataravó";
$pgv_lang["sosa_53"]="Tataravô";
$pgv_lang["sosa_54"]="Tataravó";
$pgv_lang["sosa_55"]="Tataravô";
$pgv_lang["sosa_56"]="Tataravó";
$pgv_lang["sosa_57"]="Tataravô";
$pgv_lang["sosa_58"]="Tataravó";
$pgv_lang["sosa_59"]="Tataravô";
$pgv_lang["sosa_60"]="Tataravó";
$pgv_lang["sosa_61"]="Tataravô";
$pgv_lang["sosa_62"]="Tataravó";
$pgv_lang["sosa_63"]="Tataravô";
$pgv_lang["compact_chart"]="Gráfico Resumo";
$pgv_lang["fan_chart"]="Ancestrais em Leque";
$pgv_lang["gen_fan_chart"]="Exibir até #PEDIGREE_GENERATIONS# gerações no gráfico";
$pgv_lang["fan_width"]="Largura";
$pgv_lang["gd_library"]="Servidor PHP desconfigurado: Biblioteca GD requirida para uso de funções de imagem.";
$pgv_lang["gd_freetype"]="Servidor PHP desconfigurado: Biblioteca Freetype requirida para fontes TrueType.";
$pgv_lang["gd_helplink"]="http://www.php.net/gd";
$pgv_lang["fontfile_error"]="Arquivo de Fonte não encontrada no servidor PHP";
$pgv_lang["fanchart_IE"]="A imagem do gráfico em Leque não pode ser impressa por seu navegador. Clique com o botão direito do mouse para salva-lo em seu computador e em seguida imprima-o.";
$pgv_lang["rss_descr"]="Notícias e links do site #GEDCOM_TITLE#";
$pgv_lang["rss_logo_descr"]="Feed criado por PhpGedView";
$pgv_lang["no_feed"]				= "Não há RSS disponível para este site PhpGedView";
$pgv_lang["no_feed_title"]			= "Alimentador indisponível";
$pgv_lang["rss_feeds"]="Alimentação da RSS";
$pgv_lang["feed_login"]="Caso tenha uma conta para este site <a href=\"#AUTH_URL#\">identifique-se</a> usando a Autenticação Básica do HTTP e acesse as informações restritas.";
$pgv_lang["attendant"]="Atendente";
$pgv_lang["attending"]="Atendendo";
$pgv_lang["best_man"]="Padrinho";
$pgv_lang["bridesmaid"]="Dama de Honra";
$pgv_lang["buyer"]="Comprador";
$pgv_lang["circumciser"]="Circuncisador";
$pgv_lang["civil_registrar"]="Registro Civil";
$pgv_lang["friend"]="Amigo";
$pgv_lang["godfather"]="Padrinho";
$pgv_lang["godmother"]="Madrinha";
$pgv_lang["godparent"]="Padrinhos";
$pgv_lang["informant"]="Informante";
$pgv_lang["lodger"]="Inquilino";
$pgv_lang["nurse"]="Ama-Seca";
$pgv_lang["priest"]="Padre";
$pgv_lang["rabbi"]="Rabino";
$pgv_lang["registry_officer"]="Agente de Registro";
$pgv_lang["seller"]="Vendedor";
$pgv_lang["servant"]="Empregado";
$pgv_lang["twin"]="Gêmeo";
$pgv_lang["twin_brother"]="Irmão gêmeo";
$pgv_lang["twin_sister"]="Irmã gêmea";
$pgv_lang["witness"]="Testemunha";
$pgv_lang["statutci"]="não foi possível criar o índice";
$pgv_lang["statnnames"]="qtde de nomes =";
$pgv_lang["statnfam"]="qtde de famílias =";
$pgv_lang["statnmale"]="pessoas masculinas =";
$pgv_lang["statnfemale"]="pessoas femininas =";
$pgv_lang["statvars"]="Preencha as seguintes variáveis para o gráfico";
$pgv_lang["statlxa"]="ao longo do eixo-x:";
$pgv_lang["statlya"]="ao longo do eixo-y";
$pgv_lang["statlza"]="ao longo do eixo-z";
$pgv_lang["stat_10_none"]="nenhum";
$pgv_lang["stat_11_mb"]="Mês do nascimento";
$pgv_lang["stat_12_md"]="Mês do falecimento";
$pgv_lang["stat_13_mm"]="Mês do casamento";
$pgv_lang["stat_14_mb1"]="Mês do nascimento do 1ro filho do casal";
$pgv_lang["stat_15_mm1"]="Mês do 1ro casamento";
$pgv_lang["stat_16_mmb"]="Mêses do casamento ao nascimento do 1ro filho.";
$pgv_lang["stat_17_arb"]="idade em relação ao ano do nascimento.";
$pgv_lang["stat_18_ard"]="idade em relação ao ano do falecimento.";
$pgv_lang["stat_19_arm"]="idade quando casou.";
$pgv_lang["stat_20_arm1"]="idade no 1ro casamento.";
$pgv_lang["stat_21_nok"]="qtde de filhos.";
$pgv_lang["stat_gmx"]="verifique os valores do gráfico para o mês";
$pgv_lang["stat_gax"]=" indique a marca dos valores para idades";
$pgv_lang["stat_gnx"]=" indique marca de valores para números";
$pgv_lang["stat_200_none"]="todos (ou em branco)";
$pgv_lang["stat_201_num"]="números";
$pgv_lang["stat_202_perc"]="percentual";
$pgv_lang["stat_300_none"]="nenhum";
$pgv_lang["stat_301_mf"]="masculino/feminino";
$pgv_lang["stat_302_cgp"]="períodos. Indique marca de valores para períodos do eixo-z";
$pgv_lang["statmess1"]="<b>Preencha as próximas linhas baseando-se nas suas definições anteriores para os eixo-x e eixo-z</b>";
$pgv_lang["statar_xgp"]="marca de valores para períodos (eixo-x):";
$pgv_lang["statar_xgl"]="marca de valores para idades (eixo-x):";
$pgv_lang["statar_xgm"]="marca de valores para mês (eixo-x):";
$pgv_lang["statar_xga"]="marca de valores para números (eixo-x):";
$pgv_lang["statar_zgp"]="marca de valores para períodos (eixo-z):";
$pgv_lang["statreset"]="desfazer";
$pgv_lang["statsubmit"]="Exibir a plotagem";
$pgv_lang["statistiek_list"]="Grafico das Estatísticas";
$pgv_lang["stpl"]="...";
$pgv_lang["stplGDno"]="Biblioteca Gráfica de Visualização não está disponível para PHP 4. Fale com o Administrador de seu sistema";
$pgv_lang["stpljpgraphno"]="Os módulos JPgraph não estão disponíveis na pasta <i>phpgedview/jpgraph/</i> . Consiga-os em http://www.aditus.nu/jpgraph/jpdownload.php<br /> e <h3>Instale o JPgraph na pasta <i>phpgedview/jpgraph/</i></h3><br />";
$pgv_lang["stplinfo"]="informação para plotagem";
$pgv_lang["stpltype"]="tipo:";
$pgv_lang["stplnoim"]=" não implementado:";
$pgv_lang["stplmf"]=" / homem-mulher";
$pgv_lang["stplipot"]=" / por período de tempo";
$pgv_lang["stplgzas"]="bordas do eixo-z:";
$pgv_lang["stplmonth"]="mês";
$pgv_lang["stplnumbers"]="números de uma família";
$pgv_lang["stplage"]="idade";
$pgv_lang["stplperc"]="percentual";
$pgv_lang["stplnumof"]="Quantidade";
$pgv_lang["stplmarrbirth"]="Meses do casamento ao nascimento do 1ro filho";
$pgv_lang["alive_in_year"]="Pessoas Vivas";
$pgv_lang["is_alive_in"]="Vivo em #YEAR#";
$pgv_lang["alive"]="Vivo";
$pgv_lang["dead"]="Falecido";
$pgv_lang["maybe"]="Talvez";
$pgv_lang["definitions"]="Definições";
$pgv_lang["description"]="Descrição";
$pgv_lang["block_desc"]="Descrição dos Blocos";
$pgv_lang["click_here"]="Clique aqui para continuar";
$pgv_lang["click_here_help"]="~#pgv_lang[click_here]#~<br /><br />Clique neste botão para salvar as alterações.<br /><br />Ao retornar para a página #pgv_lang[welcome]# ou para #pgv_lang[mygedview]#, caso não veja suas alterações, clique no botão Atualizar de seu Navegador (Browser).";
$pgv_lang["block_summaries"]="~#pgv_lang[block_desc]#~<br /><br />Descrição sucinta de cada bloco que você pode colocar em #pgv_lang[welcome]# ou na página #pgv_lang[mygedview]#.<br /><table border='1' align='center'><tr><td class='list_value'><b>#pgv_lang[name]#</b></td><td class='list_value'><b>#pgv_lang[description]#</b></td></tr>#pgv_lang[block_summary_table]#</table><br /><br />";
$pgv_lang["block_summary_table"]="&nbsp;";
$pgv_lang["total_places"]="Lugares encontrados";
$pgv_lang["media_contains"]="Mídia contém:";
$pgv_lang["repo_contains"]="Reposição contém:";
$pgv_lang["source_contains"]="Fonte contém:";
$pgv_lang["display_all"]="Exibir tudo";
$pgv_lang["add_faq_header"]="Cabeçalho da FAQ";
$pgv_lang["add_faq_body"]="Corpo da FAQ";
$pgv_lang["add_faq_order"]="Posição da FAQ";
$pgv_lang["no_faq_items"]="A lista de FAQ está vazia!";
$pgv_lang["position_item"]="Posição do item";
$pgv_lang["faq_list"]="Lista de FAQs";
$pgv_lang["confirm_faq_delete"]="Confirma exclusão desta FAQ?";
$pgv_lang["preview"]="Prévia";
$pgv_lang["no_id"]="Informe a ID da FAQ!";
$pgv_lang["hs_title"]="Procurar texto de Ajuda";
$pgv_lang["hs_search"]="Pesquisa";
$pgv_lang["hs_close"]="Fechar a janela";
$pgv_lang["hs_results"]="Resultados encontrados:";
$pgv_lang["hs_keyword"]="Pesquisar por";
$pgv_lang["hs_searchin"]="Pesquisar em";
$pgv_lang["hs_searchuser"]="Ajuda do Usuário";
$pgv_lang["hs_searchconfig"]="Ajuda do Administrador";
$pgv_lang["hs_searchhow"]="Tipo de pesquisa";
$pgv_lang["hs_searchall"]="Todas as palavras";
$pgv_lang["hs_searchany"]="Qualquer palavra";
$pgv_lang["hs_searchsentence"]="Frase exata";
$pgv_lang["hs_intruehelp"]="Somente texto de ajuda";
$pgv_lang["hs_inallhelp"]="Texto completo";
$pgv_lang["media_import"]="Importar e converter a mídia";
$pgv_lang["choose"]="Escolha:";
$pgv_lang["account_information"]="Informação da Conta";
$pgv_lang["TYPE__audio"]="Áudio";
$pgv_lang["TYPE__book"]="Livro";
$pgv_lang["TYPE__card"]="Cartão";
$pgv_lang["TYPE__certificate"]="Certificado";
$pgv_lang["TYPE__document"]="Documento";
$pgv_lang["TYPE__electronic"]="Eletrônico";
$pgv_lang["TYPE__fiche"]="Microficha";
$pgv_lang["TYPE__film"]="Microfilme";
$pgv_lang["TYPE__magazine"]="Revista";
$pgv_lang["TYPE__manuscript"]="Manuscrito";
$pgv_lang["TYPE__map"]="Mapa";
$pgv_lang["TYPE__newspaper"]="Jornal";
$pgv_lang["TYPE__photo"]="Foto";
$pgv_lang["TYPE__tombstone"]="Lápide";
$pgv_lang["TYPE__video"]="Vídeo";
$pgv_lang["add_individual_by_id"]		= "Adicionar pessoa pelo ID";
$pgv_lang["advanced_options"]		= "Opções avançadas";
$pgv_lang["zip_files"]				= "Arquivo(s) Compactado(s)";
$pgv_lang["include_media"]			= "Incluir mídia (compacta automaticamente)";
?>
