<?php
/**
 * Indonesian texts
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2009  PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 * @author PGV Developers
 * @translator alfarq
 * @package PhpGedView
 * @subpackage Languages
 * @version $Id: lang.id.php 6995 2010-11-29 02:41:44Z okbigkid $
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

$pgv_lang["exact"]				= "Tepat";
$pgv_lang["advanced_search"] 			= "Pencarian Mahir";
$pgv_lang["more_fields"]			= "Tambah Field Lagi";
$pgv_lang["install_step_8"] 			= "Mulai saja";
$pgv_lang["parent_family"]			= "Rumah Tangga Orangtua";
$pgv_lang["step_parent_family"]			= "Rumah Tangga Orangtua Angkat";
$pgv_lang["immediate_family"]			= "Rumah Tangga";

$pgv_lang["load_full_tree"]			= "Tampilkan silsilah ini dalam silsilah interaktif halaman penuh";
$pgv_lang["hide_show_spouses"]			= "Munculkan atau sembunyikan banyak pasangan";
$pgv_lang["interactive_tree"]			= "Silsilah Interaktif";
$pgv_lang["example"]				= "Contoh:";
$pgv_lang["tree"]				= "Silsilah";
$pgv_lang["ellipsis"]				= "\xE2\x80\xA6";
$pgv_lang["showUnknown"]			= "Munculkan jender yang tidak diketahui";
$pgv_lang["count"]				= "Jumlah";
$pgv_lang["age_differences"]			= "Munculkan Perbedaan Tanggal";
$pgv_lang["date_of_entry"]			= "Tanggal masukan pada sumber asli";
$pgv_lang["multi_site_search"] 			= "Pencarian Banyak Situs";
$pgv_lang["switch_lifespan"]			= "Munculkan Bagan Selang hidup";
$pgv_lang["switch_timeline"]			= "Munculkan Bagan Garis waktu";
$pgv_lang["differences"]			= "Perbedaan";
$pgv_lang["charts_block"]			= "Bagan blok";
$pgv_lang["charts_block_descr"]			= "Bagan blok memungkinkan Anda menempatkan bagan pada Halaman Sambutan atau portal MyGedView.  Anda dapat mengatur blok untuk menunjukkan leluhur, keturunan, atau tampilan gelas waktu.  Anda juga dapat memilih orang acuan untuk bagan tersebut.";
$pgv_lang["charts_click_box"]			= "Klik pada kotak manapun untuk memeroleh informasi lebih lanjut tentang orang tersebut.";
$pgv_lang["chart_type"]				= "Jenis Bagan";
$pgv_lang["changedate1"]			= "Selang akhir tanggal perubahan";
$pgv_lang["changedate2"]			= "Selang awal tanggal perubahan";
$pgv_lang["search_place_word"]			= "Hanya seluruh kata";
$pgv_lang["invalid_search_input"]		= "Silakan masukkan Nama depan, Nama belakang, atau Tempat sebagai tambahan Tahun";
$pgv_lang["duplicate_username"] 		= "Nama pengguna ganda. Pengguna dengan nama tersebut telah ada.  Silakan pilih nama pengguna yang lain.";
$pgv_lang["cache_life"]				= "Cache file life";
$pgv_lang["genealogy"]				= "Genealogi";
$pgv_lang["activate"]				= "Aktifkan";
$pgv_lang["deactivate"]				= "Nonaktifkan";
$pgv_lang["play"]				= "Maikan";
$pgv_lang["stop"]				= "Stop";
$pgv_lang["random_media_start_slide"]		= "Mulai slideshow pada pemuatan halaman?";
$pgv_lang["random_media_ajax_controls"]		= "Perlihatkan kontrol slideshow?";
$pgv_lang["description"]			= "Uraian";
$pgv_lang["current_dir"]			= "Direktori berlaku";
$pgv_lang["SHOW_ID_NUMBERS"]			= "Perlihatkan nomor ID setelah nama";
$pgv_lang["SHOW_HIGHLIGHT_IMAGES"]		= "Perlihatkan gambar highlight di kotak orang";
$pgv_lang["view_img_details"]			= "Tampilkan rincian gambar";
$pgv_lang["server_folder"]			= "Nama folder di server";
$pgv_lang["medialist_recursive"]		= "Daftar berkas di subdirektori";
$pgv_lang["media_options"]			= "Pilhan Media";
$pgv_lang["confirm_password"]			= "Anda harus mengonfirmasi sandi.";
$pgv_lang["enter_email"]			= "Anda harus memasukkan alamat email.";
$pgv_lang["enter_fullname"] 			= "Anda harus memasukkan nama depan dan belakang.";
$pgv_lang["name"]				= "Nama";
$pgv_lang["children"]				= "Anak";
$pgv_lang["child"]				= "Anak";
$pgv_lang["family"] 				= "Keluarga";
$pgv_lang["as_child"]				= "Keluarga dengan Orangtua";
$pgv_lang["source_menu"]			= "Pilihan untuk sumber";
$pgv_lang["repo_menu"]				= "Pilihan untuk repositori";
$pgv_lang["other_records"]			= "Rekaman yang terkait ke Sumber ini:";
$pgv_lang["other_repo_records"]			= "Rekaman yang terkait ke Repositori ini:";
$pgv_lang["repo_info"]				= "Informasi Repositori";
$pgv_lang["enter_terms"]			= "Masukkan frasa pencarian";
$pgv_lang["search_asso_label"]			= "Kerabat";
$pgv_lang["search_asso_text"]			= "Perlihatkan keluarga/orang yang berkerabat";
$pgv_lang["search_DM"]				= "Daitch-Mokotoff";
$pgv_lang["search_fams"]			= "Nama Keluarga";
$pgv_lang["search_gedcom"]			= "Cari basisdata";
$pgv_lang["search_geds"]			= "Basisdata untuk dicari";
$pgv_lang["search_indis"]			= "Nama Individu";
$pgv_lang["search_inrecs"]			= "Pencarian untuk";
$pgv_lang["search_prtall"]			= "Semua nama";
$pgv_lang["search_prthit"]			= "Nama dengan kunjungan";
$pgv_lang["results_per_page"]			= "Hasil tiap halaman";
$pgv_lang["firstname_search"]			= "Nama depan";
$pgv_lang["search_prtnames"]			= "Nama individu<br />untuk dicetak:";
$pgv_lang["other_searches"]			= "Pencarian Lain";
$pgv_lang["add_to_cart"]			= "Tambah ke Bagan Kliping";
$pgv_lang["view_gedcom"]			= "Tampilkan Rekaman GEDCOM";
$pgv_lang["welcome"]				= "Selamat Datang";
$pgv_lang["son"]				= "Putra";
$pgv_lang["daughter"]				= "Putri";
$pgv_lang["welcome_page"]			= "Halaman Sambutan";
$pgv_lang["editowndata"]			= "Akun Saya";
$pgv_lang["user_admin"] 			= "Administrasi Pengguna";
$pgv_lang["manage_media"]			= "Atur Media";
$pgv_lang["search_general"]			= "Pencarian umum";
$pgv_lang["clipping_privacy"]			= "Beberapa item tidak dapat ditambahkan sehubungan dengan pembatasan privasi";
$pgv_lang["chart_new"]				= "Bagan Silsilah Keluarga";
$pgv_lang["loading"]				= "Memuat...";
$pgv_lang["clear_chart"]			= "Bersihkan Bagan";
$pgv_lang["file_information"]			= "Informasi Berkas";
$pgv_lang["choose_file_type"]			= "Pilih Jenis Berkas";
$pgv_lang["add_individual_by_id"]		= "Tambah Individu Berdasarkan ID";
$pgv_lang["advanced_options"]			= "Pilihan Mahir";
$pgv_lang["zip_files"]				= "Berkas Zip";
$pgv_lang["include_media"]			= "Termasuk Media (otomatis mengezip berkas)";
$pgv_lang["roman_surn"]				= "Marga yang dilatinkan";
$pgv_lang["roman_givn"]				= "Nama depan yang dilatinkan";
$pgv_lang["include"]				= "Termasuk:";
$pgv_lang["page_x_of_y"]			= "Halaman #GLOBALS[currentPage]# dari #GLOBALS[lastPage]#";
$pgv_lang["options"]				= "Pilihan:";
$pgv_lang["config_update_ok"]			= "Konfigurasi berkas berhasil dimutakhirkan.";
$pgv_lang["page_size"]				= "Ukuran halaman";
$pgv_lang["record_not_found"]			= "Rekaman GEDCOM yang diminta tidak dapat ditemukan.  Hal ini dapat disebabkan oleh kaitan ke orang yang keliru atau berkas GEDCOM yang rusak.";
$pgv_lang["result_page"]			= "Halaman Hasil";
$pgv_lang["edit_media"]				= "Sunting Item Media";
$pgv_lang["wiki_main_page"]			= "Halaman Utama Wiki";
$pgv_lang["wiki_users_guide"]			= "Panduan Pengguna Wiki";
$pgv_lang["wiki_admin_guide"]			= "Panduan Administrator Wiki";
$pgv_lang["no_search_for"]			= "Pastikan untuk memilih opsi yang dicari.";
$pgv_lang["no_search_site"]			= "Pastikan untuk memilih setidaknya satu situs luar.";
$pgv_lang["search_sites"] 			= "Situs yang dicari";
$pgv_lang["site_list"]				= "Situs: ";
$pgv_lang["site_had"]				= " mengandung hal-hal berikut";
$pgv_lang["label_search_engine_detected"]	= "Mesin Pencari Laba-Laba Terdeteksi";

$pgv_lang["ex-spouse"]				= "Mantan Pasangan";
$pgv_lang["ex-wife"]				= "Mantan Istri";
$pgv_lang["ex-husband"]				= "Mantan Suami";
$pgv_lang["noemail"] 				= "Alamat tanpa email";
$pgv_lang["onlyemail"] 				= "Hanya alamat dengan email";
$pgv_lang["maxviews_exceeded"]			= "Jumlah tampilan halaman yang diizinkan #GLOBALS[MAX_VIEWS]# tiap #GLOBALS[MAX_VIEW_TIME]# detik terlampaui.";
$pgv_lang["broadcast_not_logged_6mo"]		= "Kirim pesan kepada para pengguna yang tidak masuk log selama 6 bulan";
$pgv_lang["broadcast_never_logged_in"]		= "Kirim pesan kepada para pengguna yang tidak pernah masuk log";
$pgv_lang["stats_to_show"]			= "Pilih status yang akan diperlihatkan pada blok ini";
$pgv_lang["stat_avg_age_at_death"]		= "Umur rata-rata saat meninggal";
$pgv_lang["stat_longest_life"]			= "Orang yang hidup terlama";
$pgv_lang["stat_most_children"]			= "Keluarga dengan anak terbanyak";
$pgv_lang["stat_average_children"]		= "Rata-rata anak tiap keluarga";
$pgv_lang["stat_events"]			= "Total peristiwa";
$pgv_lang["stat_media"]				= "Objek media";
$pgv_lang["stat_surnames"]			= "Total marga";
$pgv_lang["stat_users"]				= "Total pengguna";
$pgv_lang["no_family_facts"]			= "Tidak ada fakta untuk keluarga ini.";
$pgv_lang["stat_males"]				= "Total pria";
$pgv_lang["stat_females"]			= "Total wanita";
$pgv_lang["stat_unknown"]			= "Total tidak diketahui";

$pgv_lang["sunday_1st"]				= "Ah";
$pgv_lang["monday_1st"]				= "Sn";
$pgv_lang["tuesday_1st"]			= "Sl";
$pgv_lang["wednesday_1st"]			= "Rb";
$pgv_lang["thursday_1st"]			= "Km";
$pgv_lang["friday_1st"]				= "Jm";
$pgv_lang["saturday_1st"]			= "Sb";

$pgv_lang["jan_1st"]				= "Jan";
$pgv_lang["feb_1st"]				= "Feb";
$pgv_lang["mar_1st"]				= "Mar";
$pgv_lang["apr_1st"]				= "April";
$pgv_lang["may_1st"]				= "Mei";
$pgv_lang["jun_1st"]				= "Juni";
$pgv_lang["jul_1st"]				= "Juli";
$pgv_lang["aug_1st"]				= "Agust";
$pgv_lang["sep_1st"]				= "Sep";
$pgv_lang["oct_1st"]				= "Okt";
$pgv_lang["nov_1st"]				= "Nov";
$pgv_lang["dec_1st"]				= "Des";

$pgv_lang["edit_source"]			= "Sunting Sumber";
$pgv_lang["familybook_chart"]			= "Bagan Buku Keluarga";
$pgv_lang["family_of"]				= "Keluarga:&nbsp;";
$pgv_lang["descent_steps"]			= "Langkah Turun";

$pgv_lang["cancel"]				= "Batal";
$pgv_lang["cookie_help"]			= "Situs ini menggunakan cookies untuk melacak status catatanmasuk Anda.<br /><br />Cookies tampaknya tidak diaktifkan pada perambah Anda. Anda harus mengaktifkan cookies untuk situs ini sebelum Anda dapat masuk log.  Anda dapat melihat dokumentasi bantuan perambah Anda untuk informasi mengaktifkan cookies.";
//new stuff
//Individual
$pgv_lang["indi_is_remote"]			= "Informasi untuk individu ini dikaitkan dari situs luar.";
$pgv_lang["link_remote"]            		= "Kaitkan orang luar";
//Add Remote Link
$pgv_lang["title_search_link"]      		= "Tambah Pranala Lokal";
$pgv_lang["label_site_url2"]        		= "URL Situs";
//new stuff

$pgv_lang["delete_family_confirm"]		= "Menghapus keluarga akan melepas semua individu satu sama lain, namun akan meninggalkan individu di tempat.  Apakah Anda yakin ingin menghapus keluarga ini?";
$pgv_lang["delete_family"]			= "Hapus keluarga";
$pgv_lang["add_favorite"]			= "Tambah kesukaan baru";
$pgv_lang["url"]				= "URL";
$pgv_lang["add_fav_enter_note"]			= "Masukkan catatan pilihan tentang kesukaan ini";
$pgv_lang["add_fav_or_enter_url"]		= "ATAU<br />\nMasukkan URL dan judul";
$pgv_lang["add_fav_enter_id"]			= "Masukkan Orang, Keluarga, atau ID Sumber";
$pgv_lang["next_email_sent"]			= "Pengingat email berikutnya akan dikirim setelah ";
$pgv_lang["last_email_sent"]			= "Pengingat email terakhir telah terkirim ";
$pgv_lang["remove_child"]			= "Pindahkan anak ini dari keluarga";
$pgv_lang["link_new_husb"]			= "Tambah suami menggunakan orang yang ada";
$pgv_lang["link_new_wife"]			= "Tambah istri menggunakan orang yang ada";
$pgv_lang["address_labels"]			= "Label Alamat";
$pgv_lang["filter_address"]			= "Perlihatkan alamat yang mengandung:";
$pgv_lang["address_list"]			= "Daftar Alamat";
$pgv_lang["autocomplete"]			= "Autokomplit";
$pgv_lang["index_edit_advice"]			= "Highlight blok nama kemudian klik pada salah satu ikon panah untuk memindah blok terhighlight tersebut pada arah yang ditandakan.";
$pgv_lang["changelog"]				= "Perubahan Versi #VERSION#";
$pgv_lang["html_block_descr"]			= "Ini adalah blok HTML sederhana yang dapat Anda tempatkan pada halaman Anda untuk menambah pesan singkat apapun yang mungkin Anda inginkan.";
$pgv_lang["html_block_sample_part1"]		= "<p class=\"blockhc\"><b>Letakkan judul Anda di sini</b></p><br /><p>Klik tombol pengaturan";
$pgv_lang["html_block_sample_part2"]		= "untuk mengubah apa yang dicetak di sini.</p>";
$pgv_lang["html_block_name"]			= "HTML";
$pgv_lang["htmlplus_block_name"]		= "HTML Mahir";
$pgv_lang["htmlplus_block_descr"]		= "Ini adalah blok HTML yang dapat Anda letakkan pada halaman Anda untuk menambah pesan singkat apapun yang mungkin Anda inginkan.  Anda dapat menyisipkan rujukan ke informasi dari GEDCOM Anda ke teks HTML.";
$pgv_lang["htmlplus_block_templates"]		= "Templat";
$pgv_lang["htmlplus_block_content"]		= "Daftar Isi";
$pgv_lang["htmlplus_block_narrative"]		= "Gaya bercerita (Inggris saja)";
$pgv_lang["htmlplus_block_custom"]		= "Pilihan";
$pgv_lang["htmlplus_block_keyword"]		= "Contoh Katakunci (Inggris saja)";
$pgv_lang["htmlplus_block_taglist"]		= "Daftar Tag";
$pgv_lang["htmlplus_block_compat"]		= "Modus Kompatibilitas";
$pgv_lang["htmlplus_block_ui"]			= "Antarmuka Diperluas";
$pgv_lang["htmlplus_block_current"]		= "Berlaku";
$pgv_lang["htmlplus_block_default"]		= "Default";
$pgv_lang["htmlplus_block_gedcom"]		= "Silsilah Keluarga";
$pgv_lang["htmlplus_block_birth"]		= "lahir";
$pgv_lang["htmlplus_block_death"]		= "wafat";
$pgv_lang["htmlplus_block_marrage"]		= "nikah";
$pgv_lang["htmlplus_block_adoption"]		= "adopsi";
$pgv_lang["htmlplus_block_burial"]		= "pemakaman";
$pgv_lang["htmlplus_block_census"]		= "sensus ditambahkan";
$pgv_lang["num_to_show"]			= "Jumlah item yang dimunculkan";
$pgv_lang["days_to_show"]			= "Jumlah hari yang dimunculkan";
$pgv_lang["before_or_after"]			= "Letakkan hitungan sebelum atau sesudah nama?";
$pgv_lang["before"]				= "sebelum";
$pgv_lang["after"]				= "sesudah";
$pgv_lang["config_block"]			= "Pengaturan";
$pgv_lang["enter_comments"]			= "Silakan masukkan hubungan Anda ke data pada isian Komentar.";
$pgv_lang["comments"]				= "Komentar";
$pgv_lang["child-family"]			= "Orangtua dan saudara";
$pgv_lang["spouse-family"]			= "Pasangan dan anak-anak";
$pgv_lang["direct-ancestors"]			= "Leluhur langsung";
$pgv_lang["ancestors"]				= "Leluhur langsung dan keluarga mereka";
$pgv_lang["descendants"]			= "Keturunan";
$pgv_lang["choose_relatives"]			= "Pilih kerabat";
$pgv_lang["relatives_report"]			= "Laporan Kerabat";
$pgv_lang["total_unknown"]			= "Total orang yang tak diketahui";
$pgv_lang["total_living"]			= "Total orang yang hidup";
$pgv_lang["total_dead"]				= "Total orang yang wafat";
$pgv_lang["total_not_born"]			= "Total orang yang belum lahir";
$pgv_lang["remove_custom_tags"]			= "Ambil tag PGV pilihan? (eg. _PGVU, _THUM)";
$pgv_lang["cookie_login_help"]			= "Situs ini mengingat Anda dari catatanmasuk terdahulu.  Hal ini memungkinkan Anda untuk mengakses informasi pribadi dan fitur berdasar-pengguna yang lain, namun untuk menyunting atau mengatur situs, Anda harus masuk log lagi untuk meningkatkan keamanan.";
$pgv_lang["remember_me"]			= "Ingat Saya dari komputer ini?";
$pgv_lang["fams_with_surname"]			= "Keluarga dengan marga #surname#";
$pgv_lang["support_contact"]			= "Kontak bantuan teknis";
$pgv_lang["genealogy_contact"]			= "Kontak genealogi";
$pgv_lang["common_upload_errors"]		= "Kesalahan ini mungkin berarti bahwa berkas yang Anda coba ungguh melampaui batas yang ditetapkan oleh host Anda. Batas default pada PHP adalah 2MB. Anda dapat menghubungi Kelompok dukungan host Anda untuk meminta meningkatkan btas pada berkas php.ini, atau Anda dapat mengunggah berkas menggunakan FTP. Gunakan halaman <a href=\"uploadgedcom.php?action=add_form\"><b>Tambah GEDCOM</b></a> untuk menambah berkas GEDCOM yang telah Anda unggah menggunakan FTP.";
$pgv_lang["total_memory_usage"]			= "Penggunaan Memori Total:";
$pgv_lang["mothers_family_with"]		= "Keluarga Ibu dengan ";
$pgv_lang["fathers_family_with"]		= "Keluarga Ayah dengan ";
$pgv_lang["family_with"]			= "Keluarga dengan";
$pgv_lang["halfsibling"]			= "Saudara Seayah/ibu";
$pgv_lang["halfbrother"]			= "Saudara Seayah/ibu";
$pgv_lang["halfsister"]				= "Saudari Seayah/ibu";
$pgv_lang["family_timeline"]			= "Perlihatkan keluarga pada bagan gariswaktu";
$pgv_lang["children_timeline"]			= "Perlihatkan anak pada bagan gariswaktu";
$pgv_lang["other"]				= "Lainnya";
$pgv_lang["sort_by_marriage"]			= "Urutkan berdasarkan tanggal nikah";
$pgv_lang["reorder_families"]			= "Susun Keluarga";
$pgv_lang["indis_with_surname"]			= "Individu dengan marga/ayah #surname#";
$pgv_lang["first_letter_name"]			= "Pilih huruf untuk menunjukkan keluarga yang namanya bermula dengan huruf tersebut.";
$pgv_lang["first_letter_iname"]			= "Pilih huruf untuk menunjukkan individu yang nama keluarganya bermula dengan huruf tersebut.";
$pgv_lang["first_letter_fname"]			= "Pilih huruf untuk menunjukkan individu yang nama pertamanya bermula dengan huruf tersebut.";
$pgv_lang["total_names"]			= "Total Nama";
$pgv_lang["top10_pageviews_nohits"]		= "Saat ini tidak ada kunjungan untuk diperlihatkan.";
$pgv_lang["top10_pageviews_msg"]		= "Penghitung kunjungan harus diaktifkan pada pengaturan GEDCOM, bagian Tampilan dan Layout, kelompok Sembunyikan dan Perlihatkan.";
$pgv_lang["review_changes_descr"]		= "blok Perubahan Tertunda akan memberi pengguna dengan hak Sunting daftar rekaman yang telah berubah secara daring yang hal tersebut masih perlu diteliti dan diterima. Perubahan ini tertunda penerimaan atau penolakannya.<br /><br />Jika blok ini diaktifkan, pengguna dengan hak Terima akan menerima email sekali sehari yang memberitahukan bahwa perubahan tersebut perlu diteliti.";
$pgv_lang["review_changes_block"]		= "Perubahan Tertunda";
$pgv_lang["review_changes_email"]		= "Kirim email pengingat?";
$pgv_lang["review_changes_email_freq"]		= "Frekuensi email pengingat (hari)";
$pgv_lang["review_changes_subject"]		= "PhpGedView - Periksa kembali perubahan";
$pgv_lang["review_changes_body"]		= "Perubahan daring telah dibuat terhadap basisdata genealogis. Perubahan tersebut perlu diteliti dan diterima sebelum ditampilkan ke para pengguna. Silakan gunakan URL di bawah untuk memasuki situs PhpGedView itu dan masuk log untuk meneliti perubahan.";
$pgv_lang["show_pending"]			= "Perlihatkan perubahan tertunda";
$pgv_lang["show_spouses"]			= "Perlihatkan pasangan";
$pgv_lang["quick_update_title"]			= "Pemutakhiran Cepat";
$pgv_lang["quick_update_instructions"]		= "Halaman ini memungkinkan Anda untuk secepatnya memutakhirnya informasi untuk suatu individu. Anda hanya perlu mengisi informasi yang baru atau yang berubah dari yang berlaku di basisdata. Setelah pengubahan Anda terkirim, maka harus diteliti oleh administrator sebelum diperlihatkan ke khalayak.";
$pgv_lang["update_name"]			= "Mutakhirkan Nama";
$pgv_lang["update_fact"]			= "Mutakhirkan Fakta";
$pgv_lang["update_fact_restricted"]		= "Pemutakhiran fakta ini terbatas:";
$pgv_lang["update_photo"]			= "Mutakhirkan Foto";
$pgv_lang["select_fact"]			= "Pilih sebuah fakta...";
$pgv_lang["update_address"]			= "Mutakhirkan Alamat";
$pgv_lang["top10_pageviews_descr"]		= "Blok ini akan menunjukkan 10 rekaman yang paling banyak ditampilkan. Blok ini memerlukan Penghitung Kunjungan diaktikfna pada pengaturan konfigurasi GEDCOM.";
$pgv_lang["top10_pageviews"]			= "Item yang Paling Banyak Ditampilkan";
$pgv_lang["top10_pageviews_block"]		= "Item yang Paling Banyak Ditampilkan";
$pgv_lang["stepdad"]				= "Ayah Tiri";
$pgv_lang["stepmom"]				= "Ibu Tiri";
$pgv_lang["stepsister"]				= "Saudari Tiri";
$pgv_lang["stepbrother"]			= "Saudara Tiri";
$pgv_lang["fams_charts"]			= "Pilihan untuk keluarga";
$pgv_lang["indis_charts"]			= "Pilihan untuk individu";
$pgv_lang["none"]				= "Tidak ada";
$pgv_lang["locked"]				= "Jangan diganti";
$pgv_lang["privacy"]				= "Pribadi";
$pgv_lang["number_sign"]			= "#";

//-- GENERAL HELP MESSAGES
$pgv_lang["qm"] 				= "?";
$pgv_lang["qm_ah"]				= "?";
$pgv_lang["page_help"]				= "Bantuan";
$pgv_lang["help_for_this_page"] 		= "Bantuan tentang halaman ini";
$pgv_lang["help_contents"]			= "Daftar Bantuan";
$pgv_lang["show_context_help"]			= "Perlihatkan Bantuan Kontekstual";
$pgv_lang["hide_context_help"]			= "Sembunyikan Bantuan Kontekstual";
$pgv_lang["sorry"]				= "<b>Maaf, teks Bantuan untuk halaman ini atau item belum tersedia.</b>";
$pgv_lang["help_not_exist"] 			= "<b>Teks Bantuan untuk halaman ini atau item belum tersedia.</b>";
$pgv_lang["var_not_exist"]			= "<span style=\"font-weight: bold\">Variabel bahasa tidak ada. Silakan laporkan hal ini karena merupakan kesalahan.</span>";
$pgv_lang["resolution"] 			= "Resolusi Layar";
$pgv_lang["menu"]				= "Menu";
$pgv_lang["header"] 				= "Catatan Kepala";
$pgv_lang["imageview"]				= "Penampil Gambar";

//-- CONFIG FILE MESSAGES
$pgv_lang["login_head"] 			= "Masuk log Pengguna PhpGedView";
$pgv_lang["for_support"]			= "Untuk dukungan dan informasi teknis hubungi";
$pgv_lang["for_contact"]			= "Untuk bantuan tentang pertanyaan genealogi hubungi";
$pgv_lang["for_all_contact"]			= "Untuk dukungan teknis atau pertanyaan genealogi, silakan hubungi";
$pgv_lang["build_error"]			= "Berkas GEDCOM telah dimutakhirkan.";
$pgv_lang["choose_username"]			= "Nama pengguna yang diinginkan";
$pgv_lang["username"]				= "Nama pengguna";
$pgv_lang["invalid_username"]			= "Nama pengguna mengandung karakter yang keliru";
$pgv_lang["firstname"]				= "Nama Depan";
$pgv_lang["lastname"]				= "Nama Belakang";
$pgv_lang["choose_password"]			= "Sandi yang diinginkan";
$pgv_lang["password"]				= "Sandi";
$pgv_lang["confirm"]				= "Konfirmasi Sandi";
$pgv_lang["login"]				= "Masuk log";
$pgv_lang["logout"] 				= "Keluar log";
$pgv_lang["admin"]				= "Admin";
$pgv_lang["logged_in_as"]			= "Masuk log sebagai ";
$pgv_lang["my_pedigree"]			= "Kerabat Saya";
$pgv_lang["my_indi"]				= "Rekaman Pribadi Saya";
$pgv_lang["yes"]				= "Ya";
$pgv_lang["no"] 				= "Tidak";
$pgv_lang["change_theme"]			= "Ganti Tema";

//-- INDEX (PEDIGREE_TREE) FILE MESSAGES
$pgv_lang["index_header"]			= "Silsilah Kerabat";
$pgv_lang["gen_ped_chart"]			= "Bagan Kerabat #PEDIGREE_GENERATIONS# Generasi";
$pgv_lang["generations"]			= "Generasi";
$pgv_lang["view"]				= "Tampilkan";
$pgv_lang["fam_spouse"] 			= "Keluarga dengan pasangan";
$pgv_lang["root_person"]			= "ID Orang Acuan";
$pgv_lang["hide_details"]			= "Sembunyikan Rincian";
$pgv_lang["show_details"]			= "Perlihatkan Rincian";
$pgv_lang["person_links"]			= "Pranala ke bagan, keluarga, dan kerabat dekat dari orang ini. Klik ikon ini untuk memperlihatkan halaman ini, bermula dari orang ini.";
$pgv_lang["zoom_box"]				= "Perbesar/perkecil kotak ini.";
$pgv_lang["orientation"]			= "Orientasi";
$pgv_lang["portrait"]				= "Potret";
$pgv_lang["landscape"]				= "Lanskap";
$pgv_lang["start_at_parents"]			= "Mulai dari orangtua";
$pgv_lang["charts"] 				= "Bagan";
$pgv_lang["lists"]				= "Daftar";
$pgv_lang["box_width"] 				= "Lebar kotak";

//-- FUNCTIONS FILE MESSAGES
$pgv_lang["unable_to_find_family"]		= "Tidak dapat menemukan keluarga dengan ID";
$pgv_lang["unable_to_find_record"]		= "Tidak dapat menemukan rekaman dengan ID";
$pgv_lang["title"]				= "Judul:";
$pgv_lang["living"] 				= "Hidup";
$pgv_lang["private"]				= "Pribadi";
$pgv_lang["birth"]				= "Lahir:";
$pgv_lang["death"]				= "Meninggal:";
$pgv_lang["descend_chart"]			= "Bagan Keturunan";
$pgv_lang["individual_list"]			= "Daftar Individu";
$pgv_lang["family_list"]			= "Daftar Keluarga";
$pgv_lang["source_list"]			= "Daftar Sumber";
$pgv_lang["place_list"] 			= "Hirarki Tempat";
$pgv_lang["place_list_aft"] 			= "Hirarki Tempat setelah";
$pgv_lang["media_list"] 			= "Daftar MultiMedia";
$pgv_lang["search"] 				= "Cari";
$pgv_lang["clippings_cart"] 			= "Bagan Kliping Silsilah Keluarga";
$pgv_lang["print_preview"]			= "Versi akrab-pencetak";
$pgv_lang["cancel_preview"] 			= "Kembali ke tampilan normal";
$pgv_lang["change_lang"]			= "Ganti Bahasa";
$pgv_lang["print"]				= "Cetak";
$pgv_lang["total_queries"]			= "Total Kueri Basisdata: ";
$pgv_lang["total_privacy_checks"]		= "Total pemeriksaan pribadi: ";
$pgv_lang["back"]				= "Kembali";

//-- INDIVIDUAL FILE MESSAGES
$pgv_lang["aka"]				= "Alias";
$pgv_lang["male"]				= "Laki-laki";
$pgv_lang["female"] 				= "Perempuan";
$pgv_lang["temple"] 				= "Kuil LDS";
$pgv_lang["temple_code"]			= "Kode Kuil LDS:";
$pgv_lang["status"] 				= "Status";
$pgv_lang["source"] 				= "Sumber";
$pgv_lang["text"]				= "Teks Sumber:";
$pgv_lang["note"]				= "Catatan";
$pgv_lang["NN"] 				= "(anonim)";
$pgv_lang["PN"] 				= "(anonim)";
$pgv_lang["NNhebrew"] 				= "(לא ידוע)";
$pgv_lang["PNhebrew"] 				= "(לא ידוע)";
$pgv_lang["NNarabic"] 				= "(غير معروف)";
$pgv_lang["PNarabic"] 				= "(غير معروف)";
$pgv_lang["NNgreek"] 				= "(άγνωστος/η)";
$pgv_lang["PNgreek"] 				= "(άγνωστος/η)";
$pgv_lang["NNrussian"] 				= "(неопределено)";
$pgv_lang["PNrussian"] 				= "(неопределено)";
$pgv_lang["NNchinese"] 				= "(未知)";
$pgv_lang["PNchinese"] 				= "(未知)";
$pgv_lang["NNvietnamese"]			= "(vô danh)";
$pgv_lang["PNvietnamese"]			= "(không biết tuổi)";
$pgv_lang["NNthai"] 				= "(unknown)";
$pgv_lang["PNthai"] 				= "(unknown)";
$pgv_lang["NNother"] 				= "(anonim)";
$pgv_lang["PNother"] 				= "(anonim)";
$pgv_lang["unrecognized_code"]			= "Kode GEDCOM tidak dikenal";
$pgv_lang["unrecognized_code_msg"]		= "Ini adalah kesalahan, dan kami ingin memperbaikinya. Silakan laporkan kesalahan ini kepada";
$pgv_lang["indi_info"]				= "Informasi Individu";
$pgv_lang["pedigree_chart"] 			= "Bagan Kerabat";
$pgv_lang["individual"]				= "Individu";
$pgv_lang["as_spouse"]				= "Keluarga dengan Pasangan";
$pgv_lang["privacy_error"]			= "Informasi ini pribadi dan tidak diperlihatkan.";
$pgv_lang["more_information"]			= "Untuk informasi lebih lanjut hubungi";
$pgv_lang["given_name"] 			= "Nama Depan:";
$pgv_lang["surname"]				= "Marga/Ayah:";
$pgv_lang["suffix"] 				= "Sandangan:";
$pgv_lang["sex"]				= "Jender";
$pgv_lang["personal_facts"] 			= "Fakta dan Rincian Diri";
$pgv_lang["type"]				= "Jenis";
$pgv_lang["parents"]				= "Orangtua:";
$pgv_lang["siblings"]				= "Saudara";
$pgv_lang["father"] 				= "Ayah";
$pgv_lang["mother"] 				= "Ibu";
$pgv_lang["parent"] 				= "Orangtua";
$pgv_lang["parent_age"] 			= "Umur orangtua";
$pgv_lang["father_age"]				= "Umur ayah";
$pgv_lang["mother_age"]				= "Umur ibu";
$pgv_lang["self"] 				= "Diri sendiri";
$pgv_lang["relatives"]				= "Kerabat Dekat";
$pgv_lang["relatives_events"]			= "Peristiwa dari kerabat dekat";
$pgv_lang["historical_facts"]			= "Fakta sejarah";
$pgv_lang["partner"] 				= "Partner";
$pgv_lang["spouse"] 				= "Pasangan";
$pgv_lang["spouses"] 				= "Pasangan-pasangan";
$pgv_lang["surnames"]				= "Marga/Ayah";
$pgv_lang["adopted"]				= "Adopsi";
$pgv_lang["foster"] 				= "Orangtua angkat";
$pgv_lang["sealing"]				= "Penyegelan";
$pgv_lang["challenged"]				= "Ditantang";
$pgv_lang["disproved"]				= "Ditolak";
$pgv_lang["infant"]				= "Anak-anak";
$pgv_lang["stillborn"]				= "Bayi";
$pgv_lang["deceased"]				= "Meninggal";
$pgv_lang["link_as_wife"]			= "Kaitkan orang ini kepada keluarga yang ada sebagai istri";
$pgv_lang["no_tab1"]				= "Tidak ada Fakta untuk orang ini.";
$pgv_lang["no_tab2"]				= "Tidak ada Catatan untuk orang ini.";
$pgv_lang["no_tab3"]				= "Tidak ada Kutipan Sumber untuk orang ini.";
$pgv_lang["no_tab4"]				= "Tidak ada objek media untuk orang ini.";
$pgv_lang["no_tab5"]				= "Tidak ada kerabat dekat untuk orang ini.";
$pgv_lang["no_tab6"]				= "Tidak ada catatan penelitian yang terlampir pada orang ini.";
$pgv_lang["show_fact_sources"]			= "Perlihatkan semua sumber";
$pgv_lang["show_fact_notes"]			= "Perlihatkan semua catatan";

//-- FAMILY FILE MESSAGES
$pgv_lang["family_info"]			= "Informasi Keluarga";
$pgv_lang["family_group_info"]			= "Informasi Kelompok Keluarga";
$pgv_lang["husband"]				= "Suami";
$pgv_lang["wife"]				= "Istri";
$pgv_lang["marriage"]				= "Nikah:";
$pgv_lang["lds_sealing"]			= "Penyegelan LDS:";
$pgv_lang["marriage_license"]			= "Kartu Nikah:";
$pgv_lang["no_children"]			= "Tidak ada anak yang tercatat";
$pgv_lang["childless_family"]			= "Keluarga ini tidak memiliki anak";
$pgv_lang["parents_timeline"]			= "Perlihatkan pasangan pada bagan gariswaktu";

//-- CLIPPINGS FILE MESSAGES
$pgv_lang["clip_cart"]				= "Bagan Kliping";
$pgv_lang["which_links"]			= "Kaitan lain yang mana dari keluarga ini yang ingin Anda tambahkan?";
$pgv_lang["just_family"]			= "Hanya tambahkan rekaman keluarga ini.";
$pgv_lang["parents_and_family"] 		= "Tambahkan rekaman orangtua bersama dengan rekaman keluarga ini.";
$pgv_lang["parents_and_child"]			= "Tambahkan rekaman orangtua dan anak bersama dengan rekaman keluarga ini.";
$pgv_lang["parents_desc"]			= "Tambahkan rekaman orangtua dan seluruh keturunan bersama dengan rekaman keluarga ini.";
$pgv_lang["continue"]				= "Lanjutkan Penambahan";
$pgv_lang["which_p_links"]			= "Kaitan mana dari orang ini yang ingin Anda tambahkan?";
$pgv_lang["just_person"]			= "Hanya tambahkan orang ini.";
$pgv_lang["person_parents_sibs"]		= "Tambahkan orang ini, orangtua dan saudaranya.";
$pgv_lang["person_ancestors"]			= "Tambahkan orang ini dan leluhur langsungnya.";
$pgv_lang["person_ancestor_fams"]		= "Tambahkan orang ini, leluhur langsungnya, dan keluarga mereka.";
$pgv_lang["person_spouse"]			= "Tambahkan orang ini, pasangan dan anak-anaknya.";
$pgv_lang["person_desc"]			= "Tambahkan orang ini, pasangan dan semua keturunannya.";
$pgv_lang["which_s_links"]			= "Rekaman yang mana terkait dengan sumber ini yang seharusnya ditambahkan?";
$pgv_lang["just_source"]			= "Hanya tambahkan sumber ini.";
$pgv_lang["linked_source"]			= "Tambahkan sumber ini dan keluarga/orang yang terkait sumber tersebut.";
$pgv_lang["person_private"] 			= "Rincian tentang orang ini bersifat pribadi. Rincian personal tidak akan dimasukkan.";
$pgv_lang["family_private"] 			= "Rincian tentang keluarga ini bersifat pribadi. Rincian keluarga tidak akan dimasukkan.";
$pgv_lang["download"]				= "Klik kanan (klik-kontrol pada Macintosh) pada pranala di bawah dan pilih &quot;Simpan target as&quot; untuk mengunduh berkas.";
$pgv_lang["cart_is_empty"]			= "Bagan Kliping Anda kosong.";
$pgv_lang["id"] 				= "ID";
$pgv_lang["ID"] 				= "ID";
$pgv_lang["name_description"]			= "Nama / Uraian";
$pgv_lang["remove"] 				= "Buang";
$pgv_lang["empty_cart"] 			= "Kosongkan Bagan";
$pgv_lang["download_now"]			= "Unduh Sekarang";
$pgv_lang["download_file"]			= "Unduh berkas #GLOBALS[whichFile]#";
$pgv_lang["indi_downloaded_from"]		= "Individu ini diunduh dari:";
$pgv_lang["family_downloaded_from"]		= "Keluarga ini diunduh dari:";
$pgv_lang["source_downloaded_from"]		= "Sumber ini diunduh dari:";
$pgv_lang["enter_person_generations"]		= "Jumlah generasi:";

//-- PLACELIST FILE MESSAGES
$pgv_lang["connections"]				= "Keterkaitan tempat ditemukan";
$pgv_lang["top_level"]					= "Level Teratas";
$pgv_lang["form"]					= "Tempat tersusun dengan urutan: ";
$pgv_lang["default_form"]				= "Kota, Distrik, Negara Bagian/Provinsi, Negara";
$pgv_lang["default_form_info"]				= "(Default)";
$pgv_lang["unknown"]					= "Tidak diketahui";
$pgv_lang["individuals"]				= "Individu";
$pgv_lang["view_records_in_place"]			= "Tampilkan semua rekaman yang ditemukan di tempat ini";
$pgv_lang["place_list2"] 				= "Daftar Tempat";
$pgv_lang["show_place_hierarchy"]			= "Perlihatkan Tempat dalam Hirarki";
$pgv_lang["show_place_list"]				= "Perlihatkan Semua Tempat dalam Daftar";
$pgv_lang["total_unic_places"]				= "Total Tempat Spesifik";

//-- MEDIALIST FILE MESSAGES
$pgv_lang["external_objects"]				= "Objek luar";
$pgv_lang["multi_title"]				= "Daftar Objek MultiMedia";
$pgv_lang["media_found"]				= "Objek Media ditemukan";
$pgv_lang["view_person"]				= "Tampilkan Orang";
$pgv_lang["view_family"]				= "Tampilkan Keluarga";
$pgv_lang["view_source"]				= "Tampilkan Sumber";
$pgv_lang["view_object"]				= "Tampilkan Objek";
$pgv_lang["prev"]					= "&lt; Sebelumnya";
$pgv_lang["next"]					= "Selanjutnya &gt;";
$pgv_lang["next_image"]					= "Gambar selanjutnya";
$pgv_lang["file_not_found"] 				= "Berkas tidak ditemukan.";
$pgv_lang["medialist_show"] 				= "Perlihatkan";
$pgv_lang["per_page"]					= "objek media tiap halaman";
$pgv_lang["media_format"]				= "Format Media";
$pgv_lang["image_size"]					= "Dimensi Gambar";
$pgv_lang["media_id"]					= "ID Media";
$pgv_lang["invalid_id"]					= "Tidak ada ID yang demikian pada berkas GEDCOM ini.";
$pgv_lang["record_updated"]				= "Rekaman #pid# berhasil dimutakhirkan.";
$pgv_lang["record_not_updated"]				= "Rekaman #pid# tidak dapat dimutakhirkan.";
$pgv_lang["record_removed"]				= "Rekaman #xref# berhasil dibuang dari GEDCOM.";
$pgv_lang["record_not_removed"]				= "Rekaman #xref# tidak dapat dibuang dari GEDCOM.";
$pgv_lang["record_added"]				= "Rekaman #xref# berhasil ditambahkan ke GEDCOM.";
$pgv_lang["record_not_added"]				= "Rekaman #xref# tidak dapat ditambahkan ke GEDCOM.";

//-- SEARCH FILE MESSAGES
$pgv_lang["soundex_search"] 				= "Cari dengan cara bagaimana menurut Anda nama tersebut ditulis (Pengucapan)";
$pgv_lang["sources"]					= "Sumber";
$pgv_lang["lastname_search"]				= "Nama belakang";
$pgv_lang["search_place"]				= "Tempat";
$pgv_lang["search_year"]				= "Tahun";
$pgv_lang["no_results"] 				= "Tidak ada hasil yang ditemukan.";
$pgv_lang["search_soundex"]				= "Cari Pengucapan";
$pgv_lang["search_replace"]				= "Cari dan Ganti";
$pgv_lang["search_sources"]				= "Sumber";
$pgv_lang["search_more_chars"]				= "Silakan masukkan lebih dari satu karakter";
$pgv_lang["search_soundextype"]				= "Jenis Pengucapan:";
$pgv_lang["search_russell"]				= "Dasar";
$pgv_lang["search_tagfilter"]				= "Keluarkan Penyaring";
$pgv_lang["search_tagfon"]				= "Keluarkan beberapa data non-genealogis";
$pgv_lang["search_tagfoff"]				= "Meninggal";
$pgv_lang["associate"]					= "hubungan";
$pgv_lang["search_record"]				= "Seluruh rekaman";
$pgv_lang["search_to"]					= "hingga";

//-- SOURCELIST FILE MESSAGES
$pgv_lang["titles_found"]				= "Judul";
$pgv_lang["find_source"]				= "Cari Sumber";

//-- REPOLIST FILE MESSAGES
$pgv_lang["repo_list"]					= "Daftar Repositori";
$pgv_lang["repos_found"]				= "Repositori yang ditemukan";
$pgv_lang["find_repository"]				= "Cari Repositors";
$pgv_lang["total_repositories"]				= "Total Repositori";
$pgv_lang["confirm_delete_repo"]			= "Apakag Anda yakin ingin menghapus Repositori ini dari basisdata?";

//-- SOURCE FILE MESSAGES
$pgv_lang["source_info"]				= "Informasi Sumber";
$pgv_lang["people"] 					= "Orang";
$pgv_lang["families"]					= "Keluarga";
$pgv_lang["total_sources"]				= "Total Sumber";

//-- BUILDINDEX FILE MESSAGES
$pgv_lang["invalid_gedformat"]				= "Format GEDCOM keliru";
$pgv_lang["exec_time"]					= "Waktu eksekusi:";
$pgv_lang["unable_to_create_index"] 			= "Tidak dapat membuat Berkas indeks. Pastikan Izin penulisan telah diset pada direktori PhpGedView. Izin dapat dikembalikan sehabis Berkas indeks ditulis.";
$pgv_lang["changes_present"]				= "GEDCOM yang berlaku memiliki penelitian perubahan tertunda. Jika Anda melanjutkan Impor ini, perubahan tertunda tersebut akan segera terkirim ke basisdata. Anda sebaiknya meneliti perubahan tertunda sebelum melanjutkan Impor ini.";
$pgv_lang["sec"]					= "detik.";

//-- INDIVIDUAL AND FAMILYLIST FILE MESSAGES
$pgv_lang["total_fams"] 				= "Total keluarga";
$pgv_lang["total_indis"]				= "Total individu";
$pgv_lang["notes"]					= "Catatan";
$pgv_lang["ssourcess"]					= "Sumber";
$pgv_lang["media"]					= "Media";
$pgv_lang["name_contains"]				= "Nama mengandung:";
$pgv_lang["filter"] 					= "Penyaring";
$pgv_lang["apply_filter"]				= "Terapkan penyaring";
$pgv_lang["find_individual"]				= "Cari ID Individu";
$pgv_lang["find_familyid"]				= "Cari ID Keluarga";
$pgv_lang["find_sourceid"]				= "Cari ID Sumber";
$pgv_lang["find_specialchar"]				= "Cari Karakter Khusus";
$pgv_lang["magnify"]					= "Perbesar";
$pgv_lang["skip_surnames"]				= "Lewati Daftar marga";
$pgv_lang["show_surnames"]				= "Perlihatkan Daftar marga";
$pgv_lang["all"]					= "SEMUA";
$pgv_lang["hidden"]					= "Sembunyikan";
$pgv_lang["confidential"]				= "Rahasia";
$pgv_lang["alpha_index"]				= "Indeks Alfabetis";
$pgv_lang["name_list"] 					= "Daftar Nama";
$pgv_lang["firstname_alpha_index"] 			= "Indeks Alfabetis Nama Depan";
$pgv_lang["roots"]		 			= "Akar";
$pgv_lang["leaves"] 					= "Ranting";
$pgv_lang["widow"] 					= "Janda";
$pgv_lang["widower"] 					= "Duda";
$pgv_lang["show_parents"] 				= "Perlihatkan orangtua";

//-- TIMELINE FILE MESSAGES
$pgv_lang["age"]					= "Umur";
$pgv_lang["husb_age"]					= "Umur suami";
$pgv_lang["wife_age"]					= "Umur istri";
$pgv_lang["days"]					= "hari";
$pgv_lang["months"]					= "bulan";
$pgv_lang["years"]					= "tahun";	// >2 years
$pgv_lang["years2"]					= "tahun";	// 2 years
$pgv_lang["day1"]					= "hari";
$pgv_lang["month1"]					= "bulan";
$pgv_lang["year1"]					= "tahun";
$pgv_lang["after_death"]        			= "setelah wafat";
$pgv_lang["at_death_day"]      				= "pada hari kematian";
$pgv_lang["timeline_title"] 				= "Gariswaktu PhpGedView";
$pgv_lang["timeline_chart"] 				= "Bagan Gariswaktu";
$pgv_lang["remove_person"]				= "Buang Orang";
$pgv_lang["show_age"]					= "Perlihatlan Petanda Umur";
$pgv_lang["add_another"]				= "Tambahkan orang lain ke bagan:<br />ID orang:";
$pgv_lang["find_id"]					= "Cari ID";
$pgv_lang["show"]					= "Perlihatkan";
$pgv_lang["year"]					= "Tahun:";
$pgv_lang["timeline_instructions"]			= "Pada perambah terkini, Anda dapat meng-klik dan menyeret kotak di sekitar bagan.";
$pgv_lang["zoom_in"]					= "Perbesar";
$pgv_lang["zoom_out"]					= "Perkecil";
$pgv_lang["timeline_beginYear"]				= "Tahun Bermula";
$pgv_lang["timeline_endYear"]				= "Tahun Berakhir";
$pgv_lang["timeline_scrollSpeed"]			= "Kecepatan";
$pgv_lang["timeline_controls"]				= "Kontrol Gariswaktu";
$pgv_lang["include_family"]				= "Termasuk Keluarga Dekat";
$pgv_lang["lifespan_chart"]				= "Bagan Rentanghidup";

// calendar conversion options
$pgv_lang["cal_none"]                 			= "Tidak ada konversi kalender";
$pgv_lang["cal_gregorian"]            			= "Gregorian";
$pgv_lang["cal_julian"]               			= "Julian";
$pgv_lang["cal_french"]               			= "Perancis";
$pgv_lang["cal_jewish"]               			= "Yahudi";
$pgv_lang["cal_hebrew"]               			= "Yunani";
$pgv_lang["cal_jewish_and_gregorian"]			= "Yahudi dan Gregorian";
$pgv_lang["cal_hebrew_and_gregorian"]			= "Yunani dan Gregorian";
$pgv_lang["cal_hijri"]					= "Hijriah";
$pgv_lang["cal_arabic"]					= "Bahasa Arab";

// some religious dates
$pgv_lang["easter"]					= "Paskah";
$pgv_lang["ascension"]					= "Kenaikan";
$pgv_lang["pentecost"]					= "Pantekosta";
$pgv_lang["assumption"]					= "Asumsi";
$pgv_lang["all_saints"]					= "Semua Santo";
$pgv_lang["christmas"]					= "Natal";

// am/pm suffixes for 12 hour clocks
$pgv_lang["a.m."]					= "am";
$pgv_lang["p.m."]					= "pm";
$pgv_lang["noon"]					= "m";
$pgv_lang["midn"]					= "mn";

//-- MONTH NAMES
$pgv_lang["jan"]					= "Januari";
$pgv_lang["feb"]					= "Februari";
$pgv_lang["mar"]					= "Maret";
$pgv_lang["apr"]					= "April";
$pgv_lang["may"]					= "Mei";
$pgv_lang["jun"]					= "Juni";
$pgv_lang["jul"]					= "Juli";
$pgv_lang["aug"]					= "Agustus";
$pgv_lang["sep"]					= "September";
$pgv_lang["oct"]					= "Oktober";
$pgv_lang["nov"]					= "November";
$pgv_lang["dec"]					= "Desember";

$pgv_lang["vend"]					= "Vendémiaire";
$pgv_lang["brum"]					= "Brumaire";
$pgv_lang["frim"]					= "Frimaire";
$pgv_lang["nivo"]					= "Nivôse";
$pgv_lang["pluv"]					= "Pluviôse";
$pgv_lang["vent"]					= "Ventôse";
$pgv_lang["germ"]					= "Germinal";
$pgv_lang["flor"]					= "Floréal";
$pgv_lang["prai"]					= "Prairial";
$pgv_lang["mess"]					= "Messidor";
$pgv_lang["ther"]					= "Thermidor";
$pgv_lang["fruc"]					= "Fructidor";
$pgv_lang["comp"]					= "jours complémentaires";

$pgv_lang["tsh"]					= "Tishrei";
$pgv_lang["csh"]					= "Heshvan";
$pgv_lang["ksl"]					= "Kislev";
$pgv_lang["tvt"]					= "Tevet";
$pgv_lang["shv"]					= "Shevat";
$pgv_lang["adr"]					= "Adar";
$pgv_lang["adr_leap_year"]				= "Adar I";
$pgv_lang["ads"]					= "Adar II";
$pgv_lang["nsn"]					= "Nissan";
$pgv_lang["iyr"]					= "Iyar";
$pgv_lang["svn"]					= "Sivan";
$pgv_lang["tmz"]					= "Tamuz";
$pgv_lang["aav"]					= "Av";
$pgv_lang["ell"]					= "Elul";

$pgv_lang["muhar"]					= "Muharram";
$pgv_lang["safar"]					= "Safar";
$pgv_lang["rabia"]					= "Rabiul Awal";
$pgv_lang["rabit"]					= "Rabiul Tsani";
$pgv_lang["jumaa"]					= "Jumadil Awal";
$pgv_lang["jumat"]					= "Jumadil Tsani";
$pgv_lang["rajab"]					= "Rajab";
$pgv_lang["shaab"]					= "Sya'ban";
$pgv_lang["ramad"]					= "Ramadan";
$pgv_lang["shaww"]					= "Syawal";
$pgv_lang["dhuaq"]					= "Dzulqa'dah";
$pgv_lang["dhuah"]					= "Dzulhijjah";

$pgv_lang["b.c."]= "SM";

$pgv_lang["abt"]					= "Sekitar";
$pgv_lang["aft"]					= "Setelah";
$pgv_lang["and"]					= "dan";
$pgv_lang["bef"]					= "Sebelum";
$pgv_lang["bet"]					= "Antara";
$pgv_lang["cal"]					= "Diperhitungkan";
$pgv_lang["est"]					= "Diperkirakan";
$pgv_lang["from"]					= "Sejak";
$pgv_lang["int"]					= "Ditafsirkan";
$pgv_lang["to"] 					= "hingga";
$pgv_lang["cir"]					= "Sekitar";
$pgv_lang["apx"]					= "Kira-kira";

//-- Admin File Messages
$pgv_lang["rebuild_indexes"]				= "Buatkembali indeks";
$pgv_lang["password_mismatch"]				= "Sandi tidak cocok.";
$pgv_lang["enter_username"] 				= "Anda harus memasukkan nama pengguna.";
$pgv_lang["enter_password"] 				= "Anda harus memasukkan sandi.";
$pgv_lang["save"]					= "Simpan";
$pgv_lang["saveandgo"]					= "Simpan dan menuju ke rekaman baru ini";
$pgv_lang["delete"] 					= "Hapus";
$pgv_lang["edit"]					= "Sunting";
$pgv_lang["no_login"]					= "Tidak dapat mengotentifikasi pengguna.";
$pgv_lang["basic_realm"]				= "Sistem Otentifikasi PhpGedView";
$pgv_lang["basic_auth_failure"]				= "Anda harus memasukkan ID masuk log dan sandi yang benar untuk mengakses sumberdaya ini";
$pgv_lang["basic_auth"]					= "Otentifikasi Dasar";
$pgv_lang["digest_auth"]				= "Otentifikasi Digest"; //not used in code yet
$pgv_lang["no_auth_needed"]				= "Tidak ada Otentifikasi";
$pgv_lang["file_not_exists"]				= "Namaberkas yang dimasukkan tidak ada.";
$pgv_lang["research_assistant"]				= "Asisten Riset";
$pgv_lang["utf8_to_ansi"]				= "Konversi dari UTF-8 ke ANSI (ISO-8859-1)";
$pgv_lang["media_linked"]				= "Media objek ini terkait ke berikut:";
$pgv_lang["media_not_linked"]				= "Media objek ini tidak terkait ke rekaman GEDCOM manapun.";
$pgv_lang["media_dir_1"]				= "Media objek ini terletak di server luar";
$pgv_lang["media_dir_2"]				= "Media objek ini ada di direktori media standar";
$pgv_lang["media_dir_3"]				= "Media objek ini ada di direktori media terproteksi";
$pgv_lang["thumb_dir_1"]				= "Thumbnail ini terletak di server luar";
$pgv_lang["thumb_dir_2"]				= "Thumbnail ini ada di direktori media standar";
$pgv_lang["thumb_dir_3"]				= "Thumbnail ini ada di direktori media terproteksi";
$pgv_lang["moveto_2"]					= "Pindahkan ke direktori terproteksi";
$pgv_lang["moveto_3"]					= "Pindahkan ke direktori standar";
$pgv_lang["move_standard"]				= "Pindahkan ke standar";
$pgv_lang["move_protected"]				= "Pindahkan ke terproteksi";
$pgv_lang["move_mediadirs"]				= "Pindahkan Direktori Media";
$pgv_lang["setperms"]					= "Tetapkan Izin Media";
$pgv_lang["setperms_fix"]				= "Izin baca/tulis/eksekusi yang benar";
$pgv_lang["setperms_success"]				= "Izin Ditetapkan";
$pgv_lang["setperms_failure"]				= "Izin Tidak Ditetapkan";
$pgv_lang["setperms_time_exceeded"]			= "Batas waktu eksekusi tercapai.  Cobalah perintah lagi pada direktori yang lebih kecil.";
$pgv_lang["move_time_exceeded"]				= "Batas waktu eksekusi tercapai.  Cobalah perintah lagi untuk memindahkan berkas yang tersisa.";
$pgv_lang["media_firewall_rootdir_no_exist"]		= "Direktori root Firewall Media yang Anda minta tidak ada.  Anda harus membuatnya terlebih dahulu.";
$pgv_lang["media_firewall_protected_dir_no_exist"]	= "Direktori media terproteksi tidak dapat dibuat di direktori root Firewall Media. Silakan buat directori ini dan jadikan dapat tertulis secara global.";
$pgv_lang["media_firewall_protected_dir_not_writable"]	= "Direktori media terproteksi di root directori Firewall Media tidak dapat ditulisi secara global. ";
$pgv_lang["media_firewall_invalid_dir"]			= "Kesalahan: Firewall Media diluncurkan dari directori selain direktori media.";

//-- Relationship chart messages
$pgv_lang["view_fam_nav_details"]			= "Tampilan Rincian dari ...";
$pgv_lang["relationship_great"]				= "Hebat";
$pgv_lang["relationship_chart"] 			= "Bagan Kekerabatan";
$pgv_lang["person1"]					= "Orang 1";
$pgv_lang["person2"]					= "Orang 2";
$pgv_lang["no_link_found"]				= "Tidak ada kaitan (lain) antara dua individu yang ditemukan.";
$pgv_lang["sibling"]					= "Saudara";
$pgv_lang["follow_spouse"]				= "Periksa kekerabatan berdasarkan pernikahan";
$pgv_lang["timeout_error"]				= "Waktu skrip habis sebelum kekerabatan ditemukan.";
$pgv_lang["grandchild"]					= "Cucu";
$pgv_lang["grandson"]					= "Cucu laki-laki";
$pgv_lang["granddaughter"]				= "Cucu perempuan";
$pgv_lang["greatgrandchild"]				= "Cicit";
$pgv_lang["greatgrandson"]				= "Cicit laki-laki";
$pgv_lang["greatgranddaughter"]				= "Cicit perempuan";
$pgv_lang["brother"]					= "Saudara";
$pgv_lang["sister"] 					= "Saudari";
$pgv_lang["aunt"]					= "Bibi";
$pgv_lang["uncle"]					= "Paman";
$pgv_lang["nephew"]					= "Keponakan laki-laki";
$pgv_lang["niece"]					= "Keponakan perempuan";
$pgv_lang["firstcousin"]				= "Sepupu sekali";
$pgv_lang["femalecousin"]				= "Sepupu perempuan";
$pgv_lang["malecousin"]					= "Sepupu laki-laki";
$pgv_lang["relationship_to_me"] 			= "Kekerabatan denganku";
$pgv_lang["rela_husb"]					= "Kekerabatan dengan suami";
$pgv_lang["rela_wife"]					= "Kekerabatan dengan istri";
$pgv_lang["next_path"]					= "Cari jalur selanjutnya";
$pgv_lang["show_path"]					= "Perlihatkan jalur";
$pgv_lang["line_up_generations"]			= "Jejerkan generasi yang sama";
$pgv_lang["oldest_top"]             			= "Perlihatkan tetua diatas";

// %1\$s replaced by first person, %2\$s by the relationship and %3\$s by the second person.
$pgv_lang["relationship_male_1_is_the_2_of_3"]		= "%1\$s adalah %2\$ dari %3\$.";
$pgv_lang["relationship_female_1_is_the_2_of_3"]	= "%1\$s adalah %2\$ dari %3\$.";

$pgv_lang["mother_in_law"]		    		= "Ibu mertua";
$pgv_lang["father_in_law"]		    		= "Ayah mertua";
$pgv_lang["brother_in_law"]		    		= "Saudara ipar";
$pgv_lang["sister_in_law"]		    		= "Saudari ipar";
$pgv_lang["son_in_law"]		        		= "Anak laki-laki saudara ipar";
$pgv_lang["daughter_in_law"]				= "Anak perempuan saudara ipar";
$pgv_lang["uncle_in_law"]				= "Paman saudara ipar";
$pgv_lang["aunt_in_law"]				= "Bibi saudara ipar";
$pgv_lang["cousin_in_law"]				= "Sepupu saudara ipar";
$pgv_lang["m_cousin_in_law"]				= "Sepupu laki-laki saudara ipar";
$pgv_lang["f_cousin_in_law"]				= "Sepupu perempuan saudara ipar";
$pgv_lang["step_son"]		        		= "anak tiri laki-laki";
$pgv_lang["step_daughter"]	    			= "anak tiri perempuan";

// the bosa_brothers_offspring name is used for fraternal nephews and nieces - the names below can be extended to any number
// of generations just by adding more translations.
// 1st generation
$pgv_lang["bosa_brothers_offspring_2"] 			= "keponakan laki-laki";             // brother's son
$pgv_lang["bosa_brothers_offspring_3"] 			= "keponakan perempuan";              // brother's daughter
// 2nd generation
$pgv_lang["bosa_brothers_offspring_4"] 			= "putra keponakan laki-laki";       // brother's son's son
$pgv_lang["bosa_brothers_offspring_5"] 			= "putri keponakan laki-laki";        // brother's son's daughter
$pgv_lang["bosa_brothers_offspring_6"] 			= "putra keponakan perempuan";       // brother's daughter's son
$pgv_lang["bosa_brothers_offspring_7"] 			= "putri keponakan perempuan";        // brother's daughter's daughter
// for the general case of offspring of the nth generation use the text below
// in this text %1\$d is replaced with the number of generations
//              %2\$d is replaced with the number of generations - 1
//              %3\$d is replaced with the number of generations - 2
$pgv_lang["n_x_brothers_son"]				= "keponakan laki-laki %2\$d x";
$pgv_lang["n_x_brothers_daughter"]			= "keponakan perempuan %2\$d x";
// the bosa_sisters_offspring name is used for sisters nephews and nieces - the names below can be extended to any number
// of generations just by adding more translations.
// 1st generation
$pgv_lang["bosa_sisters_offspring_2"] 			= "keponakan laki-laki";             // sister's son
$pgv_lang["bosa_sisters_offspring_3"] 			= "keponakan perempuan";              // sister's daughter
// 2nd generation
$pgv_lang["bosa_sisters_offspring_4"] 			= "putra keponakan laki-laki";       // sister's son's son
$pgv_lang["bosa_sisters_offspring_5"] 			= "putri keponakan laki-laki";        // sister's son's daughter
$pgv_lang["bosa_sisters_offspring_6"] 			= "putra keponakan perempuan";       // sister's daughter's son
$pgv_lang["bosa_sisters_offspring_7"] 			= "putri keponakan perempuan";        // sister's daughter's daughter
// for the general case of offspring of the nth generation use the text below
// in this text %1\$d is replaced with the number of generations
//              %2\$d is replaced with the number of generations - 1
//              %3\$d is replaced with the number of generations - 2
$pgv_lang["n_x_sisters_son"]				= "keponakan laki-laki %2\$d x";
$pgv_lang["n_x_sisters_daughter"]			= " keponakan perempuan %2\$d x";

// the bosa name is used for offspring - the names below can be extended to any number
// of generations just by adding more translations.
// 1st generation
$pgv_lang["bosa_2"] 					= "putra";                   // son
$pgv_lang["bosa_3"] 					= "putri";              // daughter
// 2nd generation
$pgv_lang["bosa_4"] 					= "cucu laki-laki";              // son's son
$pgv_lang["bosa_5"] 					= "cucu perempuan";         // son's daughter
$pgv_lang["bosa_6"] 					= "cucu laki-laki";              // daughter's son
$pgv_lang["bosa_7"] 					= "cucu perempuan";         // daughter's daughter
// 3rd generation
$pgv_lang["bosa_8"] 					= "cicit laki-laki dari cucu laki-laki dari anak laki-laki";        // son's son's son
$pgv_lang["bosa_9"] 					= "cicit laki-laki dari cucu perempuan dari anak laki-laki";   // son's son's daughter
$pgv_lang["bosa_10"] 					= "cicit laki-laki dari cucu laki-laki dari anak perempuan";		   // son's daughter's son
$pgv_lang["bosa_11"] 					= "cicit laki-laki dari cucu perempuan dari anak perempuan";   // son's daughter's daughter
$pgv_lang["bosa_12"] 					= "cicit perempuan dari cucu laki-laki dari anak laki-laki";        // daughter's son's son
$pgv_lang["bosa_13"] 					= "cicit perempuan dari cucu perempuan dari anak laki-laki";   // daughter's son's daughter
$pgv_lang["bosa_14"] 					= "cicit perempuan dari cucu laki-laki dari anak perempuan";		   // daughter's daughter's son
$pgv_lang["bosa_15"] 					= "cicit perempuan dari cucu laki-laki dari anak perempuan";   // daughter's daughter's daughter
// for the general case of offspring of the nth generation use the text below
// in this text %1\$d is replaced with the number of generations
//              %2\$d is replaced with the number of generations - 1
//              %3\$d is replaced with the number of generations - 2
$pgv_lang["n_x_grandson_from_son"]	  		= "cicit laki-laki %3\$d x";
$pgv_lang["n_x_granddaughter_from_son"]			= "cicit perempuan %3\$d x";
$pgv_lang["n_x_grandson_from_daughter"]	  		= "cicit laki-laki %3\$d x";
$pgv_lang["n_x_granddaughter_from_daughter"]		= "cicit perempuan %3\$d x";

// the sosa_uncle name is used for uncles - the names below can be extended to any number
// of generations just by adding more translations.
// to allow fo language variations we specify different relationships for paternal and maternal
// aunts and uncles
// 1st generation
$pgv_lang["sosa_uncle_2"] 				= "paman";            // father's brother
$pgv_lang["sosa_uncle_3"] 				= "paman";            // mother's brother
// 2nd generation
$pgv_lang["sosa_uncle_4"] 				= "paman kakek";      // fathers's father's brother
$pgv_lang["sosa_uncle_5"] 				= "paman kakek";      // father's mother's brother
$pgv_lang["sosa_uncle_6"] 				= "paman nenek";      // mother's father's brother
$pgv_lang["sosa_uncle_7"] 				= "paman nenek";      // mother's mother's brother
// for the general case of uncles of the nth degree use the text below
// in this text %1\$d is replaced with the number of generations
//              %2\$d is replaced with the number of generations - 1
//              %3\$d is replaced with the number of generations - 2
$pgv_lang["n_x_paternal_uncle"]				= "paman kakek %2\$d x";
$pgv_lang["n_x_maternal_uncle"]	    			= "paman nenek %2\$d x";

// the sosa_aunt name is used for aunts - the names below can be extended to any number
// of generations just by adding more translations.
// to allow fo language variations we specify different relationships for paternal and maternal
// aunts and aunts
// 1st generation
$pgv_lang["sosa_aunt_2"] 				= "bibi";            // father's sister
$pgv_lang["sosa_aunt_3"] 				= "bibi";            // mother's sister
// 2nd generation
$pgv_lang["sosa_aunt_4"] 				= "bibi kakek";      // fathers's father's sister
$pgv_lang["sosa_aunt_5"] 				= "bibi kakek";      // father's mother's sister
$pgv_lang["sosa_aunt_6"] 				= "bibi nenek";      // mother's father's sister
$pgv_lang["sosa_aunt_7"] 				= "bibi nenek";      // mother's mother's sister
// for the general case of aunts of the nth degree use the text below
// in this text %1\$d is replaced with the number of generations
//              %2\$d is replaced with the number of generations - 1
//              %3\$d is replaced with the number of generations - 2
$pgv_lang["n_x_paternal_aunt"]				= "bibi kakek %2\$d x";
$pgv_lang["n_x_maternal_aunt"]	    			= "bibi nenek %2\$d x";

// the sosa_uncle name is used for uncles(by marriage) - the names below can be extended to any number
// of generations just by adding more translations.
// to allow fo language variations we specify different relationships for paternal and maternal
// aunts and uncles
// 1st generation
$pgv_lang["sosa_uncle_bm_2"] 				= "paman";            // father's brother
$pgv_lang["sosa_uncle_bm_3"] 				= "paman";            // mother's brother
// 2nd generation
$pgv_lang["sosa_uncle_bm_4"] 				= "paman kakek";      // fathers's father's brother
$pgv_lang["sosa_uncle_bm_5"] 				= "paman kakek";      // father's mother's brother
$pgv_lang["sosa_uncle_bm_6"] 				= "paman nenek";      // mother's father's brother
$pgv_lang["sosa_uncle_bm_7"] 				= "paman nenek";      // mother's mother's brother
// for the general case of uncles of the nth degree use the text below
// in this text %1\$d is replaced with the number of generations
//              %2\$d is replaced with the number of generations - 1
//              %3\$d is replaced with the number of generations - 2
$pgv_lang["n_x_paternal_uncle_bm"]			= "paman kakek %2\$d x";
$pgv_lang["n_x_maternal_uncle_bm"]	    		= "paman nenek %2\$d x";

// the sosa_aunt name is used for aunts (by marriage)- the names below can be extended to any number
// of generations just by adding more translations.
// to allow fo language variations we specify different relationships for paternal and maternal
// aunts and aunts
// 1st generation
$pgv_lang["sosa_aunt_bm_2"] 				= "bibi";            // father's sister
$pgv_lang["sosa_aunt_bm_3"] 				= "bibi";            // mother's sister
// 2nd generation
$pgv_lang["sosa_aunt_bm_4"] 				= "bibi kakek";      // fathers's father's sister
$pgv_lang["sosa_aunt_bm_5"] 				= "bibi kakek";      // father's mother's sister
$pgv_lang["sosa_aunt_bm_6"] 				= "bibi nenek";      // mother's father's sister
$pgv_lang["sosa_aunt_bm_7"] 				= "bibi nenek";      // mother's mother's sister
// for the general case of aunts of the nth degree use the text below
// in this text %1\$d is replaced with the number of generations
//              %2\$d is replaced with the number of generations - 1
//              %3\$d is replaced with the number of generations - 2
$pgv_lang["n_x_paternal_aunt_bm"]			= "bibi kakek %2\$d x ";
$pgv_lang["n_x_maternal_aunt_bm"]	   		= "bibi nenek %2\$d x";

// if a specific cousin relationship cannot be represented in a language translate as "";
$pgv_lang["male_cousin_1"]              	= "sepupu laki-laki sekali";
$pgv_lang["male_cousin_2"]              	= "sepupu laki-laki dua kali";
$pgv_lang["male_cousin_3"]              	= "sepupu laki-laki tiga kali";
$pgv_lang["male_cousin_4"]              	= "sepupu laki-laki empat kali";
$pgv_lang["male_cousin_5"]              	= "sepupu laki-laki lima kali";
$pgv_lang["male_cousin_6"]              	= "sepupu laki-laki enam kali";
$pgv_lang["male_cousin_7"]              	= "sepupu laki-laki tujuh kali";
$pgv_lang["male_cousin_8"]              	= "sepupu laki-laki depalan kali";
$pgv_lang["male_cousin_9"]              	= "sepupu laki-laki sembilan kali";
$pgv_lang["male_cousin_10"]             	= "sepupu laki-laki sepuluh kali";
$pgv_lang["male_cousin_11"]             	= "sepupu laki-laki sebelas kali";
$pgv_lang["male_cousin_12"]             	= "sepupu laki-laki duabelas kali";
$pgv_lang["male_cousin_13"]             	= "sepupu laki-laki tigabelas kali";
$pgv_lang["male_cousin_14"]             	= "sepupu laki-laki empatbelas kali";
$pgv_lang["male_cousin_15"]             	= "sepupu laki-laki lima belas kali";
$pgv_lang["male_cousin_16"]             	= "sepupu laki-laki enambelas kali";
$pgv_lang["male_cousin_17"]             	= "sepupu laki-laki tujuhbelas kali";
$pgv_lang["male_cousin_18"]             	= "sepupu laki-laki delapanbelas kali";
$pgv_lang["male_cousin_19"]             	= "sepupu laki-laki sembilanbelas kali";
$pgv_lang["male_cousin_20"]             	= "sepupu laki-laki duapuluh kali";
$pgv_lang["male_cousin_n"]              	= "sepupu laki-laki %d x";
$pgv_lang["female_cousin_1"]            	= "sepupu perempuan sekali";
$pgv_lang["female_cousin_2"]            	= "sepupu perempuan dua kali";
$pgv_lang["female_cousin_3"]            	= "sepupu perempuan tiga kali";
$pgv_lang["female_cousin_4"]            	= "sepupu perempuan empat kali";
$pgv_lang["female_cousin_5"]           		= "sepupu perempuan lima kali";
$pgv_lang["female_cousin_6"]            	= "sepupu perempuan enam kali";
$pgv_lang["female_cousin_7"]            	= "sepupu perempuan tujuh kali";
$pgv_lang["female_cousin_8"]            	= "sepupu perempuan depalan kali";
$pgv_lang["female_cousin_9"]            	= "sepupu perempuan sembilan kali";
$pgv_lang["female_cousin_10"]           	= "sepupu perempuan sepuluh kali";
$pgv_lang["female_cousin_11"]           	= "sepupu perempuan sebelas kali";
$pgv_lang["female_cousin_12"]           	= "sepupu perempuan duabelas kali";
$pgv_lang["female_cousin_13"]           	= "sepupu perempuan tigabelas kali";
$pgv_lang["female_cousin_14"]           	= "sepupu perempuan empatbelas kali";
$pgv_lang["female_cousin_15"]           	= "sepupu perempuan lima belas kali";
$pgv_lang["female_cousin_16"]           	= "sepupu perempuan enambelas kali";
$pgv_lang["female_cousin_17"]           	= "sepupu perempuan tujuhbelas kali";;
$pgv_lang["female_cousin_18"]           	= "sepupu perempuan delapanbelas kali";
$pgv_lang["female_cousin_19"]           	= "sepupu perempuan sembilanbelas kali";
$pgv_lang["female_cousin_20"]           	= "sepupu perempuan duapuluh kali";
$pgv_lang["female_cousin_n"]            	= "sepupu perempuan %d x";

// Only referenced from english specific functions
$pgv_lang["removed_ascending_1"]   		= " once removed ascending";
$pgv_lang["removed_ascending_2"]   		= " twice removed ascending";
$pgv_lang["removed_ascending_3"]   		= " three times removed ascending";
$pgv_lang["removed_ascending_4"]   		= " four times removed ascending";
$pgv_lang["removed_ascending_5"]   		= " five times removed ascending";
$pgv_lang["removed_ascending_6"]   		= " six times removed ascending";
$pgv_lang["removed_ascending_7"]   		= " seven times removed ascending";
$pgv_lang["removed_ascending_8"]   		= " eight times removed ascending";
$pgv_lang["removed_ascending_9"]   		= " nine times removed ascending";
$pgv_lang["removed_ascending_10"]  		= " ten times removed ascending";
$pgv_lang["removed_ascending_11"]  		= " eleven times removed ascending";
$pgv_lang["removed_ascending_12"]  		= " twelve times removed ascending";
$pgv_lang["removed_ascending_13"]  		= " thirteen times removed ascending";
$pgv_lang["removed_ascending_14"]  		= " fourteen times removed ascending";
$pgv_lang["removed_ascending_15"]  		= " fifteen times removed ascending";
$pgv_lang["removed_ascending_16"]  		= " sixteen times removed ascending";
$pgv_lang["removed_ascending_17"]  		= " seventeen times removed ascending";
$pgv_lang["removed_ascending_18"]  		= " eighteen times removed ascending";
$pgv_lang["removed_ascending_19"]  		= " nineteen times removed ascending";
$pgv_lang["removed_ascending_20"]  		= " twenty times removed ascending";
$pgv_lang["removed_descending_1"]  		= " once removed descending";
$pgv_lang["removed_descending_2"]  		= " twice removed descending";
$pgv_lang["removed_descending_3"]  		= " three times removed descending";
$pgv_lang["removed_descending_4"]  		= " four times removed descending";
$pgv_lang["removed_descending_5"]  		= " five times removed descending";
$pgv_lang["removed_descending_6"]  		= " six times removed descending";
$pgv_lang["removed_descending_7"]  		= " seven times removed descending";
$pgv_lang["removed_descending_8"]  		= " eight times removed descending";
$pgv_lang["removed_descending_9"]  		= " nine times removed descending";
$pgv_lang["removed_descending_10"] 		= " ten times removed descending";
$pgv_lang["removed_descending_11"] 		= " eleven times removed descending";
$pgv_lang["removed_descending_12"] 		= " twelve times removed descending";
$pgv_lang["removed_descending_13"] 		= " thirteen times removed descending";
$pgv_lang["removed_descending_14"] 		= " fourteen times removed descending";
$pgv_lang["removed_descending_15"] 		= " fifteen times removed descending";
$pgv_lang["removed_descending_16"] 		= " sixteen times removed descending";
$pgv_lang["removed_descending_17"]		= " seventeen times removed descending";
$pgv_lang["removed_descending_18"] 		= " eighteen times removed descending";
$pgv_lang["removed_descending_19"] 		= " nineteen times removed descending";
$pgv_lang["removed_descending_20"] 		= " twenty times removed descending";

//-- GEDCOM edit utility
$pgv_lang["check_delete"]			= "Apakah Anda yakin ingin menghapus fakta GEDCOM ini?";
$pgv_lang["access_denied"]			= "<b>Akses Tertolak</b><br />Anda tidak mempunyai akses ke sumberdaya ini.";
$pgv_lang["changes_exist"]			= "Perubahan telah dibuat pada GEDCOM ini.";
$pgv_lang["find_place"] 			= "Cari Tempat";
$pgv_lang["close_window"]			= "Tutup Jendela";
$pgv_lang["close_window_without_refresh"]	= "Tutup Jendela Tanpa Memuatkembali";
$pgv_lang["place_contains"] 			= "Tempat mengandung:";
$pgv_lang["add"]				= "Tambahkan";
$pgv_lang["custom_event"]			= "Peristiwa Pilihan";
$pgv_lang["delete_person"]			= "Hapus individu ini";
$pgv_lang["confirm_delete_person"]		= "Apakah Anda yakin ingin menghapus orang ini dari berkas GEDCOM?";
$pgv_lang["find_media"] 			= "Cari Media";
$pgv_lang["set_link"]				= "Tetapkan kaitan";
$pgv_lang["delete_source"]			= "Hapus Sumber ini";
$pgv_lang["confirm_delete_source"]		= "Apakah Anda yakin ingin menghapus Sumber ini dari berkas GEDCOM?";
$pgv_lang["find_family"]			= "Cari Keluarga";
$pgv_lang["find_fam_list"]			= "Cari Daftar Keluarga";
$pgv_lang["edit_name"]				= "Sunting Nama";
$pgv_lang["delete_name"]			= "Hapus Nama";
$pgv_lang["select_date"]			= "Pilih tanggal";
$pgv_lang["user_cannot_edit"]			= "Nama pengguna ini tidak dapat menyunting GEDCOM ini.";
$pgv_lang["ged_noshow"]				= "Halaman ini dinonaktifkan oleh administrator situs.";

//-- calendar.php messages
$pgv_lang["bdm"]				= "Lahir, Wafat, Nikah";
$pgv_lang["on_this_day"]			= "Pada Hari Ini ...";
$pgv_lang["in_this_month"]			= "Pada Bulan Ini ...";
$pgv_lang["in_this_year"]			= "Pada Tahun Ini ...";
$pgv_lang["year_anniversary"]			= "Ulangtahun #year_var#";
$pgv_lang["today"]				= "Hari ini";
$pgv_lang["day"]				= "Hari:";
$pgv_lang["month"]				= "Bulan:";
$pgv_lang["showcal"]				= "Perlihatkan peristiwa:";
$pgv_lang["anniversary"]			= "Ulangtahun";
$pgv_lang["anniversary_calendar"]		= "Kalender Ulangtahun";
$pgv_lang["sunday"] 				= "Ahad";
$pgv_lang["monday"] 				= "Senin";
$pgv_lang["tuesday"]				= "Selasa";
$pgv_lang["wednesday"]				= "Rabu";
$pgv_lang["thursday"]				= "Kamis";
$pgv_lang["friday"] 				= "Jumat";
$pgv_lang["saturday"]				= "Sabtu";
$pgv_lang["viewday"]				= "Tampilkan Hari";
$pgv_lang["viewmonth"]				= "Tampilkan Bulan";
$pgv_lang["viewyear"]				= "Tampilkan Tahun";
$pgv_lang["all_people"] 			= "Semua Orang";
$pgv_lang["living_only"]			= "Orang yang Hidup";
$pgv_lang["recent_events"]			= "Tahun Belakangan (&lt; 100 tahun)";
$pgv_lang["day_not_set"]			= "Hari tidak ditetapkan";

//-- user self registration module
$pgv_lang["lost_password"]			= "Kehilangan sandi Anda?";
$pgv_lang["requestpassword"]			= "Minta sandi baru";
$pgv_lang["no_account_yet"] 			= "Tidak ada akun?";
$pgv_lang["requestaccount"] 			= "Minta akun pengguna baru";
$pgv_lang["emailadress"]			= "Alamat Email";
$pgv_lang["mandatory"] 				= "Isian yang ditandai dengan * adalah wajib.";
$pgv_lang["mail01_line01"]			= "Halo #user_fullname# ...";
$pgv_lang["mail01_line02"]			= "Permintaan diterima di #SERVER_NAME# untuk membuat akun PhpGedView dengan alamat email Anda #user_email#.";
$pgv_lang["mail01_line03"]			= "Informasi tentang permintaan diperlihatkan dibawah pranala di bawah.";
$pgv_lang["mail01_line04"]			= "Silakan klik pada pranala berikut dan isilah data yang diminta untuk mengonfirmasikan permintaan dan alamat email Anda.";
$pgv_lang["mail01_line05"]			= "Jika Anda tidak meminta akun, Anda dapat menghapus pesan ini.";
$pgv_lang["mail01_line06"]			= "Anda tidak akan mendapat email lagi dari situs ini, karena permintaan akun akan dihapus secara otomatis setelah tujuh hari.";
$pgv_lang["mail01_subject"] 			= "Pendaftaran Anda di #SERVER_NAME#";

$pgv_lang["mail02_line01"]			= "Halo Administrator ...";
$pgv_lang["mail02_line02"]			= "Pengguna prospektif mengdaftarkan dirinya dengan PhpGedView di #SERVER_NAME#.";
$pgv_lang["mail02_line03"]			= "Pengguna menerima email dengan informasi yang diperlukan untuk mengonfirmasi permintaan aksesnya.";
$pgv_lang["mail02_line04"]			= "Anda akan diberitahu lewat email saat pengguna prospektif ini telah mengonfirmasikan permintaannya. Anda kemudian dapat menyempurnakan proses dengan mengaktifkan nama penggunanya. Pengguna baru tidak akan dapat masuk log hingga Anda mengaktifkan akunnya.";
$pgv_lang["mail02_line04a"]			= "You will be informed by email when this prospective user has confirmed his request. After this, the user will be able to login without any action on your part.";
$pgv_lang["mail02_subject"] 			= "Pendaftaraan baru di #SERVER_NAME#";

$pgv_lang["hashcode"]				= "Kode verifikasi:";
$pgv_lang["thankyou"]				= "Halo #user_fullname# ...<br />Terima kasih atas pendaftaran Anda.";
$pgv_lang["pls_note06"] 			= "Sekarang Kami akan mengirim email konfirmasi ke alamat <b>#user_email#</b>. Anda harus memverifikasi permintaan akun Anda dengan mengikuti petunjuk pada email konfirmasi. Jika Anda tidak mengonfirmasi permintaan akun Anda selama tujuh hari, pengajuan Anda otomatis akan ditolak. Anda harus mengajukan lagi.<br /><br />Setelah Anda mengikuti petunjuk di email konfirmasi, administrator masih harus menyetujui permintaan Anda sebelum akun Anda dapat digunakan.<br /><br />Untuk masuk log ke situs ini, Anda harus mengetahui nama pengguna dan sandi Anda.<br /><br />";
$pgv_lang["pls_note06a"] 			= "Sekarang Kami akan mengirim email konfirmasi ke alamat <b>#user_email#</b>. Anda harus memverifikasi permintaan akun Anda dengan mengikuti petunjuk pada email konfirmasi. Jika Anda tidak mengonfirmasi permintaan akun Anda selama tujuh hari, pengajuan Anda otomatis akan ditolak. Anda harus mengajukan lagi.<br /><br />Setelah Anda mengikuti petunjuk di email konfirmasi, Anda dapat masuk log. Untuk masuk log situs ini, Anda harus mengetahui nama pengguna dan sandi Anda.<br /><br />";

$pgv_lang["registernew"]			= "Konfirmasi Akun Baru";
$pgv_lang["user_verify"]			= "Verifikasi pengguna";
$pgv_lang["send"]					= "Kirim";

$pgv_lang["pls_note07"] 			= "~#pgv_lang[user_verify]#~<br /><br />Untuk mengonfirmasi permintaan akun Anda, silakan ketik nama pengguna, sandi, dan kode verifikasi yang Anda terima lewat email.";
$pgv_lang["pls_note08"] 			= "Data untuk pengguna <b>#user_name#</b> telah diperiksa.";

$pgv_lang["mail03_line01"]			= "Halo Administrator ...";
$pgv_lang["mail03_line02"]			= "Pengguna #newuser[username]# (#newuser[fullname]#) telah mengonfirmasikan permintaannya untuk sebuah akun.";
$pgv_lang["mail03_line03"]			= "Silakan klik pada pranala di bawah untuk masuk log ke situs Anda. Anda harus menyunting pengguna untuk mengaktifkan akunnya sehingga ia dapat masuk log ke situs Anda.";
$pgv_lang["mail03_line03a"]			= "Anda tidak harus mengambil tindakan apapun; pengguna sekarang dapat masuk log.";
$pgv_lang["mail03_subject"] 			= "Pengguna baru di #SERVER_NAME#";

$pgv_lang["pls_note09"] 			= "Anda telah mengkonfirmasikan permintaan Anda menjadi pengguna terdaftar.";
$pgv_lang["pls_note10"] 			= "Administrator telah diberitahu. Setelah ia memberi Anda izin untuk masuk log, Anda dapat masuk log dengan nama pengguna dan sandi Anda.";
$pgv_lang["pls_note10a"]			= "Sekarang Anda dapat masuk log dengan nama pengguna dan sandi Anda.";
$pgv_lang["data_incorrect"] 			= "Data tidak benar, silakan coba lagi";
$pgv_lang["user_not_found"] 			= "Tidak dapat memverifikasi informasi yang Anda masukkan. Silakan coba lagi atau hubungi administrator situs untuk informasi lebih lanjut.";

$pgv_lang["lost_pw_reset"]			= "Permintaan kehilangan sandi";
$pgv_lang["pls_note11"] 			= "Untuk mengembalikan sandi Anda, masukkan nama pengguna Anda.<br /><br />Kami akan menjawab dengan mengirimi Anda email ke alamat yang terdaftar bersama akun Anda. Email tersebut akan mengandung URL dan kode konfirmasi untuk akun Anda. Saat mengunjungi URL ini, Anda dapat mengubah sandi Anda dan masuk log situs ini. Untuk alasan keamanan, Anda sebaiknya tidak memberikan kode informasi ini ke siapapun.<br /><br />Jika Anda memerlukan dampingan administrator situs, silakan gunakan pranala kontak di bawah.";

$pgv_lang["mail04_line01"]			= "Halo #user_fullname# ...";
$pgv_lang["mail04_line02"]			= "Sandi baru telah diminta untuk nama pengguna Anda.";
$pgv_lang["mail04_line03"]			= "Rekomendasi:";
$pgv_lang["mail04_line04"]			= "Silakan klik pada pranala di bawah atau temaple pada perambah Anda, catatmasuk dengan sandi yang baru, dan segera ganti untuk menjaga integritas keamanan data Anda.";
$pgv_lang["mail04_line05"]			= "Setelah Anda masuk log, pilih pranala «#pgv_lang[editowndata]#» di bawah menu «#pgv_lang[mygedview]#» dan isilah isian sandi untuk mengubah sandi Anda.";
$pgv_lang["mail04_subject"] 			= "Permintaan data di #SERVER_NAME#";

$pgv_lang["pwreqinfo"]				= "Halo...<br /><br />Email dengan sandi baru Anda telah terkirim ke alamat yang kami miliki pada berkas untuk <b>#user[email]#</b>.<br /><br />Silakan periksa akun email Anda; Anda seharusnya segera menerima pesan kami.<br /><br />Rekomendasi:<br />Anda sebaiknya masuk log ke situs ini dengan sandi baru Anda secepat mungkin, dan Anda sebaiknya mengubah sandi Anda untuk mempertahankam keamanan data Anda.";

$pgv_lang["myuserdata"] 			= "Akun Saya";
$pgv_lang["user_theme"] 			= "Tema Saya";
$pgv_lang["mgv"]				= "GedViewSaya";
$pgv_lang["mygedview"]				= "Portal GedViewSaya";
$pgv_lang["passwordlength"] 			= "Sandi harus mengandung setidaknya 6 karakter.";
$pgv_lang["welcome_text_auth_mode_1"]		= "<center><b>Selamat datang di Situsweb genealogi ini</b></center><br />Akses ke situs ini diizinkan bagi setiap pengunjung yang mempunyai akun pengguna.<br /><br />Jika Anda memiliki akun pengguna, Anda dapat masuk log pada halaman ini. Jika Anda tidak mempunyai akun pengguna, Anda dapat mengajukan satu dengan mengklik pranala yang bersesuaian di bawah.<br /><br />Setelah memverifikasi pengajuan Anda, administrator situs akan mengaktifkan akun Anda. Anda akan menerima email saat pengajuan Anda diterima.";
$pgv_lang["welcome_text_auth_mode_2"]		= "<center><b>Selamat datang di Situsweb genealogi ini</b></center><br />Akses ke situs ini hanya diizinkan bagi <u>pengguna terotorisasi</u> saja.<br /><br />Jika Anda memiliki akun pengguna, Anda dapat masuk log pada halaman ini. Jika Anda tidak mempunyai akun pengguna, Anda dapat mengajukan satu dengan mengklik pranala yang bersesuaian di bawah.<br /><br />Setelah memverifikasi informasi Anda, administrator akan menerima atau menolak pengajuan akun Anda. Anda akan menerima pesan email saat pengajuan Anda diterima.";
$pgv_lang["welcome_text_auth_mode_3"]		= "<center><b>Selamat datang di Situsweb genealogi ini</b></center><br />Akses ke situs ini hanya diizinkan bagi <u>anggota keluarga</u> saja.<br /><br />Jika Anda memiliki akun pengguna, Anda dapat masuk log pada halaman ini. Jika Anda tidak mempunyai akun pengguna, Anda dapat mengajukan satu dengan mengklik pranala yang bersesuaian di bawah.<br /><br />Setelah memverifikasi informasi yang Anda sediakan, administrator akan menerima atau menolak permintaan akun Anda. Anda akan menerima email saat permintaan Anda diterima.";
$pgv_lang["welcome_text_cust_head"] 		= "<center><b>Selamat datang di Situsweb genealogi ini</b></center><br />Akses diizinkan bagi pengguna yang mempunyai akun dan sandi untuk situsweb ini.<br />";
$pgv_lang["acceptable_use"]			= "<div class=\"largeError\">Perhatian:</div><div class=\"error\">Dengan melengkapi dan mengirim formulir ini, Anda setuju:<ul><li>untuk melindungi privasi orang yang hidup yang terdaftar di situs kami;</li><li>dan isilah kotak teks di bawah, untuk menjelaskan kepada siapa Anda terhubung, atau menyediakan kami informasi tentang seseorang yang sebaiknya terdaftar pada situs kami.</li></ul></div>";


//-- mygedview page
$pgv_lang["upcoming_events"]			= "Peristiwa Akan Datang";
$pgv_lang["living_or_all"]			= "Hanya perlihatkan peristiwa orang-hidup?";
$pgv_lang["basic_or_all"]			= "Hanya perlihatkan Kelahiran, Kematian, dan Pernikahan?";
$pgv_lang["style"]				= "Gaya Presentasi";
$pgv_lang["style1"]				= "Daftar";
$pgv_lang["style2"]				= "Tabel";
$pgv_lang["style3"]				= "Tagcloud";
$pgv_lang["cal_download"]			= "Izinkan unduh peristiwa kalender?";
$pgv_lang["no_events_living"]			= "Tidak ada peristiwa orang-hidup selama #pgv_lang[global_num1]# hari berikutnya.";
$pgv_lang["no_events_living1"]			= "Tidak ada peristiwa orang-hidup untuk besok.";
$pgv_lang["no_events_all"]			= "Tidak ada peristiwa selama #pgv_lang[global_num1]# hari berikutnya.";
$pgv_lang["no_events_all1"]			= "Tidak ada peristiwa untuk besok.";
$pgv_lang["no_events_privacy"]			= "Ada peristiwa untuk #pgv_lang[global_num1]# hari berikutnya, namun batasan pribadi mencegah Anda melihatnya.";
$pgv_lang["no_events_privacy1"]			= "Events exist for tomorrow, but privacy restrictions prevent you from seeing them.";
$pgv_lang["more_events_privacy"]		= "<br />Ada peristiwa lagi untuk #pgv_lang[global_num1]# hari berikutnya, namun batasan pribadi mencegah Anda melihatnya.";
$pgv_lang["more_events_privacy1"]		= "<br />Ada peristiwa lagi untuk besok, namun batasan pribadi mencegah Anda melihatnya.";
$pgv_lang["none_today_living"]			= "Tidak ada peristiwa orang-hidup untuk hari ini.";
$pgv_lang["none_today_all"]			= "Tidak ada peristiwa untuk hari ini.";
$pgv_lang["none_today_privacy"]			= "Ada peristiwa untuk hari ini, namun batasan pribadi mencegah Anda melihatnya.";
$pgv_lang["more_today_privacy"]			= "<br />Ada peristiwa lagi untuk hari ini, namun batasan pribadi mencegah Anda melihatnya.";
$pgv_lang["chat"]				= "Chat";
$pgv_lang["users_logged_in"]			= "Pengguna yang masuk log";
$pgv_lang["anon_user"]				= "1 pengguna masuk log secara anonim";
$pgv_lang["anon_users"]				= "#pgv_lang[global_num1]# pengguna  masuk log secara anonim";
$pgv_lang["login_user"]				= "1 pengguna masuk log";
$pgv_lang["login_users"]			= "#pgv_lang[global_num1]# pengguna masuk log";
$pgv_lang["no_login_users"]			= "Tidak ada pengguna yang masuk log maupun anonim";
$pgv_lang["message"]				= "Kirim Pesan";
$pgv_lang["my_messages"]			= "Pesan Saya";
$pgv_lang["date_created"]			= "Tanggal Pengiriman:";
$pgv_lang["message_from"]			= "Alamat Email:";
$pgv_lang["message_from_name"]			= "Nama Anda:";
$pgv_lang["message_to"] 			= "Pesan Kepada:";
$pgv_lang["message_subject"]			= "Perihal:";
$pgv_lang["message_body"]			= "Isi Surat:";
$pgv_lang["no_to_user"] 			= "Tidak ada pengguna penerima yang tersedia. Tidak dapat melanjutkan.";
$pgv_lang["provide_email"]			= "Silakan sediakan alamat email sehingga kami dapat menghubungi Anda sebagai jawaban pesan ini. Jika Anda tidak menyediakan alamat email Anda, Kami tidak akan dapat menjawab pertanyaan Anda. Alamat email Anda tidak akan digunakan untuk keperluan lain di samping menjawab pertanyaan ini.";
$pgv_lang["reply"]				= "Balas";
$pgv_lang["message_deleted"]			= "Pesan Dihapus";
$pgv_lang["message_sent"]			= "Pesan berhasil dikirim ke #TO_USER#";
$pgv_lang["reset"]				= "Kembalikan";
$pgv_lang["site_default"]			= "Default Situs";
$pgv_lang["mygedview_desc"] 			= "Halaman GedViewSaya Anda membolehkan Anda menyimpan pembatasbuku dari orang favorit Anda, melacak peristiwa yang akan datang, dan berkolaborasi dengan pengguna PhpGedView yang lain.";
$pgv_lang["no_messages"]			= "Anda tidak mempunyai pesan tertunda.";
$pgv_lang["clicking_ok"]			= "Saat Anda mengklik Oke, jendela lain akan terbuka dan Anda dapat menghubungi #user[fullname]#";
$pgv_lang["favorites"]				= "Favorit";
$pgv_lang["my_favorites"]			= "Favorit Saya";
$pgv_lang["no_favorites"]			= "Anda belum memilih favorit apapun.<br /><br />Untuk menambah individu, keluarga, atau sumber ke favorit Anda, klik pada pranala <b>#pgv_lang[add_favorite]#</b> untuk menampilkan beberapa isian di mana Anda dapat memasukkan atau mencari nomor ID. Selain nomor ID, Anda dapat memasukkan URL atau judul.";
$pgv_lang["add_to_my_favorites"]		= "Tambahkan ke Favorit Saya";
$pgv_lang["gedcom_favorites"]			= "Favorit GEDCOM Ini";
$pgv_lang["no_gedcom_favorites"]		= "Saat ini tidak ada Favorit terpilih.	Admin dapat menambah Favorit untuk ditampilkan saat permulaan.";
$pgv_lang["confirm_fav_remove"] 		= "Apakah Anda yakin ingin membuang item ini dari daftar Favorit Anda?";
$pgv_lang["invalid_email"]			= "Silakan masukkan alamat email yang benar.";
$pgv_lang["enter_subject"]			= "Silakan masukkan perihal pesan.";
$pgv_lang["enter_body"] 			= "Silakan masukkan beberapa teks pesan sebelum mengirim.";
$pgv_lang["confirm_message_delete"] 		= "Apakah Anda yakin ingin menghapus pesan ini? Ia tidak dapat diambil kemudian.";
$pgv_lang["message_email1"] 			= "Pesan berikut telah terkirim ke akun pengguna PhpGedView Anda dari ";
$pgv_lang["message_email2"] 			= "Anda telah mengirim pesan berikut ke pengguna PhpGedView:";
$pgv_lang["message_email3"] 			= "Anda telah mengirim pesan berikut ke administrator  PhpGedView:";
$pgv_lang["viewing_url"]			= "Pesan ini telah terkirim saat menampilkan URL berikut: ";
$pgv_lang["messaging2_help"]			= "Saat Anda mengirim pesan ini, Anda akan menerima salinan yang dikirim lewat email ke alamat yang Anda sediakan.";
$pgv_lang["random_picture"] 			= "Gambar Acak";
$pgv_lang["message_instructions"]		= "<b>Untuk Diperhatikan:</b> Informasi pribadi individu yang hidup hanya akan diberikan kepada kerabat keluarga dan teman dekat. Anda akan diminta untuk memverifikasi hubungan Anda sebelum Anda menerima data pribadi apapun. Kadangkala informasi orang yang meninggal dapat juga bersifat pribadi. Jika ini masalahnya, hal ini karena tidak ada cukup informasi mengenai orang tersebut untuk menentukan apakah ia hidup atau tidak, dan kami mungkin tidak mempunyai informasi lebih lanjut tentang orang ini.<br /><br />Sebelum mengajukan pertanyaan, pastikan bahwa Anda menanyakan tentang orang yang benar dengan memeriksa tanggal, tempat, dan kerabat dekat. Jika Anda mengirimkan perubahan  terhadap data genealogis, silakan menyebutkan sumber Anda mendapatkan data.<br /><br />";
$pgv_lang["sending_to"] 			= "Pesan ini akan dikirim ke #TO_USER#";
$pgv_lang["preferred_lang"] 			= "Pengguna ini memilih untuk menerima pesan dalam #USERLANG#";
$pgv_lang["gedcom_created_using"]		= "GEDCOM ini dibuat menggunakan <b>#CREATED_SOFTWARE# #CREATED_VERSION#</b>";
$pgv_lang["gedcom_created_on"]			= "GEDCOM ini dibuat pada <b>#CREATED_DATE#</b>";
$pgv_lang["gedcom_created_on2"] 		= " pada <b>#CREATED_DATE#</b>";
$pgv_lang["gedcom_stats"]			= "Statistik GEDCOM";
$pgv_lang["stat_individuals"]			= "Individu";
$pgv_lang["stat_families"]			= "Keluarga";
$pgv_lang["stat_sources"]			= "Sumber";
$pgv_lang["stat_other"] 			= "Rekaman Lain";
$pgv_lang["stat_earliest_birth"] 		= "Tahun Lahir Terawal";
$pgv_lang["stat_latest_birth"] 			= "Tahun Lahir Terakhir";
$pgv_lang["stat_earliest_death"] 		= "Tahun Wafat Terawal";
$pgv_lang["stat_latest_death"] 			= "Tahun Wafat Terakhir";
$pgv_lang["customize_page"] 			= "Atur Portal GedViewSaya";
$pgv_lang["customize_gedcom_page"]		= "Atur Halaman-depan-GEDCOM ini";
$pgv_lang["upcoming_events_block"]		= "Peristiwa yang Akan Datang";
$pgv_lang["upcoming_events_descr"]		= "Blok Peristiwa yang Akan Datang memperlihatkan ulangtahun peristiwa yang akan terjadi dalam waktu dekat. Anda dapat mengatur jumlah rincian yang diperlihatkan, dan Administrator dapat mengatur sejauh mana blok ini akan melihat.";
$pgv_lang["todays_events_block"]		= "Pada Hari Ini";
$pgv_lang["todays_events_descr"]		= "Blok Pada Hari Ini, pada Sejarah Anda... memperlihatkan shows ulangtahun peristiwa untuk hari ini. Anda dapat mengatur jumlah rincian yang diperlihatkan.";
$pgv_lang["todo_block"]				= "&quot;Tugas&quot; untuk dilakukan";
$pgv_lang["todo_descr"]				= "Blok Untuk Dilakukan mendaftar semua fakta _TODO yang luarbiasa di basisdata.";
$pgv_lang["todo_show_other"]     		= "Perlihatkan tugas pengguna lain";
$pgv_lang["todo_show_unassigned"]		= "Perlihatkan tugas yang tidak dikerjakan";
$pgv_lang["todo_show_future"]    		= "Perlihatkan tugas di masa yang akan datang";
$pgv_lang["todo_nothing"]        		= "Tidak ada &quot;To Do&quot; tuga.";
$pgv_lang["yahrzeit_block"]			= "Yahrzeiten yang Akan Datang";
$pgv_lang["yahrzeit_descr"]			= "Blok Yahrzeiten yang Akan Datang memperlihatkan ulangtahun tanggal kematian yang akan terjadi di waktu dekat. Anda dapat mengatur periode yang diperlihatkan, dan Administrator dapat mengatur sejauh mana blok ini akan melihat.";
$pgv_lang["logged_in_users_block"]		= "Pengguna yang masuk log";
$pgv_lang["logged_in_users_descr"]		= "Blok Pengguna yang masuk log memperlihatkan daftar pengguna yang sedang masuk log.";
$pgv_lang["user_messages_block"]		= "Pesan Pengguna";
$pgv_lang["user_messages_descr"]		= "Blok Pesan Pengguna memperlihatkan daftar pesan terkirim ke pengguna aktif.";
$pgv_lang["user_favorites_block"]		= "Favorit Pengguna";
$pgv_lang["user_favorites_descr"]		= "Blok Favorit Pengguna memperlihatkan kepada pengguna daftar orang favoritnya di basisdata sehingga ia dapat dengan mudah menuju kepadanya.";
$pgv_lang["welcome_block"]			= "Sambutan Pengguna";
$pgv_lang["welcome_descr"]			= "Blok Sambutan Pengguna memperlihatkan kepada pengguna tanggal dan waktu terkini, pranala cepat untuk mengubah akunnya atau menuju Bagan Kerabatnya, dan pranala untuk mengatur halaman Portal GedViewSaya-nya.";
$pgv_lang["random_media_block"] 		= "Media Acak";
$pgv_lang["random_media_descr"] 		= "Blok Media Acak memilih acak foto atau item media lain dari basisdata yang sedang aktif dan menampilkannya ke pengguna.<br /><br />Administrator menentukan apakah blok ini dapat memperlihatkan item media yang berhubungan dengan seseorang atau suatu peristiwa.";
$pgv_lang["random_media_persons_or_all"]	= "Hanya perlihatkan orang, peristiwa, atau semua?";
$pgv_lang["random_media_persons"]		= "Orang";
$pgv_lang["random_media_events"]		= "Peristiwa";
$pgv_lang["gedcom_block"]			= "Sambutan GEDCOM";
$pgv_lang["gedcom_descr"]			= "Blok Sambutan GEDCOM bekerja seperti blok Sambutan Pengguna. Ia menyambut pengunjung situs dan menampilkan judul basisdata yang sedang aktif sebagaimana juga tanggal dan waktu.";
$pgv_lang["gedcom_favorites_block"] 		= "Favorit GEDCOM";
$pgv_lang["gedcom_favorites_descr"] 		= "Blok Favorit GEDCOM memberi Administrator kemampuan untuk memilih individu dari basisdata, sehingga informasinya mudah diakses khalayak. Ini adalah cara menekankan orang yang penting dalam sejarah keluarga Anda.";
$pgv_lang["gedcom_stats_block"] 		= "Statistik GEDCOM";
$pgv_lang["gedcom_stats_descr"] 		= "Blok Statistik GEDCOM memperlihatkan kepada pengunjung beberapa informasi dasar tentang basisdata, seperti kapan pembuatannya dan berapa orang kandungannya.<br /><br />Ia juga mempunyai daftar marga yang paling sering. Anda dapat mengatur blok ini agar tidak memperlihatkan Daftar marga yang sering, dan Anda juga dapat mengatur GEDCOM untuk membuang atau menambah nama ke daftar ini. Anda dapat menetapkan batas tampilan untuk daftar ini pada pengaturan GEDCOM.";
$pgv_lang["gedcom_stats_show_surnames"]		= "Perlihatkan marga umum?";
$pgv_lang["portal_config_intructions"]		= "~#pgv_lang[customize_page]# <br /> #pgv_lang[customize_gedcom_page]#~<br /><br />Anda dapat mengatur halaman dengan meletakkan blok pada halaman sebagaimana Anda inginkan.<br /><br />Halaman terbagi atas bagian <b>Utama</b> dan <b>Kanan</b>. Blok bagian <b>Utama</b> tampak lebih besar dan di bawah judul halaman. Bagian <b>Kanan</b> bermula dari kanan judul ke sisi bawah kanan halaman.<br /><br />Setiap bagian mempunyai daftar bloknya masing-masing yang akan dicetak pada halaman dengan urutan sebagaimana dalam daftar. Anda dapat menambah, membuang, dan menyusun blok semau Anda.<br /><br />Saat salah satu daftar blok kosong, blok yang tersisa akan mengambil lebar halaman yang tersisa.<br /><br />";
$pgv_lang["login_block"]			= "Catatmasuk";
$pgv_lang["login_descr"]			= "Blok Catatmasuk menerima nama pengguna dan sandi bagi pengguna untuk masuk log.";
$pgv_lang["theme_select_block"] 		= "Pilih Tema";
$pgv_lang["theme_select_descr"] 		= "Blok Pilih Tema menampilkan Pilihan teman walaupun fitur Ganti Tema dinonaktifkan.";
$pgv_lang["block_top10_title"]			= "10 Marga Teratas";
$pgv_lang["block_top10"]			= "10 Marga Teratas";
$pgv_lang["block_top10_descr"]			= "Blok ini memperlihatkan tabel 10 marga yang paling sering muncul di basisdata. Jumlah aktual marga yang diperlihatkan di blok ini dapat diatur. Anda dapat mengatur GEDCOM untuk membuang nama dari daftar ini.";
$pgv_lang["block_givn_top10_title"]		= "10 Nama Depan Teratas";
$pgv_lang["block_givn_top10"]			= "10 Nama Depan Teratas";
$pgv_lang["block_givn_top10_descr"]		= "Blok ini memperlihatkan tabel 10 nama depan yang paling sering muncul di basisdata. Jumlah aktual nama depan yang diperlihatkan di blok ini dapat diatur.";

$pgv_lang["gedcom_news_block"]			= "Berita GEDCOM";
$pgv_lang["gedcom_news_descr"]			= "Blok Berita GEDCOM memperlihatkan kepada pengunjung rilis berita atau artikel yang dikirimkan oleh pengguna admin.<br /><br />The News block is a good place to announce a significant database update, a family reunion, or the birth of a child.";
$pgv_lang["gedcom_news_limit"]			= "Batasi tampilan dengan:";
$pgv_lang["gedcom_news_limit_nolimit"]		= "Tidak dibatasi";
$pgv_lang["gedcom_news_limit_date"]		= "Usia item";
$pgv_lang["gedcom_news_limit_count"]		= "Jumlah item";
$pgv_lang["gedcom_news_flag"]			= "Batasan:";
$pgv_lang["gedcom_news_archive"] 		= "Tampilkan arsip";
$pgv_lang["user_news_block"]			= "Jurnal Pengguna";
$pgv_lang["user_news_descr"]			= "Blok Jurnal Pengguna membolehkan pengguna membuat catatan atau jurnal daring.";
$pgv_lang["my_journal"] 			= "Jurnal Saya";
$pgv_lang["no_journal"] 			= "Anda tidak membuat item Jurnal apapun.";
$pgv_lang["confirm_journal_delete"]		= "Apakah Anda yakin ingin menghapus masukan Jurnal ini?";
$pgv_lang["add_journal"]			= "Tambahkan masukan Jurnal baru";
$pgv_lang["gedcom_news"]			= "Berita";
$pgv_lang["confirm_news_delete"]		= "Apakah Anda yakin ingin menghapus masukan Berita ini?";
$pgv_lang["add_news"]				= "Tambahkan Artikel berita baru";
$pgv_lang["no_news"]				= "Tidak ada Artikel berita yang dikirim.";
$pgv_lang["edit_news"]				= "Tambah/Sunting masukan Jurnal/Berita";
$pgv_lang["enter_title"]			= "Silakan masukkan judul.";
$pgv_lang["enter_text"] 			= "Silakan masukkan beberapa teks untuk masukan Berita atau Jurnal.";
$pgv_lang["news_saved"] 			= "Masukan Berita/Jurnal berhasil disimpan.";
$pgv_lang["article_text"]			= "Teks Masukan:";
$pgv_lang["main_section"]			= "Blok Bagian Utama";
$pgv_lang["right_section"]			= "Blok Bagian Kanan";
$pgv_lang["available_blocks"]			= "Blok yang Tersedia";
$pgv_lang["move_up"]				= "Pindah ke Atas";
$pgv_lang["move_down"]				= "Pindah ke Bawah";
$pgv_lang["move_right"] 			= "Pindah ke Kanan";
$pgv_lang["move_left"]				= "Pindah ke Kiri";
$pgv_lang["broadcast_all"]			= "Siarkan ke seluruh pengguna";
$pgv_lang["hit_count"]				= "Hitungan Kunjungan:";
$pgv_lang["phpgedview_message"] 		= "Pesan PhpGedView";
$pgv_lang["common_surnames"]			= "Marga yang Paling Umum";
$pgv_lang["default_news_title"] 		= "Selamat Datang ke Genealogi Anda";
$pgv_lang["default_news_text"]			= "Informasi genealogi di situsweb ini disajikan oleh <a href=\"http://www.phpgedview.net/\" target=\"_blank\">PhpGedView</a>. Halaman ini menyediakan pendahuluan dan rangkuman terhadap genealogi ini.<br /><br />Untuk mulai bekerja dengan data, pilih salah satu bagan dari menu Bagan, tuju Daftar Individu, atau cari nama atau tempat.<br /><br />Jika Anda mempunyai masalah menggunakan situs ini, Anda dapat mengklik pada ikon Bantuan agar memberi Anda informasi bagaimana menggunakan halaman yang sedang Anda tampilkan.<br /><br />Terima kasih telah mengunjungi situs ini.";
$pgv_lang["reset_default_blocks"]		= "Kembalikan ke Blok Default";
$pgv_lang["recent_changes"] 			= "Perubahan Terkini";
$pgv_lang["recent_changes_block"]		= "Perubahan Terkini";
$pgv_lang["recent_changes_descr"]		= "Blok Perubahan Terkini akan mendaftar semua perubahan yang dibuat pada basisdata selama sebulan terakhir. Blok ini dapat membantu Anda tetap mengikuti perubahan yang dibuat. Perubahan dideteksi otomatis, menggunakan tag CHAN yang didefinisikan dalam standar GEDCOM.";
$pgv_lang["recent_changes_none"]		= "<b>Tidak ada perubahan selama #pgv_lang[global_num1]# hari terakhir.</b><br />";
$pgv_lang["recent_changes_some"]		= "<b>Perubahan dibuat selama #pgv_lang[global_num1]# hari terakhir</b><br />";
$pgv_lang["show_empty_block"]			= "Apakah sebaiknya blok ini tersembunyi ketika kosong?";
$pgv_lang["hide_block_warn"]			= "Jika Anda menyembunyikan blok kosong, Anda tidak akan dapat mengubah pengaturannya hingga tampak karena tidak kosong lagi.";
$pgv_lang["delete_selected_messages"]		= "Hapus Pesan Terpilih";
$pgv_lang["use_blocks_for_default"]		= "Gunakan blok berikut sebagai pengaturan blok default untuk semua pengguna?";
$pgv_lang["block_not_configure"]		= "Blok ini tidak dapat diatur.";

//-- validate GEDCOM
$pgv_lang["add_media_tool"] 			= "Tambah Peralatan Media";

//-- hourglass chart
$pgv_lang["hourglass_chart"]			= "Bagan Gelaswaktu";

//-- report engine
$pgv_lang["choose_report"]			= "Pilih laporan untuk dijalankan";
$pgv_lang["enter_report_values"]		= "Masukkan nilai laporan";
$pgv_lang["selected_report"]			= "Laporan Terpilih";
$pgv_lang["select_report"]			= "Pilih laporan";
$pgv_lang["download_report"]			= "Unduh laporan";
$pgv_lang["reports"]				= "Laporan";
$pgv_lang["pdf_reports"]			= "Laporan PDF";
$pgv_lang["html_reports"]			= "Laporan HTML";

//-- Ahnentafel report
$pgv_lang["ahnentafel_report"]			= "Laporan Ahnentafel";
$pgv_lang["ahnentafel_header"]			= "Laporan Ahnentafel untuk ";
$pgv_lang["ahnentafel_generation"]		= "Generasi ";
$pgv_lang["ahnentafel_pronoun_m"]		= "Ia ";
$pgv_lang["ahnentafel_pronoun_f"]		= "Ia ";
$pgv_lang["ahnentafel_born_m"]			= "dilahirkan";			// male
$pgv_lang["ahnentafel_born_f"]			= "dilahirkan";			// female
$pgv_lang["ahnentafel_christened_m"] 		= "dikristenkan";	// male
$pgv_lang["ahnentafel_christened_f"] 		= "dikristenkan";	// female
$pgv_lang["ahnentafel_married_m"]		= "menikah";			// male
$pgv_lang["ahnentafel_married_f"]		= "dinikahkan";			// female
$pgv_lang["ahnentafel_died_m"]			= "meninggal";				// male
$pgv_lang["ahnentafel_died_f"]			= "meninggal";				// female
$pgv_lang["ahnentafel_buried_m"]		= "dimakamkan";			// male
$pgv_lang["ahnentafel_buried_f"]		= "dimakamkan";			// female
$pgv_lang["ahnentafel_place"]			= " di ";				// place name follows this
$pgv_lang["ahnentafel_no_details"]		= " namun rincian tidak diketahui";

//-- Changes report
$pgv_lang["changes_report"]			= "Laporan Perubahan";
$pgv_lang["changes_pending_tot"]		= "Total perubahan tertunda: ";
$pgv_lang["changes_accepted_tot"]		= "Total perubahan diterima: ";

//-- Descendancy report
$pgv_lang["descend_report"]			= "Laporan Keturunan";
$pgv_lang["descendancy_header"]			= "Laporan Keturunan untuk ";

$pgv_lang["family_group_report"]		= "Laporan Kelompok Keluarga";
$pgv_lang["page"]				= "Halaman";
$pgv_lang["of"] 				= "dari";
$pgv_lang["enter_famid"]			= "Masukkan ID Keluarga";
$pgv_lang["show_sources"]			= "Perlihatkan sumber?";
$pgv_lang["show_notes"] 			= "Perlihatkan catatan?";
$pgv_lang["show_basic"] 			= "Cetak peristiwa dasar saat kosong?";
$pgv_lang["show_photos"]			= "Perlihatkan foto?";
$pgv_lang["relatives_report_ext"]		= "Laporan Kerabat Luas";
$pgv_lang["with"]				= "dengan";
$pgv_lang["on"]					= "pada tanggal";			// for precise dates
$pgv_lang["in"]					= "pada";			// for imprecise dates
$pgv_lang["individual_report"]			= "Laporan Individu";
$pgv_lang["enter_pid"]				= "Masukkan ID Individu";
$pgv_lang["generated_by"]			= "Diolah oleh";
$pgv_lang["list_children"]			= "Daftar tiap anak urut kelahiran.";
$pgv_lang["birth_report"]			= "Laporan Tanggal dan Tempat Lahir";
$pgv_lang["birthplace"]				= "Tempat Lahir mengandung";
$pgv_lang["birthdate1"]				= "Awal selang Tanggal Lahir";
$pgv_lang["birthdate2"]				= "Akhir selang Tanggal Lahir";
$pgv_lang["death_report"]			= "Laporan Tanggal dan Tempat Kematian";
$pgv_lang["deathplace"]				= "Tempat Kematian mengandung";
$pgv_lang["deathdate1"]				= "Awal selang Tanggal Kematian";
$pgv_lang["deathdate2"]				= "Akhir selang Tanggal Kematian";
$pgv_lang["marr_report"]			= "Laporan Tanggal dan Tempat Nikah";
$pgv_lang["marrplace"]				= "Tempat Nikah mengandung";
$pgv_lang["marrdate1"]				= "Awal selang Tanggal Nikah";
$pgv_lang["marrdate2"]				= "Akhir selang Tanggal Nikah";
$pgv_lang["sort_by"]				= "Urut berdasarkan";

$pgv_lang["cleanup"]				= "Pembersihan";

//-- CONFIGURE (extra) messages for programs patriarch and statistics
$pgv_lang["statistics"] 			= "Statistik";

//-- Merge Records
$pgv_lang["merge_same"] 			= "Jenis rekaman tidak sama. Tidak dapat menggabungkan rekaman yang jenisnya tidak sama.";
$pgv_lang["merge_step1"]			= "Penggabungan Langkah 1 dari 3";
$pgv_lang["merge_step2"]			= "Penggabungan Langkah 2 dari 3";
$pgv_lang["merge_step3"]			= "Penggabungan Langkah 3 dari 3";
$pgv_lang["select_gedcom_records"]		= "Pilih dua rekaman GEDCOM untuk digabungkan. Jenis rekaman harus sama.";
$pgv_lang["merge_to"]				= "Gabungkan Hingga ID:";
$pgv_lang["merge_from"] 			= "Gabungkan Dari ID:";
$pgv_lang["merge_facts_same"]			= "Fakta berikut sama persis pada kedua rekaman dan akan digabungkan secara otomatis.";
$pgv_lang["no_matches_found"]			= "Tidak ada fakta yang cocok ditemukan";
$pgv_lang["unmatching_facts"]			= "Fakta berikut tidak cocok. Pilih informasi yang ingin Anda pertahankan.";
$pgv_lang["record"] 				= "Rekaman";
$pgv_lang["adding"] 				= "Menambah";
$pgv_lang["updating_linked"]			= "Memutakhirkan rekaman terkait";
$pgv_lang["merge_more"] 			= "Gabungkan rekaman lagi.";
$pgv_lang["same_ids"]				= "Anda memasukkan ID yang sama. Anda tidak dapat menggabungkan rekaman yang sama.";

//-- ANCESTRY FILE MESSAGES
$pgv_lang["ancestry_chart"] 			= "Bagan Leluhur";
$pgv_lang["gen_ancestry_chart"]			= "Bagan Leluhur #PEDIGREE_GENERATIONS# Generasi";
$pgv_lang["chart_style"]			= "Gaya bagan";
$pgv_lang["chart_list"]				= "Daftar";
$pgv_lang["chart_booklet"]   			= "Booklet";
$pgv_lang["show_cousins"]			= "Perlihatkan sepupu";
// 1st generation
$pgv_lang["sosa_2"] 				= "Ayah";
$pgv_lang["sosa_3"] 				= "Ibu";
// 2nd generation
$pgv_lang["sosa_4"] 				= "Kakek";
$pgv_lang["sosa_5"] 				= "Nenek";
$pgv_lang["sosa_6"] 				= "Kakek";
$pgv_lang["sosa_7"] 				= "Nenek";
// 3rd generation
$pgv_lang["sosa_8"] 				= "Kakek buyut";
$pgv_lang["sosa_9"] 				= "Nenek buyut";
$pgv_lang["sosa_10"]				= "Kakek buyut";
$pgv_lang["sosa_11"]				= "Nenek buyut";
$pgv_lang["sosa_12"]				= "Kakek buyut";
$pgv_lang["sosa_13"]				= "Nenek buyut";
$pgv_lang["sosa_14"]				= "Kakek buyut";
$pgv_lang["sosa_15"]				= "Nenek buyut";
// 4th generation
$pgv_lang["sosa_16"]				= "Kakek moyang";
$pgv_lang["sosa_17"]				= "Nenek moyang";
$pgv_lang["sosa_18"]				= "Kakek moyang";
$pgv_lang["sosa_19"]				= "Nenek moyang";
$pgv_lang["sosa_20"]				= "Kakek moyang";
$pgv_lang["sosa_21"]				= "Nenek moyang";
$pgv_lang["sosa_22"]				= "Kakek moyang";
$pgv_lang["sosa_23"]				= "Nenek moyang";
$pgv_lang["sosa_24"]				= "Kakek moyang";
$pgv_lang["sosa_25"]				= "Nenek moyang";
$pgv_lang["sosa_26"]				= "Kakek moyang";
$pgv_lang["sosa_27"]				= "Nenek moyang";
$pgv_lang["sosa_28"]				= "Kakek moyang";
$pgv_lang["sosa_29"]				= "Nenek moyang";
$pgv_lang["sosa_30"]				= "Kakek moyang";
$pgv_lang["sosa_31"]				= "Nenek moyang";

// for the general case of ancestors of the nth generation use the text below
// in this text %1\$d is replaced with the number of generations
//              %2\$d is replaced with the number of generations - 1
//              %3\$d is replaced with the number of generations - 2
$pgv_lang["sosa_paternal_male_n_generations"]	= "Kakek moyang ayah %3\$d x";
$pgv_lang["sosa_paternal_female_n_generations"]	= "Nenek moyang ayah %3\$d x";
$pgv_lang["sosa_maternal_male_n_generations"]	= "Kakek moyang ibu %3\$d x";
$pgv_lang["sosa_maternal_female_n_generations"]	= "Nenek moyang ibu %3\$d x";

//-- FAN CHART
$pgv_lang["compact_chart"]			= "Bagan Sederhana";
$pgv_lang["fan_chart"]				= "Diagram Lingkaran";
$pgv_lang["gen_fan_chart"]  			= "Diagram Lingkaran #PEDIGREE_GENERATIONS# Generasi";
$pgv_lang["fan_width"]				= "Lebar";
$pgv_lang["gd_library"]				= "Miskonfigurasi server PHP: Librari GD 2.x diperlukan untuk menggunakan fungsi gambar.";
$pgv_lang["gd_freetype"]			= "Miskonfigurasi server PHP: Librari FreeType diperlukan untuk menggunakan font TrueType.";
$pgv_lang["gd_helplink"]			= "http://www.php.net/gd";
$pgv_lang["fontfile_error"]			= "Berkas Font tidak ditemukan di server PHP";
$pgv_lang["fanchart_IE"]			= "Gambar kipas ini tidak dapat dicetak langsung oleh perambah Anda. Gunakan klik-kanan, kemudian simpan dan cetak.";

//-- RSS Feed
$pgv_lang["rss_descr"]				= "Berita dan pranala dari situs #GEDCOM_TITLE#";
$pgv_lang["rss_logo_descr"]			= "Umpan dibuat oleh PhpGedView";
$pgv_lang["rss_feeds"]				= "Umpan RSS";
$pgv_lang["no_feed_title"]			= "Umpan tidak tersedia";
$pgv_lang["no_feed"]				= "Tidak ada umpan RSS yang tersedia untuk situs PhpGedView ini";
$pgv_lang["feed_login"]				= "Jika Anda mempunyai akun di situs PhpGedView ini, Anda dapat <a href=\"#AUTH_URL#\">masuk log</a> ke server menggunakan Otentifikasi HTTP Dasar untuk menampilkan informasi pribadi.";
$pgv_lang["authenticated_feed"]			= "Umpan Terotentifikasi";

//-- ASSOciates RELAtionship
// After any change in the following list, please check $assokeys in edit_interface.php
$pgv_lang["attendant"]				= "Attendant";
$pgv_lang["attending"]				= "Attending";
$pgv_lang["best_man"]				= "Best Man";
$pgv_lang["bridesmaid"]				= "Bridesmaid";
$pgv_lang["buyer"]				= "Pembeli";
$pgv_lang["circumciser"]			= "Penyunat";
$pgv_lang["civil_registrar"]			= "Pencatat Sipil";
$pgv_lang["friend"]				= "Teman";
$pgv_lang["godfather"]				= "Ayah baptis";
$pgv_lang["godmother"]				= "Ibu baptis";
$pgv_lang["godparent"]				= "Orangtua baptis";
$pgv_lang["godson"]				= "Anak baptis lelaki";
$pgv_lang["goddaughter"]			= "Anak baptis perempuan";
$pgv_lang["godchild"]				= "Anak baptis";
$pgv_lang["informant"]				= "Informan";
$pgv_lang["lodger"]				= "Lodger";
$pgv_lang["nurse"]				= "Perawat";
$pgv_lang["priest"]				= "Pendeta";
$pgv_lang["rabbi"]				= "Rabbi";
$pgv_lang["registry_officer"]			= "Registry Officer";
$pgv_lang["seller"]				= "Penjual";
$pgv_lang["servant"]				= "Pelayan";
$pgv_lang["twin"]				= "Kembar";
$pgv_lang["twin_brother"]			=  "Saudara kembar";
$pgv_lang["twin_sister"]			= "Saudari kembar";
$pgv_lang["witness"]				= "Saksi";

//-- statistics utility
$pgv_lang["statutci"]				= "tidak dapat membuat indeks";
$pgv_lang["statnnames"]				= "jumlah nama      =";
$pgv_lang["statnfam"]                  		= "jumlah keluarga  =";
$pgv_lang["statnmale"]                 		= "jumlah laki-laki =";
$pgv_lang["statnfemale"]               		= "jumlah perempuan =";
$pgv_lang["statvars"]			 	= "isilah parameter berikut untuk plot";
$pgv_lang["statlxa"]			 	= "sepanjang aksis X:";
$pgv_lang["statlya"]			 	= "sepanjang aksis Y:";
$pgv_lang["statlza"]			 	= "sepanjang aksis Z:";
$pgv_lang["stat_10_none"]		 	= "tidak ada";
$pgv_lang["stat_11_mb"]			 	= "Bulan lahir";
$pgv_lang["stat_12_md"]			 	= "Bulan wafat";
$pgv_lang["stat_13_mm"]			 	= "Bulan nikah";
$pgv_lang["stat_14_mb1"]			= "Bulan lahir anak pertama dalam hubungan";
$pgv_lang["stat_15_mm1"]			= "Bulan nikah pertama";
$pgv_lang["stat_16_mmb"]			= "Bulan antara nikah dan anak pertama";
$pgv_lang["stat_17_arb"]			= "umur sehubungan dengan tahun lahir";
$pgv_lang["stat_18_ard"]			= "umur sehubungan dengan tahun wafat";
$pgv_lang["stat_19_arm"]			= "umur dalam tahun nikah";
$pgv_lang["stat_20_arm1"]			= "umur dalam tahun nikah pertama";
$pgv_lang["stat_21_nok"]			= "jumlah anak";
$pgv_lang["stat_200_none"]			= "semua (atau kosong)";
$pgv_lang["stat_201_num"]			= "jumlah";
$pgv_lang["stat_202_perc"]			= "persentase";
$pgv_lang["stat_300_none"]			= "tidak ada";
$pgv_lang["stat_301_mf"]			= "jender";
$pgv_lang["stat_302_cgp"]			= "periode tanggal";
$pgv_lang["statmess1"]			 	= "<b>Isian berikut berhubungan dengan parameter plot di atas untuk aksis X dan Z </b>";
$pgv_lang["statar_xgp"]			 	= "batas aksis X (periode):";
$pgv_lang["statar_xgl"]			 	= "batas aksis X (umur):";
$pgv_lang["statar_xgm"]			 	= "batas aksis X (bulan):";
$pgv_lang["statar_xga"]			 	= "batas aksis X (jumlah):";
$pgv_lang["statar_zgp"]			 	= "batas aksis X (periode tanggal):";
$pgv_lang["statreset"]			 	= "kembalikan";
$pgv_lang["statsubmit"]			 	= "perlihatkan plot";

//-- statisticsplot utility
$pgv_lang["statistiek_list"]			= "Plot Statistik";
$pgv_lang["stpl"]			 	= "...";
$pgv_lang["stplGDno"]			 	= "Librari Tampilan Grafik tidak terpasang pada server. Silakan hubungi administrator sistem Anda.";
$pgv_lang["stpljpgraphno"]			= "Librari JPgraph tidak terpassang pada PhpGedView. Silakan unduh dari http://www.aditus.nu/jpgraph/jpdownload.php<br /> dan kemudian salin ke subdirectori <i>jpgraph/</i> pada server.";
$pgv_lang["stplinfo"]			 	= "informasi plotting:";
$pgv_lang["stpltype"]			 	= "jenis:";
$pgv_lang["stplnoim"]			 	= " tidak diterapkan:";
$pgv_lang["stplmf"]			 	= " / lelaki-perempuan";
$pgv_lang["stplipot"]			 	= " / tiap periodewaktu";
$pgv_lang["stplgzas"]			 	= "batas aksis Z:";
$pgv_lang["stplmonth"]			 	= "bulan";
$pgv_lang["stplnumbers"]		 	= "jumlah untuk keluarga";
$pgv_lang["stplage"]			 	= "umur";
$pgv_lang["stplperc"]			 	= "persentase";
$pgv_lang["stplnumof"]			 	= "Jumlah ";
$pgv_lang["stplmarrbirth"]		 	= "Bulan antara nikah dan lahir anak pertama";

//-- alive in year
$pgv_lang["alive_in_year"]			= "Hidup pada Tahun";
$pgv_lang["is_alive_in"]			= "Hidup pada #YEAR#";
$pgv_lang["alive"]				= "Hidup ";
$pgv_lang["dead"]				= "Wafat ";
$pgv_lang["maybe"]				= "Mungkin ";
$pgv_lang["both_alive"]				= "Hidup keduanya ";
$pgv_lang["both_dead"]				= "Wafat keduanya ";

//-- Help system
$pgv_lang["definitions"]			= "Definisi";

//-- Index_edit
$pgv_lang["block_desc"]				= "Uraian Blok";
$pgv_lang["click_here"]				= "Klik di sini untuk melanjutkan";
$pgv_lang["click_here_help"]			= "~#pgv_lang[click_here]#~<br /><br />Klik tombol ini untuk menyimpan perubahan Anda.<br /><br />Anda akan kembali ke halaman #pgv_lang[welcome]# atau #pgv_lang[mygedview]#, namun perubahan Anda mungkin tidak diperlihatkan. Anda mungkin perlu untuk menggunakan fungsi Muatkembali Halaman dari perambah Anda untuk menampilkan perubahan Anda dengan benar.";
$pgv_lang["block_summaries"]			= "~#pgv_lang[block_desc]#~<br /><br />Berikut adalah uraian singkat dari tiap blok yang dapat Anda tempatkan pada halaman #pgv_lang[welcome]# atau #pgv_lang[mygedview]#.<br /><table border='1' align='center'><tr><td class='list_value'><b>#pgv_lang[name]#</b></td><td class='list_value'><b>#pgv_lang[description]#</b></td></tr>#pgv_lang[block_summary_table]#</table><br /><br />";
// Built in index_edit.php
$pgv_lang["block_summary_table"]		= "&nbsp;";

//-- Find page
$pgv_lang["total_places"]			= "Tempat yang ditemukan";
$pgv_lang["media_contains"]			= "Media mengandung:";
$pgv_lang["repo_contains"]			= "Repositori mengandung:";
$pgv_lang["source_contains"]			= "Sumber mengandung:";
$pgv_lang["display_all"]			= "Tampilkan semua";

//-- accesskey navigation
$pgv_lang["accesskeys"]				= "Jalanpintas Keyboard";
$pgv_lang["accesskey_skip_to_content"]		= "C";
$pgv_lang["accesskey_search"]			= "S";
$pgv_lang["accesskey_skip_to_content_desc"]	= "Lewati ke DaftarIsi";
$pgv_lang["accesskey_viewing_advice"]		= "0";
$pgv_lang["accesskey_viewing_advice_desc"]	= "Saran tampilan";
$pgv_lang["accesskey_home_page"]		= "1";
$pgv_lang["accesskey_help_content"]		= "2";
$pgv_lang["accesskey_help_current_page"]	= "3";
$pgv_lang["accesskey_contact"]			= "4";

$pgv_lang["accesskey_individual_details"]		= "I";
$pgv_lang["accesskey_individual_relatives"]		= "R";
$pgv_lang["accesskey_individual_notes"]			= "N";
$pgv_lang["accesskey_individual_sources"]		= "O";
//clash with IE addBookmark but not a likely problem
$pgv_lang["accesskey_individual_media"]			= "A";
$pgv_lang["accesskey_individual_research_log"]		= "L";
$pgv_lang["accesskey_individual_pedigree"]		= "P";
$pgv_lang["accesskey_individual_descendancy"]		= "D";
$pgv_lang["accesskey_individual_timeline"]		= "T";
$pgv_lang["accesskey_individual_relation_to_me"]	= "M";
//clash with rarely used English Netscape/Mozilla Go menu
$pgv_lang["accesskey_individual_gedcom"]		= "G";

$pgv_lang["accesskey_family_parents_timeline"]		= "P";
$pgv_lang["accesskey_family_children_timeline"]		= "D";
$pgv_lang["accesskey_family_timeline"]	= "T";
//clash with rarely used English Netscape/Mozilla English Go menu
$pgv_lang["accesskey_family_gedcom"]			= "G";

// FAQ Page
$pgv_lang["add_faq_header"] 				= "Catatankepala FAQ";
$pgv_lang["add_faq_body"] 				= "Badan FAQ";
$pgv_lang["add_faq_order"] 				= "Posisi FAQ";
$pgv_lang["add_faq_visibility"] 			= "Penampakan FAQ";
$pgv_lang["no_faq_items"] 				= "Daftar FAQ kosong.";
$pgv_lang["position_item"] 				= "Posisi item";
$pgv_lang["faq_list"] 					= "Daftar FAQ";
$pgv_lang["confirm_faq_delete"] 			= "Apakah Anda yakin ingin menghapus masukan FAQ?";
$pgv_lang["preview"] 					=  "Pratayang";
$pgv_lang["no_id"] 					= "Tidak ada ID FAQ yang ditentukan!";

// Help search
$pgv_lang["hs_title"] 					= "Teks Bantuan Pencarian";
$pgv_lang["hs_search"] 					= "Cari";
$pgv_lang["hs_close"] 					= "Tutup Jendela";
$pgv_lang["hs_results"] 				= "Hasil yang ditemukan:";
$pgv_lang["hs_keyword"] 				= "Cari apa";
$pgv_lang["hs_searchin"]				= "Cari dalam";
$pgv_lang["hs_searchuser"]				= "Bantuan Pengguna";
$pgv_lang["hs_searchmodules"]				= "Bantuan Modul";
$pgv_lang["hs_searchconfig"]				= "Bantuan Administrator";
$pgv_lang["hs_searchhow"]				= "Jenis Pencarian";
$pgv_lang["hs_searchall"]				= "Semua kata";
$pgv_lang["hs_searchany"]				= "Kata apapun";
$pgv_lang["hs_searchsentence"]				= "Frase tepat";
$pgv_lang["hs_intruehelp"]				= "Hanya teks Bantuan";
$pgv_lang["hs_inallhelp"]				= "Semua teks";

// Media import
$pgv_lang["choose"] 					= "Pilih: ";
$pgv_lang["account_information"] 			= "Informasi Akun";

//-- Media item "TYPE" sub-field
$pgv_lang["TYPE__audio"] 				= "Audio";
$pgv_lang["TYPE__book"] 				= "Buku";
$pgv_lang["TYPE__card"] 				= "Kartu";
$pgv_lang["TYPE__certificate"] 				= "Sertifikat";
$pgv_lang["TYPE__document"] 				= "Dokumen";
$pgv_lang["TYPE__electronic"] 				= "Elektronik";
$pgv_lang["TYPE__fiche"] 				= "Microfiche";
$pgv_lang["TYPE__film"] 				= "Mikrofilm";
$pgv_lang["TYPE__magazine"] 				= "Majalah";
$pgv_lang["TYPE__manuscript"] 				= "Manuskrip";
$pgv_lang["TYPE__map"] 					= "Peta";
$pgv_lang["TYPE__newspaper"] 				= "Koran";
$pgv_lang["TYPE__photo"] 				= "Foto";
$pgv_lang["TYPE__tombstone"] 				= "Makam";
$pgv_lang["TYPE__video"] 				= "Video";
$pgv_lang["TYPE__painting"] 				= "Lukisan";
$pgv_lang["TYPE__other"] 				= "Lainnya";

//-- Other media suff
$pgv_lang["view_slideshow"] 				= "Tampilkan sebagai slideshow";
$pgv_lang["download_image"]				= "Unduh Berkas";
$pgv_lang["no_media"]					= "Tidak ada Media yang Ditemukan";
$pgv_lang["media_privacy"]				= "Batas pribadi mencegah Anda menampilkan item ini";
$pgv_lang["relations_heading"]				= "Gambar berhubungan terhadap:";
$pgv_lang["file_size"]					= "Ukuran Berkas";
$pgv_lang["img_size"]					= "Ukuran Gambar";
$pgv_lang["media_broken"]				= "Berkas media ini rusak dan tidak dapat di-watermark-kan";
$pgv_lang["unknown_mime"]				= "Kesalahan Firewall Media: >JenisMime tidak dikenal< untuk berkas";

//-- Modules
$pgv_lang["module_error_unknown_action_v2"] 		= "Aksi tidak dikenal: [aksi].";
$pgv_lang["module_error_unknown_type"] 			= "Jenis modul tidak dikenal.";

//-- sortable tables buttons
$pgv_lang["button_alive_in_year"] 			= "Perlihatkan orang hidup di tahun yang ditetapkan.";
$pgv_lang["button_BIRT_Y100"] 				= "Perlihatkan orang yang lahir selama 100 tahun terakhir.";
$pgv_lang["button_BIRT_YES"] 				= "Perlihatkan orang yang lahir lebih dari 100 tahun lalu.";
$pgv_lang["button_DEAT_H"] 				= "Perlihatkan pasangan dengan hanya pasangan pria yang meninggal.";
$pgv_lang["button_DEAT_N"] 				= "Perlihatkan orang yang hidup atau pasangan yang keduanya hidup.";
$pgv_lang["button_DEAT_W"] 				= "Perlihatkan pasangan dengan hanya pasangan wanita yang meninggal.";
$pgv_lang["button_DEAT_Y"] 				= "Perlihatkan orang yang meninggal atau pasangan yang keduanya meninggal.";
$pgv_lang["button_DEAT_Y100"] 				= "Perlihatkan orang yang meninggal selama 100 tahun terakhir.";
$pgv_lang["button_DEAT_YES"] 				= "Perlihatkan orang yang meninggal lebih dari 100 tahun lalu.";
$pgv_lang["button_MARR_DIV"] 				= "Perlihatkan pasangan yang bercerai.";
$pgv_lang["button_MARR_U"] 				= "Perlihatkan pasangan dengan tanggal nikah tidak diketahui.";
$pgv_lang["button_MARR_Y100"] 				= "Perlihatkan pasangan yang menikah selama 100 tahun terakhir.";
$pgv_lang["button_MARR_YES"] 				= "Perlihatkan pasangan yang menikah lebih dari 100 tahun lalu.";
$pgv_lang["button_reset"] 				= "Kembalikan default ke daftar.";
$pgv_lang["button_SEX_F"] 				= "Hanya perlihatkan perempuan.";
$pgv_lang["button_SEX_M"] 				= "Hanya perlihatkan laki-laki.";
$pgv_lang["button_SEX_U"] 				= "Hanya perlihatkan orang yang jendernya tidak diketahui.";
$pgv_lang["button_TREE_L"] 				= "Perlihatkan pasangan atau individu «ranting».  Mereka adalah individu yang hidup, namun tidak mempunyai anak yang terekam dalam basisdata.";
$pgv_lang["button_TREE_R"] 				= "Perlihatkan pasangan atau individu «akar».  Orang-orang ini juga disebut «patriarkh». Mereka adalah individu yang tidak mempunyai orangtua yang terekam dalam basisdata.";
$pgv_lang["sort_column"] 				= "Urutkan berdasarkan kolom ini.";
?>
