<?php
/**
 * Hungarian texts
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2010  PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 * @author PGV Developers
 * @author Hrotkó Gábor <roti@al.pmmf.hu>
 * @package PhpGedView
 * @subpackage Languages
 * @version $Id: lang.hu.php 6989 2010-11-09 03:26:25Z canajun2eh $
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

$pgv_lang["none"]					= "Semmi";

//-- GENERAL HELP MESSAGES
$pgv_lang["qm"]							= "?";
$pgv_lang["qm_ah"]						= "?";
$pgv_lang["page_help"]						= "Segítség";
$pgv_lang["help_for_this_page"]					= "Segítség ehhez az oldalhoz";
$pgv_lang["help_contents"]					= "A Segítség tartalomjegyzéke";
$pgv_lang["show_context_help"]					= "Környezetérzékeny segítség megjelenítése";
$pgv_lang["hide_context_help"]					= "Környezetérzékeny segítség elrejtése";
$pgv_lang["sorry"]						= "<b>Elnézést kérünk, de ennek az oldalnak a Segítsége még nem készült el.</b>";
$pgv_lang["help_not_exist"]					= "<b>Ennek az oldalnak vagy elemnek még nincsen Segítsége.</b>";
$pgv_lang["var_not_exist"]					= "<span style=font-weight: bold>A nyelvi szöveg nem létezik. Kérem jelentse ezt be mint hiba.</span>";
$pgv_lang["resolution"]						= "Képernyőfelbontás";
$pgv_lang["menu"]						= "Menü";
$pgv_lang["header"]						= "Fejléc";
$pgv_lang["imageview"]          				= "Képnéző";
//-- CONFIG FILE MESSAGES
$pgv_lang["login_head"]                 			= "Belépés a PhpGedView felhasználóinak";
$pgv_lang["for_support"]					= "Technikai jellegű segítség:";
$pgv_lang["for_contact"]					= "Genealógiai jellegű segítség:";
$pgv_lang["for_all_contact"]					= "Technikai és genealógiai jellegű segítség";
$pgv_lang["choose_username"]					= "Választott felhasználónév";
$pgv_lang["username"]						= "Felhasználói név";
$pgv_lang["invalid_username"]					= "A felhasználónév érvénytelen karaktereket tartalmaz";
$pgv_lang["lastname"]						= "Vezetéknév";
$pgv_lang["firstname"]						= "Keresztnév";
$pgv_lang["choose_password"]					= "Válasszon jelszót";
$pgv_lang["password"]						= "Jelszó";
$pgv_lang["confirm"]						= "Jelszó még egyszer";
$pgv_lang["login"]						= "Belépés";
$pgv_lang["logout"]						= "Kilépés";
$pgv_lang["admin"]						= "Adminisztráció";
$pgv_lang["logged_in_as"]					= "Bejelentkezve mint";
$pgv_lang["my_pedigree"]					= "Családfám";
$pgv_lang["my_indi"]						= "Saját Személyes Adataim";
$pgv_lang["no"]							= "Nem";
$pgv_lang["yes"]						= "Igen";
$pgv_lang["change_theme"]               			= "Asztaltéma-váltás";
//-- INDEX (PEDIGREE_TREE) FILE MESSAGES
$pgv_lang["index_header"]					= "Ősfa";
$pgv_lang["gen_ped_chart"]					= "ősei #PEDIGREE_GENERATIONS# generációra visszamenőleg";
$pgv_lang["generations"]					= "Generációk száma";
$pgv_lang["view"]						= "Mutat";
$pgv_lang["fam_spouse"]						= "Családtagok házastárssal";
$pgv_lang["root_person"]					= "Kezdő személy azonosítója";
$pgv_lang["hide_details"]					= "Részletek elrejtése";
$pgv_lang["show_details"]					= "Részletek mutatása";
$pgv_lang["person_links"]					= "Hivatkozások ennek a személynek grafikonjaira, a családjára és közeli hozzátartozóira. Klikkeljen erre az ikonra ahhoz, hogy az oldal ezzel a személlyel kezdődjön.";
$pgv_lang["zoom_box"]						= "Doboz kicsinyítése/nagyítása.";
$pgv_lang["orientation"]					= "Orientáció";
$pgv_lang["portrait"]						= "Álló";
$pgv_lang["landscape"]						= "Fekvő";
$pgv_lang["start_at_parents"]					= "Kezdjük a szülőknél";
$pgv_lang["charts"]						= "Grafikonok";
$pgv_lang["lists"]						= "Listák";
$pgv_lang["welcome_page"]					= "Nyitó oldal";
$pgv_lang["box_width"]						= "Dobozszélesség";
//-- FUNCTIONS FILE MESSAGES
$pgv_lang["unable_to_find_family"]				= "Nem található ilyen azonosítójú család";
$pgv_lang["unable_to_find_record"]				= "Nem található ilyen azonosítójú rekord";
$pgv_lang["title"]						= "Cím:";
$pgv_lang["living"]						= "Életben van";
$pgv_lang["private"]						= "Bizalmas";
$pgv_lang["birth"]						= "Született:";
$pgv_lang["death"]						= "Elhunyt:";
$pgv_lang["descend_chart"]					= "Leszármazottak";
$pgv_lang["individual_list"]					= "Személyek listája";
$pgv_lang["family_list"]					= "Családok listája";
$pgv_lang["source_list"]					= "Forráslista";
$pgv_lang["place_list"]						= "Helyszínek hierarchiája";
$pgv_lang["place_list_aft"]             			= "Helyszínek hierarchiája után";
$pgv_lang["media_list"]						= "Multimédia lista";
$pgv_lang["search"]						= "Keresés";
$pgv_lang["clippings_cart"]					= "Családfa Metszési Kosara";
$pgv_lang["print_preview"]					= "Nyomtatható változat";
$pgv_lang["cancel_preview"]					= "Vissza a normál nézethez";
$pgv_lang["change_lang"]					= "Nyelvválasztás";
$pgv_lang["print"]						= "Nyomtatás";
$pgv_lang["total_queries"]					= "Összes adatbázis-lekérdezés: ";
$pgv_lang["total_privacy_checks"]       			= "Összes diszkréciós szabály: ";
$pgv_lang["back"]						= "Vissza";
//-- INDIVUDUAL FILE MESSAGES
$pgv_lang["aka"]						= "Úgyis ismert mint";
$pgv_lang["male"]						= "Férfi";
$pgv_lang["female"]						= "Nő";
$pgv_lang["temple"]						= "UNSZ templom";
$pgv_lang["temple_code"]					= "UNSZ templom kódja:";
$pgv_lang["status"]						= "Státusz";
$pgv_lang["source"]						= "Forrás";
$pgv_lang["text"]						= "Forrás Szöveg: ";
$pgv_lang["note"]						= "Megjegyzés:";
$pgv_lang["NN"]							= "(ismeretlen)";
$pgv_lang["PN"]							= "(ismeretlen)";
$pgv_lang["unrecognized_code"]					= "Ismeretlen GEDCOM-kód";
$pgv_lang["unrecognized_code_msg"]				= "Ez egy programhiba, és szeretnénk kijavítani. Kérjük jelezze felénk a hibát:";
$pgv_lang["indi_info"]						= "Személyes adatok";
$pgv_lang["pedigree_chart"]					= "Ősfa";
$pgv_lang["individual"]						= "Személy";
$pgv_lang["family_with"]					= "Család házastárssal -";
$pgv_lang["as_spouse"]						= "Család a házastárssal";
$pgv_lang["as_child"]						= "Család a szülőkkel";
$pgv_lang["view_gedcom"]					= "A GEDCOM-rekord megtekintése";
$pgv_lang["add_to_cart"]					= "Hozzáadás a Metszési Kosárhoz";
$pgv_lang["privacy_error"]	    				= "A személy adatai bizalmas jellegűek.<br />";
$pgv_lang["more_information"]					= "További információt itt kérhet:";
$pgv_lang["name"]						= "Név";
$pgv_lang["given_name"]						= "Keresztnév:";
$pgv_lang["surname"]						= "Vezetéknév:";
$pgv_lang["suffix"]						= "Utótag:";
$pgv_lang["sex"]						= "Neme";
$pgv_lang["personal_facts"]					= "Személyes adatok";
$pgv_lang["type"]						= "Típus";
$pgv_lang["parents"] 						= "Szülők:";
$pgv_lang["siblings"] 						= "Testvér";
$pgv_lang["father"] 						= "Apa";
$pgv_lang["mother"] 						= "Anya";
$pgv_lang["parent"] 						= "Szülő";
$pgv_lang["relatives"]						= "Közeli családtagok";
$pgv_lang["relatives_events"]					= "Közeli családtagok eseményei";
$pgv_lang["spouses"] 						= "Házastársak";
$pgv_lang["child"]						= "Gyermek";
$pgv_lang["family"] 						= "Család";
$pgv_lang["surnames"]						= "Vezetéknevek";
$pgv_lang["adopted"]						= "Örökbefogadott";
$pgv_lang["foster"]						= "Nevelő";
$pgv_lang["sealing"]						= "Befogadás";
$pgv_lang["infant"]						= "Csecsemő";
$pgv_lang["link_as_wife"]					= "Ezt a személyt hozzákapcsolni egy létező családhoz mint feleség";
$pgv_lang["deceased"]						= "Elhunyt";
$pgv_lang["stillborn"]						= "Halva született";
$pgv_lang["disproved"]						= "Nem elfogadott";
$pgv_lang["challenged"]						= "Rokkant";
$pgv_lang["no_tab1"]                    			= "Ennek a személynek nincsen Tényei.";
$pgv_lang["no_tab2"]                    			= "Ennek a személynek nincs Megjegyzései.";
$pgv_lang["no_tab3"]                    			= "Ennek a személynek nincs Forrás-hivatkozásai.";
$pgv_lang["no_tab4"]                    			= "Ennek a személynek nincs Multimédia-elemei.";
$pgv_lang["no_tab5"]                   				= "Ennek a személynek nincs közeli rokonai.";
$pgv_lang["no_tab6"]						= "Ennek a személynek nincs Kutatási naplója.";
//-- FAMILY FILE MESSAGES
$pgv_lang["family_info"]					= "Család információ";
$pgv_lang["family_group_info"]					= "Információk erről a családról";
$pgv_lang["husband"]						= "Férj";
$pgv_lang["wife"]						= "Feleség";
$pgv_lang["marriage"]						= "Házasság:";
$pgv_lang["lds_sealing"]					= "UNSZ befogadás:";
$pgv_lang["marriage_license"]					= "Házassági anyakönyvi kivonat:";
$pgv_lang["children"]						= "Gyerekek";
$pgv_lang["no_children"]					= "Nincsenek gyerekek rögzítve";
$pgv_lang["childless_family"]					= "Gyermektelen család";
$pgv_lang["parents_timeline"]					= "A házaspár mutatása a Kronológiában";
//-- CLIPPINGS FILE MESSAGES
$pgv_lang["clip_cart"]						= "Metszési kosár";
$pgv_lang["which_links"]					= "Melyik ágat szeretné ebből a családból szintén hozzáadni?";
$pgv_lang["just_family"]					= "Csak ennek a családnak a rekordját adjuk hozzá.";
$pgv_lang["parents_and_family"]					= "Szülők hozzáadása ezzel a családrekorddal.";
$pgv_lang["parents_and_child"]					= "Szülők és gyerekek hozzáadása ezzel a családrekorddal.";
$pgv_lang["parents_desc"]					= "Szülők, és az összes leszármazottak hozzáadása ezzel a családrekorddal.";
$pgv_lang["continue"]						= "Hozzáadás folytatása";
$pgv_lang["which_p_links"]					= "Melyik ágat szeretné ettől a személytől szintén hozzáadni?";
$pgv_lang["just_person"]					= "Csak ennek a személynek a hozzáadása.";
$pgv_lang["person_parents_sibs"]				= "Ennek a személynek, a szüleinek és a testvéreinek a hozzáadása.";
$pgv_lang["linked_source"]					= "Forrás hozzáadása, az erre hivatkozó családokkal/személyekkel együtt";
$pgv_lang["just_source"]					= "Csak ennek a forrásnak a hozzáadása";
$pgv_lang["which_s_links"]					= "Mely rekordok adjuk hozzá, amelyek hivatkoznak erre a forrásra?";
$pgv_lang["person_ancestors"]					= "Ennek a személynek és az egyenes ági felmenőinek a hozzáadása.";
$pgv_lang["person_ancestor_fams"]				= "Ennek a személynek, az egyenes ágbi felmenőinek és azok családjainak hozzáadása.";
$pgv_lang["person_spouse"]					= "Ennek a személynek, a házastársának és a gyerekeinek a hozzáadása.";
$pgv_lang["person_desc"]					= "Ennek a személynek, a házastársának és az összes leszármazottjának a hozzáadása.";
$pgv_lang["person_private"]					= "Ennek a személynek az adatai bizalmasak. A személyes adatok így nem lesznek csatolva.";
$pgv_lang["family_private"]					= "Ennek a családnak a további információ nem nyilvánosak. Ezek a családi részletek nem lesznek csatolva.";
$pgv_lang["download"]						= "Kattintson jobb-egérgombbal (control+kattintás Machintoson) az alábbi hivatkozáson, és válassza a &quot;Mentés másként&quot; menüpontot az állományok letöltéséhez.";
$pgv_lang["download_file"]					= "Fájl letöltése #GLOBALS[whichFile]#";
$pgv_lang["cart_is_empty"]					= "Az Ön Metsző kosara üres.";
$pgv_lang["id"]							= "Azonosító";
$pgv_lang["ID"]							= "Azonosító";
$pgv_lang["name_description"]					= "Név / Leírás";
$pgv_lang["remove"]						= "Eltávolítás";
$pgv_lang["empty_cart"]						= "Üres kosár";
$pgv_lang["download_now"]					= "Letöltés";
$pgv_lang["indi_downloaded_from"]				= "Ez a személy innen lett letöltve:";
$pgv_lang["family_downloaded_from"]				= "Ez a család innen lett letöltve:";
$pgv_lang["source_downloaded_from"]				= "Ez a forrás innen lett letöltve:";
//-- PLACELIST FILE MESSAGES
$pgv_lang["connections"]					= "Helyszín-kapcsolatot találtunk";
$pgv_lang["top_level"]						= "Felső szint";
$pgv_lang["form"]						= "A helyek az alábbiak alapján rangsoroltak:";
$pgv_lang["default_form"]					= "város, megye, állam/tartomány, ország";
$pgv_lang["default_form_info"]					= "(Alapértelmezett)";
$pgv_lang["external_objects"]					= "Külső objektumok";
$pgv_lang["unknown"]						= "ismeretlen";
$pgv_lang["individuals"]					= "Személyek";
$pgv_lang["view_records_in_place"]      			= "Ehhez a helyhez kötődő rekordok";
$pgv_lang["place_list2"]                			= "Helyszín-lista";
$pgv_lang["show_place_hierarchy"]       			= "A helyszínek hierarchiában";
$pgv_lang["show_place_list"]            			= "Az összes helyszín egy listában";
$pgv_lang["total_unic_places"]          			= "Helyszínek száma";
$pgv_lang["next_image"]						= "Következő kép";
//-- MEDIALIST FILE MESSAGES
$pgv_lang["multi_title"]					= "Multimédia elemek listája";
$pgv_lang["media_found"]					= "média elem";
$pgv_lang["view_person"]					= "Személy megjelenítése";
$pgv_lang["view_family"]					= "Család megjelenítése";
$pgv_lang["view_source"]					= "Forrás megjelenítése";
$pgv_lang["view_object"]					= "Elem megjelenítése";
$pgv_lang["prev"]						= "&lt; Előző";
$pgv_lang["next"]						= "Következő &gt;";
$pgv_lang["file_not_found"]					= "Az állomány nem található.";
$pgv_lang["medialist_show"]             			= "Mutat";
$pgv_lang["per_page"]                   			= "/oldal";
$pgv_lang["manage_media"]					= "Média Kezelés";
$pgv_lang["image_size"]						= "Kép méretei";
$pgv_lang["media_format"]					= "Média Formátum";
$pgv_lang["current_dir"]					= "Aktuális mappa";
$pgv_lang["SHOW_ID_NUMBERS"]					= "Mutassuk az azonosítószámot a nevek mellett";
$pgv_lang["view_img_details"]					= "Képrészletek megtekintése";
$pgv_lang["SHOW_HIGHLIGHT_IMAGES"]				= "Mutassunk képrészletet a személyek dobozában";
$pgv_lang["search_replace"]					= "Keresés és csere";
//-- SEARCH FILE MESSAGES
$pgv_lang["search_gedcom"]					= "Keresés a GEDCOM állományban";
$pgv_lang["enter_terms"]					= "Keresőkifejezés megadása:";
$pgv_lang["soundex_search"]					= "Hasonló nevek keresése:";
$pgv_lang["sources"]						= "Források";
$pgv_lang["search_to"]						= "ig";
$pgv_lang["search_record"]					= "Összes rekord";
$pgv_lang["firstname_search"]					= "Keresztnév";
$pgv_lang["lastname_search"]					= "Vezetéknév";
$pgv_lang["search_place"]					= "Helyszín";
$pgv_lang["search_year"]					= "Év";
$pgv_lang["no_results"]						= "Nincs találat";
$pgv_lang["search_soundex"]					= "Hangzási keresés";
$pgv_lang["page_x_of_y"]					= "#GLOBALS[currentPage]# oldal a #GLOBALS[lastPage]#-ból/ből";
$pgv_lang["include"]						= "Tartalmazza";
$pgv_lang["roman_givn"]						= "Keresztnév egyszerű karakterekkel";
$pgv_lang["roman_surn"]						= "Vezetéknév egyszerű karakterekkel";
$pgv_lang["include_media"]					= "Média befoglalása (fájlok automatikus tömörítése)";
$pgv_lang["zip_files"]						= "Zip (tömörített) fájl(ok)";
$pgv_lang["advanced_options"]					= "Haladó beállítások";
$pgv_lang["add_individual_by_id"]				= "Egyén hozzáadása azonosító alapján";
$pgv_lang["choose_file_type"]					= "Fájltípus választása";
$pgv_lang["file_information"]					= "Fájl információ";
$pgv_lang["clear_chart"]					= "Grafikon törlése";
$pgv_lang["loading"]						= "Betöltés";
$pgv_lang["chart_new"]						= "Családfa grafikon";
$pgv_lang["clipping_privacy"]					= "Néhány elemet nem sikerült hozzáadni személyes adatok védelme miatt";
$pgv_lang["search_soundextype"]					= "Hangzási típus:";
$pgv_lang["search_more_chars"]      				= "Több mint egy betűt adjon meg";
$pgv_lang["search_general"]					= "Általános keresés";
$pgv_lang["search_asso_text"]					= "Mutassuk a kapcsolódó személyeket/családokat";
$pgv_lang["search_geds"]					= "Amelyik GEDCOM-okban keress";
$pgv_lang["search_asso_label"]					= "Kapcsolatok";
$pgv_lang["associate"]						= "kapcsolat";
$pgv_lang["search_tagfoff"]					= "Igen";
$pgv_lang["search_tagfon"]					= "Kizárása a nem genealógiai adatoknak";
$pgv_lang["confirm_delete_repo"]				= "Biztos ki akarja törölni ezt a Szervezetet az adatbázisból?";
$pgv_lang["other_repo_records"]					= "Adatok amik ehhez a Szervezethez kapcsolódnak:";
$pgv_lang["repo_info"]						= "Szervezet Információ";
$pgv_lang["total_repositories"]					= "Szervezetek";
$pgv_lang["find_repository"]					= "Szervezet Keresés";
$pgv_lang["repos_found"]					= "Talált Szervezetek";
$pgv_lang["repo_list"]						= "Szervezet Lista";
$pgv_lang["results_per_page"]					= "Oldalankénti találat";
$pgv_lang["other_searches"]					= "Egyéb keresések";
$pgv_lang["find_source"]					= "Találj Forrást";
$pgv_lang["search_tagfilter"]					= "Szűrő nélkül";
$pgv_lang["search_prtall"]					= "Az összes név";
$pgv_lang["search_prthit"]					= "Talált nevek";
$pgv_lang["search_prtnames"]					= "Személyek<br />neveit kiírni:";
$pgv_lang["search_sources"]					= "Források";
$pgv_lang["search_indis"]					= "Személyek";
$pgv_lang["search_fams"]					= "Családok";
$pgv_lang["search_inrecs"]					= "Keress";
$pgv_lang["search_russell"]					= "Russell";
$pgv_lang["search_DM"]						= "Daitch-Mokotoff";
//-- SOURCELIST FILE MESSAGES
$pgv_lang["titles_found"]               			= "cím";
//-- SOURCE FILE MESSAGES
$pgv_lang["source_info"]					= "Forrás információ";
$pgv_lang["other_records"]					= "Erre a forrásra hivatkozó rekordok:";
$pgv_lang["people"]						= "Személyek";
$pgv_lang["families"]						= "Családok";
$pgv_lang["total_sources"]					= "Források száma";
//-- BUILDINDEX FILE MESSAGES
$pgv_lang["invalid_gedformat"]  				= "Érvénytelen GEDCOM 5.5 formátum";
$pgv_lang["exec_time"]						= "Végrehajtási idő:";
$pgv_lang["unable_to_create_index"]				= "Az index állomány nem hozható létre. Bizonyosodjon meg arról, hogy a megfelelő írásjogok be vannak állítva a PhpGedView könyvtárra. A jogokat vissza lehet állítani, miután az index-állomány kiírásra került.";
$pgv_lang["changes_present"]					= "Az aktuális GEDCOM -nak vannak függőben változtatásai. Ha folytatja az importálást akkor ezek a függőben levő változtatások azonnal bekerülnek az adatbázisba. Meg kellene tekintenie a függőben levő változtatásokat még mielőtt folytatná az importálást.";
$pgv_lang["widow"] 						= "Özvegyasszony";
$pgv_lang["widower"] 						= "Özvegyember";
$pgv_lang["widow"] 						= "Özvegy";
$pgv_lang["leaves"] 						= "Levelek";
$pgv_lang["roots"]		 				= "Gyökerek";
$pgv_lang["sec"]						= "mp.";
//-- INDIVIDUAL AND FAMILYLIST FILE MESSAGES
$pgv_lang["total_fams"]						= "Családok száma";
$pgv_lang["total_indis"]					= "Személyek száma";
$pgv_lang["lifespan_chart"] 					= "Élettartam grafikon";
$pgv_lang["include_family"] 					= "Vegyük bele a köztes családot";
$pgv_lang["timeline_controls"] 					= "Idővonal kontroll";
$pgv_lang["timeline_scrollSpeed"] 				= "Sebesség";
$pgv_lang["timeline_endYear"] 					= "Utolsó év";
$pgv_lang["timeline_beginYear"] 				= "Kezdő év";
$pgv_lang["notes"]						= "Megjegyzések";
$pgv_lang["ssourcess"]						= "Források";
$pgv_lang["media"]						= "Média";
$pgv_lang["name_contains"]					= "Név tartalmazza:";
$pgv_lang["filter"]						= "Szűrő";
$pgv_lang["find_individual"]					= "Személy azonosítójára keresés";
$pgv_lang["find_familyid"]              			= "Család azonosítójára keresés";
$pgv_lang["b.c."]         					= "I.E.";
$pgv_lang["find_sourceid"]					= "Forrás azonosítójának keresése";
$pgv_lang["magnify"]						= "Nagyít";
$pgv_lang["find_specialchar"]					= "Speciális karakter keresése";
$pgv_lang["skip_surnames"]					= "Teljes nevek listája";
$pgv_lang["show_surnames"]					= "Vezetéknevek listája";
$pgv_lang["all"]						= "Mind";
$pgv_lang["hidden"]						= "Rejtett";
$pgv_lang["confidential"]					= "Bizalmas";
$pgv_lang["alpha_index"]					= "Ábécés index";
$pgv_lang["firstname_alpha_index"] 				= "Keresztnév ábécés indexe";
$pgv_lang["name_list"] 						= "Név lista";
//-- TIMELINE FILE MESSAGES
$pgv_lang["age"]						= "Életkor";
$pgv_lang["year1"]						= "év";
$pgv_lang["month1"]						= "hónap";
$pgv_lang["day1"]						= "nap";
$pgv_lang["years"]						= "év";
$pgv_lang["months"]						= "hónap";
$pgv_lang["days"]						= "nap";
$pgv_lang["timeline_title"]					= "PhpGedView kronológia";
$pgv_lang["timeline_chart"]					= "Kronológia";
$pgv_lang["remove_person"]					= "Személy visszavonása";
$pgv_lang["show_age"]						= "életkor jelző";
$pgv_lang["no_auth_needed"]					= "Nincs azonosítás";
$pgv_lang["digest_auth"]					= "Kivonatos azonosítás";
$pgv_lang["basic_auth"]						= "Alapvető azonosítás";
$pgv_lang["basic_auth_failure"]					= "Ezt a forrást csak érvényes felhasználónévvel és jelszóval érheti el";
$pgv_lang["basic_realm"]					= "PhpGedView azonosítási rendszer";
$pgv_lang["add_another"]					= "Új személy hozzáadása:<br />Személyi azonosító:";
$pgv_lang["find_id"]						= "Azonosító";
$pgv_lang["show"]						= "Mutat";
$pgv_lang["year"]						= "Év:";
$pgv_lang["timeline_instructions"]				= "Az elterjedtebb böngészők támogatják a szövegdobozok grafikonon belüli mozgatását.";
$pgv_lang["zoom_in"]						= "Nagyítás";
$pgv_lang["zoom_out"]						= "Kicsinyítés";
$pgv_lang["cal_gregorian"]            				= "Gregorián";
$pgv_lang["cal_julian"]               				= "Juliánusz";
$pgv_lang["cal_french"]               				= "Francia";
$pgv_lang["cal_jewish"]               				= "Zsidó";
$pgv_lang["cal_hebrew"]               				= "Héber";
$pgv_lang["cal_jewish_and_gregorian"] 				= "Zsidó és Gregorián";
$pgv_lang["cal_hebrew_and_gregorian"] 				= "Héber és Gregorián";
$pgv_lang["cal_hijri"]                				= "Hijri";
$pgv_lang["cal_arabic"]               				= "Arab";

//-- MONTH NAMES
$pgv_lang["jan"]						= "január";
$pgv_lang["feb"]						= "február";
$pgv_lang["mar"]						= "március";
$pgv_lang["apr"]						= "április";
$pgv_lang["may"]						= "május";
$pgv_lang["jun"]						= "június";
$pgv_lang["jul"]						= "július";
$pgv_lang["aug"]						= "augusztus";
$pgv_lang["sep"]						= "szeptember";
$pgv_lang["oct"]						= "október";
$pgv_lang["nov"]						= "november";
$pgv_lang["dec"]						= "december";
$pgv_lang["vend"]         = "Vendémiaire";
$pgv_lang["brum"]         = "Brumaire";
$pgv_lang["frim"]         = "Frimaire";
$pgv_lang["nivo"]         = "Nivôse";
$pgv_lang["pluv"]         = "Pluviôse";
$pgv_lang["vent"]         = "Ventôse";
$pgv_lang["germ"]         = "Germinal";
$pgv_lang["flor"]         = "Floréal";
$pgv_lang["prai"]         = "Prairial";
$pgv_lang["mess"]         = "Messidor";
$pgv_lang["ther"]         = "Thermidor";
$pgv_lang["fruc"]         = "Fructidor";
$pgv_lang["comp"]         = "jours complémentaires";
$pgv_lang["tsh"]          					= "Tisri";
$pgv_lang["csh"]          					= "Hesván";
$pgv_lang["ksl"]          					= "Kiszlév";
$pgv_lang["tvt"]          					= "Tévész";
$pgv_lang["shv"]          					= "Svát";
$pgv_lang["adr"]          					= "Ádár";
$pgv_lang["adr_leap_year"]					= "Ádár risón";
$pgv_lang["ads"]          					= "Ádár séni";
$pgv_lang["nsn"]          					= "Niszán";
$pgv_lang["iyr"]          					= "Ijár";
$pgv_lang["svn"]          					= "Sziván";
$pgv_lang["tmz"]          					= "Tamuz";
$pgv_lang["aav"]          					= "Áv";
$pgv_lang["ell"]          					= "Elul";
$pgv_lang["muhar"]        					= "Moharrem";
$pgv_lang["safar"]        					= "Safar";
$pgv_lang["rabia"]        					= "Rébi el avvel";
$pgv_lang["rabit"]        					= "Rébi el accher";
$pgv_lang["jumaa"]        					= "Dsemádi el avvel";
$pgv_lang["jumat"]        					= "Dsemádi el accher";
$pgv_lang["rajab"]        					= "Redseb";
$pgv_lang["shaab"]        					= "Sabán";
$pgv_lang["ramad"]        					= "Ramadán";
$pgv_lang["shaww"]        					= "Sevvál";
$pgv_lang["dhuaq"]        					= "Dsül kade";
$pgv_lang["dhuah"]        					= "Dsül hedse";
$pgv_lang["abt"]						= "körülbelül";
$pgv_lang["aft"]						= "után";
$pgv_lang["and"]						= "és";
$pgv_lang["bef"]						= "előtt";
$pgv_lang["bet"]						= "között";
$pgv_lang["cal"]						= "számított";
$pgv_lang["est"]						= "becsült";
$pgv_lang["from"]						= "kezdettel";
$pgv_lang["int"]						= "sértetlenség";
$pgv_lang["to"]							= "bezárólag";
$pgv_lang["cir"]						= "körülbelül";
$pgv_lang["apx"]						= "megközelítőleg";
//-- Admin File Messages
$pgv_lang["user_admin"]						= "Felhasználókezelés";
$pgv_lang["password_mismatch"]					= "A jelszavak nem egyeznek";
$pgv_lang["enter_username"]					= "Adja meg a felhasználónevet";
$pgv_lang["enter_fullname"]					= "Adja meg a teljes nevét";
$pgv_lang["enter_password"]					= "Adja meg a jelszavát";
$pgv_lang["confirm_password"]					= "Ismételje meg a jelszót";
$pgv_lang["save"]						= "Mentés";
$pgv_lang["delete"]						= "Töröl";
$pgv_lang["edit"]						= "Szerkeszt";
$pgv_lang["no_login"]						= "Nem sikerült azonosítani a felhasználót.";
$pgv_lang["relationship_male_1_is_the_2_of_3"] 			= "%1\$s a %2\$s -ik a %3\$s -ból/ből.";
$pgv_lang["relationship_female_1_is_the_2_of_3"] 		= "%1\$s a %2\$s -ik a %3\$s -ból/ből.";
$pgv_lang["n_x_maternal_uncle_bm"]	    			= "%2\$d x dédnagybácsi";
$pgv_lang["n_x_paternal_uncle_bm"]				= "%2\$d x dédnagybácsi";
$pgv_lang["sosa_uncle_bm_7"] 					= "dédnagybácsi";
$pgv_lang["sosa_uncle_bm_6"] 					= "dédnagybácsi";
$pgv_lang["sosa_uncle_bm_5"] 					= "dédnagybácsi";
$pgv_lang["sosa_uncle_bm_4"] 					= "dédnagybácsi";
$pgv_lang["sosa_uncle_bm_3"] 					= "nagybácsi";
$pgv_lang["sosa_uncle_bm_2"] 					= "nagybácsi";
$pgv_lang["removed_descending_20"] 				= "húszszor eltávolítva lefelé";
$pgv_lang["removed_descending_19"] 				= "tizenkilencszer eltávolítva lefelé";
$pgv_lang["removed_descending_18"] 				= "tizennyolcszor eltávolítva lefelé";
$pgv_lang["removed_descending_17"] 				= "tizenhétszer eltávolítva lefelé";
$pgv_lang["removed_descending_16"] 				= "tizenhatszor eltávolítva lefelé";
$pgv_lang["removed_descending_15"] 				= "tizenötször eltávolítva lefelé";
$pgv_lang["removed_descending_14"] 				= "tizennégyszer eltávolítva lefelé";
$pgv_lang["removed_descending_14"] 				= "tizenháromszor eltávolítva lefelé";
$pgv_lang["removed_descending_13"] 				= "tizenháromszor eltávolítva lefelé";
$pgv_lang["removed_descending_12"] 				= "tizenkétszer eltávolítva lefelé";
$pgv_lang["removed_descending_11"] 				= "tizenegyszer eltávolítva lefelé";
$pgv_lang["removed_descending_10"] 				= "tízszer eltávolítva lefelé";
$pgv_lang["removed_descending_9"]  				= "kilencszer eltávolítva lefelé";
$pgv_lang["removed_descending_8"]  				= "nyolcszor eltávolítva lefelé";
$pgv_lang["removed_descending_7"]  				= "hétszer eltávolítva lefelé";
$pgv_lang["removed_descending_6"]  				= "hatszor eltávolítva lefelé";
$pgv_lang["removed_descending_5"]  				= "ötször eltávolítva lefelé";
$pgv_lang["removed_descending_4"]  				= "négyszer eltávolítva lefelé";
$pgv_lang["removed_descending_3"]  				= "háromszor eltávolítva lefelé";
$pgv_lang["removed_descending_2"]  				= "kétszer eltávolítva lefelé";
$pgv_lang["removed_descending_1"]  				= "egyszer eltávolítva lefelé";
$pgv_lang["removed_ascending_20"]  				= "húszszor eltávolítva felfelé";
$pgv_lang["removed_ascending_19"]  				= "tizenkilencszer eltávolítva felfelé";
$pgv_lang["removed_ascending_18"]  				= "tizennyolcszor eltávolítva felfelé";
$pgv_lang["removed_ascending_17"]  				= "tizenhétszer eltávolítva felfelé";
$pgv_lang["removed_ascending_16"]  				= "tizenhatszor eltávolítva felfelé";
$pgv_lang["removed_ascending_15"]  				= "tizenötször eltávolítva felfelé";
$pgv_lang["removed_ascending_14"]  				= "tizennégyszer eltávolítva felfelé";
$pgv_lang["removed_ascending_13"]  				= "tizenháromszor eltávolítva felfelé";
$pgv_lang["removed_ascending_12"]  				= "tizenkétszer eltávolítva felfelé";
$pgv_lang["removed_ascending_11"]  				= "tizenegyszer eltávolítva felfelé";
$pgv_lang["removed_ascending_10"]  				= "tízszer eltávolítva felfelé";
$pgv_lang["removed_ascending_9"]   				= "kilencszer eltávolítva felfelé";
$pgv_lang["removed_ascending_8"]   				= "nyolcszor eltávolítva felfelé";
$pgv_lang["removed_ascending_7"]   				= "hétszer eltávolítva felfelé";
$pgv_lang["removed_ascending_6"]   				= "hatszor eltávolítva felfelé";
$pgv_lang["removed_ascending_5"]   				= "ötször eltávolítva felfelé";
$pgv_lang["removed_ascending_4"]   				= "négyszer eltávolítva felfelé";
$pgv_lang["removed_ascending_3"]   				= "háromszor eltávolítva felfelé";
$pgv_lang["removed_ascending_2"]   				= "kétszer eltávolítva felfelé";
$pgv_lang["removed_ascending_1"]   				= "egyszer eltávolítva felfelé";
$pgv_lang["female_cousin_n"]            			= "%d x unokaöcs";
$pgv_lang["female_cousin_20"]           			= "huszadik unokaöcs";
$pgv_lang["female_cousin_19"]           			= "tizenkilencedik unokaöcs";
$pgv_lang["female_cousin_18"]           			= "tizennyolcadik unokaöcs";
$pgv_lang["female_cousin_17"]           			= "tizenhetedik unokaöcs";
$pgv_lang["female_cousin_16"]           			= "tizenhatodik unokaöcs";
$pgv_lang["female_cousin_15"]           			= "tizenötödik unokaöcs";
$pgv_lang["female_cousin_14"]           			= "tizennegyedik unokaöcs";
$pgv_lang["female_cousin_13"]           			= "tizenharmadik unokaöcs";
$pgv_lang["female_cousin_13"]           			= "tizenharmadik unokaöcs";
$pgv_lang["female_cousin_12"]           			= "tizenkettedik unokaöcs";
$pgv_lang["female_cousin_11"]           			= "tizenegyedik unokaöcs";
$pgv_lang["female_cousin_10"]           			= "tizedik unokaöcs";
$pgv_lang["female_cousin_9"]            			= "kilencedik unokaöcs";
$pgv_lang["female_cousin_8"]            			= "nyolcadik unokaöcs";
$pgv_lang["female_cousin_7"]            			= "hetedik unokaöcs";
$pgv_lang["female_cousin_6"]            			= "hatodik unokaöcs";
$pgv_lang["female_cousin_5"]            			= "ötödik unokaöcs";
$pgv_lang["female_cousin_4"]            			= "negyedik unokaöcs";
$pgv_lang["female_cousin_3"]            			= "harmadik unokaöcs";
$pgv_lang["female_cousin_2"]            			= "második unokaöcs";
$pgv_lang["female_cousin_1"]            			= "első unokaöcs";
$pgv_lang["male_cousin_n"]              			= "%d x unokaöcs";
$pgv_lang["male_cousin_20"]             			= "huszadik unokaöcs";
$pgv_lang["male_cousin_19"]             			= "tizenkilencedik unokaöcs";
$pgv_lang["male_cousin_18"]             			= "tizennyolcadik unokaöcs";
$pgv_lang["male_cousin_17"]             			= "tizenhetedik unokaöcs";
$pgv_lang["male_cousin_15"]             			= "tizenötödik unokaöcs";
$pgv_lang["male_cousin_16"]             			= "tizenhatodik unokaöcs";
$pgv_lang["male_cousin_14"]             			= "tizennegyedik unokaöcs";
$pgv_lang["male_cousin_14"]             			= "tizenharmadik unokaöcs";
$pgv_lang["male_cousin_13"]             			= "tizenharmadik unokaöcs";
$pgv_lang["male_cousin_12"]             			= "tizenkettedik unokaöcs";
$pgv_lang["male_cousin_11"]             			= "tizenegyedik unokaöcs";
$pgv_lang["male_cousin_10"]             			= "tizedik unokaöcs";
$pgv_lang["male_cousin_9"]              			= "kilencedik unokaöcs";
$pgv_lang["male_cousin_8"]              			= "nyolcadik unokaöcs";
$pgv_lang["male_cousin_7"]              			= "hetedik unokaöcs";
$pgv_lang["male_cousin_6"]              			= "hatodik unokaöcs";
$pgv_lang["male_cousin_5"]              			= "ötödik unokaöcs";
$pgv_lang["male_cousin_4"]              			= "negyedik unokaöcs";
$pgv_lang["male_cousin_3"]              			= "harmadik unokaöcs";
$pgv_lang["male_cousin_2"]              			= "második unokaöcs";
$pgv_lang["male_cousin_1"]              			= "első unokaöcs";
$pgv_lang["n_x_maternal_aunt_bm"]	    			= "%2\$d x dédnagynéni";
$pgv_lang["n_x_paternal_aunt_bm"]				= "%2\$d x dédnagynéni";
$pgv_lang["sosa_aunt_bm_2"] 					= "nagynéni";
$pgv_lang["sosa_aunt_bm_3"] 					= "nagynéni";
$pgv_lang["sosa_aunt_bm_7"] 					= "dédnagynéni";
$pgv_lang["sosa_aunt_bm_6"] 					= "dédnagynéni";
$pgv_lang["n_x_maternal_aunt"]	    				= "%2\$d x dédnagynéni";
$pgv_lang["n_x_paternal_aunt"]					= "%2\$d x dédnagynéni";
$pgv_lang["sosa_aunt_bm_5"] 					= "dédnagynéni";
$pgv_lang["sosa_aunt_bm_4"] 					= "dédnagynéni";
$pgv_lang["sosa_aunt_7"] 					= "dédnagynéni";
$pgv_lang["sosa_aunt_6"] 					= "dédnagynéni";
$pgv_lang["sosa_aunt_5"] 					= "dédnagynéni";
$pgv_lang["sosa_aunt_4"] 					= "dédnagynéni";
$pgv_lang["sosa_aunt_3"] 					= "dédnagynéni";
$pgv_lang["sosa_aunt_2"] 					= "dédnagynéni";
$pgv_lang["n_x_maternal_uncle"]	    				= "%2\$d x dédnagybácsi";
$pgv_lang["n_x_paternal_uncle"]					= "%2\$d x dédnagybácsi";
$pgv_lang["sosa_uncle_7"] 					= "dédnagybácsi";
$pgv_lang["sosa_uncle_6"] 					= "dédnagybácsi";
$pgv_lang["sosa_uncle_5"] 					= "dédnagybácsi";
$pgv_lang["sosa_uncle_4"] 					= "dédnagybácsi";
$pgv_lang["sosa_uncle_3"] 					= "nagybácsi";
$pgv_lang["sosa_uncle_2"] 					= "nagybácsi";
$pgv_lang["n_x_granddaughter_from_daughter"] 			= "%3\$d x dédunoka (lány)";
$pgv_lang["n_x_granddaughter_from_son"] 			= "%3\$d x dédunoka (lány)";
$pgv_lang["n_x_grandson_from_daughter"]	  			= "%3\$d x dédunoka (fiú)";
$pgv_lang["n_x_grandson_from_son"]	  			= "%3\$d x dédunoka (fiú)";
$pgv_lang["bosa_15"] 						= "lány dédunoka";
$pgv_lang["bosa_13"] 						= "lány dédunoka";
$pgv_lang["bosa_11"] 						= "lány dédunoka";
$pgv_lang["bosa_9"] 						= "lány dédunoka";
$pgv_lang["bosa_14"] 						= "fiú dédunoka";
$pgv_lang["bosa_12"] 						= "fiú dédunoka";
$pgv_lang["bosa_10"] 						= "fiú dédunoka";
$pgv_lang["bosa_8"] 						= "fiú dédunoka";
$pgv_lang["bosa_7"] 						= "lány unoka";
$pgv_lang["bosa_6"] 						= "fiú unoka";
$pgv_lang["bosa_5"] 						= "lány unoka";
$pgv_lang["bosa_4"] 						= "fiú unoka";
$pgv_lang["bosa_3"] 						= "lány gyermek";
$pgv_lang["bosa_2"] 						= "fiú gyermek";
$pgv_lang["n_x_sisters_son"]	  				= "%2\$d x dédunokaöcs";
$pgv_lang["n_x_sisters_daughter"] 				= "%2\$d x dédunokahúg";
$pgv_lang["bosa_sisters_offspring_7"] 				= "dédunokahúg";
$pgv_lang["bosa_sisters_offspring_6"] 				= "dédunokaöcs";
$pgv_lang["bosa_sisters_offspring_5"] 				= "dédunokahúg";
$pgv_lang["bosa_sisters_offspring_4"] 				= "dédunokaöcs";
$pgv_lang["bosa_sisters_offspring_3"] 				= "unokahúg";
$pgv_lang["n_x_brothers_son"]	  				= "%2\$d x dédunokaöcs";
$pgv_lang["bosa_sisters_offspring_2"] 				= "unokaöcs";
$pgv_lang["n_x_brothers_daughter"] 				= "%2\$d x dédunokahúg";
$pgv_lang["n_x_brothers_son"]	  				= "%2\$d x dédunokaöcs";
$pgv_lang["bosa_brothers_offspring_7"] 				= "dédunokahúg";
$pgv_lang["bosa_brothers_offspring_6"] 				= "dédunokaöcs";
$pgv_lang["bosa_brothers_offspring_5"] 				= "dédunokahúg";
$pgv_lang["bosa_brothers_offspring_4"] 				= "dédunokaöcs";
$pgv_lang["daughter_in_law"]					= "Menye";
$pgv_lang["son_in_law"]		        			= "Veje";
$pgv_lang["bosa_brothers_offspring_3"] 				= "unokahúg";
$pgv_lang["son_in_law"]		        			= "unokaöcs";
$pgv_lang["bosa_brothers_offspring_2"] 				= "unokaöcs";
$pgv_lang["step_son"]		        			= "féltestvér (fiú)";
$pgv_lang["step_daughter"]	    				= "féltestvér (lány)";
$pgv_lang["step_son"]		        			= "féltestvér";
$pgv_lang["daughter_in_law"]					= "unokahúg";
$pgv_lang["son_in_law"]		        			= "unokaöcs";
$pgv_lang["sister_in_law"]		    			= "Sógornő";
$pgv_lang["brother_in_law"]		    			= "Sógor";
$pgv_lang["father_in_law"]		    			= "Após";
$pgv_lang["mother_in_law"]		    			= "Anyós";
$pgv_lang["file_not_exists"]    				= "Ezen a néven nem létezik GEDCOM-állomány";
$pgv_lang["research_assistant"]					= "Kutatási Segéd";
$pgv_lang["utf8_to_ansi"]					= "Át szeretné konvertálni ezt a GEDCOM-ot UTF-8-ról ANSI (ISO-8859-1)-ra?";
$pgv_lang["malecousin"]						= "Fiú unokatestvér";
$pgv_lang["femalecousin"]					= "Lány unokatestvér";
$pgv_lang["firstcousin"]					= "Első unoka testvér";

//-- Relationship chart messages
$pgv_lang["relationship_chart"]					= "Rokonsági fok";
$pgv_lang["person1"]						= "1. személy";
$pgv_lang["person2"]						= "2. személy";
$pgv_lang["granddaughter"]					= "Unoka, lány";
$pgv_lang["grandson"]						= "Unoka, fiú";
$pgv_lang["uncle"]						= "Nagybácsi";
$pgv_lang["aunt"]						= "Nagynéni";
$pgv_lang["grandchild"]						= "Unoka";
$pgv_lang["no_link_found"]					= "A két személy között nem lelhető fel rokoni kapcsolat.";
$pgv_lang["sibling"]						= "Testvér";
$pgv_lang["follow_spouse"]					= "Házastárson keresztüli rokonság ellenőrzése";
$pgv_lang["timeout_error"]					= "A program túllépte az időkorlátot, mielőtt rokonsági kapcsolatot talált volna.";
$pgv_lang["son"]						= "Fiúgyermek";
$pgv_lang["daughter"]						= "Lánygyermek";
$pgv_lang["brother"]						= "Fiútestvér";
$pgv_lang["sister"]						= "Lánytestvér";
$pgv_lang["relationship_to_me"]					= "Rokonsági kapcsolat hozzám";
$pgv_lang["rela_wife"]						= "Rokonsági kapcsolat a feleséghez";
$pgv_lang["rela_husb"]						= "Rokonsági kapcsolat a férjhez";
$pgv_lang["next_path"]						= "Alternatív útvonal";
$pgv_lang["show_path"]						= "Útvonal";
$pgv_lang["line_up_generations"]        			= "Azonos generációk igazítása";
$pgv_lang["oldest_top"]             				= "Legidősebbet felülre";
//-- GEDCOM edit utility
$pgv_lang["check_delete"]					= "Valóban törli ezt a GEDCOM-adatot?";
$pgv_lang["access_denied"]					= "<b>Hozzáférés megtagadva</b><br />Megfelelő jogosultság hiányában nem tekintheti meg ezt a forrást.";
$pgv_lang["changes_exist"]					= "A jelenlegi GEDCOM megváltozott.";
$pgv_lang["find_place"]						= "Hely keresése";
$pgv_lang["close_window"]					= "Ablak bezárás";
$pgv_lang["close_window_without_refresh"] 			= "Az ablak frissítése nélkül bezár";
$pgv_lang["place_contains"]					= "Hely tartalmazza:";
$pgv_lang["add"]						= "Hozzáadás";
$pgv_lang["custom_event"]					= "Egyéni esemény";
$pgv_lang["delete_person"]					= "A személy törlése";
$pgv_lang["confirm_delete_person"]				= "Biztosan törölni szeretné ezt a személyt a GEDCOM-állományból?";
$pgv_lang["find_media"]						= "Média keresése";
$pgv_lang["set_link"]						= "Kapcsolat létrehozása";
$pgv_lang["delete_source"]					= "Forrás törlése";
$pgv_lang["confirm_delete_source"]				= "Biztosan törölni szeretné ezt a forrást a GEDCOM-állományból?";
$pgv_lang["find_family"]					= "Család keresése";
$pgv_lang["find_fam_list"]              			= "Család-lista keresése";
$pgv_lang["edit_name"]						= "Név szerkesztése";
$pgv_lang["delete_name"]					= "Név törlése";
$pgv_lang["select_date"]                			= "Dátumválasztás";
$pgv_lang["user_cannot_edit"]           			= "Ez a felhasználó nem szerkesztheti ezt a GEDCOM-állományt.";
$pgv_lang["bdm"]						= "Születések, Halálozások, Házasságok";
$pgv_lang["ged_noshow"]						= "Ezt az oldalt az internetcím adminisztrátora lekapcsolta.";

//-- calendar.php messages
$pgv_lang["on_this_day"]					= "Ezen a napon az Ön múltjában...";
$pgv_lang["in_this_month"]					= "Ebben a hónapban az Ön múltjában ...";
$pgv_lang["in_this_year"]               			= "Ebben az évben az Ön múltjában...";
$pgv_lang["year_anniversary"]					= "#year_var# éves évforduló";
$pgv_lang["today"]						= "Ma";
$pgv_lang["day"]						= "Nap:";
$pgv_lang["month"]						= "Hónap";
$pgv_lang["showcal"]						= "Szűrés a megmutatott eseményekre:";
$pgv_lang["anniversary"]					= "Évforduló";
$pgv_lang["anniversary_calendar"]				= "Évfordulók";
$pgv_lang["sunday"]						= "Vasárnap";
$pgv_lang["monday"]						= "Hétfő";
$pgv_lang["tuesday"]						= "Kedd";
$pgv_lang["wednesday"]						= "Szerda";
$pgv_lang["thursday"]						= "Csütörtök";
$pgv_lang["friday"]						= "Péntek";
$pgv_lang["saturday"]						= "Szombat";
$pgv_lang["viewday"]						= "Adott napon";
$pgv_lang["viewmonth"]						= "Adott hónapban";
$pgv_lang["viewyear"]                   			= "Adott évben";
$pgv_lang["all_people"]						= "Az összes személy";
$pgv_lang["living_only"]					= "Élő személyek";
$pgv_lang["recent_events"]					= "Az utóbbi évekből (&lt; 100 év)";
$pgv_lang["day_not_set"]                			= "A nap nincs megadva";
//-- upload media messages
$pgv_lang["record_not_removed"]					= "Adat #xref# nem sikerült törölni a GEDCOM -ból.";
$pgv_lang["record_not_added"]					= "Adat #xref# nem lehetett hozzáadni a GEDCOM -hoz.";
$pgv_lang["record_added"]					= "Adat #xref# sikeresen hozzáadva a GEDCOM -ból.";
$pgv_lang["record_removed"]					= "Adat #xref# sikeresen törölve a GEDCOM -ból.";
$pgv_lang["record_removed"]					= "Adat #xref# sikeresen törölve a DEGCOM -ból.";
$pgv_lang["record_not_updated"]					= "Adat #pid# nem sikerült frissiteni.";
$pgv_lang["record_updated"]					= "Adat #pid# sikeresen frissítve.";
//-- user self registration module
//$pgv_lang["no_pw_or_account"]		= "Ha még nincs felhasználóneve, vagy elfelejtette a jelszavát, csak kattintson a <b>Bejelentkezés</b> gombra";
$pgv_lang["lost_password"]					= "Elfelejtette a jelszavát?";
$pgv_lang["mandatory"] 						= "A * -gal jelölt mezők, kötelezők.";
$pgv_lang["requestpassword"]					= "Új jelszó kérése";
$pgv_lang["no_account_yet"]					= "Még nem regisztrálta magát?";
$pgv_lang["requestaccount"]					= "Regisztráció kérése";
$pgv_lang["emailadress"]					= "Email cím";
$pgv_lang["mail01_line01"]					= "Kedves #user_fullname#!";
$pgv_lang["mail01_line02"]					= "Az ön email címével ( #user_email# ) belépést kezdeményeztek ( #SERVER_NAME# ).";
$pgv_lang["mail01_line03"]					= "A következő adatokat használtuk.";
$pgv_lang["mail01_line04"]					= "Kérem kattintson a következő linkre, és töltse ki a kért adatokat, hogy ellenőrizni tudjuk az adatait és az email címét.";
$pgv_lang["mail01_line05"]					= "Ha nem Ön kérte ezt az adatot, akkor nyugodtan törölheti ezt az üzenetet.";
$pgv_lang["mail01_line06"]					= "Nem fog kapni több levelet a rendszertől, mivel a felhasználói azonosítója 7 napon belül további figyelmeztetés nélkül törlésre kerül.";
$pgv_lang["mail02_line04a"]					= "Ön kapni fog egy email-t amint a jövendő felhasználó ellenőrizte magát. Csak az ellenőrzés után tud a felhasználó bejelentkezni az ön beavatkozása nélkül.";
$pgv_lang["mail01_subject"]					= "Az Ön regisztrációja a(z) #SERVER_NAME# szerveren";
$pgv_lang["mail02_line01"]					= "Kedves Adminisztrátor!";
$pgv_lang["mail02_line02"]					= "Egy felhasználó új azonosítót készített a(z) ( #SERVER_NAME# ) szerveren.";
$pgv_lang["pls_note06a"] 					= "Mi most küldeni fogunk egy ellenőrző email -t erre a címre ( #user_email# ). Önnek meg kell erősítenie a számla kérését az ellenőrző email alapján. Ha ön nem erősíti meg a számla kérését akkor automatikusan 7 nap után elutasításra kerül a kérelme. Önnek egy új kérelmet kell írnia.<br /><br />Miután követte az instrukciókat az ellenőrző email-ben, utána tud csak bejelentkezni. Ahhoz hogy bejelentkezzen tudnia kell a felhasználónevét és a jelszavát.<br /><br />";
$pgv_lang["mail02_line03"]					= "A felhasználó kapott egy emailt a fontosabb adatokkal, ahhoz hogy ellenőrizni tudja az azonosítóját.";
$pgv_lang["mail02_line04"]					= "Amint a felhasználó elvégezte ezt az ellenőrzést, email-ben kap értesítést, így jogot adhat a felhasználónak a bejelentkezéshez.";
$pgv_lang["mail02_subject"]					= "Új regisztráció a(z) #SERVER_NAME# szerveren";
$pgv_lang["hashcode"]						= "Ellenőrző kód:";
$pgv_lang["thankyou"]						= "Kedves #user_fullname#!<br />Köszönjük a regisztrációt";
$pgv_lang["pls_note06"]						= "Kapni fog egy ellenőrző emailt erre a címre ( #user_email# ). Ezt a levelet használja az azonosítója aktiválásához; ha hét napon belül nem sikerül az aktiválás, áthelyezésre kerül az azonosítója (akkor újra megkísérelheti a regisztrációt).<br /><br />Ahhoz hogy bejelentkezzen az oldalra, tudnia kell az azonosítóját, és a jelszavát.";
$pgv_lang["registernew"]					= "Új azonosító visszaigazolása";
$pgv_lang["mail03_line03a"]					= "Nem kell mást csinálnia, a felhasználó most már be tud jelentkezni.";
$pgv_lang["user_verify"]					= "Felhasználó ellenőrzése";
$pgv_lang["send"]						= "Elküld";
$pgv_lang["pls_note10a"]					= "Most már be tud jelentkezni a felhasználó nevével és a kódjával.";
$pgv_lang["pls_note07"]						= "~#pgv_lang[user_verify]#~<br /><br />Kérem írja be a felhasználónevét, a jelszavát és az email-ben az ellenőrzéshez kapott aktiváló kódot.";
$pgv_lang["pls_note08"]						= "A <b>#user_name#</b> felhasználó adatait leellenőriztük.";
$pgv_lang["mail03_line01"]					= "Kedves Adminisztrátor!";
$pgv_lang["mail03_line02"]					= "#newuser[username]# ( #newuser[fullname]# ) ellenőrizte a regisztrációs adatait.";
$pgv_lang["mail03_line03"]					= "Kérem, kattintson a lenti hivatkozásra, jelentkezzen be, és adjon a felhasználónak jogot a bejelntkezéshez.";
$pgv_lang["mail03_subject"]					= "Új ellenőrzés a(z) #SERVER_NAME# szerveren";
$pgv_lang["pls_note09"]						= "Önt regisztrált felhasználóként azonosítottuk.";
$pgv_lang["pls_note10"]						= "Az adminisztrátort értesítettük. Amint ő megadja az engedélyt a bejelentkezéshez, be tud majd jelentkezni a felhasználónevével és jelszavával.";
$pgv_lang["data_incorrect"]					= "Hibás adat!<br />Kérem próbálja újra!";
$pgv_lang["user_not_found"]					= "Nem lehetett ellenőrizni a megadott információt. Kérem lépjen vissza, és próbálja meg újra.";
$pgv_lang["lost_pw_reset"]					= "Új jelszó kérése";
$pgv_lang["pls_note11"]						= "Ahhoz hogy a jelszavát megváltoztassa, adja meg a felhasználónevet és az email címét. <br /><br />Emailben küldünk egy speciális URL-t, amely egy igazolást tartalmaz. Meglátogatva azt az internetcímet, megváltoztathatja a jelszavát majd bejelentkezhet az oldalra. Biztonsági okokból, azt a címet ne adja meg másnak, még az oldal adminisztrátorának (ezt nem is kérjük).<br /><br />Amennyiben segítségre van szüksége, lépjen kapcsolatba az oldal adminisztrátorával.";
$pgv_lang["enter_email"]					= "Adjon meg egy e-mail címet";
$pgv_lang["mail04_line01"]					= "Kedves #user_fullname# ...";
$pgv_lang["mail04_line02"]					= "Az Ön felhasználónevéhez új jelszót igényeltek!";
$pgv_lang["mail04_line03"]					= "Ajánlások:";
$pgv_lang["mail04_line04"]					= "Kattintson az alábbi hivatkozásra, jelentkezzen be az új jelszóval majd változtassa meg ahhoz hogy az adatai biztonságban maradjanak.";
$pgv_lang["mail04_line05"]					= "Miután be jelentkezett, válassza a '#pgv_lang[myuserdata]#' linket a '#pgv_lang[mygedview]#' menü alatt és töltse ki a jelszó mezőket hogy megváltoztassa a jelszavát.";
$pgv_lang["mail04_subject"]					= "Adat kérése a(z) #SERVER_NAME# szerveren";
$pgv_lang["pwreqinfo"]						= "Tisztelt Felhasználó!<br /><br />Egy emailt küldtünk a (#user[email]#) címre, amiben benne van az új jelszó.<br /><br />Kérjük, nézze meg a levelesládáját, mert ez a levél perceken belül megérkezhet.<br /><br />Javaslat:<br /><br />Miután megkapta az új jelszavát emailben, jelentkezzen be az új jelszóval majd változtassa meg ahhoz hogy az adatai biztonságban maradjanak.";
$pgv_lang["editowndata"]					= "Felhasználói adataim";
$pgv_lang["myuserdata"]						= "Felhasználói adataim";
$pgv_lang["user_theme"]						= "Az én témám";
$pgv_lang["mgv"]						= "MyGedView";
$pgv_lang["mygedview"]						= "MyGedView Portál";
$pgv_lang["passwordlength"]					= "A jelszónak legalább 6 karakterből kell állnia.";
$pgv_lang["welcome_text_auth_mode_1"]   			= "<center><b>Üdvözöljük ezen a Családfakutató-Honlapon!</b></center><br />A honlapot minden olyan felhasználó látogathatja, akinek van hozzáférési jogosultsága.<br /><br />Amennyiben Önnek már rendelkezik felhasználói jogosultsággal, bejelentkezhet az oldalra. Ha még nem, a megfelelő hivatkozásra kattintva kezdeményezheti annak megszerzését.<br /><br />Miután megerősítette jelentkezését, a honlap adminisztrátora fogadja el, vagy utasítja el az Ön igényét.A pozitív döntésről email-ben kap értesítést.";
$pgv_lang["welcome_text_auth_mode_2"]   			= "<center><b>Üdvözöljük ezen a Családfakutató-Honlapon</b><center><br />A honlaphoz kizárólag a <u>bejelentkezett</u> felhasználók férhetnek hozzá.<br /><br />Amennyiben Önnek már rendelkezik felhasználói jogosultsággal, bejelentkezhet az oldalra. Ha még nem, a megfelelő hivatkozásra kattintva kezdeményezheti annak megszerzését.<br /><br />Miután megerősítette jelentkezését, a honlap adminisztrátora fogadja el, vagy utasítja el az Ön igényét. A pozitív döntésről email-ben kap értesítést.";
$pgv_lang["welcome_text_auth_mode_3"]   			= "<center><b>Üdvözöljük ezen a Családfakutató-Honlapon</b></center><br />A honlaphoz <u>kizárólag családtagok</u> férhetnek hozzá.<br /><br />Amennyiben Önnek már rendelkezik felhasználói jogosultsággal, bejelentkezhet az oldlara. Ha még nem, a megfelelő hivatkozásra kattintva kezdeményezheti annak megszerzését.<br /><br />Miután megerősítette jelentkezését, a honlap adminisztrátora fogadja el, vagy utasítja el az Ön igényét. A pozitív döntésről email-ben kap értesítést.";
$pgv_lang["acceptable_use"]					= "<div class=\"largeError\">Megjegyzés:</div><div class=\"error\">A következő form kitöltésével és elküldésével, Ön elfogadja a következőket:<ul><li>az oldalakon lévő élő személyek személyes adatai védelmezi</li><li>a lenti dobozban írja meg ki a felmenője, vagy adjon meg információt olyan személyről aki szerepelhet az oldalon.</li></ul></div>";
$pgv_lang["welcome_text_cust_head"]				= "<center><b>Üdvözöljük ezen a Családfakutató-Honlapon</b></center><br />A honlapot érvényes felhasználói névvel és jelszóval rendelkező felhasználók látogathatják.<br />";
$pgv_lang["acceptable_use"]					= "<div class=\"largeError\">Megjegyzés:</div><div class=\"error\">Jelen kérdőív kitöltésével Ön elfogadja az alábbiakat:<ul><li>az oldalunkon szereplő élő emberek adatainak bizalmasságát megőrzi,</li><li>illetve az alábbi 'Megjegyzés' szövegdobozban elmagyarázza, hogy ki(k)hez kapcsolódik, vagy információt ad olyan személyről akiről feltételezi, hogy szerepel az oldalunkon.</li></ul></div>";

//-- mygedview page
$pgv_lang["welcome"]						= "Üdvözöljük";
$pgv_lang["upcoming_events"]					= "Következő események";
$pgv_lang["no_events_privacy"]					= "Történik esemény az elkövetkező #pgv_lang[global_num1]# napon, de bizalmas korlátozás miatt nem mutatható.";
$pgv_lang["none_today_privacy"]					= "Történnek események ma, de bizalmas korlátozás miatt nem mutatható.";
$pgv_lang["more_today_privacy"]					= "<br />Több esemény történik ma, de bizalmas korlátozás miatt nem mutatható.";
$pgv_lang["none_today_privacy"]					= "Történnek események ma, de bizalmas korlátozás miatt nem mutatható.";
$pgv_lang["none_today_all"]					= "A mai napon nincs esemény.";
$pgv_lang["none_today_living"]					= "A mai napon nincs esemény az élők között.";
$pgv_lang["more_events_privacy1"]				= "<br />Több esemény történik holnap, de bizalmas korlátozás miatt nem mutatható.";
$pgv_lang["more_events_privacy"]				= "<br />Több esemény történik az elkövetkezendő #pgv_lang[global_num1]# napon, de bizalmas korlátozás miatt nem mutatható.";
$pgv_lang["no_events_privacy1"]					= "Történik esemény holnap, de bizalmas korlátozás miatt nem mutatható.";
$pgv_lang["no_events_all1"]					= "Semmi esemény nincs holnap.";
$pgv_lang["no_events_all"]					= "Semmi esemény nincs a következő #pgv_lang[global_num1]# napon.";
$pgv_lang["no_events_living1"]					= "Semmi esemény nincs holnap az élők között.";
$pgv_lang["cal_download"]					= "Megengedjük a naptári események letöltését?";
$pgv_lang["style3"]						= "Lebegőpanel";
$pgv_lang["style2"]						= "Táblázat";
$pgv_lang["style1"]						= "Lista";
$pgv_lang["style"]						= "Prezentációs stílus";
$pgv_lang["no_events_living"]					= "Semmi esemény nincs az élők között a következő #pgv_lang[global_num1]# napon.";
$pgv_lang["basic_or_all"]					= "Csak a Születés, Halálozás és a Házasságot mutasd?";
$pgv_lang["living_or_all"]					= "Csak az élők eseményeit mutasd?";
$pgv_lang["chat"]						= "Csevegés";
$pgv_lang["no_login_users"]					= "0 bejelentkezett és 0 névtelen felhasználó";
$pgv_lang["login_users"]					= "#pgv_lang[global_num1]# bejelentkezett felhasználó";
$pgv_lang["login_user"]						= "1 bejelentkezett felhasználó";
$pgv_lang["anon_users"]						= "#pgv_lang[global_num1]# névtelen bejelentkezett felhasználó";
$pgv_lang["anon_user"]						= "1 névtelen bejelentkezett felhasználó";
$pgv_lang["users_logged_in"]					= "Bejelentkezett felhasználók";
$pgv_lang["message"]				= "Üzenet";
$pgv_lang["my_messages"]					= "Üzeneteim";
$pgv_lang["date_created"]					= "Adat elküldve:";
$pgv_lang["message_from"]					= "E-mail cím:";
$pgv_lang["message_from_name"]					= "Az Ön neve:";
$pgv_lang["message_to"]						= "Címzett:";
$pgv_lang["message_subject"]					= "Tárgy:";
$pgv_lang["message_body"]					= "Szövegtörzs:";
$pgv_lang["no_to_user"]						= "Nincs megadva címzett. Nem lehet folytatni.";
$pgv_lang["provide_email"]					= "Kérem adja meg az e-mail címét, hogy üzenetére válaszolhassunk. E-mail címét kizárólag ebből a célból fogjuk felhasználni.";
$pgv_lang["reply"]						= "Válasz";
$pgv_lang["favorites"]						= "Kedvencek";
$pgv_lang["message_deleted"]					= "Üzenet törölve";
$pgv_lang["message_sent"]					= "Üzenet elküldve";
$pgv_lang["reset"]						= "Visszaállít";
$pgv_lang["site_default"]					= "Alapértelmezett";
$pgv_lang["mygedview_desc"]					= "Az Ön MyGedView oldalán kiválaszthatja az Önnek kedves személyeket, figyelheti az elkövetkezendő eseményeket, és kapcsolatba léphet más felhasználókkal.";
$pgv_lang["no_messages"]					= "Nincs új üzenete.";
$pgv_lang["clicking_ok"]					= "Kattintson az OK-ra, és egy új ablakban léphet kapcsolatba a #user[fullname]# személlyel";
$pgv_lang["my_favorites"]					= "Kedvenceim";
$pgv_lang["no_favorites"]					= "Önnek nincsenek kijelölt Kedvencei.<br /><br />Ha egy személyt, családot vagy forrást fel kíván venni Kedvencek közé, keresse meg és kattintson a <b>#pgv_lang[add_favorite]#</b> hivatkozásra, vagy használja az alábbi beviteli mezőt az azonosító alapján történő felvételhez. Azonosító szám helyett be írhat egy URL -t és egy címet.";
$pgv_lang["add_to_my_favorites"]				= "Hozzáadás a Kedvencekhez";
$pgv_lang["gedcom_favorites"]					= "Kedvencek ebből a GEDCOM-ból";
$pgv_lang["no_gedcom_favorites"]				= "Nincs kiválasztott kedvenc. Az adminisztrátor adhat olyan kedvenceket, amelyek induláskor megjelennek.";
$pgv_lang["confirm_fav_remove"]					= "Biztosan el kívánja távolítani ezt az elemet a Kedvencek közül?";
$pgv_lang["invalid_email"]					= "Írjon be egy érvényes e-mail címet!";
$pgv_lang["enter_subject"]					= "Írja be az üzenet tárgyát!";
$pgv_lang["enter_body"]						= "Írja be az üzenet szövegét!";
$pgv_lang["confirm_message_delete"]				= "Biztosan töröljük ezt az üzenetet?";
$pgv_lang["message_email1"]					= "Ön a következő üzenetet kapta a következő címről:";
$pgv_lang["message_email2"]					= "A következő üzenetet küldte el egy PhpGedView-felhasználónak:";
$pgv_lang["message_email3"]					= "A következő üzenetet küldte el a PhpGedView-adminisztrátorának:";
$pgv_lang["viewing_url"]					= "Az üzenetet az alábbi linkre kattintva küldheti el";
$pgv_lang["messaging2_help"]					= "Az üzenet elküldésekor kapni fog egy másolatot email-ben, az Ön által megadott email címre";
$pgv_lang["random_picture"]					= "Meglepetés-kép";
$pgv_lang["message_instructions"]				= "<b>Figyelem:</b> Az élő személyek személyes adatait csak a család hozzátartozói és a közeli barátok láthatják. Mielőtt bármilyen személyes adatot megkaphatna, megkérjük hogy ellenőrizze a rokonságát. Lehetséges, hogy elhunyt személyek adatai sem hozzáférhetőek. Ebben az esetben, lehetséges hogy nincs elég információ arról hogy életben vannak-e még, vagy nincs elég egyéb információ róluk.<br /><br />Mielőtt kérdezne, győződjön meg arról, hogy a megfelelő személyről van szó. Ellenőrizze le a dátumokat, helyeket és a közeli hozzátartozókat. Ha leszármazási adatokkal szolgál, kérem adja meg adja meg az információk forrását is.<br /><br />";
$pgv_lang["sending_to"]						= "Ezt az üzenetet a(z) #TO_USER# felhasználónak küldjük.";
$pgv_lang["preferred_lang"]	 				= "A felhasználó #USERLANG# nyelven szeretné a rendszert használni";
$pgv_lang["gedcom_created_using"]				= "A GEDCOM-ot létrehozó szoftver: <b>#SOFTWARE# #CREATED_VERSION#</b>";
$pgv_lang["stat_latest_death"] 					= "Legkésőbbi halálozási év";
$pgv_lang["stat_earliest_death"] 				= "Legkorábbi halálozási év";
$pgv_lang["gedcom_created_on"]					= "A GEDCOM létrehozásának dátuma: <b>#CREATED_DATE#</b>";
$pgv_lang["gedcom_created_on2"] 				= " (frissítés dátuma: <b>#CREATED_DATE#</b>)";
$pgv_lang["gedcom_stats"]					= "GEDCOM-statisztika:";
$pgv_lang["stat_individuals"]					= "Személyek";
$pgv_lang["stat_families"]					= "Családok";
$pgv_lang["stat_sources"]					= "Források";
$pgv_lang["stat_other"]						= "Egyéb adatok";
$pgv_lang["stat_latest_birth"] 					= "Legutolsó születési év";
$pgv_lang["stat_earliest_birth"] 				= "Legrégibb születési év";
$pgv_lang["customize_page"]					= "Állítsa be az Ön személyes oldalát";
$pgv_lang["customize_gedcom_page"]				= "Állítsa be ezt a GEDCOM-oldalt";
$pgv_lang["upcoming_events_block"]				= "Elkövetkező események";
$pgv_lang["upcoming_events_descr"]				= "Az Elkövetkező események blokk az aktív GEDCOM-ból olyan eseményeket mutat, amelyek a következő 30 napban lesznek aktuálisak. A felhasználó oldalán ez a rész csak élő személyeket mutathat. A GEDCOM-oldalon minden személyt felsorol.";
$pgv_lang["todays_events_block"]				= "A mai napon... blokk";
$pgv_lang["todays_events_descr"]				= "A mai napon az Ön múltjában ... blokk, az aktív GEDCOM-ból olyan eseményeket mutat, amelyeknek a mai napon történetek. Ha nincs ilyen esemény, akkor ez a rész üres marad. A felhasználó oldalán, ez a rész csak élő személyeket mutathat. A GEDCOM-oldalon minden személyt felsorol.";
$pgv_lang["logged_in_users_block"]				= "Bejelentkezett felhasználók blokk";
$pgv_lang["logged_in_users_descr"]				= "A bejelentkezett felhasználók blokk az éppen bejelentkezett felhasználókat mutatja.";
$pgv_lang["random_media_persons_or_all"]			= "Csak személyek mutatása, vagy eseményeké is, vagy mind?";
$pgv_lang["user_messages_block"]				= "Felhasználói üzenetek blokk";
$pgv_lang["user_messages_descr"]				= "A Felhasználói üzenetek blokk az aktív felhasználónak elküldött üzenetek listáját tartalmazza.";
$pgv_lang["random_media_events"]				= "Események";
$pgv_lang["random_media_persons"]				= "Személyek";
$pgv_lang["user_favorites_block"]				= "Felhasználói kedvencek blokk";
$pgv_lang["user_favorites_descr"]				= "A Felhasználói kedvencek blokk a kedvenc személyek listáját tartalmazza, hogy így könnyebben megtalálhassák őket.";
$pgv_lang["welcome_block"]					= "Felhasználó üdvözlő blokk";
$pgv_lang["welcome_descr"]					= "A Felhasználó üdvözlő blokk a jelenlegi időt és dátumot tünteti fel, a hivatkozást ahol módosíthatják a felhasználói beállításaikat vagy a saját családfájukra ugorhatnak, és a hivatkozást, ahol személyes oldalukat állíthatják be.";
$pgv_lang["random_media_block"]					= "Véletlen média blokk";
$pgv_lang["random_media_descr"]					= "A Véletlen média blokk véletlenszerűen választ ki egy képet vagy egyéb médiát a jelenlegi GEDCOM-ból, és megjeleníti azt a felhasználónak.";
$pgv_lang["gedcom_block"]					= "GEDCOM Üdvözlő blokk";
$pgv_lang["gedcom_descr"]					= "A GEDCOM Üdvözlő blokk hasonlóan működik mint a Felhasználó üdvözlő blokk, azaz üdvözli a látogatót, az aktív GEDCOM címét, az időt és a dátumot jeleníti meg..";
$pgv_lang["gedcom_favorites_block"]				= "GEDCOM Kedvencek blokk";
$pgv_lang["gedcom_favorites_descr"]				= "A GEDCOM Kedvencek blokkba az adminisztrátor választhatja be a kedvenc személyeket, így a látogatók könnyebben megtalálhatják őket. Ezzel a módszerrel kiemelhetők a fontosabb személyek a család történetéből.";
$pgv_lang["gedcom_stats_block"]					= "GEDCOM Statisztika blokk";
$pgv_lang["gedcom_stats_descr"]					= "A GEDCOM Statisztika blokk alapvető dolgokat mutat a jelenlegi GEDCOM-ból, mint a létrehozás dátuma, és hány személy található benne.";
$pgv_lang["gedcom_news_archive"] 				= "Archívum megtekintése";
$pgv_lang["gedcom_news_flag"]					= "Korlát:";
$pgv_lang["gedcom_news_limit_count"]				= "Egységek száma";
$pgv_lang["gedcom_news_limit_date"]				= "Egység ideje";
$pgv_lang["gedcom_news_limit_nolimit"]				= "Nincs korlát";
$pgv_lang["gedcom_news_limit"]					= "Megjelenési korlát ennyivel:";
$pgv_lang["gedcom_stats_show_surnames"]				= "Leggyakoribb vezetéknevek mutatása?";
$pgv_lang["portal_config_intructions"]				= "~#pgv_lang[customize_page]#<br />#pgv_lang[customize_gedcom_page]#~<br /><br />Ezen az oldalon beállíthatja a MyGedView Portálon megjelenő blokkok helyét, úgy hogy tetszőleges helyre helyezi a megfelelő blokkot. <br /><br />Az oldal két fő részre van osztva, a <b>Központi</b> részre, és a <b>Jobb</b> oldalra. A központi rész nagyobb, és a #pgv_lang[mgv]# cím alatt jelenik meg. A <b>Jobb</b> oldal a cím jobb oldalánál kezdődik, és az oldal jobb oldalán halad lefelé.<br /><br />Mindegyik résznek megvannak saját blokkjai, amelyeknek a sorrendjét meg lehet változtatni, valamint blokkokat lehet beszúrni és kivenni.<br /><br />Amikor az egyik blokk üres, a maradék blokk felveszi az egész szélességet az oldalon.<br /><br />";
$pgv_lang["login_block"]					= "Bejelentkező blokk";
$pgv_lang["login_descr"]					= "A bejelentkező blokk felhasználónév és jelszó bevitelt tesz lehetővé a bejelentkezéshez.";
$pgv_lang["theme_select_block"]         			= "Asztaltéma-választó blokk";
$pgv_lang["theme_select_descr"]         			= "Az asztaltéma-választó blokk megmutatja az asztaltéma-választó felületet akkor is, ha a váltás nincs engedélyezve.";
$pgv_lang["block_top10_title"]          			= "Leggyakoribb vezetéknevek";
$pgv_lang["block_top10"]                			= "Top 10 vezetéknév blokk";
$pgv_lang["block_top10_descr"]          			= "Ez a blokk egy táblázatban megmutatja az adatbázisban lévő 10 leggyakoribb keresztnevet.";
$pgv_lang["gedcom_news_block"]					= "GEDCOM hírblokk";
$pgv_lang["gedcom_news_descr"]					= "A GEDCOM hírblokk az adminisztrátor által bevitt híreket mutatja.<br /><br />A Hírek szolgálhat például a GEDCOM-állomány frissítésének, vagy családok újraegyesítésének bejelentésére vagy gyermek születésére.";
$pgv_lang["user_news_block"]					= "Felhasználói hírlap blokk";
$pgv_lang["user_news_descr"]					= "A felhasználók hírlapjához saját feljegyzések készíthetőek.";
$pgv_lang["my_journal"]						= "Az én hírlapom";
$pgv_lang["no_journal"]						= "Ön még nem hozott létre hírlap-bejegyzést.";
$pgv_lang["confirm_journal_delete"]				= "Biztosan törli ezt a hírlap-bejegyzést?";
$pgv_lang["add_journal"]					= "Új hírlap-bejegyzés hozzáadása";
$pgv_lang["gedcom_news"]					= "Hírek";
$pgv_lang["confirm_news_delete"]				= "Biztosan törli ezt a hír bejegyzést?";
$pgv_lang["add_news"]						= "Hír hozzáadása";
$pgv_lang["no_news"]						= "Nem érkezett új hír.";
$pgv_lang["edit_news"]						= "Hírlap vagy hír hozzáadás/szerkesztése";
$pgv_lang["enter_title"]					= "Adjon meg egy címet.";
$pgv_lang["enter_text"]						= "Kérem írja be a közölni kívánt információt ehhez a hírhez vagy hírlap-bejegyzéshez.";
$pgv_lang["news_saved"]						= "A Hír/Hírlap-bejegyzést sikeresen mentettük.";
$pgv_lang["article_text"]					= "Szövegbevitel:";
$pgv_lang["main_section"]					= "Központi szekció blokkjai";
$pgv_lang["right_section"]					= "Jobb oldali blokkok";
$pgv_lang["available_blocks"]					= "Rendelkezésre álló Blokkok";
$pgv_lang["move_up"]						= "Felfelé";
$pgv_lang["move_down"]						= "Lefelé";
$pgv_lang["move_right"]						= "Jobbra";
$pgv_lang["move_left"]						= "Balra";
$pgv_lang["broadcast_all"]					= "Üzenet az összes felhasználónak";
$pgv_lang["hit_count"]						= "Számláló:";
$pgv_lang["edit_media"]						= "Média elem szerkesztése";
$pgv_lang["search_sites"] 					= "Keresendő oldal";
$pgv_lang["no_search_site"]					= "Válasszon legalább egy távoli oldalt";
$pgv_lang["no_search_for"]					= "Válasszon keresendő opciót";
$pgv_lang["wiki_admin_guide"]					= "Wiki adminisztrátori oldal";
$pgv_lang["htmlplus_block_templates"] 				= "Sablonok";
$pgv_lang["htmlplus_block_census"]				= "népszámláláshoz adva";
$pgv_lang["htmlplus_block_burial"]				= "temetés";
$pgv_lang["htmlplus_block_adoption"]				= "örökbefogadás";
$pgv_lang["htmlplus_block_marrage"]				= "házasság";
$pgv_lang["htmlplus_block_death"]				= "halál";
$pgv_lang["htmlplus_block_birth"]				= "születés";
$pgv_lang["htmlplus_block_gedcom"]				= "Családfa";
$pgv_lang["htmlplus_block_default"]				= "Alapértelmezett";
$pgv_lang["htmlplus_block_current"]				= "Jelenlegi";
$pgv_lang["htmlplus_block_compat"]				= "Kompatibilitási mód";
$pgv_lang["htmlplus_block_taglist"]				= "Tag lista";
$pgv_lang["htmlplus_block_keyword"]				= "Kulcsszó példák(csak angolban)";
$pgv_lang["htmlplus_block_custom"]				= "Egyéni";
$pgv_lang["htmlplus_block_narrative"] 				= "Elbeszélő stílus (csak angolban)";
$pgv_lang["htmlplus_block_descr"]				= "Ez egy HTML blokk, amit az oldalára helyezhet mindenféle információkkal. A Gedcom-ban lévő információkra utaló hivatkozásokat is betehet.";
$pgv_lang["wiki_admin_guide"]					= "Wiki adminisztrátori oldal";
$pgv_lang["wiki_users_guide"]					= "Wiki felhasználói oldal";
$pgv_lang["result_page"]					= "Találati oldal";
$pgv_lang["record_not_found"]					= "A kért Gedcom rekord nem található. Ez vagy egy érvénytelen személyre mutató hivatkozás miatt lehet, vagy sérült Gedcom fájl következtében.";
$pgv_lang["phpgedview_message"]					= "PhpGedView üzenet";
$pgv_lang["common_surnames"]					= "Leggyakoribb vezetéknevek:";
$pgv_lang["default_news_title"]					= "Üdvözöljük az Ön Családfájánál.";
$pgv_lang["default_news_text"]					= "Ezen az oldalon a családfa-információk közlését a <a href=\"http://www.phpgedview.net/\" target=\"_blank\">PhpGedView</a> programmal tettük lehetővé. Az oldal áttekintést ad ehhez a programhoz.<br /><br />Ahhoz hogy megkezdhesse a munkát az adatokkal, válassza az egyik grafikont a Grafikonok menüből, menjen a személyek listájához, vagy keressen a nevek és a helyek közt.<br /><br />Ha nehézségei támadnak az oldal használata közben, kattintson a segítség menüre, és ott magyarázatot kaphat annak az oldalnak a használatához.<br /><br />Köszönjük hogy meglátogatta ezt az oldalt.";
$pgv_lang["reset_default_blocks"]				= "Az alapértelmezett blokkok visszaállítása";
$pgv_lang["recent_changes"]             			= "Aktuális változások";
$pgv_lang["recent_changes_block"]       			= "Aktuális változások blokk";
$pgv_lang["hide_block_warn"]					= "Amikor elrejt egy üres blokkot, akkor nem lehet megváltoztatni a konfigurációját amig a blokk megint látható nem lesz mert már nem lesz üres.";
$pgv_lang["show_empty_block"]					= "Rejtve legyen ez a Blokk amikor üres?";
$pgv_lang["block_not_configure"]				=	"Ezt a Blokkot nem lehet beállítani.";
$pgv_lang["recent_changes_some"]				= "<b>Változás történt az elmúlt #pgv_lang[global_num1]# napban.</b><br />";
$pgv_lang["recent_changes_none"]				= "<b>Nem történt semmi változás az elmúlt #pgv_lang[global_num1]# napban.</b><br />";
$pgv_lang["show_pending"]					= "Mutasd az elfogadásra váró változásokat";
$pgv_lang["recent_changes_descr"]       			= "Az Aktuális változások blokkjában találhat minden olyan, a GEDCOM-állományt érintő változást, mely az elmúlt hónapban történt. Ez a blokk segíti Önt a változások naprakész követésében. A változások felismerése a CHAN elem alapján történik.";
$pgv_lang["delete_selected_messages"]   			= "Kiválasztott üzenetek törlése";
$pgv_lang["use_blocks_for_default"]     			= "Legyen ez a blokkbeállítás az alapértelmezett minden felhasználónak?";
//-- upgrade.php messages
$pgv_lang["options"]						= "Lehetőségek:";
$pgv_lang["media_options"]					= "Média beállítások";
$pgv_lang["config_update_ok"]					= "A konfigurációs állományt sikeresen frissítettük.";
$pgv_lang["server_folder"]					= "Mappa neve a szerveren";
$pgv_lang["page_size"]						= "Oldal méret";
$pgv_lang["wiki_main_page"]					= "Wiki start oldala";
$pgv_lang["last_email_sent"]					= "Az utolsó emlékeztető email el lett küldve ";
$pgv_lang["html_block_name"]					= "HTML";
$pgv_lang["htmlplus_block_name"]				= "Fejlettebb HTML";
$pgv_lang["htmlplus_block_content"] 				= "Tartalomjegyzék";
$pgv_lang["config_block"]					= "Beállítás";
$pgv_lang["child-family"]					= "Szülők és testvérek";
$pgv_lang["total_not_born"]					= "Még meg nem születettek";
$pgv_lang["common_upload_errors"]				= "Ez a hiba valószínűleg azért van mert a feltöltött állomány meghaladta a maximum méretet. Az PHP alap feltöltési mérete 2MB. Kapcsolatba léphet az adminisztrátorral megnövelje az alap beállítást a php.ini állományban, vagy feltölthető legyen FTP-n keresztül. Használja a <a href=\"uploadgedcom.php?action=add_form\"><b>GEDCOM hozzáadás</b></a> oldalt, hogy hozzáadjon egy GEDCOM állományt amit feltöltött FTP-n keresztül.";
$pgv_lang["indis_with_surname"]					= "Személyek #surname# vezetéknévvel";
$pgv_lang["review_changes_descr"]				= "A Változások Függőben Blokk sorolja fel azokat a változtatásokat, amelyeket egy adminisztrátornak el kell fogadnia. Ezek a változások függőben vannak mindaddig amíg el nem fogadják vagy elutasítják őket.<br /><br />Ha ez a Blokk be van kapcsolva, akkor felhasználok elfogadási engedéllyel, kapnak egy emailt naponta egyszer hogy változás történt amit meg kell tekinteni.";
$pgv_lang["number_sign"]					= "#";
$pgv_lang["privacy"]						= "Diszkréció";
$pgv_lang["locked"]						= "Ne változtasd meg";
$pgv_lang["indis_charts"]					= "Személy Opció";
$pgv_lang["fams_charts"]					= "Család Opció";
$pgv_lang["stepbrother"]					= "Mostoha fiútestvér";
$pgv_lang["stepsister"]						= "Mostoha lánytestvér";
$pgv_lang["stepmom"]						= "Mostoha anya";
$pgv_lang["stepdad"]						= "Mostoha apa";
$pgv_lang["top10_pageviews_block"]				= "Leggyakoribban nézet elemek";
$pgv_lang["top10_pageviews"]					= "Leggyakoribban nézet elemek";
$pgv_lang["top10_pageviews_descr"]				= "Ez a Blokk feltünteti a 10 leggyakoribban megtekintetet adatot. Ennek a Blokknak kell hogy a Számláló be legyen kapcsolva a GEDCOM konfigurációjánál.";
$pgv_lang["update_address"] 					= "Cím Frissítés";
$pgv_lang["select_fact"] 					= "Válasszon egy tényt...";
$pgv_lang["update_fact_restricted"] 				= "Ennek a ténynek a frissítése korlátozott:";
$pgv_lang["update_fact"] 					= "Tény Frissítés";
$pgv_lang["update_name"] 					= "Név Frissítés";
$pgv_lang["quick_update_instructions"] 				= "Ezen az oldalon egy személy adatain végezhet el gyors frissítést. Miután kész van, egy adminisztrátornak meg kell tekintenie és elfogadnia mielőtt a felhasználok meg tudják tekinteni a változásokat.";
$pgv_lang["quick_update_title"] 				= "Gyors Frissítés";
$pgv_lang["show_spouses"]					= "Házastársak feltüntetése";
$pgv_lang["review_changes_body"]				= "Online változások történtek a genealógiai adatbázisban. Ezeket a változásokat meg kell tekinteni és elfogadni hogy a többi felhasználó is megtekinthesse. Kérem, használja a lenti URL címet hogy abba a PhpGedView weboldalra menjen és bejelentkezzen hogy megnézze a változásokat.";
$pgv_lang["review_changes_subject"]				= "PhpGedView - Változások Megtekintése";
$pgv_lang["review_changes_email_freq"]				= "Ismételt emlékeztető email (napok)";
$pgv_lang["review_changes_email"]				= "Emlékeztető email küldése?";
$pgv_lang["review_changes_block"]				= "Változások Függőben";
$pgv_lang["top10_pageviews_msg"]				= "A számlálót be kell kapcsolni a GEDCOM konfigurációjában hogy ez a Blokk működjön.";
$pgv_lang["top10_pageviews_nohits"]				= "Jelenleg nincs találat.";
$pgv_lang["total_names"]					= "Nevek száma";
$pgv_lang["first_letter_fname"]					= "Válasszon egy betűt amivel személyek keresztneve kezdődik.";
$pgv_lang["reorder_families"]					= "Családok sorrendje";
$pgv_lang["sort_by_marriage"]					= "Sorrend házassági dátum szerint";
$pgv_lang["other"]						= "Egyéb";
$pgv_lang["children_timeline"]					= "Gyerek feltüntetése kronológiai grafikonon";
$pgv_lang["family_timeline"]					= "Család feltüntetése kronológiai grafikonon";
$pgv_lang["halfsister"]						= "Fél lánytestvér";
$pgv_lang["halfbrother"]					= "Fél fiútestvér";
$pgv_lang["halfsibling"]					= "Féltestvér";
$pgv_lang["fathers_family_with"]				= "Apa családja mással";
$pgv_lang["mothers_family_with"]				= "Anya családja mással";
$pgv_lang["total_memory_usage"]					= "Felhasznált Memória:";
$pgv_lang["genealogy_contact"]					= "Genealógiai kapcsolat";
$pgv_lang["support_contact"]					= "Kapcsolat technikai segítséghez ";
$pgv_lang["fams_with_surname"]					= "Családok #surname# vezetéknévvel";
$pgv_lang["remember_me"]					= "Emlékezz rám erről a számítógépről?";
$pgv_lang["cookie_login_help"]					= "Ez a weboldal emlékszik önre egy előző bejelentkezésből. Jelenleg megengedett a hozzáférés magán információkhoz és más felhasználói tulajdonságokhoz, de ahhoz hogy szerkeszteni vagy adminisztrálni lehessen, ahhoz be kell jelentkezni megint biztonsági okok miatt.";
$pgv_lang["title_search_link"]      				= "Helyi link hozzáadása";
$pgv_lang["label_search_engine_detected"]  			= "Keresőmotor detektálva";
$pgv_lang["remove_custom_tags"]					= "Eltávolítani a hozzá adott PGV toldalékokat? (pl._PGVU,_THUM)";
$pgv_lang["total_dead"]						= "Elhúnytak";
$pgv_lang["total_living"]					= "Élők";
$pgv_lang["relatives_report"]					= "Rokonok Jelentés";
$pgv_lang["choose_relatives"]					= "Válasszon rokonokat";
$pgv_lang["descendants"]					= "Leszármazottak";
$pgv_lang["ancestors"]						= "Ősök egyenes vonalon és a családjuk";
$pgv_lang["direct-ancestors"]					= "Ősök egyenes vonalon";
$pgv_lang["spouse-family"]					= "Házastárs és gyerekek";
$pgv_lang["comments"]						= "Megjegyzések";
$pgv_lang["enter_comments"]					= "Kérem, írja be a kapcsolatát az adathoz a megjegyzés mezőbe.";
$pgv_lang["relationship_great"]					= "Déd";
$pgv_lang["stat_females"]					= "Nők";
$pgv_lang["dec_1st"]						= "Dec";
$pgv_lang["descent_steps"]					= "Leszármazási lépések";
$pgv_lang["family_of"]						= "A következő személy családja:&nbsp;";
$pgv_lang["nov_1st"]						= "Nov";
$pgv_lang["oct_1st"]						= "Okt";
$pgv_lang["sep_1st"]						= "Szep";
$pgv_lang["aug_1st"]						= "Aug";
$pgv_lang["jul_1st"]						= "Júl";
$pgv_lang["jun_1st"]						= "Jún";
$pgv_lang["may_1st"]						= "Máj";
$pgv_lang["apr_1st"]						= "Ápr";
$pgv_lang["mar_1st"]						= "Márc";
$pgv_lang["feb_1st"]						= "Feb";
$pgv_lang["jan_1st"]						= "Jan";
$pgv_lang["stat_males"]						= "Férfiak";
$pgv_lang["after"]						= "késöbb mint";
$pgv_lang["before"]						= "előtte";
$pgv_lang["before_or_after"]					= "Helyezze a számlálót a név elé vagy mögé?";
$pgv_lang["days_to_show"]					= "Napok száma feltüntetése";
$pgv_lang["num_to_show"]					= "Elemek száma feltüntetése";
$pgv_lang["html_block_sample_part2"]				= "megváltoztassa amit ide kiírt.</p>";
$pgv_lang["html_block_sample_part1"]				= "<p class=\"blockhc\"><b>Írja ide a címet</b></p><br /><p>Kattintson a Konfiguráció gombra";
$pgv_lang["html_block_descr"]					= "Ez egy egyszerű HTML Blokk amit az oldalra lehet tenni hogy, bármilyen saját üzenetet hozáadhasson.";
$pgv_lang["changelog"]						= "Verzió #VERSION# változások";
$pgv_lang["index_edit_advice"]					= "Jelöljön ki egy Blokkot és kattintson az egyik nyílra hogy, áthelyezze a kijelölt Blokkot a megadott irányba.";
$pgv_lang["address_list"]					= "Cím Lista";
$pgv_lang["filter_address"]					= "Címek mutatása ami ezt tartalmaz";
$pgv_lang["stat_media"]						= "Média objektumok";
$pgv_lang["address_labels"]					= "Cím Etikettek";
$pgv_lang["link_new_wife"]					= "Hozzáadni egy feleséget egy bejegyzett személyből választva";
$pgv_lang["link_new_husb"]					= "Hozzáadni egy férjet egy bejegyzett személyből választva";
$pgv_lang["remove_child"]					= "Ezt a gyereket eltávolítani ebből a családból";
$pgv_lang["link_remote"]            				= "Kapcsolj egy külső személyt";
$pgv_lang["indi_is_remote"]					= "Az információ ennek a személynek egy külső weboldalról lett ide kapcsolva.";
$pgv_lang["next_email_sent"]					= "A következő emlékeztető email el lesz küldve";
$pgv_lang["maxviews_exceeded"]					= "Az oldal látogatottságának sűrűsége #GLOBALS[MAX_VIEWS]# / #GLOBALS[MAX_VIEW_TIME]# elérte a maximálisat.";
$pgv_lang["add_fav_enter_id"]					= "Írjon be egy Személy, Család vagy Forrás azonosítóját";
$pgv_lang["add_fav_or_enter_url"]				= "VAGY<br />\nÍrjon be egy URL-t és egy címet";
$pgv_lang["add_fav_enter_note"]					= "Beírhat egy tetszőleges jegyzetet erről a kedvencről";
$pgv_lang["url"]						= "URL";
$pgv_lang["add_favorite"]					= "Új kedvenc hozzáadása";
$pgv_lang["delete_family"]					= "Család törlése";
$pgv_lang["delete_family_confirm"]				= "A család törlése minden személyi összefüggést egymáshoz kitöröl de a személyek megmaradnak. Biztos benne hogy, ki akarja törölni ezt a családot?";
$pgv_lang["cancel"]						= "Mégse";
$pgv_lang["cookie_help"]					= "Ez az weboldal cookie-kat használ hogy, ellenőrizze a belépési státuszt.<br /><br />A cookie elfogadását a böngészőben lehet beállítani. Ezt be kell állítani még mielőtt bejelentkezik. Az ön böngészőjében a Segitség-nél találhat információt hogy ezt  a beállítást hol találja.";
$pgv_lang["stat_users"]						= "Felhasználók száma";
$pgv_lang["no_family_facts"]					= "Nincs tény jegyezve ennek a családnak.";
$pgv_lang["saturday_1st"]					= "Szo";
$pgv_lang["familybook_chart"]					= "Családi Könyv Grafikon";
$pgv_lang["source_menu"]					= "Forrás Opció";
$pgv_lang["edit_source"]					= "Forrás szerkesztése";
$pgv_lang["cancel"]						= "Mégse";
$pgv_lang["jan_1st"]						= "jan";
$pgv_lang["feb_1st"]						= "febr";
$pgv_lang["mar_1st"]						= "márc";
$pgv_lang["apr_1st"]						= "ápr";
$pgv_lang["may_1st"]						= "máj";
$pgv_lang["jun_1st"]						= "jún";
$pgv_lang["jul_1st"]						= "júl";
$pgv_lang["aug_1st"]						= "aug";
$pgv_lang["sep_1st"]						= "szept";
$pgv_lang["oct_1st"]						= "okt";
$pgv_lang["nov_1st"]						= "nov";
$pgv_lang["dec_1st"]						= "dec";
$pgv_lang["friday_1st"]						= "P";
$pgv_lang["thursday_1st"]					= "Cs";
$pgv_lang["site_had"]						= "a következőt tartalmazta";
$pgv_lang["wednesday_1st"]					= "Sze";
$pgv_lang["tuesday_1st"]					= "K";
$pgv_lang["monday_1st"]						= "H";
$pgv_lang["sunday_1st"]						= "V";
$pgv_lang["stat_surnames"]					= "Vezetéknevek száma";
$pgv_lang["stat_events"]					= "Események száma";
$pgv_lang["stat_average_children"]				= "Gyermekek száma átlagosan családonként";
$pgv_lang["stat_most_children"]					= "Legnagyobb gyermekes család";
$pgv_lang["stat_longest_life"]					= "Legidősebb személy";
$pgv_lang["stat_avg_age_at_death"]				= "Átlagos életkor";
$pgv_lang["ex-husband"] 					= "Volt férj";
$pgv_lang["noemail"] 						= "Címek email nélkül";
$pgv_lang["onlyemail"] 						= "Csak email-es címek";
$pgv_lang["stats_to_show"]					= "Válassza azokat a statisztikákat amit ez a Blokk mutasson";
$pgv_lang["broadcast_never_logged_in"]				= "Küldj üzenet azoknak a felhasználóknak akik még soha nem jelentkeztek be";
$pgv_lang["broadcast_not_logged_6mo"]				= "Küldj üzenet azoknak a felhasználóknak akik 6 hónapja nem jelentkeztek be";
$pgv_lang["ex-wife"] 						= "Volt feleség";
$pgv_lang["ex-spouse"] 						= "Volt házastárs";
$pgv_lang["invalid_id"]						= "Az azonosító nem létezik ebben a GEDCOM állományban.";
$pgv_lang["media_id"]						= "Média azonosító";
$pgv_lang["site_list"]						= "Weboldal: ";
$pgv_lang["link_remote"]            				= "Kapcsolj egy külső személyt";
$pgv_lang["indi_is_remote"]					= "Az információ ennek a személynek egy külső weboldalról lett ide kapcsolva.";
//-- validate GEDCOM
$pgv_lang["media_not_linked"]					= "Ez a Média nincsen semmi GEDCOM adathoz hozzákapcsolva.";
$pgv_lang["media_linked"]					= "Ez a média ehhez van hozzákapcsolva:";
$pgv_lang["add_media_tool"]					= "Média hozzáadása eszköz";
$pgv_lang["descendancy_header"]					= "Leszármazási jelentés a következőhöz";
$pgv_lang["descend_report"]					= "Leszármazási jelentés";
$pgv_lang["ahnentafel_no_details"]				= "de a részletek ismeretlenek";
$pgv_lang["ahnentafel_place"]					= " ";

//-- hourglass chart
$pgv_lang["hourglass_chart"]					= "Homokóra diagram";
//-- report engine
$pgv_lang["choose_report"]              			= "Válasszon ki egy jelentést";
$pgv_lang["enter_report_values"]        			= "Adjon meg értékeket a jelentéshez";
$pgv_lang["selected_report"]            			= "Kiválasztott jelentés";
$pgv_lang["select_report"]              			= "Jelentés kiválasztása";
$pgv_lang["download_report"]					= "Jelentés letöltése";
$pgv_lang["reports"]                    			= "Jelentések";
$pgv_lang["pdf_reports"]                			= "PDF jelentések";
$pgv_lang["ahnentafel_header"]					= "Családfa jelentés a következőhöz";
$pgv_lang["ahnentafel_report"]					= "Családfa jelentés";
$pgv_lang["html_reports"]               			= "HTML jelentések";
$pgv_lang["in"]							= "a következőben";
$pgv_lang["with"]						= "a következőn";
$pgv_lang["on"]							= "a következőn";
$pgv_lang["with"]						= "val/vel";
$pgv_lang["relatives_report_ext"]				= "Kiterjesztett rokonsági jelentés";
$pgv_lang["ahnentafel_generation"]				= "Generáció ";
$pgv_lang["ahnentafel_buried_f"]				= "el lett temetve";
$pgv_lang["ahnentafel_buried_m"]				= "el lett temetve";
$pgv_lang["of"] 						= "/";
$pgv_lang["marrdate2"]						= "Házassági dátum tartomány vége";
$pgv_lang["marrdate1"]						= "Házassági dátum tartomány kezdete";
$pgv_lang["marrplace"]						= "Házassági hely tartalmazza";
$pgv_lang["deathdate1"]						= "Halálozási év tartomány kezdete";
$pgv_lang["marr_report"]					= "Házassági dátum és hely jelentés";
$pgv_lang["deathdate2"]						= "Halálozási év tartomány vége";
$pgv_lang["deathplace"]						= "Halálozási hely tartalmazza";
$pgv_lang["death_report"]					= "Halálozási év és hely jelentés";
$pgv_lang["ahnentafel_died_f"]					= "elhunyt";
$pgv_lang["ahnentafel_died_m"]					= "elhunyt";
$pgv_lang["ahnentafel_married_f"]				= "meg házasodott";
$pgv_lang["ahnentafel_married_m"]				= "meg házasodott";
$pgv_lang["ahnentafel_christened_f"]				= "meg lett keresztelve";
$pgv_lang["ahnentafel_christened_m"]				= "meg lett keresztelve";
$pgv_lang["ahnentafel_born_f"]					= "született";
$pgv_lang["ahnentafel_born_m"]					= "született";
$pgv_lang["ahnentafel_pronoun_f"]				= "Ő ";
$pgv_lang["ahnentafel_pronoun_m"]				= "Ő ";
$pgv_lang["family_group_report"]        			= "Csoportos jelentés a családokról";
$pgv_lang["page"]                       			= "Oldal";
$pgv_lang["enter_famid"]                			= "A család azonosítója";
$pgv_lang["show_sources"]               			= "Feltüntessük a forrásokat?";
$pgv_lang["show_notes"]                 			= "Feltüntessük a megjegyzéseket?";
$pgv_lang["show_basic"]                 			= "Nyomtassuk az alapvető eseményeket, ha azok üresek?";
$pgv_lang["show_photos"]					= "Megmutassuk a fényképeket?";
$pgv_lang["individual_report"]					= "Személyes jelentés";
$pgv_lang["enter_pid"]						= "A személy azonosítója";
$pgv_lang["generated_by"]               			= "Létrehozta";
$pgv_lang["list_children"]              			= "Gyermekek listázása születésük szerint.";
$pgv_lang["birth_report"]               			= "Születési dátum és hely jelentés";
$pgv_lang["birthplace"]                 			= "Születési hely tartalmazza";
$pgv_lang["birthdate1"]                 			= "Születési idő-intervallum kezdete";
$pgv_lang["birthdate2"]                 			= "Születési idő-intervallum vége";
$pgv_lang["sort_by"]                    			= "Sorrend";
$pgv_lang["cleanup"]						= "Tisztítás";
 //-- CONFIGURE (extra) messages for programs patriarch, slklist and statistics
$pgv_lang["statistics"]                 			= "Statisztika";
//-- Merge Records
$pgv_lang["merge_same"]                 			= "A kiválasztott rekordok típusa nem egyezik meg, így azok nem fűzhetők össze.";
$pgv_lang["merge_step1"]                			= "Összefűzés -  1. lépés a 3-ból";
$pgv_lang["merge_step2"]                			= "Összefűzés -  2. lépés a 3-ból";
$pgv_lang["merge_step3"]                			= "Összefűzés -  3. lépés a 3-ból";
$pgv_lang["select_gedcom_records"]      			= "Válassza ki a 2 összefűzendő GEDCOM-rekordot! A rekordok típusának meg kell egyezni.";
$pgv_lang["merge_to"]                   			= "Célrekord azonosítója:";
$pgv_lang["merge_from"]                 			= "Forrásrekord azonosítója:";
$pgv_lang["merge_facts_same"]   				= "A következő események a két rekordban megegyeznek és automatikusan összefűzésre kerülnek.";
$pgv_lang["no_matches_found"]   				= "Nem találtunk egyező eseményeket.";
$pgv_lang["unmatching_facts"]   				= "A következő események nem egyeznek meg. Kérjük jelölje ki, hogy melyik információt tartsuk meg.";
$pgv_lang["record"]                     			= "rekord";
$pgv_lang["adding"]                     			= "Hozzáadás";
$pgv_lang["updating_linked"]    				= "Összekapcsolt rekordok frissítése";
$pgv_lang["merge_more"]                 			= "További rekordok összefűzése";
$pgv_lang["same_ids"]                   			= "Ön ugyanazt az azonosítót adta meg mindkétszer. Egy rekord nem fűzhető össze saját magával.";
//-- ANCESTRY FILE MESSAGES
$pgv_lang["ancestry_chart"]             			= "Könyv az ősfáról";
$pgv_lang["gen_ancestry_chart"]         			= "#PEDIGREE_GENERATIONS# generációs könyv az ősfáról";
$pgv_lang["chart_style"]                			= "A grafikon stílusa";
$pgv_lang["chart_list"]						= "Lista";
$pgv_lang["chart_booklet"]   					= "Füzet";
$pgv_lang["show_cousins"]					= "Unokatestvérek feltüntetése";
// 1st generation
$pgv_lang["compact_chart"]					= "Egyszerű grafikon";
$pgv_lang["sosa_2"]               				= "Apa";
$pgv_lang["sosa_3"]               				= "Anya";
// 2nd generation
$pgv_lang["sosa_4"]               				= "Nagyapa";
$pgv_lang["sosa_5"]               				= "Nagyanya";
$pgv_lang["sosa_6"]               				= "Nagyapa";
$pgv_lang["sosa_7"]               				= "Nagyanya";
// 3rd generation
$pgv_lang["sosa_8"]               				= "Dédapa";
$pgv_lang["sosa_9"]               				= "Dédanya";
$pgv_lang["sosa_10"]               				= "Dédapa";
$pgv_lang["sosa_11"]               				= "Dédanya";
$pgv_lang["sosa_12"]               				= "Dédapa";
$pgv_lang["sosa_13"]               				= "Dédanya";
$pgv_lang["sosa_14"]              				= "Dédapa";
$pgv_lang["sosa_15"]               				= "Dédanya";
// 4th generation
$pgv_lang["sosa_16"]               				= "Ükapa";
$pgv_lang["sosa_17"]               				= "Ükanya";
$pgv_lang["sosa_18"]               				= "Ükapa";
$pgv_lang["sosa_19"]               				= "Ükanya";
$pgv_lang["sosa_20"]               				= "Ükapa";
$pgv_lang["sosa_21"]               				= "Ükanya";
$pgv_lang["sosa_22"]               				= "Ükapa";
$pgv_lang["sosa_23"]               				= "Ükanya";
$pgv_lang["sosa_24"]               				= "Ükapa";
$pgv_lang["sosa_25"]               				= "Ükanya";
$pgv_lang["sosa_26"]               				= "Ükapa";
$pgv_lang["sosa_27"]               				= "Ükanya";
$pgv_lang["sosa_maternal_male_n_generations"]			= "%3\$d x dédnagyanya";
$pgv_lang["sosa_paternal_male_n_generations"]			= "%3\$d x dédnagyanya";
$pgv_lang["sosa_maternal_female_n_generations"]			= "%3\$d x dédnagyapa";
$pgv_lang["sosa_paternal_female_n_generations"]			= "%3\$d x dédnagyapa";
$pgv_lang["sosa_28"]               				= "Ükapa";
$pgv_lang["sosa_29"]               				= "Ükanya";
$pgv_lang["sosa_30"]               				= "Ükapa";
$pgv_lang["sosa_31"]               				= "Ükanya";
// 5th generation
$pgv_lang["bridesmaid"] 					= "menyasszony tanúja";
$pgv_lang["best_man"] 						= "vőlegény tanúja";
$pgv_lang["bridesmaid"] 					= "Nyoszolyólány";
$pgv_lang["best_man"] 						= "Legjobb ember";
$pgv_lang["attending"] 						= "Gondozás";
$pgv_lang["attendant"] 						= "Gondozó";
$pgv_lang["authenticated_feed"]					= "Azonosított hírcsatorna";
$pgv_lang["feed_login"]						= "Ha van azonosítója ezen a PhpGedView oldalon, <a href=\"#AUTH_URL#\">beléphet</a> a szerverre alap HTTP azonosítással ahhoz hogy megtekintse a privát információkat.";
$pgv_lang["civil_registrar"] 					= "Anyakönyvvezető";
$pgv_lang["circumciser"] 					= "Sterilizálás";
//-- FAN CHART
$pgv_lang["fan_chart"]        					= "Családi kör";
$pgv_lang["statistiek_list"]					= "Statisztikai görbe";
$pgv_lang["gen_fan_chart"]    					= "#PEDIGREE_GENERATIONS# generációs családi kör";
$pgv_lang["fan_width"]        					= "A kör szélessége";
$pgv_lang["gd_library"]       					= "PHP-szerver beállítási hiba: a GDlib 2.x szükséges a képi funkciók használatához.";
$pgv_lang["gd_freetype"]                			= "PHP-szerver beállítási hiba: a FreeType library szükséges a TrueType betűkészletek használatához.";
$pgv_lang["gd_helplink"]                			= "http://www.php.net/gd";
$pgv_lang["fontfile_error"]   					= "A betűkészlet nem található a PHP szerveren";
$pgv_lang["fanchart_IE"]					= "Ezt a Családi kör képet nem lehet közvetlenül megjeleníteni az ön böngészőjében. Kattintson jobb egérgombbal rajta, majd nyomtassa ki.";
//-- RSS Feed
$pgv_lang["rss_descr"]          				= "Újdonságok a #GEDCOM_TITLE# oldalról";
$pgv_lang["rss_logo_descr"]     				= "A hírcsatornát a PhpGedView táplálja";
$pgv_lang["no_feed"]						= "RSS hírcsatorna nem áll rendelkezésre erről a PhpGedView weboldalról";
$pgv_lang["no_feed_title"]					= "Hírcsatorna nem áll rendelkezésre";
$pgv_lang["registry_officer"] 					= "Hivatalnok";
$pgv_lang["rss_feeds"]						= "RSS hírcsatorna";
$pgv_lang["twin"] 						= "Iker";
$pgv_lang["witness"] 						= "Tanú";
$pgv_lang["twin_sister"] 					= "Ikertestvér, lány";
$pgv_lang["twin_brother"] 					= "Ikertestvér, fiú";
$pgv_lang["servant"] 						= "Szolga";
$pgv_lang["seller"] 						= "Eladó";
$pgv_lang["rabbi"] 						= "Zsidó pap";
$pgv_lang["priest"] 						= "Pap";
$pgv_lang["stplnoim"]			 			= "nincs megvalósítva:";
$pgv_lang["nurse"] 						= "Nővér";
$pgv_lang["lodger"] 						= "Albérlő";
$pgv_lang["informant"] 						= "Tudósító";
$pgv_lang["godparent"] 						= "Keresztszülő";
$pgv_lang["godmother"] 						= "Keresztanya";
$pgv_lang["godfather"] 						= "Keresztapa";
$pgv_lang["friend"] 						= "Barát";
$pgv_lang["stat_19_arm"]			 		= "év házasságban.";
$pgv_lang["stat_20_arm1"]			 		= "év az első házasságban.";
$pgv_lang["stat_19_arm"]			 		= "év a házasságban.";
$pgv_lang["stat_18_ard"]			 		= "év a halálozási évhez viszonyítva.";
$pgv_lang["stat_17_arb"]			 		= "év a születési évhez viszonyítva.";
$pgv_lang["buyer"] 						= "Vásárló";
//-- statistics utility
$pgv_lang["statutci"]                   			= "nem tudtuk létrehozni az indexet";
$pgv_lang["statnnames"]                				= "nevek száma    =";
$pgv_lang["statvars"]			 			= "Töltse ki az adatokat az ábrának";
$pgv_lang["statnfam"]                  				= "családok száma =";
$pgv_lang["statnmale"]                 				= "férfiak száma  =";
$pgv_lang["stat_10_none"]		 			= "senki";
$pgv_lang["stat_16_mmb"]					= "Hónapok száma a házasság és az elsö gyermek között.";
$pgv_lang["both_dead"]						= "Mindketten halottak";
$pgv_lang["stat_302_cgp"]			 		= "periódusok. Z-tengely periódus másodperceinek ellenőrzése";
$pgv_lang["both_alive"]						= "Mindketten élnek";
$pgv_lang["stat_21_nok"]			 		= "gyermekek száma.";
$pgv_lang["stat_14_mb1"]					= "Az első gyermek születési hónapja a kapcsolatban";
$pgv_lang["stat_15_mm1"]					= "Az első házasságkötés hónapja";
$pgv_lang["stat_13_mm"]			 			= "Házasságkötési hónap";
$pgv_lang["stat_12_md"]			 			= "Elhalálozási hónap";
$pgv_lang["stat_11_mb"]			 			= "Születési hónap";
$pgv_lang["statsubmit"]			 			= "az ábra feltüntetése";
$pgv_lang["statreset"]			 			= "eredeti értékek";
$pgv_lang["statar_zgp"]			 			= "periódusok vonal (z-tengely):";
$pgv_lang["statar_xga"]			 			= "számok vonal (x-tengely):";
$pgv_lang["statar_xgm"]			 			= "hónap vonal (x-tengely):";
$pgv_lang["add_faq_visibility"] 				= "GYÍK láthatósága";
$pgv_lang["statar_xgl"]			 			= "év vonal (x-tengely):";
$pgv_lang["statar_xgp"]			 			= "periódus vonal (x-tengely):";
$pgv_lang["stat_301_mf"]			 		= "férfi/nő";
$pgv_lang["stat_300_none"]					= "semmi";
$pgv_lang["stat_202_perc"]			 		= "százalék";
$pgv_lang["stat_201_num"]			 		= "számok";
$pgv_lang["stplmarrbirth"]		 			= "Hónapok a házasság és az első gyermek születése között";
$pgv_lang["stplnumof"]			 			= "Darabszám";
$pgv_lang["stat_200_none"]			 		= "összes (vagy üres)";
$pgv_lang["statnfemale"]               				= "nők száma      =";
$pgv_lang["statlxa"]                    			= "az x-tengely mentén:";
$pgv_lang["statlya"]                    			= "az y-tengely mentén:";
$pgv_lang["statlza"]                    			= "a z-tengely mentén:";

//-- statisticsplot utility
$pgv_lang["stpl"]                        			= "...";
$pgv_lang["stpltype"]			 			= "típus:";
$pgv_lang["stplinfo"]			 			= "ábrázolási információ:";
$pgv_lang["stplmf"]                     			= " / személy";
$pgv_lang["stplipot"]                   			= " / időszak";
$pgv_lang["stplmonth"]                  			= "hónap";
$pgv_lang["click_here"]						= "Kattintson ide hogy folytassa";
$pgv_lang["click_here_help"]					= "~#pgv_lang[click_here]#~<br /><br />Kattintson erre a gombra hogy elmentse a változtatásokat.<br /><br />Vissza fog kerülni a #pgv_lang[welcome]# vagy a #pgv_lang[mygedview]# oldalra, de a változtatásai lehet hogy még nem fognaklátsztani. Lehet hogy az oldalt frissítenie kell a változások megjelenítéséhez.";
$pgv_lang["block_summaries"]		= "~#pgv_lang[block_desc]#~<br /><br />Egy rövid leírás minden egyes blokkról amit a #pgv_lang[welcome]# vagy a #pgv_lang[mygedview]# oldalra tud tenni.<br /><table border='1' align='center'><tr><td class='list_value'><b>#pgv_lang[name]#</b></td><td class='list_value'><b>#pgv_lang[description]#</b></td></tr>#pgv_lang[block_summary_table]#</table><br /><br />";
$pgv_lang["display_all"]					= "Mutass mindent";
$pgv_lang["source_contains"]					= "A Forrás tartalma:";
$pgv_lang["repo_contains"]					= "A Szervezet tartalma:";
$pgv_lang["media_contains"]					= "A Média tartalma:";
$pgv_lang["total_places"]					= "Talált helyek";
$pgv_lang["block_desc"]						= "Leírás Blokk";
$pgv_lang["description"]					= "Leírás";
$pgv_lang["definitions"]					= "Definícíók";
$pgv_lang["maybe"]						= "Talán ";
$pgv_lang["dead"]						= "Elhunyt ";
$pgv_lang["dead"]						= "Elhunyt";
$pgv_lang["alive"]						= "Él ";
$pgv_lang["is_alive_in"]					= "Él #YEAR# évében";
$pgv_lang["add_faq_header"] 					= "GYÍK fejléc";
$pgv_lang["position_item"] 					= "Elem pozíciója";
$pgv_lang["faq_list"] 						= "GYÍK lista";
$pgv_lang["hs_title"] 						= "Keresési Segítség";
$pgv_lang["confirm_faq_delete"] 				= "Biztos benne hogy ezt az GYÍK-ot ki akarja törölni?";
$pgv_lang["preview"] 						= "Előnézet";
$pgv_lang["no_id"] 						= "Semmi GYÍK azonosító nem lett megadva!";
$pgv_lang["no_faq_items"] 					= "A GYÍK lista üres.";
$pgv_lang["add_faq_order"] 					= "GYÍK pozíció";
$pgv_lang["add_faq_body"] 					= "GYÍK szövegtörzs";
$pgv_lang["alive_in_year"]					= "Élő az Évben";
$pgv_lang["stplnumbers"]                			= "számok";
$pgv_lang["stplage"]                    			= "kor";
$pgv_lang["stplperc"]                   			= "százalék";
$pgv_lang["hs_searchin"]					= "Keresd ebben";
$pgv_lang["hs_keyword"] 					= "Keresd";
$pgv_lang["block_summary_table"]				= "&nbsp;";
$pgv_lang["hs_searchuser"]					= "Használói segítség";
$pgv_lang["hs_searchmodules"]					= "Segítség a modulokhoz";
$pgv_lang["hs_results"] 					= "Talált eredmény:";
$pgv_lang["hs_close"] 						= "Ablak bezárás";
$pgv_lang["hs_search"] 						= "Keres";
$pgv_lang["hs_searchconfig"]					= "Adminisztrátori Segítség";
$pgv_lang["hs_searchhow"]					= "Keresési típus";
$pgv_lang["hs_searchall"]					= "Minden szó";
$pgv_lang["hs_searchany"]					= "Bármilyen szó";
$pgv_lang["hs_searchsentence"]					= "Pontos frázis";
$pgv_lang["hs_intruehelp"]					= "Csak Segítségi szöveg";
$pgv_lang["hs_inallhelp"]					= "Minden szöveg";
$pgv_lang["account_information"] 				= "Regisztráció";
$pgv_lang["choose"] 						= "Válasszon: ";
$pgv_lang["TYPE__audio"] 					= "Hangfelvétel";
$pgv_lang["TYPE__certificate"] 					= "Igazolás";
$pgv_lang["TYPE__fiche"] 					= "Mikrofilm";
$pgv_lang["TYPE__electronic"] 					= "Elektronikus";
$pgv_lang["TYPE__manuscript"] 					= "Kézirat";
$pgv_lang["TYPE__card"] 					= "Kártya";
$pgv_lang["TYPE__book"] 					= "Könyv";
$pgv_lang["TYPE__document"] 					= "Dokumentum";
$pgv_lang["TYPE__film"] 					= "Mikrofilm";
$pgv_lang["button_TREE_R"] 					= "Mutasd a «gyökér» párokat vagy személyeket. Ezek az emberek «pátriárkák». Ők azok, akiknek nincs szülő bejegyezve az adatbázisban.";
$pgv_lang["button_TREE_L"] 					= "Mutasd a «levél» párokat vagy személyeket. Ők azok, akik élnek, de nincs gyermekük az adatbázisban.";
$pgv_lang["button_SEX_U"] 					= "Csak azokat a személyeket mutasd, akiknek a neme nem ismert.";
$pgv_lang["button_SEX_M"] 					= "Csak férfiak mutatása.";
$pgv_lang["button_SEX_F"] 					= "Csak nők mutatása.";
$pgv_lang["button_reset"] 					= "Visszaállítás a lista alapértelmezett értékeire.";
$pgv_lang["button_MARR_YES"] 					= "Mutasd azokat a párokat, akik több mint 100 éve házasodtak.";
$pgv_lang["button_MARR_Y100"] 					= "Mutasd azokat a párokat, akik az utóbbi 100 évben házasodtak.";
$pgv_lang["button_MARR_U"] 					= "Mutasd azokat a párokat, akiknek nem ismert a házasságkötési dátumuk.";
$pgv_lang["button_MARR_DIV"] 					= "Mutasd az elvált párokat.";
$pgv_lang["button_DEAT_YES"] 					= "Mutasd azokat a személyeket, akik több mint 100 éve hunytak el.";
$pgv_lang["button_DEAT_Y100"] 					= "Mutasd azokat a személyeket, akik az utolsó 100 évben hunytak el.";
$pgv_lang["button_DEAT_Y"] 					= "Mutasd csak azokat a személyeket akik elhunytak, avgy azokat a párokat, akik mindketten elhunytak.";
$pgv_lang["button_DEAT_W"] 					= "Mutasd azokat a párokat, ahol a csak a nő hunyt el.";
$pgv_lang["button_DEAT_N"] 					= "Mutasd azokat a személyeket akik életben vannak, vagy párokat akik mindketten életben vannak.";
$pgv_lang["button_DEAT_H"] 					= "Mutasd azokat a párokat, ahol csak a férfi hunyt el.";
$pgv_lang["button_BIRT_YES"] 					= "Mutasd azokat a személyeket akik több mint 100 éve születtek.";
$pgv_lang["button_BIRT_Y100"] 					= "Mutasd az elmúlt 100 évben született személyeket";
$pgv_lang["button_alive_in_year"] 				= "Mutasd az élő személyeket a kiválasztott évben";
$pgv_lang["button_alive_in_year"] 				= "Mutasd az élő személyeket a kiválasztott évben";
$pgv_lang["module_error_unknown_type"] 				= "Ismeretlen modultípus.";
$pgv_lang["module_error_unknown_action_v2"] 			= "Ismeretlen tevékenység: [action].";
$pgv_lang["img_size"]						= "Képméret";
$pgv_lang["file_size"]						= "Fájlméret";
$pgv_lang["relations_heading"]					= "A kép a következőhöz tartozik:";
$pgv_lang["no_media"]						= "Nincs média";
$pgv_lang["download_image"]					= "Fájl letöltése";
$pgv_lang["view_slideshow"] 					= "Vetítés";
$pgv_lang["TYPE__magazine"] 					= "Magazin";
$pgv_lang["TYPE__map"] 						= "Térkép";
$pgv_lang["TYPE__newspaper"] 					= "Újság";
$pgv_lang["TYPE__photo"] 					= "Fotó";
$pgv_lang["TYPE__tombstone"] 					= "Sírkő";
$pgv_lang["TYPE__video"] 					= "Videó";
$pgv_lang["sort_column"] 					= "Rendezés ezen oszlop szerint";
$pgv_lang["differences"]					= "Különbségek";
$pgv_lang["genealogy"]						= "genealógia/leszármazás";
$pgv_lang["random_media_ajax_controls"]				= "Mutassuk a bemutató irányító gombjait?";
$pgv_lang["random_media_start_slide"]				= "Induljon el a képbemutató az oldal betöltésekor?";
$pgv_lang["stop"]						= "Megállítás";
$pgv_lang["play"]						= "Lejátszás";
$pgv_lang["deactivate"]						= "Deaktiválás";
$pgv_lang["activate"]						= "Aktiválás";
$pgv_lang["activate"]						= "aktív";
$pgv_lang["genealogy"]						= "genealógia";
$pgv_lang["cache_life"]						= "Gyorsítótár fájl élettartama";
$pgv_lang["duplicate_username"] 				= "A megadott felhasználónév már foglalt. Válasszon másikat.";
$pgv_lang["invalid_search_input"] 				= "Kérem adjon meg keresztnevet, vezetéknevet vagy helyet az év mellett";
$pgv_lang["search_place_word"]					= "Csak egész szavak";
$pgv_lang["changes_report"]					= "Változások jelentése";
$pgv_lang["changedate2"]					= "Dátumváltás kezdete";
$pgv_lang["changedate1"]					= "Dátumváltás vége";
$pgv_lang["chart_type"]						= "Grafikon típus";
$pgv_lang["charts_block_descr"]					= "A Grafikonok blokk segítségével, grafikont helyezhet el az üdvözlő, vagy a MyGedView oldalon. Beállíthatja a dobozt, hogy milyen nézetet használjon: ősök, leszármazottak vagy homokóra. Beállíthatja a kezdőszemélyt is.";
$pgv_lang["charts_block"]					= "Grafikon blokk";
$pgv_lang["switch_lifespan"]					= "Élettartam grafikon";
$pgv_lang["switch_timeline"]					= "Idővonal grafikon";
$pgv_lang["cemetery_report"]		= "Temetés jelentés";
$pgv_lang["spouse"] 				= "Házastárs";
$pgv_lang["rootid"] 				= "A családfa-grafikon kezdő személye";
$pgv_lang["gedcomid"]				= "A felhasználó azonosítója a GEDCOM-ban";
$pgv_lang["area_chart"]			= "Földrajzi terület";
$pgv_lang["asia_chart"]			= "Ázsia";
$pgv_lang["TYPE__painting"] = "Festmény";
$pgv_lang["TYPE__other"] = "Egyéb";
$pgv_lang["europe_chart"]		= "Európa";
$pgv_lang["s_america_chart"]	= "Dél-Amerika";
$pgv_lang["middle_east_chart"]	= "Közel-Kelet";
$pgv_lang["africa_chart"]		= "Afrika";
$pgv_lang["world_chart"]		= "Világ";
$pgv_lang["ahnentafel_married_post"]= "&nbsp;";
$pgv_lang["a.m."]         = "de.";
$pgv_lang["p.m."]         = "du.";
$pgv_lang["easter"]     = "Húsvét";
$pgv_lang["ascension"]  = "Mennybemenetel";
$pgv_lang["christmas"]  = "Karácsony";
$pgv_lang["TYPE__coat"] = "Címer pecsét";
$pgv_lang["nephew"]				= "Unokaöcs";
$pgv_lang["niece"]				= "Unokahúg";
$pgv_lang["avg_age"]				= "Átlagéletkor";
$pgv_lang["employer"] = "Munkáltató";
$pgv_lang["employee"] = "Munkavállaló";
$pgv_lang["wife_age"]				= "Feleség életkora";
$pgv_lang["husb_age"]				= "Férj életkora";
$pgv_lang["females"]				= "Nők";
$pgv_lang["males"]					= "Férfiak";
$pgv_lang["sortby"]					= "Sorrend";
$pgv_lang["sounds_like"]			= "Úgy hanzik mint";
$pgv_lang["step_parent_family"]		= "Mostoha szülök családja";
$pgv_lang["example"]				= "Példa:";
$pgv_lang["names"]					= "Nevek";
$pgv_lang["lchildren"]				= "gyerekek";
$pgv_lang["grandchildren"]			= "unokák";
$pgv_lang["search_notes"]			= "Közös jegyzetek";
$pgv_lang["font"]					= "Betütípus";
$pgv_lang["use_colors"]				= "Színek használata";
$pgv_lang["stat_unknown"]			= "Ismeretlen";
$pgv_lang["edit_shared_note"]		= "Közös jegyzet szerkesztése";
$pgv_lang["total_unknown"]			= "Ismeretlen";
$pgv_lang["others"]					= "Egyéb";
$pgv_lang["total_changes"]			= "Változások száma";
$pgv_lang["stepparent"]				= "Mostoha szülök";
$pgv_lang["facts"]					= "Események";
$pgv_lang["landscape_top"]			= "Legidősebb fent";
$pgv_lang["landscape_down"]			= "Legidősebb alúl";
$pgv_lang["generation_number"]		= "Generáció";
$pgv_lang["shared_note_list"]		= "Közös jegyzetek";
$pgv_lang["parent_age"] 			= "Szülők életkora";
$pgv_lang["historical_facts"]		= "Történelmi események";
$pgv_lang["partner"] 				= "Partner";
$pgv_lang["show_fact_sources"]		= "Mutasd az összes forrást";
$pgv_lang["show_fact_notes"]		= "Mutasd az összes jegyzetet";
$pgv_lang["enter_person_generations"] = "Generációk száma:";
$pgv_lang["shared_notes"]			= "Közös jegyzetek";
$pgv_lang["search_shared_notes"]	= "Közös jegyzetek";
$pgv_lang["repository"] 			= "Szervezet";
$pgv_lang["shared_note"]				= "Közös jegyzet";
$pgv_lang["shared_notes_found"]			= "Talált közös jegyzetek";
$pgv_lang["find_shared_note"]			= "Közös jegyzetek keresése";
$pgv_lang["shared_note_info"]			= "Közös jegyzet információja";
$pgv_lang["total_shared_notes"]			= "Közös jegyzetek száma";
$pgv_lang["skip_marnms"]			= "Házasságnév nélkül";
$pgv_lang["show_marnms"]			= "Házasságnévvel";
$pgv_lang["show_parents"] 			= "Mutassd a szülöket";
$pgv_lang["years2"]					= "év";	// For Polish 2,3,4 or 22,23,24 or 32,33,34 etc.
$pgv_lang["week1"]					= "hét";
$pgv_lang["weeks"]					= "hét";
$pgv_lang["after_death"]        	= "haláleset után";
$pgv_lang["at_death_day"]      		= "a haláleset dámunán";
$pgv_lang["saveandgo"]		= "Mentsd el és megy az új rekordhoz";
$pgv_lang["view_fam_nav_details"]	= "Részletek tekintése ...";
$pgv_lang["greatgrandchild"]		= "Dédunoka";
$pgv_lang["greatgrandson"]			= "Dédunoka fiú";
$pgv_lang["greatgranddaughter"]		= "Dédunoka lány";
$pgv_lang["brothers_wife"]		= "Sógornő"; // brother's wife
$pgv_lang["delete_shared_note"]		= "Közös jegyzet törlése";
$pgv_lang["confirm_delete_shared_note"]		= "Biztosan törölni szeretné ezt a közös jegyzetet?";
$pgv_lang["by_alpha"]				= "Ábécés sorrend";
$pgv_lang["individual_with_rela_report"]		= "Közeli rokonok jelentése";
$pgv_lang["fact_sources_report"]	= "Események forrása";
$pgv_lang["missing_facts_report"]	= "Közeli rokonok hiányzó eseményei";
$pgv_lang["sources_to_events"]		= "Események forrása";
$pgv_lang["godson"]		= "Keresztfiú";
$pgv_lang["goddaughter"] = "Keresztlány";
$pgv_lang["godchild"]	= "Keresztgyerek";
$pgv_lang["nanny"] = "Dadus";
$pgv_lang["owner"] = "Tulajdonos";
$pgv_lang["slave"] = "Szolga";
$pgv_lang["with_sources"]		= "Forrással";
$pgv_lang["without_sources"]	= "Forrás nélkül";
$pgv_lang["stat_sindi"]			= "Személyek forrással";
$pgv_lang["stat_sfam"]			= "Családok forrással";
$pgv_lang["map_type"]			= "Térkép típusa";
$pgv_lang["stat_2_map"]			= "Születés ország szerint";
$pgv_lang["stat_3_map"]			= "Halálozás ország szerint";
$pgv_lang["stat_4_map"]			= "Házasság ország szerint";
$pgv_lang["stat_5_birth"]		= "Születés századok szerint";
$pgv_lang["stat_6_death"]		= "Halálozás századok szerint";
$pgv_lang["stat_7_marr"]		= "Házasság századok szerint";
$pgv_lang["stat_7_div"]			= "Válás századok szerint";
$pgv_lang["stat_8_fam"]			= "Családok forrással";
$pgv_lang["stat_9_indi"]		= "Személyek forrással";
$pgv_lang["stat_22_fwok"]		= "Gyermek nélküli családok száma";
$pgv_lang["century"]			= "évszázad";
$pgv_lang["stat_age"]			= "Életkór";
$pgv_lang["less"]				= "kevesebb mint";
$pgv_lang["interval"]			= "intervallummal";
$pgv_lang["stat_largest_families"] = "Legnagyobb családok";
$pgv_lang["statnliving"]			= "Életbenlévök";
$pgv_lang["statndead"]				= "Elhúnytak";
$pgv_lang["stat_births"]			= "Születések száma";
$pgv_lang["stat_marriages"]			= "Házasságok száma";
$pgv_lang["stat_divorces"]			= "Válások száma";
$pgv_lang["stat_deaths"]			= "Halálesetek száma";
$pgv_lang["stplnuch"]			= "gyermekek";
$pgv_lang["shared_note_contains"]	= "Közös jegyzet tartalma:";
$pgv_lang["stat_long_marr_age"]		= "Leghosszab házasság";
$pgv_lang["stat_short_marr_age"]	= "Legrövidebb házasság";
$pgv_lang["stat_youngest_male"]		= "Legfiatalabb férfi";
$pgv_lang["stat_youngest_female"]	= "Legfiatalabb nő";
$pgv_lang["stat_oldest_male"]		= "Legidősebb férfi";
$pgv_lang["stat_oldest_female"]		= "Legidősebb nő";
$pgv_lang["stat_youngest_father"]	= "Legfiatalabb apa";
$pgv_lang["stat_youngest_mother"]	= "Legfiatalabb anya";
$pgv_lang["stat_oldest_father"]		= "Legőregebb apa";
$pgv_lang["stat_oldest_mother"]		= "Legőregebb anya";
$pgv_lang["stat_age_difference"]	= "Évkór különbség";
$pgv_lang["stat_age_siblings"]		= "Évkó különbség tesvérek között";
$pgv_lang["stat_age_mf_spouse"]		= "Évkór különbség férj és feleség között";
$pgv_lang["stat_age_fm_spouse"]		= "Évkór különbség feleség és férj között";
$pgv_lang["stat_names"]				= "Nevek";
$pgv_lang["statnsurnames"]			= "Családnevek";
$pgv_lang["statngivennames"]		= "Keresztnevek";
$pgv_lang["events"]					= "Események";
$pgv_lang["stat_notes"]				= "Jegyzetek";
$pgv_lang["stat_first_event"]		= "Az első esemény";
$pgv_lang["stat_last_event"]		= "Az utólsó esemény";
$pgv_lang["stat_places"]			= "Helyszínek";
$pgv_lang["stat_countries"]			= "Események országok szerint";
$pgv_lang["stat_birth_places"]		= "Születések helyszínei";
$pgv_lang["stat_marriage_places"]	= "Házasságok helyszínei";
$pgv_lang["stat_death_places"]		= "Halálozások elyszínei";
$pgv_lang["top_surnames"]			= "Leggyakoribb családnevek";
$pgv_lang["top_givennames"]			= "Leggyakoribb személynevek";
$pgv_lang["parent_family"]			= "Szülők családja";
$pgv_lang["age_differences"]		= "Dátum külőnbség mutatása";
$pgv_lang["showUnknown"]			= "Ismeretlen nem mutatása";
$pgv_lang["guardian"]	= "Gyámja";
$pgv_lang["no_date_fam"]		= "ismeretlen";
$pgv_lang["stat_first_birth"]		= "Legrégibb születés";
$pgv_lang["stat_first_marriage"]	= "Legrégibb házasság";
$pgv_lang["stat_first_divorce"]		= "Legrégibb elválás";
$pgv_lang["stat_first_death"]		= "Legrégibb haláleset";
$pgv_lang["stat_last_birth"]		= "Legutolsó születés";
$pgv_lang["stat_last_marriage"]		= "Legutolsó házasság";
$pgv_lang["stat_last_divorce"]		= "Legutolsó válás";
$pgv_lang["stat_last_death"]		= "Legutolsó haláleset";
$pgv_lang["stat_lived_longest"]		= "Legidősebb halott";
$pgv_lang["stat_live_longest"]		= "Legidősebb élő személy";
$pgv_lang["stat_marr_age"]			= "Házasság hossza";
?>
