<?php
/**
 * Greek Language file for PhpGedView.
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2010  PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @author Vangelis Skarmoutsos
 * @version $Id: lang.el.php 6989 2010-11-09 03:26:25Z canajun2eh $
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

$pgv_lang["download_file"]							= "Λήψη αρχείου #GLOBALS[whichFile]#";
$pgv_lang["none"]						= "Καμμία";
$pgv_lang["SHOW_ID_NUMBERS"]						= "Εμφάνιση αριθμών ID δίπλα στα ονόματα";
$pgv_lang["SHOW_HIGHLIGHT_IMAGES"]					= "Εμφάνιση επισημασμένων εικόνων στα κουτιά των ατόμων";
$pgv_lang["SHOW_HIGHLIGHT_IMAGES"]					= "Show highlight images in people boxes";
$pgv_lang["cancel"]									= "Άκυρο";
$pgv_lang["duplicate_username"]					= "Διπλότυπο όνομα χρήστη. Υπάρχει ήδη χρήστης με αυτό το όνομα χρήστη.  Παρακαλώ επιλέξτε άλλο όνομα χρήστη.";
$pgv_lang["family"]								= "Οικογένεια";
$pgv_lang["invalid_search_input"]				= "Παρακαλώ δώστε Όνομα, Επώνυμο ή Τοποθεσία \n\t καθώς και Έτος";

//-- GENERAL HELP MESSAGES
$pgv_lang["qm"]									= ";";
$pgv_lang["qm_ah"]								= ";";
$pgv_lang["page_help"]							= "Βοήθεια";
$pgv_lang["help_for_this_page"]					= "Βοήθεια για τη σελίδα αυτή";
$pgv_lang["help_contents"]						= "Περιεχέμενα Βοήθειας";
$pgv_lang["show_context_help"]					= "Εμφάνιση συναφούς βοήθειας";
$pgv_lang["hide_context_help"]					= "Απόκρυψη συναφούς βοήθειας";
$pgv_lang["sorry"]								= "<b>Συγνώμη, δεν έχουμε ολοκληρώσει το κείμενο βοήθειας για την σελίδα αυτή ή για το συγκεκριμένο θέμα</b>";
$pgv_lang["help_not_exist"]						= "<b>Το κείμενο βοήθειας, για την σελίδα αυτή ή για το θέμα αυτό, δεν είναι διαθέσιμο ακόμη</b>";
$pgv_lang["resolution"]							= "Ανάλυση οθόνης";
$pgv_lang["menu"]								= "Μενού";
$pgv_lang["header"]								= "Κεφαλίδα";
$pgv_lang["imageview"]							= "Προβολή εικόνων";
//-- CONFIG FILE MESSAGES
$pgv_lang["login_head"]							= "PhpGedView Σύνδεση χρήστη";
$pgv_lang["error_title"]						= "ΣΦΑΛΜΑ: Δεν ανοίγει το αρχείο GEDCOM";
$pgv_lang["for_support"]						= "Για τεχνική υποστήριξη και πληροφορίες επικοινωνήστε με";
$pgv_lang["for_contact"]						= "Για βοήθεια με γενεαλογικές ερωτήσεις, παρακαλώ επικοινωνήστε με";
$pgv_lang["for_all_contact"]					= "Για τεχνική υποστήριξη ή γενεαλογικές ερωτήσεις, παρακαλώ επικοινωνήστε με";
$pgv_lang["build_title"]						= "Δημιουργία Αρχείων Ευρετηρίου";
$pgv_lang["build_error"]						= "Το αρχείο GEDCOM έχει ενημερωθεί.";
$pgv_lang["please_wait"]						= "Παρακαλώ περιμένετε να ενημερωθούν τα αρχεία ευρετηρίου.";
$pgv_lang["choose_gedcom"]						= "Επιλέξτε ένα αρχεία GEDCOM";
$pgv_lang["username"]							= "Όνομα χρήστη";
$pgv_lang["invalid_username"]					= "Το όνομα χρήστη περιέχει άκυρους χαρακτήρες";
$pgv_lang["fullname"]							= "Ονοματεπώνυμο";
$pgv_lang["password"]							= "Κωδικός πρόσβασης";
$pgv_lang["confirm"]							= "Επιβεβαίωση κωδικού πρόσβασης";
$pgv_lang["login"]								= "Σύνδεση χρήστη";
$pgv_lang["login_aut"]							= "Διαμόρφωση Χρήστη";
$pgv_lang["logout"]								= "Αποσύνδεση";
$pgv_lang["admin"]								= "Διαχείριση";
$pgv_lang["logged_in_as"]						= "Συνδεδεμένος ως";
$pgv_lang["my_pedigree"]						= "Το γενεαλόγιο μου";
$pgv_lang["my_indi"]							= "Η ατομική μου καταχώρηση";
$pgv_lang["yes"]								= "Ναι";
$pgv_lang["no"]									= "Όχι";
$pgv_lang["no_support"]							= "Έχει εντοπιστεί ότι ο browser που χρησιμοποιείτε δεν υποστηρίζει τα πρωτόκολλα που χρησιμοποιούνται από την εφαρμογή PhpGedView. Οι περισσσότεροι browsers υποστηρίζουν αυτά τα πρωτόκολλα σε νεώτερες εκδόσεις τους. Παρακαλώ όπως αναβαθμίστε το browser σας σε νεώτερη έκδοση.";
$pgv_lang["change_theme"]						= "Αλλαγή θέματος εμφάνισης";
//-- INDEX (PEDIGREE_TREE) FILE MESSAGES
$pgv_lang["index_header"]						= "Γενεαλογικό δέντρο";
$pgv_lang["gen_ped_chart"]						= "Γενεαλογικό δέντρο #PEDIGREE_GENERATIONS# γενεών";
$pgv_lang["generations"]						= "Γενεές";
$pgv_lang["view"]								= "Προβολή";
$pgv_lang["fam_spouse"]							= "Οικογένεια με σύζυγο";
$pgv_lang["root_person"]						= "ID ατόμου ρίζας";
$pgv_lang["hide_details"]						= "Απόκρυψη λεπτομεριών";
$pgv_lang["show_details"]						= "Εμφάνιση λεπτομεριών";
$pgv_lang["person_links"]						= "Συνδέει σε διαγράμματα, οικογένειες, και στενούς συγγενείς του ατόμου αυτού. Κάντε κλικ στο εικονίδιο, για να προβάλετε αυτή τη σελίδα αρχίζοντας από αυτό το άτομο.";
$pgv_lang["zoom_box"]							= "Μεγένθυση/Σμίκρυνση στο κουτί αυτό.";
$pgv_lang["portrait"]							= "Κατακόρυφα";
$pgv_lang["landscape"]							= "Οριζόντια";
$pgv_lang["start_at_parents"]					= "Εκκίνηση από γονείς";
$pgv_lang["charts"]								= "Διαγράμματα";
$pgv_lang["lists"]								= "Κατάλογοι";
$pgv_lang["welcome_page"]						= "Σελίδα καλωσορίσματος";
$pgv_lang["max_generation"]						= "Ο μέγιστος αριθμός γενεών στο γενεαλόγιο είναι #PEDIGREE_GENERATIONS#.";
$pgv_lang["min_generation"]						= "Ο ελάχιστος αριθμός γενεών στο γενεαλόγιο είναι 3.";
$pgv_lang["box_width"]							= "Μήκος κουτιού";
//-- FUNCTIONS FILE MESSAGES
$pgv_lang["unable_to_find_family"]				= "Δεν βρέθηκε οικογένεια με ID";
$pgv_lang["unable_to_find_indi"]				= "Δεν υπάρχει άτομο με κωδικό";
$pgv_lang["unable_to_find_record"]				= "Δεν βρέθηκε εγγραφή με ID";
$pgv_lang["unable_to_find_source"]				= "Δεν υπάρχει πηγή με κωδικό";
$pgv_lang["unable_to_find_repo"]				= "Unable to find Repository with id";
$pgv_lang["repo_name"]							= "Όνομα Αποθηκοφυλακίου:";
$pgv_lang["address"]							= "Διεύθυνση:";
$pgv_lang["phone"]								= "Τηλέφωνο:";
$pgv_lang["source_name"]						= "Όνομα Πηγής:";
$pgv_lang["title"]								= "Τίτλος:";
$pgv_lang["author"]								= "Συγγραφέας:";
$pgv_lang["publication"]						= "Δημοσίευση:";
$pgv_lang["call_number"]						= "Call Number:";
$pgv_lang["living"]								= "Ζωντανοί";
$pgv_lang["private"]							= "Προσωπικά";
$pgv_lang["birth"]								= "Γέννηση:";
$pgv_lang["death"]								= "Θάνατος:";
$pgv_lang["descend_chart"]						= "Διάγραμμα απογόνων";
$pgv_lang["individual_list"]					= "Άτομα";
$pgv_lang["family_list"]						= "Οικογένειες";
$pgv_lang["source_list"]						= "Πηγές";
$pgv_lang["place_list"]							= "Ιεραρχία τόπων";
$pgv_lang["place_list_aft"]						= "Ιεραρχία τόπων μετά";
$pgv_lang["media_list"]							= "Πολυμέσα";
$pgv_lang["search"]								= "Αναζήτηση";
$pgv_lang["clippings_cart"]						= "Καλάθι αποκομμάτων οικογενειακού δέντρου";
$pgv_lang["not_an_array"]						= "Δεν είναι Κατάλογος";
$pgv_lang["print_preview"]						= "Έκδοση φιλική για εκτύπωση";
$pgv_lang["cancel_preview"]						= "Επιστροφή σε κανονική προβολή";
$pgv_lang["change_lang"]						= "Αλλαγή γλώσσας";
$pgv_lang["print"]								= "Εκτύπωση";
$pgv_lang["total_queries"]						= "Σύνολο επερωτήσεων στη βάση δεδομένων: ";
$pgv_lang["total_privacy_checks"]				= "Σύνολο ελέγχων ιδιωτικότητας: ";
$pgv_lang["back"]								= "Πίσω";
$pgv_lang["privacy_list_indi_error"]			= "Για λόγους προστασίας προσωπικών δεδομένων, ένα ή περισσότερα άτομα έχουν κρυφτεί.";
$pgv_lang["privacy_list_fam_error"]				= "Για λόγους προστασίας προσωπικών δεδομένων, μια ή περισσότερες οικογένειες έχουν κρυφτεί.";
//-- INDIVIDUAL FILE MESSAGES
$pgv_lang["aka"]								= "Παρατσούκλι(α)";
$pgv_lang["male"]								= "Άρσενικό";
$pgv_lang["female"]								= "Θηλυκό";
$pgv_lang["temple"]								= "Ναός LDS";
$pgv_lang["temple_code"]						= "Κωδικός ναού LDS:";
$pgv_lang["status"]								= "Κατάσταση";
$pgv_lang["source"]								= "Πηγή";
$pgv_lang["citation"]							= "Citation:";
$pgv_lang["text"]								= "Κείμενο πηγής:";
$pgv_lang["note"]								= "Σημείωση";
$pgv_lang["NN"]									= "(άγνωστο)";
$pgv_lang["PN"]									= "(άγνωστο)";
$pgv_lang["unrecognized_code"]					= "Μη αναγνωρίσιμος κώδικας GEDCOM";
$pgv_lang["unrecognized_code_msg"]				= "Αυτό είναι ένα σφάλμα και θα θέλαμε να το διορθώσουμε. Παρακαλώ αναφέρετε αυτό το σφάλμα σε";
$pgv_lang["indi_info"]							= "Πληροφορίες ατόμου";
$pgv_lang["pedigree_chart"]						= "Γενεαλογικό διάγραμμα";
$pgv_lang["desc_chart2"]						= "Διάγραμμα Απογόνων";
$pgv_lang["family_with"]						= "Οικογένεια με";
$pgv_lang["as_spouse"]							= "Οικογένεια με σύζυγο";
$pgv_lang["as_child"]							= "Οικογένεια με γονείς";
$pgv_lang["view_gedcom"]						= "Εμφάνιση εγγραφής GEDCOM";
$pgv_lang["add_to_cart"]						= "Προσθήκη στο καλάθι αποκομμάτων";
$pgv_lang["still_living_error"]					= "Το άτομο αυτό είτε είναι εν ζωή είτε δεν έχει καταγεγραμμένη ημερομηνία γέννησης ή ημερομηνία θανάτου.   Οι λεπτομέρειες ατόμων εν ζωή έχουν κρυφτεί από δημόσια θέαση.<br />Για περισσότερες πληροφορίες επικοινωνήστε με";
$pgv_lang["privacy_error"]						= "Οι πληροφορίες είναι ιδιωτικές και δεν μπορούν να εμφανιστούν.";
$pgv_lang["more_information"]					= "Για περισσότερες πληροφορίες επικοινωνήστε με";
$pgv_lang["name"]								= "Όνομα";
$pgv_lang["given_name"]							= "Δοσμένο όνομα:";
$pgv_lang["surname"]							= "Επώνυμο:";
$pgv_lang["suffix"]								= "Επίθεμα:";
$pgv_lang["object_note"]						= "Object Σημειώσεις:";
$pgv_lang["sex"]								= "Φύλο";
$pgv_lang["personal_facts"]						= "Προσωπικά γεγονότα και λεπτομέρειες";
$pgv_lang["type"]								= "Τύπος";
$pgv_lang["place_description"]					= "Τόπος / Περιγραφή";
$pgv_lang["parents"]							= "Γονείς";
$pgv_lang["siblings"]							= "Αδέλφια";
$pgv_lang["father"]								= "Πατέρας";
$pgv_lang["mother"]								= "Μητέρα";
$pgv_lang["relatives"]							= "Πλησιέστεροι συγγενείς";
$pgv_lang["child"]								= "Παιδί";
$pgv_lang["spouse"]								= "Σύζυγος";
$pgv_lang["surnames"]							= "Επώνυμα";
$pgv_lang["adopted"]							= "Υιοθετημένος/η";
$pgv_lang["foster"]								= "Θετός";
$pgv_lang["sealing"]							= "Sealing";
$pgv_lang["link_as"]							= "Σύνδεση του ατόμου αυτού σε υπάρχουσα οικογένεια ως ";
$pgv_lang["no_tab1"]							= "Δεν υπάρχουν γεγονότα για το άτομο αυτό.";
$pgv_lang["no_tab2"]							= "Δεν υπάρχουν σημειώσεις για το άτομο αυτό.";
$pgv_lang["no_tab3"]							= "Δεν υπάρχουν αναφορές πηγών για το άτομο αυτό.";
$pgv_lang["no_tab4"]							= "Δεν υπάρχουν αντικείμενα μέσων για το άτομο αυτό.";
$pgv_lang["no_tab5"]							= "Δεν υπάρχουν κοντινοί συγγενείς για το άτομο αυτό.";
$pgv_lang["no_tab6"]							= "Δεν υπάρχει ημερολόγιο έρευνας προσαρτημένο στο άτομο αυτό.";
//-- FAMILY FILE MESSAGES
$pgv_lang["family_info"]						= "Πληροφορίες οικογένειας";
$pgv_lang["family_group_info"]					= "Πληροφορίες οικογενειακής ομάδας";
$pgv_lang["husband"]							= "Σύζυγος (άνδρας)";
$pgv_lang["wife"]								= "Σύζυγος (γυναίκα)";
$pgv_lang["marriage"]							= "Γάμος:";
$pgv_lang["lds_sealing"]						= "Σφράγιση LDS:";
$pgv_lang["marriage_license"]					= "Άδεια γάμου:";
$pgv_lang["media_object"]						= "Αντικείμενο Πολυμέσων:";
$pgv_lang["children"]							= "Παιδιά";
$pgv_lang["no_children"]						= "Δεν έχουν καταχωρηθεί παιδιά";
$pgv_lang["parents_timeline"]					= "Εμφάνιση ζευγαριού στο <br />χρονοδιάγραμμα";
//-- CLIPPINGS FILE MESSAGES
$pgv_lang["clip_cart"]							= "Καλάθι αποκομμάτων";
$pgv_lang["clip_explaination"]					= "Το Καλάθι Αποκομμάτων Οικογενειακού Δέντρου επιτρέπει την ανάκτηση &quot;αποκομμάτων&quot; από αυτό το οικογενειακό δέντρο και την δημιουργία ενός αρχείου GEDCOM που μπορείτε να κατεβάσετε στον υπολογιστή σας.<br /><br />";
$pgv_lang["item_with_id"]						= "Αντικείμενο με κωδικό id";
$pgv_lang["error_already"]						= "είναι ήδη στο καλάθι αποκομμάτων.";
$pgv_lang["which_links"]						= "Ποιές συνδέσεις από την οικογένεια αυτή θέλετε να προσθέσετε;";
$pgv_lang["just_family"]						= "Προσθήκη μόνο αυτής της οικογενειακής εγγραφής.";
$pgv_lang["parents_and_family"]					= "Προσθήκη εγγραφών γονέων μαζί με αυτή την οικογενειακή εγγραφή.";
$pgv_lang["parents_and_child"]					= "Προσθήκη εγγραφών γονέων και παιδιών, μαζί με αυτή την οικογενειακή εγγραφή.";
$pgv_lang["parents_desc"]						= "Προσθήκη εγγραφών γονέων και απογόνων, μαζί με αυτή την οικογενειακή εγγραφή.";
$pgv_lang["continue"]							= "Συνέχιση πρόσθεσης";
$pgv_lang["which_p_links"]						= "Ποιές συνδέσεις από αυτό το άτομο θα θέλατε επίσης να προσθέσετε;";
$pgv_lang["just_person"]						= "Προσθήκη μόνο αυτού του ατόμου.";
$pgv_lang["person_parents_sibs"]				= "Προσθήκη του ατόμου αυτού, των γονιών του, και των αδερφιών του.";
$pgv_lang["person_ancestors"]					= "Προσθήκη του ατόμου αυτού και των απευθείας προγόνων του.";
$pgv_lang["person_ancestor_fams"]				= "Προσθήκη του ατόμου αυτού, των απευθείας προγόνων του, και των οικογενειών τους.";
$pgv_lang["person_spouse"]						= "Προσθήκη του ατόμου αυτού, του συζύγου του, και των παιδιών.";
$pgv_lang["person_desc"]						= "Προσθήκη του ατόμου αυτού, του συζύγου του, και όλων των απογόνων.";
$pgv_lang["unable_to_open"]						= "Αδυναμία εγγραφής στον κατάλογο αποκομμάτων.";
$pgv_lang["person_living"]						= "Το άτομο αυτό είναι εν ζωή. Ατομικές λεπτομέρειες δεν θα συμπεριληφθούν.";
$pgv_lang["person_private"]						= "Οι λεπτομέρειες για το άτομο αυτό είναι ιδιωτικές. Οι ατομικές λεπτομέρειες δεν θα συμπεριληφθούν.";
$pgv_lang["family_private"]						= "Οι λεπτομέρειες για την οικογένεια αυτή είναι ιδιωτικές. Οι οικογενειακές λεπτομέρειες δεν θα συμπεριληφθούν.";
$pgv_lang["download"]							= "Κάντε δεξί κλικ (control-κλικ σε Mac) στις παρακάτω συνδέσεις και επιλέξτε &quot;Αποθήκευση προορισμού ως&quot; για λήψη των αρχείων.";
$pgv_lang["media_files"]						= "Αρχεία Φωτογραφιών που αναφέρονται σε αυτό το αρχείο GEDCOM";
$pgv_lang["cart_is_empty"]						= "Το καλάθι αποκομμάτων είναι άδειο.";
$pgv_lang["id"]									= "Ταυτότητα (ID)";
$pgv_lang["ID"]									= "Ταυτότητα (ID)";
$pgv_lang["name_description"]					= "Όνομα / Περιγραφή";
$pgv_lang["remove"]								= "Αφαίρεση";
$pgv_lang["empty_cart"]							= "Άδειο καλάθι";
$pgv_lang["download_now"]						= "Λήψη τώρα";
$pgv_lang["indi_downloaded_from"]				= "Το άτομο αυτό έχει ληφθεί από:";
$pgv_lang["family_downloaded_from"]				= "Η οικογένεια αυτή έχει ληφθεί από:";
$pgv_lang["source_downloaded_from"]				= "Η πηγή αυτή έχει ληφθεί από:";
//-- PLACELIST FILE MESSAGES
$pgv_lang["connections"]						= "Ευρεθείσες συνδέσεις τόπων";
$pgv_lang["top_level"]							= "Ανώτατο επίπεδο";
$pgv_lang["form"]								= "Οι τοποθεσίες έχουν κωδικοποιηθεί στη μορφή: ";
$pgv_lang["default_form"]						= "Πόλη, County, Πολιτεία/Νομός, Χώρα";
$pgv_lang["default_form_info"]					= "(Προκαθορισμένο)";
$pgv_lang["gedcom_form_info"]					= "(GEDCOM)";
$pgv_lang["unknown"]							= "άγνωστο";
$pgv_lang["individuals"]						= "Άτομα";
$pgv_lang["view_records_in_place"]				= "Εμφάνιση όλων των εγγραφών που βρέθηκαν στον τόπο αυτό";
$pgv_lang["place_list2"]						= "Κατάλογος τοποθεσιών";
$pgv_lang["show_place_hierarchy"]				= "Εμφάνιση τοποθεσιών σε ιεραρχία";
$pgv_lang["show_place_list"]					= "Εμφάνιση όλων των τόπων σε κατάλογο";
$pgv_lang["total_unic_places"]					= "Σύνολο μοναδικών τόπων";
//-- MEDIALIST FILE MESSAGES
$pgv_lang["multi_title"]						= "Αντικείμενα πολυμέσων";
$pgv_lang["media_found"]						= "Ευρεθέντα αντικείμενα μέσων";
$pgv_lang["view_person"]						= "Προβολή ατόμου";
$pgv_lang["view_family"]						= "Προβολή οικογένειας";
$pgv_lang["view_source"]						= "Προβολή πηγής";
$pgv_lang["prev"]								= "&lt; Προηγούμενο";
$pgv_lang["next"]								= "Επόμενο &gt;";
$pgv_lang["file_not_found"]						= "Το αρχείο δεν βρέθηκε.";
$pgv_lang["medialist_show"]						= "Εμφάνιση";
$pgv_lang["per_page"]							= "Αντικείμενα μέσων ανά σελίδα";
//-- SEARCH FILE MESSAGES
$pgv_lang["search_gedcom"]						= "Αναζήτηση βάσεων δεδομένων (GEDCOM)";
$pgv_lang["enter_terms"]						= "Εισάγετε όρους αναζήτησης";
$pgv_lang["soundex_search"]						= "Αναζήτηση όπως νομίζετε οτι γράφεται το όνομα (Soundex):";
$pgv_lang["sources"]							= "Πηγές";
$pgv_lang["firstname_search"]					= "Δοσμένο όνομα";
$pgv_lang["lastname_search"]					= "Επώνυμο";
$pgv_lang["search_place"]						= "Τόπος";
$pgv_lang["search_year"]						= "Έτος";
$pgv_lang["no_results"]							= "Δεν βρέθηκαν αποτελέσματα.";
//-- SOURCELIST FILE MESSAGES
$pgv_lang["sources_found"]						= "Πηγές βρέθηκαν";
$pgv_lang["titles_found"]						= "Τίτλοι";
//-- SOURCE FILE MESSAGES
$pgv_lang["source_info"]						= "Πληροφορίες πηγής";
$pgv_lang["other_records"]						= "Εγγραφές που συνδέονται σε αυτή την Πηγή:";
$pgv_lang["people"]								= "Άτομα";
$pgv_lang["families"]							= "Οικογένειες";
$pgv_lang["total_sources"]						= "Σύνολο πηγών";
//-- BUILDINDEX FILE MESSAGES
$pgv_lang["building_indi"]						= "Δημιουργία Ευρετηρίων Ατόμων και Οικογενειών";
$pgv_lang["building_index"]						= "Δημιουργία Καταλόγων Ευρετηρίου";
$pgv_lang["invalid_gedformat"]					= "Άκυρη μορφή GEDCOM 5.5";
$pgv_lang["importing_records"]					= "Εισαγωγή Στοιχείων στη Βάση Δεδομένων";
$pgv_lang["detected_change"]					= "Η εφαρμογή PhpGedView έχει ανιχνεύση αλλαγή στο GEDCOM αρχείο #GEDCOM#. Πρέπει να ενημερωθούν τα αρχεία ευρετηρίου πριν επιτραπούν άλλες ενέργειες.";
$pgv_lang["flushing"]							= "Flushing contents";
$pgv_lang["exec_time"]							= "Χρόνος εκτέλεσης:";
$pgv_lang["unable_to_create_index"]				= "Αδύνατο να δημιουργηθούν αρχεία index. Σιγουρευτείτε ότι έχει οριστεί να επιτρέπεται το γράψιμο στο κατάλογο PhpGedView.  Μπορείτε να κάνετε επαναφορά αυτής της ρύθμισης, μόλις τα αρχεία index έχουν γραφεί.";
$pgv_lang["indi_complete"]						= "Individual Index file update complete.";
$pgv_lang["family_complete"]					= "Family Index file update complete.";
$pgv_lang["source_complete"]					= "Source Index file update complete.";
$pgv_lang["tables_exist"]						= "PhpGedView Tables already exist in the database";
$pgv_lang["you_may"]							= "Μπορείτε:";
$pgv_lang["drop_tables"]						= "Διαγραφή των υπαρχόντων πινάκων της βάσης δεδομένων";
$pgv_lang["import_multiple"]					= "Import and work with multiple GEDCOMs";
$pgv_lang["explain_options"]					= "If you choose to drop the tables all of the data will be replaced with this GEDCOM.<br />If you choose to import and work with multiple GEDCOMs, PhpGedView will erase any data that was imported using a GEDCOM with the same file name.  This option allows you to store multiple GEDCOM data in the same tables and easily switch between them.";
$pgv_lang["path_to_gedcom"]						= "Enter the path to your GEDCOM file:";
$pgv_lang["gedcom_title"]						= "Enter a title that describes the data in this GEDCOM file";
$pgv_lang["index_complete"]						= "Index Complete.";
$pgv_lang["updating_is_dead"]					= "Updating is dead status for INDI ";
$pgv_lang["updating_family_names"]				= "Updating family names for FAM ";
$pgv_lang["processed_for"]						= "Επεξεργασία αρχείου για ";
$pgv_lang["run_tools"]							= "Do you want to run one of the following tools on your GEDCOM before it is imported:";
$pgv_lang["addmedia"]							= "Add Media Tool";
$pgv_lang["dateconvert"]						= "Εργαλείο Μετατροπής Ημερομηνίας";
$pgv_lang["xreftorin"]							= "Convert XREF IDs to RIN number";
$pgv_lang["tools_readme"]						= "See the tools secion of the #README.TXT# file for more information.";
$pgv_lang["sec"]								= "sec.";
//-- INDIVIDUAL AND FAMILYLIST FILE MESSAGES
$pgv_lang["total_fams"]							= "Σύνολο οικογενειών";
$pgv_lang["total_indis"]						= "Σύνολο ατόμων";
$pgv_lang["starts_with"]						= "Starts With:";
$pgv_lang["person_list"]						= "Κατάλογος Ατόμων:";
$pgv_lang["paste_person"]						= "Επικόλληση Ατόμου";
$pgv_lang["notes_sources_media"]				= "Σημειώσεις, Πηγές, και Πολυμέσα";
$pgv_lang["notes"]								= "Σημειώσεις";
$pgv_lang["ssourcess"]							= "Πηγές";
$pgv_lang["media"]								= "Πολυμέσα";
$pgv_lang["name_contains"]						= "Το όνομα περιέχει:";
$pgv_lang["filter"]								= "Φίλτρο";
$pgv_lang["find_individual"]					= "Εύρεση ID ατόμου";
$pgv_lang["find_familyid"]						= "Εύρεση ID οικογένειας";
$pgv_lang["find_sourceid"]						= "Εύρεση ID πηγής";
$pgv_lang["skip_surnames"]						= "Παράλειψη καταλόγου επωνύμων";
$pgv_lang["show_surnames"]						= "Εμφάνιση καταλόγου επωνύμων";
$pgv_lang["all"]								= "ΌΛΑ";
$pgv_lang["hidden"]								= "Κρυφό";
//-- TIMELINE FILE MESSAGES
$pgv_lang["age"]								= "Ηλικία";
$pgv_lang["timeline_title"]						= "PhpGedView Χρονοδιάγραμμα";
$pgv_lang["timeline_chart"]						= "Χρονοδιάγραμμα";
$pgv_lang["remove_person"]						= "Αφαίρεση ατόμου";
$pgv_lang["show_age"]							= "Εμφάνιση σήμανσης ηλικίας";
$pgv_lang["add_another"]						= "Προσθήκη και άλλου ατόμου στο διάγραμμα:<br />ID ατόμου:";
$pgv_lang["find_id"]							= "Εύρεση ID";
$pgv_lang["show"]								= "Εμφάνιση";
$pgv_lang["year"]								= "Έτος:";
$pgv_lang["timeline_instructions"]				= "Σε πιο πρόσφατους φυλλομετρητές μπορείτε να σύρετε τα κουτιά γύρω από το διάγραμμα.";
$pgv_lang["zoom_in"]							= "Μεγέθυνση";
$pgv_lang["zoom_out"]							= "Σμίκρυνση";

$pgv_lang["cal_gregorian"]            = "Γρηγοριανό";
$pgv_lang["cal_julian"]               = "Ιουλιανό";
$pgv_lang["cal_french"]               = "Γαλλικό";
$pgv_lang["cal_jewish"]               = "Ιουδαϊκό";
$pgv_lang["cal_hebrew"]               = "Εβραϊκό";
$pgv_lang["cal_jewish_and_gregorian"] = "Ιουδαϊκό και Γρηγοριανό";
$pgv_lang["cal_hebrew_and_gregorian"] = "Εβραϊκό και Γρηγοριανό";
$pgv_lang["cal_hijri"]                = "Εγίρας (ισλαμικό)";
$pgv_lang["cal_arabic"]               = "Αραβικό";

//-- MONTH NAMES
$pgv_lang["jan"]								= "Ιανουάριος";
$pgv_lang["feb"]								= "Φεβρουάριος";
$pgv_lang["mar"]								= "Μάρτιος";
$pgv_lang["apr"]								= "Απρίλιος";
$pgv_lang["may"]								= "Μάιος";
$pgv_lang["jun"]								= "Ιούνιος";
$pgv_lang["jul"]								= "Ιούλιος";
$pgv_lang["aug"]								= "Αύγουστος";
$pgv_lang["sep"]								= "Σεπτέμβριος";
$pgv_lang["oct"]								= "Οκτώβριος";
$pgv_lang["nov"]								= "Νοέμβριος";
$pgv_lang["dec"]								= "Δεκέμβριος";
$pgv_lang["abt"]								= "περίπου";
$pgv_lang["aft"]								= "μετά";
$pgv_lang["and"]								= "και";
$pgv_lang["bef"]								= "πριν";
$pgv_lang["bet"]								= "μεταξύ";
$pgv_lang["cal"]								= "υπολογισμένο";
$pgv_lang["est"]								= "εκτιμώμενο";
$pgv_lang["from"]								= "από";
$pgv_lang["int"]								= "ερμηνευόμενο";
$pgv_lang["to"]									= "έως";
$pgv_lang["cir"]								= "circa";
$pgv_lang["apx"]								= "περ.";
//-- Admin File Messages
$pgv_lang["rebuild_indexes"]					= "Rebuild Indexes";
$pgv_lang["user_admin"]							= "Διαχείριση χρηστών";
$pgv_lang["password_mismatch"]					= "Οι κωδικοί δεν ταυτίζονται.";
$pgv_lang["enter_username"]						= "Πρέπει να εισάγετε όνομα χρήστη.";
$pgv_lang["enter_fullname"]						= "Πρέπει να εισάγετε δοσμένο όνομα και επώνυμο.";
$pgv_lang["enter_password"]						= "Πρέπει να εισάγετε κωδικό πρόσβασης.";
$pgv_lang["confirm_password"]					= "Πρέπει να επιβεβαιώστε τον κωδικό.";
$pgv_lang["save"]								= "Αποθήκευση";
$pgv_lang["delete"]								= "Διαγραφή";
$pgv_lang["edit"]								= "Επεξεργασία";
$pgv_lang["no_login"]							= "Αδυναμία πιστοποίησης χρήστη.";
$pgv_lang["import_gedcom"]						= "Εισαγωγή Αρχείου GEDCOM";
$pgv_lang["enter_gedcomid"]						= "You must enter a GEDCOM ID.";
$pgv_lang["user_info"]							= "My User Information";
$pgv_lang["GEDCOM_file"]						= "Αρχείο GEDCOM:";
$pgv_lang["enter_filename"]						= "Πρέπει να πληκτρολογήστε όνομα αρχείου GEDCOM.";
$pgv_lang["file_not_exists"]					= "Το όνομα αρχείου που πληκτρολογήσατε δεν υπάρχει.";
$pgv_lang["file_exists"]						= "There is already a GEDCOM with that file name. Please choose a different file name or delete the old file.";
$pgv_lang["new_gedcom_title"]					= "Γενεαλογία από [#GEDCOMFILE#]";
$pgv_lang["upload_help"]						= "Select a file from your local computer to upload to your server.  All files will be uploaded to the directory:";
$pgv_lang["add_gedcom_instructions"]			= "Enter a filename for this new GEDCOM.  The new GEDCOM file will be created in the Index directory: ";
$pgv_lang["research_log"]						= "Ημερολόγιο Έρευνας";
$pgv_lang["utf8_to_ansi"]						= "Θέλετε να μετατρέψετε αυτό το GEDCOM από UTF-8 σε ANSI (ISO-8859-1);";
$pgv_lang["user_manual"]						= "Εγχειρίδιο Χρήσης PhpGedView";
$pgv_lang["upgrade"]							= "Upgrade PhpGedView/ResearchLog";
$pgv_lang["step1"]								= "Βήμα 1 από 4:";
$pgv_lang["step3"]								= "Βήμα 3 από 4:";
$pgv_lang["step4"]								= "Βήμα 4 από 4:";
$pgv_lang["cancel_upload"]						= "Ακύρωση Αποστολής";
//-- Relationship chart messages
$pgv_lang["relationship_chart"]					= "Διάγραμμα συγγενείας";
$pgv_lang["person1"]							= "Άτομο 1";
$pgv_lang["person2"]							= "Άτομο 2";
$pgv_lang["no_link_found"]						= "Δεν βρέθηκε καμία σύνδεση ανάμεσα στα δύο άτομα.";
$pgv_lang["sibling"]							= "Αδέλφια";
$pgv_lang["follow_spouse"]						= "Έλεγχος συγγένειας από γάμο";
$pgv_lang["timeout_error"]						= "Ξεπεράστηκε ο επιτρεπόμενος χρόνος του σεναρίου, πριν βρεθεί κάποια συγγένεια.";
$pgv_lang["son"]								= "Υιός";
$pgv_lang["daughter"]							= "Θυγατέρα";
$pgv_lang["brother"]							= "Αδελφός";
$pgv_lang["sister"]								= "Αδελφή";
$pgv_lang["relationship_to_me"]					= "Συγγένεια με εμένα";
$pgv_lang["next_path"]							= "Εύρεση επόμενης διαδρομής";
$pgv_lang["show_path"]							= "Εμφάνιση διαδρομής";
$pgv_lang["line_up_generations"]				= "Στοίχιση όμοιων γενεών";
$pgv_lang["oldest_top"]							= "Εμφάνιση πρώτα του μεγαλύτερου";
//-- GEDCOM edit utility
$pgv_lang["check_delete"]						= "Είστε σίγουροι ότι θέλετε να διαγράψετε αυτό το γεγονός;";
$pgv_lang["access_denied"]						= "<b>Απαγορεύεται η πρόσβαση</b><br />Δεν έχετε πρόσβαση σε αυτό τον πόρο.";
$pgv_lang["changes_exist"]						= "Έχουν γίνει αλλαγές σε αυτό το GEDCOM.";
$pgv_lang["find_place"]							= "Εύρεση τόπου";
$pgv_lang["close_window"]						= "Κλείσιμο παραθύρου";
$pgv_lang["close_window_without_refresh"]		= "Κλείσιμο παραθύρου χωρίς επαναφόρτωση";
$pgv_lang["place_contains"]						= "Ο τόπος περιέχει:";
$pgv_lang["now_import"]							= "Now you should import the GEDCOM records into PhpGedView by clicking on the import link below.";
$pgv_lang["add"]								= "Προσθήκη";
$pgv_lang["custom_event"]						= "Προσαρμοσμένο συμβάν";
$pgv_lang["delete_person"]						= "Διαγραφή αυτού του ατόμου";
$pgv_lang["confirm_delete_person"]				= "Είστε σίγουροι ότι θέλετε να διαγράψετε αυτό το άτομο από το αρχείο GEDCOM;";
$pgv_lang["find_media"]							= "Εύρεση μέσου";
$pgv_lang["set_link"]							= "Ορισμός συνδέσμου";
$pgv_lang["delete_source"]						= "Διαγραφή αυτής της πηγής";
$pgv_lang["confirm_delete_source"]				= "Είστε σίγουροι ότι θέλετε να διαγράψετε αυτή την πηγή από το αρχείο GEDCOM;";
$pgv_lang["find_family"]						= "Εύρεση οικογένειας";
$pgv_lang["find_fam_list"]						= "Εύρεση καταλόγου οικογένειας";
$pgv_lang["edit_name"]							= "Επεξεργασία ονόματος";
$pgv_lang["delete_name"]						= "Διαγραφή ονόματος";
$pgv_lang["select_date"]						= "Επιλογή ημερομηνίας";
$pgv_lang["user_cannot_edit"]					= "Αυτό το όνομα χρήστη δεν μπορεί να επεξεργαστεί αυτό το GEDCOM.";
//-- calendar.php messages
$pgv_lang["on_this_day"]						= "Σαν σήμερα, στην ιστορία μας...";
$pgv_lang["in_this_month"]						= "Στο μήνα αυτό, στην ιστορία μας...";
$pgv_lang["in_this_year"]						= "Στο έτος αυτό, στην ιστορία μας...";
$pgv_lang["year_anniversary"]					= "#year_var# Επέτειος";
$pgv_lang["today"]								= "Σήμερα";
$pgv_lang["day"]								= "Ημέρα:";
$pgv_lang["month"]								= "Μήνας:";
$pgv_lang["showcal"]							= "Εμφάνιση συμβάντων της:";
$pgv_lang["anniversary_calendar"]				= "Ημερολόγιο επετείων";
$pgv_lang["sunday"]								= "Κυριακή";
$pgv_lang["monday"]								= "Δευτέρα";
$pgv_lang["tuesday"]							= "Τριτη";
$pgv_lang["wednesday"]							= "Τετάρτη";
$pgv_lang["thursday"]							= "Πέμπτη";
$pgv_lang["friday"]								= "Παρασκευή";
$pgv_lang["saturday"]							= "Σάββατο";
$pgv_lang["viewday"]							= "Προβολή ημέρας";
$pgv_lang["viewmonth"]							= "Προβολή μήνα";
$pgv_lang["viewyear"]							= "Προβολή έτους";
$pgv_lang["all_people"]							= "Όλα τα άτομα";
$pgv_lang["living_only"]						= "Ζωντανά άτομα";
$pgv_lang["recent_events"]						= "Πρόσφατα έτη (&lt; 100 έτη)";
$pgv_lang["day_not_set"]						= "Δεν ορίστηκε ημέρα";
$pgv_lang["year_error"]							= "Sorry, dates before 1970 are not supported.";
//-- upload media messages
//-- user self registration module
//$pgv_lang["no_pw_or_account"]					= "If you have no account yet, or lost your password, just click the <b>Login</b> button";
$pgv_lang["lost_password"]						= "Χάσατε τον κωδικό σας;";
$pgv_lang["requestpassword"]					= "Αίτηση νέου κωδικού";
$pgv_lang["no_account_yet"]						= "Δεν έχετε ακόμη λογαριασμό;";
$pgv_lang["requestaccount"]						= "Αίτηση νέου λογαριασμού χρήστη";
$pgv_lang["register_info_01"]					= "The amount of data that can be publicly viewed on this website may be limited due to applicable law concerning privacy protection. Most people do not want their personal data publicly available on the Internet. It could be misused for spam or identity theft.<br /><br />To gain access to the private data, you must have an account on this website. To gain an account you may register yourself by providing the requested information. After the administrator has checked your registration and approved it, you will be able to login and view the private data.<br /><br />If the relationship privacy is activated you will only be able to access your own close relative's private information after logging in. The administrator can also provide access to database editing, so you can change or add information.<br /><br />NOTE: You only will receive access to the private data if you can prove that you are a close relative of a person in the database.<br /><br />If you are not a close relative you will probably not be given an account, so you should save yourself the trouble.<br />If you need any further support, please use the link below to contact the webmaster.<br /><br />";
$pgv_lang["register_info_02"]					= "";
$pgv_lang["pls_note01"]							= "Please note: The system is case-sensitive!";
$pgv_lang["min6chars"]							= "Password has to contain at least 6 characters";
$pgv_lang["pls_note02"]							= "Please note: Passwords can contain letters and numbers and other characters.";
$pgv_lang["pls_note03"]							= "This email address will be verified before account activation. It will not be displayed on the site. A message will be sent to this Email address with your registration data";
$pgv_lang["emailadress"]						= "Διεύθυνση email";
$pgv_lang["pls_note04"]							= "Fields marked with * are mandatory.";
$pgv_lang["pls_note05"]							= "Pending completion of the form on this page and verification of your answers, you will be sent a confirmation message to the email address you specify on this page. Using the confirmation email, you will activate your account; if you fail to activate your account within seven days, it will be purged (you may attempt to register the account again at that time). To use this site, you will need to know your login name and password. You must specify an existing, valid email address on this page in order to receive the account confirmation email.<br /><br />If you encounter an issue in registering an account on this website, please submit a Support Request to the webmaster.";
$pgv_lang["mail01_line01"]						= "Γειά σου #user_fullname# ...";
$pgv_lang["mail01_line02"]						= "Μία αίτηση λήφθηκε στο #SERVER_NAME# για τη δημιουργία ενός λογαριασμού, με χρήση του email σας #user_email#.";
$pgv_lang["mail01_line03"]						= "Πληροφορίες σχετικά με την αίτηση εμφανίζονται κάτω από τον σύνδεσμο παρακάτω.";
$pgv_lang["mail01_line04"]						= "Please click on the link below and fill in the requested data to verify your Account and Email address.";
$pgv_lang["mail01_line05"]						= "Εάν δεν ζητήσατε εσείς τον λογαριασμό, μπορείτε απλά να διαγράψετε αυτό το μήνυμα.";
$pgv_lang["mail01_line06"]						= "Δεν θα λάβετε περισσότερα email από αυτή την τοποθεσία, γιατί η αίτηση λογαριασμού θα διαγραφεί αυτόματα μετά από επτά ημέρες.";
$pgv_lang["mail01_subject"]						= "Η καταχώρηση σας στο #SERVER_NAME#";
$pgv_lang["mail02_line01"]						= "Γεια σου διαχειριστή ...";
$pgv_lang["mail02_line02"]						= "Ένας υποψήφιος χρήστης καταχώρησε τον εαυτό του με το PhpGedView στο #SERVER_NAME#.";
$pgv_lang["mail02_line03"]						= "Ο χρήστης έλαβε ένα email με πληροφορίες απαραίτητες για να επιβεβαιώσει την αίτηση πρόσβασης του.";
$pgv_lang["mail02_line04"]						= "Θα ενημερωθείτε με email όταν ο υποψήφιος χρήστης έχει επιβεβαιώσει την αίτηση του. Μετά μπορείτε να ολοκληρώσετε την διαδικασία ενεργοποιώντας το όνομα χρήστη. Ο νέος χρήστης δεν θα μπορεί να συνδεθεί μέχρι να ενεργοποιήσετε τον λογαριασμό.";
$pgv_lang["mail02_subject"]						= "Νέα καταχώρηση στο #SERVER_NAME#";
$pgv_lang["hashcode"]							= "Κώδικας επαλήθευσης:";
$pgv_lang["thankyou"]							= "Γειά σου #user_fullname# ...<br />Ευχαριστώ για την αίτηση εγγραφής";
$pgv_lang["pls_note06"]							= "Τώρα θα στείλουμε ένα email επιβεβαίωσης στην διεύθυνση <b>#user_email#</b>. Πρέπει να επαληθεύσετε την αίτηση λογαριασμού σας, ακολουθώντας τις οδηγίες στο email επαλήθευσης. Εάν δεν επιβεβαιώσετε την αίτηση λογαριασμού μέσα σε επτά ημέρες, το αίτημα σας θα απορριφθεί αυτόματα. Θα πρέπει να υποβάλετε ξανά.<br /><br />Εφόσον ακολουθήσετε τις οδηγίες στο email επιβεβαίωσης, ο διαχειριστής θα πρέπει να εγκρίνει την αίτηση σας, πριν μπορέσει να χρησιμοποιηθεί ο λογαριασμός σας.<br /><br />Για να συνδεθείτε σε αυτή την τοποθεσία θα πρέπει να γνωρίζετε το όνομα χρήστη και τον κωδικό σας.<br /><br />";
$pgv_lang["registernew"]						= "Επιβεβαίωση νέου λογαριασμού";
$pgv_lang["user_verify"]						= "Επαλήθευση χρήστη";
$pgv_lang["send"]								= "Αποστολή";
$pgv_lang["pls_note07"]							= "~#pgv_lang[user_verify]#~<br /><br />Για να επιβεβαιώσετε την αίτηση λογαριασμού που κάνατε, παρακαλώ πληκτρολογήστε το όνομα χρήστη, τον κωδικό σας και τον κωδικό επαλήθευσης που λάβατε με email.";
$pgv_lang["pls_note08"]							= "Τα δεδομένα για τον χρήστη #user_name# ελέγχθηκαν.";
$pgv_lang["mail03_line01"]						= "Γεια σου διαχειριστή ...";
$pgv_lang["mail03_line02"]						= "Ο χρήστης #newuser[username]# (#newuser[fullname]#) έχει επιβεβαιώσει την αίτηση του για λογαριασμό.";
$pgv_lang["mail03_line03"]						= "Παρακαλώ επιλέξτε τον σύνδεσμο παρακάτω για να συνδεθείτε στην τοποθεσία. Πρέπει να επεξεργαστείτε τον χρήστη και να ενεργοποιήσετε τον λογαριασμό ώστε να μπορεί να συνδεθεί στην τοποθεσία σας.";
$pgv_lang["mail03_subject"]						= "Νέος χρήστης στο #SERVER_NAME#";
$pgv_lang["pls_note09"]							= "Έχετε επιβεβαιώσει την αίτηση σας για να γίνεται ένας εγγεγραμμένος χρήστης.";
$pgv_lang["pls_note10"]							= "Ο διαχειριστής έχει ενημερωθεί. Μόλις σας δώσει άδεια να συνδεθείτε, θα μπορέσετε να συνδεθείτε με το όνομα χρήστη και τον κωδικό σας.";
$pgv_lang["data_incorrect"]						= "Τα δεδομένα δεν ήταν σωστά, παρακαλώ δοκιμάστε ξανά";
$pgv_lang["user_not_found"]						= "Δεν μπόρεσαν να επαληθευτούν οι πληροφορίες που εισάγατε. Παρακαλώ δοκιμάστε ξανά ή επικοινωνήστε με τον διαχειριστή της τοποθεσίας για περισσότερες πληροφορίες.";
$pgv_lang["lost_pw_reset"]						= "Αίτηση απολεσθέντος κωδικού";
$pgv_lang["pls_note11"]							= "Για να γίνει επαναφορά του κωδικού σας, εισάγετε το όνομα χρήστη.<br /><br />Θα αποκριθούμε στέλνοντας σας ένα email στην διεύθυνση που καταχωρήθηκε μαζί με τον λογαριασμό. Το email θα περιέχει ένα URL και κώδικα επιβεβαίωσης για τον λογαριασμό σας. Μόλις επισκεφτείτε αυτό το URL, μπορείτε να αλλάξετε τον κωδικό και να συνδεθείτε σε αυτή την τοποθεσία. Για λόγους ασφαλείας, δεν πρέπει να δώσετε αυτό τον κωδικό επιβεβαίωσης σε κανένα.<br /><br />Αν χρειάζεστε βοήθεια από τον διαχειριστή της τοποθεσίας, παρακαλώ χρησιμοποιήστε τον σύνδεσμο της επαφής παρακάτω.";
$pgv_lang["enter_email"]						= "Πρέπει να εισάγετε την διεύθυνση email.";
$pgv_lang["mail04_line01"]						= "Γεια σου #user_fullname# ...";
$pgv_lang["mail04_line02"]						= "Έχει γίνει αίτηση νέου κωδικού για το όνομα χρήστη σας.";
$pgv_lang["mail04_line03"]						= "Υπόδειξη:";
$pgv_lang["mail04_line04"]						= "Παρακαλώ επιλέξτε το σύνδεσμο παρακάτω ή επικολλήστε τον στον φυλλομετρητή σας, συνδεθείτε με τον νέο κωδικό και αλλάξτε τον άμεσα ώστε να διατηρήσετε την ακεραιότητα των δεδομένων σας με ασφάλεια.";
$pgv_lang["mail04_subject"]						= "Αίτημα δεδομένων στο #SERVER_NAME#";
$pgv_lang["pwreqinfo"]							= "Γεια σας...<br /><br />Ένα email με τον νέο σας κωδικό στάλθηκε στην διεύθυνση που έχουμε στο αρχείο στο <b>#user[email]#</b><br /><br />Παρακαλώ ελέγξτε τον λογαριασμό email σας, πρέπει να λάβετε το μήνυμα μας σύντομα.<br /><br />Υπόδειξη:<br />Πρέπει να συνδεθείτε σε αυτή την τοποθεσία με τον νέο σας κωδικό το συντομότερο δυνατό, και πρέπει να αλλάξετε τον κωδικό ώστε να διατηρήσετε την ασφάλεια των δεδομένων σας.";
$pgv_lang["editowndata"]						= "Ο λογαριασμός μου";
$pgv_lang["savedata"]							= "Save changed data";
$pgv_lang["datachanged"]						= "User data was changed!";
$pgv_lang["datachanged_name"]					= "You may need to relogin with your new username.";
$pgv_lang["myuserdata"]							= "Ο Λογαριασμός μου";
$pgv_lang["user_theme"]							= "Το θέμα εμφάνισης μου";
$pgv_lang["mgv"]								= "Η σελίδα μου";
$pgv_lang["mygedview"]							= "Ατομική πύλη";
$pgv_lang["passwordlength"]						= "Οι κωδικοί πρέπει να περιέχουν τουλάχιστον 6 χαρακτήρες.";
$pgv_lang["welcome_text_auth_mode_1"]			= "<center><b>Καλώς ήλθατε σε αυτό τον γενεαλογικό ιστοτόπο</b></center><br />Η πρόσβαση σε αυτή την τοποθεσία επιτρέπεται σε κάθε επισκέπτη που διαθέτει ένα λογαριασμό χρήστη.<br /><br />Εάν έχετε ένα λογαριασμό χρήστη, μπορείτε να συνδεθείτε σε αυτή τη σελίδα. Εάν δεν έχετε λογαριασμό χρήστη, μπορείτε να υποβάλετε αίτημα για έναν, επιλέγοντας το κατάλληλο σύνδεσμο παρακάτω.<br /><br />Μετά την επιβεβαίωση του αιτήματος σας, ο διαχειριστής της τοποθεσίας θα ενεργοποιήσει τον λογαριασμό σας. Θα λάβετε ένα email μόλις το αίτημα σας εγκριθεί.";
$pgv_lang["welcome_text_auth_mode_2"]			= "<center><b>Καλώς ήλθατε σε αυτό τον γενεαλογικό ιστοτόπο</b></center><br />Η πρόσβαση σε αυτή την τοποθεσία επιτρέπεται μόνο σε <u>εγκεκριμένους</u> χρήστες.<br /><br />Εάν έχετε ένα λογαριασμό χρήστη, μπορείτε να συνδεθείτε σε αυτή τη σελίδα. Εάν δεν έχετε λογαριασμό χρήστη, μπορείτε να υποβάλετε αίτημα για έναν, επιλέγοντας το κατάλληλο σύνδεσμο παρακάτω.<br /><br />Μετά την επιβεβαίωση του αιτήματος σας, ο διαχειριστής της τοποθεσίας είτε θα εγκρίνει τον λογαριασμό σας είτε θα απορρίψει το αίτημα σας. Θα λάβετε ένα email μόλις το αίτημα σας εγκριθεί.";
$pgv_lang["welcome_text_auth_mode_3"]			= "<center><b>Καλώς ήλθατε σε αυτό τον γενεαλογικό ιστοτόπο</b></center><br />Η πρόσβαση σε αυτή την τοποθεσία επιτρέπεται <u>μόνο σε μέλη της οικογένειας</u>.<br /><br />Εάν έχετε ένα λογαριασμό χρήστη, μπορείτε να συνδεθείτε σε αυτή τη σελίδα. Εάν δεν έχετε λογαριασμό χρήστη, μπορείτε να υποβάλετε αίτημα για έναν, επιλέγοντας το κατάλληλο σύνδεσμο παρακάτω.<br /><br />Μετά την επιβεβαίωση του αιτήματος σας, ο διαχειριστής της τοποθεσίας είτε θα εγκρίνει τον λογαριασμό σας είτε θα απορρίψει το αίτημα σας. Θα λάβετε ένα email μόλις το αίτημα σας εγκριθεί.";
$pgv_lang["welcome_text_cust_head"]				= "<center><b>Καλώς ήλθατε σε αυτό τον γενεαλογικό ιστοτόπο</b></center><br />Η πρόσβαση επιτρέπεται σε χρήστες που έχουν λογαριασμό και κωδικό για αυτή την τοποθεσία.<br />";
//-- mygedview page
$pgv_lang["welcome"]							= "Καλωσόρισες";
$pgv_lang["upcoming_events"]					= "Επερχόμενα συμβάντα";
$pgv_lang["chat"]								= "Συνομιλία";
$pgv_lang["users_logged_in"]					= "Συνδεδεμένοι χρήστες";
$pgv_lang["message"]							= "Αποστολή μηνύματος";
$pgv_lang["my_messages"]						= "Τα μηνύματά μου";
$pgv_lang["date_created"]						= "Ημερομηνία αποστολής:";
$pgv_lang["message_from"]						= "Διεύθυνση email:";
$pgv_lang["message_from_name"]					= "Το όνομα σας:";
$pgv_lang["message_to"]							= "Μήνυμα προς:";
$pgv_lang["message_subject"]					= "Θέμα:";
$pgv_lang["message_body"]						= "Σώμα:";
$pgv_lang["no_to_user"]							= "Δεν ορίσθηκε παραλήπτης. Η συνέχιση είναι αδύνατη.";
$pgv_lang["provide_email"]						= "Παρακαλώ να παρέχετε την διεύθυνση email σας ώστε να μπορούμε να έρθουμε σε επαφή μαζί σας ως απόκριση σε αυτό το μήνυμα. Εάν δεν μας παρέχετε την διεύθυνση email σας, δεν θα μπορούμε να αποκριθούμε στο αίτημα σας. Η διεύθυνση email σας δεν θα χρησιμοποιηθεί με κανένα άλλο τρόπο, εκτός από την απόκριση σε αυτό το αίτημα.";
$pgv_lang["reply"]								= "Απάντηση";
$pgv_lang["message_deleted"]					= "Το μήνυμα διαγράφηκε";
$pgv_lang["message_sent"]						= "Το μήνυμα στάλθηκε επιτυχώς στον #TO_USER#";
$pgv_lang["reset"]								= "Επαναφορά";
$pgv_lang["site_default"]						= "Προεπιλογή τοποθεσίας";
$pgv_lang["mygedview_desc"]						= "Η σελίδα Ατομική πύλη, σας επιτρέπει να κρατάτε σελιδοδείκτες των αγαπημένων σας ανθρώπων, να παρακολουθείτε επερχόμενα γεγονότα και να συνεργάζεσθε με άλλους χρήστες του PhpGedView.";
$pgv_lang["no_messages"]						= "Δεν έχετε εκκρεμή μηνύματα.";
$pgv_lang["clicking_ok"]						= "Μόλις πατήσετε το ΟΚ, θα ανοίξει ένα άλλο παράθυρο και μπορείτε να επικοινωνήσετε με τον #user[fullname]#";
$pgv_lang["my_favorites"]						= "Τα αγαπημένα μου";
$pgv_lang["no_favorites"]						= "Δεν έχετε επιλεγμένα κάποια αγαπημένα.<br /><br />Για να προσθέσετε ένα άτομο, μια οικογένεια ή μια πηγή στα αγαπημένα σας, κάντε κλικ στο σύνδεσμο <b>#pgv_lang[add_favorite]#</b> ώστε να αποκαλυφθούν κάποια πεδία όπου μπορείτε να εισάγετε ή να αναζητήσετε ένα αριθμό ID. Αντί αριθμού ID, μπορείτε να εισάγετε ένα URL και ένα τίτλο.";
$pgv_lang["add_to_my_favorites"]				= "Προσθήκη στα αγαπημένα μου";
$pgv_lang["gedcom_favorites"]					= "Αγαπημένα αυτού του GEDCOM";
$pgv_lang["no_gedcom_favorites"]				= "Αυτή τη στιγμή δεν υπάρχουν επιλεγμένα Αγαπημένα. Ο διαχειριστής μπορεί να προσθέσει Αγαπημένα ώστε να εμφανίζονται στην εκκίνηση.";
$pgv_lang["confirm_fav_remove"]					= "Είστε σίγουροι ότι θέλετε να αφαιρέσετε αυτό το αντικείμενο από τον κατάλογο των αγαπημένων σας;";
$pgv_lang["invalid_email"]						= "Παρακαλώ εισάγετε μια έγκυρη διεύθυνση email.";
$pgv_lang["enter_subject"]						= "Παρακαλώ εισάγετε ένα θέμα για το μήνυμα.";
$pgv_lang["enter_body"]							= "Παρακαλώ εισάγετε κάποιο κείμενο μηνύματος πριν την αποστολή.";
$pgv_lang["confirm_message_delete"]				= "Σίγουρα θέλετε να διαγράψετε αυτό το μήνυμα; Δεν θα μπορεί να ανακτηθεί αργότερα.";
$pgv_lang["message_email1"]						= "Το ακόλουθο μήνυμα έχει σταλθεί στον PhpGedView λογαριασμό σας από";
$pgv_lang["message_email2"]						= "Στείλατε το ακόλουθο μήνυμα σε χρήστη του PhpGedView:";
$pgv_lang["message_email3"]						= "Στείλατε το ακόλουθο μήνυμα σε διαχειριστή του PhpGedView:";
$pgv_lang["viewing_url"]						= "Το μήνυμα στάλθηκε καθώς προβαλλόταν το ακόλουθο URL: ";
$pgv_lang["messaging2_help"]					= "Όταν στείλετε αυτό το μήνυμα θα λάβετε ένα αντίγραφο μέσω email στην διεύθυνση που είχατε παρέχει.";
$pgv_lang["random_picture"]						= "Τυχαία εικόνα";
$pgv_lang["message_instructions"]				= "<b>Παρακαλώ προσέξτε:</b>  Ιδιωτικές πληροφορίες ατόμων που ζουν, θα δίνονται μόνο σε συγγενείς της οικογένειας και κοντινούς φίλους. Θα ερωτηθείτε να επαληθεύσετε την συγγένεια σας πριν λάβετε οποιαδήποτε προσωπικά δεδομένα. Μερικές φορές οι πληροφορίες νεκρών ατόμων μπορεί να είναι επίσης ιδιωτικές. Εάν αυτό συμβαίνει, είναι διότι δεν υπάρχουν αρκετές γνωστές πληροφορίες για το άτομο που να καθορίζουν εάν είναι ζωντανό ή όχι, και πιθανά δεν υπάρχουν περισσότερες πληροφορίες σε αυτό το άτομο.<br /><br />Πριν κάνετε μια ερώτηση, παρακαλώ επαληθεύστε ότι εξετάζετε το σωστό άτομο ελέγχοντας ημερομηνίες, τοποθεσίες και κοντινούς συγγενείς. Εάν υποβάλετε αλλαγές στα γενεαλογικά δεδομένα, παρακαλώ συμπεριλάβετε τις πηγές απ' όπου λάβατε τα δεδομένα.<br /><br />";
$pgv_lang["sending_to"]							= "Το μήνυμα αυτό θα σταλεί σε #TO_USER#";
$pgv_lang["preferred_lang"]						= "Αυτός ο χρήστης προτιμά να λαμβάνει μηνύματα στα #USERLANG#";
$pgv_lang["gedcom_created_using"]				= "Αυτό το GEDCOM δημιουργήθηκε αρχικά με χρήση του <b>#CREATED_SOFTWARE# #CREATED_VERSION#</b>";
$pgv_lang["gedcom_created_on"]					= "Αυτό το GEDCOM δημιουργήθηκε στις <b>#CREATED_DATE#</b>";
$pgv_lang["gedcom_created_on2"]					= " στις <b>#CREATED_DATE#</b>";
$pgv_lang["gedcom_stats"]						= "Στατιστικά GEDCOM";
$pgv_lang["stat_individuals"]					= "Άτομα";
$pgv_lang["stat_families"]						= "Οικογένειες";
$pgv_lang["stat_sources"]						= "Πηγές";
$pgv_lang["stat_other"]							= "Άλλες εγγραφές";
$pgv_lang["customize_page"]						= "Προσαρμογή ατομικής πύλης";
$pgv_lang["customize_gedcom_page"]				= "Προσαρμογή της σελίδας καλωσορίσματος αυτού του GEDCOM ";
$pgv_lang["upcoming_events_block"]				= "Επερχόμενα συμβάντα";
$pgv_lang["upcoming_events_descr"]				= "Το πλαίσιο επερχόμενων συμβάντων εμφανίζει επετείους ή συμβάντα που θα εμφανιστούν στο κοντινό μέλλον. Μπορείτε να προσαρμόσετε την ποσότητα λεπτομερειών που εμφανίζονται, και ο διαχειριστής μπορεί να προσαρμόσει αυτό το πλαίσιο πόσο μακριά στο μέλλον θα βλέπει.";
$pgv_lang["todays_events_block"]				= "Σαν σήμερα";
$pgv_lang["todays_events_descr"]				= "Το πλαίσιο Σαν σήμερα, στην ιστορία σας... εμφανίζει σημερινές επετείους συμβάντων. Μπορείτε  να προσαρμόσετε την ποσότητα λεπτομέρειας που εμφανίζεται.";
$pgv_lang["logged_in_users_block"]				= "Συνδεδεμένοι χρήστες";
$pgv_lang["logged_in_users_descr"]				= "Το πλαίσιο Συνδεδεμένοι χρήστες, εμφανίζει ένα κατάλογο των χρηστών που βρίσκονται συνδεδεμένοι τώρα.";
$pgv_lang["user_messages_block"]				= "Μηνύματα χρήστη";
$pgv_lang["user_messages_descr"]				= "Το πλαίσιο Μηνύματα χρήστη, εμφανίζει ένα κατάλογο των μηνυμάτων που έχουν σταλθεί στον ενεργό χρήστη.";
$pgv_lang["user_favorites_block"]				= "Αγαπημένα χρήστη";
$pgv_lang["user_favorites_descr"]				= "Το πλαίσιο Αγαπημένα χρήστη, εμφανίζει στον χρήστη ένα κατάλογο με τα αγαπημένα του άτομα στην βάση δεδομένων, ώστε να μπορεί να συνδέεται εύκολα σε αυτούς.";
$pgv_lang["welcome_block"]						= "Καλωσόρισμα χρήστη";
$pgv_lang["welcome_descr"]						= "Το πλαίσιο Καλωσόρισμα χρήστη, εμφανίζει στον χρήστη την τρέχουσα ημερομηνία και ώρα, γρήγορους συνδέσμους για τροποποίηση του λογαριασμού του ή πηγαίνει στον δικό του διάγραμμα προγόνων, και ένα σύνδεσμο για την προσαρμογή της ατομικής του σελίδας.";
$pgv_lang["random_media_block"]					= "Τυχαίο μέσο";
$pgv_lang["random_media_descr"]					= "Το πλαίσιο Τυχαίο μέσο, επιλέγει τυχαία μία φωτογραφία ή άλλο αντικείμενο μέσου, από την τρέχουσα ενεργή βάση δεδομένων, και την εμφανίζει στον χρήστη.<br /><br />Ο διαχειριστής καθορίζει εάν αυτό το πλαίσιο μπορεί να εμφανίζει αντικείμενα που συνδέονται με άτομα ή συμβάντα.";
$pgv_lang["gedcom_block"]						= "Καλωσόρισμα GEDCOM";
$pgv_lang["gedcom_descr"]						= "Το πλαίσιο Καλωσόρισμα GEDCOM λειτουργεί το ίδιο όπως το πλαίσιο Καλωσόρισμα χρήστη. Καλωσορίζει τον επισκέπτη στην τοποθεσία και εμφανίζει τον τίτλο της τρέχουσας ενεργής βάσης δεδομένων, όπως επίσης και την τρέχουσα ημερομηνία και ώρα.";
$pgv_lang["gedcom_favorites_block"]				= "Αγαπημένα GEDCOM";
$pgv_lang["gedcom_favorites_descr"]				= "Το πλαίσιο Αγαπημένα GEDCOM, δίνει στον διαχειριστή τη δυνατότητα να ορίσει άτομα από την βάση δεδομένων ώστε οι πληροφορίες τους να είναι εύκολα προσβάσιμες από όλους. Αυτός είναι ένας τρόπος να δώσετε έμφαση σε άτομα που είναι σημαντικά στην οικογενειακή σας ιστορία.";
$pgv_lang["gedcom_stats_block"]					= "Στατιστικά GEDCOM";
$pgv_lang["gedcom_stats_descr"]					= "Το πλαίσιο Στατιστικά GEDCOM, εμφανίζει στον επισκέπτη κάποιες βασικές πληροφορίες σχετικά με την βάση δεδομένων, όπως πότε δημιουργήθηκε και πόσα άτομα βρίσκονται μέσα σε αυτήν.<br /><br />Επίσης έχει ένα κατάλογο με τα πιο συχνά επώνυμα. Μπορείτε να ρυθμίσετε αυτό το πλαίσιο να μην εμφανίζει τον κατάλογο με τα συχνά επώνυμα, και μπορείτε επίσης να ρυθμίσετε το GEDCOM να αφαιρεί ή να προσθέτει ονόματα σε αυτό τον κατάλογο. Μπορείτε να καθορίσετε το όριο εμφάνισης για αυτό τον κατάλογο, στις ρυθμίσεις του GEDCOM.";
$pgv_lang["portal_config_intructions"]			= "~#pgv_lang[customize_page]# <br /> #pgv_lang[customize_gedcom_page]#~<br /><br />Μπορείτε να προσαρμόσετε την σελίδα τοποθετώντας τα πλαίσια στην σελίδα με τον τρόπο που τα θέλετε.<br /><br />Η σελίδα διαιρείται σε <b>Κύριο</b> και <b>Δεξί</b> τμήμα. Τα πλαίσια στο <b>Κύριο</b> τμήμα εμφανίζονται μεγαλύτερα και κάτω από τον τίτλο της σελίδας. Το <b>Δεξί</b> τμήμα αρχίζει δεξιά από τον τίτλο και πηγαίνει κάτω στην δεξιά πλευρά της σελίδας.<br /><br />Κάθε τμήμα έχει τον δικό του κατάλογο πλαισίων τα οποία αποτυπώνονται στην σελίδα με τη σειρά που βρίσκονται. Μπορείτε να προσθέσετε, αφαιρέσετε και αναταξινομήσετε τα πλαίσια με οποιοδήποτε τρόπο σας αρέσει.<br /><br />Όταν ένας από τους καταλόγους πλαισίων είναι άδειος, τα υπόλοιπα πλαίσια θα καταλάβουν όλο το πλάτος της σελίδας.<br /><br />";
$pgv_lang["login_block"]						= "Σύνδεση";
$pgv_lang["login_descr"]						= "Το πλαίσιο Σύνδεση, δέχεται όνομα χρήστη και κωδικό ώστε να συνδεθούν οι χρήστες.";
$pgv_lang["theme_select_block"]					= "Επιλογή θεματικής απεικόνισης";
$pgv_lang["theme_select_descr"]					= "Το πλαίσιο Επιλογή θεματικής απεικόνισης, εμφανίζει τον επιλογέα θεματικής απεικόνισης ακόμη και αν η δυνατότητα αλλαγής θεματικής απεικόνισης είναι απενεργοποιημένη.";
$pgv_lang["block_top10_title"]					= "Δημοφιλή επώνυμα";
$pgv_lang["block_top10"]						= "Δημοφιλή επώνυμα";
$pgv_lang["block_top10_descr"]					= "Αυτό το πλαίσιο εμφανίζει ένα πίνακα των 10 πιο συχνά εμφανιζόμενων επωνύμων στην βάση δεδομένων. Ο πραγματικός αριθμός των επωνύμων που εμφανίζονται είναι ρυθμιζόμενος. Μπορείτε να ρυθμίσετε το GEDCOM να αφαιρεί ονόματα από αυτό τον κατάλογο.";
$pgv_lang["gedcom_news_block"]					= "Νέα GEDCOM";
$pgv_lang["gedcom_news_descr"]					= "Το πλαίσιο Νέα GEDCOM, εμφανίζει στον επισκέπτη δελτία τύπου ή άρθρα που δημοσιεύονται από ένα διαχειριστή.<br /><br />Το πλαίσιο νέων είναι μια καλή τοποθεσία για την ανακοίνωση μια σημαντικής ενημέρωσης της βάσης δεδομένων, μιας οικογενειακής επανένωσης ή την γέννηση ενός παιδιού.";
$pgv_lang["user_news_block"]					= "Ημερολόγιο χρήστη";
$pgv_lang["user_news_descr"]					= "Το πλαίσιο Ημερολόγιο χρήστη, επιτρέπει στον χρήστη να κρατάει σημειώσεις ή ένα ημερολόγιο online.";
$pgv_lang["my_journal"]							= "Το ημερολόγιο μου";
$pgv_lang["no_journal"]							= "Δεν έχετε δημιουργήσει κάποια αντικείμενα ημερολογίου.";
$pgv_lang["confirm_journal_delete"]				= "Σίγουρα θέλετε να διαγράψετε αυτή την καταχώρηση ημερολογίου;";
$pgv_lang["add_journal"]						= "Προσθήκη νέας καταχώρησης ημερολογίου";
$pgv_lang["gedcom_news"]						= "Νέα";
$pgv_lang["confirm_news_delete"]				= "Σίγουρα θέλετε να διαγράψετε αυτή την καταχώρηση νέων;";
$pgv_lang["add_news"]							= "Προσθήκη άρθρου νέων";
$pgv_lang["no_news"]							= "Δεν έχουν υποβληθεί άρθρα νέων.";
$pgv_lang["edit_news"]							= "Προσθήκη/Επεξεργασία καταχώρησης Ημερολογίου/Νέων";
$pgv_lang["enter_title"]						= "Παρακαλώ εισάγετε τίτλο.";
$pgv_lang["enter_text"]							= "Παρακαλώ εισάγετε κάποιο κείμενο για αυτή την καταχώρηση νέων ή ημερολογίου.";
$pgv_lang["news_saved"]							= "Η καταχώρηση Νέων/Ημερολογίου αποθηκεύτηκε επιτυχώς.";
$pgv_lang["article_text"]						= "Κείμενο καταχώρησης:";
$pgv_lang["main_section"]						= "Πλαίσια κύριου τμήματος";
$pgv_lang["right_section"]						= "Πλαίσια δεξιού τμήματος";
$pgv_lang["move_up"]							= "Μετακίνηση επάνω";
$pgv_lang["move_down"]							= "Μετακίνηση κάτω";
$pgv_lang["move_right"]							= "Μετακίνηση δεξιά";
$pgv_lang["move_left"]							= "Μετακίνηση αριστερά";
$pgv_lang["add_main_block"]						= "Add a block to main section...";
$pgv_lang["add_right_block"]					= "Προσθήκη πλαισίου στη δεξιά περιοχή...";
$pgv_lang["broadcast_all"]						= "Εξαγγελία σε όλους τους χρήστες";
$pgv_lang["hit_count"]							= "Μέτρηση hit:";
$pgv_lang["phpgedview_message"]					= "Μήνυμα του PhpGedView";
$pgv_lang["common_surnames"]					= "Τα πιο συνηθισμένα επώνυμα";
$pgv_lang["default_news_title"]					= "Καλωσορίσατε στο γενεαλόγιο σας";
$pgv_lang["default_news_text"]					= "Οι γενεαλογικές πληροφορίες σε αυτό τον ιστοτόπο λειτουργούν με το <a href=\"http://www.phpgedview.net/\" target=\"_blank\">PhpGedView</a>.  Αυτή η σελίδα παρέχει μια εισαγωγή και επισκόπιση σε αυτό το γενεαλόγιο.<br /><br />Για να ξεκινήσετε την εργασία με τα δεδομένα, επιλέξτε ένα από τα διαγράμματα από το μενού Διαγράμματα, πηγαίνετε στον κατάλογο ατόμων ή αναζητήστε ένα όνομα ή τόπο.<br /><br />Αν έχετε δυσκολίες με την χρήση της τοποθεσίας, επιλέξτε το εικονίδιο Βοήθεια για να σας δώσει πληροφορίες του πως να χρησιμοποιήσετε την σελίδα που προβάλετε.<br /><br />Σας ευχαριστούμε που επισκεφθήκατε την τοποθεσία αυτή.";
$pgv_lang["reset_default_blocks"]				= "Επαναφορά στα προεπιλεγμένα πλαίσια";
$pgv_lang["recent_changes"]						= "Πρόσφατες αλλαγές";
$pgv_lang["recent_changes_block"]				= "Πρόσφατες αλλαγές";
$pgv_lang["recent_changes_descr"]				= "Το πλαίσιο Πρόσφατες αλλαγές, καταγράφει όλες τις αλλαγές που έχουν συμβεί στην βάση δεδομένων τον τελευταίο μήνα. Αυτό το πλαίσιο μπορεί να σας βοηθήσει να μείνετε ενήμερος με τις αλλαγές που έχουν συμβεί. Οι αλλαγές ανιχνεύονται αυτόματα, χρησιμοποιώντας την ετικέτα CHAN που έχει καθοριστεί από τις προδιαγραφές του GEDCOM.";
$pgv_lang["delete_selected_messages"]			= "Διαγραφή επιλεγμένων μηνυμάτων";
$pgv_lang["use_blocks_for_default"]				= "Να χρησιμοποιηθούν αυτά τα πλαίσια ως προεπιλεγμένη ρύθμιση πλαισίων για όλους τους χρήστες;";
//-- upgrade.php messages
$pgv_lang["upgrade_util"]						= "Upgrade Util";
$pgv_lang["no_upgrade"]							= "There are no files to upgrade.";
$pgv_lang["use_version"]						= "You are using version:";
$pgv_lang["current_version"]					= "Current stable version:";
$pgv_lang["upgrade_download"]					= "Download:";
$pgv_lang["upgrade_tar"]						= "TAR";
$pgv_lang["upgrade_zip"]						= "ZIP";
$pgv_lang["latest"]								= "You are running the latest version of PhpGedView.";
$pgv_lang["location"]							= "Location of upgrade files: ";
$pgv_lang["include"]							= "Συμπερίληψη:";
$pgv_lang["options"]							= "Επιλογές:";
$pgv_lang["inc_phpgedview"]						= " PhpGedView";
$pgv_lang["inc_config"]							= " Αρχείο Διαμόρφωσης";
$pgv_lang["inc_researchlog"]					= " Researchlog";
$pgv_lang["inc_index"]							= " Index files";
$pgv_lang["inc_themes"]							= " Themes";
$pgv_lang["inc_docs"]							= " Manuals";
$pgv_lang["inc_privacy"]						= " Privacy file(s)";
$pgv_lang["inc_backup"]							= " Create backup";
$pgv_lang["upgrade_help"]						= " Help me";
$pgv_lang["cannot_read"]						= "Cannot read file:";
$pgv_lang["not_configured"]						= "You do not have PhpGedView configured yet.";
$pgv_lang["location_upgrade"]					= "Please fill in the location of your upgrade files.";
$pgv_lang["new_variable"]						= "Found new variable: ";
$pgv_lang["config_open_error"]					= "There has been error opening the config file.";
$pgv_lang["config_update_ok"]					= "Το αρχείο ρυθμίσεων ενημερώθηκε επιτυχώς.";
$pgv_lang["config_uptodate"]					= "Your configuration file is up-to-date.";
$pgv_lang["processing"]							= "Σε επεξεργασία...";
$pgv_lang["privacy_open_error"]					= "There has been error opening the file [#PRIVACY_MODULE#].";
$pgv_lang["privacy_write_error"]				= "ERROR!!! Unable to write to the file [#PRIVACY_MODULE#].<br />Make sure write permissions are available to the file.<br />Permissions may be restored once privacy file is written.";
$pgv_lang["privacy_update_ok"]					= "Privacy file: [#PRIVACY_MODULE#] updated successfully.";
$pgv_lang["privacy_uptodate"]					= "Your [#PRIVACY_MODULE#] file is up-to-date.";
$pgv_lang["heading_privacy"]					= "Αρχεία Προστασίας Προσωπικών Δεδομένων:";
$pgv_lang["heading_phpgedview"]					= "Αρχεία Εφαρμογής PhpGedView:";
$pgv_lang["heading_image"]						= "Αρχεία Εικόνων:";
$pgv_lang["heading_index"]						= "Αρχεία ευρετηρίου:";
$pgv_lang["heading_language"]					= "Αρχεία Γλώσσας:";
$pgv_lang["heading_theme"]						= "Theme files:";
$pgv_lang["heading_docs"]						= "Εγχειρίδια:";
$pgv_lang["heading_researchlog"]				= "Research Log files:";
$pgv_lang["heading_researchloglang"]			= "Research Log language files:";
$pgv_lang["copied_success"]						= "copied successfully.";
$pgv_lang["backup_copied_success"]				= "backup file created successfully.";
$pgv_lang["process_error"]						= "There is a problem processing the page. A newer version cannot be determined.";
$pgv_lang["upgrade_completed"]					= "Upgrade Completed Successfully";
$pgv_lang["start_using_upgrad"]					= "Click here to begin using version";
//-- validate GEDCOM
$pgv_lang["changed_mac"]						= "Macintosh line endings detected. Changed lines ending with only return to end with a return and a linefeed.";
$pgv_lang["changed_places"]						= "Invalid Place encodings detected. Cleaned up place records to match proper GEDCOM 5.5 specifications.  An example from your GEDCOM is:";
$pgv_lang["optional_tools"]						= "You may also choose to run the following optional tools before importing.";
$pgv_lang["optional"]							= "Optional Tools";
$pgv_lang["date_format"]						= "Μορφή Απεικόνισης Ημερομηνίας:";
$pgv_lang["add_media_tool"]						= "Εργαλείο προσθήκης μέσων";
$pgv_lang["launch_media_tool"]					= "Click here to launch the Add Media Tool.";
$pgv_lang["add_media_descr"]					= "This tool will add media OBJE tags to the GEDCOM.  Close this window when you are finished adding media.";
$pgv_lang["extension"]							= "Extension";
$pgv_lang["order"]								= "Order";
$pgv_lang["add_media_button"]					= "Add Media";
$pgv_lang["media_table_created"]				= "Successfully updated <i>media</i> table.";
$pgv_lang["click_to_add_media"]					= "Click here to Add the Media listed above to GEDCOM #GEDCOM#";
$pgv_lang["adds_completed"]						= "Media successfully added to GEDCOM file.";
//-- hourglass chart
$pgv_lang["hourglass_chart"]					= "Διάγραμμα κλεψύδρας";
//-- report engine
$pgv_lang["choose_report"]						= "Επιλογή αναφοράς";
$pgv_lang["enter_report_values"]				= "Εισαγωγή τιμών αναφοράς";
$pgv_lang["selected_report"]					= "Επιλεγμένη αναφορά";
$pgv_lang["run_report"]							= "Εμφάνιση Αναφοράς";
$pgv_lang["select_report"]						= "Επιλογή αναφοράς";
$pgv_lang["download_report"]					= "Λήψη αναφοράς";
$pgv_lang["reports"]							= "Αναφορές";
$pgv_lang["pdf_reports"]						= "Αναφορές PDF";
$pgv_lang["html_reports"]						= "Αναφορές HTML";
$pgv_lang["family_group_report"]				= "Αναφορά οικογενειακής ομάδας";
$pgv_lang["page"]								= "Σελίδα";
$pgv_lang["of"]									= "από";
$pgv_lang["enter_famid"]						= "Εισαγωγή ID οικογένειας";
$pgv_lang["show_sources"]						= "Εμφάνιση πηγών;";
$pgv_lang["show_notes"]							= "Εμφάνιση σημειώσεων;";
$pgv_lang["show_basic"]							= "Εκτύπωση βασικών συμβάντων όταν είναι κενό;";
$pgv_lang["show_photos"]						= "Εμφάνιση φωτογραφιών;";
$pgv_lang["individual_report"]					= "Αναφορά ατόμου";
$pgv_lang["enter_pid"]							= "Εισαγωγή ID ατόμου";
$pgv_lang["individual_list_report"]				= "Individual List Report";
$pgv_lang["generated_by"]						= "Δημιουργήθηκε από";
$pgv_lang["list_children"]						= "Καταγραφή κάθε παιδιού κατά σειρά γέννησης.";
$pgv_lang["birth_report"]						= "Αναφορά ημερομηνίας και τόπου γέννησης";
$pgv_lang["birthplace"]							= "Η γενέτειρα περιέχει";
$pgv_lang["birthdate1"]							= "Αρχή εύρους ημερομηνιών γέννησης";
$pgv_lang["birthdate2"]							= "Τέλος εύρους ημερομηνιών γέννησης";
$pgv_lang["sort_by"]							= "Ταξινόμιση ως προς";
$pgv_lang["cleanup"]							= "Καθαρισμός";
//-- CONFIGURE (extra) messgaes for programs patriarch, slklist and statistics
$pgv_lang["dynasty_list"]						= "Ανασκόπιση Οικογενειών";
$pgv_lang["make_slklist"]						= "Create EXCEL (SLK) list";
$pgv_lang["excel_list"]							= "Output in EXCEL (slk) format on the following files (first use patriarchlist):";
$pgv_lang["excel_tab"]							= "tabblad:";
$pgv_lang["excel_create"]						= " will be created on file:";
$pgv_lang["patriarch_list"]						= "Patriarch list";
$pgv_lang["slk_list"]							= "EXCEL SLK list";
$pgv_lang["statistics"]							= "Στατιστικά";
//-- Merge Records
$pgv_lang["merge_same"]							= "Οι εγγραφές δεν είναι του ίδιου τύπου. Δεν μπορούν να συγχωνευτούν εγγραφές που δεν είναι του ίδιου τύπου.";
$pgv_lang["merge_step1"]						= "Συγχώνευση βήμα 1 από 3";
$pgv_lang["merge_step2"]						= "Συγχώνευση βήμα 2 από 3";
$pgv_lang["merge_step3"]						= "Συγχώνευση βήμα 3 από 3";
$pgv_lang["select_gedcom_records"]				= "Επιλέξτε δύο εγγραφές GEDCOM για συγχώνευση. Οι εγγραφές πρέπει να είναι του ίδιου τύπου.";
$pgv_lang["merge_to"]							= "Συγχώνευση στο ID:";
$pgv_lang["merge_from"]							= "Συγχώνευση από το ID:";
$pgv_lang["merge_facts_same"]					= "Τα παρακάτω γεγονότα ήταν ακριβώς τα ίδια και στις δύο εγγραφές και θα συγχωνευτούν αυτόματα.";
$pgv_lang["no_matches_found"]					= "Δεν βρέθηκαν γεγονότα που να ταιριάζουν";
$pgv_lang["unmatching_facts"]					= "Τα παρακάτω γεγονότα δεν ταιριάζουν. Επιλέξτε τις πληροφορίες που θέλετε να κρατήσετε.";
$pgv_lang["record"]								= "Εγγραφή";
$pgv_lang["adding"]								= "Προσθήκη";
$pgv_lang["updating_linked"]					= "Ενημέρωση συνδεδεμένης εγγραφής";
$pgv_lang["merge_more"]							= "Συγχώνευση περισσότερων εγγραφών.";
$pgv_lang["same_ids"]							= "Εισάγατε τα ίδια ID. Δεν μπορείτε να συγχωνεύσετε τις ίδιες εγγραφές.";
//-- ANCESTRY FILE MESSAGES
$pgv_lang["ancestry_chart"]						= "Διάγραμμα προγόνων";
$pgv_lang["gen_ancestry_chart"]					= "Διάγραμμα προγόνων #PEDIGREE_GENERATIONS# γενεών";
$pgv_lang["chart_style"]						= "Στυλ διαγράμματος";
$pgv_lang["ancestry_list"]						= "Κατάλογος Προγόνων";
$pgv_lang["ancestry_booklet"]					= "Βιβλίο Προγόνων";
// 1st generation
$pgv_lang["sosa_2"]								= "Πατέρας";
$pgv_lang["sosa_3"]								= "Μητέρα";
// 2nd generation
$pgv_lang["sosa_4"]								= "Παππούς";
$pgv_lang["sosa_5"]								= "Γιαγιά";
$pgv_lang["sosa_6"]								= "Παππούς";
$pgv_lang["sosa_7"]								= "Γιαγιά";
// 3rd generation
$pgv_lang["sosa_8"]								= "Προπαππούς";
$pgv_lang["sosa_9"]								= "Προγιαγιά";
$pgv_lang["sosa_10"]							= "Προπαππούς";
$pgv_lang["sosa_11"]							= "Προγιαγιά";
$pgv_lang["sosa_12"]							= "Προπαππούς";
$pgv_lang["sosa_13"]							= "Προγιαγιά";
$pgv_lang["sosa_14"]							= "Προπαππούς";
$pgv_lang["sosa_15"]							= "Προγιαγιά";
// 4th generation
$pgv_lang["sosa_16"]							= "Προ-προπαππούς";
$pgv_lang["sosa_17"]							= "Προ-προγιαγιά";
$pgv_lang["sosa_18"]							= "Προ-προπαππούς";
$pgv_lang["sosa_19"]							= "Προ-προγιαγιά";
$pgv_lang["sosa_20"]							= "Προ-προπαππούς";
$pgv_lang["sosa_21"]							= "Προ-προγιαγιά";
$pgv_lang["sosa_22"]							= "Προ-προπαππούς";
$pgv_lang["sosa_23"]							= "Προ-προγιαγιά";
$pgv_lang["sosa_24"]							= "Προ-προπαππούς";
$pgv_lang["sosa_25"]							= "Προ-προγιαγιά";
$pgv_lang["sosa_26"]							= "Προ-προπαππούς";
$pgv_lang["sosa_27"]							= "Προ-προγιαγιά";
$pgv_lang["sosa_28"]							= "Προ-προπαππούς";
$pgv_lang["sosa_29"]							= "Προ-προγιαγιά";
$pgv_lang["sosa_30"]							= "Προ-προπαππούς";
$pgv_lang["sosa_31"]							= "Προ-προγιαγιά";
// 5th generation
$pgv_lang["sosa_32"]							= "Προ-Προ-Προ-Πάππους";
$pgv_lang["sosa_33"]							= "Προ-Προ-Προ-Γιαγιά";
$pgv_lang["sosa_34"]							= "Προ-Προ-Προ-Πάππους";
$pgv_lang["sosa_35"]							= "Προ-Προ-Προ-Γιαγιά";
$pgv_lang["sosa_36"]							= "Προ-Προ-Προ-Πάππους";
$pgv_lang["sosa_37"]							= "Προ-Προ-Προ-Γιαγιά";
$pgv_lang["sosa_38"]							= "Προ-Προ-Προ-Πάππους";
$pgv_lang["sosa_39"]							= "Προ-Προ-Προ-Γιαγιά";
$pgv_lang["sosa_40"]							= "Προ-Προ-Προ-Πάππους";
$pgv_lang["sosa_41"]							= "Προ-Προ-Προ-Γιαγιά";
$pgv_lang["sosa_42"]							= "Προ-Προ-Προ-Πάππους";
$pgv_lang["sosa_43"]							= "Προ-Προ-Προ-Γιαγιά";
$pgv_lang["sosa_44"]							= "Προ-Προ-Προ-Πάππους";
$pgv_lang["sosa_45"]							= "Προ-Προ-Προ-Γιαγιά";
$pgv_lang["sosa_46"]							= "Προ-Προ-Προ-Πάππους";
$pgv_lang["sosa_47"]							= "Προ-Προ-Προ-Γιαγιά";
$pgv_lang["sosa_48"]							= "Προ-Προ-Προ-Πάππους";
$pgv_lang["sosa_49"]							= "Προ-Προ-Προ-Γιαγιά";
$pgv_lang["sosa_50"]							= "Προ-Προ-Προ-Πάππους";
$pgv_lang["sosa_51"]							= "Προ-Προ-Προ-Γιαγιά";
$pgv_lang["sosa_52"]							= "Προ-Προ-Προ-Πάππους";
$pgv_lang["sosa_53"]							= "Προ-Προ-Προ-Γιαγιά";
$pgv_lang["sosa_54"]							= "Προ-Προ-Προ-Πάππους";
$pgv_lang["sosa_55"]							= "Προ-Προ-Προ-Γιαγιά";
$pgv_lang["sosa_56"]							= "Προ-Προ-Προ-Πάππους";
$pgv_lang["sosa_57"]							= "Προ-Προ-Προ-Γιαγιά";
$pgv_lang["sosa_58"]							= "Προ-Προ-Προ-Πάππους";
$pgv_lang["sosa_59"]							= "Προ-Προ-Προ-Γιαγιά";
$pgv_lang["sosa_60"]							= "Προ-Προ-Προ-Πάππους";
$pgv_lang["sosa_61"]							= "Προ-Προ-Προ-Γιαγιά";
$pgv_lang["sosa_62"]							= "Προ-Προ-Προ-Πάππους";
$pgv_lang["sosa_63"]							= "Προ-Προ-Προ-Γιαγιά";
//-- FAN CHART
$pgv_lang["fan_chart"]							= "Διάγραμμα βεντάλιας";
$pgv_lang["gen_fan_chart"]						= "Διάγραμμα βεντάλια #PEDIGREE_GENERATIONS# γενεών";
$pgv_lang["fan_width"]							= "Πλάτος";
$pgv_lang["gd_library"]							= "Εσφαλμένη ρύθμιση του PHP server: απαιτείται η βιβλιοθήκη GD 2.x για χρήση λειτουργιών εικόνας.";
$pgv_lang["gd_freetype"]						= "Εσφαλμένη ρύθμιση του PHP server: απαιτείται η βιβλιοθήκη Freetype για χρήση γραμματοσειρών TrueType.";
$pgv_lang["gd_helplink"]						= "http://www.php.net/gd";
$pgv_lang["fontfile_error"]						= "Το αρχείο γραμματοσειράς δεν βρέθηκε στον PHP server";
//-- RSS Feed
$pgv_lang["rss_descr"]							= "Νέα και σύνδεσμοι από την τοποθεσία #GEDCOM_TITLE#";
$pgv_lang["rss_logo_descr"]						= "Η τροφοδοσία δημιουργήθηκε από το PhpGedView";
$pgv_lang["begins_with"]		= "Ξεκινάει με";
$pgv_lang["exact"]				= "Ακριβής";
$pgv_lang["sortby"]				= "Ταξινόμηση";
$pgv_lang["contains"]			= "Περιέχει";
$pgv_lang["sounds_like"]		= "Ακούγεται σαν";
$pgv_lang["advanced_search"] 	= "Προχωρημένη αναζήτηση";
$pgv_lang["advanced_search"] 	= "Προχωρημένη αναζήτηση";
$pgv_lang["more_fields"]		= "Προσθήκη περισσότερων πεδίων";
$pgv_lang["more_fields"]		= "Προσθήκη περισσότερων πεδίων";
$pgv_lang["install_step_8"] 		= "Ξεκινήστε";
$pgv_lang["immediate_family"]		= "Άμεση οικογένεια";
$pgv_lang["immediate_family"]		= "Άμεση οικογένεια";
$pgv_lang["parent_family"]			= "Οικογένεια γονέων";
$pgv_lang["parent_family"]			= "Οικογένεια γονέων";
$pgv_lang["step_parent_family"]		= "Οικογένεια θετού γονέα";
$pgv_lang["step_parent_family"]		= "Οικογένεια θετού γονέα";
$pgv_lang["load_full_tree"]			= "Προβολή αυτού του δέντρου ως διαδραστικό, σε πλήρη σελίδα";
$pgv_lang["load_full_tree"]			= "Δείτε αυτό το δέντρο, στο διαδραστικό δέντρο πλήρους σελίδας";
$pgv_lang["hide_show_spouses"]		= "Εμφάνιση ή απόκρυψη πολλαπλών συζύγων";
$pgv_lang["interactive_tree"]		= "Διαδραστικό δέντρο";
$pgv_lang["interactive_tree"]		= "Διαδραστικό δέντρο";
$pgv_lang["example"]				= "Παράδειγμα:";
$pgv_lang["tree"]					= "Δέντρο";
$pgv_lang["showUnknown"]			= "Εμφάνιση αγνώστου φύλου";
$pgv_lang["showUnknown"]			= "Εμφάνιση άγνωστου φύλου";
$pgv_lang["count"]					= "Αρίθμηση";
$pgv_lang["count"]					= "Μέτρηση";
$pgv_lang["age_differences"]		= "Εμφάνιση διαφοράς ημερομηνιών";
$pgv_lang["age_differences"]		= "Εμφάνιση διαφορών ημερομηνίας";
$pgv_lang["multi_site_search"] 		= "Multi Site Αναζήτηση";
$pgv_lang["multi_site_search"] 		= "Αναζήτηση σε πολλαπλούς τόπους";
$pgv_lang["switch_lifespan"]		= "Εμφάνιση διάγραμματος διάρκειας ζωής";
$pgv_lang["differences"]			= "Διαφορές";
$pgv_lang["switch_timeline"]		= "Εμφάνιση χρονοδιαγράμματος";
$pgv_lang["charts_block"]			= "Πλαίσιο διαγραμμάτων";
$pgv_lang["charts_block_descr"]		= "Το πλαίσιο διαγραμμάτων σας επιτρέπει να τοποθετήσετε ένα διάγραμμα στη σελίδα καλωσορίσματος ή στην ατομική σας σελίδα. Μπορείτε να ρυθμίσετε το πλαίσιο να εμφανίζεται σε προβολή προγόνων, απογόνων ή κλεψύδρας. Μπορείτε επίσης να επιλέξετε το ριζικό άτομο του διαγράμματος.";
$pgv_lang["charts_block"]			= "Πλαίσιο διαγραμμάτων";
$pgv_lang["charts_click_box"]		= "Κάντε κλικ σε οποιοδήποτε από τα κουτιά για να πάρετε πληροφορίες σχετικά με εκείνο το άτομο.";
$pgv_lang["chart_type"]				= "Τύπος διαγράμματος";
$pgv_lang["changedate1"]			= "Τέλος ορίου των αλλαγών ημερομηνίας";
$pgv_lang["changedate2"]			= "Αρχή ορίου των αλλαγών ημερομηνίας";
$pgv_lang["search_place_word"]		= "Ολόκληρες λέξεις μόνο";
$pgv_lang["genealogy"]				= "γενεαλόγιο";
$pgv_lang["cache_life"]				= "Διάρκεια ζωής αρχείου cache";
$pgv_lang["activate"]				= "Ενεργοποίηση";
$pgv_lang["deactivate"]				= "Απενεργοποίηση";
$pgv_lang["play"]					= "Αναπαραγωγή";
$pgv_lang["stop"]					= "Διακοπή";
$pgv_lang["random_media_start_slide"]	= "Εκκίνηση ολισθαίνουσας προβολής στην φόρτωση της σελίδας;";
$pgv_lang["random_media_ajax_controls"]	= "Εμφάνιση στοιχείων ελέγχου της ολισθαίνουσας προβολής;";
$pgv_lang["description"]			= "Περιγραφή";
$pgv_lang["current_dir"]			= "Τρέχον κατάλογος";
$pgv_lang["view_img_details"]		= "Προβολή λεπτομερειών εικόνας";
$pgv_lang["server_folder"]			= "Όνομα φακέλου στον εξυπηρετητή";
$pgv_lang["medialist_recursive"]	= "Λίστα αρχείων υποκαταλόγων";
$pgv_lang["media_options"]			= "Επιλογές μέσων";
$pgv_lang["names"]					= "Ονόματα";
$pgv_lang["shared_note_menu"]		= "Επιλογές για κοινόχρηστη σημείωση";
$pgv_lang["source_menu"]			= "Επιλογές για πηγή";
$pgv_lang["repo_menu"]				= "Επιλογές για χώρο φύλαξης";
$pgv_lang["other_repo_records"]		= "Εγγραφές που συνδέονται σε αυτό τον Χώρο φύλαξης:";
$pgv_lang["repo_info"]				= "Πληροφορίες χώρου φύλαξης";
$pgv_lang["search_asso_label"]		= "Σχετιζόμενοι";
$pgv_lang["search_asso_text"]		= "Εμφάνιση ατόμων/οικογενειών που σχετίζονται";
$pgv_lang["search_asso_text"]		= "Εμφάνιση συγγενικών ατόμων/οικογενειών";
$pgv_lang["search_fams"]			= "Οικογένειες";
$pgv_lang["search_geds"]			= "Βάσεις δεδομένων για αναζήτηση";
$pgv_lang["search_indis"]			= "Άτομα";
$pgv_lang["search_inrecs"]			= "Αναζήτηση για";
$pgv_lang["search_prtall"]			= "Όλα τα ονόματα";
$pgv_lang["search_prthit"]			= "Ονόματα με ταίριαγμα";
$pgv_lang["results_per_page"]		= "Αποτελέσματα ανά σελίδα";
$pgv_lang["search_prtnames"]		= "Ατομικά όνοματα<br />για εκτύπωση:";
$pgv_lang["search_prtnames"]		= "Ονόματα ατόμου<br />για εκτύπωση:";
$pgv_lang["other_searches"]			= "Άλλες αναζητήσεις";
$pgv_lang["manage_media"]			= "Διαχείριση πολυμέσων";
$pgv_lang["search_general"]			= "Γενική αναζήτηση";
$pgv_lang["clipping_privacy"]		= "Μερικά αντικείμενα δεν μπορούν να προστεθούν λόγω περιορισμών ιδιωτικότητας";
$pgv_lang["chart_new"]				= "Διάγραμμα οικογενειακού δέντρου";
$pgv_lang["loading"]				= "Φόρτωση...";
$pgv_lang["clear_chart"]			= "Καθαρισμός διαγράμματος";
$pgv_lang["file_information"]		= "Πληροφορίες αρχείου";
$pgv_lang["choose_file_type"]		= "Επιλογή τύπου αρχείου";
$pgv_lang["add_individual_by_id"]	= "Προσθήκη ατόμου με ID";
$pgv_lang["advanced_options"]		= "Προχωρημένες επιλογές";
$pgv_lang["zip_files"]				= "Αρχείο(α) zip";
$pgv_lang["include_media"]			= "Συμπερίληψη μέσων (αυτόματα αρχεία zip)";
$pgv_lang["roman_surn"]				= "Εκλατινισμένο επώνυμο";
$pgv_lang["roman_givn"]				= "Εκλατινισμένο δοσμένο όνομα";
$pgv_lang["page_x_of_y"]			= "Σελίδα #GLOBALS[currentPage]# από #GLOBALS[lastPage]#";
$pgv_lang["page_size"]				= "Μέγεθος σελίδας";
$pgv_lang["record_not_found"]		= "Η ζητούμενη εγγραφή GEDCOM  δεν μπόρεσε να βρεθεί. Αυτό μπορεί να προκλήθηκε από μια σύνδεση σε μη έγκυρο άτομο ή σε κατεστραμένο αρχείο GEDCOM.";
$pgv_lang["result_page"]			= "Σελίδα αποτελέσματος";
$pgv_lang["edit_media"]				= "Επεξεργασία αντικειμένου μέσου";
$pgv_lang["wiki_main_page"]			= "Κύρια σελίδα wiki";
$pgv_lang["wiki_users_guide"]		= "Οδηγός χρήστη του wiki";
$pgv_lang["wiki_admin_guide"]		= "Οδηγός διαχειριστών του wiki";
$pgv_lang["no_search_for"]			= "Σιγουρευτείτε ότι επιλέξατε μια επιλογή για αναζήτηση.";
$pgv_lang["no_search_site"]			= "Σιγουρευτείτε ότι επιλέξατε τουλάχιστον μία απομακρυσμένη τοποθεσία.";
$pgv_lang["search_sites"] 			= "Τοποθεσίες για αναζήτηση";
$pgv_lang["site_list"]				= "Τοποθεσία:";
$pgv_lang["site_had"]				= "περιείχε τα ακόλουθα";
$pgv_lang["label_search_engine_detected"]  = "Αναγνωρίστηκε αράχνη μηχανής αναζήτησης";
$pgv_lang["ex-spouse"] = "Πρώην σύζυγος";
$pgv_lang["ex-wife"] = "Πρώην γυναίκα";
$pgv_lang["ex-husband"] = "Πρώην άντρας";
$pgv_lang["noemail"] 				= "Διευθύνσεις χωρίς emails";
$pgv_lang["onlyemail"] 				= "Μόνο διευθύνσεις με emails";
$pgv_lang["maxviews_exceeded"]		= "Ο επιτρεπόμενος ρυθμός προβολής σελίδων των #GLOBALS[MAX_VIEWS]# ανά #GLOBALS[MAX_VIEW_TIME]# δευτερόλεπτα ξεπεράστηκε.";
$pgv_lang["broadcast_not_logged_6mo"]	= "Αποστολή μηνύματος σε χρήστες που δεν συνδέθηκαν για 6 μήνες";
$pgv_lang["broadcast_never_logged_in"]	= "Αποστολή μηνύματος σε χρήστες που δεν συνδέθηκαν ποτέ";
$pgv_lang["stats_to_show"]			= "Επιλογή στατιστικών για εμφάνιση σε αυτό το πλαίσιο";
$pgv_lang["stat_avg_age_at_death"]	= "Μέσος όρος ηλικίας θανάτου";
$pgv_lang["stat_longest_life"]		= "Μακροβιότερο άτομο";
$pgv_lang["stat_most_children"]		= "Οικογένεια με τα περισσότερα παιδιά";
$pgv_lang["stat_average_children"]	= "Μέσος όρος παιδιών ανά οικογένεια";
$pgv_lang["stat_events"]			= "Σύνολο γεγονότων";
$pgv_lang["stat_media"]				= "Αντικείμενα μέσων";
$pgv_lang["stat_surnames"]			= "Σύνολο επωνύμων";
$pgv_lang["stat_users"]				= "Σύνολο χρηστών";
$pgv_lang["no_family_facts"]		= "Δεν υπάρχουν γεγονότα για αυτή την οικογένεια";
$pgv_lang["stat_males"]				= "αρσενικά";
$pgv_lang["stat_females"]			= "θηλυκά";
$pgv_lang["stat_males"]				= "αρσενικά";
$pgv_lang["stat_females"]			= "θηλυκά";
$pgv_lang["stat_unknown"]			= "άγνωστο";
$pgv_lang["sunday_1st"]				= "Κ";
$pgv_lang["monday_1st"]				= "Δ";
$pgv_lang["tuesday_1st"]			= "Τρ";
$pgv_lang["wednesday_1st"]			= "Τε";
$pgv_lang["thursday_1st"]			= "Πε";
$pgv_lang["friday_1st"]				= "Πα";
$pgv_lang["saturday_1st"]			= "Σ";
$pgv_lang["jan_1st"]				= "Ιαν";
$pgv_lang["feb_1st"]				= "Φεβ";
$pgv_lang["mar_1st"]				= "Μαρ";
$pgv_lang["apr_1st"]				= "Απρ";
$pgv_lang["may_1st"]				= "Μάιος";
$pgv_lang["jun_1st"]				= "Ιουν";
$pgv_lang["jul_1st"]				= "Ιουλ";
$pgv_lang["aug_1st"]				= "Αυγ";
$pgv_lang["sep_1st"]				= "Σεπ";
$pgv_lang["oct_1st"]				= "Οκτ";
$pgv_lang["nov_1st"]				= "Νοεμ";
$pgv_lang["dec_1st"]				= "Δεκ";
$pgv_lang["edit_source"]			= "Επεξεργασία πηγής";
$pgv_lang["edit_shared_note"]		= "Επεξεργασία κοινόχρηστης σημείωσης";
$pgv_lang["familybook_chart"]		= "Διάγραμμα οικογενειακού βιβλίου";
$pgv_lang["family_of"]				= "Οικογένεια του:&nbsp;";
$pgv_lang["descent_steps"]			= "Βήματα προγόνων";
$pgv_lang["cookie_help"]			= "Η τοποθεσία αυτή χρησιμοποιεί cookies για να κρατάει τα ίχνη από την κατάσταση σύνδεσης σας.<br /><br />Τα cookies δεν φαίνεται να είναι ενεργοποιημένα στον φυλλομετρητή σας. Πρέπει να ενεργοποιήσετε τα cookies για αυτή την τοποθεσία πριν μπορέσετε να συνδεθείτε. Μπορείτε να συμβουλευτείτε την βοήθεια του φυλλομετρητή σας για πληροφορίες του πως να ενεργοποιήσετε τα cookies.";
$pgv_lang["indi_is_remote"]			= "Οι πληροφορίες για αυτό το άτομο διασυνδέθηκαν από μία απομακρυσμένη τοποθεσία.";
$pgv_lang["link_remote"]            = "Διασύνδεση απομακρυσμένου ατόμου";
$pgv_lang["title_search_link"]      = "Προσθήκη τοπικής σύνδεσης";
$pgv_lang["label_site_url2"]        = "URL τοποθεσίας";
$pgv_lang["delete_family_confirm"]	= "Διαγράφοντας την οικογένεια θα αποσυνδεθούν όλα τα άτομα από κάθε άλλο, αλλά θα μείνουν τα άτομα στη θέση τους. Είστε σίγουροι ότι θέλετε να διαγράψετε αυτή την οικογένεια;";
$pgv_lang["delete_family"]			= "Διαγραφή οικογένειας";
$pgv_lang["add_favorite"]			= "Προσθήκη νέου αγαπημένου";
$pgv_lang["url"]					= "URL";
$pgv_lang["add_fav_enter_note"]		= "Εισαγωγή προαιρετικής σημείωσης σχετικά με αυτό το αγαπημένο";
$pgv_lang["add_fav_or_enter_url"]	= "Ή<br />\nΕισαγωγή URL και τίτλου";
$pgv_lang["add_fav_enter_id"]		= "Εισαγωγή ατόμου, οικογένειας ή ID πηγής";
$pgv_lang["next_email_sent"]		= "Το επόμενο email υπενθύμισης θα σταλεί μετά";
$pgv_lang["last_email_sent"]		= "Το τελευταίο email υπενθύμισης στάλθηκε";
$pgv_lang["remove_child"]			= "Αφαίρεση αυτού του παιδιού από την οικογένεια";
$pgv_lang["link_new_husb"]			= "Προσθήκη συζύγου (άντρα) χρησιμοποιόντας υπάρχον άτομο";
$pgv_lang["address_labels"]			= "Ετικέτες διευθύνσεων";
$pgv_lang["filter_address"]			= "Εμφάνιση διευθύνσεων που περιέχουν:";
$pgv_lang["address_list"]			= "Κατάλογος διευθύνσεων";
$pgv_lang["autocomplete"]			= "Αυτόματη συμπλήρωση";
$pgv_lang["index_edit_advice"]		= "Επιλέξτε ένα πλαίσιο ονόματος και μετά κάντε κλικ σε ένα από τα εικονίδια με τα βέλη για να μετακινήσετε το επιλεγμένο πλαίσιο στην ενδεικνυόμενη κατεύθυνση.";
$pgv_lang["changelog"]				= "Αλλαγές έκδοσης #VERSION#";
$pgv_lang["html_block_descr"]		= "Αυτό είναι ένα απλό πλαίσιο HTML που μπορείτε να το τοποθετήσετε στην σελίδα σας για να προσθέσετε οποιοδήποτε είδος μηνύματος θέλετε.";
$pgv_lang["html_block_sample_part1"]	= "<p class=\"blockhc\"><b>Βάλτε τον τίτλο σας εδώ</b></p><br /><p>Κάντε κλικ στο κουμπί ρύθμιση";
$pgv_lang["html_block_sample_part2"]	= "για να αλλάξει ότι εκτυπώθηκε εδώ.</p>";
$pgv_lang["html_block_name"]		= "HTML";
$pgv_lang["htmlplus_block_name"]	= "Προχωρημένη HTML";
$pgv_lang["htmlplus_block_descr"]	= "Αυτό είναι ένα πλαίσιο HTML που μπορείτε να τοποθετήσετε στην σελίδα σας για να προσθέσετε οποιοδήποτε είδος μηνύματος θέλετε. Μπορείτε να εισάγετε αναφορές πληροφοριών από το GEDCOM στο κείμενο HTML.";
$pgv_lang["htmlplus_block_templates"] = "Πρότυπα";
$pgv_lang["htmlplus_block_content"] = "Περιεχόμενο";
$pgv_lang["htmlplus_block_narrative"] = "Αφηγηματικό στυλ (μόνο Αγγλικά)";
$pgv_lang["htmlplus_block_custom"]	= "Προσαρμογή";
$pgv_lang["htmlplus_block_keyword"]	= "Παραδείγματα λέξεων-κλειδιών (μόνο Αγγλικά)";
$pgv_lang["htmlplus_block_taglist"]	= "Λίστα ετικετών";
$pgv_lang["htmlplus_block_compat"]	= "Κατάσταση συμβατότητας";
$pgv_lang["htmlplus_block_ui"]		= "Εκτεταμένη διεπαφή";
$pgv_lang["htmlplus_block_current"]	= "Τρέχον";
$pgv_lang["htmlplus_block_default"]	= "Προεπιλογή";
$pgv_lang["htmlplus_block_gedcom"]	= "Οικογενειακό δέντρο";
$pgv_lang["htmlplus_block_birth"]	= "γέννηση";
$pgv_lang["htmlplus_block_death"]	= "θάνατος";
$pgv_lang["htmlplus_block_marrage"]	= "γάμος";
$pgv_lang["htmlplus_block_adoption"]= "υιοθεσία";
$pgv_lang["htmlplus_block_burial"]	= "ταφή";
$pgv_lang["htmlplus_block_census"]	= "απογραφή προστέθηκε";
$pgv_lang["num_to_show"]			= "Αριθμός αντικειμένων για εμφάνιση";
$pgv_lang["days_to_show"]			= "Αριθμός ημερών για εμφάνιση";
$pgv_lang["before_or_after"]		= "Τοποθέτηση μετρήσεων πριν ή μετά το όνομα;";
$pgv_lang["before"]					= "πριν";
$pgv_lang["after"]					= "μετά";
$pgv_lang["config_block"]			= "Ρύθμιση";
$pgv_lang["enter_comments"]			= "Παρακαλώ εισάγετε την συγγένεια σας, στα δεδομένα του πεδίου Σχόλια.";
$pgv_lang["comments"]				= "Σχόλια";
$pgv_lang["child-family"]			= "Γονείς και αδέρφια";
$pgv_lang["spouse-family"]			= "Σύζυγος και παιδιά";
$pgv_lang["direct-ancestors"]		= "Απευθείας γραμμής πρόγονοι";
$pgv_lang["ancestors"]				= "Απευθείας γραμμής πρόγονοι και οι οικογένειες τους";
$pgv_lang["descendants"]			= "Απόγονοι";
$pgv_lang["choose_relatives"]		= "Επιλογή συγγενών";
$pgv_lang["relatives_report"]		= "Αναφορά συγγενών";
$pgv_lang["total_unknown"]			= "άγνωστο";
$pgv_lang["total_living"]			= "ζωντανοί";
$pgv_lang["total_dead"]				= "νεκροί";
$pgv_lang["total_not_born"]			= "θνησιγενή";
$pgv_lang["remove_custom_tags"]		= "Απομάκρυνση προσαρμοσμένων PGV ετικετών; (πχ. _PGVU, _THUM)";
$pgv_lang["cookie_login_help"]		= "Η τοποθεσία σας θυμήθηκε από προηγούμενη σύνδεση. Αυτό σας επιτρέπει να έχετε πρόσβαση σε ιδιωτικές πληροφορίες και άλλα χαρακτηριστικά βασισμένα στον χρήστη, αλλά προκειμένου να επεξεργαστείτε ή διαχειριστείτε την τοποθεσία, πρέπει να συνδεθείτε ξανά για αυξημένη ασφάλεια. ";
$pgv_lang["remember_me"]			= "Να με θυμάσαι από αυτό τον υπολογιστή;";
$pgv_lang["fams_with_surname"]		= "Οικογένειας με επώνυμο #surname#";
$pgv_lang["fams_with_surname"]		= "Οικογένειες με επώνυμο #surname#";
$pgv_lang["support_contact"]		= "Επαφή τεχνικής βοήθειας";
$pgv_lang["genealogy_contact"]		= "Επαφή γενεαλογίου";
$pgv_lang["common_upload_errors"]	= "Αυτό το σφάλμα πιθανά σημαίνει ότι το αρχείο που προσπαθήσατε να ανεβάσετε ξεπέρασε το όριο που καθορίστηκε από τον οικοδεσπότη. Το προκαθορισμένο όριο στην PHP είναι 2MB. Μπορείτε να επικοινωνήσετε με την ομάδα υποστήριξης του οικοδεσπότη για να αυξήσουν το όριο στο αρχείο php.ini, ή μπορείτε να ανεβάσετε το αρχείο χρησιμοποιόντας FTP. Χρησιμοποιήστε τη σελίδα <a href=\"uploadgedcom.php?action=add_form\"><b>Προσθήκη GEDCOM</b></a> για να προσθέσετε ένα αρχείο GEDCOM που έχετε ανεβάσει χρησιμοποιόντας FTP.";
$pgv_lang["total_memory_usage"]		= "Σύνολο χρήσης μνήμης:";
$pgv_lang["mothers_family_with"]	= "Οικογένεια μητέρας με";
$pgv_lang["fathers_family_with"]	= "Οικογένεια πατέρα με";
$pgv_lang["halfsibling"]			= "Ετεροθαλές αδέρφι";
$pgv_lang["halfbrother"]			= "Ετεροθαλής αδερφός";
$pgv_lang["halfsister"]				= "Ετεροθαλής αδερφή";
$pgv_lang["family_timeline"]		= "Εμφάνιση οικογένειας στο χρονοδιάγραμμα";
$pgv_lang["children_timeline"]		= "Εμφάνιση παιδιών στο χρονοδιάγραμμα";
$pgv_lang["other"]					= "Άλλο";
$pgv_lang["others"]					= "Άλλοι";
$pgv_lang["sort_by_marriage"]		= "Ταξινόμηση ανά ημερομηνία γάμου";
$pgv_lang["reorder_families"]		= "Αναδιάταξη οικογενειών";
$pgv_lang["indis_with_surname"]		= "Άτομα με επώνυμο #surname#";
$pgv_lang["first_letter_name"]		= "Επιλέξτε ένα γράμμα για να εμφανιστού οικογένειες που το όνομα τους ξεκινά με αυτό το γράμμα.";
$pgv_lang["first_letter_sfname"]	= "Επιλέξτε ένα γράμμα για να εμφανίσετε οικογένειες στις οποίες ένας από τους συζύγους έχει δοσμένο όνομα το οποίο ξεκινάει από αυτό το γράμμα.";
$pgv_lang["first_letter_iname"]		= "Επιλέξτε ένα γράμμα για να εμφανίσετε άτομα των οποίων το επώνυμο αρχίζει με αυτό το γράμμα.";
$pgv_lang["first_letter_fname"]		= "Επιλέξτε ένα γράμμα για να εμφανίσετε άτομα που έχουν δοσμένο όνομα το οποίο αρχίζει με αυτό το γράμμα.";
$pgv_lang["total_names"]			= "Σύνολο ονομάτων";
$pgv_lang["total_changes"]			= "Σύνολο αλλαγών";
$pgv_lang["total_links"]			= "Σύνολο διασυνδέσεων";
$pgv_lang["top10_pageviews_nohits"]	= "Δεν υπάρχουν επιτυχίες για εμφάνιση.";
$pgv_lang["top10_pageviews_msg"]	= "Οι μετρητές επιτυχιών πρέπει να ενεργοποιηθούν στις ρυθμίσεις GEDCOM, τμήμα Προβολή και Διάταξη, ομάδα Εμφάνιση και Προβολή.";
$pgv_lang["review_changes_descr"]	= "Το πλαίσιο Εκρεμείς Αλλαγές θα δώσει στους χρήστες με προνόμια Επεξεργασίας, μια λίστα με εγγραφές που έχουν τροποποιηθεί online και εξακολουθούν να αναμένουν επισκόπηση και αποδοχή. Αυτές οι αλλαγές επιδέχονται αποδοχή ή απόρριψη.<br /><br />Εάν αυτό το πλαίσιο είναι ενεργοποιημένο, οι χρήστες με δικαιώματα Αποδοχής θα λάβουν ένα email μία φορά την ημέρα, που θα τους ενημερώνει ότι οι αλλαγές χρειάζονται επισκόπηση.";
$pgv_lang["review_changes_block"]	= "Εκκρεμείς αλλαγές";
$pgv_lang["review_changes_block"]	= "Εκκρεμείς αλλαγές";
$pgv_lang["review_changes_email"]	= "Αποστολή υπενθυμιστικών email;";
$pgv_lang["review_changes_email_freq"]	= "Συχνότητα email υπενθύμισης (ημέρες)";
$pgv_lang["review_changes_subject"]	= "PhpGedView - Επισκόπηση αλλαγών";
$pgv_lang["review_changes_body"]	= "Έχουν γίνει αλλαγές online στην γενεαλογική βάση δεδομένων. Αυτές οι αλλαγές χρειάζεται να επιθεωρηθούν και να γίνει αποδοχή τους πριν εμφανιστούν σε όλους τους χρήστες. Παρακαλώ χρησιμοποιήστες το παρακάτω URL για να μπείτε σε αυτή την τοποθεσία PhpGedView και να συνδεθείτε ώστε να επιθεωρήσετε τις αλλαγές.";
$pgv_lang["review_changes_subject"]	= "PhpGedView - Επιθεώρηση αλλαγών";
$pgv_lang["show_pending"]		= "Εμφάνιση εκκρεμών αλλαγών";
$pgv_lang["show_spouses"]		= "Εμφάνιση συζύγων";
$pgv_lang["quick_update_title"] = "Ταχεία ενημέρωση";
$pgv_lang["quick_update_instructions"] = "Αυτή η σελίδα σας επιτρέπει να ενημερώνετε γρήγορα τις πληροφορίες ενός ατόμου. Χρειάζεται να συμπληρώσετε μόνο τις πληροφορίες που είναι νέες ή αυτές που έχουν τροποποιηθεί, σε σχέση με τις τρέχουσες στην βάση δεδομένων.";
$pgv_lang["quick_update_instructions"] = "Αυτή η σελίδα σας επιτρέπει να ενημερώνετε γρήγορα τις πληροφορίες ενός ατόμου. Χρειάζεται να συμπληρώσετε μόνο τις πληροφορίες που είναι νέες ή αυτές που έχουν τροποποιηθεί, σε σχέση με τις τρέχουσες στην βάση δεδομένων. Αφότου οι αλλαγές σας υποβληθούν, πρέπει να επιθεωρηθούν από ένα διαχειριστή πριν γίνουν ορατές σε όλους.";
$pgv_lang["update_name"] = "Ενημέρωση ονόματος";
$pgv_lang["update_fact"] = "Ενημέρωση γεγονότος";
$pgv_lang["update_fact_restricted"] = "Η ενημέρωση αυτού του γεγονότος είναι περιορισμένη:";
$pgv_lang["select_fact"] = "Επιλογή γεγονότος...";
$pgv_lang["update_address"] = "Ενημέρωση διεύθυνσης";
$pgv_lang["top10_pageviews_descr"]	= "Αυτό το πλαίσιο θα εμφανίσει τις 10 εγγραφές που προβλήθηκαν περισσότερο. Αυτό το πλαίσιο απαιτεί να είναι ενεργοποιημένοι οι Μετρητές επιτυχιών στις ρυθμίσεις διαμόρφωσης του GEDCOM.";
$pgv_lang["top10_pageviews"]		= "Περισσότερο προβεβλημένα αντικείμενα";
$pgv_lang["top10_pageviews_block"]		= "Περισσότερο προβεβλημένα αντικείμενα";
$pgv_lang["stepparent"]				= "Θετός γονέας";
$pgv_lang["stepdad"]				= "Θετός πατέρας";
$pgv_lang["stepmom"]				= "Θετή μητέρα";
$pgv_lang["stepsister"]				= "Ετεροθαλής αδερφή";
$pgv_lang["stepbrother"]			= "Ετεροθαλής αδερφός";
$pgv_lang["fams_charts"]			= "Επιλογές οικογένειας";
$pgv_lang["indis_charts"]			= "Επιλογές ατόμου";
$pgv_lang["facts"]					= "Γεγονότα";
$pgv_lang["locked"]					= "Δεν αλλάζει";
$pgv_lang["privacy"]				= "Ιδιωτικότητα";
$pgv_lang["number_sign"]			= "#";
$pgv_lang["var_not_exist"]			= "<span style=\"font-weight: bold\">Η μεταβλητή γλώσας δεν υπάρχει. Παρακαλώ αναφέρατε το ως σφάλμα.</span>";
$pgv_lang["search_notes"]			= "Κοινόχρηστες σημειώσεις";
$pgv_lang["link_new_wife"]			= "Προσθήκη συζύγου (γυναίκας) χρησιμοποιόντας υπάρχον άτομο";
$pgv_lang["choose_username"]		= "Επιθυμητό όνομα χρήστη";
$pgv_lang["orientation"]			= "Προσανατολισμός";
$pgv_lang["shared_note_list"]		= "Κοινόχρηστες σημειώσεις";
$pgv_lang["repo_list"]				= "Χώροι φύλαξης";
$pgv_lang["search_DM"]				= "Daitch-Mokotoff";
$pgv_lang["firstname"]				= "Όνομα";
$pgv_lang["lastname"]				= "Επώνυμο";
$pgv_lang["choose_password"]		= "Επιθυμητός κωδικός πρόσβασης";
$pgv_lang["males"]					= "Αρσενικά";
$pgv_lang["females"]				= "Θηλυκά";
$pgv_lang["NNother"] 			= "(άγνωστο)";
$pgv_lang["PNother"] 			= "(άγνωστο)";
$pgv_lang["individual"]				= "Άτομο";
$pgv_lang["parent"] 				= "Γονέας";
$pgv_lang["parent_age"] 			= "Ηλικία γονέα";
$pgv_lang["father_age"]				= "Ηλικία πατέρα";
$pgv_lang["mother_age"]				= "Ηλικία μητέρας";
$pgv_lang["self"] 					= "Εαυτός";
$pgv_lang["relatives_events"]		= "Συμβάντα πλησιεστέρων συγγενών";
$pgv_lang["historical_facts"]		= "Ιστορικά γεγονότα";
$pgv_lang["partner"] 				= "Σύντροφος";
$pgv_lang["spouses"] 				= "Σύζυγοι";
$pgv_lang["stillborn"]				= "Θνησιγενές";
$pgv_lang["infant"]					= "Βρέφος";
$pgv_lang["disproved"]				= "Διαψευσμένο";
$pgv_lang["challenged"]				= "Αμφισβητούμενο ";
$pgv_lang["deceased"]				= "Αποβίωσε";
$pgv_lang["link_as_wife"]			= "Σύνδεση αυτού του ατόμου σε μια υπάρχουσα οικογένεια, ως σύζυγο (γυναίκα)";
$pgv_lang["show_fact_sources"]		= "Εμφάνιση όλων των πηγών";
$pgv_lang["show_fact_notes"]		= "Εμφάνιση όλων των σημειώσεων";
$pgv_lang["childless_family"]		= "Αυτή η οικογένεια παρέμεινε άτεκνη";
$pgv_lang["which_s_links"]			= "Ποιες από τις εγγραφές που συνδέονται σε αυτή την πηγή πρέπει να προστεθούν;";
$pgv_lang["just_source"]		= "Προσθήκη μόνο αυτής της πηγής.";
$pgv_lang["linked_source"]		= "Προσθήκη αυτής της πηγής και οικογένειες/άτομα που συνδέονται σε αυτή.";
$pgv_lang["enter_person_generations"] = "Αριθμός γενεών:";
$pgv_lang["external_objects"]		= "Εξωτερικά αντικείμενα";
$pgv_lang["view_object"]			= "Προβολή αντικειμένου";
$pgv_lang["next_image"]				= "Επόμενη εικόνα";
$pgv_lang["media_format"]			= "Μορφή μέσου";
$pgv_lang["image_size"]				= "Διαστάσεις εικόνας";
$pgv_lang["media_id"]				= "ID μέσου";
$pgv_lang["invalid_id"]				= "Δεν υπάρχει τέτοιο ID σε αυτό το αρχείο GEDCOM.";
$pgv_lang["record_updated"]			= "Η εγγραφή #pid# ενημερώθηκε επιτυχώς.";
$pgv_lang["record_not_updated"]		= "Η εγγραφή #pid# δεν μπόρεσε να ενημερωθεί.";
$pgv_lang["record_removed"]			= "Η εγγραφή #xref# αφαιρέθηκε επιτυχώς από το GEDCOM.";
$pgv_lang["record_not_removed"]		= "Η εγγραφή #xref# δεν μπόρεσε να αφαιρεθεί από το GEDCOM.";
$pgv_lang["record_added"]			= "Η εγγραφή #xref# προτέθηκε επιτυχώς στο GEDCOM.";
$pgv_lang["record_not_added"]		= "Η εγγραφή #xref# δεν μπόρεσε να προστεθεί στο GEDCOM.";
$pgv_lang["shared_notes"]			= "Κοινόχρηστες σημειώσεις";
$pgv_lang["search_soundex"]			= "Αναζήτηση Soundex";
$pgv_lang["search_replace"]			= "Εύρεση και αντικατάσταση";
$pgv_lang["search_sources"]			= "Πηγές";
$pgv_lang["search_shared_notes"]	= "Κοινόχρηστες σημειώσεις";
$pgv_lang["search_more_chars"]      = "Παρακαλώ εισάγετε περισσότερους από έναν χαρακτήρες";
$pgv_lang["search_soundextype"]		= "Τύπος Soundex:";
$pgv_lang["search_russell"]			= "Βασικό";
$pgv_lang["search_tagfilter"]		= "Φίλτρο εξαίρεσης";
$pgv_lang["search_tagfon"]			= "Εξαίρεση κάποιων μη-γενεαλογικών δεδομένων";
$pgv_lang["search_tagfoff"]			= "Ανενεργό";
$pgv_lang["associate"]				= "συσχετισμός";
$pgv_lang["search_record"]			= "Πλήρης εγγραφή";
$pgv_lang["search_to"]				= "έως";
$pgv_lang["find_source"]			= "Εύρεση πηγής";
$pgv_lang["repos_found"]			= "Χώροι φύλαξης που βρέθηκαν";
$pgv_lang["find_repository"]		= "Εύρεση χώρου φύλαξης";
$pgv_lang["total_repositories"]		= "Σύνολο χώρων φύλαξης";
$pgv_lang["confirm_delete_repo"]	= "Είστε σίγουροι ότι θέλετε να διαγράψετε αυτό τον χώρο φύλαξης;";
$pgv_lang["shared_note"]				= "Κοινόχρηστη σημείωση";
$pgv_lang["shared_notes_found"]			= "Κοινόχρηστες σημειώσεις βρέθηκαν";
$pgv_lang["find_shared_note"]			= "Εύρεση κοινόχρηστης σημείωσης";
$pgv_lang["shared_note_info"]			= "Πληροφορίες κοινόχρηστης σημείωσης";
$pgv_lang["total_shared_notes"]			= "Σύνολο κοινόχρηστων σημειώσεων";
$pgv_lang["changes_present"]		= "Το παρόν GEDCOM έχει εκκρεμείς αλλαγές για επισκόπηση. Εάν συνεχίσετε αυτή την εισαγωγή, οι αλλαγές θα καταχωρηθούν στην βάση δεδομένων άμεσα. Πρέπει να αξιολογήσετε τις εκκρεμείς αλλαγές, πριν συνεχίσετε την εισαγωγή.";
$pgv_lang["apply_filter"]			= "Εφαρμογή φίλτρου";
$pgv_lang["find_specialchar"]		= "Εύρεση ειδικών χαρακτήρων";
$pgv_lang["magnify"]				= "Μεγέθυνση";
$pgv_lang["skip_marnms"]			= "Εξαίρεση ονομάτων γάμου";
$pgv_lang["show_marnms"]			= "Συμπερίληψη ονομάτων γάμου";
$pgv_lang["confidential"]			= "Εμπιστευτικό";
$pgv_lang["alpha_index"]			= "Αλφαβητική κατάταξη";
$pgv_lang["name_list"] 				= "Κατάλογος ονομάτων";
$pgv_lang["firstname_alpha_index"] 	= "Αλφαβητική κατάταξη ονομάτων";
$pgv_lang["roots"]		 			= "Ρίζες";
$pgv_lang["leaves"] 				= "Φύλλα";
$pgv_lang["widow"] 					= "Χήρα";
$pgv_lang["widower"] 				= "Χήρος";
$pgv_lang["show_parents"] 			= "Εμφάνιση γονέων";
$pgv_lang["husb_age"]				= "Ηλικία συζύγου (άντρα)";
$pgv_lang["wife_age"]				= "Ηλικία συζύγου (γυναίκας)";
$pgv_lang["wife_age"]				= "";
$pgv_lang["year1"]					= "έτος";
$pgv_lang["years2"]					= "έτη";	// For Polish 2,3,4 or 22,23,24 or 32,33,34 etc.
$pgv_lang["years"]					= "ετών";
$pgv_lang["month1"]					= "μήνας";
$pgv_lang["months"]					= "μήνες";
$pgv_lang["week1"]					= "εβδομάδα";
$pgv_lang["weeks"]					= "εβδομάδες";
$pgv_lang["day1"]					= "ημέρα";
$pgv_lang["days"]					= "ημέρες";
$pgv_lang["after_death"]        	= "μετά τον θάνατο";
$pgv_lang["at_death_day"]      		= "την ημέρα του θανάτου";
$pgv_lang["timeline_beginYear"] = "Έτος αρχής";
$pgv_lang["timeline_endYear"] = "Έτος τέλους";
$pgv_lang["timeline_scrollSpeed"] = "Ταχύτητα";
$pgv_lang["timeline_controls"] = "Χειριστήρια χρονοδιαγράμματος";
$pgv_lang["include_family"] = "Συμπερίληψη άμεσης οικογένειας";
$pgv_lang["lifespan_chart"] = "Διάγραμμα διάρκειας ζωής";
$pgv_lang["cal_none"]                 = "Χωρίς μετατροπή ημερολογίου";
$pgv_lang["easter"]     = "Πάσχα";
$pgv_lang["ascension"]  = "Αναλήψεως";
$pgv_lang["pentecost"]  = "Πεντηκοστή";
$pgv_lang["assumption"] = "Κοίμηση της Θεοτόκου";
$pgv_lang["all_saints"] = "Αγίων Πάντων";
$pgv_lang["christmas"]  = "Χριστούγεννα";
$pgv_lang["a.m."]         = "πμ";
$pgv_lang["p.m."]         = "μμ";
$pgv_lang["noon"]         = "μβ";
$pgv_lang["midn"]         = "μν";
$pgv_lang["b.c."]         = "π.Χ.";
$pgv_lang["ramad"]        = "Ραμαζάνι";
$pgv_lang["muhar"]        = "Μουχάραμ";
$pgv_lang["saveandgo"]		= "Αποθήκευση και μετάβαση στη νέα εγγραφή";
$pgv_lang["basic_realm"]			= "Σύστημα πιστοποίησης του PhpGedView ";
$pgv_lang["basic_auth_failure"]		= "Πρέπει να εισάγετε έγκυρο ID σύνδεσης και κωδικό, για πρόσβαση σε αυτό τον πόρο";
$pgv_lang["basic_auth"]				= "Βασική πιστοποίηση";
$pgv_lang["digest_auth"]				= "Σύντομη πιστοποίηση (digest)"; //not used in code yet
$pgv_lang["no_auth_needed"]			= "Χωρίς πιστοποίηση";
$pgv_lang["research_assistant"]		= "Βοηθός έρευνας";
$pgv_lang["media_linked"]			= "Αυτό το αντικείμενο μέσου είναι διασυνδεμένο στα παρακάτω:";
$pgv_lang["media_not_linked"]		= "Αυτό το αντικείμενο μέσου δεν είναι διασυνδεμένο σε κάποια εγγραφή GEDCOM.";
$pgv_lang["media_dir_1"]			= "Αυτό το αντικείμενο μέσου είναι τοποθετημένο σε εξωτερικό εξυπηρετητή";
$pgv_lang["media_dir_2"]			= "Αυτό το αντικείμενο μέσου είναι στον κανονικό κατάλογο μέσων";
$pgv_lang["media_dir_3"]			= "Αυτό το αντικείμενο μέσου είναι στον προστατευμένο κατάλογο μέσων";
$pgv_lang["thumb_dir_1"]			= "Αυτή η μικρογραφία είναι τοποθετημένη σε εξωτερικό εξυπηρετητή";
$pgv_lang["thumb_dir_2"]			= "Αυτή η μικρογραφία είναι στον κανονικό κατάλογο μέσων";
$pgv_lang["thumb_dir_3"]			= "Αυτή η μικρογραφία είναι στον προστατευμένο κατάλογο μέσων";
$pgv_lang["moveto_2"]				= "Μετακίνηση στον προστατευμένο κατάλογο";
$pgv_lang["moveto_3"]				= "Μετακίνηση στον κανονικό κατάλογο";
$pgv_lang["move_standard"]			= "Μετακίνηση στον κανονικό";
$pgv_lang["move_protected"]			= "Μετακίνηση στον προστατευμένο";
$pgv_lang["move_mediadirs"]			= "Μετακίνηση καταλόγων μέσων";
$pgv_lang["setperms"]				= "Ορισμός αδειών μέσων";
$pgv_lang["setperms_fix"]			= "Διόρθωση αδειών ανάγνωσης/εγγραφής/εκτέλεσης";
$pgv_lang["setperms_success"]		= "Οι άδειες ορίστηκαν";
$pgv_lang["setperms_failure"]		= "Οι άδειες δεν ορίστηκαν";
$pgv_lang["setperms_time_exceeded"]	= "Προσεγγίστηκε το χρονικό όριο εκτέλεσης. Δοκιμάστε την εντολή ξανά σε μικρότερο κατάλογο.";
$pgv_lang["move_time_exceeded"]		= "Προσεγγίστηκε το χρονικό όριο εκτέλεσης. Δοκιμάστε την εντολή ξανά για να μετακινήσετε τα υπόλοιπα αρχεία.";
$pgv_lang["media_firewall_rootdir_no_exist"]			= "Ο ριζικός κατάλογος του τοίχου προστασίας μέσων που ζητήσατε, δεν υπάρχει.";
$pgv_lang["media_firewall_protected_dir_no_exist"]		= "Ο προστατευμένος κατάλογος μέσων δεν μπορούσε να δημιουργηθεί μέσα στον ριζικό κατάλογο του τοίχου προστασίας μέσων. Παρακαλώ δημιουργήστε αυτό τον κατάλογο και κάντε τον παγκόσμια εγγράψιμο.";
$pgv_lang["media_firewall_protected_dir_not_writable"]	= "Ο προστατευμένος κατάλογος μέσων, μέσα στον ριζικό κατάλογο του τοίχου προστασίας, δεν είναι παγκόσμια εγγράψιμος.";
$pgv_lang["media_firewall_invalid_dir"]	= "Σφάλμα: Το τοίχος προστασίας μέσων ξεκίνησε από κατάλογο διαφορετικό από τον κατάλογο μέσων.";
$pgv_lang["view_fam_nav_details"]	= "Προβολή λεπτομερειών για...";
$pgv_lang["view_fam_nav_notes"]		= "Προβολή σημειώσεων για ...";
$pgv_lang["view_fam_nav_sources"]	= "Προβολή πηγών για ...";
$pgv_lang["view_fam_nav_media"]		= "Προβολή μέσων για ...";
$pgv_lang["view_fam_nav_album"]		= "Προβολή λευκώματος για ...";
$pgv_lang["view_fam_nav_relatives"]	= "Προβολή συγγενών για ...";
$pgv_lang["view_fam_nav_tree"]		= "Προβολή δέντρου για ...";
$pgv_lang["view_fam_nav_research"]	= "Προβολή έρευνας για ...";
$pgv_lang["view_fam_nav_map"]		= "Προβολή χάρτη για ...";
$pgv_lang["view_fam_nav_spare"]		= "Προβολή περισσευούμενων πληροφοριών για ...";
$pgv_lang["navigator"]				= "Πλοηγός";
$pgv_lang["relationship_great"]		= "Προ";
$pgv_lang["no_other_link_found"]	= "Δεν βρέθηκε καμία άλλη σύνδεση ανάμεσα στα δύο άτομα.";
$pgv_lang["grandchild"]				= "Εγγόνι";
$pgv_lang["grandson"]				= "Εγγονός";
$pgv_lang["granddaughter"]			= "Εγγονή";
$pgv_lang["greatgrandchild"]		= "Δισέγγονο";
$pgv_lang["greatgrandson"]			= "Δισέγγονος";
$pgv_lang["greatgranddaughter"]		= "Δισέγγονη";
$pgv_lang["aunt"]					= "Θεία";
$pgv_lang["uncle"]				= "Θείος";
$pgv_lang["nephew"]				= "Ανιψιός";
$pgv_lang["niece"]				= "Ανιψιά";
$pgv_lang["nephew"]				= "Ανιψιός";
$pgv_lang["firstcousin"]			= "Πρώτο ξαδέρφι";
$pgv_lang["malecousin"]				= "Ξάδερφος";
$pgv_lang["femalecousin"]			= "Ξαδέρφη";
$pgv_lang["rela_husb"]				= "Σχέση με σύζυγο (άντρα)";
$pgv_lang["rela_wife"]				= "Σχέση με σύζυγο (γυναίκα)";
$pgv_lang["relationship_male_1_is_the_2_of_3"] = "%1\$s είναι ο %2\$s του %3\$s.";
$pgv_lang["relationship_female_1_is_the_2_of_3"] = "%1\$s είναι η %2\$s του %3\$s.";
$pgv_lang["mother_in_law"]		= "Πεθερά";
$pgv_lang["father_in_law"]		= "Πεθερός";
$pgv_lang["brother_in_law"]		= "Κουνιάδος";
$pgv_lang["sister_in_law"]		= "Κουνιάδα";
$pgv_lang["brothers_wife"]		= "Κουνιάδα"; // brother's wife
$pgv_lang["son_in_law"]			= "Γαμπρός";
$pgv_lang["daughter_in_law"]	= "Νύφη";
$pgv_lang["uncle_in_law"]		= "Ο θείος του δικαίου";
$pgv_lang["aunt_in_law"]		= "Η θεία του δικαίου";
$pgv_lang["cousin_in_law"]		= "Ξαδέρφι του δικαίου";
$pgv_lang["m_cousin_in_law"]	= "Ξάδερφος του δικαίου";
$pgv_lang["f_cousin_in_law"]	= "Ξαδέρφη του δικαίου";
$pgv_lang["step_son"]			= "θετός γιος";
$pgv_lang["step_daughter"]		= "θετή κόρη";
$pgv_lang["step_son"]			= "θετός γιός";
$pgv_lang["step_son"]			= "θετός γιος";
$pgv_lang["bosa_brothers_offspring_2"]				= "ανιψιός";             // brother's son
$pgv_lang["bosa_brothers_offspring_3"]				= "ανιψιά";              // brother's daughter
$pgv_lang["bosa_brothers_offspring_4"]				= "great ανιψιός";       // brother's son's son
$pgv_lang["bosa_brothers_offspring_5"]				= "great ανιψιά";        // brother's son's daughter
$pgv_lang["bosa_brothers_offspring_6"]				= "great ανιψιός";       // brother's daughter's son
$pgv_lang["bosa_brothers_offspring_7"]				= "great ανιψιά";        // brother's daughter's daughter
$pgv_lang["n_x_brothers_son"]	  = "%2\$d x great ανιψιός";
$pgv_lang["n_x_brothers_daughter"] = "%2\$d x great ανιψιά";
$pgv_lang["bosa_sisters_offspring_2"]				= "ανιψιός";             // sister's son
$pgv_lang["bosa_sisters_offspring_3"]				= "ανιψιά";              // sister's daughter
$pgv_lang["bosa_sisters_offspring_4"]				= "great ανιψιός";       // sister's son's son
$pgv_lang["bosa_sisters_offspring_5"]				= "great ανιψιά";        // sister's son's daughter
$pgv_lang["bosa_sisters_offspring_6"]				= "great ανιψιός";       // sister's daughter's son
$pgv_lang["bosa_sisters_offspring_7"]				= "great ανιψιά";        // sister's daughter's daughter
$pgv_lang["n_x_sisters_son"]	  = "%2\$d x great ανιψιός";
$pgv_lang["n_x_sisters_daughter"] = "%2\$d x great ανιψιά";
$pgv_lang["bosa_2"] 				= "υιός";                   // son
$pgv_lang["bosa_3"] 				= "θυγατέρα";              // daughter
$pgv_lang["bosa_4"] 				= "εγγονός";              // son's son
$pgv_lang["bosa_5"] 				= "εγγονή";         // son's daughter
$pgv_lang["bosa_6"] 				= "εγγονός";              // daughter's son
$pgv_lang["bosa_7"] 				= "εγγονή";         // daughter's daughter
$pgv_lang["bosa_8"] 				= "δισέγγονος";        // son's son's son
$pgv_lang["bosa_9"] 				= "δισεγγονή";   // son's son's daughter
$pgv_lang["bosa_10"] 				= "δισέγγονος";		   // son's daughter's son
$pgv_lang["bosa_11"] 				= "δισεγγονή";   // son's daughter's daughter
$pgv_lang["bosa_12"] 				= "δισέγγονος";        // daughter's son's son
$pgv_lang["bosa_13"] 				= "δισεγγονή";   // daughter's son's daughter
$pgv_lang["bosa_14"] 				= "δισέγγονος";		   // daughter's daughter's son
$pgv_lang["bosa_15"] 				= "δισεγγονή";   // daughter's daughter's daughter
$pgv_lang["n_x_grandson_from_son"]	  = "%3\$d x δισέγγονος";
$pgv_lang["n_x_granddaughter_from_son"] = "%3\$d x δισεγγονή";
$pgv_lang["n_x_grandson_from_daughter"]	  = "%3\$d x δισέγγονος";
$pgv_lang["n_x_granddaughter_from_daughter"] = "%3\$d x δισεγγονή";
$pgv_lang["sosa_uncle_2"] 				= "θείος";            // father's brother
$pgv_lang["sosa_uncle_3"] 				= "θείος";            // mother's brother
$pgv_lang["sosa_uncle_4"] 				= "great θείος";      // fathers's father's brother
$pgv_lang["sosa_uncle_5"] 				= "great θείος";      // father's mother's brother
$pgv_lang["sosa_uncle_6"] 				= "great θείος";      // mother's father's brother
$pgv_lang["sosa_uncle_7"] 				= "great θείος";      // mother's mother's brother
$pgv_lang["n_x_paternal_uncle"]		= "%2\$d x great θείος";
$pgv_lang["n_x_maternal_uncle"]	    = "%2\$d x great θείος";
$pgv_lang["sosa_aunt_2"] 				= "θεία";            // father's sister
$pgv_lang["sosa_aunt_3"] 				= "θεία";            // mother's sister
$pgv_lang["sosa_aunt_4"] 				= "great θεία";      // fathers's father's sister
$pgv_lang["sosa_aunt_5"] 				= "great θεία";      // father's mother's sister
$pgv_lang["sosa_aunt_6"] 				= "great θεία";      // mother's father's sister
$pgv_lang["sosa_aunt_7"] 				= "great θεία";      // mother's mother's sister
$pgv_lang["n_x_paternal_aunt"]		= "%2\$d x great θεία";
$pgv_lang["n_x_maternal_aunt"]	    = "%2\$d x great θεία";
$pgv_lang["sosa_uncle_bm_2"] 				= "θείος";            // father's brother
$pgv_lang["sosa_uncle_bm_3"] 				= "θείος";            // mother's brother
$pgv_lang["sosa_uncle_bm_4"] 				= "great θείος";      // fathers's father's brother
$pgv_lang["sosa_uncle_bm_5"] 				= "great θείος";      // father's mother's brother
$pgv_lang["sosa_uncle_bm_6"] 				= "great θείος";      // mother's father's brother
$pgv_lang["sosa_uncle_bm_7"] 				= "great θείος";      // mother's mother's brother
$pgv_lang["n_x_paternal_uncle_bm"]		= "%2\$d x great θείος";
$pgv_lang["n_x_maternal_uncle_bm"]	    = "%2\$d x great θείος";
$pgv_lang["sosa_aunt_bm_2"] 				= "θεία";            // father's sister
$pgv_lang["sosa_aunt_bm_3"] 				= "θεία";            // mother's sister
$pgv_lang["sosa_aunt_bm_4"] 				= "great θεία";      // fathers's father's sister
$pgv_lang["sosa_aunt_bm_5"] 				= "great θεία";      // father's mother's sister
$pgv_lang["sosa_aunt_bm_6"] 				= "great θεία";      // mother's father's sister
$pgv_lang["sosa_aunt_bm_7"] 				= "great θεία";      // mother's mother's sister
$pgv_lang["n_x_paternal_aunt_bm"]		= "%2\$d x great θεία";
$pgv_lang["n_x_maternal_aunt_bm"]	    = "%2\$d x great θεία";
$pgv_lang["male_cousin_1"]              = "πρώτος ξάδερφος";
$pgv_lang["male_cousin_2"]              = "δεύτερος ξάδερφος";
$pgv_lang["male_cousin_3"]              = "τρίτος ξάδερφος";
$pgv_lang["male_cousin_4"]              = "τέταρτος ξάδερφος";
$pgv_lang["male_cousin_5"]              = "πέμπτος ξάδερφος";
$pgv_lang["male_cousin_6"]              = "έκτος ξάδερφος";
$pgv_lang["male_cousin_7"]              = "έβδομος ξάδερφος";
$pgv_lang["male_cousin_8"]              = "όγδοος ξάδερφος";
$pgv_lang["male_cousin_9"]              = "ένατος ξάδερφος";
$pgv_lang["male_cousin_10"]             = "δέκατος ξάδερφος";
$pgv_lang["male_cousin_11"]             = "ενδέκατος ξάδερφος";
$pgv_lang["male_cousin_12"]             = "δωδέκατος ξάδερφος";
$pgv_lang["male_cousin_13"]             = "δέκατος τρίτος ξάδερφος";
$pgv_lang["male_cousin_14"]             = "δέκατος τέταρτος ξάδερφος";
$pgv_lang["male_cousin_15"]             = "δέκατος πέμπτος ξάδερφος";
$pgv_lang["male_cousin_16"]             = "δέκατος έκτος ξάδερφος";
$pgv_lang["male_cousin_17"]             = "δέκατος έβδομος ξάδερφος";
$pgv_lang["male_cousin_18"]             = "δέκατος όγδοος ξάδερφος";
$pgv_lang["male_cousin_19"]             = "δέκατος ένατος ξάδερφος";
$pgv_lang["male_cousin_20"]             = "εικοστός ξάδερφος";
$pgv_lang["male_cousin_n"]              = "%d x ξάδερφος";
$pgv_lang["female_cousin_1"]            = "πρώτη ξαδέρφη";
$pgv_lang["female_cousin_2"]            = "δεύτερη ξαδέρφη";
$pgv_lang["female_cousin_3"]            = "τρίτη ξαδέρφη";
$pgv_lang["female_cousin_4"]            = "τέταρτη ξαδέρφη";
$pgv_lang["female_cousin_5"]            = "πέμπτη ξαδέρφη";
$pgv_lang["female_cousin_6"]            = "έκτη ξαδέρφη";
$pgv_lang["female_cousin_7"]            = "έβδομη ξαδέρφη";
$pgv_lang["female_cousin_8"]            = "όγδοη ξαδέρφη";
$pgv_lang["female_cousin_9"]            = "ένατη ξαδέρφη";
$pgv_lang["female_cousin_10"]           = "δέκατη ξαδέρφη";
$pgv_lang["female_cousin_11"]           = "ενδέκατη ξαδέρφη";
$pgv_lang["female_cousin_12"]           = "δωδέκατη ξαδέρφη";
$pgv_lang["female_cousin_13"]           = "δέκατη τρίτη ξαδέρφη";
$pgv_lang["female_cousin_14"]           = "δέκατη τέταρτη ξαδέρφη";
$pgv_lang["female_cousin_15"]           = "δέκατη πέμπτη ξαδέρφη";
$pgv_lang["female_cousin_16"]           = "δέκατη έκτη ξαδέρφη";
$pgv_lang["female_cousin_17"]           = "δέκατη έβδομη ξαδέρφη";
$pgv_lang["female_cousin_18"]           = "δέκατη όγδοη ξαδέρφη";
$pgv_lang["female_cousin_19"]           = "δέκατη ένατη ξαδέρφη";
$pgv_lang["female_cousin_20"]           = "εικοστή ξαδέρφη";
$pgv_lang["female_cousin_n"]            = "%d x ξαδέρφη";
$pgv_lang["removed_ascending_1"]   = "με μία απομάκρυνση ανερχόμενα";
$pgv_lang["removed_ascending_2"]   = "με διπλή απομάκρυνση ανερχόμενα";
$pgv_lang["removed_ascending_3"]   = "με τριπλή απομάκρυνση ανερχόμενα";
$pgv_lang["removed_ascending_4"]   = "με τετραπλή απομάκρυνση ανερχόμενα";
$pgv_lang["removed_ascending_5"]   = "με πενταπλή απομάκρυνση ανερχόμενα";
$pgv_lang["removed_ascending_6"]   = "με εξαπλή απομάκρυνση ανερχόμενα";
$pgv_lang["removed_ascending_7"]   = "με επταπλή απομάκρυνση ανερχόμενα";
$pgv_lang["removed_ascending_8"]   = "με οκταπλή απομάκρυνση ανερχόμενα";
$pgv_lang["removed_ascending_9"]   = "με εννεαπλή απομάκρυνση ανερχόμενα";
$pgv_lang["removed_ascending_10"]  = "με δεκαπλή απομάκρυνση ανερχόμενα";
$pgv_lang["removed_ascending_11"]  = "με εντεκαπλή απομάκρυνση ανερχόμενα";
$pgv_lang["removed_ascending_12"]  = "με δωδεκαπλή απομάκρυνση ανερχόμενα";
$pgv_lang["removed_ascending_13"]  = "με δεκατριπλή απομάκρυνση ανερχόμενα";
$pgv_lang["removed_ascending_14"]  = "με δεκατετραπλή απομάκρυνση ανερχόμενα";
$pgv_lang["removed_ascending_15"]  = "με δεκαπενταπλή απομάκρυνση ανερχόμενα";
$pgv_lang["removed_ascending_16"]  = "με δεκαεξαπλή απομάκρυνση ανερχόμενα";
$pgv_lang["removed_ascending_17"]  = "με δεκαεπταπλή απομάκρυνση ανερχόμενα";
$pgv_lang["removed_ascending_18"]  = "με δεκαοκταπλή απομάκρυνση ανερχόμενα";
$pgv_lang["removed_ascending_19"]  = "με δεκαεννεαπλή απομάκρυνση ανερχόμενα";
$pgv_lang["removed_ascending_20"]  = "με εικοσαπλή απομάκρυνση ανερχόμενα";
$pgv_lang["removed_descending_1"]  = "με μία απομάκρυνση κατερχόμενα";
$pgv_lang["removed_descending_2"]  = "με διπλή απομάκρυνση κατερχόμενα";
$pgv_lang["removed_descending_3"]  = "με τριπλή απομάκρυνση κατερχόμενα";
$pgv_lang["compact_chart"]			= "Συμπαγές διάγραμμα";
$pgv_lang["statnnames"]         = "Σύνολο ατόμων";
$pgv_lang["statnmale"]          = "Σύνολο αρσενικά";
$pgv_lang["statnfemale"]        = "Σύνολο θηλυκά";
$pgv_lang["statnmale"]          = "Σύνολο αρσενικών";
$pgv_lang["statnfam"]           = "Σύνολο οικογενειών";
$pgv_lang["click_here"]				= "Συνέχεια";
$pgv_lang["descend_report"]		= "Αναφορά απογόνων";
$pgv_lang["changes_report"]			= "Αναφορά αλλαγών";
$pgv_lang["bdm"]					= "Γεννήσεις, θάνατοι, γάμοι";
$pgv_lang["death_report"]			= "Αναφορά ημερομηνίας και τόπου θανάτου ";
$pgv_lang["relatives_report_ext"]	= "Αναφορά εκτεταμένων συγγενών";
$pgv_lang["marr_report"]			= "Αναφορά ημερομηνίας και τόπου γάμου";
$pgv_lang["ahnentafel_report"]		= "Αναφορά Ahnentafel";
$pgv_lang["favorites"]				= "Αγαπημένα";
$pgv_lang["mail04_line05"]			= "Αφού συνδεθείτε, επιλέξτε το σύνδεσμο «#pgv_lang[editowndata]#» κάτω από το μενού «#pgv_lang[mygedview]#» και συμπληρώστε τα πεδία κωδικών για να αλλάξετε τον κωδικό σας.";
$pgv_lang["block_givn_top10_title"]		= "Δημοφιλή δοσμένα ονόματα";
$pgv_lang["block_givn_top10"]			= "Δημοφιλή δοσμένα ονόματα";
$pgv_lang["anon_user"]				= "1 ανώνυμος συνδεδεμένος χρήστης";
$pgv_lang["anon_users"]				= "#pgv_lang[global_num1]# ανώνυμοι συνδεδεμένοι χρήστες";
$pgv_lang["login_user"]				= "1 συνδεδεμένος χρήστης";
$pgv_lang["login_users"]			= "#pgv_lang[global_num1]# συνδεδεμένοι χρήστες";
$pgv_lang["no_login_users"]			= "Μη συνδεδεμένοι και μη ανώνυμοι χρήστες";
$pgv_lang["gedcom_stats_show_surnames"]	= "Εμφάνιση συνηθισμένων επωνύμων;";
$pgv_lang["removed_descending_4"]  = "με τετραπλή απομάκρυνση κατερχόμενα";
$pgv_lang["removed_descending_5"]  = "με πενταπλή απομάκρυνση κατερχόμενα";
$pgv_lang["removed_descending_6"]  = "με εξαπλή απομάκρυνση κατερχόμενα";
$pgv_lang["removed_descending_7"]  = "με επταπλή απομάκρυνση κατερχόμενα";
$pgv_lang["removed_descending_8"]  = "με οκταπλή απομάκρυνση κατερχόμενα";
$pgv_lang["removed_descending_9"]  = "με εννεαπλή απομάκρυνση κατερχόμενα";
$pgv_lang["removed_descending_10"] = "με δεκαπλή απομάκρυνση κατερχόμενα";
$pgv_lang["removed_descending_11"] = "με εντεκαπλή απομάκρυνση κατερχόμενα";
$pgv_lang["removed_descending_12"] = "με δωδεκαπλή απομάκρυνση κατερχόμενα";
$pgv_lang["removed_descending_13"] = "με δεκατριπλή απομάκρυνση κατερχόμενα";
$pgv_lang["removed_descending_14"] = "με δεκατετραπλή απομάκρυνση κατερχόμενα";
$pgv_lang["removed_descending_15"] = "με δεκαπενταπλή απομάκρυνση κατερχόμενα";
$pgv_lang["removed_descending_16"] = "με δεκαεξαπλή απομάκρυνση κατερχόμενα";
$pgv_lang["removed_descending_17"] = "με δεκαεπταπλή απομάκρυνση κατερχόμενα";
$pgv_lang["removed_descending_18"] = "με δεκαοκταπλή απομάκρυνση κατερχόμενα";
$pgv_lang["removed_descending_19"] = "με δεκαεννεαπλή απομάκρυνση κατερχόμενα";
$pgv_lang["removed_descending_20"] = "με εικοσαπλή απομάκρυνση κατερχόμενα";
$pgv_lang["delete_shared_note"]		= "Διαγραφή αυτής της κοινόχρηστης σημείωσης";
$pgv_lang["confirm_delete_shared_note"]		= "Είστε σίγουροι ότι θέλετε να διαγράψετε αυτή την κοινόχρηστη σημείωση;";
$pgv_lang["ged_noshow"]				= "Αυτή η σελίδα έχει απενεργοποιηθεί από τον διαχειριστή της τοποθεσίας.";
$pgv_lang["anniversary"]			= "Επέτειος";
$pgv_lang["mandatory"] 			= "Τα σημειωμένα πεδία με * είναι υποχρεωτικά.";
$pgv_lang["mail02_line04a"]			= "Θα ενημερωθείτε με email όταν ο υποψήφιος χρήστης έχει επιβεβαιώσει την αίτηση του. Μετά από αυτό, ο χρήστης θα μπορεί να συνδεθεί χωρίς καμία δράση από την πλευρά σας.";
$pgv_lang["pls_note06a"] 			= "Τώρα θα στείλουμε ένα email επιβεβαίωσης στην διεύθυνση <b>#user_email#</b>. Πρέπει να επαληθεύσετε την αίτηση λογαριασμού σας, ακολουθώντας τις οδηγίες στο email επαλήθευσης. Εάν δεν επιβεβαιώσετε την αίτηση λογαριασμού μέσα σε επτά ημέρες, το αίτημα σας θα απορριφθεί αυτόματα. Θα πρέπει να υποβάλετε ξανά.<br /><br />Εφόσον ακολουθήσετε τις οδηγίες στο email επιβεβαίωσης, μπορείτε να συνδεθείτε. Για να συνδεθείτε σε αυτή την τοποθεσία θα πρέπει να γνωρίζετε το όνομα χρήστη και τον κωδικό σας.<br /><br />";
$pgv_lang["mail03_line03a"]			= "Δεν χρειάζεται να κάνετε οποιαδήποτε ενέργεια. Ο χρήστης μπορεί τώρα να συνδεθεί.";
$pgv_lang["pls_note10a"]			= "Μπορείτε τώρα να συνδεθείτε με το όνομα χρήστη και τον κωδικό σας.";
$pgv_lang["acceptable_use"]			= "<div class=\"largeError\">Σημείωση:</div><div class=\"error\">Με την συμπλήρωση και υποβολή αυτής της φόρμας, συμφωνείτε:<ul><li>Να προστατεύετε την ιδιωτικότητα των ανθρώπων που ζουν και βρίσκονται καταχωρημένοι στην τοποθεσία μας,</li><li>και στο πλαίσιο κειμένου παρακάτω, να εξηγήσετε με ποιον έχετε συγγένεια, ή να μας προσφέρετε πληροφορίες για κάποιον που θα έπρεπε να είναι καταχωρημένος στην τοποθεσία μας.</li></ul></div>";
$pgv_lang["living_or_all"]			= "Εμφάνιση συμβάντων από ζωντανά άτομα μόνο;";
$pgv_lang["basic_or_all"]			= "Εμφάνιση μόνο γεννήσεων, θανάτων, και γάμων;";
$pgv_lang["style"]					= "Στυλ παρουσίασης";
$pgv_lang["style1"]					= "Κατάλογος";
$pgv_lang["style2"]					= "Πίνακας";
$pgv_lang["style3"]					= "Ετικετοσύνεφο";
$pgv_lang["cal_download"]			= "Επιτρέπεται η λήψη συμβάντων του ημερολογίου;";
$pgv_lang["no_events_living"]		= "Δεν υπάρχουν συμβάντα για ζωντανά άτομα για τις επόμενες #pgv_lang[global_num1]# ημέρες.";
$pgv_lang["no_events_living1"]		= "Δεν υπάρχουν συμβάντα ζωντανών ατόμων για αύριο.";
$pgv_lang["no_events_all"]			= "Δεν υπάρχουν συμβάντα για τις επόμενες #pgv_lang[global_num1]# ημέρες.";
$pgv_lang["no_events_all1"]			= "Δεν υπάρχουν συμβάντα για αύριο.";
$pgv_lang["no_events_privacy"]		= "Υπάρχουν συμβάντα για τις επόμενες #pgv_lang[global_num1]# ημέρες, αλλά περιορισμοί ιδιωτικότητας σας εμποδίζουν να τα δείτε.";
$pgv_lang["no_events_privacy1"]		= "Υπάρχουν συμβάντα για αύριο, αλλά περιορισμοί ιδιωτικότητας σας εμποδίζουν να τα δείτε.";
$pgv_lang["more_events_privacy"]	= "<br />Περισσότερα συμβάντα υπάρχουν για τις επόμενες #pgv_lang[global_num1]# ημέρες, αλλά περιορισμοί ιδιωτικότητας σας εμποδίζουν να τα δείτε.";
$pgv_lang["more_events_privacy1"]	= "<br />Περισσότερα συμβάντα υπάρχουν για αύριο, αλλά περιορισμοί ιδιωτικότητας σας εμποδίζουν να τα δείτε.";
$pgv_lang["none_today_living"]		= "Δεν υπάρχουν συμβάντα ζωντανών ατόμων για σήμερα.";
$pgv_lang["none_today_all"]			= "Δεν υπάρχουν συμβάντα για σήμερα.";
$pgv_lang["none_today_privacy"]		= "Υπάρχουν συμβάντα για σήμερα, αλλά περιορισμοί ιδιωτικότητας σας εμποδίζουν να τα δείτε.";
$pgv_lang["more_today_privacy"]		= "<br />Περισσότερα συμβάντα υπάρχουν για σήμερα, αλλά περιορισμοί ιδιωτικότητας σας εμποδίζουν να τα δείτε.";
$pgv_lang["stat_earliest_birth"] 	= "Παλαιότερο έτος γέννησης";
$pgv_lang["stat_latest_birth"] 	= "Τελευταίο έτος γέννησης";
$pgv_lang["stat_earliest_death"] 	= "Παλαιότερο έτος θανάτου";
$pgv_lang["stat_latest_death"] 	= "Τελευταίο έτος θανάτου";
$pgv_lang["todo_block"] = "Εργασίες &quot;προς ενέργεια&quot;";
$pgv_lang["todo_descr"] = "Το πλαίσιο Προς ενέργεια εμφανίζει ένα κατάλογο με τα εκκρεμή _TODO γεγονότα στην βάση δεδομένων.";
$pgv_lang["todo_show_other"]     = "Εμφάνιση εργασιών άλλων χρηστών.";
$pgv_lang["todo_show_unassigned"]= "Εμφάνιση ανεκχώρητων εργασιών.";
$pgv_lang["todo_show_future"]    = "Εμφάνιση μελλοντικών εργασιών";
$pgv_lang["todo_nothing"]        = "Δεν υπάρχουν εργασίες &quot;προς ενέργεια&quot;.";
$pgv_lang["random_media_persons_or_all"]	= "Εμφάνιση μόνο ατόμων, συμβάντων, ή όλων;";
$pgv_lang["random_media_persons"]	= "Άτομα";
$pgv_lang["random_media_events"]	= "Συμβάντα";
$pgv_lang["block_givn_top10_descr"]		= "Αυτό το πλαίσιο εμφανίζει ένα πίνακα με τα 10 πιο συχνά εμφανιζόμενα δοσμένα ονόματα στην βάση δεδομένων. Ο πραγματικός αριθμός δοσμένων ονομάτων που εμφανίζονται σε αυτό το πλαίσιο είναι ρυθμιζόμενος.";
$pgv_lang["gedcom_news_limit"]		= "Περιορισμός εμφάνισης με:";
$pgv_lang["gedcom_news_limit_nolimit"]	= "Χωρίς όριο";
$pgv_lang["gedcom_news_limit_date"]		= "Ηλικία αντικειμένου";
$pgv_lang["gedcom_news_limit_count"]	= "Αριθμός αντικειμένων";
$pgv_lang["gedcom_news_flag"]		= "Όριο:";
$pgv_lang["gedcom_news_archive"] 	= "Προβολή αρχείου";
$pgv_lang["available_blocks"]		= "Διαθέσιμα πλαίσια";
$pgv_lang["recent_changes_none"]	= "<b>Δεν υπάρχουν αλλαγές κατά τις τελευταίες #pgv_lang[global_num1]# ημέρες.</b><br />";
$pgv_lang["recent_changes_some"]	= "<b>Αλλαγές κατά τις τελευταίες #pgv_lang[global_num1]# ημέρες</b><br />";
$pgv_lang["show_empty_block"]		= "Πρέπει αυτό το πλαίσιο να αποκρύπτεται όταν είναι άδειο;";
$pgv_lang["hide_block_warn"]		= "Εάν αποκρύψετε ένα άδειο πλαίσιο, δεν θα μπορείτε να αλλάξετε τις ρυθμίσεις του μέχρι να μην είναι πλέον άδειο ώστε να γίνει ορατό.";
$pgv_lang["block_not_configure"]	=	"Αυτό το πλαίσιο δεν μπορεί να ρυθμιστεί.";
$pgv_lang["ahnentafel_header"]		= "Αναφορά Ahnentafel για";
$pgv_lang["ahnentafel_generation"]	= "Γενεά";
$pgv_lang["ahnentafel_born_m"]		= "γεννήθηκε";			// male
$pgv_lang["ahnentafel_pronoun_m"]	= "Αυτός";
$pgv_lang["ahnentafel_pronoun_f"]	= "Αυτή";
$pgv_lang["ahnentafel_born_f"]		= "γεννήθηκε";			// female
$pgv_lang["ahnentafel_christened_m"] = "βαφτίστηκε";	// male
$pgv_lang["ahnentafel_christened_f"] = "βαφτίστηκε";	// female
$pgv_lang["ahnentafel_married_m"]	= "παντρεύτηκε";			// male
$pgv_lang["ahnentafel_married_f"]	= "παντρεύτηκε";			// female
$pgv_lang["ahnentafel_died_m"]		= "πέθανε";				// male
$pgv_lang["ahnentafel_died_f"]		= "πέθανε";				// female
$pgv_lang["ahnentafel_buried_m"]	= "ενταφιάστηκε";			// male
$pgv_lang["ahnentafel_buried_f"]	= "ενταφιάστηκε";			// female
$pgv_lang["ahnentafel_place"]		= "σε";				// place name follows this
$pgv_lang["ahnentafel_no_details"]	= "αλλά οι λεπτομέρειες είναι άγνωστες";
$pgv_lang["changes_pending_tot"]	= "Σύνολο εκκρεμών αλλαγών:";
$pgv_lang["changes_accepted_tot"]	= "Σύνολο δεκτών αλλαγών:";
$pgv_lang["descendancy_header"]		= "Αναφορά απογόνων για";
$pgv_lang["with"]					= "με";
$pgv_lang["in"]						= "σε";			// for imprecise dates
$pgv_lang["on"]						= "από";			// for precise dates
$pgv_lang["deathplace"]				= "Η τοποθεσία θανάτου περιέχει";
$pgv_lang["deathdate1"]				= "Αρχή εύρους ημερομηνιών θανάτου";
$pgv_lang["deathdate2"]				= "Τέλος εύρους ημερομηνιών θανάτου";
$pgv_lang["marrplace"]				= "Η τοποθεσία γάμου περιέχει";
$pgv_lang["marrdate1"]				= "Αρχή εύρους ημερομηνιών γάμου";
$pgv_lang["marrdate2"]				= "Τέλος εύρους ημερομηνιών γάμου";
$pgv_lang["cemetery_report"]		= "Αναφορά νεκροταφείων";
$pgv_lang["show_stats_charts"]		= "Εμφάνιση διαγραμμάτων στατιστικών";
$pgv_lang["decade_birth"]			= "Δεκαετία γέννησης";
$pgv_lang["decade_death"]			= "Δεκαετία θανάτου";
$pgv_lang["decade_marriage"]		= "Δεκαετία γάμου";
$pgv_lang["avg_age"]				= "Μέσος όρος ηλικίας";
$pgv_lang["chart_list"]			= "Κατάλογος";
$pgv_lang["chart_booklet"]   	= "Φυλλάδιο";
$pgv_lang["show_cousins"]			= "Εμφάνιση ξαδερφιών";
$pgv_lang["sosa_paternal_male_n_generations"]	= "%3\$d x προπαππούς (από πατέρα)";
$pgv_lang["sosa_paternal_female_n_generations"]	= "%3\$d x προγιαγιά (από πατέρα)";
$pgv_lang["sosa_maternal_male_n_generations"]	= "%3\$d x προπαππούς (από μητέρα)";
$pgv_lang["sosa_maternal_female_n_generations"]	= "%3\$d x προγιαγιά (από μητέρα)";
$pgv_lang["fanchart_IE"]			= "Η εικόνα του διαγράμματος βεντάλιας δεν μπορεί να εκτυπωθεί απευθείας από τον φυλλομετρητή σας. Χρησιμοποιήστε δεξί κλικ και μετά αποθηκεύστε και εκτυπώστε.";
$pgv_lang["rss_feeds"]				= "Τροφοδοσίες RSS";
$pgv_lang["no_feed_title"]			= "Η τροφοδοσία δεν είναι διαθέσιμη";
$pgv_lang["no_feed"]				= "Δεν υπάρχει διαθέσιμη τροφοδοσία RSS για αυτή την τοποθεσία PhpGedView";
$pgv_lang["feed_login"]				= "Εάν έχετε λογαριασμό σε αυτή την τοποθεσία PhpGedView, μπορείτε να <a href=\"#AUTH_URL#\">συνδεθείτε</a> στον εξυπηρετητή με χρήση Βασικής Πιστοποίησης HTTP για προβολή ιδιωτικών πληροφοριών.";
$pgv_lang["authenticated_feed"]		= "Πιστοποιημένη τροφοδοσία";
$pgv_lang["attendant"] = "Ακόλουθος";
$pgv_lang["attending"] = "Παρακολούθηση";
$pgv_lang["bridesmaid"] = "Παρανυφάκι";
$pgv_lang["buyer"] = "Αγοραστής";
$pgv_lang["employer"] = "Εργοδότης";
$pgv_lang["employee"] = "Εργαζόμενος";
$pgv_lang["friend"] = "Φίλος";
$pgv_lang["best_man"] = "Κουμπάρος";
$pgv_lang["circumciser"] = "Διενεργών περιτομές";
$pgv_lang["civil_registrar"] = "Πολιτικός ληξίαρχος";
$pgv_lang["godfather"] = "Νονός";
$pgv_lang["godmother"] = "Νονά";
$pgv_lang["godparent"] = "Ανάδοχος";
$pgv_lang["godson"]		= "Βαφτισιμιός";
$pgv_lang["goddaughter"] = "Βαφτισιμιά";
$pgv_lang["godchild"]	= "Βαφτιστήρι";
$pgv_lang["informant"] = "Πληροφοριοδότης";
$pgv_lang["lodger"] = "Ένοικος";
$pgv_lang["nurse"] = "Νοσηλευτής";
$pgv_lang["owner"] = "Κάτοχος";
$pgv_lang["priest"] = "Ιερέας";
$pgv_lang["rabbi"] = "Ραββίνος";
$pgv_lang["registry_officer"] = "Υπάλληλος αρχείου";
$pgv_lang["seller"] = "Πωλητής";
$pgv_lang["servant"] = "Υπηρέτης";
$pgv_lang["slave"] = "Δούλος";
$pgv_lang["twin"] = "Δίδυμος";
$pgv_lang["twin_brother"] = "Δίδυμος αδερφός";
$pgv_lang["twin_sister"] = "Δίδυμη αδερφή";
$pgv_lang["witness"] = "Μάρτυρας";
$pgv_lang["statutci"]			= "δεν ήταν δυνατό να δημιουργηθεί ευρετήριο";
$pgv_lang["stat_sindi"]			= "Άτομα με συζύγους";
$pgv_lang["stat_sfam"]			= "Οικογένειες με πηγές";
$pgv_lang["statvars"]			= "Συμπληρώστε τις παρακάτω παραμέτρους για τη σχεδίαση";
$pgv_lang["statlxa"]			= "Επιλογή τύπου διαγράμματος:";
$pgv_lang["statlya"]			= "αποτελέσματα:";
$pgv_lang["statlza"]			= "Κατηγορίες:";
$pgv_lang["map_type"]			= "Τύπος χάρτη";
$pgv_lang["stat_1_map"]			= "Κατανομή ατόμων";
$pgv_lang["stat_2_map"]			= "Γεννήσεις ανά χώρα";
$pgv_lang["stat_3_map"]			= "Θάνατοι ανά χώρα";
$pgv_lang["stat_4_map"]			= "Γάμοι ανά χώρα";
$pgv_lang["stat_8_fam"]			= "Οικογένειες με συζύγους";
$pgv_lang["stat_9_indi"]		= "Άτομα με πηγές";
$pgv_lang["stat_10_none"]		= "κανένα";
$pgv_lang["stat_11_mb"]			= "Μήνας γέννησης";
$pgv_lang["stat_12_md"]			= "Μήνας θανάτου";
$pgv_lang["stat_13_mm"]			= "Μήνας γάμου";
$pgv_lang["stat_14_mb1"]		= "Μήνας γέννησης του πρώτου παιδιού με συσχέτιση";
$pgv_lang["stat_15_mm1"]		= "Μήνας του πρώτου γάμου";
$pgv_lang["stat_16_mmb"]		= "Μήνες μεταξύ γάμου και πρώτου παιδιού";
$pgv_lang["stat_17_arb"]		= "Ηλικία σε σχέση με το έτος γέννησης";
$pgv_lang["stat_18_ard"]		= "Ηλικία σε σχέση με το έτος θανάτου";
$pgv_lang["stat_19_arm"]		= "Ηλικία στο έτος του γάμου";
$pgv_lang["stat_20_arm1"]		= "Ηλικία στο έτος του πρώτου γάμου";
$pgv_lang["stat_21_nok"]		= "Αριθμός παιδιών";
$pgv_lang["stat_200_none"]		= "όλα (ή κενό)";
$pgv_lang["stat_201_num"]		= "αριθμοί";
$pgv_lang["stat_202_perc"]		= "ποσοστό";
$pgv_lang["stat_301_mf"]		= "φύλο";
$pgv_lang["stat_300_none"]		= "κανένα";
$pgv_lang["europe_chart"]		= "Ευρώπη";
$pgv_lang["s_america_chart"]	= "Νότια Αμερική";
$pgv_lang["asia_chart"]			= "Ασία";
$pgv_lang["middle_east_chart"]	= "Μέση Ανατολή";
$pgv_lang["africa_chart"]		= "Αφρική";
$pgv_lang["world_chart"]		= "Κόσμος";
$pgv_lang["preview"] =  "Προεπισκόπηση";
$pgv_lang["hs_search"] 			= "Αναζήτηση";
$pgv_lang["TYPE__magazine"] = "Περιοδικό";
$pgv_lang["TYPE__manuscript"] = "Χειρόγραφο";
$pgv_lang["TYPE__map"] = "Χάρτης";
$pgv_lang["TYPE__film"] = "Μικροφίλμ";
$pgv_lang["TYPE__document"] = "Έγγραφο";
$pgv_lang["TYPE__coat"] = "Θυρεός";
$pgv_lang["TYPE__video"] = "Βίντεο";
$pgv_lang["sort_column"] = "Ταξινόμηση με βάση αυτή τη στήλη.";
$pgv_lang["statar_xgp"]			= "όρια για τις περιόδους:";
$pgv_lang["stat_302_cgp"]		= "Ημερομηνία περιόδων";
$pgv_lang["statar_xgl"]			= "όρια για τις ηλικίες:";
$pgv_lang["statar_xgm"]			= "όρια για το μήνα:";
$pgv_lang["statar_xga"]			= "όρια για τους αριθμούς:";
$pgv_lang["statar_zgp"]			= "όρια για περιόδους ημερομηνιών:";
$pgv_lang["less"]				= "λιγότερο από";
$pgv_lang["over"]				= "πάνω από";
$pgv_lang["interval"]			= "μεσοδιάστημα";
$pgv_lang["aft_marr"]			= "μήνες μετά το γάμο";
$pgv_lang["bef_marr"]			= "μήνες πριν και μετά το γάμο";
$pgv_lang["quarters"]			= "τρίμηνα μετά το γάμο";
$pgv_lang["half_year"]			= "εξάμηνο μετά το γάμο";
$pgv_lang["two_children"]		= "μεσοδιάστημα δύο παιδιά";
$pgv_lang["one_child"]			= "μεσοδιάστημα ένα παιδί";
$pgv_lang["statreset"]			= "επαναφορά";
$pgv_lang["statsubmit"]			= "εμφάνιση της σχεδίασης";
$pgv_lang["statistiek_list"]	= "Σχεδίαση στατιστικών";
$pgv_lang["stpl"]			 	= "...";
$pgv_lang["stplinfo"]			= "πληροφορίες σχεδίασης:";
$pgv_lang["stpltype"]			= "τύπος:";
$pgv_lang["stplnoim"]			= "δεν παρέχεται:";
$pgv_lang["stplmf"]			 	= "ανά φύλο";
$pgv_lang["stplipot"]			= "ανά χρονική περίοδο";
$pgv_lang["stplmonth"]			= "μήνας";
$pgv_lang["stplnuch"]			= "παιδιά";
$pgv_lang["stplage"]			= "ηλικία";
$pgv_lang["stplperc"]			= "ποσοστό";
$pgv_lang["stplnumof"]			= "Μετρήσεις";
$pgv_lang["stplmarrbirth"]		= "Μήνες μεταξύ γάμου και γέννησης του πρώτου παιδιού";
$pgv_lang["indi_distribution_chart"]	= "Διάγραμμα κατανομής ατόμων";
$pgv_lang["surname_distribution_chart"]	= "Διάγραμμα κατανομής επωνύμων";
$pgv_lang["g_chart_high"]		= "Υψηλότερος πληθυσμός";
$pgv_lang["g_chart_low"]		= "Χαμηλότερος πληθυσμός";
$pgv_lang["g_chart_nobody"]		= "Απολύτως κανένας";
$pgv_lang["area_chart"]			= "Γεωγραφική περιοχή";
$pgv_lang["alive_in_year"]			= "Ζωντανοί στο έτος";
$pgv_lang["is_alive_in"]			= "Είναι ζωντανός το #YEAR#";
$pgv_lang["alive"]					= "Ζωντανός";
$pgv_lang["dead"]					= "Νεκρός";
$pgv_lang["maybe"]					= "Ίσως";
$pgv_lang["both_dead"]				= "Και οι δύο νεκροί";
$pgv_lang["both_alive"]				= "Και οι δύο ζωντανοί";
$pgv_lang["definitions"]			= "Ορισμοί";
$pgv_lang["block_desc"]				= "Πλαίσιο περιγραφών";
$pgv_lang["click_here_help"]		= "~#pgv_lang[click_here]#~<br /><br />Επιλέξτε αυτό το πλήκτρο για να αποθηκεύσετε τις αλλαγές.<br /><br />Θα επιστραφείτε στην σελίδα #pgv_lang[welcome]# ή #pgv_lang[mygedview]#, αλλά οι αλλαγές μπορεί να μην εμφανιστούν. Μπορεί να χρειαστεί να χρησιμοποιήσετε τη λειτουργία Ανανέωση σελίδας στον φυλλομετρητή σας, για να προβάλετε τις αλλαγές σωστά.";
$pgv_lang["block_summaries"]		= "~#pgv_lang[block_desc]#~<br /><br />Εδώ υπάρχει μια σύντομη περιγραφή του κάθε πλαισίου που μπορείτε να τοποθετήσετε στη σελίδα #pgv_lang[welcome]# ή #pgv_lang[mygedview]#.<br /><table border='1' align='center'><tr><td class='list_value'><b>#pgv_lang[name]#</b></td><td class='list_value'><b>#pgv_lang[description]#</b></td></tr>#pgv_lang[block_summary_table]#</table><br /><br />";
$pgv_lang["total_places"]			= "Ευρεθείσες τοποθεσίες";
$pgv_lang["block_summary_table"]	= "&nbsp;";
$pgv_lang["media_contains"]			= "Το μέσο περιέχει:";
$pgv_lang["repo_contains"]			= "Ο χώρος φύλαξης περιέχει:";
$pgv_lang["shared_note_contains"]	= "Η κοινόχρηστη σημείωση περιέχει:";
$pgv_lang["source_contains"]		= "Η πηγή περιέχει:";
$pgv_lang["display_all"]			= "Εμφάνιση όλων";
$pgv_lang["add_faq_header"] = "Κεφαλίδα συχνής ερώτησης";
$pgv_lang["add_faq_body"] = "Σώμα συχνής ερώτησης";
$pgv_lang["add_faq_order"] = "Θέση συχνής ερώτησης";
$pgv_lang["add_faq_visibility"] = "Ορατότητα συχνής ερώτησης";
$pgv_lang["no_faq_items"] = "Η λίστα συχνών ερωτήσεων είναι άδεια.";
$pgv_lang["position_item"] = "Θέση αντικειμένου";
$pgv_lang["faq_list"] = "Λίστα συχνών ερωτήσεων (FAQ)";
$pgv_lang["confirm_faq_delete"] = "Σίγουρα θέλετε να διαγράψετε αυτή την καταχώρηση συχνής ερώτησης;";
$pgv_lang["no_id"] = "Δεν έχει ορισθεί ID συχνής ερώτησης !";
$pgv_lang["hs_title"] 			= "Αναζήτηση κειμένου βοήθειας";
$pgv_lang["hs_close"] 			= "Κλείσιμο παραθύρου";
$pgv_lang["hs_results"] 		= "Ευρεθέντα αποτελέσματα:";
$pgv_lang["hs_keyword"] 		= "Αναζήτηση για";
$pgv_lang["hs_searchin"]		= "Αναζήτηση σε";
$pgv_lang["hs_searchuser"]		= "Βοήθεια χρήστη";
$pgv_lang["hs_searchmodules"]	= "Βοήθεια αρθρωμάτων";
$pgv_lang["hs_searchconfig"]	= "Βοήθεια διαχειριστή";
$pgv_lang["hs_searchhow"]		= "Τύπος αναζήτησης";
$pgv_lang["hs_searchall"]		= "Όλες οι λέξεις";
$pgv_lang["hs_searchany"]		= "Οποιαδήποτε λέξη";
$pgv_lang["hs_searchsentence"]	= "Ακριβής φράση";
$pgv_lang["hs_inallhelp"]		= "Όλο το κείμενο";
$pgv_lang["hs_intruehelp"]		= "Μόνο στο κείμενο βοήθειας";
$pgv_lang["choose"] = "Επιλογή:";
$pgv_lang["account_information"] = "Πληροφορίες λογαριασμού";
$pgv_lang["TYPE__audio"] = "Ήχος";
$pgv_lang["TYPE__book"] = "Βιβλίο";
$pgv_lang["TYPE__card"] = "Κάρτα";
$pgv_lang["TYPE__certificate"] = "Πιστοποιητικό";
$pgv_lang["TYPE__electronic"] = "Ηλεκτρονικά";
$pgv_lang["TYPE__fiche"] = "Μικροδιαφάνεια";
$pgv_lang["TYPE__newspaper"] = "Εφημερίδα";
$pgv_lang["TYPE__photo"] = "Φωτογραφία";
$pgv_lang["TYPE__tombstone"] = "Επιτύμβια πλάκα";
$pgv_lang["TYPE__painting"] = "Ζωγραφιά";
$pgv_lang["TYPE__other"] = "Άλλο";
$pgv_lang["view_slideshow"] 		= "Προβολή ως ολισθαίνουσα παρουσίαση";
$pgv_lang["download_image"]			= "Λήψη αρχείου";
$pgv_lang["no_media"]				= "Δεν βρέθηκε μέσο";
$pgv_lang["media_privacy"]			= "Περιορισμοί ιδιωτικότητας σας εμποδίζουν να προβάλετε αυτό το αντικείμενο";
$pgv_lang["relations_heading"]		= "Η εικόνα σχετίζεται με:";
$pgv_lang["file_size"]				= "Μέγεθος αρχείου";
$pgv_lang["img_size"]				= "Μέγεθος εικόνας";
$pgv_lang["media_broken"]			= "Αυτό το αρχείο μέσου είναι κατεστραμμένο και δεν μπορεί να υδατογραφηθεί.";
$pgv_lang["unknown_mime"]			= "Σφάλμα του τοίχου προστασίας: >Άγνωστο Mimetype< για το αρχείο";
$pgv_lang["module_error_unknown_action_v2"] = "Άγνωστη ενέργεια: [action].";
$pgv_lang["module_error_unknown_type"] = "Άγνωστος τύπος αρθρώματος.";
$pgv_lang["button_alive_in_year"] = "Εμφάνιση ζωντανών ατόμων κατά το υποδεικνυόμενο έτος.";
$pgv_lang["button_BIRT_Y100"] = "Εμφάνιση ατόμων γεννημένων τα τελευταία 100 χρόνια.";
$pgv_lang["button_BIRT_YES"] = "Εμφάνιση ατόμων γεννημένων περισσότερο από 100 χρόνια πριν.";
$pgv_lang["button_DEAT_H"] = "Εμφάνιση ζευγαριών όπου μόνο ο αρσενικός σύντροφος απεβίωσε.";
$pgv_lang["button_DEAT_N"] = "Εμφάνιση ατόμων που είναι ζωντανά ή ζευγαριών όπου και οι δύο σύντροφοι ζουν.";
$pgv_lang["button_DEAT_W"] = "Εμφάνιση ζευγαριών όπου μόνο η θηλυκή σύντροφος απεβίωσε.";
$pgv_lang["button_DEAT_Y"] = "Εμφάνιση ατόμων που έχουν πεθάνει ή ζευγαριών όπου και οι δύο σύντροφοι απεβίωσαν.";
$pgv_lang["button_DEAT_Y100"] = "Εμφάνιση ατόμων που πέθαναν μέσα στα τελευταία 100 χρόνια.";
$pgv_lang["button_DEAT_YES"] = "Εμφάνιση ατόμων που πέθαναν περισσότερο από 100 χρόνια πριν.";
$pgv_lang["button_MARR_DIV"] = "Εμφάνιση διαζευγμένων ζευγαριών.";
$pgv_lang["button_MARR_U"] = "Εμφάνιση ζευγαριών με άγνωστη ημερομηνία γάμου.";
$pgv_lang["button_MARR_Y100"] = "Εμφάνιση ζευγαριών που παντρεύτηκαν μέσα στα τελευταία 100 χρόνια.";
$pgv_lang["button_MARR_YES"] = "Εμφάνιση ζευγαριών που παντρεύτηκαν περισσότερο από 100 χρόνια πριν.";
$pgv_lang["button_reset"] = "Επαναφορά στις προεπιλογές της λίστας.";
$pgv_lang["button_SEX_F"] = "Εμφάνιση μόνο θηλυκών.";
$pgv_lang["button_SEX_M"] = "Εμφάνιση μόνο αρσενικών.";
$pgv_lang["button_SEX_U"] = "Εμφάνιση μόνο ατόμων αγνώστου φύλου.";
$pgv_lang["button_TREE_L"] = "Εμφάνιση «φύλλων», ζευγαριών ή ατόμων. Αυτά είναι άτομα που είναι ζωντανά αλλά δεν έχουν καταχωρημένα παιδιά στην βάση δεδομένων.";
$pgv_lang["button_TREE_R"] = "Εμφάνιση «ριζών», ζευγάρια ή άτομα. Αυτά τα άτομα μπορούν επίσης να αποκαλεστούν «πατριάρχες». Είναι άτομα που δεν έχουν γονείς καταχωρημένους στην βάση δεδομένων.";
$pgv_lang["ellipsis"]				= "\xE2\x80\xA6";
$pgv_lang["stat_link"]				= "Προβολή στατιστικών ως γράφημα";
$pgv_lang["print_stat_link"]		= "Εμφάνιση συνδέσμου στα διαγράμματα στατιστικών;";
$pgv_lang["yahrzeit_block"]			= "Επερχόμενο Yahrzeiten";
$pgv_lang["yahrzeit_descr"]			= "Το πλαίσιο Επερχόμενα Yahrzeiten, εμφανίζει επετείους ή ημερομηνίες θανάτων που συμβαίνουν στο κοντινό μέλλον. Μπορείτε να ρυθμίσετε την εμφανιζόμενη περίοδο, και ο διαχειριστής μπορεί να ρυθμίσει πόσο μακρυά στο μέλλον θα κοιτάζει αυτό το πλαίσιο.";
$pgv_lang["stplnumbers"]		= "αριθμοί";
?>
