<?php
/**
 * Serbian Language file for PhpGedView.
 *
 * PhpGedView: Genealogy Viewer
 * Copyright (C) 2009 to 2010  PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @translator Vojin Damjanac
 * @version $Id: help_text.sr.php 6989 2010-11-09 03:26:25Z canajun2eh $
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

##$pgv_lang["help_treenav.php"]		= "~#pgv_lang[interactive_tree]#~<br />Use the #pgv_lang[interactive_tree]# to view the entire family tree of a person in both directions.  This view is similar to the Hourglass view in that it shows both ancestors and descendants of a given root person.  This chart gives you a more compact view by showing boxes for couples or families instead of just individuals.<br /><ul><li><b>Scrolling</b><br />Whenever your mouse cursor changes to a Move icon, you can click and drag the tree to view other portions of the tree.  As you drag the tree future generations will automatically expand until there are no more generations left to view in that direction.<br /></li><li><b>Zoom</b><br />You can use the icons on the left of the tree to zoom in and out.  Zooming out will allow you to see more of the tree on the screen at a time.  As you zoom out the text can become difficult to read; when your mouse hovers over a box you will get an enlarged view of what is inside it.<br /></li><li><b>Expanding Details</b><br />Clicking on any box will expand the box and display a more detailed view.  While in expanded mode, clicking on a person's name will open their #pgv_lang[indi_info]# page.  Clicking <img src='#GLOBALS[PGV_IMAGE_DIR]#/small/gedcom.gif' width='15px' height='15px' alt='' /> will redraw the tree with that person as the new root.  Clicking <img src='#GLOBALS[PGV_IMAGE_DIR]#/buttons/family.gif' alt='' /> will take you to that family's detail page.<br /></li><li><b>Toggle Spouses</b><br />The <img src='#GLOBALS[PGV_IMAGE_DIR]#/small/sfamily.gif' width='15px' height='15px' alt='' /> icon directly under the Zoom buttons will toggle the display of all spouses on or off on the descendancy side.  When the display is set to show spouses, all of a person's spouses will appear in the box with them.  All of the person's children will be shown as well.  When the option to show spouses is off, only the person's last spouse and children with that spouse will be shown.<br /></li><li><b>Large Tree</b><br />The #pgv_lang[interactive_tree]# is available from many different pages including the Tree tab on the #pgv_lang[indi_info]# page and the Charts block on the Welcome page.  When viewing the tree from one of these other pages, you will also have a Tree icon under the Zoom icons.  If you click <img src='#GLOBALS[PGV_IMAGE_DIR]#/small/gedcom.gif' width='15px' height='15px' alt='' /> you will be taken to the #pgv_lang[interactive_tree]# page.</li></ul><br />";

##$pgv_lang["move_mediadirs_help"]	= "~#pgv_lang[move_mediadirs]#~<br />When the Media Firewall is enabled, Multi-Media files can be stored in a server directory that is not accessible from the Internet.<br /><br />These buttons allow you to easily move an entire Media directory structure between the protected (not web-addressable) <b>#GLOBALS[MEDIA_FIREWALL_ROOTDIR]##GLOBALS[MEDIA_DIRECTORY]#</b> and the normal <b>#GLOBALS[MEDIA_DIRECTORY]#</b> directories.<br /><br />"; 
##$pgv_lang["setperms_help"]			= "~#pgv_lang[setperms]#~<br />Recursively set the permissions on the protected (not web-addressable) <b>#GLOBALS[MEDIA_FIREWALL_ROOTDIR]##GLOBALS[MEDIA_DIRECTORY]#</b> and the normal <b>#GLOBALS[MEDIA_DIRECTORY]#</b> directories to either world-writable or read-only.<br /><br />"; 
##$pgv_lang["no_update_CHAN_help"] 	= "~#pgv_lang[no_update_CHAN]#~<br />Administrators sometimes need to clean up and correct the data submitted by users.  For example, they might need to correct the PLAC location to include the country.  When Administrators make such corrections, information about the original change is normally replaced.  This may not be desirable.<br /><br />When this option is selected, PhpGedView will retain the original Change information instead of replacing it with that of the current session.  With this option selected, Administrators also have the ability to modify or delete the information associated with the original CHAN tag.<br /><br />";
##$pgv_lang["edit_SOUR_EVEN_help"]	= "~#pgv_lang[source_events]#~<br /><br />Each source records specific events, generally for a given date range and for a place jurisdiction.  For example a Census records census events and church records record birth, marriage, and death events.<br /><br />Select the events that are recorded by this source from the list of events provided. The date should be specified in a range format such as <i>FROM 1900 TO 1910</i>. The place jurisdiction is the name of the lowest jurisdiction that encompasses all lower-level places named in this source. For example, \"Oneida, Idaho, USA\" would be used as a source jurisdiction place for events occurring in the various towns within Oneida County. \"Idaho, USA\" would be the source jurisdiction place if the events recorded took place not only in Oneida County but also in other counties in Idaho.<br /><br />";
##$pgv_lang["cache_life_help"]		= "~#pgv_lang[cache_life]#~<br /><br />To improve performance, this PhpGedCom Welcome Page block is saved as a cache file.  You can control how often this block's cache file is refreshed.<br /><br /><ul><li><b>-1</b> means that the cache file is never refreshed automatically.  To get a fresh copy, you need to delete all cache files.  You can do this on the Customize Welcome Page page.</li><li><b>0</b> (Zero) means that this block is never cached, and every time the block is displayed on the PhpGedView Welcome page, you see a fresh copy.  This setting is used automatically for blocks that change frequently, such as the #pgv_lang[logged_in_users_block]# and the #pgv_lang[random_media_block]# blocks.</li><li><b>1</b> (One) means that a fresh copy of this block's cache file is created daily, <b>2</b> means that a fresh copy is created every two days, <b>7</b> means that a fresh copy is created weekly, etc.</li></ul><br /><br />";
##$pgv_lang["clear_cache_help"]		= "~#pgv_lang[clear_cache]#~<br /><br />In order to improve performance, several of the blocks on the PhpGedView Welcome page are saved as cache files in the index directory.  The cache files for most blocks are refreshed once each day, but there may be times when you want to refresh them manually.<br /><br />This button allows you to refresh the cache files when necessary.";
##$pgv_lang["import_options_help"] 	= "You can choose additional options to be used when importing the GEDCOM.";
##$pgv_lang["verify_gedcom_help"]	= "Here you can choose to either continue with the upload and import of this GEDCOM file or to abort the upload and import.";
##$pgv_lang["add_gedcom_instructions"]= "Enter a file name for this new GEDCOM.  The new GEDCOM file will be created in the Index directory: #INDEX_DIRECTORY#";
##$pgv_lang["random_media_start_slide_help"]			= "~#pgv_lang[random_media_start_slide]#~<br /><br />Should the slideshow start automatically when the page is loaded.<br /><br />The slideshow changes the contents of the block without preloading information from the server and without reloading the entire page.<br /><br />";
##$pgv_lang["random_media_ajax_controls_help"]	= "~#pgv_lang[random_media_ajax_controls]#~<br /><br />You can use this setting to show or hide the slideshow controls of the Random Media block.<br /><br />These controls allow the user to jump to another random object or to play through randomly selected media like a slideshow. The slideshow changes the contents of the block without preloading information from the server and without reloading the entire page.<br /><br />";
##$pgv_lang["edit_add_unlinked_source_help"]	= "~#pgv_lang[add_unlinked_source]#~<br /><br />Use this link to add a new source to your database without linking the source to a source citation in another record.  The new source will appear in the source list, but will not appear on any charts or anywhere else in the program until it is linked up to a source citation.";
##$pgv_lang["link_person_id_help"]	= "~#pgv_lang[label_local_id]#~<br /><br />In this field you enter the ID of the person you are linking to (e.g. I100).";
##$pgv_lang["link_gedcom_id_help"]	= "~#pgv_lang[label_gedcom_id]#~<br /><br />Use this section to select the alternate database identifier that contains the the person you are linking to.";
##$pgv_lang["link_remote_site_help"]	= "~#pgv_lang[label_site]#~<br /><br />In this section you specify the parameters that are required to connect to the remote site hosting the data you are linking to. You have the option of choosing from a list of known sites that you have used before, or entering the #pgv_lang[label_site_url2]# and #pgv_lang[label_gedcom_id]# for a new one.<br /><br />In the <b>#pgv_lang[label_site_url2]#</b> field, you enter the URL to access the web services description file (WDSL) which tells PhpGedView how to access the data on the remote site.  For a remote PhpGedView website, the URL to the WSDL file will look like this: <u>http://www.remotesite.com/phpGedView/genservice.php?wsdl</u><br /><br />The <b>#pgv_lang[label_gedcom_id]#</b> field is used to enter an optional database identifier for remote sites that require one.  For PhpGedView sites, this is the name of the GEDCOM file. <br /><br />The <b>#pgv_lang[label_username_id]#</b> and the <b>#pgv_lang[label_password_id]#</b> fields are necessary if the database requires it.<br /><br /><i>Note: Remote PhpGedView sites must be running version 4.0 or later; earlier versions do not have this capability.</i>";
##$pgv_lang["link_remote_location_help"]	= "~#pgv_lang[label_location]#~<br /><br />This option allows you to choose whether data for the person you are linking to is on the same site but in a different genealogical database set, or whether the data is on a different site accessible through the Internet.<br /><br />If the person is on the same site, you will be asked to select the dataset identifier and enter the person's ID.<br /><br />For a remote site, you will be asked to enter its URL, a database identifier, and the person's remote ID.";
##$pgv_lang["link_remote_rel_help"]	= "~#pgv_lang[label_rel_to_current]#~<br /><br />Use this option to select the relationship the remote person has to the person you are linking them with on your site.  For example, selecting <i>Father</i> would mean that the person on the remote site is the father of the person you are linking them to locally.";
##$pgv_lang["link_remote_help"]       = "~#pgv_lang[link_remote]#~<br /><br />Use this form to link people to other people either from another site or another genealogical database accessible to your copy of PhpGedView.<br /><br />To add such a link, you must first select the relationship type, then choose a site already known to PhpGedView or define a new site, and then enter that site's ID of the person you want to link to.  PhpGedView will then automatically download information from the remote site as necessary.  The downloaded information does <u>not</u> become part of your genealogical database; it remains on the original site but is incorporated into the various pages where this remotely linked person is displayed.<br /><br />Refer to the Help link next to each element on the page for more information about that element.  You can also check the online English tutorial for more information: <a href=\"#PGV_PHPGEDVIEW_WIKI#/en/index.php?title=How_To:Remote_Link_Individuals_Across_Websites_And_Databases\" target=\"_blank\">#PGV_PHPGEDVIEW_WIKI#</a>.";

//-- Edit Interface
##$pgv_lang["edit_ABBR_help"]			= "~ABBREVIATED TITLE~<br /><br />Use this field for storing an abbreviated version of a title.  This field is used in conjunction with the title field on sources.  By default PGV will first use the title and then the abbreviated title.<br /><br />According to the GEDCOM 5.5 specification, \"this entry is to provide a short title used for sorting, filing, and retrieving source records (pg 62).\"<br /><br />In PhpGedView the abbreviated title is optional, but in other genealogical programs it is required.";
##$pgv_lang["edit_ROMN_help"]			= "~ROMANIZED NAME~<br /><br />In many cultures it is customary to have a traditional name spelled in the traditional characters and also a romanized version of the name as it would be spelled or pronounced in languages based on the Latin alphabet, such as English.<br /><br />If you prefer to use a non-Latin alphabet such as Hebrew, Greek, Russian, Chinese, or Arabic to enter the name in the standard name fields, then you can use this field to enter the same name using the Latin alphabet.  Both versions of the name will appear in lists and charts.<br /><br />Although this field is labelled \"Romanized\", it is not restricted to containing only characters based on the Latin alphabet.  This might be of use with Japanese names, where three different alphabets may occur.";
##$pgv_lang["edit_ROMN_GIVN_help"]	= "#pgv_lang[edit_ROMN_help]#<br /><br />In this field you should enter the given names for the person.  As an example, in the name \"John Robert Finlay\", the given names that should be entered here are \"John Robert\"<br /><br />";
##$pgv_lang["edit_ROMN_SURN_help"]	= "#pgv_lang[edit_ROMN_help]#<br /><br />In this field you should enter the surname for the person.  As an example, in the name \"John Robert Finlay\", the surname that should be entered here is \"Finlay\"<br /><br />Individuals with multiple surnames, common in Spain and Portugal, should separate the surnames with a comma.  This indicates that the person is to be listed under each of the names.  For example, the surname \"Cortes,Vega\" will be listed under both <b>C</b> and <b>V</b>, whereas the surname \"Cortes Vega\" will only be listed under <b>C</b>.<br /><br />";
##$pgv_lang["edit__HEB_help"]			= "~HEBREW NAME~<br /><br />In many cultures it is customary to have a traditional name spelled in the traditional characters and also a romanized version of the name as it would be spelled or pronounced in languages based on the Latin alphabet, such as English.<br /><br />If you prefer to use the Latin alphabet to enter the name in the standard name fields, then you can use this field to enter the same name in the non-Latin alphabet such as Greek, Hebrew, Russian, Arabic, or Chinese.  Both versions of the name will appear in lists and charts.<br /><br />Although this field is labelled \"Hebrew\", it is not restricted to containing only Hebrew characters.";
##$pgv_lang["edit__HEB_GIVN_help"]	= "#pgv_lang[edit__HEB_help]#<br /><br />In this field you should enter the given names for the person.  As an example, in the name \"John Robert Finlay\", the given names that should be entered here are \"John Robert\"<br /><br />";
##$pgv_lang["edit__HEB_SURN_help"]	= "#pgv_lang[edit__HEB_help]#<br /><br />In this field you should enter the surname for the person.  As an example, in the name \"John Robert Finlay\", the surname that should be entered here is \"Finlay\"<br /><br />Individuals with multiple surnames, common in Spain and Portugal, should separate the surnames with a comma.  This indicates that the person is to be listed under each of the names.  For example, the surname \"Cortes,Vega\" will be listed under both <b>C</b> and <b>V</b>, whereas the surname \"Cortes Vega\" will only be listed under <b>C</b>.<br /><br />";
##$pgv_lang["edit_SEX_help"]			= "#pgv_lang[edit_sex_help]#";
##$pgv_lang["edit_NAME_help"]			= "#pgv_lang[edit_name_help]#";
##$pgv_lang["edit_add_unlinked_person_help"]	= "~#pgv_lang[add_unlinked_person]#~<br /><br />Use this form to add an unlinked person.<br /><br />When you add an unlinked person to your family tree, the person will not be linked to any other people until you link them.  Later, you can link people together from the #pgv_lang[relatives]# tab on the #pgv_lang[indi_info]# page.";
##$pgv_lang["edit_URL_help"]			= "Enter the URL address including the http://.<br /><br />An example URL looks like this: <b>http://www.phpgedview.net/</b> Leave this field blank if you do not want to include a URL.";
##$pgv_lang["edit_EMAIL_help"]		= "Enter the email address.<br /><br />An example email address looks like this: <b>name@hotmail.com</b>  Leave this field blank if you do not want to include an email address.";
##$pgv_lang["edit_FAX_help"]			= "Enter the FAX number including the country and area code.<br /><br />Leave this field blank if you do not want to include a FAX number.  For example, a number in Germany might be +49 25859 56 76 89 and a number in USA or Canada might be +1 888 555-1212.";
##$pgv_lang["edit_PHON_help"]			= "Enter the phone number including the country and area code.<br /><br />Leave this field blank if you do not want to include a phone number.  For example, a number in Germany might be +49 25859 56 76 89 and a number in USA or Canada might be +1 888 555-1212.";
##$pgv_lang["edit_ADDR_help"]			= "Enter the address into the field just as you would write it on an envelope.<br /><br />Leave this field blank if you do not want to include an address.";
##$pgv_lang["edit_GIVN_help"]			= "#pgv_lang[edit_given_name_help]#";
##$pgv_lang["edit_SPFX_help"]			= "~Surname Prefix~<br /><br />Enter or select from the list words that precede the main part of the Surname.  Examples of such words are <b>von</b> Braun, <b>van der</b> Kloot, <b>de</b> Graaf, etc.";
##$pgv_lang["edit_SURN_help"]			= "#pgv_lang[edit_surname_help]#";
##$pgv_lang["edit_NSFX_help"]			= "#pgv_lang[edit_suffix_help]#";
##$pgv_lang["edit__MARNM_help"]		= "~#factarray[_MARNM]#~<br /><br />Enter the married name for this person, using the same formatting rules that apply to the Name field.  This field is optional.<br /><br />For example, if Mary Jane Brown married John White, you might enter (without the quotation marks, of course)<ul><li>American usage:&nbsp;&nbsp;\"Mary Jane Brown /White/\"</li><li>European usage:&nbsp;&nbsp;\"Mary Jane /White/\"</li><li>Alternate European usage:&nbsp;&nbsp;\"Mary Jane /White-Brown/\" or \"Mary Jane /Brown-White/\"</li></ul>You should do this only if Mary Brown began calling herself by the new name after marrying John White.  In some places, Quebec (Canada) for example, it's illegal for names to be changed in this way.<br /><br />Men sometimes change their name after marriage, most often using the hyphenated form but occasionally taking the wife's surname.";
##$pgv_lang["edit_PEDI_help"]			= "~#factarray[PEDI]#~<br /><br />This field describes the relationship of the child to its family.  The possibilities are:<ul><li><b>#pgv_lang[unknown]#</b>&nbsp;&nbsp;&nbsp;The child's relationship to its family cannot be determined.  When this option is selected, the #factarray[PEDI]# field will not be copied into the database.<br /><br /></li><li><b>#factarray[BIRT]#</b>&nbsp;&nbsp;&nbsp;This option indicates that the child is related to its family by birth.<br /><br /></li><li><b>#pgv_lang[adopted]#</b>&nbsp;&nbsp;&nbsp;This option indicates that the child was adopted by its family.  This does <i>not</i> indicate that there is no blood relationship between the child and its family; it shows that the child was adopted by the family in question sometime after the child's birth.<br /><br /></li><li><b>#pgv_lang[foster]#</b>&nbsp;&nbsp;&nbsp;This option indicates that the child is a foster child of the family.  Usually, there is no blood relationship between the child and its family.<br /><br /></li><li><b>#pgv_lang[sealing]#</b>&nbsp;&nbsp;&nbsp;The child was sealed to its family in an LDS <i>sealing</i> ceremony.  A child sealing is performed when the parents were sealed to each other after the birth of the child.  Children born after the parents' sealing are automatically sealed to the family.<br /><br /></li></ul>";
##$pgv_lang["edit_AGNC_help"]			= "~#factarray[AGNC]#~<br /><br />The organization, institution, corporation, person, or other entity that has authority.<br /><br />For example, an employer of a person, or a church that administered rites or events, or an organization responsible for creating and/or archiving records.";

##$pgv_lang["context_help"]			= "More help is available by clicking the <b>?</b> next to items on the page.";

##$pgv_lang["register_gedcomid_help"]	= "~#pgv_lang[gedcomid]#~<br /><br />Every person in the database has a unique ID number on this site.  If you know the ID number for your own record, please enter it here.  If you don't know your ID number or could not find it because of privacy settings, please provide enough information in the Comments field to help the site administrator identify who you are on this site so that he can set the ID for you.<br /><br />";
##$pgv_lang["register_comments_help"]	= "~#pgv_lang[comments]#~<br /><br />Use this field to tell the site administrator why you are requesting an account and how you are related to the genealogy displayed on this site.  You can also use this to enter any other comments you may have for the site administrator.<br /><br />";
##$pgv_lang["utf8_ansi_help"]		= "~CONVERT FROM UTF-8 TO ANSI~<br /><br />For optimal display on the Internet, PhpGedView uses the UTF-8 character set.  Some programs, Family Tree Maker for example, do not support importing GEDCOM files encoded in UTF-8.  Checking this box will convert the file from <b>UTF-8</b> to <b>ANSI (ISO-8859-1)</b>.<br /><br />The format you need depends on the program you use to work with your downloaded GEDCOM file.  If you aren't sure, consult the documentation of that program.<br /><br />Note that for special characters to remain unchanged, you will need to keep the file in UTF-8 and convert it to your program's method for handling these special characters by some other means.  Consult your program's manufacturer or author.<br /><br />This <a href='http://en.wikipedia.org/wiki/UTF-8' target='_blank' title='Wikipedia article'><b>Wikipedia article</b></a> contains comprehensive information and links about UTF-8.<br /><br />";
##$pgv_lang["remove_tags_help"]	= "~REMOVE CUSTOM PGV TAGS~<br /><br />Checking this option will remove any custom tags that may have been added to the records by PhpGedView.<br /><br />Custom tags used by PhpGedView include the <b>_PGVU</b> tag which identifies the user who changed a record online and the <b>_THUM</b> tag which tells PhpGedView that the image should be used as a thumbnail.<br /><br />Custom tags may cause errors when importing the downloaded GEDCOM to another genealogy application.<br /><br />";
##$pgv_lang["download_zipped_help"]	= "~DOWNLOAD GEDCOM AS ZIP FILE~<br /><br />When you check this option, a copy of the GEDCOM file will be compressed into ZIP format before the download begins. This will reduce its size considerably, but you will need to use a compatible Unzip program (WinZIP, for example) to decompress the transmitted GEDCOM file before you can use it.<br /><br />This is a useful option for downloading large GEDCOM files.  There is a risk that the download time for the uncompressed file may exceed the maximum allowed execution time, resulting in incompletely downloaded files.  The ZIP option should reduce the download time by 75%.<br /><br />";
##$pgv_lang["remember_me_help"]	= "~REMEMBER ME~<br /><br />Checking this box when you login will allow PhpGedView to remember you the next time you visit so that you don't have to login again.  This feature will set a cookie on your computer which your browser will send back to the site the next time you visit.<br /><br />When you return to the site you will be able to access private information and user pages, but in order to edit or administer, you will be required to enter your username and password again.<br /><br /><b>You should not check this box if you are logging in from a public computer or from a computer that you share with others; anyone can return to PhpGedView as if they were you.</b>";
##$pgv_lang["edit_NCHI_help"]		= "~#factarray[NCHI]#~<br /><br />Enter the number of children for this individual or family. This is an optional field.<br /><br />";
##$pgv_lang["edit_TIME_help"]		= "~#factarray[TIME]#~<br /><br />Enter the time for this event in 24-hour format with leading zeroes. Midnight is 00:00. Examples: 04:50 13:00 20:30.<br /><br />";
##$pgv_lang["edit_NOTE_help"]		= "~#factarray[NOTE]#~<br /><br />Notes are free-form text and will appear in the Fact Details section of the page.<br /><br />";
##$pgv_lang["edit_CEME_help"]		= "~#factarray[CEME]#~<br /><br />Enter the name of the cemetery or other resting place where individual is buried.<br /><br />";
##$pgv_lang["edit_ASSO_help"]		= "~#factarray[ASSO]#~<br /><br />Enter associate GEDCOM ID.<br /><br />";
##$pgv_lang["edit_RELA_help"]		= "~#factarray[RELA]#~<br /><br />Select a relationship name from the list. Selecting <b>Godfather</b> means: <i>This associate is the Godfather of the current individual</i>.<br /><br />";
##$pgv_lang["show_spouse_help"]			= "~#pgv_lang[show_spouses]#~<br /><br />By default this chart does not show spouses for the descendants because it makes the chart harder to read and understand.  Turning this option on will show spouses on the chart.<br /><br />";
##$pgv_lang["reorder_families_help"]		= "~#pgv_lang[reorder_families]#~<br /><br />Families on the #pgv_lang[relatives]# tab are displayed in the order in which they appear in the individual's GEDCOM record.  Families are not sorted by the marriage date because often the marriage dates are unknown but the order of the marriages <u>is</u> known.<br /><br />This option will allow you to change the order of the families in which they are listed on the #pgv_lang[relatives]# tab.  If you want to sort the families by their marriage dates, there is a button you can press that will automatically do this for you.<br /><br />";
##$pgv_lang["autoContinue_help"]			= "~#pgv_lang[autoContinue]#~<br /><br />When PhpGedView detects that the GEDCOM Import requires more time than is permitted by the time limit, it will display a <b>#pgv_lang[del_proceed]#</b> button that you must press to continue the Import.<br /><br />When this option is set to <b>#pgv_lang[yes]#</b>, PhpGedView will automatically press the <b>#pgv_lang[del_proceed]#</b> button for you.  This should relieve the tedium of having to press the button repeatedly for lengthy Imports.<br /><br />";
##$pgv_lang["firstname_i_help"]		= "~#pgv_lang[firstname_alpha_index]#~<br /><br />The surname you have chosen has more than #GLOBALS[SUBLIST_TRIGGER_I]# individuals.<br /><br />To help you find the person you want, the list has been broken into smaller lists according to the first letter of the person's given name.  This alphabetical sub-index works the same as the alphabetical index for surnames.<br /><ul><li>Click a letter to see all of the first names which start with that letter.</li><li>Choose <b>#pgv_lang[NN]#</b> to list all of the persons with unknown first names.</li><li>Choosing <b>#pgv_lang[all]#</b> will display a list of all persons with the previously chosen surname.</li></ul>Because there are many names, it may take a long time for this list to appear on your screen.<br /><br />";
##$pgv_lang["firstname_f_help"]		= "~#pgv_lang[firstname_alpha_index]#~<br /><br />The family name you have chosen has more than #GLOBALS[SUBLIST_TRIGGER_F]# individuals.<br /><br />To help you find the family you want, the list has been broken into smaller lists according to the first letter of the person's given name.  This alphabetical sub-index works the same as the alphabetical index for names.<br /><ul><li>Click a letter to see all of the first names which start with that letter.</li><li>Choose <b>#pgv_lang[NN]#</b> to list all of the people with unknown first names.</li><li>Choosing <b>#pgv_lang[all]#</b> will display a list of all families with the previously chosen surname.</li></ul>Because there are many names, it may take a long time for this list to appear on your screen.<br /><br />";
##$pgv_lang["edit_TYPE_help"]		= "~#factarray[TYPE]#~<br /><br />The #factarray[TYPE]# field is used to enter additional information about the item.  In most cases, the field is completely free-form, and you can enter anything you want.<br /><br />";
##$pgv_lang["edit_TEMP_help"]		= "~#factarray[TEMP]#~<br /><br />For LDS ordinances, this field records the Temple where it was performed.<br /><br />";
##$pgv_lang["edit_STAT_help"]		= "~#factarray[STAT]#~<br /><br />This is an optional status field and is used mostly for LDS ordinances as they are run through the TempleReady program.<br /><br />";
##$pgv_lang["edit__PRIM_help"]		= "~#factarray[_PRIM]#~<br /><br />Use this field to signal that this media item is the highlighted or primary item for the person it is attached to.  The highlighted image is the one that will be used on charts and on the Individual page.<br /><br />";
##$pgv_lang["edit__THUM_help"]		= "~#factarray[_THUM]#~<br /><br />This field lets you override the usual selection for a thumbnail image.  You would not normally need to use this option, since PhpGedView will create properly sized thumbnails automatically whenever you upload an image.<br /><br />You can use this option to ensure that the image in question is displayed with sufficient detail whenever the real thumbnail is lacking in detail.  However, since you can always click on a thumbnail to see the related full-sized image, this option is probably not very useful.<br /><br />When this option is set to <b>Yes</b>, PhpGedView will use the specified image, regardless of its size, whenever a thumbnail is called for.  No checks are done on the size of the image; if it is not thumbnail-sized, the resulting display can be surprising.<br /><br />";
##$pgv_lang["edit_TITL_help"]		= "~#factarray[TITL]#~<br /><br />Enter a title for the item you are editing.  If this is a title for a multimedia item, enter a descriptive title that will identify that item to the user.<br /><br />";
##$pgv_lang["edit_FILE_help"]		= "~#factarray[FILE]#~<br /><br />This is the most important field in the multimedia object record.  It indicates which file to use. At the very minimum, you need to enter the file's name.  Depending on your settings, more information about the file's location may be helpful.<br /><br />You can use the <b>#pgv_lang[find_media]#</b> link to help you locate media items that have already been uploaded to the site.<br /><br />#pgv_lang[readme_help]#<br /><br />";
##$pgv_lang["edit_FORM_help"]		= "~#factarray[FORM]#~<br /><br />This is an optional field that can be used to enter the file format of the multimedia object.  Some genealogy programs may look at this field to determine how to handle the item.  However, since media do not transfer across computer systems very well, this field is not very important.<br /><br />";
##$pgv_lang["generate_thumb_help"]		= "~#pgv_lang[auto_thumbnail]#~<br /><br />Your system can generate thumbnails for certain types of images automatically.  There may be support for BMP, GIF, JPG, and PNG files.  The types that your system supports are listed beside the checkbox.<br /><br />By clicking this checkbox, you signal the system that you are uploading images of this type and that you want it to try to generate thumbnails for them.  Leave the box unchecked if you want to provide your own thumbnails.<br /><br />";
##$pgv_lang["edit_add_NOTE_help"]		= "~#pgv_lang[add_note]#~<br /><br />This section allows you to add a new Note to the fact that you are currently editing.  Notes are free-form text and will appear in the Fact Details section of the page.<br /><br />";
##$pgv_lang["edit_add_SOUR_help"]		= "~#pgv_lang[add_source]#~<br /><br />This section allows you to add a new source citation to the fact that you are currently editing.<br /><br />In the Source field you enter the ID for the source.  Click the <b>#pgv_lang[create_source]#</b> link if you need to enter a new source.  In the Citation Details field you would enter the page number or other information that might help someone find the information in the source.  In the Text field you would enter the text transcription from the source.<br /><br />";
##$pgv_lang["edit_add_ASSO_help"]		= "~#pgv_lang[add_asso]#~<br /><br />#pgv_lang[add_asso]# allows you to link a fact with an associated person in the site.  This is one way in which you might record that someone was the Godfather of another person.<br /><br />";
##$pgv_lang["edit_QUAY_help"]		= "~#factarray[QUAY]#~<br /><br />You would use this field to record the quality or reliability of the data found in this source.  Many genealogy applications use a number in the field. <b>3</b> might mean that the data is a primary source, <b>2</b> might mean that it was a secondary source, <b>1</b> might mean the information is questionable, and <b>0</b> might mean that the source is unreliable.<br /><br />";
##$pgv_lang["edit_PAGE_help"]		= "~#factarray[PAGE]#~<br /><br />In the Citation Details field you would enter the page number or other information that might help someone find the information in the source.<br /><br />";
##$pgv_lang["edit_TEXT_help"]		= "~#factarray[TEXT]#~<br /><br />In this field you would enter the citation text for this source.  Examples of data may be a transcription of the text from the source, or a description of what was in the citation.<br /><br />";
##$pgv_lang["edit_SOUR_help"]		= "~#factarray[SOUR]#~<br /><br />This field allows you to change the source record that this fact's source citation links to.  This field takes a Source ID.  Beside the field will be listed the title of the current source ID.  Use the <b>#pgv_lang[find_id]#</b> link to look up the source's ID number.  To remove the entire citation, make this field blank.<br /><br />";
##$pgv_lang["edit_edit_raw_help"]	= "~#pgv_lang[edit_raw]#~<br /><br />This page allows you to edit the raw GEDCOM record.  You should use this page with caution; it requires a good understanding of the GEDCOM 5.5.1 Standard.  For more information on the GEDCOM 5.5.1 Standard, refer to Help topic <b>GEDCOM file</b>.<br /><br />PhpGedView provides many ways to add and edit information, but there could be occasions when you may want to edit the raw GEDCOM structure.  When possible, you should use the provided forms for adding information, but when that is impossible, you can use this form.  Upon submitting the form, your information will be checked for basic conformance to the Standard and the CHAN record will be updated.<br /><br />";
##$pgv_lang["add_from_clipboard_help"]	= "~#pgv_lang[add_from_clipboard]#~<br />PhpGedView allows you to copy facts to a clipboard.  You can copy up to 5 facts and store them in the clipboard.  From the Add New Facts drop-down menu you can choose to paste one of the facts from the clipboard into the record you are editing.  This is very helpful when entering similar facts, such as census facts, for many individuals or families.<br /><br />";
##$pgv_lang["edit_PLAC_help"]			= "~#factarray[PLAC]#~<br /><br />Places should be entered according to the standards for genealogy.  In genealogy, places are recorded with the most specific information about the place first and then working up to the least specific place last, using commas to separate the different place levels.  The level at which you record the place information should represent the levels of government or church where vital records for that place are kept.<br /><br />For example, a place like Salt Lake City would be entered as \"Salt Lake City, Salt Lake, Utah, USA\".<br /><br />Let's examine each part of this place.  The first part, \"Salt Lake City,\" is the city or township where the event occurred.  In some countries, there may be municipalities or districts inside a city which are important to note.  In that case, they should come before the city.  The next part, \"Salt Lake,\" is the county.  \"Utah\" is the state, and \"USA\" is the country.  It is important to note each place because genealogical records are kept by the governments of each level.<br /><br />If a level of the place is unknown, you should leave a space between the commas.  Suppose, in the example above, you didn't know the county for Salt Lake City.  You should then record it like this: \"Salt Lake City, , Utah, USA\".  Suppose you only know that a person was born in Utah.  You would enter the information like this: \", , Utah, USA\".  <br /><br />You can use the <b>#pgv_lang[find_place]#</b> link to help you find places that already exist in the database.<br /><br />";
##$pgv_lang["edit_add_parent_help"]	= "~ADD NEW MOTHER OR FATHER~<br /><br />With this page you can add a new mother or father to the selected person.  Fill out the new person's name and the birth and death information if it is known.  If you don't know some information, leave it blank.<br /><br />To add other facts besides birth and death, first add the new person to the database by saving the changes.  Then click on the person's name in the updated Family page or #pgv_lang[relatives]# tab to view the person's #pgv_lang[indi_info]# page.  From the #pgv_lang[indi_info]# page you can add more detailed information.<br /><br />";
##$pgv_lang["edit_add_spouse_help"]	= "~ADD NEW HUSBAND OR WIFE~<br /><br />With this page you can add a new husband or wife to the selected person.  Fill out the new person's name and the birth and death information if it is known.  If you don't know some information leave it blank.<br /><br />To add other facts besides birth and death, first add the new person to the database by saving the changes.  Then click on the person's name in the updated Family page or #pgv_lang[relatives]# tab to view the person's #pgv_lang[indi_info]# page.  From the #pgv_lang[indi_info]# page you can add more detailed information.<br /><br />";
##$pgv_lang["edit_death_help"] = "~#pgv_lang[death]#~<br /><br />This area allows you to enter Death information.  First enter the date when the person died in the standard date format for genealogy (1 JAN 2004).  You can click on the Calendar icon for help selecting a date.  Then enter the place where the person died.  You can use the <b>#pgv_lang[find_place]#</b> link to select a place that already exists in the database.<br /><br />";
##$pgv_lang["edit_birth_help"] = "~#pgv_lang[birth]#~<br /><br />This area allows you to enter the birth information.  First enter the date when the person was born in the standard date format for genealogy (1 JAN 2004).  You can click on the Calendar icon for help selecting a date.  Then enter the place where the person was born.  You can use the <b>#pgv_lang[find_place]#</b> link to select a place that already exists in the database.<br /><br />";
##$pgv_lang["edit_sex_help"]	= "~#pgv_lang[sex]#~<br /><br />Choose the appropriate gender from the drop-down list.  The <b>unknown</b> option indicates that the gender is unknown.<br /><br />";
##$pgv_lang["edit_name_help"]	= "~#pgv_lang[name]#~<br /><br />This is the most important field in a person's Name record.<br /><br />This field should be filled automatically as the other fields are filled in, but it is provided so that you can edit the information according to your personal preference.<br /><br />The name in this field should be entered according to the GEDCOM 5.5.1 standards with the surname surrounded by forward slashes \"/\".  As an example, the name \"John Robert Finlay Jr.\" should be entered like this: \"John Robert /Finlay/ Jr.\".<br /><br />";
##$pgv_lang["edit_suffix_help"]	= "~#pgv_lang[suffix]#~<br /><br />In this optional field you should enter the name suffix for the person.  Examples of name suffixes are \"Sr.\", \"Jr.\", and \"III\".<br /><br />";
##$pgv_lang["edit_surname_help"]	= "~#pgv_lang[surname]#~<br /><br />In this field you should enter the surname for the person.  As an example, in the name \"John Robert Finlay\", the surname that should be entered here is \"Finlay\"<br /><br />Individuals with multiple surnames, common in Spain and Portugal, should separate the surnames with a comma.  This indicates that the person is to be listed under each of the names.  For example, the surname \"Cortes,Vega\" will be listed under both <b>C</b> and <b>V</b>, whereas the surname \"Cortes Vega\" will only be listed under <b>C</b>.<br /><br />";
##$pgv_lang["edit_NICK_help"]	= "~#factarray[NICK]#~<br /><br />In this field you should enter any nicknames for the person.<br />This is an optional field.<br /><br />Ways to add a nickname:<ul><li>Select <b>modify name</b> then enter nickname and save</li><li>Select <b>add new name</b> then enter nickname AND name and save</li><li>Select <b>edit GEDCOM record</b> to add multiple [2&nbsp;NICK] records subordinate to the main [1&nbsp;NAME] record.</li></ul>";
##$pgv_lang["edit_given_name_help"]	= "~#pgv_lang[given_name]#~<br /><br />In this field you should enter the given names for the person.  As an example, in the name \"John Robert Finlay\", the given names that should be entered here are \"John Robert\"<br /><br />";
##$pgv_lang["edit_NPFX_help"]			= "~Name Prefix~<br /><br />This optional field allows you to enter a name prefix such as \"Dr.\" or \"Adm.\"<br /><br />";
##$pgv_lang["edit_add_child_help"]	= "~#pgv_lang[add_child]#~<br /><br />With this page you can add a new child to the selected family.  Fill out the name of the child and the birth and death information if it is known.  If you don't know some information leave it blank.<br /><br />To add other facts besides birth and death, first add the new child to the database by saving the changes.  Then click on the child's name in the updated Family page or #pgv_lang[relatives]# tab to view the child's #pgv_lang[indi_info]# page.  From the #pgv_lang[indi_info]# page you can add more detailed information.<br /><br />";

##$pgv_lang["review_changes_help"]	= "~UNACCEPTED CHANGES~<br /><br />This block will list all of the records that have been changed online and that still need to be reviewed and accepted into the database.<br /><br />";
##$pgv_lang["quick_update_name_help"] = "~UPDATE NAME~<br /><br />Use the \"Update Name\" fields to change the name of the person you are editing.  In the Given Names field enter the person's given or first names.  In the Surname field enter the person's last or surname.  For example, if the name you want to enter is \"John Robert Finlay\" then you would enter \"John Robert\" in the Given Name field and \"Finlay\" in the Surname field.<br /><br />Filling out these fields will <u>change</u> the name of the person; it will not add a new name.<br /><br /><i>Note: you should <u>not</u> use this method if the name changes due to a new marriage.  Instead, use the options to add a new husband below.</i><br /><br />";
##$pgv_lang["quick_update_fact_help"] = "~UPDATE A FACT~<br /><br />Use the \"Update Fact\" fields to add new fact information or change an existing fact for the record you are editing.  First choose a fact from the drop-down list.  Then enter the date when that fact occurred in the standard date format for genealogy (1 JAN 2004).  You can click on the Calendar icon for help selecting a date.  Then enter the place when that fact occurred.  You can use the <b>#pgv_lang[find_place]#</b> link to select a place that already exists in the database.<br /><br />As with all the other fields on this form, your information will either replace what is already there or it will create new entries as required.<br /><br />";
##$pgv_lang["quick_update_address_help"] = "~UPDATE ADDRESS~<br /><br />Use the \"Update Address\" fields to change the address, telephone number, or email address of the person you are editing.<br /><br />As with all the other fields on this form, your information will either replace what is already there or it will create new entries as required.<br /><br />";
##$pgv_lang["quick_update_spouse_help"] = "~ADD A NEW HUSBAND OR WIFE~<br /><br />Use these fields when you want to add a new husband or wife to the person you are editing.  Enter the new spouse's name and birth information into the fields and then enter the date they were married under the marriage information.  Enter dates in the standard date format for genealogy (1 JAN 2004).  You can click on the Calendar icon for help selecting a date.  You can use the <b>#pgv_lang[find_place]#</b> link to select a place that already exists in the database.<br /><br />These fields will only add a <i>new</i> partner; they will not update the information of an old one.  To edit the information of someone who is already recorded, close this window and click on that person's name in the #pgv_lang[relatives]# tab.  Then click on the Edit Individual menu to edit the information.<br /><br />";
##$pgv_lang["quick_update_marriage_help"] = "~UPDATE MARRIAGE~<br /><br />You can use these fields along with the fields to add a new husband or wife if you want to record a new marriage.  Otherwise entering data in these fields will change information about the person's last marriage.  Enter dates in the standard date format for genealogy (1 JAN 2004).  You can click on the Calendar icon for help selecting a date.  You can use the <b>#pgv_lang[find_place]#</b> link to select a place that already exists in the database.<br /><br />";
##$pgv_lang["quick_update_child_help"] = "~ADD A NEW CHILD~<br /><br />Use these fields to add a new child to this person.  First enter the child's name and choose the gender.  Then enter the date and place where the child was born.  Enter dates in the standard date format for genealogy (1 JAN 2004).  You can click on the Calendar icon for help selecting a date.  You can use the <b>#pgv_lang[find_place]#</b> link to select a place that already exists in the database.<br /><br />These fields will only add a <u>new</u> child.  They will not update the information of a child that is already recorded.  To edit the information of someone who is already in the database, close this window and click on that person's name in the #pgv_lang[relatives]# tab.  Then click on the Edit Individual menu to edit the information.<br /><br />";
##$pgv_lang["index_top10_pageviews_help"]		= "~MOST VIEWED ITEMS BLOCK~<br /><br />This block will list the top 10 individuals, families, or sources that have been viewed by visitors to this site.  In order for this block to appear the site administrator must have enabled the Item Hit counters.<br /><br />";
##$pgv_lang["useradmin_user_default_tab_help"]	= "~USER DEFAULT TAB SETTING~<br /><br />This setting allows you to specify which tab is opened automatically when this user accesses the #pgv_lang[indi_info]# page.  If allowed to edit their account, the user can change this setting later.<br /><br />";
##$pgv_lang["edituser_user_default_tab_help"]	= "~USER DEFAULT TAB SETTING~<br /><br />This setting allows you to specify which tab is opened automatically when you access the #pgv_lang[indi_info]# page.<br /><br />";
##$pgv_lang["reorder_children_help"]	= "~#pgv_lang[reorder_children]#~<br /><br />Children are displayed in the order in which they appear in the family record.  Children are not automatically sorted by birth date because often the birth dates of some of the children are uncertain but the order of their birth <u>is</u> known.<br /><br />This option will allow you to change the order of the children within the family's record.  Since you might want to sort the children by their birth dates, there is a button you can press that will do this for you.<br /><br />You can also drag-and-drop any information box to change the order of the children.  As you move the mouse cursor over an information box, its shape will change to a pair of double-headed crossed arrows. If you push and hold the left mouse button before moving the mouse cursor, the information box will follow the mouse cursor up or down in the list.  As the information box is moved, the other boxes will make room.  When you release the left mouse button, the information box will take its new place in the list.<br /><br />";
##$pgv_lang["rss_feed_help"]	= "~RSS FEED SETTINGS~<br /><br />The ATOM/RSS feed available in PhpGedView allows anyone to view, using a suitable feed aggregator, the contents of your site's Welcome page without visiting the site. Most aggregators will pop up a notice letting the user know when something has changed on a page being monitored. This essentially allows anyone to monitor your PhpGedView site without needing to visit it regularly.<br /><br />The Feed block is used to customize the link to the feed, allowing specific feed types (most readers can deal with most types so this can usually be left at the default), and the specific module you would like in your feed. The language of the feed and the GEDCOM used will be based on the language and GEDCOM active in PhpGedView when you select the feed.<br /><br />The types of feed that can be generated include ATOM, RSS 2.0, RSS 1.0, RSS 0.92, HTML and JavaScript. The first four types are for feed aggregators, while JavaScript and HTML are meant to enable inclusion of the feeds in other web pages.  Note that the numbers of the RSS feed indicate different styles, not a different version.<br /><br />There is an option to select authentication that will log the user in, and allow the user to view, using a suitable RSS aggregator, any information that he could normally view if logged in. Basic Authentication uses <i>Basic HTTP Authentication</i> to log the user in. Future enhancements might allow <i>Digest Authentication</i>.<br /><br />This <a href='http://en.wikipedia.org/wiki/RSS_(file_format)' target='_blank' alt='Wikipedia article' title='Wikipedia article'><b>Wikipedia article</b></a> contains comprehensive information and links about RSS and the various RSS formats. <i>Basic HTTP Authentication</i> is discussed in this <a href='http://en.wikipedia.org/wiki/Basic_authentication_scheme' target='_blank' alt='Wikipedia article' title='Wikipedia article'><b>Wikipedia article</b></a>, while <i>Digest Authentication</i> is discussed in this <a http://en.wikipedia.org/wiki/Digest_access_authentication' target='_blank' alt='Wikipedia article' title='Wikipedia article'><b>Wikipedia article</b></a>.<br /><br />";

##$pgv_lang["upload_media_folder_help"]	= "~#pgv_lang[folder]#~<br /><br />Your GEDCOM configuration allows up to #GLOBALS[MEDIA_DIRECTORY_LEVELS]# directory levels beyond the default <b>#GLOBALS[MEDIA_DIRECTORY]#</b> where uploaded media files are normally stored. This lets you organize your media files, and you don't need to be as concerned about maintaining unique names for each media file.<br /><br />In this field you specify the destination directory on your server where the uploaded media file is to be stored.  Be sure to pay attention to the case (upper or lower case) of what you enter or select here, since file and directory names are case sensitive.<br /><br />If the directory name you enter here does not exist, it will be created automatically. If you enter more than the additional #GLOBALS[MEDIA_DIRECTORY_LEVELS]# directory levels permitted by your GEDCOM configuration, your input will be truncated accordingly.<br /><br />Thumbnails will be uploaded or created in an identical directory structure, starting with <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b>.<br /><br />";
##$pgv_lang["upload_media_file_help"]		= "~#pgv_lang[media_file]#~<br /><br />In this field you specify the location and name, on your local computer, of the media file you wish to upload to the server.  You can use the <b>Browse</b> button to search your local computer for the desired file.<br /><br />The uploaded file will have the same name on the server, and it will be uploaded to the directory specified in the <b>#pgv_lang[folder]#</b> field.<br /><br />If you do not see the <b>#pgv_lang[folder]#</b> field or cannot change it, you do not have sufficient permissions or your GEDCOM configuration has been set to allow no directory levels beyond the default <b>#GLOBALS[MEDIA_DIRECTORY]#</b>.  In this case, the media file will be uploaded to the directory <b>#GLOBALS[MEDIA_DIRECTORY]#</b>.<br /><br />";
##$pgv_lang["upload_thumbnail_file_help"]	= "~#pgv_lang[thumbnail]#~<br /><br />In this field you specify the location and name, on your local computer, of the thumbnail file you wish to upload to the server.  You can use the <b>Browse</b> button to search your local computer for the desired file.  When this field is filled in, the <b>#pgv_lang[auto_thumbnail]#</b> checkbox is ignored.<br /><br />If the <b>#pgv_lang[media_file]#</b> field has been filled in, your uploaded thumbnail file will be named according to the contents of that field, regardless of what it is called on your local computer.  If that field is empty, the uploaded thumbnail file will be copied to two places on the server, once into the server directory mentioned in the <b>#pgv_lang[folder]#</b> field, and then again into an identical directory structure starting with <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b>.<br /><br />If you do not see the <b>#pgv_lang[folder]#</b> field or cannot change it, you do not have sufficient permissions or your GEDCOM configuration has been set to allow no directory levels beyond the default <b>#GLOBALS[MEDIA_DIRECTORY]#</b> where uploaded media files are normally stored.<br /><br />";


//-- GENERAL
##$pgv_lang["help_header"]			= "Information about:";
##$pgv_lang["privacy_error_help"]			= "~PRIVATE DETAILS~<br /><br />There are several possible reasons for this message:<br /><br /><ul><li><b>Information on living people is set to \"Private\"</b><br />Visitors and registered users who are not logged in can see full information only for deceased individuals. If allowed by the system administrator, visitors may register for an account by clicking the Login button, then the #pgv_lang[requestpassword]# link.<br /></li><li><b>You are a user with user name and password...</b><br />But you have not logged in successfully or you have been inactive for a while and your session timed out.<br /></li><li><b>Due to privacy</b><br />The person does not want to be shown at all (Hidden) and may have asked the admin to set him or her to \"Private\".  Privacy can be set to:<br /><ol><li>#pgv_lang[PRIV_USER]#</li><li>#pgv_lang[PRIV_NONE]#</li><li>#pgv_lang[PRIV_HIDE]#</li></ol></li><li><b>Out of \"Relation Path\"</b><br />Even if you are a regular user <u>and</u> logged in, it can still happen that you see this message if the person you are trying to view is not related to you within the number of relationship steps (Relation Path length) set by the site administrator for this GEDCOM.<br /><br />Examples:<br />When the Relation Path length is set to <b>1</b>, you can only see the details of your own family, father, mother, brother, sister (but not the spouses and children of your brother or sister)<br /><br />When the Relation Path is set to <b>2</b>, you can also see the details of your brother's wife and their children (but not the spouses of their children).<br /><br />The higher the Relation Path length setting, the more remote relatives you can see.<br /></li></ul><br />If you think that you qualify to see certain hidden details, please contact the site administrator.  Use the contact link on any page.<br /><br />";
##$pgv_lang["more_help"]				= "<br />Contextual help is available on every screen; make sure that the <b>#pgv_lang[show_context_help]#</b> option in the Help menu is on, and click on a <b>?</b> next to the subject.<br /><br />";
##$pgv_lang["more_config_help"]			= "<br /><b>More help</b><br />#pgv_lang[context_help]#<br /><br />";
##$pgv_lang["start_admin_help"]			= "+++ Begin extra Admin Info +++";
##$pgv_lang["end_admin_help"]			= "--- End extra Admin Info ---";
##$pgv_lang["multiple_help"]			= "<center>--- This is a general help text for multiple pages ---</center>";
##$pgv_lang["header_general_help"]		= "<div class=\"name_head\"><center><b>GENERAL INFORMATION</b></center></div><br />";
##$pgv_lang["best_display_help"]			= "~Your Screen~<br />PhpGedView is designed for a screen size of 1024x768 pixels.  This should be the minimum size to have everything displayed properly.<br /><br />If you set the size to a lower value (for example 800x600), you may need to do horizontal scrolling on some pages.<br /><br />";
##$pgv_lang["preview_help"]			= "~Printing~<br />Clicking the Printer-friendly Version link will remove the items that don't look good on a printed page (menus, input boxes, extra links, the question marks for the contextual help, etc.)<br /><br />On the Printer-friendly version of the page, you will get a <b>Print</b> link at the bottom of the page. Just click it and your printer dialog will pop up. After printing, just click the <b>Back</b> link and the screen will be rebuilt normally.<br /><br />Note: Although the \"Printer-friendly version\" removes many links from the displayed page, the remaining links are still clickable.<br /><br />";
##$pgv_lang["readme_help"]			= "See <a href=\"readme.txt\" target=\"_blank\"><b>Readme.txt</b></a> for more information.";
##$pgv_lang["is_user_help"]			= "--- This help text is the same text that site visitors will read. --- <br />--- To save space, we did not make a special admin text for this item. ---";
##$pgv_lang["edit_raw_gedcom_help"]	= "~EDIT RAW GEDCOM~<br /><br />When you click this link, a new window will open containing the raw GEDCOM data of the details on this page.<br /><br />Here you can edit the GEDCOM data directly. Be sure to enter valid GEDCOM 5.5.1 data, as no further validity checks will be done.  The changed or added data will be displayed in PhpGedView as \"changes\", and have to be accepted by a user with Accept rights.<br /><br />";
##$pgv_lang["RESN_help"]				= "~SETTING RESTRICTIONS ON FACTS~<br /><br />Apart from general privacy settings, PhpGedView has the ability to set restrictions on viewing and editing fact information for individuals and families. The restrictions can be set by anyone who is allowed to edit the information, unless privacy or formerly set restrictions prohibit this.<br /><br />The following values can be used:<br /><ul><li><b>#pgv_lang[none]#</b><br />Site administrators, GEDCOM administrators, and users who have rights to edit can change the information. Fact information can be viewed according to privacy settings as applied by the administrator.</li><li><b>#pgv_lang[locked]#</b><br />This setting has no influence on the visibility of the fact data. It restricts editing rights to site administrators and GEDCOM administrators. If the information applies to the user himself, he can also view and, assuming he has editing rights, edit it.</li><li><b>#pgv_lang[privacy]#</b><br />Site administrators and GEDCOM administrators can view and edit the information. If the information applies to the user himself, he can also view and, assuming he has editing rights, edit it. It will be hidden from all other users regardless of their login status.</li><li><b>#pgv_lang[confidential]#</b><br />Only site administrators and GEDCOM administrators can view and edit the information. It will be hidden from all other users regardless of their login status.</li></ul><br /><table><tr><th></th><th colspan=\"2\">Admin</th><th colspan=\"2\">Owner</th><th colspan=\"2\">Others</th></tr><tr><th></th><th>R</th><th>W</th><th>R</th><th>W</th><th>R</th><th>W</th></tr><tr><td><img src=\"images/RESN_none.gif\" alt=\"\" /> #pgv_lang[none]#</td><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th></tr><tr><td><img src=\"images/RESN_locked.gif\" alt=\"\" /> #pgv_lang[locked]#</td><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th></tr><tr><td><img src=\"images/RESN_privacy.gif\" alt=\"\" /> #pgv_lang[privacy]#</td><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th></tr><tr><td><img src=\"images/RESN_confidential.gif\" alt=\"\" /> #pgv_lang[confidential]#</td><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th></tr></table><ul><li>R : can read</li><li>W : can edit</li><li><img src=\"images/checked_qm.gif\" alt=\"\" /> : depends on global privacy settings</li></ul>";


//-- Pages Help-messages
//-- Index-page
##$pgv_lang["index_help"]				= "~THE WELCOME PAGE~<br /><br />This page is the Welcome page. It welcomes you to the selected <a href=\"#def_gedcom\">GEDCOM</a> file. You can return to this page by selecting Welcome Page from the top menu. If there are multiple GEDCOMs on this site, you can select a GEDCOM from the drop-down menu.<br /><br />This Help page contains information about:<ul><li><a href=\"#index_portal\"><b>Welcome Page</b></a></li><li><a href=\"#header\"><b>Header Area</b></a></li><li><a href=\"#menu\"><b>Menus</b></a></li><li><a href=\"#header_general\"><b>General Information</b></a></li><li><a href=\"#def\"><b>Definitions</b></a></li></ul><br />";

//-- Index-page Header
##$pgv_lang["header_help"]			= "<div class=\"name_head\"><center><b>HEADER AREA</b></center></div><br />The header is shown at the top of every page.  The header contains some useful links that you can use throughout the site.<br /><br />Since this site can have a different look depending on the selected <a href=\"#def_theme\">theme</a>, headers can be affected and links may vary.<br /><br />The links that you might find are:<ul><li><a href=\"#header_search\"><b>Search Box</b></a></li><li><a href=\"#header_lang_select\"><b>Language Selector</b></a></li><li><a href=\"#header_user_links\"><b>User Links</b></a></li><li><a href=\"#header_favorites\"><b>Favorites</b></a></li><li><a href=\"#header_theme\"><b>Change Theme</b></a></li></ul>";
##$pgv_lang["header_search_help"]			= "~Header Area: Search Box~<br />This Search box is small but powerful.  You can have PhpGedView search almost anything for you. When you click the <b>></b> or <b>Search</b> button, you will be linked to the Search page to see the results of your search.  You will find extensive help about searching options on the Search page.<br /><br />";
##$pgv_lang["header_lang_select_help"]		= "~Header Area: Language Selector~<br />One of the most important features of PhpGedView is that multiple languages are supported.<br /><br />The language in which PhpGedView displays all pages is determined automatically according to the Preferred Language setting of the browser.  However, the site administrator may have limited the availability of certain languages.<br /><br />Depending on site configuration, you may be able to change the language of PhpGedView by selecting a more suitable language from a drop-down list or by clicking on a flag icon.  If you are a registered user, you can configure PhpGedView to switch to your preferred language after you login, regardless of what your browser is set to.<br /><br />";
##$pgv_lang["header_user_links_help"]		= "~Header Area: User Links~<br />The User Links is a small block with useful links that can be found in the same place on every page.  The location of these links varies according to the theme currently in effect.<br /><br />When not logged in, you will only see the <b>Login</b> link.  After you have logged in, you will see:<ul><li><b>Logged in as (your user name)</b>. Clicking that link will take you to your Account page.</li><li>Click <b>Log out</b> to Log out.</li><li>If you have admin rights, you will also see <b>Admin</b>. Clicking this link will take you directly to the main Administration page.</li></ul><br />";
##$pgv_lang["header_favorites_help"]		= "~Header Area: Favorites~<br />The Favorites drop-down list shows the favorites that you have selected on your personalized Portal page.  It also shows the favorites that the site administrator has selected for the currently active GEDCOM.  Clicking on one of the favorites entries will take you directly to the #pgv_lang[indi_info]# page of that person.<br /><br />More help about adding Favorites is available in your personalized Portal page.<br /><br />";
##$pgv_lang["header_theme_help"]		= "~Header Area: Change Theme~<br />When enabled by the site administrator, the Change Theme drop-down list shows you a list of the themes that you can use to view the site.<br /><br />You can change the appearance of the site by selecting a theme from the drop-down list.  If you are logged in, it will also change your user theme to the one that you have chosen so that your next login will automatically select that same theme.<br /><br />";

//-- Index-page Menu
##$pgv_lang["menu_help"]				= "<div class=\"name_head\"><center><b>MENUS</b></center></div><br />The page headers have drop-down menus associated with each menu icon.<br /><br />When you move your mouse pointer over an icon a sub-menu will appear, if one exists.  When you click on an icon you will be taken to the first item in the sub-menu.<br /><br />The following menu icons are usually available:<ul><li><a href=\"#menu_fam\">#pgv_lang[welcome_page]#</a><br /></li><li><a href=\"#menu_myged\">#pgv_lang[mygedview]#</a><br /></li><li><a href=\"#menu_charts\">#pgv_lang[charts]#</a><br /></li><li><a href=\"#menu_lists\">#pgv_lang[lists]#</a><br /></li><li><a href=\"#menu_annical\">#pgv_lang[anniversary_calendar]#</a><br /></li><li><a href=\"#menu_clip\">#pgv_lang[clippings_cart]#</a><br /></li><li><a href=\"#menu_search\">#pgv_lang[search]#</a><br /></li><li><a href=\"#menu_help\">#pgv_lang[page_help]#</a></li></ul><br />";
##$pgv_lang["menu_famtree_help"]			= "~Welcome Page menu~<br />All of this site's available genealogical databases are listed in this menu. Each database has its own customized Welcome page, like this one.  If there is only one database at this site, there is no sub-menu under the Welcome Page icon.<br /><br />";
##$pgv_lang["menu_myged_help"]			= "~#pgv_lang[mygedview]# menu~<br />If you are logged in, this menu can include the following items:<ol><li>#pgv_lang[mygedview]#<br />This takes you to your own customizable Starting page.</li><li>#pgv_lang[editowndata]#<br />You can edit your personal data here.</li><li>#pgv_lang[my_pedigree]#<br />If you have selected a Root person for this GEDCOM, this will take you to the Pedigree chart for that person.</li><li>#pgv_lang[my_indi]#<br />This link will take you to your #pgv_lang[indi_info]# page, where all genealogical data about yourself and your family is displayed.</li></ol><br />";
##$pgv_lang["menu_charts_help"]			= "~Charts Menu~<br />The available charts are:<ol><li><a href=\"?help=help_pedigree.php\"><b>#pgv_lang[index_header]#</b></a><br />This will link you to the Pedigree chart of this GEDCOM file. The pedigree will start with the person configured by the administrator. When you are logged in the starting person can be whoever you have configured in your Account preferences.</li><li><a href=\"?help=help_descendancy.php\"><b>#pgv_lang[descend_chart]#</b></a><br />The Descendancy chart is essentially a <a href=\"?help=help_pedigree.php\"><b>#pgv_lang[index_header]#</b></a> in reverse order.  This comparison is not quite correct, but while the Pedigree chart shows you all the ancestors of a starting person, the Descendancy chart shows you all the descendants of a starting person.</li><li><a href=\"?help=help_timeline.php\"><b>#pgv_lang[timeline_chart]#</b></a><br />Here you view the events of a person along a time line.  It's interesting to compare the events of two or more persons along the same time line.</li><li><a href=\"?help=help_relationship.php\"><b>#pgv_lang[relationship_chart]#</b></a><br />Here you can check the relation of a person to yourself or to another person.</li><li><a href=\"?help=help_ancestry.php\"><b>#pgv_lang[ancestry_chart]#</b></a><br />This chart is very similar to the <a href=\"?help=help_pedigree.php\"><b>#pgv_lang[index_header]#</b></a>, but with more details and alternate <a href=\"?help=chart_style_help\"><b>#pgv_lang[chart_style]#</b></a> displays.</li><li><a href=\"?help=help_fanchart.php\"><b>#pgv_lang[fan_chart]#</b></a><br />This chart is very similar to the <a href=\"?help=help_pedigree.php\"><b>#pgv_lang[index_header]#</b></a>, but in a more graphical way.</li></ol><br />";
##$pgv_lang["menu_lists_help"]			= "~Lists Menu~<br />The following lists are available:<ol><li><a href=\"?help=help_indilist.php\"><b>#pgv_lang[individual_list]#</b></a></li><li><a href=\"?help=help_famlist.php\"><b>#pgv_lang[family_list]#</b></a><br />In these two lists you can browse alphabetical lists of individuals or families in this GEDCOM.</li><li><a href=\"?help=help_sourcelist.php\"><b>#pgv_lang[source_list]#</b></a><br />This item returns a list of all the sources used in the GEDCOM.</li><li><a href=\"?help=help_placelist.php\"><b>#pgv_lang[place_list]#</b></a><br />Here you can look for people by Place. A two-column list will be returned. Individuals are listed on the left, families on the right.</li><li><a href=\"?help=help_medialist.php\"><b>#pgv_lang[media_list]#</b></a><br />You see this menu item only if enabled by the site admin.  This will display links to all multimedia files in this GEDCOM.</li></ol><br />";
##$pgv_lang["menu_annical_help"]			= "~#pgv_lang[anniversary_calendar]# Menu~<br />The #pgv_lang[anniversary_calendar]# displays the events in a GEDCOM for a given date, month, or year.<ol><li><a href=\"?help=day_month_help\"><b>#pgv_lang[viewday]#</b></a></li><li><a href=\"?help=day_month_help\"><b>#pgv_lang[viewmonth]#</b></a></li><li><a href=\"?help=day_month_help\"><b>#pgv_lang[viewyear]#</b></a><br />These menu items will take you to the #pgv_lang[anniversary_calendar]# to display a list of all the events for the current day, month, or year.</li></ol><br />";
##$pgv_lang["menu_clip_help"]			= "~#pgv_lang[clippings_cart]# Menu~<br />You will see this item in the menu bar only when the administrator has enabled this feature.<br /><br />The #pgv_lang[clip_cart]# allows you to store information about individuals, families, and sources in a temporary file that you can later download in GEDCOM 5.5.1 format.<br /><br />";
##$pgv_lang["menu_search_help"]			= "~Search Menu~<br />The Search page is a more powerful version of the Search box you may find in each page header.<br /><br />";
##$pgv_lang["menu_help_help"]			= "~Help Menu~<br />#pgv_lang[help_help_items]#";

//-- Index-page Portal
##$pgv_lang["index_portal_head_help"]		= "<div class=\"name_head\"><center><b>THE WELCOME PAGE</b></center></div><br />";
##$pgv_lang["index_portal_help"]			= "The Welcome page consists of several separate blocks, and can be customized. On sites that have more than one genealogical database, you may see a different Welcome page for each.  Depending on how the administrator customized the site, you may see any of the following blocks on the Welcome page:<ul><li><a href=\"#index_welcome\"><b>Welcome</b></a></li><li><a href=\"#index_login\"><b>Login</b></a></li><li><a href=\"#index_events\"><b>Upcoming events</b></a></li><li><a href=\"#index_onthisday\"><b>On this Day in Your History</b></a></li><li><a href=\"#index_charts\"><b>Charts</b></a></li><li><a href=\"#index_favorites\"><b>GEDCOM Favorites</b></a></li><li><a href=\"#index_stats\"><b>GEDCOM Statistics</b></a></li><li><a href=\"#index_common_surnames\"><b>Most Common Surnames</b></a></li><li><a href=\"#index_media\"><b>Random Media</b></a></li><li><a href=\"#index_loggedin\"><b>Logged in Users</b></a></li><li><a href=\"#gedcom_news\"><b>GEDCOM News</b></a></li><li><a href=\"#recent_changes\"><b>Recent Changes</b></a></li></ul><br />";
##$pgv_lang["index_welcome_help"]			= "~WELCOME BLOCK~<br />The Welcome block shows you the current database title, the date and time, and, if enabled by the admin, the Hit Counter.<br /><br />The Hit Counter is only available in the Welcome block and on the #pgv_lang[indi_info]# page.  The counter counts the \"Hits\" of these pages. That means it counts how many times these pages are visited.  The counter does not check the Internet address of a visitor; every visit to a page from <u>any</u> remote location counts as another Hit.<br /><br />";
##$pgv_lang["index_login_help"]			= "~LOGIN BLOCK~<br />You can login on almost every page of this program. You will usually do so on the first page, since you can only access privileged information when you are logged in.<br /><br />You can login by typing your <b>username</b> and <b>password</b> and then clicking the Login button.<br /><br />";
##$pgv_lang["index_events_help"]			= "~UPCOMING EVENTS BLOCK~<br />This block shows you anniversaries of events that are coming up in the near future.<br /><br />The administrator determines how far ahead the block will look.  You can further refine the block's display of upcoming events through several configuration options.<br /><br />";
##$pgv_lang["todo_help"] = "~&quot;TO DO&quot; BLOCK~<br />This block helps you keep track of <b>_TODO</b> tasks in the database.<br /><br />To add &quot;To Do&quot; tasks to your records, you may first need amend the GEDCOM configuration so that the <b>_TODO</b> fact is in the list of facts that can be added to the records of individuals, families, sources, and repositories.  Each of these lists, which you will find in the Edit Options section of the GEDCOM configuration, is independent.  The order of the list entries is not important; you can add the new entries at the beginning of each list.<br /><br />";
##$pgv_lang["todo_show_other_help"]     = "Show &quot;To Do&quot; tasks assigned to other users";
##$pgv_lang["todo_show_unassigned_help"]= "Show &quot;To Do&quot; tasks that are not assigned to any user";
##$pgv_lang["todo_show_future_help"]= "Show &quot;To Do&quot; tasks that have a date in the future.  Otherwise only items with a date in the past are shown.";
##$pgv_lang["yahrzeit_help"]			="~YAHRZEITEN BLOCK~<br />This block shows you Yahrzeiten that are coming up in the near future.<br /><br />Yahrzeiten (singular: Yahrzeit) are anniversaries of a person's death.  These anniversaries are observed in the Jewish tradition; they are no longer in common use in other traditions.  «Yahrzeit» can also be spelled «Jahrzeit» or «Yartzeit».<br /><br />The Administrator determines how far ahead the block will look.  You can further refine the block's display of upcoming Yahrzeiten through configuration options.<br /><br />";
##$pgv_lang["days_to_show_help"]			= "~#pgv_lang[days_to_show]#~<br /><br />Enter the number of days to show.  This number cannot be greater than <b>#DAYS_TO_SHOW_LIMIT#</b>.  If you enter a larger value, that limit will be used.<br /><br />The limit shown is set by the administrator in the GEDCOM configuration, Display and Layout section, Hide &amp; Show sub-section.";
##$pgv_lang["random_media_persons_or_all_help"] = "~#pgv_lang[random_media_persons_or_all]#~<br /><br />This option lets you determine the type of media to show.<br /><br />When you select <b>#pgv_lang[random_media_persons]#</b>, only media associated with persons will be shown.  Usually, this would be a person's photograph.  When you select <b>#pgv_lang[random_media_events]#</b>, only media associated with facts or events will be shown.  This might be an image of a certificate.  When you select <b>#pgv_lang[all]#</b>, this block will show all types of media.";
##$pgv_lang["random_media_filter_help"] = "~#pgv_lang[filter]#~<br /><br />You can restrict what the Random Media block is permitted to show according to the format and type of media item.  When a given checkbox is checked, the Random Media block is allowed to display media items of that format or type.<br /><br />Format or Type codes that exist in your database but are not in these checkbox lists are assumed to have the corresponding checkbox checked.  For example, if your database contains Media objects of format <b><i>pdf</i></b>, the Random Media block is always permitted to display them.  Similarly, if your database contains Media objects of type <b><i>special</i></b>, the Random Media block is always permitted to display them.";
##$pgv_lang["basic_or_all_help"]			= "~#pgv_lang[basic_or_all]#~<br /><br />This option lets you eliminate some dated events.  For example, #factarray[DIV]#, #factarray[CREM]#, #factarray[GRAD]#, #factarray[BARM]#, #factarray[FCOM]#, etc. should all be dated.<br /><br />When you select <b>Yes</b>, only Births, Deaths, and Marriages will be shown. When you select <b>No</b>, all dated events will be shown.";
##$pgv_lang["style_help"]					= "~#pgv_lang[style]#~<br /><br />This option controls how the information is presented.<br /><br />When you select <b>#pgv_lang[style1]#</b>, the information is shown in text form, similar to what you see in the various Chart boxes.  This format is well suited to blocks that print on the right side of the page.<br /><br />When you select <b>#pgv_lang[style2]#</b>, the information is shown in tabular format, and is more suited to the larger blocks that print on the left side of the page.";
##$pgv_lang["cal_dowload_help"]			= "~#pgv_lang[cal_download]#~<br /><br />This option controls whether the button for downloading calendar events is shown to logged-in users. The downloaded calendar file can be imported into compatible programs such as Microsoft Outlook to, for example, generate automatic e-mail reminders of anniversaries.<br /><br />When set to <b>#pgv_lang[no]#</b>, the logged-in user will not be able to download the calendar file.  When set to <b>#pgv_lang[yes]#</b>, the Download button will be shown.  This button is never shown when the user is not logged in.";
##$pgv_lang["index_charts_help"]		= "~#pgv_lang[charts_block]#~<br />This block allows a pedigree, descendancy, or hourglass chart to appear on the Welcome or the MyGedView page.  Because of space limitations, the charts should be placed only on the left side of the page.<br /><br />When this block appears on the Welcome page, the root person and the type of chart to be displayed are determined by the administrator.  When this block appears on the user's personalized MyGedView page, these options are determined by the user.<br /><br />The behavior of these charts is identical to their behavior when they are called up from the menus.  Click on the box of a person to see more details about them.<br /><br />";
##$pgv_lang["index_onthisday_help"]		= "~ON THIS DAY IN YOUR HISTORY BLOCK~<br />This block is similar to the \"Upcoming Events\" block, except that it displays today's events.<br /><br />";
##$pgv_lang["index_favorites_help"]		= "~GEDCOM FAVORITES BLOCK~<br />The GEDCOM Favorites block is much the same as the \"My Favorites\" block of the #pgv_lang[mygedview]# page. Unlike the Portal page configuration, only the administrator or a user with Admin rights can change the list of favorites in this block.<br /><br />The purpose of the GEDCOM Favorites block is to draw the visitor's attention to persons of special interest.  This GEDCOM's favorites are available for selection from a drop-down list in the header on every page.<br /><br />When you click on one of the listed site favorites, you will be taken to the #pgv_lang[indi_info]# page of that person.<br /><br />";
##$pgv_lang["index_add_favorites_help"]	= "~ADD A FAVORITE~<br />This form allows you to add a new favorite item to your list of favorites.<br /><br />You must enter either an ID for the person, family, or source you want to store as a favorite, or you must enter a URL and a title.  The Note field is optional and can be used to describe the favorite.  Anything entered in the Note field will be displayed in the Favorites block after the item.<br /><br />";
##$pgv_lang["index_stats_help"]			= "~GEDCOM STATISTICS BLOCK~<br />In this block you will see some statistics about the current GEDCOM file.  If you need more information than is listed, send a message to the contact at the bottom of the page.<br /><br />";
##$pgv_lang["index_common_names_help"]		= "~MOST COMMON SURNAMES~<br />This block displays a list of frequently occurring surnames from this database. A surname must occur at least #COMMON_NAMES_THRESHOLD# times before it will appear in this list.  The administrator has control over this threshold.<br /><br />When you click on a surname in this list, you will be taken to the #pgv_lang[individual_list]#, where you will get more details about that name.<br /><br />";
##$pgv_lang["index_common_given_names_help"]		= "~MOST COMMON GIVEN NAMES~<br />This block displays a list of frequently occurring given names from this database. You can configure how many given names should appear in the list.<br /><br />";
##$pgv_lang["index_media_help"]			= "~RANDOM PICTURE BLOCK~<br />In this block PhpGedView randomly chooses a media file to show you on each visit to this page.<br /><br />When you click on the picture, you will see its full-size version.  Below the picture you have a link to the person associated with the picture.  When you click on the picture caption, you will see the picture on the #pgv_lang[media_list]# page. When you click on the person's name, you will be taken to the #pgv_lang[indi_info]# page of that person.<br /><br />";
##$pgv_lang["index_loggedin_help"]		= "~LOGGED IN USERS BLOCK~<br />This block will show you the users currently logged in.<br /><br />If you are not an administrator, your view of logged-in users is restricted to those who have elected to be visible while on-line.  For this to work, you must also elect to be visible while on-line.  On-line users who are invisible to you are counted as being anonymous.<br /><br />";
##$pgv_lang["index_gedcom_news_help"]		= "~GEDCOM NEWS BLOCK~<br />The News block is like a bulletin board for this GEDCOM.  The site administrator can place important announcements or interesting news messages here.<br /><br />If you have something interesting to display, please contact the site administrator;  he can put your message on this bulletin board.<br /><br />";
##$pgv_lang["recent_changes_help"]			= "~RECENT CHANGES BLOCK~<br />This block shows you the most recent changes to the GEDCOM as recorded by the CHAN GEDCOM tag.<br /><br />";
##$pgv_lang["gedcom_news_limit_help"]		= "You can limit the number of News articles displayed, thereby reducing the height of the GEDCOM News block.<br /><br />This option determines whether any limits should be applied or whether the limit should be according to the age of the article or according to the number of articles.<br /><br />";
##$pgv_lang["gedcom_news_flag_help"]		= "Enter the limiting value here.<br /><br />If you have opted to limit the News article display according to age, any article older than the number of days entered here will be hidden from view.  If you have opted to limit the News article display by number, only the specified number of recent articles, ordered by age, will be shown.  The remaining articles will be hidden from view.<br /><br />Zeros entered here will disable the limit, causing all News articles to be shown.<br /><br />";
##$pgv_lang["gedcom_news_archive_help"]	= "To reduce the height of the News block, the administrator has hidden some articles.  You can reveal these hidden articles by clicking the <b>#pgv_lang[gedcom_news_archive]#</b> link.<br /><br />";
##$pgv_lang["index_htmlplus_help"]		= "~#pgv_lang[htmlplus_block_name]#~<br />This block lets the administrator add information to the Index or Portal page.  Its purpose is similar to the #pgv_lang[html_block_name]#, #pgv_lang[gedcom_news_block]#, and #pgv_lang[gedcom_stats_block]# blocks, but the administrator has more control over its appearance.<br /><br />";
##$pgv_lang["index_htmlplus_title_help"]	= "~#factarray[TITL]#~<br />This text should be blank or very brief.  When blank, the Advanced HTML block will show on the Index or Portal page as a plain block, just like the HTML block does.  When there is text, the Advanced HTML block will show like all the other blocks, complete with a block title bar containing the text you enter here.<br /><br />";
##$pgv_lang["index_htmlplus_template_help"]	= "~#pgv_lang[htmlplus_block_templates]#~<br />To assist you in getting started with this block, we have created several standard templates.  When you select one of these templates, the text area will contain a copy that you can then alter to suit your site's requirements.<br /><br />";
##$pgv_lang["index_htmlplus_content_help"]	= "~#pgv_lang[htmlplus_block_content]#~<br />Unlike the #pgv_lang[html_block_name]#, #pgv_lang[gedcom_news_block]#, and #pgv_lang[gedcom_stats_block]# blocks, you have full control over the appearance of your block.  You can use HTML tags, and the block uses the CSS style sheets from the currently active theme.  References to information from the currently active genealogical database can be included in the text.<br /><br />Database references are signalled in the text by enclosing keywords within paired <b>&#35;</b> symbols.  For example, <b>&#35;totalFamilies&#35;</b> represents the number of families in the database.  On occasion, you may wish to use a database reference as text instead of its true meaning.  To do so, you need to replace the <b>&#35;</b> symbols enclosing the keyword by their symbolic equivalent.  For example, if your text contains <b>&amp;&#35;35;totalFamilies&amp;&#35;35;</b> it will print as <b>&#35;totalFamilies&#35;</b> instead of becoming a database reference.<br /><br />For a full example of the use of this block, please examine the &quot;#pgv_lang[gedcom_stats_block]#&quot; template found in the blocks/ directory, it uses most of the styles of tags, including language and help text links.<br /><br />The <b>#pgv_lang[htmlplus_block_keyword]#</b> template contains a full list of all supported keywords.<br /><br />";
##$pgv_lang["index_htmlplus_compat_help"]	= "~#pgv_lang[htmlplus_block_compat]#~<br />Enable compatibility with older versions of this block.  When checked, both old and new keywords will be recognized and acted upon.<br /><br />For example, the text <b>&#35;TOTAL_FAM&#35;</b> will be recognized as being equivalent to <b>&#35;totalFamilies&#35;</b>, <b>&#35;FIRST_DEATH_PLACE&#35;</b> to <b>&#35;firstDeathPlace&#35;</b>, <b>&#35;TOP10_BIGFAM&#35;</b> to <b>&#35;topTenLargestFamily&#35;</b>, etc.<br /><br />Unless absolutely necessary, you should not use Compatibility mode.<br /><br />";
##$pgv_lang["index_htmlplus_gedcom_help"] = "~#pgv_lang[htmlplus_block_gedcom]#~<br />Select the database to which the keywords apply.<br /><br />Your site supports several databases.  Keywords such as <b>&#35;totalFamilies&#35;</b> can only refer to one database.  You can identify the database that is to be consulted for all such keywords.  Each #pgv_lang[htmlplus_block_name]# block can only access one database.<br /><br />";
##$pgv_lang["showUnknown_help"]	= "~#pgv_lang[showUnknown]#~<br />Hide or show the list of given names of persons of unknown gender.<br /><br />The #pgv_lang[block_givn_top10]# block always hides the list of given names when no persons of that gender exist in your database.  This option lets you hide the list of persons of unknown gender even when there are such persons in your database.<br /><br />";

//-- Index-Page Help
##$pgv_lang["help_help"]				= "Of course, it would be ideal to create a program so simple and easy to use that it doesn't need any explanation at all; it should be as simple as reading a book.<br /><br />Although PhpGedView is very complicated, you should not notice that as you use it; almost everything can be used without explanation.  But, since we may have a lot of visitors and users who are not very experienced with the use of a computer or with the Internet, we offer you some help at certain places.<br /><br />You will find the following items in the Help menu:";
##$pgv_lang["help_page_help"]			= "<dl><dt><b>Help with this Page</b></dt><dd>For all pages there is a general \"Page Help\" available.  You can click this item in the menu to get \"Page Help\", where you will be informed about the items on that very page.<br /><br />Page Help is often brief.  If you need more help or information about a certain item on the page than Page Help provides you can use the \"Contextual Help\" feature.</dd></dl>";
##$pgv_lang["help_content_help"]		= "<dl><dt><b>Help Contents</b></dt><dd>When you click this menu item, you will get a Help page that displays an index of the major Help topics.  The amount of Help information available will be increased as time permits.</dd></dl>";
##$pgv_lang["help_faq_help"]			= "<dl><dt><b>FAQ List</b></dt><dd>#pgv_lang[text_faq_help]#</dd></dl>";
##$pgv_lang["help_HS_help"]			= "<dl><dt><b>#pgv_lang[hs_title]#</b></dt><dd>#pgv_lang[hs_intro]#</dd></dl>";
##$pgv_lang["help_qm_help"]			= "<dl><dt><b>Hide / Show Contextual Help</b></dt><dd>This last menu item could be the most useful for you. Clicking this link will either switch on or off the \"Contextual Help\".<br /><br />With Contextual Help switched on, you may find a Question Mark or similar icon beside some links, drop-down boxes, or buttons. When you click this icon, a Help screen will pop up.  This Help screen contains information about that object.<br /><br />Of course, when you click \"Hide Contextual Help\", all the Question Marks or icons will disappear until you click \"Show....\" again.</dd></dl>";

//-- Index-page Definitions
##$pgv_lang["def_help"]				= "<div class=\"name_head\"><center><b>#pgv_lang[definitions]#</b></center></div><br />Here are some explanations of terms used in this Help text:<ul><li><a href=\"#def_gedcom\"><b>GEDCOM</b></a><br /></li><li><a href=\"#def_gedcom_date\"><b>Dates</b></a></li><li><a href=\"#def_pdf_format\"><b>PDF file format</b></a></li><li><a href=\"#def_pgv\"><b>PhpGedView</b></a></li><li><a href=\"#def_portal\"><b>Portal</b></a></li><li><a href=\"#def_theme\"><b>Theme</b></a></li></ul><br />";
##$pgv_lang["def_portal_help"]			= "~Portal~<br />This site's Portal is like the lobby of a restaurant or a public library. It is the place where you enter, but you can also find important information like explanations, menus etc.<br /><br />";
##$pgv_lang["def_gedcom_help"]			= "~GEDCOM file~<br />A quote from the Introduction to the GEDCOM 5.5.1 Standard:<div class=\"list_value_wrap\">GEDCOM was developed by the Family History Department of The Church of Jesus Christ of Latter-day Saints (LDS Church) to provide a flexible, uniform format for exchanging computerized genealogical data.&nbsp; GEDCOM is an acronym for <i><b>GE</b></i>nealogical <i><b>D</b></i>ata <i><b>Com</b></i>munication.&nbsp; Its purpose is to foster the sharing of genealogical information and the development of a wide range of inter-operable software products to assist genealogists, historians, and other researchers.</div><br />A copy of the GEDCOM 5.5.1 <u>draft</u> Standard, to which PhpGedView adheres, can be downloaded in PDF format here:&nbsp; <a href=\"http://www.phpgedview.net/ged551-5.pdf\" target=\"_blank\">GEDCOM 5.5.1 Standard</a>  This Standard is only available in English.<br /><br />The GEDCOM file contains all the information about the family. All facts, dates, events, etc. are stored here. GEDCOM files have to follow strict rules because they must be exchangeable between many programs, independent of platforms or operating systems.<br /><br />";
##$pgv_lang["def_gedcom_date_help"]		= "~Dates in a GEDCOM file~<br />Although the date field allows for free-form entry (meaning you can type in whatever you want), there are some rules about how dates should be entered according to the GEDCOM 5.5.1 standard.<ol><li>A full date is entered in the form DD MMM YYYY.  For example, <b>01&nbsp;MAR&nbsp;1801</b> or <b>14&nbsp;DEC&nbsp;1950</b>.</li><li>If you are missing a part of the date, you can omit that part.  E.g. <b>MAR&nbsp;1801</b> or <b>14&nbsp;DEC</b>.</li><li>If you are not sure or the date is not confirmed, you could enter <b>ABT&nbsp;MAR&nbsp;1801</b> (abt = about), <b>BEF&nbsp;20&nbsp;DEC&nbsp;1950</b> (bef = before), <b>AFT&nbsp;1949</b> (aft = after)</li><li>Date ranges are entered as <b>FROM&nbsp;MAR&nbsp;1801&nbsp;TO&nbsp;20&nbsp;DEC&nbsp;1810</b> or as <b>BET&nbsp;MAR&nbsp;1801&nbsp;AND&nbsp;20&nbsp;DEC&nbsp;1810</b> (bet = between)<br /><br />The <b>FROM</b> form indicates that the event being described happened continuously between the stated dates and is used with events such as employment. The <b>BET</b> form indicates a single occurrence of the event, sometime between the stated dates and is used with events such as birth.<br /><br />Imprecise dates, where the day of the month or the month is missing, are always interpreted as the first or last possible date, depending on whether that imprecise date occurs before or after the separating keyword.  For example, <b>FEB&nbsp;1804</b> is interpreted as <b>01&nbsp;FEB&nbsp;1804</b> when it occurs before the TO or AND, and as <b>29&nbsp;FEB&nbsp;1804</b> when it occurs after the TO or AND.</li></ol><b>Be sure to enter dates and abbreviations in <u>English</u>,</b> because then the GEDCOM file is exchangeable and PhpGedView can translate all dates and abbreviations properly into the currently active language.  Furthermore, PhpGedView does calculations using these dates. If improper dates are entered into date fields, PhpGedView will not be able to calculate properly.<br /><br />You can click on the Calendar icon for help selecting a date.<br /><br />";
##$pgv_lang["def_gramps_help"]		= "~GRAMPS XML Database file~<br />A quote from GRAMPS Project: <div class=\"list_value_wrap\">GRAMPS helps you track your family tree. It allows you to store, edit, and research genealogical data. GRAMPS attempts to provide all of the common capabilities of other genealogical programs, but, more importantly, to provide an additional capability of integration not common to these programs. This is the ability to input any bits and pieces of information directly into GRAMPS and rearrange/manipulate any/all data events in the entire data base (in any order or sequence) to assist the user in doing research, analysis and correlation with the potential of filling relationship gaps.</div><br />A copy of the GRAMPS XML format v1.1.0 <a href=\"http://www.gramps-project.org/xml/1.1.0/\" target=\"_blank\">can be found here</a> in both RELAX NG Schema format and DTD format.<br /><br />For more information about the GRAMPS Project visit <a href=\"http://gramps-project.org/\" target=\"_blank\">http://gramps-project.org/</a>";
##$pgv_lang["def_pgv_help"]			= "~PhpGedView~<br />PhpGedView (or PGV) does not just put static pages on the Web; it is dynamic and can be customized in many ways.<br /><br />PhpGedView was created by John Finlay to view GEDCOM files online.  John started developing the program on his own.  An international team of developers and translators has since joined him and is working to improve the program.  Among the more significant features that have been added or improved in the program are its extensive support of languages other than English, and the ability to add and edit events online.<br /><br />";
##$pgv_lang["def_theme_help"]			= "~Theme~<br />This site can have different \"appearances\", called Themes.<br /><br />The site administrator chooses a default Theme, which everybody who enters this site will initially see. When the administrator has enabled this feature, all users can select their own Themes.  PhpGedView remembers the last selected Theme for each logged-in user, so that that user will automatically see that Theme the next time he logs in.  Themes can be used as a way to distinguish between different databases on the same site.  Each database can have a different default Theme.<br /><br />";

//-- Index-page MyGEDCOM
##$pgv_lang["mygedview_portal_help"]		= "~#pgv_lang[mygedview]#~<br />This is your Personal #pgv_lang[mgv]# page.<br /><br />Here you will find easy links to access your personal data such as <b>My Account</b>, <b>My Indi</b> (this is your #pgv_lang[indi_info]# page), and <b>My Pedigree</b>.  You can have blocks with <b>Messages</b>, a <b>Journal</b> (like a Notepad) and many more.<br /><br />The layout of this page is similar to the Welcome page that you see when you first access this site.  While the parts of the Welcome page are selected by the site administrator, you can select what parts to include on this personalized page.  You will find the link to customize this page in the Welcome block or separately when the Welcome block is not present.<br /><br />You can choose from the following blocks:<ul><li><a href=\"#mygedview_welcome\"><b>Welcome</b></a></li><li><a href=\"#mygedview_customize\"><b>Customize MyGedView</b></a></li><li><a href=\"#mygedview_message\"><b>Messages</b></a></li><li><a href=\"#mygedview_events\"><b>Upcoming events</b></a></li><li><a href=\"#mygedview_onthisday\"><b>On this Day in Your History</b></a></li><li><a href=\"#mygedview_charts\"><b>Charts</b></a></li><li><a href=\"#mygedview_favorites\"><b>My Favorites</b></a></li><li><a href=\"#mygedview_stats\"><b>GEDCOM Statistics</b></a></li><li><a href=\"#mygedview_myjournal\"><b>My Journal</b></a></li><li><a href=\"#mygedview_media\"><b>Random Media</b></a></li><li><a href=\"#mygedview_loggedin\"><b>Logged In Users</b></a></li><li><a href=\"#mygedview_recent_changes\"><b>Recent Changes</b></a></li></ul><br />";
##$pgv_lang["mygedview_customize_help"]		= "~CUSTOMIZE #pgv_lang[mygedview]#~<br />When you entered here for the first time, you already had some blocks on this page.  If you like, you can customize this Portal page.<br /><br />When you click this link you will be taken to a form where you can add, move, or delete blocks.  More explanation is available on that form.<br /><br />";
##$pgv_lang["mygedview_message_help"]		= "~MESSAGES BLOCK ~<br />In this block you will find the messages sent to you by other users or the admin.  You too can send messages to other users or to the admin.<br /><br />The PhpGedView mail system is designed to help protect your privacy.  You don't have to leave your email address here and others will not be able to see your email address.<br /><br />To expand a message, click on the message subject or the \"<b>+</b>\" symbol beside it.  You can delete multiple messages by checking the boxes next to the messages you want to delete and clicking on the <b>Delete Selected Messages</b> button.<br /><br />";
##$pgv_lang["mygedview_favorites_help"]		= "~MY FAVORITES BLOCK~<br />Favorites are similar to bookmarks.<br /><br />Suppose you have somebody in the family tree whose record you want to check regularly.  Just go to the person's #pgv_lang[indi_info]# page and select the <b>Add to My Favorites</b> option from the Favorites drop-down list. This person is now book marked and added to your list of favorites.<br /><br />Wherever you are on this site, you can click on a name in the \"My Favorites\" drop-down list in the header.  This will take you to the #pgv_lang[indi_info]# page of that person.<br /><br />";
##$pgv_lang["mygedview_myjournal_help"]		= "~MY JOURNAL BLOCK~<br />You can use this journal to write notes or reminders for your own use.  When you make such a note, it will still be there the next time you visit the site.<br /><br />These notes are private and will not be visible to others.<br /><br />";
##$pgv_lang["mygedview_welcome_help"]		= "~WELCOME BLOCK~<br />The Welcome block shows you:<ul><li>The current GEDCOM file</li><li>The date and time</li><li>Links to:<ul><li>#pgv_lang[myuserdata]#</li><li>#pgv_lang[my_pedigree]#</li><li>#pgv_lang[my_indi]#</li><li>#pgv_lang[customize_page]#</li></ul></li></ul><br /><b>Note:</b><br />You will see the links to <b>My Indi</b> and <b>My Pedigree</b> only if you are known to the current GEDCOM file.  You might have a record in one GEDCOM file and therefore see the <b>My Indi</b> and <b>My Pedigree</b> links, while in another GEDCOM file you do not have a record and consequently these links are not displayed.<br /><br />";

//-- Pedigree-page
##$pgv_lang["help_pedigree.php"]			= "~THE PEDIGREE PAGE~<br />A pedigree is an enumeration of all ancestors of the starting person.  Users who are not logged in see the pedigree of the starting (root) person chosen by the site administrator.  Logged in users can select their own starting (root) person.<br /><br />In this context, \"All ancestors\" means the father and mother, their parents, and so on.  The pedigree is displayed graphically; you don't have to struggle through pages of text to determine your ancestors.<br /><br />All individuals are displayed in Name boxes on the screen.<br /><ul><li><b>Name boxes on the pedigree</b><br />If the Pedigree page is set to show details, you will see the person's name and birth and death dates.  You can click on a person's name to take you directly to the #pgv_lang[indi_info]# page of that person.<br /><br />When <b>Show details</b> is on there are two icons inside the name box.</li><li><b>Pedigree icon inside the Name box</b><br />When the option <b>Show Details</b> is on, you see a Pedigree icon in the Name box. Depending on the site settings, you have to hover over the icon or click on it.  When you click on or hover over this icon, a small sub-menu appears.<br /><br />The items <b>#pgv_lang[index_header]#</b> and <b>#pgv_lang[descend_chart]#</b> are similar to those items in the main menu, but the difference is that the starting person is now the individual of mentioned in the Name box.  You also see <b>#pgv_lang[as_spouse]#</b>. Underneath that you see the name of the spouse followed by the names of the children.  All names are clickable.</li><li><b>Magnifying glass inside the Name box</b><br />Depending on the site settings, you have to hover over the icon or click on it.  This magnifies the Name box so that more details will be displayed.  You will see more dates and events. Names are clickable.</li><li><b>Arrows</b><br />On the left or right of the leftmost or rightmost Name boxes you may see arrows.  When you click on these arrows the screen display will shift in the direction of the arrow.</li></ul><br />#pgv_lang[context_help]#<br /><br />";
##$pgv_lang["show_full_help"]			= "~HIDE  OR  SHOW  DETAILS~<br /><br />With this option you can either show or hide all details in the Name boxes.  You can display more boxes on one screen when the details are hidden.<br /><br />When all details are hidden, the Zoom icon described below is not shown.  However, if the administrator has enabled the Zoom function, the entire box will act like a Zoom icon to reveal full details about the person.<br /><br />When the details are not hidden and the Zoom function, identified by a magnifying glass icon, has been enabled by the administrator, you can reveal even more details about that person.  If you normally have to click on the Zoom icon to zoom in, you can reveal additional hidden details by clicking that icon here.  Similarly, if you can zoom in by hovering over the Zoom icon, hidden details will be revealed by hovering over that icon here.<br /><br />If you have clicked on the Zoom icon to reveal more details, you can restore the box to its normal level of detail by clicking on the Zoom icon again.  If you have revealed more details by simply moving the mouse pointer over the Zoom icon, the box will be restored to its normal level of detail when you move the mouse pointer away from the Zoom icon.<br /><br />";
##$pgv_lang["talloffset_help"]			= "~PAGE LAYOUT~<br /><br />With this option you determine the page layout orientation.<br /><br />Changing this setting might be useful if you want to make a screen print or if you have a different type of screen.  <b>Portrait</b> mode will make the tree taller, such that a 4 generation chart should fit on a single page printed vertically.  <b>Landscape</b> mode will make a wider tree that should print on a single page printed horizontally.<br /><br />Your choice depends on the capabilities of your printer and also on what you intend to do with the printed page.<br /><br />";
##$pgv_lang["rootid_help"]			= "~NEW ROOT PERSON~<br /><br />If you want to display a chart with a new starting (root) person, the ID of that new starting person is typed here.<br /><br />If you don't know the ID of that person, use the <b>Find ID</b> link.<br /><br /><b>ID NUMBER</b><br />The ID numbers used inside PhpGedView are <u>not</u> the identification numbers issued by various governments (driving permit or passport numbers, for instance).  The ID number referred to here is simply a number used within the database to uniquely identify each individual; it was assigned by the ancestry program that created the GEDCOM file which was imported into PhpGedView.<br /><br />";
##$pgv_lang["PEDIGREE_GENERATIONS_help"]		= "~NUMBER OF GENERATIONS~<br /><br />Here you can set the number of generations to display on this page.<br /><br />The right number for you depends of the size of your screen and whether you show details or not.  Processing time will increase as you increase the number of generations.<br /><br />";

//-- LOGIN-page
##$pgv_lang["login_page_help"]			= "~THE LOGIN PAGE~<br /><br />On this page you can login, request a new password, or request a new user account.<br />";
##$pgv_lang["username_help"]			= "~USER NAME~<br /><br />In this box you type your user name.<br /><br /><b>The user name is case sensitive.</b>  This means that <b>MyName</b> is <u>not</u> the same as <b>myname</b> or <b>MYNAME</b>.<br /><br />";
##$pgv_lang["password_help"]			= "~PASSWORD~<br /><br />In this box you type your password.<br /><br /><b>The password is case sensitive.</b>  This means that <b>MyPassword</b> is <u>not</u> the same as <b>mypassword</b> or <b>MYPASSWORD</b>.<br /><br />";
##$pgv_lang["login_buttons_help"]			= "~LOGIN BUTTONS~<br /><br />Here you see two buttons to login to the system.<br /><br />The page you will be taken to or sent back to depends on which button you click after typing your user name and password.<br /><ul><li>The <b>#pgv_lang[login]#</b> button<br />If you click this button, you will return to the page you were just on, but with logged-in access rights.<br /><br />For example, if you click <b>#pgv_lang[login]#</b> when you were at the Pedigree page, you will return to that same page.  If you click this button when you were on the main Welcome page, you will be taken to the #pgv_lang[mygedview]# page.</li><li>The <b>#pgv_lang[admin]#</b> button<br />If you have Admin rights, you can click this button to go directly to the main Administration page.</li></ul><br />";
##$pgv_lang["login_buttons_aut_help"]		= "~AUTHENTICATION MODE LOGIN BUTTONS~<br /><br />Here you see two buttons to login to the system.<br /><br />The page you will be taken to depends on which button you click after typing your user name and password.<br /><ul><li>The <b>#pgv_lang[login]#</b> button<br />If you click this button, you will be logged in and go directly to your #pgv_lang[mygedview]# page, where you can edit your settings, add or edit favorites, send and read messages, etc.</li><li>The <b>#pgv_lang[admin]#</b> button<br />If you have Admin rights, you can click this button to go directly to the main Administration page.</li></ul><br />";
##$pgv_lang["new_password_help"]			= "~REQUEST NEW PASSWORD~<br /><br />If you have forgotten your password, you can click this link to request a new password.<br /><br />You will be taken to the \"Lost Password Request\" page.<br /><br />";
##$pgv_lang["new_user_help"]			= "~REQUEST NEW USER ACCOUNT~<br /><br />If you are a visitor to this site and wish to request a user account, you can click this link.<br /><br />You will be taken to the \"Register\" page.<br /><br />";
##$pgv_lang["mygedview_login_help"]		= "In order to access the #pgv_lang[mygedview]# page, you must be a registered user on the system.  On the #pgv_lang[mygedview]# page you can bookmark your favorite people, keep a user journal, manage messages, see other logged in users, and customize various aspects of PhpGedView pages.<br /><br />Enter your User name and Password in the appropriate fields to login to #pgv_lang[mgv]#.<br /><br />";
##$pgv_lang["new_user_firstname_help"]		= "~#pgv_lang[firstname]#~<br /><br />In this box you have to type your first name.<br /><br />We need your first and last names to determine whether you qualify for an account at this site, and what your rights should be.  These names will be visible to other logged-in family members and users.<br /><br />";
##$pgv_lang["new_user_lastname_help"]		= "~#pgv_lang[lastname]#~<br /><br />In this box you have to type your last name.<br /><br />We need your first and last names to determine whether you qualify for an account at this site, and what your rights should be.  These names will be visible to other logged-in family members and users.<br /><br />";
##$pgv_lang["register_info_01"]		= "~REQUEST NEW USER ACCOUNT~<br /><br />The amount of data that can be publicly viewed on this website may be limited due to applicable law concerning privacy protection. Many people do not want their personal data publicly available on the Internet. Personal data could be misused for spam or identity theft.<br /><br />Access to this site is permitted to every visitor who has a user account. After the administrator has verified and approved your account application, you will be able to login.<br /><br />If Relationship Privacy has been activated you will only be able to access your own close relatives' private information after logging in. The administrator can also allow database editing for certain users, so that they can change or add information.<br /><br />If you need any further support, please use the link below to contact the administrator.<br /><br />";
##$pgv_lang["register_info_02"]		= "~REQUEST NEW USER ACCOUNT~<br /><br />The amount of data that can be publicly viewed on this website may be limited due to applicable law concerning privacy protection. Many people do not want their personal data publicly available on the Internet. Personal data could be misused for spam or identity theft.<br /><br />Access to this site is permitted to <u>authorized</u> users only. After the administrator has verified and approved your account application, you will be able to login and view the private data.<br /><br />If Relationship Privacy has been activated you will only be able to access your own close relatives' private information after logging in. The administrator can also allow database editing for certain users, so that they can change or add information.<br /><br />If you need any further support, please use the link below to contact the administrator.<br /><br />";
##$pgv_lang["register_info_03"]		= "~REQUEST NEW USER ACCOUNT~<br /><br />The amount of data that can be publicly viewed on this website may be limited due to applicable law concerning privacy protection. Many people do not want their personal data publicly available on the Internet. Personal data could be misused for spam or identity theft.<br /><br />Access to this site is permitted to <u>family members only</u>. After the administrator has verified and approved your account application, you will be able to login and view the private data.<br /><br />If Relationship Privacy has been activated you will only be able to access your own close relatives' private information after logging in. The administrator can also allow database editing for certain users, so that they can change or add information.<br /><br />If you need any further support, please use the link below to contact the administrator.<br /><br />";


//-- Descendancy-page
##$pgv_lang["help_descendancy.php"]		= "~THE DESCENDANCY PAGE~<br /><br />This page will show the descendants of a person.<br /><br />You can choose a starting (root) person for this Descendancy chart or you can be linked to this page by clicking the <b>#pgv_lang[descend_chart]#</b> link on another page.  Click on Arrow icons to navigate this tree in the direction of the arrow.  Click on the Chart icon in any Person box to change the root of the tree to that person.<br /><br />";
##$pgv_lang["desc_rootid_help"]			= "#pgv_lang[rootid_help]#";
##$pgv_lang["desc_generations_help"]		= "#pgv_lang[PEDIGREE_GENERATIONS_help]#";

//-- Time line-page
##$pgv_lang["help_lifespan.php"]			= "~LIFESPAN CHART~<br /><br />On this chart you can display one or more persons along a horizontal timeline.  This chart allows you to see how the lives of different people overlapped.<br /><br />You can add people to the chart individually or by family groups by their IDs.  The previous list will be remembered as you add more people to the chart.  You can clear the chart at any time with the <b>Clear Chart</b> button.<br /><br />You can also add people to the chart by searching for them by date range or locality.<br /><br />";
##$pgv_lang["lifespan_add_person_help"]			= "#pgv_lang[add_person_help]#~Include Immediate Family CheckBox~<br/>Include Immediate Family is checked by default.  Leave checked to view the father, mother, spouse, siblings, and children of the individual being added to the timeline.  Uncheck if you wish to omit the immediate family.<br/><br/>";
##$pgv_lang["help_timeline.php"]			= "~TIMELINE CHART~<br /><br />On this chart you can display one or more persons along a timeline.  You can, for example, visualize the status of two or more persons at a certain moment.<br /><br />If you click the <b>Time Line</b> link on an other page you will already see one person on the Time Line.  If you clicked the <b>Time Line</b> menu item in a page header, you have to supply the starting person's ID.<br /><br />";
##$pgv_lang["add_person_help"]			= "~ADD PERSON TO THE CHART~<br /><br />You can have several persons on the timeline.<br /><br />Use this box to supply each person's ID.  If you don't know the ID of the person, you can click the <b>Find ID</b> link next to the box.<br /><br />";
##$pgv_lang["remove_person_help"]			= "~REMOVE PERSON FROM THE CHART~<br /><br />Click this link to remove the person from the timeline.<br /><br />";
##$pgv_lang["show_age_marker_help"]		= "~SHOW AGE MARKER~<br /><br />If you check this box, you will see an Age marker.<br /><br />You can slide this Age marker up or down along the time line.  The sliding Age marker is a nice tool to check the age of a person at a certain event.  You can enable or disable the Age marker individually for each person in the chart.<br /><br />";
##$pgv_lang["timeline_control_help"] = "~LIFESPAN CONTROLS~<br/><br/>~SPEED~<br/>Click the drop down menu to change the speed at which the timeline scrolls.<br/><br/>~Begin Year~<br/>Enter the starting year of the range.<br/><br/>~End Year~<br/>Enter the ending year of the range.<br/><br/>~Search~<br/>Click the Search button to begin searching for events that occurred within the range identified by the Begin Year and End Year fields.<br/><br/>";

//-- Relationship-page
##$pgv_lang["help_relationship.php"]		= "~RELATIONSHIP PAGE~<br /><br />On this page you can display the relationship between any two people.  These people do not have to be directly related by blood line;  any relation will be found.<br /><br />";
##$pgv_lang["relationship_id_help"]		= "~IDs of PERSON 1 and PERSON 2~<br /><br />If you have jumped from another page to this one by having clicked the <b>Relation to me</b> link, you will see here the relationship between yourself and that other individual.<br /><br />If you arrived at this page through the <b>Relationship Chart</b> menu entry on any page header, you have to type the identifier numbers of the two people whose relationship you wish to see.  If you don't know the identifier of the desired person, you can click the <b>Find ID</b> link.<br /><br />";
##$pgv_lang["next_path_help"]			= "~FIND NEXT PATH~<br /><br />You can click this button to see whether there is another relationship path between the two people.  Previously found paths can be displayed again by clicking the link with the path number.<br /><br />";
##$pgv_lang["follow_spouse_help"]			= "~CHECK RELATIONSHIP BY MARRIAGE - CHECK BOX~<br /><br />With this check box <b>un</b>checked, the relationships are only checked between blood relatives.  With this check box checked, relationships by marriage are also checked.  You will probably find more relationships by leaving this box checked.<br /><br />";
##$pgv_lang["line_up_generations_help"]	= "~LINE UP GENERATIONS - CHECK BOX~<br /><br />When this check box is checked, the chart will be printed with the same generations lining up horizontally on the page.  When it is unchecked, each generation will appear going down the page regardless of the type of relationship.<br /><br />";
##$pgv_lang["oldest_top_help"]          = "~SHOW OLDEST TOP - CHECK BOX~<br /><br />When this check box is checked, the chart will be printed with oldest people at the top.  When it is unchecked, youngest people will appear at the top.<br /><br />Note: This option works only if <b>#pgv_lang[line_up_generations]#</b> is also checked.<br /><br />";

//-- Ancestry-page
##$pgv_lang["help_ancestry.php"]		= "~#pgv_lang[ancestry_chart]# page~<br /><br />The Ancestry page is very similar to the <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, but with more details and alternate <a href=\"?help=chart_style_help\">#pgv_lang[chart_style]#</a> displays.<br /><br />Each ancestry is shown with a unique number, calculated according to the <i>Sosa-Stradonitz</i> system:<div style=\"padding-left:30px;\"><b>Even</b> numbers for men (child*2)<br /><b>Odd</b> numbers for women (husband+1) except for <b>1</b></div><br />Example:<br /><div style=\"padding-left:30px;\">The root person is <b>1</b>, regardless of gender.<br /><b>1</b>'s father is <b>2</b> (<b>1</b> * 2), mother is <b>3</b> (<b>2</b> + 1).<br /><b>2</b>'s father is <b>4</b> (<b>2</b> * 2), mother is <b>5</b> (<b>4</b> + 1).<br /><b>3</b>'s father is <b>6</b> (<b>3</b> * 2), mother is <b>7</b> (<b>6</b> + 1).<br /><b>7</b>'s father is <b>14</b> (<b>7</b> * 2), mother is <b>15</b> (<b>14</b> +1).<br />etc.</div><br />";
##$pgv_lang["box_width_help"]		= "~#pgv_lang[ancestry_chart]# box width~<br /><br />Here you can change the box width from 50% to 300%.  At 100% each box is about 270 pixels wide.<br /><br />";
##$pgv_lang["chart_style_help"]			= "~#pgv_lang[chart_style]#~<br />Two chart styles are available:<ul><li><b>#pgv_lang[chart_list]#</b><br />Vertical tree, with collapsible/expandable families.</li><li><b>#pgv_lang[chart_booklet]#</b><br />One family per page, with parents, grandparents, and all recorded children.<br /><br />This format is easy to print to give to your relatives.</li></ul><br />";

//-- Fan chart-page
##$pgv_lang["help_fanchart.php"]		= "~#pgv_lang[fan_chart]# page~<br /><br />The Circle Diagram is very similar to the <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, but in a more graphical way.<br /><br />The Root person is shown in the center, his parents on the first ring, grandparents on the second ring, and so on.<br /><br />Years of birth and death are printed under the name when known.<br /><br />Clicking on a name on the chart will open a links menu specific to that person.  From this menu you can choose to center the diagram on that person or on one of that person's close relatives, or you can jump to that person's #pgv_lang[indi_info]# page or a different chart for that person.<br /><br />";
##$pgv_lang["fan_width_help"]		= "~#pgv_lang[fan_chart]# width~<br /><br />Here you can change the diagram width from 50% to 300%.  At 100% the output image is about 640 pixels wide.<br /><br />";
##$pgv_lang["fan_style_help"]			= "~#pgv_lang[fan_chart]# style~<br /><br />This option controls the appearance of the diagram.<ul><li><b>1/2</b><br />Half circle 180&deg; diagram</li><li><b>3/4</b><br />Three-quarter 270&deg; diagram, sometimes called <i>Angel wing</i></li><li><b>4/4</b><br />Full circle 360&deg; diagram</li></ul><br />";

//-- Hourglass chart-page
##$pgv_lang["help_hourglass.php"]			= "~#pgv_lang[hourglass_chart]#~<br /><br />The Hourglass chart will show the ancestors and descendants of the selected root person on the same chart.  This chart is a mix between the Descendancy chart and the Pedigree chart.<br /><br />The root person is centered in the middle of the page with his descendants listed to the left and his ancestors listed to the right.  In this view, each generation is lined up across the page starting with the earliest generation and ending with the latest.<br /><br />If there is a downwards arrow on the screen under the root person, clicking on it will display a list of the root person's close family members that you can use the navigate down the chart.  Selecting a name from this list will reload the chart with the selected person as the new root person.";

//-- Family Book chart-page
##$pgv_lang["help_familybook.php"]	= "~#pgv_lang[familybook_chart]#~<br /><br />This chart is very similar to the Hourglass chart.  It will show the ancestors and descendants of the selected root person on the same chart.  It will also show the descendants of the root person in the same Hourglass format.<br /><br />The root person is centered in the middle of the page with his descendants listed to the left and his ancestors listed to the right.  In this view, each generation is lined up across the page starting with the earliest generation and ending with the latest.<br /><br />Each descendant of the root person will become the root person of an additional hourglass chart, printed on the same page.  This process repeats until the specified number of descendant generations have been printed.";
##$pgv_lang["fambook_descent_help"]	= "~#pgv_lang[descent_steps]#~<br /><br />This value determines the number of descendant generations of the root person that will be printed in Hourglass format.<br /><br />";

//-- Indilist-page
##$pgv_lang["help_indilist.php"]			= "~INDIVIDUALS LIST PAGE~<br /><br />On this page you can display a list of individuals.  The names will be displayed with surnames first and sorted into alphabetical order.<br /><br />The output of the Name list depends on:<ol><li>The letter you clicked in the Alphabetical index.</li><li>Whether you clicked \"Skip\" or \"Show\" Surname List.</li></ol>#pgv_lang[context_help]#<br /><br />";
##$pgv_lang["alpha_help"]				= "~ALPHABETICAL INDEX~<br /><br />Clicking a letter in the Alphabetical index will display a list of the names that start with the letter you clicked.<br /><br />The second to last item in the Alphabetical index can be <b>#pgv_lang[NN]#</b>.  This entry will be present when there are people in the database whose surname has not been recorded or does not contain any recognizable letters.  Unknown surnames are often recorded as <b>?</b>, and these will be recognized as <b>#pgv_lang[NN]#</b>.  This will also happen if the person is unknown.<br /><br /><b>Note:</b><br />Surnames entered as, for example, <b>Nn</b>, <b>NN</b>, <b>Unknown</b>, or even <b>N.N.</b> will <u>not</u> be found in the <b>#pgv_lang[NN]#</b> list. Instead, you will find these persons by clicking <b>N</b> or <b>U</b> because these are the initial letters of those names.  PhpGedView cannot possibly account for all possible ways of entering unknown surnames;  there is no recognized convention for this.<br /><br />At the end of the Alphabetical index you see <b>ALL</b>. When you click on this item, you will see a list of all surnames in the database.<br /><br /><b>Missing letters?</b><br />If your Alphabetical index appears to be incomplete, with missing letters, your database doesn't contain any surnames that start with that missing letter.<br /><br />";
##$pgv_lang["name_list_help"]			= "~NAME LIST~<br /><br />This box will display either a surname list or a complete name list.  In both cases all surnames will start with the initial letter that you clicked in the Alphabetical index, unless you clicked <b>ALL</b>.<br /><br />Whether you will see a surname list or the complete name list depends on the status of the <b>Skip/Show Surname Lists</b> link.<br /><br />";
##$pgv_lang["skip_sublist_help"]			= "~SKIP SUBLIST~<br /><br />The standard setting is that, after you have clicked a letter of the Alphabetical index, you will get a sub-list with surnames.  If you click this link, all individuals with surnames that have the currently selected initial letter will be displayed immediately. Thereafter, the list of individuals will be displayed directly whenever you click on a new initial letter in the Alphabetical list.<br /><br />To reverse this action, click on the #pgv_lang[show_surnames]# link.<br /><br />";
##$pgv_lang["show_marnms_help"]			= "~INCLUDE/EXCLUDE MARRIED NAMES~<br /><br />The individual and family list pages can either include or exclude married names.  This option can be helpful when searching for individuals or families where you only know the married name.  Married names can only be included if they already exist in the database.<br /><br />On the family list, this value defaults to exclude.  On the individual list, the default value is set in the GEDCOM Configuration page.<br /><br />When you change this option, your selection will be remembered until you log off or your session ends.<br /><br />";

//-- Families-page
##$pgv_lang["help_famlist.php"]		= "~FAMILY LIST PAGE~<br /><br />On this page you can display a list of families.  The names will be displayed with surnames first and sorted into alphabetical order.<br /><br />The output of the Name list depends on:<ol><li>The letter you clicked in the Alphabetical index.</li><li>Whether you clicked \"Skip\" or \"Show\" Surname List.</li></ol>You can search on the husband's or the wife's surname;  both are included in the list.<br /><br />#pgv_lang[context_help]#<br /><br />";
##$pgv_lang["help_family.php"]			= "~FAMILY DETAILS PAGE~<br /><br />This page will show you an overview of the family that you chose on a previous page.<br /><br />From top to bottom you will see the Personal Details boxes of the husband and his parents, the wife and her parents, and the children.<br /><br />The layout and contents of the Person Boxes are the same as the boxes that you already know from the Pedigree and Descendancy pages.<br /><br />To the right of the Parent boxes you may see an arrow if more ancestors exist in the file. When you click that arrow, you will move up a generation to show you a new family page with the previous parents now listed as the husband and wife.<br /><br />At the right side within the name box you may see a Zoom (magnifying glass) icon which you can click to reveal more details about the individual. When you click the name you will be taken to the #pgv_lang[indi_info]# page of that person.<br /><br />Also at the right side you will find a small menu to take you to pages with charts or more information.  Some of these menu items also have sub-menus which will appear when your mouse pointer approaches the parent menu item.<br /><br />The Family Group Information box shows all known facts and information about this family, such as marriage, multimedia objects, and notes. In the Fact Information box, clicking a place will take you to the Place list, where all other families and individuals who are connected to that place are shown. Clicking a date will jump to the Day calendar, which will show all events that happened on that day and month in history. Multi-media objects can be clicked; this will open a new window in which the object is viewed. When you click on the picture caption, you will see the picture on the #pgv_lang[media_list]# page. If you click on a Source link, the details of that source will be displayed on the Source page.<br /><br />Below the name boxes of the children you find the <b>Add a child to this Family</b> link.  Next to the name boxes of the children you see the <b>Family Group Information</b> link.  If you have enough rights, you can edit, delete, and add data and facts here.<br /><br />As with the #pgv_lang[indi_info]# page, you will see a menu at the top right of the page.  Entries in this menu take you to other pages where you can get information about this family or perform other tasks related to this family.#pgv_lang[more_help]#";
##$pgv_lang["add_child_help"]			= "~ADD CHILD TO THIS FAMILY~<br /><br />You can add a child to this family by clicking this link.<br /><br />Adding a child is simple: Just click the link, fill out the boxes in the pop up screen, and that's all.<br /><br />";
##$pgv_lang["show_fam_gedcom_help"]	= "~SHOW GEDCOM RECORD~<br /><br />The information about the family, as it is stored in the database, will be displayed when you click this link.  The display will show raw GEDCOM data.<br /><br />";
##$pgv_lang["add_fam_clip_help"]		= "~ADD FAMILY TO CLIPPINGS CART~<br /><br />You can add all or some of this family's information to your #pgv_lang[clip_cart]#. On the next page you can choose precisely how much information you wish to add:<ol><li>#pgv_lang[just_family]#</li><li>#pgv_lang[parents_and_family]#</li><li>#pgv_lang[parents_and_child]#</li><li>#pgv_lang[parents_desc]#</li></ol><br />";
##$pgv_lang["show_fam_timeline_help"]	= "~SHOW COUPLE ON TIMELINE CHART~<br /><br />When you click this link you will jump to the Timeline page, where all facts of the couple will be displayed on a timeline scale.<br /><br />";

//-- Source list-page
##$pgv_lang["help_sourcelist.php"]		= "~SOURCES LIST PAGE~<br /><br />A list of sources is displayed on this page.<br /><br />Unlike the #pgv_lang[indi_info]# and Family pages, there is no alphabetical index.<br /><br />A source can be an individual, a public database, an institution, an Internet resource, etc.  Because of the completely random nature of genealogical sources, it is impossible to find a sort order that is meaningful in all cases. However, PhpGedView <u>does</u> sort the Source names into alphabetical order.<br /><br /><b>SOURCES</b><br />Without sources we cannot build our database. There is a source for every item of information in the database. The source can be a relative, an institution, a public database, government or private records, an Internet resource, etc.<br /><br />A source can be linked to many persons. One person can also be linked to many sources. You can have different sources for every event, whether it is birth date, profession, marriage, children, etc.<br /><br />";
##$pgv_lang["sourcelist_listbox_help"]		= "~SOURCES LIST BOX~<br /><br />In this box you see the names of the sources as they are stored in the GEDCOM.<br /><br />The names are displayed in alphabetical order.  When you click on a name in the list, you will go to the Source page where a list is displayed.  This list shows you which individuals or families are linked to that source.<br /><br />";

//-- Sources-page
##$pgv_lang["help_source.php"]			= "~SOURCE DETAILS PAGE~<br /><br />The details of the source are displayed on this page. Sources are very important to genealogical researchers and will allow you to follow the trail another researcher used to find the information.<br /><br />You can see information about the source's title, author, publication, and the repository where the source was looked up. Because of the many different types of sources, some sources may have more information than others.<br /><br />If a multimedia object such as a scan of a document is connected to the source, you can view that object by clicking the object. When you click on the object name, you will see the object on the #pgv_lang[media_list]# page.<br /><br />Following the source details there is a list of all individuals and families who are connected to this source. This allows you to identify all items that were obtained from that data source.<br /><br />When the administrator has enabled these features, you will have one or two additional menu icons on this page:<ol><li><b>#pgv_lang[view_gedcom]#</b><br />which shows the information in GEDCOM format.</li><li><b>#pgv_lang[add_to_cart]#</b><br />which enables you to store this information in your #pgv_lang[clip_cart]# for later downloading and importing into your own genealogy program.</li></ol><br />#pgv_lang[context_help]#<br /><br />";
##$pgv_lang["sources_listbox_help"]		= "~RECORDS LINKED TO THIS SOURCE~<br /><br />In this box you see the names of individuals and families that are connected to the source.<br /><br />The names are displayed in alphabetical order.  When you click on a name in the list, you will go to the relevant Detail page.<br /><br />";
##$pgv_lang["show_source_gedcom_help"]	= "~SHOW GEDCOM RECORD~<br /><br />When you click this link, the source's records will be displayed in raw database format.<br /><br />";
##$pgv_lang["add_source_clip_help"]		= "~ADD SOURCE TO CLIPPINGS CART~<br /><br />When you click this link, you can add the source's information to your #pgv_lang[clip_cart]# for later downloading and importing into your own genealogy program.<br /><br />";
##$pgv_lang["delete_source_help"]			= "~DELETE SOURCE FROM GEDCOM~<br /><br />When you click this option, you will mark this Source to be deleted from the database.<br /><br />What does that mean?<br />Let's suppose you have a good reason to remove this source from the database. You click the link.  You will be asked to confirm your deletion request.  If you decide to continue, it can take a little time before you see a message that the source is deleted.<br /><br />When you continue with your visit, you will notice that the source is still visible and can be used as if the deletion had not occurred.<br /><br /><b>This is <u>not</u> an error.</b>  The site admin will get a message that a change has been made to the database, and that you removed the Source.<br />The administrator can accept or reject your change. Only after the administrator has accepted your change will the deletion actually occur <u>irreversibly</u>.  If there is any doubt about your change, the administrator will contact you.<br /><br />";

//-- Persons per Place-page
##$pgv_lang["help_placelist.php"]			= "~PLACE HIERARCHY~<br />(or Persons Per Place)<br /><br />This page will show you a hierarchy of the places in the GEDCOM and which individuals or families are connected to a location.<br /><br />If there is any connection between an individual or family and an event at a certain location, PhpGedView will find it.<br /><br />The results are displayed in a two-column list, one column for individuals and one for families.<br /><br />#pgv_lang[more_help]#";
##$pgv_lang["ppp_default_form_help"]		= "~PLACE ORDER FORMAT~<br /><br /><b>DEFAULT ORDER</b><br />This means that there is no place encoding format declared in this GEDCOM file and the default format is assumed.<br /><br />If another format had been found, it would have been shown between the <b>(</b> and <b>)</b> at the end of the line.<br /><br />";
##$pgv_lang["ppp_match_one_help"]			= "~PLACE ORDER FORMAT~<br /><br />GEDCOM ORDER<br />The locations are assumed to be encoded in the place format explicitly declared in the GEDCOM file.  This overrules the default order.";
##$pgv_lang["ppp_numfound_help"]			= "~FOUND PLACE CONNECTIONS~<br /><br />The number of matches that are found is displayed here.  If you still see a list box with locations you have not yet reached the lowest level.<br /><br />You can choose to view all records connected to this place or you can refine your search by clicking another location.<br /><br />";
##$pgv_lang["ppp_levels_help"]			= "~LOCATION LEVELS~<br /><br />This shows the levels that are displayed now.  The list box showing places is actually a sublist of the leftmost level.<br /><br />EXAMPLE:<br />The default order is #pgv_lang[default_form]#.<br />If the current level is \"Top Level\", the box will list all the countries in the database.<br />If the current level is \"U.S.A., Top Level\", the box will list all the states in the U.S.A.<br />etc.<br /><br />You can click a level to go back one or more steps.<br /><br />";
##$pgv_lang["ppp_placelist_help"]			= "~PLACE HIERARCHY~<br /><br />In this list you can see the locations that are found subordinate to the current location you have chosen.  If you have not yet selected a place, you will see a list of all of the top level locations (e.g. countries or states).<br /><br />The names of the locations in the list are clickable; clicking on a location works like a filter, you will be taken to the next level down.<br /><br />";
##$pgv_lang["ppp_placelist_help2"]		= "~PLACE LIST~<br /><br />In this list you can see the locations that have been found to this stage.<br /><br />The names of the locations in the list are clickable; clicking on a location works like a filter, you will be taken to the next level down.<br /><br />Only when you are in the top level will a name list not be displayed. At all subordinate levels you will get a list of families and individuals connected to that location.<br /><br />";
##$pgv_lang["ppp_view_records_help"]		= "~VIEW ALL RECORDS~<br /><br />Clicking on this link will show you a list of all of the individuals and families that have events occurring in this place.  When you get to the end of a place hierarchy, which is normally a town or city, the name list will be shown automatically.<br /><br />";
##$pgv_lang["ppp_name_list_help"]			= "~NAME LIST~<br /><br />This box will display a complete list of individuals and families that are connected to that location.<br /><br />The names in the list are clickable.  When you click a name, you will be taken to the relevant Detail page.  When you click on a location at the top of this list, you change your Location selection.<br /><br />";

//-- Multimedia-page
##$pgv_lang["help_medialist.php"]			= "~MULTIMEDIA OBJECT LIST~<br /><br />This page lists all of the Multimedia Objects (MMO) that can be found in this database.<br /><br />For each of the media items you see the title or filename of the item, names of the individuals or families connected to the item, and notes about the item.<br /><br />Clicking the title or filename of the item has the same effect as clicking its thumbnail.  The item will be opened in the image viewer built into PhpGedView or in the viewer specified in your browser's configuration.<br /><br />When you click on the \"View\" link next to the person or family, you will be taken to the relevant Details page.<br /><br />";

//-- Upload Media-page
##$pgv_lang["help_uploadmedia.php"]		= "~UPLOAD MEDIA FILES~<br /><br />Uploading media files is quite straightforward.  Here is a little additional information.<br /><br /><b>Thumbnails</b><br />Thumbnails should have a size somewhere around 100px width.  The thumbnail <u>must</u> be named identically to the full-size version.  If your system can generate thumbnails automatically, you will see a notice to that effect on the Upload Media page.<br /><br /><b>Uploading</b><br />Files will be uploaded automatically to the directory <b>#GLOBALS[MEDIA_DIRECTORY]#</b> for the full-sized version and to <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b> for the thumbnails.<br /><br />#pgv_lang[readme_help]#";

//-- Anniversaries-page
##$pgv_lang["help_calendar.php"]			= "~#pgv_lang[anniversary_calendar]#~<br /><br /><ul><li><a href=\"#calendar_general\"><b>General information</b></a></li><li><a href=\"#calendar_day\"><b>#pgv_lang[day]#</b></a></li><li><a href=\"#calendar_month\"><b>#pgv_lang[month]#</b></a></li><li><a href=\"#calendar_year\"><b>#pgv_lang[year]#</b></a></li><li><a href=\"#calendar_show\"><b>#pgv_lang[show]# / #pgv_lang[showcal]#</b></a></li><li><a href=\"#calendar_sex\"><b>#pgv_lang[sex]#</b></a></li><li><a href=\"#calendar_event\"><b>Event</b></a></li><li><a href=\"#calendar_button\"><b>View Day / View Month / View Year buttons</b></a></li><li><a href=\"#calendar_tip\"><b>Tip</b></a></li></ul><br /><a name=\"calendar_general\"></a>The #pgv_lang[anniversary_calendar]# shows the persons and families who are linked to an event at a certain day or month or during a certain period of time. It has an advanced filtering system to select the right date, period, and events for you.<dl><dt><b>View <a href=\"#calendar_day\">Day</a></b></dt><dd>This shows the events on a certain day, independent of the selected year. Output will be either a single list with the names of individuals or families, or a two-column list with individuals on one side and families on the other.</dd><dt><b>View <a href=\"#calendar_month\">Month</a></b></dt><dd>In this calendar the names of individuals and families are shown inside the Day boxes. The calendar is shown as it was in the year you entered into the Year box. All events that happened in the past up to that year are shown.<br /><br />In combination with the option <a href=\"#calendar_show\"><b>#pgv_lang[recent_events]#</b></a>, it will give a realistic view of what a calendar of your ancestors looked like.</dd><dt><b>View <a href=\"#calendar_year\">Year</a></b></dt><dd>This shows the events in a certain year or during a number of years. Output will be a list with the names of individuals or families, or a two-column list with individuals on one side and families on the other.</dd></dl>The currently shown day and month are highlighted in the calendar menu.<br /><br />All names and dates are clickable.  When you click on a name you will be taken to the relevant Details page. Clicking on a date will jump to \"Today\" or \"Year\" mode, which will display all events for the day and month in the clicked date.<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_day\"> </a>#pgv_lang[annivers_date_select_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_month\"> </a>#pgv_lang[annivers_month_select_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_year\"> </a>#pgv_lang[annivers_year_select_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_show\"> </a>#pgv_lang[annivers_show_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_sex\"> </a>#pgv_lang[annivers_sex_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_event\"> </a>#pgv_lang[annivers_event_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_button\"> </a>#pgv_lang[day_month_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_tip\"> </a>#pgv_lang[annivers_tip_help]#";
##$pgv_lang["annivers_date_select_help"]	= "~DAY SELECTOR~<br /><br />The top row of the Selector table is the <b>Day</b> selector.  Its meaning is obvious: You select a <u>day</u>.<br /><br />The result of clicking on a certain day depends of whether you are in <b>Day</b> or in <b>Month</b> mode.<br /><dl><dt><b>Day mode</b></dt><dd>In this mode, you click a day, the screen will refresh, and the list for that day will be displayed.</dd><dt><b>Month mode</b></dt><dd>You have the calendar of a certain month on the screen.  You click a day and the screen will refresh, but you will still see the month that you had on the screen before.  The reason for this is that you can still decide to select another month, year, or event before you either click the <b>#pgv_lang[viewday]#</b> or <b>#pgv_lang[viewmonth]#</b> button.<br /><br />At the end of the Day row you will see a <b>Quick Link</b> with today's date.  Clicking that <b>Quick Link</b> will display the list for today in <b>Day</b> mode, no matter whether you are in <b>Month</b> or in <b>Day</b> mode.</dd></dl>";
##$pgv_lang["annivers_month_select_help"]	= "~MONTH SELECTOR~<br /><br />The middle row of the Selector table is the <b>Month</b> selector.  Its meaning is obvious: You select a <u>month</u>.<br /><br />The result of clicking on a certain month depends of whether you are in <b>Day</b> or in <b>Month</b> mode.<br /><dl><dt><b>Day mode</b></dt><dd>In this mode, you click a month, the screen will refresh, and the list for that month will be displayed.  All other selections like day, year, and events will be unchanged.</dd><dt><b>Month mode</b></dt><dd>When you have the calendar on the screen and click a month in the <b>Month</b> row, the calendar for that new month will be displayed.<br /><br />At the end of the Month row you will see a <b>Quick Link</b> with today's month and year.  Clicking that <b>Quick Link</b> will display the list for that month in <b>Month</b> mode, no matter whether you are in <b>Month</b> or in <b>Day</b> mode.</dd></dl>";
##$pgv_lang["annivers_year_select_help"]	= "~YEAR INPUT BOX~<br /><br />This input box lets you change that year of the calendar.  Type a year into the box and press <b>Enter</b> to change the calendar to that year.<br /><br /><b>Advanced features</b> for <b>#pgv_lang[viewyear]#</b><dl><dt><b>More than one year</b></dt><dd>You can search for dates in a range of years.<br /><br />Year ranges are <u>inclusive</u>.  This means that the date range extends from 1 January of the first year of the range to 31 December of the last year mentioned.  Here are a few examples of year ranges:<br /><br /><b>1992-5</b> for all events from 1992 to 1995.<br /><b>1972-89</b> for all events from 1972 to 1989.<br /><b>1610-759</b> for all events from 1610 to 1759.<br /><b>1880-1905</b> for all events from 1880 to 1905.<br /><b>880-1105</b> for all events from 880 to 1105.<br /><br />To see all the events in a given decade or century, you can use <b>?</b> in place of the final digits. For example, <b>197?</b> for all events from 1970 to 1979 or <b>16??</b> for all events from 1600 to 1699.<br /><br/>Selecting a range of years will change the calendar to the year view.</dd></dl>";
##$pgv_lang["annivers_show_help"]			= "~SHOW EVENTS OF...~<br />The following options are available:<br /><ol><li><b>All People</b><br />With this option, all individuals and families are displayed.</li><li><b>Recent Years (&lt;100 yrs)</b><br />With this option you will see all events for the chosen day or month, but no events older than 100 years will be shown.</li><li><b>Living People</b><br />Unless the administrator has configured PhpGedView so that living people are visible to anyone, this option will only be available to you after you have logged in.<br /><br />With this option, only the events of living persons will be displayed.</li></ol>When you click on an option, the events of your choice will be displayed.<br /><br />The settings of day, month, and year, as well as <b>Day</b> or <b>Month</b> mode, remain as they were.<br /><br />";
##$pgv_lang["annivers_sex_help"]			= "~GENDER SELECTOR~<br />When you are logged in or when the admin has not enabled the Privacy option, you can select one of these options:<ol><li><b>All</b> icon<br />This is the default option. The events of all individuals and families are displayed.</li><li><b>Male</b> icon<br />Only events of male individuals are displayed. Only male members of families will be displayed with Family events.</li><li><b>Female</b> icon<br />Only events of female individuals are displayed. Only female members of families will be displayed with Family events.</li></ol>When you click on an option, the events of your choice will be displayed.<br /><br />The settings of day, month, and year, as well as <b>Day</b> or <b>Month</b> mode, remain as they were.<br /><br />";
##$pgv_lang["annivers_event_help"]		= "~EVENT SELECTOR~<br />Here you choose whether you want all events for individuals and families displayed or just a selected event.  You cannot select more than one event category.<br /><br />When you click on an option, the events of your choice will be displayed.<br /><br />The settings of day, month, and year, as well as <b>Day</b> or <b>Month</b> mode, remain as they were.<br /><br />";
##$pgv_lang["annivers_tip_help"]			= "~TIP~<br />Adjust the Date selector to any date in the past.<br /><br />When you click on one of the View buttons you will see a list or calendar for that date.  All the ages, anniversaries, etc. have been recalculated and now count from the date you set in the Date selector.  You are now seeing the calendar or list that your ancestor would have seen on that date, years ago.<br /><br />";
##$pgv_lang["day_month_help"]				= "~VIEW DAY / VIEW MONTH / VIEW YEAR BUTTONS~<br /><ul><li>The <b>View Day</b> button will display the events of the chosen date in a list. All years are scanned, so only the day and month can be set here. Changing the year will have no effect.  You can reduce the list by choosing the option <b>Recent years</b> or <b>Living people</b>.<br /><br />Ages in the list will be calculated from the current year.</li><li>The <b>View Month</b> button will display a calendar diagram of the chosen month and year. Here too you can reduce the lists by choosing the option <b>Recent years</b> or <b>Living people</b>.<br /><br />You will get a realistic impression of what a calendar on the wall of your ancestors looked like by choosing a year in the past in combination with <b>Recent years</b>. All ages on the calendar are shown relative to the year in the Year box.</li><li>The <b>View Year</b> button will show you a list of events of the chosen year.  Here too you can reduce the list by choosing the option <b>Recent years</b> or <b>Living people</b>.<br /><br />You can show events for a range of years.  Just type the beginning and ending years of the range, with a dash <b>-</b> between them.  Examples:<br /><b>1992-4</b> for all events from 1992 to 1994<br /><b>1976-1984</b> for all events from 1976 to 1984<br /><br />To see all the events in a given decade or century, you can use <b>?</b> in place of the final digits. For example, <b>197?</b> for all events from 1970 to 1979 or <b>16??</b> for all events from 1600 to 1699.</li></ul>When you want to <b>change the year</b> you <b>have</b> to press one of these three buttons.  All other settings remain as they were.<br /><br />";

//-- Clippings Cart-page
##$pgv_lang["help_clippings.php"]			= "~THE FAMILY TREE CLIPPINGS CART~<br />The #pgv_lang[clip_cart]# allows you to take extracts (\"clippings\") from this family tree and bundle them up into a single file for downloading and subsequent importing into your own genealogy program.  The downloadable file is recorded in GEDCOM format.<br /><ul><li>How to take clippings?<br />This is really simple. Whenever you see a clickable name (individual, family, or source) you can go to the Details page of that name. There you will see the <b>#pgv_lang[add_to_cart]#</b> option.  When you click that link you will be offered several options to download.</li><li>How to download?<br />Once you have items in your cart, you can download them just by clicking the <b>Download Now</b> link.  Follow the instructions and links.</li></ul><br />";
##$pgv_lang["clip_download_help"]			= "~DOWNLOAD THE CLIPPINGS~<br /><br />When you click this link you will be taken to the next page.  If any of the clippings in your cart refer to multimedia items, these items will also be displayed on that page.<br /><br />Simply follow the instructions.<br /><br />";
##$pgv_lang["empty_cart_help"]			= "~EMPTY THE CLIPPINGS CART~<br /><br />When you click this link your #pgv_lang[clip_cart]# will be totally emptied.<br /><br />If you don't want to remove all persons, families, etc. from the #pgv_lang[clip_cart]#, you can remove items individually by clicking the <b>Remove</b> link in the Name boxes.  There is <u>no</u> confirmation dialog when you click either of these links;  the requested deletion takes place immediately.<br /><br />";
##$pgv_lang["add_by_id_help"]				= "~CLIPPINGS CART ADD BY ID~<br /><br />This input box lets you enter an individual's ID number so he can be added to the Clippings Cart.  Once added you'll be offered options to link that individual's relations to your Clippings Cart.<br /><br />If you do not know an individual's ID number, you can perform a search by name by pressing the Person icon next to the Add button.<br /><br />";
##$pgv_lang["zip_help"]					= "~ZIP CLIPPINGS~<br /><br />Select this option as to save your clippings in a ZIP file.  For more information about ZIP files, please visit <a href=\"http://www.winzip.com\" target=\"_blank\">http://www.winzip.com</a>.<br /><br />";
##$pgv_lang["include_media_help"]			= "~INCLUDE MEDIA~<br /><br />Select this option to include the media files associated with the records in your clippings cart.  Choosing this option will automatically zip the files during download.<br /><br />";
##$pgv_lang["clip_cart_help"]				= "~CLIPPINGS CART~<br /><br />This box shows the contents of your Clippings Cart.  The <i>Types</i> column indicates the type of each entry, which can be Individual (INDI), Family (FAM), Source (SOUR), Repository (REPO), Note (NOTE), and Media (OBJE);  each is represented by its own icon.  The <i>ID</i> column shows the ID number for each item of that particular type.  The <i>Name / Description</i> column gives either the name of the family or individual, or a description of the item.  The Remove button will remove that record from the Clippings Cart.  <b>Confirmation to remove is NOT asked for.</b><br /><br />";

//-- GEDCOM Edit Utility
##$pgv_lang["show_changes_help"]			= "~SHOW CHANGES TO THE GEDCOM~<br /><br />When you see this message, it means two things:<ol><li>Somebody has made changes to the GEDCOM<br />Records may have been added, deleted, or changed.</li><li>The changes have not yet been accepted by the administrator.<br />Once the changes have been accepted or rejected, you will no longer see this message.</li></ol>You can see what changes have been made when you click the link.  If you notice that a change is not correct, please notify the admin.<br /><br />";

//-- Search-page
##$pgv_lang["help_search.php"]			= "~THE SEARCH PAGE~<br /><br />Although this page looks very simple, there is a very powerful and complicated search engine behind the two forms.  Most genealogy web sites just let you search for a name.  PhpGedView lets you search for almost anything.<br /><br />The Search box on the left of the screen is the same as the Search box in each page header.<br /><br />If you are looking for people in connection to a certain year, just type the year. The program will find all connections for you.<br /><br />Looking for a name, or place?  Just type in the name or place, completely or just a part of it, and PhpGedView does the rest.<br /><br /><b>Soundex search method</b><br />With the search boxes on the right, you can search for names of persons and places, even if you don't know precisely how to write the name.<br /><br />When there are several genealogical databases on one site and the administrator has enabled switching between them, your search will return the results for all of them.<br /><br />You will find more help about these two boxes by clicking the <b>?</b> above the boxes.<br /><br />";
##$pgv_lang["search_enter_terms_help"]		= "~ENTER SEARCH TERMS~<br /><br />In this Search box you can enter criteria such as dates, given names, surnames, places, multimedia, etc.<br /><br /><b>Wildcards</b><br />Wildcards, as you probably know them (like * or ?), are not allowed, but the program will automatically assume wildcards.<br /><br />Suppose you type in the Search box the following: <b>Pete</b>.  The result could be, assuming the names are in the database:<div style=\"padding-left:30px;\"><b>Pete</b> Smith<br /><b>Pete</b>r Johnes<br />Will <b>Pete</b>rson<br />somebody --Born 01 January 1901 <b>Pete</b>rsburg<br />etc.</div><br /><b>Dates</b><br />Typing a year in the Search box will result in a list of individuals who are somehow connected to that year.<br /><br />If you type <b>1950</b>, the result will be all individuals with an event that occurred in 1950.  These events could be births, deaths, marriages, Bar Mitzvahs, LDS Sealings, etc.<br /><br />If you type <b>4 Dec</b>, all persons connected to an event that occurred on 4 December of whatever year will be listed.  Persons connected to an event on 14 or 24 December will be listed as well.  As you see, wildcards are always assumed, so you do not have to type them.  Sometimes, the results can be surprising.<br /><br /><b>Proper dates</b><br />PhpGedView searches for data, as they are stored in the GEDCOM file.  If, for example, you want to search for an event on December 14, you should type <b>14&nbsp;dec</b> because this is how the date is stored in the database.<br /><br />If you were to type <b>dec&nbsp;14</b>, the result could be a person connected to an event on 08&nbsp;<b>dec</b>ember&nbsp;18<b>14</b>.  Again, the results can be surprising.<br /><br />You can use regular expressions in your search if you are familiar with them.  For example, if you wanted to find all of the people who have dates in the 20th century, you could enter the search <b>19[0-9][0-9]</b> and you would get all of the people with dates from 1900-1999.<br /><br />If you need more help with this searching system, please let us know, so that we can extend this Help file as well.<br /><br />#pgv_lang[soundex_search_help]# #pgv_lang[search_replace_help]#";
##$pgv_lang["search_replace_help"]		= "~#pgv_lang[search_replace]#~<br /><br />Here, you can search for a misspelling or other inaccurate information and replace it with correct information.<br /><br /><b>Searching</b><br />This feature performs searching just like a <a href=\"help_text.php?help=search_enter_terms_help\">normal search</a>.<br /><br /><b>Replacing</b><br />All instances of the search term that are found are replaced by the replacement term in the database.<br /><br /><b>For Example...</b><br />Suppose you accidentally misspell your great-grandpa Michael's name.  You accidentally entered 'Micheal.' <br /><br />You would type <b>Micheal</b> in the Search box, and <b>Michael</b> in the Replace box.<br />Every instance of \"Micheal\" would then be replaced by \"Michael\"<br /><br /><b>Search for...</b><br />Select the scope of the search.  You can limit the search to names or places, or apply no limit (search everything).  The <i>#pgv_lang[search_place_word]#</i> option will only search for your term in the place field as a whole word.  This means that searching for <i>UT</i> would only match <b>UT</b> and not <i>UT</i> in the other words such as Connectic<b>ut</b>.<br /><br />Don't worry if you accidentally replace something where you don't want to.  Just click the \"Accept/Reject Changes\" link at the bottom of the page to accept the changes you want, and reject the changes you don't want.<br /><br />If you need more help with this searching system, please let us know, so that we can improve this Help file as well.<br /><br />";
##$pgv_lang["soundex_search_help"]		= "~#pgv_lang[soundex_search]#~<br /><br />Soundex is a method of coding words according to their pronunciation.  This allows you to search the database for names and places when you don't know precisely how they are written.  PhpGedView supports two different Soundex algorithms that produce vastly different results.<ul><li><b>Basic</b><br />This method, patented in 1918 by Russell, is very simple and can be done by hand.<br /><br />Because the Basic method retains the first letter of the name as part of the resultant code, it is not very helpful when you are unsure of that first letter.  The Basic algorithm is not well suited to names that were originally in languages other than English, and even with English names the results are very surprising.  For example, a Basic Soundex search for <b>Smith</b> will return not only <b>Smith, Smid, Smit, Schmidt, Smyth, Smithe, Smithee, Schmitt</b>, all of which are clearly variations of <b>Smith</b>, but also <b>Smead, Sneed, Smoote, Sammett, Shand,</b> and <b>Snoddy</b>.  <br /><br /></li><li><b>Daitch-Mokotoff</b><br />This method, developed in 1985, is much more complex than the Basic method and is not easily done by hand.<br /><br />A Soundex search using this method produces much more accurate results.</li></ul>For details on both Soundex algorithms, visit this <a href=\"http://www.jewishgen.org/infofiles/soundex.html\" target=_blank><b>Jewish Genealogical Society</b></a> web page.<br /><br />";
##$pgv_lang["search_exclude_tags_help"]	= "~#pgv_lang[search_tagfilter]#~<br /><br />The <b>#pgv_lang[search_tagfon]#</b> choice will cause the Search function to ignore the following GEDCOM tags:<div style=\"padding-left:30px;\"><b>_PGVU</b> - Last change by<br /><b>CHAN</b> - Last change date<br /><b>FILE</b> - #factarray[FILE]#<br /><b>FORM</b> - #factarray[FORM]#<br /><b>TYPE</b> - #factarray[TYPE]#<br /><b>SUBM</b> - #factarray[SUBM]#<br /><b>REFN</b> - #factarray[REFN]#</div><br />In addition to these optionally excluded tags, the Search function always excludes these tags:<div style=\"padding-left:30px;\"><b>_UID</b> - #factarray[_UID]#<br /><b>RESN</b> - #factarray[RESN]#</div><br /><br />";
##$pgv_lang["search_include_ASSO_help"]	= "~#pgv_lang[search_asso_label]#~<br /><br />This option causes PhpGedView to show all individuals who are recorded as having an association relationship to the person or family that was found as a direct result of the search.  The inverse, where all persons or families are shown when a person found as a direct result of the search has an association relationship to these other persons or families, is not possible.<br /><br />Example:  Suppose person <b>A</b> is godparent to person <b>B</b>.  This relationship is recorded in the GEDCOM record of person <b>B</b> by means of an ASSO tag.  No corresponding tag exists in the GEDCOM record of person <b>A</b>.<br /><br />When this option is set to <b>#pgv_lang[yes]#</b> and the Search results list includes <b>B</b>, <b>A</b> will be included automatically because of the ASSO tag in the GEDCOM record of <b>B</b>.  However, if the Search results list includes <b>A</b>, <b>B</b> will not be included automatically since there is no matching ASSO tag in the GEDCOM record of person <b>A</b>.<br /><br />";

//-- Individual Information-page
##$pgv_lang["help_individual.php"]		= "~#pgv_lang[indi_info]# PAGE~<br /><br />All details of a person are displayed on this page.<br /><br />If there is a picture available, you will see it at the top left side.  You will see the names of the person next to the picture.<br /><br />Names can have notes and sources attached to them. If any of the names have notes or sources, you will see them listed under the names they relate to.<br /><br />A person might have an AKA (maybe he's known under another name). If that is the case, it will be displayed.<br /><br />If you have Edit rights to this person, you will also see <b>Edit</b> and <b>Delete</b> links next to the items that you can edit.<br /><br />On this page you see tab sheets for <b>#pgv_lang[personal_facts]#</b>, <b>#pgv_lang[notes]#</b>, <b>#pgv_lang[ssourcess]#</b>, <b>#pgv_lang[media]#</b>, and <b>#pgv_lang[relatives]#</b>.  These tab sheets show you all the information about this individual that is stored in the database.<br /><ul><li>The <b>#pgv_lang[personal_facts]#</b> tab will show you the facts and details about this person and any fact from their marriages. Clicking on any date on this tab will take you to the #pgv_lang[anniversary_calendar]# for that date, so that you can see other events that happened on the same day. Clicking on a place will take you to the Place Hierarchy where you can view other people who had events in the same place. For marriage and other family related facts, the name of the person's spouse is available so that you can view the spouse and a link to the family record is also provided.</li><li>The <b>#pgv_lang[notes]#</b> tab will show you any general notes relating to this person.</li><li>The <b>#pgv_lang[ssourcess]#</b> tab will show you all of the <u>general</u> sources for this person. These sources are <u>not</u> linked to individual facts, not even the person's name; they are associated with the individual himself.  Clicking on the title of a source will take you to a more detailed Source Information page that will display other people who are also linked to the same source.</li><li>The <b>#pgv_lang[media]#</b> tab will list all of the pictures and other media items that are attached to this individual. Clicking on a thumbnail of the picture will open up a larger view of the image. Clicking on the picture caption will show you the picture on the #pgv_lang[media_list]# page.</li><li>The <b>#pgv_lang[relatives]#</b> tab lists this person's parents and siblings as well as all of the spouses and children that this person has had. These persons will be listed in boxes similar to the charts that you may have already seen.</li></ul>On the right of the screen you will find a box with links.  Many of the links in the box are the same as the links in the menus. For example, clicking on the <b>#pgv_lang[pedigree_chart]#</b> link on the side links will take you to the Pedigree chart for this person. This is different from the menu links, because clicking on the <b>#pgv_lang[pedigree_chart]#</b> link in the menu will take you back to the default Pedigree chart for this database.<br /><br />One of the links that might appear in this list if it has been enabled by the admin, is the <b>#pgv_lang[view_gedcom]#</b> link. This link will show you the raw GEDCOM record of this individual.<br /><br />If the #pgv_lang[clip_cart]# has been enabled by the site admin, you will also have a link that will allow you to add this person to your #pgv_lang[clip_cart]#.<br /><br />The <b>#pgv_lang[relationship_to_me]#</b> link will only appear if you are logged in and have been assigned an ID in the GEDCOM. This link will take you to the Pedigree chart and show you how you are related to this person.<br /><br />#pgv_lang[context_help]#<br /><br />";
##$pgv_lang["delete_person_help"]			= "~DELETE PERSON FROM GEDCOM~<br /><br />When you click this option, you will mark this individual to be deleted from the database.<br /><br />What does that mean?<br />Let's suppose you have a good reason to remove this person from the database. You click the link.  You will be asked to confirm your deletion request.  If you decide to continue, it can take a little time before you see a message that the individual is deleted.<br /><br />When you continue with your visit, you will notice that the person is still visible and can be used as if the deletion had not occurred.<br /><br /><b>This is <u>not</u> an error.</b>  The site admin will get a message that a change has been made to the database, and that you removed the individual.<br />The administrator can accept or reject your change. Only after the administrator has accepted your change will the deletion actually occur <u>irreversibly</u>.  If there is any doubt about your change, the administrator will contact you.<br /><br />";
##$pgv_lang["delete_name_help"]			= "~EDIT or DELETE NAME FROM GEDCOM~<br /><br /><b>EDIT NAME</b><br />When you click this link, another window will open.  There you can edit the name of the person.  Just type the changes into the boxes and click the button, close the window, and that's it.<br /><br /><b>DELETE NAME</b><br />By clicking this option you will mark this Name to be deleted from the database.  Note that deleting the name is completely different from deleting the individual.  Deleting the name just removes the name from the person. The person will <u>not</u> be deleted.  If it is an AKA that you want to delete, the person still has his other names.  If it is the <u>only</u> name that you want to remove, the person will still not be deleted, but will now be recorded as <b>#pgv_lang[NN]#</b>.  The person will also not be disconnected from any other to relatives, sources, notes, etc.<br /><br />How does it work?<br />You will be asked to confirm your deletion request.  If you decide to continue, it can take a little time before you see a message that the name is deleted.<br /><br />When you continue with your visit, you will notice that the name is still visible and can be used as if the deletion had not occurred.<br /><br /><b>This is <u>not</u> an error.</b>  The site admin will get a message that a change has been made to the database, and that you removed the name.<br />The administrator can accept or reject your change. Only after the administrator has accepted your change will the deletion actually occur <u>irreversibly</u>.  If there is any doubt about your change, the administrator will contact you.<br /><br />";
##$pgv_lang["add_name_help"]				= "~ADD NEW NAME~<br /><br />This link will allow you to add another name to this individual.  Sometimes people are known by other names or aliases.  This link allows you to add new names to a person without changing the old name.<br /><br />";
##$pgv_lang["add_sibling_help"]			= "~#pgv_lang[add_sibling]#~<br /><br />You can add a child to this family when you click this link.  \"This Family\", in this case, is the father and mother of the principal person of this screen.<br /><br />Keep in mind that you are going to add a sibling of that person.  Adding a brother or sister is simple: Just click the link, fill out the boxes in the pop up screen and that's all.<br /><br />If you have to add a son or daughter of the principal person, scroll down a little and click the link in \"#pgv_lang[as_spouse]#\".<br /><br />";
##$pgv_lang["add_son_daughter_help"]		= "~#pgv_lang[add_son_daughter]#~<br /><br />You can add a child to this family when you click this link.  \"This Family\", in this case, is the principal person of this screen and his or her spouse.<br /><br />Keep in mind that you are going to add a son or daughter of that person.  Adding a son or daughter is simple: Just click the link, fill out the boxes in the popup screen and that's all.<br /><br />If you have to add a brother or sister of the principal person, scroll up a little and click the link in \"#pgv_lang[as_child]#\".<br /><br />";
##$pgv_lang["link_child_help"]			= "~#pgv_lang[link_as_child]#~<br /><br />You can link this person as a child to an existing family when you click this link.<br /><br />Suppose that at one time the parents of the person were unknown, and you discovered later that the parents have a record in this database.<br /><br />Just click the link, enter the ID of the family, and you have competed the task.  If you don't know the family's ID, you can search for it.<br /><br />";
##$pgv_lang["link_husband_help"]			= "~#pgv_lang[link_as_husband]#~<br /><br />This item will allow you to link the current individual as a husband to a family that is already in the database. By clicking this link you can add this person to an existing family, of which the husband was unknown until now. This person will take the place of the previously unknown husband. All events, marriage information, and children will keep their existing links to the family.<br /><br />Just click the link, enter the ID of the family, and you have competed the task. This is an advanced editing option that should only be used if the family you want to link to already exists.  If you want to add a <u>new</u> family to this individual, use the <b>#pgv_lang[add_new_wife]#</b> link.<br /><br />";
##$pgv_lang["add_husband_help"]			= "~#pgv_lang[add_new_husb]#~<br /><br />By clicking this link, you can add a <u>new</u> male person and link this person to the principal individual as a new husband.<br /><br />Just click the link, and you will get a pop up window to add the new person.  Fill out as many boxes as you can and click the <b>Save</b> button.<br /><br />That's all.<br /><br />";
##$pgv_lang["link_new_husb_help"]			= "~#pgv_lang[link_new_husb]#~<br />This will allow you to link another individual, who already exists, as a new husband to this person.  This will create a new family with the husband you select.  You will also have the option of specifying a marriage for this new family.<br /><br />";
##$pgv_lang["add_opf_child_help"]			= "~#pgv_lang[add_opf_child]#~<br /><br />By clicking this link, you can add a <u>new</u> child to this person, creating a one-parent family.<br /><br />Just click the link, and you will get a pop up window to add the new person.  Fill out as many boxes as you can and click the <b>Save</b> button.<br /><br />That's all.<br /><br />";
##$pgv_lang["link_wife_help"]			= "~#pgv_lang[link_as_wife]#~<br /><br />This item will allow you to link the current individual as a wife to a family that is already in the database.<br /><br />This is an advanced editing option that should only be used if the family you want to link to already exists.  If you want to add a <u>new</u> family to this individual, use the <b>#pgv_lang[add_new_husb]#</b> link.<br /><br />";
##$pgv_lang["add_wife_help"]			= "~#pgv_lang[add_new_wife]#~<br /><br />By clicking this link, you can add a <u>new</u> female person and link this person to the principal individual as a new wife.<br /><br />Just click the link, and you will get a pop up window to add the new person.  Fill out as many boxes as you can and click the <b>Save</b> button.<br /><br />That's all.<br /><br />";
##$pgv_lang["link_new_wife_help"]			= "~#pgv_lang[link_new_wife]#~<br />This will allow you to link another individual, who already exists, as a new wife to this person.  This will create a new family with the wife you select.  You will also have the option of specifying a marriage for this new family.<br /><br />";
##$pgv_lang["add_new_parent_help"]		= "#pgv_lang[multiple_help]#<br />~ADD NEW FATHER or MOTHER~<br /><br />There are certainly many individuals in the GEDCOM without a record of a father or mother.<br /><br />In that case, on the <b>#pgv_lang[indi_info]#</b> page, tab sheet <b>#pgv_lang[relatives]#</b>, table <b>#pgv_lang[as_child]#</b>, you will find links to add a <u>new</u> father or mother to the individual.<br /><br />Please keep in mind that these links are for adding a <u>new</u> father or mother.  If the father or mother already has a record in this database, you have to use the link <b>#pgv_lang[link_as_child]#</b>, which you will find on that <b>#pgv_lang[indi_info]#</b> page below the last table.<br /><br />";
##$pgv_lang["show_fact_sources_help"]		= "~#pgv_lang[show_fact_sources]#~<br />~#pgv_lang[show_fact_notes]#~<br />When this option is checked, you can see all Source or Note records for this person.  When this option is unchecked, Source or Note records that are associated with other facts for this person will not be shown.<br /><br />";
##$pgv_lang["age_differences_help"]	= "~#pgv_lang[age_differences]#~<br />When this option box is checked, the «#pgv_lang[relatives]#» tab will show date differences as follows:<br /><ul><li>birth dates of partners.<br />A negative value indicates that the second partner is older than the first.<br /><br /></li><li>marriage date and birth date of the first child.<br />A negative value here indicates that the child was born before the marriage date or that either the birth date or the marriage date is wrong.<br /><br /></li><li>birth dates of siblings.<br />A negative value here indicates that either the order of the children is wrong or that one of the birth dates is wrong.</li></ul><br /><br />";

//-- Add Facts
##$pgv_lang["add_facts_help"]			= "~ADD NEW FACTS~<br /><br />Here you can add a fact to the record being edited.<br /><br />First choose a fact from the drop-down list, then click the <b>Add</b> button.  All possible facts that you can add to the database are in that drop-down list.<br /><br />";
##$pgv_lang["add_custom_facts_help"]		= "~Add custom fact~<br />If you can't find the fact that you want to add in the list of GEDCOM facts, you can enter a <b>custom fact</b> as well.<br /><br />Entering a custom fact is just as simple as entering one of the pre-defined ones.  The only difference is that you have to name the fact instead of picking its name from a list. You have to do this in the top field: <b>#pgv_lang[type]#</b><br /><br />";
##$pgv_lang["add_note_help"]			= "#pgv_lang[multiple_help]#<br />~ADD NEW NOTE~<br />If you have a note to add to this record, this is the place to do so.<br /><br />Just click the link, a window will open, and you can type your note.  When you are finished typing, just click the button below the box, close the window, and that's all.<br /><br />#pgv_lang[add_facts_general_help]#";
##$pgv_lang["add_source_help"]			= "#pgv_lang[multiple_help]#<br />~ADD NEW SOURCE CITATION~<br />Here you can add a source <b>Citation</b> to this record.<br /><br />Just click the link, a window will open, and you can choose the source from the list (Find ID) or create a new source and then add the Citation.<br /><br />Adding sources is an important part of genealogy because it allows other researchers to verify where you obtained your information.<br /><br />#pgv_lang[add_facts_general_help]#";
##$pgv_lang["add_media_help"]			= "~#pgv_lang[add_media]#~<br /><br />Adding multimedia files (MM) to the GEDCOM is a very nice feature.  Although this program already has a great look without media, if you add pictures or other MM to your relatives, it will only get better.<br /><br /><b>What you should understand about MM.</b><br />There are many formats of MM. Although PhpGedView can handle most of them, there some things to consider.<br /><ul><li><b>Formats</b><br />Pictures can be edited and saved in many formats.  For example, .jpg, .png, .bmp, .gif, etc.  If the same original picture was used to create each of the formats, the viewed image will appear to be the same size no matter which format is used.  However, the image files stored in the database will vary considerably in size.  Generally, .jpg images are considered to the most efficient in terms of storage space.</li><li><b>Image size</b><br />The larger the original image, the larger will be the resultant file's size. The picture should fit on the screen without scrolling; the maximum width or height should not be more than the width or height of the screen. PhpGedView is designed for screens of 1024x768 pixels but not all of this space is available for viewing pictures; the picture's size should be set accordingly.  To reduce file sizes, smaller pictures are more desirable.</li><li><b>Resolution</b><br />The resolution of a picture is usually measured in \"dpi\" (dots/inch), but this is valid only for printed pictures.  When considering pictures shown on screen, the only correct way is to use total dots or pixels. When printed, the picture could have a resolution of 150 - 300 dpi or more depending on the printer. Screen resolutions are rarely better than 50 pixels per inch.  If your picture will never be printed, you can safely lower its resolution (and consequently its file size) without affecting picture quality.  If a low-resolution picture is printed with too great a magnification, its quality will suffer; it will have a grainy appearance.</li><li><b>Color depth</b><br />Another way to keep a file small is to decrease the number of colors that you use.  The number of colors can differ from pure black and white (two colors) to true colors (millions of colors) and anything in between.  You can see that the more colors are used, the bigger the size of the files.</li></ul><b>Why is it important to keep the file size small?</b><br /><ul><li>First of all: Our webspace is limited.  The more large files there are, the more web space we need on the server. The more space we need, the higher our costs.</li><li>Bandwidth.  The more data our server has to send to the remote location (your location), the more we have to pay.  This is because the carrying capacity of the server's connection to the Internet is limited, and the link has to be shared (and paid for) by all of the applications running on the server.  PhpGedView is one of many applications that share the server.  The cost is normally apportioned according to the amount of data each application sends and receives.</li><li>Download time. If you have large files, the user (also you) will have to wait long for the page to download from the server.  Not everybody is blessed with a cable connection, broadband or DSL.</li></ul><b>How to upload your MM</b><br />There are two ways to upload media to the site.  If you have a lot of media items to upload you should contact the site administrator to discuss the best ways.  If it has been enabled by your site administrator, you can use the Upload Media form under your #pgv_lang[mgv]# menu.  You can also use the Upload option on the Multimedia form to upload media items.<br /><br />";
##$pgv_lang["gen_missing_thumbs_help"]	= "~#pgv_lang[gen_missing_thumbs]#~<br />This option will generate thumbnails for all files in the current directory which don't already have a thumbnail.  This is much more convenient than clicking the <b>#pgv_lang[gen_thumb]#</b> link for each such file.<br /><br />If you wish to retain control over which files should have corresponding thumbnails, you should not use this option.  Instead, click the appropriate <b>#pgv_lang[gen_thumb]#</b> links.<br /><br />";
##$pgv_lang["add_facts_general_help"]      = "~General info about adding~<br />When you have added a fact, note, source, or multimedia file to a record in the database, the addition still has to be approved by a user who has Accept rights.<br /><br />Until the changes have been Accepted, they are identified as \"pending\" by a differently colored border.  All users with Edit rights can see these changes as well as the original information.  Users who do not have Edit rights will only see the original information. When the addition has been Accepted, the borders will disappear and the new data will display normally, replacing the old.  At that time, users without Edit rights will see the new data too.<br /><br />";

//-- Edit user
##$pgv_lang["edituser_my_account_help"]		= "Here you can change your settings and preferences.<br /><br />You can change your user name, full name, password, language, email address, theme of the site, and preferred contact method.<br /><br />You cannot change the GEDCOM INDI record ID; that has to be done by an administrator.";
##$pgv_lang["edituser_username_help"]		= "~#pgv_lang[username]#~<br /><br />In this box you can change your user name.  If you no longer like your user name or if have other reasons to change it, you can do so using this form.<br /><br />The username is <u>case sensitive</u>. That means that <b>John</b> is not the same as <b>john</b> or <b>JOHN</b>.<br /><br />You should <u>only</u> use characters from the alphabets that PhpGedView supports.  You may use uppercase and lower case letters with or without diacritical marks, numbers, dash (-), and underscore (_). Do <u>not</u> use punctuation marks or spaces.<br /><br />";
##$pgv_lang["edituser_firstname_help"]		= "~#pgv_lang[firstname]#~<br /><br />In this box you can change your first name.  This is the name that other users see when you are logged in.<br /><br />Although the choice of what to put into this field is yours, you should inform the administrator when you change it.  When others see an unknown person on-line, they might wonder and ask questions.  The admin can find out without having received your notice, but you should save him that unnecessary work.<br /><br />";
##$pgv_lang["edituser_lastname_help"]		= "~#pgv_lang[lastname]#~<br /><br />In this box you can change your last name.  This is the name that other users see when you are logged in.<br /><br />Although the choice of what to put into this field is yours, you should inform the administrator when you change it.  When others see an unknown person on-line, they might wonder and ask questions.  The admin can find out without having received your notice, but you should save him that unnecessary work.<br /><br />";
##$pgv_lang["edituser_gedcomid_help"]		= "~#pgv_lang[gedcomid]#~<br /><br />This is an identification number that links you to your own data in the database.<br /><br />You cannot change this ID; it's set by the administrator.  If you think that this ID is not correct, you should contact the administrator to have it changed.<br /><br />";
##$pgv_lang["edituser_rootid_help"]		= "~#pgv_lang[rootid]#~<br /><br />This is the starting (Root) person of all your charts.<br /><br />If, for example, you were to click the link to the Pedigree, you would see this root person in the leftmost box.  This root person does not have to be you; you can start with any person (your grandfather or your mother's aunt, for instance), as long you have the rights to see that person.<br /><br />The changes the default Root person for most charts.  You can change the Root person on many charts, but that is just for that page at that particular invocation.<br /><br />";
##$pgv_lang["edituser_password_help"]		= "~#pgv_lang[password]#~<br /><br />It is a good practice to change your password regularly.  You have to keep in mind that anyone who knows your user name and your password will have access to your data.<br /><br />Make the password at least 6 characters long, the longer the better. You may use uppercase and lower case letters with or without diacritical marks, numbers, dash (-), and underscore (_). Do <u>not</u> use punctuation marks or spaces.  Use a combination of upper and lower case, numbers, and other characters. For example: <b>5Z_q\$P4=r9</b>.<br /><br />Like the user name, the password is <u>case sensitive</u>.  That means that <b>Secret.Password!#13</b> is not the same as <b>secret.password!#13</b> or <b>SECRET.PASSWORD!#13</b>.<br /><br />";
##$pgv_lang["edituser_conf_password_help"]	= "~#pgv_lang[confirm]#~<br /><br />If you have changed your password, you need to confirm it as well.  This is just to make sure that you did not make a typing error in the password field.<br /><br />If the password and its confirmation are not identical, you will get a suitable error message.  You will have to re-type both the original password and its confirmation.<br /><br />";
##$pgv_lang["edituser_change_lang_help"]		= "~#pgv_lang[change_lang]#~<br /><br />Here you can change the language in which PhpGedview will display all its pages and messages after you have logged in.<br /><br />When you first access the site, PhpGedView assumes that you want to see everything in the language configured as the Preferred Language in your browser.  If that assumption is incorrect, you would override it here.  For example, your browser might be set to English because that is the most prevalent language on the Internet.  However, for genealogical purposes, you would prefer to see everything in Finnish or Hebrew.  Here's where you do that.<br /><br />The administrator controls what language choices are available to you.  If your preference isn't listed, you need to contact the administrator.<br /><br />Please remember that PhpGedView is very much a project staffed by an international team of unpaid volunteers.  Experts come and go.  Consequently, support for languages other than English is sometimes not as good as it should be.<br /><br />If you see something that has not been translated, has been translated incorrectly, or could be phrased better, let your administrator know.  The administrator will know how to get in touch with the PhpGedView developer team to have your concerns addressed.  Better still, volunteer some of your time.  We can use the help.<br /><br />";
##$pgv_lang["edituser_email_help"]		= "~#pgv_lang[emailadress]#~<br /><br />Your correct email address is, important to us to keep in touch with you.<br /><br />If you get a new email address, as usually happens when you change your Internet provider, please do not forget to change the address here as well.  You won't get a confirmation message from this site when you change this address, but any future messages directed to you will go this new address.<br /><br />";
##$pgv_lang["edituser_user_theme_help"]		= "~#pgv_lang[user_theme]#~<br /><br />This site can have several different looks or appearances.  Other programs may call them \"skins\", but here they're \"themes\".<br /><br />Every theme will display the same data, but its presentation or even its location on the screen may vary.  This is like putting a picture into a different frame and hanging it in a different room as well. The picture does not change, but the way you look at it is completely different.<br /><br />Just give it a try. Set it to another theme. Look at it, try another. Change back to the one that suits you the best. Whenever you log in, you will see the theme you last used; you don't even have to get to this configuration page to change your preferred theme.<br /><br />";
##$pgv_lang["edituser_contact_meth_help"]		= "~#pgv_lang[user_contact_method]#~<br />PhpGedView has several different contact methods.  The administrator determines which method will be used to contact him.  You have control over the method to be used to contact <u>you</u>.  Depending on site configuration, some of the listed methods may not be available to you.<br />";
##$pgv_lang["mail_option1_help"]			= "With this option, the PhpGedView internal messaging system will be used and no emails will be sent.<br /><br />You will receive only <u>internal</u> messages from the other users.  When another site user sends you a message, that message will appear in the Message block on your personal #pgv_lang[mygedview]# page.  If you have removed this block from your #pgv_lang[mygedview]# page, you will not see any messages.  They will, however, show up as soon as you configure the #pgv_lang[mygedview]# page to again have the Message block.<br /><br />";
##$pgv_lang["mail_option2_help"]			= "This option is like #pgv_lang[messaging]#, with one addition.  As an extra, a copy of the message will also be sent to the email address you configured on your Account page.<br /><br />This is the default contact method.<br /><br />";
##$pgv_lang["mail_option3_help"]			= "With this option, you will only receive email messages at the address you configured on your Account page.  The messaging system internal to PhpGedView will not be used at all, and there will never be any messages in the Message block on your personal #pgv_lang[mygedview]# page.<br /><br />";
##$pgv_lang["mail_option4_help"]			= "With this option, you will not receive any messages.  Even the administrator will not be able to reach you.<br /><br />";

//-- Admin
##$pgv_lang["admin_help"]				= "On this page you will find links to the configuration pages, administration pages, documentation, and log files.<br /><br /><b>#pgv_lang[system_time]#</b>, just below the page title, shows the time of the server on which your site is hosted. This means that if the server is located in New York while you're in France, the time shown will be six hours less than your local time, unless, of course, the server is running on Greenwich Mean Time (GMT).  The time shown is the server time when you opened or refreshed this page.<br /><br /><b>WARNING</b><br />When you see a red warning message under the system time, it means that your <i>config.php</i> is still writeable.  After configuring your site, you should, for <b>security</b>, set the permissions of this file back to read-only.  You have to do this <u>manually</u>, since PhpGedView cannot do this for you.<br /><br />";

//-- User Admin
##$pgv_lang["useradmin_help"]			= "~#pgv_lang[user_admin]#~<br /><br />On this page you can administer the current users and add new users.<br /><br /><b>#pgv_lang[current_users]#</b><br />In this table the current users, their status, and their rights are displayed.  You can <b>delete</b> or <b>edit</b> users.<br /><br /><b>#pgv_lang[add_user]#</b><br />This form is almost the same as the one users see on the  <b>#pgv_lang[editowndata]#</b> page.<br /><br />For several subjects we did not make special Help text for the administrator. In those cases you will see the following message:";
##$pgv_lang["useradmin_gedcomid_help"]		= "~#pgv_lang[gedcomid]#~<br /><br />The #pgv_lang[gedcomid]# identifies the user.  It has to be set by the administrator.<br /><br />This ID is used as the ID on several pages such as <b>#pgv_lang[my_indi]#</b> and <b>#pgv_lang[my_pedigree]#</b>.<br /><br />You can set the user's GEDCOM ID separately for each GEDCOM.  If a user does not have a record in a GEDCOM, you leave that box empty.<br /><br />";
##$pgv_lang["useradmin_rootid_help"]		= "~#pgv_lang[rootid]#~<br /><br />For each genealogical database, you can designate a <b>Root Person</b> for the user.<br /><br />This Root Person does not need to be the user himself; it can be anybody.  The user will probably want to start the Pedigree chart with himself.  You control that, as well as the default Root person on other charts, here.<br /><br />If the user has Edit rights to his own account information, he can change this setting himself.<br /><br />";
##$pgv_lang["useradmin_can_admin_help"]		= "~#pgv_lang[can_admin]# CHECK BOX~<br /><br />If this box is checked, the user will have the same rights that you have.<dl><dt>These rights include:</dt><dd>Add / Remove / Edit Users</dd><dd>Broadcast messages to all users</dd><dd>Edit Welcome messages</dd><dd>Edit and configure language files</dd><dt></dt><dd>Upgrade PhpGedView</dd><dd>Change program and GEDCOM configurations</dd><dd>Administer the GEDCOMs</dd><dd>Change Privacy settings</dd><dd>And anything else that is not mentioned here.</dd></dl><br />The user <u>cannot</u> change anything on your server outside PhpGedView.";
##$pgv_lang["useradmin_sync_gedcom_help"]		= "~#pgv_lang[sync_gedcom]# CHECK BOX~<br /><br />If this box is checked and the user has a GEDCOM record ID assigned to them, their user account settings will automatically be synchronized with their GEDCOM data.  This means that when the user's GEDCOM record is edited, some of the information such as email address and name will be copied to the user's account.  When the user's account is edited, corresponding information will be copied to the GEDCOM record.";
##$pgv_lang["useradmin_can_edit_help"]	= "~#pgv_lang[can_edit]#~<br /><br />The user can have different access and editing privileges for each genealogical database in the system.<ul><li><b>#pgv_lang[none]#:</b> The user cannot access the private data in this GEDCOM.</li><li><b>#pgv_lang[access]#:</b> The user cannot edit or accept data into the database but can see the private data.</li><li><b>#pgv_lang[edit]#:</b> The user can edit values but another user with <b>#pgv_lang[accept]#</b> privileges must approve the changes before they are added to the database and made public.</li><li><b>#pgv_lang[accept]#:</b> The user can edit.  He can also edit and approve changes made by other users.</li><li><b>#pgv_lang[admin_gedcom]#:</b> The user edit and approve changes made by other users.  The user can also edit configuration and privacy settings for <u>this</u> GEDCOM.</li></ul>System administrators, identified through the <b>#pgv_lang[can_admin]#</b> check box, are automatically given <b>#pgv_lang[admin_gedcom]#</b> privileges.<br /><br />";
##$pgv_lang["useradmin_verified_help"]		= "~#pgv_lang[verified]#~<br /><br /><b>Self Registration</b><br />A user can apply for a new account by means of the <b>self registration</b> module.<br /><br />When he does so, he will receive an email message with a link to verify his application.  After the applicant has acted on the instructions in that email, you will see this box checked, and you can proceed with the next step, <b>#pgv_lang[verified_by_admin]#</b>.  You should wait with your approval as long as this box is not checked.<br /><br /><b>Add user manually</b><br />If you use this form to add a user manually, you will find this box checked already.<br /><br />";
##$pgv_lang["useradmin_verbyadmin_help"]		= "~#pgv_lang[verified_by_admin]#~<br /><br />If a user has used the Self Registration module and has verified himself, the last step, before his account will become active, is your approval.<br /><br />After you have approved the user's application for a new account, the user will receive an email message.  The message will tell the user that his account is now active.  He can login with the user name and password that he supplied when he applied for the account.<br /><br />";
##$pgv_lang["useradmin_edit_user_help"]		= "~#pgv_lang[update_user]#~<br /><br />This form is used by the administrator to change a user's account<br /><br />The form is very similar to the <b>#pgv_lang[add_user]#</b> and <b>#pgv_lang[update_myaccount]#</b> forms.<br /><br />";
##$pgv_lang["useradmin_visibleonline_help"]		= "~VISIBLE ONLINE~<br /><br />This checkbox controls your visibility to other users while you're online.  It also controls your ability to see other online users who are configured to be visible.<br /><br />When this box is unchecked, you will be completely invisible to others, and you will also not be able to see other online users.  When this box is checked, exactly the opposite is true.  You will be visible to others, and you will also be able to see others who are configured to be visible.<br /><br />";
##$pgv_lang["useradmin_editaccount_help"]			= "~EDIT ACCOUNT INFO~<br /><br />If this box is checked, this user will be able to edit his account information.  Although this is not generally recommended, you can create a single user name and password for multiple users.  When this box is unchecked for all users with the shared account, they are prevented from editing the account information and only an administrator can alter that account.<br /><br />";
##$pgv_lang["useradmin_relation_priv_help"]		= "~#pgv_lang[user_relationship_priv]#~<br /><br />If this box is checked, the user will only be allowed access to living people that they are related to.  They will be able to see anyone who is within the relationship path length set by their <i>#pgv_lang[user_path_length]#</i> setting.  You can require relationship privacy for all of your users by turning on the global option in the GEDCOM privacy settings.<br /><br />This setting requires that the user be associated with a GEDCOM ID before they will be able to see any living people.<br /><br />";
##$pgv_lang["useradmin_path_length_help"]			= "~#pgv_lang[user_path_length]#~<br /><br />If <i>#pgv_lang[user_relationship_priv]#</i> is enabled, this user will only be able to see or edit living individuals within this number of relationship steps.<br /><br />";
##$pgv_lang["useradmin_auto_accept_help"]			= "~#pgv_lang[user_auto_accept]#~<br /><br />By checking this box you are allowing the system to automatically accept any edit changes made by this user.  The user must also have accept privileges on the GEDCOM in order for this setting to take effect.<br /><br />";

//-- Manage Sites
##$pgv_lang["help_managesites"] 			= "~MANAGE SITES~<br /><br />On this page you can add remote sites and ban IP addresses.<br /><br />Remote sites can be added by providing the site title, URL, database id(optional), username, and password for the remote web service.<br /><br />IP address banning is accomplished by supplying any valid IP address range. For example, 212.10.*.*  Remote sites within the IP address ranges in the Banned list will not be able to access your web service.  You can ban specific IP addresses too.";
//-- Adding Remote Links
##$pgv_lang["help_remotesites"]			= "~Adding Remote Sites~<br /><br />To add a remote site, provide the site title, URL of the remote web service, database id(optional), and username and password. Click the Add button to complete the process.  If the remote server allows anonymous authentication, you should leave the username and password blank.";
//-- IP Address Banning
##$pgv_lang["help_banning"]				= "~IP Address Banning~<br /><br />To ban remote sites from accessing your web service, provide a specific IP address or a valid IP address range, for example, 212.10.*.* and click the Submit button.";
##$pgv_lang["help_manual_search_engines"]				= "~Manual Search Engine Spider Marking~<br /><br />PhpGedView automatically provides search engines with smaller data files with fewer links.  The data is limited to the individual and immediate family, without adding information about grand parents or grand children.  Many reports and server-intensive pages like the calendar are off limits to the spiders.<br /><br />If a search engine is not automatically recognized and you wish to provide it data to index, you can list it here.  If you do not want to provide it data, you list it below in the banned IP section.<br /><br />If you wish to see what data is provided to search engines to index, list your own IP address here.  <font color=\"red\">WARNING:</font> This will lock you out of the admin interface, and you must remove the IP by logging in from a different machine or manually editing the <i>/index/search_engines.php</i> file.<br /><br />To manually mark a remote site as a search engine spider, provide a specific IP address or a valid IP address range, for example, 212.10.*.* and click the Submit button.  Many popular search engines like Google and Yahoo will be detected automatically.";

//-- Search_engines.php
##$pgv_lang["search_engine_landing_page"]		= "~Search Engine Detected~<br /><br />PhpGedView automatically provides search engines with smaller data files with fewer links.  The data is limited to the individual and immediate family, without adding information about grand parents or grand children.  Many reports and server-intensive pages like the calendar are off limits to the spiders.<br /><br />Attempts by the spiders to go to those pages result in showing this page.  If you are seeing this text, the software believes you are a search engine spider.  Below is the list of pages that are allowed to be spidered and will provide the abbreviated data.<br /><br />Real users who follow search engine links into this site will see the full pages and data, and not this page.";

//-- G E D C O M
##$pgv_lang["add_upload_gedcom_help"]		= "~ADDING VERSUS UPLOADING GEDCOM~<dl><dt><b>Uploading GEDCOM Files</b></dt><dd>Uploading files can be done on line.  You can upload from anywhere without needing an ftp program.</dd><dt><b>Adding GEDCOM Files</b></dt><dd>If a previously uploaded file is still present in your GEDCOM directory, you can use it again without uploading.  Sometimes, because of file or upload size limitations, you need to use Add.</dd></dl>The Add and the Upload procedure can be finished in four simple steps.  In either procedure, only Step 1 is different.<br /><br />";
##$pgv_lang["gedcom_configfile_help"]		= "~GEDCOM CONFIGURATION FILE~<br /><br />This is the file where all the basic settings related to the genealogical database are stored.  There is a separate file for each such database.<br /><br />You will find the path and name of each configuration file in the <b>#pgv_lang[current_gedcoms]#</b> table on the <b>#pgv_lang[gedcom_adm_head]#</b> page.<br /><br />";
##$pgv_lang["default_gedcom_help"]		= "~DEFAULT GEDCOM~<br /><br />If you have more than one genealogical database, you can set here which of them will be the default.<br /><br />This default will be shown to all visitors and users who have not yet logged in.<br /><br />Users who can edit their account settings can override this default.  In that case, the user's preferred database will be shown after login.<br /><br />";
##$pgv_lang["delete_gedcom_help"]			= "~DELETE GEDCOM~<br /><br />PhpGedView creates its database from a GEDCOM file that was previously uploaded. When you select <b>Delete</b>, that section of the database will be erased.  You have to confirm your Delete request.<br /><br />Unless you have deliberately removed it outside PhpGedView, the original GEDCOM file will remain in the directory into which it was uploaded.  If you later want to work with that GEDCOM file again, you don't have to upload it again. You can choose the <b>#pgv_lang[add_gedcom]#</b> function.<br /><br />";
##$pgv_lang["add_gedcom_help"]			= "~#pgv_lang[add_gedcom]#~<br /><br />When you use the <b>#pgv_lang[add_gedcom]#</b> function, it is assumed that you have already uploaded the GEDCOM file to your server using a program or method <u>external</u> to PhpGedView, for example, <i>ftp</i> or <i>network connection</i>.  The file you wish to add could also have been left over from a previous <b>#pgv_lang[upload_gedcom]#</b> procedure.<br /><br />If the input GEDCOM file is not yet on your server, you <u>have to</u> get it there first, before you can start with Adding.<br /><br />Instead of uploading a GEDCOM file, you can also upload a ZIP file containing the GEDCOM file, either with PhpGedView, or using an external program. PhpGedView will recognize the ZIP file automatically and will extract the GEDCOM file and filename from the ZIP file.<br /><br />If a GEDCOM file with the same name already exists in PhpGedView, it will be overwritten. However, all GEDCOM settings made previously will be preserved.<br /><br />You are guided step by step through the procedure.<br /><br />";
##$pgv_lang["add_new_gedcom_help"]		= "~#pgv_lang[add_new_gedcom]#~<br /><br />You can start a new genealogical database from scratch.<br /><br />This procedure requires only a few simple steps. Step 1 is different from what you know already about uploading and adding. The other steps will be familiar.<ol><li><b>Naming the new GEDCOM</b><br />Type the name of the new GEDCOM <u>without</u> the extension <b>.ged</b>. The new file will be created in the directory named above the box where you enter the name.  Click <b>Add</b>.</li><li><b>Configuration page</b><br />You already know this page;  you configure the settings for your new GEDCOM file.</li><li><b>Validate</b><br />You already know this page;  the new GEDCOM is checked.  Since there is nothing in it, it will be ok.</li><li><b>Importing Records</b><br />Since there will be only one record to import, this will be finished very fast.</li></ol>That's it.  Now you can go to the Pedigree chart to see your first person in the new GEDCOM. Click the name of the person and start editing. After that, you can link new individuals to the first person.<br /><br />";
##$pgv_lang["download_gedcom_help"]		= "~#pgv_lang[download_gedcom]#~<br /><br />From this page you can download your genealogical database in GEDCOM format.  You may want to import the data into another genealogical program, or you may want to share its information with others.<br /><br />#pgv_lang[utf8_ansi_help]#<br /><br />#pgv_lang[remove_tags_help]#<br /><br />#pgv_lang[download_zipped_help]#";
##$pgv_lang["edit_gedcoms_help"]			= "~#pgv_lang[gedcom_adm_head]#~<br /><br />The #pgv_lang[gedcom_adm_head]# page is the control center for administering all of your genealogical databases.<br /><br /><b>#pgv_lang[current_gedcoms]#</b><br />At the head of the <b>#pgv_lang[current_gedcoms]#</b> table, you see an action bar with four links.<ul><li>#pgv_lang[add_gedcom]#</li><li>#pgv_lang[upload_gedcom]#</li><li>#pgv_lang[add_new_gedcom]#</li><li>#pgv_lang[lang_back_admin]#</li></ul>In the <b>#pgv_lang[current_gedcoms]#</b> table each genealogical database is listed separately, and you have the following options for each of them:<ul><li>Import</li><li>Delete</li><li>Download</li><li>Edit configuration</li><li>Edit privacy</li><li>SearchLog files</li></ul>Edit privacy appears here because every GEDCOM has its own privacy file.<br /><br />Each line in this table should be self-explanatory.  PhpGedView can be configured to log all database searches.  The SearchLog files can be inspected through links found on this page.<br />#pgv_lang[more_help]#<br />";
##$pgv_lang["edit_config_gedcom_help"]		= "~CONFIGURE GEDCOM~<br /><br />Every genealogical database used with PhpGedView has its own <b>Configuration file</b>.<br /><br />On this form you configure many options such as database title, language, calendar format, email options, logging of database searches, HTML META headers, removal of surnames from the database's Frequent Surnames list, etc.<br /><br />";
##$pgv_lang["import_gedcom_help"]			= "~IMPORT GEDCOM~<br /><br />In most cases importing of an externally created GEDCOM file is one step in procedures that result in bulk changes to the genealogical database.<br /><br />These steps are in a logical sequence and need to be completed in the prescribed order so that the genealogical database is usable.<br /><br />If, for some reason, you did not complete these steps in the correct order, you will see a <u>warning</u> message that the GEDCOM is not yet imported. To correct the problem, click the <b>Import GEDCOM</b> link to import the file.<br /><br />Existing GEDCOM configuration settings will not change when you re-import a GEDCOM.  Existing data will, however, be overwritten.<br /><br />";
##$pgv_lang["upload_gedcom_help"]			= "~#pgv_lang[upload_gedcom]#~<br /><br />Unlike the <b>#pgv_lang[add_gedcom]#</b> function, the GEDCOM file you wish to add to your database does not have to be on your server.<br /><br />In Step 1 you select a GEDCOM file from your local computer. Type the complete path and file name in the text box or use the <b>Browse</b> button on the page.<br /><br />You can also use this function to upload a ZIP file containing the GEDCOM file. PhpGedView will recognize the ZIP file and extract the file and the filename automatically.<br /><br />If a GEDCOM file with the same name already exists in PhpGedView, it will, after your confirmation, be overwritten. However, all GEDCOM settings made previously will be preserved.<br /><br />You will find more help on other pages of the procedure.<br /><br />";
##$pgv_lang["validate_gedcom_help"]		= "~VALIDATE GEDCOM~<br /><br />This is the third step in the procedure to add externally created GEDCOM data to your genealogical database.<br /><br />PhpGedView will check the input file for the correct use of Date format, Place format, Character Set, etc.  Some deviations from the GEDCOM 5.5.1 Standard, to which PhpGedView adheres, can be corrected automatically. Examples are Macintosh line endings and incorrect use of Place format.  When this happens, you will see a message that the data has been changed.  For other abnormalities you will get a warning message with a recommended solution.<br /><br /><b>Optional Tools</b><br />At this moment there is only one additional tool:<br /><b>Change Individual ID to...</b>.<br />#pgv_lang[more_config_help]#<br />";
##$pgv_lang["convert_ansi2utf_help"]		= "~CONVERT ANSI TO UTF-8~<br /><br />To ensure that the information in your input GEDCOM files is processed and displayed correctly, these files should be encoded in UTF-8.<br /><br />Some of the more modern genealogy programs can export their data to a GEDCOM file in UTF-8 encoding.  Older programs often don't have this capability.  If your program does not offer you this option, PhpGedView can convert the file for you.<br /><br />When PhpGedView validates the input file, it will detect the file's encoding and advise you accordingly.<br /><br />";
##$pgv_lang["detected_ansi2utf_help"]		= "~ANSI ENCODING DETECTED~<br /><br />The GEDCOM file being validated now is encoded in the ANSI character set.  You are strongly advised to convert the file's encoding to UTF-8.<br /><br /><br />#pgv_lang[convert_ansi2utf_help]#";
##$pgv_lang["detected_date_help"]			= "~WRONG DATE FORMAT DETECTED~<br /><br /><b>DATE FORMAT WILL BE CHANGED</b><br /><br />The date format that is standard for PhpGedView and also according to the GEDCOM 5.5.1 Standard is <b>DD&nbsp;MMM&nbsp;YYYY</b> (e.g. 01&nbsp;JAN&nbsp;2004)<br /><br />If, after your GEDCOM file has been validated, you see a message that a wrong date format has been detected, PhpGedView will convert the incorrectly formatted dates as prescribed by the Standard.<br /><br />You have, however, the option to choose either \"<b>day</b> before month\" (DD&nbsp;MMM&nbsp;YYYY), or \"<b>month</b> before day\" (MMM&nbsp;DD&nbsp;YYYY).<br /><br />We recommend that you use the first format (day before month).<br /><br />";
##$pgv_lang["change_indi2id_help"]		= "~CHANGE INDIVIDUAL ID TO ....~<br /><br />This tool was designed for users whose Genealogy programs use a different GEDCOM ID for the individuals every time the GEDCOM is exported. For example, the first time the GEDCOM is exported some person's ID might be I100 but the next time the GEDCOM is exported that same person's ID is changed to I234. These changing IDs make it difficult to administer PhpGedView because the ID is how people are referenced.<br /><br />Most genealogy programs also use the RIN or REFN tag to give each person a unique identifier that can be used to reference the individual. This tool will replace all of the individual IDs in the GEDCOM file with the whatever field (RIN or REFN) you specify.<br /><br />";
##$pgv_lang["edit_privacy_help"]			= "On this page you can make all the Privacy settings for the selected GEDCOM.<br /><br />You can check under the page title to see that you are editing the correct privacy file.  It is displayed like this: (path/nameofyourgedcom_priv.php)<br /><br />If you need more settings, you can make changes to the privacy file manually. You can read more about this on the PhpGedView web site.<br /><br />";
##$pgv_lang["BOM_detected_help"]			= "~Byte Order Mark (BOM) detected~<br /><br />The GEDCOM file you are importing has a special 3-byte code at the beginning.  This special code is used by some programs to indicate that the file has been recorded in the UTF-8 character set.<br /><br />Although this special code is not really an error, PhpGedView will not work properly when the input file contains the code.  You should let PhpGedView remove the code.<br /><br />";
##$pgv_lang["invalid_header_help"]		= "~INVALID GEDCOM HEADER~<br /><br />A GEDCOM file must begin with <b>0&nbsp;HEAD</b>. PhpGedView detected that the GEDCOM file you are importing does not have <b>0&nbsp;HEAD</b> as the first line. When you click the Cleanup button, any lines before the first <b>0&nbsp;HEAD</b> line will be removed.<br /><br />This error usually means that the program you used to create your GEDCOM did not create it properly or it is not a GEDCOM file. You should check to make sure that you uploaded the correct file, and that it starts with the line <b>0&nbsp;HEAD</b> and ends with the line <b>0&nbsp;TRLR</b>.<br /><br />";
##$pgv_lang["macfile_detected_help"]		= "~MACINTOSH FILE DETECTED~<br /><br />PhpGedView detected that your GEDCOM file was created on a Macintosh computer.<br /><br />Macintosh files end each line with a CR control code.  CR is Ctrl+M.<br />Unix files end each line with an LF control code.  LF is Ctrl+J.<br />Windows and DOS use a two-code sequence, CR followed by LF.<br /><br />PhpGedView requires that all files use Unix or DOS line endings. When you click the Cleanup button, your line endings will be converted accordingly.<br /><br />";
##$pgv_lang["cleanup_places_help"]		= "~CLEANUP PLACES~<br /><br />PhpGedView detected that your GEDCOM file uses places on GEDCOM tags that should not have places.<br /><br />Many genealogy programs, such as Family Tree Maker, will create this type of GEDCOM file. PhpGedView will work with these GEDCOM files, but some invalid places will show up in your place hierarchy. <br /><br />For example, your GEDCOM might have the following encoding<br />1 SSN<br />2 PLAC 123-45-6789<br />1 OCCU<br />2 PLAC Computer Programmer<br /><br />According to the GEDCOM 5.5.1 Standard this should really be shown as<br />1 SSN 123-45-6789<br />1 OCCU Computer Programmer<br /><br />If you select <b>Yes</b>, PhpGedView will automatically correct these encoding errors.<br /><br />";
##$pgv_lang["empty_lines_detected_help"]	= "~EMPTY LINES DETECTED~<br /><br />PhpGedView has detected that there are empty lines in your input file. These lines may cause errors and will be removed from the file before it is imported.<br /><br />";

//-- Edit Config
##$pgv_lang["help_editconfig.php"]		= "~CONFIGURE PhpGedView~<br /><br />On this page you configure the global settings for PhpGedView.  You have to do this after you have installed PhpGedView and are running it for the first time.<br /><br />#pgv_lang[review_readme]#As these settings are <b>global</b>, they are for the whole program and for all genealogical databases you use with PhpGedView.<br /><br />Each genealogical database also has additional configuration options that you set after clicking the <b>#pgv_lang[admin_gedcoms]#</b> link on this page.<br /><br />You can also access the #pgv_lang[gedcom_adm_head]# function from the main Admin page, whose link is found under the #pgv_lang[mgv]# icon or in the header of most pages.  On the Admin page, the relevant link is called <b>#pgv_lang[manage_gedcoms]#.</b><br /><br />";

//-- merge records
##$pgv_lang["help_edit_merge.php"]		= "~#pgv_lang[merge_records]#~<br /><br />This page will allow you to merge two GEDCOM records from the same GEDCOM file.<br /><br />This is useful for people who have merged GEDCOMs and now have many people, families, and sources that are the same.<br /><br />The page consists of three steps.<br /><ol><li>You enter two GEDCOM IDs.  The IDs <u>must</u> be of the same type.  You cannot merge an individual and a family or family and source, for example.<br />In the <b>#pgv_lang[merge_to]#</b> field enter the ID of the record you want to be the new record after the merge is complete.<br />In the <b>#pgv_lang[merge_from]#</b> field enter the ID of the record whose information will be merged into the #pgv_lang[merge_to]# record.  This record will be deleted after the Merge.</li><li>You select what facts you want to keep from the two records when they are merged.  Just click the checkboxes next to the ones you want to keep.</li><li>You inspect the results of the merge, just like with all other changes made online.</li></ol>Someone with Accept rights will have to authorize your changes to make them permanent.<br />";

//-- report engine
##$pgv_lang["help_reportengine.php"]	= "~REPORTS~<br />The items in the reports menu will generate PDF files for printing.<br /><br />The first step is to choose a report to run.  After you have selected a report to run, you will be asked to provide some information specific to that report, such as which individual or family to start with and whether or not to show photos.  When you are ready to run the report, click the <b>#pgv_lang[download_report]#</b> button to download the report to your computer.<br /><br /><br />#pgv_lang[help_xml_reports]#<br />#pgv_lang[def_pdf_format_help]#<br />#pgv_lang[help_ahnentafel.xml]#<br />#pgv_lang[help_birthlist.xml]#<br />#pgv_lang[help_relativelist.xml]#";
##$pgv_lang["def_pdf_format_help"]	= "~PDF FILE FORMAT~<br />The PhpGedView Reporting Engine produces downloadable reports in Adobe&reg; PDF format.  The GEDCOM 5.5.1 Standard specification, mentioned elsewhere in this Help file, is also downloadable as a PDF file.  PDF is an acronym for <b>P</b>ortable <b>D</b>ocument <b>F</b>ormat.<br /><br />PDF files are not viewable or printable by the standard software on your PC.  If you already have Acrobat Reader installed (it's often packaged with other softwares), you do not need to replace or upgrade it to deal with report files produced by PhpGedView.<br /><br />Acrobat Reader, the viewing and printing program for these files, is available free of charge from Adobe Systems Inc.  The free Adobe&reg; Acrobat Reader can be downloaded from the <a href=\"http://www.adobe.com/products/acrobat/readstep2.html\" target=\"_blank\"><b>Adobe Systems Inc.</b></a> web site.  You may find copies of \"Acrobat Reader\" available for download from other Internet sites, but we strongly advise you to trust <u>only</u> the Adobe Systems Inc. site.<br /><br />Acrobat Reader is available for many different systems, including Microsoft&reg; Windows and Apple&reg; Macintosh, in many languages other than English.  If you have a Windows 95 system, be sure to download Acrobat Reader version 5.0.5.  Versions more recent than this will not install correctly on Windows 95 systems.<br /><br /><a href=\"http://www.adobe.com/products/acrobat/readstep2.html\" target=\"_blank\"><b>Download Adobe Reader here</b></a><br /><br />";
##$pgv_lang["help_ahnentafel.xml"]	= "~#pgv_lang[ahnentafel_report]#~<br />This is a report of the selected person and his ancestors, printed in booklet format.  It starts with the first person and then continues with his or her parents, grand-parents, etc.<br /><br />Note that the ahnentafel report is only available in English at this time.<br /><br />";
##$pgv_lang["help_birthlist.xml"]		= "~#pgv_lang[birth_report]#~<br />With this report you can list all of the people who were born at a certain time or place.<br /><br />";
##$pgv_lang["help_relativelist.xml"]	= "~#pgv_lang[relatives_report]#~<br />This report will list all of the relatives of the selected individual.  You can choose which of the person's relatives to show on the report.<ul><li><b>#pgv_lang[child-family]#</b> will show the selected person, his parents, and his brothers and sisters.</li><li><b>#pgv_lang[spouse-family]#</b> will list the person with his or her spouses and their children.</li><li><b>#pgv_lang[direct-ancestors]#</b> will list the person, his parents, grand-parents, great-grand-parents, and continue up the tree listing all of the people who are parents in the person's lineage.</li><li><b>#pgv_lang[ancestors]#</b> will list all of the people from the #pgv_lang[direct-ancestors]# list but also include aunts and uncles and great-aunts and great-uncles, so it will include the siblings of all of the ancestors in this person's family tree.  It will not list the children of the siblings (cousins).</li><li><b>#pgv_lang[descendants]#</b> will list all of this person's descendants (children, grand-children, great-grand children, etc).</li><li><b>#pgv_lang[all]#</b> this option is a combination of the #pgv_lang[descendants]# and the #pgv_lang[ancestors]# in a single report.</li></ul><br /><br />";
##$pgv_lang["help_xml_reports"]	= "~Reporting Engine~<br />The PhpGedView Reporting Engine uses XML template files to automatically generate PDF reports.<br /><br />The reports available in the <b>#pgv_lang[select_report]#</b> list are generated from the report XML files found in the \"reports\" directory.  You can create your own reports by making a copy of any of the templates provided and modifying the template XML.  To add your custom report, just put it in the \"reports\" directory and PhpGedView will automatically detect it and make it available in the <b>#pgv_lang[select_report]#</b> drop-down list.<br /><br />";

//-- Help Contents
##$pgv_lang["help_contents_head_help"]		= "<b>HELP CONTENTS</b><br /><br />";
##$pgv_lang["help_contents_gedcom_info"]		= "GEDCOM info";
##$pgv_lang["help_contents_gedcom_places"]	= "Places in the GEDCOM";

//-- Admin Help Contents Items
##$pgv_lang["admin_help_contents_head_help"]	= "<b>HELP CONTENTS<br /><br />ADMINISTRATOR HELP ITEMS</b> added to the beginning of the list.<br /><br />";
// ##$pgv_lang["ah1_help"]				= "_Upgrade";
##$pgv_lang["ah2_help"]				= "_Configure PhpGedView";
##$pgv_lang["ah3_help"]				= "_GEDCOM: Add vs Upload";
##$pgv_lang["ah4_help"]				= "_GEDCOM: Configuration file";
##$pgv_lang["ah5_help"]				= "_GEDCOM: Default";
##$pgv_lang["ah6_help"]				= "_GEDCOM: Delete";
##$pgv_lang["ah7_help"]				= "_GEDCOM: Add";
##$pgv_lang["ah8_help"]				= "_GEDCOM: Create new";
##$pgv_lang["ah9_help"]				= "_GEDCOM: Download";
##$pgv_lang["ah10_help"]				= "_GEDCOM: Administration page";
##$pgv_lang["ah11_help"]				= "_GEDCOM: Configure";
##$pgv_lang["ah12_help"]				= "_GEDCOM: Import";
##$pgv_lang["ah13_help"]				= "_GEDCOM: Upload";
##$pgv_lang["ah14_help"]				= "_GEDCOM: Validate";
##$pgv_lang["ah15_help"]				= "_GEDCOM: Convert ANSI to UTF-8";
##$pgv_lang["ah16_help"]				= "_GEDCOM: Privacy settings";
##$pgv_lang["ah17_help"]				= "_User Administration";
##$pgv_lang["ah18_help"]				= "_Administration";
##$pgv_lang["ah19_help"]				= "_GEDCOM: Media tool";
##$pgv_lang["ah20_help"]				= "_GEDCOM: Change Individual ID to ...";
##$pgv_lang["ah21_help"]				= "_Translator tools";
//           22 is in the help_text_vars.php
##$pgv_lang["ah23_help"]				= "_Configure supported languages";
##$pgv_lang["ah24_help"]				= "_User Information migrate (Index --&gt;&gt; SQL)";
##$pgv_lang["ah25_help"]				= "_PhpGedView backup";
##$pgv_lang["ah26_help"]				= "_FAQ List: Edit";

//--Statistics Help
##$pgv_lang["help_statisticsplot.php"] = "~Statistics Plot~<br /><br />This is the result page, showing the graphical plot of the statistics from your database as defined by the inputs on the previous page.<br /><br />";
##$pgv_lang["help_statistics.php"] = "~Statistics Plot~<br /><br />This page lets you determine the criteria for producing a graphical display of various statistics from your database.<br /><br />";
##$pgv_lang["stat_help"]		= "~OPTIONS FOR STATISTICS PLOTS~<br /><br />A number of different plots of statistics from your database can be produced.<br /><br />Select the chart, then adjust the options from the drop-down boxes.<br /><br />The numbers included in each plot depend on the data available. For example, individuals without a month of birth (e.g. just '1856') cannot be included in a plot of births by month.<br /><br />";
##$pgv_lang["stat_help_x"]		= "~OPTIONS FOR STATISTICS PLOTS~<br /><br />~X AXIS~<br />The following options are available for the X axis (horizontal). Each will then be presented according to options set for the Y and Z axes.<p style=\"padding-left: 25px\"><b>#pgv_lang[stat_11_mb]#</b>&nbsp;&nbsp;individuals born in each month.<br /><b>#pgv_lang[stat_12_md]#</b>&nbsp;&nbsp;individuals who died in each month.<br /><b>#pgv_lang[stat_13_mm]#</b>&nbsp;&nbsp;marriages that occurred in each month.<br /><b>#pgv_lang[stat_14_mb1]#</b>&nbsp;&nbsp;the number of first-borns for each family by month.<br /><b>#pgv_lang[stat_15_mm1]#</b>&nbsp;&nbsp;the number of first marriages per month.<br /><b>#pgv_lang[stat_16_mmb]#</b>&nbsp;&nbsp;the number of months between marriage and birth of first child to that couple.<br /><b>#pgv_lang[stat_17_arb]#</b>&nbsp;&nbsp;age at death, related to the time period that includes each person's birth year.<br /><b>#pgv_lang[stat_18_ard]#</b>&nbsp;&nbsp;age at death, related to the time period that includes each person's year of death.<br /><b>#pgv_lang[stat_19_arm]#</b>&nbsp;&nbsp;the average age of individuals at the time of their marriages.<br /><b>#pgv_lang[stat_20_arm1]#</b>&nbsp;&nbsp;the average age of individuals at the time of their first marriage.<br /><b>#pgv_lang[stat_21_nok]#</b>&nbsp;&nbsp;average family sizes.<br /><b>#pgv_lang[stat_1_map]#</b>&nbsp;&nbsp;placement of all persons or persons with the specified name, by country.<br /><b>#pgv_lang[stat_2_map]#</b>&nbsp;&nbsp;country of birth.<br /><b>#pgv_lang[stat_4_map]#</b>&nbsp;&nbsp;country of marriage.<br /><b>#pgv_lang[stat_3_map]#</b>&nbsp;&nbsp;country of death.<br /><b>#pgv_lang[stat_9_indi]#</b>&nbsp;&nbsp;pie chart of individuals with sources.<br /><b>#pgv_lang[stat_8_fam]#</b>&nbsp;&nbsp;pie chart of families with sources.</p><br /><br />";
##$pgv_lang["stat_help_y"]		= "~OPTIONS FOR STATISTICS PLOTS~<br /><br />~Y AXIS~<br />The following options are available for the Y axis (vertical). These options alter the way the items presented on the X axis are displayed.<p style=\"padding-left: 25px\"><b>#pgv_lang[stat_201_num]#</b>&nbsp;&nbsp;displays the number of individuals in each category defined by the X axis.<br /><b>#pgv_lang[stat_202_perc]#</b>&nbsp;&nbsp;calculates and diplays the proportion of each item in the X axis categories.</p><br /><br />";
##$pgv_lang["stat_help_z"]		= "~OPTIONS FOR STATISTICS PLOTS~<br /><br />~Z AXIS~<br />The following options are available for the Z axis. These options provide a sub-division of the categories selected for the X axis.<p style=\"padding-left: 25px\"><b>#pgv_lang[stat_300_none]#</b>&nbsp;&nbsp;displays the items as a single column for each X axis category.<br /><b>#pgv_lang[stat_301_mf]#</b>&nbsp;&nbsp;displays the items in 2 columns (male and female) for each X axis category.<br /><b>#pgv_lang[stat_302_cgp]#</b>&nbsp;&nbsp;displays the items in a number of columns related to the time periods set in the next section, for each X axis category.</p><br /><br />";
##$pgv_lang["stat_help_gwx"]		= "~OPTIONS FOR STATISTICS PLOTS~<br /><br />~boundaries for X axis~<br />Select the desired age interval.<br /><br />For example, <b>#pgv_lang[aft_marr]#</b> describes the following set of month ranges:<div style=\"padding-left:30px;\">before the marriage<br />from the marriage to 8 months after<br />from 8 to 12<br />from 12 to 15<br />from 15 to 18<br />from 18 to 24<br />from 24 to 48<br />over 48 months after the marriage</div><br /><br />When you want to show quarters you have to choose: <b>quarters</b>.<br /><br />";
##$pgv_lang["stat_help_gax"]		= "~OPTIONS FOR STATISTICS PLOTS~<br /><br />~boundaries for X axis~<br />Select the desired age interval.<br /><br />For example, <b>interval 10 years</b> describes the following set of age ranges:<div style=\"padding-left:30px;\">younger than one year<br />one year to 5 years<br />6 to 10<br />11 to 20<br />21 to 30<br />31 to 40<br />41 to 50<br />51 to 60<br />61 to 70<br />71 to 80<br />81 to 90<br />91 to 100<br />older than 100 years</div><br /><br />";
##$pgv_lang["stat_help_gbx"]		= "~OPTIONS FOR STATISTICS PLOTS~<br /><br />~boundaries for X axis~<br />Select the desired age interval.<br /><br />For example, <b>interval 2 years</b> describes the following set of age ranges:<div style=\"padding-left:30px;\">younger than 16 years<br />16 to 18<br />19 to 20<br />21 to 22<br />23 to 24<br />25 to 26<br />27 to 28<br />29 to 30<br />31 to 32<br />33 to 35<br />36 to 40<br />41 to 50<br />older than 50 years</div><br /><br />";
##$pgv_lang["stat_help_gcx"]		= "~OPTIONS FOR STATISTICS PLOTS~<br /><br />~boundaries for X axis~<br />Select the desired count interval.<br /><br />For example, <b>interval one child</b> describes the following set of child count ranges:<div style=\"padding-left:30px;\">without children<br />one child<br />two children<br />3, 4, 5, 6, 7, 8, 9, 10 children<br />more than 10 children</div><br /><br />";
##$pgv_lang["stat_help_gwz"]		= "~OPTIONS FOR STATISTICS PLOTS~<br /><br />~boundaries for Z axis~<br />Select the desired starting year and interval<br /><br />For example, <b>from 1700 interval 50 years</b> describes the following set of date ranges:<div style=\"padding-left:30px;\">before 1700<br />1700 to 1749<br />1750 to 1799<br />1800 to 1849<br />1850 to 1899<br />1900 to 1949<br />1950 to 1999<br />2000 or later</div><br /><br />";
##$pgv_lang["chart_type_help"]	= "~OPTIONS FOR STATISTICS PLOTS~<br /><br />Select what you want to see on the map chart. You can choose:<p style=\"padding-left: 25px\"><b>#pgv_lang[indi_distribution_chart]#</b>&nbsp;&nbsp;shows the countries in which persons from this database occur.<br /><b>#pgv_lang[surname_distribution_chart]#</b>&nbsp;&nbsp;shows the countries in which the specified surname occurs.</p><br /><br />";
##$pgv_lang["google_chart_surname_help"]	= "~OPTIONS FOR STATISTICS PLOTS~<br /><br />The number of occurrences of the specified name will be shown on the map. If you leave this field empty, the most common surname will be used.<br /><br />";
##$pgv_lang["chart_area_help"]	= "~OPTIONS FOR STATISTICS PLOTS~<br /><br />Select the geographical area that you want to see on the map. You can choose:<p style=\"padding-left: 25px\"><b>#pgv_lang[world_chart]#</b>&nbsp;&nbsp;shows all continents.<br /><b>#pgv_lang[europe_chart]#</b>&nbsp;&nbsp;shows Europe.<br /><b>#pgv_lang[s_america_chart]#</b>&nbsp;&nbsp;shows South America.<br /><b>#pgv_lang[asia_chart]#</b>&nbsp;&nbsp;shows Asia.<br /><b>#pgv_lang[middle_east_chart]#</b>&nbsp;&nbsp;shows the Middle East.<br /><b>#pgv_lang[africa_chart]#</b>&nbsp;&nbsp;shows Africa.</p><br /><br />";

//-- Find Media Help
##$pgv_lang["manage_media_help"]		= "~#pgv_lang[manage_media]#~<br /><br />On this page you can easily manage your Media files and directories.<br /><br />When you create new Media subdirectories, PhpGedView will ensure that the identical directory structure is maintained within the <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs</b> directory.  When you upload new Media files, PhpGedView can automatically create the thumbnails for you.<br /><br />Beside each image in the Media list you'll find the following options.  The options actually shown depend on the current status of the Media file.<ul><li><b>#pgv_lang[edit]#</b>&nbsp;&nbsp;When you click on this option, you'll see a page where you can change the title of the Media object.  If the Media object is not yet linked to a person, family, or source in the currently active database, you can establish this link here.  You can rename the file or even change its location within the <b>#GLOBALS[MEDIA_DIRECTORY]#</b> directory structure.  When necessary, PhpGedView will automatically create the required subdirectories or any missing thumbnails.</li><li><b>#pgv_lang[edit_raw]#</b>&nbsp;&nbsp;This option is only available when the administrator has enabled it.  You can view or edit the raw GEDCOM data associated with this Media object.  You should be very careful when you use this option.</li><li><b>#pgv_lang[delete_file]#</b>&nbsp;&nbsp;This option lets you erase all knowledge of the Media file from the current database.  Other databases will not be affected.  If this Media file is not mentioned in any other database, it, and its associated thumbnail, will be deleted.</li><li><b>#pgv_lang[remove_object]#</b>&nbsp;&nbsp;This option lets you erase all knowledge of the Media file from the current database.  Other databases will not be affected.  The Media file, and its associated thumbnail, will not be deleted.</li><li><b>#pgv_lang[remove_links]#</b>&nbsp;&nbsp;This option lets you remove all links to the media object from the current database.  The file will not be deleted, and the Media object by which this file is known to the current database will be retained.  Other databases will not be affected.</li><li><b>#pgv_lang[set_link]#</b>&nbsp;&nbsp;This option lets you establish links between the media file and persons, families, or sources of the current database.  When necessary, PhpGedView will also create the Media object by which the Media file is known to the database.</li><li><b>#pgv_lang[gen_thumb]#</b>&nbsp;&nbsp;When you select this option, PhpGedView will create the missing thumbnail.</li></ul><br /><br />";
##$pgv_lang["simple_filter_help"]		= "~#pgv_lang[filter]#~<br /><br />Simple search filter based on the characters entered, no wildcards are accepted.<br /><br />";
##$pgv_lang["show_thumb_help"]		= "~#pgv_lang[show_thumbnail]#~<br /><br />Thumbnails will be shown if you check this box.<br /><br />";
##$pgv_lang["new_dir_help"]			= "~#pgv_lang[add_directory]#~<br /><br />As an admin user you can create the directory structure you require to keep your media files organized. Creating directories from this page ensures that the thumbnail directories are created as well as creating a suitable index.php in each directory.<br /><br />Click on this link to enter the name of the directory you wish to create.<br /><br />";
##$pgv_lang["find_media_help"]		= "~#pgv_lang[find_media]#~<br /><br />This allows you to search the file structure to find the media item you wish to link to.<br /><br />";

//-- Add / Edit Media Help
##$pgv_lang["add_media_linkid"]		= "~Link ID~<br /><br />Each media item should be associated with one or more person, family, or source records in your database.<br /><br />To establish such a link, you can enter or search for the ID of the person, family, or source at the same time as you create the media item.  You can also establish the link later through editing options on the Manage Media page, or by adding media items through the Add Media link available on the Individual, Family, or Source Details pages.<br /><br />";
##$pgv_lang["upload_server_file_help"] = "~#pgv_lang[server_file]#~<br /><br />The media file you are uploading can be, and probably should be, named differently on the server than it is on your local computer.  This is so because often the local file name has meaning to you but is much less meaningful to others visiting this site.  Consider also the possibility that you and someone else both try to upload different files called \"granny.jpg\".<br /><br />In this field, you specify the new name of the file you are uploading.  The name you enter here will also be used to name the thumbnail, which can be uploaded separately or generated automatically.  You do not need to enter the file name extension (jpg, gif, pdf, doc, etc.)<br /><br />Leave this field blank to keep the original name of the file you have uploaded from your local computer.<br /><br />";
##$pgv_lang["upload_server_folder_help"] = "~#pgv_lang[server_folder]#~<br /><br />The administrator has enabled up to #GLOBALS[MEDIA_DIRECTORY_LEVELS]# folder levels below the default <b>#GLOBALS[MEDIA_DIRECTORY]#</b>.  This helps to organize the media files and reduces the possibility of name collisions.<br /><br />In this field, you specify the destination folder where the uploaded media file should be stored.  The matching thumbnail file, either uploaded separately or generated automatically, will be stored in a similar folder structure starting at <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b> instead of <b>#GLOBALS[MEDIA_DIRECTORY]#</b>.  You do not need to enter the <b>#GLOBALS[MEDIA_DIRECTORY]#</b> part of the destination folder name.<br /><br />If you are not sure about what to enter here, you should contact your site administrator for advice.<br /><br />";
##$pgv_lang["view_server_folder_help"] = "~#pgv_lang[server_folder]#~<br /><br />The administrator has enabled up to #GLOBALS[MEDIA_DIRECTORY_LEVELS]# folder levels below the default <b>#GLOBALS[MEDIA_DIRECTORY]#</b>.  This helps to organize the media files and reduces the possibility of name collisions.<br /><br />In this field, you select the media folder whose contents you wish to view.  When you select <b>#pgv_lang[all]#</b>, all media files will be shown without regard to the folder in which they are stored.  This can produce a very long list of media items.<br /><br />";

//--Repository Help
##$pgv_lang["help_repolist.php"]		= "~#pgv_lang[repo_list]#~<br /><br />A list of repositories is displayed on this page.<br /><br />The names of the repositories are sorted into alphabetical order.<br /><br /><b>REPOSITORIES</b><br />Without repositories we cannot build our database. There is a source for all information stored in the database, and that source is kept in a repository. Repositories can be the personal archive of a person, an institution, a public database, a government or church records office, an Internet resource, etc. To get access to a source we will want to know where and in what place it is. All necessary information to find a source should be stored in the Repository record.<br /><br />A repository can be linked to many sources.<br /><br />";
##$pgv_lang["help_repo.php"]			= "~#pgv_lang[repo_info]#~<br /><br />The details of the Repository are displayed here. Together with Sources, Repositories are very important to genealogical researchers.  With accurate Source and Repository information, you can follow the trail another researcher used to find the information.  You should be able to find that same information again.<br /><br />On this page you may see information about the Repository's title, address, email and webpage.<br /><br />After the repository details, will be a list of all sources that are linked to this repository. This allows you to see all of the information that was obtained from a particular repository.<br /><br />If enabled by the site admin, you will have one or two more menu icons on this page:<br /><b>#pgv_lang[view_gedcom]#</b>, which shows the information in GEDCOM format.<br /><b>#pgv_lang[add_to_cart]#</b>, which enables you to store this information in your #pgv_lang[clip_cart]#. From there you can download the information in GEDCOM file format and import it into your own genealogy program.<br /><br />#pgv_lang[context_help]#<br /><br />";
##$pgv_lang["delete_repo_help"]			= "~#pgv_lang[delete_repo]#~<br /><br />When you click this option you mark this Repository to be deleted from the database.<br /><br />What does that mean?<br />Let's suppose you have a good reason to remove this Repository from the database. You click the link.  You will be asked to confirm your deletion request.  If you decide to continue, it can take a little time before you see a message that the Repository is deleted.<br /><br />When you continue with your visit, you will notice that the Repository is still visible and can be used as if the deletion had not occurred.<br /><br /><b>This is <u>not</u> an error.</b>  The site admin will get a message that a change has been made to the database, and that you removed the Repository.<br />The administrator can accept or reject your change. Only after the administrator has accepted your change will the deletion actually occur <u>irreversibly</u>.  If there is any doubt about your change, the administrator will contact you.<br /><br />";
##$pgv_lang["show_repo_gedcom_help"]	= "~#pgv_lang[view_gedcom]#~<br /><br />When you click this link, the information about the repository, as it is stored in the database, will be displayed in a popup window.<br /><br />";
##$pgv_lang["add_repository_clip_help"]		= "~#pgv_lang[add_to_cart]#~<br /><br />When you click this link you can add the repository, as it is stored in the GEDCOM, to your #pgv_lang[clip_cart]#.<br /><br />";
##$pgv_lang["repolist_listbox_help"]		= "~#pgv_lang[repo_list]#~<br /><br />In this box you see the names of the repositories as they are stored in the database.<br /><br />The names are displayed in alphabetical order.<br /><br />When you click on a name in the list, you will go to the #pgv_lang[repo_info]# page where you will see a list of the sources that are linked to that repository.<br /><br />";
##$pgv_lang["repos_listbox_help"]		= "~#pgv_lang[other_repo_records]#~<br /><br />In this box you see the names of sources that are linked to the repository.<br /><br />The names are displayed in alphabetical order.<br /><br />When you click on a name in the list, you will go to the Detail page of that source.<br /><br />";

// Index-Edit
##$pgv_lang["block_move_up_help"]		= "~Move list entries~<br /><br />Use these buttons to re-arrange the order of the entries within the list.  The blocks will be printed in the order in which they are listed.<br /><br />Highlight the entry to be moved, and then click a button to move that entry up or down.<br /><br />";
##$pgv_lang["block_move_right_help"]	= "~Move list entries~<br /><br />Use these buttons to move an entry from one list to another.<br /><br />Highlight the entry to be moved, and then click a button to move or copy that entry in the direction of the arrow.  Use the <b>&raquo;</b> and <b>&laquo;</b> buttons to move the highlighted entry from the leftmost to the rightmost list or vice-versa.  Use the <b>&gt;</b> and <b>&lt;</b> buttons to move the highlighted entry between the #pgv_lang[available_blocks]# list and the list to its right or left.<br /><br />The entries in the #pgv_lang[available_blocks]# list do not change, regardless of what you do with the #pgv_lang[move_right]# and #pgv_lang[move_left]# buttons.  This is so because the same block can appear several times on the same page.  The HTML block is a good example of why you might want to do this.<br /><br />";
##$pgv_lang["block_default_index"]	= "~Default blocks on #pgv_lang[welcome]# page~<br /><br />When you remove all entries from the #pgv_lang[main_section]# and #pgv_lang[right_section]# lists, or when you click the <b>#pgv_lang[reset_default_blocks]#</b> button, the block list will be set as follows:<br /><br /><center><table border=\"1\"><tr><td class=\"list_value\"><b>#pgv_lang[main_section]#</b></td><td class=\"list_value\"><b>#pgv_lang[right_section]#</b></td></tr><tr><td>#pgv_lang[gedcom_stats_block]#<br />#pgv_lang[gedcom_news_block]#<br />#pgv_lang[gedcom_favorites_block]#<br />#pgv_lang[review_changes_block]#</td><td>#pgv_lang[gedcom_block]#<br />#pgv_lang[random_media_block]#<br />#pgv_lang[todays_events_block]#<br />#pgv_lang[logged_in_users_block]#</td></tr></table></center><br />";
##$pgv_lang["block_default_portal"]	= "~Default blocks on #pgv_lang[mygedview]# page~<br /><br />When you remove all entries from the #pgv_lang[main_section]# and #pgv_lang[right_section]# lists, or when you click the <b>#pgv_lang[reset_default_blocks]#</b> button, the block list will be set as follows:<br /><br /><center><table border=\"1\"><tr><td class=\"list_value\"><b>#pgv_lang[main_section]#</b></td><td class=\"list_value\"><b>#pgv_lang[right_section]#</b></td></tr><tr><td>#pgv_lang[todays_events_block]#<br />#pgv_lang[user_messages_block]#<br />#pgv_lang[user_favorites_block]#<br />&nbsp;</td><td>#pgv_lang[welcome_block]#<br />#pgv_lang[random_media_block]#<br />#pgv_lang[upcoming_events_block]#<br />#pgv_lang[logged_in_users_block]#</td></tr></table></center><br />";

// FAQ page
##$pgv_lang["help_faq.php"] = "~Frequently Asked Questions~<br />#pgv_lang[text_faq_help]#<br />";
##$pgv_lang["text_faq_help"] = "The FAQ (Frequently Asked Questions) page can contain an overview or a list of questions and answers on the use of this genealogy site.<br /><br />The use to which the FAQ page is put is entirely up to the site administrator. The site administrator controls the content of each item and also the order in which the items are shown on the page.";

// Help search
##$pgv_lang["hs_title_help"] 			= "<center>~#pgv_lang[hs_title]#~</center><br />#pgv_lang[hs_intro]#<br /><br />#pgv_lang[hs_keyword_advice]#<br /><br />#pgv_lang[hs_searchhow_advice]#<br /><br />#pgv_lang[hs_searchin_advice]#";
##$pgv_lang["hs_intro"]				= "You can search PhpGedView's Help system.  The #pgv_lang[hs_title]# feature gives you a high degree of control over the way the search functions; you should be able to find what you are looking for easily.";
##$pgv_lang["hs_keyword_advice"] 		= "~#pgv_lang[hs_keyword]#~<br />You enter the words or the phrase you wish to find.<br /><br />The search does not pay attention to the case (upper or lower) of the search terms or the text being examined.  This means that if you search for <b>Individual</b>, you will find text containing <b>Individual</b>, <b>individual</b>, or <b>INDIVIDUAL</b>.  You will also find text containing <b>individuals</b>, etc. since the search is looking for sequences of characters rather than words.<br /><br />You can have the search look for several words at once.  Enter all of the words, separating each of them by a space, like this: <b>individual&nbsp;family&nbsp;child</b>.  When more than one word is entered, the meaning of what you have typed is clarified in the #pgv_lang[hs_searchhow]# field.<br />";
##$pgv_lang["hs_searchin_advice"]		= "~#pgv_lang[hs_searchin]#~<br />You determine the scope of the search here.<br /><br />Administrators have the choice of searching User Help or Configuration Help or both.  Users do not have this choice; because they do not have access to any configuration features, they can only search the User Help file.<br /><br />The Help files contain not only Help text but also certain text strings used to build input forms and other material.  This option lets you control whether the entire Help file should be examined or whether only the Help text should be looked at.<br />";
##$pgv_lang["hs_searchhow_advice"]	= "~#pgv_lang[hs_searchhow]#~<br />You clarify the meaning of what you have entered into the #pgv_lang[hs_keyword]# field by selecting among the possibilities presented here.<br /><dl><dt><b>#pgv_lang[hs_searchany]#</b></dt><dd>If you have entered <b>individual&nbsp;family&nbsp;child</b>, this option will find Help text that contains one of the words listed.  The order of the words doesn't matter.  The meaning of the search is: \"Find Help text containing <b>individual</b> <u>or</u> <b>family</b> <u>or</u> <b>child</b>\".</dd><dt><b>#pgv_lang[hs_searchall]#</b></dt><dd>If you have entered <b>individual&nbsp;family&nbsp;child</b>, this option will find Help text that contains all of the words listed.  The order of the words doesn't matter.  The meaning of the search is: \"Find Help text containing <b>individual</b> <u>and</u> <b>family</b> <u>and</u> <b>child</b>\".</dd><dt><b>#pgv_lang[hs_searchsentence]#</b></dt><dd>If you have entered <b>individual&nbsp;family&nbsp;child</b>, this option will find Help text that contains all of the words listed in the order given.  The meaning of the search is: \"Find Help text containing the words <b>individual&nbsp;family&nbsp;child</b> in exactly that order with no other words or characters between\".  You probably won't find this particular phrase in any Help text.<br /><br />There are a few limitations on this type of search.  Certain special characters such as <b>&quot; &lt; &gt;</b> etc. are contained within the Help text in symbolic form and won't be found if they form part of the text you enter.  Some Help text contains a special kind of Space character represented by <b>&amp;nbsp;</b> and you won't find phrases containing this character.</dd></dl>";

// Directory cleanup tool
##$pgv_lang["help_dir_editor.php"]	= "~#pgv_lang[index_dir_cleanup]#~<br /><br />This tool can help site administrators clean up files in the Index directory.<br /><br />Over time, files such as log files, old GEDCOM files, and old backup files can build up in the Index directory.  Since many of these files are created by the program, they may be owned by the web server user.  If they are owned by the web server user, you might not be able to delete them. This tool lets you delete these files even when they are owned by the web server user account.<br /><br />#pgv_lang[index_dir_cleanup_inst]#";
?>
