<?php
/**
 * Slovak Language file for PhpGedView.
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2008  PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 * @package PhpGedView
 * @subpackage Languages
 * @author Peter Moravčík
 * @version $Id: help_text.sk.php 4194 2008-10-30 10:45:46Z fisharebest $
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

//-- GENERAL
$pgv_lang["help_header"]			= "Daľšie informácie o:";
$pgv_lang["privacy_error_help"]			= "<b>SÚKROMNÉ ÚDAJE</b><br /><br />Existuje niekoľko možných dôvodov, prečo sa vám zobrazila táto správa:<br /><br /><b>1. Informácie o žijúcich osobách v tomto GEDCOMe sú označené ako \"Súkromné\".</b><br /> Neregistrovaný návštevníci alebo návštevníci, ktorý nie sú prihlásený do systému, si môžu prezerať iba osobné údaje zosnulých osôb. Ak je to umožnené administrátorom, môžete sa zaregistrovať kliknutím na tlačítko \"Prihlásiť sa\", potom na odkaz #pgv_lang[requestpassword]#.<br /><br /><b>2. Ste uživateľ, ktorý tu má účet zo svojím uživateľským menom a heslom...</b><br />Ale zabudli ste sa prihlásiť alebo ste neboli dlhšiu dobu aktívny, a tak vám vypršala \"životnosť\" session.<br /><br /><b>3. Kvôli nastaveniu utajenia</b><br />Osoba, na meno ktorej ste klikli, požiadala admina, aby informácie o nej boli nastavené ako súkromné alebo neboli zobrazené vôbec.<br />Utajenie môže byť nastavené na:<br />a) #pgv_lang[PRIV_USER]#<br />b) #pgv_lang[PRIV_NONE]#<br />c) #pgv_lang[PRIV_HIDE]#<br /><br /><b>4. Mimo \"príbuzenskú vzdialenosť\"</b><br />I keď ste registrovaným uživateľom <b>a</b> ste prihlásený, môže sa stať, že sa vám zobrazí táto správa. A to v prípade, že osoba, ktorú chcete zobraziť je s vami príbuzná vzdialene – vzdialenejšie, než je administrátorom nastavená Príbuzenská vzdialenosť pre tento GEDCOM.<br />Príklady:<br />Keď je Príbuzenská vzdialenosť nastavená na <b>1</b>, môžete zobraziť osobné údaje iba svojej najužšej rodiny: otca, matky, brata, sestry (ale nie partnerov vaších súrodencov a ich detí)<br /><br />Keď je Príbuzenská vzdialenosť nastavená na <b>2</b>, môžete zobraziť i údaje vašej švagriny a jej detí (ale nie partnerov týchto detí).<br />Čím väčšia je hodnota je nastavená v Príbuzenskej vzdialenosti, tým vzdialenejších príbuzných uvidíte (ich osobné údaje).<br /><br />Ak si myslíte, že môžete získať oprávnenie vidieť určité údaje, kontaktujte prosím administrátora stránok. Odkaz na neho je na každej stránke.";
$pgv_lang["more_help"]				= "<br />Ak chcete mať k dispozícii kontextovú nápovedu, uistite sa, že je voľba <b>#pgv_lang[show_context_help]#</b> zapnutá (v Menu nápovedy), a kliknite na <b>?</b> za textom.<br />";
$pgv_lang["more_config_help"]			= "<br /><b>Ďalšia nápoveda</b><br />Ďalšia nápoveda je k dispozícii z formulára.<br />Kliknite prosím na <b>?</b> za popiskami.<br />";
$pgv_lang["start_admin_help"]			= "+++ Začiatok informácií naviac pre Admina +++";
$pgv_lang["end_admin_help"]			= "--- Koniec informácií naviac pre Admina ---";
$pgv_lang["multiple_help"]			= "<center>--- Toto je všeobecná nápoveda pre viacej stránok ---</center>";
$pgv_lang["header_general_help"]		= "<div class=\"name_head\"><center><b>VŠEOBECNÉ INFORMÁCIE</b></center></div><br />";
$pgv_lang["best_display_help"]			= "~Váš monitor~<br/>PhpGedView je navrhnuté pre rozlíšenie 1024x768 pixelov.<br />Pre správne zobrazenie je teda potrebné, aby vaše rozlíšenie bolo minimálne 1024x768.<br />Ak nastavíte rozlíšenie na nižšiu hodnotu (napr. 800x600 pix.), budete sa musieť v okne vodorovne posúvať.<br />";
$pgv_lang["preview_help"]			= "~Tlač~<br />Ak kliknete na odkaz Tlačový režim, budú zo stránky odstránené všetky položky, ktoré v tlačovej podobe prekážajú (menu, formulárové políčka, odkazy, otázniky pre nápovedu apod.).<br />Dolu na stránke určenej pre tlač uvidíte odkaz Vytlačiť. Kliknite naň a objaví sa dialogové okno tlače.<br />Po vytlačení proste iba kliknete na odkaz <b>Späť</b> a objaví sa opäť stránka v normálnom režime.<br /><br /><b>Poznámka:</b><br />I keď sú všetky nadbytočné odkazy v náhľadovom režime odstránené, na mená v rámčekoch je možné klikať.<br />";
$pgv_lang["readme_help"]			= "<center>Ak chcete ďalšie informácie, podívajte sa do súboru <a href=\"readme.txt\" target=\"_blank\"><b>Readme.txt</b></a>.</center>";
$pgv_lang["is_user_help"]			= "--- Tento text je rovnaký ako ten, ktorý bude čítať uživateľ (alebo návštevník). --- <br />--- Aby sme ušetrili miesto, nevytvárame u tejto položky špeciálny text pre admina. --";
$pgv_lang["edit_raw_gedcom_help"]		= "~UPRAVIŤ PRIAMO GEDCOM~<br /><br />Ak kliknete na tento odkaz, otvorí sa nové okno zo \"zdrojovým kódom\" GEDCOMu, konkrétne s údajmi, ktoré sú zobrazené na tejto stránke.<br />Tu môžete upravovať priamo samotný GEDCOM súbor. Dbajte na to, aby ste údaje zapisovali podľa štandardu GEDCOM 5.5, pretože tieto záznamy sa už nebudú kontrolovať.<br />Zmenené, alebo pridané údaje sa v PhpGedView zobrazia ako zmeny, a budú teda musieť byť prijaté (potvrdené) uživateľom s právom potvrdzovať zmeny.";
$pgv_lang["RESN_help"]				= "~NATAVENIE REŠTRIKCIÍ PRE ÚDAJE~<br /><br />Nezávisle na všeobecnom nastavení utajenia, PhpGedView má možnosť nastavenia reštrikcií na zobrazenie a editáciu údajov osôb, alebo rodín. Reštrikcie môžu byť nastavené kýmkoľvek, kto má oprávnenie editovať údaje, ak mu to dovolujú už nastavené reštrikcie.<br /><br />Môžu byť použité nasledujúce hodnoty:<br /><ul><li><b>#pgv_lang[none]#</b><br/>Administrátorovia stránky, administrátorovia GEDCOM, a uživatelia ktorí majú právo editovať údaje. Údaje môžu byť zobrazené podľa nastavenia utajenia nastaveného administrátorom.</li><li><b>#pgv_lang[locked]#</b><br />Toto nastavenie nemá žiadny vplyv na viditelnosť dát údajov. Obmedzí právo editácie pre administratorov stránky a administrátorom GEDCOM. Ak údaje patria uživateľovi, on ich môže zobraziť a samozrejme i editovať.</li><li><b>#pgv_lang[privacy]#</b><br />Administrátorovia stránky a GEDCOMu môžu zobraziť a editovať tieto údaje. Ak údaje patria uživateľovi, on ich môže zobraziť a samozrejme i editovať. Ale budú ukryté všetkým ďalším uživateľom bez ohľadu na ich status prihlásenia.</li><li><b>#pgv_lang[confidential]#</b><br />Iba  administrátorovia stránky a GEDCOMu môžu zobraziť a editovať údaje. Ale budú ukryté všetkým ďalším uživateľom bez ohľadu na ich status prihlásenia.</li></ul><br /><table><tr><th></th><th colspan=2>Admin</th><th colspan=2>Vlastník</th><th colspan=2>Ďalší</th></tr><tr><th></th><th>R</th><th>W</th><th>R</th><th>W</th><th>R</th><th>W</th></tr><tr><td><img src=\"images/RESN_none.gif\" alt=\"\"/> #pgv_lang[none]#</td><th><img src=\"images/checked.gif\"/></th><th><img src=\"images/checked.gif\"/></th><th><img src=\"images/checked_qm.gif\"/></th><th><img src=\"images/checked_qm.gif\"/></th><th><img src=\"images/checked_qm.gif\"/></th><th><img src=\"images/checked_qm.gif\"/></th></tr><tr><td><img src=\"images/RESN_locked.gif\" alt=\"\"/> #pgv_lang[locked]#</td><th><img src=\"images/checked.gif\"/></th><th><img src=\"images/checked.gif\"/></th><th><img src=\"images/checked_qm.gif\"/></th><th><img src=\"images/checked_qm.gif\"/></th><th><img src=\"images/checked_qm.gif\"/></th><th><img src=\"images/forbidden.gif\"/></th></tr><tr><td><img src=\"images/RESN_privacy.gif\" alt=\"\"/> #pgv_lang[privacy]#</td><th><img src=\"images/checked.gif\"/></th><th><img src=\"images/checked.gif\"/></th><th><img src=\"images/checked_qm.gif\" /></th><th><img src=\"images/checked_qm.gif\"/></th><th><img src=\"images/forbidden.gif\"/></th><th><img src=\"images/forbidden.gif\"/></th></tr><tr><td><img src=\"images/RESN_confidential.gif\" alt=\"\"/> #pgv_lang[confidential]#</td><th><img src=\"images/checked.gif\"/></th><th><img src=\"images/checked.gif\"/></th><th><img src=\"images/forbidden.gif\"/></th><th><img src=\"images/forbidden.gif\"/></th><th><img src=\"images/forbidden.gif\"/></th><th><img src=\"images/forbidden.gif\"/></th></tr></table><ul><li>R : môže čítať</li><li>W : môže editovať</li><li><img src=\"images/checked_qm.gif\"/> : v závislosti na všeobecnom nastavení utajenia</li></ul>";


//-- Pages Help-messages
//-- Index-page
$pgv_lang["index_help"]				= "~ÚVODNÁ STRANA~<br /><br />Toto je úvodná strana. Uvádza vás do zvoleného súboru <a href=\"#def_gedcom\">GEDCOM</a>. Na túto stránku sa môžete kedykoľvek vrátiť kliknutím na Úvodnú stránku v hornom menu. Ak je na týchto stránkach k dispozícii viacej GEDCOMov, môžete si zvoliť GEDCOM z rolovacieho menu.<br /><b>Táto stránka s nápovedou obsahuje informácie o:</b><ul><li><a href=\"#index_portal\">Úvodnej stránke</a><li><a href=\"#header\">Oblasti záhlaví</a><li><a href=\"#menu\">Menu</a><li><a href=\"#header_general\">Všeobecné informácie</a><li><a href=\"#def\">Definície</a></ul><br />Verzia #VERSION# prináša nový vzhľad <a href=\"#def_pgv\">PhpGedView</a>. Menu, počiatočná strana a mnoho ďalších vlastností je vylepšené alebo prepracované.<br /><br />";

//-- Index-page Header
//$pgv_lang["header_help_items"]	is moved to help_text_vars.php
$pgv_lang["header_help"]			= "<div class=\"name_head\"><center><b>OBLASŤ ZÁHLAVIA</b></center></div><br />Záhlavie je horná časť stránky a objavuje sa na každej stránke.<br />Záhlavie obsahuje užitočné odkazy, ktoré môžete používať pre prechádzanie stránok.<br />Pretože tieto stránky môžu mať rôzný vzhľad v závislosti na zvolenom <a href=\"#def_theme\">Motíve</a>, záhlavia rôzných motívov tým môžu byť ovplyvnené a môžu sa líšiť.<br /><br /><b>Odkazy, ktoré tu môžete nájsť, sú:</b><ul><li><a href=\"#header_search\">Vyhľadávacie políčko</a><li><a href=\"#header_lang_select\">Výber jazyka</a><li><a href=\"#header_user_links\">Uživatelské odkazy</a><li><a href=\"#header_favorites\">Obľúbené</a><li><a href=\"#header_theme\">Zmena motívu</a></ul>";
$pgv_lang["header_search_help"]			= "~Oblasť záhlavia: Vyhľadávacie políčko~<br />Toto vyhľadávacie políčko je síce malé, ale zato možnosti vyhľadávania sú široké.<br />Pre vyhľadávanie môžete zadať takmer čokoľvek. Keď kliknete na tlačítko <b>></b> alebo <b>Hľadať</b>, budete presmerovaný na hlavnú stránku vyhľadávania, kde uvidíte zoznam nájdených položiek.<br />Podrobnejšiu nápovedu k vyhľadávaniu nájdete na hlavnej strane vyhľadávania.<br />";
$pgv_lang["header_lang_select_help"]		= "~Oblasť záhlavia: Výber jazyka~<br/>Jedna z najdôležitejších vlastností tohoto programu je automatické prepnutie do podporovaného jazyka.<br /><br />Niekdy sa môže stať, že sa program návštevníkovi prepne do iného jazyka, než by si želal (napr. kvôli nesprávnemu nastaveniu jazyka v prehliadači).<br />Návštevník si ale môže zmeniť jazyk pomocou <b>>Výberu jazyka<</b><br />Výber jazyka môže byť zobrazený dvoma odlišnými spôsobmi:<br />Buď uvidíte klasický rolovací zoznam alebo lištu s národnými vlajkami.<br /> Ak ste registrovaným uživateľom, môžete si nakonfigurovať preferovaný jazyk, bez ohľadu na nastavenie vašeho prehliadača. Administrátor môže obmedziť počet podporovaných jazykov.";
$pgv_lang["header_user_links_help"]		= "~Oblasť záhlavia: Uživateľské odkazy~<br />Uživateľské odkazy sú užitočné odkazy zobrazené v malom bloku vždy na rovnakom mieste na stránke (ak nebudete meniť motívy)<br />Ak nebudete ešte prihlásený, uvidíte iba odkaz <b>Prihlásiť sa</b>.<br />Keď už budete prihlásený, uvidíte: <b>Prihlásený(á) ako (vaše uživateľské meno)</b>. Ak kliknete na tento odkaz, dostanete sa do svojho účtu.<br />Odkaz <b>Odhlásiť sa</b> je jasný: urobí presne to.<br />Ak máte práva administrátora, uvidíte tiež <b>Admin</b>. Kliknutie na tento odkaz vás prenesie priamo na hlavnú stránku administrácie.<br />";
$pgv_lang["header_favorites_help"]		= "~Oblasť záhlavia: Moje obľúbené~<br />V tomto rolovacom zozname nájdete svoje obľúbené, ktoré ste si vybrali na svojej osobnej vstupnej stránke.<br />Kliknutím na jednu z týchto položiek sa dostanete priamo na stránku s údajmi o tejto osobe.<br />Ďalšia nápoveda o pridávaní Obľúbených je k dispozícii na vstupnej stránke.<br />";
$pgv_lang["header_theme_help"]			= "~Oblasť hlavičky: Zmeniť motív~<br />Ak je to povolené administrátorom, zobrazí sa rolovacie menu s výberom motívu vzhľadu pre tieto stránky. Ak si vyberiete jeden z motívov, zmení sa vzhľad stránok. Ak ste naviac prihlásený do systému, zmení sa tiež váš uživateľský motív.<br />";
$pgv_lang["menu_help"]				= "<div class=\"name_head\"><center><b>MENU</b></center></div><br />V záhlaví stránok máme rolovacie menu.<br />Pohybom myšou cez ikonu menu sa vyvolá podmenu, ak nejaké pre danú položku existuje.<br />Kliknutie na ikonu menu vás presmeruje na stránku, ktorá je prvou položkou v podmenu.<br /><br /><b>Môžete si vybrať z nasledujúcich hlavných položiek:<ul><li><a href=\"#menu_fam\">#pgv_lang[welcome_page]#</a><br /><li><a href=\"#menu_myged\">#pgv_lang[mygedview]#</a><br /><li><a href=\"#menu_charts\">#pgv_lang[charts]#</a><br /><li><a href=\"#menu_lists\">#pgv_lang[lists]#</a><br /><li><a href=\"#menu_annical\">#pgv_lang[anniversary_calendar]#</a><br /><li><a href=\"#menu_clip\">#pgv_lang[clippings_cart]#</a><br /><li><a href=\"#menu_search\">#pgv_lang[search]#</a><br /><li><a href=\"#menu_help\">#pgv_lang[page_help]#</a></ul><br />";
$pgv_lang["menu_famtree_help"]			= "~Menu úvodnej stránky~</b><br />V menu sú zaradené všetky dostupné GEDCOMy. Každý GEDCOM má svoju vlastnú Úvodnú stránku ako je táto.<br />Ak je na týchto stránkach práve jeden GEDCOM, žiadne podmenu pod ikonkou Úvodnej stránky nenájdete.<br />";
$pgv_lang["menu_myged_help"]			= "~Menu vstupnej brány MyGedView~<br />Ak ste prihlásený, toto menu môže obsahovať nasledujúce položky:<dl><dt> MyGedView</dt><dd>Vás zavedie na vašu vlastnú \"úvodnú stránku\".</dd><dt>Môj účet</dt><dd>Tu môžete upravovať svoj uživateľský účet.</dd><dt>Rýchla aktualizácia</dt><dd>Tu môžete upravovať osobné údaje ľubovolnej osoby.</dd><dt>Môj vývod</dt><dd>Ak ste zvolili pre tento GEDCOM východiskovú osobu, tento odkaz vás zavedie na stránku s jej vývodom.</dd><dt>Môj osobný záznam</dt><dd>Tento odkaz vás presmeruje na stránku o vašej osobe, kde sú zobrazené všetky genealogické údaje o vás a vašej rodine.</dd></dl>";
$pgv_lang["menu_charts_help"]			= "~Menu schém~<br />Pod touto položkou menu sú zaradené všetky dostupné schémy:<dl><dt><a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a></dt><dd>Tento odkaz vás zavedie na stránku s vývodom pre aktuálny GEDCOM. Vývod začína východiskovou osobou GEDCOMu. Ak ste však prihlásený, východiskovou osobou môžete byť vy alebo niekto iný podľa vášho výberu.</dd><dt><a href=\"?help=help_descendancy.php\">#pgv_lang[descend_chart]#</a></dt><dd>Rozrod je viacmenej <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a> v obrátenom slede.<br />Toto zrovnanie nije úplne najvhodnejšie, avšak, zatiaľ čo vývod zobrazuje všetkých predkov východiskovej osoby, rozrod vám ukáže všetkých potomkov tejto (východiskovej) osoby.</dd><dt><a href=\"?help=help_timeline.php\">#pgv_lang[timeline_chart]#</a></dt><dd>Časová osa</dt><dd>Tu si môžete prezrieť udalosti u danej osoby zachytené na časovej ose.<br />Je veľmi zaujímavé porovnávať udalosti dvoch či viacerých osôb na jednej ose.</dd><dt><a href=\"?help=help_relationship.php\">#pgv_lang[relationship_chart]#</a></dt><dd>Tu môžete nájsť príbuzenské vzťahy nejakej osoby s vami alebo inou osobou.</dd><dt><a href=\"?help=help_ancestry.php\">#pgv_lang[ancestry_chart]#</a></dt><dd>Veľmi podobné na <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, ale zahrňuje viacej informácií a strieda <a href=\"?help=chart_style_help\">#pgv_lang[chart_style]#</a> zobrazenie.</dd><dt><a href=\"?help=help_fanchart.php\">#pgv_lang[fan_chart]#</a></dt><dd>Veľmi podobné na <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, ale z väčším dôrazom na grafickú podobu.</dd></dl>";
$pgv_lang["menu_lists_help"]			= "~Menu zoznamov~<br />K dispozícii sú nasledujúce zoznamy:<dl><dt><a href=\"?help=help_indilist.php\">#pgv_lang[individual_list]#</a></dt><dt><a href=\"?help=help_famlist.php\">#pgv_lang[family_list]#</a></dt><dd>V týchto dvoch zoznamoch môžete prechádzať abecedný zoznam ľudí z tohoto GEDCOMu.<br />Prvý z nich zobrazí zoznam jednotlivcov a druhý zoznam rodín.</dd><dt><a href=\"?help=help_sourcelist.php\">#pgv_lang[source_list]#</a></dt><dd>Pod touto položkou sa skrývá zoznam všetkých prameňov použitých v GEDCOMe.</dd><dt><a href=\"?help=help_placelist.php\">#pgv_lang[place_list]#</a></dt><dd>Tu môžete vyhľadávať ľudí podľa miesta. Zobrazí sa vám dvojstĺpcový zoznam. Osoby sú zoradené vľavo, rodiny vpravo.</dd><dt><a href=\"?help=help_medialist.php\">#pgv_lang[media_list]#</a></dt><dd>Túto položku uvidíte jedine v prípade, že je zapnutá administrátorom.<br />Ak kliknete na ňu, zobrazia sa vám odkazy na všetky multimediálne súbory použité v tomto GEDCOMe.</dd></dl>";
$pgv_lang["menu_annical_help"]			= "~Menu kalendára výročí~<br />Kalendár výročí zobrazuje udalosti vzťahujúce sa ku zvolenému dátumu, mesiaci či roku.<dl><dt><a href=\"?help=day_month_help\">#pgv_lang[viewday]#</a></dt><dd>Kliknutím na túto položku menu sa dostanete do Kalendára výročí, ktorý vám ukáže udalosti pre aktuálny deň.</dd><dt><a href=\"?help=day_month_help\">#pgv_lang[viewmonth]#</a></dt><dd>Kliknutím na túto položku menu sa dostanete do Kalendára výročí, ktorý vám ukáže udalosti pre aktuálny mesiac.</dd><dt><a href=\"?help=day_month_help\">#pgv_lang[viewyear]#</a></dt><dd>Cez tento odkaz sa dostanete do Kalendára výročí tak, že vám ukáže udalosti pre daný rok.</dd></dl>";
$pgv_lang["menu_clip_help"]			= "~Menu Schránky výstrižkov~<br />Ak je táto voľba zapnutá administrátorom, uvidíte ju v lište menu.<br />Schránka výstrižkov vám umožňuje vybrať osoby, rodiny a pramene a uložiť si ich ako \"ústrižky rodokmeňa\" do Schránky výstrižkov, ktorú si potom môžete stiahnúť v podobe súboru GEDCOM 5.5.<br /><br />";
$pgv_lang["menu_search_help"]			= "~Menu Hľadanie~<br />Vyhľadávacia stránka, kam sa dostanete kliknutím na tento odkaz, je to mocnejší vyhľadávací nástroj než odkaz Hľadať, ktorý môžete nájsť v záhlaví.<br /><br />";
$pgv_lang["menu_help_help"]			= "~Menu nápovedy~<br />#pgv_lang[help_help_items]#";
$pgv_lang["index_portal_head_help"]		= "<div class=\"name_head\"><center><b>ÚVODNÁ STRANA</b></center></div><br />";
$pgv_lang["index_portal_help"]			= "Úvodná stránka sa skladá z niekoľko oddelených blokov a je možné ju upravovať. Takže pre každý GEDCOM (tzn. ak je dostupných viacej GEDCOMov), môžete vidieť inú úvodnú stranu.<br /><br /><b>V závislosti na tom, ako administrátor nastavil tento systém môžete na úvodnej strane vidieť niektoré z týchto blokov:</b><ul><li><a href=\"#index_welcome\">Úvodný</a><li><a href=\"#index_login\">Prihlasovací</a><li><a href=\"#index_events\">Nadchádzajúce udalosti</a><li><a href=\"#index_onthisday\">Tohoto dňa vo vašej histórii...</a><li><a href=\"#index_favorites\">Obľúbené GEDCOMu</a><li><a href=\"#index_stats\">Štatistika GEDCOMu</a><li><a href=\"#index_common_surnames\">Najčastejšie priezviská</a><li><a href=\"#index_media\">Náhodný obrázok</a><li><a href=\"#index_loggedin\">Prihlásený uživatelia</a><li><a href=\"#gedcom_news\">Novinky GEDCOMu</a><li><a href=\"#recent_changes\">Posledné zmeny</a></ul>";
$pgv_lang["index_welcome_help"]			= "~UVÍTACÍ BLOK~<br />Tento uvítací blok vám ukazuje:<br />Aktuálny súbor GEDCOM, dátum a čas a (ak je to povolené adminom) <b>Počítadlo prístupov</b>.<br />Toto počítadlo nájdete iba v uvítacom bloku a na stránke s osobnými údajmi.<br />Počítadlo zaznamenáva počet prístupov k týmto stránkam. To znamená: koľkokrát boli tieto stránky navštívené.<br />Počítadlo nekontroluje URL návštevníka, takže, keď niekto stránku po nejakom čase znovu navštíví (napr. dva krát za deň), bude započítaný ako ďalší návštevník.<br />";
$pgv_lang["mygedview_welcome_help"]		= "<dl>~UVÍTACÍ BLOK ~<dt>Tento uvítací blok zobrazuje:</dt><dd>- Aktuálny GEDCOM súbor</dd><dd>- Dátum a čas</dd><dd>- Odkazy na:</dd><dd> - - #pgv_lang[myuserdata]#</dd><dd>- - #pgv_lang[my_pedigree]# (prečítajte si komentár)</dd><dd>- - #pgv_lang[my_indi]# (prečítajte si komentár)</dd><dd>- - #pgv_lang[customize_page]#</dd></dl><b>Komentár</b><br />Odkazy na \"Môj vývod\" a \"Môj osobný záznam\" uvidíte jedine vtedy, ak je v súbore GEDCOM o váš záznam.<br />Takže je možné, že v jednom GEDCOM súbore ste zapísaný a uvidíte odkazy \"Môj vývod\" a \"Môj osobný záznam\", zatiaľ čo v inom GEDCOMe záznam o vás nie je a odkazy \"Môj vývod\" a \"Môj osobný záznam\" potom nebudú zobrazené.<br />";
$pgv_lang["index_login_help"]			= "~PRIHLÁSIŤ SA~<br />I keď je možné sa prihlásiť takmer na každej stránke tohoto programu, je najlepšie prihlásiť sa hneď na prvej stránke, pretože máte tak prístup k ďalším informáciám.<br />Prihlásite sa vložením <b>uživatelského mena</b> a <b>hesla</b> a kliknutím na tlačítko \"Prihlásiť sa\".<br /><br />#pgv_lang[new_password_help]#<br />";
$pgv_lang["index_events_help"]			= "~BLOK NADCHÁDZAJÚCICH UDALOSTÍ~<br />V tomto bloku uvidíte udalosti od dneška do konca mesiaca.<br />Sú to všetky udalosti uložené v GEDCOMe.<br />";
$pgv_lang["days_to_show_help"]			= "~#pgv_lang[days_to_show]#~<br /><br />Vložte počet dní ktoré sa majú zobraziť. Toto číslo nesmie byť vačšie než <b>#DAYS_TO_SHOW_LIMIT#</b>. Ak zadáte vačšiu hodnotu, bude použitý limit.<br /><br />Zobrazený limit je nastavený administrátorom v konfigurácii GEDCOMu.";
$pgv_lang["index_onthisday_help"]		= "~BLOK \"TENTO DEŇ VO VAŠEJ HISTÓRII\"~<br />Tento blok má podobné vlastnosti ako blok Nadchádzajúcich udalostí, tu sa vám však zobrazia iba udalosti viažúce sa ku dnešku.<br />";
$pgv_lang["index_favorites_help"]		= "~BLOK OBĽÚBENÝCH GEDCOMU~</center>Blok Obľúbených GEDCOMu je viacmenej podobný bloku \"Moje obľúbené\" na vstupnej bráne MyGedView. Ale v tomto prípade môže pridávať, mazať a meniť obľúbené iba administrátor stránok alebo uživateľ s právami administrátora.<br />Účelom Obľúbených GEDCOMu je upozorniť na osobu či osoby zvlášť dôležité.<br />V záhlaví každej strany vašich stránok je k dispozícii rolovací zoznam \"Obľúbené tohoto GEDCOMu\".<br />Tak budete presmerovaný na stránku s údajmi o danej osobe.<br /><br />Rámček obsahujúci meno obľúbenej osoby je kvôli úspornosti zobrazený s minimom informácií o tejto osobe. V pravej časti rámčeka je ikonka lupy, pomocou ktorej môžete získať ďalšie informácie.<br />Ak kliknete na meno, presuniete sa na stránku s údajmi o danej osobe.<br />Na pravej strane tiež nájdete menu, ktoré vás môže zaviesť na stránky s ďalšími informáciami alebo schémami.<br />";
$pgv_lang["index_add_favorites_help"]		= "~PRIDAŤ OBĽÚBENÉ~<br />Tento formulár vám umožňuje pridať do vašeho zoznamu obľúbených novú položku. Musíte zadať ID osoby, rodiny, alebo zdroja ktorý chcete uložiť ako obľúbené, alebo musíte zadať URL a názov. Pole Poznámka je nepovinné a môže byť použité na popis. Čokoľvek uložené v poli Poznámka bude zobrazené v bloku Obľúbené za položkou.<br /><br />";
$pgv_lang["index_stats_help"]			= "~BLOK ZO ŠTATISTIKOU GEDCOMU~<br />V tomto bloku vidíte štatistické údaje o aktuálnom súbore GEDCOM.<br />Ak chcete viacej informácií, môžete poslať správu na kontaktnú adresu na zápätí stránky.<br />";
$pgv_lang["index_common_names_help"]		= "~BLOK S NAJČASTEJŠÍMI PRIEZVISKAMI~<br />V tomto bloku sú zobrazené priezviská, ktoré sa v tomto GEDCOMe vyskytujú najčastejšie.<br />Minimálnu četnosť výskytu jedného priezviska potrebnú k tomu, aby priezvisko bolo zaradené medzi najčastejšie môže nastaviť administrátor.<br />(Súčasné nastavenie tohoto limitu je #COMMON_NAMES_THRESHOLD#)<br />Na mená môžete kliknúť. Jedným kliknutím na meno sa dostanete na #pgv_lang[individual_list]#, kde získate ďalšie informácie o tomto mene.<br />";
$pgv_lang["index_media_help"]			= "~BLOK S NÁHODNÝM OBRÁZKOM~<br />Program vyberie náhodne mediálny súbor, ktorý vám ukáže v tomto bloku pri návšteve tejto stránky.<br />Ak kliknete na tento obrázok alebo jeho názov, uvidíte ho v pôvodnej veľkosti.<br />Pod obrázkom je odkaz na osobu, ku ktorej je obrázok pripojený.<br />Kliknutím na toto meno budete presmerovaný na stránku s údajmi o tejto osobe.<br />";
$pgv_lang["index_loggedin_help"]		= "~BLOK PRIHLÁSENÝCH UŽIVATEĽOV~<br />V tomto bloku zistíte, koľko uživateľov je práve teraz prihlásených.<br />";
$pgv_lang["index_gedcom_news_help"]		= "~BLOK NOVINIEK GEDCOMU~<br />Blok Noviniek GEDCOMu je niečo ako billboard tohoto GEDCOMu.<br />Administrátor sem môže umiestniť dôležité oznámenia alebo zaujímavé novinky.<br /><br />Ak máte niečo zaujímavého k zobrazeniu, kontaktujte prosím administrátora a on vašu správu bude môcť pridať do noviniek.";
$pgv_lang["recent_changes_help"]		= "~BLOK POSLEDNÝCH ZMIEN~<br />V tomto bloku sa objavia posledné zmeny, ktoré boli v GEDCOMe urobené, ako je v súbore GEDCOM zaznamenané pomocou tagov CHAN.<br />";
$pgv_lang["gedcom_news_limit_help"]		= "Môžete obmedziť počet zobrazený Noviniek pre zredukovanie veľkosti bloku Novinky GEDCOMu. Táto voľba určuje či bude uplatnený nejaký limit a či bude závislý na veku článkov, alebo ich počte.";
$pgv_lang["gedcom_news_flag_help"]		= "Vložte hodnotu limitu.<br /><br />Ak ste sa rohodli obmedziť zobrazenie Noviniek vekom, všetky články staršie (v dňoch) než je zadaná hodnota budú skryté. Ak ste sa rohodli obmedziť zobrazenie Noviniek počtom článkov, bude zobrazený zadaný počet článkov zotriedených podľa veku. Ostatné články budú skryté.<br /><br />Ak zadáte hodnotu nula (0) vypnete limit a budú zobrazené všetky články.<br /><br />";
$pgv_lang["gedcom_news_archive_help"]		= "Pre zredukovanie veľkosti bloku Novinky, administrator potlačil zobrazenie niektorých článkov. Môžete zobraziť tieto skyté články klinutím na link <b>#pgv_lang[gedcom_news_archive]#</b><br />";
$pgv_lang["index_htmlplus_help"]		= "~ZDOKONALENÝ HTML BLOK~<br />Tento blok dovoluje administrátorom pridať informácie na Index alebo Portal stránky. Účel je rovnaký ako u blokov HTML, Novinky a GEDCOM Štatistiky, ale administrátor má viac možností nastaviť jeho vzhľad.<br /><br />";
$pgv_lang["index_htmlplus_title_help"]	  	= "Tento text by mal byť prázdny, alebo veľmi stručný. Ak je prázdny tak zdokonalený HTML blok bude zobrazený na Index alebo Portal stránke ako prostý blok, presne tak ako je HTML blok urobený. Ak je tu nejaký text tak zdokonalený HTML blok bude zobrazený ako všetky ďaľšie bloky, kompletný i s titulkom obsahujúcim text, ktorý je tu vložený.";
$pgv_lang["index_htmlplus_template_help"]	= "Pre pomoc pri práci s týmto blokom sme vytvorili niekoľko štandardných šablon. Ak si zvolíte niektorú šablonu, textová oblasť bude obsahovať predlohu, ktorú môžete zmeniť a prispôsobiť tak požiadavkám vašich stránok.";
$pgv_lang["index_htmlplus_content_help"]	= "Na rozdiel od blokov HTML, Noviniek a GEDCOM Štatistika, máte neobmedzené možnosti upraviť vzhľad vašeho bloku. Môžete použiť HTML tagy, blok používá CSS štýly stránky pre práve aktívnu tému. Odkazy na informácie z práve aktívnej genealogickej databázi môžu byť vložené do textu.<br /><br />Databázové odkazy sú označené kľúčovým slovom uzatvoreným medzi dva symboly <b>&#35;</b>. Napríklad <b>&#35;TOTAL_FAM&#35;</b> predstavuje počet rodín v databáze. Občas môžete chcieť použiť databázový odkaz ak text miesto jeho skutočného významu. Aby ste to mohli urobiť, musíte nahradiť symboly <b>&#35;</b> uzatvárajúce kľúčové slovo ich ekvivalentom. Napríklad, ak vas text obsahuje  <b>&&#35;35;TOTAL_FAM&amp&#35;35;</b> tak bude zobrazený ako <b>&#35;TOTAL_FAM&#35;</b> miesto navratu databázového odkazu.<br /><br />Zoznam kľúčových slov nasleduje:<br /><table><tr valign=top><td><ul><li>COMMON_SURNAMES </li><li>TOTAL_INDI </li><li>TOTAL_FAM </li><li>TOTAL_SOUR </li><li>TOTAL_OTHER </li><li>TOTAL_SURNAMES </li><li>TOTAL_MALES </li><li>TOTAL_FEMALES </li><li>TOTAL_UNKNOWN_SEX </li><li>TOTAL_EVENTS </li><li>TOTAL_EVENTS_BIRTH </li><li>TOTAL_EVENTS_DEATH </li><li>TOTAL_EVENTS_MARRIAGE </li><li>TOTAL_EVENTS_OTHER </li><li>TOTAL_USERS </li><li>FIRST_EVENT </li><li>FIRST_EVENT_TYPE </li><li>FIRST_EVENT_NAME </li><li>FIRST_EVENT_YEAR </li><li>LAST_EVENT </li><li>LAST_EVENT_TYPE </li><li>LAST_EVENT_NAME </li><li>LAST_EVENT_YEAR </li><li>FIRST_BIRTH </li><li>FIRST_BIRTH_NAME </li><li>FIRST_BIRTH_YEAR </li></ul></td><td><ul><li>LAST_BIRTH </li><li>LAST_BIRTH_NAME </li><li>LAST_BIRTH_YEAR </li><li>LONG_LIFE </li><li>LONG_LIFE_NAME </li><li>LONG_LIFE_AGE </li><li>TOP10_OLDEST </li><li>AVG_LIFE </li><li>MOST_CHILD </li><li>MOST_CHILD_NAME </li><li>MOST_CHILD_TOTAL </li><li>TOP10_BIGFAM </li><li>AVG_CHILD </li><li>HIGHLIGHT </li><li>GEDCOM </li><li>GEDCOM_ID </li><li>GEDCOM_TITLE </li><li>CREATED_SOFTWARE </li><li>CREATED_VERSION </li><li>CREATED_DATE </li><li>GEDCOM_UPDATED </li><li>GEDCOM_CONTACT </li><li>WEBMASTER_CONTACT </li></ul></td></tr></table><br />|";
$pgv_lang["help_help"]				= "Samozrejme, že by bolo skvelé vyrobiť program, ktorého ovládanie by bolo tak jednoduché, že by nepotreboval vôbec žiadne vysvetlivky.<br />Malo by to byť rovnako ľahké ako čítanie knihy.<br />I keď je program pomerne zložitý, v uživateľskom rozhraní to nepoznáte. Takmer všetko sa dá použiť bez nápovedy.<br />Ale, pretože máme hodne návštevníkov a uživateľov, ktorý nemajú moc skúseností z prácou na počítači alebo na internete, ponúkame často na určitých miestach nápovedu.<br />V menu nápovedy nájdete nasledujúce položky:<br />";
$pgv_lang["help_page_help"]			= "<dl><dt><b>Nápoveda k tejto stránke</b></dt><dd>Pre všetky stránky je dostupná všeobecná nápoveda.<br />Keď ste na nejakej stránke, môžete kliknúť na túto položku v menu a otvorí sa vám okno s nápovedou informujúce o položkách, ktoré nájdete na danej stránke.<br />Nápoveda ku stránke je väčšinou stručná.<br />Ak chcete ďalšiu nápovedu alebo informáciu o určitej položke na stránke, potom je tu tretia voľba menu: \"Kontextová nápoveda\".</dd></dl>";
$pgv_lang["help_content_help"]			= "<dl><dt><b>Obsah nápovedy</b></dt><dd>Ak kliknete na túto položku menu, vyskočí vám pop-up okno s nápovedou, kde uvidíte index hlavných položiek nápovedy.<br />V indexe bude v dohľadnej dobe viacej položiek, pretože budú zahrnuté i ostatné položky.</dd></dl>";
$pgv_lang["help_faq_help"]			= "<dl><dt><b>FAQ zoznam</b></dt><dd>#pgv_lang[text_faq_help]#</dd></dl>";
$pgv_lang["help_HS_help"]			= "<dl><dt><b>#pgv_lang[hs_title]#</b></dt><dd>#pgv_lang[hs_intro]#</dd></dl>";
$pgv_lang["help_qm_help"]			= "<dl><dt><b>Skryť / Ukázať Kontextovú nápovedu</b></dt><dd>Táto posledná položka menu môže byť pre vás najužitočnejšia. Kliknutie na túto voľbu buď zapne nebo vypne kontextovú nápovedu.<br />Čo je to \"Kontextová nápoveda\"?<br />Ak je zapnutá, nájdete u niektorých odkazov, tlačítok a políčok otáznik. Kliknutie na tento <b>?</b> vyvolá malé okienko s nápovedou k danému objektu.<br />Samozrejme, že keď kliknete na \"Skryť kontextovú nápovedu\", všetky otázniky budú skryté do tej doby, než kliknete znovu na \"Zobraziť...\". </dd></dl>";
$pgv_lang["def_help"]				= "<div class=\"name_head\"><center><b>DEFINÍCIE</b></center></div><br />Definície niektorých výrazov používaných v tejto nápovede:<ul><li><a href=\"#def_gedcom\">GEDCOM</a><br /><li><a href=\"#def_gedcom_date\">Dáta</a><li><a href=\"#def_pgv\">PhpGedView</a><li><a href=\"#def_portal\">Vstupná brána (portál)</a><li><a href=\"#def_theme\">Motív</a></ul>";
$pgv_lang["def_portal_help"]			= "~Vstupná brána~<br />Vstupná brána týchto stránok je niečo ako vestibul reštaurácie. Je to miesto, kde môžete nájsť dôležité informácie ako vysvetlivky, menu atd..<br />";
$pgv_lang["def_gedcom_help"]			= "~Súbor GEDCOM~<br />Súbor GEDCOM je súbor obsahujúci všetky informácie o rode.<br />Všetky údaje, dátumy, udalosti atd. sú ukladané v súbore GEDCOM.<br />Pre súbor GEDCOM platia prísne pravidlá, pretože musí umožňovať predávanie dát medzi všetkými genealogickými programami nezávisle na platforme či systéme.<br />";
$pgv_lang["def_gedcom_date_help"]		= "~Dáta v súbore GEDCOM~<br />Pretože formáty v súboroch GEDCOM musia zodpovedať medzinárodným pravidlám, je tam i uvedenie zápisu datumu.<br /><br />I keď políčko pre dátum v GEDCOM súbore môže obsahovať dokonca iba text, tu je vysvetlenie správneho zapisovania dátumov:<br />Celý dátum sa vkladá ako DD MMM YYYY - tj.:<br />01 Mar 1801 alebo 14 Dec 1950<br />Ak vám časť dátumu chýba, môžete ju v zápise vynechať, ako napr.:<br />Mar 1801 nebo 14 Dec<br />Ak si nie ste istý alebo dátum nie je potvrdený, mohli by ste napísať:<br />abt Mar 1801 (abt = okolo)<br />bef 20 Dec 1950 (bef = pred) <br />aft 1949 (aft = po)<br />Uistite sa, že ste zadali tieto dáta a skratky v angličtine, pretože program potom všetko preloží sám do zvoleného jazyka.<br />Naviac program sám musí z dátumami počítať. Ak budú dátumy zadané v zlom formáte, program nebude schopný s nimi správne pracovať.<br />";
$pgv_lang["def_pgv_help"]			= "~PhpGedView~<br />PhpGedView (alebo PGV) je program zobrazujúci súbory GEDCOM online, vytvorený Johnom Finlayom.<br />Ako si môžete všimnúť, tento program nevytvára obyčajné statické webové stránky, ale je dynamický a je možné ho v mnoha smeroch upravovať.<br />John ho začal vyvíjať sám, ale v súčasnosti na ňom pracuje medzinárodný tým vývojárov a prekladateľov.<br />Okrem prezerania súborov GEDCOM, môže dnes uživateľ pridávať a upravovať údaje a udalosti online.<br />";
$pgv_lang["def_theme_help"]			= "~Motív~<br />Stránky môžu mať rôzne \"podoby\", ktorým sa hovorí motívy.<br />Administrátor stránok vyberá počiatočný motív.<br />Každý, kto na tieto stránky vstúpi, uvidí rovnaký vzhľad (motív). Ak to administrátor umožní v nastavení programu, môžu si prihlásený uživatelia vybrať svoj vlastný motív.<br />Ak si uživateľ vybral iný motív, program si toto nastavenie uloží a uživateľ ho uvidí ho ihneď po prihlásení.<br />";
$pgv_lang["mygedview_portal_help"]		= "~#pgv_lang[upper_mygedview]#~<br />Toto je vaša osobná stránka #pgv_lang[mgv]#.<br />Na tejto stránke sú odkazy na vaše osobné údaje, napr. <b>Môj osobný záznam</b> (to je stránka s GEDCOM údajmi o vašej osobe), <b>Môj účet</b>,<b>Môj vývod</b>.<br />Ďalej tu môžete mať blok zo <b>Správami</b>, <b>Denník</b> (ako poznámkový blok) a mnoho ďalšieho.<br /><br />Rozvrhnutie tejto stránky je rovnaké ako úvodnej (uvítacej) stránky.<br />Zatial čo úvodná strana je spravovaná iba administrátorom, túto stránku si môžete upraviť podľa seba (vybrať z ponúkaných blokov pre zobrazenie).<br /><br />V úvodnom bloku tejto strany nájdete odkaz pre úpravu tejto stránky.<br /><b>Môžete si vybrať z nasledujúcich blokov:<br /><br /></b><ul><li><a href=\"#mygedview_welcome\">Úvodný</a><li><a href=\"#mygedview_customize\">Upraviť MyGedView</a><li><a href=\"#mygedview_message\">Správy</a><li><a href=\"#mygedview_events\">Nadchádzajúce udalosti</a><li><a href=\"#mygedview_onthisday\">Tohoto dňa vo vašej histórii...</a><li><a href=\"#mygedview_favorites\">Moje obľúbené</a><li><a href=\"#mygedview_stats\">Štatistika GEDCOMu</a><li><a href=\"#mygedview_myjournal\">Môj denník</a><li><a href=\"#mygedview_media\">Náhodný obrázok</a><li><a href=\"#mygedview_loggedin\">Prihlásený uživatelia</a><li><a href=\"#mygedview_recent_changes\">Posledné zmeny</a></ul>";
$pgv_lang["mygedview_customize_help"]		= "~ÚPRAVA #pgv_lang[upper_mygedview]#~<br />Keď ste sem vstúpili prvý krát, už ste na tejto stránke mali nejaké bloky.<br />Ak chcete, môžete si svoju vstupnú bránu prizpôsobiť.<br />Kliknutie na tento odkaz vás prenesie do formulára v pop-up okne, kde budete môcť bloky pridať, zmazať alebo presunúť.<br />Ďalšia nápoveda je k dispozícii na formulári.<br />";
$pgv_lang["mygedview_message_help"]		= "~BLOK SPRÁV~</center>V tomto bloku nájdete správy, ktoré vám poslali ostatný uživatelia alebo administrátor.<br />Samozrejme môžete i vy sami poslať správy ostatným uživateľom alebo adminovi.<br />E-mailový systém PhpGedView je vytvorený tak, aby chránil vaše súkromie. Nemusíte sem zadávať svoju e-mailovú adresu a ostatný uživatelia ju tak neuvidia.<br /><br />Ak chcete e-mail zväčšiť, kliknite na značku \"+\" vedľa e-mailu. Keď zaškrtnete políčka vedľa správ, ktoré chcete zmazať, a potom kliknete na tlačítko \"Zmazať označené správy, odstránite všetky označené správy naraz.<br />";
$pgv_lang["mygedview_favorites_help"]		= "~BLOK MOJICH OBĽÚBENÝCH~<br />Moje obľúbené fungujú podobne ako záložky v knihe.<br />Predpokladajme, že máte v rodokmeni niekoho, ktorého záznam si chcete prezerať pravidelne.<br />Otvorte stránku tejto osoby a kliknite na odkaz \"Pridať do Mojich obľúbených\". U tejto osoby je teraz záložka a je pridaná do vášho zoznamu Obľúbených.<br />Ak ste kdekoľvek na stránkach, môžete kliknúť na meno z rolovacieho zoznamu v záhlaví \"Moje obľúbené\".<br />To vás presmeruje na osobnú stránku tejto osoby.<br /><br />Kvoli ušetreniu miesta sú rámčeky zobrazené z minimom informácií. Napravo v rámčeku uvidíte lupu, pomocou ktorej môžete získať ďalšie informácie.<br />Kliknutie na meno vás presmeruje na osobnú stránku tejto osoby.<br />Na pravej strane uvidíte menu, ktoré vás navedie na stránky s ďalšími informáciami alebo schémami.<br />";
$pgv_lang["mygedview_myjournal_help"]		= "~BLOK \"MOJ DENNÍK\"~<br />Do tohoto denníku môžete zapisovať poznámky (alebo pripomienky) pre vlastnú potrebu.<br />Samozrejme, že poznámka, ktorú vložíte, tu bude i pri vašej ďalšej návšteve.<br /><br />Tieto poznámky sú pre ostatných neviditeľné.<br />";
$pgv_lang["help_pedigree.php"]			= "~STRÁNKA S VÝVODOM~<br /><br />Väčšina uživateľov a návštevníkov bude vedieť, čo je to vývod, ale predsa niečo málo o našom vývode:<br />Vývod je v skutočnosti výčet všetkých predkov východiskovej osoby.<br />Keď ste vstúpili na túto stránku, videli ste vývod osoby, ktorá bola v rámčeku úplne vľavo (keď sa prihlásite, môžete si zvoliť vlastnú východiskovú osobu).<br /><br />Takže, \"všetci predkovia\" znamená otec a matka a ich rodičia a tak ďalej.<br />Na týchto stránkach vidíte vývod v grafickej podobe.<br />Nemusíte sa predierať stranami textu, aby ste zistili, kto sú vaši predkovia.<br />Všetky osoby sú na obrazovke zobrazené v rámčekoch.<br /><br />* RÁMČEKY VO VÝVODE<br />Ak je na stránke s vývodom nastavené zobrazovanie podrobností, uvidíte meno osoby, dátum narodenia a úmrtia.<br />Na meno osoby môžete kliknúť a to vás zavedie priamo na stránku s osobnými údajmi.<br />Keď je zapnutá voľba \"Zobraziť podrobnosti\", sú v rámčeku dve ikonky.<br /><br />* IKONA VÝVODU<br />Keď je zapnutá voľba \"Zobraziť podrobnosti\", vidíte vovnútri rámčeka ikonku vývodu. V závislosti na nastavení stránok musíte prejsť cez ikonu myšou, alebo na ňu kliknúť.<br />Takže, keď na ňu kliknete, alebo cez ňu prejdete myšou, objaví sa vám malé podmenu.<br />Položka \"Vývod\" a \"Rozrod\" sa podobajú položkám v hlavnom menu, ale rozdiel je v tom, že v tomto prípade bude východiskovou osobou schémy osoba, ktorej meno je v danom rámčeku.<br />Ďalej vidíte \"Rodina s partnerom\". Vidíte meno partnera nasledované menami detí.<br />Na všetky mená sa dá kliknúť.<br /><br />* LUPA<br />Opäť v závislosti na nastavení stránok musíte na ikonu buď kliknúť, alebo cez ňu prejsť myšou.<br />Lupa zväčší rámček s menom, takže sa zobrazia niektoré ďalšie podrobnosti.<br />Uvidíte viacej údajov a udalostí. Na mená môžete kliknúť.<br /><br />* ŠÍPKY<br />Naľavo alebo napravo od úplne krajných rámčekov môžete vidieť šípky.<br />Kliknutím na jednu zo šípok posuniete schému v danom smere.<br /><br />Ďalšia nápoveda je k dispozícii po kliknutí na <b>?</b> za rámčekmi alebo odkazmi na stránke.";

//-- Pages Help-messages
//-- Index-page
$pgv_lang["show_full_help"]			= "~SKRYTIE ALEBO ZOBRAZENIE PODROBNOSTÍ~<br /><br />Touto voľbou môžete podrobnosti v políčkach osôb buď zobraziť alebo skryť.<br /> Ak necháte podrobnosti skryť, budete môcť na obrazovke zobraziť väčtšiu schému (rodokmeň).<br /><br />Ak zvolíte skryť podrobnosti, môžete si zobraziť skryté informácie použitím lupy, ak je v normálnom režime (pohľade) zapnutá.<br />To záleží na tom, ako administrátor nakonfiguroval tento program.<br />Ak musíte pre zväčšenie rámčeku na lupu kliknúť, potom doplňujúce informácie získate tiež kliknutím na rámček s menom.<br />Ak pre priblíženie stačí nájsť na ikonku lupy, potom to bude fungovať úplne rovnako, ak postavíte kurzor na \"jednoduchý\" rámček.";
$pgv_lang["talloffset_help"]			= "~FORMÁT ZOBRAZENIA~<br /><br />Týmto nastavením určujete formát zobrazenia.<br /> Zmena tohoto nastavenia sa môže hodiť, ak chcete tlačiť alebo ak máte iný typ obrazovky. Ak zvolíte možnosť \"na výšku\", rodokmeň bude užší, takže 4-generačná schéma v režime \"na výšku\" by sa mala vojsť na jednu stranu. Voľba \"na šírku\" zapríčiní zobrazenie širšej schémy, ktorá by sa mala vojsť na jednu stránku na šírku.";
$pgv_lang["rootid_help"]			= "~NOVÁ VÝCHODISKOVÁ OSOBA~<br /><br />Ak chcete zobraziť rodokmeň s inou východiskovou osobou, potom do tohoto políčka môžete napísať ID tejto osoby.<br /> Ak nepoznáte jej ID, použijte odkaz <b>>Nájsť ID<</b>.<br /><br /><b>ČÍSLO ID</b><br />Číslo ID je jednoznačný identifikátor. Bolo vygenerované programom, v ktorom bol vytvorený tento súbor GEDCOM.";
$pgv_lang["PEDIGREE_GENERATIONS_help"]		= "~POČET GENERÁCIÍ~<br /><br />Tu môžete nastaviť počet generácií, ktorý sa má zobraziť v rodokmeni na jednej stránke.<br />Voľba čísla záleží na veľkosti vašej obrazovky a potom, či si nechávate zobrazovať podrobnosti alebo nie.";

//-- LOGIN-page
$pgv_lang["login_page_help"]			= "~VSTUPNÁ STRÁNKA~<br /><br />Na tejto stránke sa môžete prihlásiť do systému, požiadať o nové heslo alebo nový uživateľský účet.<br />";
$pgv_lang["username_help"]			= "~UŽIVATELSKÉ MENO~<br /><br />Do tohoto políčka napíšte svoje uživatelské meno.<br />Rozlišujú sa veľké a malé písmená!";
$pgv_lang["password_help"]			= "~HESLO~<br /><br />Do tohoto políčka napíšte svoje heslo.<br />Rozlišujú sa veľké a malé písmená!";
$pgv_lang["login_buttons_help"]			= "~VSTUPNÉ TLAČÍTKA~<br /><br />Tu vidíte dve tlačítka, pomocou ktorých sa môžete prihlásiť do systému.<br />Zvolte možnosť podľa toho, ako chcete po prihlásení ďalej pokračovať.<br /><br />* Tlačítko <b> #pgv_lang[login]# </b><br />Ak kliknete na toto tlačítko, budete po prihlásení presmerovaný na stránku, z ktorej ste sem prišli.<br />Takže, keď kliknete na \" #pgv_lang[login]# \" a budete práve na stránke s rozrodom, budete po prihlásení presmerovaný zpäť na rozrod.<br /><br />* Tlačítko <b> #pgv_lang[mygedview]# </b><br />Ak máte práva administrátora, môžete kliknúť na toto tlačítko a dostanete sa na hlavnú stránku administrácie.";
$pgv_lang["login_buttons_aut_help"]		= "~AUTORIZAČNÝ REŽIM~<br /><br />VSTUPNÉ TLAČÍTKA <br /><br />Tu vidíte dve tlačítka pre prihlásenie do systému.<br />Na výbere tlačítka záleží, ako budete pokračovať.<br /><br />* Tlačítko <b> #pgv_lang[login]# </b><br />Ak kliknete na toto tlačítko, dostanete sa do systému, a to priamo na svoju osobnú stránku, kde si môžete zmeniť nastavenie, pridať alebo upraviť obľúbené, posielať a čítať správy a tak ďalej.<br /><br />* Tlačítko <b> #pgv_lang[mygedview]# </b><br />Keď kliknete na toto ľavé tlačítko, dostanete sa do systému, a to priamo na svoju osobnú stránku, kde si môžete upraviť svoje nastavenie, pridať alebo upraviť obľúbené, posielať a čítať správy a tak ďalej.<br /><br />* Tlačítko <b> #pgv_lang[admin]# </b><br />Ak máte práva administrátora, môžete kliknúť na toto tlačítko, dostanete sa priamo na hlavnú stránku administrácie.";
$pgv_lang["new_password_help"]			= "~ŽIADOSŤ O NOVÉ HESLO~<br />Ak ste zabudli svoje heslo, môžete kliknúť na tento odkaz pre zažiadanie o nové heslo.<br />Budete presmerovaný na \"Stránku s žiadosťou o zaslanie hesla\".";
$pgv_lang["new_user_help"]			= "~ŽIADOSŤ O NOVÝ UŽIVATEĽSKÝ ÚČET~<br /><br />Ak ste len návštevníkom týchto stránok a radi by ste tu mali účet, kliknite na tento odkaz.<br />Budete presmerovaný na \"Stránku registrácie\".";
$pgv_lang["mygedview_login_help"]		= "Aby ste mali prístup ku vstupnej bráne MyGedView, musíte byť registrovaným uživateľom tohoto systému.<br /><br />Pomocou vstupnej brány MyGedView môžete vytvárať záložky u svojich obľúbených osôb, viesť uživateľský denník, spravovať správy, mať prehľad o iných prihlásených uživateľoch a lepšie poznávať PhpGedView.<br /><br />Pre prihlásenie do MyGedView zadajte do políčok svoje uživateľské meno a heslo.";
$pgv_lang["new_user_firstname_help"]		= "~#pgv_lang[firstname]#~<br /><br />Do tohoto poľa zadajte svoje meno.<br /><br />Potrebujeme vaše meno a priezvisko pre stanovenie či pre vás môžeme vytvoriť účet na tejto stránke a aké budú vaše oprávnenia. Tieto mená budú zobrazované ostatným prihláseným členom rodiny a uživateľom.<br /><br />";
$pgv_lang["new_user_lastname_help"]		= "~#pgv_lang[lastname]#~<br /><br />Do tohoto poľa vložte svoje priezvisko.<br /><br />Potrebujeme vaše meno a priezvisko pre stanovenie či pre vás môžeme vytvoriť účet na tejto stránke a aké budú vaše oprávnenia. Tieto mená budú zobrazované ostatným prihláseným členom rodiny a uživateľom.<br /><br />";

//-- Descendancy-page
$pgv_lang["help_descendancy.php"]		= "~STRÁNKA S ROZRODOM~<br /><br />Táto stránka zobrazí potomkov osoby.<br />Východiskovú osobu tejto schémy si môžete zvoliť priamo na tejto stránke, alebo sem môžete byť presmerovaný z inej stránky kliknutím na odkaz \"Rozrod\".<br />Ak sa chcete posunúť v schéme nahoru, kliknite na hornú šípku. Ak budete chcieť vidieť rozrod inej osoby, kliknite na ikonu schémy v rámčeku požadovanej osoby.";
$pgv_lang["desc_rootid_help"]			= "~NOVÁ OSOBA~<br /><br />Ak chcete zobraziť rozrod inej osoby, potom do tohoto políčka môžete zadať ID tejto osoby.<br /> Ak nepoznáte jej ID, použijte odkaz Nájsť ID.";
$pgv_lang["desc_generations_help"]		= "~POČET GENERÁCIÍ~<br /><br />Tu môžete nastaviť počet generácií k zobrazeniu na jednej stránke.<br />Čo je najlepšie? To záleží na veľkosti vašej obrazovky a potom, či máte zapnuté zobrazovanie podrobností alebo nie.";
//-- show_full is used from pedigree

//-- Time line-page
$pgv_lang["help_timeline.php"]			= "~STRÁNKA S ČASOVOU OSOU~<br /><br />Na tejto stránke si môžete nechať zobraziť jednu, dve či viacej osôb na časovej ose.<br />Týmto spôsobom si môžete napríklad znázorniť stav dvoch či viacerých osôb v určitý okamžik.<br /><br />Ak kliknete na odkaz Časová osa na inej stránke, uvidíte jednu osobu na časovej ose už hneď po načítaní stránky.<br />Ak ste klikli na položku z menu v záhlaví, potom musíte napísať do rámčeka \"ID\" osoby, s ktorou chcete začať.";
$pgv_lang["add_person_help"]			= "~PRIDANIE OSOBY NA ČASOVÚ OSU~<br /><br />Na časovej ose môžete mať viacej osôb.<br />Do tohoto políčka vložte ID osoby.<br />Ak nepoznáte ID tejto osoby, môžete kliknúť na odkaz \"Nájsť ID\" za rámčekom.";
$pgv_lang["remove_person_help"]			= "~ODSTRÁNENIE OSOBY Z OSY~<br /><br />Kliknite na tento odkaz, ak chcete odstrániť osobu z časovej osy.";
$pgv_lang["show_age_marker_help"]		= "~ZOBRAZENIE VEKU~<br /><br />Ak zaškrtnete toto políčko, uvidíte ukazateľ veku, ktorý môžete posúvať po ose.<br />Tento ukazateľ veku je dobrý nástroj ku zisteniu veku danej osoby v danom čase.<br />Ukazateľ veku môžete zapnúť alebo vypnúť pre ktorúkoľvek osobu na ose.<br /><br />";
$pgv_lang["timeline_control_help"] = "~LIFESPAN CONTROLS~<br/><br/>~SPEED~<br/>Click the drop down menu to change the speed at which the timeline scrolls.<br/><br/>~Begin Year~<br/>Enter the starting year of the range.<br/><br/>~End Year~<br/>Enter the ending year of the range.<br/><br/>~Search~<br/>Click the Search button to begin searching for events that occurred within the range identified by the Begin Year and End Year fields.<br/><br/>|";
 
//-- Relationship-page
$pgv_lang["help_relationship.php"]		= "~STRÁNKA ZO SCHÉMOU VZŤAHU~<br /><br />Na tejto stránke si môžete znázorniť príbuzenský vzťah medzi dvoma osobami.<br />Neznamená to, že by tieto osoby museli byť priamo pokrvne príbuzné.<br />Nájdený bude akýkoľvek vzťah.";
$pgv_lang["relationship_id_help"]		= "~ID čísla 1. a 2. osoby~<br /><br />Ak ste sa sem dostali cez odkaz z inej stránky (napríklad: kliknutím na odkaz \"Vzťah ku mne\"), potom tu uvidíte príbuzenský vzťah medzi sebou a touto osobou.<br />Inak musíte zadať ID tých dvoch osôb, ktorých vzájomný príbuzenský vzťah chcete zobraziť.<br />Ak tieto ID nepoznáte, môžete kliknúť na odkaz \"Nájsť ID\".<br /><br />";
$pgv_lang["next_path_help"]			= "~ĎALŠIE VZŤAHY~<br /><br />Na toto tlačítko môžete kliknúť pre nájdenie ďalšieho vzťahu medzi týmito dvoma osobami, ak taký existuje.<br />Predchádzajúci nájdený vzťah si môžete opätovne zobraziť kliknutím na odkaz s číslom vzťahu.";
$pgv_lang["follow_spouse_help"]			= "~KONTROLA PRÍBUZENSTVA SŇATKOM – ZAŠKRTÁVACIE POLÍČKO~<br /><br />Ak je toto políčko <b>ne</b>zaškrtnuté, budú sa hľadať iba pokrvné príbuzenské vzťahy.<br>Ak je zaškrtnuté, budú sa hľadať i príbuznosti sňatkom. Ak necháte políčko zaškrtnuté, máte väčšiu pravdepodobnosť, že nájdete viacej vzťahov.";
$pgv_lang["line_up_generations_help"]		= "~VYROVNAŤ PODĽA GENERAČNEJ ÚROVNE - ZAŠKRTÁVACIE POLÍČKO~<br /><br />Ak je toto políčko zaškrtnuté, schéma sa vytlačí tak, že potomkovia postavený na rovnakej generačnej úrovni, budú na stránke vodorovne zarovnaný. Ak nie je políčko zaškrtnuté, každá generácia sa zobrazí na stránke smerom dolu bez ohľadu na to, či je vo vzťahu rodičov alebo detí.";
$pgv_lang["oldest_top_help"]          		= "~ZOBRAZIŤ NAJSTARŠÍCH HORE - ZAŠKRTÁVACIE POLÍČKO~<br /><br />Ak je toto políčko zaškrtnuté, budú sa schémy tlačiť s najstaršími osobami hore.<br />A nie je zaškrtnuté, objavia sa hore najmladší ľudia.<br /><br />Poznámka: Táto voľba funguje iba, ak je zaškrtnuté <i>#pgv_lang[line_up_generations]#</i>.";
$pgv_lang["help_ancestry.php"]			= "~Stránka #pgv_lang[ancestry_chart]#~<br /><br />Prehľad predkov je veľmi podobný na <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, ale obsahuje viacej informácií a alternuje <a href=\"?help=chart_style_help\">#pgv_lang[chart_style]#</a> zobrazenie.<br /><br />Každý predok je zobrazený s jedinečným číslom, vypočítaným na základe <i>Sosa-Stradonitzovho</i> systému :<br /> - párne čísla pre mužov (dieťa*2)<br /> - nepárne čísla pre ženy (manžel+1) s výnimkou <big>1</big><br /><br />Príklad:<br /><ul>Východisková osoba je <b>1</b>, bez ohľadu na pohlavie<br /><b>1</b> jej otec je <b>2</b> (<b>1</b> * 2), jej matka je <b>3</b> (<b>2</b> + 1).<br /><b>2</b> jej otec je <b>4</b> (<b>2</b> * 2), jej matka je <b>5</b> (<b>4</b> + 1).<br /><b>3</b> jej otec je <b>6</b> (<b>3</b> * 2), jej matka je <b>7</b> (<b>6</b> + 1).<br /><b>7</b> jej otec je <b>14</b> (<b>7</b> * 2), jej matka je <b>15</b> (<b>14</b> +1).<br />atd.</ul><br />";
$pgv_lang["box_width_help"]			= "~Šírka rámčeka pre #pgv_lang[ancestry_chart]#~</b><br /><br />Tu môžete nastaviť šírku rámčeka od 50% do 300%.<br />Normálna hodnota je 100% : každé políčko je široké asi 270 pixelov.";
$pgv_lang["chart_style_help"]			= "~Štýl #pgv_lang[ancestry_chart]#~<br /><br /><dl><dt>#pgv_lang[ancestry_list]#</dt><dd>Zvislý strom s rolovatelnými rodinami.</dd><dt>#pgv_lang[ancestry_booklet]#</dt><dd>Na jednej stránke je zobrazená jedna rodina - rodičia, prarodičia a všetky zaznamenané deti.<br />Dá sa jednoducho vytlačiť a vy ho môžete dať svojim príbuzným.</dd></dl>";
$pgv_lang["help_fanchart.php"]			= "~#pgv_lang[fan_chart]# page~<br /><br />Vejárová schéma je veľmi podobná na <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, ale s dôrazom na grafickú podobu.<br /><br />Východisková osoba je zobrazená v strede, jej rodičia na prvej kružnici, prarodičia na druhej atd...<br /><br />Ak je známy rok narodenia, sňatku a úmrtia, potom je zobrazený pod menom.<br /><br />Ak kliknete na meno v schéme, získate nový obraz, na ktorom bude zvolené meno v strede schémy. Pri východiskovej osobe je šípka zo skrytým menu, z ktorého budete môcť vybrať ako novú východiskovú osobu niektoré z detí alebo súrodencov východiskovej osoby, čo môžete urobiť tiež pomocou <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>.";
$pgv_lang["fan_width_help"]			= "~Šírka #pgv_lang[fan_chart]#~</b><br /><br />Tu môžete nastaviť šírku vejárovej schémy od 50% do 300%.<br />Normálna hodnota je 100% : výsledný obrázok má na šírku asi 640 pixelov.";
$pgv_lang["fan_style_help"]			= "~Štýl - #pgv_lang[fan_chart]#~<br /><br /><dl><dt>1/2</dt><dd>Oblúkový (180°) vejár</dd><dt>3/4</dt><dd>Troj-štvrtočný (270°) vejár alebo 'Anjelské krídlo'</dd><dt>4/4</dt><dd>Úplný (360°) vejár</dd></dl>";
//-- show_full is used from pedigree

//-- Indilist-page
$pgv_lang["help_indilist.php"]			= "~STRÁNKA SO ZOZNAMOM OSOB~<br /><br />Na tejto stránke si môžete nechať zobraziť zoznam osôb.<br /><br />Mená budú zobrazené v abecednom poradí, priezvisko na prvom mieste.<br />Výstup zoznamu mien závisí na:<br /><b>1.</b> písmene, na ktoré ste klikli v abecednom indexe.<br /><b>2.</b> na tom, či ste klikli na \"Preskočiť\" alebo \"Zobraziť\" zoznam priezvísk.<br /><br />Ak k tomu potrebujete ďalšiu nápovedu, kliknite prosím na <b>?</b> za položkami.";
$pgv_lang["alpha_help"]				= "~ABECEDNÝ INDEX~<br /><br />Po kliknutí na znak v abecednom indexe sa vám zobrazí zoznam mien začínajúcich na písmeno, na ktoré ste klikli.<br />Na konci indexu môže byť <b>#pgv_lang[NN]#</b>. Táto voľba je zobrazená v prípade, že v GEDCOMe sú ľudia, u ktorých nebolo zadané priezvisko alebo nezačína na žiadne písmeno abecedy aktuálneho jazyka.<br />Rovnako tak neznámu osobu.<br /><br /><b>Pozor</b><br />Ak je priezvisko osoby v GEDCOM zázname zadané napríklad takto: Nn, NN, Neznámy(a), alebo dokonca N.N., potom sa meno tejto osoby po kliknutí na <b>N.N.</b> <b>ne</b>zobrazí. Tieto osoby nájdete pod \"<b>N</b>\" alebo \"<b>U</b>\" (pre príklad v tomto riadku).<br />Je tomu tak preto, že program kontroluje iba, či je v GEDCOM zázname zapísané priezvisko.<br /><br />Na konci abecedného indexu vidíte \"<b>VŠETKY</b>\". Ak kliknete na tento odkaz, zobrazí sa vám zoznam všetkých priezvísk v GEDCOMe.<br /><br /><b>Chýbajú niektoré znaky?</b><br />Môže sa stať, že niektoré znaky budú v indexe \"chýbať\".<br />V skutočnosti však nechýbajú. Znamená to proste, že priezviská začínajúce týmto znakom sa v zozname nevyskytujú.";
$pgv_lang["name_list_help"]			= "~ZOZNAM MIEN~<br /><br />Toto políčko zobrazí buď zoznam priezvisk alebo zoznam celých mien.<br />V oboch prípadoch budú všetky priezviská začínať znakom, na ktorý ste klikli v abecednom indexe. Ak však nekliknete na \"VŠETKY\"<br /><br />Či uvidíte zoznam priezvísk, alebo celých mien záleží na stave odkazu pod tabulkou.";
$pgv_lang["skip_sublist_help"]			= "~PRESKOČENIE ZOZNAMU PRIEZVÍSK~<br /><br />Štandardné nastavenie je také, že po kliknutí na písmeno dostanete najskôr zoznam priezvísk.<br />Ak  kliknete na tento odkaz, preskočíte zoznam priezvísk a uvidíte hneď zoznam celých mien.";

//-- Families-page
$pgv_lang["help_famlist.php"]			= "~STRÁNKA SO ZOZNAMOM RODÍN~<br /><br />Na tejto stránke si môžete zobraziť zoznam rodín.<br /><br />Mená budú zobrazené v abecednom poradí, priezviská na prvom mieste.<br />Podoba zobrazeného zoznamu závisí na:<br /><b>1.</b> písmene, na ktoré ste klikli v abecednom indexe.<br /><b>2.</b> na tom, či ste klikli na \"Preskočiť\" alebo \"Zobraziť\" zoznam priezvísk.<br /><br />Môžete hľadať ako mužské, tak ženské priezviská. Oboje sú zahrnuté v zoznamu.<br /><br />Ak potrebujete k tomu ďalšiu nápovedu, kliknite prosím na ? za položkami.";
$pgv_lang["help_family.php"]			= "~STRÁNKA S PODROBNOSŤAMI O RODINE~<br /><br />Táto stránka vám ukáže prehľad o rodine, ktorú ste si vybrali na predchádzajúcej strane.<br />Odhora dolu uvidíte rámčeky s týmito menami:<br />Manžel a jeho rodičia.<br />Manželka a jej rodičia<br />a deti.<br /><br />Vzhľad a obsah rámčekov je rovnaký ako na stránke s vývodom a rozrodom.<br />Napravo od rámčekov s manami rodičov uvidíte šípku (ak sú v súbore ďalší predkovia). Kliknutím na šípku sa posuniete o jednu generáciu na novú stránku, kde sú rodičia zobrazený ako manželia.<br />Po pravej strane <i>v</i> rámčeku si môžete všimnúť lupy, vďaka ktorej môžete získať ďalšie informácie o danom jednotlivcovi. Kliknutie na meno vás presmeruje na stránku s osobnými údajmi o tomto človekovi.<br />Na pravej strane nájdete ešte malé menu, ktoré vás odkáže na stránky s ďalšími informáciami alebo schémami.<br /><br />V Rodinných informáciach sú zobrazené všetky známe údaje a informácie o tejto rodine ako sňatok, multimediálne súbory a poznámky. Kliknutie na miesto vás presmeruje na zoznam miest, kde uvidíte zoznam všetkých jednotlivcov a rodín, ktoré sú s týmto miestom spojené. Ak kliknete na dátum, dostanete sa do kalendára, kde si budete môcť prezrieť všetky udalosti, ktoré sa vo vašej histórii stali tohoto dňa v tomto mesiaci. Kliknúť môžete tiež na multimediálne objekty; tým sa otvorí nové okno, v ktorom si budete môcť objekt prezrieť. Ak kliknete na odkaz na prameň, zobrazí sa na stránke informácia o tomto prameni.<br /><br />Pod rámčekmi s manami detí nájdete odkaz \"Pridať dieťa k tejto rodine\".<br />Vedľa rámčekov s menami detí uvidíte odkaz \"Informácie o rodine\".<br />Ak máte príslušné oprávnenia, môžete tu upravovať, mazať a pridávať dátumy a údaje.<br /><br />Na pravej strane obrazovky môžete vidieť, ak je zapnuté administrátorom, tieto ikony a odkazy:<br /><b>Zobraziť priamo záznam GEDCOMu</b>, ktorý zobrazí informácie v GEDCOM formáte.br /><b>Pridať do Schránky výstrižkov</b>, ktorý vám umožní uložiť si zvolené informácie do schránky. Odtiaľto si ich potom môžete stiahnuť a naimportovať do svojho genealogického programu.<br /><b>Zobraziť pár na časovej ose</b>, ktorý vás presmeruje na stránku s časovou osou, na ktorej zobrazí všetky údaje o rodine.<br /><br />#pgv_lang[more_help]#";
$pgv_lang["add_child_help"]			= "~PRIDANIE DIEŤAŤA DO RODINY~<br /><br />Kliknutím na tento odkaz môžete pridať k tejto rodine dieťa.<br />Pridanie dieťaťa je jednoduché: Proste len kliknite na odkaz, vyplňte políčka v pop-up okne a je to.<br />";
$pgv_lang["show_fam_gedcom_help"]		= "~ZOBRAZIŤ ZÁZNAM GEDCOMu~<br /><br />Po kliknutí na tento odkaz sa informácie o rodine (tak, ako je uložená v GEDCOMe) zobrazí v pop-up okne.";
$pgv_lang["add_fam_clip_help"]			= "~PRIDAŤ RODINU DO SCHRÁNKY VÝSTRIŽKOV~<br /><br />Ak kliknete na tento odkaz, budete môcť pridať informácie o tejto rodine (tak, ako je uložená v GEDCOMe) do svojej Schránky výstrižkov. Na ďalšej stránke si budete mocť vybrať, ktoré údaje konkrétne si budete želať pridať: len týchto rodičov, alebo tiež ich rodičov, alebo tiež ich rodičov alebo tiež ich deti alebo všetkých potomkov.";
$pgv_lang["show_fam_timeline_help"]		= "~ZOBRAZIŤ PÁR NA ČASOVEJ OSE~<br /><br />Po kliknutí na tento odkaz sa dostanete na stránku s časovou osou, kde budú údaje o tejto rodine zobrazené v časovom merítku.";
$pgv_lang["help_sourcelist.php"]		= "~STRÁNKA SO ZOZNAMOM PRAMEŇOV~<br /><br />Na tejto stránke je zobrazený zoznam prameňov.<br />Narozdiel od stránky s osobami a stránky s rodinami, tu chýba abecedný index. Je to z toho dôvodu, že prameň môže byť osoba, ktorá má samozrejme krstné meno a priezvisko, alebo to môže byť verejná databáza alebo inštitúcia atd. <br />To znamená, že je obtiažne vymyslieť spôsob radenia. Názvy prameňov sú zoradené v abecednom poradí tak, ako sú uložené v súbore GEDCOM.<br /><br /><b>PRAMENE</b><br />Bez prameňov by sme nemohli vybudovať svoju rodopisnú databázu. Každá informácia uložená v databázi pochádza z nejakého zdroja. Môže jím byť príbuzný danej osoby, inštitúcia, verejná databáza apod.<br />Jeden prameň môže byť spojený s viacerými osobami. Na druhú stranu, jedna osoba môže byť zase spojená s viacerými prameňami. Pre každú udalosť môžete mať iný prameň, nech už je to dátum narodenia, profesia, sňatok, deti atd. atd.";

//-- same variable as individuals page

//-- Sourcelist-page
$pgv_lang["sourcelist_listbox_help"]		= "~ZOZNAM PRAMEŇOV~<br /><br />V tejto tabulke môžete vidieť zoznam prameňov, tak ako sú uložené v GEDCOMe.<br />Názvy sú zobrazené v abecednom poradí.<br /><br />Keď kliknete na názov v zozname, dostanete sa na stránku tohoto prameňa, kde bude zobrazený zoznam osôb, ktoré sú pripojené k tomuto prameňu.";
$pgv_lang["help_source.php"]			= "~STRÁNKA S PODROBNOSŤAMI O PRAMENI~<br /><br />Na tejto stránke sú zobrazené podrobnosti o tomto prameni.<br />Môžete tu nájsť informácie o názve, autorovi, vydanie prameňa a mieste, kde bol vyhľadaný. Pretože existuje mnoho typov prameňov, u niektorých z nich môže byť k dispozícii viacej, u iných menej údajov.<br /><br />Ak je k prameňu pripojený multimediálny objekt (ako naskenovaný dokument), môžete si tento objekt prezrieť vo veľkom okne kliknutím buď na objekt alebo na názov súboru uvedený vedľa neho.<br /><br />Po podrobnostiach o tomto prameni nasleduje zoznam všetkých jednotlivcov a rodín, ktorý sú k tomuto prameňu napojený. Tak máte možnosť získať všetky informácie, ktoré boli z daného prameňa získané.<br /><br />Ak je to povolené adminom, budete mať na stránke menu s jednou alebo dvoma ikonami:<br /><b>Zobraziť priamo záznam GEDCOMu</b> ukáže údaj v GEDCOM formáte.<br /><b>Pridať do Schránky výstrižkov</b>, ktorá umožňuje ukladať vybrané informácie do schránky. Odtiaľto ich môžete stiahnúť a naimportovať do svojho genealogického programu.<br /><br />Ďalšia nápoveda je k dispozícii po kliknutí na <b>?</b>";

//-- Sources-page
$pgv_lang["sources_listbox_help"]		= "~ZÁZNAMY PRIPOJENÉ K TOMUTO PRAMEŇU~<br /><br />V tejto tabulke si môžete prezrieť zoznam mien osôb či rodín pripojených k tomuto prameňu.<br />Mená sú zobrazené v abecednom poradí.<br /><br />Keď kliknete na meno v zozname, dostanete sa na stránku s podrobnými informáciami o osobe či rodine.";
$pgv_lang["show_source_gedcom_help"]		= "~ZOBRAZENIE GEDCOM ZÁZNAMOV~<br /><br />Kliknutím na tento odkaz vyvoláte pop-up okno, v ktorom sa vám zobrazí podrobnosti o prameni tak, ako sú uložené v GEDCOM súbore.";
$pgv_lang["add_source_clip_help"]		= "~PRIDANIE PRAMEŇA DO SCHRÁNKY VÝSTRIŽKOV~<br /><br />Kliknutím na tento odkaz môžete pridať prameň, tak ako je uložený v GEDCOM súbore, do schránky výstrižkov.";
$pgv_lang["delete_source_help"]			= "~VYMAZANIE PRAMEŇA Z GEDCOMu~<br /><br />Kliknutím na túto voľbu, označíte prameň, ktorý sa má z GEDCOMu vymazať.<br />Čo to znamená?<br />Predpokladajme, že máte dobrý dôvod odstrániť tento prameň zo svojho GEDCOMu. Môžete kliknúť na odkaz a vyskočí vám pop-up okno s otázkou, či chcete prameň skutočne vymazať alebo či chcete príkaz zrušiť.<br /><br />Ak budete pokračovať v odstraňovaniu prameňa, za nejakú chvíľu vám vyskočí pop-up okno so správou, že prameň bol vymazaný.<br /><br />Ak budete pokračovať v prezeraní, všimnite si, že prameň je ešte stále v databáze, rovnako ako pred vymazaním.<br /><br />To <b>nie je</b> chyba.<br />Administrátor stránok dostane správu, že v GEDCOMe bola urobená zmena a že ste odstránili prameň.<br />Administrátor musí vašu zmenu prijať (alebo zamietnuť). Nie je možné tento proces obrátiť.<br />V prípade nejasností vás administrátor bude kontaktovať.";
$pgv_lang["help_placelist.php"]			= "~HIERARCHIE MIEST~<br />(alebo tiež osoby v miestach)<br /><br />Tu sa môžete podívať, ktoré osoby alebo rodiny sú spojené s akým miestom.<br /><br />Ak je medzi osobou alebo rodinou a nejakou udalosťou v určitom mieste nejaké spojenie, program vám ho nájde.<br /><br />Výsledok je zobrazený v dvojstĺpcovom zozname:<br />Jeden stĺpec je pre osoby a druhý pre rodiny.<br /><br />#pgv_lang[more_help]#";

//-- Persons per Place-page
$pgv_lang["ppp_default_form_help"]		= "~PORADIE MIEST~<br /><br /><b>IMPLICITNÉ PORADIE</b><br />To znamená, že v tomto GEDCOM súbore nie je stanovené žiadne poradie.<br />V takom prípade je nastavené implicitné poradie podľa predvoľby na tejto stránke.<br /><br />Keby bolo v tomto GEDCOM súbore nájdené iné poradie, bolo by se ukázalo medzi (...) a koncom riadku.";
$pgv_lang["ppp_match_one_help"]			= "~PORADIE MIEST~<br /><br />PORADIE PODĽA GEDCOMu<br />Miesta sú v poradí, ktoré bolo nájdené v súbore GEDCOM.<br />To má vyššiu prioritu než implicitné poradie, ktoré sa naopak použije v prípade, že v GEDCOMe žiadne poradie nie je nájdené";
$pgv_lang["ppp_numfound_help"]			= "~NÁJDENÉ VZŤAHY K MIESTAM~<br /><br />Tu je zobrazený počet nájdených odpovedí.<br />Ak ešte stále vidíte tabuľku so zoznamom miest, znamená to, že ste doteraz nedosiahli najnižšiu úroveň.<br />Môžete zvoliť zobrazenie všetkých záznamov nájdených u tohoto miesta alebo zmeniť kritéria vyhľadávania kliknutím na iné miesto.";
$pgv_lang["ppp_levels_help"]			= "~HIERARCHIA MIEST~<br /><br />Tu sú zobrazené úrovne nájdené do tohoto okamžiku.<br />Tabuľka ukazujúca zoznam miest je v skutočnosti podzoznamom úrovne úplne vľavo.<br /><br />PRÍKLAD:<br />(Implicitné) poradie je: #pgv_lang[default_form]#<br />Ak sme teraz na \"hornej úrovni\", potom sa v tabuľke zobrazí všetky zeme z GEDCOMu.<br />Ak  stávajúca úroveň ukazuje: \"U.S.A., Horná úroveň\", potom budú v zozname zobrazené všetky štáty v U.S.A.<br />atd.<br /><br />Môžete kliknúť na úroveň, aby ste sa dostali späť o jeden či viacej krokov.";
$pgv_lang["ppp_placelist_help"]			= "~ZOZNAM MIEST~<br /><br />V tomto zozname vidíte miesta nájdená pod zvoleným miestom. Ak ste doteraz nezvolili žiadne miesto, potom vidíte zoznam všetkých miest na najvyššej úrovni (napr. zemí alebo štátov).<br /><br />Názvy miest v zozname sú odkazy, na ktoré môžete kliknúť.<br />Kliknutie na miesto funguje ako filter. Prenesie vás na nasledujúcu nižšiu úroveň.";
$pgv_lang["ppp_placelist_help2"]		= "~ZOZNAM MIEST~<br /><br />V tomto zozname môžete vidieť miesta, ktoré boli doteraz nájdené.<br />Na názvy miest zo zoznamu môžete klikať.<br />Kliknutie na miesto funguje ako filter. Prenesie vás na nasledujúcu nižšiu úroveň.<br />Zoznam mien sa nezobrazí jedine v prípade, že ste na najvyššej úrovni. Na každej inej úrovni dostanete zoznam osôb alebo rodín nájdených v danom mieste.";
$pgv_lang["ppp_view_records_help"]		= "~ZOBRAZIŤ VŠETKY ZÁZNAMY~<br /><br />Ak kliknete na tento odkaz, zobrazí sa vám zoznam všetkých osôb a rodín, ktoré sú spojené s týmto miestom. Keď sa dostanete na koniec hierarchie miest (napr. mesto), zobrazí sa automaticky zoznam mien.";
$pgv_lang["ppp_name_list_help"]			= "~ZOZNAM MIEN~<br /><br />Táto tabuľka bude obsahovať zoznam celých mien osôb alebo rodín, ktoré majú niečo spoločné s týmto miestom.<br /><br />Na miesta v zozname môžete kliknúť.<br />Keď na niektorý názov kliknete, dostanete sa na stránku s podrobnosťami o tej osobe alebo rodine.<br /><br />Môžete si tiež vybrať zmenu svojho označenia – a to kliknutím na miesto hore na tomto zozname.";
$pgv_lang["help_medialist.php"]			= "~ZOZNAM MULTIMÉDIÍ~<br /><br />Zoznam multimediálnych súborov zahrnuje všetky multimediálne objekty (MMO), ktoré sa nachádzajú v tomto GEDCOMe.<br /><br />V políčkach MMO nájdete jeho názov a meno osoby alebo rodiny, ku ktorej je tento objekt pripojený. Na oboje môžete kliknúť.<br /><br />Ak kliknete na meno osoby alebo rodiny, dostanete sa na stránku s osobnými údajmi alebo stránku o rodine.<br /><br />Kliknutie na názov MMO má rovnaký efekt ako kliknutie na zmenšeninu (náhľad) MMO.<br />V závislosti na formáte MMO (*.gif, *.jpg) sa MMO otvorí v internom PhpGedView-prehliadači alebo v prehliadači, ktorý je pripojený k vášmu internetovému prehliadači.<br /><br />Ak kliknete na odkaz \"Zobraziť\" vedľa osôb alebo rodín, dostanete sa na stránku s údajmi o osobe alebo rodine.<br /><br />";
$pgv_lang["help_uploadmedia.php"]		= "~NAHRÁVANIE MEDIÁLNYCH SÚBOROV~<br /><br />Nahrávanie súborov je jednoduché, takže iba doplňujúce informácie.<br /><br /><b>Zmenšeniny</b><br />Zmenšeniny by mali mať veľkosť približne okolo 100px na šírku.<br />Názov súboru musí byť rovnaký ako u originálu (obr. v pôvodnej veľkosti).<br /><br /><b>Nahrávanie</b><br />Originály obrázkov budú uložené automaticky do zložky ../media a zmenšeniny do ../media/thumbs/.<br /><br />#pgv_lang[readme_help]#";

//-- Mulitmedia-page
//-- I did not work multimedia yet, so at this moment I cannot ad something here ;-) (Jans)

//-- Anniversaries-page
$pgv_lang["help_calendar.php"]			= "~KALENDÁR VÝROČÍ~<br /><br /><ul><li><a href=\"#calendar_general\">Základné informácie</a><li><a href=\"#calendar_day\">#pgv_lang[day]#</a><li><a href=\"#calendar_month\">#pgv_lang[month]#</a><li><a href=\"#calendar_year\">#pgv_lang[year]#</a><li><a href=\"#calendar_show\">#pgv_lang[show]# / #pgv_lang[showcal]#</a><li><a href=\"#calendar_sex\">#pgv_lang[sex]#</a><li><a href=\"#calendar_event\">Udalosť</a><li><a href=\"#calendar_button\">Výber režimu (tlačítka)</a><li><a href=\"#calendar_tip\">Tip</a></ul><br /><a name=\"calendar_general\"></a>Kalendár výročí zobrazuje osoby a rodiny napojené k udalostiam z určitého dňa alebo mesiaca alebo určitého časového úseku. Používá dômyselný filtrovací systém k tomu, aby vám ukázal správny dátum alebo období.<dl><dt><b>Zobraziť <a href=\"#calendar_day\">deň</a></b></dt><dd>Táto voľba ukazuje udalosti, ku ktorým došlo v určitý deň nezávisle na zvolenom roku. Výstupom bude buď jednoduchý zoznam mien osôb alebo rodín, alebo dvojstĺpcový zoznam osôb na jednej a rodín na druhej strane.</dd><dt><b>Zobraziť <a href=\"#calendar_month\">mesiac</a></b></dt><dd>V <b>Kalendári</b> sú mená osôb i rodín zobrazená v políčkach dní. Kalendár sa zobrazí tak, ako vyzeral v roku, ktorý ste zadali do políčka roku. Zobrazené sú všetky udalosti z minulosti až po zadaný rok.<br />V kombinácii s voľbou \"<a href=\"#calendar_show\">#pgv_lang[recent_events]#</a>\" vám poskytne realistický pohľad na to, ako vyzeral kalendár vašich predkov.</dd><dt><b>Zobraziť <a href=\"#calendar_year\">rok</a></b></dt><dd>Táto voľba zobrazí udalosti, ktoré sa stali v určitom roku alebo v rozmedzí určitých rokov. Výstupom bude buď jednoduchý zoznam mien osôb alebo rodín, alebo dvojstĺpcový zoznam osôb na jednej a rodín na druhej strane.</dd></dl>Práve zobrazovaný deň a mesiac sú v menu kalendára zvýraznené.<br /><br />Na mená a dátumy, ktoré sa objavia v zozname alebo v kalendári, môžete kliknúť.<br />Kliknutím na meno sa prenesiete na stránku s údajmi o danej osobe či rodine. Ak kliknete na dátum, dostanete sa do režimu \"Dnes\" (alebo Rok), a tak získate zobrazenie všetkých udalostí tohoto (zvoleného) dňa a mesiaca.<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_day\"> </a>#pgv_lang[annivers_date_select_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_month\"> </a>#pgv_lang[annivers_month_select_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_year\"> </a>#pgv_lang[annivers_year_select_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_show\"> </a>#pgv_lang[annivers_show_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_sex\"> </a>#pgv_lang[annivers_sex_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_event\"> </a>#pgv_lang[annivers_event_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_button\"> </a>#pgv_lang[day_month_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_tip\"> </a>#pgv_lang[annivers_tip_help]#";
$pgv_lang["annivers_date_select_help"]		= "~VÝBER DŇA~<br />Výber dátumu zahrňuje dve políčka (deň a mesiac) a vstupné políčko, do ktorého vložíte požadovaný rok.<br /><br />Keď vstúpite na túto stránku, uvidíte dnešný dátum. Keď kliknete na tlačítko <b>Zobraziť deň</b>, uvidíte všetky osoby spojené s nejakou udalosťou, ktorá sa odohrala toho dňa.<br />Keď kliknete na tlačítko <b>Zobraziť mesiac</b>, uvidíte všetky osoby spojené s nejakou udalosťou, ktorá sa odohrala v danom mesiaci.<br />Ktoré osoby uvidíte, záleží na tom, ktorú položku ste zvolili vo výbere <b>Ukázať</b>.<br /><br /><b>TIP</b><br />Predpokladajme, že máme príbuzného narodeného 25. januára 1875.<br />Upravte výber dátumov podľa tohoto dátumu.<br />Keď teraz kliknete na jedno z tlačítiek pre zobrazenie, uvidíte zoznam alebo kalendár pre tento deň.<br />Všetky veky, výročia apod. sú prepočítavané podľa dátumu, ktorý ste nastavili.<br />Takže vlastne vidíte úplne rovnaký kalendár aký by mal pred sebou váš predok vo vzdialenej minulosti.";
$pgv_lang["annivers_month_select_help"]		= "~VÝBER MESIACA~<br /><br />Prostredný riadok \"Prepínacej tabuľky\" je <b>Výber mesiaca</b>.<br />Význam tohoto prvku je rovnako ako u \"Výberu dňa\" jasný: Vyberiete mesiac.<br /><br />A rovnako ako pri Výbere dňa je rozdiel medzi kliknutím na mesiac v \"Režime deň\" a v \"Režime mesiac\".<br /><br /><b>Režim deň</b>:<br />V tomto režime, keď kliknete na mesiac, sa obrazovka znovu načíta a zobrazí sa zoznam dní v danom mesiaci.<br />Všetky ostatné nastavenia ako deň, rok a udalosti budú zachované.<br /><br /><b>Režim mesiac</b>:<br />Ak máte na obrazovke kalendár a kliknete na mesiac v riadku \"Mesiac\", zobrazí sa kalendár tohoto nového mesiaca.<br /><br />Na konci riadku Mesiac uvidíte <b>\"rýchly odkaz\"</b> na aktuálny mesiac.<br />Ak kliknete na tento \"rýchly odkaz\", zobrazí sa vám kalendár na tento mesiac bez ohľadu na to, či ste v režime Mesiac, alebo v režime Deň.<br />";
$pgv_lang["annivers_year_select_help"]		= "~POLÍČKO PRE ROK~<br /><br />Toto políčko slúži pre prepínanie roku v kalendári v \"režime mesiacov\" alebo v zozname v \"režime rokov\".<br />V \"režime deň\" sa zmena roku nijak neprejaví, pretože sú zobrazené udalosti za celý rok.<dl><dt><b>Rozšírené možnosti</b> pre <b>#pgv_lang[viewyear]#:<br />Viacej rokov naraz</b></dt><dd>Môžete hľadať viacej než jeden rok zapísaním do políčka roku::<br />- Pr. 1: <b>1992-5</b> pre všetky udalosti od 1992 do 1995.<br />- Pr. 2: <b>1972-89</b> pre všetky udalosti od 1972 do 1989.<br />- Pr. 3: <b>1610-759</b> pre všetky udalosti od 1610 do 1759.<br />- Pr. 4: <b>1880-1905</b> pre všetky udalosti od 1880 do 1905.<br />- Pr. 5: <b>880-1105</b> pre všetky udalosti od 880 do 1105.<br /><br />Tiež môžete vynechať poslednú číslicu roku pre zobrazenie všetkých udalostí za určité desaťročie.<br />- Pr.: <b>197</b> pre všetky udalosti od 1970 do 1979.</dd><dt><br /><b>Skratky</b></dt><dd>Niekedy nie je úplne jasné, kedy presne sa daná udalosť stala. V týchto prípadoch môžu byť k dátumu pridané slová ako \"po\", \"pred\" a \"okolo\". Dátumy sú v GEDCOMe uložené spoločne so skratkou daného termínu. V režime roku môžete zadávať i hľadanie týchto termínov s, alebo bez, pridruženého dátumu. Tu je niekoľko príkladov takých výberov:<br /><b>abt</b> 1800 (abt = about = OKOLO)<br /><b>bet</b> 1950-1959 (bet = between = MEDZI) zadajte: bet 1950 alebo iba: 1950-59<br /><b>bef</b> 1950 (bef = before = PRED)<br /><b>aft</b> 1900 (aft = after = PO)<br /><br /><b>Poznámka:</b> PhpGedView bude hľadať výraz presne tak, ako ho zadáte. Ak hľadáte \"abt 1850\", dátum z GEDCOMu ako napr. \"abt oct 1850\" <b>nebude</b> zahrnutý vo výsledoch vyhľadávania. - Môžete zadať iba skratku bez roku a získate zoznam všetkých dátumov, ktoré túto skratku obsahujú.</dd></dl>Samotným napísaním roku nespustíte vyhľadávanie.<br />Pretože toto políčko nie je odkazom, budete po zapísaní roku musieť kliknúť na tlačítko <b>#pgv_lang[viewmonth]#</b> alebo tlačítko <b>#pgv_lang[viewyear]#</b>.<br />";
$pgv_lang["annivers_show_help"]			= "~voľba ČO UKÁZAŤ~<br />Keď nie ste prihlásený do systému, môžete si vybrať medzi dvomi možnosťami:<br /><br /><b>1. Všetci ľudia</b><br />S týmto nastavením budú zobrazené všetky osoby a rodiny.<br /><br /><b>2. Nedávne udalosti (<100 rokov)</b><br />S týmto nastavením uvidíte udalosti, ktoré sa stali v danom dni/mesiaci, však iba mladšie než 100 rokov.<br /><br />Existuje ešte tretia možnosť. Aby ste si ju mohli vybrať, musíte byť buď prihlásený alebo musí admin nastaviť systém tak, aby si žijúce osoby mohol zobraziť kdokoľvek.<br /><br /><b>3. Žijúci ľudia</b><br />S týmto nastavením budú zobrazené iba žijúce osoby.<br />Po zvolení jednej z možností sa stránka automaticky znovu načíta (s novým nastavením).<br />Nastavenie dňa, mesiaca, roku a režimu dňa alebo mesiaca zostáva rovnaké.<br />";
$pgv_lang["annivers_sex_help"]			= "~VÝBER POHLAVIA~<br />Ak ste prihlásený (alebo ak admin vypol nastavenie utajenia), môžete si vyberať medzi tromi možnosťami:<dl><dt><b>1. Všetky ikony</b></dt><dd>V tomto prípade (implicitne) sú zobrazené udalosti všetkých osôb a rodín.</dd><dt><b>2. Ikona - muži</b></dt><dd>Zobrazené sú iba udalosti u mužov. Mužský členovia rodín budú zobrazený s rodinnými udalosťami.</dd><dt><b>3. Ikona - ženy</b></dt><dd>Zobrazené sú iba udalosti týkajúce sa žien. V prípade rodín sú rodinné udalosti zobrazené pri ženách.</dd></dl>Ak kliknete na niektorú z volieb, dôjde k novému načítaniu stránky a zobrazí sa požadovaná forma.<br />Ostatné nastavenia dňa, mesiaca, roku, udalostí a režimu zostávajú rovnaké.<br />";
$pgv_lang["annivers_event_help"]		= "~VÝBER UDALOSTÍ~<br />Tu si môžete vybrať, či chcete u osôb a rodín zobraziť všetky udalosti alebo iba nejakú konkrétnu.<br /><br />Keď kliknete na niektorú z volieb, stránka sa načíta znovu a zobrazí sa tak, ako ste požadovali.<br />Ostatné nastavenia dňa, mesiaca, roku, pohlavia a režimu zostávajú rovnaké.<br />";
$pgv_lang["annivers_tip_help"]			= "~TIP~<br />Predpokladajme, že máte v databázi príbuzného, ktorý sa narodil 25. januára 1875.<br />Nastavte tento dátum.<br />Keď teraz kliknete na jedno z dvoch tlačítiek pre zobrazenie, uvidíte zoznam alebo kalendár pre tento dátum.<br />Všetky veky, výročia, atd. sú prepočítané a počítané spätne podľa dátumu, ktoré ste nastavili.<br />Takže, v skutočnosti, vidíte rovnaký zoznam alebo kalendár ako váš príbuzný v minulosti.<br />";
$pgv_lang["day_month_help"]			= "~TLAČÍTKA ZOBRAZIŤ DEŇ / ZOBRAZIŤ MESIAC / ZOBRAZIŤ ROK~<br /><br />Tlačítko <b>Zobraziť deň</b> zobrazí udalosti spojené s dátumom vybraným z kalendára. Prehľadávajú sa všetky roky, takže stačí zadať deň a mesiac. Zmena roku sa nijako neprejaví.<br />Zoznam môžete obmedziť výberom možnosti \"Posledné roky\" alebo, ak je táto možnosť k dispozícii, \"Žijúci ľudia\".<br />Vek ľudí zo zoznamu sa vypočíta k aktuálnemu roku.<br /><br />Tlačítko <b>Zobraziť mesiac</b> ukáže tabuľku pre daný mesiac a rok. I tu môžete zoznam obmedziť dodatočným kliknutím na \"Žijúci ľudia\" alebo \"Posledné roky\".<br />Výber nejakého roku z minulosti v kombinácii s voľbou \"Posledné roky\" vám umožní získať realistický obraz toho, aký kalendár mali na stene vaši predkovia. Vek všetkých ľudí v kalendári sa zobrazí vo vzťahu k roku zadanému v príslušnom políčku.<br /><br />Tlačítko <b>Zobraziť rok</b> vám ukáže zoznam udalostí, ktoré sa stali v priebehu vybraného roku.<br />Opäť môžete zoznam obmedziť dodatočným kliknutím na \"Žijúci ľudia\", ak je táto možnosť k dispozícii, alebo \"Posledné roky\".<br />Vítanou vlastnosťou programu je, že môže zobraziť udalosti i za viacej rokov: Proste iba zapíšte poslednú číslicu koncového roku za počiatočný rok a pomlčku \"-\" (napr.: 1992-4 zaistí zobrazenie všetkých udalostí od roku 1992 do 1994, alebo 1976-1984 pre všetky udalosti medzi rokmi 1976 a 1984 včetne).<br />- Tiež môžete napísať iba počiatočné číslice požadovaných rokov a zobrazia sa všetky udalosti, ktoré sa stali v rokoch začínajúcich zadanými číslicami. (napr.: 197 pre všetky udalosti medzi rokmi 1970 a 1979 včetne)<br /><br />Keď budete chcieť <b>zmeniť rok</b>, potom <b>musíte</b> stisknúť jedno z týchto troch tlačítok.<br /><br />Všetko ostatné nastavenie ostáva rovnaké.<br />";
$pgv_lang["help_clippings.php"]			= "~Schránka výstrižkov~<br />Schránka výstrižkov vám umožňuje robiť z tohoto rodokmeňa \"výstrižky\" a vložiť ich do jednoduchého GEDCOM súboru ku stiahnutiu.<br /><br />* Ako urobiť výstrižky?<br />To je veľmi jednoduché. Kdekoľvek uvidíte meno, na ktoré sa dá kliknúť (osoba, rodina alebo prameň), môžete na toto meno kliknúť a tak sa dostať na stránku s údajmi o tomto mene. Na tejto stránke uvidíte voľu \"Pridať do schránky výstrižkov\".<br />Kliknutím na tento odkaz sa dostanete na stránku, kde  budete mať niekoľko možností stiahnutia.<br /><br />* Ako súbor stiahnuť?<br />Keď budete mať položky v schránke, môžete ich stiahnúť jednoducho kliknutím na odkaz \"Stiahnúť\".<br>Potom postupujte podľa inštrukcií a odkazov.";

//-- Clipping Cart-page
$pgv_lang["clip_download_help"]			= "~STIAHNUTIE VÝSTRIŽKOV~<br /><br />Kliknutím na tento odkaz, budete presmerovaný na ďalšiu stránku.<br />Ak bude viacej možností, čo stiahnúť, budú zobrazené na stránke.<br />Jednoducho postupujte podľa pokynov.";
$pgv_lang["empty_cart_help"]			= "~VYPRÁZDNENIE SCHRÁNKY VÝSTRIŽKOV~<br /><br />Kliknutím na tento odkaz bude vaša schránka výstrižkov úplne vyprázdnená.<br /><br /> Ak nechcete odstrániť všetky osoby, rodiny atd zo schránky výstrižkov, môžete odstraňovať položku za položkou klikaním na odkaz \"Odstrániť\" v rámčekoch s menami. ";

//-- GEDCOM Edit Utillity
$pgv_lang["show_changes_help"]			= "~ZOBRAZENIE ZMIEN V GEDCOME~<br /><br />To, že vidíte túto správu, znamená dve veci:<br /><br />1. Niekto urobil v GEDCOMe zmeny<br />Záznamy mohli byť pridané, zmazané alebo zmenené.<br /><br />2. Zmeny doteraz neboli potvrdené administrátorom.<br />Keď budú tieto zmeny prijaté (alebo zamietnuté), táto správa zmizne.<br /><br /><br />Kliknutím na odkaz sa môžete podívať na zmeny, ktoré boli urobené.<br />Ak zistíte, že nejaká zmena nie je správna, prosím oznámte to adminovi.";
$pgv_lang["help_search.php"]			= "~Stránka VYHĽADÁVANIE~<br /><br />I keď táto stránka vypadá veľmi jednoducho, tie dva formuláre na nej obsluhuje výkonný vyhľadávací nástroj.<br /><br />Väčšina genealogických webov vám umožní hľadať priezviská (niekedy i mená).<br />Na tejto stránke môžete hľadať prakticky čokoľvek.<br /><br />Vyhľadávacie políčko na ľavej strane obrazovky je úplne to isté ako v záhlaví stránky.<br /><br />Ak hľadáte ľudí spojených s určitým rokom, napíšte proste rok. Program vám nájde všetky spojenia.<br /><br />Hľadáte azda meno alebo miesto?<br />Tak ho zadajte, buď celé alebo iba časť, a program urobí zbytok za vás.<br /><br />Vyhľadávacia metóda SOUNDEX.<br />Cez vyhľadávacie políčko na pravej strane môžete vyhľadávať mená osôb a miest, dokonca i tedy, keď neviete, ako sa píše.<br /><br />Ďalšiu nápovedu k týmto dvom políčkam nájdete, ak kliknete na <b>?</b> nad políčkami.<br /><br />";

//-- Search-page
$pgv_lang["search_enter_terms_help"]		= "~VKLADANIE VÝRAZOV PRE VYHĽADÁVANIE~<br /><br />Do tohoto vyhľadávacieho políčka môžete zadávať kritéria ako dátumy, krstné mená, priezviská, miesta, multimédia atd.<br /><br /><b>Masky</b><br />Masky, tak ako ich asi poznáte (ako * alebo ?), nie sú povolené, ale program sám vyhľadáva pomocou masiek.<br />Čo to znamená?<br />Predpokladajme, že ste do políčka zadali nasledujúci reťazec: \"<b>Pete</b>\"<br />Výsledok bude (zase predpokladajme, že tieto mená sú v databáze):<br /><b>Pete</b> Smith<br /><b>Pete</b>r Johnes<br />Will <b>Pete</b>rson<br />niekto --narodený 1. januára 1901 <b>Pete</b>rsburg<br />atd., atd.<br /><br /><b>Dátumy</b><br />Napísaním roku do vyhľadávacieho políčka dostanete mená všetkých osôb, ktoré sú nejako spojené s týmto rokom.<br />Ak napíšete 1950, potom výsledkom budú ľudia, ktorý sa roku 1950 narodili, oženili/vydali, zomreli alebo.... sú akoukoľvek inou udalosťou s týmto rokom spojený.<br /><br />Ak napíšete \"4 Dec\", potom získate zoznam všetkých ľudí spojených z nejakou udalosťou z dňa 4. decembra ktoréhokoľvek roku.<br />Ale tiež osoby, ktorých sa týkajú udalosti z dní 14. či 24. decembra.<br />Ako vidíte, tiež tu sa uplatňujú masky, takže ich nemusíte písať.<br /><br /><b>Správne dátumy</b><br />Program hľadá dátumy tak, ako sú uložené v GEDCOM súbore .<br />Takže, ak chcete hľadať nejakú udalosť 14. decembra, mali by ste napísať:<br /><b>14 dec</b><br />, pretože toto je formát, v akom sú dátumy ukladané do GEDCOM súboru.<br />Ale ak napíšete \"<b>dec 14</b>\", potom výsledkom bude zoznam ľudí spojených s nejakou udalosťou - napr. 08 <b>dec</b>ember 18<b>14</b>. Ak chcete a poznáte ich, môžete používať tiež regulárne výrazy. Napríklad, keď budete chcieť nájsť všetky osoby, ktoré sa narodili v 20. storočí, mohli by ste zadať do vyhľadávania 19[0-9][0-9] a dostali by ste všetky osoby s dátumami od 1900 do 1999.<br /><br />Keby ste potrebovali ďalšiu nápovedu k tomuto vyhľadávaciemu systému, prosím dajte nám vedieť, aby sme ju mohli rozšíriť.";
$pgv_lang["soundex_search_help"]		= "~HĽADANIE MENA PODĽA TOHO AKO (SI MYSLÍTE, ŽE) SA PÍŠE (METÓDA SOUNDEX)~<br /><br />Metóda SOUNDEX je veľmi užitočná.<br />Najskôr krátke objasnenie pojmu Soundex:<br /><br />Soundex vyhľadá priezviská, ktoré znejú podobne, ale píšu sa inak. Soundexový kód začína prvým písmenom priezviska a po ňom nasleduje trojciferný kód predstavujúci prvé tri zo zostávajúcich súhlások. U mien, ktoré nemajú dosť znakov, sa do kódu pridajú nuly.<br /><br />V angličtine to znamená:<br />Ak hľadáte meno \"Smith\", môžete ako výsledok získať tiež:<br />Smith - Smid - Smit - Schmidt, Smyth, Smithe, Smithee, Schmitt, Smead,  Sneed, Smoote atd.<br /><br />Soundexový kód vás nemusí vôbec zaujímať.<br />Jednoducho iba napíšte meno, ktoré hľadáte, a program to urobí.<br /><br />Systém Soundex je veľmi vhodné použiť v tomto prípade: poznáte meno, ale neviete, ako sa presne píše.<br />Môže to tiež pomôcť v prípade, že ten, kto meno vkladal do databázy, urobil chybu.<br />I v takom prípade, za použitia systému Soundex, bude možné meno nájsť.<br /><br />Aby ste si na to zvykli, skúste nájsť určité meno, ale napíšte ho v pozmenenej podobe.<br /><br />V tomto soundexovom formulári stačí zadať akékoľvek meno.<br />Môžete vyhľadávať podľa krstného mena, priezviska alebo podľa názvu miesta.<br />Ak vyplníte viacej než jedno políčko, jednotlivé kritériá sa zreťazia pomocou \"AND\" - tj. budú vyhľadané iba tie záznamy, ktoré splňujú súčasne všetky zadané podmienky.<br />Výsledky hľadania môžete ovplyvniť tiež zadaním roku alebo rozsahu rokov. Napríklad: 1950 alebo 19[5-7][0-9], čo znamená 1950 až 1979.<br />Výsledkom vyhľadávania budú všetky osoby, u ktorých je zaznamenaná nejaká udalosť na danom mieste v zadanom rozsahu rokov.";

//-- Individuals-page
$pgv_lang["help_individual.php"]		= "~STRÁNKA S ÚDAJMI O OSOBE~<br /><br />Na tejto stránke sú zobrazené všetky údaje o danej osobe.<br /><br />Ak je v databáze obrázok, uvidíte ho nahore po ľavej strane. Vedľa obrázku uvidíte meno osoby. K menám môžu byť pripojené pramene a poznámky. Ak sú k niektorému z mien pripojené poznámky alebo pramene, uvidíte ich zoradené pod príslušným menom.<br />Človek môže mať tiež pseudonym. Ak ho má tak, bude tiež zobrazený.<br /><br />Ak máte potrebné práva k tejto osobe, zobrazí sa vám tiež odkazy pre úpravu a vymazanie položiek, ktoré môžete upravovať.<br /><br />Na tejto stránke vidíte záložky \"Osobné údaje\", \"Poznámky\", \"Pramene\", \"Média\", \"Blízky príbuzný\".<br /><br />Pod týmito záložkami nájdete všetky informácie uložené v GEDCOMe.<br /><br />Záložka \"Osobné údaje\" vám ukáže údaje a podrobnosti o danej osobe a údaje o jej manželstvách. Kliknutie na ktorýkoľvek dátum vás prepne do Kalendára výročí s týmto dátomom, takže sa budete môcť pozrieť, aké ďalšie udalosti sa ešta k tomuto dátumu viažu. Kliknutie na miesto vás prepne do Hierarchie miest, kde uvidíte zoznam ľudí, v ktorých živote sa niečo odohralo na rovnakom mieste. Pri sňatkoch a iných údajoch spojených s rodinou sa zobrazí tiež meno partnera, takže sa budete môcť pozrieť i na neho a k dispozícii je i odkaz na záznam o rodine.<br /><br />Záložka \"Poznámky\" vám ukáže všetky všeobecné poznámky pripojené k tejto osobe.<br /><br />Záložka \"Pramene\" vám ukáže všetky pramene viažúce sa k tejto osobe. Po kliknutí na názov prameňa sa dostanete na stránku s podrobnými údajmi o danom prameni a zoznamom ľudí, ktorý sú k tomuto prameňu napojený.<br /><br />Pod záložkou \"Média\" sa zobrazí zoznam všetkých obrázkov a iných multimediálnych súborov pripojených k tejto osobe. Ak kliknete na náhľad obrázku, otvorí sa okno s obrázkom v pôvodnej veľkosti.<br /><br />Pod záložkou \"Blízky príbuzný\" sú zoradený rodičia, súrodenci, partneri a deti tejto osoby. Osoby budú zapísané do rámčekov podobných schémam, ktoré ste už videli.<br /><br />Pri pravej strane obrazovky nájdete rámček s odkazmi.<br />Mnohé z týchto odkazov sú tiež v hornom menu. Napríklad, ak kliknete z postranných odkazov na \"Vývod\", dostanete sa na stránku s vývodom tejto osoby. Zatiaľ čo keď kliknete na odkaz \"Vývod\" v hornom menu, zobrazí sa vám stránka s implicitným vývodom tohoto GEDCOMu.<br /><br />Jeden z odkazov, ktoré by sa mohli v zoznamu objaviť, ak boli zapnuté adminom, je odkaz \"Zobraziť priamo záznam GEDCOM\". Tento odkaz vám ukáže priamo samotný GEDCOM kód tejto osoby.<br /><br />Ak admin povolil používanie Schránky výstrižkov, uvidíte tiež odkaz, ktorý vám umožní pridať si túto osobu do Schránky výstrižkov.<br /><br />Odkaz \"Vzťah ku mne\" sa zobrazí iba v prípade, že ste prihlásený do systému a bolo vám priradené nejaké číslo z aktuálneho GEDCOMu. Po kliknutí na tento odkaz sa ocitnete na stránke s vývodom a vy uvidíte, ako ste príbuzný s touto osobou.<br /><br />Ďalšia nápoveda je k dispozícii na stránke po kliknutí na <b>?</b> za odkazmi či položkami.";
$pgv_lang["delete_person_help"]			= "~VYMAZANIE OSOBY Z GEDCOMU~<br /><br />Kliknutím na túto voľbu označíte túto OSOBU, aby mohla byť vymazaná z GEDCOMu.<br /><br />Čo to znamená?<br />Predpokladajme, že máte dobrý dôvod k odstráneniu tejto osoby zo svojho GEDCOMu. Kliknite na odkaz a zobrazí sa vám pop-up okno a budete vyzvaný k potvrdeniu, či naozaj chcete akciu vykonať, alebo ju ukončiť.<br /><br />Ak budete pokračovať v odstraňovaní osoby, vyskočí vám po chvilke okno so správou, že osoba bola vymazaná.<br /><br />Keď budete pokračovať v prezeraní stránok, všimnete si možno, že osoba je ešte stále v databáze, že sa teda nič nezmenilo.<br /><br />To <b>nie je</b> chyba.<br />Administrátor dostane správu, že v GEDCOMe bola urobená zmena a že ste odstránili túto osobu.<br />Administrátor môže vašu zmenu buď prijať, alebo odmietnúť. Iba potom už túto zmenu nie je možné vziať späť.<br />V prípade pochybností vás administrátor bude kontaktovať.";
$pgv_lang["delete_name_help"]			= "~UPRAVENIE alebo VYMAZANIE MENA Z GEDCOMU~<br /><br /><b>ÚPRAVA MENA</b><br />Po kliknutí na tento odkaz sa vám otvorí pop-up okno, v ktorom budete môcť upraviť meno osoby.<br />Je to veľmi jednoduché, skrátka iba napíšete zmeny do políčok, kliknete na tlačítko a zatvoríte okno; a je to.<br /><br /><b>VYMAZAŤ MENO</b><br />Kliknutím na túto voľbu označíte toto meno k výmazu z GEDCOMu.<br />Majte na pamäti, že vymazanie mena je niečo úplne iného než vymazanie osoby.<br />Vymazaním mena iba odstránite u tejto osoby meno. Osoba sama vymazaná nebude.<br />Ak vymažete u osoby pseudonym, zostanú jej ostatné mená.<br />Ak má iba jedno meno a vy ho vymažete, osoba nebude vymazaná, ale bude naďalej vedená ako \"Neznámy(a)\".<br />Osoba tiež nebude odpojená od príbuzných, prameňov, poznámok atd.<br /><br />Ako to funguje?<br />Predpokladajme, že máte dobrý dôvod k odstráneniu tohoto mena zo svojho GEDCOMu. Kliknite na odkaz a zobrazí sa vám pop-up okno a budete vyzvaný k potvrdeniu, či naozaj chcete akciu vykonať, alebo ju ukončiť.<br /><br />Ak budete pokračovať v odstraňovaní osoby, vyskočí vám po chvíľke okno so správou, že meno bolo vymazané.<br /><br />Keď budete pokračovať v prezeraní stránok, všimnete si možno, že meno je ešte stále v databáze, že sa teda nič nezmenilo.<br /><br />To <b>nie je</b> chyba.<br />Administrátor dostane správu, že v GEDCOMe bola urobená zmena a že ste odstránili toto méno.<br />Administrátor môže vašu zmenu buď prijať, alebo odmietnuť. Iba potom už tuto zmenu nemôžete vziať spät.<br />V prípade pochybností vás administrátor bude kontaktovať.";
$pgv_lang["add_name_help"]			= "~PRIDANIE NOVÉHO MENA~<br /><br />Tento odkaz vám umožní pridať tejto osobe ďalšie meno. Niektorý ľudia sú známi pod inými menami či aliasy. Tento odkaz vám umožní pridať meno, bez zmeny starého.";
$pgv_lang["add_note_help"]			= "~PRIDANIE NOVEJ POZNÁMKY~<br /><br />Ak chcete k tomuto údaju pridať poznámku, potom toto je miesto, kde tak môžete urobiť.<br />Urobiť to je jednoduché, kliknite na odkaz. Otvorí sa vám pop-up okno a vy budete môcť napísať novú poznámku.<br /><br />Po dokončení zapísania poznámky kliknite na tlačítko pod rámčekom a zatvorte okno; to je všetko.";
$pgv_lang["add_sibling_help"]			= "~PRIDANIE BRATA ALEBO SESTRY~<br /><br />Kliknutím na tento odkaz môžete pridať dieťa do tejto rodiny.<br />\"Táto rodina\" je, v tomto prípade, otec a matka ústrednej osoby tejto stránky.<br />Takže, majte na pamäti, že pridávate brata alebo sestru tejto osoby.<br />Pridanie brata alebo sestry je jednoduché: Jednoducho iba kliknite na odkaz, vyplňte políčka v pop-up okne a je to.<br /><br />Ak potrebujete pridať syna či dceru ústrednej osoby, posuňte sa v okne o niečo dolu a kliknite na odkaz \"Rodina s partnerom\".";
$pgv_lang["add_son_daughter_help"]		= "~PRIDANIE SYNA ČI DCÉRY~<br /><br />Kliknutím na tento odkaz môžete pridať dieťa k tejto rodine.<br />\"Táto rodina\" je, v tomto prípade, ústredná osoba na tejto stránke a jej partner.<br />Takže majte na pamäti, že sa chystáte pridať syna alebo dcéru tejto osobe.<br />Pridanie syna alebo dcéry je jednoduché: Jednoducho iba kliknite na odkaz, vyplňte políčka v pop-up okne a je to.<br /><br />Ak chcete pridať brata alebo sestru ústrednej osobe, posuňte sa na stránke kúsok nahoru a kliknite na odkaz \"Rodina s rodičmi\".";
$pgv_lang["link_child_help"]			= "~PRIPOJENIE TEJTO OSOBY K EXISTUJÚCEJ RODINE AKO DIEŤA~<br /><br />Kliknutím na tento odkaz môžete túto osobu pripojiť ako dieťa k existujúcej rodine.<br /><br />Predpokládajme, že rodičia tejto osoby boli neznámy a vy teraz zistíte, že majú svoj záznam v tomto GEDCOMe.<br /><br />Kliknite iba na odkaz, vložte ID rodiny (ak nepoznáte ID, môžete použiť okno pre vyhľadávanie) a práca je hotová.";
$pgv_lang["link_husband_help"]			= "~PRIPOJENIE TEJTO OSOBY K EXISTUJÚCEJ RODINE AKO MANŽELA~<br /><br />Táto položka vám umožní pripojiť túto osobu ako manžela k rodine, ktorá už je zapísaná v GEDCOMe. Kliknutím na tento odkaz pridáte túto osobu k rodine, u ktorej manžel doteraz nebol známy. Táto osoba zaujme miesto tej neznámej osoby. Všetky udalosti, informácie o manželstve a deti zostanú pripojené k rodine tak, ako sú.<br /><br />Iba kliknite na tento odkaz, zadajte ID rodiny (ak nepoznáte ID, môžete ho vyhľadať pomocou pop-up okna) a celá operácia je hotová. Toto je špeciálna voľba, ktorá by sa mala používať jedine v prípade, že rodina, ku ktorej chcete osobu pripojiť, je už v GEDCOMe uložená. Ak chcete pridať novú rodinu, použijte odkaz pre pridanie novej manželky.";
$pgv_lang["add_husband_help"]			= "~PRIDANIE NOVÉHO MANŽELA~<br /><br />Kliknutím na tento odkaz môžete pridať \"nového\" muža a pripojiť ho k ústrednej osobe ako manžela.<br /><br />Kliknite jednoducho na odkaz. Objaví sa pop-up okno, v ktorom budete môcť novú osobu pridať.<br />Vyplňte čo najviac políčok a kliknite na tlačítko \"Uložiť\".<br /><br />To je všetko.";
$pgv_lang["link_new_husb_help"]			= "~#pgv_lang[link_new_husb]#~<br />Toto vám umožňuje pridať osobu, ktorá už existuje, ako nového manžela k tejto osobe. Bude vytvorená nová rodina s manželom, ktorého ste vybrali. Máte tiež možnosť špecifikovať udaje o sobáši novej rodiny.<br /><br />";
$pgv_lang["link_wife_help"]			= "~PRIPOJENIE TEJTO OSOBY K EXISTUJÚCEJ RODINE AKO MANŽELKU~<br /><br />Táto položka vám umožní pripojiť aktuálnu osobu ako manželku k nejakej rodine, ktorá je už zapísaná v GEDCOMe. Toto je špeciálna voľba, ktorá by sa mala používať jedine v prípade, že rodina, ku ktorej chcete osobu pripojiť, je už v GEDCOMe uložená. Ak chcete pridať novú rodinu, použijte odkaz pre pridanie nového manžela.";
$pgv_lang["add_wife_help"]			= "~PRIDANIE NOVEJ MANŽELKY~<br /><br />Kliknutím na tento odkaz môžete pridať \"novú\" ženu a pripojiť ju k ústrednej osobe ako novú manželku.<br /><br />Kliknite jednoducho na odkaz. Objaví sa pop-up okno, v ktorom budete môcť novú osobu pridať.<br />Vyplňte čo najviacej políčok a kliknite na tlačítko \"Uložiť\".<br /><br />To je všetko.";
$pgv_lang["link_new_wife_help"]			= "~#pgv_lang[link_new_wife]#~<br />Toto vám umožňuje pridať osobu, ktorá existuje, ak novú manželku tejto osoby.  This will create a new family with the wife you select.  You will also have the option of specifying a marriage for this new family.<br /><br />";
$pgv_lang["add_new_parent_help"]		= "#pgv_lang[multiple_help]#<br />~PRIDANIE NOVÉHO OTCA alebo MATKY~<br /><br />V GEDCOMe nepochybne bude mnoho osôb, u ktorých nie je uvedený otec alebo matka.<br /><br />V takom prípade nájdete na <b>Stránke s osobnými údajmi</b>, tabuľke <b>Blízky príbuzný</b>, tabuľke <b>Rodina s rodičmi</b> odkazy pre pridanie <b>nového</b> otca alebo matky k danej osobe.<br /><br /><b>POZNÁMKA:</b><br />Majte prosím na pamäti, že tieto odkazy slúžia pre pridanie <b>nového</b> otca alebo matky.<br />Ak už matka alebo otec má v GEDCOMe záznam, potom použijte odkaz: <b>#pgv_lang[link_as]##pgv_lang[child]#</b>, ktorý nájdete na stránce s osobnými údajmi - pod najspodnejšou tabuľkou na stránke.";

//-- Add Facts
$pgv_lang["add_facts_help"]			= "~PRIDANIE NOVÝCH ÚDAJOV~<br /><br />Tu môžete k osobe (alebo osobám) pridať nové údaje.<br /><br />Najskôr z \"rolovacieho zoznamu\" vyberte typ údaja, potom kliknite na tlačítko \"Pridať\".<br />V \"rolovacom zozname\" sú už všetky údaje, ktoré je možné pridať do súboru GEDCOM.<br />";
$pgv_lang["add_custom_facts_help"]		= "~Pridať vlastnú udalosť~<br />Ak ste v zozname GEDCOM údajov nenašli údaj, ktorý chcete pridať, môžete zadať <b>vlastný údaj</b>.<br />Vloženie vlastného údaja je rovnako jednoduché ako vloženie preddefinovaného údaja.<br />Jediný rozdiel spočíva v tom, že musíte naviac zadať názov údaja. To musíte urobiť v hornom políčku: <b>#pgv_lang[type]#</b><br />";
$pgv_lang["add_source_help"]			= "~PRIDANIE NOVEJ CITÁCIE K PRAMEŇU~<br /><br />Ak chcete k tomuto údaju pridať nový prameň, môžete kliknúť na odkaz.<br />Otvorí sa pop-up okno a vy budete môcť zvoliť jeden prameň zo zoznamu (Nájsť ID) a pridať \"Citáciu\".<br /><br />V tejto chvíli nie je možné pridať úplne nový prameň, takže musíte vybrať jeden z prameňov zo zoznamu.<br /><br />Ak nie je prameň, ktorý chcete upravovať, v zoznamu, upozornite prosím admina (pripíšte údaje o prameni) a on ho pridá do zoznamu.<br />Nabudúce tak už bude váš nový prameň zahrnutý v zoznamu a vy ho budete môcť upravovať.<br /><br />Pravdepodobne už v niektorej z budúcich verzií PhpGedView bude možné pridávať pramene priamo.<br /><br />#pgv_lang[add_facts_general_help]#";
$pgv_lang["add_media_help"]			= "~PRIDANIE NOVÉHO MÉDIA~<br /><br />Možnosť pridávať do GEDCOMu multimediálne súbory je veľmi pekná vlastnosť.<br />I keď tento program vyzerá pekne i bez médií, po pridaní obrázkov alebo iných multimediálnych súborov k príbuzným to môže byť jedine lepšie.<br /><br /><b>Čo by ste si mali predstaviť pod týmto pojmom.</b><br />Ako možno viete, existuje neskutočná rada multimediálnych formátov. I keď PhpGedView vie pracovať s väčšinou z nich, mali by ste niektoré veci zvážit.<br /><br /><b>Formáty</b><br />Obrázky môžu byť uložené do mnohých formátov.<br />Napríklad obrazok.jpg / obrazok.png / obrazok.bmp / obrazok.gif / atd.<br />Všetky obrázky z našeho príkladu budú mať na obrazovke rovnakú veľkosť, ale budú sa podstatne líšiť veľkosťou súboru na disku.<br /><br /><b>Rozlíšenie</b><br />Rozlíšenie obrázkov je dané v jednotkách \"dpi\" (body na palec). Môžete to viacmenej porovnať s klasickou fotografiou a rozdielmi medzi 25ASA - 200ASA - 800ASA.<br />Čím vyššie rozlíšenie, tým lepšia kvalita, ale tiež väčšia veľkosť súboru na disku.<br />Normálne stačí na obrázky na internete 75.<br /><br /><b>Farebná hĺbka</b><br />Tretí spôsob, ako zmenšiť súbor, je znížiť počet farieb.<br />Počet farieb môže byť rôzný – od čiste čiernobielej až po true colors a niečo medzi tým.<br />Opäť si uvedomte, že, čím viacej farieb použijete, tým väčšia bude veľkosť súboru.<br /><br /><b>Prečo je dôležité, aby boly obrázkové súbory malé?</b><br /><br />Za prvé: Náš webový priestor je obmedzený.<br />Čím väčšie budú súbory, tým viacej diskového priestoru na servere budeme potrebovať. Čím viacej miesta budeme potrebovať, tím viacej za to budeme musieť platiť.<br /><br />Za druhé: doba sťahovania. Ak budete mať veľké súbory, uživatelia (i vy) budú musieť dlho čakať, než sa im stránka so všetkými obrázkami načíta.<br />Každý nemá to štastie mať kabelové, širokopásmové alebo DSL pripojenie.<br /><br /><b>Ako môžete nahrať svoje súbory na server</b><br />Stručne - nemôžete.<br />Z vyššie zmienených dôvodov nemôžete svoje súbory nahrať priamo do databázy.<br /><br /><b>Teda ako?</b><br />Kontaktujte admina, od ktorého chcete, aby súbory do GEDCOMu pridal. Poradí vám, ktorý formát použiť.<br />Ak budete mať obrázky v správnom formáte, budete ich môcť poslať adminovi na e-mail. Admin skontroluje formáty a veľkosti súborov a nahrá ich do adresára na servere.<br />Potom budete môcť tieto súbory pripojiť ku svojim príbuzným, a to použitím tohoto odkazu #pgv_lang[mgv]#.";
$pgv_lang["add_facts_general_help"]		= "~Všeobecné informácie o pridávaní~<br />Keď pridáte k osobe či osobám údaj, poznámku, prameň alebo multimediálny súbor, táto operácia musí byť ešte potvrdená osobou, ktorej admin udelil právo potvrdzovať zmeny v databáze.<br />Než sa tak stane, zmeny sa na stránke zobrazia v rámčeku odlišnej farby a to iba uživateľom, ktorý majú právo túto databázu upravovať, obyčajným návštevníkom nie. Až budú zmeny potvrdené, rámčeky zmiznú a dáta sa zobrazia normálne.";

//-- Edit user
//$pgv_lang["help_edituser.php"]	is moved to help_text_vars.php
$pgv_lang["edituser_my_account_help"]		= "Na tejto stránke môžete zmeniť svoje nastavenia a predvoľby.<br /><br />Môžete zmeniť svoje uživateľské meno, celé meno, heslo, jazyk, e-mailovú adresu, motív (podobu) stránky a uprednostňovanú formu kontaktu.<br /><br />Jediné, čo si sami nemôžete zmeniť, je osobné ID v GEDCOMe.<br /><br />";
$pgv_lang["edituser_username_help"]		= "~#pgv_lang[username]#~<br /><br />V tomto políčku môžete zmeniť svoje uživateľské meno.<br />Ak sa vám už vaše súčasné uživatelské meno nepáči alebo máte iné dôvody ku jeho zmene, môžete tak urobiť v tomto formulári.<br /><br />V uživateľskom mene sa rozoznáva veľkosť písmen. To znamená, že \"Ján\" nie je rovnaké ako \"ján\" nebo \"JÁN\".<br /><br />Mali by ste použiť <b>iba</b> znaky z tých abecied, ktoré sú podporované týmto programom (veľké a malé písmená), čísla, pomlčku (-) a podčiarnik (_).<br /><br /><b>Nepoužívajte</b> interpunkčné znamienka, medzery alebo iné znaky než znaky podporovaných abecied.";
$pgv_lang["edituser_firstname_help"]		= "~#pgv_lang[firstname]#~<br /><br />V tomto poli môžete zmeniť svoje meno. Toto je meno, ktoré vidia ostatný uživatelia, keď ste prihlásený.<br /><br />I keď voľba čo dáte do tohoto poľa je na vás, mali by ste informovať o tejto zmene administrátora. Ak ostatný uživatelia uvidia prihláseného neznámeho uživateľa tak by mohli byť udivený a klásť otázky administrátorovi. Admin to môže zistit i bez vášho oznámenia ale vy mu môžete ušetriť túto zbytočnú prácu.<br /><br />";
$pgv_lang["edituser_lastname_help"]		= "~#pgv_lang[lastname]#~<br /><br />V tomto poli môžete zmeniť svoje priezvisko. Toto je priezvisko, ktoré vidia ostatný uživatelia, keď ste prihlásený.<br /><br />I keď voľba čo dáte do tohoto poľa je na vás, mali by ste informovať o tejto zmene administrátora. Ak ostatný uživatelia uvidia prihláseného neznámeho uživateľa tak by mohli byť udivený a klásť otázky administrátorovi. Admin to môže zistit i bez vášho oznámenia ale vy mu môžete ušetriť túto zbytočnú prácu.<br /><br />";
$pgv_lang["edituser_gedcomid_help"]		= "~#pgv_lang[gedcomid]#~<br /><br />Toto je vnútorné (GEDCOM) ID, ktoré vás spája s vašími údajmi v GEDCOMe.<br /><br />Toto ID nemôžete zmeniť.<br />To nastavuje administrátor stránok.<br />Ak si myslíte, že toto ID nie je správné, mali by ste kontaktovať administrátora, aby ho zmenil.<br/>";
$pgv_lang["edituser_rootid_help"]		= "~#pgv_lang[rootid]#~<br /><br />Toto je východisková osoba všetkých vašich schém.<br />Keď kliknete (napríklad) na odkaz Vývod, potom uvidíte túto osobu v rámčeku vľavo úplne hore.<br />Samozrejme nie je nutné, aby ste boli východiskovou osobou vy. Ako východiskovú osobu si môžete stanoviť ktorúkoľvek osobu, ktorú máte právo vidieť.<br />V niektorých schémach môžete východiskovú osobu meniť, ale táto zmena bude platiť iba pre danú stránku.<br />";
$pgv_lang["edituser_password_help"]		= "~#pgv_lang[password]#~<br /><br />Je dobré zvyknúť si pravidelne meniť heslo.<br />Musíte si uvedomiť, že ktokoľvek, kto pozná vaše uživateľské meno a heslo, má prístup k vaším dátam.<br />Vytvorte si heslo zložené z aspoň 6 znakov. Čím dlhšie, tým lepšie. Môžete použiť všetky znaky abecedy, číslice a akékoľvek ďalšie znaky, ktoré máte na svojej klávesnici.<br /><b>Poznámka:</b> Je lepšie <b>nepoužívať</b> \" (úvodzovky) či ' (apostrofy). Možno by to fungovalo, ale nie je to zaručené.<br /><br /><b>Najlepšia je kombinácia veľkých, malých znakov, číslic a ďalších znakov</b>. Napríklad: 5Z_q\$P4=r9.<br /><br />Rovnako ako uživateľské meno, tak i heslo je <b>case sensitive</b> (rozlišuje veľké/malé písmená). To znamená, že \"Ja5n\" nie je to isté čo \"ja5n\" alebo \"JA5N\".";
$pgv_lang["edituser_conf_password_help"]	= "~#pgv_lang[confirm]#~<br /><br />Ak ste si zmenili heslo, je potrebné ho ešte potvrdiť.<br />Je to z toho dôvodu, aby sa vylúčily možné chyby pri zapisovaní hesla.<br />Ak zistí program, že vaše heslo a jeho potvrdenie sa líši, uvidíte túto správu: <b>#pgv_lang[password_mismatch]#</b>.<br />Obsah oboch políčok (hesla a potvrdenia) bude vymazaný a budete musieť zadať heslo do oboch políčok.<br />";
$pgv_lang["edituser_change_lang_help"]		= "~#pgv_lang[change_lang]#~<br /><br />Tu môžete nastaviť implicitný jazyk pre svoje stránky.<br />Program je schopný rozoznať <b>jazykové nastavenie</b> vášho prehliadača, takže väčšinou nie je dôvod meniť nastavenie tu.<br />Ale, keď má napríklad váš prehliadač nastavený ako implicitný jazyk angličtinu, ale vy chcete zobrazovať stránky v slovenčine alebo nemčine, potom to môžete zariadiť práve tu.<br />";
$pgv_lang["edituser_email_help"]		= "~#pgv_lang[emailadress]#~<br /><br />Vaša e-mailová adresa je pre nás samozrejme dôležitá kvôli možnosti vás kontaktovať.<br />Ak začnete používať inú e-mailovú adresu, napríklad pri zmene poskytovateľa, nezabudnite prosím zmeniť svoju adresu i tu.<br />Možno máte viacej e-mailových adries a správy od nás chcete dostávať na inú adresu, prosím zmenu urobte tu.<br />";
$pgv_lang["edituser_user_theme_help"]		= "~#pgv_lang[user_theme]#~<br /><br />K dispozícii máte niekoľko motívov.<br />Motív je súhrn nastavení vzhľadu jednotlivých prvkov na stránkach. S každým motívom uvidíte rovnaké dáta, ale vzhľad bude iný.<br />Je to podobné, ako by ste obrazu dali iný rám a zavesili ho v inej izbe. Obraz sa nezmenil, ale pozeráte sa teraz na neho úplne inak.<br />Len to skúste. Nastavte si iný motív. Prezrite si ho a skúste ďalší. Nakoniec nastavte ten, ktorý sa vám páčil najviacej.<br />Kedykoľvek sa prihlásite, program vám nastaví vami predvolený motív.<br />";
$pgv_lang["edituser_contact_meth_help"]		= "~#pgv_lang[user_contact_method]#~<br />Tento systém ponúka ďalšie možnosti zasielania správ<br />Spôsob kontaktu je nastavený administrátorom stránok, takže to nemôžete zmeniť.<br />Spôsob <b>prijímania</b> správ si však zmeniť môžete.<br />V súčasnosti si môžete vybrať zo štyroch možností.";
$pgv_lang["mail_option1_help"]			= "Ak zvolíte túto možnosť, bude sa k odosielaniu správ používať vstavaný systém PhpGedView bez použitia e-mailu.<br />Tak budete môcť dostávať iba <b>vnútorné správy</b> od ostatných uživateľov.<br />Keď vám niektorý z uživatelov pošle z týchto stránok správu, nájdete ju v bloku správ na svojej stránke MyGedView (ak ste tento blok zo svojej stránky neodstránili)<br />";
$pgv_lang["mail_option2_help"]			= "Táto voľba je rovnaká ako #pgv_lang[messaging]# z niečím naviac.<br />Kópia správy bude naviac poslaná na vašu e-mailovú adresu, ktorú ste u svojho účtu zadali.<br />Tento spôsob kontaktu je nastavený implicitne.<br />";
$pgv_lang["mail_option3_help"]			= "Ak je nastavená táto voľba, budete dostávať správy iba na svoju e-mailovú adresu.<br />Ostatný uživatelia sa s vami nebudú môcť spojiť cez vnútorný systém.<br />";
$pgv_lang["mail_option4_help"]			= "Táto voľba spôsobí, že nebudete dostávať žiadne správy.<br />";

//-- Add user
$pgv_lang["admin_help"]				= "Na tejto stránke sú všetky odkazy na konfiguračné súbory, administračné stránky, dokumentáciu a log súbory.<br /><br /><b>Systemový čas</b>, umiestnený hneď pod titulok stránky, ukazuje čas serveru, na ktorom sú vaše stránky umiestnené. Čas, ktorý vidíte, je čas otvorenia alebo obnovenia stránky.<br /><br /><b>VAROVANIE</b><br />Ak vidíte pod systémovým časom varovnú správu, znamená to, že do vášho súboru <b>config.php</b> je stále možné zapisovať!<br />Z <b>bezpečnostných dôvodov</b> by ste mali po dokončení konfigurácie stránok nastaviť práva súboru späť na \"iba na čítanie\".<br />To musíte urobiť <b>ručne</b>, pretože PhpGedView to zatiaľ nedokáže.<br /><br />Okrem volieb Readme, Uživateľský manuál a Log súbory získáte dalšiu nápovedu na zvolených stránkach.";
$pgv_lang["useradmin_help"]			= "~ADMINISTRÁCIA UŽIVATEĽOV~<br /><br />na tejto stránke môžete administrovať súčasných uživateľov a pridávať nových uživateľov.<br /><br /><b>Zoznam súčasných uživateľov</b><br />V tejto tabuľke sú zobrazený súčasný uživatelia, ich stav a ich práva.<br />Uživateľa môžete <b>mazať</b> alebo <b>upravovať</b>.<br /><br /><b>Pridať nový uživateľský formulár</b><br />Tento formulár je takmer zhodný s tým, ktorý poznáte z \"Váš účet\".<br />U niektorých predmetov sme nevytvárali špeciálnu nápovedu pre admina. V týchto prípadoch uvidíte nasledujúcu správu:";
$pgv_lang["useradmin_gedcomid_help"]		= "~ID V GEDCOMU~<br /><br />Toto ID musí nastaviť administrátor.<br />Tým bude ID spojené s osobou daného uživateľa.<br />To tiež umožní uživateľovi prístup do svojho <b>#pgv_lang[my_indi]#</b> a <b>#pgv_lang[my_pedigree]#</b>.<br /><br />Pre každý GEDCOM, ktorý v tomto programe používate, môžete nastaviť pre uživateľa jeho ID.<br />Ak uživateľ nie je v tomto GEDCOMe, necháte toto políčko prázdne.";
$pgv_lang["useradmin_rootid_help"]		= "~VÝCHODISKOVÁ OSOBA VÝVODU~<br /><br />V každom GEDCOM súbore môžete nastaviť ako <b>Východiskovú osobu</b> niektorého uživateľa.<br />Uživateľovi sa pravdepodobne bude páčiť spustenie programu so svojím vlastným vývodem, ale nie je to nutné.<br /><br />Uživateľ si toto nastavenie môže zmeniť vo svojom účte.";
$pgv_lang["useradmin_can_admin_help"]		= "~ZAŠKRTÁVACIE POLÍČKO - UŽIVATEĽ SMIE ADMINISTROVAŤ~<br /><br />ak bude toto políčko zaškrtnuté, bude mať uživateľ v tomto programe rovnaké práva ako vy.<dl><dt>Jediné, čo on/ona nebude môcť robiť je:</dt><dd>Pridávať / Odstraňovať / Upravovať uživateľov.</dd><dd>Posielať správy všetkým uživateľom naraz.</dd><dd>Upravovať uvítacie správy.</dd><dd>Upravovať a konfigurovať jazykové súbory.</dd><dt>Ale tiež:</dt><dd>Aktualizovať program.</dd><dd>Meniť nastavenie.</dd><dd>Aministrovať GEDCOMy.</dd><dd>Meniť nastavenie utajenia.</dd><dt>A nič ďalšieho, čo tu nie je zmienené.</dt><dd>Ale nie nastavenie vašich stránok - mimo tento program</dd></dl>";
$pgv_lang["useradmin_sync_gedcom_help"]		= "~#pgv_lang[sync_gedcom]# CHECK BOX~<br /><br />AK je tento check box zaškrtnutý a uživateľ má priradený záznam GEDCOM pomocou ID, tak zmeny účtu tohoto uživateľa budú automaticky synchronizované s jeho údajmi v GEDCOMe. To znamená že ked je upravený záznam tohoto uživateľa v GEDCOMe, niektoré informácie napríklad ako e-mailová  adresa a meno bude zkopírované do uživateľského účtu. Ak je upravený uživateľský účet, zodpovedajúce informácie budú zkopírované do Gedcom záznamu.";
$pgv_lang["useradmin_can_edit_help"]		= "~UŽIVATELSKÉ PRÁVA~<br /><br />Ku každému z GEDCOM súborov, dostupných v tomto systéme, môže mať uživateľ určité práva pre prístup a upravovanie.<br /><br />Ak je táto položka nastavená na <b>Žiadna</b>, znamená to, že uživateľ nemá prístup k utajeným údajom z tohoto GEDCOMu. Ak je táto položka nastavená na <b>Prístup</b>, potom tento uživateľ nemá právo upravovať alebo potvrdzovať úpravy urobené v databáze, ale má prístup k utajeným údajom.<br /><br />Ak zvolíte <b>Úpravy</b>, znamená to, že tento uživateľ môže upravovať informácie v databáze, ale iný uživateľ s právami <b>Potvrdzovanie</b> musí tieto zmeny potvrdiť skôr, než budú definitivne zapísané do databázy a zverejnené.<br /><br />Nastavenie na <b>Potvrdzovanie</b> umožní uživateľovi upravovať databázu a potvrdzovať zmeny urobené inými uživateľmi.<br /><br />Ak vyberiete možnosť <b>Spravovať GEDCOM</b>, umožníte tak uživateľovi naviac upravovať konfiguráciu a nastavenie utajenia tohoto GEDCOMu.<br /><br />Administrátori systému majú automaticky práva <b>Spravovať GEDCOM</b>.";
$pgv_lang["useradmin_verified_help"]		= "~UŽIVATEĽ POTVRDIL REGISTRÁCIU~<br /><br /><b>Automatická registrácia</b><br />Uživateľ môže požadovať zavedenie nového účtu pomocou modulu <b>automatickej registrácie</b>.<br />Ak tak urobí, potom obdrží e-mailom správu s odkazom na stránku, kde bude môcť svoju registráciu potvrdiť.<br />Ak tak už urobil, uvidíte zaškrtnuté políčko a budete môcť pristúpiť k ďalšiemu kroku: <b>Uživateľa povoliť adminom</b>.<br />Ak uživateľ registráciu nepotvrdil, mali by ste zo svojím povolením počkať.<br /><br /><b>Pridať uživateľa ručne</b><br />Ak použijete formulár k pridaniu uživateľa ručne, uvidíte toto políčko už zaškrtnuté.";
$pgv_lang["useradmin_verbyadmin_help"]		= "~POVOLENIE ADMINOM~<br /><br />Ak uživateľ použil modul automatickej registrácie a následne potvrdil registráciu, potom je váš súhlas posledným krokom pred aktivovaním účtu.<br /><br />Po tom, čo povolíte aktiváciu účtu, uživateľ obdrží e-mailom správu o tom, že jeho účet je aktívny a že sa môže prihlásiť so svojím uživateľským menom a heslem, ktoré použil, keď žiadal o zavedenie účtu.";
$pgv_lang["useradmin_edit_user_help"]		= "~AKTUALIZÁCIA UŽIVATEĽSKÉHO ÚČTU~<br /><br />Tento formulár používá admin k tomu, aby zmenil uživateľský účet.<br /><br />Formulár je podobný formuláru \"Pridať uživateľa\" alebo \"Môj účet\".";
$pgv_lang["useradmin_visibleonline_help"]	= "~VIDITELNÝ ONLINE~<br /><br />Ak je toto políčko zaškrtnuté, ostatný prihlásený uživatelia uvidia, či ste v daný okamžik online a vy uvidíte, či sú online ostatný. Ak nechcete, aby vás ostatný videli online, vyškrtnite toto políčko. Ale ani vy nebudete môcť zistiť, či sú ostatný uživatelia online.";
$pgv_lang["useradmin_editaccount_help"]		= "~UPRAVOVANIE ÚČTU~<br /><br />Ak je toto políčko zaškrtnuté, potom dotyčný uživatel bude môcť upravovať informácie o svojom účte. Ak nie je políčko zaškrtnuté, potom mu to nebude umožnené. To vám umožní vytvoriť jedno uživateľské meno a heslo pre viacej uživateľov a pritom nepripustiť, aby ktorýkoľvek z nich tento účet menil.";
$pgv_lang["useradmin_relation_priv_help"]	= "~#pgv_lang[user_relationship_priv]#~<br /><br />Ak je tento check box zaškrtnutý, uživateľ bude mať povolený prístup iba na žijúce osoby které sú s ním v príbuzenskom pomere. Bude môcť vidieť kohokoľvek v rámci nastavenie pásma príbuzných v <i>#pgv_lang[user_path_length]#</i>. Môžete požadovať nastavenie utajenia príbuzných nastavením globálnej voľby v nastavení GEDCOM utajenia.<br /><br />Toto nastavenie vyžaduje aby bol uživateľ asociovaný s GEDCOM ID predtým než bude môcť zobraziť ktorúkoľvek žijúcu osobu.<br /><br />";
$pgv_lang["useradmin_path_length_help"]		= "~#pgv_lang[user_path_length]#~<br /><br />Ak je povolené <i>#pgv_lang[user_relationship_priv]#</i>, tak tento uživateľ je schopný iba zobraziť, alebo editovať žijúce osoby v rámci zadaného rozsahu príbuzných.<br /><br />";
$pgv_lang["useradmin_auto_accept_help"]		= "~#pgv_lang[user_auto_accept]#~<br /><br />Zaškrtnutím tohoto boxu povolíte aby program automaticky akceptoval zmeny vykonané týmto uživateľomr. Uživateľ musí mať tiež oprávnenie akcetovať zmeny pre tento GEDCOM aby táto voľba bola funkčná.<br /><br />";
$pgv_lang["add_upload_gedcom_help"]		= "~PRIDÁVANIE versus NAHRÁVANIE GEDCOMOV~<dl><dt>Nahrávanie GEDCOM súborov</dt><dd>Nahrávanie súborov sa môže robiť online.<br />Súbor môžete nahrať z akéhokoľvek miesta, bez toho že by ste museli použiť ftp program.</dd><dt>Pridávanie GEDCOM súborov</dt><dd>Ak je váš súbor ešte stále vo vašej GEDCOM zložke (na servere), nemusíte ho opäť nahrávať.<br />Niekdy je potreba použiť možnosť Pridať miesto nahrať - to kvôli veľkosti súboru alebo limitom pre uploadovanie.</dd></dl>Obe procedúry (Pridať i Nahrať) sa dajú urobiť v 4 jednoduchých krokoch.<br />U oboch procedúr sa líši iba krok č. 1.<br />";
$pgv_lang["gedcom_configfile_help"]		= "~KONFIGURAČNÝ SÚBOR GEDCOMU~<br /><br />V tomto súbore sú uložené všetky základné nastavenia súboru GEDCOM.<br /><br />Na stránke administrácie GEDCOMu je v stĺpci \"Konfiguračný súbor\" zobrazená cesta a názov konfiguračného súboru.";
$pgv_lang["default_gedcom_help"]		= "~IMPLICITNÝ GEDCOM~<br /><br />Ak máte v programe viacej než 1 GEDCOM, môžete tu nastaviť, ktorý GEDCOM bude <b>implicitný</b>.<br /><br />Tj. ten GEDCOM, ktorý sa zobrazí všetkým návštevníkom, ktorý ešte nie sú prihlásený.<br /><br />Uživatelia si môžu vo svojom účte nastaviť ako implicitný ktorýkoľvek GEDCOM v programe.<br />";
$pgv_lang["delete_gedcom_help"]			= "~ZMAZANIE GEDCOMU~<br /><br />PhpGedView importuje záznamy zo súboru GEDCOM. Keď kliknete na <b>Zmazať</b>, program zmaže tie záznamy, ktoré boli importované z GEDCOMu.<br />Samotný súbor GEDCOM zostane v zložke, do ktorej bol nahraný.<br /><br />Ak budete chcieť neskoršie s týmto súborom opäť pracovať, nebudete ho musieť znovu nahrávať. Miesto toho môžete zvoliť možnosť <b>Pridať GEDCOM</b>.<br /><br />Po kliknutí na Zmazať budete musieť svoju voľbu <b>potvrdiť</b> v popup okne.";
$pgv_lang["add_gedcom_help"]			= "~PRIDANIE GEDCOMU~<br /><br />Keď použijete voľbu Pridať GEDCOM, predpokladá sa, že váš GEDCOM súbor je už nahraný na servere - <i>s využitím externého programu</i>, napríklad pre <b>ftp</b> alebo <b>sieťové</b> spojenie.<br />Ak ešte váš súbor GEDCOM nie je na servere, <b>musíte</b> ho pred pridávaním najskôr nahrať.<br /><br />Program vás povedie krok po kroku celou procedúrou.<br />";
$pgv_lang["add_new_gedcom_help"]		= "~VYTVORENIE NOVÉHO GEDCOMU~<br /><br />Máte možnosť vytvoriť úplne nový súbor GEDCOM.<br /><br />Tento proces môžete vykonať v niekoľko málo krokoch. Krok 1 sa od iných spôsobov pridávania a nahrávania, ktoré už poznáte, líši. Ostatné kroky sú podobné.<dl><dt>Krok 1: Pomenovanie nového GEDCOMu</dt><dd>Napíšte názov nového GEDCOMu bez prípony '.ged'. Súbor bude vytvorený v zložke, ktorej názov je zobrazený nad políčkom pre vloženie názvu.<br />Kliknite na <b>Pridať</b>.</dd><dt>Krok 2: Stránka konfigurácie.</dt><dd>Túto stránku už poznáte z konfigurácie GEDCOM súborov.</dd><dt>Krok 3: Validácia</dt><dd>Tiež tento krok je vám už iste známy. Nový GEDCOM bude prekontrolovaný.</dd><dt>Krok 4: Importovanie záznamov</dt><dd>Pretože budete importovať iba jeden záznam, tento krok prebehne veľmi rýchlo.</dd><dt>Vytváranie hotové.</dt><dd>Teraz môžete ísť na stránku s vývodom a uvidíte prvú osobu v GEDCOMe. Úpravy začnete kliknutím na meno osoby. Potom môžete k prvej osobe začať pridávať ďalšie osoby.</dd></dl>";
$pgv_lang["edit_gedcoms_help"]			= "~ADMINISTRÁCIA GEDCOMU~<br /><br />Stránka administrácie GEDCOMu je kontrolným centrom administrácie vašich <b>súčasných</b> a <b>nových</b> GEDCOM súborov.<br /><dl><b>SÚČASNÉ GEDCOMY</b><br /><dt>V tabuľke <b>Súčasné GEDCOMy</b> máte nasledujúce voľby:</dt><dd>Vymazať GEDCOM</dd><dd>Upraviť GEDCOM</dd><dl><dt>Upraviť utajenie</dt><dd>Upravenie utajenia je tiež súčasťou tejto tabuľky, pretože každý GEDCOM má svoj vlastný súbor s nastavením utajenia.</dd></dl><dd>Nastaviť implicitný GEDCOM</dd><dd>Importovať GEDCOM</dd><dd>Stiahnúť GEDCOM</dd><dt>sú tam 3 stĺpce s nasledujúcimi informáciami:</dt><dd>Súbor GEDCOM</dd><dd>Názov GEDCOMu</dd><dd>Konfiguračný súbor</dd></dl><dl><b>NOVÉ GEDCOM SÚBORY</b><dt>Na tejto stránke máte nasledujúce možnosti pridania <b>nových</b> alebo <b>existujúcich</b> GEDCOM súborov do systému.</dt><dd>Pridať GEDCOM</dd><dd>Nahrať GEDCOM</dd><dd>Vytvoriť nový GEDCOM</dd></dl>#pgv_lang[more_help]#<br />";
$pgv_lang["edit_config_gedcom_help"]		= "~KONFIGURÁCIA GEDCOMU~<br /><br />Každý GEDCOM, ktorý v tomto programe používate, má svoj vlastný <b>konfiguračný súbor</b>.<br /><br />V tomto formulári môžete zvoliť základné nastavenie ako napríklad: jazyk, formát kalendára, nastavenie e-mailu atd. adt.<br />";
$pgv_lang["import_gedcom_help"]			= "~IMPORTOVANIE GEDCOMU~<br /><br />Vo väčšine prípadov prebieha importovanie GEDCOMu v jednom kroku ako napríklad pridávanie alebo nahrávanie GEDCOMu.<br /><br />Tieto kroky sú usporiadané do logického sledu a musia byť dokončené, aby bolo možné s GEDCOMom pracovať.<br />V prípade, že ste túto procedúru nedokončili, uvidíte <b>varovnú</b> správu o tom, že GEDCOM zatiaľ nebol importovaný. V takom prípade kliknite na odkaz pre (znovu-)importovanie GEDCOM súboru.<br /><br /><b>Importovanie</b><br /><br />Konfiguračné nastavenie GEDCOMu sa re-importovaním nezmení.<br />Doterajšie údaje v databáze budú prepísané.";
$pgv_lang["upload_gedcom_help"]			= "~NAHRANIE GEDCOMU~<br /><br />Na rozdiel od možnosti \"Pridať GEDCOM\", v tomto prípade nemusíte mať ešte GEDCOM súbor na servere.<br /><br />V 1. kroku zvolte jeden GEDCOM súbor uložený na svojom (domácom) počítači. Do políčka napíšte celú cestu včetne názvu súboru alebo použijte tlačítko <b>Prechádzať</b>.<br /><br />Na ďalších stránkach nájdete v priebehu tohoto procesu ďalšiu nápovedu.<br />";
$pgv_lang["random_media_start_slide_help"]			= "~#pgv_lang[random_media_start_slide]#~<br /><br />Mal by spustit slideshow automaticky pri načítaní stránky.<br /><br />Slideshow mení obsah bloku bez nového načítania informácií zo serveru a bez nového načítania celej stránky.<br /><br />";
$pgv_lang["random_media_ajax_controls_help"]	= "~#pgv_lang[random_media_ajax_controls]#~<br /><br />Môžete použiť na nastavenia zobrazenia alebo ukrytia ovládacích prvkov slideshow v bloku náhodných médií.<br /><br />Tieto ovládače umožňujú užívateľom preskočiť na ďalší náhodný objekt alebo prehrávať náhodne vybrané médiá ako slideshow. Slideshow mení obsah bloku bez predchádzajúceho načítania informácií zo serveru a bez úplného načítania stránky.<br /><br />";
$pgv_lang["validate_gedcom_help"]		= "~VALIDÁCIA GEDCOMU~<br /><br />Validácia GEDCOMu, ktorý nahrávate alebo pridávate, je tretí krok procedúry, ktorá má zaistiť, že systém s vašim súborom bude vedieť správne pracovať.<br /><br />Program súbor skontroluje na správnosť použitia: datového formátu, formátu miest, znakovej sady a ďalších položiek.<br />Niektoré z týchto odchyliek, programom nájdených, budú automaticky opravené. Príkladom sú MacIntošove zakončenia riadkov a nesprávny formát miest.<br />V týchto prípadoch uvidíte správu o tom, že program zmenil dáta.<br />V prípade iných odchyliek sa objaví varovná správa s návrhom riešenia.<br /><br /><b>Voliteľné nástroje</b><br />V tejto chvíli sú k dispozícii ďalšie dva nástroje:<br /><b>Zmeniť i ID čísla osôb...</b> a <b>Nástroj pridania médií</b>.<br />Tento posledný nástroj je dostupný iba v režime <b>MySQL</b>. Ak máte uložený svoj GEDCOM v režime <b>Index</b>, táto voľba bude skrytá.<br /><br /><b>Ďalšia nápoveda</b> je k dispozícii vo formulári.#pgv_lang[more_help]#<br />";
$pgv_lang["convert_ansi2utf_help"]		= "~PREVEDENIE ANSI NA UTF-8~<br /><br />Aby program správne spracovával s vašími dátami, súbory by mali byť zapísané v kódovaní UTF-8.<br /><br />Väčšina genealogických programov vie GEDCOMy exportovat s týmto kódovaním (UTF-8).<br />Ak však váš program túto možnosť neponúka, môže to urobiť PhpGedView.<br /><br />Keď PhpGedview kontroluje nahraný (alebo pridaný) súbor, program zistí, či je súbor zapísaný v ANSI (kódovaní).";
$pgv_lang["detected_ansi2utf_help"]		= "~ROZOZNANÉ KÓDOVANIE ANSI~<br /><br />Súbor GEDCOM, ktorý práve prechádza kontrolou, je zapísaný v kódování ANSI.<br />Dôrazne doporučujeme, aby bolo kódovanie prevedené na UTF-8.<br /><br />#pgv_lang[convert_ansi2utf_help]#";
$pgv_lang["detected_date_help"]			= "~ROZOZNANÝ ZLÝ FORMÁT DÁTUMU:~<br /><b>FORMÁT DÁTUMU BUDE ZMENENÝ</b><br /><br />Štandardný formát dátumu programu PhpGedview a tiež podľa <b>štandardov GEDCOM 5.5</b> je: DD MMM YYYY (napr.: 01 JAN 2004)<br /><br />Ak uvidíte po skontrolovaní (validácii) svojho GEDCOMu správu o tom, že bol rozoznaný zlý formát dátumu, program prevedie dátumy do štandardného tvaru.<br /><br />Vy však máte možnosť zvoliť zobrazenie buď \"<b>deň</b> pred mesiacom\" (DD MMM YYYY), alebo \"<b>mesiac</b> pred dňom\" (MMM DD YYYY).<br />Doporučujeme ponechať navrhnuté nastavenie na prvej možnosti.";
$pgv_lang["addmedia_tool_help"]			= "~NÁSTROJ PRE PRIDANIE MÉDIÍ~<br />Iba v režime MySQL</b><br /><br />Nástroj Pridanie médií bol navrhnutý pre uživateľov, ktorých genealogický program neexportuje GEDCOMy s odkazmi na médiá. Tým je dobre známy napr. Family Tree Maker. <br /><br />Nástroj Pridanie médií vám umožňuje uchovávať zoznam odkazov na mediálne súbory mimo súbore GEDCOM a oddelene od normálnych tabuliek PhpGedView. Pretože sú dáta uchovávané v samostatnej tabuľke, stačí ich zadať iba raz. Tým sa administrátorom zjednodušuje práca s genealogickými dátami v ich klasickom programe, exportovanie nového súboru GEDCOM a následné spúšťanie nástroja Pridanie médií pre tento súbor ako súčasť importu, takže sa im pridajú rovnaké odkazy na obrázky vždy, keď vytvoria nový GEDCOM.<br /><br />Ak chcete používať nástroj Pridanie médií, najskôr vytvorte zoznam mediálnych položiek vyplnením políčok a kliknutím na tlačítko Pridať média pre každú mediálnu položku, ktorú chcete začleniť do svojho GEDCOMu. Políčko \"#pgv_lang[gedcomid]#\" obsahuje ID GEDCOM záznamu, ku ktorému chcete obrázok pridať, napr. I100. Do políčka \"Externý súbor\" napíšte názov súboru (obrázku), ktorý chcete použiť. Do políčka \"#pgv_lang[extension]#\" zadajte príponu súboru. Políčko \"#pgv_lang[highlighted]#\" použijte pre označenie, či je daný obrázok pre danú osobu primárny (uprednostňovaný). Primárny obrázok sa zobrazí vedľa mena osoby na stránke s osobnými údajmi. Do políčka \"#pgv_lang[title]#\" doplňte popisok k danému obrázku. Políčko \"#pgv_lang[order]#\" použijte pre špecifikovanie poradia, v ktorom sa majú obrázky objaviť v tabuľke obrázkov danej osoby. A konečne políčko \"#pgv_lang[gedcom_file]#\" hovorí, pre ktorý GEDCOM je obrázok určený. To vám umožní použiť obrázok pre viacej GEDCOMov.<br /><br />Keď je zoznam hotový, kliknite na tlačítko \"#pgv_lang[click_to_add_media]#\", aby sa dáta uložili do GEDCOM súboru. Keď budete nabudúce aktualizovať svoj GEDCOM, bude stačiť, keď spustíte nástroj Pridanie médií a stisknete toto tlačítko.<br /><br />";
$pgv_lang["change_indi2id_help"]		= "~ZMENIŤ ID OSOBY NA ....~</b><br /><br />Tento nástroj bol navrhnutý pre uživateľov, ktorých genealogický program používa pri každom exporte iné GEDCOM ID. Napríklad, keď je GEDCOM exportovaný prvýkrát, ID osoby je I100, ale pri ďalšom exporte má osoba ID I234. Tieto zmeny ID čísiel značne komplikujú administráciu PhpGedView, pretože podľa ID sa vytvárajú odkazy na osoby.<br /><br />Ale väčšina genealogických programov používa ako jednoznačné identifikátory tagy RIN alebo REFN. Tento nástroj prepíše ID všetkých osôb hodnotami, ktoré určíte. Môžete zvoliť medzi RIN alebo REFN.<br /><br />";
$pgv_lang["edit_privacy_help"]			= "Na tejto stránke môžete vybrať nastavenie utajenia pre zvolený GEDCOM (ak ich máte viacej).<br />Pod titulkom stránky si môžete overiť, či upravujete správny súbor utajenia.<br />Je tam zobrazené niečo takého: (cesta/nazovvashogedcomu_priv.php)<br /><br />Ak potrebujete zmeniť nejaké ďalšie nastavenia, môžete tak urobiť ručne v súbore utajenia. Viacej sa o tom dozviete na internetových stránkach projektu PhpGedView.<br />";
$pgv_lang["invalid_header_help"]		= "~NEPLATNÁ HLAVIČKA GEDCOM~<br />Súbor GEDCOM musí začínať riadkom 0 HEAD. PhpGedView zistilo, že váš GEDCOM súbor týmto riadkom nezačína. Potom, čo kliknete na tlačítko Pokračovať, všetky riadky pred riadkom 0 HEAD budú z GEDCOMu odstránené.<br /><br />Táto chyba väčšinou znamená to, že váš genealogický program nevytvoril správny súbor GEDCOM alebo tento súbor nie je súborom GEDCOM. Mali by ste si overiť, či ste na server pridali správny súbor GEDCOM a či začína riadkom 0 HEAD a končí riadkom 0 TRLR.";
$pgv_lang["macfile_detected_help"]		= "~ROZOZNANÝ SÚBOR PRE MACINSTOSH~<br />PhpGedView zistilo, že váš súbor GEDCOM bol vytvorený na počítači Macintosh. Súbory pre Macintosh obsahujú iné ukončenie riadkov (r) než Unix (n) alebo Windows (rn). Funkcie PHP, ktoré používa systém PhpGedView, vie pracovať iba zo súbormi pre Unix alebo DOS. Keď kliknete na tlačítko Pokračovať, váš súbor bude prevedený na súbor pre DOS.<br />";
$pgv_lang["cleanup_places_help"]		= "~OPRAVA MIEST~<br />PhpGedView zistilo že vo vašom súbore GEDCOM sú miesta priradené k údajom, kde by podľa špecifikácie nemali byť. Takéto súbory vytvára mnoho genealogických programov, ako napr. Family Tree Maker. PhpGedView s týmito súbormi vie pracovať, ale niektoré nesprávne zaradené miesta sa zobrazí ve vašej hierarchii miest. <br /><br />Napríklad, váš GEDCOM môže obsahovať nasledujúci záznam<br />1 SSN<br />2 PLAC 123-45-6789<br />Podľa špecifikácie GEDCOM by tento údaj mal byť zobrazený ako<br />1 SSN 123-45-6789<br />Ak zvolíte Ano, PhpGedView automaticky vyhľadá a opraví všetky tieto chyby v zakončení.<br />";
$pgv_lang["empty_lines_detected_help"]		= "~NÁJDENÉ PRÁZDNE RIADKY~<br />PhpGedView zistilo, že vo vašom GEDCOMe sú prázdne riadky. Tieto riadky môžu spôsobiť chyby, a preto budú odstránené ešte pred importom GEDCOMu.<br />";
$pgv_lang["skip_cleanup_help"]			= "~PRESKOČENIE ČISTENIA~<br />Je veľmi doporučené povoliť PhpGedView pred importovaním opraviť váš GEDCOM súbor. Ak sa tak nestane, niektoré funkcie možno nebudú pracovať správne.<br /><br />Ale, ak chcete, môžete kliknúť na toto tlačítko, súbor sa nebude opravovať a bude naimportovaný tak, ako je.<br />";
$pgv_lang["help_editconfig.php"]		= "~KONFIGURÁCIA PhpGedView~<br /><br />Na tejto stránke musíte v prípade, že ste práve nainštalovali PhpGedView na svoj server a prvý krát ho spúšťate, zvoliť globálne nastavenie programu.<br />#pgv_lang[review_readme]#<br /><br />Pretože toto nastavenie je <b>globálne</b>, platí pre celý program a pre všetky GEDCOMy v ňom používané.<br />Pre každý GEDCOM si však môžete vytvoriť vlastné nastavenie.<br />Pretože sa nachádzate na stránke Konfigurácia, môžete kliknúť na odkaz pre administráciu GEDCOMov (hneď nad formulárom).<br />Na všetkých ostatných stránkach nájdete tento odkaz v menu, pod ikonou MyGedView.";
$pgv_lang["help_edit_merge.php"]		= "~#pgv_lang[merge_records]#~<br /><br />Táto stránka vám umožňuje zlúčiť dva GEDCOM záznamy v tom istom GEDCOM súbore.<br /><br />To je veľká pomoc pre uživateľov, ktorý zlúčili viacej GEDCOM súborov a teraz majú veľa duplicitných záznamov osôb, rodín a zdrojov.<br /><br />Postup zlúčenia má tri kroky.<br /><ol><li>Zadajte dva GEDCOM ID. ID <u>musia</u> byť rovnakého typu. Nemôžete zlúčiť osobu s rodinou a rodinu so zdrojom, napríklad.<br />Do poľa <b>#pgv_lang[merge_to]#</b> zadajte ID výsledného záznamu.<br />Do poľa  <b>#pgv_lang[merge_from]#</b> zadajte ID záznamu z ktorého chcete data vložiť do záznamu #pgv_lang[merge_to]#. Tento záznam bude po zlúčení zmazaný.</li><br /><li>Vyberte z oboch záznamov údaje, ktoré chcete zlúčiť. Jednoducho kliknite na zaškrtávacie políčko vedľa údaja.</li><br /><li>Môžete si prezrieť výsledok zlúčenia ako i ďalšie zmeny, ktoré ste urobili online.</li></ol>Niekto s oprávnením autorizácie musí vaše zmeny akceptovať.</li></ul><br />";

//-- Download GEDCOM
$pgv_lang["download_gedcom_help"]		= "~STIAHNUTIE GEDCOMU~<br /><br />Zo svojich stránok si môžete stiahnúť GEDCOM.<br /><br />Na stránke \"Stiahnutie GEDCOMu\", máte možnosť zmeniť kódovanie z <b>UTF-8</b> na <b>ANSI (ISO-8859-1)</b>.<br />Výber formátu závisí na tom, v akom programe potom chcete zo súborom pracovať.<br />Ak si nie ste istý, nahliadnite do dokumentácie k danému programu.";

//-- GDBI Changes

//-- Language Editor
$pgv_lang["help_reportengine.php"]		= "~SPRÁVY~<br />Nástroj pre vytváranie správ v PhpGedView používa šablony XML pre automatické generovanie PDF správ. Správy dostupné zo zoznamu, sú generované zo správ nájdených v zložke \"reports\". Keď zvolíte správu, ktorá sa má vytvoriť, budete požiadaný o informácie špecifické pre daný typ správy, napr. východiskovú osobu alebo rodinu a či sa majú zobraziť fotky. Ak máte všetko zvolené kliknite na tlačítko \"#pgv_lang[download_report]#\", ak chcete správu rovno stiahnúť na svoj disk.<br /><br />Môžete si vytvoriť vlastný typ správy tak, že vytvoríte kópiu niektorého zo súborov s XML šablonou a upravíte ho. Túto novú šablonu potom vložte do zložky \"reports\". PhpGedView ju sám nájde a zaradí ju do rolovacieho menu pre výber správy.";
$pgv_lang["def_pdf_format_help"]		= "~PDF FILE FORMAT~<br />Generátor reportov PhpGedView vytvára stiahnuteľné reporty v Adobe&reg; PDF formáte. GEDCOM 5.5.1 Standard špecifikácia, uvádzaná na viacerých miestach tejto Nápovedy, je tiež stiahnuteľná ako PDF súbor. PDF je skratka pre <b>P</b>ortable <b>D</b>ocument <b>F</b>ormat.<br /><br />PDF súbory nie sú zobraziteľné pomocou štandardného software vo vašom PC. Ak už máte Acrobat Reader inštalovaný (je často súčasťou SW balíčkov), nemusíte ho aktualizovat pre spracovanie reportov generovaných PhpGedView.<br /><br />Acrobat Reader, program na zobrazenie a tlač týchto súborov je dostupný zdarma. Free Adobe&reg; Acrobat Reader môžete stiahnúť zo stránky <a href=\"http://www.adobe.com\" target=_blank><b>Adobe Systems Inc.</b></a>. Kopie \"Acrobat Reader\" môžete nájsť i na iných stránkach, ale my dôrazne doporučujeme použiť <u>iba</u> stránku Adobe Systems Inc.<br /><br />Acrobat Reader je použiteľný pre mnoho rôznych systémov, včetne Microsoft&reg; Windows a Apple&reg; Macintosh, v mnohých jazykoch. Ak máte Windows 95, musíte stiahnúť Acrobat Reader verziu 5.0.5. Novšie verzie ako je táto nie je možné korektne inštalovať pod systémom Windows 95.<br /><br />";
$pgv_lang["help_ahnentafel.xml"]		= "~#pgv_lang[ahnentafel_report]#~<br />Toto je správa vybranej osoby a jej predkov zobrazená vo formáte brožúry. Začíná vybranou osobou a pokračuje jej rodičmi, starými rodičmi, prarodičmi atd.<br /><br />Poznámka: ahnentafel je v súčasnosti dostupný iba v anglickej verzii.<br /><br />";
$pgv_lang["help_birthlist.xml"]			= "~#pgv_lang[birth_report]#~<br />S týmto reportom si môžete zobraziť zoznam všetkých osôb, ktoré sa narodili v určitý čas, alebo na určitom mieste.<br /><br />";
$pgv_lang["help_relativelist.xml"]		= "~#pgv_lang[relatives_report]#~<br />Táto správa zobrazí zoznam všetkých príbuzných vybranej osoby. Môžete vybrať ktorý príbuzný budú zobrazený.<ul><li><b>#pgv_lang[child-family]#</b> zobrazí zvolenú osobu, jej rodičov a jej bratov a sestry.</li><li><b>#pgv_lang[spouse-family]#</b> zobrazí zvolenú osobu, jej partnerov a ich deti.</li><li><b>#pgv_lang[direct-ancestors]#</b> zobrazí osobu jej rodičov, starých rodičov, prastarých rodičov a tak ďalej celý strom všetkých rodičov tejto osoby v celej línii.</li><li><b>#pgv_lang[ancestors]#</b> zobrazí zoznam všetkých osôb z #pgv_lang[direct-ancestors]# ale obsahuje aj strýkov a tety a prastrýkov a pratety, tiež obsahuje súrodencov všetkých predkov v tejto rodovej línii. Neobsahuje ale deti súrodencov (sestranice a bratrancov).</li><li><b>#pgv_lang[descendants]#</b> zobrazí pre všetky tieto osoby ich potomkov (deti, vnukov, pravnukov, atd.).</li><li><b>#pgv_lang[all]#</b> táto voľba je kombináciou #pgv_lang[descendants]# a #pgv_lang[ancestors]# v jednej správe.</li></ul><br /><br />";
$pgv_lang["help_xml_reports"]			= "~REPORTY~<br />Nástroj pre vytváranie správ v PhpGedView používa šablony XML pre automatické generovanie PDF správ. Správy dostupné zo zoznamu <b>#pgv_lang[select_report]#</b>, sú generované XML súborov nájdených v zložke \"reports\". Keď zvolíte správu, ktorá sa má vytvoriť, budete požiadaný o informácie špecifické pre daný typ správy, napr. východiskovú osobu alebo rodinu a či sa majú zobraziť fotky. Ak máte všetko zvolené kliknite na tlačítko \"#pgv_lang[download_report]#\", ak chcete správu rovno stiahnúť na svoj disk.<br /><br />Môžete si vytvoriť vlastný typ správy tak, že vytvoríte kópiu niektorého zo súborov s XML šablonou a upravíte ho. Túto novú šablonu potom vložte do zložky \"reports\". PhpGedView ju sám nájde a zaradí ju do rolovacieho menu pre výber správy.";

//-- Help Contents
$pgv_lang["help_contents_head_help"]		= "<b>OBSAH NÁPOVEDY</b><br /><br />";
$pgv_lang["help_contents_gedcom_info"]		= "GEDCOM info";
$pgv_lang["help_contents_gedcom_places"]	= "Miesta v GEDCOMe";
$pgv_lang["admin_help_contents_head_help"]	= "<b>OBSAH NÁPOVEDY<br /><br />POLOŽKY ADMINISTRÁTORSKEJ NÁPOVEDY</b> boli pridané na začiatok zoznamu.<br /><br />";
$pgv_lang["ah2_help"]				= "_Konfigurácia PhpGedView";
$pgv_lang["ah3_help"]				= "_GEDCOM: Pridanie x Nahranie";
$pgv_lang["ah4_help"]				= "_GEDCOM: Konfiguračný súbor";
$pgv_lang["ah5_help"]				= "_GEDCOM: Implicitný";
$pgv_lang["ah6_help"]				= "_GEDCOM: Zmazanie";
$pgv_lang["ah7_help"]				= "_GEDCOM: Pridanie";
$pgv_lang["ah8_help"]				= "_GEDCOM: Vytvorenie nového";
$pgv_lang["ah9_help"]				= "_GEDCOM: Stiahnutie";
$pgv_lang["ah10_help"]				= "_GEDCOM: Stránka administrácie";
$pgv_lang["ah11_help"]				= "_GEDCOM: Konfigurovanie";
$pgv_lang["ah12_help"]				= "_GEDCOM: Importovanie";
$pgv_lang["ah13_help"]				= "_GEDCOM: Nahranie";
$pgv_lang["ah14_help"]				= "_GEDCOM: Skontrolovanie";
$pgv_lang["ah15_help"]				= "_GEDCOM: Prevod z ANSI na UTF-8";
$pgv_lang["ah16_help"]				= "_GEDCOM: Nastavenie utajenia";
$pgv_lang["ah17_help"]				= "_Administrácia uživateľov";
$pgv_lang["ah18_help"]				= "_Administrácia";
$pgv_lang["ah19_help"]				= "_GEDCOM: Nástroj médií";
$pgv_lang["ah20_help"]				= "_GEDCOM: Zmena ID osôb na .......";
$pgv_lang["ah21_help"]				= "_Jazykové súbory";
$pgv_lang["ah23_help"]				= "_Konfigurácia podporovaných jazykov";
$pgv_lang["ah24_help"]				= "_Uživateľské informácie - presun (Index -->> SQL)";
$pgv_lang["ah25_help"]				= "_PhpGedView záloha";
$pgv_lang["ah26_help"]				= "_FAQ zoznam: Editácia";
$pgv_lang["manage_media_help"]			= "~#pgv_lang[manage_media]#~<br /><br />Toto je druhý krok v riadení nahrávania mediálnych súborov keď máte nakonfigurované adresáre v default adresári médií.<br /><br />Ako uživateľ s administrátorskými právami môžete vytvoriť štruktúru adresárov v ktorej budete ukladať mediálne súbory. Založenie adresárov z tejto stránky zabezpečí, že adresáre s náhľadmi obrázkov budú založené so zodpovedajúcimi súbormi index.php v každom adresári.<br /><br />Môžete presúvať súbory medzi adresármi pomocou linku Presunúť do --> link. Náhľady sú tiež presunuté tak aby štruktúra súborov zostala zhodná.<br /><br />Ak ste neurobili načítanie súborov s náhľadmi alebo ste zabudli zaznačiť checkbox <b>#pgv_lang[gen_thumb]#</b> v priebehu načítania, máte možnosť vytvoriť náhľady tu. Označte box <b>#pgv_lang[show_thumbnail]#</b>; ak náhľad nebol nájdený môžete kliknúť na link <b>#pgv_lang[gen_thumb]#</b> a vytvoriť ho.<br /><br />";
$pgv_lang["simple_filter_help"]			= "~#pgv_lang[filter]#~<br /><br />Jednoduchý vyhľadávací filter založený na vložených znakoch, globálne vyhľadávacie znaky (tzv. wildcards - * ?) nie sú akceptované.<br /><br />";
$pgv_lang["show_thumb_help"]			= "~#pgv_lang[show_thumbnail]#~<br /><br />Náhľady budú zobrazené, ak zaškrtnete tento check box.<br /><br />";
$pgv_lang["new_dir_help"]			= "~#pgv_lang[add_directory]#~<br /><br />Ak uživateľ s právami administrátora môžete vytvoriť adresárovú štruktúru v ktorej chcete ukladať vaše mediálne súbory. Vytvorenie adresárov z tejto stránky zaručí, že adresáre z náhľadmi obrázkov sú založené súčasne so zodpovedajúcimi súbormi index.php v každom adresári.<br /><br />Kliknite na link a vložte meno adresára, ktorý chcete založiť.<br /><br />";
$pgv_lang["find_media_help"]			= "~#pgv_lang[find_media]#~<br /><br />Umožňuje vám prechádzať štruktúru súborov a vyhľadať položky médií, ktoré chcete priradiť.<br /><br />";
$pgv_lang["alive_in_year_help"]			= "~#pgv_lang[alive_in_year]#~<br /><br />Táto voľba vám umožní zobraziť osoby žijúce v zadanom roku.<br /><br />Ak máte pre osobu vyplnený rok narodenia a úmrtia, a zadaný rok spadá do tohoto obdobia, osoba je označená ako žíjúca v tomto roku. <br /><br />Vložte iný rok a kliknite na tlačítko <b>Zobraziť</b> ku zobrazeni osôb žijúcich v tomto roku. Zbytok stránky funguje rovnako ako Zoznam osôb.<br /><br /><br />";
$pgv_lang["year_help"]				= "~#pgv_lang[alive_in_year]#~<br /><br />Vložte rok, pre ktorý chcete vyhľadať ľudí žijúcich v tomto roku.<br /><br />";
$pgv_lang["help_repolist.php"]			= "~#pgv_lang[repo_list]#~<br /><br />Na tejto stránke je zobrazený zoznam prameňov.<br /><br /> Mená prameňov su triedené abecedne.<br /><br /><b>PRAMENE</b><br />Bez prameňov nemôžete budovať svoju databázu. To je zdroj všetkých informácií uložených v databáze, a tieto zdroje sú uložené v prameňoch. Pramene môžu byť archívy a to ako súkromné tak i verejné, verejné databázy, štátne alebo cirkevné matriky, informácie z Internetu a pod. Pre prístup k zdrojom musíte vedieť kde a v akej forme sú uložené. Všetky potrebné informácie, ktoré ste našli v prameňoch musia byť uložené v záznamoch Prameňov v databáze.<br /><br />Prameň môže byť zviazaný z mnohými zdrojmi.<br /><br />";
$pgv_lang["help_repo.php"]			= "~#pgv_lang[repo_info]#~<br /><br />Tu su zobrazené detailné informácie o Prameni. Spoločne zo Zdrojmi sú Pramene najdôležitejšie zdroje informácií pre genealogické bádanie. Pomocou presných informácií Zdrojov a Prameňov budete môcť sledovať cesty ďalších bádateľov pri vyhľadávaní informácií. Mali by ste byť schopný nájsť rovnaké informácie ako oni.<br /><br />Na tejto stránke môžete vidieť údaje o Prameni ako titul, adresu, e-mail, internetovú stránku.<br /><br />Za detailnými informáciami o Prameni je zoznam všetkých Zdrojov spojených s týmto Prameňom. To vám umožňuje vidieť všetky informácie získaných z jednotlivého Prameňa.<br /><br />Ak to je povolené administrátorom stránky, uvidíte jednu alebo dve ikony na tejto stránke:<br /><b>#pgv_lang[view_gedcom]#</b>, ktorá zobrazí informácie v GEDCOM formáte, <br /><b>#pgv_lang[add_to_cart]#</b>, ktorá vám umožní uložiť tieto informácie do  #pgv_lang[clip_cart]#. Odtial môžete stiahnuť informácie do  GEDCOM súboru a importovať do vašeho vlastného genealogického programu.<br /><br />#pgv_lang[context_help]#<br /><br />";
$pgv_lang["delete_repo_help"]			= "~#pgv_lang[delete_repo]#~<br /><br />Ak kliknete na túto voľbu, označíte tento Prameň na zmazanie.<br /><br />Čo to znamená?<br />Predpokladajme, že máte dobrý dôvod k zmazaniu prameňa z databázy. Kliknite na link. Budete vyzvaný k potvrdeniu požiadavku. Ak budete pokračovať uvidíte za chviľku správu, že prameň bol zmazaný.<br /><br />Ak budete pokračovať v práci s rodokmeňom, zistíte, že prameň je naďalej vidieť ako keby nebol zmazaný.<br /><br /><b>To <u>nie je</u> chyba.</b> Administrátor stránky dostane správu o zmene v databáze a potom zmaže prameň.<br />Administrátor môže akceptovať alebo zamietnuť váš požiadavok. Až po akceptovaní administrátorom bude váš požiadavok na zmazanie <br /><u>nevratne</u> vykonaný. V prípade nejakej pochybnosti o vašom požiadavku vás bude administrátor kontaktovať.<br /><br />";
$pgv_lang["show_repo_gedcom_help"]		= "~#pgv_lang[view_gedcom]#~<br /><br />Ak kliknete na tento link, zobrazia sa vám v novom okne informácie o prameni, ktorý je uložený vo vašej databáze.<br /><br />";
$pgv_lang["add_repository_clip_help"]		= "~#pgv_lang[add_to_cart]#~<br /><br />Ak kliknete na tento link, môžete pridať prameň, ktorý je uložený vo vašej databáze, do vášho #pgv_lang[clip_cart]#.<br /><br />";
$pgv_lang["repolist_listbox_help"]		= "~#pgv_lang[repo_list]#~<br /><br />V tomto boxe vidíte zobrazené mená prameňov uložených v tejto databáze.<br /><br />Mená súzobrazené v abecednom poriadku.<br /><br />Ak kliknete na meno v zozname, dostanete sa na stránku #pgv_lang[repo_info]#, kde môžete vidieť zoznam zdrojov pripojených k tomuto prameňu.<br /><br />";
$pgv_lang["repos_listbox_help"]			= "~#pgv_lang[other_repo_records]#~<br /><br />V tomto boxe vidíte zobrazené mená zdrojov, ktoré sú zviazané z prameňmi.<br /><br />Mená sú zobrazené v abecednom poriadku.<br /><br />Ak kliknete na meno v zozname, otvoríte si detailné zobrazenie zdroja.<br /><br />";
$pgv_lang["block_move_up_help"]			= "~Presun položiek zoznamu~<br /><br />Použite toto tlačítko ku zmene poradia položiek zoznamu. Bloky budú zobrazené v poradí v akom su zoradené na zozname.<br /><br />Označte položku ktorú chcete presunúť a potom kliknite na tlačítko šípky hore alebo dole.<br /><br />";
$pgv_lang["help_faq.php"] 			= "~FAQ - Často sa opakujúce otázky~<br />#pgv_lang[text_faq_help]#<br />";
$pgv_lang["text_faq_help"] 			= "FAQ (Frequently Asked Questions) stránka obsahuje prehľad otázok a odpovedí k tejto genealogickej stránke.<br /><br /> Použitie stránky FAQ nastavuje výhradne administrátor. Administrátor nastavuje obsah položiek a tiež poradie v ktorom sa zobrazujú na stránke.";
$pgv_lang["hs_title_help"] 			= "<center>~#pgv_lang[hs_title]#~</center><br />#pgv_lang[hs_intro]#<br /><br />#pgv_lang[hs_keyword_advice]#<br /><br />#pgv_lang[hs_searchhow_advice]#<br /><br />#pgv_lang[hs_searchin_advice]#";
$pgv_lang["hs_searchin_advice"]		= "~#pgv_lang[hs_searchin]#~<br />Tu určíte rozsah hľadania.<br /><br />Administrátorovia majú možnosť hľadať v Uživateľskej nápovede alebo v Nápovede konfigurácie, prípadne v oboch. Uživatelia túto možnosť nemajú, pretože nemajú prístup na žiadnu funkčnosť konfigurácie, preto môžu hľadať iba v Uživateľskej nápovede.<br /><br />Súbory nápovedy neobsahujú iba nápovedu ale tiež určité textové reťazce používané vo formulároch a ďalších materiáloch. Táto voľba vám dáva možnosť určiť či bude prehľadávaný celý súbor nápovedy, alebo či bude prehľadávaný iba text nápovedy.<br />";
$pgv_lang["edit_NCHI_help"]			= "~#factarray[NCHI]#~<br /><br />Vložte počet detí tejto osoby, alebo rodiny. Toto je nepovinné pole.<br /><br />|";
$pgv_lang["edit_TIME_help"]			= "~#factarray[TIME]#~<br /><br />Vložte čas pre túto udalosť v 24-hodinovom formáte s vedúcimi nulami. Polnoc je 00:00. Príklad: 04:50 13:00 20:30.<br /><br />";
$pgv_lang["edit_NOTE_help"]			= "~#factarray[NOTE]#~<br /><br />Poznamky sú neformatované texty, ktoré sa zobrazia na stránke v sekcii Detail udalosti.<br /><br />";
$pgv_lang["edit_CEME_help"]			= "~#factarray[CEME]#~<br /><br />Vložte meno cintorína, alebo miesta odpočinku, kde je osoba pochovaná.<br /><br />";
$pgv_lang["edit_ASSO_help"]			= "~#factarray[ASSO]#~<br /><br />Vložte GEDCOM ID príbuzného.<br /><br />";
$pgv_lang["edit_RELA_help"]			= "~#factarray[RELA]#~<br /><br />Vyberte názov vzťahu zo zoznamu. Výber <b>Dedko</b> znamená: <i>Tento príbuzný je dedkom tejto osoby</i>.<br /><br />";
$pgv_lang["help_hourglass.php"]			= "~#pgv_lang[hourglass_chart]#~<br /><br />Schéma presýpacích hodín zobrazí predkov a potomkov zvolenej východiskovej osoby v jednej schéme. Táto schéma je spojením Vývodu a Rozrodu.<br /><br />Východisková osoba je umiestnená v strede stránky a jej potomkovia sú zobrazený vľavo a predkovia vpravo. Na tomto pohľade je každá generácia zoradená naprieč stránkou počínajúc najmladšou a končiac najstaršou.<br /><br />";
$pgv_lang["help_familybook.php"]		= "~#pgv_lang[familybook_chart]#~<br /><br />Táto schéma ja velmi podobná schéme presýpacích hodín. Zobrazuje predkov a potomkov zvolenej východiskovej osoby v jednej schéme. Tiež zobrazuje potomkov východiskovej osoby v formáte schémy presýpacích hodín.<br /><br />Východisková osoba je umiestnená v strede stránky, jej potomkovia sú zobrazený vľavo a predkovia vpravo. V tomto zobrazení sú všetky generácie zoradené naprieč stránkou počínajúc najstaršou a končiac najmladšou.<br /><br />Všetci potomkovia východiskovej osoby sa stávajú východiskovou osobou dodatočných schém presýpacích hodín, ktoré sú zobrazené na tej istej stránke. Tento proces sa opakuje v závislosti na hodnote parametru počet generácií potomkov, zadanom na výberovej obrazovke.";
$pgv_lang["fambook_descent_help"]		= "~#pgv_lang[descent_steps]#~<br /><br />Táto hodnota určuje počet generácií potomkov východiskovej osoby, ktoré budú samostatne zobrazené vo forme schémy presýpacích hodín.<br /><br />";
$pgv_lang["show_spouse_help"]			= "~#pgv_lang[show_spouses]#~<br /><br />Implicitne táto schéma nezobrazuje partnerov potomkov, pretože zobrazenie je potom neprehľadné a nezrozumiteľné. Zapnutím tejto voľby zobrazíte partnerov v tejto schéme.<br /><br />";
$pgv_lang["reorder_families_help"]		= "~#pgv_lang[reorder_families]#~<br /><br />Rodiny na záložke #pgv_lang[relatives]# sú zobrazené v takom poradí v akom boli zadané do záznamu osoby v GEDCOMe. Rodiny nie sú zoradené podľa dátumu sňatku pretože často je neznámy, ale poradie sňatkov <u>známe je</u>.<br /><br />Táto voľba vám umožňuje zmeniť poradie rodín, ktoré sú zobrazené na záložke #pgv_lang[relatives]#. Ak chcete triediť rodiny podľa dátumu ich sňatku, kliknite na tlačítko, ktoré tu je a triedenie bude prebiehať automaticky.<br /><br />";
$pgv_lang["import_marr_names_help"]		= "~#pgv_lang[import_marr_names]#~<br /><br />Ak vyberiete možnosť importovať mená žien po sňatku PhpGedView bude kontrolovať záznamy žien vo vašom GEDCOM súbore a automaticky generovať pole s menom po sňatku v ich zázname v GEDCOM súbore. Mená sú generované z mien manželov posledného manželstva. Toto vám umožní hľadať tieto ženy podľa ich mena po sňatku alebo podľa rodného mena.<br /><br />Táto voľba vám umožňuje zobraziť  meno po sňatku na stránke osoby a zozname osôb ak povolíte voľbu <b>#pgv_lang[SHOW_MARRIED_NAMES]#</b> v nastavení konfigurácie GEDCOMu.<br /><br />";
$pgv_lang["edit_TYPE_help"]			= "~#factarray[TYPE]#~<br /><br />Pole #factarray[TYPE]# umožňuje špecifikovať uživateľskú udalosť. Je to volne definovateľné pole, do ktorého možete zapísať ľubovolný text.<br /><br />";
$pgv_lang["edit_TEMP_help"]			= "~#factarray[TEMP]#~<br /><br />Pre LDS obrad, toto pole odsahuje údaj o chráme kde bol obrad vykonaný.<br /><br />";
$pgv_lang["edit_STAT_help"]			= "~#factarray[STAT]#~<br /><br />Toto je nepovinné pole zo stavom používané hlavne pre LDS obrady tak ako prebiehaju v TempleReady programe.<br /><br />";
$pgv_lang["edit__PRIM_help"]			= "~#factarray[_PRIM]#~<br /><br />Použite toto pole k označeniu, že táto mediálna položka je primárna, alebo zdôraznená, pre osobu ku ktorej je priradená. Zvýraznený obrázok bude použitý v schémach a na individuálnej stránke osoby.<br /><br />";
$pgv_lang["edit__THUM_help"]			= "~#factarray[_THUM]#~<br /><br />Toto je uživateľské PhpGedView pole, ktoré vám umožní špecifikovať zvýraznený obrázok pre použitie v schémach i keď náhľad pre obrázok neexistuje.<br /><br />";
$pgv_lang["edit_TITL_help"]			= "~#factarray[TITL]#~<br /><br />Vložte titulok položky ktorú práve editujete. Ak je to titulok pre multimediálnu položku, vložte popisný titulok ktorý bude identifikovať ktorému uživateľovi (osobe) patrí.<br /><br /><br />";
$pgv_lang["edit_FILE_help"]			= "~#factarray[FILE]#~<br /><br />Toto je najdôležitejšie pole v zázname multimediálneho objektu. Označuje ktorý súbor sa používa. Musíte zadať minimálne meno súboru. V závislosti na vašom nastavení môžu byť užitočné i informácie o uložení súboru.<br /><br />Môžete použiť link <b>#pgv_lang[find_media]#</b> pre nájdenie súborov, ktoré už boli načítané na stránku.<br /><br />#pgv_lang[readme_help]#<br /><br />";
$pgv_lang["edit_FORM_help"]			= "~#factarray[FORM]#~<br /><br />Toto je voliteľné pole ktoré môže byť použité na vloženie formátu multimediálneho objektu. Niektoré genealogické programy môžu brať v úvahu toto pole pri spracovaní objektu. Avšak, pretože média nie je možné prenášať medzi počítačovými systémami príliš dobre, toto pole nie je veľmi dôležité.<br /><br />";
$pgv_lang["generate_thumb_help"]		= "~VYTVORIŤ NÁHĽADY~<br /><br />Zistili sme, že váš systém má možnosť automaticky generovať náhľady z niektorých typov obrázkov. Napríklad pre JPG, GIF, a PNG súbory. Typy, ktoré váš systém podporuje, sú zobrazené vedľa checkboxu.<br /><br />Zaznačením tohoto boxu, signalizujete systému, že ste načítali obrázky tohoto typu a chcete skúsiť generovať pre ne náhľady. Ponechajte checkbox nezaznačený ak chcete načítať vaše vlastné náhľady.<br /><br />";
$pgv_lang["edit_add_NOTE_help"]			= "~#pgv_lang[add_note]#~<br /><br />Táto sekcia vám umožňuje pridať novú Poznámku k udalosti, ktorú práve editujete. Je to volne definovateľné pole, do ktorého možete zapísať ľubovolný text.<br /><br />";
$pgv_lang["edit_add_SOUR_help"]			= "~#pgv_lang[add_source]#~<br /><br />Táto sekcia vám umožňuje pridať novú citáciu zdroja k udalosti, ktorú práve editujete.<br /><br />Do poľa Zdroj vložte ID príslušného zdroja. Kliknite na link <b>#pgv_lang[create_source]#</b> ak potrebujete založiť nový zdroj. Do poľa Detail citácie môžete vložiť číslo stránky zdroja, alebo inú informáciu, ktorá môže pomôcť komukoľvek nájsť informáciu v zdroji. Do poľa Text môžete vložiť opis textu zo zdroja.<br /><br />";
$pgv_lang["edit_add_ASSO_help"]			= "~#pgv_lang[add_asso]#~<br /><br />#pgv_lang[add_asso]# umožní vám spojiť nejakú udalosť s nejakou pridruženou osobou. To je jeden zo spôsobou ako vy môžete zaznamenať napríklad to, že niekto je dedkom nejake inej osoby.<br /><br />";
$pgv_lang["edit_QUAY_help"]			= "~#factarray[QUAY]#~<br /><br />Môžete použiť toto pole k vyjadreniu kvality, alebo spoľahlivosti údajov nájdených v tomto zdroji. Mnoho genealogických aplikácií na to používa čísla. <b>1</b> môže znamenať, že údaje sú kvalitné, <b>2</b> môže znamenať, že údaje sú menej kvalitné, <b>3</b> môže znamenať, že údaje sú nespoľahlivé.<br /><br />";
$pgv_lang["edit_PAGE_help"]			= "~#factarray[PAGE]#~<br /><br />V poli Detail citácie môžete uložiť číslo stránky, alebo nejakú inú informáciu, ktorá môže niekomu pomôcť nájsť informáciu v zdroji.<br /><br />";
$pgv_lang["edit_TEXT_help"]			= "~#factarray[TEXT]#~<br /><br />Do tohoto pole môžete vložiť text citácie z tohoto zdroja. Napríklad to môže byť prepis textu zo zdroja, alebo popis toho čo bolo v citácii.<br /><br /><br />";
$pgv_lang["edit_SOUR_help"]			= "~#factarray[SOUR]#~<br /><br />Toto pole vám umožní zmeniť  záznam o zdroji z ktorého je táto citácia. Pole obsahuje ID zdroja. Vedľa pola je zobrazený názov aktuálneho zdroja. Použite link <b>#pgv_lang[find_id]#</b> k vyhľadaniu ID zdroja. Ak chcete odstrániť citáciu, vymažte odsah poľa.<br /><br />";
$pgv_lang["edit_edit_raw_help"]			= "~#pgv_lang[edit_raw]#~<br /><br />Táto stránka vám umožňuje editovať priamo záznam v GEDCOMe. Používajte túto stránku opatrne, vyžaduje to dobru znalosť štandardu GEDCOM 5.5.1. Pre ďalšie informácie o GEDCOM 5.5.1 štandarde sa môžete podívať na heslo nápovedy <b>GEDCOM súbor</b>.<br /><br />PhpGedView poskytuje veľa možností ako pridať a editovať informácie, ale môžete mať dôvod editovať priamo záznam GEDCOMu. Obvykle by ste mali používať štandardné formuláre na pridávanie informácií, ale ak to nieje možné môžete použiť i tento formulár. Po uložení formulára budú vaše údaje skontrolované na zhodu s GEDCOM štandardom a následne bude aktualizovaný záznam CHAN.<br /><br />";
$pgv_lang["add_from_clipboard_help"]		= "~#pgv_lang[add_from_clipboard]#~<br />PhpGedView vám umožňuje kopírovať udalosti do schránky. Môžete zkopírovať až 5 udalostí a uložiť ich do schránky. Z rozbalovacieho menu Pridať novú udalosť môžete zvoliť voľbu Vložiť a vložiť jedenu z udalostí do záznamu osoby. To je veľmi užitočná funkcia na vkladanie rovnakých udalostí, ako napríklad sčítanie ľudu, pre veľa osôb.<br /><br />";
$pgv_lang["edit_PLAC_help"]			= "#factarray[PLAC]#~<br /><br />Miesta musia byt zapisovane podľa genealogického štandardu. V genealógii sú miesta zaznamenávané s najdôležitejšou informáciou na prvej pozícii až po nejmenej dôležitejšiu informáciu na poslednej pozícii, na oddelenie rôznych úrovní miest sa používa čiarka. Úroveň by mala zodpovedať úrovni miesta podľa hierarchie cirkve alebo štátu a odkazovať na miesto kde sú uchované dôležité záznamy.<br /><br />Napríklad miesto ako Salt Lake City má byť zaznamenané ako \"Salt Lake City, Salt Lake, Utah, USA\".<br /><br />Vysvetlime si každú časť tohoto záznamu. Prvá časť, \"Salt Lake City,\" je mesto alebo mestská štvrť, kde sa udalosť stala. V niektorých krajinách môže byť ešte samosprávna obec, alebo mestský obvod. V tom prípade musia byť pred mestom. Ďalšia časť, \"Salt Lake,\" je kraj. \"Utah\" je štát, a \"USA\" je krajina (republika). Je dôležité zaznamenať každé miesto, lebo genealogické záznamy sú uchovávané úradmi na všetkých úrovniach.<br /><br />Ak je úroveň miesta neznáma, vynechajte ho a nechajte medzeru medzi čiarkami. Predpokladajme, že pre vyššie uvedený príklad ste nevedeli kraj pre Salt Lake City. Záznam by vyzeral takto: \"Salt Lake City, , Utah, USA\". Predpokladajme, že viete iba to, že osoba sa narodila v Utahu. V tom prípade by záznam vyzeral takto: \", , Utah, USA\". <br /><br />Môžete použiť link <b>#pgv_lang[find_place]#</b> pre nájdenie miesta ak už existuje v databáze.<br /><br />";
$pgv_lang["edit_add_parent_help"]		= "~PRIDAŤ NOVÚ MATKU ALEBO OTCA~<br /><br />Táto stránka vám umožňuje pridať novú matku alebo otca pre vybranú osobu. Vyplňte pre novú osobu meno a dátum narodenia a úmrtia ak ich poznáte. Ak neviete ďalšie údaje ponechajte polia prázdne.<br /><br />Ak chcete pridať ďalšie udalosti okrem dátumu narodenia a úmrtia uložte najskôr novú osobu do databázy. Potom otvorte stránku Rodina alebo záložku #pgv_lang[relatives]# na stránke #pgv_lang[indi_info]#. Na stránke #pgv_lang[indi_info]# môžete pridať ďalšie detailné informácie.<br /><br />";
$pgv_lang["edit_add_spouse_help"]		= "~PRIDAŤ NOVÉHO MANŽELA ALEBO MANŽELKU~<br /><br />Na tejto stránke môžete pridať nového manžela alebo manželku vybranej osobe. Vyplňte pre novú osobu meno a dátum narodenia a úmrtia ak ich poznáte. Ak neviete ďalšie údaje ponechajte polia prázdne.<br /><br />Ak chcete pridať ďalšie udalosti okrem dátumu narodenia a úmrtia uložte najskôr novú osobu do databázy. Potom otvorte stránku Rodina alebo záložku #pgv_lang[relatives]# na stránke #pgv_lang[indi_info]#. Na stránke #pgv_lang[indi_info]# môžete pridať ďalšie detailné informácie.<br /><br />";
$pgv_lang["edit_death_help"] 			= "~#pgv_lang[death]#~<br /><br />Táto oblasť vám umožňuje vložiť informácie o úmrtí. Najskôr vyplňte dátum kedy osoba zomrela v štandardnom formáte dátumu pre genealógiu (1 JAN 2004). Môžete kliknúť na ikonu kalendára a dátum vybrať. Potom vyplňte miesto kde osoba zomrela. Ak miesto existuje v databáze, môžete použit na vyhľadanie link <b>#pgv_lang[find_place]#</b>.<br /><br />";
$pgv_lang["edit_birth_help"] 			= "~#pgv_lang[birth]#~<br /><br />Táto oblasť vám umožňuje vložiť informácie o narodení. Najskôr vyplňte dátum kedy sa osoba narodila v štandardnom formáte dátumu pre genealógiu (1 JAN 2004). Môžete kliknúť na ikonu kalendára a dátum vybrať. Potom vyplňte miesto kde sa osoba narodila. Ak miesto existuje v databáze, môžete použit na vyhľadanie link <b>#pgv_lang[find_place]#</b>.<br /><br />";
$pgv_lang["edit_sex_help"]			= "~#pgv_lang[sex]#~<br /><br />Vyberte zodpovedajúce pohlavie zo zoznamu. <b>Neznáme</b> indikuje, že pohlavie osoby nám nieje známe.<br /><br />";
$pgv_lang["edit_name_help"]			= "~#pgv_lang[name]#~<br /><br />Toto je najdôležitejšie pole v zázname Meno osoby. Malo by byť vyplnené automaticky keď vyplňujete ďalšie polia, ale môžete editovať údaje podľa vlastného uváženia. Meno je pole ktoré musí byť vyplnené podľa  GEDCOM 5.5.1 štandardu s priezviskom uzavretým lomítkami \"/\". Napríklad meno \"John Robert Finlay Jr.\" musí byť vyplnené takto: \"John Robert /Finlay/ Jr.\".<br /><br />";
$pgv_lang["edit_suffix_help"]			= "~#pgv_lang[suffix]#~<br /><br />Do tohoto nepovinného poľa môžete vložiť príponu k menu osoby. Príklady prípon mien sú \"St.\", \"Ml.\", \"III\" atd.<br /><br />";
$pgv_lang["edit_surname_help"]			= "#pgv_lang[surname]#~<br /><br />Do tohoto poľa vložte priezvisko tejto osoby. Napríklad, pre meno \"John Robert Finlay\",  priezvisko ktoré môžete sem vložit je \"Finlay\"<br /><br />";
$pgv_lang["edit_NICK_help"]			= "~#factarray[NICK]#~<br /><br />Do tohoto poľa môžete vložiť prezývku (nicknames) osoby.<br />Toto pole je nepovinné.<br /><br />Ako pridať prezývky:<ul><li>Vyberte <b>Upraviť meno</b> potom vložte prezývku a uložte záznam</li><li>Vyberte <b>Pridať nové meno</b> potom vložte ďalšiu prezývku A MENO a uložte záznam </li><li>Vyberte<b>Upraviť GEDCOM záznam</b> pre pridanie viacerých [2&nbsp;NICK] záznamov podriadených hlavnému záznamu [1&nbsp;NAME].</li></ul>";
$pgv_lang["edit_given_name_help"]		= "~#pgv_lang[given_name]#~<br /><br />Do tohoto poľa vložte krstné meno tejto osoby. Napríklad, pre meno \"John Robert Finlay\",  krstné meno ktoré môžete sem vložit je \"John Robert\"<br /><br />";
$pgv_lang["edit_NPFX_help"]			= "~#factarray[NAME]# #factarray[NPFX]#~<br /><br />Toto nepovinné pole môžete použiť na zadanie titulu, napríklad \"Dr.\" or \"ing.\"<br /><br />";
$pgv_lang["edit_add_child_help"]		= "~#pgv_lang[add_child]#~<br /><br />Táto stránka vám umožňuje pridať nové dieťa pre vybranú rodinu. Vyplňte pre nové dieťa meno a dátum narodenia a úmrtia ak ich poznáte. Ak neviete ďalšie údaje ponechajte polia prázdne.<br /><br />Ak chcete pridať ďalšie údaje okrem dátumu narodenia a úmrtia uložte najskôr nové dieťa do databázy. Potom otvorte stránku Rodina alebo záložku #pgv_lang[relatives]# na stránke #pgv_lang[indi_info]#. Na stránke #pgv_lang[indi_info]# môžete pridať ďalšie detailné informácie.<br /><br />";
$pgv_lang["review_changes_help"]		= "~NEAKCEPTOVANÉ ZMENY~<br /><br />Tento blok zobrazuje zoznam záznamov, ktoré boli zmenené v režime online a doteraz neboli zkontrolované a akceptované pre zápis do databázy.<br /><br /><br />";
$pgv_lang["quick_update_name_help"] 		= "~AKTUALIZÁCIA MENA~<br /><br />Použite polia \"Aktualizácia mena\" ku zmene mena osoby, ktorú práve editujete. Do poľa Rodné meno zadajte rodné meno (prvé meno) osoby. Do poľa Priezvisko zadajte priezvisko (druhé meno) osoby. Napríklad ak je meno ktoré chcete napísať \"John Robert Finlay\" tak vložte \"John Robert\" od poľa rodné meno a \"Finlay\" do poľa priezvisko.<br /><br />Vyplnenie týchto polí <u>zmení</u> meno osoby; nebude pridané nové meno.<br /><br /><i>Poznámka: <u>nepoužívajte</u> tento postup na zmenu mena ak vkladáte záznam o novom sňatku. Naopak, použijte túto voľbu k založeniu nového manžela.</i><br /><br />";
$pgv_lang["quick_update_fact_help"] 		= "~AKTUALIZÁCIA UDALOSTI~<br /><br />Použite polia \"Aktualizácia udalosti\" ku zmene informácií o udalosti alebo zmene existujúcej udalosti pre osobu ktorú editujete. Najskôr vyberte udalosť zoz zoznamu. Potom vložte dátum kedy sa udalosť stala v štandardnom formáte pre genealógiu (1 JAN 2004). Môžete kliknúť na ikonu kalendára a vybrať datum. Potom vložte miesto kde sa udalosť stala. Môžete použiť link  <b>#pgv_lang[find_place]#</b> pre výber miesta ak existuje v databázer.<br /><br />Tak ako všetky ďalšie polia tohoto formulára, vaše údaje prepíšu už existujúce alebo založia nové podľa požiadavku.<br /><br />";
$pgv_lang["quick_update_photo_help"] 		= "~AKTUALIZÁCIA FOTOGRAFIE~<br /><br />Použite polia \"Aktualizácia fotografie\" k načítaniu obrázku pre osobu ktorú práve editujete. Do poľa Titulok napíšte výstižný popis pre obrázok, napríklad ako \"John Finlay 2004\". Potom kliknite na tlačítko <b>Zobraziť</b> pre nájdenie obrázku vo vašom PC. Ak osoba ktorú editujete už má obrázok, môžete pomocou zaškrtávacieho políčka určiť či chcete obrázok prepísať alebo pridať nový.<br /><br />";
$pgv_lang["quick_update_address_help"] 		= "~AKTUALIZÁCIA ADRESY~<br /><br />Použijte pole \"Aktualizácia adresy\" ku zmene adresy, čísla telefónu, alebo e-mail adresu osoby, ktorú práve editujete.<br /><br />Tak ako všetky polia na tomto formulári, vaše informácie prepíšu už existujúce, alebo založia nové záznamy podľa požiadavku.<br /><br />";
$pgv_lang["quick_update_spouse_help"] 		= "~PRIDAŤ NOVÉHO MANŽELA ALEBO MANŽELKU~<br /><br />Použite toto pole ak chcete pridať nového manžela alebo manželku osobe ktorú práve upravujete. Vyplňte pre nového partnera meno a dátum narodenia a potom zadajte dátum sňatku. Dátum zadajte v štandardnom formáte pre genealógiu (1 JAN 2004). Môžete kliknúť na ikonu kalendára a dátum vybrať. Môžete použiť link <b>#pgv_lang[find_place]#</b> na vyhľadanie miesta ak existuje v databáze. br /><br />Toto pole je iba na pridanie <i>nového</i> partnera, nie je na aktualizáciu údajov už existujúceho. Pre aktualizáciu údajov niekoho, kto už je založený v databáze, zatvorte toto okno a kliknite na meno osoby v záložke #pgv_lang[relatives]#. Potom kliknite na voľbu Upraviť v menu.<br /><br />";
$pgv_lang["quick_update_marriage_help"] 	= "~AKTUALIZOVAŤ SŇATOK~<br /><br />Môžete použiť toto pole súčasne s poľom na pridanie nového manžela alebo manželky ak chcete založiť nový záznam o sňatku. Inak údaje vložené do tohoto poľa zmenia informácie o poslednom sňatku tejto osoby. Vložte dátum v štandardnom formáte pre genealógiu (1 JAN 2004). Môžete kliknúť na ikonu kalendára a vybrať dátum. Môžete použiť link <b>#pgv_lang[find_place]#</b> pre vybranie miesta ak existuje v databáze.<br /><br />";
$pgv_lang["quick_update_child_help"] 		= "~PRIDAŤ NOVÉ DIEŤA~<br /><br />Použijte toto pole na pridanie nového dieťaťa pre túto osobu. Najskôr zadajte meno dieťaťa a vyberte pohlavie. Potom vložte dátum a miesto narodenia. Dátum vložte v štandardnom formáte pre genealógiu (1 JAN 2004). Môžete kliknúť na ikonu kalendára a dátum vybrať. Ak miesto narodenia existuje v databáze môžete použiť link <b>#pgv_lang[find_place]#</b> k výberu miesta zo zoznamu.<br /><br />Toto pole pole je iba pre pridanie <u>nového</u> dieťaťa. Neumožňuje aktualizovať údaje pre už existujúci záznam. Pre aktualizáciu údajov niekoho kto už existuje v databáze, zatvorte toto okno a kliknite na jeho meno v záložke #pgv_lang[relatives]#. Potom kliknite na voľbu Upraviť v menu.<br /><br />";
$pgv_lang["index_top10_pageviews_help"]		= "~BLOK NAJČASTEJŠIE ZOBRAZENÝCH POLOŽIEK~<br /><br />Tento blok zobrazuje zoznam Top 10 osôb, rodín, alebo zdrojov ktoré boli zobrazené návštevníkmi týchto stránok. Pre zobrazenie tohoto bloku musí administrátor stránok zapnúť počitadlo prístupov k položkám.<br /><br />";
$pgv_lang["useradmin_user_default_tab_help"]	= "~NASTAVENIE IMPLICITNÝCH ZÁLOŽIEK UŽIVATEĽA~<br /><br />Umožňuje vám definovať, ktoré záložky budú zobrazené automaticky keď otvoríte stránku #pgv_lang[indi_info]#. Ak máte povolené editovať tento účet možete si zmeniť toto nastavenie.<br /><br />";
$pgv_lang["edituser_user_default_tab_help"]	= "~NASTAVENIE IMPLICITNÝCH ZÁLOŽIEK UŽIVATEĽA~<br /><br />Umožňuje vám definovať, ktoré záložky budú zobrazené automaticky keď otvoríte stránku #pgv_lang[indi_info]#.<br /><br />";
$pgv_lang["reorder_children_help"]		= "~PRETRIEDIŤ DETI~<br /><br />Deti sú zobrazené  v poradí v akom boli zadané do záznamu o rodine. Deti nie sú zoradené podľa dátumu narodenia, pretože často nie je známy, ale podľa poradia ich narodenia ktoré <u>známe je</u>.<br /><br />Táto voľba vám umožňuje zmeniť poradie v ktorom sú zobrazené deti v GEDCOM zázname o rodine. Ak chcete odteraz zoradit deti podľa ich dátumu narodenia, kliknite na tlačítko ktoré tu je umiestnené a triedenie bude prebiehať automaticky.<br /><br />";
$pgv_lang["rss_feed_help"]			= "~NASTAVENIE RSS~<br /><br />RSS správy dostupné v  PhpGedView vám umožnia vidieť dôležité novinky z vašej úvodnej stránky pomocu vašeho obľúbeného prehliadača RSS bez toho aby ste museli navštíviť internetové stránky rodokmeňa. Väčšina prehliadačov zobrazí upozornenie ak sa niečo zmenilo na stránke. To vám v podstate umožní sledovať stránky PhpGedView bez pravidelnej návštevy. V bloku RSS správy, nastavujete pripojenie k správam, umožňuje vám tiež definovať typ správy (väčšina prehliadačov most môže pracovať s väčšinou typov, takže môžete ponechať implicitné nastavenie), a špecifikovať modul pre vaše správy. Jazyk správy bude totožný z aktívnym jazykom stránky PhpGedView  v momente ked nastavujete RSS. Typy správ ktoré môžu byť generované sú RSS 0.92, RSS 1.0, RSS 2.0, ATOM, HTML a JavaScript. Prvé 4 typy sú pre prehliadače RSS správ, zatiaľ čo  JavaScript a HTML sú určené pre umožnenie zaradenia správ do iných web stránok.<br /><br />Poznámka: rôzne čísla verzií RSS správ označuje rôzne druhy a nie rozne verzie.<br /><br />";
$pgv_lang["edit_SEX_help"]			= "~Edit #factarray[SEX]#~<br /><br />Použite toto pole na špecifikáciu či je osoba <b>#pgv_lang[male]#</b> alebo <b>#pgv_lang[female]#</b>. Vyberte <b>#pgv_lang[unknown]#</b> iba v prípade ak nie ste si istý pohlavím osoby.";
$pgv_lang["edit_NAME_help"]			= "~Edit #factarray[NAME]#~<br /><br />Mená by mali byť napísané s lomítkami \"/\" uzatvárajúcimi priezvisko.<br /><br />Vezmite v úvahu následujúci príklad:<ul><li>Krstné meno /Priezvisko/</li><li>Krstné meno /Priezvisko/ ml.</li><li>Krstné meno /von Priezvisko/ jr.</li></ul>";
$pgv_lang["edit_add_unlinked_person_help"]	= "~#pgv_lang[add_unlinked_person]#~<br /><br />Použijte tento formulár na pridanie nezávislej osoby.<br /><br />Ak pridáte nezávislú osobu do vášho rodokmeňa, táto osoba nebude mať žiadny vzťah k ostatným osobám až dokiaľ ho nevytvoríte. Neskoršie môžete vytvoriť vzťah medzi osobami z tabuľky #pgv_lang[relatives]# na stránke #pgv_lang[indi_info]#.";
$pgv_lang["edit_URL_help"]			= "Vložte URL adresu včetne http://.<br /><br />Ako je napríklad táto: <b>http://www.phpgedview.net/</b> Ponechajte pole prázdne ak nechcete zadať URL.";
$pgv_lang["edit_EMAIL_help"]			= "Vložte e-mailovú adresu.<br /><br />Ako je napríklad táto: <b>name@hotmail.com</b> Ponechajte toto pole prázdné ak nechcete zadať e-mailovú adresu.";
$pgv_lang["edit_FAX_help"]			= "Vložte číslo FAXu včetne kódu štátu a oblasti.<br /><br />Ponechajte toto pole prázdné ak nechcete zadať číslo FAXu. Napríklad číslo pre Nemecko môže byť +49 25859 56 76 89 a číslo pre USA môže byť +1 888 555-1212.";
$pgv_lang["edit_PHON_help"]			= "Vložte telefónne číslo včetne kódu štátu a oblasti.<br /><br />Ponechajte toto pole prázdné ak nechcete zadať číslo telefónu. Napríklad číslo pre Nemecko môže byť +49 25859 56 76 89 a číslo pre USA môže byť +1 888 555-1212.";
$pgv_lang["edit_ADDR_help"]			= "Vložte do tohoto poľa poštovú adresu presne v tom tvare v akom ju chcete tlačiť na obálku.<br /><br />Ponechajte toto pole prázdne ak nechcete zadať adresu.";
$pgv_lang["edit_GIVN_help"]			= "#pgv_lang[edit_given_name_help]#";
$pgv_lang["edit_SPFX_help"]			= "~Prefix Priezviska~<br /><br />Vložte, alebo vyberte zo zoznamu prefix, ktorý je umiestnený pred hlavnou časťou priezviska. Napríklad <b>von</b> Braun, <b>van der</b> Kloot, <b>de</b> Graaf, atd.";
$pgv_lang["edit_SURN_help"]			= "#pgv_lang[edit_surname_help]#";
$pgv_lang["edit_NSFX_help"]			= "#pgv_lang[edit_suffix_help]#";
$pgv_lang["edit__MARNM_help"]			= "~#factarray[_MARNM]#~<br /><br />Vložte meno po sobáši pre túto osobu, použite rovnaké formátovacie pravidlá ako pre pole Meno. Toto pole je nepovinné.<br /><br />Napríklad ak sa Mary Jane Brown vydá za Johna White, môžete vložiť (samozrejme bez uvodzoviek)<ul><li>Americká  verzia:&nbsp;&nbsp;\"Mary Jane Brown /White/\"</li><li>Európska verzia:&nbsp;&nbsp;\"Mary Jane /White/\"</li><li>Alternatívna Európska verzia:&nbsp;&nbsp;\"Mary Jane /White-Brown/\" alebo \"Mary Jane /Brown-White/\"</li></ul>Toto môžete urobiť iba ak si Mary Brown zmenímeno po sobáši s Johnom White. Na niektorých miestach, napríklad v Quebecu (Canada), je nelegálne zmeniť meno týmto spôsobom.<br /><br />Muži niekedy zmenia svoje meno po sobáši, najčastejšie použijú formu /Brown-White/ ale občas prevezmú priezvisko manželky.";
$pgv_lang["context_help"]			= "Ďalšiu nápovedu získate kliknutím na <b>?</b> vedľa textu na stránke.";
$pgv_lang["register_gedcomid_help"]		= "~#pgv_lang[gedcomid]#~<br /><br />Každá osoba v databáze má unikátny ID kód. Ak poznáte svoje ID, prosím vložte ho sem. Ak ho nepoznáte, alebo ho nemozete vyhľadať z dôvodu nastavenia utajenie, napíšte do poľa Komentáre dostatok informácií, ktoré pomôžu administrátorovi identifikovať kto ste a aké máte ID. Toto ID vám potom nastaví administrátor.<br /><br /><br />";
$pgv_lang["register_comments_help"]		= "~#pgv_lang[comments]#~<br /><br />Použijte toto pole k tomu, aby ste administrátorovi zdôvodnili prečo žiadate o založenie uživateľského účtu a aký je váš vzťah k rodokmeňu zobrazenému na tejto stránke. Tiež môžete napísať ďaľšie informácie potrebné administrátorovi.<br /><br />";
$pgv_lang["utf8_ansi_help"]			= "~KONVERZIA Z UTF-8 NA ANSI~<br /><br />Pre optimálne zobrazenie na internete, používa PhpGedView sadu znakov UTF-8. Niektoré programy, napríklad Family Tree Maker, nepodporujú import súborov GEDCOM kódovaných v UTF-8. Označte tento check box ak chcete zkonvertovať súbor z <b>UTF-8</b> na <b>ANSI (ISO-8859-1)</b>.<br /><br />Formát ktorý potrebujete, je závislý na programe v ktorom chcete pracovať z downloadovaným GEDCOM súborom. Ak nie ste si istý formátom, overte kódovanie v dokumentácii použitého programu.<br /><br />Pozor. Ak chcete ponechať špeciálne znaky nezmenené, musíte súbor ponechať v kódovaní UTF-8 a zmeniť spôsob spracovania týchto znakov vo vašom programe nejakým iným spôsobom. Poraďte sa s dodávateľom, alebo autorom programu.<br /><br /> ";
$pgv_lang["remove_tags_help"]			= "~ODSTRÁNIŤ UŽIVATEĽSKÉ PGV TAGY~<br /><br />Výberom tejto voľby odstránite uživateľské TAGy, ktoré mohli byť pridané k záznamom PhpGedView.<br /><br />Uživaťeľské tagy použité PhpGedView včetne <b>_PGVU</b> tagu, identifikujúceho uživateľa , ktorý zmenil záznam v režime online a <b>_THUM</b> tagu ktorý určuje pre PhpGedView ktorý obrázok bude použitý ako náhľad.<br /><br />Uživateľské tagy môžu spôsobiť chybu pri importe stiahnutého GEDCOMu do iných genealogických programov.<br /><br />";
$pgv_lang["download_zipped_help"]		= "~NAČÍTAŤ GEDCOM AKO ZIP SÚBOR~<br /><br />Ak zvolíte túto možnosť, zkopírovaný súbor GEDCOM bude komprimovaný do formátu ZIP než začne načítanie. To podstatne redukuje jeho veľkosť, ale budete musieť použiť kompatibilný Unzip program (WinZIP, napríklad) na dekomprimovanie preneseného GEDCOM súboru, než ho budete môcť použiť.<br /><br />Toto je užitočná voľba pre načítanie veľkých GEDCOM súborov. Je tu riziko, že čas načítania nekomprimovaného súboru prekročí maximálny povolený čas, dôsledkom toho by bol nekompletný import súboru. Voľba ZIP môže zredukovať čas načítania o  75%.<br /><br />";
$pgv_lang["remember_me_help"]			= "~ULOŽIŤ V TOMTO POČÍTAČI~<br /><br />Zaškrtnutím tohoto boxu pro prihlasovaní povolíte PhpGedView uložiť vaše prihlasovacie údaje a pri ďalšej návšteve sa nebudete musieť prihlasovať. Táto voľba vyžaduje aby boli povolené cookies vo vašom prehliadači.<br /><br />Pri ďalšom vstupe na stránku budete mať prístup na osobné údaje a uživateľské stránky, ale z dôvodu zabezpečenia budete požiadaný o zadanie uživateľského mena a hesla pri pokuse editovať, alebo administrovať stránky.<br /><br /><b>Neoznačujte tento box ak sa prihlasujete z verejného počítača, alebo počítača ktorý používate spoločne z inými uživateľmi; ktokoľvek by sa mohol prihlásiť do PhpGedView pod vaším uživateľom a heslom.</b>";
$pgv_lang["edit_add_unlinked_source_help"]	= "~#pgv_lang[add_unlinked_source]#~<br /><br />Použite tento link na pridanie nového zdroja do vašej databázi bez odkazu na citáciu alebo iný záznam. Nový zdroj bude zobrazený v zozname zdrojov, ale nebude zobrazený v žiadnej schéme ani kdekoľvek inde v programe pokiaľ nebude vytvorený odkaz na citáciu zdroja.";
$pgv_lang["link_person_id_help"]		= "~#pgv_lang[label_local_id]#~<br /><br />Do tohoto poľa vložte  ID osoby s ktorou ste spojený (napr. I100).";
$pgv_lang["link_gedcom_id_help"]		= "~#pgv_lang[label_gedcom_id]#~<br /><br />Použite túto sekciu k výberu alternatívneho databázového identifikátora ktorý obsahuje osobu s ktorou ste spojený.";
$pgv_lang["add_gedcom_instructions"]		= "Zadajte meno súboru pre tento nový GEDCOM. Gedcom súbor bude vytvorený v Index adresári: #INDEX_DIRECTORY#";
$pgv_lang["import_options_help"] 	= "Môžete vybrať dodatočné voľby, ktoré budú použité pri importe GEDCOMu.";
$pgv_lang["verify_gedcom_help"]	= "Tu môžete zvoliť buď pokračovanie v načítaní a importe tohoto GEDCOMu alebo prerušenie načítania a importu.";
$pgv_lang["clear_cache_help"]		= "~#pgv_lang[clear_cache]#~<br /><br />Za účelom zlepšenia výkonu, niektoré bloky z Úvodnej stránky PhpGedView sú uchované ako cache súbory v adresári index. Cache súbory pre väčšinu blokov sú obnovené jeden krát za deň, ale môže nastať situácia keď ich budete chcieť obnoviť manuálne.<br /><br />Toto tlačidlo vám umožní obnoviť cache súbory keď to je potrebné.";
$pgv_lang["no_update_CHAN_help"] 	= "~#pgv_lang[no_update_CHAN]#~<br />Administrátor niekedy potrebuje vyčistiť a upraviť údaje zaslané užívateľmi. Napríklad môže potrebovať upraviť polohu PLAC. Ak adminitrátor urobí takúto opravu, informácia o povôde zmeny je normálne prepísaná. To je ale nežiadúce.<br /><br />Ak je táto možnosť zvolená,  PhpGedView uchová informáciu o pôvode zmeny miesto nahradenia z aktuálnej session. Administrator má tiež možnosť zmeniť, alebo zmazať informáciu spojenú s pôvodom tagu CHAN.<br /><br />";
?>
