<?php
/**
 * Dutch Language file for PhpGedView.
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2010  PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 * @package PhpGedView
 * @subpackage Languages
 * @authors Erik Bent, Jans B. Luder, Boudewijn Sjouke, Eduard Wustenveld
 * @version $Id: help_text.nl.php 6989 2010-11-09 03:26:25Z canajun2eh $
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

$pgv_lang["file_type_help"]					= "~#pgv_lang[choose_file_type]#~<br /><br />Kies het formaat waarin de te exporteren gegevens worden opgeslagen.  Uw keuze zal afhangen van de mogelijkheden en eisen van het programma, waarin u het gedownloade bestand wilt importeren.  U kunt kiezen uit:<ul><li>#pgv_lang[def_gedcom_help]#<br /></li><li>#pgv_lang[def_gramps_help]#</li></ul>";
$pgv_lang["apply_privacy_help"]				= "~#pgv_lang[apply_privacy]#~<br /><br />Als deze optie is aangevinkt, zal het, te exporteren bestand, worden onderworpen aan de privacyregels volgens de geslecteerde optie.  Dit kan er toe leiden dat bepaalde informatie wordt verwijderd.  Het te exporteren bestand kan alleen de gegevens bevatten, die zichtbaar zijn voor een gebruiker met rechten zoals aangegeven.<br /><br />Als u bijvoorbeeld de rechten heeft van een #pgv_lang[gedadmin]#, kunt u niet aangeven dat het te exporteren bestand gegevens mag bevatten volgens de privileges van de #pgv_lang[siteadmin]#.<br /><br />";
$pgv_lang["convertPath_help"]				= "~#pgv_lang[convertPath]#~<br /><br />Deze optie stelt een  constant pad in, dat aan het begin van alle media-paden wordt toegevoegd, in het te exporteren bestand.<br /><br />Bijvoorbeel: als het media-pad, op de server, is ingesteld als \"/media\" en het te exporteren media-bestandand heeft als pad en naam:  \"/media/pictures/xyz.jpg\" en u heeft in het veld ingevuld: <b>\"c:\\mijn afbeeldingen\\mijn familie\"</b> , zal het resultaat van het media-pad zijn: <b>\"c:\\mijn afbeeldingen\\mijn familie/pictures/xyz.jpg\"</b>.<br /><br />Het volgende valt op in dit voorbeeld:<ul><li>De naam van de huidige media map is verwijderd uit het pad.</li><li>Het resulterende pad bevat <b>niet</b> de correcte map-naam separatoren.</li></ul><br />Als u de huidige media-pad namen wilt behouden in het te exporteren bestand, moet u die media-pad namen eveneens invullen in het veld: <b>#pgv_lang[convertPath]#</b>.<br /><br />Omdat de seperatoren niet correct zijn moet u ook de optie <b>#pgv_lang[convertSlashes]#</b> gebruiken. Dit om er zeker van te zijn dat de map-naam separatoren consistent zijn en overeen komen met vereisten van het ontvangende  besturingssystem (Windows, Mac, Linux,enz.).<br /><br />Media paden die in feite URL's zijn (web adressen) zullen niet worden gewijzigd.<br /><br />";
$pgv_lang["convertSlashes_help"]			= "~#pgv_lang[convertSlashes]#~<br /><br />Opmerking vooraf:<br /><b>Slash</b> en <b>Backslash</b> zijn door mij niet vertaald. Slash, of Forward Slash, is de Schuine Streep Voorwaarts: <b>/</b>, terwijl Backslash de Schuine Streep Achterwaarts: <b>\\</b> is. Deze begrippen zijn echter al zo ingeburgerd en duidelijk, dat ik ze hier maar onvertaald laat.<br /><br />Deze optie bepaald of de mappen-namen in de BESTANDS-specificatie van de media objecten moet worden gescheiden door slashes of door backslashes.  Uw keuze hangt af van de eisen van het besturingssysteem, waarop u de bestanden.<br /><br />De keuze <b>#pgv_lang[forwardSlashes]#</b> is van toepassing op de meeste besturingssystemen, behalve Microsoft Windows.  De keuze <b>#pgv_lang[backSlashes]#</b> moet worden gebruikt als het bestemmingsprogramma draait op een Microsoft Windows systeem.<br /><br />Media paden die in feite URL's zijn (web adressen) zullen niet worden gewijzigd.<br /><br />";
$pgv_lang["medialist_recursive_help"]		= "~#pgv_lang[medialist_recursive]#~<br />Als deze optie is geselecteerd, zal #pgv_lang[multi_title]# niet slechts de map, die u koos uit de #pgv_lang[filter]# lijst, maar ook alle onderliggende mappen ( subdirectories) doorzoeken.<br />Als deze optie niet is geselecteerd, zal alleen de geselecteerde map worden doorzocht.<br /><br />De titels, van alle gevonden media objecten, worden dan gecontroleerd om te bepalen of ze de tekst bevatten, die is ingevoerd in het #pgv_lang[filter]#.<br />Het resultaat van deze twee acties is bepalend welke multimedia objecten op de lijst worden gezet.<br /><br />";
$pgv_lang["sortby_help"]					= "~#pgv_lang[sortby]#~<br />Selecteer de volgorde waarin u de lijst wilt zien.<br /><br />";
$pgv_lang["help_treenav.php"]				= "~#pgv_lang[interactive_tree]#~<br />Gebruik de #pgv_lang[interactive_tree]# om de hele stamboom van een persoon te bekijken, in beide richtingen.  Dit beeld is ongeveer gelijk aan het #pgv_lang[hourglass_chart]#, dat zowel de voorouders en nakomelingen van een bepaalde startpersoon laat zien.  Dit diagram laat u een compacter beeld zien, door vakken te laten zien voor paren of gezinnen i.p.v. personen.<br /><ul><li><b>Scrollen</b><br />Als de muis-cursor verandert in een ikoontje voor verplaatsen, kunt u op het diagram klikken en deze verslepen om andere gedeelten van de stamboom te laten zien.  Als u de stamboom versleept, worden er meer delen van de stamboom zichtbaar, tot er niet meer generaties in het bestand zitten.<br /></li><li><b>Zoom</b><br />U kunt de ikoontjes, aan de linkerzijde van de stamboom, gebruiken om in- of uit te zoomen.  Door uit te zoomen, kunt u meer delen van de stamboom op het scherm zichtbaar maken. De tekst kan dan echter slecht leesbaar waren; als u met de muisaanwijzer over een vakje, wordt dit vergroot.<br /></li><li><b>Details uitvergroten</b><br />As u op een vakje klik, wordt het vakje vergroot en toont meer details.  Als het vakje vergroot is en u vervolgens op een naam klikt gaat u naar de #pgv_lang[indi_info]# pagina van die persoon.  Door op de  <img src='#GLOBALS[PGV_IMAGE_DIR]#/small/gedcom.gif' width='15px' height='15px' alt='' /> te klikken, wordt de stamboom weer opnieuw getekent, met die persoon als nieuwe startpersoon.  Door op de <img src='#GLOBALS[PGV_IMAGE_DIR]#/buttons/family.gif' alt='' /> te klikken gaat u naar detaisl pagina van het gezin.<br /></li><li><b>Partner Aan - Uit</b><br />De <img src='#GLOBALS[PGV_IMAGE_DIR]#/small/sfamily.gif' width='15px' height='15px' alt='' /> ikoon, onder de  Zoom knoppen, zal het tonen van alle partners aan of uit zetten.  Als het is ingesteld om alle partners te tonen, zullen alle partners van een persoon worden getoond, evenals al diens kinderen. Als het is ingesteld om niet alle partners te tonen, zal alleen de laatste partner van een persoon worden getoond, alsmede de kinderen die ze samen hadden.<br /></li><li><b>Grote stamboom</b><br />De #pgv_lang[interactive_tree]# is beschikbaar vanaf diverse pagina's, inclusief de Boom Tab op de #pgv_lang[indi_info]# pagina en het Diagram blok op de Welkom pagina (indien het daar wordt getoond).  Als u de stamboom vanaf een van die pagina's bekijkt, heeft u eveneens een boom-ikoontje onder de Zoom knoppen.  Als u op de  <img src='#GLOBALS[PGV_IMAGE_DIR]#/small/gedcom.gif' width='15px' height='15px' alt='' /> klikt gaat u naar de #pgv_lang[interactive_tree]# pagina.</li></ul><br />";

$pgv_lang["move_mediadirs_help"]			= "~#pgv_lang[move_mediadirs]#~<br />Als de Media Firewall is ingeschakeld kunnen Multi-Media bestanden worden opgeslagen in een map, op de server, die niet toegankelijk is vaanaf het Internet.<br /><br />Met deze knoppen kunt u op eenvoudige wijze een complete Media mappen structuur verplaatsen tussen de beschermde (niet web-adresseerbaar) <b>#GLOBALS[MEDIA_FIREWALL_ROOTDIR]##GLOBALS[MEDIA_DIRECTORY]#</b> en de normale <b>#GLOBALS[MEDIA_DIRECTORY]#</b> mappen.<br /><br />";
$pgv_lang["setperms_help"]					= "~#pgv_lang[setperms]#~<br />Stel de permissies in voor de beschermde (niet web-adresseerbaar) <b>#GLOBALS[MEDIA_FIREWALL_ROOTDIR]##GLOBALS[MEDIA_DIRECTORY]#</b> en de gewone <b>#GLOBALS[MEDIA_DIRECTORY]#</b> mappen als wereld-beschrijfbaar of alleen lezen.<br /><br />";
$pgv_lang["no_update_CHAN_help"]			= "~#pgv_lang[no_update_CHAN]#~<br />Beheerders moeten soms gegevens, die door gebruikers zijn ingevuld,  aanpassen en/of corrigeren.  Bijvoorbeeld: Soms zijn plaatsnamen niet in de vereiste vorm opgegeven. Misschien moet een gemeente of het land worden toegevoegd.<br />Als beheerders zo'n correctie maken, wordt de informatie over de originele wijziging (ingevuld door de gebruiker)  overschreven.  Dit is misschien niet wenselijk.<br /><br />Als deze optie is geselecteerd, zal PhpGedView de informatie van de originele Wijziging behouden, i.p.v. deze te overschrijven met de info van de huidige sessie.  Als deze optie is geselecteerd, heeft de Beheerder eveneens de mogelijkheid om de informatie, die behoort bij de originele CHAN tag, te wijzigen of te wissen.<br /><br />";
$pgv_lang["edit_SOUR_EVEN_help"]			= "~#pgv_lang[source_events]#~<br /><br />Elke bron legt specifieke gebeurtenissen vast, vaak binnen een bepaald tijdsbestek en voor een bepaald rechtsgebied. <br />Voorbeelden zijn:  een volkstelling legt de daarvoor relevante gebeurtenissen vast; kerkelijke registers leggen de gebeurtenissen rond geboorte, doop, huwelijk en dood vast.<br /><br />Selecteer de gebeurtenissen, welke door deze bron zijn vastgelegd, uit de aangeboden gebeurtenissen-lijst.<br />De datum moet worden ingevoerd in een bereik-formaat, zoals <i>VAN 1900 TOT 1910</i>.<br />De plaats-jurisdictie is de naam van de jurisdictie, welke alle lager gelegen plaatsen bevat, die bij deze bron horen.<br />Bijvoorbeeld: \"Borger, Drenthe, NL\" wordt gebruikt als de jurisdictie, voor deze bron, voor gebeurtenissen die plaatsvonden in de plaatsen in de gemeente Borger.<br /> \"Drenthe, NL\" wordt gebruikt als de jurisdictie, voor deze bron, voor gebeurtenissen die plaatsvonden niet alleen in de plaatsen in de gemeente Borger, maar ook in de andere gemeentes in Drenthe.<br /><br />";
$pgv_lang["cache_life_help"]				= "~#pgv_lang[cache_life]#~<br /><br />Om de prestaties te verbeteren is dit PhpGedCom Welkom Pagina blok opgeslagen als een  cache bestand.  Dat betekent dat deze pagina niet elke keer opnieuw samengesteld moet worden, als deze wordt opgeroepen door een gebruiker/bezoeker. U kunt aangeven hoe vaak het cache bestand van dit blok moet worden ververst.<br /><br /><ul><li><b>-1</b> betekent dat het cache bestand nooit automatisch zal worden ververst.  Om de pagina te vernieuwen, moet u alle cache bestanden verwijderen.  U kunt dit doen op de Welkom Pagina Aanpassen pagina.</li><li><b>0</b> (Nul) betekent dat dit blok nooit wordt opgeslagen in de cache. Elke keer dat de pagina wordt getoond, zal dat een nieuw samengestelde zijn.  Deze instelling wordt automatisch gebruikt voor blokken die regelmatig wijzigen, zoals bijv.:  #pgv_lang[logged_in_users_block]# en de #pgv_lang[random_media_block]# blokken.</li><li><b>1</b> (Een) betekent dat er dagelijks een verse kopie van het dit blok wordt opgeslagen als cache bestand, <b>2</b> betekent dat er elke twee dagen een verse kopie wordt gemaakt, <b>7</b> betekent dat er eens per week een verse kopie wordt gemaakt, enz.</li></ul><br /><br />";
$pgv_lang["clear_cache_help"]				= "~#pgv_lang[clear_cache]#~<br /><br />Om de prestaties te verbeteren zijn diverse blokken op de  PhpGedView Welkom Pagina  opgeslagen als een  cache bestand in de index-map.  De cache bestanden voor de meeste blokken worden eens per dag ververst. Het zal echter voor kunnen komen dat u de cache bestanden handmatig wilt verversen.<br /><br />Deze knop stelt u in staat om de cache bestanden, indien nodig, te verversen.";
$pgv_lang["import_options_help"]			= "U kunt aanvullende opties kiezen, die gebruikt worden bij het importeren van de GEDCOM.";
$pgv_lang["verify_gedcom_help"]				= "~#pgv_lang[verify_gedcom]~<br /><br />Hier kiest u of u wilt doorgaan met uploaden en importeren van dit GEDCOM bestand, of dit wilt afbreken.";
$pgv_lang["add_gedcom_instructions"] 		= "Voer een bestandsnaam in voor deze nieuwe GEDCOM.  De nieuwe GEDCOM zal worden gemaakt in de Index map: #INDEX_DIRECTORY#";
$pgv_lang["random_media_start_slide_help"]	= "~#pgv_lang[random_media_start_slide]#~<br /><br />Moet de diavoorstelling automatisch starten wanneer de pagina is geladen?<br /><br />De diavoorstelling wijzigt de inhoud van het blok, zonder informatie van de server te pre-laden en zonder de gehele pagina opnieuw te laden.<br /><br />";
$pgv_lang["random_media_ajax_controls_help"] = "~#pgv_lang[random_media_ajax_controls]#~<br /><br />Gebruik deze instelling om de Diavoorstelling-controls van het Willekeurige Media blok te tonen.<br /><br />Met behulp van deze controls kan de gebruiker naar een ander willekeurig object springen of, willekeurig geselecteerde, media te tonen als een diavoorstelling. De diavoorstelling wijzigt de inhoud van het blok, zonder informatie van de server te pre-laden en zonder de gehele pagina opnieuw te laden.<br /><br />";
$pgv_lang["edit_add_unlinked_source_help"]	= "~#pgv_lang[add_unlinked_source]#~<br /><br />Gebruik deze link om een nieuwe bron aan uw database toe te voegen zonder de bron te koppelen  aan een citaat in een andere kaart.  De nieuwe bron wordt opgenomen in de Bronnen lijst, maar zal niet voorkomen op overzichten of elders in het programma, totdat het is gekoppeld aan een citaat van een bron.";
$pgv_lang["edit_add_unlinked_note_help"]	= "~#pgv_lang[add_unlinked_note]#~<br /><br />Gebruik deze link om een nieuwe gedeelde notitie aan uw database toe te voegen, zonder deze aan enige kaart te koppelen.<br /><br />De nieuwe notitite wordt in de Gedeelde Notities lijst opgenomen, maar zal niet voorkomen op overzichten of elders in het programma, totdat het is gekoppeld aan een persoon, gezin of geeurtenis.";
$pgv_lang["link_person_id_help"]			= "~#pgv_lang[label_local_id]#~<br /><br />In dit veld moet u het persoons_ID nnummer invullen (bijv. I654).";
$pgv_lang["link_gedcom_id_help"]			= "~#pgv_lang[label_gedcom_id]#~<br /><br />Gebruik deze sectie om het ID-kenmerk van de andere database, waarin de persoon zich bevindt waaraan u wilt koppelen, in te vullen.";
$pgv_lang["link_remote_site_help"]			= "~#pgv_lang[label_site]#~<br /><br />In deze sectie specificeert u de parameters die nodig zijn om de verbinding te maken met een andere site, waarop de gegevens staan waaraan u gegevens van deze site aan wilt verbinden.<br />U heeft de keus om te kiezen uit een lijst van bekende sites, die u eerder heeft gebruikt, of de #pgv_lang[label_site_url2]# en #pgv_lang[label_gedcom_id]# in te toetsen voor een nieuw adres.<br /><br />In het <b>#pgv_lang[label_site_url2]#</b> veld voert u de URL in om toegang te krijgen tot het \"web services description\" bestand (WDSL) dat PhpGedView vertelt hoe toegang is te verkijgen tot de gegevens op de andere site.  Als de andere site ook een PhpGedView website is, zou de URL naar het WSDL bestand er zo uit kunnen zien: <u>http://www.remotesite.com/phpGedView/genservice.php?wsdl</u><br />(als de install-map van die andere site \"/phpGedView/\" is)<br /><br />Het <b>#pgv_lang[label_gedcom_id]#</b> veld wordt gebruikt om een optionele database identificatie in te vullen, indien een site dat vereist.  Voor PhpGedView sites is dat de naam van het GEDCOM bestand. <br /><br />De <b>#pgv_lang[label_username_id]#</b> en de <b>#pgv_lang[label_password_id]#</b> velden zijn noodzakelijk indien de database dat vereist.<br /><br /><i>NB: De andere PhpGedView sites moeten  versie 4.0 of later draaien; eerdere versies zijn niet in staat om, op deze wijze, te koppelen.</i>";
$pgv_lang["link_remote_location_help"]		= "~#pgv_lang[label_location]#~<br /><br />Bij deze optie kunt u kiezen waar de gegevens, van de persoon waaraan u gaat koppelen, zich bevinden.<br />De gegevens kunnen zich op dezelfde (deze) site bevinden, maar in een andere genealogical database set. Of de data kunnen zich op een andere site, toegankelijk via het Internet, bevinden.<br /><br />Als de persoon op dezelfde site aanwezig is, wordt u gevraagd naar de naam van de dataset.<br /><br />Als de gegevens op een andere site staan, wordt u gevraagd naar de URL, de database naam of indentificatie, gebruikersnaam en wachtwoord voor toegang naar de database.<br /><br />In beide gevallen moet u de ID van persoon, waaraan u linkt, invullen.";
$pgv_lang["link_remote_rel_help"]			= "~#pgv_lang[label_rel_to_current]#~<br /><br />Gebruik deze optie om de relatie te selecteren, die de persoon op de andere site heeft met de persoon op uw site.<br / >Bijvoorbeeld: Als u <i>Vader</i> selecteert, betekent het dat de persoon op de andere site de vader is van de persoon aan wie hij op uw site is gekoppeld.";
$pgv_lang["link_remote_help"]				= "~#pgv_lang[link_remote]#~<br /><br />Gebruik dit formulier om personen te koppelen aan andere personen, waarvan de gegevens op een andere site staan. Ook kunt u kiezen te koppelen aan personen, wiens gegevens wel op deze site staan, maar in een andere genealigisch bestand, welke toegankelik is voor uw PhpGedView.<br /><br />Om zo'n koppeling (link) toe te voegen, moet eerst de juiste relatie, tussen de te koppelen personen, worden geselecteerd. Kies vervolgens waar de gegevens zijn te bereiken: op deze site, op een al bekende site, of een andere site. Vul vervolgens de ID in van de persoon waaraan u wilt koppelen. Dus de ID die wordt gebruikt in de andere database.<br /><br />Wanneer het nodig is, zal PhpGedView automatisch de nodige informatie van de andere site downloaden.<br /><br />De ge-downloade informatie wordt <u>geen</u> deel van uw genealogische database; het blijft op de originele site, maar het is opgenomen op de diverse pagina's, waar deze gekoppelde persoon wordt getoond.<br /><br />Voor meer informatie kunt u bij elk onderdeel op het formulier op het vraagteken klikken.  Ook kunt u de online (Engelstalige)  tutorial bekijken voor meer informatie: <a href=\"#PGV_PHPGEDVIEW_WIKI#/en/index.php?title=How_To:Remote_Link_Individuals_Across_Websites_And_Databases\" target=\"_blank\">#PGV_PHPGEDVIEW_WIKI#</a>.";

//-- Edit Interface
$pgv_lang["edit_ABBR_help"]					= "~AFGEKORTE TITEL~<br /><br />Gebruik dit veld om een afgekorte versie van een titel op te slaan.  Dit veld wordt gebruikt in samenhang met het titelveld bij bronnen.  Standaard zal PGV eerst de titel gebruiken en daarna de titelafkorting.<br /><br />Volgens de GEDCOM 5.5 specificatie, \"deze invoer is er voor om een verkorte titel te hebben voor het sorteren, in- en uitvoeren van gegevens op bronnen-kaarten (pg 62).\"<br /><br />In PhpGedView is de afgekorte titel vrijblijvend, maar in sommige genealogische  programma's is het verplicht deze in te vullen.";
$pgv_lang["edit_ROMN_help"]					= "~GEROMANISEERDE NAAM~<br /><br />In veel culturen is het gebruikelijk om de traditionele naam te schrijven met de karakters. Vaak is er dan ook een geromaniseerde versie v.d. naam, zoals het gespeld en uitgesproken zou worden in talen, die zijn gebaseerd op het Latijnse alfabet, zoals het Nederlands.<br /><br />Als u het verkiest om een niet-Latijnse alfabet te gebruiken, zoals Grieks, Hebreeuws, Russisch, Arabisch of Chinees om de naam in te voeren in de standaard naam-velden, dan kunt u dit veld gebruiken om dezelfde naam ook in te voeren met het Latijnse alfabet.  Beide versies van de naam zullen worden getoond in lijsten en diagrammen of grafieken.<br /><br />Hoewel de titel van dit veld  \"Geromaniseerde naam\" luidt, is het natuurlijk niet beperkt tot alleen  karakters van het Latijnse alfabet, zoals duidelijk wordt in bovenstaande voorbeelden. Dit kan ook bij uitstek worden gebruikt bij bijv. Japanse namen, waar drie verschillende alfabetten kunnen voorkomen.<br /><br />";
$pgv_lang["edit_ROMN_GIVN_help"]			= "#pgv_lang[edit_ROMN_help]#<br /><br />In dit veld voert u de voornaam, of voornamen, in van de persoon.  Bijvoorbeeld: als de naam \"John Robert Finlay\" is, dan moet in dit veld \"John Robert\" worden ingevoerd.<br /><br />";
$pgv_lang["edit_ROMN_SURN_help"]			= "#pgv_lang[edit_ROMN_help]#<br /><br />In dit veld wordt de achternaam van de persoon ingevuld.  Als, bijvoorbeeld, de naam \"John Robert Finlay\" is, dan is de hier in te voeren achternaam \"Finlay\"<br /><br />Van personen met meervoudige achternamen, zoals vaak voorkomt in bijv.  Spanje en Portugal, kunnen de achternamen worden gescheiden door een komma.  Dat geeft dan aan dat de persoon kan worden gezocht op beide namen.  Bijvoorbeeld: de achternaam \"Cortes,Vega\" kan worden gevonden onder de <b>C</b> en de  <b>V</b>, maar de achternaam \"Cortes Vega\" komt alleen voor onder de <b>C</b>.<br /><br />";
$pgv_lang["edit__HEB_help"]					= "~HEBREEUWSE NAAM~<br /><br />In veel culturen is het gebruikelijk om de traditionele naam te schrijven met de karakters. Vaak is er dan ook een geromaniseerde versie v.d. naam, zoals het gespeld en uitgesproken zou worden in talen, die zijn gebaseerd op het Latijnse alfabet, zoals het Nederlands.<br /><br />Als u het verkiest om het Latijnse alfabet te gebruiken om de naam in te voeren in de standaard naam-velden, dan kunt u dit veld gebruiken om dezelfde naam ook in te voeren met een niet-Latijns alfabet, zoals Grieks, Hebreeuws, Russisch, Arabisch of Chinees.  Beide versies van de naam zullen worden getoond in lijsten en diagrammen of grafieken.<br /><br />Hoewel de titel van dit veld  \"Hebreeuws\" luidt, is het natuurlijk niet beperkt tot alleen Hebreeuwse karakters, zoals duidelijk wordt in bovenstaande voorbeelden.";
$pgv_lang["edit__HEB_GIVN_help"]			= "#pgv_lang[edit__HEB_help]#<br /><br />In dit veld voert u de voornaam, of voornamen, in van de persoon.  Bijvoorbeeld: als de naam \"John Robert Finlay\" is, dan moet in dit veld \"John Robert\" worden ingevoerd.<br /><br />";
$pgv_lang["edit__HEB_SURN_help"]			= "#pgv_lang[edit__HEB_help]#<br /><br />In dit veld wordt de achternaam van de persoon ingevuld.  Als, bijvoorbeeld, de naam \"John Robert Finlay\" is, dan is de hier in te voeren achternaam \"Finlay\"<br /><br />Van personen met meervoudige achternamen, zoals vaak voorkomt in bijv.  Spanje en Portugal, kunnen de achternamen worden gescheiden door een komma.  Dat geeft dan aan dat de persoon kan worden gezocht op beide namen.  Bijvoorbeeld: de achternaam \"Cortes,Vega\" kan worden gevonden onder de <b>C</b> en de  <b>V</b>, maar de achternaam \"Cortes Vega\" komt alleen voor onder de <b>C</b>.<br /><br />";
$pgv_lang["edit_SEX_help"]					= "~WIJZIG #factarray[SEX]#~<br /><br />Gebruik deze keuze om aan te geven of de persoon <b>#pgv_lang[male]#</b> of <b>#pgv_lang[female]#</b> is. Kies <b>#pgv_lang[unknown]#</b> alleen als u niet zeker bent van het geslacht van de persoon.";
$pgv_lang["edit_NAME_help"]					= "~WIJZIG #factarray[NAME]#~<br /><br />Namen worden ingegeven met een schuine streep \"/\" voor en achter de achternaam van de persoon.<br /><br />Voorbeelden:<ul><li>Voornaam /Achternaam/</li><li>Voornaam /Achternaam/ Jr.</li><li>Voornaam /van Achternaam/ jr.</li></ul>";
$pgv_lang["edit_add_unlinked_person_help"]	= "~#pgv_lang[add_unlinked_person]#~<br /><br />Gebruik deze functie om een niet-gekoppeld persoon toe te voegen.<br />Deze persoon blijft als losse persoon in de genealogie bestaan en is niet verbonden met partner, ouders of kinderen, totdat u de koppeling aanbrengt. Dit kan via het #pgv_lang[relatives]# tabblad op de #pgv_lang[indi_info]# pagina.";
$pgv_lang["edit_URL_help"]					= "~#factarray[URL]#~<br /><br />Een voorbeeld van een Web-URL ziet er als volgt uit: <b>http://www.phpgedview.net</b>. Laat dit vak leeg als u geen Web-URL wilt toevoegen.<br /><br />";
$pgv_lang["edit_EMAIL_help"]				= "~#factarray[EMAIL]#~<br /><br />Voer een e-mailadres in.<br />Een voorbeeld van een e-mailadres is: <b>naam@hotmail.com</b>.<br />Laat dit vak leeg als u geen e-mailadres wilt invoeren.<br /><br />";
$pgv_lang["edit_FAX_help"]					= "~#factarray[FAX]#~<br /><br />Voer het faxnummer in, inclusief de land- en regiocode.<br />Een voorbeeld van een faxnummer is: +31 71 1234567.<br />Als u geen faxnummer wilt invoeren, laat dit vak dan leeg.<br /><br />";
$pgv_lang["edit_PHON_help"]					= "~#factarray[PHON]#~<br /><br />Voer het telefoonnummer in, inclusief de land- en regiocode.<br />Een voorbeeld van een telefoonnummer is: +31 71 1234567.<br />Als u geen telefoonnummer wilt invoeren, laat dit vak dan leeg.<br /><br />";
$pgv_lang["edit_ADDR_help"]					= "~#factarray[ADDR]#~<br /><br />Voer het adres in, op dezelfde wijze als u het op een envelop zou schrijven.<br /><br />Laat dit vak leeg als u geen adres wilt invoeren.";
$pgv_lang["edit_GIVN_help"]					= "#pgv_lang[edit_given_name_help]#";
$pgv_lang["edit_SPFX_help"]					= "~Achternaam voegsel~<br /><br />Hier kunt u een eventueel voorvoegesle invullen, of selecteren uit de lijst.  Voorbeelden van zulke voorvoegsel zijn:  <b>van der</b> Vaart, <b>de</b> Graaf, <b>von</b> Braun, enz.";
$pgv_lang["edit_SURN_help"]					= "#pgv_lang[edit_surname_help]#";
$pgv_lang["edit_NSFX_help"]					= "#pgv_lang[edit_suffix_help]#";
$pgv_lang["edit__MARNM_help"]				= "~#factarray[_MARNM]#~<br /><br />Voer hier de \"getrouwde\" naam in voor deze persoon in. Volg hierbij de regels, zoals deze ook getoond worden in het \"Naam\" veld.  Dit veld is optioneel.<br /><br />Bijvoorbeeld: als Grietje Bruin is getrouwd met Jan Blaauw zou u kunnen invoeren (natuurlijk zonder de aanhalingstekens)<ul><li>Nederlands (algemeen) gebruik:&nbsp;&nbsp;\"Grietje  /Blaauw-Bruin/\"</li><li>Europees gebruik:&nbsp;&nbsp;\"Grietje /Blaauw/\"</li><li>Alternatief Europees gebruik:&nbsp;&nbsp;\"Grietje /Blaauw-Bruin/\" of \"Grietje /Bruin-Blaauw/\"</li><li>Amerikaans (VS) gebruik:&nbsp;&nbsp;\"Grietje Bruin /Blaauw/\"</li></ul>U zou dit alleen moeten wijzigen als Grietje Bruin zichzelf volgens de nieuwe naam liet aanspreken nadat ze met Jan Blaauw was getrouwd.<br />  In sommige plaatsen, Quebec (Canada) bijvoorbeeld, is het onwettig om namen op deze manier te wijzigen.<br /><br />Mannen kunnen tegenwoordig hun achternaam ook aanpassen na een huwelijk.<br /><br />";
$pgv_lang["edit_PEDI_help"]					= "~#factarray[PEDI]#~<br /><br />Dit veld omschrijft de relatie van het kind tot het gezin.  De mogelijke opties zijn:<ul><li><b>#pgv_lang[unknown]#</b>&nbsp;&nbsp;&nbsp;De relatie van het kind tot het gezin kan niet worden vastgesteld.  Als deze optie is geselecteerd, wordt het #factarray[PEDI]# veld niet overgenomen in de database.<br /><br /></li><li><b>#factarray[BIRT]#</b>&nbsp;&nbsp;&nbsp;Deze optie geeft aan dat de relatie van het kind tot het gezin is bepaald door geboorte.<br /><br /></li><li><b>#pgv_lang[adopted]#</b>&nbsp;&nbsp;&nbsp;Deze optie geeft aan dat het kind was geadopteerd door het gezin.  Dit geeft <i>niet</i> aan dat er <i>geen</i> bloedverwantschap is tussen het kind en het gezin; het toont aan dat het kind door het gezin, in kwestie, was geadopteerd enige tijd na de geboorte van het kind.<br /><br /></li><li><b>#pgv_lang[foster]#</b>&nbsp;&nbsp;&nbsp;Deze optie geeft aan dat het kind een pleegkind is van het gezin.  Gewoonlijk is er dan geen sprake van bloedverwantschap tussen het kind en het gezin.<br /><br /></li><li><b>#pgv_lang[sealing]#</b>&nbsp;&nbsp;&nbsp; Het kind is door Zegeling aan het gezin verbonden door een LDS <i>Zegeling</i> ceremonie.  De zegeling van een kind wordt uitgevoerd als de ouder door zegeling aan elkaar waren verbonden na de geboorte van het kind.  Kinderen, die worden geboren na de zegeling van de ouders, zijn automatisch door zegeling verbonden aan het gezin.<br /><br /></li></ul>";
$pgv_lang["edit_AGNC_help"]					= "~#factarray[AGNC]#~<br /><br />Een organisatie, instituut, bedrijf, persoon, of andere entiteit welke een bepaalde autoriteit heeft.<br /><br />Bijvoorbeeld: een werkgever van een persoon, of een kerk die rituelen of andere gebeurtenissen uitvoert, of een organisatie die verantwoordelijk is voor het maken en archiveren van bepaalde registraties.";

$pgv_lang["context_help"]					= "Meer helpinformatie is beschikbaar, click hiervoor op <b>?</b> naast het desbetreffende onderdeel.";

$pgv_lang["register_gedcomid_help"]			= "~#pgv_lang[gedcomid]#~<br /><br />Ieder persoon in een genealogie heeft een uniek identificatienummer, een ID. Als u in de genealogie voorkomt en uw ID kent, kunt u dat hier intypen. Als u het niet kent, of u kunt het niet vinden doordat de toegang is afgeschermd door privacy-instellingen, geeft u dan voldoende informatie in het commentaarvak om u herkenbaar te maken voor de beheerder. Deze zal dat uw ID voor u instellen.<br /><br />";
$pgv_lang["register_comments_help"]			= "~#pgv_lang[comments]#~<br /><br />Dit vak kunt u gebruiken om aan de beheerder de reden aan te geven, waarom u een gebruikersnaam aanvraagt. Geeft u daarbij ook aan hoe uw relatie is tot personen in deze genealogie. Verder kunt u hier uw overige opmerkingen kwijt.<br /><br />";
$pgv_lang["utf8_ansi_help"]					= "~CONVERTEER VAN UTF-8 NAAR ANSI~<br /><br />Voor het optimaal tonen van de gegevens op Internet gebruikt PhpGedView de UTF-8 tekenset. Sommige genealogieprogramma's ondersteunen deze tekenset niet, als GEDCOM-bestanden worden geïmporteerd. Als u deze keuze aanzet, wordt het bestand van <b>UTF-8</b> naar <b>ANSI (ISO-8859-1)</b> geconverteerd.<br /><br />Welk formaat u nodig heeft hangt af van het programma waar u het GEDCOM-bestand mee wilt bewerken na het downloaden ervan.<br />Raadpleeg indien nodig de handleiding bij het programma.<br /><br />Let erop dat speciale tekens alleen behouden blijven, als u het bestand in UTF-8 formaat download. Als u het bestand naar andere formaten zoals ANSEL moet converteren, dient u hiervoor een ander programma te gebruiken.<br /><br />";
$pgv_lang["remove_tags_help"]				= "~VERWIJDER SPECIALE PGV-KENMERKEN?~<br /><br />Deze optie zorgt ervoor dat speciale PhpGedView-kenmerken worden verwijderd.<br /><br />Dit betreft kenmerken zoals _PGVU, waarmee wordt aangegeven welke gebruiker het laatst iets aan de gegevens heeft gewijzigd, of _THUM, waarmee wordt aangegeven welke afbeelding moet worden gebruikt als miniweergave.<br /><br />In sommige gevallen kunnen de speciale kenmerken foutmeldingen genereren als ze in een genealogieprogramma worden gemporteerd.<br /><br />";
$pgv_lang["download_zipped_help"]			= "~DOWNLOAD GEDCOM BESTAND ALS ZIP BESTAND~<br /><br />Als u deze optie kiest, wordt een kopie van het GEDCOM-bestand gecomprimeerd in een ZIP-bestand, voordat het downloaden begint. Dit brengt de omvang ervan aanzienlijk terug, maar u heeft op uw PC een UnZIP-programma nodig (zoals WinZip) om het GEDCOM-bestand weer uit te pakken voor gebruik.<br /><br />Deze optie kunt u met name gebruiken voor grote GEDCOM-bestanden. Het risico bestaat dat deze niet geheel gedownload worden, doordat de maximale uitvoeringstijd van het downloadprogramma wordt overschreden. U heeft dan een incompleet GEDCOM-bestand.<br />Deze optie reduceert de downloadtijd met ongeveer 75%.<br /><br />";
$pgv_lang["remember_me_help"]				= "~ONTHOUDT MIJ OP DEZE COMPUTER~<br /><br />Als u dit aanvinkt worden uw aanmeldgegevens bewaard op deze computer. Wanneer u dan de volgende maal deze site bezoekt, hoeft u zich niet opnieuw aan te melden.<br />Uw Internet Verkenner moet het opslaan van \"cookies\" toestaan, hierin worden de aanmeldgegevens opgeslagen en daar vandaan een volgende keer naar de website toegezonden.<br /><br />Vink deze optie NIET aan als u op een publiek toegankelijke computer werkt, iedereen zal dan in staat zijn deze website te bezoeken met uw gegevens.<br /><br />";
$pgv_lang["edit_NCHI_help"]					= "~#factarray[NCHI]#~<br /><br />Voer het aantal kinderen voor deze persoon of dit gezin in. Invoeren is niet verplicht.<br /><br /> <br />";
$pgv_lang["edit_TIME_help"]					= "~#factarray[TIME]#~<br /><br />Voer het tijdstip van deze gebeurtenis in. Het geldige formaat is UU:MM. Voorbeelden zijn: 04:50 13:00 20:30.<br /><br />";
$pgv_lang["edit_NOTE_help"]					= "~#factarray[NOTE]#~<br /><br />In notities kunt u vrije stukken tekst opslaan. Deze verschijnen bij de details van de feiten en gebeurtenissen op de pagina.<br /><br />";
$pgv_lang["edit_SHARED_NOTE_help"]			= "~#pgv_lang[shared_note]#~<br /><br />Gedeelde notities zijn, net als gewone notities, vrije vorm (ongestructureerde) tekst.  <br /><br />In tegenstelling tot gewone notities, kan elke gedeelde notitie worden gekoppeld aan meer dan 1 persoon, gezin, bron of feit.<br /><br />";
$pgv_lang["edit_CEME_help"]					= "~#factarray[CEME]#~<br /><br />Voer de naam van de begraafplaats of andere laatste rustplaats in waar de persoon is begraven.<br /><br />";
$pgv_lang["edit_ASSO_help"]					= "~#factarray[ASSO]#~<br /><br />Voer het ID in van de relatie.<br /><br />";
$pgv_lang["edit_RELA_help"]					= "~#factarray[RELA]#~<br /><br />Selecteer een soort relatie uit de lijst. Het selecteren van Peetvader betekent dus dat de relatie de peetvader van de huidige persoon is.<br /><br />";
$pgv_lang["show_spouse_help"]				= "~#pgv_lang[show_spouses]#~<br /><br />Standaard worden in dit overzicht de partners van de personen niet weergegeven, omdat dit het overzicht ingewikkeld maakt. Met deze optie kunt u de partners alsnog laten tonen.<br />";
$pgv_lang["reorder_families_help"]			= "~#pgv_lang[reorder_families]#~<br /><br />De gezinnen op het tabblad \"Verwanten\" worden weergegeven in de volgorde waarin ze in de gegevens van de desbetreffende persoon voorkomen. Dit is van belang, omdat soms niet de huwelijksdata bekend zijn, maar wel de volgorde van huwelijken.<br /><br />Met behulp van deze optie kunt u de volgorde van de gezinnen aanpassen. Daarbij is een speciale knop beschikbaar om de sortering op huwelijksdatum toe te passen, uiteraard indien alle huwelijksdata bekend zijn.<br />";
$pgv_lang["autoContinue_help"]				= "~#pgv_lang[autoContinue]#~<br /><br />Als PhpGedView merkt dat het importeren van de GEDCOM meer tijd nodig heeft dan is toegestaan door de tijdslimiet, zal er een <b>#pgv_lang[del_proceed]#</b> knop getoond worden, waarop u moet klikken om door te gaan met het Importeren.<br /><br />Als deze optie op <b>#pgv_lang[yes]#</b>is gezet, zal PhpGedView automatisch de <b>#pgv_lang[del_proceed]#</b> knop voor u indrukken.  Dit voorkomt het vervelende herhaaldelijk moeten klikken op de knop, bij langdurige  Imports.<br /><br />";
$pgv_lang["firstname_i_help"]				= "~#pgv_lang[firstname_alpha_index]#~<br /><br />De achternaam, die u heeft gekozen, heeft meer dan #GLOBALS[SUBLIST_TRIGGER_I]# personen.<br /><br />Om u de juiste persoon te helpen zoeken, is de lijst verdeeld in kleinere lijsten, op volgorde van de eerste letter van de voornamen van de afzonderlijke personen.<br />Deze alpfabetische sub-index werkt op dezelfde wijze als de alpfabetische index voor achternamen.<br /><ul><li>Klik op een letter om alle voornamen te zien, die met die letter beginnen. </li><li>Kies <b>#pgv_lang[NN]#</b> om alle mensen, waarvan de voornamen niet bekend zijn, te tonen.</li><li>Door <b>#pgv_lang[all]#</b> te kiezen, zal een lijst worden getoond van alle personen met de, eerder gekozen, achternaam.</li></ul>Omdat er veel namen in het bestand zitten, kan het enige tijd duren, voordat de lijst op uw scherm wordt getoond.<br /><br />";
$pgv_lang["firstname_f_help"]				= "~#pgv_lang[firstname_alpha_index]#~<br /><br />De gezinsnaam, die u heeft gekozen, heeft meer dan #GLOBALS[SUBLIST_TRIGGER_F]# personen.<br /><br />Om u het juiste gezin te helpen zoeken, is de lijst verdeeld in kleinere lijsten, op volgorde van de eerste letter van de voornamen van de afzonderlijke personen.<br />Deze alpfabetische sub-index werkt op dezelfde wijze als de alpfabetische index voor namen.<br /><ul><li>Klik op een letter om alle voornamen te zien, die met die letter beginnen. </li><li>Kies <b>#pgv_lang[NN]#</b> om alle mensen, waarvan de voornamen niet bekend zijn, te tonen.</li><li>Door <b>#pgv_lang[all]#</b> te kiezen, zal een lijst worden getoond van alle gezinnen met de, eerder gekozen, achternaam.</li></ul>Omdat er veel namen in het bestand zitten, kan het enige tijd duren, voordat de lijst op uw scherm wordt getoond.<br /><br />";
$pgv_lang["edit_TYPE_help"]					= "~#factarray[TYPE]#~<br /><br />Het #factarray[TYPE]# invoervak stelt u in staat om een eigen gebeurtenistype in te voeren. U bent vrij om iedere tekst in te vullen, zoals u dat wilt.<br /><br />";
$pgv_lang["edit_TEMP_help"]					= "~#factarray[TEMP]#~<br /><br />Vul hier de tempel in, waar de LDS-plechtigheid heeft plaatsgevonden.<br /><br />";
$pgv_lang["edit_STAT_help"]					= "~#factarray[STAT]#~<br /><br />Dit is een optionele statusaanduiding, die meestal wordt gebruikt voor gegevens over LDS-gebeurtenissen, die door het TempleReady-programma zijn bewerkt.<br /><br />";
$pgv_lang["edit__PRIM_help"]				= "~#factarray[_PRIM]#~<br /><br />Gebruik dit keuzeveld om aan te geven of de afbeelding de geaccentueerde of primaire is, die aan deze persoon is gekoppeld.<br />De geaccentueerde afbeelding wordt gebruikt op overzichten en op de persoonspagina.<br /><br />";
$pgv_lang["edit__THUM_help"]				= "~#factarray[_THUM]#~<br /><br />Dit is een specifieke PhpGedView-optie, waarmee u kunt aangeven dat een geaccentueerde miniweergave moet worden gebruikt in de overzichten, zelfs als deze niet bestaat.<br /><br />";
$pgv_lang["edit_TITL_help"]					= "~#factarray[TITL]#~<br /><br />Voer een titel in voor de gegevens die u nu invoert. Als het een titel betreft voor een multimedia-item zorg dan voor een duidelijke omschrijving, waaruit gebruikers kunnen opmaken waar het om gaat.<br /><br />";
$pgv_lang["edit_FILE_help"]					= "~#factarray[FILE]#~<br /><br />Dit is verreweg het belangrijkste gegeven van het multimedia-object en geeft aan welk bestand gebruikt wordt. Minimaal vult u hier de bestandsnaam in. Afhankelijk van de instellingen is meer informatie over de locatie van het bestand nodig.<br /><br />U kunt de koppeling \"#pgv_lang[find_media]#\" gebruiken om een multimedia-bestand te zoeken, als dat tenminste al is ge-upload naar de website.<br /><br />#pgv_lang[readme_help]#<br /><br /> ";
$pgv_lang["edit_FORM_help"]					= "~#factarray[FORM]#~<br /><br />Hier kunt u invullen welk bestandformaat het multimedia-object heeft, maar het is niet verplicht. Sommige genealogieprogramma's gebruiken het om te bepalen hoe ze met een multimedia-object moeten omgaan.<br />Omdat multimedia-objecten in het algemeen niet gemakkelijk worden overgeheveld tussen computersystemen, is de hier ingevulde waarde van gering belang.<br /><br />";
$pgv_lang["generate_thumb_help"]			= "~GENEREER MINIWEERGAVE~<br /><br />Uw webserver is in staat om automatisch miniweergaves aan te maken van bepaalde soorten afbeeldingen. Dit kunnen ondermeer JPG, GIF en PNG-bestanden zijn. De soorten die door uw webserver worden ondersteund zijn weergegeven in het keuzevak.<br /><br />Door dit te selecteren, geeft u aan dat u afbeeldingen uploadt en wilt proberen hier automatisch miniweergaves voor aan te maken. Als u zelf miniweergaves wilt aanmaken en in de juiste map plaatsen, selecteert u deze optie niet.<br /><br />";
$pgv_lang["edit_add_NOTE_help"]				= "~#pgv_lang[add_note]#~<br /><br />In deze sectie kunt een notitie toevoegen aan het feit dat u op dit moment aan het wijzigen of toevoegen bent. In notities kunt u een willekeurige tekst plaatsen. De notitie verschijnt bij de detailgegevens van het feit op de pagina.<br /><br />";
$pgv_lang["edit_add_SHARED_NOTE_help"]		= "~#pgv_lang[add_shared_note]#~<br />~#pgv_lang[edit_shared_note]#~<br /><br />Gedeelde notities zijn, net als gewone notities, vrije vorm (ongestructureerde) tekst.  In tegenstelling tot gewone notities, kan elke gedeelde notitie worden gekoppeld aan meer dan 1 persoon, gezin, bron of feit.<br /><br />Door op de juiste ikoon te klikken, kunt u een koppeling maken naar een bestaande gedeelde notitie. Of u kunt dan een nieuwe gedeelde notitie maken en er aan koppelen.  Als er al een koppeling naar een bestaande gedeelde notitie bestaat, kunt u ook de inhoud van die notitie wijzigen.<br /><ul><li><b>Koppelen aan een bestaande gedeelde notitie</b><div style=\"padding-left:20px;\">Als u al het ID-nummer van de gewenste gedeelde notitie weet, kunt u dat nummer direct in het veld invoeren.<br /><br />Als u op de ikoon van de <b>#pgv_lang[find_shared_note]#</b> klikt, kunt u in de tekst van alle bestaande Gedeelde notities zoek en dan een ervan kiezen.  Het ID-nummer van de gekozen notitite wordt automatisch in het veld ingevuld.<br /><br />U moet op de <b>#pgv_lang[add]#</b> knop klikken om de originele kaart bij te werken.</div><br /></li><li><b>Maak een nieuwe gedeelde notitie</b><div style=\"padding-left:20px;\">Als u op de <b>#pgv_lang[create_shared_note]#</b> ikoon klikt, zal een nieuw venster openen.  U kunt dan, desgewenst,de tekst van de nieuwe notitie invoeren.  Zoals ook bij gewone notities kunt u URL's intypen.<br /><br />Als u op de <b>#pgv_lang[save]#</b> knop klikt, ziet u een bericht met het ID nummer van de nieuw gemaakte created gedeelde notitie.  U moet op dit bericht klikken om het Wijzigen venster te sluiten en het nieuwe ID-nummer rechtstreeks naar het ID-nummer veld te kopiëren.  Als u het venster alleen maar sluit, zal het nieuw gemaakte ID-nummer niet automatisch gekopiëerd worden.<br /><br />U moet op de <b>#pgv_lang[add]#</b> knop klikken om de originele kaart bij te werken.</div><br /></li><li><b>Een bestaande gedeelde notitie wijzigen</b><div style=\"padding-left:20px;\">Als u op de <b>#pgv_lang[edit_shared_note]#</b> ikoon klikt, zal een nieuw venster openen.  Desgewenst kunt u de tekst van de bestaande gedeelde notitie wijzigen.  Zoals ook bij gewone notities kunt u URL's intypen.<br /><br />Als u op de <b>#pgv_lang[save]#</b> knop klikt, zal de tekst van de gedeelde notitie worden bijgewerkt.  U kunt het venster sluiten en dan nogmaals op de <b>#pgv_lang[save]#</b> knop klikken.<br /><br />Als u de tekst van een gedeelde notitie wijzigt, zal dat bij alle plaatsen ,waaraan de gedeelde notitie momenteel is gekoppeld, zichtbaar zijn.  Nieuwe koppelingen, die u maakt nadat de wijzigingen zijn aangebracht, zullen ook de bijgewerkte tekst gebruiken.</div></li></ul>";
$pgv_lang["edit_add_GEDFact_ASSISTED_help"]	= "~GEBRUIK van GEDFACT ASSISTENT~<br /><br />Door op de \"+\" te klikken zal het  GEDFact Gedeelde Notitie Assistent venster worden geopend.<br />Specifieke help wordt daar geboden.<br /><br />Als u op  \"Opslaan\" knop klikt, wordt het ID van de Gedeelde Notitie hier geplakt.<br /><br />";
$pgv_lang["edit_add_SOUR_help"]				= "~#pgv_lang[add_source]#~<br /><br />In deze sectie kunt u een bronvermelding toevoegen aan het feit dat u op dit moment wijzigt of toevoegt. De code voor de bron moet worden ingevoerd, u kunt ernaar zoeken door op het icoon rechts van het invoervak te klikken.<br /><br />Klik op de #pgv_lang[create_source]#-koppeling als u een nieuwe bron wilt invoeren.<br /><br />Bij \"details citaat\" kunt u aangeven waar in de bron (bijvoorbeeld op welke pagina) de informatie te vinden in.<br />Bij tekst kunt u een transcript (overgenomen informatie) opnemen vanuit de bron.<br /><br />";
$pgv_lang["edit_add_ASSO_help"]				= "~#pgv_lang[add_asso]#~<br /><br />Met #pgv_lang[add_asso]# kunt u een persoon uit uw genealogie relateren aan een feit. Op die manier kunt u bijvoorbeeld aangeven dat een bepaald persoon de peetvader is van een ander persoon.<br /><br />";
$pgv_lang["edit_QUAY_help"]					= "~#factarray[QUAY]#~<br /><br />Deze aanduiding kunt u gebruiken om de betrouwbaarheid van gegevens van deze bron aan te geven.<br />Veel genealogieprogramma's duiden dit aan door middel van een cijfer:<br />1. kan inhouden dat een gegeven uit een directe of primaire bron afkomstig is. Denk aan een geboorteakte of ander officieel document.<br />2. kan inhouden dat de informatie in de bron overgenomen kan zijn uit een andere bron, en daarbij onderhevig aan fouten.<br />3. kan betekenen dat de informatie ronduit onbetrouwbaar is.<br /><br />";
$pgv_lang["edit_PAGE_help"]					= "~#factarray[PAGE]#~<br /><br />In de detailgegevens van het citaat kunt u bijvoorbeeld een paginanummer opgeven of andere informatie, waardoor de bedoelde informatie gemakkelijk in de bron kan worden teruggevonden.<br /><br />";
$pgv_lang["edit_TEXT_help"]					= "~#factarray[TEXT]#~<br /><br />Hier kunt u specifieke informatie invoeren over deze bronverwijzing. Voorbeelden zijn een transcript (letterlijk overgenomen tekst) uit de bron of een samenvatting of beschrijving ervan.<br /><br />";
$pgv_lang["edit_SOUR_help"]					= "~#factarray[SOUR]#~<br /><br />Hier kunt u de verwijzing naar een bron voor dit feit aanpassen. Ingevuld wordt een bron-ID (kenmerk). Daarnaast wordt de titel van de bron weergegeven. Gebruik de \"#pgv_lang[find_id]#\"-koppeling om een nieuwe bron te selecteren. Om de bronverwijzing te verwijderen, maak het vak met de bron-ID leeg.<br /><br />";
$pgv_lang["edit_edit_raw_help"]				= "~#pgv_lang[edit_raw]#~<br /><br />Met behulp van deze functie kunt u de informatie aanpassen, zoals deze in de GEDCOM-informatie voorkomt.<br /><br /><b>Let op:</b> het direct wijzigen van GEDCOM-informatie vereist kennis van de structuur en inhoud ervan.<br /><br />PhpGedView biedt op vele andere manieren via invulschermen de mogelijkheid om de gegevens aan te passen. Aangeraden wordt altijd deze mogelijkheden te gebruiken, en deze functie alleen in uiterste noodzaak toe te passen.<br />Als u de aangepaste informatie heeft opgeslagen, wordt op een aantal punten gecontroleerd op de juistheid ervan. Ook wordt een CHAN-record aangemaakt (laatste wijziging).<br /><br />";
$pgv_lang["add_from_clipboard_help"]		= "~#pgv_lang[add_from_clipboard]#~<br /><br />Met PhpGedView kunt u informatie over feiten kopiëren naar het klembord. Als u dit heeft gedaan, kunt u onder \"Nieuw feit toevoegen\" de gekopieerde informatie toevoegen aan ieder ander persoon. In de keuzelijst is de informatie te vinden onder \"Toevoegen vanaf klembord .....\".<br />Deze mogelijkheid is erg handig als u dezelfde informatie over een feit wilt toevoegen aan meerdere personen.<br /><br />";
$pgv_lang["edit_PLAC_help"]					= "~#factarray[PLAC]#~<br /><br />Locaties moeten worden ingevoerd aan de hand van de standaards in genealogie. Locaties worden ingevoerd met de meest specifieke informatie eerst en dan per niveau steeds minder specifiek. De stappen worden gescheiden door komma's. De niveaus moeten overeenkomen met de niveaus die door (kerkelijke) autoriteiten worden onderscheiden.<br /><br />Een plaats als Leiden wordt ingevoerd als \"Leiden, Zuid-Holland, Nederland\". Hier is Leiden de stad, Zuid-Holland de provincie en Nederland het land.<br />Stadsdelen kunnen worden toegevoegd door deze voor de stad te plaatsen. Er komt dan dus nog een niveau bij.<br /><br />Als een niveau niet bekend is, wordt het vervangen door een spatie. Stel dat we alleen weten dat een persoon in Leiden is geboren en dat Leiden in Nederland ligt, dan wordt de aanduiding als volgt: \"Leiden, , Nederland\".<br /><br />U kunt de koppeling \"#pgv_lang[find_place]#\" gebruiken om locaties te vinden die in deze genealogie al voorkomen.<br /><br />";
$pgv_lang["edit_add_parent_help"]			= "~NIEUWE VADER OF MOEDER TOEVOEGEN~<br /><br />Hiermee kunt u een vader of moeder toevoegen aan de persoon. Vul alle bekende gegevens over naam, geboorte en evt. overlijden in. Nog niet bekende gegevens kunt u later toevoegen.<br /><br />Om andere feiten aan de persoon toe te voegen, dient u eerst de ingevulde gegevens op te slaan. Daarna kunt u op de naam van de persoon klikken en op de persoonspagina, tabblad \"Persoonlijke feiten en details\", nieuwe feiten toevoegen.<br /><br />";
$pgv_lang["edit_add_spouse_help"]			= "~NIEUWE PARTNER TOEVOEGEN~<br /><br />Hiermee kunt u een partner toevoegen aan de geselecteerde persoon. De partner wordt als nieuw persoon in de genealogie opgenomen. Vul de naam, geboortegegevens en eventueel overlijdensgegevens in. Gegevens die nu nog ontbreken kunt u altijd later aanvullen.<br /><br />Om andere feiten aan de persoon toe te voegen, dient u eerst de ingevulde gegevens op te slaan. Daarna kunt u op de naam van de persoon klikken en op de persoonspagina, tabblad \"Persoonlijke feiten en details\", nieuwe feiten toevoegen.<br /><br />";
$pgv_lang["edit_death_help"]				= "~#pgv_lang[death]#~<br /><br />In deze sectie kunt u gegevens over het overlijden toevoegen. Voer eerst de datum in waarop het overlijden plaatsvond. Zorg ervoor dat de datum in het standaard genealogisch formaat wordt ingevoerd, bijvoorbeeld 1 JAN 2004 of 16 MAY 1877. U kunt ook de kalender gebruiken om een datum te selecteren: gebruik hiervoor de koppeling naast het datumvak.<br />Voer vervolgens de locatie in waar de persoon is overleden. Gebruik de \"Zoek locatie\" koppeling om een reeds bestaande locatie te selecteren.<br /><br />";
$pgv_lang["edit_birth_help"]				= "~#pgv_lang[birth]#~<br /><br />In deze sectie kunt u gegevens over de geboorte toevoegen. Voer eerst de datum in waarop de geboorte plaatsvond. Zorg ervoor dat de datum in het standaard genealogisch formaat wordt ingevoerd, bijvoorbeeld 1 JAN 2004 of 16 MAY 1877. U kunt ook de kalender gebruiken om een datum te selecteren: gebruik hiervoor de koppeling naast het datumvak.<br />Voer vervolgens de locatie in waar de persoon is geboren. Gebruik de \"Zoek locatie\" koppeling om een reeds bestaande locatie te selecteren.<br /><br />";
$pgv_lang["edit_sex_help"]					= "~#pgv_lang[sex]#~<br /><br />Kies het geslacht van de persoon in de keuzelijst. \"Onbekend\" betekent dat het geslacht niet bekend is.";
$pgv_lang["edit_name_help"]					= "~#pgv_lang[name]#<br /><br />Dit is het belangrijkste onderdeel van de persoonsgegevens. In dit vak wordt de complete naam samengesteld uit hetgeen in de andere naamvakken is ingevoerd. Volgens de genealogische standaard wordt hierbij de achternaam omgeven door \"/\"-tekens. \"Piet de Groot jr.\" wordt dan weergegeven als \"Piet/de Groot/jr.\".<br /><br />";
$pgv_lang["edit_suffix_help"]				= "~#pgv_lang[suffix]#~<br /><br />In dit vak kunt u een achtervoegsel van de naam invoeren. Voorbeelden zijn \"sr.\" en \"jr.\". Invullen van dit vak is niet verplicht.<br /><br />";
$pgv_lang["edit_surname_help"]				= "~#pgv_lang[surname]#~<br /><br />In dit vak kunt u de achternaam van de persoon invoeren.<br />Een, eventueel, voorvoegsel van de achternaam vult u hier echter niet in. Heet de persoon bijvoorbeeld \"Piet de Groot\", dan vult u hier \"Groot\" in. Het voorvoegsel \"de\" wordt dan ingevuld in het daarvoor bedoelde veld.<br /><br />";
$pgv_lang["edit_NICK_help"]					= "~#factarray[NICK]#~<br /><br />In dit vak kunt u de bij- of roepnaam van een persoon invoeren.<br />Invoer is niet verplicht.<br /><br />Er zijn verschillende manieren om een bij- of roepnaam in te voeren:<ul><li>Selecteer 'Wijzig naam', vul de roep- of bijnaam in en sla het op.</li><li>Selecteer 'Nieuwe voor/achternaam toevoegen', vul zowel voor-, achter-, als roep- of bijnaam in en sla het op. Let op: hierdoor worden voor/achternaam TWEEMAAL in de gegevens opgenomen.<br /></li><li>Selecteer 'Wijzig GEDCOM-gegevens' om meerdere [2 NICK] toe te voegen onder [1 NAME].</li></ul><br /><br />";
$pgv_lang["edit_given_name_help"]			= "~#pgv_lang[given_name]#~<br /><br />In dit vak kunt u de voornamen van de persoon invullen. Heet de persoon \"Piet de Groot\", dan vult u hier \"Piet\" in.<br /><br />";
$pgv_lang["edit_NPFX_help"]					= "~#factarray[NAME]# #factarray[NPFX]#~<br /><br />In dit vak kunt u voorvoegsels voor de naam invoeren, zoals dr, ir en drs. U kunt dit vak leeg laten.<br /><br />";
$pgv_lang["edit_add_child_help"]			= "~#pgv_lang[add_child]#~<br /><br />Hiermee kunt u een nieuw kind toevoegen aan het geselecteerde gezin. Het kind wordt als nieuw persoon in de genealogie opgenomen. Vul de naam, geboortegegevens en eventueel overlijdensgegevens in. Gegevens die nu nog ontbreken kunt u altijd later aanvullen.<br /><br />Om andere feiten aan het kind toe te voegen, dient u eerst de ingevulde gegevens op te slaan. Daarna kunt u op de naam van het kind klikken en op de persoonspagina, tabblad \"Persoonlijke feiten en details\", nieuwe feiten toevoegen.<br /><br />";

$pgv_lang["review_changes_help"]			= "~NOG NIET GEACCEPTEERDE WIJZIGINGEN~<br /><br />In dit vak worden alle wijzigingen getoond die zijn aangebracht, maar nog niet door een bevoegd beheerder zijn beoordeeld en doorgevoerd.<br /><br />";
$pgv_lang["quick_update_name_help"]			= "~NAAM BIJWERKEN~<br /><br />Gebruik deze invoervakken om de naam te wijzigen van de persoon op de persoonspagina. Bij \"Voornamen\" vult u de volledige voornamen van de persoon in , bij \"Achternaam\" de achternaam inclusief voorvoegsels. Als u bijvoorbeeld de naam van de persoon wilt wijzigen in \"Piet de Groot\", vult u bij \"Voornaam\" \"Piet\" in en bij \"Achternaam\" \"de Groot\".<br /><br />Let op: Met het intypen van een nieuwe naam voegt u geen nieuwe persoon toe, de naam van de bestaande persoon wordt gewijzigd. Ook wordt geen nieuwe naam toegevoegd, de huidige naam wordt gewijzigd.<br /><br /><i>Let op: Wijzig de naam niet ten gevolge van een huwelijk, gebruik deze pagina dan om een nieuwe partner in te voeren.</i><br /><br />";
$pgv_lang["quick_update_fact_help"]			= "~FEIT BIJWERKEN~<br /><br />Gebruik de vakken om nieuwe feiten toe te voegen of bestaande feiten aan te passen. Kies eerst een feit uit de keuzelijst.<br />Voer vervolgens de datum in van wanneer het feit plaatsvond. Zorg ervoor dat de datum in het standaard genealogisch formaat wordt ingevoerd, bijvoorbeeld 1 JAN 2004 of 16 MAY 1877. U kunt ook de kalender gebruiken om een datum te selecteren: gebruik hiervoor de koppeling naast het datumvak.<br />Voer vervolgens de locatie in waar het feit plaatsvond. Gebruik de \"Zoek locatie\" koppeling om een reeds bestaande locatie te selecteren.<br /><br />Als u informatie invoert voor een feit dat al bestaat, dan wordt de oude informatie overschreven met hetgeen u hier invoert. Bestaat het feit nog niet, dan maakt u hiermee een nieuw feit aan.<br /><br />";
$pgv_lang["quick_update_address_help"]		= "~ADRES BIJWERKEN~<br /><br />Gebruik de vakken van \"Adres bijwerken\" om adres, telefoon en e-mailgegevens van de desbetreffende persoon bij te werken.<br /><br />Bestaande adresinformatie wordt hierbij overschreven.<br /><br />";
$pgv_lang["quick_update_spouse_help"]		= "~NIEUWE PARTNER TOEVOEGEN~<br /><br />Gebruik deze sectie als u een nieuwe partner wilt toevoegen aan de persoon. Voer de naams- en geboorte-informatie in de vakken in en, indien het om een huwelijk gaat, de huwelijksinformatie eronder.<br /><br />Voer datums in volgens de genealogische indeling (1 JAN 2005 of 16 MAY 1799). U kunt ook de kalender gebruiken om een datum te selecteren, klik hiervoor op de kalenderafbeelding rechts van het invoervak.<br />U kunt \"Zoek locatie\" gebruiken om een reeds eerder in PhpGedView gebruikte locatie te selecteren.<br /><br />Let op: U kunt hiermee alleen een <i>nieuwe</i> partner toevoegen. De informatie van bestaande partner wordt niet aangepast. Om die informatie te bewerken, kunt u dit venster sluiten, op de naam van de desbetreffende partner klikken op het tabblad \"Verwanten\". Kies daarna bij de feiten of bij \"opties voor personen\" voor wat u wilt wijzigen.<br /><br />";
$pgv_lang["quick_update_marriage_help"]		= "~HUWELIJK BIJWERKEN~<br /><br />U kunt deze sectie gebruiken in combinatie met \"Nieuwe partner toevoegen\". In dat geval wordt een nieuw huwelijk/gezin toegevoegd.<br />In het andere geval wordt het <b>laatste</b> huwelijk van de persoon aangepast.<br /><br />Voer datums in volgens de genealogische indeling (1 JAN 2005 of 16 MAY 1799). U kunt ook de kalender gebruiken om een datum te selecteren, klik hiervoor op de kalenderafbeelding rechts van het invoervak.<br />U kunt \"Zoek locatie\" gebruiken om een reeds eerder in PhpGedView gebruikte locatie te selecteren.<br /><br />";
$pgv_lang["quick_update_child_help"]		= "~NIEUW KIND TOEVOEGEN~<br /><br />Gebruik deze sectie om een nieuw kind toe te voegen aan de persoon. Voer eerst de namen van het kind in en het geslacht, vervolgens de datum en plaats van geboorte.<br />Voer datums in volgens de genealogische indeling (1 JAN 2005 of 16 MAY 1799). U kunt ook de kalender gebruiken om een datum te selecteren, klik hiervoor op de kalenderafbeelding rechts van het invoervak.<br />U kunt \"Zoek locatie\" gebruiken om een reeds eerder in PhpGedView gebruikte locatie te selecteren.<br /><br />Let op: U kunt hiermee alleen een <i>nieuw</i> kind toevoegen. De informatie van een bestaand kind wordt niet aangepast. Om die informatie te bewerken kunt u dit venster sluiten, op de naam van het desbetreffende kind klikken op het tabblad \"Verwanten\". Kies daarna bij de feiten of bij \"opties voor personen\" voor wat u wilt wijzigen.<br /><br />";
$pgv_lang["index_top10_pageviews_help"]		= "~MEEST BEKEKEN GEGEVENS~<br />In dit vak wordt de top 10 weergegeven van meest bekeken personen, gezinnen en bronnen. Dit vak wordt alleen weergegeven als de bezoekersteller is ingeschakeld.<br /><br />";
$pgv_lang["useradmin_user_default_tab_help"] = "~STANDAARD TABBLAD VOOR PERSOONSPAGINA~<br /><br />Deze instelling bepaalt welk tabblad standaard wordt getoond als de gebruiker de gegevens van een persoon bekijkt. Als gebruikers hun gebruikersgegevens mogen aanpassen, kunnen ze deze instelling later zelf wijzigen.";
$pgv_lang["edituser_user_default_tab_help"]	= "~STANDAARD TABBLAD VOOR PERSOONSPAGINA~<br /><br />Deze instelling bepaalt welk tabblad standaard wordt getoond als de gebruiker de gegevens van een persoon bekijkt.";
$pgv_lang["reorder_children_help"]			= "~KINDEREN HERSCHIKKEN~<br /><br />Kinderen worden getoond in de volgorde waarin ze in de genealogie voorkomen in het gezin. Hoewel sortering op geboortedatum voor de hand ligt, wordt dit niet gedaan, omdat soms geen geboortedata bekend zijn, maar de volgorde van geboorte daarentegen wel.<br /><br />Met deze functie kunt u de kinderen binnen het gezin herschikken naar de juiste volgorde. Als u ze simpelweg op geboortedatum wilt sorteren, kunt u hiervoor de desbetreffende knop gebruiken. PhpGedView verzorgt de sortering dan automatisch.<br /><br />";
$pgv_lang["rss_feed_help"]					= "~RSS FEED INSTELLINGEN~<br /><br />De RRS feed van PhpGedView stelt u in staat om de belangrijkste onderdelen van de Welkomstpagina te zien op een website die deze feed gebruikt, zonder dat u de PhpGedView-site steeds hoeft te bezoeken. De meeste websites die gebruik maken van RSS feeds maken u op wijzigingen in de feeds attent.<br />Met het RSS feed vak kunt u de koppeling naar de feed instellen voor bepaalde soorten informatie (de meeste websites kunnen hiermee overweg en in principe kunt u de standaardwaarden laten staan) en de specifieke module die u aan de feed wilt toevoegen. De taal van de feed is de taal die actief is op het moment dat u de feed selecteert. De types feed die kunnen worden gegenereerd zijn ondermeer RSS 0.92, RSS 1.0, RSS 2.0, ATOM, HTML en JavaScript. De eerste vier types zijn bedoeld voor feed-verzamelaars, terwijl JavaScript en HTML zijn bedoeld om op te nemen op andere webpagina's.<br /><br />Let erop dat de verschillende versienummers duiden op verschillende types feed en niet op verschillende versies.<br /><br />";

$pgv_lang["upload_media_folder_help"]		= "~#pgv_lang[folder]#~<br /><br />Uw GEDCOM configuratie is ingesteld om #GLOBALS[MEDIA_DIRECTORY_LEVELS]# mappen nivo's dieper te gaan dan de standaard <b>#GLOBALS[MEDIA_DIRECTORY]#</b> map, waar ge-uploade media bestanden normaliter worden opgeslagen.<br />Hierdoor kunt u de mediabestanden beter organiseren en u hoeft er minder op te letten dat elk media bestand een unieke naam zou moeten hebben.<br /><br />In dit veld geeft u de bestemmingsmap op uw server op, waar het te uploaden bestand moet worden opgeslagen.<br />Overtuig u ervan dat de benaming hier goed wordt ingevuld. Denk om HOOFD- en kleine letters, aangezien bestands- en mappen namen hoofdlettergevoelig zijn.<br /><br />Als de mapnaam, die u hier invult, niet bestaat, dan wordt die map automatisch aangemaakt.<br />Als u meer mappen nivo's opgeeft dan de ingestelde #GLOBALS[MEDIA_DIRECTORY_LEVELS]# mappen nivo's in de GEDCOM instellingen, dan wordt uw invoer afgekapt tot het toegestane aantal mappen.<br /><br />Miniweergave bestanden worden geupload, of automatisch gemaakt, in dezelde mappenstructuur, beginnend met <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b>.<br /><br />";
$pgv_lang["upload_media_file_help"]			= "~#pgv_lang[media_file]#~<br /><br />In dit veld geeft u de plaats en naam op, op uw lokale computer, van het mediabestand, dat u naar onze server wilt sturen.  U kunt de <b>Bladeren</b> knop gebruiken om op uw lokale computer het gewenste bestand te zoeken.<br /><br />Het bestand zal dezelfde naam krijgen op onze server. Het zal worden geplaatst in de map, dat is aangegeven in het veld <b>#pgv_lang[folder]#</b>.<br /><br />Als u het <b>#pgv_lang[folder]#</b> veld niet ziet, of anders niet kunt wijzigen, heeft u niet voldoende rechten, of het programma is door de beheerder zodanig ingesteld dat geen mappen buiten de standaard map <b>#GLOBALS[MEDIA_DIRECTORY]#</b>, waar de opgeladen bestanden normaal gesproken worden opgeslagen, zijn toegestaan.  In dat geval wordt het mediabestand geplaatst in de map  <b>#GLOBALS[MEDIA_DIRECTORY]#</b>.<br /><br />";
$pgv_lang["upload_thumbnail_file_help"]		= "~#pgv_lang[thumbnail]#~<br /><br />In dit veld geeft u de plaats en naam op, op uw lokale computer, van het miniweergavebestand, dat u naar onze server wilt sturen.  U kunt de <b>Bladeren</b> knop gebruiken om op uw lokale computer het gewenste bestand te zoeken.  Als dit veld is ingevuld, wordt het <b>#pgv_lang[auto_thumbnail]#</b> keuzevakje niet gebruikt.<br /><br />Als het <b>#pgv_lang[media_file]#</b> veld is ingevuld, wordt uw miniweergavebestand genoemd zolas het veld is ingevuld, ongeacht hoe het bestand op uw lokale computer heet.  Als het veld leeg blijft, wordt een kopie van het miniweergavebestand op twee plaatsen van de servergezet. Een keer in de server map, genoemd in het <b>#pgv_lang[folder]#</b> veld. Een tweede kopie gaat naar een identieke mappenstructuur, beginnend met <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b>.<br /><br />Als u het <b>#pgv_lang[folder]#</b> veld niet ziet, of anders niet kunt wijzigen, heeft u niet voldoende rechten, of het programma is door de beheerder zodanig ingesteld dat geen mappen buiten de standaard <b>#GLOBALS[MEDIA_DIRECTORY]#</b>, waar de opgeladen bestanden normaal gesproken worden opgeslagen, zijn toegestaan.<br /><br />";


//-- GENERAL
$pgv_lang["help_header"]					= "Informatie over:";
$pgv_lang["privacy_error_help"]				= "<b>GEGEVENS ZIJN VERBORGEN</b><br /><br />Als deze boodschap verschijnt kan dit een aantal oorzaken hebben:<br /><br /><b>1. Informatie van levende personen is verborgen voor bezoekers.</b><br />Onder Bezoeker wordt iemand verstaan die op deze website niet is aangemeld met een gebruikersnaam.<br />Alle gegevens van nog levende personen zijn verborgen voor Bezoekers.<br />Gegevens van overleden personen zijn wel publiekelijk toegankelijk, en kunnen dus door een Bezoeker worden ingezien.<br />U kunt een gebruikersnaam als volgt aanvragen: klik op de koppeling \"Aanmelden\" boven aan het scherm en daarna op de koppeling #pgv_lang[requestaccount]#.<br /><br /><b>2. U beschikt over een gebruikersnaam en een wachtwoord......</b><br />Maar u heeft zich nog niet aangemeld, of bent voor langere tijd inactief geweest, waardoor u automatisch bent afgemeld.<br />Als u zich (opnieuw) aanmeldt dan is het probleem opgelost.<br /><br /><b>3. Gegevens van deze persoon zijn verborgen.</b><br />De persoon, wiens gegevens u wilde zien, heeft aan de beheerder gevraagd om de gegevens als privé aan te merken of geheel te verbergen.<br />In dat geval kunnen de gegevens alleen worden ingezien door gebruikers, die hiertoe voldoende rechten hebben.<br />Privacy kan worden ingesteld op::<br />a) #pgv_lang[PRIV_USER]#<br />b) #pgv_lang[PRIV_NONE]#<br />c) #pgv_lang[PRIV_HIDE]#<br /><br /><b>4. Gegevens buiten \"relatiepad\"</b><br />Ook als u beschikt over een gebruikersnaam <b>en</b> aangemeld bent, kan het voorkomen dat deze boodschap verschijnt.<br />De beheerder heeft dan in de instellingen aangegeven, dat het relatiepad beperkt is.<br />Hiermee wordt aangegeven, dat u alleen de gegevens van personen kunt zien, die een beperkt aantal stappen in de stamboom van u verwijderd zijn.<br />Als de lengte van het relatiepad de waarde \"1\" heeft, kunt u alleen de details zien van uw eigen familie: ouders, broers en zussen en kinderen (maar niet de partners en kinderen van uw broers en zussen).<br /><br />Bij een waarde \"2\" kunt u  ook de details zien van de vrouw van uw broer en van diens kinderen (maar niet van de partners van die kinderen).<br />Hoe hoger de waarde van het relatiepad is, hoe verder weg de personen van u af liggen, waarvan u de details kunt zien.<br /><br />Als u van mening bent, dat u van te weinig personen details kunt zien, neemt u dan contact op met de beheerder via de koppeling onder in het scherm.";
$pgv_lang["more_help"]						= "<br />Als u meer specifieke helpinformatie wilt hebben, zorg er dan voor dat de <b>#pgv_lang[show_context_help]#</b> (in het Help-menu) aan staat, en klik op een <b>?</b> bij een onderwerp.<br />";
$pgv_lang["more_config_help"]				= "<br /><b>Meer Help</b><br />Op deze pagina is meer helpinformatie beschikbaar. Klik daarvoor op de <b>?</b> achter de vakken en teksten.<br />";
$pgv_lang["start_admin_help"]				= "+++ Start extra informatie voor de beheerder +++";
$pgv_lang["end_admin_help"]					= "+++ Einde extra informatie voor de beheerder +++";
$pgv_lang["multiple_help"]					= "<center>--- Dit is een algemene helptekst voor meerdere pagina's ---</center>";
$pgv_lang["header_general_help"]			= "<div class=\"name_head\"><center><b>ALGEMENE INFORMATIE</b></center></div><br />";
$pgv_lang["best_display_help"]				= "~UW BEELDSCHERM~<br />PhpGedView is ontworpen voor een beeldschermresolutie van 1024x768.<br />Als u uw PC op minimaal deze waarde heeft ingesteld, wordt alles correct op het scherm getoond.<br />Als u de resolutie op een lagere waarde instelt, zoals 800x600, passen de pagina's niet meer geheel op uw beeldscherm en moet u de horizontale schuifbalk van uw Internet verkenner gebruiken.<br /><br />";
$pgv_lang["preview_help"]					= "~PRINTERVRIENDELIJKE VERSIE~<br />PhpGedView biedt u de mogelijkheid om de informatie op het scherm af te drukken op papier.<br />Op iedere pagina is onder aan een koppeling \"Printervriendelijke versie\" opgenomen. Als u daarop klikt, verandert de opmaak van de pagina, zodat menu's, invoervakken, vraagtekens voor helpinformatie, etc. van het scherm zijn verdwenen.<br />Onder aan deze af te drukken pagina is de koppeling \"Afdrukken\" zichtbaar. Klikt u daarop, dan krijgt u het menuvenster van uw printer te zien, waarmee u de afdruk kunt maken.<br />Als u in dat venster op \"Print\" of \"Afbreken\" heeft geklikt, komt u terug in PhpGedView. Onder aan de pagina is dan de koppeling \"Terug\" te zien, waarmee u terugkeert naar de normale weergave.<br /><br />Let op: Hoewel op de printervriendelijke versie de overbodige koppelingen zijn verdwenen werken andere koppelingen, zoals namen, nog wel.<br /><br /><br />";
$pgv_lang["readme_help"]					= "<center>Zie het bestand <a href=\"readme.txt\" target=\"_blank\"><b>Readme.txt</b></a> voor meer informatie over dit onderwerp.</center>";
$pgv_lang["is_user_help"]					= "--- Deze helptekst is dezelfde als aan gebruikers en bezoekers wordt getoond. ---<br />--- Om ruimte te besparen, is geen aparte tekst voor beheerders beschikbaar. ---";
$pgv_lang["edit_raw_gedcom_help"]			= "~WIJZIG GEDCOM-GEGEVENS~<br /><br />Als u op deze koppeling klikt, worden in een nieuw venster de GEDCOM-regels weergegeven die de bron zijn voor de gegevens op deze pagina.<br />U kunt deze gegevens wijzigen. Let er echter wel op, dat u geldige GEDCOM 5.5 regels invoert. PhpGedView voert geen controle uit op de geldigheid ervan.<br />De gewijzigde en/of toegevoegde gegevens worden aan de PhpGedView bestanden toegevoegd als wijzigingen en moeten door een daarvoor geautoriseerde gebruiker worden geaccepteerd.";
$pgv_lang["RESN_help_title"]				= "Beperking toegang tot feiten";
$pgv_lang["RESN_help"]						= "~BEPERKING TOEGANG TOT FEITEN~<br /><br />Naast de normale privacy-instellingen, kunnen in PhpGedView eveneens beperkingen worden aangebracht op het tonen en wijzigen van feiten bij personen en gezinnen. De beperkingen kunnen worden aangebracht door iedereen die de informatie mag wijzigen, tenzij privacy-instellingen of eerder aangebrachte beperkingen dit verhinderen.<br />De volgende waarden kunnen worden toegekend:<br /><br /><b>#pgv_lang[none]#</b><br/>Site-beheerders, GEDCOM-beheerder en gebruikers met rechten om te wijzigen, kunnen de informatie wijzigen. De informatie is zichtbaar voor zover de door de beheerder ingestelde privacy-instellingen dit toelaten.<br /><br /><b>#pgv_lang[confidential]#</b><br />Alleen Site-beheerders en GEDCOM-beheerders kunnen de informatie zien en wijzigen. Het is verborgen voor alle andere (al dan niet aangemelde) gebruikers.<br /><br /><b>#pgv_lang[private]#</b><br />Site-beheerders en GEDCOM-beheerders kunnen de informatie zien en wijzigen. Als de informatie betrekking heeft op de gebruiker zelf, kan hij deze zien en, aangenomen dat hij wijzig-rechten heeft, ook aanpassen. De informatie blijft verborgen voor alle andere (al dan niet aangemelde) gebruikers.<br /><br /><b>#pgv_lang[locked]#</b><br />Deze instelling heeft geen effect op de zichtbaarheid van de informatie, maar beperkt wijzig-rechten tot Site- en GEDCOM-beheerders. Als de informatie betrekking heeft op de gebruiker zelf, kan hij deze zien en, aangenomen dat hij wijzig-rechten heeft, ook aanpassen.<br /><br />";


//-- Pages Help-messages
//-- Index-page
$pgv_lang["index_help"]						= "~DE WELKOMSTPAGINA~<br /><br />Deze pagina is de startpagina van de geselecteerde genealogie. U kunt hier altijd terugkeren, door te klikken op de knop \"Welkomstpagina\" in de menubalk.<br />Als er op deze site meerdere genealogieën beschikbaar zijn, kunt u er een uit het submenu van de knop \"Welkomstpagina\" kiezen.<br /><br />In deze HELP-informatie treft u, naast een toelichting op deze pagina, ook algemene informatie aan over deze website en het gebruik ervan.<br />Aan de orde komen:)<ul><li><a href=\"#index_portal\">#pgv_lang[welcome_page]#</a><li><a href=\"#header\">Menubalk</a><li><a href=\"#menu\">Menu's</a><li><a href=\"#header_general\">Algemene informatie</a><li><a href=\"#def\">Definities</a></ul><br />Op alle andere pagina's is de help (<b>Help bij deze pagina</b> in het Help-menu) beperkt tot informatie over de desbetreffende pagina.<br /><br />";

//-- Index-page Header
$pgv_lang["header_help"]					= "<div class=\"name_head\"><center><b>DE MENUBALK</b></center></div><br /><br />De menubalk wordt gebruikt om de functies van PhpGedView te benaderen. Afhankelijk van het gekozen website-thema is de menubalk altijd aan de bovenzijde of linkerzijde van het scherm te zien, en kan de knopindeling afwijken van de standaard indeling.<br /><br />In de menubalk vindt u de volgende knoppen/functies:<ul><li><a href=\"#header_search\">#pgv_lang[search]#</a><li><a href=\"#header_lang_select\">#pgv_lang[change_lang]#</a><li><a href=\"#header_user_links\">Gebruikerskoppelingen</a><li><a href=\"#header_favorites\">#pgv_lang[my_favorites]#</a></ul>";
$pgv_lang["header_search_help"]				= "~MENUBALK: ZOEKEN~<br />Met deze functie kunt u bijna op alles in de genealogie zoeken. Ook is een functie opgenomen om namen te zoeken, waarvan u de schrijfwijze niet precies weet.<br />Als u op de \">\" klikt, komt u op de Zoekpagina terecht, waar u verdere hulp kunt krijgen.<br /><br />";
$pgv_lang["header_lang_select_help"]		= "~MENUBALK: WIJZIG TAAL~<br />een van de eigenschappen van PhpGedView is, dat het zich automatisch aanpast aan de taal van de Internet Verkenner van de gebruiker.<br />Wanneer de taal niet door PhpGedView wordt ondersteund, of de gebruiker wil een andere taal selecteren, dan kan dit door de taal in de keuzelijst te selecteren, of, afhankelijk van het weergaventhema, op de vlag van het desbetreffende land te klikken.<br /><br />";
$pgv_lang["header_user_links_help"]			= "~MENUBALK: GEBRUIKERSKOPPELINGEN~<br />Dit groepje koppelingen is steeds op dezelfde plaats te vinden.<br />Als u zich nog niet heeft aangemeld, is alleen de koppeling \"Aanmelden\" zichtbaar.<br />Als u zich heeft aangemeld, ziet u de koppeling \"Aangemeld als ......\". Klikt u daarop, dan kunt u uw gebruikersgegevens wijzigen.<br />Met de koppeling \"Afmelden\" meldt u zich af bij de site.<br />Wanneer u over beheerderrechten beschikt, is ook de koppeling \"Beheren\" zichtbaar. Hiermee gaat u rechtstreeks naar het Menu Beheer.<br /><br />";
$pgv_lang["header_favorites_help"]			= "~MENUBALK: MIJN FAVORIETEN~<br />In deze keuzelijst zijn de personen zichtbaar, die u als favorieten heeft geselecteerd.<br />Zodra u uit deze keuzelijst een van de aanwezige favorieten kiest, krijgt u de details van deze persoon te zien.<br /><br />U kunt favorieten toevoegen op uw persoonlijke MyGedView pagina of, op de pagina \"Detailgegevens persoon\", door in de keuzelijst \"Mijn Favorieten\" te kiezen voor \"Toevoegen aan mijn favorieten\".<br /><br />Meer helpinformatie over Favorieten is beschikbaar op uw persoonlijke MyGedView pagina.<br /><br />";
$pgv_lang["header_theme_help"]				= "~MENUBALK: WIJZIG OPMAAK~<br />Als de site-beheerder dit heeft toegestaan, kunt u de opmaak van deze website wijzigen. Vorm en opmaak van deze site zijn vastgelegd in zogenaamde thema's.<br />In de keuzelijst \"Wijzig site-opmaak\" kunt u een nieuw thema selecteren. Als u bent aangemeld als gebruiker, dan wordt bij uw gegevens het gekozen thema vastgelegd.<br /> ";

//-- Index-page Menu
$pgv_lang["menu_help"]						= "<div class=\"name_head\"><center><b>MENU'S</b></center></div><br />In de menubalk bevinden zich, onder de menuknoppen, submenu's. Als u met uw muisaanwijzer over de menuknoppen gaat, krijgt u het submenu te zien.<br />Als u op een menuknop klikt, kiest u automatisch de eerste menukeuze van het submenu.<br />U vindt u in de menubalk de volgende menu's en koppelingen:</b><ul><li><a href=\"#menu_fam\">#pgv_lang[welcome_page]#</a><br /><li><a href=\"#menu_myged\">Mygedview Portal</a><br /><li><a href=\"#menu_charts\">Charts</a><br /><li><a href=\"#menu_lists\">Lists</a><br /><li><a href=\"#menu_annical\">Anniversary Calendar</a><br /><li><a href=\"#menu_clip\">#pgv_lang[clippings_cart]#</a><br /><li><a href=\"#menu_search\">Search</a><br /><li><a href=\"#menu_help\">Help</a></ul><br />";
$pgv_lang["menu_famtree_help"]				= "~MENU \"WELKOMSTPAGINA\"~<br />Het programma is in staat om meerdere genealogieën te bevatten. Met behulp van dit menu kiest u een genealogie, die u wilt raadplegen of wijzigen.<br />u komt dan terecht op de welkomstpagina van de desbetreffende genealogie.<br /><br />Als er slechts een genealogie in PhpGedView is opgenomen, wordt het submenu niet getoond.<br /><br />";
$pgv_lang["menu_myged_help"]				= "~MENU \"MYGEDVIEW\"~<br />In dit menu vindt u, als u bent aangemeld als gebruiker, alle aan u gerelateerde onderwerpen terug. U kunt naar uw persoonlijke MyGedView pagina toegaan, uw gebruikersgegevens aanpassen, of direct naar uw kwartierstaat of detailgegevens toegaan.<br />Als u beschikt over beheerderrechten, kunt u naar het hoofdmenu Beheer of naar het menu \"Beheer GEDCOM-bestanden en privacy-instellingen\".<br /><br /><br />";
$pgv_lang["menu_charts_help"]				= "~MENU \"OVERZICHTEN\"~<br />In dit menu zijn de volgende overzichten beschikbaar:<dl><dt><a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a></dt><dd>In dit overzicht worden de voorouders van de startpersoon van de kwartierstaat getoond. Als u bent aangemeld als gebruiker, kunt u de startpersoon zelf instellen, of bent u in sommige gevallen de startpersoon zelf al.</dd><dt><a href=\"?help=help_descendancy.php\">#pgv_lang[descend_chart]#</a></dt><dd>Dit overzicht toont de nakomelingen van de startpersoon. Voor de startpersoon geldt hier hetzelfde als bij het item <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a.</dd><dt><a href=\"?help=help_timeline.php\">#pgv_lang[timeline_chart]#</a></dt><dd>Met deze functie kunt u een of meer personen aan een tijdlijn toevoegen, waarna de gebeurtenissen van deze personen op een tijdlijn worden getoond..</dd><dt><a href=\"?help=help_relationship.php\">#pgv_lang[relationship_chart]#</a></dt><dd>Hiermee kunt u de verwantschap tussen een persoon en uzelf, of een ander persoon, vaststellen.</dd><dt><a href=\"?help=help_ancestry.php\">#pgv_lang[ancestry_chart]#</a></dt><dd>Deze lijkt veel op de <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, maar toont meer details en kan bekeken worden in een verschillende <a href=\"?help=chart_style_help\">#pgv_lang[chart_style]#</a>.</dd><dt><a href=\"?help=help_fanchart.php\">#pgv_lang[fan_chart]#</a></dt><dd>Deze lijkt veel op de <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, maar toont de gegevens in een meer grafische vorm.</dd></dl>";
$pgv_lang["menu_lists_help"]				= "~MENU \"DETAILGEGEVENS\"~<br />De volgende soorten detailgegevens zijn beschikbaar in dit menu:<dl><dt><a href=\"?help=help_indilist.php\">#pgv_lang[individual_list]#</a></dt><dd>Vanuit een selectie-overzicht kunt u de gewenste persoon selecteren.</dd><dt><a href=\"?help=help_famlist.php\">#pgv_lang[family_list]#</a></dt><dd>Vanuit een selectie-overzicht kunt u de gewenste persoon respectievelijk het gewenste gezin selecteren.</dd><dt><a href=\"?help=help_sourcelist.php\">#pgv_lang[source_list]#</a></dt><dd>Dit geeft een lijst van alle gebruikte bronnen in deze genealogie.</dd><dt><a href=\"?help=help_placelist.php\">#pgv_lang[place_list]#</a></dt><dd>Hier kunt u personen en gezinnen zoeken, waarvan een gebeurtenis is gekoppeld aan een bepaalde plaats. De getoonde lijst is gesplitst in links de personen en rechts de gezinnen.</dd><dt><a href=\"?help=help_medialist.php\">#pgv_lang[media_list]#</a></dt><dd>Deze optie ziet u alleen als dit door de beheerder is ingeschakeld.<br />Getoond worden alle koppelingen naar multimedia-items in deze genealogie.</dd></dl>";
$pgv_lang["menu_annical_help"]				= "~MENU \"GEBEURTENISKALENDER\"~<br />Met deze functie kunt u zien, welke gebeurtenissen er op een bepaalde dag of in een bepaalde maand of jaar in het verleden hebben plaatsgevonden..<dl><dt><a href=\"?help=day_month_help\">#pgv_lang[viewday]#</a></dt><dd>Deze optie geeft een overzicht van alle gebeurtenissen die op de huidige dag in een jaar hebben plaatsgevonden.</dd><dt><a href=\"?help=day_month_help\">#pgv_lang[viewmonth]#</a></dt><dd>Hiermee wordt de maandkalender getoond, met alle gebeurtenissen uit het verleden, in de huidige maand.</dd><dt><a href=\"?help=day_month_help\">#pgv_lang[viewyear]#</a></dt><dd>Deze brengt u naar de jaarkalender, waarop alle gebeurtenissen uit het huidige jaar worden getoond.</dd></dl>";
$pgv_lang["menu_clip_help"]					= "~MENU \"STAMBOOMKNIPSELS\"~<br />Als deze optie zichtbaar is in de menubalk, is deze door de sitebeheerder ingeschakeld.<br />Met de knipselbak kunt u stukjes uit de genealogie verzamelen in uw knipselbak en ze daarna, in GEDCOM 5.5 formaat, naar uw eigen computer downloaden.<br />Daar kunt u ze verder importeren in uw eigen genealogieprogramma.<br /><br />";
$pgv_lang["menu_search_help"]				= "~MENU \"ZOEKEN\"~<br />Dit menu heeft geen keuzes, maar brengt u meteen naar de zoekpagina van PhpGedView. Dit is dezelfde pagina, als die vanuit het \"Zoeken\"-veld elders op de pagina wordt gebruikt.<br /><br />";
$pgv_lang["menu_help_help"]					= "~MENU \"HELP\"~<br />#pgv_lang[help_help_items]#";

//-- Index-page Portal
$pgv_lang["index_portal_head_help"]			= "<div class=\"name_head\"><center><b>WELKOMSTPAGINA</b></center></div><br />";
$pgv_lang["index_portal_help"]				= "Deze Welkomstpagina geeft informatie over de gekozen genealogie en bestaat, net als de persoonlijke MyGedView-pagina, uit verschillende vakken. Per genealogie is er een aparte Welkomstpagina, die door de beheerder wordt vervaardigd.<br /><br />De volgende vakken kunnen zichtbaar zijn:<ul><li><a href=\"#index_welcome\">#pgv_lang[welcome]#</a><li><a href=\"#index_login\">#pgv_lang[login]#</a><li><a href=\"#index_events\">#pgv_lang[upcoming_events]#</a><li><a href=\"#index_onthisday\">#pgv_lang[on_this_day]#</a><li><a href=\"#index_favorites\">#pgv_lang[gedcom_favorites]#</a><li><a href=\"#index_stats\">#pgv_lang[gedcom_stats]#</a><li><a href=\"#index_media\">#pgv_lang[random_picture]#</a><li><a href=\"#index_loggedin\">#pgv_lang[users_logged_in]#</a><li><a href=\"#recent_changes\">#pgv_lang[recent_changes]#</a></ul>";
$pgv_lang["index_welcome_help"]				= "~WELKOM ......~<br />In dit vak treft u het volgende aan:<br />- De omschrijving van de actieve genealogie<br />- De datum en tijd<br />- Een bezoekteller, die het aantal bezoeken aan deze pagina weergeeft<br />- Een koppeling voor het wijzigen van de infopagina, indien u beschikt over beheerderrechten.<br /><br />";
$pgv_lang["index_login_help"]				= "~AANMELDEN~<br />In het vak \"Aanmelden\" kunt u zich vanaf deze pagina direct aanmelden met uw gebruikersnaam en wachtwoord. Indien u nog niet over een gebruikersnaam en wachtwoord beschikt, kunt u eveneens op \"Aanmelden\" klikken. U komt dan terecht op de pagina Aanmelden, waar u met de koppeling onder aan die pagina een gebruikersnaam kunt aanvragen.<br /><br /><br />#pgv_lang[new_password_help]#<br />";
$pgv_lang["index_events_help"]				= "~BINNENKORT....~<br />Dit vak toont een lijst met gebeurtenissen, die op deze dag en tot 30 dagen daarna in het verleden hebben plaatsgevonden.<br /><br />#pgv_lang[cal_download_user_help]#";
$pgv_lang["todo_help"]						= "~&quot;Te Doen&quot; taken blok~<br />Dit blok helpt u bij te houden welke  <b>Te Doen</b> taken in de database no uitstaan.<br /><br />Om &quot;Te Doen&quot; taken aan uw kaarten toe te voegen, moeten eerst de GEDCOM instellingen worden aangepast, zodat het  <b>_TODO</b> feit in de lijst komt te staan van feiten, die kunnen worden toegevoegd aan de kaarten van personen, gezinnen, families, bronnen en bewaarplaatsen.  Elk van genoemde lijsten, die u kunt vinden in de \"Opties voor wijzigen\" sectie van de GEDCOM configuratie, is onafhankelijk.  De volgorde van de lijstinhoud is niet belangrijk; u kunt de nieuwe toevoegingen aan het begin van elke lijst zetten.<br /><br />";
$pgv_lang["todo_show_other_help"]			= "Toon &quot;Te Doen&quot; taken, die zijn toegewezen aan andere gebruikers.";
$pgv_lang["todo_show_unassigned_help"]		= "Toon &quot;Te Doen&quot; taken, die nog niet aan iemand zijn toegewezen.";
$pgv_lang["todo_show_future_help"]			= "Toon &quot;Te Doen&quot; taken die een datum in de toekomst hebben.<br />Anders worden alleen items getoond met een datum in het verleden.";
$pgv_lang["yahrzeit_help"]					= "~YAHRZEITEN BLOK~<br />Dit blok toont de Yahrzeiten, welke aanstaande zijn, in de nabije toekomst.<br /><br />Yahrzeiten (enklevoud: Yahrzeit) zijn verjaardagen van het overlijden van een persoon.  Deze verjaardagen komen voor in de Joodse traditie; in veel andere tradities is dit in onbruik geraakt.  «Yahrzeit» kan ook worden gespeld ald «Jahrzeit» of «Yartzeit».<br /><br />De beheerder bepaald hoever vooruit het programma kijkt.  Hoe het blok wordt getoond kan ook nog verder worden aangepast.<br /><br />#pgv_lang[cal_download_user_help]#<br /><br />";
$pgv_lang["days_to_show_help"]				= "~#pgv_lang[days_to_show]#~<br /><br />Voer het aantal dagen in dat u wilt tonen.  Dit getal kan niet groter zijn dan <b>#DAYS_TO_SHOW_LIMIT#</b>.  Als u een grotere waarde invoert, zal de limiet worden toegepast.<br /><br />De limiet van het te tonen aantal, is ingesteld, door de beheerder, in de  GEDCOM instellingen,  Display en Layout sectie, Verberg &amp; Toon sub-sectie.";
$pgv_lang["random_media_persons_or_all_help"] = "~#pgv_lang[random_media_persons_or_all]#~<br /><br />Met deze optie bepaalt u welk type media wordt getoond.<br /><br />Als u <b>#pgv_lang[random_media_persons]#</b> selecteert, wordt alleen media getoond m.b.t. personen.  Vaak zijn de foto's van personen.<br />Als u <b>#pgv_lang[random_media_events]#</b> selecteert, wordt alleen media getoond m.b.t. feiten of gebeurtenissen.  Dit kan bijv. een afbeelding van een certificaat zijn.<br />Als u <b>#pgv_lang[all]#</b> selecteert, zal dit blok alle types media tonen.";
$pgv_lang["random_media_filter_help"]		= "~#pgv_lang[filter]#~<br /><br />U kunt beperkingen aanbrengen in de formaten en types media objecten, wat mag worden getoond in het Willekeurige Media blok.  Als een bepaalde checkbox is aangevinkt, is het Willekeurige Media blok toegestaan om media objecten van dat formaat of type te tonen.<br /><br />Formaten of Types code dat in uw database aanwezig zijn, maar niet in deze checkbox lijsten staan, worden verondersteld te mogen worden getoond.<br />Bijvoorbeeld: als uw database Media objecten van het formaat <b><i>pdf</i></b> bevat, is het het Willekeurige Media blok altijd toegestaan deze te tonen.  Op dezelfde wijze is het Willekeurige Media blok altijd toegestaan om Media objecten van het type <b><i>special</i></b> te tonen, als deze bestaan in uw database.";
$pgv_lang["basic_or_all_help"]				= "~#pgv_lang[basic_or_all]#~<br /><br />Deze optie laat u enkele gedateerde gebeurtenissen verbergen.  Bijvoorbeeld: #factarray[DIV]#, #factarray[CREM]#, #factarray[GRAD]#, #factarray[BARM]#, #factarray[FCOM]#, enz. zouden alle gedateerd moeten zijn.<br /><br />Als u <b>Ja</b> selecteerd, worden alleen Geboorten, Sterfgevallen en Huwelijken getoond. Kiest u voor <b>Nee</b>, dan worden alle gedateerde gebeurtenissen getoond.";
$pgv_lang["style_help"]						= "~#pgv_lang[style]#~<br /><br />Met deze optie kunt u instellen hoe de informatie wordt getoond.<br /><br />Als u <b>#pgv_lang[style1]#</b> selecteert, wordt de informatie getoond in tekst formaat, min of meer identiek aan wat u ziet in de diverse Diagram vakken.  Dit formaat lijkt goed in de blokken die aan de rechter zijde van de pagina worden getoond.<br /><br />Als u <b>#pgv_lang[style2]#</b> selecteert, wordt de informatie getoond in tabelvorm. Deze tabelvorm is meer geschikt om te tonen in grotere blokken, zoals deze worden getoond op de linker zijde van de pagina.";
$pgv_lang["sort_style_help"]				= "~#pgv_lang[sort_style]#~<br /><br />Deze optie gebruikt u om aan te geven hoe de informatie moet worden gesorteerd.<br /><br />Als u <b>#pgv_lang[by_alpha]#</b> selecteert, wordt de informatie in alphabetische volgorde getoond. Als <b>#pgv_lang[by_anniv]#</b> is geslecteerd, wordt de informatie gesorteerd op datum, met de meest recente verjaardagen eerst.";
$pgv_lang["cal_dowload_help"]				= "~#pgv_lang[cal_download]#~<br /><br />Met deze optie stelt u in of de knop om de Kalender Gebeurtenissen te downloaden wordt getoond aan ingelogde gebruikers. Het gedownloade kalender bestand kan worden geïmporteerd in compatible programma's zoals Microsoft Outlook. Vervolgens kunt u, bijvoorbeeld,  automatische e-mail- of verjaardags herinneringen laten genereren.<br /><br />Indien ingesteld op <b>#pgv_lang[no]#</b>, kunnen de ingelogde gebruikers het kalender-bestand niet downloaden.  Indien ingesteld op <b>#pgv_lang[yes]#</b>, wordt de Download knop getoond.  Deze knop wordt nooit getoond aan niet-ingelogde gebruikers.</b></b>";
$pgv_lang["cal_download_user_help"]			= "Als u bent ingelogd, kunt u mogelijk aan de onderzijde van de lijst een ikoon <img src='images/hcal.png' alt='' /> zien. Als u op hierop klikt, kunt u de lijst downloaden als kalender bestand. Het gedownloade kalender bestand kan worden geïmporteerd in compatible programma's zoals Microsoft Outlook. Vervolgens kunt u, bijvoorbeeld, automatische e-mail- of verjaardags herinneringen laten genereren.<br /><br />Als u dit ikoon niet ziet, kan de beheerder de download-optie hebben uitgeschakeld. Bezoekers, die niet zijn ingelogd, kunnen dit ikoon niet zien en het kalender bestand niet downloaden.<br />";
$pgv_lang["index_charts_help"]				= "~#pgv_lang[charts_block]#~<br />In dit blok kan een kwartierstaat, nakomelingen diagram of zandloper diagram worden getoond op de Welkom pagina of op de MyGedView pagina.  Door ruimtebeperkingen is het beter dit blok alleen aan de linker zijde van de pagina te plaatsen.<br /><br />Als dit blok op de Welkom pagina staat, wordt de startpersoon bepaald door de beheerder.  Indien dit blok door een gebruiker op diens MyGedView pagina is geplaatst, worden de instellingen bepaalt door die gebruiker.<br /><br />Het gedrag van deze diagrammen is identiek aan het gedrag ervan als ze via de menu's worden gestart.  Klik op het vak van een persoon, om meer details van die persoon te zien.<br /><br />";
$pgv_lang["index_onthisday_help"]			= "~OP DEZE DAG, IN HET VERLEDEN...~<br />Dit vak toont een lijst met gebeurtenissen, die op deze dag in het verleden hebben plaatsgevonden. De gebeurtenissen hebben betrekking op personen uit de actieve genealogie.<br /><br />#pgv_lang[cal_download_user_help]#";
$pgv_lang["index_favorites_help"]			= "~FAVORIETEN IN DEZE GENEALOGIE~<br />In het vak \"Favorieten in deze genealogie\" kan de site-beheerder personen uit de genealogie plaatsen, zodat gebruikers deze makkelijk kunnen vinden.<br />Door op de namen van de personen te klikken, kunt u direct de details van de persoon inzien. Met behulp van de twee miniaturen rechts in het vak kunt u op deze plaats al wat meer gegevens zien, of naar een andere functie toe gaan.<br /><br />Zowel deze favorieten als uw eigen favorieten (zie de informatie op uw persoonlijke MyGedView pagina) zijn altijd beschikbaar in het keuzemenu boven aan het scherm.<br /><br />";
$pgv_lang["index_add_favorites_help"]		= "~ADD A FAVORITE~<br />Met dit formulier kunt u  een nieuw fovoriet item aan uw favorietenlijst toevoegen.<br /><br />U moet een ID van de persoon, het gezin of de bron inullen, die of dat u wilt oplsaan als een favoriet. Ook kunt u een URL en een tietel toevoegen.  Het Notitie veld is optioneel en kan worden gebruikt om uw favoriet te omschrijven.  Alles wat in het Notititie veld is ingevuld zal in het Favorieten blok, na het item, worden getoond.<br /><br />";
$pgv_lang["index_stats_help"]				= "~STATISTIEKEN VAN DEZE GENEALOGIE~<br />Het vak \"Statistieken van deze genealogie\" toont enkele gegevens over het dit bestand, zoals het aantal erin aanwezige personen en de datum waarop het is aangemaakt.<br />Voor meer informatie kunt u contact opnemen met de contactpersoon van deze genealogie (zie onder aan deze pagina).<br /><br />";
$pgv_lang["index_common_names_help"]		= "~ACHTERNAMEN TOP 10~<br />In dit blok wordt de Top 10 van de meest voorkomende achternamen getoond. Er is een kolom met de achternamen en een kolom met daarin de aantallen keren hoevaak die achternamen voorkomen.<br /><br />De namen in de 1ste kolom zijn aanklikbaar. Als u op een naam klikt, wordt u naar de \"Personen\" pagina gebracht, waar al op de aangeklikte naam is gefilterd.<br /><br />Hoewel dit blok de TOP 10 heet, kan de beheerder een ander aantal instellen. Het zou dus ook de TOP 5 of TOP 15 kunnen heten. Wat de ingestelde waarde is, kunt u zien aan de titel van het blok: \"ACHTERNAMEN TOP xx\".<br /><br />";
$pgv_lang["index_common_given_names_help"]	= "~VOORNAMEN TOP 10~<br />In dit blok wordt de Top 10 van de meest voorkomende voornamen getoond. Er is een aparte kolom voor de voornamen van mannen en een kolom voor de voornamen van vrouwen. Er kan nog een derde kolom aan zijn toegevoegd: De benamingen van personen, waarvan de voornamen niet bekend zijn. In deze kolom kunt u dan zien welke afkorting daar meestal voor wordt gebruikt.<br /><br />Hoewel dit blok de TOP 10 heet, kan de beheerder een ander aantal instellen. Het zou dus ook de TOP 5 of TOP 15 kunnen heten. Wat de ingestelde waarde is, kunt u zien aan de titel van het blok: \"VOORNAMEN TOP xx\".<br /><br />";
$pgv_lang["index_media_help"]				= "~WILLEKEURIGE AFBEELDING~<br />In dit blok wordt, telkens wanneer u deze pagina bezoekt, een willekeurig multimedia-item (foto, afbeelding van een document) weergegeven.<br />Door op de afbeelding te klikken krijgt u een vergrote weergave te zien.<br />Als u op de tekst onder de afbeelding klikt, kunt u direct naar de detailgegevens daarvan springen.<br /><br />";
$pgv_lang["index_loggedin_help"]			= "~AANGEMELDE GEBRUIKERS~<br />Dit vak toont een lijst met gebruikers die op dat moment zijn aangemeld.<br /><br />";
$pgv_lang["index_gedcom_news_help"]			= "~GENEALOGIE PRIKBORD~<br />Dit vak is het prikbord van deze genealogie. De beheerder kan daarop belangrijke mededelingen, weetjes en koppelingen naar andere websites plaatsen.<br /><br />Als u zelf een bericht wilt plaatsen, kunt u hiervoor contact opnemen met de beheerder.";
$pgv_lang["recent_changes_help"]			= "~RECENTE WIJZIGINGEN~<br />In dit vak worden de recente wijzigingen in deze genealogie getoond. Hiervoor wordt de datum van laatste wijziging in de persoons- en gezinsinformatie gebruikt.";
$pgv_lang["gedcom_news_limit_help"]			= "U kunt het aantal artikelen van het Prikbord-blok beperken. Daarmee reduceert u tevens de lengte van het blok..<br /><br />Deze optie bepaalt of er geen limiet wordt toegepast, of een limiet op basis van leeftijd, of een limiet op basis van het aantal artikelen.<br /><br />";
$pgv_lang["gedcom_news_flag_help"]			= "Voer hier de limiet-waarde in.<br /><br />Als u heeft gekozen voor de optie om de lengte v.h. Prikbordblok te beperken d.m.v. de leeftijd v.d. artikelelen, dan is de waarde, die u invult, het aantal dagen dat een artikel zichtbaar blijft. Artikelen die ouder zijn dan de ingevulde waarde, worden niet getoond. <br /><br />Als u heeft gekozen voor de optie om de lengte v.h. Prikbordblok te beperken door het aantal artikelelen te beperken, dan is de waarde, die u invult, het aantal artikelen dat getoond zal worden, gesorteerd op leeftijd. De overige artikelen worden verborgen.<br /><br />Indien u een 0 (nul) invoert, is er geen limeit. Alle artikelen zullen worden getoond.<br /><br />";
$pgv_lang["gedcom_news_archive_help"]		= "Om de lenget van het Prikbord blok te beperken, heeft de beheerde enkele artikelen verborgen.<br />Om deze verborgen artikelen zichtbaar te maken, klikt u op de <b>#pgv_lang[gedcom_news_archive]#</b> link.<br /><br />";
$pgv_lang["index_htmlplus_help"]			= "~#pgv_lang[htmlplus_block_name]#~<br />In dit blok kan de beheerder informatie toevoegen aan de Welkomst- of Portal- pagina.<br />Het doel van dit blok is vergelijkbaar met #pgv_lang[html_block_name]#, #pgv_lang[gedcom_news_block]# en #pgv_lang[gedcom_stats_block]# blok, maar de beheerder heeft meer controle en invloed op de manier van presentatie.<br /><br />";
$pgv_lang["index_htmlplus_title_help"]		= "~#factarray[TITL]#~<br />De tekst in dit titelvak wordt ofwel weggelaten of moet kort zijn.<br />Als het titelvak leeg blijft, wordt het Geavanceerd HTML blok, op de Welkomst- of Portal- pagina, weergegeven als een eenvoudig blok, zoals het gewone HTML blok.<br />Als het titelvak wel is ingevuld, wordt het Geavanceerd HTML blok weergegeven zaols alle blokken, compleet met een blok titel balk, met daarin de tekst die u in het titelvak heeft ingevuld.<br /><br />";
$pgv_lang["index_htmlplus_template_help"]	= "~#pgv_lang[htmlplus_block_templates]#~<br />Ter assistentie, als u pas begint te werken met dit blok, hebben we een aantal standard templates gemaakt.<br />Als u een van deze templates selecteert, zal een kopie in het tekstvak worden gezet, dat u dan naar wens kunt aanpassen.<br /><br />";
$pgv_lang["index_htmlplus_content_help"]	= "~#pgv_lang[htmlplus_block_content]#~<br />In tegenstelling tot #pgv_lang[html_block_name]#, #pgv_lang[gedcom_news_block]#, en #pgv_lang[gedcom_stats_block]# blok, heeft u volledige controle over het aanzien van uw blok.  U kunt HTML tags gebruiken. Het blok gebruikt de CSS style sheets van het huidige actieve thema.  Referenties naar informatie in de huidig actieve genealogische database kan eveneens worden ingesloten in de tekst.<br /><br />Database referenties worden in de tekst opgenomen d.m.v. sleutelwoorden, welke zijn ingesloten door <b>&#35;</b> symbolen.  Bijvoorbeeld: <b>&#35;totalFamilies&#35;</b> zal het aantal gezinnen in de database weergeven.  Het zou voor kunnen komen dat u wilt verwijzen naars een database referentie, i.p.v. de inhoud van die referentie te tonen.  Om dat te doen moet u de symbolen <b>&#35;</b>, die het sleutelwoord insluiten, vervangen door hun symbolisch equivalent.<br />  Als uw tekst, bijvoorbeeld, <b>&amp;&#35;35;totalFamilies&amp;&#35;35;</b> bevat, zal het worden getoond als <b>&#35;totalFamilies&#35;</b> i.p.v. het tonen van de inhoud van die variabele.<br /><br />Voor een compleet voorbeeld van het genruik van dit blok, kunt u eens kijken naar de &quot;#pgv_lang[gedcom_stats_block]#&quot; template, welke u kunt vinden in de blocks/ map. Het gebruikt vele van de tags-styles, incl. taal- en help-links.<br /><br />De <b>#pgv_lang[htmlplus_block_keyword]#</b> template bevat een volledige lijst met alle ondersteunde sleutelwoorden.<br /><br />";
$pgv_lang["index_htmlplus_compat_help"]		= "~#pgv_lang[htmlplus_block_compat]#~<br />Door dit aan te vinken zal deze versie van dit blok compatible met oudere versies.<br />Als het is aangevinkt, zullen oude en nieuwe sleutelwoorden worden herkend en juist worden geïnterpreteerd.<br /><br />Bijvoorbeeld:<br /><i>(De voorbeelden zijn in het Engels, omdat de afkortingen en variabelen ook in het Engels zijn)</i><br />De tekst <b>&#35;TOTAL_FAM&#35;</b> zal worden herkend als equivalent van <b>&#35;totalFamilies&#35;</b>, <b>&#35;FIRST_DEATH_PLACE&#35;</b> is gelijk aan <b>&#35;firstDeathPlace&#35;</b>, <b>&#35;TOP10_BIGFAM&#35;</b> is gelijk aan <b>&#35;topTenLargestFamily&#35;</b>, enz.<br /><br />Tenzij het absoluut noodzakelijk is, moet u de Compatibility mode niet gebruiken.<br /><br />";
$pgv_lang["index_htmlplus_gedcom_help"]		= "~#pgv_lang[htmlplus_block_gedcom]#~<br />Selecteer de database, waar de sleutelwoorden naar verwijzen.<br /><br />Uw  site ondersteunt meerdere databases.  Sleutelwoorden zoals: <b>&#35;totalFamilies&#35;</b> kunnen slechts naar één database verwijzen.  U kunt de database aanwijzen dei moet worden gekozen voor het gebruik van zulke sleutelwoorden.  Elk #pgv_lang[htmlplus_block_name]# blok heeft slechts toegang tot één database.<br /><br />";
$pgv_lang["showUnknown_help"]				= "~#pgv_lang[showUnknown]#~<br />Verberg of toon de lijst met namen van personen, waarvan het geslacht niet bekend is.<br /><br />Het #pgv_lang[block_givn_top10]# blok verbergt altijd de lijst met voornamen van personen, waarvan het geslacht niet bekend is, als er in uw database deze personen niet aanwezig zijn.<br /><br />Met deze optie kunt u eveneens deze lijst verbergen, als er wel zulke personen in uw database aanwezig zijn.<br /><br />";

//-- Index-Page Help
$pgv_lang["help_help"]						= "De bouwers van PhpGedView besteden veel aandacht aan de begrijpelijkheid en het bedieningsgemak van het programma.<br />Het uitgangspunt is, dat iedere gebruiker zonder voorkennis in staat moet zijn, zijn weg in PhpGedView te vinden.<br />Helaas lukt dat niet altijd, soms zijn bewerkingen nu eenmaal niet op een eenvoudiger manier uit te voeren.<br />Ook omdat veel gebruikers nauwelijks bekend zijn met Internet en computers, is aan PhpGedView een grote hoeveelheid helpinformatie toegevoegd.<br />Mocht u desondanks nog vragen hebben, dan kunt u zich altijd tot de beheerder van de site wenden. Deze zal u graag van dienst zijn.<br /><br />Op dit moment zijn verschillende soorten helpinformatie voorhanden:<br />";
$pgv_lang["help_page_help"]					= "<i>Help per pagina</i><br />Op iedere pagina is algemene helpinformatie beschikbaar.<br />U krijgt deze in een apart venster te zien, als u op \"Help\" klikt in de menubalk. of in het keuzemenu Help kiest voor \"Help bij deze pagina\".<br /><br />Daarnaast is in veel gevallen detailinformatie voorhanden, die u door middel van de contextuele help kunt opvragen.<br />Hiervoor kunt u op de diverse vraagtekens op de pagina klikken.<br />Zijn deze niet zichtbaar, dan staat waarschijnlijk de contextuele help uitgeschakeld. U kunt deze activeren door in het helpmenu te kiezen voor \"Toon contextuele help\".<br />";
$pgv_lang["help_content_help"]				= "<i>Inhoudsopgave</i><br />Als u hierop klikt, verschijnt een nieuw venster met daarin de belangrijkste helponderwerpen.<br />";
$pgv_lang["help_faq_help"]					= "<dl><dt><b>VGV Lijst</b></dt><dd>#pgv_lang[text_faq_help]#</dd></dl>";
$pgv_lang["help_HS_help"]					= "<dl><dt><b>#pgv_lang[hs_title]#</b></dt><dd>#pgv_lang[hs_intro]#</dd></dl>";
$pgv_lang["help_qm_help"]					= "<i>Toon/verberg contextuele help</i><br />Deze optie zorgt ervoor, dat aan de rechterkant van de meeste koppelingen, keuzemenu's, vakken en invoervelden, een vraagteken zichtbaar wordt. Als u op het \"?\" klikt, krijgt u een extra venster met specifieke informatie over die optie of functie.<br /><br />U kunt deze optie in- en uitschakelen door op deze menuoptie te klikken.<br />";

//-- Index-page Definitions
$pgv_lang["def_help"]						= "<div class=\"name_head\"><center><b>BEGRIPPENLIJST</b></center></div><br /><br />Hier volgt een beschrijving van enkele begrippen, die op deze website worden gebruikt:<ul><li><a href=\"#def_gedcom\">GEDCOM-bestand</a><br /><li><a href=\"#def_gedcom_date\">Datumgebruik</a><li><a href=\"#def_pgv\">#pgv_lang[inc_phpgedview]#</a><li><a href=\"#def_portal\">Portaal</a><li><a href=\"#def_theme\">Thema's</a></ul>";
$pgv_lang["def_portal_help"]				= "~PORTAAL~<br />Op een website is het portaal het centrale toegangspunt tot de website. Hier treft u in het algemeen de menu's aan voor toegang tot de informatie op de site, maar ook zaken als een prikbord, algemene mededelingen, etc.<br />";
$pgv_lang["def_gedcom_help"]				= "~GEDCOM-BESTAND~<br />Een GEDCOM-bestand is een bestand, dat genealogische informatie bevat. Deze informatie wordt in het bestand opgeslagen volgens het GEDCOM-formaat. Dit is een algemeen aanvaarde standaard voor het uitwisselen van genealogische informatie en stelt de gebruikers in staat om informatie tussen genealogiepakketten uit te wisselen.<br />Een citaat uit de inleiding van de GEDCOM 5.5 standaard:<div class=\"list_value_wrap\">De GEDCOM-standaard is ontwikkeld door de kerk van Jezus Christus, Heilige der laatste dagen, om een flexibel en uniform formaat vast te stellen om elektronisch vastgelegde genealogische gegevens uit te wisselen.&nbsp; GEDCOM is een acroniem voor <i><b>GE</b></i>nealogical <i><b>D</b></i>atabase <i><b>C</b></i>ommunication.&nbsp; Het doel is om het delen van genealogische informatie te ondersteunen en daarmee de ontwikkeling van een groot aantal softwareproducten voor genealogen, historici en andere onderzoekers.</div><br />Een exemplaar van de GEDCOM 5.5.1 standaard, waarop PhpGedView is gebaseerd, kunt u in PDF-formaat downloaden van: :&nbsp; <a href=\"http://www.phpgedview.net/ged551-5.pdf\" target=_blank>GEDCOM 5.5.1 Standard</a><br /><br />Een GEDCOM-bestand bevat alle informatie over personen en gezinnen, zoals feiten, data, gebeurtenissen, etc. Aan de vastlegging van de informatie worden regels gesteld, waardoor de uitwisselbaarheid van de informatie tussen systemen wordt bevorderd.<br />";
$pgv_lang["def_gedcom_date_help"]			= "~DATUMS IN EEN GEDCOM-BESTAND~<br />Hoewel in datumvelden van een GEDCOM-bestand in principe iedere tekst kan worden opgeslagen, geeft de GEDCOM-standaard toch een aantal voorschriften voor het vastleggen van datums en tijdsperiodes.<br />Dit zorgt ervoor, dat ook datuminformatie uitwisselbaar blijft, doordat het steeds op een eenduidige wijze wordt vastgelegd.<br />Hier volgt een aantal voorbeelden van uniform datumgebruik:<br />Een volledige datum wordt genoteerd als 'dd Mmm yyyy', waar Mmm staat voor de Engelse drieletterige afkorting van de maand. Dus: 01 May 2004 en 31 Mar 1800.<br />Soms is maar een deel van de datum bekend en kan worden volstaan met Mar 1800 of alleen 1800.<br />Ook kan bij een datum iets worden aangegeven over de mate van zekerheid. Er worden dan de voorvoegsels 'ABT' (ongeveer), 'EST' (geschat aan de hand van andere gebeurtenissen) en 'CAL' (berekend aan de hand van  bijvoorbeeld iemands leeftijd).<br />Een tijdperiode wordt aangegeven door de voorvoegsels 'BEF' (voor) en 'AFT' (na).<br />Let erop dat u de maanden in de datum en de voorvoegsels in het Engels gebruikt. Wijkt u hiervan af, dan zullen genealogieprogramma's niet in staat zijn om de datum als zodanig te herkennen en ermee te rekenen.<br />";
$pgv_lang["def_gramps_help"]				= "~GRAMPS XML Database file~<br />Een citaat van het  GRAMPS Project: <div class=\"list_value_wrap\">GRAMPS helpt u om uw familie stamboom te volgen. Het laat u genealogische gegevens opslaan, wijzigen en onderzoeken. GRAMPS poogt om alle gemeenschappelijke mogelijkheden van andere genealogische programma's aan te bieden.<br />Maar, nog belangrijker,  om een aanvullende mogelijkheid van integratie te bieden, die niet gemeenschappelijk in deze andere programma's aanwezig zijn.<br />Dat is de mogelijkheid om ieder soort gegevens, stukje bij beetje,  direct in GRAMPS in te voeren. Vervolgens is het dan mogelijk om elke/alle data gebeurtenis(sen) in de gehele database te herordenen/mannipuleren (in elke gewenste volgorde). Dit om de gebruiker te assisteren met onderzoek, analyse en correlatie, met de mogelijkheid om eventuele gaten in de verwantschappen te vullen.</div><br />Een kopie van het GRAMPS XML formaat v1.1.0 <a href=\"http://www.gramps-project.org/xml/1.1.0/\" target=\"_blank\"><i>kan hier worden gevonden</i></a> in zowel RELAX NG Schema formaat en DTD formaat.<br /><br />Voor meer informatie over het GRAMPS Project bezoek <a href=\"http://gramps-project.org/\" target=\"_blank\">http://gramps-project.org/</a>";
$pgv_lang["def_pgv_help"]					= "~PHPGEDVIEW~<br />PhpGedView (afgekort PGV) is een programma, ontworpen door John Finlay, waarmee genealogische bestanden via webpagina's kunnen worden bekeken.<br />Op den duur moet het groeien naar een platform, waarop verschillende gebruikers met elkaar samenwerken om te werken aan een genealogie.<br />PhpGedView is uitgegroeid tot een product, dat op vele manieren is in te stellen, zodanig, dat het in een specifieke behoefte voorziet.<br />Inmiddels werkt een uitgebreid internationaal team aan de verdere ontwikkeling van PhpGedView.<br />";
$pgv_lang["def_theme_help"]					= "~THEMA'S~<br />Deze site kan veranderen van uiterlijk. Hoe de site er in een uiterlijk uitziet, wordt vastgelegd in een \"thema\". De beheerder bepaalt in principe het thema dat wordt toegepast, maar kan ook aangeven dat de aangemelde gebruikers dit zelf kunnen wijzigen.<br />U kunt dan zelf uitproberen welk thema het beste bevalt.<br />Het gekozen thema wordt actief zodra u zich als gebruiker heeft aangemeld.<br />";

//-- Index-page MyGEDCOM
$pgv_lang["mygedview_portal_help"]			= "~#pgv_lang[mygedview]#~<br />Dit is uw persoonlijke MyGedView-pagina.<br />Als u voor de eerste keer op deze pagina bent, treft u al een aantal vakken aan met: informatie uit de stamboom, uw berichten, uw favorieten en koppelingen naar uw eigen gegevens. <br />U kunt zelf bepalen hoe u deze pagina indeelt en welke vakken erop zichtbaar zijn. Om de indeling te wijzigen kunt u klikken op de koppeling \"MyGedView indelen\" in het vak \"Welkom .....\".<br /><br />U vindt daar meer Help bij de diverse opties.<br /><br />";
$pgv_lang["mygedview_customize_help"]		= "~#pgv_lang[mygedview]# INDELEN~<br />U heeft de mogelijkheid, om deze pagina naar eigen believen in de delen. U kunt vakken verwijderen en toevoegen, en bepalen waar deze op het scherm komen te staan.<br />Door op de koppeling \"MyGedView indelen\" te klikken, in het \"Welkom.....\" vak, wordt een venster geopend waarmee u de veranderingen kunt aanbrengen.<br />Ook treft u daar meer hulp over deze functie aan.<br /><br />";
$pgv_lang["mygedview_message_help"]			= "~MIJN BERICHTEN~<br />In dit vak vindt u de berichten, die u door de sitebeheerder of door andere gebruikers zijn toegestuurd.<br />U kunt ook zelf aan andere gebruikers een bericht sturen. Selecteer daarvoor de geadresseerde en klik op \"Verzenden\". In het nieuwe venster kunt u uw bericht intikken en verzenden.<br /><br />Om in de lijst een bericht volledig weer te geven, kunt u op het onderwerp klikken of op de \"+\" ernaast. U kunt meerdere berichten tegelijk verwijderen door ze aan te vinken in de vakjes ernaast en te klikken op \"Verwijder geselecteerde berichten.<br />";
$pgv_lang["mygedview_favorites_help"]		= "~MIJN FAVORIETEN~<br />Favorieten zijn een soort bladwijzers.<br /><br />Stel u heeft gegevens op deze site, die u regelmatig wilt raadplegen. Dan is \"Mijn Favorieten\" zeer geschikt om daarin een vermelding van op te nemen.<br />Toen \"Mijn Favorieten\" werd toegevoegd aan dit programma, was het alleen nog mogelijk om personen of gezinnen op te nemen in de lijst. Nu is het ook mogelijk om ook notities, media en externe links op te nemen in \"Mijn Favorieten\".<br /><br />Hoe krijgt u toegang tot uw Favorieten?<br />Waar u zich ook bevindt op deze site, zult u bovenin  een link, of een pull-down lijst zien: <b>Favorieten</b>. Afhankelijk van de, door u gekozen, site opmaak kan zich dit links, rechts, of in het midden (bovenin) bevinden. U kunt daar op een van uw Favorieten klikken en dan direct naar de desbetreffende pagina worden gevoerd.Aan dit lijstje kunt u zelf personen toevoegen, waarvan u de gegevens regelmatig wilt zien.<br />Als op een gegevenspagina bent van personen, gezinnen, bronnen, enz., ziet u bovenin het pulldown-lijst ook staan \"- Toevoegen aan mijn favorieten -\". Klikt u hierop, dan wordt de bewuste pagina aan uw Favorietenlijst toegevoegd. Op sommige pagina's vindt u ook een directe link \"- Toevoegen aan mijn favorieten -\"<br /><br /><b> Mijn Favorieten blok</b><br />U kunt uw eigen Favorieten blok toevoegen aan uw \"My Gedview\" pagina. Vanaf dat blok kunt u behalve genoemde gegevens ook nog media, notities, of zelfs externe links toevoegen.<br /><br />";
$pgv_lang["mygedview_myjournal_help"]		= "~MIJN NOTITIEBLOK~<br />Voor uw eigen gebruik kunt u notities maken op uw notitieblok. Als u een volgende keer de site bezoekt, kunt u de notities weer bekijken, aanpassen of verwijderen.<br /><br />De notities zijn alleen voor u zelf zichtbaar.<br /><br />";
$pgv_lang["mygedview_welcome_help"]			= "<dl>~WELKOM ......~<dt>In dit vak treft u het volgende aan:</dt><dd>- De omschrijving van de actieve genealogie</dd><dd>- De datum en tijd</dd><dd>- De volgende koppelingen</dd><dd> - - #pgv_lang[myuserdata]#</dd><dd> - - #pgv_lang[my_pedigree]#</dd><dd> - - #pgv_lang[my_indi]#</dd><dd> - - #pgv_lang[customize_page]#</dd></dl><b>Opmerking:</b><br /> de koppelingen naar #pgv_lang[my_pedigree]# en #pgv_lang[my_indi]# worden alleen weergegeven, als u in de genealogie voorkomt.<br /><br />";

//-- Pedigree-page
$pgv_lang["help_pedigree.php"]				= "~DE KWARTIERSTAAT~<br /><br />De Kwartierstaat Pagina is de eerste pagina van dit programma.<br /><br /><i>MEER HELP</i><br />Aan de rechterkant van sommige velden en koppelingen is een vraagteken zichtbaar. Als u hierop klikt, verschijnt een schermpje met mee informatie over het desbetreffende onderwerp.<br /><br /><i>AANMELDEN</i><br />Hoewel men zich op elke pagina kunt aanmelden, doet men dit meestal toch op de eerste pagina, omdat men pas dan over alle toegestane informatie kan beschikken.<br />U meldt u aan, door op de betreffende koppeling aan de bovenzijde van de pagina te klikken.<br />Bezoekers die een gebruikersnaam en wachtwoord willen aanvragen, klikken ook op de koppeling \"Aanmelden\"<br /><br /><i>DE KWARTIERSTAAT</i><br />De meeste bezoekers en gebruikers zullen weten wat een kwartierstaat is, maar toch nog een, bescheiden uitleg van deze Kwartierstaat:<br />Een kwartierstaat is in feite een opsomming van alle voorouders van de startpersoon, de \"probant\". Deze wordt als eerste weergegeven, dan diens ouders, de grootouders, de overgrootouders, enzovoort. De probant is generatie I, diens ouders generatie II, enz.<br /><br /><i>PERSOONSVAKKEN IN DE KWARTIERSTAAT</i><br />Per persoon wordt een aantal gegevens getoond, zoals namen, geboorte- en overlijdensdatum en -plaats. Door op de persoonsnaam te klikken, komt u op het detailscherm van de persoon. Tevens zijn twee speciale knoppen zichtbaar (mits de optie \"Toon details\" aan staat):<br /><br /><i>KNOP \"KWARTIERSTAAT\" IN PERSOONSVAK</i><br />Afhankelijk van de instelling van de website, kunt u deze knop activeren door erop te klikken of er met de muis overheen te gaan. Er verschijnt dan een schermpje, waarin u kunt klikken op: de kwartierstaat van deze persoon, zijn/haar afstammelingen, zijn/haar gezin en de persoonsschermen van eega en kinderen.<br /><br /><i>VERGROOTGLAS IN PERSOONSVAK</i><br />Afhankelijk van de instelling van de website, kunt u deze knop activeren door erop te klikken of er met de muis overheen te gaan. Er verschijnt dan een schermpje, waarin extra informatie over de persoon wordt gegeven. Dit betreft onder andere de voorhanden zijnde feiten zoals beroepen, verhuizingen, enz.<br /><br /><i>DE PIJLEN LINKS EN RECHTS VAN DE VAKKEN</i><br />Door op de pijlen (links van het meest linkse vak en rechts van het meest rechtse vak) te klikken, kunt u het scherm \"verschuiven\", naar links naar de kinderen van de probant, naar rechts naar een generatie verder terug.<br /><br />";
$pgv_lang["show_full_help"]					= "~LAAT DETAILS ZIEN of VERBERG DETAILS~<br /><br />Met deze optie kunt u alle details in de naamvakken laten zien, of de details juist verbergen.<br />Als de details zijn verborgen, kunt u wat meer naamvakken op het scherm laten tonen.<br />Details kunt u, ook als deze in de vakken niet zichtbaar zijn, altijd bekijken door op het vergrootglas in de box te klikken (of er met de muisaanwijzer overheen te gaan, afhankelijk van de instelling van de website).";
$pgv_lang["talloffset_help"]				= "~SCHERM ORIËNTATIE~<br /><br />Met deze optie bepaalt u de oriëntatie van het scherm: staand of liggend.<br /> Het veranderen van deze instelling kan handig zijn als u een ander schermtype heeft, of in sommige gevallen kunt u dit wijzigen als het beter uitkomt op een schermafdruk.<br />Staand maakt het overzicht smaller, zodat 4 generaties op een pagina passen. Liggend maakt de afbeelding breder zodat de afdruk beter past op een liggende pagina.";
$pgv_lang["rootid_help"]					= "~STARTPERSOON DIAGRAM~<br /><br />Als u een diagram wilt beginnen met een andere startpersoon, vul dan in het vakje het ID van de nieuwe persoon in.<br /> Als u het ID van de persoon niet weet, gebruik dan de koppeling \"Zoek ID\". Aan de hand van (een deel van) de naam kunt u dan de persoon opzoeken en selecteren.";
$pgv_lang["PEDIGREE_GENERATIONS_help"]		= "~AANTAL GENERATIES PER SCHERM~<br /><br />Hier kunt u instellen hoeveel generaties op het scherm worden getoond.<br />Wat juist is voor u is afhankelijk van de afmetingen van uw scherm en of u de details van de naamvakken wel of niet laat zien.";

//-- LOGIN-page
$pgv_lang["login_page_help"]				= "~DE PAGINA \"AANMELDEN\"~<br /><br />Op deze pagina kunt u zich aanmelden als bestaande gebruiker, een nieuwe gebruikersnaam aanvragen of, als u uw wachtwoord hebt vergeten, deze opnieuw aanvragen.<br />";
$pgv_lang["username_help"]					= "~GEBRUIKERSNAAM~<br /><br />In dit veld vult u uw gebruikersnaam in. De gebruikersnaam is hoofdlettergevoelig.<br /><br />Als u nog niet beschikt over een gebruikersnaam, kunt u die aanvragen door te klikken op de onderstaande koppeling \"Vraag gebruikersnaam aan\".";
$pgv_lang["password_help"]					= "~WACHTWOORD~<br /><br />In dit veld vult u uw wachtwoord in.<br />het wachtwoord is hoofdlettergevoelig.<br /><br />Als u uw wachtwoord kwijt bent, kunt u klikken op de koppeling \"Vraag nieuw wachtwoord aan\".";
$pgv_lang["login_buttons_help"]				= "~TOEGANGSKNOPPEN~<br /><br />Hier ziet u twee knoppen om toegang te krijgen tot het systeem.<br />Afhankelijk van de gekozen knop gaat u naar:<br /><br />* De <b> #pgv_lang[login]# </b> knop<br />Hier zijn twee mogelijkheden:<br /><br />Als u op \"#pgv_lang[login]#\" klikte,vanaf een ander scherm in PhpGedView, keert u na het aanmelden terug naar waar u oorspronkelijk vandaan kwam.<br />Als u dus op deze knop klikte vanaf de kwartierstaat-pagina, keert u daar weer naar terug.<br /><br />Als dit het eerste scherm is, dat u in PhpGedView te zien krijgt, wordt u aangemeld en gaat u direct naar uw persoonlijke MyGedView pagina. Hier kunt u uw eigen instellingen en favorieten aanpassen, e-mails ontvangen en versturen, enz.<br /><br />* De <b>#pgv_lang[admin]#</b> knop<br />Als u over beheerderrechten beschikt, kunt u deze knop gebruiken om direct naar de beheerpagina te gaan.";
$pgv_lang["login_buttons_aut_help"]			= "~TOEGANGSKNOPPEN~<br /><br />Hier ziet u twee knoppen om toegang te krijgen tot het systeem, nadat u uw gebruikersnaam en wachtwoord heeft ingetypt.<br />Afhankelijk van de gekozen knop gaat u naar:<br /><br />* De <b>#pgv_lang[login]#</b> knop <br />Als u op deze linker knop klikt, wordt u aangemeld en gaat u direct naar uw persoonlijke MyGedView pagina. Hier kunt u uw eigen instellingen en favorieten aanpassen, e-mails ontvangen en versturen, enz.<br /><br />* De <b>#pgv_lang[admin]#</b> knop<br />Als u over beheerderrechten beschikt, kunt u deze knop gebruiken om direct naar de beheerpagina te gaan.";
$pgv_lang["new_password_help"]				= "~NIEUW WACHTWOORD AANVRAGEN~<br />Als u uw wachtwoord kwijt bent, kunt u via deze koppeling een nieuw wachtwoord aanvragen. U komt dan terecht op de pagina \"Verzoek om een nieuw wachtwoord\".<br />Let op: dit geldt alleen voor gebruikers die op deze site al over een gebruikersnaam beschikken!";
$pgv_lang["new_user_help"]					= "~NIEUWE GEBRUIKERSNAAM AANVRAGEN~<br /><br />Als u een gebruikersnaam voor deze website wilt aanvragen, kunt u op deze koppeling klikken. U komt dan terecht op de pagina \"Vraag gebruikersnaam aan\".<br />Let op: dit geldt voor gebruikers die nog niet over een gebruikersnaam voor deze site beschikken, of langer dan 7 dagen geleden een gebruikersnaam hebben aangevraagd en deze niet hebben geverifieerd.";
$pgv_lang["mygedview_login_help"]			= "Om toegang te verkrijgen tot uw persoonlijke MyGedView pagina, moet u beschikken over een gebruikernaam.<br /><br />Op deze persoonlijke pagina kunt u uw favoriete personen vastleggen, notities maken, boodschappen versturen. zien wie er verder nog aangelogd zijn en uw persoonlijke pagina naar believen indelen met nog meer informatievakken.<br /><br />Type, om naar uw persoonlijke MyGedView pagina te gaan, uw gebruikersnaam en wachtwoord in de vakjes in en klik op \"Aanmelden\".";
$pgv_lang["new_user_firstname_help"]		= "~#pgv_lang[firstname]#~<br /><br />In dit vak moet u uw voornaam invullen.<br /><br />Uw voornaam en ook achternaam hebben we nodig om te kunnen beoordelen of:<br />u in aanmerking komt voor een account voor deze site<br />en<br />welke rechten u dan krijgt.<br /><br />Deze namen zullen zichtbaar zijn voor andere ingelogde familieleden en gebruikers. Voor gebruikers, die niet zijn ingelogd, of geen account hebben, zullen deze namen nooit zichtbaar zijn.<br /><br />";
$pgv_lang["new_user_lastname_help"]			= "~#pgv_lang[lastname]#~<br /><br />In dit vak moet u uw achternaam invullen.<br /><br />Uw voornaam en ook achternaam hebben we nodig om te kunnen beoordelen of:<br />u in aanmerking komt voor een account voor deze site<br />en<br />welke rechten u dan krijgt.<br /><br />Deze namen zullen zichtbaar zijn voor andere ingelogde familieleden en gebruikers. Voor gebruikers, die niet zijn ingelogd, of geen account hebben, zullen deze namen nooit zichtbaar zijn.<br /><br />";
$pgv_lang["register_info_01"]				= "~AANVRAGEN GEBRUIKERSACCOUNT~<br /><br />De hoeveelheid gegevens, die publiekelijk op deze website kan worden bekeken is beperkt vanwege wettelijke regelingen aangaande de privacy bescherming. Veel mensen willen niet dat persoonlijke gegevens publiekelijk beschikbaar zijn op het internet. Persoonlijke gegevens zouden kunnen worden gebruikt voor het verzenden van spam en, nog erger, identiteits-diefstal.<br /><br />Het zich aanmelden (inloggen) bij deze site is alleen toegestaan aan bezoekers, die een gebruikers-account hebben. Nadat de Beheerder uw account aanvraag heeft gecontroleerd en goedgekeurd, zult u zich aan kunnen melden.<br /><br />Als de Familieband Privacy is geactiveerd, kunt u alleen de persoonlijk informatie inzien van uw directe verwanten. De Beheerder kan ook bepaalde gebruikers toestaan om gegevens in de database te wijzigen, of aan te vullen.<br /><br />Als u meer uitleg, of hulp, nodig heeft, neem dan a.u.b. kontakt op met de Beheerder, via de link onderaan de pagina.<br /><br />";
$pgv_lang["register_info_02"]				= "~AANVRAGEN GEBRUIKERSACCOUNT~<br /><br />De hoeveelheid gegevens, die publiekelijk op deze website kan worden bekeken is beperkt vanwege wettelijke regelingen aangaande de privacy bescherming. Veel mensen willen niet dat persoonlijke gegevens publiekelijk beschikbaar zijn op het internet. Persoonlijke gegevens zouden kunnen worden gebruikt voor het verzenden van spam en, nog erger, identiteits-diefstal.<br /><br />Het zich aanmelden (inloggen) bij deze site is alleen toegestaan aan <u>geauthoriseerde</u> gebruikers. Nadat de Beheerder uw account aanvraag heeft gecontroleerd en goedgekeurd, zult u zich aan kunnen melden en de persoonlijke gegevens kunnen bekijken.<br /><br />Als de Familieband Privacy is geactiveerd, kunt u alleen de persoonlijk informatie inzien van uw directe verwanten. De Beheerder kan ook bepaalde gebruikers toestaan om gegevens in de database te wijzigen, of aan te vullen.<br /><br />Als u meer uitleg, of hulp, nodig heeft, neem dan a.u.b. kontakt op met de Beheerder, via de link onderaan de pagina.<br /><br />";
$pgv_lang["register_info_03"]				= "~AANVRAGEN GEBRUIKERSACCOUNT~<br /><br />De hoeveelheid gegevens, die publiekelijk op deze website kan worden bekeken is beperkt vanwege wettelijke regelingen aangaande de privacy bescherming. Veel mensen willen niet dat persoonlijke gegevens publiekelijk beschikbaar zijn op het internet. Persoonlijke gegevens zouden kunnen worden gebruikt voor het verzenden van spam en, nog erger, identiteits-diefstal.<br /><br />Het zich aanmelden (inloggen) bij deze site is alleen toegestaan aan <u>familieleden</u>. Nadat de Beheerder uw account aanvraag heeft gecontroleerd en goedgekeurd, zult u zich aan kunnen melden en de persoonlijke gegevens kunnen bekijken.<br /><br />Als de Familieband Privacy is geactiveerd, kunt u alleen de persoonlijk informatie inzien van uw directe verwanten. De Beheerder kan ook bepaalde gebruikers toestaan om gegevens in de database te wijzigen, of aan te vullen.<br /><br />Als u meer uitleg, of hulp, nodig heeft, neem dan a.u.b. kontakt op met de Beheerder, via de link onderaan de pagina.<br /><br />";


//-- Descendancy-page
$pgv_lang["help_descendancy.php"]			= "~NAKOMELINGEN~<br /><br />Op deze pagina worden de nakomelingen van de geselecteerde persoon getoond, maximaal het aantal generaties dat in het veld \"generaties\" is weergegeven. Indien u een ander persoon als startpersoon wilt kiezen, kunt u direct diens ID intikken in het veld \"Startpersoon\". Als u het ID niet kent, kunt u de persoon opzoeken door de koppeling \"Zoek persoon\" aan te klikken en dan op (deel van) de naam te zoeken.<br /><br /><i>PERSOONSVAKKEN IN DE KWARTIERSTAAT</i><br />Per persoon wordt een aantal gegevens getoond, zoals namen, geboorte- en overlijdensdatum en -plaats. Door op de persoonsnaam te klikken, komt u op het detailscherm van de persoon. Tevens zijn twee speciale knoppen zichtbaar (mits de optie \"Toon details\" aan staat):<br /><br /><i>KNOP \"KWARTIERSTAAT\" IN PERSOONSVAK</i><br />Afhankelijk van de instelling van de website, kunt u deze knop activeren door erop te klikken of er met de muis overheen te gaan. Er verschijnt dan een schermpje, waarin u kunt klikken op: de kwartierstaat van deze persoon, zijn/haar afstammelingen, zijn/haar gezin en de persoonsschermen van eega en kinderen.<br /><br /><i>VERGROOTGLAS IN PERSOONSVAK</i><br />Afhankelijk van de instelling van de website, kunt u deze knop activeren door erop te klikken of er met de muis overheen te gaan. Er verschijnt dan een schermpje, waarin extra informatie over de persoon wordt gegeven. Dit betreft onder andere de voorhanden zijnde feiten zoals beroepen, verhuizingen, enz..<br /><br /><i>DE PIJLEN LINKS VAN DE VAKKEN</i><br />Door op de pijlen (te klikken, kunt u het scherm \"verschuiven\", de ouders van de persoon waarvan u de pijl aanklikt, worden dan de startpersonen.<br /><br />";
$pgv_lang["desc_rootid_help"]				= "~NIEUWE STARTPERSOON~<br /><br />Als u een overzicht, diagram of grafiek wilt beginnen met een ander startpersoon, vul dan in het vakje het ID van de nieuwe persoon in.<br />Als u het ID van de persoon niet weet, gebruik dan de koppeling \"Zoek_ID\". Aan de hand van (een deel van) de naam kunt u dan de persoon opzoeken en selecteren.";
$pgv_lang["desc_generations_help"]			= "~AANTAL GENERATIES~<br /><br />Stel hier het aantal generaties in, dat op het scherm wordt weergegeven. Welke weergave voor u het beste is, is afhankelijk van de grootte van uw scherm en van het al dan niet tonen van details.";

//-- Time line-page
$pgv_lang["help_lifespan.php"]				= "~LEVENSDUUR GRAFIEK~<br /><br />Op dit grafiek kunt u een persoon, of meerdere personen langs een horizontale tijdlijn laten tonen.  Dit grafiek laat u zien hoe de levens van verschillende peronen elkaar kunnen overlappen. <br /><br />U kunt mensen per persoon aan het grafiek toevoegen, of in gezinsverband, m.b.v. hun ID's.  De vorige lijst wordt bewaard als u meer mensen aan het grafiek toevoegt.  U kunt het grafiek op elk moment wissen door te klikken op de  <b>Wis Grafiek</b> knop.<br /><br />U kunt zelfs mensen toevoegen door te zoeken in een datumbereik of per plaats.<br /><br />";
$pgv_lang["lifespan_add_person_help"]		= "#pgv_lang[add_person_help]#~Inclusief Directe Familie CheckBox~<br/>Inclusief Directe Familie is standaard aangevinkt.<br/>Laat dit aangevinkt om ook de vader, moeder, partner, broers, zusters en kinderen te zien van de persoon, die aan Levensduur Grafiek wordt toegevoegd.<br/>Verwijder het vinkje als u de directe familie niet mede wilt toevoegen.<br/><br/>";
$pgv_lang["help_timeline.php"]				= "~TIJDLIJN~<br /><br />Op deze pagina kunt u de gebeurtenissen en feiten van een of meerdere personen langs een tijdlijn zichtbaar maken.<br />Op die manier kunt u bijvoorbeeld de status van twee of meer personen op een bepaald moment tonen.<br /><br />Als u vanaf een andere pagina op de tijdlijn-koppeling klikt, wordt de desbetreffende persoon automatisch op de tijdlijn getoond.<br />Als u de tijdlijn heeft gekozen vanaf het menu, kunt u de persoon aangeven door middel van een ID. Ook kunt u met behulp van \"Zoek ID\" de gewenste persoon opzoeken.";
$pgv_lang["add_person_help"]				= "~PERSOON TOEVOEGEN AAN DE TIJDLIJN~<br /><br />Op de tijdlijn kunt u de gebeurtenissen van meerdere personen weergeven.<br />Gebruik het veld in het vak om personen toe te voegen. U kunt direct het ID van de persoon intikken.<br />Als u het ID niet kent, kunt u de persoon opzoeken door de koppeling \"Zoek ID\" aan te klikken en dan op (deel van) de naam te zoeken.";
$pgv_lang["remove_person_help"]				= "~PERSOON VAN DE TIJDLIJN VERWIJDEREN~<br /><br />Klik op deze koppeling om de persoon en diens gebeurtenissen van de tijdlijn te verwijderen.";
$pgv_lang["show_age_marker_help"]			= "~TOON LEEFTIJDS-INDICATOR~<br /><br />Als u deze optie aanvinkt, verschijnt er een leeftijdsindicator van deze persoon op de tijdlijn.<br />Met behulp van uw linker muisknop kunt u deze indicator naar beneden en naar boven schuiven langs de tijdlijn. De indicator geeft, op het aangegeven punt op de tijdlijn, het jaartal aan en de leeftijd van de desbetreffende persoon op dat moment.<br />Voor elke persoon op de tijdlijn kunt u de leeftijdsindicator aan- of uitzetten.";
$pgv_lang["timeline_control_help"]			= "~LEVENSDUUR CONTROLS~<br/><br/>~SNELHEID~<br/>Klik op de  \"drop down\" lijst en kies een waarde om de snelheid, waarmee de tijdbalk zich verplaatst, te wijzigen.<br/><br/>~Begin_Jaar~<br/>Voer een jaartal in, als beginjaar van de reeks.<br/><br/>~Eind_Jaar~<br/>Voer een jaartal in, als laatste jaar van de reeks.<br/><br/>~Zoeken~<br/>Klik op de \"Zoeken\" knop om te beginnen met zoeken naar gebeurtenissen, die voorkwamen tussen de twee jaartallen, die u eerder heeft ingevoerd.<br/><br/>";

//-- Relationship-page
$pgv_lang["help_relationship.php"]			= "~VERWANTSCHAP~<br /><br />Op deze pagina kunt u de verwantschap tussen twee personen vaststellen.<br />Het is hierbij niet noodzakelijk, dat de twee personen ook bloedverwanten van elkaar zijn, de relatie kan ook bestaan door middel van een huwelijk in de lijn, die de twee personen verbindt (zie \"Controleer verwantschap door huwelijk\").";
$pgv_lang["relationship_id_help"]			= "~ID'S VAN PERSOON 1 EN 2~<br /><br />Als u vanaf een andere pagina op deze pagina terecht bent gekomen (bijvoorbeeld door op de koppeling \"relatie met mij\" te klikken) wordt hier direct de relatie getoond tussen de twee personen.<br /><br />In het andere geval dient u eerst de ID's van de twee personen in de velden in te vullen, of deze door middel van de koppelingen \"Zoek ID\" op te zoeken.";
$pgv_lang["next_path_help"]					= "~VOLGEND PAD~<br /><br />Twee personen kunnen een relatie met elkaar hebben via verschillende personen in de stamboom. U kunt deze knop gebruiken om het programma een volgend pad te laten zoeken. De verschillende gevonden paden blijven bewaard en kunnen door middel van de aangegeven koppelingen (\"Toon pad ...\") opgeroepen worden.<br /><br />";
$pgv_lang["follow_spouse_help"]				= "~CONTROLEER VERWANTSCHAP DOOR HUWELIJK~<br /><br />Zonder deze optie worden alleen relaties tussen personen gevonden, die een bloedband hebben.<br />Is deze optie ingeschakeld, dan zoekt het programma ook naar relaties door huwelijk. Hiermee zult u waarschijnlijk meer relatiepaden vinden.";
$pgv_lang["line_up_generations_help"]		= "~UITLIJNEN GELIJKE GENERATIES~~<br /><br />Als u deze optie aanzet, worden alle zelfde generaties in het overzicht op dezelfde hoogte op de pagina afgedrukt.<br /><br />Staat deze optie uit, dan wordt het overzicht van boven naar beneden afgedrukt, ongeacht of de relatie nu kind-ouder of ouder-kind betreft.";
$pgv_lang["oldest_top_help"]				= "~TOON OUDSTE BOVENAAN~<br /><br />Met deze optie kunt u de oudste personen in het overzicht bovenaan laten afdrukken.<br />In het andere geval worden de jongste personen bovenaan getoond.<br /><br />Let op: Deze optie werkt alleen als <i>#pgv_lang[line_up_generations]#</i> is aangevinkt.";

//-- Ancestry-page
$pgv_lang["help_ancestry.php"]				= "~#pgv_lang[ancestry_chart]#~<br /><br />De pagina Voorouders lijkt veel op de <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, maar toont meer details en heeft een keuze in <a href=\"?help=chart_style_help\">#pgv_lang[chart_style]#</a>.<br /><br />Elke voorouder heeft een uniek nummer volgens het <i>Sosa-Stradonitz</i> systeem :<br /> - even nummers voor mannen (nummer kind * 2)<br /> - oneven nummers voor vrouwen (nummer partner + 1), behalve uiteraard voor nummer <big>1</big><br /><br />Voorbeeld: <big>7</big> is de partner van <big>6</big>, de moeder van <big>3</big>, de dochter van <big>14</big> en <big>15</big>.";
$pgv_lang["box_width_help"]					= "~#pgv_lang[ancestry_chart]# vakbreedte~</b><br /><br />Hiermee kun u de breedte van de vakken met persoonsgegevens instellen, van 50% tot 300%.<br />Standaard is 100% hetgeen overeenkomt met een vakbreedte van 270 pixels.";
$pgv_lang["chart_style_help"]				= "~#pgv_lang[ancestry_chart]# indeling overzicht~<br /><br /><dl><dt>#pgv_lang[ancestry_list]#</dt><dd>Verticale boomstructuur, met door +/- in- en uitklapbare delen van de boom.</dd><dt>#pgv_lang[ancestry_booklet]#</dt><dd>Een gezin per pagina met ouders, grootouders en alle kinderen.<br />Dit geeft een goed overzicht van een gezin met nabije familie en is gemakkelijk af te drukken, bijvoorbeeld om aan uw familie te geven.</dd></dl>";

//-- Fan chart-page
$pgv_lang["help_fanchart.php"]				= "~#pgv_lang[fan_chart]#~<br /><br />Het cirkeldiagram lijkt veel op de <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, maar toont de informatie grafisch op een andere wijze.<br /><br />De startpersoon staat in het centrum van het diagram, de ouders in de eerste cirkel, de grootouders in de tweede, enz.<br /><br />Het geboorte- en overlijdensjaar worden, indien bekend, onder de naam van de persoon afgedrukt.<br /><br />Als u op de naam van een persoon klikt, wordt deze de startpersoon in het cirkeldiagram en verschuift daarmee naar het centrum.<br />In het centrum ziet u tevens een pijl, waarmee u een van de kinderen of broers en zusters van de huidige startpersoon, de nieuwe startpersoon kunt maken. Dit werkt hetzelfde als in de <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>.";
$pgv_lang["fan_width_help"]					= "~#pgv_lang[fan_chart]# omvang~</b><br /><br />De omvang van het cirkeldiagram kunt u instellen van 50% tot 300%.<br />De standaard waarde is 100%, de afbeelding is hiermee ongeveer 640 beeldpunten in breedte.";
$pgv_lang["fan_style_help"]					= "~#pgv_lang[fan_chart]# stijl~<br /><br />Deze optie regelt hoe het cirkeldiagram wordt getoond.<ul><li><b>1/2</b><br />Halve  diagram (180&deg;) </li><li><b>3/4</b><br />Drie-kwart cirkel diagram (270&deg;) </li><li><b>4/4</b><br />Volledige cirkel diagram (360&deg;) </li></ul><br />";

//-- Hourglass chart-page
$pgv_lang["help_hourglass.php"]				= "~#pgv_lang[hourglass_chart]#~<br /><br />Het zandloperdiagram toont zowel de voorouders als de nakomelingen van de geselecteerde startpersoon in hetzelfde overzicht. Het is een mengvorm van kwartierstaat en overzicht nakomelingen.<br /><br />De startpersoon wordt weergegeven op het midden van de pagina, zijn nakomelingen links en zijn voorouders rechts. De generaties worden op die manier van links naar rechts weergegeven.<br /><br />";

//-- Family Book chart-page
$pgv_lang["help_familybook.php"]			= "~#pgv_lang[familybook_chart]#~<br /><br />Dit diagram is, min of meer, gelijk aan het Zandloperdiagram.  Het toont de voorouders en de nakomelingen van de gekozen startpersoon in hetzelfde diagram.  Het toont eveneens de nakomelingen van de startperoon in eenzelfde Zandloperdiagram, op dezelfde pagina.<br /><br />De startpersoon staat gecentreerd op de pagina, met de nakomelingen links en de voorouders rechts ervan.  In dit overzicht zijn de generaties zo over de pagina verdeeld, dat het start met de vroegste generatie en eindigt met de laatste.<br /><br />Elke nakomeling van de startpersoon wordt zelf de startpersoon van een extra zandloperdiagram op dezelfde pagina.  Dit wordt zovaak herhaald tot er niet meer nakomelingen zijn te tonen, of tot het maximum aantal is bereikt, zoals was ingevuld in het daarvoor bestemde vakje.";
$pgv_lang["fambook_descent_help"]			= "~#pgv_lang[descent_steps]#~<br /><br />Deze waarde bepaalt het aantal generaties nakomeling, van de startpersoon, dat zal worden getoond in het Zandloperdiagram formaat.<br /><br />";

//-- Indilist-page
$pgv_lang["help_indilist.php"]				= "~PERSONEN~<br /><br />PERSOON OPZOEKEN<br />Via deze pagina kunt u de detailgegevens van personen opzoeken. Kies hiervoor de beginletter van de achternaam in de alfabetische index. Daarna wordt een lijst met achternamen getoond, waaruit u wederom een keus kunt maken. Hierna worden de personen met de desbetreffende achternaam getoond. Door een van deze personen aan te klikken kunt u de details bekijken.<br />De lijst met achternamen kan worden overgeslagen, door op de koppeling \"Sla achternamenlijst over\" te klikken.<br />Als u meer informatie wilt hebben, kunt u op het vraagteken achter een koppeling of veld klikken.";
$pgv_lang["alpha_help"]						= "~ALFABETISCHE INDEX~<br /><br />Deze index werkt eenvoudig: <br />Klik op een letter in het alfabet en een lijst met achternamen, beginnend met deze letter, verschijnt.<br /><br />Aan de rechterkant van de rij ziet u (mogelijk) \"Onbekend\". Als u hierop klikt, selecteert u de personen zonder of met een onbekende achternaam. In het originele bestand waren dit personen waarbij geen achternaam is opgegeven. Als de achternaam van personen is aangeduid met N.N. (Nominum nescio, latijn voor naam onbekend) staan deze onder de letter 'N' vermeld.<br /><br />Geheel rechts in de rij ziet u \"ALLE\" staan. Door deze aan te klikken, krijgt u direct een totaaloverzicht van alle personen in de database.<br /><br />Ontbrekende letters?<br />Het kan voorkomen, dat in de rij met letters er enkele ontbreken.<br />Dit is geen fout, maar het gevolg van het feit dat er geen personen voorkomen, waarvan de achternaam met de desbetreffende letter begint.";
$pgv_lang["name_list_help"]					= "~NAMENLIJST~<br /><br />In dit vak ziet u ofwel een achternamenlijst, ofwel een complete namenlijst. In beide gevallen beginnen de namen met de letter, die u in de alfabetische index heeft aangeklikt, met twee uitzonderingen:<br /><br />Als u op \"ALLE\" heeft geklikt in de alfabetische index, ziet u een lijst met alle achternamen in de database.<br /><br />Als u op \"Onbekend\" heeft geklikt in de alfabetische index, ziet u een lijst met personen zonder achternaam.<br /><br />Of u de achternamenlijst ziet of de lijst met personen/gezinnen, is afhankelijk van de status van de koppeling (Toon/verberg achternamenlijst) onder het vak.";
$pgv_lang["skip_sublist_help"]				= "~SLA ACHTERNAMENLIJST OVER~<br /><br />Standaard krijgt u na het kiezen van een letter uit de alfabetische index eerst een lijst van bijbehorende achternamen te zien. Daarna worden pas de specifieke personen/gezinnen getoond.<br /><br />Als u deze optie aanklikt, wordt de achternamenlijst overgeslagen, en krijgt u direct alle personen/gezinnen te zien, waarvan de achternaam met de gekozen letter begint.";
$pgv_lang["show_marnms_help"]				= "~#pgv_lang[show_marnms]#~<br /><br />De pagina's van Personen- en Familielijsten kunnen wel of geen huwelijksnamen bevatten.  Deze optie kan handig zijn als u personen zoekt, waarvan u alleen de huwelijksnaam kent.<br /><br />Huwelijksnamen kunnen alleen worden inbegrepen als ze ook daadwerkelijk bestaan in de database.<br /><br />Voor de Familielijst is de standaard instelling: Niet inbegrepen.<br />Voor de Personenlijst is de standaardwaarde ingesteld op de GEDCOM Instellingen pagina.<br /><br />Als de optie hier wordt gewijzigd, wordt uw selectie bewaard totdat u zich afmeldt of totdat uw sessie eindigt.<br /><br />";

//-- Families-page
$pgv_lang["help_famlist.php"]				= "~GEZINNEN~<br /><br />Via deze pagina kunt u de detailgegevens van een gezin opzoeken. Kies hiervoor de beginletter van de achternaam van een van de partners in de alfabetische index. Daarna wordt een lijst met achternamen getoond, waaruit u wederom een keus kunt maken. Als laatste krijgt u een lijst met partners (in huwelijken) te zien, waaruit u een keus kunt maken. Hierna worden de gezinsleden in het desbetreffende huwelijk getoond.<br /><br />Als u klikt op \"Sla achternamenlijst over\", dan wordt de lijst met verschillende achternamen niet getoond, maar krijgt u direct alle partners in huwelijken te zien waarvan de achternaam met de gekozen letter begint.<br /><br />U kunt zoeken op de achternaam van zowel de ene als van de andere partner.<br /><br />#pgv_lang[more_help]#";
$pgv_lang["help_family.php"]				= "~DETAILS GEZINNEN~<br /><br />Deze pagina geeft de detailgegevens van het gezin, dat u op de vorige pagina heeft gekozen.<br /><br />Van boven naar beneden worden de volgende vakken getoond:<br /><br />De eerste partner en ouders.<br />De tweede partner en ouders.<br />De kinderen.<br /><br />De vorm en inhoud van de vakken zijn dezelfde als die u al aantrof in de kwartierstaat- en nakomelingen-pagina's.<br /><br />Aan de rechterkant van de vakken van de ouders ziet u een pijl. Als u daarop klikt, gaat u naar de details van het gezin van die ouders.<br /><br />Onder de vakken van de kinderen ziet u, als dit door de sitebeheerder is ingesteld, de koppeling \"Kind toevoegen aan dit gezin\".<br />Ook ziet u dan in het vak \"Gezinsinformatie\" een aantal koppelingen, waarmee u nieuwe feiten, notities, bronvermeldingen en koppelingen met multimedia-items kunt aanbrengen.<br /><br />Aan de rechterzijde van het scherm staan de koppelingen:<br /><br /><i>Laat partners zien op de tijdlijn</i><br />Hiermee kunt u direct doorspringen naar de Tijdlijn, waarop dan al de gegevens van beide partners worden getoond.<br /><br /><i>Toon GEDCOM-gegevens</i><br />Hiermee kunt u de brongegevens van dit gezin uit het GEDCOM-bestand inzien.<br /><br /><i>Toevoegen aan knipselbak</i><br />Hiermee kunt u de gegevens van dit gezin in uw knipselbak opslaan om ze later naar uw PC te downloaden. U kunt ze dan importeren in uw eigen genealogieprogramma.<br /><br />#pgv_lang[more_help]#";
$pgv_lang["add_child_help"]					= "~KIND TOEVOEGEN AAN DIT GEZIN~<br /><br />Met deze functie kunt u een nieuw persoon als kind toevoegen aan dit gezin.<br /><br />Als u op de koppeling heeft geklikt, krijgt u een nieuw scherm, waarop u zoveel mogelijk gegevens van de persoon dient in te vullen. ";
$pgv_lang["show_fam_gedcom_help"]			= "~TOON GEDCOM-GEGEVENS~<br /><br />Als u op deze koppeling klikt, krijgt u in een nieuw venster de gegevens van dit gezin in GEDCOM-formaat te zien.";
$pgv_lang["add_fam_clip_help"]				= "~FAMILIE TOEVOEGEN AAN KNIPSELBAK~<br /><br />Met deze koppeling kunt u de GEDCOM-gegevens van deze familie aan uw knipselbak toevoegen. Op de pagina die dan wordt weergegeven, kunt u kiezen om alleen de ouders, tevens hun ouders, hun kinderen en/of alle nakomelingen toe te voegen.";
$pgv_lang["show_fam_timeline_help"]			= "~TOON PARTNERS OP DE TIJDLIJN~<br /><br />Deze koppeling brengt u op de tijdlijn-pagina, waar de tijdlijn direct met de gegevens van de partners wordt weergegeven.";

//-- Source list-page
$pgv_lang["help_sourcelist.php"]			= "~BRONNEN~<br /><br />Op deze pagina treft u een overzicht van alle bronnen aan.<br />Anders dan bij Personen en Gezinnen zijn de bronnen niet via een alfabetische index te benaderen. De reden hiervan is, dat een bron een persoon kan zijn met een voor- en achternaam, maar ook een organisatie of zelfs een website.<br />Het is daarom niet mogelijk om een eenduidige sorteervolgorde te hanteren, ze worden daarom alfabetisch op titel weergegeven.<br /><br />GEBRUIK VAN BRONNEN<br />Zonder bronnen kunnen we niet op een verantwoorde manier een genealogisch bestand opbouwen. Alle informatie dient herleidbaar, reproduceerbaar en controleerbaar te zijn. Aan alle personen, gezinnen en feiten moeten daarom bronnen worden gekoppeld. de bron kan een persoon zijn, die informatie heeft verstrekt, een bepaald document (aktes e.d.) of een ander bestand (denk aan Genlias). Als informatie uit meerdere bronnen afkomstig is, worden alle bronnen genoemd. Tevens kan een bron over meerdere zaken informatie geven, en daarom aan meerdere feiten (huwelijk, geboorte, beroep, etc.) gekoppeld zijn.<br /><br />";
$pgv_lang["sourcelist_listbox_help"]		= "~VAK BRONNENLIJST~<br /><br />In dit vak ziet u de titels van alle bronnen, die in het bestand zijn opgenomen.<br />De lijst is op alfabetische volgorde van titel gesorteerd.<br /><br />Door op de titel van een bron te klikken, gaat u naar de detailgegevens toe. Daar ziet u (indien van toepassing) de notities, bewaarplaats en een koppeling naar een afbeelding van de bron (bijvoorbeeld een ingescande akte).<br />Tevens kunt u zien, vanuit welke persoons- en gezinsinformatie naar de bron wordt verwezen. Door op een persoon of gezin te klikken, kunt u naar de desbetreffende informatie doorspringen.";

//-- Sources-page
$pgv_lang["help_source.php"]				= "~DETAILS BRON~<br /><br />Bronnen zijn belangrijk in genealogisch onderzoek, omdat ze informatie in een stamboom controleerbaar en reproduceerbaar maken. Op die manier kunnen andere onderzoekers op een verantwoorde manier van de gegevens gebruik maken.<br /><br />Op deze pagina ziet u de detailgegevens van de bron.<br />Omdat er veel verschillende soorten bronnen zijn, hebben sommige bronnen hier meer informatie dan anderen.<br />Indien voorhanden, worden onder meer notities, de bewaarplaats en een koppeling naar de afbeelding van de bron weergegeven. De afbeelding is bijvoorbeeld een scan van een akte.<br />Als u op de afbeelding of de bestandsnaam daarnaast klikt, wordt deze in een apart venster vergroot weergegeven.<br />Onder de details van de bron wordt een lijst met personen en gezinnen getoond, waarvan een feit of gebeurtenis naar de bron verwijst.<br /><br />Als de beheerder van de site dit mogelijk heeft gemaakt, ziet u aan de rechterzijde van het scherm nog twee koppelingen: <br />\"Toon GEDCOM-gegevens\", waarmee u in een apart venster de gegevens van de bron in GEDCOM-formaat kunt zien, en <br />\"Toevoegen aan knipselbak\", waarmee u de GEDCOM-gegevens van de bron in uw knipselbak kunt opslaan. Later kunt u ze downloaden naar uw eigen machine en ze daar importeren in uw genealogiepakket.<br /><br />#pgv_lang[more_help]#";
$pgv_lang["sources_listbox_help"]			= "~VAK PERSONEN/GEZINNEN VAN BRON~<br /><br />In dit kader ziet u de namen van personen en/of gezinnen, waarvan een feit of gebeurtenis verwijst naar de bron.<br />Als u op de persoon of het gezin klikt, gaat u naar de detailgegevens van die persoon of dat gezin.";
$pgv_lang["show_source_gedcom_help"]		= "~TOON GEDCOM-GEGEVENS~<br /><br />Als u op deze koppeling klikt, krijgt u in een nieuw venster de gegevens over de bron te zien, zoals ze in het GEDCOM-bestand zijn opgenomen.";
$pgv_lang["add_source_clip_help"]			= "~TOEVOEGEN AAN KNIPSELBAK~<br /><br />Door op deze koppeling te klikken, kunt u de gegevens van de bron, zoals ze in het GEDCOM-bestand voorkomen, aan uw knipselbak toevoegen.";
$pgv_lang["delete_source_help"]				= "~VERWIJDER BRON~<br /><br />Door deze optie aan te klikken, markeert u een bron voor verwijdering uit de genealogie.<br /><br />Wat betekent dat nu?<br />Laten we aannemen dat u een goede reden heeft om deze bron uit de genealogie te verwijderen. U klikt op de koppeling. Daarna verschijnt er een venster, waarin u wordt gevraagd of u er zeker van bent, of dat u de bewerking wilt annuleren.<br /><br />Als u doorgaat, verschijnt na enige tijd opnieuw een scherm, waarin wordt gemeld dat de bron uit de genealogie is verwijderd.<br />De bron zal echter nog steeds zichtbaar en raadpleegbaar zijn. <br /><br />Dit is <b>geen</b> fout. De beheerder heeft een e-mail gekregen, waarin wordt vermeld dat er een wijziging op de genealogie is aangebracht en dat u de bron heeft verwijderd. De beheerder kan de wijziging accepteren of ongedaan maken. Pas als de beheerder de wijziging heeft geaccepteerd, is de bron definitief verwijderd.<br />Bij twijfel zal de beheerder contact met u opnemen.";

//-- Persons per Place-page
$pgv_lang["help_placelist.php"]				= "~PERSONEN PER LOCATIE~<br /><br />Via dit scherm kunt u personen en gezinnen opzoeken, die een verband hebben met een bepaalde locatie.<br /><br />Wanneer een locatie wordt genoemd in een feit of gebeurtenis van een persoon of gezin, vindt het programma deze voor u.<br />Zo kunt u bijvoorbeeld opzoeken, wie iets te maken heeft gehad met een bepaald land, stad of zelfs een bepaalde straat.<br /><br />De resultaten worden getoond in een venster met twee kolommen:<br />Een voor personen en een voor gezinnen.<br /><br />#pgv_lang[more_help]#";
$pgv_lang["ppp_default_form_help"]			= "~ORDENING VAN LOCATIES - STANDAARD~<br /><br />Binnen locaties komen verschillende niveaus van omschrijving voor.<br /> Zo kan een landaanduiding worden genoemd, maar ook een plaatsnaam of zelfs straat. In het bestand wordt de opbouw aangehouden, die hier wordt genoemd. Deze opbouw is standaard bepaald, omdat in het geïmporteerde GEDCOM-bestand geen aanduiding voor een afwijkende opbouw is gevonden.<br /><br />In het geval dat deze afwijkend was geweest, was deze aan het einde van de regel tussen haakjes getoond.";
$pgv_lang["ppp_match_one_help"]				= "~ORDENING VAN LOCATIES - VOLGENS GEDCOM~<br /><br />Binnen locaties komen verschillende niveaus van omschrijving voor.<br /> Zo kan een landaanduiding worden genoemd, maar ook een plaatsnaam of zelfs straat. In het bestand wordt de opbouw aangehouden, die hier wordt genoemd. Deze opbouw is gedefinieerd in het geïmporteerde GEDCOM-bestand.";
$pgv_lang["ppp_numfound_help"]				= "~LOCATIEVERBINDINGEN GEVONDEN~<br /><br />Hier wordt het aantal locatieverbindingen getoond dat is gevonden.<br />Als nog steeds een lijst met locaties zichtbaar is, betekent dit dat het laagste niveau nog niet is bereikt.<br />U kunt de bij deze locatie bijbehorende gezinnen en personen zien, door op deze koppeling te klikken. Ook kunt u de zoekopdracht verder verfijnen, door op een locatie te klikken in de lijst.";
$pgv_lang["ppp_levels_help"]				= "~LOCATIENIVEAUS~<br /><br />Dit laat het aantal niveaus binnen de locatie zien, dat nu wordt getoond.<br />De lijst in het vak is in feite een deellijst van het bovenliggende niveau.<br /><br />VOORBEELD:<br />De (standaard) volgorde is: #pgv_lang[default_form]#<br />Als het huidige niveau het \"Hoogste niveau\"  is, dan laat het vak alle landen in het bestand zien. <br />Als het huidige niveau is: \"Leiden, Hoogste niveau\", dan worden alle straten in Leiden getoond, die in het bestand voorkomen.<br />etc.<br /><br />U kunt op een niveau klikken, om een of meer stappen terug te gaan.";
$pgv_lang["ppp_placelist_help"]				= "~LOCATIES~<br /><br />In deze lijst worden de locaties getoond, die zijn gevonden onder de locatie die u heeft gekozen. Heeft u nog geen locatie gekozen, dan ziet u een lijst met alle locaties op het hoogste niveau.<br />De namen van de locaties in de lijst kunt u aanklikken.<br />Klikken op een locatie werkt als een filter, het brengt u naar een lager niveau.";
$pgv_lang["ppp_placelist_help2"]			= "~LOCATIELIJST~<br /><br />In deze lijst ziet u de locaties die zijn gevonden.<br />U kunt op de locatienamen klikken, dit brengt u een niveau dieper.<br />Op ieder niveau behalve het hoogste krijgt u een lijst met personen en gezinnen te zien, waarvan een gebeurtenis aan de desbetreffende locatie is gekoppeld.";
$pgv_lang["ppp_view_records_help"]			= "~ALLE PERSONEN/GEZINNEN OP DEZE LOCATIE~<br /><br />Door op deze koppeling te klikken, gaat u direct naar het overzicht van personen en gezinnen, waarvan een gebeurtenis op deze locatie heeft plaatsgevonden.<br />Als u in het locatieoverzicht op het laagste niveau bent gekomen, krijgt u dit overzicht automatisch te zien.";
$pgv_lang["ppp_name_list_help"]				= "~LOCATIES - NAMENLIJST~<br /><br />In dit vak vindt u een complete lijst van personen en gezinnen, waarvan een feit of gebeurtenis naar deze locatie verwijst.<br /><br />Door op een naam in de lijst klikken, worden de details van de persoon of het gezin getoond.<br /><br />U kunt ook opnieuw zoeken, door op de koppeling naar een hogerliggend niveau (b.v. de plaats of \"hoogste niveau\") te klikken. In dat geval wordt weer de lijst met locaties getoond.";

//-- Multimedia-page
$pgv_lang["help_medialist.php"]				= "~MULTIMEDIALIJST~<br /><br />In deze lijst worden alle multimedia-items vermeld, die in het bestand voorkomen. De lijst is op volgorde van bestandsnaam gesorteerd.<br />U kunt direct het multimedia-item bekijken, door op de bestandsnaam of de miniatuurafbeelding te klikken. Afhankelijk van het bestandstype wordt het item getoond in PhpGedView of in het programma dat is gekoppeld aan het bestandstype.<br />Als u met de rechter muisknop op het item klikt, kun u alle mogelijkheden die uw verkenner biedt, benutten, zoals opslaan als....., afdrukken, etc.<br />Onder de bestandsnaam zijn (indien aanwezig) de koppelingen naar personen, gezinnen en bronnen vermeld, waaraan het item is gekoppeld. Als u op deze \"Bekijk....\"-koppelingen klikt, gaat u direct naar de pagina met de details van persoon, gezin of bron.<br />";

//-- Upload Media-page
$pgv_lang["help_uploadmedia.php"]			= "~UPLOADEN MEDIABESTANDEN~<br /><br />Met deze functie kunt u mediabestanden uploaden naar PhpGedView. In de invoervakken vult u resp. de bestandsnaam van het mediabestand en van de miniatuurweergave in. Deze bestanden worden dan geplaatst in de mappen, die bij de instellingen van de huidige, actieve genealogie zijn opgegeven.<br />Het mediabestand wordt dan bijvoorbeeld geplaatst in ./media, de miniatuurweergave in ./media/thumbs.<br /><br /><b>Miniatuurweergaven</b><br />Miniatuurweergaven kunnen het beste een afmeting hebben van 100 x 100 en moeten dezelfde naam hebben als het bijbehorende mediabestand.<br /><br />#pgv_lang[readme_help]#";

//-- Anniversaries-page
$pgv_lang["help_calendar.php"]				= "~GEBEURTENISKALENDER~<br /><br /><ul><li><a href=\"#calendar_general\">Algemene informatie</a><li><a href=\"#calendar_day\">#pgv_lang[day]#</a><li><a href=\"#calendar_month\">#pgv_lang[month]#</a><li><a href=\"#calendar_year\">#pgv_lang[year]#</a><li><a href=\"#calendar_show\">#pgv_lang[show]# / #pgv_lang[showcal]#</a><li><a href=\"#calendar_sex\">#pgv_lang[sex]#</a><li><a href=\"#calendar_event\">Event</a><li><a href=\"#calendar_button\">\"Toon\"-knoppen </a><li><a href=\"#calendar_tip\">Tip</a></ul><br /><a name=\"calendar_general\"></a>De gebeurteniskalender toont de gezinnen en personen die zijn gekoppeld aan een gebeurtenis op een bepaalde dag of maand, of in een bepaalde periode. De kalender is dermate geavanceerd, dat de juiste datum of periode met de gewenste gebeurtenissen worden getoond.<dl><dt><b>Toon <a href=\"#calendar_day\">dag</a></b></dt><dd>Dit toont de gebeurtenissen op een bepaalde dag, onafhankelijk van maand en jaar. Er verschijnt een lijst met de namen van gezinnen of personen, of een lijst met in de linkerkolom de personen en in de rechter de gezinnen.</dd><dt><b>Toon <a href=\"#calendar_month\">maand</a></b></dt><dd>In de <b>Kalender</b> zijn zowel de namen van personen als van gezinnen zichtbaar in de dagvakken. De kalender wordt getoond zoals deze was in het jaar dat u in het jaarvak heeft ingevoerd. Alle gebeurtenissen in en voor dat jaar zijn zichtbaar.<br />In combinatie met de optie \"<a href=\"#calendar_show\">#pgv_lang[recent_events]#</a>\" geeft het een realistisch beeld van de maandkalender, zoals deze bij uw voorouders in dat jaar aan de muur hing.</dd><dt><b>Toon <a href=\"#calendar_year\">jaar</a></b></dt><dd>Dit toont de gebeurtenissen in een jaar of een reeks van jaren. Er verschijnt een lijst met de namen van gezinnen of personen, of een lijst met in de linkerkolom de personen en in de rechter de gezinnen.</dd></dl>De datum en maand die op dit moment worden getoond, zijn vetgedrukt in de kalenderbalken.<br /><br />U kunt klikken op de namen en datums die in de lijst staan.<br />Hiermee springt u of naar de detailpagina van het gezin of de persoon, of naar de \"Toon dag\" of \"Toon jaar\" functie van de kalender, waarmee alle gebeurtenissen van de desbetreffende dag of het jaar worden getoond.<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_day\"> </a>#pgv_lang[annivers_date_select_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_month\"> </a>#pgv_lang[annivers_month_select_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_year\"> </a>#pgv_lang[annivers_year_select_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_show\"> </a>#pgv_lang[annivers_show_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_sex\"> </a>#pgv_lang[annivers_sex_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_event\"> </a>#pgv_lang[annivers_event_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_button\"> </a>#pgv_lang[day_month_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_tip\"> </a>#pgv_lang[annivers_tip_help]#";
$pgv_lang["annivers_date_select_help"]		= "~DATUMKEUZE~</b><br /><br />U kunt de datum kiezen door in de dag- en maandvelden de gewenste waarden te kiezen en in het jaarveld het gewenste jaar in te typen.<br />Als u op deze pagina terechtkomt, is standaard de datum van vandaag ingevuld.<br /><br />Wanneer u op de knop \"Toon dag\" klikt, worden alle personen getoond, waaraan een gebeurtenis is gekoppeld op de gekozen dag en maand.<br /><br />Klikt u op de knop \"Toon maand\", dan ziet u een maandkalender van de gekozen maand, waarin per dag de personen worden getoond, waaraan een gebeurtenis is gekoppeld die op die dag in de gekozen maand heeft plaatsgevonden.<br /><br /><b>TIP</b><br />Stel dat u een familielid heeft, dat op 25 januari 1875 is geboren.<br />Als u op een van de \"Toon\" knoppen klikt, ziet u een lijst met personen of een kalender van die datum.<br />Alle verjaardagen, leeftijden, etc. zijn herberekend en tellen terug vanaf de datum die u heeft ingevoerd in de keuzevelden en het jaarveld.<br />In feite ziet u dan een verjaardagskalender, zoals uw familielid deze ook heeft gezien, lang geleden.<br />";
$pgv_lang["annivers_month_select_help"]		= "~MAAND SELECTIE~<br /><br />Op de middelste rij van het selectievak kunt u de maand selecteren. Dit werkt hetzelfde als selectie van de dag: door op een maand te klikken wordt deze aan de gewenste datum toegekend.<br /><br />Heeft u voor \"Toon dag\" gekozen en klikt u op een nieuwe maand, dan zullen op het scherm de gebeurtenissen worden getoond op de eerder gekozen dag en jaar, in combinatie met de nieuw gekozen maand.<br /><br />Heeft u voor \"Toon maand\" gekozen, dan worden de gebeurtenissen getoond van het eerder gekozen jaar en de nu gekozen maand.<br /><br />Rechts in de maandbalk ziet u een snelkoppeling naar de huidige maand. Als u hierop klikt, wordt het maandoverzicht van de huidige maand getoond.<br /><br />Rechts in de dagbalk ziet u de huidige datum staan. Als u hierop klikt, verschijnt het overzicht op de huidige datum.<br />";
$pgv_lang["annivers_year_select_help"]		= "~JAAR INVOERVAK~<br /><br />In dit vak kunt u het jaartal typen, waarvan u het maandoverzicht of jaaroverzicht wilt zien.<br />In het dagoverzicht heeft het jaartal geen functie, omdat alle gebeurtenissen uit alle jaren worden getoond.<dl><dt><b>Geavanceerde mogelijkheden</b> voor <b>#pgv_lang[viewyear]#:<br /><br />Meer dan een jaar</b></dt><dd>U kunt de gebeurtenissen van meer dan een jaar tonen door de jaartallen als volgt in het jaarvak in te vullen:<br />- Voorbeeld 1: <b>1992-5</b> voor alle gebeurtenissen van 1992 tot en met 1995.<br />- Voorbeeld 2: <b>1972-89</b> voor alle gebeurtenissen van 1972 tot en met 1989.<br />- Voorbeeld 3: <b>1610-759</b> voor alle gebeurtenissen van 1610 tot 1759.<br />- Voorbeeld 4: <b>1880-1905</b> voor alle gebeurtenissen van 1880 tot 1905<br />- Voorbeeld 5: <b>880-1105</b> alle gebeurtenissen van 880 tot 1105.<br /><br />In alle gevallen kunt u de twee jaartallen volledig invoeren met een liggend streepje ertussen, zie de voorbeelden 4 en 5.<br /><br /></dd><dt><b>Afkortingen</b></dt><dd>Soms is niet precies bekend, wanneer een gebeurtenis heeft plaatsgevonden. In dat geval kunnen er aan de datum termen worden toegevoegd als \"voor\", \"na\", \"ongeveer\", etc. De datums worden dan in het bestand opgeslagen met de Engelse afkorting ervan. Deze afkortingen kunt u gebruiken in het jaarvak:<br /><b>abt</b> 1800 (abt=about, ongeveer)<br /><b>bet</b> 1950-1959 (bet=between, tussen), type dit als: bet 1950-59<br /><b>bef</b> 1950 (bef=before, voor)<br /><b>aft</b> 1910 (aft=after, na)<br /><br />Let op: PhpGedView zoekt in het bestand op de exacte term die u heeft ingevoerd. Met de term \"abt 1800\" wordt een datum \"abt oct 1800\" dus <b>niet</b> gevonden.<br />U kunt ook alleen de afkortingen gebruiken, alle gebeurtenissen met een jaartal met deze afkorting worden dan gevonden.<br /><br /></dd></dl>Nadat u het jaar heeft ingevuld, moet u op de <b>#pgv_lang[viewmonth]#</b> of <b>#pgv_lang[viewyear]#</b> knop klikken om het nieuwe overzicht op het scherm te tonen.<br />";
$pgv_lang["annivers_show_help"]				= "~TOON GEBEURTENISSEN VAN ....~<br /><br />Als u niet op de site bent aangemeld, heeft u de keuze uit:<br /><br /><i>Alle personen</i><br />U krijgt alle personen en families te zien.<br /><br /><i>Recente gebeurtenissen (<100 jaar)</i><br />Toont alleen de personen en gezinnen, waaraan een gebeurtenis is gekoppeld die op de desbetreffende dag, minder dan 100 jaar geleden, heeft plaatsgevonden.<br /><br />Heeft u zich wel aangemeld, dan heeft u tevens de optie:<br /><br /><i>Levende personen</i><br />Toont alleen de levende personen, waaraan een gebeurtenis is gekoppeld die op de desbetreffende dag heeft plaatsgevonden<br /><br />Bij ieder van deze keuzes blijft de gekozen datum en dag/maand selectie gehandhaafd.<br />";
$pgv_lang["annivers_sex_help"]				= "~SELECTIE GESLACHT~<br /><br />Als u als gebruiker bent aangemeld (of als de beheerder de privacybeperkingen heeft uitgeschakeld) kunt u kiezen uit drie mogelijkheden:<dl><dt><b>1. Alle</b></dt><dd>Met deze optie worden de gebeurtenissen van alle personen en gezinnen getoond.</dd><dt><b>2. Mannelijk</b></dt><dd>Hier worden alleen de gebeurtenissen van mannelijke personen getoond, alsmede de gezinsgebeurtenissen van mannelijke gezinsleden.</dd><dt><b>3. Vrouwelijk</b></dt><dd>Hier worden alleen de gebeurtenissen van vrouwelijke personen getoond, alsmede de gezinsgebeurtenissen van vrouwelijke gezinsleden.</dd></dl>Als u een optie heeft aangeklikt wordt het scherm ververst en krijgt u de nieuwe gegevens te zien. Andere keuzes zoals jaar, maand en dag blijven zoals ze waren.<br />";
$pgv_lang["annivers_event_help"]			= "~SELECTIE GEBEURTENIS~<br /><br />U kunt hier aangeven of u voor de personen en gezinnen alle gebeurtenissen wilt weergegeven, of alleen een specifieke gebeurtenis.<br /><br />Als u de keuze heeft gemaakt, ververst het scherm en wordt getoond wat u heeft gekozen.<br />Andere keuzes zoals jaar, maand en dag blijven zoals ze waren.<br />";
$pgv_lang["annivers_tip_help"]				= "~TIP~<br /><br />Stel dat u een familielid heeft, geboren op 25 januari 1875.<br />Stel nu de datum hierop in.<br />Wanneer u nu op de \"Toon dag\" of \"Toon maand\" knop klikt, krijgt u een kalender voor die datum.<br />Alle leeftijden, verjaardagen, etc. zijn herberekend aan de hand van de datum die u heeft ingevoerd.<br />In feite ziet u nu dus een kalender, die uw familielid lang geleden op die datum zou hebben gezien.<br />";
$pgv_lang["day_month_help"]					= "~TOON DAG / TOON MAAND / TOON JAAR~<br /><br />Met de <b>\"Toon dag\"</b> knop worden de personen weergegeven waaraan een gebeurtenis is gekoppeld, die op die dag en maand in een willekeurig jaar heeft plaatsgevonden. Het wijzigen van het jaar in het jaarveld heeft dus geen effect. Leeftijden worden berekend ten opzichte van het huidige jaar.<br /><br />De <b>\"Toon maand\"</b> knop laat een kalender zien, met de gebeurtenissen die op iedere dag van die maand hebben plaatsgevonden, met de bijbehorende personen. Met het jaarvak kunt u instellen, tot welk jaar de gebeurtenissen worden geselecteerd. Bij 1800 worden alle gebeurtenissen tot en met het jaar 1800, in de gekozen maand, getoond. In combinatie met \"Recent verleden\" krijgt u een realistische indruk van hoe de kalender aan de muur van uw voorouders er moet hebben uitgezien in het gekozen jaar.<br /><br />Met de <b>\"Toon jaar\"</b> knop krijg u een overzicht van personen en families, waarvan een gebeurtenis aan het desbetreffende jaar is gekoppeld. De gebeurtenissen worden getoond en het overzicht is gesorteerd op naam.<br />Ook kunt u hier een periodes van jaren selecteren. Voor 1990 tot en met 1995 typt u: 1990-5. Voor 1900 tot en met 1930: 1900-30. Tevens kunt u een periode van 10 jaar selecteren, door in het jaarveld alleen de eerste drie cijfers van het jaartal in te geven. 190 selecteert dus de periode 1900-1909.<br />In alle gevallen is het mogelijk de periode aan te geven door de gehele jaartallen in te voeren, met een minteken ertussen: 1764-1823.<br /><br />Bij al deze keuzes kunt u de gebeurtenissen limiteren door \"Levende personen\" of \"Recent verleden\" te kiezen.<br /><br />Let op: zodra u een nieuw jaartal heeft ingevoerd in het jaarvak, moet u op een van de drie knoppen klikken om dit te activeren.<br />";

//-- Clippings Cart-page
$pgv_lang["help_clippings.php"]				= "~STAMBOOMKNIPSELS~<br /><br />Met deze functie kunt u gegevens uit de stamboom in GEDCOM-formaat verzamelen. Uiteindelijk kunt u de verzamelde GEDCOM-regels downloaden naar uw eigen PC.<br /><br />Hoe verzamelt u de gegevens?<br />Dit is eenvoudig. Als ergens op een pagina u een naam ziet, waarop u kunt klikken (familie, persoon of bron), gaat u naar de detailpagina hiervan. Daar ziet u een optie \"Toevoegen aan knipselbak\".<br />Als u daarop klikt, krijgt u een nieuw scherm, waarop u kunt kiezen uit een aantal mogelijkheden voor het toevoegen.<br /><br />Hoe download u gegevens?<br />Zodra u gegevens in uw knipselbak heeft, kunt u deze downloaden. Klik hiervoor op de koppeling \"Nu downloaden\" en volg de instructies.";
$pgv_lang["clip_download_help"]				= "~DOWNLOAD KNIPSELBAK~<br /><br />Als u op deze koppeling klikt, komt u op een nieuwe pagina terecht.<br />Mogelijk staan daarop meerdere opties om te downloaden.<br />Volg dan de instructies die daarbij worden vermeld.";
$pgv_lang["empty_cart_help"]				= "~KNIPSELBAK LEEGMAKEN~<br /><br />Door op deze koppeling te klikken, wordt uw knipselbak geheel leeg gemaakt.<br /><b>Let op:</b> er wordt <b>niet</b> om een bevestiging gevraagd, om te verwijderen.<br /><br />Als u niet alle personen, gezinnen, etc. uit uw knipselbak wilt verwijderen, kunt u dit selectief doen door op de koppeling \"Verwijderen\" in het desbetreffende vak te klikken.";
$pgv_lang["add_by_id_help"]					= "~STAMBOOMKNIPSEL TOEVOEGEN D.M.V. ID~<br /><br />In dit veld kunt u het ID nummer van een persoon (of een gezin, of een bron) invullen, zodat de Gedcom gegevens aan de Knipselbak zullen worden toegevoegd. Zodra dat is toegevoegd, krijgt u nog opties aangeboden om ook familieleden daarvan aan de Knipselbak toe te voegen.<br /><br />Als u het ID nummer niet weet, heeft u de mogelijkheid tot zoeken, door op een ikoontje van een persoon, gezin, of bron te klikken. Deze ikoontjes vindt u naast het invulvakje.<br /><br />";
$pgv_lang["zip_help"]						= "~ZIP KNIPSELS~<br /><br />Selecteer deze optie als u uw knipsels wilt opslaan in een ZIP bestand.<br />Knipsels, die zijn opgeslagen in een ZIP bestand, nemen minder ruimte in.<br />Voor meer informatie over ZIP bestanden kunt u de WinZip site bezoeken op <a href=\"http://www.winzip.com\" target=\"_blank\">http://www.winzip.com</a>.<br /><br />";
$pgv_lang["include_media_help"]				= "~INCLUSIEF MEDIA~<br /><br />Selecteer deze optie om ook de mediabestanden, die zijn verbonden aan de gegevens in uw knipselbak, te downloaden.  Als u deze optie kiest, worden de bestanden automatisch ingepakt in een ZIP bestand, voordat ze kunnen worden gedownload.<br /><br />";
$pgv_lang["clip_cart_help"]					= "~KNIPSELBAK~<br /><br />Dit vak laat de inhoud zien van uw Knipselbak. <br />De <i>Soort</i> kolom geeft het soort aan van elk knipsel. Dat kunnen Personen zijn (INDI), Gezinnen (FAM), Bronnen (SOUR), Bewaarplaatsen (REPO), Notities (NOTE) en Media (OBJE);  elk wordt weergegeven d.m.v. een eigen ikoon.  <br />De <i>ID</i> kolom toont het ID nummer van elk item.  <br />De <i>Naam / Omschrijving</i> kolom toont de naam van een persoon of gezin, dan wel een omschrijving van het betreffende item.  <br />Met de Verwijder-knop (de grote rode X) in de laatste kolom, kunt u het item per regel verwijderen uit de knipselbak.  <b>Er wordt NIET gevraagd om de verwijdering te bevestigen.</b> Als u op de rode X klikt, wordt de regel zonder meer verwijderd.<br />Als u de hele Knipselbak wilt legen, kunt u dat doen door op de link <i> Maak bak leeg</i> te klikken<br /><br />";

//-- GEDCOM Edit Utility
$pgv_lang["show_changes_help"]				= "~TOON GEDCOM-WIJZIGINGEN~<br /><br />Als u deze koppeling ziet, betekent dit dat:<br /><br />1. Iemand wijzigingen heeft aangebracht aan het GEDCOM-bestand.<br />Gegevens kunnen zijn gewijzigd, verwijderd of toegevoegd.<br /><br />2. De wijzigingen zijn door de beheerder nog niet geaccepteerd.<br />Zodra de beheerder de wijzigingen heeft geaccepteerd of verworpen, verschijnt deze koppeling niet meer.<br /><br />Door op deze koppeling te klikken, kunt u zien welke wijzigingen zijn aangebracht.<br /><br />Mocht u vinden, dat een wijziging niet correct is, neem dan contact op met de beheerder.";

//-- Search-page
$pgv_lang["help_search.php"]				= "~ZOEKEN~<br /><br />Hoewel deze pagina er eenvoudig uitziet, bevindt zich achter de zoekfunctie een uiterst krachtige zoekmachine. U kunt op deze pagina:<br /><br />* DOORZOEK GENEALOGIE(EN)<br />Met behulp van deze zoekfunctie kunt u het gehele bestand doorzoeken op willekeurig welk zoekcriterium.<br /> U kunt hier een jaartal ingeven of een (gedeelte van) de naam van een persoon of plaats.<br /><br />* ZOEK GELIJKENDE PERSOONS- of PLAATSNAMEN (SOUNDEX)<br />Met behulp van Soundex kunt u zoeken naar gelijkende namen. U kunt dit gebruiken, als u de schrijfwijze van de achternaam niet precies weet. Het programma vindt alle namen die enigszins overeen komen met degene die u heeft ingegeven.<br /><br />Ale er meer dan een genealogie op deze website aanwezig is EN de beheerder heeft het wisselen van genealogie toegestaan, zoekt deze functie door alle genealogieën heen.<br /><br />Meer informatie vindt u door op de Help-koppelingen te klikken bij de zoekvakken.<br /><br />";
$pgv_lang["search_enter_terms_help"]		= "~ZOEKCRITERIA~<br /><br />In dit vak kunt u een zoekcriterium invoeren, waarop in de stamboom zal worden gezocht.<br />Omdat de zoekmachine het gehele bestand doorzoekt, kunt u op elk willekeurig gegeven zoeken.<br />Zo kunt u een achternaam invoeren, maar ook een beroep, een plaatsnaam of een jaartal. Wanneer deze in het bestand voorkomt, zullen de bijbehorende personen en gezinnen in een resultatenvak worden getoond.<br /><br /><b>Jokertekens</b><br />De zoekmachine kent geen jokertekens zoals \"*\" of \"?\", binnen alle gegevens wordt gezocht naar het voorkomen van de letterreeks die u heeft ingevoerd. De jokertekens worden impliciet toegepast.<br />Stel dat u zoekt op <b>Peter</b>. Dit kan de volgende resultaten opleveren:<br /><b>Peter</b> Kleinsma<br /><b>Peter</b>-Jan de Groot<br />Klaas Pietersen, geboren te St. <b>Peter</b>sburg<br />etc. etc.<br /><br /><b>Datums</b><br />U kunt in principe ook zoeken op datums. Als u bijvoorbeeld zoekt op <b>1950</b>, dan worden alle personen getoond, waar in de gegevens 1950 voorkomt. Dit kan in een huwelijk zijn, maar ook in een geboorte, datum bij een beroep of welke gebeurtenis dan ook.<br /><br />Als u zoekt op <b>4 dec</b>, krijgt u als resultaat alle personen met een gebeurtenis op 4 december, maar ook op 14 december en 24 december. Ook hier voegt het programma automatisch de jokertekens toe.<br />De volgorde van dag en maand is eveneens van belang: <b>14 dec</b> selecteert alle personen met 14 december in de gegevens, <b>dec 14</b> alle personen met bijvoorbeeld <b>dec</b> 18<b>14</b><br /><br />U kunt ook zoekuitdrukkingen gebruiken. Als u bijvoorbeeld personen zoekt die een datum hebben in de 20e eeuw, dan kunt u dit als volgt invoeren: <b>19[0-9][0-9]</b>, waarmee u alle datums van 1900 tot en met 1999 selecteert.<br /><br />Heeft u meer hulp nodig bij het werken met dit zoeksysteem, meldt dit dan aan de makers van PhpGedView, zodat de Help-informatie kan worden uitgebreid.";
$pgv_lang["search_replace_help"]			= "~#pgv_lang[search_replace]#~<br /><br />Hier kunt u zoeken naar een schrijffout, of andere onjuiste informatie en deze door de juiste gegevens vervangen.<br /><br /><b>Zoeken</b><br />Deze functie zal gaan zoeken zoals een <a href=\"help_text.php?help=search_enter_terms_help\">gewone zoekopdracht</a>.<br /><br /><b>Vervangen</b><br />Alle voorkomende resultaten van de zoekopdracht zullen worden vervangen door de opgegeven vervangende tekst.<br /><br /><b>Bijvoorbeeld...</b><br />Veronderstel dat u de naam van uw grootvader Johannes verkeerd heeft geschreven. Per ongeluk heeft u 'Johannus' ingetypt. <br /><br />U vult in het Zoekvakje dan <b>Johannus</b> in. Vervolgens vult u <b>Johannes</b> in, in het Vervangen vakje.<br />Elke keer dat \"Johannus\" voorkomt, wordt deze vervangen door \"Johannes\"<br /><br /><b>Zoeken naar...</b><br />Selecteer de omvang van de zoekopdracht.  U kunt de zoekopdracht beperken tot namen of plaatsen, of geen limiet instellen (#pgv_lang[search_record]#).  De <i>#pgv_lang[search_place_word]#</i> optie zal alleen uw zoekterm gaan zoeken als een heel woord. Heeft u <i>Buinen</i> ingevuld en een vinkje gezet bij Locatie, zal alleen <b>Buinen</b> worden gevonden en niet <i>Buinen</i> in andere woorden zoals Nieuw-<b>Buinen</b>.<br /><br />Geen paniek, als per ongeluk iets wordt vervangen, wat niet de bedoeling is. Klik op de <i>#pgv_lang[accept_changes]#</i> link, onderaan de pagina, om de gewenste wijzigingen te accepteren en de ongewenste te ongedaan te maken.<br /><br />Als u meer hulp ndoig heeft met het zoeksysteem, laat ons dat dan a.u.b. weten, zodat we dit Help bestand ook kunnen aanpassen.<br /><br />";
$pgv_lang["soundex_search_help"]			= "~ZOEK GELIJKENDE PERSOONS- OF PLAATSNAMEN (SOUNDEX)~<br /><br />Type, om met behulp van Soundex te zoeken, minimaal een achternaam, voornaam of plaatsnaam in, eventueel in combinatie met een jaartal of periode. Om het aantal zoekresultaten te beperken, kunt u aanvullende criteria opgeven in de overige velden.<br /><br />Soundex wordt gebruikt om namen te vinden die weliswaar hetzelfde worden uitgesproken, maar verschillend worden geschreven. Denk aan \"Smit\", \"Smid\" en \"Smidt\".<br />In een Soundex-index wordt aan deze drie namen een zelfde code toegekend, waardoor ze bij een zoekactie alle drie worden getoond.<br />Een nadeel is, dat de eerste letter altijd wel overeen moet komen, \"Ferwerda\" en \"Verwerda\" worden dus als verschillende namen in de Soundex-index opgenomen.<br />Een voordeel is, dat namen worden gevonden, ook al kent u de precieze schrijfwijze niet.<br /><br />Deze zoekmethode werkt voor alle soorten namen, dus ook voor voornamen en plaatsnamen.<br />Als u meerdere velden invult, werkt dit als een \"EN\" functie, waardoor de zoekresultaten worden beperkt.<br />Ook kunt u een jaartal of periode toevoegen, waardoor de resultaten verder worden beperkt tot alle personen met een gebeurtenis in dat jaar of die periode.<br />Voorbeelden van mogelijkheden voor jaartal zijn: 1950 of 19[5][0]-19[6][9]. Dit laatste voorbeeld selecteert op de periode 1950-1969.";
$pgv_lang["search_exclude_tags_help"]		= "~#pgv_lang[search_tagfilter]#~<br /><br />De <b>#pgv_lang[search_tagfon]#</b> keuze zorgt ervoor dat bij de Zoek functie de volgende GEDCOM tags niet worden meegenomen:<div style=\"padding-left:30px;\"><b>_PGVU</b> - Laatste wijziging door<br /><b>CHAN</b> - Datum v.d. laatste wijziging<br /><b>FILE</b> - #factarray[FILE]#<br /><b>FORM</b> - #factarray[FORM]#<br /><b>TYPE</b> - #factarray[TYPE]#<br /><b>SUBM</b> - #factarray[SUBM]#<br /><b>REFN</b> - #factarray[REFN]#</div><br />Behalve de optie om bovenstaande tags niet in de zoekopdracht mee te nemen, worden de volgende tags altijd uitgesloten bij de Zoek functie:<div style=\"padding-left:30px;\"><b>_UID</b> - #factarray[_UID]#<br /><b>RESN</b> - #factarray[RESN]#</div><br /><br />";
$pgv_lang["search_include_ASSO_help"]		= "~#pgv_lang[search_asso_label]#~<br /><br />Bij deze optie laat PhpGedView alle personen zien, waarvan is vastgelegd dat ze een geassocieerde relatie hebben met de persoon, of het gezin, die was gevonden als resultaat van de zoekopdracht.  Het omgekeerde, waarbij alle personen of gezinnen worden getoond wanneer een persoon, gevonden als resultaat van een zoekopdracht, een geassocieerde relatie heeft met deze andere personen of gezinnen, is niet mogelijk.<br /><br />Voorbeeld:  Stel persoon <b>A</b> is peetvader van persoon <b>B</b>.  Deze relatie is opgeslagen in het GEDCOM bestand van persoon <b>B</b> d.m.v. van een ASSO tag.  Geen corresponderende tag bestaat in het GEDCOM bestand van persoon <b>A</b>.<br /><br />Als deze optie is aangevinkt, dus <b>#pgv_lang[yes]#</b>, en de Zoek resultaten lijst bevat <b>B</b>, dan zal <b>A</b> ook automatisch worden vermeld door de aanwezigheid van de ASSO tag in het GEDCOM bestand van <b>B</b>.<br />Maar, als de Zoek resultaten lijst <b>A</b> bevat, dan zal <b>B</b> niet automatisch in de lijst worden opgenomen, aangezien er geen corresponderende ASSO tag in het GEDCOM bestand van persoon <b>A</b> is.<br /><br />";

//-- Individual Information-page
$pgv_lang["help_individual.php"]			= "~DETAILGEGEVENS PERSOON~<br /><br />Op deze pagina worden alle details van de geselecteerde persoon weergegeven, voor zover deze aanwezig zijn en mogen worden weergegeven vanwege privacy-instellingen. Een uitleg van de mogelijkheden wordt hieronder gegeven.<br />Let op: sommige functies (zoals wijzigen) kunnen door de beheerder zijn uitgeschakeld.<br /><br /><i>NAAMGEDEELTE</i><br />Links op het scherm zijn de namen en het geslacht van de persoon vermeld. Indien aanwezig, eveneens diens bijnamen (\"ook bekend als\"). Aan de namen kunnen bronvermeldingen zijn gekoppeld evenals notities. Deze zijn, indien aanwezig, bij de desbetreffende naam vermeld.<br />Als een afbeelding van de persoon beschikbaar is, wordt deze eveneens getoond.<br />Tevens kunt u de namen van de persoon wijzigen of verwijderen of zelfs de gehele persoon verwijderen, mits u daartoe rechten heeft.<br /><br /><i>EXTRA FUNCTIES</i><br />Rechts op het scherm ziet u een vak, waarin de functies staan die u vanaf dit scherm kunt uitvoeren, mits de beheerder deze beschikbaar heeft gemaakt: <br /><br /><i>Kwartierstaat</i><br />Ga naar de kwartierstaat van deze persoon.<br /><br /><i>Tijdlijn</i><br />Ga naar de tijdlijn en plaats deze persoon erop.<br /><br /><i>Nakomelingen</i><br />Toon nakomelingen van deze persoon.<br /><br /><i>Toon GEDCOM-gegevens</i><br />Toont in een apart venster de gegevens van deze persoon in GEDCOM-formaat.<br /><br /><i>Toevoegen aan knipselbak</i><br />Voegt de GEDCOM-gegevens van deze persoon toe aan uw knipselbak. Hierin kunt u vanaf diverse plaatsen GEDCOM-gegevens verzamelen en deze vervolgens downloaden. Daarna kunt u ze importeren in uw eigen genealogieprogramma.<br /><br /><i>Relatie met mij</i><br />Toont de verwantschap tussen deze persoon en uzelf.<br /><br /><i>HET TABBLAD \"PERSOONLIJKE FEITEN EN DETAILS\"</i><br />Hierop worden alle bekende gegevens van de persoon en zijn/haar huwelijk(en) getoond. Per feit of detail worden tevens de bronnen getoond, waarin naar het feit wordt verwezen (klik op de + tekens om eventueel aanvullende tekst te zien).<br />Op elke datum en plaats op dit tabblad kunt u klikken. Een datum brengt u naar de jaarkalender, waar alle personen en gezinnen worden getoond waarvan een feit op die dag en maand plaatsvond. Een plaats geeft u een overzicht van alle personen en gezinnen, waarvan een gebeurtenis is verbonden met deze plaats.<br />Bij iedere huwelijksgerelateerde gebeurtenis wordt tevens de partner genoemd. Als u op de naam daarvan klikt, krijgt u de persoonlijke details van de partner te zijn. Klikt u op de koppeling \"Bekijk gezin\", dan gaat u naar de gezinsinformatie van dit gezin.<br />Tevens kunt u nieuwe feiten toevoegen aan deze persoon, en bestaande feiten wijzigen of verwijderen.<br /><br /><i>HET TABBLAD \"NOTITIES\"</i><br />Hier vindt u alle notities, die bij de persoon zijn gemaakt.<br />Ook kunt u bestaande notities wijzigen of verwijderen en nieuwe notities toevoegen.<br /><br /><i>HET TABBLAD \"BRONNEN\"</i><br />Hier vindt u alle bronnen, die direct aan de persoon zijn gekoppeld. Let op: dit zijn verwijzingen naar bronnen, die de persoon noemen of niet direct aan een feit zijn gerelateerd.<br />Door op de omschrijving van de bron te klikken, kunt u nadere gegevens over de bron inzien. Tevens wordt een lijst getoond van personen en gezinnen, die eveneens een verwijzing naar deze bron hebben.<br />Ook kunt u bestaande notities wijzigen of verwijderen en nieuwe notities toevoegen.<br /><br /><i>HET TABBLAD \"MULTIMEDIA\"</i><br />Op dit blad treft u alle koppelingen aan van de persoon met multimedia-items. U kunt ze in het groot bekijken, door op de miniatuurweergave te klikken.<br />Eveneens kunt u bestaande multimediakoppelingen wijzigen of verwijderen en nieuwe koppelingen toevoegen.<br /><br /><i>HET TABBLAD \"VERWANTEN\"</i><br />Op dit scherm vindt u de detailgegevens van het gezin met ouders en van de gezinnen van de persoon zelf. Door op de namen van de gezinsleden te klikken kunt u de detailgegevens van de persoon bekijken.<br /><br />#pgv_lang[more_help]#";
$pgv_lang["delete_person_help"]				= "~VERWIJDER DEZE PERSOON~<br /><br />Door middel van deze functie kunt u een persoon markeren voor verwijdering.<br />Als u op deze koppeling klikt, dient u eerst te bevestigen dat u deze persoon daadwerkelijk wilt verwijderen. Na bevestiging zal de persoon worden gemarkeerd voor verwijdering.<br />De daadwerkelijke verwijdering zal eerst plaatsvinden, als de beheerder van de genealogie dit heeft goedgekeurd. Pas dan is de verwijdering definitief en is de persoon niet meer zichtbaar.<br />Tot die tijd kunt u de gegevens van de persoon nog bekijken en kunnen deze zelfs nog worden bewerkt.<br /><br />Met het verwijderen van een persoon worden ook alle feiten van de persoon, de deelname in gezinnen, bronvermeldingen, notities en koppelingen met multimedia-items verwijderd.";
$pgv_lang["delete_name_help"]				= "~WIJZIG NAAM | VERWIJDER NAAM~<br /><br />Met deze functie kunt u de naam van een persoon bewerken. De persoon zelf en de bijbehorende feiten, notities en koppelingen met bronnen en multimedia worden NIET verwijderd.<br />Ook geldt, dat wijzigingen en verwijdering zichtbaar blijven en zelfs weer kunnen worden aangepast, totdat deze door de beheerder van de genealogie zijn goedgekeurd. Pas dan worden ze definitief doorgevoerd.<br /><br /><i>WIJZIG NAAM</i><br />Als u op deze koppeling klikt, kunt u in het nieuwe venster de naam van de persoon wijzigen, een roepnaam toevoegen, etc.<br /><br /><i>VERWIJDER NAAM</i><br />Met deze functie kunt u de naam van de persoon wissen. Alle gegevens van de persoon blijven ongewijzigd, behalve dat de persoon met naam \"Onbekend\" voorkomt.";
$pgv_lang["add_name_help"]					= "~NAAM TOEVOEGEN~<br /><br />Hiermee kunt u extra namen toevoegen aan deze persoon. Als een persoon onder meerdere namen bekend is of bijnamen had, kunt u deze toevoegen zonder de oude naamsgegevens te wijzigen.";
$pgv_lang["add_sibling_help"]				= "~VOEG BROER OF ZUS TOE~<br /><br />Met deze functie kunt u een nieuw persoon als broer of zus toevoegen aan dit gezin.<br />Let op: hiermee wordt een kind toegevoegd aan het gezin van de ouders van de persoon bovenin het scherm.<br />Als u op de koppeling heeft geklikt, krijgt u een nieuw scherm, waarop u zoveel mogelijk gegevens van de persoon dient in te vullen.<br /><br />Voor het toevoegen van een kind aan het gezin van de gekozen persoon, dient u naar de detailpagina voor het gezin te gaan. Klik hiervoor op de koppeling \"Bekijk gezin\" bij :Gezin met partner\".";
$pgv_lang["add_son_daughter_help"]			= "~VOEG ZOON OF DOCHTER TOE~<br /><br />Met deze functie kunt u een nieuw persoon als kind toevoegen aan dit gezin.<br />Als u op de koppeling heeft geklikt, krijgt u een nieuw scherm, waarop u zoveel mogelijk gegevens van de persoon dient in te vullen.<br /><br />Als u een broer of zus wilt toevoegen aan de partner, dient u dit vanaf de pagina met persoonsinformatie te doen. Klik hiervoor op de naam van de persoon, aan wie een broer/zuster toegevoegd moet worden.";
$pgv_lang["link_child_help"]				= "~KOPPEL DEZE PERSOON AAN EEN BESTAAND GEZIN ALS: KIND~<br /><br />Met deze functie kunt u de persoon aan een reeds bestaand gezin toevoegen, als kind. Dit kan voorkomen, als tot op heden de ouders van de persoon onbekend waren, en u nu ontdekt heeft, dat deze in uw bestand reeds voorkwamen.<br /><br />Als u op de koppeling klikt, verschijnt een scherm waarin u de ID van het desbetreffende gezin dient op te geven. Met de zoekfunctie kunt u deze gemakkelijk selecteren.";
$pgv_lang["link_husband_help"]				= "~KOPPEL DEZE PERSOON AAN EEN BESTAAND GEZIN ALS: PARTNER~<br /><br />Met deze functie kunt u de huidige persoon toevoegen als partner in een <i>bestaand</i> gezin.<br />Binnen dit gezin is dan bijvoorbeeld de partner onbekend, doch er zijn al wel een ouder en kinderen die gezamenlijk een gezin vormen.<br />Let op: De huidige persoon zal in dat gezin de plaats innemen van een eventueel bestaande partner. Alle bestaande koppelingen in het gezin met huwelijksgegevens, kinderen, etc. blijven behouden.<br />Als u op deze koppeling heeft geklikt, kunt u in een nieuw venster de ID van het gezin opgeven of deze met de zoekfunctie selecteren.<br /><br />Wilt u een <i>nieuw</i> gezin vormen, kies dan: \"Nieuwe partner toevoegen\".";
$pgv_lang["add_husband_help"]				= "~NIEUWE PARTNER TOEVOEGEN~<br /><br />Hiermee kunt u een nieuwe persoon toevoegen als partner voor de persoon bovenaan het scherm. U vormt hierdoor een nieuw gezin<br /><br />Als u op de koppeling heeft geklikt, krijgt u een nieuw scherm, waarop u zoveel mogelijk gegevens van de persoon dient in te vullen. ";
$pgv_lang["link_new_husb_help"]				= "~#pgv_lang[link_new_husb]#~<br />Dit stelt u in staat om een bestaand persoon (in dit bestand) aan deze persoon toe te voegen als partner.<br />Hierdoor ontstaat  een nieuwe familie met de, door u geselecteerde partner.<br />Eveneens heeft u de optie om een huwelijk voor deze nieuwe familie te specificeren.<br /><br />";
$pgv_lang["add_opf_child_help"]				= "~#pgv_lang[add_opf_child]#~<br /><br /> Hier kunt u een <u>nieuw</u> kind aan deze persoon toevoegen. U maakt dan een 1-ouder gezin.<br /><br />Door op deze link te klikken krijgt u een pop-up window om de nieuwe persoon toe te voegen.  Vul zo veel mogelijk vakjes in en klik op de <b>Opslaan</b> knop.<br /><br />Dat is alles.<br /><br />";
$pgv_lang["link_wife_help"]					= "~KOPPEL DEZE PERSOON AAN EEN BESTAAND GEZIN ALS: PARTNER~<br /><br />Met deze functie kunt u de huidige persoon toevoegen als partner in een <i>bestaand</i> gezin.<br />Binnen dit gezin is dan bijvoorbeeld de partner onbekend, doch er zijn al wel een ouder en kinderen die gezamenlijk een gezin vormen.<br />Let op: De huidige persoon zal in dat gezin de plaats innemen van een eventueel bestaande partner. Alle bestaande koppelingen in het gezin met huwelijksgegevens, kinderen, etc. blijven behouden.<br />Als u op deze koppeling heeft geklikt, kunt u in een nieuw venster de ID van het gezin opgeven of deze met de zoekfunctie selecteren.<br /><br />Wilt u een <i>nieuw</i> gezin vormen, kies dan: \"Nieuwe partner toevoegen\".";
$pgv_lang["add_wife_help"]					= "~NIEUWE PARTNER TOEVOEGEN~<br /><br />Hiermee kunt u een nieuwe persoon toevoegen als partner voor de persoon bovenaan het scherm. U vormt hierdoor een nieuw gezin<br /><br />Als u op de koppeling heeft geklikt, krijgt u een nieuw scherm, waarop u zoveel mogelijk gegevens van de persoon dient in te vullen. ";
$pgv_lang["link_new_wife_help"]				= "~#pgv_lang[link_new_wife]#~<br />Dit stelt u in staat om een bestaand persoon (in dit bestand) aan deze persoon toe te voegen als partner.<br />Hierdoor ontstaat  een nieuwe familie met de, door u geselecteerde partner.<br />Eveneens heeft u de optie om een huwelijk voor deze nieuwe familie te specificeren.<br /><br />";
$pgv_lang["add_new_parent_help"]			= "#pgv_lang[multiple_help]#<br />~VADER OF MOEDER TOEVOEGEN~<br /><br />In iedere genealogie zullen vele personen voorkomen zonder gegevens over de ouders. In dat geval vindt u, op het detailscherm personen om alsnog ouders toe te voegen. U vindt deze koppelingen op de tab \"Verwanten\", waar u kunt kiezen om een vader of een moeder toe te voegen.<br /><br />Let op: Hiermee kunt u alleen <b>nieuwe</b> personen als vader of moeder toevoegen. Als u een <b>bestaande</b> persoon wilt toevoegen als vader of moeder, moet u de koppelingen <b>#pgv_lang[link_as]##pgv_lang[child]#</b> gebruiken, die u onderaan dezelfde pagina aantreft.";
$pgv_lang["show_fact_sources_help"]			= "~#pgv_lang[show_fact_sources]#~<br />~#pgv_lang[show_fact_notes]#~<br />Als deze optie is aangevinkt, kunt u alle Bronnen en Notities vermeldingen voor deze persoon zien.<br />Indien niet aangevinkt, zullen Bronnen en Notities vermeldingen, die zijn verbonden met andere feiten voor deze persoon niet worden getoond.<br /><br />";
$pgv_lang["age_differences_help"]			= "~#pgv_lang[age_differences]#~<br />Als deze check-box is aangevinkt, zal de «#pgv_lang[relatives]#» tab de datumverschillen als volgt tonen:<br /><ul><li>Geboortedatums van  partners:<br />Een negatieve waarde geeft aan dat de tweede partner ouder is dan de eerste.<br /><br /></li><li>Huwelijksdatum en geboortedatum van eerste kind:<br />Een negatieve waarde geeft aan dat het kind was geboren voor de huwelijksdatum. Het kan dan echter ook mogelijk zijn dat de huwelijksdatum of de geboortedatum onjuist is.<br /><br /></li><li>Geboortedatums van broers/zusters:<br />Een negatieve waarde geeft aan dat de volgorde van de kinderen verkeerd is, of dat een geboortedatum onjuist is.</li></ul><br /><br />";

//-- Add Facts
$pgv_lang["add_facts_help"]					= "~NIEUW FEIT TOEVOEGEN~<br /><br />Naast de naam kunnen van een persoon meerdere gegevens bekend zijn, zoals geboortedatum en -plaats, beroepen, woonplaatsen, etc. Met deze functie kunt u die aan de persoon toevoegen.<br />Als u het feit heeft geselecteerd in het selectievenster en op \"Toevoegen\" heeft geklikt, kunt u de nadere gegevens verder invullen.<br />";
$pgv_lang["add_custom_facts_help"]			= "~SPECIAAL FEIT TOEVOEGEN~<br /><br />Als het feit, dat u wilt toevoegen, niet in het standaard lijstje met feiten voorkomt, kunt u zelf een feit definiëren.<br />Dit gaat op dezelfde wijze als het toevoegen van een standaardfeit, zij het dat u de aanduiding van het feit eveneens moet invoeren. Dit doet u in het bovenste vakje: <b>#pgv_lang[type]#</b><br />";
$pgv_lang["add_note_help"]					= "#pgv_lang[multiple_help]#<br />~VOEG NOTITIE TOE~<br /><br />Hiermee kunt u een notitie toevoegen aan de persoon. Als u op de knop klikt, verschijnt een venster waarin u de tekst van de notitie kunt intypen.<br /><br />#pgv_lang[add_facts_general_help]#";
$pgv_lang["add_shared_note_help"]			= "#pgv_lang[multiple_help]#<br />~#pgv_lang[add_shared_note_lbl]#~<br />Als u op de <b>#pgv_lang[add_shared_note]#</b> link klikt, zal een nieuw venster worden geopend.  U kunt er voor kiezen om te linken aan een bestaande Gedeelde Notitie, of u kunt een nieuwe Gedeelde Notitie maken en op dat moment er een link aan verbinden.<br /><br />#pgv_lang[add_facts_general_help]#";
$pgv_lang["add_source_help"]				= "#pgv_lang[multiple_help]#<br />~VOEG BRONVERMELDING TOE~<br /><br />Door middel van deze koppeling kunt u een bron koppelen aan deze persoon. Zo'n koppeling heet een bronvermelding. Zodra u op deze knop heeft geklikt, verschijnt een venster, waarin u de bron kunt selecteren en zonodig informatie aan de vermelding kunt toevoegen. Let op: de bron zelf dient al op de website aanwezig te zijn!<br /><br />Als u een nieuwe bron wilt toevoegen, kunt u (per e-mail) contact opnemen met de beheerder van deze stamboom. Zodra deze de bron (al dan niet met afbeelding) heeft toegevoegd, kunt u de koppeling met deze persoon aanbrengen.<br /><br />#pgv_lang[add_facts_general_help]#";
$pgv_lang["add_media_help"]					= "~VOEG KOPPELING MET MULTIMEDIA TOE~<br /><br />Door middel van deze functie kunt u een bestaand multimedia-item koppelen aan een persoon. Als u op deze knop klikt, verschijnt een volgend scherm, waarop u het desbetreffende multimedia-item kunt selecteren. Dit dient dus al op de website aanwezig te zijn!<br /><br />Als u een NIEUW multimedia-item wilt toevoegen, dient u dit eerst (per mail) toe te sturen naar de beheerder van deze stamboom (zie onderaan het scherm). Zodra het item op de website is geplaatst, kunt u het koppelen aan de gewenste persoon.";
$pgv_lang["gen_missing_thumbs_help"]		= "~#pgv_lang[gen_missing_thumbs]#~<br />Deze  optie zal miniweergaves genereren van alle afbeeldingen, in de huidige map, die nog geen miniweergave hebben.  Dit is een stuk gemakkelijker dan, elke keer, op de <b>#pgv_lang[gen_thumb]#</b> link te klikken voor zo'n bestand.<br /><br />Als u controle wilt blijven uitoefenen over welke bestanden wel, of geen, miniweergave moeten hebben, kunt u deze optie beter niet gebruiken.  Gebruik dan de toepasselijke <b>#pgv_lang[gen_thumb]#</b> links.<br /><br />";
$pgv_lang["add_facts_general_help"]			= "~Algemene informatie over toevoegen~<br />Als u een feit, notitie, bronvermelding of koppeling met een multimedia bestand heeft toegevoegd aan een of meerdere persoon, moet deze toevoeging nog worden goedgekeurd door een gebruiker, die acceptatierechten heeft gekregen van de beheerder van de website.<br />In de tussentijd is de wijziging door een gekleurde rand herkenbaar, zichtbaar voor gebruikers met wijzigrechten, maar niet zichtbaar voor gewone gebruikers.<br />Zodra de toevoeging is geaccepteerd verdwijnt de gekleurde rand en zijn de gegevens normaal zichtbaar.";

//-- Edit user
$pgv_lang["edituser_my_account_help"]		= "Op deze pagina kunt u uw instellingen en voorkeuren aanpassen.<br /><br />U kunt uw gebruikersnaam, wachtwoord, voorkeurstaal en e-mailadres aanpassen, alsmede de site-opmaak (thema) en de gewenste verzendwijze van berichten.<br /><br />Uw ID in de genealogie geeft aan, aan welke persoon u in de genealogie bent gekoppeld en wordt gebruikt voor beveiligingsdoeleinden. Om deze reden kunt u de instelling niet aanpassen.<br /><br />";
$pgv_lang["edituser_username_help"]			= "~#pgv_lang[username]#~<br /><br />In dit vak kunt u uw gebruikersnaam aanpassen.<br /><br />In de gebruikersnaam kunt u de volgende tekens gebruiken: hoofdletters, kleine letters, verbindingsstreepje (-), liggend streepje (_) en cijfers. Gebruik <b>geen</b> spaties, punten en andere tekens.<br /><br />De gebruikersnaam is hoofdlettergevoelig. De gebruikersnaam \"Piet\" is dus een andere dan \"piet\".<br /><br />Let op: dit is de naam waarmee u zich aanmeldt bij PhpGedView, vergeet dus de volgende keer niet om de nieuwe naam te gebruiken.<br />";
$pgv_lang["edituser_firstname_help"]		= "~#pgv_lang[firstname]#~<br /><br />In dit vakje kunt u uw voornaam wijzigen.  Dit is de naam die andere (ingelogde) gebruikers zien, als u bent ingelogd.<br /><br />Howel het uw eigen keuze is, wat u in dit vakje invult, zou u de beheerder moeten informeren als u het wijzigt.  Als anderen een onbekende persoon on-line zien, kunnen ze zich afvragen wie het is en gaan informeren.  De beheerder kan het natuurlijk ook zelf uitzoeken, als u geen bericht geeft, maar u zou hem dat onnodige werk kunnen besparen.<br /><br />";
$pgv_lang["edituser_lastname_help"]			= "~#pgv_lang[lastname]#~<br /><br />In dit vakje kunt u uw achternaam wijzigen.  Dit is de naam die andere (ingelogde) gebruikers zien, als u bent ingelogd.<br /><br />Howel het uw eigen keuze is, wat u in dit vakje invult, zou u de beheerder moeten informeren als u het wijzigt.  Als anderen een onbekende persoon on-line zien, kunnen ze zich afvragen wie het is en gaan informeren.  De beheerder kan het natuurlijk ook zelf uitzoeken, als u geen bericht geeft, maar u zou hem dat onnodige werk kunnen besparen.<br /><br />";
$pgv_lang["edituser_gedcomid_help"]			= "~#pgv_lang[gedcomid]#~<br /><br />Dit koppelt u aan een persoon in de genealogie en wordt ondermeer gebruikt voor beveiligingsdoeleinden.<br />U kunt deze waarde niet veranderen, omdat hij is ingesteld door de beheerder.<br />Als u denkt dat u aan de verkeerde persoon in de genealogie bent gekoppeld, neemt u dan contact op met de beheerder.<br />";
$pgv_lang["edituser_rootid_help"]			= "~#pgv_lang[rootid]#~<br /><br />Dit is de startpersoon van al uw overzichten.<br />Als u bijvoorbeeld klikt op \"Kwartierstaat\", krijgt u standaard de startpersoon geheel links op het scherm te zien. U kunt uiteraard op de kwartierstaat pagina daarna zelf een andere startpersoon selecteren.<br />In principe kunt u iedere persoon uit de genealogie als startpersoon kiezen, mits u daarvoor de rechten heeft.<br />";
$pgv_lang["edituser_password_help"]			= "~#pgv_lang[password]#~<br /><br />Het is een goede gewoonte om uw wachtwoord periodiek te veranderen. Op die manier wordt de kans verkleind dat niet geautoriseerde personen van uw gebruikersnaam en wachtwoord gebruik maken.<br />Kies hier een wachtwoord van minimaal 6 karakters, liefst bestaand uit hoofdletters, cijfers, kleine letters en leestekens.<br /><b>Opmerking:</b><br />Het wordt aangeraden om de leestekens ( \" en ' ) niet te gebruiken. Er is geen garantie voor goede werking bij het gebruik van deze leestekens.<br />Een langer wachtwoord dan 6 karakters mag natuurlijk ook worden gekozen.<br /><br />Let er wel op, dat het wachtwoord, evenals de gebruikersnaam, hoofdlettergevoelig is.<br /><br />Als u, als bestaande gebruiker, een van de andere instellingen wijzigt, is het niet nodig om opnieuw uw wachtwoord in te typen.<br />";
$pgv_lang["edituser_conf_password_help"]	= "~#pgv_lang[confirm]#~<br /><br />Als u een wachtwoord heeft ingetypt, moet u deze hier nogmaals intypen.<br />Dit zorgt ervoor, dat er niet per ongeluk typefouten in het wachtwoord voorkomen, waardoor u niet meer kunt aanmelden.<br />Als de twee ingetypte wachtwoorden verschillen, krijg u een foutboodschap.<br />Als u, als bestaande gebruiker, een van de andere instellingen wijzigt, is het niet nodig om opnieuw uw wachtwoord in te typen.<br />";
$pgv_lang["edituser_change_lang_help"]		= "~#pgv_lang[change_lang]#~<br /><br />PhpGedView kan deze website in meerdere talen weergeven. Op deze plaats kunt u de door u gewenste taal instellen.<br />";
$pgv_lang["edituser_email_help"]			= "~#pgv_lang[emailadress]#~<br /><br />Het e-mailadres dat u hier invult, wordt gebruikt om berichten van PhpGedView heen te sturen, inclusief een eventueel nieuw wachtwoord, als u dit hebt vergeten. Het is dus belangrijk om uw e-mailadres hier correct in te vullen en het bij wijziging aan te passen.<br />";
$pgv_lang["edituser_user_theme_help"]		= "~#pgv_lang[user_theme]#~<br /><br />Deze PhpGedView website kunt u verschillende uiterlijken geven. Zo'n uiterlijk is vastgelegd in een thema. In het thema zijn bijvoorbeeld de schermkleuren en -indeling, lettertypes etc. bepaald.<br />U kunt de verschillende beschikbare thema's uitproberen en degene die u het meeste aanstaat, hier instellen.<br />Iedere keer, dat u zich opnieuw aanmeldt, wordt de website in het door u gekozen thema weergegeven.<br />";
$pgv_lang["edituser_contact_meth_help"]		= "~#pgv_lang[user_contact_method]#~<br />Via het berichtensysteem van PhpGedView kunnen berichten op verschillende manieren worden getransporteerd.<br />Hoe berichten worden <b>verzonden</b> wordt ingesteld door de beheerder.<br />De wijze waarop u berichten <b>ontvangt</b> wordt door u zelf ingesteld.<br />U heeft keuze uit de volgende mogelijkheden.";
$pgv_lang["mail_option1_help"]				= "Het interne PhpGedView berichtensysteem wordt gebruikt en er worden geen e-mailberichten verzonden.<br />U ontvangt uitsluitend interne berichten van andere gebruikers.<br />De berichten kunt u bekijken in het berichtenvak van uw persoonlijke MyGedView pagina<br />";
$pgv_lang["mail_option2_help"]				= "Dit werkt zoals #pgv_lang[messaging]#, met een toevoeging: een kopie van de berichten wordt eveneens verzonden naar uw e-mailadres. Dit is het adres dat u in uw gebruikersgegevens heeft opgegeven.<br />Deze verzendwijze wordt standaard gehanteerd.<br />";
$pgv_lang["mail_option3_help"]				= "U ontvangt uitsluitend berichten op uw e-mailadres.<br />Andere gebruikers kunnen u geen berichten sturen via het interne berichtensysteem.<br />";
$pgv_lang["mail_option4_help"]				= "Met deze optie ontvangt u op geen enkele wijze een bericht.<br />";

//-- Admin
$pgv_lang["admin_help"]						= "Op deze pagina bevinden zich de beheerfuncties. Hiermee kunt u informatie krijgen over het functioneren van de website, documentatie inzien of wijzigingen aanbrengen in de configuratie van PhpGedView.<br /><br />In de balk boven het menu zijn de versie van PhpGedView en de datum/tijd van de webserver zichtbaar<br />Tevens is mogelijk een melding zichtbaar, dat gebruikers schrijfrechten hebben op uw config.php bestand. Als u klaar bent met de functie \"instellingen\", dient u de bestanden op uw website op alleen-lezen in te stellen, behalve de index-map. Daar dienen gebruikers ook schrijfrechten te hebben.<br />Het wijzigen van rechten moet u met de hand uitvoeren, omdat hiervoor in PhpGedView geen voorziening is.<br /><br />De volgende functies zijn in dit menu voorhanden:<br /><br /><i>README DOCUMENTATIE</i><br />Dit is een koppeling naar het Readme.txt bestand van PhpGedView. Hierin treft u de voor de instellingen benodigde informatie aan.<br /><br /><i>PHPGEDVIEW GEBRUIKERSHANDBOEK</i><br />Dit handboek beschrijft stapsgewijs, hoe u PhpGedView kunt installeren. Tevens wordt ingegaan op de diverse configuratie-instellingen.<br /><br /><i>INSTELLINGEN</i><br />Met deze optie stelt u de basiswaarden van PhpGedView in, zoals de te gebruiken database. Het maken van deze instellingen is de eerste stap in het installatieproces.<br /><br/ >BEHEER GEDCOM-BESTANDEN EN PRIVACY-INSTELLINGEN</i><br />Met deze functie kunt u de inhoud van PhpGedView beheren: de genealogieën. U kunt GEDCOM-bestanden importeren, exporteren of zelfs een nieuw bestand aanmaken, om dit met behulp van PhpGedView te vullen.<br />Ook stelt u hier de privacy-instellingen in.<br /><br /><i>UPLOADEN MEDIABESTANDEN</i><br />Hiermee kunt u mediabestanden en de bijbehorende miniatuurweergaven van uw lokale PC naar de webserver transporteren.<br /><br /><i>BEHEER GEBRUIKERS</i><br />Deze site heeft minimaal één gebruiker: de beheerder. Of u meer gebruikers heeft, hangt af van het gebruik van de website. Zodra u toegang gaat verlenen op groeps- of persoonsniveau, heeft u meer gebruikers nodig. Personen kunnen zo'n gebruikersnaam zelf aanvragen, of u kunt ze handmatig aanmaken. In alle gevallen dient de beheerder een aantal aanvullende gegevens in te voeren, alvorens er met een gebruiker gewerkt kan worden.<br /><br /><i>MIGREREN GEBRUIKERSINFORMATIE</i><br />Met deze functie kunt u alle gebruikersgegevens overzetten van SQL- naar indexmodus en vice versa.<br /><br /><i>BEWERK EN CONFIGUREER DE TAALBESTANDEN</i><br />PhpGedView ondersteunt verschillende talen. Alle tekst in PhpGedView is daarom in taalbestanden vastgelegd.<br />Met deze functie kunt u vertalingen aanpassen en zelfs nieuwe talen toevoegen.<br /><br /><i>GEGEVENS SAMENVOEGEN</i><br />Hiermee kunt u de gegevens van twee gezinnen, personen of bronnen samenvoegen, wanneer deze blijken een en dezelfde te zijn.<br /><br /><i>TOON PHP-INFO</i><br />Deze functie toont technische informatie over PHP op uw webserver, en kan gebruikt worden voor foutonderzoek.<br /><br /><i>BEKIJK LOG-BESTANDEN</i><br />PhpGedView legt belangrijke bewerkingen, zoals aanmelden, toevoegen van gebruikers, etc. vast in een log-bestand. Met deze functie kunt u de inhoud daarvan bekijken.<br />";

//-- User Admin
$pgv_lang["useradmin_help"]					= "~BEHEER GEBRUIKERS~<br /><br />Op deze pagina kunt u gebruikers verwijderen, wijzigen en aanmaken.<br />Gebruikers dienen om de toegang tot uw site te regelen, er privacy-instellingen aan te relateren en het voor personen mogelijk te maken om de site op henzelf afgestemd te laten functioneren. Denk bij dit laatste aan de MyGedView pagina en de standaard-startpersoon voor overzichten.<br /><br />Door op de vraagtekens achter de verschillende onderwerpen te klikken, kunt u per onderwerp nadere informatie krijgen.<br />Als de vraagtekens niet zichtbaar zijn, controleer dan in het menu Help of de contextuele help is ingeschakeld.<br /><br />In een aantal gevallen is geen aparte helpinformatie voor de beheerder beschikbaar. U ziet dan de melding:";
$pgv_lang["useradmin_gedcomid_help"]		= "~GEDCOM INDI RECORD ID~<br /><br />Dit is het individual-ID, waarmee de desbetreffende gebruiker in de genealogie voorkomt. Het is van belang bijvoorbeeld voor privacy-instellingen, waarbij een gebruiker alleen de gegevens van directe familie mag zien. Ook is het de startpersoon voor \"Mijn kwartierstaat\" en \"Mijn persoon\" op de persoonlijke MyGedView pagina van de gebruiker.<br /><br />Voor iedere genealogie kunt u het ID voor de gebruiker instellen.<br />Als de gebruiker niet in de genealogie voorkomt, kunt u het veld leeg laten.";
$pgv_lang["useradmin_rootid_help"]			= "~STARTPERSOON VAN DE KWARTIERSTAAT~<br /><br />Voor iedere genealogie kunt u een <b>startpersoon</b> opgeven voor een gebruiker.<br />Deze startpersoon wordt dan de persoon, die standaard bij de kwartierstaat en de nakomelingen wordt getoond.<br /><br />Als dit veld leeg wordt gelaten, wordt het ID gebruikt, wat bij de GEDCOM-configuratie is opgegeven.<br /><br />De gebruiker kan de startpersoon zelf altijd aanpassen.";
$pgv_lang["useradmin_can_admin_help"]		= "~GEBRUIKER MAG BEHEREN~<br /><br />Als deze optie wordt ingeschakeld, krijgt de gebruiker alle beheerderrechten binnen PhpGedView.<br />Hij/zij kan daarmee alle instellingen veranderen, wijzigingen doorvoeren, etc.<br />Doorsnee gebruikers zullen daarom deze rechten nooit toebedeeld krijgen.<br /><br />Het toekennen van beheerderrechten geldt alleen binnen PhpGedView. Met deze optie worden geen rechten toegekend op niveau van de webserver, databases, etc.";
$pgv_lang["useradmin_sync_gedcom_help"]		= "~#pgv_lang[sync_gedcom]# CHECK BOX~<br /><br />Als dit vakje is aangevinkt en de gebruiker heeft een GEDCOM ID, wordt diens gebruikers account automatisch gesynchoniseerd met GEDCOM data.<br /><br />Dit betekent dat wanneer de GEDCOM gegevens van de gebruiker worden gewijzigd, sommige informatie, zoals email adres en naam, worden gekopieerd naar diens gebruikers account.<br />Wanneer diens gebruikers account wordt gewijzigd, worden overeenkomstige gegevens gekopieerd naar de GEDCOM kaart.";
$pgv_lang["useradmin_can_edit_help"]		= "~GEBRUIKER MAG WIJZIGEN~<br /><br />Aan iedere gebruiker op deze website kunnen rechten worden toegekend om wijzigingen aan te brengen in een bepaalde genealogie. Per genealogie kunt u de volgende waarden voor deze gebruiker instellen:<br /><br /><b>Geen</b> beperkt de rechten van de gebruiker tot het alleen raadplegen van de gegevens waarvoor geen privacybeperkingen gelden.<br /><br /><b>Toegang</b> geeft de gebruiker de mogelijkheid om privacybeschermde gegevens te zien. De gebruiker mag niets wijzigen.<br /><br /><b>Wijzig</b> geeft aan dat deze gebruiker weliswaar wijzigingen mag aanbrengen en toevoegingen mag doen op deze genealogie, maar dat deze moeten worden goedgekeurd door een (andere) gebruiker, die over <b>Accepteer</b> rechten beschikt.<br /><br /><b>Accepteren</b> geeft de gebruiker het recht om zowel wijzigingen als toevoegingen aan te brengen, als om deze (van zichzelf en van anderen) voor deze genealogie goed te keuren.<br /><br /><b>Beheren</b> geeft gebruikers beheerrechten, waardoor zij de instellingen en privacy voor deze genealogie mogen wijzigen.<br /><br />Aan beheerders worden automatisch <b>Beheren</b> rechten toegekend.";
$pgv_lang["useradmin_verified_help"]		= "~REGISTRATIE BEVESTIGD~<br /><br />Deze optie heeft betrekking op het aanvragen en aanmaken van een nieuwe gebruikersnaam. Hiervoor zijn twee mogelijkheden:<br /><br />De gebruiker vraagt via PhpGedView een gebruikersnaam aan.<br />Dit gaat in drie stappen:<br />1. De gebruiker vraagt een gebruikersnaam aan. De gebruikersnaam wordt geregistreerd in PhpGedView, en de gebruiker krijgt een e-mail met een verificatiecode.<br />2. De gebruiker verifieert zijn aanvraag door deze met behulp van de code te bevestigen. In Gebruikersbeheer wordt bij zijn gebruikersnaam het vinkje \"Bevestigd door gebruiker\" aangezet.<br />3. Na een e-mailbericht keurt de beheerder de aanvraag goed, door de optie \"Goedgekeurd door beheerder\" aan te vinken.<br />Hierna kan de gebruiker zich aanmelden.<br /><br />De beheerder maakt de gebruikersnaam aan. De desbetreffende opties zijn dan al automatisch aangevinkt.";
$pgv_lang["useradmin_verbyadmin_help"]		= "~REGISTRATIE GOEDGEKEURD~<br /><br /><br />Als de gebruiker via PhpGedView een gebruikersnaam heeft aangevraagd, is de goedkeuring door de beheerder de laatste stap in dit proces.<br /><br />Zodra u de aanmelding heeft goedgekeurd, ontvangt de gebruiker een e-mailbericht, dat de aanvraag is goedgekeurd en hij/zij zich kan aanmelden met de gekozen gebruikersnaam en wachtwoord.";
$pgv_lang["useradmin_edit_user_help"]		= "~GEBRUIKER WIJZIGEN~<br /><br />Deze optie wordt door de beheerder gebruikt om de gegevens van een gebruiker te wijzigen. De pagina komt grotendeels overeen met die voor het toevoegen van een gebruiker, en met de pagina die de gebruiker zelf krijgt voor het wijzigen van zijn gegevens.";
$pgv_lang["useradmin_visibleonline_help"]	= "~ZICHTBAAR VOOR ANDEREN ALS AANGEMELD~<br /><br />Als deze optie is ingeschakeld, kan de desbetreffende gebruiker zien welke andere gebruikers zijn aangemeld. Ook is hij zichtbaar voor anderen. Als dit ongewenst is, kunt u de optie uitschakelen, maar andere gebruikers zijn voor u dan ook niet meer zichtbaar.";
$pgv_lang["useradmin_editaccount_help"]		= "~STA GEBRUIKER TOE OM GEBRUIKERSGEGEVENS TE WIJZIGEN~<br /><br />Als deze optie is ingeschakeld, is de desbetreffende gebruiker in staat om de eigen informatie aan te passen. Met de optie uitgeschakeld is dit niet het geval.<br />Dit stelt u in staat om gebruikers voor algemeen gebruik te definiëren, zonder dat een van de gebruikers de gegevens (zoals wachtwoord) kan aanpassen.";
$pgv_lang["useradmin_relation_priv_help"]	= "~#pgv_lang[user_relationship_priv]#~<br /><br />Als dit vakje is aangevinkt, kan de gebruiker alleen de gegevens zien van nog levende personen waaraan hij of zij verwant is.<br />De gebruiker kan de gegevens van iedereen zien, die binnen het aantal stappen valt, zoals ingesteld in <i>#pgv_lang[user_path_length]#</i> instelling.<br /><br />U kunt verwantschap privacy afdwingen voor al uw gebruikers door dit in te stellen in de globale optie in de GEDCOM privacy instellingen.<br /><br />Deze instelling houdt eveneens in dat de gebruiker een GEDCOM ID moet hebben, voordat hij of zij de gegevens van enig nog levend persoon kan inzien.<br /><br />";
$pgv_lang["useradmin_path_length_help"]		= "~#pgv_lang[user_path_length]#~<br /><br />Als  <i>#pgv_lang[user_relationship_priv]#</i> is ingeschakeld, zal de gebruiker alleen de gegevens van, nog levende, personen kunnen inzien en wijzigen binnen het, hier opgegeven, aantal relatie-pad stappen.<br /><br />";
$pgv_lang["useradmin_auto_accept_help"]		= "~#pgv_lang[user_auto_accept]#~<br /><br />Door dit vakje aan te vinken, geeft u het programma toestemming om automatisch <b>alle</b> wijzigingen te accepteren, die door deze gebruiker zijn gemaakt.<br /><br />De gebruiker moet eveneens privileges voor de GEDCOM hebben geaccepteerd, om deze instelling in werking te stellen.<br /><br />";

//-- Manage Sites
$pgv_lang["help_managesites"]				= "~BEHEER SITES~<br /><br />Op deze pagina kunt u andere sites toevoegen en IP adressen blokkeren.<br /><br />Andere sites kunnen worden toegevoegd door het opgeven van de titel v.d. site, URL, database id(optioneel), gebruikersnaam en wachtwoord, voor de andere web service.<br /><br />Het blokkeren van IP adressen wordt bereikt door het invullen van een geldig  bereik van IP adressen. Bijvoorbeeld: 212.10.*.*<br />Sites binnen het IP adressen bereik, op de Geblokkeerde Sites lijst, zullen niet uw web service niet meer kunnnen bereiken.<br />U kunt uiteraard ook een enkel specifiek IP adres invullen.";
//-- Adding Remote Links
$pgv_lang["help_remotesites"]				= "~Andere Sites Toevoegen~<br /><br />Om andere sites toe te voegen vul de titel v.d. site, URL van de andere web service, database id (optioneel), gebruikersnaam en wachtwoord in.<br /> Klik op de \"Toevoegen\" knop om af te ronden.<br />Als de andere server anonieme authenticatie toestaat, vul dan geen gebruikersnaam en wachtwoord in.<br /><br />";
//-- IP Address Banning
$pgv_lang["help_banning"]					= "~IP Adres Blokkering~<br /><br />Om de toegang, van andere sites of personen via bepaalde IP adressen, tot uw web service te blokkeren kunt u hier het IP adres invullen.<br />Toets in het veld het IP adres of een bepaald bereik IP adressen (bijv.: 212.10.*.*) in.<br />Klik daarna de \"Toevoegen\" knop.<br /><br />";
$pgv_lang["help_manual_search_engines"]		= "~Handmatig Markeren van Zoekmachine Spider~<br /><br />PhpGedView stelt automatisch kleinere datbestanden, met minder links, beschikbaar aan zoekmachines.  De data zijn beperkt tot personen en hun directe familie, zonder informatie toe te voegen over grootouders of kleinkinderen.<br />Veel rapporten en andere server-intensieve pagina's zijn \"verboden toegang\" voor de spiders.<br /><br />Als een zoekmachine niet automatisch wordt herkend, en u toch wilt dat het wel gegevens indexeert, kunt u het hier in de lijst opnemen.<br />Als u daarentegen wilt dat een zoekmachine geen gegevens overneemt, kunt u het toevoegen in de lijst van geblokkeerde sites sectie, iets naar beneden op deze pagina.<br /><br />Als u wilt zien welke gegevens aan de zoekmachines worden aangeboden, om te indexeren, vul dan uw eigen IP adres hier in.  <font color=\"red\">WAARSCHUWING:</font> Daarmee wordt u UITGESLOTEN van de beheeders interface.  U kunt uw IP adres alleen verwijderen door in te loggen d.m.v. een andere machine via een ander IP adres, of u moet handmatig het <i>/index/search_engines.php</i> bestand aanpassen.<br /><br />Om handmatig een andere site als een (zoekmachine) spider te kenmerken, vult u een specifiek IP adres of een geldig IP adressen bereik in, zoals bijv.: 212.10.*.* .  Klik vervolgens op de \"Toevoegen\" knop.<br />Veel populaire zoekmachines zoals Google en Yahoo worden automatich gedetecteerd.<br /><br />";

//-- Search_engines.php
$pgv_lang["search_engine_landing_page"]		= "~Zoek Machine Gedetecteerd~<br /><br />PhpGedView biedt automatisch kleinere data bestanden, met minder links, aan aan zoekmachines. De data is beperkt tot de persoon en de directe familie, zonder dat informatie over grootouders of kleinkinderen wordt toegevoegd.<br />Veel rapporten-pagina's of pagina's die erg server-intensief zijn, zijn verboden toegang voor spiders.<br /><br />Pogingen van spiders om naar zulke pagina's te gaan hebben als gevolg dat deze pagina wordt getoond. Als u deze tekst ziet, dan denkt de software dat u een zoekmachine spider bent.<br />Onderstaand is de lijst met pagina's, waarvan spider-bezoek is toegestaan en de juiste afgekorte data bieden.<br /><br />Echte gebruikers, die links van zoekmachines volgen naar deze site, zullen de volledige pagina's en gegevens zien, maar niet deze pagina.";

//-- G E D C O M
$pgv_lang["add_upload_gedcom_help"]			= "~UPLOADEN EN TOEVOEGEN GEDCOM-BESTAND~<br /><br />Om een GEDCOM-bestand in PhpGedView op te nemen, dient het bestand op de website aanwezig te zijn. Dit kunt u op twee manieren doen:<br />Met behulp van een FTP programma en <br />met de functie \"Uploaden GEDCOM-bestand\".<br /><br />De functie \"Toevoegen GEDCOM-bestand\" ligt in het verlengde hiervan: hiermee start u het daadwerkelijk proces om het bestand in PhpGedView op te nemen.<br />Als het GEDCOM-bestand al op de PhpGedView website aanwezig is, kunt u de upload-stap dus achterwege laten.<br />";
$pgv_lang["gedcom_configfile_help"]			= "~INSTELLINGENBESTAND~<br /><br />Dit zijn de map- en bestandsnaam van het bestand, waarin alle instellingen van de desbetreffende genealogie staan.<br />";
$pgv_lang["default_gedcom_help"]			= "~STANDAARD GEDCOM~<br /><br />Als u een of meer GEDCOM-bestanden in PhpGedView heeft opgenomen, kunt u hier instellen welke genealogie <b>standaard</b> wordt getoond aan gebruikers, die zich niet hebben aangemeld.<br />Aangemelde gebruikers kunnen zelf kiezen, welke genealogie zij standaard te zien krijgen.<br />";
$pgv_lang["delete_gedcom_help"]				= "~VERWIJDER GEDCOM-BESTAND~<br /><br />Dit verwijdert alle records uit de PhpGedView-bestanden, die uit dit GEDCOM-bestand afkomstig zijn. NIET verwijderd worden het GEDCOM-bestand zelf (xxxx.ged) en het bijbehorende bestand met GEDCOM-instellingen voor PhpGedView.<br /><br />Als u later dit GEDCOM-bestand toch weer wilt toevoegen, kunt u direct de optie \"GEDCOM-bestand toevoegen\" kiezen, het GEDCOM-bestand bevindt zich dan nog steeds in de map waar u het eerder heeft geplaatst en hoeft dus niet meer ge-upload te worden.";
$pgv_lang["add_gedcom_help"]				= "~GEDCOM-BESTAND TOEVOEGEN~<br /><br />In deze stap van het proces geeft u op, welk GEDCOM-bestand moet worden geïmporteerd en welke naam het krijgt in PhpGedView.<br />Het GEDCOM-bestand moet al op de server staan, is dit nog niet zo, dan kunt u het met behulp van de functie \"Upload GEDCOM-bestand\" eerst op de juiste plaats neerzetten.<br />Als u de velden heeft ingevuld, kunt u op \"Toevoegen\" klikken om naar de volgende stap te gaan.<br />";
$pgv_lang["add_new_gedcom_help"]			= "~NIEUW GEDCOM-BESTAND MAKEN~<br /><br />Geef hier aan, onder welke naam het nieuwe GEDCOM-bestand moet worden opgeslagen. De extensie (.ged) mag weggelaten worden. Zodra u op \"Toevoegen\" heeft geklikt, gaat u naar de volgende stap van het proces, waarbij u een aantal gegevens over het nieuwe bestand moet invullen.<br />";
$pgv_lang["download_gedcom_help"]			= "~DOWNLOAD GEDCOM-BESTAND~<br /><br />U kunt een genealogiebestand in PhpGedView als GEDCOM-bestand downloaden naar uw PC.<br />Allereerst dient u te kiezen, welk formaat het GEDCOM-bestand dient te zijn. Standaard is dit UTF-8, maar het formaat ANSI (ISO-8859-1)is ook mogelijk. Raadpleeg hiervoor de documentatie van uw genealogiepakket.<br /><br />Hierna krijgt u het gebruikelijke download-venster van uw Internetverkenner, om aan te geven of en waar u het GEDCOM-bestand wilt opslaan.<br />Als het downloaden gereed is, kunt u met de \"Vorig\" knop in uw Internetverkenner terug naar het GEDCOM-menu.<br />";
$pgv_lang["edit_gedcoms_help"]				= "~BEHEER GEDCOM-BESTANDEN~<br /><br />Op dit scherm bevinden zich alle functies om de verschillende genealogieën en bijbehorende GEDCOM-bestanden te beheren.<br />De volgende opties zijn beschikbaar:<br /><br /><i>ONDERHOUD HUIDIGE GEDCOM-BESTANDEN</i><br />In het vak, waar de GEDCOM-bestanden worden vermeld, kunt u kiezen uit een aantal functies. Voor helpinformatie hierover kunt u klikken op de vraagtekens achter de kolomtitels.<br /><br /><i>GEDCOM TOEVOEGEN</i><br />Hiermee kunt u een GEDCOM-bestand, dat al op de website aanwezig is, toevoegen aan PhpGedView. Na het instellen en importeren van dit bestand wordt de genealogie beschikbaar in PhpGedView.<br /><br /><i>UPLOAD GEDCOM-BESTAND</i><br />Met deze functie kunt u een GEDCOM-bestand van uw eigen PC uploaden naar de webserver.<br /><br /><i>NIEUW GEDCOM-BESTAND MAKEN</i><br />Als u een geheel nieuwe genealogie wilt beginnen, kiest u voor deze optie. Er wordt dan een leeg GEDCOM-bestand aangemaakt, waarna u de normale procedure voor het toevoegen van een GEDCOM-bestand doorloopt.<br />Let op: Vanwege technische redenen wordt er een persoon aan de genealogie toegevoegd. Deze kunt u later weer uit de genealogie verwijderen.<br />#pgv_lang[more_help]#<br />";
$pgv_lang["edit_config_gedcom_help"]		= "~INSTELLEN PHPGEDVIEW - GEDCOMGEGEVENS~<br /><br />Per genealogie in PhpGedView moet een aantal gegevens worden ingevoerd en keuzes gemaakt. Op die manier wordt o.a. bepaald, hoe de genealogie aan de gebruiker wordt getoond.<br />Pas als deze gegevens zijn ingevoerd, kan een GEDCOM-bestand daadwerkelijk worden geïmporteerd of aangemaakt.<br />De ingevoerde waarden worden per GEDCOM-bestand opgeslagen in de index-map op de site.<br /><br />Onderaan de pagina kunt u kiezen voor \"Opslaan\", waarmee de waarden worden weggeschreven, of voor \"Reset\". Hiermee worden alle door u gewijzigde instellingen weer teruggezet naar hun oude waarde.<br /><br />Bij ieder onderwerp op deze pagina kunt op het vraagteken klikken om meer helpinformatie te krijgen.<br />";
$pgv_lang["import_gedcom_help"]				= "~IMPORTEREN GEDCOM-BESTAND</b>In de meeste gevallen is het importeren van een GEDCOM-bestand een stap in de procedure van toevoegen of uploaden.<br /><br />Deze stappen zijn in een logische volgorde en moeten worden voltooid om met het bestand te kunnen werken.<br />Als u niet de gehele procedure heeft afgewerkt, ziet u een <b>waarschuwing</b>. In dat geval dient u eerst de koppeling aan te klikken om het bestand te importeren.<br /><br />In alle gevallen worden de configuratie-instellingen gehanteerd, die u eerder heeft opgegeven.<br />De huidige informatie uit het GEDCOM-bestand zal, bij her-import, worden overschreven met de nieuwe inhoud.<br />";
$pgv_lang["upload_gedcom_help"]				= "~UPLOAD GEDCOM-BESTAND~<br /><br />Selecteer hier een GEDCOM-bestand, dat vanaf uw lokale PC naar de webserver moet worden getransporteerd. Gebruik eventueel de \"Browse\" knop om er op uw lokale schijf naar te zoeken en het te selecteren. Geef hier in ieder geval het gehele pad op en de bestandsnaam inclusief extensie (.ged).<br />Zodra u op \"Upload GEDCOM-bestand\" heeft geklikt, wordt het bestand op de server geplaatst. Daarna gaat u naar de volgende stap van het proces, waarbij u een aantal gegevens over het nieuwe bestand moet invullen.<br /><br />";
$pgv_lang["validate_gedcom_help"]			= "~VALIDEREN GEDCOM-BESTAND~<br /><br />In deze stap wordt een aantal controles uitgevoerd op het GEDCOM-bestand. Tevens kunt u zelf aangeven dat een of meer bewerkingen moeten plaatsvinden.<br /><br />Automatische controles zijn:<br /><br /><b>Datumcontrole</b><br />Hierbij wordt gecontroleerd, of de datums voldoen aan het GEDCOM-formaat. Waar mogelijk, vindt automatisch herstel plaats. Het programma kan u vragen om zelf het gebruikte datumformaat aan te geven als twijfel bestaat, bijvoorbeeld bij de keuze YYY-MM-DD of YYY-DD-MM<br /><br /><b>Controle op gebruik plaatsnaam</b><br />Gecontroleerd wordt op onjuist gebruik van de GEDCOM-tag PLAC voor het vastleggen van informatie. Dit komt soms voor bij CAST, DSCR, EDUC, IDNO, NATI, NCHI, NMR, OCCU, PROP, RELI, SSN en TITL tags. Het programma corrigeert dit automatisch. Bijvoorbeeld:<br />n SSN<br />n PLAC 123-45-6789<br />wordt gewijzigd in<br />n SSN 123-45-6789.<br /><br /><b>Mac regeleinden</b><br />De regeleinden van GEDCOM-bestanden, afkomstig van het Macintosh platform, worden automatisch gecorrigeerd.<br /><br /><b>Gebruikte karakterset</b><br />Als het programma een karakterset detecteert waarvoor conversie nodig is naar UTF-8, zal het de conversie automatisch uitvoeren.<br /><br />De handmatige keuzes zijn op het scherm zichtbaar. U kunt op de vraagtekens klikken om daar meer informatie over te krijgen.<br />";
$pgv_lang["convert_ansi2utf_help"]			= "~CONVERSIE ANSI NAAR UTF-8~<br /><br />De automatische conversie (zie help bij de pagina) werkt alleen, als in het GEDCOM-bestand de tag CHAR is opgenomen (bijvoorbeeld 1 CHAR ANSI). Is dit niet het geval, dan moet u handmatig aangeven dat conversie noodzakelijk is.<br />";
$pgv_lang["detected_ansi2utf_help"]			= "~ANSI CODERING GEVONDEN~<br /><br />Het GEDCOM-bestand dat nu wordt gevalideerd, is gecodeerd in ANSI.<br /><br />Het wordt sterk aanbevolen dat het bestand wordt geconverteerd naar UTF-8 codering.<br /><br />#pgv_lang[convert_ansi2utf_help]#";
$pgv_lang["detected_date_help"]				= "~FOUTIEF DATUMFORMAAT GEVONDEN~<br />DATUMFORMAAT WORDT AANGEPAST<br /><br />De GEDCOM 5.5 standaard voor het datumformaat is DD MMM YYYY (bijvoorbeeld 01 JAN 2004). Ook PhpGedView hanteert deze standaard.<br />Als u na de GEDCOM-validatie de bovenstaande melding ziet, kan het programma de datums converteren naar het standaard formaat.<br /><br />U heeft nog de mogelijkheid te kiezen tussen <b>dag voor maand </b> (DD MMM YYYY) en <b>maand voor dag</b> (MMM DD YYYY).<br />Wij raden u aan om voor de standaard (eerste) optie te kiezen.";
$pgv_lang["change_indi2id_help"]			= "~WIJZIG PERSOONS-ID...~<br /><br />PhpGedView koppelt instellingen zoals startpersoon en privacy-instellingen aan INDI-nummers van personen in het bestand. Als het GEDCOM-bestand daarna opnieuw wordt geïmporteerd, moeten de personen daarin dezelfde INDI-nummer toegekend gekregen hebben. Is dit niet het geval, dan verwijzen de instellingen naar verkeerde personen.<br />In zo'n geval moet u een persoonskenmerk kiezen dat wel stabiel is, d.w.z. dat bij export uit uw genealogiepakket steeds dezelfde waarde aan dezelfde persoon wordt toegekend. PhpGedView biedt de mogelijkheid om hiervoor de tags RIN of REFN te kiezen.<br />Kijk in de documentatie van uw genealogiepakket welke hiervoor in aanmerking komt, of probeer het uit door een aantal malen een GEDCOM-bestand te exporteren en in het bestand te kijken, welke tags een stabiele waarde houden.<br /><br />";
$pgv_lang["edit_privacy_help"]				= "Op deze pagina bevinden zich alle instellingen, die u ten aanzien van privacy voor deze genealogie kunt maken. Onder de menubalk kunt u zien, van welke genealogie u op dit moment de instellingen kunt wijzigen. De naam van het bijbehorende privacybestand wordt getoond in het formaat 'map/gedcomnaam_priv.php'.<br /><br />Met de beschikbare instellingen is er een grote verscheidenheid aan mogelijkheden om informatie voor gebruikers te verbergen of juist zichtbaar te maken. Het verdient aanbeveling om de beschikbare helpinformatie goed te bestuderen alvorens deze instellingen worden aangepast. Zie hiervoor de PhpGedView website.<br />";
$pgv_lang["BOM_detected_help"]				= "~Byte Order Mark (BOM) gedetecteerd~<br /><br />Het GEDCOM bestand, dat u importeert, heeft een speciale  3-byte code aan het begin. Deze speciale code wordt door sommige programma's gebruikt, om aan te geven dat het bestand is opgenomen met de UTF-8 karakter set.<br /><br />Hoewel deze speciale code niet echt een fout is, zal PhpGedView niet goed werken als het input bestand deze code bevat.  U moet PhpGedView deze code laten verwijderen.<br /><br />";
$pgv_lang["invalid_header_help"]			= "~ONGELDIGE GEDCOM KOPREGEL~<br />Een GEDCOM-bestand moet beginnen met regel 0 HEAD. PhpGedView heeft gedetecteerd dat uw GEDCOM-bestand niet met 0 HEAD begint. Als u op \"Opschonen\" heeft geklikt, worden alle regels voor 0 HEAD uit uw GEDCOM-bestand verwijderd.<br /><br />Deze fout betekent meestal dat uw programma geen correct GEDCOM-bestand heeft gemaakt, of dat het bestand geen GEDCOM-bestand is.<br />Controleer of u het juiste bestand heeft ge-upload en of het begint met een 0 HEAD regel en eindigt met een 0 TRLR regel.";
$pgv_lang["macfile_detected_help"]			= "~MACINTOSH-BESTAND GEVONDEN~<br />PhpGedView heeft gedetecteerd dat uw GEDCOM-bestand van een Macintosh computer afkomstig is. Macintosh-bestanden gebruiken andere regeleinden (r) dan Unix- (n) en DOS/Windows-systemen (rn). De PhpGedView-functies zijn gebouwd voor Unix- en DOS/Windows-bestanden.<br />Als u op de \"Opschonen\"-knop klikt, wordt uw bestand geconverteerd naad een DOS/Windows-bestand.<br />";
$pgv_lang["cleanup_places_help"]			= "~OPSCHONEN PLAATSEN~<br />PhpGedView heeft gedetecteerd dat in uw GEDCOM-bestand plaatsnamen voorkomen waar dit niet is toegestaan. Veel genealogieprogramma's, zoals Family Tree Maker, genereren dit soort fouten. PhpGedView kan met deze GEDCOM-bestanden werken, maar in de locatieniveaus worden de plaatsnamen dan niet altijd correct weergegeven.<br /><br />Bijvoorbeeld kunnen in uw bestand de volgende regels voorkomen:<br />1 SSN<br />2 PLAC 123-45-6789<br />Volgens de GEDCOM-standaard zou dit moeten zijn:<br />1 SSN 123-45-6789<br /><br />Als u op \"Ja\" klikt, spoort PhpGedView deze fouten op en corrigeert ze.<br />";
$pgv_lang["empty_lines_detected_help"]		= "~LEGE REGELS GEVONDEN~<br />PhpGedView heeft lege regels gevonden in uw GEDCOM-bestand. Omdat deze regels fouten kunnen veroorzaken worden ze voor import uit het GEDCOM-bestand verwijderd.<br />";

//-- Edit Config
$pgv_lang["help_editconfig.php"]			= "~INSTELLEN PHPGEDVIEW~<br /><br />Deze instellingen vormen de basis voor het functioneren van PhpGedView, en gelden voor de gehele website.<br />Zorg ervoor, dat u schrijfrechten heeft op het config.php bestand, zodat de ingegeven waarden weggeschreven kunnen worden.<br />Zorg er, als u SQL als database gebruikt, tevens voor dat er een lege database bestaat en een databasegebruiker, die over voldoende rechten beschikt.<br /><br />Verdere helpinformatie kunt u krijgen door op het vraagteken achter een onderwerp te klikken.<br />";

//-- merge records
$pgv_lang["help_edit_merge.php"]			= "~#pgv_lang[merge_records]#~<br /><br />Op deze pagina kunt u de gegevens van twee personen, twee families of twee bronnen samenvoegen. Dit kan noodzakelijk zijn als u twee GEDCOM-bestanden heeft samengevoegd, waar dezelfde personen, families of bronnen in voorkomen.<br /><br />Het samenvoegen gaat in drie stappen.<br /><ul><li><b>Stap 1</b> Hier wordt u gevraagd om twee ID's in te voeren. De ID's moeten van dezelfde soort zijn: beide persoons-, gezins- of bron-ID's. Het is niet mogelijk om gegevens naar een ander soort ID over te brengen. In het vak \"Samenvoegen naar ID\" vult u de ID in die behouden of aangevuld moet worden. U kunt van de zoek-koppelingen gebruik maken om het ID op te zoeken. In het vak \"Samenvoegen van\" vult u het ID in waarvan gegevens worden overgenomen en dat daarna wordt verwijderd.</li><li><b>Stap 2</b> Hierin geeft u aan welke informatie van welke ID behouden moet blijven. Deze wordt samengevoegd en in het gekozen \"naar\" ID opgeslagen. Met de vinkjes geeft u aan wat u wilt behouden.</li><li><b>Stap 3</b> Hier wordt getoond wat het resultaat van het samenvoegen is. Net als het geval is met alle wijzigingen, worden ook deze pas definitief wanneer ze door een gebruiker met accepteer-rechten worden bevestigd.</li></ul><br />";

//-- report engine
$pgv_lang["help_reportengine.php"]			= "~RAPPORTEN~<br />De items in het rapporten menu genereren rapporten in PDF formaat.<br />De eerste stap is het selecteren van een rapport. Daarna wordt gevraagd om informatie te geven die voor het vervaardigen van dat rapport noodzakelijk is, bijvoorbeeld een startpersoon of -gezin en of er wel of niet afbeeldingen moeten worden toegevoegd.<br />Als u hiermee klaar bent, kunt u klikken op de <b>#pgv_lang[download_report]#</b> knop, om het rapport naar uw computer te downloaden.<br /><br /><br />#pgv_lang[help_xml_reports]#<br />#pgv_lang[def_pdf_format_help]#<br />#pgv_lang[help_ahnentafel.xml]#<br />#pgv_lang[help_birthlist.xml]#<br />#pgv_lang[help_relativelist.xml]#";
$pgv_lang["def_pdf_format_help"]			= "~PDF BESTANDS FORMAAT~<br />De PhpGedView Rapporten Module produceert te downloaden rapporten in Adobe&reg; PDF formaat.  De GEDCOM 5.5.1 Standaard specificatie, elders in dit Help bestand al genoemd, is eveneens te downloaden als een PDF bestand.  PDF is een afkorting van <b>P</b>ortable <b>D</b>ocument <b>F</b>ormat.<br /><br />PDF bestanden zijn niet te bekijken of te printen met de standaard software op uw computer. Als Acrobat Reader reeds op uw computer aanwezig is (het wordt vaak samen met andere software aangeboden), hoeft u deze niet te vervangen of op te waarderen, om de rapport bestanden, die door  PhpGedView worden gemaakt, te verwerken.<br /><br />Acrobat Reader, het programma om deze bestanden te bekijken en te printen, wordt gratis beschikbaar gesteld door Adobe Systems Inc.  Deze gratis Adobe&reg; Acrobat Reader kan worden gedownload van de <a href=\"http://www.adobe.com/products/acrobat/readstep2.html\" target=\"_blank\"><b>Adobe Systems Inc.</b></a> web site.  U zult op andere Internet sites ook versies van \"Acrobat Reader\" vinden, beschikbar om te  downloaden, maar we adviseren om <u>alleen</u> de Adobe Systems Inc. site te vertrouwen.<br /><br />Acrobat Reader is beschikbaar voor vele verschillende systemen, inclusief Microsoft&reg; Windows and Apple&reg; Macintosh, in vele talen.  Als u nog een Windows 95 systeem heeft, selecteer dan Acrobat Reader versie 5.0.5 om te downloaden.  Recentere versies zult u niet correct op een Windows 95 systeem kunnen installeren.<br /><br /><a href=\"http://www.adobe.com/products/acrobat/readstep2.html\" target=\"_blank\"><b>Download Adobe Reader hier</b></a><br /><br />";
$pgv_lang["help_ahnentafel.xml"]			= "~#pgv_lang[ahnentafel_report]#~<br />Dit is een rapport van de geselecteerde persoon en de voorouders hiervan, geprint in booklet formaat.  Het begint met de gekozen persoon en vervolgt dan met diens ouders, grootouders, enz.<br /><br />";
$pgv_lang["help_birthlist.xml"]				= "~#pgv_lang[birth_report]#~<br />Met dit rapport kunt u een lijst maken met alle personen, die zijn geboren in een bepaalde plaats of in een bepaalde tijdsperiode. Een combinatie kan natuurlijk ook.<br /><br />";
$pgv_lang["help_relativelist.xml"]			= "~#pgv_lang[relatives_report]#~<br />Dit rapport maakt een lijst van alle verwanten van de geselecteerde persoon.  U kunt zelf kiezen welke verwanten van die persoon in het rapport zullen worden getoond.<ul><li><b>#pgv_lang[child-family]#</b> zal de geselecteerde persoon, diens ouders en broers en zusters, laten zien. </li><li><b>#pgv_lang[spouse-family]#</b> zal de persoon tonen, met diens partner en hun kinderen.</li><li><b>#pgv_lang[direct-ancestors]#</b> zal de persoon tonen, diens ouders, grootouders, overgrootouders, enz. Het vervolgt de boom met alle personen die ouders zijn in de directe lijn van de geselecteerde startpersoon.</li><li><b>#pgv_lang[ancestors]#</b> zal alle mensen opsommen van de #pgv_lang[direct-ancestors]# lijst, maar ook inclusief ooms en tantes enz. De lijst bevat dus alle directe voorouders, inclusief alle kinderen van deze voorouders. Het zal echter niet de kinderen van deze kinderen tonen (neven en nichten). </li><li><b>#pgv_lang[descendants]#</b> zal alle nakomelingen van de geselecteerde persoon tonen  (kinderen, kleinkinderen, achterkleinkinderen, enz.).</li><li><b>#pgv_lang[all]#</b> deze optie is een combinatie van #pgv_lang[descendants]# en #pgv_lang[ancestors]# in een enkel rapport.</li></ul><br /><br />";
$pgv_lang["help_xml_reports"]				= "~Rapporten Module~<br />De PhpGedView Rapporten Module gebruikt XML sjabloon bestanden om rapporten in PDF formaat automatisch te genereren.<br /><br />De rapporten, beschikbaar in de <b>#pgv_lang[select_report]#</b> lijst, worden gemaakt van de rapport-XML bestanden, gevonden in de \"rapporten\" map.  U kunt uw eigen rapporten genereren door een kopie te maken van een van de beschibare sjablonen en dan de sjabloon XML te wijzigen.  Om uw aangepast rapport toe te voegen, hoeft u het alleen maar in de  \"rapporten\" map te plaatsen en PhpGedView zal het automatisch detecteren en beschikbaar stellen in de <b>#pgv_lang[select_report]#</b> drop-down lijst.<br /><br />";

//-- Help Contents
$pgv_lang["help_contents_head_help"]		= "<b>HELP INHOUD</b><br /><br />";
$pgv_lang["help_contents_gedcom_info"]		= "GEDCOM-informatie";
$pgv_lang["help_contents_gedcom_places"]	= "Locaties in het GEDCOM-bestand";

//-- Admin Help Contents Items
$pgv_lang["admin_help_contents_head_help"]	= "<b>INHOUDSOPGAVE HELP<br /><br />HELPONDERWERPEN BEHEERDER</b> toegevoegd aan het begin van de lijst.<br /><br />";
// ##$pgv_lang["ah1_help"] = "_Upgrade";
$pgv_lang["ah2_help"]						= "_Instellen PhpGedView";
$pgv_lang["ah3_help"]						= "_GEDCOM: Toevoegen en uploaden";
$pgv_lang["ah4_help"]						= "_GEDCOM: Instellingenbestand";
$pgv_lang["ah5_help"]						= "_GEDCOM: Standaard";
$pgv_lang["ah6_help"]						= "_GEDCOM: Verwijderen";
$pgv_lang["ah7_help"]						= "_GEDCOM: Toevoegen";
$pgv_lang["ah8_help"]						= "_GEDCOM: Nieuwe maken";
$pgv_lang["ah9_help"]						= "_GEDCOM: Downloaden";
$pgv_lang["ah10_help"]						= "_GEDCOM: Beheerpagina";
$pgv_lang["ah11_help"]						= "_GEDCOM: Instellen";
$pgv_lang["ah12_help"]						= "_GEDCOM: Importeren";
$pgv_lang["ah13_help"]						= "_GEDCOM: Uploaden";
$pgv_lang["ah14_help"]						= "_GEDCOM: Valideren";
$pgv_lang["ah15_help"]						= "_GEDCOM: Converteren van ANSI naar UTF-8";
$pgv_lang["ah16_help"]						= "_GEDCOM: Privacy instellingen";
$pgv_lang["ah17_help"]						= "_Gebruikersbeheer";
$pgv_lang["ah18_help"]						= "_Beheer";
$pgv_lang["ah19_help"]						= "_GEDCOM: Toevoegen multimedia";
$pgv_lang["ah20_help"]						= "_GEDCOM: Wijzig persoons-ID";
$pgv_lang["ah21_help"]						= "_Taalbestanden";
//           22 is in the help_text_vars.php
$pgv_lang["ah23_help"]						= "_Instellen ondersteunde talen";
$pgv_lang["ah24_help"]						= "_Migreren gebruikersinformatie (SQL <<-->> Indexmodus)";
$pgv_lang["ah25_help"]						= "_PhpGedView backup";
$pgv_lang["ah26_help"]						= "_VGV Lijst: Wijzig";

//--Statistics Help
$pgv_lang["help_statisticsplot.php"]		= "~Statistics Plot~<br /><br />This is the result page, showing the graphical plot of the statistics from your database as defined by the inputs on the previous page.<br /><br />";
$pgv_lang["help_statistics.php"]			= "~Statistics Plot~<br /><br />This page lets you determine the criteria for producing a graphical display of various statistics from your database.<br /><br />";
$pgv_lang["stat_help"]						= "~OPTIES VOOR STATISTISCHE PLOTS~<br /><br />Een aantal verschillende plots van statistieken uit het databestand kunnen worden geproduceerd.<br /><br />Selecteer het diagram, pas vervolgens de opties aan n.b.v. de keuzelijsten.<br /><br />De aantallen in elke plot hangen af van de beschikbare gegevens. Bijvoorlbeeld: personen, zonder een aanwezige geboortemaand, (bijv.: alleen maar 1856) kunnen niet worden opgenomen in een diagram van Geboorten per maand.<br /><br />";
$pgv_lang["stat_help_x"]					= "~OPTIES VOOR STATISTISCHE PLOTS~<br /><br />~X AS~<br />De volgende opties zijn beschikbaar voor de X as (horizontaal). Elk zal dan worden getoond volgens de opties, zoals deze zijn ingesteld voor de Y en Z assen.<p style=\"padding-left: 25px\"><b>#pgv_lang[stat_11_mb]#</b>&nbsp;&nbsp;personen, geboren per maand.<br /><b>#pgv_lang[stat_12_md]#</b>&nbsp;&nbsp;personen, overleden per maand.<br /><b>#pgv_lang[stat_13_mm]#</b>&nbsp;&nbsp;huwelijken, die voorkwamen per maand<br /><b>#pgv_lang[stat_14_mb1]#</b>&nbsp;&nbsp;het aantal eerst-geborenen voor elk gezin, per maand.<br /><b>#pgv_lang[stat_15_mm1]#</b>&nbsp;&nbsp;het aantal eerste huwelijken, per maand.<br /><b>#pgv_lang[stat_16_mmb]#</b>&nbsp;&nbsp;het aantal maanden tussen huwelijk en de geboorte van het eerste kind van het paar.<br /><b>#pgv_lang[stat_17_arb]#</b>&nbsp;&nbsp;leeftijd bij overlijden, gerelateerd aan de tijdsperiode, waarin het geboortejaar van elke persoon valt.<br /><b>#pgv_lang[stat_18_ard]#</b>&nbsp;&nbsp;leeftijd bij overlijden, gerelateerd aan de tijdsperiode, waarin het jaar van overlijden valt, van elke persoon.<br /><b>#pgv_lang[stat_19_arm]#</b>&nbsp;&nbsp;de gemiddelde leeftijd van personen, ten tijde van hun huwelijk.<br /><b>#pgv_lang[stat_20_arm1]#</b>&nbsp;&nbsp;de gemiddelde leeftijd van personen, ten tijde van hun eerste huwelijk.<br /><b>#pgv_lang[stat_21_nok]#</b>&nbsp;&nbsp;gemiddelde grootte van de gezinnen.<br /><b>#pgv_lang[stat_1_map]#</b>&nbsp;&nbsp;plaatsin van alle personen of personen met een bepaalde naam, per land.<br /><b>#pgv_lang[stat_2_map]#</b>&nbsp;&nbsp;het aantal geboorten, per land.<br /><b>#pgv_lang[stat_4_map]#</b>&nbsp;&nbsp;het aantal huwelijken, per land.<br /><b>#pgv_lang[stat_3_map]#</b>&nbsp;&nbsp;het aantal sterfgevallen, per land.<br /><b>#pgv_lang[stat_9_indi]#</b>&nbsp;&nbsp;taartdiagram van personen met bronnen.<br /><b>#pgv_lang[stat_8_fam]#</b>&nbsp;&nbsp;taartdiagram van gezinnen met bronnen.</p><br /><br />";
$pgv_lang["stat_help_y"]					= "~OPTIES VOOR STATISTISCHE PLOTS~<br /><br />~Y AS~<br />De volgende opties zijn beschikbaar voor de Y as (vertikaal). Deze opties wijzigen de wijze waarop de onderdelen worden getoond langs de X as.<p style=\"padding-left: 25px\"><b>#pgv_lang[stat_201_num]#</b>&nbsp;&nbsp;toont het aantal personen van elke categorie, zoals opgegeven voor de X as.<br /><b>#pgv_lang[stat_202_perc]#</b>&nbsp;&nbsp;bereknt en toont de verhoudingen van elk item in de X as categorie.</p><br /><br />";
$pgv_lang["stat_help_z"]					= "~OPTIES VOOR STATISTISCHE PLOTS~<br /><br />~Z AS~<br />De volgende opties zijn beschikbaar voor de Z as. Deze opties geven een onderverdeling van de geselecteerde categories langs de X as.<p style=\"padding-left: 25px\"><b>#pgv_lang[stat_300_none]#</b>&nbsp;&nbsp;toont de items in een aparte kolom voor elke X as categorie.<br /><b>#pgv_lang[stat_301_mf]#</b>&nbsp;&nbsp;toont de items in 2 kolommen (man en vrouw) voor elke X as categorie.<br /><b>#pgv_lang[stat_302_cgp]#</b>&nbsp;&nbsp;toont de items in een aantal kolommen, gerelateerd aan de tijdperiodes, ingesteld in de volgende sectie, voor elke X as categorie.</p><br /><br />";
$pgv_lang["stat_help_gwx"]					= "~OPTIES VOOR STATISTISCHE PLOTS~<br /><br />~boundaries for X axis~<br />Select the desired age interval.<br /><br />For example, <b>#pgv_lang[aft_marr]#</b> describes the following set of month ranges:<div style=\"padding-left:30px;\">before the marriage<br />from the marriage to 8 months after<br />from 8 to 12<br />from 12 to 15<br />from 15 to 18<br />from 18 to 24<br />from 24 to 48<br />over 48 months after the marriage</div><br /><br />When you want to show quarters you have to choose: <b>quarters</b>.<br /><br />";
$pgv_lang["stat_help_gax"]					= "~OPTIES VOOR STATISTISCHE PLOTS~<br /><br />~boundaries for X axis~<br />Select the desired age interval.<br /><br />For example, <b>interval 10 years</b> describes the following set of age ranges:<div style=\"padding-left:30px;\">younger than one year<br />one year to 5 years<br />6 to 10<br />11 to 20<br />21 to 30<br />31 to 40<br />41 to 50<br />51 to 60<br />61 to 70<br />71 to 80<br />81 to 90<br />91 to 100<br />older than 100 years</div><br /><br />";
$pgv_lang["stat_help_gbx"]					= "~OPTIES VOOR STATISTISCHE PLOTS~<br /><br />~boundaries for X axis~<br />Select the desired age interval.<br /><br />For example, <b>interval 2 years</b> describes the following set of age ranges:<div style=\"padding-left:30px;\">younger than 16 years<br />16 to 18<br />19 to 20<br />21 to 22<br />23 to 24<br />25 to 26<br />27 to 28<br />29 to 30<br />31 to 32<br />33 to 35<br />36 to 40<br />41 to 50<br />older than 50 years</div><br /><br />";
$pgv_lang["stat_help_gcx"]					= "~OPTIES VOOR STATISTISCHE PLOTS~<br /><br />~boundaries for X axis~<br />Select the desired count interval.<br /><br />For example, <b>interval one child</b> describes the following set of child count ranges:<div style=\"padding-left:30px;\">without children<br />one child<br />two children<br />3, 4, 5, 6, 7, 8, 9, 10 children<br />more than 10 children</div><br /><br />";
$pgv_lang["stat_help_gwz"]					= "~OPTIES VOOR STATISTISCHE PLOTS~<br /><br />~boundaries for Z axis~<br />Select the desired starting year and interval<br /><br />For example, <b>from 1700 interval 50 years</b> describes the following set of date ranges:<div style=\"padding-left:30px;\">before 1700<br />1700 to 1749<br />1750 to 1799<br />1800 to 1849<br />1850 to 1899<br />1900 to 1949<br />1950 to 1999<br />2000 or later</div><br /><br />";
$pgv_lang["chart_type_help"]				= "~OPTIES VOOR STATISTISCHE PLOTS~<br /><br />Select what you want to see on the map chart. You can choose:<p style=\"padding-left: 25px\"><b>#pgv_lang[indi_distribution_chart]#</b>&nbsp;&nbsp;shows the countries in which persons from this database occur.<br /><b>#pgv_lang[surname_distribution_chart]#</b>&nbsp;&nbsp;shows the countries in which the specified surname occurs.</p><br /><br />";
$pgv_lang["google_chart_surname_help"]		= "~OPTIES VOOR STATISTISCHE PLOTS~<br /><br />The number of occurrences of the specified name will be shown on the map. If you leave this field empty, the most common surname will be used.<br /><br />";
$pgv_lang["chart_area_help"]				= "~OPTIES VOOR STATISTISCHE PLOTS~<br /><br />Select the geographical area that you want to see on the map. You can choose:<p style=\"padding-left: 25px\"><b>#pgv_lang[world_chart]#</b>&nbsp;&nbsp;shows all continents.<br /><b>#pgv_lang[europe_chart]#</b>&nbsp;&nbsp;shows Europe.<br /><b>#pgv_lang[s_america_chart]#</b>&nbsp;&nbsp;shows South America.<br /><b>#pgv_lang[asia_chart]#</b>&nbsp;&nbsp;shows Asia.<br /><b>#pgv_lang[middle_east_chart]#</b>&nbsp;&nbsp;shows the Middle East.<br /><b>#pgv_lang[africa_chart]#</b>&nbsp;&nbsp;shows Africa.</p><br /><br />";

//-- Find Media Help
$pgv_lang["manage_media_help"]				= "~#pgv_lang[manage_media]#~<br /><br />Dit is de tweede stap in het beheren van multimediabestanden, als u onder de standaard multimediamap niveaus van mappen heeft gedefinieerd<br /><br />Als beheerder kunt u een mapstructuur maken om multimediabestanden in onder te brengen en georganiseerd te houden. Als u vanaf deze pagina mappen aanmaakt, worden eveneens mappen aangemaakt voor de miniweergaves en wordt een index.php bestand in de relevante mappen geplaatst.<br /><br />U kunt bestanden verplaatsen binnen de mappenstructuur met behulp van de koppeling \"Verplaats naar --->\". De miniweergave wordt dan eveneens verplaatst zodat consistentie tussen miniweergave en afbeelding bewaard blijft.<br /><br />Als u tijdens het uploaden geen miniweergave heeft opgegeven, en ook de mogelijkheid om deze aan te maken niet heeft gekozen, dan kunt u de miniweergave hier alsnog maken. Vink eerst het vakje \"Toon miniweergaves\" aan. Alle multimediabestanden waarvan geen miniweergave bestaat, hebben een koppeling \"Genereren miniweergave\". Als u deze aanklikt, wordt de miniweergave alsnog aangemaakt.<br /><br />";
$pgv_lang["simple_filter_help"]				= "~#pgv_lang[filter]#~<br /><br />Eenvoudig zoekfilter op basis van de ingevoerde letters. Jokertekens (* en ?) kunnen niet worden gebruikt.<br /><br />";
$pgv_lang["show_thumb_help"]				= "~#pgv_lang[show_thumbnail]#~<br /><br />Indien deze keuze wordt ingeschakeld, worden miniweergaves bij de bestandsnamen getoond.<br /><br />";
$pgv_lang["new_dir_help"]					= "~#pgv_lang[add_directory]#~<br /><br />Als beheerder kunt u een mappenstructuur aanmaken om uw multimediabestanden ingedeeld en georganiseerd te houden.<br />Als u deze functie gebruikt, worden eveneens mappen aangemaakt voor de miniweergaves en wordt een vereist index.php bestand in de mappen geplaatst.<br /><br />Klik op de koppeling om een nieuwe map te maken en type de mapnaam in het invoervak in.<br /><br />";
$pgv_lang["find_media_help"]				= "~#pgv_lang[find_media]#~<br /><br />Hiermee kunt u door de mappenstructuur zoeken om het multimedia-bestand te vinden waarmee u een koppeling wilt maken.<br /><br />";

//-- Add / Edit Media Help
$pgv_lang["add_media_linkid"]				= "~Link ID~<br /><br />Elk media item zou geassocieerd moeten zijn met een of meer personen, gezin, of bronin uw database.<br /><br />Om zo'n link te maken, kunt het  ID van de persoon, gezin, of bron invoeren, of er naar zoeken, op het moment dat u het media item maakt.  U kunt de link echter ook later maken bij de Wijzigen Opties van de  Beheer MultiMedia pagina. Ook heeft u op de Personen, Gezinnen of Bronnen pagina's de mogelijkheid om met  Media Link Toevoegen dit te doen.<br /><br />";
$pgv_lang["upload_server_file_help"]		= "~#pgv_lang[server_file]#~<br /><br />Het media bestand, dat u gaat uploaden, kan anders heten op onze server, dan op uw lokale computer. Dit is omdat de naam van een lokaal bestand voor u wel duidelijk is, maar voor bezoekers van onze site weinig betekenis heeft.  Denk ook aan de mogelijkheid dat u, en eveneens iemand anders, een bestand probeert te uploaden, die de naam heeft \"Oma.jpg\".<br /><br />In dit veld geeft u de nieuwe naam op van het bestand dat u wilt uploaden.  De naam, die u hier opgeeft, wordt ook gebruikt om het miniweergavebestand te benoemen. Het miniweergavebestand kan apart worden ge-upload, maar ook automatisch worden gegenereerd.  U hoeft de de extensie van de bestandsnaam (jpg, gif, pdf, doc, etc.) in te vullen.<br /><br />Vul dit veld niet in, om de orginele naam, van het bestand dat u wilt uploaden van uw lokale computer, te behouden.<br /><br />";
$pgv_lang["upload_server_folder_help"]		= "~#pgv_lang[server_folder]#~<br /><br />De beheerder heeft het mogelijk gemaakt om  #GLOBALS[MEDIA_DIRECTORY_LEVELS]# map(pen) nivo('s) binnen de standaard <b>#GLOBALS[MEDIA_DIRECTORY]#</b> map op te kunnen geven.  Dit heeft als voordeel dat de media-bestanden enigszins georganiseerd kunnen worden opgeslagen. Tevens wordt dan de mogelijkheid kleiner dat er problemen optreden als u probeert een bestand te uploaden, welke een naam heeft die reeds voorkomt in de database.<br /><br />In dit veld (vakje) kunt u de naam opgeven van de map, waarin in het mediabestand, dat u gaat uploaden, wordt opgeslagen.  Het bijbehorende miniweergave-bestand, of het nu apart door u wordt ge-upload of automatisch wordt gegenereerd, wordt dan in een soortgelijke mappenstructuur opgeslagen, welke begint in <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b> in plaats van <b>#GLOBALS[MEDIA_DIRECTORY]#</b>.  <br />U hoeft niet <b>#GLOBALS[MEDIA_DIRECTORY]#</b> op te geven als deel van de bestemming. Dit wordt al automatisch toegevoegd.<br /><br />Als u niet zeker weet wat hier moet worden ingevuld, neem dan even kontakt op met de Beheerder voor advies.<br /><br />";
$pgv_lang["view_server_folder_help"]		= "~#pgv_lang[server_folder]#~<br /><br />De beheerder heeft, voor het opslaan van de mediabestanden, tot  #GLOBALS[MEDIA_DIRECTORY_LEVELS]# map-nivo's dieper dan de standaardmap <b>#GLOBALS[MEDIA_DIRECTORY]#</b> ingesteld.<br /><br />Dit helpt om de media bestanden te organiseren en problemen met eventuele gelijknamige bestanden te voorkomen.<br /><br />In dit veld selecteert u de media map, waarvan u de inhoud wilt bekijken.<br />Als u <b>#pgv_lang[all]#</b> selecteert, zullen alle media bestanden worden getoond, ongeacht de map waarin ze zijn opgeslagen.  Hierdoor zou wel een lange lijst met media item kunnen ontstaan.<br /><br />";

//--Repository Help
$pgv_lang["help_repolist.php"]				= "~BEWAARPLAATSEN~<br /><br />Op deze pagina treft u een overzicht van alle bewaarplaatsen aan.<br />De bewaarplaatsen zijn alfabetisch op titel gesorteerd.<br />Als u op een van de bewaarplaatsen klikt, worden de details van de bewaarplaats weergegeven, evenals de bronnen die aan de bewaarplaats zijn gekoppeld.<br /><br />GEBRUIK VAN BEWAARPLAATSEN<br />Zonder bewaarplaatsen kunnen we niet op een verantwoorde manier een genealogisch bestand opbouwen. Alle informatie dient herleidbaar, reproduceerbaar en controleerbaar te zijn. Alle bronnen die in de genealogie zijn opgenomen, moeten zijn gekoppeld aan een bewaarplaats. Op die manier kan de bron altijd fysiek worden teruggevonden.<br />Omdat in een bewaarplaats meerdere bronnen kunnen zijn opgeslagen, worden bewaarplaatsen gekoppeld aan meerdere bronnen.<br /><br />";
$pgv_lang["help_repo.php"]					= "~DETAILS BEWAARPLAATS~<br /><br />Bewaarplaatsen zijn, samen met bronnen, belangrijk in genealogisch onderzoek omdat ze informatie in een stamboom controleerbaar en reproduceerbaar maken. Op die manier kunnen andere onderzoekers op een verantwoorde manier van de gegevens gebruik maken.<br /><br />Op deze pagina ziet u de detailgegevens van de bewaarplaats zoals adres, e-mailadres, internet pagina en telefoonnummer.<br />Onder de details van de bewaarplaats wordt een lijst met bronnen getoond die verwijzen naar deze bewaarplaats.<br /><br />Als de beheerder van de site dit mogelijk heeft gemaakt, ziet u aan de rechterzijde van het scherm nog twee koppelingen: <br />\"Toon GEDCOM-gegevens\", waarmee u in een apart venster de gegevens van de bewaarplaats in GEDCOM-formaat kunt zien, en <br />\"Toevoegen aan knipselbak\", waarmee u de GEDCOM-gegevens van de bron in uw knipselbak kunt opslaan. Later kunt u ze downloaden naar uw eigen machine en ze daar importeren in uw genealogiepakket.<br /><br />#pgv_lang[more_help]#";
$pgv_lang["delete_repo_help"]				= "~VERWIJDER BEWAARPLAATS~<br /><br />Door deze optie aan te klikken, markeert u een bewaarplaats voor verwijdering uit de genealogie.<br /><br />Wat betekent dat nu?<br />Laten we aannemen dat u een goede reden heeft om deze bewaarplaats uit de genealogie te verwijderen. U klikt op de koppeling. Daarna verschijnt er een venster, waarin u wordt gevraagd of u er zeker van bent, of dat u de bewerking wilt annuleren.<br /><br />Als u doorgaat, verschijnt na enige tijd opnieuw een scherm, waarin wordt gemeld dat de bewaarplaats uit de genealogie is verwijderd.<br />De bewaarplaats zal echter nog steeds zichtbaar en raadpleegbaar zijn. <br /><br />Dit is <b>geen</b> fout. De beheerder heeft een e-mail gekregen, waarin wordt vermeld dat er een wijziging op de genealogie is aangebracht en dat u de bewaarplaats heeft verwijderd. De beheerder kan de wijziging accepteren of ongedaan maken. Pas als de beheerder de wijziging heeft geaccepteerd, is de bewaarplaats definitief verwijderd.<br />Bij twijfel zal de beheerder contact met u opnemen.<br /><br />";
$pgv_lang["show_repo_gedcom_help"]			= "~TOON GEDCOM-GEGEVENS~<br /><br />Door op deze koppeling te klikken, krijgt u de informatie over deze bewaarplaats in GEDCOM-formaat te zien.<br /><br />";
$pgv_lang["add_repository_clip_help"]		= "~BEWAARPLAATS TOEVOEGEN AAN KNIPSELBAK~<br /><br />Door op deze koppeling te klikken, worden de gegevens van deze bewaarplaats toegevoegd aan de knipselbak.<br /><br />";
$pgv_lang["repolist_listbox_help"]			= "~LIJST BEWAARPLAATSEN~<br /><br />In dit vak ziet u een overzicht van bewaarplaatsen die voorkomen in deze genealogie.<br />De titels worden weergegeven in alfabetische volgorde.<br /><br />Als u op een bewaarplaats klikt, worden de detailgegevens getoond, evenals een lijst met bronnen die aan de bewaarplaats zijn gekoppeld.<br /><br />";
$pgv_lang["repos_listbox_help"]				= "~AAN DEZE BEWAARPLAATS GEKOPPELDE BRONNEN~<br /><br />In dit vak ziet u alle bronnen, die aan deze bewaarplaats zijn gekoppeld. Als u op een bron klikt, krijgt u de details ervan te zien.<br /><br />";

// Index-Edit
$pgv_lang["block_move_up_help"]				= "~Wijzig vakvolgorde~<br /><br />Gebruik deze knoppen om de volgorde van de vakken in de lijst aan te passen. De vakken worden weergegeven in de volgorde zoals ze in de lijst staan.<br /><br />klik het vak aan dat u wilt verplaatsen en klik op de op- en neerknoppen om het vak naar boven of naar beneden te verplaatsen.<br /><br />";
$pgv_lang["block_move_right_help"]			= "~Verplaats vakken~<br /><br />Gebruik deze knoppen om een vak van een lijst naar een andere te verplaatsen.<br /><br />Klik op het vak dat u wilt verplaatsen en klik op een pijlknop om het vak in de aangegeven richting te verplaatsen. Gebruik de <b>&raquo;</b> en <b>&laquo;</b> knoppen om het vak van meest links naar meest rechts te verplaatsen en vice versa. Gebruik de <b>></b> en <b><</b> knoppen om het vak tussen de lijst #pgv_lang[available_blocks]# list en de lijsten links en rechts te verplaatsen.<br /><br />De lijst met #pgv_lang[available_blocks]# wijzigt niet, ongeacht wat u met de #pgv_lang[move_right]# en #pgv_lang[move_left]# knoppen doet. Ze blijven beschikbaar omdat ze meerdere malen op dezelfde pagina kunnen verschijnen. Het HTML-vak is hiervan een goed voorbeeld.<br /><br />";
$pgv_lang["block_default_index"]			= "~Standaard vakken op de #pgv_lang[welcome]#~<br /><br />Als u alle vakken uit de #pgv_lang[main_section]# en #pgv_lang[right_section]# verwijdert, of als u klikt op de <b>#pgv_lang[reset_default_blocks]#</b> knop, dan wordt de vakindeling als volgt ingesteld:<br /><br /><center><table border=\"1\"><tr><td class=\"list_value\"><b>#pgv_lang[main_section]#</b></td><td class=\"list_value\"><b>#pgv_lang[right_section]#</b></td></tr><td>#pgv_lang[gedcom_stats_block]#<br />#pgv_lang[gedcom_news_block]#<br />#pgv_lang[gedcom_favorites_block]#<br />#pgv_lang[review_changes_block]#</td><td>#pgv_lang[gedcom_block]#<br />#pgv_lang[random_media_block]#<br />#pgv_lang[todays_events_block]#<br />#pgv_lang[logged_in_users_block]#</td></tr></table></center><br />";
$pgv_lang["block_default_portal"]			= "~Standaard vakken op de #pgv_lang[mygedview]# pagina~<br /><br />Als u alle vakken uit de #pgv_lang[main_section]# en de #pgv_lang[right_section]# verwijdert, of op de knop <b>#pgv_lang[reset_default_blocks]#</b> klikt, worden de vaklijsten als volgt ingesteld:<br /><br /><center><table border=\"1\"><tr><td class=\"list_value\"><b>#pgv_lang[main_section]#</b></td><td class=\"list_value\"><b>#pgv_lang[right_section]#</b></td></tr><td>#pgv_lang[todays_events_block]#<br />#pgv_lang[user_messages_block]#<br />#pgv_lang[user_favorites_block]#<br />&nbsp;</td><td>#pgv_lang[welcome_block]#<br />#pgv_lang[random_media_block]#<br />#pgv_lang[upcoming_events_block]#<br />#pgv_lang[logged_in_users_block]#</td></tr></table></center><br />";

// FAQ page
$pgv_lang["help_faq.php"]					= "~Veel Gestelde Vragen~<br />#pgv_lang[text_faq_help]#<br />";
$pgv_lang["text_faq_help"]					= "De VGV (Veel Gestelde Vragen) pagina kan een overzicht, of lijst, met vragen en antwoorden bevatten over het gebruik van deze genealogie site.<br />Vaak zijn er vragen die regelmatig in, min of meer, dezelfde vorm terugkomen. De VGV pagina kan worden gebruikt om deze vragen, met de antwoorden daarop, te verzamlen en weer te geven.<br /><br />Het gebruik en de inrichting van deze VGV pagina is geheel in handen van de site beheerder. De beheerder bepaalt de inhoud van elk onderwerp en tevens de volgorde, waarin deze worden weergegeven.";

// Help search
$pgv_lang["hs_title_help"]					= "<center>~#pgv_lang[hs_title]#~</center><br />#pgv_lang[hs_intro]#<br /><br />#pgv_lang[hs_keyword_advice]#<br /><br />#pgv_lang[hs_searchhow_advice]#<br /><br />#pgv_lang[hs_searchin_advice]#";
$pgv_lang["hs_intro"]						= "U kunt het hele PhpGedView's Help systeem doorzoeken.  De \"#pgv_lang[hs_title]#\" mogelijkheid geeft u in hoge mate controle over de wijze waarop u kunt zoeken; u kunt gemakkelijk (bijna) alles vinden wat u zoekt.";
$pgv_lang["hs_keyword_advice"]				= "~#pgv_lang[hs_keyword]#~<br />U voert de woorden, of (gedeelte van) een zin in, die u wilt vinden.<br /><br />Het zoeksysteem is Hoofdletter-ongevoelig. Dat betekent dat het niet uitmaakt of u hoofd- of kleine- letters invoert of zoekt.  Als u zoekt naar  <b>Individual</b>, zult u tekst vinden die het volgende kan bevatten: <b>Individual</b>, <b>individual</b>, of <b>INDIVIDUAL</b>.  Ook tekst, die <b>individuals</b>, bevat, zal worden gevonden, enz. Dit komt omdat meer naar de opeenvolging van letters wordt gekeken, dan naar woorden.<br /><br />U kunt het zoeksysteem naar verschillende woorden in een keer laten zoeken.  Voer de woorden, gescheiden door een spatie, als volgt in: <b>persoon&nbsp;gezin&nbsp;kind</b>.  Als meer dan een woord is ingevoerd, wordt de bedoeling van wat u heeft ingetypt verduidelijkt in het veld \"#pgv_lang[hs_searchhow]#\".<br />";
$pgv_lang["hs_searchin_advice"]				= "~#pgv_lang[hs_searchin]#~<br />U bepaalt hier, waarin moet worden gezocht.<br /><br />Beheerders hebben de keus om te zoeken in Help bestanden voor Gebruikers, of die voor de Configuratie, of beide. Gebruikers hebben die keuze niet. Omdat gebruikers geen toegang hebben tot de configuratie mogelijkheden, kunnen ze alleen  zoeken in de Help bestanden voor gebruikers.<br /><br />De Help bestanden bevatten niet alleen de Help teksten, maar ook zekere tekst strings die bijv. worden gebruikt om invoerformulieren en diverse andere pagina's samen te stellen.  Deze optie laat u bepalen of alleen weer te geven Help teksten moeten worden doorzocht, of het complete Help bestand.<br />";
$pgv_lang["hs_searchhow_advice"]			= "~#pgv_lang[hs_searchhow]#~<br />U verduidelijkt hier hoe er moet worden gezocht naar hetgeen u heeft ingevoerd in het veld \"#pgv_lang[hs_keyword]#\" (als u meer dan een woord heeft ingevoerd), door een van de onderstaande mogelijkheden te kiezen:<br /><dl><dt><b>#pgv_lang[hs_searchany]#</b></dt><dd>Als u heeft ingevoerd: <b>persoon&nbsp;gezin&nbsp;kind</b>, zal deze optie de Help tekst  laten zoeken, die een van deze woorden bevat.  De volgorde van de woorden is niet belangrijk.  De betekenis van de zoekopdracht is: \"Vindt Helptekst die het volgende bevat: <b>persoon</b> <u>of</u> <b>gezin</b> <u>of</u> <b>kind</b>\".</dd><dt><b>#pgv_lang[hs_searchall]#</b></dt><dd>Als u heeft ingevoerd: <b>persoon&nbsp;gezin&nbsp;kind</b>, zal deze optie de Help tekst  laten zoeken, die al deze woorden bevat.  De volgorde van de woorden is niet belangrijk  De betekenis van de zoekopdracht is: \"Vindt Helptekst die het volgende bevat: <b>persoon</b> <u>en</u> <b>gezin</b> <u>en</u> <b>kind</b>\".</dd><dt><b>#pgv_lang[hs_searchsentence]#</b></dt><dd>Als u heeft ingevoerd: <b>persoon&nbsp;gezin&nbsp;kind</b>, zal deze optie de Help tekst  laten zoeken, die al deze woorden bevat, in de volgorde waarin deze woorden zijn ingevoerd.  De betekenis van de zoekopdracht is: \"Vindt Helptekst die het volgende bevat: <b>persoon&nbsp;gezin&nbsp;kind</b> in exact die volgorde en geen woorden of letters daartussen\".  (Hoogstwaarschijnlijk zult u dit voorbeeld niet in de Helpteksten vinden).<br /><br />Er zijn een paar beperkingen aan deze wijze van zoeken.  Sommige speciale karakters (zoals bijv. <b>&quot; &lt; &gt;</b> etc.) staan wel in de weergegeven helptekst, maar in de database staan ze niet als zodanig vermeld, maar in symbolische vorm. Als u dus tekst invoert die bepaalde speciale tekens bevat, zal de tekst niet worden gevonden. Het is beter deze tekens te vermijden in de zoektekst.  Ook kan Helptekst Spaties bevatten, die in de database zijn opgeslagen als <b>&amp;nbsp;</b> uitdrukkingen waarin zo'n spatie is gebruikt, zult u dan ook niet vinden. Als u denkt dat een bepaalde uitdrukking er wel in zou moeten staan, probeer dan de middelste optie: \"Alle woorden\".</dd></dl>";

// Directory cleanup tool
$pgv_lang["help_dir_editor.php"]			= "~#pgv_lang[index_dir_cleanup]#~<br /><br />Dit hulpprogramma kan site beheerders help om bestanden op te ruimen in de Index map (directory).<br /><br />Na verloop van tijd kunnen er steeds meer bestanden, zoals log bestanden, oude GEDCOM bestanden en oude backup bestanden, bij komen in de Index map.<br /><br />Omdat  veel van deze bestanden worden gemaakt door het programma, kunnen ze eigendom zijn van de web server gebruiker.  En zal ze dan eigendom zijn van de web server gebruiker, zou het kunnen zijn dat u ze niet kunt wissen.<br />Dit hulpprogramma kan de bestande wel wissen, ondanks dat ze eigendom kunnen zijn van de web server gebruikers account.<br /><br />~Het opruimen:~ <br />#pgv_lang[index_dir_cleanup_inst]#";
?>
