<?php
/**
 * Finnish Language file for PhpGedView.
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2010  PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @subpackage Languages
 * @author Jaakko Sarell, Matti Valve, Marko Kohtala
 * @version $Id: help_text.fi.php 6989 2010-11-09 03:26:25Z canajun2eh $
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

$pgv_lang["utf8_ansi_help"]		= "~MUUNNA UTF-8 MERKISTÖSTÄ ANSI MERKISTÖÖN~<b /><br />Jotta sivut näkyisivät oikein internetissä PhpGedView käyttää UTF-8 merkistöä. Jotkut ohjelmat, kuten Family Tree Maker, eivät tue UTF-8-koodattujen GEDCOM-tiedostojen tuontia. Rastittamalla tämän valintaruudun muunnetaan tiedosto <b>UTF-8</b>-muodosta <b>ANSI</b>-muotoon (ISO-8859-1).</b><br /> Riippuu ohjelmasta, missä muodossa koneellesi lataama GEDCOM-tiedoston on oltava.</b>Tarkista ohjelman tiedoista, missä muodossa tiedoston on oltava.<br /><br />Huomaa, että jotta tietyt erikoismerkit pysyisivät muuttumattomina, tiedosto on ladattava UTF-8-muodossa ja muunnettava ohjelmasi käyttämään muotoon jollakin muulla tavalla. Tiedustele asiaa ohjelman valmistajalta tai tekijältä.<br /><br />";
$pgv_lang["remove_tags_help"]	= "~POISTA RÄÄTÄLÖIDYT PHP-MERKITSIMET~<br /><br />Rastittamalla tämä vaihtoehto poistetaan kaikki räätälöidyt PHP-merkitsimet, jotka on lisätty tietueisiin.<br /><br />PhpGedView-ohjelman käyttämiä merkitsimiä ovat <b>_PGVU</b>, joka osoittaa, kuka käyttäjä teki muutoksia on-line-tilassa ja <b>_THUM</b>, joka kertoo PhpGedView:lle, että kuvaa on käytettävä pienoiskuvana.<br /><br />Räätälöidyt merkitsimet saattavat aiheuttaa virheitä ladattuun GEDCOM-tiedostoon kun se viedään toiseen sukututkimusohjelmaan.<br /><br /> ";
$pgv_lang["download_zipped_help"]	= "~LATAA GEDCOM-TIEDOSTO ZIP-TIEDOSTONA~<br /><br />Kun rastitat tämän vaihtoehdon, GEDCOM-tiedoston kopio tiivistetään ZIP-muotoon ennen sen latautumista. Tämä vähentää huomattavasti tiedoston kokoa, mutta tarvitset soveltuvan purkuohjelman (esim. WinZip) purkaaksesi sen käyttökelpoiseen muotoon.<br /><br />Tämä on käyttökelpoinen vaihtoehto ladataksesi suuren GEDCOM-tiedoston. Suuren tiivistämättömän tiedoston sallittu latausaika saattaa ylittyä, mikä johtaa tiedoston epätäydelliseen latautumiseen. ZIP-vaihtoehto vähentää latausaikaa 75 %:lla.<br /><br />";
$pgv_lang["remember_me_help"]	= "~MUISTA MINUT~<br /><br />Rastittamalla tämän ruudun sisäkirjautumisen yhteydessä sinun ei uudestaan tarvitse kirjautua järjestelmään vieraillessasi tällä sivulla seuraavan kerran. Tietokoneellesi asetetaan keksi, jonka selain lähettää palvelimelle kun avaat tämän sivuston seuraavan kerran.<br /><br />Kun palaat tälle sivulle voit katsoa yksityistietoja ja käyttäjäsivuja, mutta jotta voisit muokata tai ylläpitää niitä, sinun on kirjauduttava normaalisti.<br /><br /><b>Älä rastita tätä ruutua kun käyt sivustolla yleiseltä tietokoneelta, koska silloin kuka tahansa voi mennä sivustolle tunnuksillasi</b>.";
$pgv_lang["edit_NCHI_help"]		= "~#factarray[NCHI]#~<br /><br />Lisää tämän henkilön tai perheen lasten lukumäärä. Tämä on valinnainen kenttä.<br /><br />";
$pgv_lang["edit_TIME_help"]		= "~#factarray[TIME]#~<br /><br />Lisää tämän tapahtuman aikaetunollineen. Keskiyö on 00:00. Esimerkkejä: 04:50 13:00 20:30.<br /><br />";
$pgv_lang["edit_NOTE_help"]		= "~#factarray[NOTE]#~<br /><br />Huomautukset ovat vapaata tekstiä ja ilmestyvät sivun tieto-osioon.<br /><br />";
$pgv_lang["edit_CEME_help"]	= "~#factarray[CEME]#~<br /><br />Lisää hautausmaan tai muun viimeisen leposijan nimi, jossa tämä henkilö lepää.<br /><br />";
$pgv_lang["edit_ASSO_help"]		= "~#factarray[ASSO]#~<br /><br />Lisää läheisen GEDCOM ID-tunnus.<br /><br />";
$pgv_lang["edit_RELA_help"]		= "~#factarray[RELA]#~<br /><br />Valitse luettelosta läheisen suhteen laji. Valitsemalla Kummisetä merkitsee, että läheinen on kyseisen henkilön kummisetä.<br /><br />";
$pgv_lang["help_hourglass.php"]	= "~#pgv_lang[hourglass_chart]#~<br /><br />Tiimalasikaavio näyttää lähtöhenkilön esi- ja jälkipolvet samassa kaaviossa. Se on tavallaan sekoitus esipolvi- ja jälkipolvikaaviosta.<br /><br />Lähtöhenkilö sijaitsee keskellä sivua siten, että jälkipolvet ovat vasemmalla ja esipolvet oikealla. Tässä näkymässä kukin sukupolvi on samalla tasolla sivulla alkaen vanhimmasta sukupolvesta ja päättyen nuorimpaan.<br /><br />";
$pgv_lang["help_familybook.php"]	= "~#pgv_lang[familybook_chart]#~<br /><br />Tämä kaavio on hyvin samantapainen kuin tiimalasikaavio. Se näyttää valitun juurihenkilön esivanhemmat ja jälkeläiset samassa kaaviossa. Se näyttää juurihenkilön jälkeläiset  samanlaisessa tiimalasimuodossa.<br /><br />Juurihenkilö sijaitsee sivun keskellä jälkeläiset vasemmalla ja esivanhemmat oikealla. Tässä näkymässä jokainen sukupolvi on tasattu sivun poikki alkaen varhaisimmasta sukupolvesta ja päättyen viimeismpään.<br /><br />Jokaisesta juurihenkilön jälkeläisestä tulee uuden tiimalasikaavion juurihenkilö samalle sivulle tulostettuna. Tämä toistuu kunnes haluttu määrä jälkipolvia on tulostettu.";
$pgv_lang["fambook_descent_help"]	= "~#pgv_lang[descent_steps]#~<br /><br />Tämä lukuarvo määrittää juurihenkilön jälkipolvien lukumäärän, joka tulostetaan tiimalasimuodossa.<br /><br />";
$pgv_lang["show_spouse_help"]	= "~#pgv_lang[show_spouses]#~<br /><br />Tässä kaaviossa ei oletusarvoisesti näytetä jälkipolvien puolisoita, koska se vaikeuttaa kaavion luettavuutta. Kytkemällä tämän vaihtoehdon päälle, näytetään puolisot kaaviossa.<br /><br />";
$pgv_lang["reorder_families_help"]	= "~#pgv_lang[reorder_families]#~<br /><br />Lähisukulaisten välilehdellä näytetään perheet siinä järjestyksessä missä ne ovat henkilön GEDCOM-tietueessa. Niitä ei ole järjestetty avioliitonsolmimispäivän mukaan koska kyseiset päivät eivät ole aina tiedossa mutta järjestys on. <br /><br />Tämä vaihtoehto mahdollistaa perheiden järjestyksen muuttamisen lähisukulaiset-välilehdellä. Painikkeella saadaan perheet avioliitonsolmimisjärjestykseen.<br /><br />";
$pgv_lang["autoContinue_help"]	= "~#pgv_lang[autoContinue]#~<br /><br />Kun PhpGedView havaitsee, että GEDCOM tuonti vaatii enemmän aikaa kuin mitä aikarajoitus sallii, se näyttää <b>#pgv_lang[del_proceed]#</b>-painikkeen jota on painettava, jotta tuonti jatkuisi.<br /><br />Kun tämä optio on asetettu tilaan <b>#pgv_lang[yes]#</b>, PhpGedView painaa automaattisesti <b>#pgv_lang[del_proceed]#</b>-painiketta puolestasi. Tällä vältät painikkeen jatkuvaa painelua pitkäaikaisen tuonnin aikana.<br /><br />";
$pgv_lang["firstname_i_help"]		= "~#pgv_lang[firstname_alpha_index]#~<br /><br />Valitsemallasi sukunimellä esiintyy enemmän kuin #GLOBALS[SUBLIST_TRIGGER_I]# henkilöä.<br /><br />Luettelo on jaettu henkilön etunimen mukaan useampaan osaan helpottamaan hakemasi henkilön löytymistä. Tämä aakkosellinen alaindeksi toimii samoin kuin sukunimien mukainen aakkosellinen indeksi.<br /><ul><li>Klikkaa kirjainta nähdäksesi kaikki sillä alkavien henkilöiden etunimet.</li><li>Valitse <b>#pgv_lang[NN]#</b> nähdäksesi kaikki ne henkilöt, joiden etunimi on tuntematon.</li><li>Valitsemalla <b>#pgv_lang[all]#</b> saat luettelon kaikista henkilöistä, joilla on kyseinen sukunimi.</li></ul>Koska nimiä on paljon, saattaa kestää kauan ennen kuin luettelo ilmestyy näkyviin.<br /><br />";
$pgv_lang["firstname_f_help"]		= "~#pgv_lang[firstname_alpha_index]#~<br /><br />Valitsemallasi sukunimellä esiintyy enemmän kuin #GLOBALS[SUBLIST_TRIGGER_I]# henkilöä.<br /><br />Luettelo on jaettu henkilön etunimen mukaan useampaan osaan helpottamaan hakemasi henkilön löytymistä. Tämä aakkosellinen alaindeksi toimii samoin kuin sukunimien mukainen aakkosellinen indeksi.<br /><ul><li>Klikkaa kirjainta nähdäksesi kaikki sillä alkavien henkilöiden etunimet.</li><li>Valitse <b>#pgv_lang[NN]#</b> nähdäksesi kaikki ne henkilöt, joiden etunimi on tuntematon.</li><li>Valitsemalla <b>#pgv_lang[all]#</b> saat luettelon kaikista henkilöistä, joilla on kyseinen sukunimi.</li></ul>Koska nimiä on paljon, saattaa kestää kauan ennen kuin luettelo ilmestyy näkyviin.<br /><br />";
$pgv_lang["edit_TYPE_help"]		= "~#factarray[TYPE]#~<br /><br />#factarray[TYPE]#-kenttä sallii erikoistapahtuman määrittelyn. Se on tekstikenttä, johon voit kirjoittaa mitä tahansa kirjattavaa.<br /><br />";
$pgv_lang["edit_TEMP_help"]		= "~#factarray[TEMP]#~<br /><br />Myöhempien Aikojen Pyhien Jeesuksen Kristuksen Kirkon jäseniä koskeva. Tässä kentässä on temppeli, jossa aikuiskaste suoritettiin<br /><br />";
$pgv_lang["edit_STAT_help"]		= "~#factarray[STAT]#~<br /><br />Tämä on vaihtoehtoinen tilakenttä jota käytetään yleensä MAP Uskonnollisissa toimituksissa kun ne ajetaan TempleReady-ohjelmalla.<br /><br />";
$pgv_lang["edit__PRIM_help"]	= "~#factarray[_PRIM]#~<br /><br />Käytä tätä kenttää osoittamaan, että tämä mediaobjekti on kyseisen henkilön ensisijainen tai korostettu objekti. Korostettua kuvaa käytetään henkilösivun kaavioiden yhteydessä.<br /><br />";
$pgv_lang["edit__THUM_help"]	= "~#factarray[_THUM]#~<br /><br />Tämä kenttä antaa sinun korvata tavallisen pienoiskuvan. Sinun ei yleensä tarvitse käyttää tätä vaihtoehtoa, sillä PhpGedView luo oikean kokoisen pienoiskuvan aina kun lähetät kuvan.<br /><br /> Voit käyttää tätä valintaa varmistaaksesi, että kuva näyttää riittävän tarkalta silloin kun pienoiskuvasta puuttuu yksityiskohtia. Koska pienoiskuvan klikkaaminen tuo näkyviin täysikokoisen kuvan, tästä valinnasta tuskin on iloa. <br /><br /> Kun tämä valinta on <b>Kyllä</b>, PhpGedView käyttää kyseistä kuvaa sen koosta rippumatta, aina kun pienoiskuvaa pyydetään. Kuvan kokoa ei tarkisteta; mikäli se ei ole pienoiskuvakokoa, näyttö voi aiheuttaa yllätyksiä.<br /><br />";
$pgv_lang["edit_TITL_help"]		= "~#factarray[TITL]#~<br /><br />Anna otsikko muokattavalle kohteellesi. Jos kyseessä on multimediakohde, anna kuvaava otsikko, jolla käyttäjä voi sen tunnistaa.<br /><br />";
$pgv_lang["edit_FILE_help"]		= "~#factarray[FILE]#~<br /><br />Tämä on multimediatietueen tärkein kenttä. Se kertoo, mitä tiedostoa on käytettävä. Vähimmillään on annettava tiedostonimi. Lisätietoa tiedoston sijainnista on hyvä olla riippuen asetuksista.<br /><br />Voit käyttää linkkiä \"#pgv_lang[find_media]#\" löytääksesi mediaobjekteja joita jo on ladattu palvelimelle.<br />#pgv_lang[readme_help]#<br /><br />";
$pgv_lang["edit_FORM_help"]	= "~#factarray[FORM]#~<br /><br />Tämä on valinnainen kenttä johon voi syöttää multimediaobjektin formaatin. Jotkut sukututkimusohjelmat saattavat tarkistaa kentän määritelläkseen kuinka mediaobjektia on käsiteltävä. Koska media ei aina ole siirrettävissä tietokonejärjestelmästä toiseen kovin hyvin, kentällä ei ole suurta merkitystä.<br /><br />";
$pgv_lang["generate_thumb_help"]	= "~#pgv_lang[auto_thumbnail]#~<br /><br />Järjestelmäsi voi automaattisesti luoda pienoiskuvat tietyntyppisistä kuvatiedostoista.  Tuettuina saattavat olla BMP, JPG-, GIF- ja PNG-tiedostot. Järjestelmäsi tukee rastitettuja tiedostomuotoja.<br /><br />Klikkaamalla tätä valintaruutua osoitat järjestelmälle, että olet lataamassa tämän tyyppisiä tiedostoja ja että haluat järjestelmän yrittävän automaattisesti luoda niistä pienoiskuvat. Älä rastita ruutua, jos haluat itse toimittaa pienoiskuvat.<br /><br />";
$pgv_lang["edit_add_NOTE_help"]	= "~#pgv_lang[add_note]#~<br /><br />Voit lisätä tähän osioon uuden muokattavaa tietoa koskevan huomautuksen. Huomautukset ovat tekstitietoa, joka näkyvät sivun yksityiskohtaisten tietojen osiossa.";
$pgv_lang["edit_add_SOUR_help"]	= "~#pgv_lang[add_source]#~<br /><br /> Tähän osioon voit lisätä uuden muokattavaa tietoa koskevan lähdeviittauksen. Lähdekenttään annetaan kyseisen lähteen ID-tunniste. Klikkaa linkkiä #pgv_lang[create_source]# mikäli sinun on lisättävä uusi lähde. Viittauskenttään lisäät sivunumeron tai muun tiedon, joka auttaa muita löytämään lähteessä olevan tiedon. Tekstikenttään kirjoitetaan tekstiosa lähteestä.<br /><br />";
$pgv_lang["edit_add_ASSO_help"]	= "~#pgv_lang[add_asso]#~<br /><br />#pgv_lang[add_asso]# yhdistää sivuston tiedon ja siihen liittyvän läheisen henkilön keskenään. Tämä on yksi tapa tallentaa tieto, että joku henkilö on esimerkiksi ollut jonkun kummisetä.<br /><br />";
$pgv_lang["edit_QUAY_help"]		= "~#factarray[QUAY]#~<br /><br />Tässä kentässä voidaan todeta jonkun tästä lähteestä löydetyn tiedon laatu tai luotettavuus. Useat sukututkimusohjelmat käyttävät numeroita tässä kentässä. <b>3</b> saattaa merkitä, että kyseessä on ensikäden tieto. <b>2</b> saattaa merkitä, että kyseessä on toisen käden tieto ja <b>1</b>, että kyseessä on kyseenalainen tieto ja <b>0</b>, että lähde on epäluotettava.<br /><br />";
$pgv_lang["edit_PAGE_help"]		= "~#factarray[PAGE]#~<br /><br />Viittauskenttään lisäät sivunumeron tai muun tiedon, joka auttaa muita löytämään lähteessä olevan tiedon.<br /><br />";
$pgv_lang["edit_TEXT_help"]		= "~#factarray[TEXT]#~<br /><br />Tähän kenttään kirjoitetaan lähteen viittausteksti. Esimerkkinä voi olla lainaus tekstistä tai kuvaus viitteestä.<br /><br />";
$pgv_lang["edit_SOUR_help"]	= "~#factarray[SOUR]#~<br /><br />Tässä kentässä voit vaihtaa lähdetietuetta, johon tämä lähdeviittaus on yhdistetty. Tähän tulee lähteen ID-tunnus. Kentän viereen tulee nykyisen lähteen ID-tunnuksen otsikko. Käytä linkkiä \"#pgv_lang[find_id]#\" hakeaksesi lähteen ID-tunnuksen. Poistaaksesi koko viittauksen, älä anna ID-tunnusta.<br /><br />";
$pgv_lang["edit_edit_raw_help"]	= "~#pgv_lang[edit_raw]#~<br /><br />Tällä sivulla voit muokata GEDCOM-raakadataa. Tätä sivua on käytettävä varoen ja se edellyttää, että ymmärrät GEDCOM 5.5 standarttia.<br /><br />PhpGedView sallii monta tapaa lisätä ja muokata tietoa, mutta saattaa esiintyä tilanteita jolloin on tarvetta käsitellä raakaa GEDCOM-rakennetta. Mikäli mahdollista tulisi aina käyttää olemassa olevia lomakkeita tiedon lisäämiseksi, mutta jos se ei käy, voi tätä lomaketta käyttää. Kun tämä lomake lähetetään, tarkistetaan GEDCOM-muodon oikeellisuus ja CHAN-tietue päivitetään.<br /><br />";
$pgv_lang["add_from_clipboard_help"]	= "~#pgv_lang[add_from_clipboard]#~<br />PhpGedView sallii tietojen kopioinnin leikepöydälle. Voit kopioida jopa 5 tietoa leikepöydälle. Sitten voit alasvetovalikosta \"lisää uusi tieto\" valita jonkun tiedon leikepöydältä henkilön tietueeseen. Tämä helpottaa samanlaisen tiedon lisäämistä usealle henkilölle.<br /><br />";
$pgv_lang["edit_PLAC_help"]		= "~#factarray[PLAC]#~<br /><br />Paikat tulisi lisätä sukututkimuksen standardien mukaisesti. Sukututkimuksessa paikka määritellään alkaen kaikkein tarkimmasta määrittelystä ja siirtymällä sitten yhä yleisemmille tasoille. Eri tasot erotetaan toisistaan pilkulla. Sinun tulisi lisätä paikkatieto sellaisella tasolla, joka edustaa valtiovaltaa tai seurakuntaa, jossa ylläpidetään oleellista kyseistä paikkaa koskevaa tietoa.<br /><br />Esimerkiksi Salt Lake City lisätään muodossa \"Salt Lake City, Salt Lake, Utah, USA\". Tarkastellaanpa kutakin osaa erikseen. Ensimmäinen osa, \"Salt Lake City\", on kaupunki, jossa tapahtuma sattui. Joissakin maissa kaupunkien sisällä saattaa olla alueita, jotka on hyvä huomata. Nämä tulevat ennen kaupunkia. Seuraava osa, \"Salt Lake\" on piirikunta. \"Utah\" on osavaltio ja \"USA\" on valtio. On tärkeätä huomata kukin paikka, koska sukututkimustietoa pidetään kunkin tason/paikan virastoissa.<br /><br />Mikäli paikan taso on tuntematon, pilkkujen väliin jätetään välilyönti. Esimerkiksi jos ei tiedetä Salt Lake Cityn piirikuntaa, tieto syötettäisiin muodossa \"Salt Lake City, , Utah, USA\".<br /><br />Voit käyttää linkkiä \"#pgv_lang[find_place]#\" löytääksesi tällä sivustolla jo käytössä olevia paikkoja.<br /><br />";
$pgv_lang["edit_add_parent_help"]	= "~LISÄÄ UUSI ÄITI TAI ISÄ~<br /><br />Tällä sivulla voit lisätä henkilölle uuden äidin tai isän. Täytä uuden henkilön nimi, syntymäaika ja kuolinaika mikäli ne ovat tiedossa. Mikäli joku tieto on tuntematon, jätä se tyhjäksi.<br /><br />Lisätäksesi muita tietoja, tallenna ensin muutokset, jotka lisäävät uuden henkilön. Klikkaa sen jälkeen henkilön nimeä päivitetyllä perhesivulla tai lähisukulaisvälilehdellä päästäksesi hänen henkilösivulleen. Henkilösivulla voi sitten lisätä muita tietoja.<br /><br />";
$pgv_lang["edit_add_spouse_help"]	= "~LISÄÄ UUSI AVIOMIES TAI -VAIMO~<br /><br />Tällä sivulla voit lisätä henkilölle uuden av(i)omiehen tai -vaimon. Täytä uuden henkilön nimi, syntymäaika ja kuolinaika mikäli ne ovat tiedossa. Mikäli joku tieto on tuntematon, jätä se tyhjäksi.<br /><br />Lisätäksesi muita tietoja, tallenna ensin muutokset, jotka lisäävät uuden henkilön. Klikkaa sen jälkeen henkilön nimeä päivitetyllä perhesivulla tai lähisukulaisvälilehdellä päästäksesi hänen henkilösivulleen. Henkilösivulla voi sitten lisätä muita tietoja.<br /><br />";
$pgv_lang["edit_death_help"] 		= "~#pgv_lang[death]#~<br /><br />Tässä voit ilmoittaa kuolintiedot. Lisää ensin henkilön kuolinpäivä sukututkimuksen mukaisessa standardimuodossa (1 JAN 2004). Klikkaa kalenteri-ikonia saadaksesi päivän valintaa koskevia ohjeita. Lisää sen jälkeen kuolinpaikka. Voit käyttää linkkiä \"Hae paikka\" yhdistääksesi paikkaan, jonka joku muu on jo tallentanut.<br /><br />";
$pgv_lang["edit_birth_help"] 		= "~#pgv_lang[birth]#~<br /><br />Tässä voit ilmoittaa syntymätiedot. Lisää ensin henkilön syntymäpäivä sukututkimuksen mukaisessa standardimuodossa (1 JAN 2004). Klikkaa kalenteri-ikonia saadaksesi päivän valintaa koskevia ohjeita. Lisää sen jälkeen syntymäpaikka. Voit käyttää linkkiä \"Hae paikka\" yhdistääksesi paikkaan, jonka joku muu on jo tallentanut.<br /><br />";
$pgv_lang["edit_sex_help"]		= "~#pgv_lang[sex]#~<br /><br />Valitse oikea sukupuoli alasvetovalikosta. Vaihtoehto \"Tuntematon\" osoittaa, että sukupuolta ei tiedetä.<br /><br />";
$pgv_lang["edit_name_help"]		= "~#pgv_lang[name]#~<br /><br />Tämä on tärkein kenttä henkilöä koskevassa tietueessa. <br /><br />Tämä kenttä täytetään automaattisesti, kun muut kentät täytetään, mutta se on olemassa jotta voit muokata tietoja omien toiveidesi mukaiseksi. <br /><br />Nimi tulee lisätä kenttään GEDCOM 5.5.1 standardin mukaisesti siten, että sukunimen kummallakin puolella on kauttaviiva \"/\". Esimerkiksi \"John Robert Finlay Jr.\" lisätään seuraavasti: \"John Robert /Finlay/ Jr.\".<br /><br />";
$pgv_lang["edit_suffix_help"]	= "~#pgv_lang[suffix]#~<br /><br />Tähän kenttään lisätään henkilön nimen liite. Esimerkkejä ovat \"Vanh.\", \"Nuor.\", \"III\". Kenttä on valinnainen.<br /><br />";
$pgv_lang["edit_surname_help"]	= "~#pgv_lang[surname]#~<br /><br />Tähän kenttään lisätään henkilön sukunimi. Esimerkiksi \"John Robert Finlay\" nimestä sukunimi on \"Finlay\" ja lisätään tähän.<br /><br />Henkilöille, joilla on useampi sukunimi, kuten on yleistä Espanjassa ja Portugalissa, lisätään sukunimet pilkulla erotettuina. Tämä osoittaa, että henkilö luetteloidaan kaikkien sukunimien alle. Esimerkiksi sukunimi \"Cortes,Vega\" luetteloidaan sekä kirjaimen <b>C</b> ja <b>V</b> alle, kun taas sukunimi \"Cortes Vega\" luetellaan vain kirjaimen <b>C</b> alle.<br /><br />";
$pgv_lang["edit_NICK_help"]		= "~#factarray[NICK]#~<br /><br />Tähän kenttään lisäät henkilön lempinimet. <br />Tämä on valinnainen kenttä.<br /><br />Tavat lisätä lempinimi:<ul><li>Valitse <b>muokkaa nimi</b> lisää lempinimi ja tallenna</li><li>Valitse <b>lisää uusi nimi</b> lisää sitten lempinimi JA nimi ja tallenna</li><li>Valitse <b>editoi GEDCOM-tietuetta</b> lisätäksesi [2&nbsp;NICK] tietueen alisteisena pää- [1&nbsp;NAME] tietueelle.</li></ul>";
$pgv_lang["edit_given_name_help"]	= "~#pgv_lang[given_name]#~<br /><br />Tähän kenttään lisätään henkilön etunimet. Esimerkiksi \"John Robert Finlay\" nimestä etunimet ovat \"John Robert\" ja lisätään tähän.<br /><br />";
$pgv_lang["edit_NPFX_help"]			= "~#factarray[NAME]# #factarray[NPFX]#~<br /><br />Tähän voit antaa nimen etuliitteen kuten \"Tri\", \"Maisteri\". Kenttä on valinnainen.<br /><br />";
$pgv_lang["edit_add_child_help"]	= "~#pgv_lang[add_child]#~<br /><br /><br />Tällä sivulla voit lisätä lapsen valittuun perheeseen. Lisää lapsen nimi sekä syntymä- ja kuolinaika mikäli se on tiedossa. Mikäli joku tieto on tuntematon, jätä se tyhjäksi.<br /><br />Lisätäksesi muita tietoja kuin syntymä- ja kuolinaika, tallenna ensin muutokset, jotka lisäävät uuden lapsen. Klikkaa sen jälkeen lapsen nimeä päivitetyllä perhesivulla tai lähisukulaisvälilehdellä päästäksesi lapsen henkilösivulle. Henkilösivulla voi sitten lisätä muita tietoja.<br /><br />";
$pgv_lang["review_changes_help"]	= "~VIREILLÄ OLEVAT MUUTOKSET~<br /><br />Tällä alueella luetellaan kaikki tietueet joihin on tehty on-line muutokset, ja jotka täytyy tarkistaa ja hyväksyä tietokantaan.<br /><br />";
$pgv_lang["quick_update_name_help"] = "~PÄIVITÄ NIMI~<br /><br />Käytä kenttiä \"Päivitä nimi\" muuttaaksesi muokattavan henkilön nimeä. Kenttään \"Etunimet\" lisätään henkilön etunimet. Kenttään \"Sukunimi\" lisätään sukunimi. Mikäli haluat lisätä nimen \"John Robert Finlay\", lisätään etunimikenttään \"John Robert\" ja sukunimikenttään \"Finlay\".<br /><br />Näiden kenttien täyttäminen muuttaa nimet, ei lisää niitä.<br /><br /><i>Huomaa: älä käytä näitä nimenmuutoksia avioliiton solmimisen yhteydessä. Käytä sen sijaan alla olevaa vaihtoehtoa, jossa lisätään uusi aviomies.</i><br /><br />";
$pgv_lang["quick_update_fact_help"] = "~PÄIVITÄ TIETO~<br /><br />Käytä kenttää \"Päivitä tieto\" lisätäksesi muokattavaa henkilöä koskevaa uutta tai muuttaaksesi olemassa olevaa tietoa. Valitse ensin tietolaji alasvetovalikosta. Lisää sen jälkeen tietoa koskeva tapahtuma-aika sukututkimuksen mukaisessa standardimuodossa (1 JAN 2004). Klikkaa kalenteri-ikonia saadaksesi päivän valintaa koskevia ohjeita. Lisää sitten tietoa koskeva paikka. Voit käyttää linkkiä \"Hae paikka\" valitaksesi paikan, jonka joku muu on jo tallentanut.<br /><br />Mikäli lisäät tietoa tapauksesta, joka jo on olemassa, uusi tieto korvaa vanhan. Mikäli tietoa ei ennestään ollut, syntyy uusi tieto.<br /><br />";
$pgv_lang["quick_update_address_help"] 	= "~PÄIVITÄ OSOITE~<br /><br />Käytä kenttää \"Päivitä osoite\" päivittääksesi osoitteesi, puhelinnumerosi tai sähköpostiosoitteesi.<br /><br />Tämä korvaa mahdollisen vanhan tiedon.<br /><br />";
$pgv_lang["quick_update_spouse_help"] 	= "~LISÄÄ UUSI PUOLISO~<br /><br />Näillä kentillä voit lisätä muokattavalle henkilölle uuden puolison. Täytä uuden puolison nimi, syntymäaika ja avioitumisaika. Lisää päivä sukututkimuksen mukaisessa standardimuodossa (1 JAN 2004). Klikkaa kalenteri-ikonia saadaksesi päivän valintaa koskevia ohjeita. Voit käyttää linkkiä \"Hae paikka\" valitaksesi paikan, jonka joku muu on jo tallentanut.<br /><br />Näillä kentillä voi lisät vain <i>uuden</i> puolison. Ne eivät päivitä olemassa olevaa tietoa. Muokataksesi jo olemassa olevan henkilön tietoja, sulje tämä ikkuna ja klikkaa hänen nimeään lähisukulaiset välilehdellä. Klikkaa sitten \"Muokkaa henkilöä\" muokataksesi henkilön tietoja.<br /><br />";
$pgv_lang["quick_update_marriage_help"] 	= "~PÄIVITÄ AVIOLIITTO~<br /><br />Voit käyttää näitä kenttiä yhdessä niiden kenttien kanssa, joilla lisätään uusi puoliso kun haluat tallentaa uuden avioliiton. Muussa tapauksessa näiden kenttien täyttäminen muuttaa henkilön avioliittotietoja. Lisää päivä sukututkimuksen mukaisessa standardimuodossa (1 JAN 2004). Klikkaa kalenteri-ikonia saadaksesi päivän valintaa koskevia ohjeita. Voit käyttää linkkiä \"Hae paikka\" valitaksesi paikan, jonka joku muu on jo tallentanut.<br /><br />";
$pgv_lang["quick_update_child_help"] 	= "~LISÄÄ UUSI LAPSI~<br /><br />Näillä kentillä voit lisätä muokattavalle henkilölle uuden lapsen. Täytä uuden lapsen nimi ja sukupuoli. Sitten täytät syntymäajan ja paikan. Lisää päivä sukututkimuksen mukaisessa standardimuodossa (1 JAN 2004). Klikkaa kalenteri-ikonia saadaksesi päivän valintaa koskevia ohjeita. Voit käyttää linkkiä \"Hae paikka\" valitaksesi paikan, jonka joku muu on jo tallentanut.<br /><br />Näillä kentillä voi lisätä vain <i>uuden</i> lapsen. Ne eivät päivitä olemassa olevaa tietoa. Muokataksesi jo olemassa olevan henkilön tietoja, sulje tämä ikkuna ja klikkaa hänen nimeään lähisukulaiset välilehdellä. Klikkaa sitten \"Muokkaa henkilöä\" muokataksesi henkilön tietoja.<br /><br />";
$pgv_lang["index_top10_pageviews_help"]	= "~ENITEN KATSOTTUJEN ASIOIDEN ALUE~<br /><br />Tämä alue näyttää tämän sivuston 10 suosituinta henkilöä, perhettä tai lähdettä. Jotta tämä alue olisi näkyvissä, ylläpitäjän täytyy aktivoida osumalaskurit.<br /><br />";
$pgv_lang["useradmin_user_default_tab_help"]	= "~KÄYTTÄJÄN OLETUSVÄLILEHDEN ASETUS~<br /><br />Tämä asetus määrittää mikä välilehti aukeaa oletusarvoisesti ensimmäisenä katsoessa mitä tahansa #pgv_lang[indi_info]#sivua tällä sivustolla. Mikäli käyttäjä saa muokata käyttäjätiliään, tämän asetuksen voi muuttaa myöhemmin.<br /><br />";
$pgv_lang["edituser_user_default_tab_help"]	= "~KÄYTTÄJÄN OLETUSVÄLILEHDEN ASETUS~<br /><br />Tämä asetus määrittää mikä välilehti aukeaa oletusarvoisesti ensimmäisenä katsoessa mitä tahansa #pgv_lang[indi_info]#sivua.<br /><br />";
$pgv_lang["edituser_user_default_tab_help"]	= "~KÄYTTÄJÄN OLETUSVÄLILEHDEN ASETUS~<br /><br />Tämä asetus määrittää mikä välilehti aukeaa oletusarvoisesti ensimmäisenä katsoessa mitä tahansa henkilösivua tällä sivustolla.";
$pgv_lang["reorder_children_help"]		= "~#pgv_lang[reorder_children]#~<br /><br />Lapset näytetään siinä järjestyksessä, jossa he ovat perhetietueessa. He eivät näy automaattisesti syntymäjärjestyksessä, mikä johtuu siitä, että usein jonkun lapsen syntymäaika on tuntematon, mutta syntymäjärjestys <u>on</u> tiedossa.<br /><br />Tällä valinnalla voit muuttaa lasten järjestystä perheen tietueessa. Koska usein halutaan lajitella lapset syntymäajan perusteella, se voidaan tehdä automaattisesti painikkeen avulla.<br /><br />Voit myös raahata ja pudottaa minkä tahansa tietolaatikon muuttaaksesi lasten järjestyksen. Kun liikutat osoitinta tietolaatikon päällä, sen muoto muuttuu siirtokursoriksi. Kun klikkaat ja pidät vasemman hiiren painikkeen alhaalla, laatikko seuraa kursorin alla ylös ja alas luetteloa pitkin. Kun tietolaatikkoa liikutetaan, muuta antavat sille tilaa. Kun vapautat näppäimen, tietolaatikko jää uuteen paikkaansa luettelossa.<br /><br />";
$pgv_lang["rss_feed_help"]			= "~RSS-SYÖTEASETUKSET~<br /><br />PhpGedView-ohjelmassa oleva RSS-syöte mahdollistaa tervetuloasivun sisällön katsomisen RSS-lukijalla käymättä varsinaisella verkkosivulla. Normaalisti RSS tarjoaja avaa ponnahdusikkunan kertoen muutoksien tapahtuneen seurattavalla sivulla. Tämä mahdollista PhpGedView-sivuston tarkkailun ilman, että tarvitsee käydä sivustolla katsomassa muutoksia.<br /><br /> RSS syötealueella voit räätälöidä linkin syötteeseen ja määritellä syötetyypit (useimmat selaimet osaavat käsitellä useimpia tyyppejä, joten asetus voidaan jättää oletusarvoonsa) sekä määritellä minkä moduulin haluat syötteeseen. Syötteen kieli riippuu siitä kielestä, jolla katsot sivua valitessasi.<br /><br /> Muodostettavat syötteet ovat RSS 0.92, RSS 1.0, RSS 2.0, ATOM, HTML ja JavaScript. Neljä ensimmäistä on tarkoitettu RSS-lukijalle, JavaScript ja HTML on tarkoitettu sallimaan syötteen sisällyttämisen muille verkkosivuille. Huomaa, että suurempi versioluku RSS syötteellä ei tarkoita uudempaa versiota vaan erilaista tyyliä.<br /><br />Järjestelmässä on mahdollisuus asettaa tunnustautumispyyntö jolla käyttäjä voi kirjautua ja sallii näin, sopivan RSS-lukijalla, käyttäjän katsoa mitä tahansa tietoa samalla tavoin kuin normaalisti kirjauduttuaan palveluun. Perustunnustautuminen käyttää <i>Basic HTTP Authentication</i> kirjaamaan käyttäjän järjestelmään. Tulevat parannukset saattavat sallia <i>Digest Authentication</i>.<br /><br />Tämä <a href='http://en.wikipedia.org/wiki/RSS_(file_format)' target='_blank' alt='Wikipedia article' title='Wikipedia article'><b>Wikipedia artikkeli</b></a> sisältää perusteellista tietoa ja linkkejä RSS-syötteestä ja erilaisista RSS formaateista. <i>Basic HTTP Authentication</i> käsitellään tässä <a href='http://en.wikipedia.org/wiki/Basic_authentication_scheme' target='_blank' alt='Wikipedia article' title='Wikipedia article'><b>Wikipedia-artikkelissa</b></a>, kun taas <i>Digest Authentication</i> käsitellään tässä <a http://en.wikipedia.org/wiki/Digest_access_authentication' target='_blank' alt='Wikipedia article' title='Wikipedia article'><b>Wikipedia artikkelissa</b></a>.<br /><br />";
$pgv_lang["upload_media_folder_help"]	= "~#pgv_lang[folder]#~<br /><br />GEDCOM-tiedostosi konfigurointi sallii #GLOBALS[MEDIA_DIRECTORY_LEVELS]# kansiotasoa oletusarvoisen <b>#GLOBALS[MEDIA_DIRECTORY]#</b> lisäksi, mihin voidaan tallentaa palvelimelle ladattuja mediatiedostoja. Näin voit organisoida mediatiedostosi tarvitsematta huolehtia siitä, että jokaisella mediatiedostolla olisi ainutlaatuinen nimi.<br /><br />Tässä kentässä määrittelet sen hakemiston palvelimessasi, johon mediatiedostot tallennetaan. Huomaa ero pienten ja suurten kirjasinten välillä.<br /><br />Mikäli tähän kirjoittamaasi kansiota ei ole olemassa, se luodaan automaattisesti. Mikäli lisäät enemmän kansioita kuin #GLOBALS[MEDIA_DIRECTORY_LEVELS]#, joka on asetettu GEDCOM-asetuksissasi, syötteesi katkaistaan vastaavasti.<br /><br />Pienoiskuvat ladataan tai luodaan samanlaiseen kansiorakenteeseen alkaen kansiosta <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b>.<br /><br />";
$pgv_lang["upload_media_file_help"]		= "~#pgv_lang[media_file]#~<br /><br />Tässä kentässä määrittelet palvelimelle ladattavaksi tarkoitettujen mediatiedostojen sijainnin ja nimen omalla koneellasi. Voit käyttää <b>Selaa</b>-painiketta etsiäksesi tiedostoa omalta koneeltasi.<br /><br />Ladatulla tiedostolla tulee olemaan sama nimi palvelimella ja se tallennetaan siihen kansioon, joka on määritelty <b>#pgv_lang[folder]#</b>-kentässä.<br /><br /> Mikäli et näe <b>#pgv_lang[folder]#</b>-kenttää tai et voi muuttaa sitä, GEDCOM-asetuksesi ei salli lisää kansiotasoja ylitse oletusarvon <b>#GLOBALS[MEDIA_DIRECTORY]#</b>, mihin mediatiedostoja normaalisti tallennetaan. Siinä tapauksessa tiedostot ladataan hakemistoon <b>#GLOBALS[MEDIA_DIRECTORY]#</b>.<br /><br />";
$pgv_lang["upload_thumbnail_file_help"]	= "~#pgv_lang[media_file]#~<br /><br />Tässä kentässä määrittelet palvelimelle ladattavaksi tarkoitettujen pienoiskuvien sijainnin ja nimen omalla koneellasi. Voit käyttää <b>Selaa</b>-painiketta etsiäksesi tiedostoa omalta koneeltasi.<br /><br />Kun tämä kenttä täytetään, <b>#pgv_lang[auto_thumbnail]#</b> valintaruutu ohitetaan.<br /><br />Mikäli <b>#pgv_lang[media_file]#</b>-kenttä on täytetty, pienoiskuvasi nimetään sen mukaisesti riippumatta pienoiskuvasi nimestä omalla koneellasi. Mikäli kenttä on tyhjä, ladattu pienoiskuva tallennetaan kahteen paikaan palvelimella. Toinen hakemisto on <b>#pgv_lang[folder]#</b>-kentässä mainittu ja toinen identtiseen kansiorakenteeseen, jonka alku on <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b>.<br /><br />Mikäli et näe <b>#pgv_lang[folder]#</b>-kenttää tai et voi muuttaa sitä, GEDCOM-asetuksesi ei salli lisää kansiotasoja ylitse oletusarvon <b>#GLOBALS[MEDIA_DIRECTORY]#</b>, mihin mediatiedostoja normaalisti tallennetaan.<br /><br />Voit jättää tämän kentän tyhjäksi, mikäli haluat ladata vain pienoiskuvan ja haluat, että se on myös pääkuva.<br /><br />";

//-- GENERAL
$pgv_lang["help_header"]			= "Lisätietoja:";
$pgv_lang["privacy_error_help"]		= "~YKSITYISTIETOJA~<br /><br />Tähän viestiin on monta syytä:<br /><br /><ul><li><b>Eläviä henkilöitä koskeva tieto on asetettu tilaan \"Yksityinen\"</b><br />Rekisteröitymättömät tai sisäänkirjautumattomat vierailijat voivat nähdä vain kuolleiden henkilöiden tietoja. Mikäli järjestelmän ylläpitäjä sallii, voit rekisteröityä klikkaamalla Kirjaudu sisään-painiketta ja sitten #pgv_lang[requestpassword]# -linkkiä.<br /></li><li><b>Sinulla on käyttäjätunnus ja salasana...</b><br />Mutta unohdit kirjautua sisälle tai et ollut aktiivinen vähään aikaan ja istuntosi aika loppui.<br /></li><li><b>Yksityisyyden vuoksi</b><br />Henkilö on pyytänyt ylläpitäjää asettamaan hänet tilaan \"Yksityinen\" tai ei halua näkyä ollenkaan (Piilotettu).<br />Yksityisyys voidaan asettaa seuraaviin tiloihin:<br /><ol><li>#pgv_lang[PRIV_USER]#</li><li>#pgv_lang[PRIV_NONE]#</li><li>#pgv_lang[PRIV_HIDE]#</li></ol></li><li><b>\"Sukulinjan\" ulkopuolella. </b><br />Vaikka olet säännöllinen käyttäjä <u>ja</u> kirjautunut sisään, voit silti nähdä tämän viestin mikäli haluamasi henkilö ei ole sinulle riittävän läheistä sukua. Ylläpitäjä asettaa sukulaisuusportaiden lukumäärän tässä GEDCOM-tiedostossa.<br /><br />Esimerkkejä: <br />Mikäli sukulaisuussuhteen etäisyys on <b>1</b>, voit nähdä vain oman perheesi, isäsi, äitisi ja sisarustesi tiedot (mutta et sisarustesi puolisoiden tai lasten tietoja)<br /><br />Kun sukulaisuussuhteen etäisyys on <b>2</b>, voit nähdä myös sisarustesi puolisoiden ja lasten tiedot (mutta et lasten puolisoiden ja heidän lastensa tietoja).<br />Mitä suurempi sukulaisuussuhteen arvo on, sen kaukaisempien sukulaisten tietoja saat nähdä.<br /></li></ul><br />Mikäli sinulla on mielestäsi oikeus nähdä tiettyjä piilotettuja tietoja, ota yhteyttä järjestelmän ylläpitäjään seuraamalla yhteyslinkkejä näytöllä.<br /><br />";
$pgv_lang["more_help"]			= "<br />Mikäli haluat pika-avusteet, varmista, että <b>#pgv_lang[show_context_help]#</b> (Ohje-valikossa) on päällä ja klikkaa <b>?</b> aiheen jälkeen.<br /><br />";
$pgv_lang["more_config_help"]		= "<br /><b>More help</b><br />#pgv_lang[context_help]#<br /><br />";
$pgv_lang["start_admin_help"]		= "+++Ylläpitäjän lisäinfon alku+++";
$pgv_lang["end_admin_help"]			= "--- Ylläpitäjän lisäinfon loppu---";
$pgv_lang["multiple_help"]			= "<center>--- Tämä on yleistä useita sivuja koskeva lisäinfo ---</center>";
$pgv_lang["header_general_help"]		= "<div class=\"name_head\"><center><b>YLEISTÄ INFORMAATIOTA</b></center></div><br />";
$pgv_lang["best_display_help"]		= "~Näyttösi~<br /> PhpGedView on suunniteltu toimivaksi parhaiten näytön resoluutiolla 1024x768 pikseliä. Sen tulisi olla vähimmäisresoluution, jotta kaikki näkyisi kunnolla.<br /><br />Jos resoluutio on alhaisempi, (esim. 800x600 pikseliä) joudut vierittämään näyttöä vaakasuunnassa joillakin sivuilla.<br /><br />";
$pgv_lang["preview_help"]			= "~Tulostus~<br />Klikkaamalla Tulostuksen esiakatselu-linkkiä poistuvat kaikki sellaiset yksityiskohdat, jotka häiritsisivät siistiä tulostusasua (valikot, syöttökentät, ylimääräiset linkit, pika-avusteiden kysymysmerkit jne.)<br /><br />Tulostusnäkymän alareunassa on <b>Tulosta</b>-linkki. Klikkaamalla sitä tulostusvalikko aukeaa. Tulostuksen jälkeen voit klikata <b>Takaisin</b>-linkkiä ja näyttö palautuu normaalitilaan.<br /><br />Vihje: Vaikka tulostusnäkymästä puuttuu useita linkkejä, ovat jäljelle jääneet yhä klikattavissa.<br /><br />";
$pgv_lang["readme_help"]			= "Katso <a href=\"readme.txt\" target=\"_blank\"><b>Readme.txt</b></a> saadaksesi lisätietoa.";
$pgv_lang["is_user_help"]			= "---Tämä ohjeteksti on sama kuin se minkä vierailijat näkevät.---<br />---Säästääksemme tilaa, emme laatineet erillistä ylläpitäjälle suunnattua tekstiä tälle asialle.---";
$pgv_lang["edit_raw_gedcom_help"]		= "~MUOKKAA GEDCOM-RAAKADATAA~<br /><br />Kun klikkaat tätä linkkiä, uusi, tätä sivua koskeva GEDCOM-raakadataa sisältävä ikkuna aukeaa.<br /><br />Siinä voit muokata suoraan GEDCOM-dataa. Varmista, että syötät vain oikeamuotoista GEDCOM 5.5.1 dataa, koska aineiston oikeellisuutta ei tarkasteta. Muutettu tai lisätty data näkyy PhpGedView:ssä muutoksina jotka riittävillä oikeuksilla varustetun käyttäjän on hyväksyttävä.<br /><br />";
$pgv_lang["RESN_help"]			= "~TIETOJA KOSKEVIEN RAJOITUSTEN ASETTAMINEN~<br /><br />Paitsi yksityisyysasetuksia PhpGedView voi asettaa rajoituksia henkilöitä ja perheitä koskevien tietojen katselulle ja muokkaukselle. Kuka tahansa, jolla on muokkausoikeudet, elleivät aiemmin tehdyt yksityisyysasetukset ja muut asetukset sitä kiellä, voi määrätä rajoitukset. <br /><br />Seuraavat arvot ovat käytössä:<br /><br /><b>#pgv_lang[none]#</b><br />Sivuston ylläpitäjät, GEDCOM-ylläpitäjät ja käyttäjät, joilla on muokkausoikeudet, voivat muuttaa tietoja. Tietoa voi katsoa ylläpitäjän tekemien yksityisyysasetusten mukaan.</li><li><b>#pgv_lang[locked]#</b><br />Tällä valinnalla ei ole vaikutusta tietojen näkymiseen. Se rajoittaa editointioikeudet palvelun ylläpitäjälle ja GEDCOM-ylläpitäjälle. Mikäli tieto koskee käyttäjää itseänsä, hän voi katsoa, ja mikäli hänellä on editointioikeudet, editoida niitä. Tiedot ovat piilossa muilta käyttäjiltä riippumatta siitä, ovatko he kirjautuneet palveluunvai eivät.</li></ul><br /><table><tr><th></th><th colspan=\"2\">Ylläpitäjä</th><th colspan=\"2\">Omistaja</th><th colspan=\"2\">Muut</th></tr><tr><th></th><th>R</th><th>W</th><th>R</th><th>W</th><th>R</th><th>W</th></tr><tr><td><img src=\"images/RESN_none.gif\" alt=\"\" /> #pgv_lang[none]#</td><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th></tr><tr><td><img src=\"images/RESN_locked.gif\" alt=\"\" /> #pgv_lang[locked]#</td><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th></tr><tr><td><img src=\"images/RESN_privacy.gif\" alt=\"\" /> #pgv_lang[privacy]#</td><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th></tr><tr><td><img src=\"images/RESN_confidential.gif\" alt=\"\" /> #pgv_lang[confidential]#</td><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th></tr></table><ul><li>R : voi lukea</li><li>W : voi editoida</li><li><img src=\"images/checked_qm.gif\" alt=\"\" /> : riippuu yleisistä yksityisyysasetuksista</li></ul>";

//-- Pages Help-messages
//-- Index-page
$pgv_lang["index_help"]			= "~TERVETULOASIVU~<br /><br />Tämä sivu on tervetuloasivu. Siinä toivotetaan sinut tervetulleeksi valittuun <a href=\"#def_gedcom\">GEDCOM</a>-tiedostoon. Voit palata tälle sivulle valitsemalla Tervetuloa-sivu ylävalikosta. Mikäli tässä palvelussa on useita GEDCOM-tiedostoja, voit valita haluamasi alasvetovalikosta.<br /><b />Tämä ohjesivu sisältää seuraavat asiat:<ul><li><a href=\"#index_portal\"><b>Tervetuloa-sivu</b></a></li><li><a href=\"#header\"><b>Otsikkoalue</b></a></li><li><a href=\"#menu\"><b>Valikot</b></a></li><li><a href=\"#header_general\"><b>Yleistä tietoa</b></a></li><li><a href=\"#def\"><b>Määritelmiä</b></a></li></ul><br />";

//-- Index-page Header
$pgv_lang["header_help"]			= "<div class=\"name_head\"><center><b>OTSIKKOALUE</b></center></div><br />Otsikko näkyy jokaisen sivun alussa. Otsikko sisältää joitakin käyttökelpoisia linkkejä, joita voit hyödyntää kaikkialla palvelussa.<br /><br />Koska tällä palvelulla voi olla erilaisia ulkoasuja valitusta <a href=\"#def_theme\">Teemasta</a> riippuen, voi otsikon ulkoasu ja linkkien paikka vaihdella.<br /><br />Voit löytää seuraavat linkit:<ul><li><a href=\"#header_search\"><b>Hakukenttä</b></a></li><li><a href=\"#header_lang_select\"><b>Kielen valintar</b></a></li><li><a href=\"#header_user_links\"><b>Käyttäjän linkit</b></a></li><li><a href=\"#header_favorites\"><b>Suosikit</b></a></li><li><a href=\"#header_theme\"><b>Vaihda teema</b></a></li></ul>";
$pgv_lang["header_search_help"]		= "~Otsikkoalue: Hakukenttä~<br />Tämä hakukenttä on pieni mutta tehokas. PhpGedVieW voi etsiä melkein mitä tahansa. Kun klikkaat  <b>></b>-merkkiä tai <b>Hae</b>-painiketta pääset haun pääsivulle, josta löydät hakutulokset. Hakusivulla on laajasti lisäohjeita.<br /><br /> ";
$pgv_lang["header_lang_select_help"]	= "~Otsikkoalue: Kielen valitsin~<br />Yksi PhpGedView:n tärkeimmistä ominaisuuksista on useamman kielen tuki. Kieli valitaan automaattisesti vierailijan selaimen asetusten perusteella.<br />Mikäli valinta ei tapahdu automaattisesti (johtuu todennäköisesti selaimen virheellisestä oletuskielen asetuksesta), voit vaihtaa kieltä <b>Kielivalitsimen</b> avulla.<br />Kielivalitsin voi näkyä kahdella tavalla:<br />1. Tavanomainen alasvetovalikko.<br />2. Värillinen kansallislippujono.<br />";
$pgv_lang["header_user_links_help"]		= "~Otsikkoalue: Käyttäjän linkit~<br />Käyttäjän linkit on pieni alue, jossa on tärkeitä linkkejä, jotka ovat samalla paikalla kaikkialla palvelussa. Linkkien paikka riippuu valitusta voimassa olevasta teemasta.<br /><br />Jos et ole kirjautunut palveluun, näkyy vain <b>Sisäänkirjautuminen</b>-linkki. Kun olet kirjautunut näkyy: <ul><li><b>Kirjautunut (käyttäjätunnuksesi)</b>. Klikkaamalla linkkiä, pääset käyttäjätietoihisi.</li><li>Klikkaa <b>Uloskirjautuminen</b> kirjautuaksesi ulos.</li><li>Jos sinulla on ylläpito-oikeudet, näkyy myös <b>Hallinnointi</b>.<br />Klikkaamalla sitä, pääset ylläpidon pääsivulle.</li><br /><br />";
$pgv_lang["header_favorites_help"]		= "~Otsikkoalue: Suosikit~<br />Suosikit-alasvetovalikko näyttää suosikit, jotka olet valinnut henkilökohtaiseen portaaliisi. Se näyttää myös ylläpitäjän valitsemat suosikit. Klikkaamalla suosikkia pääset suoraan kyseisen henkilön #pgv_lang[indi_info]#sivulle.<br /><br />Lisää ohjeita suosikin lisäämiseksi löytyy omasta portaalistasi.<br /><br />";
$pgv_lang["header_theme_help"]		= "~Otsikkoalue: Vaihda teema~<br />Jos ylläpitäjä on aktivoinut Vaihda teemaa alasvetovalikon, voit valita siitä haluamasi näkymän.<br /><br />Voit muuttaa näkymää alasvetovalikosta valitsemasi teeman mukaiseksi. Jos olet sisäänkirjautunut myös käyttäjäteemasi muuttuu ja on käytössä seuraavan kerran kirjautuessasi.<br /><br />";

//-- Index-page Menu
$pgv_lang["menu_help"]			= "<div class=\"name_head\"><center><b>VALIKOT</b></center></div><br />Sivujen otsikkoalueella ovat alasvetovalikot.<br /><br />Siirtämällä kursori valikkoikonin päälle, näkyviin tulee alavalikko mikäli sellainen on olemassa kyseiselle asialle. Mikäli klikkaat päävalikkoikonia pääset  ensimmäiseen alavalikon kohtaan.<br /><br /> Voit yleensä valita seuraavat asiat päävalikosta: <ul><li><a href=\"#menu_fam\">#pgv_lang[welcome_page]#</a><br /></li><li><a href=\"#menu_myged\">#pgv_lang[mygedview]#</a><br /></li><li><a href=\"#menu_charts\">#pgv_lang[charts]#</a><br /></li><li><a href=\"#menu_lists\">#pgv_lang[lists]#</a><br /></li><li><a href=\"#menu_annical\">#pgv_lang[anniversary_calendar]#</a><br /></li><li><a href=\"#menu_clip\">#pgv_lang[clippings_cart]#</a><br /></li><li><a href=\"#menu_search\">#pgv_lang[search]#</a><br /></li><li><a href=\"#menu_help\">#pgv_lang[page_help]#</a></li></ul><br />";
$pgv_lang["menu_famtree_help"]		= "~Tervetulosivun valikko~<br />Kaikki tämän palvelun GEDCOM-tiedostot on lueteltu tässä valikossa. Jokaisella GEDCOM-tiedostolla on oma räätälöity tervetulosivunsa, kuten tämä. Mikäli tässä palvelussa on vain yksi GEDCOM-tiedosto, ei tervetulosivun ikonin alla ole alavalikkoa.<br /><br />";
$pgv_lang["menu_myged_help"]		= "~#pgv_lang[mygedview]# menu~<br />Mikäli olet sisäänkirjautunut, tämä valikko saattaa sisältää seuraavat asiat:<ol><li>#pgv_lang[mygedview]#<br /> Tämä vie sinut omalle räätälöitävälle \"Aloitussivulle\".</li><li>#pgv_lang[editowndata]#<br />Voit muokata omia henkilötietojasi tässä.</li><li>#pgv_lang[my_pedigree]#<br />Mikäli olet valinnut lähtöhenkilön tässä GEDCOM:ssa, vie tämä kyseisen henkilön esipolvikaavioon.</li><li>#pgv_lang[my_indi]#<br />Tämä vie sinut #pgv_lang[indi_info]# sivullesi, jolta löytyy kaikki tiedot itsestäsi ja perheestäsi.</li></ol><br />";
$pgv_lang["menu_charts_help"]		= "~Kaaviot-valikko~ <br />Käytettävissä olevat kaaviot ovat on lueteltu tässä valikossa:<ol><li><a href=\"?help=help_pedigree.php\"><b>#pgv_lang[index_header]#</b></a><br />Tämä vie GEDCOM-tiedoston esipolvikaavioon. Kaavio alkaa ylläpitäjän määrittämästä henkilöstä.Jos olet kirjautunut sisään, lähtöhenkilö voi olla kuka tahansa käyttäasetuksissa määrittelemäsi henkilö.</li><li><a href=\"?help=help_descendancy.php\"><b>#pgv_lang[descend_chart]#</b></a><br />Jälkipolvikaavio on kuin <a href=\"?help=help_pedigree.php\"><b>#pgv_lang[index_header]#</b></a> mutta käänteisessä järjestyksessä. Tämä vertaus ei ole ihan tarkka sillä kun esipolvikaaviossa näytetään lähtöhenkilön esipolvet, niin jälkipolvikaaviossa näytetään lähtöhenkilön jälkipolvet.</li><li><a href=\"?help=help_timeline.php\"><b>#pgv_lang[timeline_chart]#</b></a><br />Tässä näet henkilöä koskevat tapahtumat aikajanalla. On mielenkiintoista seurata kahden tai useamman henkilön tapahtumia samalla aikajanalla.</li><li><a href=\"?help=help_relationship.php\"><b>#pgv_lang[relationship_chart]#</b></a><br />Tässä voit selvittää sukulaisuussuhteet jonkun henkilön ja itsesi tai jonkun muun välillä.</li><li><a href=\"?help=help_ancestry.php\"><b>#pgv_lang[ancestry_chart]#</b></a><br />Tämä kaavio on hyvin samantapainen kuin <a href=\"?help=help_pedigree.php\"><b>#pgv_lang[index_header]#</b></a>, mutta siinä on enemmän yksityiskohtia ja vaihtoehtoiset <a href=\"?help=chart_style_help\"><b>#pgv_lang[chart_style]#</b></a>-näkymät.</li><li><a href=\"?help=help_fanchart.php\"><b>#pgv_lang[fan_chart]#</b></a><br />Hyvin samanlainen kuin <a href=\"?help=help_pedigree.php\"><b>#pgv_lang[index_header]#</b></a>, mutta graafisemmin esitettynä.</li></ol><br />";
$pgv_lang["menu_lists_help"]			= "~Luettelovalikko~<br />Seuraavat luettelot ovat käytettävissä:<ol><li><a href=\"?help=help_indilist.php\"><b>#pgv_lang[individual_list]#</b></a></li><li><a href=\"?help=help_famlist.php\"><b>#pgv_lang[family_list]#</b></a><br />Näistä luetteloista voit etsiä henkilöitä ja sukuja aakkosjärjestyksessä tässä GEDCOMissa.</li><li><a href=\"?help=help_sourcelist.php\"><b>#pgv_lang[source_list]#</b></a><br />Tässä luettelossa on kaikki tämän GEDCOM-tiedoston tietolähteet.</li><li><a href=\"?help=help_placelist.php\"><b>#pgv_lang[place_list]#</b></a><br />Täältä voit etsiä henkilöitä paikan mukaan. Siinä palautetaan kaksi saraketta. Henkilöt on luetteloitu vasemmanpuoleisessa ja suvut oikeanpuoleisessa sarakkeessa.</li><li><a href=\"?help=help_medialist.php\"><b>#pgv_lang[media_list]#</b></a><br />Tämän valikon näet vain jos ylläpitäjä on sen aktivoinut.<br />Tämä näyttää linkit kaikkiin tämän GEDCOM-tiedoston multimediatiedostoihin.</li></ol><br />";
$pgv_lang["menu_annical_help"]		= "~#pgv_lang[anniversary_calendar]#valikko~<br />~#pgv_lang[anniversary_calendar]# näyttää tietyn päivämäärän, kuukauden tai vuoden tapahtumat GEDCOMissa.<ol><li><a href=\"?help=day_month_help\"><b>#pgv_lang[viewday]#</b></a></li><li><a href=\"?help=day_month_help\"><b>#pgv_lang[viewmonth]#</b></a></li><li><a href=\"?help=day_month_help\"><b>#pgv_lang[viewyear]#</b></a><br /> Nämä valikkokohteet vievät #pgv_lang[anniversary_calendar]#in, josta näkyy luettelo tämän päivän, kuukauden tai vuoden kaikista tapahtumista.</li></ol><br />";
$pgv_lang["menu_clip_help"]			= "~#pgv_lang[clippings_cart]# alikko~<br />Tämä näkyy, mikäli ylläpitäjä on sen aktivoinut. <br /><br />#pgv_lang[clip_cart]# tekee mahdolliseksi valita henkilöitä, sukuja ja lähteitä ja tallentaa ne väliaikaistiedostoon jotta voit myöhemmin ladata ne koneellesi GEDCOM 5.5.1 muodossa.<br /><br />";
$pgv_lang["menu_search_help"]		= "~Hakuvalikko~<br />Klikkaamalla tätä pääset hakusivulle, joka on tehokkaampi kuin hakulinkki, joka joskus näkyy sivun otsikkoalueella. <br /><br />";
$pgv_lang["menu_help_help"]			= "~Ohjevalikko~<br />#pgv_lang[help_help_items]#";

//-- Index-page Portal
$pgv_lang["index_portal_head_help"]		= "<div class=\"name_head\"><center><b>TERVETULOSIVU</b></center></div><br />";
$pgv_lang["index_portal_help"]		= "Tervetuloasivu koostuu useista erillisistä alueista ja voidaan räätälöidä. Palveluissa, joissa on useampia GEDCOM-tiedostoja, voi  kullakin GEDCOM-tiedostolla olla oma erilainen tervetulosivu.Riippuen siitä, miten ylläpitäjä on räätälöinyt sivuston voit nähdä seuraavat alueet tervetulosivulla:<ul><li><a href=\"#index_welcome\"><b>Tervetuloa</b></a><li><a href=\"#index_login\"><b>Sisäänkirjautuminen</b></a><li><a href=\"#index_events\"><b>Tulevia tapahtumia</b></a><li><a href=\"#index_onthisday\"><b>Historiallisia tapahtumia tänään</b></a><li><a href=\"#index_favorites\"><b>GEDCOM suosikkeja</b></a><li><a href=\"#index_stats\"><b>GEDCOM tilastotietoja</b></a><li><a href=\"#index_common_surnames\"><b>Tavallisimmat sukunimet</b></a><li><a href=\"#index_media\"><b>Satunnainen kuva</b></a><li><a href=\"#index_loggedin\"><b>Kirjautuneet käyttäjät</b></a><li><a href=\"#gedcom_news\"><b>GEDCOM uutisia</b></a><li><a href=\"#recent_changes\"><b>Viimeisimmät muutokset</b></a></li></ul><br />";

$pgv_lang["index_welcome_help"]		= "~TERVETULOA-ALUE~<br />Tervetuloalohko näyttää nykyisen tietokannan nimen, päivämäärän ja ajan ja, mikäli ylläpitäjä on sen käynnistänyt, Osumalaskurin.<br /><br />Tämän osumalaskurin löydät vain tervetuloa-alueelta ja sivulta #pgv_lang[indi_info]#. Laskuri laskee kuinka monta kertaa sivulla on käyty. Laskuri ei tarkista kävijän linkkiä, vaan jokainen käynti <u>miltä tahansa sivustolta</u> lasketaan uudeksi osumaksi.<br /><br />";
$pgv_lang["index_login_help"]			= "~SISÄÄNKIRJAUTUMISALUE~<br />Vaikka voit kirjautua järjestelmään melkein miltä tahansa sivulta, teet sen kuitenkin useimmiten ensimmäisellä sivulla, koska pääset käsiksi rajoitettuihin tietoihin vain sisäänkirjautuneena.<br />Voit kirjautua antamalla <b>käyttäjätunnuksen</b> ja <b>salasanan</b> ja klikkaamalla \"Kirjaudu sisään\" painiketta.<br /><br />#pgv_lang[new_password_help]#<br />";
$pgv_lang["index_events_help"]		= "~TULEVAT TAPAHTUMAT -ALUE~<br />Tämä alue näyttää lähitulevaisuudessa olevat vuosipäivät.<br /><br /> Ylläpitäjä määrittää, kuinka pitkälle tulevaisuuten vuosipäiviä näytetään alueella. Voit itsekin säätää alueella näkyvät vuosipäivät useiden valintojen avulla.<br /><br />";
$pgv_lang["yahrzeit_help"]			="~JORTSAIT ALUE~<br />Tämä alue näyttää lähitulevaisuuden Yahrzeit-tapahtumat.<br /><br />Jortsaitit ovat henkilön kuoleman muistopäiviä. Nämä on huomioitu juutalaisessa perinteessä; niitä ei juuri huomioida muissa perinteissä. «Jortsaitt» voidaan myös kirjoittaa muodossa «Jahrzeit» tai «Yartzeit».<br /><br />Ylläpitäjä määrittää, miten pitkälle tulevaisuuteen alue ulottuu. Voit hienosäätää tulevien Jortsait-päivien näkymistä konfiguroimalla.<br /><br />";
$pgv_lang["days_to_show_help"]		= "~#pgv_lang[days_to_show]#~<br /><br />Lisää näytettävien päivien lukumäärä. Lukumäärä ei voi olla suurempi kuin <b>#DAYS_TO_SHOW_LIMIT#</b>. Mikäli kirjoitat suuremman luvun, käytetään tätä raja-arvoa.<br /><br />Rajan asettaa ylläpito GEDCOM-asetuksissa, Näyttö- ja asetteluosiossa, Piilota & näytä alaosiossa. ";
$pgv_lang["random_media_persons_or_all_help"] = "~#pgv_lang[random_media_persons_or_all]#~<br /><br />Tämä valinta määrittelee näytettävän mediatyypin.<br /><br />Valittaessa <b>#pgv_lang[random_media_persons]#</b>, vain henkilöihin liittyvä media näytetään. Yleensä se on henkilön valokuva. Valittaessa <b>#pgv_lang[random_media_events]#</b>, vain tietoihin tai tapahtumiin liittyvä media näytetään. Se voi olla esimerkiksi kuva todistuksesta. Valittaessa <b>#pgv_lang[all]#</b>, näytetään kaikenlainen media.";
$pgv_lang["random_media_filter_help"] 	= "~#pgv_lang[filter]#~<br /><br />Voit median muodon ja tyypin perusteella rajoittaa sitä, mitä satunnaisen kuvan alueella on näkyvissä. Kun tietty valintaruutu on rastitettu, satunnaisen kuvan alueella näytetään kyseisen formaatin tai tyypin muotoista mediaa.<br /><br />Sellaiset formaatti- tai tyyppikoodit, jotka ovat olemassa tietokannassasi, mutta joita ei näy valintaruutulistassa ovat oletusarvoisesti rastitetut. Esimerkiksi mikäli tietokannassasi on <b><i>pdf</i></b>-formaatin mukaisia mediatiedostoja, niiden näkyminen on aina sallittu satunnaisen kuvan alueella. Sama pätee mikäli tietokannassasi on <b><i>erikois</i></b>-tyyppisiä mediatiedostoja, niiden näkyminen on myös sallittu satunnaisen kuvan alueella. ";
$pgv_lang["basic_or_all_help"]		= "~#pgv_lang[basic_or_all]#~<br /><br />Tämä vaihtoehto sallii joidenkin päivättyjen tapahtumien poistamisen näkyvistä. Esimerkiksi #factarray[DIV]#, #factarray[CREM]#, #factarray[GRAD]#, #factarray[BARM]#, #factarray[FCOM]# jne. tulisi kaikki olla päivättyjä. <br /><br />Kun valitset <b>Kyllä</b>, vain syntymät, kuolemat ja avioliitot näytetään. Kun valitset <b>Ei</b>, kaikki tapahtumat näytetään.";
$pgv_lang["style_help"]			= "~#pgv_lang[style]#~<br /><br />Tämä valinta määrittelee, kuinka tieto esitetään.<br /><br />Kun valitset <b>#pgv_lang[style1]#</b>, tieto näytetään tekstimuodossa samalla tavoin kuin useissa kaaviolaatikoissa. Muoto sopii alueille, jotka tulostuvat sivun oikeaan laitaan. <br /><br />Kun valitset <b>#pgv_lang[style2]#</b>, tieto näytetään taulukkomuodossa ja sopii paremmin suuriin alueisiin, jotka tulostuvat sivun vasempaan laitaan.";
$pgv_lang["cal_dowload_help"]		= "~#pgv_lang[cal_download]#~<br /><br />Tämä valinta määrittelee näytetäänkö kirjautuneille käyttäjille painike, jolla ladataan kalenteritapahtumat omalle koneelle. Ladattu kalenteritiedosto voidaan tuoda yhteensopivaan ohjelmaan kuten esimerkiksi Microsoft Outlookiin, jotta voidaan esimerkiksi luoda automaattisia sähköpostimuistutuksia vuosipäivien varalle.<br /><br />Jos valinta on <b>#pgv_lang[no]#</b>, kirjautunut käyttäjä ei voi ladata kalenteritiedostoa. Jos valinta on <b>#pgv_lang[yes]#</b>, \"Lataa\"-painike on näkyvissä. Tämä painike ei koskaan näy kirjautumattomalle käyttäjälle.";
$pgv_lang["index_charts_help"]		= "~#pgv_lang[charts_block]#~<br />Tämä alue sallii esipolvi-, jälkipolvi- tai tiimalasikaavion näkymisen Tervetuloa- tai OmaGedView-sivulla. Tilarajoituksista johtuen kaaviot tulisi sijoittaa vain sivun vasempaan laitaan.<br /><br />Kun tämä alue näkyy tervetuloa-sivulla, ylläpitäjä määrittelee juurihenkilön ja kaaviotyypin. Kun tämä alue näkyy käyttäjän henkilökohtaisella OmaGedView-sivulla, käyttäjä itse määrittelee valinnat.<br /><br />Nämä kaaviot käyttäytyvät samalla tavoin kuin silloin, kun ne haetaan valikoista. Klikkaa henkilön laatikkoa nähdäksesi lisätietoja.<br /><br />";
$pgv_lang["index_onthisday_help"]		= "~TÄNÄ PÄIVÄNÄ TAPAHTUI... ALUE~<br />Tämä alue toimii kuten \"tulevat tapahtumat\" alue sillä erotuksella, että siinä näet tämän päivän tapahtumat omassa historiassasi.<br />";
$pgv_lang["index_favorites_help"]		= "~GEDCOM SUOSIKIT-ALUE~<br />GEDCOM suosikit-alue on kuin \"Suosikkini\"-alue sivulla #pgv_lang[mygedview]#. Poiketen portaalisivun asetuksista, vain ylläpitäjä tai käyttäjällä, jolla on ylläpito-oikeudet voi muuttaa suosikkiluetteloa tällä alueella.<br /><br />GEDCOM suosikkialueen merkitys on kiinnittää huomiota erityisen kiinnostavviin henkilöihin. Jokaisen sivun otsikkoalueella olevasta alasvetovalikosta pääsee käsiksi tämän GEDCOMin suosikkeihin.<br /><br />Napauttamalla jotain suosikkia luettelossa pääset kyseisen henkilön sivulle #pgv_lang[indi_info]#.<br /><br />";
$pgv_lang["index_add_favorites_help"]	= "~LISÄÄ SUOSIKKI~<br />Tässä voit lisätä uuden suosikin suosikkiluetteloosi. Lisää joko henkilön, perheen tai lähteen ID-tunnus tai URL-osoite ja otsikko. Huomautuskenttä on vaihtoehtoinen ja siinä voi antaa kuvauksen suosikista. Kaikki, mikä on kirjoitettu huomautuskenttään näkyy Suosikit-alueella, kohteen perässä. <br /><br />";
$pgv_lang["index_stats_help"]			= "~GEDCOM TILASTOTIETOJA ALUE~<br />Tällä alueella näet joitakin tilastotietoja tästä GEDCOM-tiedostosta. Mikäli tarvitset enemmän tietoja, lähetä ilmoitus sivun lopussa olevaan kontaktiosoitteeseen.<br /><br />";
$pgv_lang["index_common_names_help"]	= "~YLEISIMMÄT SUKUNIMET~<br />Tällä alueella näytetään tämän GEDCOM-tiedoston yleisimmät sukunimet. Sukunimen on esiinnyttävä vähintään #COMMON_NAMES_THRESHOLD# kertaa ennenkuin se näkyy luettelossa.<br /><br /> Ylläpitäjä asettaa näytettävien sukunimien lukumäärän.<br /><br /> Klikkaa sukunimeä luettelossa ja pääset #pgv_lang[individual_list]#-luetteloon, josta saat lisätietoa nimestä.<br /><br />";
$pgv_lang["index_media_help"]		= "~SATUNNAINEN KUVA ALUE~ <br />Tällä alueella PhpGedView näyttää satunnaisesti valitsemansa mediatiedoston jokaisella käynnillä sivulla.<br /><br />Klikkaamalla kuvaa tai sen selitettä avautuu täysikokoinen kuva. Kuvan alla on linkki kuvaan liittyvään henkilöön. <br />Klikkaamalla kuvan otsikkoa, näet kuvan sivulla #pgv_lang[media_list]#. Klikkaamalla henkilön nimeä, pääset kyseisen henkilön sivulle #pgv_lang[indi_info]#.<br /><br />";
$pgv_lang["index_loggedin_help"]		= "~KIRJAUTUNEET ALUE~<br />Tämä alue näyttää tällä hetkellä kirjautuneet henkilöt.<br /><br />Mikäli et ole ylläpitäjä, näet vain ne sisäänkirjautuneet, jotka ovat sen sallineet. Jotta tämä toimisi on myös sinun sallittava näkyminen on-linetilassa. Ne on-linekäyttäjät joita et pysty näkemään, luetaan tuntemattomiksi.<br /><br />";
$pgv_lang["index_gedcom_news_help"]	= "~GEDCOM UUTISIA ALUE~<br />Uutisalue on kuin ilmoitustaulu tälle GEDCOMille. Ylläpitäjä voi laittaa tänne tärkeitä ilmoituksia tai uutisia.<br /><br />Jos sinulla on jotakin mielenkiintoista näytettävää, ota yhteyttä ylläpitäjään, joka voi laittaa ilmoituksesi esille.<br /><br />";
$pgv_lang["recent_changes_help"]		= "~VIIMEISIMMÄT MUUTOKSET ALUE~<br />Tälla alueella näytetään ne viimeisimmät mutokset GEDCOM-tiedostossa, jotka on tehty CHAN CEDCOM-merkitsimen mukaisesti.<br /><br />";
$pgv_lang["gedcom_news_limit_help"]	= "Voit rajoittaa näytettävien uutisartikkelien lukumäärän ja näin rajoittaa GEDCOM uutisalueen korkeuden.<br /><br />Tämä valinta määrittää käytetäänkö mitään rajoituksia vai asetetaanko rajoitukset artikkelin iän tai artikkelien lukumäärän perusteella.<br /><br />";
$pgv_lang["gedcom_news_flag_help"]	= "Lisää raja-arvo tähän.<br /><br /> Mikäli rajoittavana tekijänä on ikä, kaikki tätä päivien lukumäärää vanhemmat artikkelit jäävät piiloon. Mikäli rajoittavan tekijänä on artikkelien lukumäärä, vain lukumäärän mukaiset uusimmat artikkelit näkyvät.<br /><br />Mikäli arvoiksi valitaan nollat, näytetään kaikki artikkelit.<br /><br />";
$pgv_lang["gedcom_news_archive_help"]	= "Rajoittaakseen uutisalueen korkeutta, ylläpitäjä on piilottanut joitakin artikkeleita. Ne saa näkyville klikkaamalla linkkiä <b>#pgv_lang[gedcom_news_archive]#</b>.<br /><br />";
$pgv_lang["index_htmlplus_help"]		= "~#pgv_lang[htmlplus_block_name]#~<br />Ylläpitäjä voi tässä lisätä tietoa indeksi- tai portaalisivulle. Sillä on sama tarkoitus kuin #pgv_lang[html_block_name]#, #pgv_lang[gedcom_news_block]#, and #pgv_lang[gedcom_stats_block]#alueella, mutta ylläpitäjällä on enemmän vaikutusta sen ulkonäköön.<br /><br />";
$pgv_lang["index_htmlplus_title_help"]	= "Tämän tekstin tulee olla tyhjä tai hyvin lyhyt. Kun se on tyhjä, edistyksellinen HTML-alue näkyy indeksi- tai portaalisivulla tavallisena alueena aivan kuten HTML-alue. Kun siinä on tekstiä, edistyksellinen HTML-alue näyttää samalta kuin muut alueet täydellisenä sisältäen otsikkokentän, jossa on tässä lisäämäsi teksti.";
$pgv_lang["index_htmlplus_template_help"]	= "~#pgv_lang[htmlplus_block_templates]#~<br />Auttaaksemme sinua tämän alueen laatimisessa olemme luoneet useita vakiopohjia. Kun valitset jonkun näistä pohjista, tekstialueella on tekstiä, jonka voit muuttaa tarpeittesi mukaan.<br /><br />";
$pgv_lang["index_htmlplus_content_help"]	= "Poiketen #pgv_lang[html_block_name]#-, #pgv_lang[gedcom_news_block]#-, and #pgv_lang[gedcom_stats_block]#alueista voit täysin säätää tämän alueen ulkonäköä. Voit käyttää HTML-merkitsimiä ja alueella on käytössä aktiivisen teeman CSS tyylitiedostot. Viittauksia aktiiviseen sukututkimustietokantaan voidaan sisällyttää tekstiin.<br /><br />Tietokantaviittaukset tehdään tekstissä ympäröimällä avainsanat <b>&#35;</b> symboliparilla. Esimerkiksi <b>&#35;TOTAL_FAM&#35;</b> edustaa tietokannassa olevien perheiden lukumäärää. Joskus saatat haluta käyttää tietokantaviittausta tekstinä sen todellisen merkityksen sijaan. Siinä tapauksessa on merkit <b>&#35;</b> korvattava niitä vastaavilla symbolivastineilla. Esimerkiksi jos teksti sisältää <b>&&#35;35;TOTAL_FAM&amp&#35;35;</b> se tulostuu merkkijonona <b>&#35;TOTAL_FAM&#35;</b> eikä muodostu tietokantaviittaukseksi.<br /><br />Nähdäksesi täydellisemmän esimerkin tämän alueen käytöstä, katso pohjamallia &quot;#pgv_lang[gedcom_stats_block]#&quot;, joka löytyy osoitteesta alueet/hakemisto. Siinä käytetään useimpia merkitsimien tyylejä mukaan lukien kielilinkit ja aputekstien linkit.<br /><br />Pohjamalli  <b>#pgv_lang[htmlplus_block_keyword]#</b> sisältää täydellisen luettelon tuettuja avainsanoja.<br /><br />";
$pgv_lang["index_htmlplus_compat_help"]	= "Tarkista yhteensopivuus tämän alueen vanhempien versioiden kanssa. Tämä sallii vanhempien merkitsinformaattien käytön, mutta toiminta hidastuu lievästi.<br /><br />\n Tätä tilaa ei suositella käytettäväksi.<br />\n";
$pgv_lang["index_htmlplus_gedcom_help"] = "~#pgv_lang[htmlplus_block_gedcom]#~<br />Valitse tietokanta johon avainsanat soveltuvat.<br /><br />Palvelusi tukee useita tietokantoja. Avainsanat, kuten <b>&#35;totalFamilies&#35;</b> voivat viitata vain yhteen tietokantaan. Voit tunnistaa sen tietokannan, jota tarvitaan kaikkia tällaisia avainsanoja varten. Jokaisella #pgv_lang[htmlplus_block_name]#-alueella on pääsy vain yhteen tietokantaan.<br /><br />";

//-- Index-Page Help
$pgv_lang["help_help"]			= "Olisi tietysti täydellistä tehdä ohjelma, joka on niin yksinkertainen, ettei se vaatisi selityksiä.<br />Se olisi yhtä helppoa kuin kirjan lukeminen.<br />Vaikka tämä ohjelma on varsin monimutkainen, ei sitä huomaa käyttöliittymässä. Melkein kaikkea voi käyttää ilman selityksiä.<br />Mutta koska meillä on paljon kävijöitä ja käyttäjiä, joilla ei ole paljoakaan kokemusta tietokoneista tai internetistä, tarjoamme apua tietyissä paikoissa.<br />Ohjevalikosta löytyvät seuraavat asiat";
$pgv_lang["help_page_help"]			= "<dl><dt><b>Tämän sivun ohje</b></dt><dd>Jokaiselle sivulle on oma \"Ohjesivu\".<br />Kun olet jollakin sivulla, voit klikata tätä asiaa valikossa ja saat esille \"Sivuohjeen\", josta saat selville juuri tällä sivulla olevat asiat.<br />Sivuohje on useimmiten lyhyt.<br />Mikäli tarvitset lisäohjeita tai -tietoja jostakin asiasta tällä sivulla, käytettävissä on \"Pika-avusteet\" kolmantena vaihtoehtona.</dd></dl>";
$pgv_lang["help_content_help"]		= "<dl><dt><b>Ohjeen sisältö</b></dt><dd>Klikkaamalla tätä, aukeaa ponnahdusikkuna, jossa on luettelo tärkeimmistä ohjeista.<br />Tähän luetteloon tulee lähiaikoina lisää kohtia, koska myös vähäisemmät ohjeet indeksoidaan.</dd></dl>";
$pgv_lang["help_faq_help"]			= "<dl><dt><b>UKK-luettelo</b></dt><dd>#pgv_lang[text_faq_help]#</dd></dl>";
$pgv_lang["help_HS_help"]			= "<dl><dt><b>#pgv_lang[hs_title]#</b></dt><dd>#pgv_lang[hs_intro]#</dd></dl>";
$pgv_lang["help_qm_help"]			= "<dl><dt><b>Piilota / Näytä pika-avusteet</b></dt><dd>Tämä viimeinen valikkokohta on ehkä kätevin. Näpäyttämällä tätä kytkeytyvät pika-avusteet päälle tai pois.<br />Mitä ovat pika-avusteet?<br />Kun ne ovat päällä, näkyy mahdollisesti joidenkin linkkien oikealla puolella kysymysmerkki, alasvetovalikko tai painike. Klikkaamalla tätä <b>?</b>-ikonia ponnahtaa pieni ohjeikkuna, jossa on tietoa kyseisestä asiasta.<br />Klikkaamalla \"Piilota pika-avusteet\", kaikki kysymysmerkit poistuvat näytöltä, kunnes taas klikkaat \"Näytä...\".</dd></dl>";

//-- Index-page Definitions
$pgv_lang["def_help"]				= "<div class=\"name_head\"><center><b>MÄÄRITELMIÄ</b></center></div><br />Eräitä ohjeteksteissä esiintyvien sanojen määritelmiä:<ul><li><a href=\"#def_gedcom\">GEDCOM</a><br /><li><a href=\"#def_gedcom_date\">Päivämäärä</a><li><a href=\"#def_pgv\">PhpGedView</a><li><a href=\"#def_portal\">Portaali</a><li><a href=\"#def_theme\">Teema</a></ul>";
$pgv_lang["def_portal_help"]			= "~Portaali~<br />Myös tällä sivustolla portaali on kuin ravintolan aula. Se on lähtöpaikka, mutta sieltä voit myös saada tärkeätä tietoa kuten selityksiä, valikoita jne.<br />";
$pgv_lang["def_gedcom_help"]		= "~GEDCOM-tiedosto~<br />GEDCOM-tiedosto on Myöhempien Aikojen Pyhien Jeesuksen Kristuksen Kirkon perhehistoriaosaston kehittämä tiedostomuoto. Sen tarkoitus on edistää sukututkimustiedon jakamista ja keskenään toimivien sovellusten kehittämistä sukututkijoiden, historiantutkijoiden ja muiden tutkijoiden avuksi.<br />PhpGedView:n noudattaman standardin saa täältä: <a href=\"http://www.phpgedview.net/ged551-5.pdf\" target=\"_blank\">GEDCOM 5.5.1 Standard</a>. Tämä standardi on saatavana vain englanninkielisenä.<br />GEDCOM-tiedosto sisältää kaikki asiatiedot, päivämäärät, tapahtumat, jne. GEDCOM-tiedoston on noudatettava tiukkoja sääntöjä ollakseen vaihtokelpoinen useiden ohjelmien kanssa riippumatta alustasta tai käyttöjärjestelmästä.<br />";
$pgv_lang["def_gedcom_date_help"]		= "~Päivämäärät GEDCOM-tiedostossa~<br />Koska formaattien GEDCOM-tiedostoissa tulee seurata kansainvälisiä sääntöjä, on myös päivämäärän merkitsemistavoista sovittu.<br /><br />Vaikka päivämääräkenttä GEDCOM-tiedostossa on vapaa tekstikenttä (tarkoittaen, että voit kirjoittaa ihan mitä tekstiä tahansa) tässä muutamia selityksiä oikean päivämäärän syöttämiseksi:<br />Täysi päivämäärä kirjoitetaan DD MMM YYYY kuten:<br />01 JAN 1801 tai 14 DEC 1950.<br />Jos sinulta puuttuu jokin osa päivämäärästä voit jättää sen pois ja kirjoittaa:<br />MAR 1801 tai 14 DEC.<br />Ellet ole varma tai päivämäärää ei ole vahvistettu, voit kirjoittaa:<br />ABT MAR 1801 (ABT = noin)<br />BEF 20 DEC 1950 (bef = ennen)<br />AFT 1949 (aft=jälkeen).<br />Kirjoita kyseiset päivämäärät ja lyhenteet englanniksi, koska silloin GEDCOM-tiedostot voi siirtää eri ohjelmille ja ohjelma osaa kääntää päivämäärät ja lyhenteet toivotulle kielelle.<br />Ohjelman tulee myös voida suorittaa laskutoimituksia päivämäärien avulla. Mikäli kirjoitat päivämäärän väärässä muodossa GEDCOM-tiedoston päivämääräkenttään, ohjelma ei pysty suorittamaan laskutoimitusta oikein.<br />";
$pgv_lang["def_gramps_help"]		= "~GRAMPS XML tietokantatiedosto~<br />Lainaus GRAMPS-projektista: <div class=\"list_value_wrap\">GRAMPS autaa sinua selvittämään sukupuusi. Sen avulla voit tallentaa, muokata ja tutkia sukutietoja. GRAMPS pyrkii tarjoamaan kaikki muiden sukututkimusohjelmien suomat palvelut, mutta mikä tärkeintä, pyrkii tarjoamaan integrointimahdollisuuksia, joita normaalisti näillä ohjelmilla yleensä ei ole. GRAMPS-tiedostoon  voi suoraan lisätä mitä tahansa tietoa sekä järjestää uudelleen ja muokata mitä tahansa tai kaikkia tapahtumia koko tietokannassa (missä järjestyksessä tahansa)ja näin auttamaan käyttäjää tekemään tutkimusta, analysoimaan ja vertaamaan tietoja, jotta hän voisi täyttää aukkoja sukulaisuussuhteissa.</div><br />Kopio GRAMPS XML formaatista v1.1.0 <a href=\"http://www.gramps-project.org/xml/1.1.0/\" target=\"_blank\">löytyy tästä</a> sekä RELAX NG Schema muodossa että DTD muodossa.<br /><br />Lisätietoa GRAMPS projektista löytyy osoitteessa <a href=\"http://gramps-project.org/\" target=\"_blank\">http://gramps-project.org/</a>";
$pgv_lang["def_pgv_help"]			= "~PhpGedView~<br />PhpGedView (tai PGV) on John Finlayn laatima ohjelma GEDCOM-tiedostojen katselemiseksi internetissä.<br />Kuten huomaat, PhpGedView ei vain näytä staattisia verkkosivuja, vaan on muuntuva ja voidaan räätälöidä monella tavoin.<br />John aloitti ohjelman kehittelyn itsekseen, mutta kokonainen kansainvälinen tiimi kehittäjiä ja kääntäjiä on liittynyt mukaan kehittämään ohjelmaa.<br />GEDCOM-tiedostoja voidaan nykyään katselemisen lisäksi myös muuttaa ja niihin voi tehdä lisäyksiä verkon välityksellä.<br />";
$pgv_lang["def_theme_help"]			= "~Teema~<br />Tällä sivustolla voi olla useampia ulkonäköjä, joita nimitetään Teemoiksi.<br />Palvelun ylläpitäjä valitsee käynnistyksessä käytettävän teeman.<br />Jokainen sivustolle tulija näkee sivuston samanlaisena (teemana). Mikäli ylläpitäjä on tehnyt sopivat asetukset, voi kirjautunut käyttäjä valita itselleen sopivan teeman, jonka käyttäjä aina sitten näkee kirjauduttuaan sisään.<br />";

//-- Index-page MyGEDCOM
$pgv_lang["mygedview_portal_help"]		= "~#pgv_lang[mygedview]#~<br /> Tämä on henkilökohtainen #pgv_lang[mgv]# sivusi.<br />Täältä voit helposti löytää linkit omiin tietoihisi, kuten <b>Käyttäjätilini</b>, Tietoni</b> (tämä on henkilökohtainen sivusi), <b>Esivanhempani</b>.<br />Lisäksi sinulla voi olla sellaiset alueet kuin <b>Viestit, Päiväkirja</b> ja monia muita. Tämän sivun asettelu on samanlainen kuin Tervetulosivulla.<br />Mutta kun Tervetulosivun asettelun määrää ylläpitäjä, voit itse määrittää, mitkä osat ja alueet tulevat tälle sivulle.<br /><br />Tämän sivun Tervetuloalueella on linkki sivun räätälöimiseen.<br /><br /><b>Voit valita seuraavista alueista haluamasi:</b></b><ul><li><a href=\"#mygedview_welcome\">Tervetuloa</a><li><a href=\"#mygedview_customize\">Muokkaa oma GedView</a><li><a href=\"#mygedview_message\">Viestit</a><li><a href=\"#mygedview_events\">Tulevat tapahtumat</a><li><a href=\"#mygedview_onthisday\">Tänä päivänä tapahtui...</a><li><a href=\"#mygedview_favorites\">Suosikkini</a><li><a href=\"#mygedview_stats\">GEDCOM tilastotietoa</a><li><a href=\"#mygedview_myjournal\">Päiväkirjani</a><li><a href=\"#mygedview_media\">Satunnainen kuva</a><li><a href=\"#mygedview_loggedin\">Sisäänkirjautuneet käyttäjät</a><li><a href=\"#mygedview_recent_changes\">Viimeiset muutokset</a></ul>";
$pgv_lang["mygedview_customize_help"]	= "~MUOKKAA #pgv_lang[mygedview]#~<br />Tultuasi tänne ensimmäistä kertaa sinulla oli jo joitakin alueita käytettävissäsi tällä sivulla.<br />Voit halutessasi muokata (räätälöidä) tätä portaalia.<br />Klikkaamalla tätä linkkiä avautuu lomake ponnahdusikkunaan. Siinä voit lisätä, poistaa ja liikutella alueita.<br />Lisäohjeita löytyy lomakkeella.<br />";
$pgv_lang["mygedview_message_help"]	= "~VIESTIT ALUE ~<br />Täältä löydät muiden käyttäjien tai ylläpitäjän lähettämät viestit.<br />Voit itsekin lähettää viestejä muille käyttäjille ja ylläpitäjälle.<br />PhpGedView sähköpostijärjestelmässä yksityisyytesi on suojattu eivätkä muut näe sähköpostiosoitettasi.<br /><br />Avataksesi viestin klikkaa viestin aihetta tai \"+\"-merkkiä sen vieressä. Voit poistaa useita viestejä rastittamalla niiden vieressä olevat ruudut ja klikkaamalla \"Poista merkityt viestit\" painiketta.<br />";
$pgv_lang["mygedview_favorites_help"]	= "~SUOSIKKINI ALUE~<br />Suosikkini toimii kuten kirjanmerkki.<br />Jos sinulla on joku erityinen henkilö, jota haluat seurata, mene hänen henkilösivulleen ja valitse \"Lisää suosikkeihini\" suosikkien alasvetovalikosta.<br />Kyseinen henkilö on nyt saanut kirjanmerkin ja lisätty suosikkiluetteloosi.<br />Pääset nyt suoraan kyseisen henkilön henkilösivulle kaikilta palvelun sivuilta valitsemalla hänen nimensä otsikkoalueen \"Suosikit\" alasvetovalikosta.<br /><br />Tilan säästämiseksi alueella näkyy vain rajoitettu määrä tietoa. Nimilaatikon vieressä on suurennuslasi, jota klikkaamalla saat enemmän tietoa. Oikealla puolella näkyy myös valikko, josta pääset enemmän tietoa sisältäville sivuille ja kaavioihin.<br />";
$pgv_lang["mygedview_myjournal_help"]	= "~PÄIVÄKIRJANI ALUE ~<br />Voit käyttää tätä päiväkirjaa muistiinpanojen (tai muistutusten) kirjoittamiseen omaan tarpeeseesi.<br />Muistiinpanot säilyvät seuraaviin käynteihisi sivustolla.<br /><br />Nämä muistiinpanot eivät näy muille.<br />";
$pgv_lang["mygedview_welcome_help"]	= "~TERVETULOA ALUE ~<dt>Tämä alue näyttää:</dt><dd>- Nykyisen GEDCOM-tiedoston</dd><dd>- Päivän ja ajan</dd><dd>- Linkit seuraaviin kohteisiin:</dd><dd> - - #pgv_lang[myuserdata]#</dd><dd>- - #pgv_lang[my_pedigree]# (katso huomautus)</dd><dd>- - #pgv_lang[my_indi]# (katso huomautus)</dd><dd>- - #pgv_lang[customize_page]#</dd><br /><b>Huomautus</b><br />Näet linkit  \"Tietoni\" ja \"Esivanhempani\" vain jos sinulla on tietue kyseisessä GEDCOM-tiedostossa.<br />Joten jos sinulla on tietue yhdessä GEDCOM-tiedostossa näet linkit  \"Tietoni\" ja \"Esivanhempani\", mutta jos tietueet puuttuvat toisesta GEDCOM-tiedostosta, ei kyseisiä linkkejä ole näkyvissä.<br />";

//-- Pedigree-page
$pgv_lang["help_pedigree.php"]		= "~ESIVANHEMPANI SIVU~<br /><br /><br />Useimmat käyttäjät ja vierailijat tietävät, mikä on esipolvitaulu, mutta tässä silti vähän tietoa esipolvitaulustamme:<br />Esipolvitaulu on luettelo kaikista lähtöhenkilön esivanhemmista.<br />Kun tulet tälle sivustolle, on lähtöhenkilö kaikkein vasemmanpuoleisin henkilö. (kun kirjaudut sisälle, voit valita oman lähtöhenkilösi). Kaikki esivanhemmat tarkoittavat isää, äitiä, heidän isiään ja äitejään jne.<br /><br />Tällä sivulla näet esivanhemmat kuvaajana. Sinun ei tarvitse selata tekstisivuja löytääksesi esivanhempasi. Kaikki henkilöt näytetään nimiruuduissa näytöllä.<br /><br />* NIMIRUUDUT ESIPOLVITAULUSSA<br />Mikäli esipolvitaulu on asetettu näyttämään yksityiskohtia, näkyvät henkilön nimi sekä syntymä- ja kuolinpäivä.<br />Kun klikkaat henkilön nimeä, avautuu henkilösivu.<br />Kun \"näytä yksityiskohdat\" on kytketty päälle, näkyy nimiruudussa esipolvi-ikoni ja suurennuslasi-ikoni.<br /><br />* ESIPOLVI-IKONI NIMIRUUDUSSA<br />Kun klikkaat tai osoitat ikonia, avautuu pieni alavalikko.<br />Esi- tai jälkipolvitaulukon valinta vastaa päävalikon valintaa sillä erotuksella, että nyt lähtöhenkilö vaihtuu nimiruudussa olevaksi henkilöksi. Lisäksi näkyy \"Perhe puolisoineen\". Näet avio/avopuolison nimen sekä lasten nimet.<br />Kaikki nimet ovat klikattavissa.<br /><br />* SUURENNUSLASI NIMIRUUDUSSA<br />Sivuston asetuksista riippuen sinun on joko osoitettava tai klikattava sitä.<br />Tämä suurentaa nimiruudun, jolloin siinä näkyy enemmän tietoja.<br />Näet enemmän päivämääriä ja tapahtumia. Nimet ovat klikattavissa.<br /><br />* NUOLET<br />Kaikkein vasemmanpuoleisimman nimiruudun vasemmalla puolella tai oikeanpuolimmaisimman nimiruudun oikealla puolella voi olla nuoli.<br />Klikkaamalla tätä näyttö \"siirtyy\" nuolen suuntaan.<br /><br />Lisäohjeita saa klikkaamalla kysymysmerkkiä <b>?</b> ruudun tai linkin vieressä.";
$pgv_lang["show_full_help"]			= "~NÄYTÄ TAI PIILOTA YKSITYISKOHDAT~<br /><br />Tällä vaihtoehdolla voit joko näyttää tai piilottaa kaikki yksityiskohdat nimiruudussa.<br />Kun yksityiskohdat on piilotettu, näytölle mahtuu useampia ruutuja.<br /><br />Mikäli olet piilottanut yksityiskohdat, voit saada ne näkyviin, mikäli suurennuslasi on kytketty päälle normaalinäkymässä.<br />Se taas riippuu siitä, miten ylläpitäjä on konfiguroinut ohjelman.<br />Jos tavallisesti joudut klikkaamaan suurennuslasia lähentääksesi kohdetta, voit myös paljastaa yksityiskohdat klikkaamalla nimiruutua.<br />Mikäli lähennät kohdetta pelkästään osoittamalla suurennuslasia, homma toimii samalla tavoin osoittamalla \"yksinkertaista\" ruutua.<br />";
$pgv_lang["talloffset_help"]			= "~SIVUN SUUNTAUS~<br /><br />Tällä vaihtoehdolla määrität sivun suuntauksen.<br />Suuntauksen vaihtaminen saattaa kannattaa mikäli haluat tulostaa näytön tai näytön muoto on epätavallinen. Valitsemalla pystysivun saat korkeamman sukupuun jolloin 4 sukupolvea mahtuu samalle sivulle. Vaakasivulla saat aikaan leveämmän sukupuun.";
$pgv_lang["rootid_help"]			= "~UUSI LÄHTÖHENKILÖ~<br /><br />Mikäli haluat näyttää sukupuun, jossa on uusi lähtöhenkilö, voit tähän ruutuun kirjoittaa hänen ID-tunnuksensa.<br />Mikäli et tiedä henkilön ID-tunnusta, käytä <b>>Hae ID<</b> linkkiä.<br /><br /><b>ID-TUNNUS</b><br /> PhpGedView-ohjelmassa käytetty ID-tunnus ei ole sama kuin henkilötunnus!<br />ID-tunnus on luku, jota käytetään GEDCOM-tiedostossa ja jonka sukututkimusohjelma luo luodessaan GEDCOM-tiedoston!";
$pgv_lang["PEDIGREE_GENERATIONS_help"]	= "~SUKUPOLVIEN LUKUMÄÄRÄ~<br /><br />Tässä voit määrittää tällä sivulla näytettävien sukupolvien lukumäärän.<br />Sinulle sopiva lukumäärä riippuu näytön koosta ja näytetäänkö yksityiskohdat vai ei.<br />";

//-- LOGIN-page
$pgv_lang["login_page_help"]			= "~SISÄÄNKIRJAUTUMISSIVU~<br /><br />Tällä sivulla voit kirjautua järjestelmään, pyytää uutta salasanaa tai uutta käyttäjätiliä.<br />";
$pgv_lang["username_help"]			= "~KÄYTTÄJÄTUNNUS~<br /><br />Tähän ruutuun kirjoitat käyttäjätunnuksesi.<br />Huomaa ero isojen ja pienten kirjainten välillä!<br />";
$pgv_lang["password_help"]			= "~SALASANA~<br /><br />Tähän ruutuun kirjoitat salasanasi.<br />Huomaa ero isojen ja pienten kirjainten välillä!<br />";
$pgv_lang["login_buttons_help"]		= "~SISÄÄNKIRJAUTUMISPAINIKKEET~<br /><br />Tässä näkyy kaksi painiketta järjestelmään kirjautumiseksi.<br />Sivu jolle joudut riippuu klikkaamastasi painikkeesta sen jälkeen kun olet antanut käyttäjätunnuksen ja salasanan.<br /><br />* <b>#pgv_lang[login]#</b> painike<br />Jos klikkaat tätä painiketta, palaat sille sivulle, jolta lähdit<br />Siis jos klikkasit \"#pgv_lang[login]#\" kun olit esipolvisivulla palaat sille sivulle.<br /><br />* <b>#pgv_lang[admin]#</b> painike<br />Jos sinulla on ylläpito-oikeudet, voit klikata tätä päästäksesi suoraan pääylläpitosivulle.";
$pgv_lang["login_buttons_aut_help"]		= "~AUTENTIKOINTITILA~<br /><br />SISÄÄNKIRJAUTUMISPAINIKKEET<br /><br />Tässä näkyy kaksi painiketta järjestelmään kirjautumiseksi.<br />Sivu jolle joudut riippuu klikkaamastasi painikkeesta sen jälkeen kun olet antanut käyttäjätunnuksen ja salasanan.<br /><br />* <b>#pgv_lang[login]#</b>-painike<br />Jos klikkaat tätä painiketta, kirjaudut järjestelmään ja joudut suoraan omalle GedView-sivullesi, jossa muokkaat asetuksiasi, lisäät tai muokkaat suosikkejasi, luet ja lähetät viestejä jne.<br /><br /><b>#pgv_lang[admin]#</b>-painike<br />Jos sinulla on ylläpito-oikeudet, voit klikata tätä päästäksesi suoraan ylläpidon pääsivulle.";
$pgv_lang["new_password_help"]		= "~PYYDÄ UUSI SALASANA~<br />Jos olet unohtanut salasanasi, voit klikata tätä linkkiä pyytääksesi uuden salasanan.<br />Pääset sivulle \"Unohtunut salasana\".";
$pgv_lang["new_user_help"]			= "~PYYDÄ UUSI KÄYTTÄJÄTILI~<br /><br />Mikäli vierailet tällä sivulla ja haluat käyttäjätilin, klikkaa tätä linkkiä.<br />Pääset \"rekisteröitymissivulle\".";
$pgv_lang["mygedview_login_help"]		= "Päästäksesi OmaGedView-portaaliin, sinun on rekisteröidyttävä järjestelmään.<br /><br />OmaGedView-portaalin avulla voit merkitä kirjanmerkillä suosikkihenkilösi, pitää käyttäjän päiväkirjaa, hallita viestejä, nähdä muut kirjautuneet käyttäjät sekä räätälöidä kokemuksiasi PhpGedView:ssä.<br /><br />Kirjoita käyttäjätunnus ja salasana ao. kenttiin kirjautuaksesi OmaGedView-järjestelmään.";
$pgv_lang["new_user_firstname_help"]	= "~#pgv_lang[firstname]#~<br /><br />Tähän kenttään kirjoitat etunimesi<br /><br />Meidän on tiedettävä etu- ja sukunimesi, jotta voimme päätellä voitko saada käyttäjätilin tähän palveluun ja mitä oikeuksia sinulle voi antaa. Nimet näkyvät muille kirjautuneille perheenjäsenille ja käyttäjille<br /><br />";
$pgv_lang["new_user_lastname_help"]	= "~#pgv_lang[lastname]#~<br /><br /> Tähän kenttään kirjoitat sukunimesi.<br /><br />Meidän on tiedettävä etu- ja sukunimesi, jotta voimme päätellä voitko saada käyttäjätilin tähän palveluun ja mitä oikeuksia sinulle voi antaa. Nimet näkyvät muille kirjautuneille perheenjäsenille ja käyttäjille<br /><br />";
$pgv_lang["register_info_01"]			= "~PYYDÄ UUSI KÄYTTÄJÄTILI~<br /><br />Tässä palvelussa yleisesti näytettävän tiedon määrä saattaa riippua sovellettavista turvallisuusmääräyksistä. Monet henkilöt eivät halua tietojaan näkyville internetissä. Henkilötietoja saatetaan käyttää roskapostin lähettämiseen tai henkilötietovarkauksiin. <br /><br />Tälle sivustolle pääsevät ne henkilöt, joilla on käyttäjätili. Kun ylläpitäjä on varmentanut ja hyväksynyt hakemuksesi, voit kirjautua sisään. <br /><br />Mikäli sukulaisuuden yksityisyysasetus on aktivoitu pääset käsiksi vain omien lähisukulaistesi tietoihin kirjauduttuasi järjestelmään. Ylläpitäjä saattaa myös antaa tietyille henkilöille luvan tietokannan muokkaukseen niin, että he voivat muuttaa tai lisätä tietoja.<br /><br />Mikäli tarvitset enemmän tukea, käytä oheista linkkiä ottaaksesi yhteyttä ylläpitäjään.";
$pgv_lang["register_info_02"]			= "~PYYDÄ UUSI KÄYTTÄJÄTILI~<br /><br />Tässä palvelussa yleisesti näytettävän tiedon määrä saattaa riippua sovellettavista turvallisuusmääräyksistä. Monet henkilöt eivät halua tietojaan näkyville internetissä. Henkilötietoja saatetaan käyttää roskapostin lähettämiseen tai henkilötietovarkauksiin. <br /><br />Tälle sivustolle pääsevät vain ne henkilöt, joille on myönnetty <u>käytölupa</u>. Kun ylläpitäjä on varmentanut ja hyväksynyt hakemuksesi, voit kirjautua sisään ja katsoa yksityisiä tietoja.<br /><br />Mikäli sukulaisuuden yksityisyysasetus on aktivoitu pääset käsiksi vain omien lähisukulaistesi tietoihin kirjauduttuasi järjestelmään. Ylläpitäjä saattaa myös antaa tietyille henkilöille luvan tietokannan muokkaukseen niin, että he voivat muuttaa tai lisätä tietoja.<br /><br />Mikäli tarvitset enemmän tukea, käytä oheista linkkiä ottaaksesi yhteyttä ylläpitäjään.";
$pgv_lang["register_info_03"]			= "~PYYDÄ UUSI KÄYTTÄJÄTILI~<br /><br />Tässä palvelussa yleisesti näytettävän tiedon määrä saattaa riippua sovellettavista turvallisuusmääräyksistä. Monet henkilöt eivät halua tietojaan näkyville internetissä. Henkilötietoja saatetaan käyttää roskapostin lähettämiseen tai henkilötietovarkauksiin. <br /><br />Tälle sivustolle pääsevät <u>vain perheenjäsenet</u>. Kun ylläpitäjä on varmentanut ja hyväksynyt hakemuksesi, voit kirjautua sisään ja katsoa yksityisiä tietoja.<br /><br />Mikäli sukulaisuuden yksityisyysasetus on aktivoitu pääset käsiksi vain omien lähisukulaistesi tietoihin kirjauduttuasi järjestelmään. Ylläpitäjä saattaa myös antaa tietyille henkilöille luvan tietokannan muokkaukseen niin, että he voivat muuttaa tai lisätä tietoja.<br /><br />Mikäli tarvitset enemmän tukea, käytä oheista linkkiä ottaaksesi yhteyttä ylläpitäjään.";

//-- Descendancy-page
$pgv_lang["help_descendancy.php"]		= "~JÄLKIPOLVISIVU~<br /><br />Tämä sivu näyttää henkilön jälkeläiset.<br />Voit valita lähtöhenkilön jälkipolvikaavioon tällä sivulla, tai voit siirtyä tälle sivulle klikkaamalla \"Jälkipolvet\"-kaaviota toisella sivulla.<br />Klikkaa ylös-nuolta liikkuaksesi ylöspäin pitkin sukupuuta. Klikkaa kaavioikonia henkilöruudussa tehdäksesi hänestä lähtöhenkilön sukupuussa.";
$pgv_lang["desc_rootid_help"]		= "#pgv_lang[rootid_help]#";
$pgv_lang["desc_generations_help"]		= "#pgv_lang[PEDIGREE_GENERATIONS_help]#";
$pgv_lang["help_lifespan.php"]		= "~ELINKAARIKAAVIO~<br /><br />Tässä kaaviossa näytytään yksi tai useampi henkilö vaakasuoralla aikajanalla. Siinä näkyy, miten eri henkilöiden elämänkaari asettuu toisiinsa nähden.<br /><br />Voit lisätä henkilöitä yksitellen tai perheryhminä tai ID-tunnuksien perusteella. Edellinen luettelo jää muistiin lisätessäsi uuden henkilön kaavioon. Voit tyhjentää kaavion koska tahansa klikkaamalla <b>Tyhjennä kaavio</b>-painiketta.<br /><br />Voit myös lisätä henkilöitä kaavioon hakemalla heitä aikajakson tai paikan perusteella.<br /><br />";
$pgv_lang["lifespan_add_person_help"]	= "#pgv_lang[add_person_help]#~Sisällytä ydinperhe-valintaruutu~<br />Sisällytä ydinperhe on oletusarvoisesti rastitettu. Jätä rastitetuksi nähdäksesi isän, äidin, puolison, sisarukset ja lapset aikajanalla. Poista valinta, mikäli et halua nähdä ydinperhettä.";
//-- show_full is used from pedigree

//-- Time line-page
$pgv_lang["help_timeline.php"]		= "~AIKAJANASIVU~<br /><br /> Tällä sivulla voit näyttää yhden tai useamman henkilön aikajanalla.<br />Tällä tavoin voit esimerkiksi visualisoida kahden tai useamman henkilön tilan tietyssä pisteessä aikajanalla.<br /><br />Mikäli klikkasit Aikajana-linkkiä toisella sivulla, tulet näkemään kyseisen henkilön aikajanalla.<br />Mikäli klikkaat Aikajana-linkkiä valikossa, joudut syöttämään aluksi jonkun henkilön ID-tunnuksen.";
$pgv_lang["add_person_help"]		= "~LISÄÄ HENKILÖ KAAVIOON~<br /><br /> Aikajanalla voi olla useampia henkilöitä.<br />Lisää tähän kenttään henkilön ID.<br />Ellet tiedä sitä, käytä linkkiä \"hae ID\".";
$pgv_lang["remove_person_help"]			= "~POISTA HENKILÖ KAAVIOSTA~<br /><br /> Klikkaa tätä linkkiä poistaaksesi henkilön aikajanalta.";
$pgv_lang["show_age_marker_help"]		= "~NÄYTÄ IKÄMERKITSIN~<br /><br /> Klikkaamalla tätä ruutua saat esille ikämerkitsimen, jota voit vetää aikajanaa pitkin.<br />Tämä on mukava työkalu tarkistaaksesi kyseisen henkilön iän tietyn tapahtuman aikoihin.<br />Kullekin henkilölle kaaviossa voit aktivoida tai sulkea oman ikämerkitsimen.";
$pgv_lang["timeline_control_help"] 		= "~ELINKAARIOHJAIMET~<br /><br />~NOPEUS~<br />Klikkaa pudotusvalikkoa muuttaaksesi aikajanan vierintänopeutta.<br /><br />~Aloitusvuosi~<br />Kirjoita vuosiluku, josta tapahtumien haku alkaa.<br /><br />~Lopetusvuosi~<br />Kirjoita vuosiluku, johon tapahtumien haku loppuu.<br /><br />~Hae~<br />Klikkaa hae-painiketta aloittaaksesi haun aloitus- ja lopetusvuosien ajanjakson välillä.<br /><br />";

//-- Relationship-page
$pgv_lang["help_relationship.php"]		= "~SUKULAISUUSSIVU~<br /><br /> Tällä sivulla saa näkyviin kahden henkilön sukulaisuussuhteen.<br />Ei vain verisukulaisuus vaan ihan mikä muukin sukulaisuussuhde saadaan esille.";
$pgv_lang["relationship_id_help"]		= "~HENKILÖIDEN 1 ja 2 ID~<br /><br />Mikäli olet siirtynyt tälle sivulle muualta klikkaamalla esimerkiksi linkkiä \"Sukulaisuus minuun\", tulet tässä näkemään kyseisen kahden henkilön välisen sukulaisuussuhteen. <br />Muuten sinun tulee antaa kummankin henkilön ID selvittääksesi heidän välisensä sukulaisuussuhteen.<br />Ellet tiedä niitä, käytä linkkiä \"hae ID\".";
$pgv_lang["next_path_help"]			= "~HAE TOINEN REITTI~<br /><br />Voit klikata tätä linkkiä nähdäksesi, onko kahden henkilön välillä muuta suukaukaisuussuhdetta<br />Edellinen/set reitit saa näkyviin klikkaamalla kyseisen numeroidun reitin linkkiä.";
$pgv_lang["follow_spouse_help"]		= "~TARKISTA SUKULAISUUS MYÖS AVIOLIITON KAUTTA- VALINTARUUTU~<br /><br />Kun valintaruutu on <b>rastittamatta</b>, sukulaisuussuhde tarkistetaan vain verisukulaisten välillä.<br />Mikäli se on rastitettu, tarkistetaan myös avioliiton kautta muodostunut sukulaisuussuhde. Rastittamalla ruutu löytyy luultavasti useampia sukulaisuussuhteita.";
$pgv_lang["line_up_generations_help"]	= "~ASETA SAMA SUKUPOLVI RIVIIN - VALINTARUUTU~<br /><br />Kun tämä valintaruutu on rastitettu, tulevat saman sukupolven henkilöt asettumaan samalle vaakasuoralle tällä sivulla. Mikäli ruutu ei ole rastitettu, tulee jokainen sukupolvi näkymään allekkain riippumatta siitä, onko kyseessä vanhempien tai lasten välinen sukulaisuussuhde.";
$pgv_lang["oldest_top_help"]          		= "~NÄYTÄ VANHIN HUIPULLA - VALINTARUUTU~<br /><br /> Kun tämä valintaruutu on rastitettu, näkyy vanhin henkilö ylimpänä.<br />Rastittamaton ruutu näyttää nuorimman ylimpänä.<br /><br />Huom! Tämä vaihtoehto toimii vain, mikäli <i>#pgv_lang[line_up_generations]#</i> on rastitettu.";

//-- Ancestry-page
$pgv_lang["help_ancestry.php"]		= "~#pgv_lang[ancestry_chart]# sivu~<br /><br />Esipolvikaavio on hyvin samantapainen kuin <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, mutta siinä on enemmän yksityiskohtia ja vaihtoehtoisia <a href=\"?help=chart_style_help\">#pgv_lang[chart_style]#</a> näyttöjä.<br /><br />Jokainen esipolvi näytetään yhdessä ainutkertaisen numeron kanssa, joka on laskettu <i>Sosa-Stradonitz</i> järjestelmästä:<br />- parillinen luku miehille (lapsi*2)<br />- pariton luku naisille (aviomies+1) paitsi <big>1</big><br /><br />Esimerkki: <big>7</big> on <big>6</big>:n aviovaimo, <big>3</big>:n äiti sekä <big>14</big>:n ja <big>15</big>:n tytär.";
$pgv_lang["box_width_help"]			= "~#pgv_lang[ancestry_chart]# laatikon leveys~<br /><br />Laatikon leveyden voit tässä muuttaa välillä 50 - 100%.<br />Normaali arvo on 100%: kukin laatikko on noin 270 pikseliä leveä.";
$pgv_lang["chart_style_help"]			= "~#pgv_lang[ancestry_chart]# tyyli~<br /><br /><dl><dt>#pgv_lang[ancestry_list]#</dt><dd> Pystysuora sukupuu, jossa on kutistettavat tai laajennettavat perheet.</dd><dt>#pgv_lang[ancestry_booklet]#</dt><dd>. Yksi perhe sivulla joka sisältää vanhemmat, isovanhemmat ja kaikki kirjatut lapset.<br />Tämä muoto on helppo tulostaa ja antaa sukulaisille.</dd></dl>";

//-- Fan chart-page
$pgv_lang["help_fanchart.php"]		= "~#pgv_lang[fan_chart]# sivu~<br /><br />Viuhkakaavio on hyvin samanlainen kuin <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, mutta graafisempi.<br /><br />Lähtöhenkilö näytetään keskellä, hänen vanhempansa ensimmäisessä renkaassa, isovanhemmat seuraavassa jne...<br /><br />Syntymä- ja kuolinvuosi sijaitsevat nimen alla, jos ne ovat tiedossa.<br /><br />Klikkaamalla henkilöä kaaviossa asettaa hänet keskelle. Keskellä olevan henkilön lähellä on nuoli, joka avaa ruudun, josta voi siirtyä lähtöhenkilön lapseen (tai sisarukseen) kuten <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>.";
$pgv_lang["fan_width_help"]			= "~#pgv_lang[fan_chart]# leveys~</b><br /><br />Tässä voit muuttaa viuhkakaavion leveyden välillä 50 - 300%. Normaali arvo on 100%: kaavio on noin 640 pikseliä leveä.";
$pgv_lang["fan_style_help"]			= "~#pgv_lang[fan_chart]# tyyli~<br /><br /><dl><dt>1/2</dt><dd>Puoliympyrän (180 astetta) muotoinen viuhkakaavio</dd><dt>3/4</dt><dd>Kolme-neljännesympyrän (270 astetta) muotoinen kaavio tai 'enkelin siipi'</dd><dt>4/4</dt><dd>Täysympyrän (360 astetta) muotoinen kaavio</dd></dl>";

//-- Indilist-page
$pgv_lang["help_indilist.php"]			= "~HENKILÖLUETTELOSIVU~<br /><br />Tällä sivulla näytetään luettelo henkilöistä.<br /><br />Nimet näytetään sukunimi ensimmäisenä ja lajiteltuna aakkosjärjestyksessä.<br />Näkymä riippuu:<br /><b>1.</b> Kirjaimesta, jota klikkasit<br /><b>2.</b> Klikkasitko \"Ohita\" tai \"Näytä\" sukunimiluettelo.<br /><br />Lisätietoa saat klikkaamalla <b>?</b> kohteiden perässä.";
$pgv_lang["alpha_help"]			= "~AAKKOSLUETTELO~<br /><br />Klikkaamalla kirjainta aakkosluettelossa saat luettelon nimistä, jotka alkavat klikkaamallasi kirjaimella.<br />Luettelon toiseksi viimeisenä kohteena voi olla <b>(tuntematon).</b><br />Se näkyy mikäli GEDCOM-tiedostossa on henkilöitä, joiden nimeä ei ole lisätty kyseisen henkilön GEDCOM-tietueeseen, tai jos nimi ei sisällä merkkejä tuetuista kielistä.<br />Siis tuntematon henkilö.<br /><br /><b>Huom!</b> Mikäli henkilön sukunimi on tallennettu GEDCOM-tietueeseen muodossa Nn, NN, Tuntematon tai N.N. niitä <b>ei</b> näytetä, jos klikkaat <b>Tuntematon</b>. Ne näkyvät klikkaamalla <b>N</b> tai <b>T</b>. Tämä siksi, että ohjelma tarkistaa vain onko henkilön sukunimi olemassa hänen GEDCOM-tietueessaan.<br /><br />Aakkosluettelon lopussa on \"<b>KAIKKI</b>\", jota klikkaamalla näkyvät kaikki GEDCOM-tiedostossa olevat sukunimet.<br /><br /><b>Puuttuvat kirjaimet</b><br />Mikäli aakkosluettelosta puuttuu jokin kirjain, merkitsee se vain sitä, että kyseisellä kirjaimella alkavia sukunimiä ei ole tietokannassa.";
$pgv_lang["name_list_help"]			= "~NIMILUETTELO~<br /><br />Tämä ruutu näyttää joko sukunimiluettelon tai luettelon täydellisistä nimistä.<br />Kummassakin tapauksessa sukunimiluettelo alkaa sillä kirjaimella, jota klikkasit aakkosluettelossa, ellet klikannut \"KAIKKI\".<br /><br />Riippuen ruudun alla olevan linkin tilasta, näytetään joko sukunimiluettelo tai luettelo täydellisistä nimistä.";
$pgv_lang["skip_sublist_help"]		= "~OHITA SUKUNIMILUETTELO~<br /><br />Vakioasetuksena on pelkästään sukunimien näyttäminen klikattuasi kirjainta aakkosluettelossa.<br />Mikäli klikkaat tätä linkkiä, sukunimiluettelo ohitetaan, ja kaikki nimet näytetään kerrallaan.";

//-- Families-page
$pgv_lang["help_famlist.php"]			= "~PERHELUETTELO~<br /><br />Tällä sivulla näkyy luettelo perheistä.<br /><br />Ne on lueteltu sukunimen mukaan aakkosjärjestyksessä.<br />Näkymä riippuu: <br /><b>1.</b> Kirjaimesta, jota klikkasit <br /><b>2.</b> Klikkasitko \"Ohita\" tai \"Näytä\" sukunimiluettelo.<br /><br /> Voit hakea sekä aviomiehen että aviovaimon sukunimen perusteella, kumpikin on luettelossa.<br /><br />Lisätietoa saat klikkaamalla <b>?</b> kohteiden perässä.";
$pgv_lang["help_family.php"]			= "~PERHEITÄ KOSKEVIEN YKSITYISKOTAISTEN TIETOJEN SIVU~<br /><br />Tällä sivulla näkyy aiemmalla sivulla valitsemaasi perhettä koskevat yleiset tiedot.<br />Ylhäältä alaspäin mennessä näkyvät henkilötietolaatikot seuraavasti:<br />Aviomies ja hänen vanhempansa, aviovaimo ja hänen vanhempansa, ja lapset.<br /><br />Henkilötietoruutujen asettelu ja sisältö ovat samanlaiset kuin esipolvi- ja jälkipolvisivuilla.<br />Vanhempien ruudun oikealla puolella voi olla nuoli, mikäli tiedostossa on enemmän esivanhempia. Klikkaamalla tätä nuolta, siirryt yhtä sukupolvea ylemmäksi uudelle perhesivulle, missä vanhemmat ovat nyt aviomies ja aviovaimo.<br />Oikealla puolella nimiruudun <i>sisällä</i> voi olla suurennuslasi, jota klikkaamalla saa lisätietoa henkilöstä. Näpäyttämällä nimeä, siirryt kyseisen henkilön henkilösivulle. Oikealla puolella näkyy myös pieni valikko, joka johtaa enemmän tietoa ja kaavioita sisältäville sivuille.<br /><br />Perheen ryhmätieto näyttää kaikki tiedot tästä perheestä, kuten avioliitot, multimediakohteet ja muistiinpanot. Klikkaamalla paikkaa avautuu paikkaluettelo, missä kaikki muut paikkaan kytketyt perheet ja henkilöt näytetään. Klikkaamalla päivämäärää avautuu päiväkalenteri, jossa näkyy tämän päivän ja kuukauden kaikki tapahtumat menneisyydessä. Myös multimediakohdetta voi klikata, jolloin aukeaa kohteen näyttävä ikkuna. Klikkaamalla lähdelinkkiä näytetään yksityiskohdat lähdesivulla.<br /><br />Lasten nimiruudun alla on linkki \"Lisää lapsi perheeseen\".<br />Lapsen nimiruudun vieressä on \"perheen ryhmätieto\".<br />Mikäli sinulla on riittävät oikeudet, voit tässä muuttaa, lisätä ja poistaa tietoja.<br /><br />Näytön oikealla reunalla on kuvakkeita ja linkkejä, joista voi tehdä seuraavaa (mikäli se on sallittu):<br /><b>Näytä GEDCOM-tietue</b> jolloin tiedot näkyvät GEDCOM-muodossa,<br /><b>Lisää leikekoriin</b>, jolloin voit tallentaa tiedon leikekoriin myöhempää omaan sukututkimusohjelmaasi latausta varten,<br /><b>Näytä pariskuntaa aikajanalla</b>, joka vie aikajanasivulle näyttäen pariskunnan kaikki tiedot aikajanalla.<br /><br />#pgv_lang[more_help]#";
$pgv_lang["add_child_help"]			= "~LISÄÄ LAPSI PERHEESEEN~<br /><br />Klikkaamalla tätä linkkiä, voi lisätä lapsen tähän perheeseen.<br />Tämä on yksinkertaista: klikkaa linkkiä ja täytä kentät ponnahdusikkunassa.<br />";
$pgv_lang["show_fam_gedcom_help"]	= "~NÄYTÄ GEDCOM-TIETUE~<br /><br />Klikkaamalla tätä linkkiä, ponnahdusikkunaan ilmestyy tätä perhettä koskevat tiedot GEDCOM-muodossa.";
$pgv_lang["add_fam_clip_help"]		= "~LISÄÄ PERHE LEIKEKORIIN~<br /><br />Klikkaamalla tätä linkkiä voit lisätä GEDCOM-muodossa olevat perheen tiedot leikekoriin. Seuraavalla sivulla voit valita mitkä tiedot tarkalleen haluat lisätä: vain vanhemmat vai vanhemmat ja/tai lapset ja/tai heidän kaikki perillisensä.";
$pgv_lang["show_fam_timeline_help"]	= "~NÄYTÄ PARISKUNTA AIKAJANALLA~<br /><br />Tästä linkistä pääset aikajanasivulle, jossa kaikki tiedot pariskunnasta näytetään aikajanalla.";
//-- same variables as individuals page

//-- Source list-page
$pgv_lang["help_sourcelist.php"]		= "~LÄHDELUETTELOSIVU~<br /><br />Tällä sivulla näytetään lähdeluettelo.<br />Poiketen henkilö- ja perhesivusta tässä ei ole aakkosluetteloa ylhäällä. Tämä siksi, koska lähde voi olla henkilö, jolla on etu- ja sukunimi tai julkinen tietokanta tai laitos jne. Siksi on vaikeata löytää lajittelujärjestys. Lähteiden nimet on lajiteltu aakkosjärjestyksessä siten kun ne on tallennettu GEDCOM-tiedostossa.<br /><br /><b>LÄHTEET</b><br /> Ilman lähteitä ei tietokantaa voi muodostaa, koska kaikki sinne tallennettu tieto on lähde. Lähde voi olla henkilön sukulainen, laitos, julkinen tietokanta jne.<br />Lähde voidaan liittää useaan henkilöön. Toisaalta henkilö voi myös olla liitetty useaan lähteeseen. Jokaiselle tapahtumalle voi olla oma lähteensä, oli sitten kyseessä syntymäaika, ammatti, avioliittoon vihkiminen, lapset jne.";
$pgv_lang["sourcelist_listbox_help"]		= "~LÄHDELUETTELO~<br /><br />Tässä ruudussa näet lähteiden nimet niin kuin ne on tallennettu GEDCOM-tiedostoon.<br />Ne näytetään aakkosjärjestyksessä.<br /><br />Klikkaamalla lähteen nimeä, avautuu lähdesivu, jossa on luettelo kyseiseen lähteeseen liitetyistä henkilöistä tai/ja perheistä.";

//-- Sources-page
$pgv_lang["help_source.php"]			= "~LÄHTEIDEN TIEDOT SIVU~<br /><br />Tällä sivulla näytetään lähdettä koskevat yksityiskohtaiset tiedot. Lähteet ovat erittäin tärkeitä sukututkijoille ja niiden avulla voit seurata toisen tutkijan käyttämää reittiä tiedon lähteille.<br />Tällä sivulla voi olla tietoa lähteen otsikosta, kirjoittajasta, julkaisusta ja sijainnista. Koska lähteitä on useita eri tyyppejä, tiedon määrä vaihtelee lähteittäin.<br /><br />Mikäli lähteeseen on kytketty multimediakohde (kuten skannattu asiakirja), voit katsoa sitä suuremmassa ikkunassa joko klikkaamalla kohdetta tai sen vierellä olevaa nimeä.<br /><br />Lähteen tietojen jälkeen on luettelo kaikista henkilöistä ja perheistä jotka on liitetty tähän lähteeseen. Tämä näyttää kaiken tiedon joka on satu tietystä lähteestä.<br /><br />Tällä sivulla on vielä yksi tai kaksi valikkokuvaketta, mikäli ylläpitäjä on ne kytkenyt päälle:<br /><b>Näytä GEDCOM-tietue</b>, joka näyttä tiedon GEDCOM-muodossa.<br /><b>Lisää leikekoriin</b>, jolloin voit tallentaa tiedon leikekoriin myöhempää omaan sukututkimusohjelmaasi latausta varten.<br /><br />Lisätietoa saat klikkaamalla <b>?</b> kohteiden perässä.";
$pgv_lang["sources_listbox_help"]		= "~TÄHÄN LÄHTEESEEN VIITTAAVAT TIETUEET~<br /><br />Tässä ruudussa on lueteltu tähän lähteeseen viittaavat henkilöt ja perheet.<br />Nimet näytetään aakkosjärjestyksessä.<br /><br />Klikkaamalla nimeä, siirryt kyseisen henkilön tai perheen sivulle.";
$pgv_lang["show_source_gedcom_help"]	= "~NÄYTÄ GEDCOM-TIETUE~<br /><br />Klikkaamalla tätä linkkiä näytetään ponnahdusikkunassa tiedot lähteestä GEDCOM-muodossa.";
$pgv_lang["add_source_clip_help"]		= "~LISÄÄ LÄHDE LEIKEKORIIN~<br /><br />Klikkaamalla linkkiä lisätään leikekoriin tiedot lähteestä GEDCOM-muodossa.";
$pgv_lang["delete_source_help"]		= "~POISTA LÄHDE GEDCOM-TIEDOSTOSTA~<br /><br />Klikkaamalla tätä vaihtoehtoa merkitset tämän lähteen poistettavaksi GEDCOM-tiedostosta.<br />Mitä se merkitsee?<br />Oletetaan, että sinulla on hyvä syy poistaa lähde. Klikkaamalla linkkiä aukeaa ponnahdusikkuna, jossa kysytään oletko varma vai haluatko perua.<br /><br />Jos jatkat poistamista, saattaa kestää jonkin aikaa ennen kuin uusi ponnahdusikkuna aukeaa ilmoittaen poistamisen tapahtuneen.<br /><br />Kun jatkat vierailuasi sivustolla, havaitset, että lähde on edelleen näkyvissä ja käytettävissä kuten aiemmin.<br /><br />Tämä <b>ei</b> ole virhe. Ylläpitäjä saa viestin muutoksesta GEDCOM-tiedostossa ja että olet poistanut lähteen.<br />Ylläpitäjä hyväksyy tai hylkää muutokset. Vasta sen jälkeen tapahtumaa ei voi perua.<br />Ongelmatapauksissa ylläpitäjä ottaa sinuun yhteyttä.";

//-- Persons per Place-page
$pgv_lang["help_placelist.php"]		= "~PAIKKAHIERARKIA~<br />(tai henkilöt paikkaa kohti)<br /><br />Tällä sivulla näytetään luettelo paikoista ja henkilöistä tai perheistä, jotka on kytketty paikkaan.<br /><br />Mikäli henkilön tai perheen ja jonkun tapahtuman välillä on yhteyttä tietyllä paikalla, ohjelma löytää sen.<br /><br />Tulos näytetään kahdessa sarakkeessa:<br />toinen henkilöille ja toinen perheille.<br /><br />#pgv_lang[more_help]#";
$pgv_lang["ppp_default_form_help"]		= "~PAIKKOJEN JÄRJESTYSFORMAATTI~<br /><br /><b>OLETUSJÄRJESTYS</b><br />Tämä tarkoittaa, että GEDCOM-tiedostossa ei ole erityistä paikkajärjestystä.<br />Siinä tapauksessa käytetään vakioformaattia.<br /><br />Mikäli GEDCOM-tiedostosta löytyy toinen formaatti, se näytetään (...) merkkien välissä rivin lopussa.";
$pgv_lang["ppp_match_one_help"]		= "~PAIKKOJEN JÄRJESTYSFORMAATTI~<br /><br /><b>GEDCOMJÄRJESTYS</b><br />Paikat oletetaan koodatuiksi siinä järjestysformaatissa joka on GEDCOM-tiedostossa.<br />Se ohittaa vakiojärjestyksen jota käytetään, kun GEDCOM-tiedostosta ei löydy formaatin kuvaus.";
$pgv_lang["ppp_numfound_help"]		= "~LÖYTYI PAIKKAKYTKENTÖJÄ~<br /><br />Tässä näytetään löydettyjen kytkentöjen lukumäärä.<br />Mikäli vielä näet luettelon paikkoja, merkitsee se että et ole vielä päätynyt alimmalle tasolle.<br />Voit valita haluatko katsoa kaikki paikkaan liitetyt tietueet vai haluatko tarkentaa hakua klikkaamalla toista paikkaa.";
$pgv_lang["ppp_levels_help"]			= "~PAIKKATASOT~<br /><br />Tämä näyttää parhaillaan näkyvät tasot.<br />Luetteloruutu, jossa tasot näkyvät, on ylimmän vasemmanpuoleisen tason alaluettelo.<br /><br />ESIMERKKI:<br />(Oletus)järjestys on: #pgv_lang[default_form]#<br />Mikäli nykyinen taso on \"Ylin taso\", luettelossa näkyvät kaikki GEDCOM-tiedoston maat.<br />Mikäli nykyinen taso on \"USA, Ylin taso\", silloin ruudussa on lueteltu kaikki USA:n osavaltiot.<br />Jne.<br /><br />Klikkaa tasoa palataksesi yhden tai useamman tason verran takaisinpäin.";
$pgv_lang["ppp_placelist_help"]		= "~PAIKKAHIERARKIA~<br /><br />Tässä luettelossa näytetään valitsemasi paikan alapuolella olevat paikat. Ellet ole valinnut paikkaa, näytetään luettelo ylimmän tason paikoista (esim. läänit tai maat).<br />Luettelon nimet ovat klikattavissa.<br />Paikan klikkaaminen toimii kuin suodatin ja pääset yhden askelen alaspäin luettelossa.";
$pgv_lang["ppp_placelist_help2"]		= "~PAIKKALUETTELO~<br /><br />Tässä luettelossa näytetään tähän asti löydetyt paikat.<br />Luettelon nimet ovat klikattavissa.<br />Paikan klikkaaminen toimii kuin suodatin ja pääset yhden askelen alaspäin luettelossa.<br />Vain ollessasi ylimmällä tasolla, nimiluetteloa ei näytetä. Kaikilla alemmilla tasoilla näytetään kaikkien niiden henkilöiden tai perheiden nimet, jotka liittyvät kyseiseen paikkaan.";
$pgv_lang["ppp_view_records_help"]		= "~KATSO KAIKKI TIETUEET~<br /><br /> Klikkaamalla tätä linkkiä luetellaan kaikkien henkilöiden tai perheiden nimet, jotka ovat olleet tekemisissä kyseisen paikan kanssa. Kun olet paikkahierarkian lopussa, näytetään nimet automaattisesti.";
$pgv_lang["ppp_name_list_help"]		= "~NIMILUETTELO~<br /><br />Tämä ruutu näyttää täydellisen luettelon henkilöistä ja/tai perheistä, jotka liittyvät paikkaan.<br /><br />Nimet luettelossa ovat klikattavissa.<br /><br />Kun klikkaat nimeä, pääset kyseisen henkilön tai perheen sivulle.<br /><br />Voit myös vaihtaa valintaasi klikkaamalla luettelon ylintä paikkaa.";

//-- Multimedia-page
$pgv_lang["help_medialist.php"]		= "~MULTIMEDIAKOHDELUETTELO~<br /><br />Tällä sivulla luetellaan kaikki tässä GEDCOM-tiedotossa olevat multimediakohteet (MMK).<br /><br />Jokaisella kohteella on kohteen otsikko tai tiedostonimi, niiden henkilöiden tai perheiden nimet, jotka liittyvät siihen sekä kohteeseen liittyviä muita tietoja.<br /><br />Voit klikata kohteen pienoiskuvaa tai nimeä tai otsikkoa, jolloin tiedoston muodosta riippuen (*.gif tai *.jpg) kuva aukeaa joko PhpGedView sisäiseen katselimeen tai selaimeesi kytkettyyn katselimeen.<br /><br />Klikkaamalla \"Katso\"-linkkiä henkilön tai perheen vieressä, vie ohjelma sinut kyseiselle henkilö- tai perhesivulle.";

//-- Upload Media-page
$pgv_lang["help_uploadmedia.php"]		= "~LÄHETÄ MEDIATIEDOSTO PALVELIMELLE~<br /><br />Tiedoston lähettäminen palvelimelle on yksinkertainen toimenpide ja tässä onkin vain vähän lisätietoa.<br /><br /><b>Pienoiskuva</b><br />Pienoiskuvan tulisi olla noin 100 pikseliä leveä.<br />Tiedostonimen tulee olla sama kuin alkuperäiskuvalla.<br /><br /><b>Lähetys palvelimelle</b><br />Tiedostot lähetetään automaattisesti kansioon <b>#GLOBALS[MEDIA_DIRECTORY]#</b> ja pienoiskuvat kansioon <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b>.<br /><br />#pgv_lang[readme_help]#";

//-- Anniversaries-page
$pgv_lang["help_calendar.php"]		= "~VUOSIPÄIVÄKALENTERI~<br /><br /><ul><li><a href=\"#calendar_general\">Yleistä</a><li><a href=\"#calendar_day\">#pgv_lang[day]#</a><li><a href=\"#calendar_month\">#pgv_lang[month]#</a><li><a href=\"#calendar_year\">#pgv_lang[year]#</a><li><a href=\"#calendar_show\">#pgv_lang[show]# / #pgv_lang[showcal]#</a><li><a href=\"#calendar_sex\">#pgv_lang[sex]#</a><li><a href=\"#calendar_event\">Tapahtuma</a><li><a href=\"#calendar_button\">Valitse tila (painikkeet))</a><li><a href=\"#calendar_tip\">Vihje</a></ul><br /><a name=\"calendar_general\"></a>Vuosipäiväkalenteri näyttää ne henkilöt tai perheet jotka on kytketty tiettyyn tapahtumaan tiettynä päivänä ja/tai kuukautena tai aikajaksona. Siinä on edistyksellinen suodatusjärjestelmä oikean päivämäärän, aikajakson tai tapahtuman valitsemiseksi.<dl><dt><b>Näytä <a href=\"#calendar_day\">päivä</a></b></dt><dd> Tämä näyttää tapahtumat tiettynä päivänä vuosiluvusta riippumatta. Se palauttaa joko yksinkertaisen luettelon henkilöiden tai perheiden nimiä tai kaksisarakkeisen luettelon, jossa henkilöt ovat toisessa ja perheet toisessa sarakkeessa. </dd><dt><b>Näytä <a href=\"#calendar_month\">kuukausi</a></b></dt><dd><b>Kalenterissa</b> henkilöiden ja perheiden nimet näytetään päiväruuduissa. Kalenteri näytetään sellaisen kuin se oli sinä vuonna jonka syötit vuosiruutuun. Kaikki tapahtumat menneisyydestä ilmoittamaasi vuoteen saakka näytetään. Yhdessä valinnan \"<a href=\"#calendar_show\">#pgv_lang[recent_events]#</a>\" kanssa saadaan todenmukainen kuva siitä, millainen kalenteri oli esivanhemmillamme.</dd><dt><b>Näytä <a href=\"#calendar_year\">vuosi</a></b></dt><dd>Tämä valinta näyttää tapahtumat tiettynä vuotena tai vuosina. Se palauttaa joko yksinkertaisen luettelon henkilöiden tai perheiden nimiä tai kaksisarakkeisen luettelon, jossa henkilöt ovat toisessa ja perheet toisessa sarakkeessa.</dd></dl>Kalenterivalikossa näytetään nyt valittu päivä ja kuukausi korostetulla värillä.<br /><br />Luettelossa tai kalenterissa näytettävät nimet ovat klikattavissa.<br />Nimen klikkaaminen vie kyseiselle henkilö- tai perhesivulle, päivämäärän klikkaaminen vie \"Tänä päivänä\"-tilaan, missä näytetään kaikki klikatun päivämäärän päivän ja kuukauden tapahtumat.<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_day\"></a>#pgv_lang[annivers_date_select_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_month\"></a>#pgv_lang[annivers_month_select_help]#<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a> <a name=\"calendar_year\"></a>#pgv_lang[annivers_year_select_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_show\"> </a>#pgv_lang[annivers_show_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_sex\"></a>#pgv_lang[annivers_sex_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_event\"></a>#pgv_lang[annivers_event_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_button\"> </a>#pgv_lang[day_month_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_tip\"> </a>#pgv_lang[annivers_tip_help]#";
$pgv_lang["annivers_date_select_help"]	= "~PÄIVÄMÄÄRÄVALITSIN~<br /><br />\"Valitsintaulukon\" ylin rivi on <b>Päivävalitsin</b>.<br />Sillä valitset päivämäärän.<br />Tietyn päivän klikkaamisen vaikutus riippuu siitä, oletko  \"päivätilassa\" vai \"kuukausitilassa\".<br /><br /><b>Päivätila</b>:<br />Kun klikkaat päivää, näyttö päivittyy ja kyseisen päivän luettelo näytetään.<br /><br /><b>Kuukausitila</b>:<br />Kun näytöllä on tietyn kuukauden kalenteri ja klikkaat tiettyä päivää, näyttö päivittyy, mutta sama kuukausi on edelleen näkyvissä.<br />Syynä tähän on se, että voit vielä vaihtaa toiseen kuukauteen, vuoteen tai tapahtumaan ennen kuin klikkaat joko <b>#pgv_lang[viewday]#</b> tai <b>#pgv_lang[viewmonth]# painiketta</b>.<br /><br />Klikkaamalla päivärivin lopussa olevaa <b>\"Pikalinkkiä\"</b>, jossa on tämän päivän päiväys, saat näkyviin luettelon tämän päivän tapahtumista riippumatta siitä, oletko \"Päivätilaassa\" vai \"Kuukausitilassa\".<br />";
$pgv_lang["annivers_month_select_help"]	= "~KUUKAUSIVALITSIN~<br /><br />\"Valitsintaulukon\" keskirivi on <b>Kuukausivalitsin</b><br />Sen avulla valitset kuukauden.<br /><br />Tietyn kuukauden klikkaamisen vaikutus riippuu siitä, oletko \"päivätilassa\" vai \"kuukausitilassa\".<br /><br /><b>Päivätila</b>:<br />Kun klikkaat kuukautta, näyttö päivittyy ja kyseisen kuukauden päivät näytetään.<br />Kaikki muut asetukset kuten päivä, vuosi ja tapahtumat säilyvät ennallaan. <br /><br /><b>Kuukausitila</b>:<br />Kun ruudulla on kalenteri kuukausitilassa ja klikkaat kuukautta valitsimen kuukausirivillä, tulee näyttöön kyseinen kuukausi.<br /><br />Kuukausirivin lopussa on <b>\"Pikalinkki\"</b> nykyiseen kuukauteen.<br />Tätä klikkaamalla näytetään nykyinen kuukausi riippumatta siitä, oletko \"päivätilassa\" vai \"kuukausitilassa\".";
$pgv_lang["annivers_year_select_help"]	= "~VUOSIKENTTÄ~<br /><br />Tässä kentässä voit muuttaa kalenterivuoden. <br /><br /><b>Erityisominaisuuksia</b> <b>#pgv_lang[viewyear]#</b><dl><dt><b>Enemmän kuin yksi vuosi </b></dt><dd>Voit hakea päivämääriä vuosijakson sisällä. <br /><br />Vuosijaksossa päivämääräalue ulottuu ensimmäisen vuoden 1. tammikuusta viimeisen vuoden 31. joulukuuta saakka. Tässä muutama esimerkki vuosijaksoista: <br /><br /><b>1992-5</b>Kaikki tapahtumat vuodesta 1992 vuoteen 1995. <br /><b>1972-89</b> Kaikki tapahtumat vuodesta 1972 vuoteen 1989. <br /><b>1610-759</b> Kaikki tapahtumat vuodesta 1610 vuoteen 1759. <br /><b>1880-1905</b> Kaikki tapahtumat vuodesta 1880 vuoteen 1905. <br /><b>880-1105</b> Kaikki tapahtumat vuodesta 880 vuoteen 1105. <br /><br />Nähdäksesi kaikki tapahtumat tietyllä vuosikymmenellä tai vuosisadalla, voit kirjoittaa <b>?</b> viimeisten numeromerkkien asemesta. Esimerkiksi <b>197?</b> kaikki tapahtumat vuosina 1970-1979 tai <b>16??</b> kaikki tapahtumat vuosina 1600-1699. <br /><br/> Valitsemalla vuosijakso kalenterinäkymä muuttuu vuosinäkymäksi. </dd></dl>";
$pgv_lang["annivers_show_help"]		= "~NÄYTÄ TAPAHTUMAT...~<br />Mikäli et ole kirjautunut järjestelmään, voit valita kahdesta vaihtoehdosta:<br /><br /><b>1. Kaikki henkilöt</b><br />Tällä vaihtoehdolla näytetään kaikki henkilöt ja perheet.<br /><br /><b>2. Viimeiset vuodet (100 vuotta)</b><br />Tällä vaihtoehdolla näytetään kaikki tapahtumat valittuna päivänä tai kuukautena, mutta ei yli 100 vuotta kauemmaksi.<br /><br />On myös olemassa kolmas vaihtoehto, mutta joko sinun on oltava sisäänkirjautunut tai ylläpitäjän on täytynyt asettaa järjestelmä näyttämään myös elävät henkilöt kaikille.<br /><br /><b>3. Elävät henkilöt</b><br />Kun tämä vaihtoehto on valittu, vain elävien henkilöiden tapahtumat näytetään.<br /><br />Klikkaamalla vaihtoehtoa näyttö päivittyy ja valitsemasi tapahtumat näytetään.<br />Päivä-, kuukausi- ja vuosiasetus sekä päivätila tai kuukausitila jäävät ennalleen.<br />";
$pgv_lang["annivers_sex_help"]		= "~SUKUPUOLEN VALITSIN~<br />Kun olet kirjautunut järjestelmään (tai jos ylläpitäjä on estänyt yksityisyysasetuksen) voit valita kolmesta vaihtoehdosta:<dl><dt><b>1. Kaikki-kuvake</b></dt><dd>Tällä vaihtoehdolla (vakio) kaikkien henkilöiden tai perheiden tapahtumat näytetään.</dd><dt><b>2. Mies-kuvake</b></dt><dd>Vain miespuolisten henkilöiden tapahtumat näytetään. Perhetapahtumien miehet näytetään.</dd><dt><b>3. Nainen-kuvake</b></dt><dd>Vain naispuolisten henkilöiden tapahtumat näytetään. Perhetapahtumien naiset näytetään.</dd></dl>Vaihtoehdon klikkaaminen päivittää näytön ja valitsemasi tapahtumat näytetään.<br />Päivä-, kuukausi- ja vuosiasetus sekä päivätila tai kuukausitila jäävät ennalleen.<br />";
$pgv_lang["annivers_event_help"]		= "~TAPAHTUMAVALITSIN~<br />Tässä voit valita näytetäänkö kaikki henkilöitä tai perheitä koskevat tapahtumat vai ainoastaan valitsemasi tapahtumat.<br /><br />Vaihtoehdon klikkaaminen päivittää näytön ja valitsemasi tapahtumat näytetään.<br />Päivä-, kuukausi- ja vuosiasetus sekä päivätila tai kuukausitila jäävät ennalleen.<br />";
$pgv_lang["annivers_tip_help"]		= "~VIHJE~<br />Oletetaan, että sinulla on 25. tammikuuta 1875 syntynyt sukulainen.<br />Säädä päivävalitsin siihen päivään.<br />Kun nyt klikkaat jotain Näytä-painiketta, näytetään kyseistä päivää koskeva luettelo tai kalenteri.<br />Kaikki iät, vuosipäivät jne. lasketaan uudestaan taaksepäin siitä päivämäärästä lähtien, jonka olet asettanut päivävalitsimeen.<br />Näet siis kalenterin samoin kuin sukulaisesi olisi nähnyt kauan sitten.<br />";
$pgv_lang["day_month_help"]			= "~NÄYTÄ PÄIVÄ/NÄYTÄ KUUKAUSI/NÄYTÄ VUOSI PAINIKKEET~<br /><br /><b>Näytä päivä</b> painike näyttää luettelon valitun päivän tapahtumista. Kaikki vuodet käydään läpi, joten ainoastaan päivä ja kuukausi voidaan valita tässä. Vuosiluvun muuttaminen ei vaikuta.<br />Voit rajoittaa luetteloa valitsemalla \"Viimeiset vuodet\" tai mikäli mahdollista \"Elävät henkilöt\".<br />Henkilöiden ikä lasketaan voimassa olevasta vuodesta.<br /><br /><b>Näytä kuukausi</b> painike näyttää valitusta kuukaudesta ja vuodesta kalenterikaavion. Tässä voit rajoittaa luetteloa klikkaamalla \"Viimeiset vuodet\" tai \"Elävät henkilöt\".<br />Valitsemalla vuoden menneisyydestä samanaikaisesti \"Viimeiset vuodet\" vaihtoehdon kanssa saat realistisen vaikutelman siitä, miltä kalenteri on näyttänyt esi-isiesi silmin. Kaikki ikävuodet kalenterissa näytetään suhteessa vuosikentässä olevaan vuosilukuun.<br /><br /><b>Näytä vuosi</b> painike näyttää valitun vuoden tapahtumat.<br />Voit taas rajoittaa luetteloa valitsemalla \"Viimeiset vuodet\" tai mikäli mahdollista \"Elävät henkilöt\".<br />Mukava ominaisuus on mahdollisuus valita näyttää useamman vuoden tapahtumat: Syötä jälkimmäisen vuoden viimeinen luku ensimmäisen perään erotettuna \"-\"-merkillä. (Esimerkki: 1924-6 näyttää kaikki tapahtumat vuodesta 1924 vuoteen 1926 tai 1976-1984 kaikki tapahtumat vuodesta 1976 vuoteen 1984.)<br />- Voit myös syöttää vain vuosiluvun ensimmäiset numerot, jolloin näytetään kaikki vuodet, jotka alkavat sillä numerolla (Esim. 197 näyttää kaikki vuodet välillä 1970-1979)<br /><br /> Kun haluat <b>muuttaa vuosiluvun</b> sinun <b>on</b> painettava jotakin näistä kolmesta painikkeesta.</b><br /><br />Kaikki muut asetukset pysyvät ennallaan kun painettaan jotakin näistä painikkeista.<br />";

//-- Clipping Cart-page
$pgv_lang["help_clippings.php"]		= "~Sukupuun leikekori~<br />Leikekori mahdollistaa \"leikkeiden\" tallentamisen tästä sukupuusta leikekoriin ja liittämään ne yhdeksi GEDCOM-tiedostoksi omalle koneelle lataamista varten.<br /><br />* Kuinka leike tehdään?<br />Tämä on helppoa. Aina kun näet klikattavissa olevan nimen (henkilön, perheen tai paikan) voit mennä kyseiselle sivulle. Siellä näet vaihtoehdon \"Lisää leikekoriin\".<br />Klikkaamalla sitä linkkiä avautuu sivu, jossa on monta vaihtoehtoa ladata tiedosto.<br /><br />* Kuinka ladata tiedosto koneellesi?<br />Kun sinulla on haluamasi tiedot leikekorissa klikkaa \"Lataa nyt koneesta\"-linkkiä.<br />Seuraa sen jälkeen ohjeita ja linkkejä.";
$pgv_lang["clip_download_help"]		= "~LATAA LEIKKEET~<br /><br />Klikkaamalla tätä linkkiä avautuu seuraava sivu.<br />Mikäli valittavana on useita vaihtoehtoja ladattaviksi kohteiksi GEDCOM-leikkeessä, ne näytetään tällä sivulla. Seuraa vain ohjeita.";
$pgv_lang["empty_cart_help"]			= "~TYHJENNÄ LEIKEKORI~<br /><br />Klikkaamalla tätä, leikekorisi tyhjenee kokonaan.<br /><br />Mikäli et halua poistaa kaikkia henkilöitä, perheitä ja paikkoja leikekorista, voit poistaa ne yksitellen klikkaamalla \"Poista\" linkkiä nimiruuduissa.";
$pgv_lang["add_by_id_help"]			= "~LISÄÄ ID-TUNNUKSEN MUKAAN LEIKEKORIIN~<br /><br />Tähän kenttään voi kirjoittaa henkilön ID-tunnuksen lisätäksesi hänet leikekoriin. Kun hänet on lisätty, sinulle annetaan mahdollisuus linkittää kyseisen henkilön sukulaisuussuhteet leikekoriisi<br /><br />Mikäli et tiedä henkilön ID-tunnusta, voit suorittaa haun klikkaamalla henkilön kuvaketta lisää-painikkeen vieressä.<br /> <p>#zip_help#";  //$pgv_lang["zip_help"]";
$pgv_lang["zip_help"]				= "~ZIPATUT LEIKKEET~<br /><br />Valitse tämä vaihtoehto tallentaaksesi leikkeet zip-tiedostoksi. Lisätietoja zip-tiedostoista löytyy osoitteesta <a href=\"http://www.winzip.com\" target=\"_blank\">http://www.winzip.com</a>.";
$pgv_lang["include_media_help"]		= "~SISÄLLYTÄ MEDIA~<br /><br />Valitse tämä vaihtoehto sisällyttääksesi tietueeseen liitetyt mediatiedostot leikekoriisi. Tämä valinta zippaa tiedostot automaattisesti, kun tiedostot ladataan omalle koneellesi.";
$pgv_lang["clip_cart_help"]			= "~LEIKEKORI~<br /><br />Tämä luettelo kertoo leikekorisi sisällön. Tyypit ovat henkilö (INDI), perhe (FAM), lähde (SOUR), tietovarasto (REPO), huomautus (NOTE), ja media (OBJE). Jokaista tyyppiä edustaa oma kuvakkeensa. ID on kyseistä tyyppiä koskevan kohteen tunnusluku. Nimi / kuvaus sisältää joko perheen tai henkilön nimen tai kohteen kuvauksen.  Poista-painike poistaa tietueen leikekorista. Huomaa, että poistamista ei pyydetä vahvistamaan.";

//-- GEDCOM Edit Utility
$pgv_lang["show_changes_help"]		= "~NÄYTÄ MUUTOKSET GEDCOM-TIEDOSTOSSA~<br /><br />Kun tämä viesti näytetään se merkitsee kahta asiaa:<br /><br />1. Joku on tehnyt muutoksia GEDCOM-tiedostoon.<br />Tietueita on lisätty, poistettu tai muutettu.<br /><br />2. Ylläpitäjä ei vielä ole hyväksynyt muutoksia.<br />Kun muutokset on hyväksytty (tai hylätty), et enää näe tätä viestiä.<br /><br /><br />Klikkaamalla linkkiä, näet mitä muutoksia on tehty.<br />Jos huomaat, että muutos on virheellinen, ilmoita siitä ylläpitäjälle.";

//-- Search-page
$pgv_lang["help_search.php"]			= "~HAKUSIVU~<br /><br />Vaikka sivu on yksinkertaisen näköinen, sen taustalla on kaksi tehokasta hakumoottori..<br /><br />Useimmat sukututkimussivut sallivat haun vain (suku)nimen perusteella. Tällä sivustolla voit käytännössä hake mitä tahansa.<br /><br />Hakukenttä näytön vasemmalla laidalla on sama kuin otsikkoalueella.<br /><br />Mikäli etsin henkilöitä, jotka liittyvät tiettyyn vuosilukuun, kirjoita pelkästään vuosiluku. Ohjelma hakee kaikki siihen liittyvän.<br /><br />Haetko nimeä tai paikkaa?<br />Kirjoita vain nimi tai paikka tai osa siitä ja ohjelma hoitaa loput.<br /><br />SOUNDEX-menetelmä.<br />Oikealla puolella olevalla hakukentällä voit hakea henkilöiden nimiä tai paikkoja vaikka et tietäisikään niiden oikeata kirjoitusasua.<br /><br />Lisää tietoa näistä kahdesta hakukentästä saat klikkaamalla <b>?</b> kenttien yläpuolella.<br /><br />";
$pgv_lang["search_enter_terms_help"]	= "~SYÖTÄ HAKUTERMIT~<br /><br />Tähän hakukenttään voit syöttää etu- ja sukunimiä, paikkoja, multimediaa, jne.<br /><br /><b>Jokerimerkit</b><br />Jokerimerkit sellaisin kuin ne tunnet (esim. *), eivät ole sallittuja, vaan ohjelma olettaa automaattisesti jokerimerkit.<br />Mitä se merkitsee?<br />Oletetaan, että kirjoitat hakukenttään \"<b>Kai</b>\".<br />Hakutulos voi olla (jos tieto on olemassa tietokannassa):<br /><b>Kai</b> Järvinen<br /><b>Kai</b>ja Saari<br />Siiri <b>Kai</b>nulainen<br />Joku, joka on syntynyt 01.01.1901 <b>Kai</b>rossa<br />Jne., jne..<br /><br /><b>Päivämäärät</b><br />Vuosiluvun syöttäminen hakukenttään palauttaa kaikki ne nimet, jotka jollain tavoin liittyvät kyseiseen vuoteen.<br />Mikäli syötät 1950, tuloksena saadaan kaikki sinä vuonna syntyneet, kuolleet, naimisiin menneet... mitä tahansa muita tapahtumia sinä vuonna.<br />Mikäli syötät \"4 Dec\", kaikki siihen päivään liittyvät henkilöt kaikkina vuosina palautetaan.<br />Mutta myös henkilöt, jotka liittyvät päivämääriin 14. ja 24. joulukuuta luetellaan.<br />Kuten huomaat myös tässä tapauksessa oletetaan jokerimerkit, joten niitä ei tarvitse syöttää.<br /><br /><b>Oikea päivämäärämuoto</b><br />Ohjelma etsii tietoa sellaisen kuin se on syötetty GEDCOM-tiedostoon.<br />Jos siis haluat hakea tapahtumaa joulukuun 14., sinun on syötettävä:<br /><b>14 dec</b><br /> koska tieto syötetään tässä muodossa GEDCOM-tiedostoon..<br />Mikäli kirjoitat <b>dec 14</b> palautetaan henkilöt, jotka liittyvät tapahtumaan 08 <b>dec</b>ember 18<b>14</b>. Voit myös käyttää normaalimuotoja haussasi, jos ne ovat sinulle tuttuja. Mikäli esimerkiksi haluat luettelon kaikista henkilöistä joille on kytketty tapahtuma 1900-luvulla, voit syöttää 19[0-9][0-9]ja saat osuman kaikista henkilöistä vuosilta 1900-1999.<br /><br />Mikäli tarvitset enemmän tietoa hakujärjestelmästä, ota yhteyttä meihin niin laajennamme tätä ohjetiedostoa.";
$pgv_lang["search_replace_help"]		= "~ETSI JA KORVAA~<br /><br />Tässä voit hakea kirjoitusvirheitä ja muita epätarkkoja tietoja ja korvata ne oikeilla.<br /><br /><b>Hakeminen</b><br />Tämä ominaisuus suorittaa haun kuten <a href=\"help_text.php?help=search_enter_terms_help\">normaali haku</a>.<br /><br /><b>Korvaaminen</b><br />Kaikki hakutermin esiintymät korvataan korvattavalla sanalla GEDCOM-tiedostossa.<br /><br /><b>Esimerkki</b><br />Olet kirjoittanut isoisoisäsi nimen väärin muodossa Sepetues <br /><br />Kirjoita hakukenttään: <b>Sepetues</b>. Kirjoita korvaa-kenttään: <b>Sepeteus</b><br />Jokainen esiintymä \"Sepetues\" korvautuu sanalla \"Sepeteus\"<br /><br /><b>Hae...</b><br />Valitse mitä haet. Voit hakea pelkkiä nimiä, pelkkiä paikkoja tai kaikkea. Tämä on kätevää, mikäli haluat korvata vain henkilön nimen etkä paikannimeä.<br /><br />Mikäli teit väärän korvauksen, klikkaa  \"Hyväksy/Hylkää muutokset\"-linkkiä sivun alareunassa hyväksyäksesi halutut ja hylätäksesi virheelliset muutokset.<br /><br />Mikäli haluat enemmän apua tähän järjestelmälle, kerro se meille jotta voimme laajentaa tätä aputiedostoa.<br /><br />";
$pgv_lang["soundex_search_help"]		= "~HAE TAVALLA, JOLLA KUVITTELET NIMEN KIRJOITETTAVAN (SOUNDEX)~<br /><br />Myös SOUNDEX nimihaku on varsin tehokas.<br />Aluksi lyhyt selostus SOUNDEXista:<br /><br />SOUNDEX järjestää yhteen nimet, jotka kuulostavat samanlaisilta mutta jotka kirjoitetaan eri tavalla. SOUNDEX-koodi alkaa nimen ensimmäisellä kirjaimella jota seuraa kolmenumeroinen koodi, joka edustaa kolmea ensimmäistä jäljellä olevaa konsonanttia. Nimiin, joissa ei ole riittävästi koodattavia kirjaimia, lisätään nollia.<br /><br />Eli:<br />mikäli etsit nimeä \"Smith\", voit saada tulokseksi:<br />Smith - Smid - Smit - Schmidt, Smyth, Smithe, Smithee, Schmitt, Smead, Sneed, Smoote jne.<br /><br />Sinun ei tarvitse vaivata päätäsi SOUNDEX-koodeilla.<br />Kirjoita vain etsimäsi nimi ja ohjelma tekee loput.<br /><br />SOUNDEX-systeemi on kätevä: tiedät nimen mutta et sen tarkkaa kirjoitusasua.<br />Joskus tietokantaan on saatettu syöttää väärin kirjoitettu nimi.<br />Käyttämällä SOUNDEXia saatat kuitenkin löytää nimen.<br /><br />Voit totutella SOUNDEXin käyttöön, koeta löytää tietty nimi mutta syötä se hakukenttään väärin kirjoitettuna.<br /><br />Tässä SOUNDEX-järjestelmässä millä tahansa nimellä voi aloittaa haun.<br />Voit hakea etunimen, sukunimen tai paikan nimen.<br />Syöttämällä Useampaan kuin yhteen kenttään syöttäminen toimii \"JA\" ehdon tavoin.<br /> Voit myös rajoittaa hakua syöttämällä vuosiluku tai vuosilukualue. Esimerkkeinä 1950 tai 19[5-7][0-9], mikä edustaa vuosilukuja 1950 - 1979.<br />Hakutuloksena ovat kaikki henkilöt, jotka esiintyvät tietyssä paikassa kyseisellä vuosilukualueella.";

//-- Individuals-page
$pgv_lang["help_individual.php"]		= "~#pgv_lang[indi_info]# SIVU~<br /><br />Tällä sivulla näkyvät henkilöä koskevat yksityiskohtaiset tiedot.<br /><br />Mikäli käytettävissä on kuva, se näkyy ylhäällä vasemmalla.<br />Kuvan vierellä ovat henkilön nimet.<br />Nimiin voi liittyä huomautuksia ja lähteitä. Mikäli nimeen on liitetty huomautuksia tai lähteitä, ne näkyvät luettelona nimen alla. Myös henkilön lempinimi näytetään, jos sellainen on olemassa.<br /><br />Mikäli sinulla on muokkausoikeudet, \"Muokkaa\" ja \"Poista\" linkit näkyvät niiden nimien kohdalla.<br /><br />Tällä sivulla näkyvät myös välilehtilinkit \"Henkilön tietoja\", \"Lisätietoja\", \"Lähteitä\", \"Media\" ja \"Lähisukulaisia\". Näillä välilehdillä ovat kaikki GEDCOM-tiedostoon tallennetut tiedot.<br /><br />\"Henkilön tietoja\" välilehdellä ovat kaikki tiedot henkilöstä ja hänen avioliito(i)staan. Klikkaamalla päivämäärää aukeaa kyseisen päivän vuosipäiväkalenteri, josta näkyvät tässä GEDCOM-tiedostossa olevat tapahtumat kyseisenä päivänä. Klikkaamalla paikkaa avautuu paikkahierarkia, missä näytetään muut henkilöt, joihin liittyi tapahtumia kyseisellä paikkakunnalla. Avioliitto- ja muita perhetietoja varten näkyy puolison nimi, josta pääsee puolison tietoihin. Perhetietueeseen on myös linkki.<br /><br />\"Lisätietoja\"-välilehdellä on muita kyseiseen henkilöön liittyviä tietoja.<br /><br />\"Lähteitä\"-välilehdellä ovat kaikki kyseiseen henkilöön liittyvät yleiset lähteet. Klikkaamalla lähdettä, avautuu yksityiskohtainen lähteeseen liittyvä sivu, jossa luetteloidaan myös muut kyseiseen lähteeseen liittyvät henkilöt.<br /><br />\"Media\"-välilehdellä luetteloidaan kaikki kyseiseen henkilöön liittyvät kuvat ja muu media. Klikkaamalla pienoiskuvaa aukeaa täysikokoinen kuva.<br /><br />\"Lähisukulaisia\"-välilehdellä luetellaan henkilön vanhemmat ja sisarukset sekä aviopuolisot ja lapset. Henkilöt luetteloidaan samanlaisissa ruuduissa joita jo muissa kaavioissa olet ehkä nähnyt.<br /><br />Näytön oikealla laidalla on linkkiruutu.<br />Monet ruudun linkeistä ovat samat kuin valikoissa. Esimerkiksi klikkaamalla \"Esipolvikaavio\"-linkkiä sivustalla olevassa linkkiruudussa avautuu kyseisen henkilön esipolvikaavio. Tämä eroaa valikkolinkistä siinä, että klikkaamalla valikon \"Esipolvikaavio\"-linkkiä avautuu tämän GEDCOM-tiedoston oletusesipolvikaavio.<br /><br />Mikäli ylläpitäjä on sen mahdollistanut, näkyy linkkiruudussa myös \"Näytä GEDCOM-tietue\". Tämä näyttää kyseisen henkilön tietueen GEDCOM-raakamuodossa.<br /><br />Mikäli ylläpitäjä on mahdollistanut leikekorin, löytyy myös linkki kyseisen henkilön GEDCOM-tietojen lisäämiseksi leikekoriin.<br /><br />\"Sukulaisuus minuun\" linkki näkyy vain, mikäli olet kirjautunut järjestelmään ja sinulla on ID-tunnus GEDCOM-tiedostossa. Tämä linkki vie esipolvikaavioon ja näyttää, miten olet sukua kyseiselle henkilölle.<br /><br /> Lisäohjeita löytyy klikkaamalla <b>?</b> linkin vieressä.";
$pgv_lang["delete_person_help"]		= "~POISTA TÄMÄ HENKILÖ ~<br /><br /><br />Klikkaamalla tätä merkitset tämän HENKILÖN poistettavaksi GEDCOM-tiedostosta.<br /><br />Mitä se merkitsee?<br />Olettaen, että sinulla on hyvä syy poistaa tämä henkilö GEDCOM-tiedostosta klikkaat tätä linkkiä, jolloin avautuu ponnahdusikkuna, jossa kysytään oletko varma tai peruuta.<br /><br />Mikäli jatkat poistamista saattaa kestää hetken, ennen kuin uusi ponnahdusikkuna ilmoittaa, että henkilö on poistettu.<br /><br />Kun jatkat vierailuasi sivustolla havaitset, että poistettu henkilö on vielä näkyvissä ja käytettävissä kuten ennenkin.<br /><br />Tämä <b>ei</b> ole virhe.<br />Ylläpitäjä saa viestin, että GEDCOM-tiedostoon on tehty muutos ja että poistit henkilön.<br />Ylläpitäjän on hyväksyttävä (tai hylättävä) muutos. Vasta sitten muutos on voimassa.<br />Tarvittaessa ylläpitäjä ottaa yhteyttä sinuun.";
$pgv_lang["delete_name_help"]		= "~MUUTA TAI PYYHI NIMI GEDCOM-TIEDOSTOSTA~<br /><br />Klikkaamalla tätä linkkiä avautuu ponnahdusikkuna, jossa voit muuttaa henkilön nimeä.<br />Se on helppoa: kirjoita muutokset ruutuihin, klikkaa painiketta ja sulje ponnahdusikkuna.<br /><br /><b>PYYHI NIMI</b> Klikkaamalla tätä vaihtoehtoa merkitset nimen poistettavaksi GEDCOM-tiedostosta. Huomaa, että tämä on kokonaan eri asia kuin henkilön poistaminen. Vain nimi poistuu, ei henkilö.<br />Mikäli haluat poistaa lempinimen, muut nimet säilyvät.<br />Mikäli poistat ainoan nimen, henkilö jää jäljelle \"tuntemattomana\".<br />Henkilöä ei myöskään kytketä irti mistään yhteyksistä sukulaisiinsa, paikkoihin, lähteisiin jne.<br />Kuinka tämä toimii?<br />Olettaen, että sinulla on hyvä syy poistaa tämä nimi GEDCOM-tiedostosta klikkaat tätä linkkiä, jolloin avautuu ponnahdusikkuna, jossa kysytään oletko varma tai peruuta.<br /><br />Mikäli jatkat poistamista saattaa kestää hetken, ennen kuin uusi ponnahdusikkuna ilmoittaa, että nimi on poistettu.<br /><br />Kun jatkat vierailuasi sivustolla havaitset, että poistettu nimi on vielä näkyvissä ja käytettävissä kuten ennenkin.<br /><br />Tämä <b>ei</b> ole virhe.<br />Ylläpitäjä saa viestin, että GEDCOM-tiedostoon on tehty muutos ja että poistit nimen.<br />Ylläpitäjän on hyväksyttävä (tai hylättävä) muutos. Vasta sitten muutos on voimassa.<br />Tarvittaessa ylläpitäjä ottaa yhteyttä sinuun.";
$pgv_lang["add_name_help"]			= "~LISÄÄ NIMI~<br /><br />Tämä linkki antaa sinun lisätä uuden nimen henkilölle. Joskus henkilöt tunnetaan lempinimellä tai aliaksena. Tämä linkki mahdollistaa uuden nimen lisäämisen henkilölle muuttamatta vanhaa nimeä.";
$pgv_lang["add_sibling_help"]		= "~LISÄÄ SISARUS~<br /><br />Klikkaamalla tätä linkkiä voit lisätä uuden lapsen tähän perheeseen.<br />\"Tämä perhe\" on tässä tapauksessa tämän näytön henkilön isä ja äiti.<br />Joten pidä mielessä, että olet lisäämässä siskon tai veljen kyseiselle henkilölle.<br />Sisaruksen lisääminen on helppoa: klikkaa linkkiä ja täytä ruudut avautuvassa ponnahdusikkunassa ja lopuksi klikkaa \"Tallenna\".<br /><br />Mikäli haluat lisätä henkilölle pojan tai tyttären, vieritä ruutua alaspäin ja klikkaa linkkiä \"Perhe puolisoineen\".";
$pgv_lang["add_son_daughter_help"]		= "~LISÄÄ POIKA TAI TYTÄR~<br /><br />Klikkaamalla tätä linkkiä voit lisätä lapsen tähän perheeseen.\"Tämä perhe\" on tässä tapauksessa tämän näytön päähenkilön ja hänen puolisonsa.<br />Joten pidä mielessä, että olet lisäämässä pojan tai tyttären kyseiselle henkilölle.<br />Lapsen lisääminen on helppoa: klikkaa linkkiä ja täytä ruudut avautuvassa ponnahdusikkunassa ja lopuksi klikkaa \"Tallenna\".<br /><br />Mikäli haluat lisätä henkilölle veljen tai sisaren, vieritä ruutua alaspäin ja klikkaa linkkiä \"Perhe vanhempineen\".";
$pgv_lang["link_child_help"]			= "~LIITÄ TÄMÄ HENKILÖ LAPSEKSI OLEMASSA OLEVAAN PERHEESEEN ~<br /><br />Klikkaamalla tätä linkkiä voit liittää hänet lapseksi olemassa olevaan perheeseen.<br /><br />Oletetaan, että tämän henkilön vanhemmat ovat tuntemattomia, mutta ilmeneekin, että vanhemmilla onkin tietue tässä GEDCOM-tiedostossa.<br /><br />Klikkaa linkkiä, lisää perheen ID-tunnus (mikäli et tiedä ID-tunnusta, voit etsiä sitä ponnahdusikkunassa) ja homma on hoidettu.";
$pgv_lang["link_husband_help"]		= "~LIITÄ TÄMÄ HENKILÖ AVIOMIEHEKSI OLEMASSA OLEVAAN PERHEESEEN ~<br /><br />Klikkaamalla tätä linkkiä voit liittää hänet aviomieheksi olemassa olevaan perheeseen, jonka aviomies on tähän asti ollut tuntematon.<br /><br />Kyseinen henkilö korvaa näin tuntemattoman henkilön. Kaikki tapahtumat, avioliittotiedot ja lapset säilyttävät entiset kytkennät perheeseen.<br /><br />Klikkaa linkkiä, lisää perheen ID-tunnus (mikäli et tiedä ID-tunnusta, voit etsiä sitä ponnahdusikkunassa) ja homma on hoidettu. Tämä on edistyksellinen muokkausvaihtoehto, jota saa käyttää vain mikäli liitettävä perhe on jo olemassa GEDCOM-tiedostossa. Mikäli haluat lisätä uuden perheen, käytä \"Lisää uusi vaimo\" linkkiä.";
$pgv_lang["add_husband_help"]		= "~LISÄÄ UUSI AVIOMIES~<br /><br />Klikkaamalla tätä linkkiä voit lisätä \"uuden\" (miespuolisen) henkilön ja kytkeä hänet näytön päähenkilöön uutena aviomiehenä.<br /><br />Klikkaa linkkiä, täytä ponnahdusikkunassa mahdollisimman monta kenttää ja klikkaa lopuksi \"Tallenna\".";
$pgv_lang["link_new_husb_help"]		= "~#pgv_lang[link_new_husb]#~<br />Tämän avulla voit liittää tiedostossa jo olevan henkilön uudeksi aviomieheksi tälle henkilölle. Näin luodaan uusi perhe valitsemasi aviomiehen kanssa. Voit myös määritellä avioliiton tälle uudelle perheelle.<br /><br />";
$pgv_lang["link_wife_help"]			= "~LIITÄ TÄMÄ HENKILÖ VAIMOKSI OLEMASSA OLEVAAN PERHEESEEN ~<br /><br />Klikkaamalla tätä linkkiä voit liittää hänet vaimoksi olemassa olevaan perheeseen. Tämä on edistyksellinen muokkausvaihtoehto, jota saa käyttää vain mikäli liitettävä perhe on jo olemassa GEDCOM-tiedostossa. Mikäli haluat lisätä uuden perheen, käytä \"Lisää uusi aviomies\" linkkiä.";
$pgv_lang["add_wife_help"]			= "~LISÄÄ UUSI VAIMO~<br /><br />Klikkaamalla tätä linkkiä voit lisätä \"uuden\" (naispuolisen) henkilön ja kytkeä hänet näytön päähenkilöön uutena vaimona.<br /><br />Klikkaa linkkiä, täytä ponnahdusikkunassa mahdollisimman monta kenttää ja klikkaa lopuksi \"Tallenna\".";
$pgv_lang["link_new_wife_help"]		= "~#pgv_lang[link_new_wife]#~<br />Tämän avulla voit liittää tiedostossa jo olevan henkilön uudeksi vaimoksi tälle henkilölle. Näin luodaan uusi perhe valitsemasi aviovaimon kanssa. Voit myös määritellä avioliiton tälle uudelle perheelle.<br /><br />";
$pgv_lang["add_new_parent_help"]		= "#pgv_lang[multiple_help]#<br />~LISÄÄ UUSI ISÄ TAI ÄITI~<br /><br />GEDCOM-tiedostossa on tietenkin useita henkilöitä ilman  isää ja/tai äitiä koskevaa tietuetta. <br /><br />Siinä tapauksessa <b>Henkilötietosivulla</b> sen <b>Lähisukulaisia</b>-välilehdellä taulukossa <b>Perhe vanhempineen</b> on linkki/linkit lisätä <b>uusi</b> isä ja/tai äiti henkilölle.<br /><br /><b>HUOMAA:</b><br />Näillä linkeillä lisätään <b>uusi</b> isä ja/tai äiti. Mikäli isällä ja/tai äidillä jo on tietue tässä GEDCOM-tiedostossa, käytä linkkiä: <b>#pgv_lang[link_as]##pgv_lang[child]#</b>, joka löytyy Henkilötietosivulta, sivun viimeisen taulukon alapuolelta.";
$pgv_lang["show_fact_sources_help"]	= "~#pgv_lang[show_fact_sources]#~<br />~#pgv_lang[show_fact_notes]#~<br />Kun tämä valinta on rastitettu, kaikki tähän henkilöön liitetyt lähde- tai muistiinpanotietueet näytetään. Mikäli tätä valintaa ei ole rastitettu, lähde- tai muistiinpanotietueita, jotka liittyvät tämän henkilön muihin tietoihin, ei näytetä.<br /><br />";
$pgv_lang["age_differences_help"]		= "Kun tämä valintaruutu on rastitettu «#pgv_lang[relatives]#»-välilehti näyttää päivämääräerotukset seuraavasti:<br /><ul><li>Partnerien syntymäajat.<br /> Negatiivinen arvo kertoo, että seuraava partneri on vanhempi kuin edellinen.<br /><br /></li><li>Vihkimispäivä ja ensimmäisen lapsen syntymäaika.<br />Negatiivinen arvo osoittaa, että lapsi syntyi ennen vihkimispäivää tai että joko syntymäaika tai vihkimisaika on väärä.<br /><br /></li><li>Lasten syntymäajat.<br />Negatiivinen arvo kertoo, että joko lasten järjestys on väärä tai joku lasten syntymäajoista on väärä.</li></ul><br /><br />";

//-- Add Facts
$pgv_lang["add_facts_help"]			= "~LISÄÄ UUSIA TIETOJA~<br /><br />Tässä voit lisätä tietoja henkilölle tai henkilöille.<br /><br />Valitse ensin tietolaji pudotusvalikosta ja klikkaa sitten \"Lisää\" painiketta.<br />Pudotusvalikossa ovat kaikki GEDCOM-tiedostoon lisättävissä olevat tietolajit.<br />";
$pgv_lang["add_custom_facts_help"]		= "~Lisää oma tieto~<br />Mikäli alasvetovalikosta ei löydy sopivaa tietolajia, voit lisätä <b>oman tiedon</b>.<br />Sen lisääminen on yhtä helppoa kuin valmiiksi luetteloidun tiedon. Ainoa ero on se, että sinun on nimettävä tietolaji. Se on tehtävä ylimpään kenttään: <b>#pgv_lang[type]#</b>";
$pgv_lang["add_note_help"]			= "~LISÄÄ UUSI LISÄTIETO~<br /><br />Tässä voit lisätä uuden lisätiedon koskien tätä/näitä henkilöä/henkilöitä.<br />Klikkaa linkkiä ja avautuvaan ponnahdusikkunaan voit kirjoittaa lisätiedot.<br />Kun olet valmis, klikkaa \"Lisää\" painiketta ja sulje ikkuna.<br /><br />#pgv_lang[add_facts_general_help]#";
$pgv_lang["add_source_help"]		= "#pgv_lang[multiple_help]#<br />~LISÄÄ UUSI LÄHDEVIITTAUS~<br /><br />Klikkaamalla tätä linkkiä voit lisätä uuden lähde<b>viittauksen</b> koskien tätä/näitä henkilöä/henkilöitä.<br />Avautuneessa ikkunassa voit hakea lähteen (Hae ID-tunnus) ja lisää \"viittaus\".<br /><br />Kokonaista lähdettä ei voi lisätä vaan se on valittava luettelosta.<br /><br />Mikäli haluamaasi lähdettä ei ole luettelossa, toimita ylläpitäjälle tiedot ja hän lisää uuden lähteen luetteloon.<br />Tulevaisuudessa voit sitten käyttää uutta lähdettä luettelossa.<br /><br />Seuraavassa ohjelmaversiossa on mahdollista itsekin lisätä uusi lähde.<br /><br />#pgv_lang[add_facts_general_help]#";
$pgv_lang["add_media_help"]			= "~LISÄÄ UUSI MEDIA~<br /><br />Multimediatiedostojen lisääminen GEDCOM-tiedostoon on mukava ominaisuus.<br />Vaikka tämä ohjelma on hyvännäköinen jo ilman mediaa, sen saa vielä paremmaksi lisäämällä sukulaisiasi koskevia kuvia tai muuta multimediaa.<br /><br />Mitä sinun tulee tietää multimediasta.<br /><br />Kuten ehkä tiedät, multimediaformaatteja on lukemattomia. Vaikka PhpGedView pystyy käsittelemään niistä useimpia, on muutamia asioita otettava huomioon.<br /><ul><li><b>Formaatit</b><br />Kuvia voi muokata ja tallentaa monissa formaateissa.<br />Esimerkiksi .jpg, .png, .gif, .bmp jne. Mikäli sama kuva on tallennettu eri muotoihin, ne näkyisivät näytöllä samankokoisina, mutta niiden tiedostokoot eroavat toisistaan. Yleensä jpg-kuvat vaativat vähiten tilaa levyllä.</li><br /><br /><li><b>Kuvan koko</b><br />Mitä suurempi kuva, sen suurempi kuvatiedoston koko. Kuvan tulisi mahtua näytölle ilman vieritystä. Kuvan suurin pituus tai leveys ei saisi ylittää kuvaruudun kokoa. Koska tämä ohjelma on optimoitu näyttöresoluutiolle 1024*756 pistettä on kuvan koko suhteutettava sen mukaisesti.</li><br /><li><b>Resoluutio</b><br />Kuvan resoluutio ilmoitetaan dpi-arvona (pistettä/tuuma), mutta se koskee vain tulostettua kuvaa. Paperille painetussa kuvassa resoluutio voi olla 150-300 dpi tai suurempi ja kuvan fyysisten mittojen perusteella se skaalataan sopivan kokoiseksi. Mikäli et aio tulostaa kuvaasi, sen koko kannattaa jättää pieneksi</li><br /><br /><li><b>Värisyvyys</b></ br> Kolmas tapa pitää kuvatiedosto pienenä on vähentää värisävyjen määrää. Värisävyjen määrä voi olla mitä tahansa mustavalkoisen (kaksi sävyä) ja täysvärikuvan (16 miljoonaa sävyä) välillä. Mitä enemmän värisävyjä, sen suurempi tiedostokoko.</li></ul><b>Miksi on tärkeätä pitää tiedostokoko pienenä?</b> <br /><br /><ul><li>Ensiksikin: käytettävissä on rajoitettu tila verkossa. Mitä useampi suuri tiedosto, sen enemmän tilaa tarvitaan palvelimella. Mitä enemmän tilaa tarvitaan, sen kalliimmaksi se tulee.</li><br /><li>Latausaika. Suuret tiedostot vaativat pidemmän latausajan palvelimelta omalle koneelle. Kaikilla ei ole käytettävissä kaapeliyhteyttä, laajakaistayhteyttä tai DSL-yhteyttä.</li><br /><br /><li>Kaistanleveys. Mitä enemmän dataa on ladattava palvelimelta koneellesi tai päinvastoin, sen enemmän se maksaa. Tämä johtuu siitä, että palvelimen siirtokapasiteetti on rajoitettu ja yhteys on jaettava kaikkien palvelimella pyörivien ohjelmin välillä. PhpGedView on yksi ohjelma, joka jakaa kapasiteettia muiden ohjelmien kanssa palvelimella. Kustannukset jaetaan yleensä ohjelmien välillä niiden käyttämän datasiirtomäärän suhteessa.</li></ul><b>Kuinka ladata multimediatiedostosi palvelimelle.</b><br />Se voidaan tehdä kahdella tavalla. Mikäli mediatiedostoja on paljon, ota yhteyttä ylläpitäjään parhaan tavan selvittämiseksi. Mikäli ylläpitäjä on sen sallinut, voit käyttää Lataa mediatiedostoja-lomaketta #pgv_lang[mgv]#-valikossa. Voit myös käyttää Lataa palvelimelle-optiota multimedialomakkeella.<br /><br />";
$pgv_lang["add_facts_general_help"]		= "~Yleistä tietoa asioiden lisäämisestä~<br />Kun olet lisännyt tiedon, lisätiedon, lähteen tai multimediatiedoston henkilö(i)lle, käyttäjän, jolle ylläpitäjä on antanut hyväksymisoikeudet, on hyväksyttävä lisäys.<br />Ennen hyväksymistä käyttäjät, joilla on muokkausoikeudet, näkevät muutokset erivärisen reunuksen ympäröimänä. Muut näkevät vain alkuperäisen tiedon. Vasta kun muutos on hyväksytty, reunus poistuu ja uusi tieto tulee kaikkien nähtäville.";

//-- Edit user
$pgv_lang["edituser_my_account_help"]	= "Tällä sivulla voit muuttaa asetuksiasi.<br /><br />Voit muuttaa käyttäjätunnustasi, nimeäsi, salasanaasi, kieltäsi, sähköpostiosoitettasi, sivuston teemaa ja ensisijaista yhteydenottotapaa.<br /><br />GEDCOM INDI -tietueen ID-tunnusta et voi itse muuttaa.<br /><br />";
$pgv_lang["edituser_username_help"]	= "~#pgv_lang[username]#~<br /><br /> Tässä ruudussa voit muuttaa käyttäjätunnustasi.<br />Käyttäjätunnuksessa on <b>erotettava suuret ja pienet</b> kirjaimet. Jussi ei ole sama kuin JUSSI tai jussi.<br /><br />Voit vain käyttää aakkosia, numeroita, yhdysviivaa (-) ja alaviivaa (_).<br /><br />Älä käytä pisteitä, pilkkuja, välilyöntiä tai muita aakkosiin kuulumattomia merkkejä.";
$pgv_lang["edituser_firstname_help"]		= "~#pgv_lang[firstname]#~<br /><br />Tähän kenttään voit muuttaa etunimesi. Tämän nimet muut näyttäjät näkevät kun olet kirjautunut. <br /><br />Vaikka itse voit valita mitä tähän kirjoitat, sinun on ilmoitettava ylläpitäjälle muutoksesta. Saattaa herättää ihmetystä kun muut näkevät tuntemattoman henkilön linjoilla. Ylläpitäjä voi saada sen selville ilman ilmoitustasi, mutta olisi kohteliasta säästää hänet turhalta vaivalta.<br /><br />";
$pgv_lang["edituser_lastname_help"]		= "~#pgv_lang[lastname]#~<br /><br /> Tähän kenttään voit muuttaa sukunimesi. Tämän nimet muut näyttäjät näkevät kun olet kirjautunut. <br /><br />Vaikka itse voit valita mitä tähän kirjoitat, sinun on ilmoitettava ylläpitäjälle muutoksesta. Saattaa herättää ihmetystä kun muut näkevät tuntemattoman henkilön linjoilla. Ylläpitäjä voi saada sen selville ilman ilmoitustasi, mutta olisi kohteliasta säästää hänet turhalta vaivalta.<br /><br />";
$pgv_lang["edituser_gedcomid_help"]	= "~#pgv_lang[gedcomid]#~<br /><br />Tämä on sisäinen (GEDCOM ID-tunnus), joka linkittää sinut omiin tietoihisi GEDCOM-tiedostossa.<br /><br />Et voi muuttaa tätä tunnusta.<br />Tämä on ylläpitäjän asettama linkki.<br />Mikäli mielestäsi ID-tunnus ei ole oikea, ota yhteyttä ylläpitäjään asian korjaamiseksi.<br />";
$pgv_lang["edituser_rootid_help"]		= "~#pgv_lang[rootid]#~<br /><br />Tämä on kaikkien kaavioittesi lähtöhenkilö.<br />Mikäli (esimerkiksi) klikkaat linkkiä esivanhempiin, lähtöhenkilö sijaitsee vasemmanpuoleisimmassa ruudussa.<br />Tämän lähtöhenkilön ei tietenkään tarvitse olla sinä itse. Voit aloittaa kenestä tahansa, jota sinulla on oikeus tarkastella.<br />Joissakin kaavioissa voit muuttaa lähtöhenkilöä, mutta se koskee nimenomaan juuri niitä sivuja.<br />";
$pgv_lang["edituser_password_help"]	= "~#pgv_lang[password]#~<br /><br /> Salasana kannattaa muuttaa  säännöllisin välein.<br />Pidä mielessäsi, että jokainen, joka tuntee käyttäjätunnuksesi ja salasanasi pääsee käsiksi tietoihisi.<br />Salasanan pituuden tulisi olla vähintään 6 merkkiä. Mitä pidempi sen parempi. Voit käyttää kaikkia aakkosia ja muita merkkejä, jotka ovat näppäimistössäsi.<br /><br /><b>Huomaa: Älä</b> käytä \" (kaksinkertaiset lainausmerkit) tai ' (yksikertaiset lainausmerkit). Niiden toimimisesta ei ole takeita.<br /><br /><b>Yhdistele suuria ja pieniä aakkosia, numeroita ja muita merkkejä.</b> Esimerkki: 5Z_q\$P4=r9.<br /><br />Kuten käyttäjätunnuksessa, myös salasanassa on <b>eroa suurten ja pienten</b> kirjainten välillä. Esimerkiksi \"Jo5hn\" ei ole sama kuin \"jo5hn\" tai \"JO5HN\".";
$pgv_lang["edituser_conf_password_help"] 	= "~#pgv_lang[confirm]#~<br /><br />Mikäli olet muuttanut salasanaasi, sinun on myös varmistettava se.<br />Tämä vain varmistukseksi, että et ole tehnyt kirjoitusvirhettä salasanakentässä.<br />Mikäli ohjelma havaitsee, että salasana ja sen varmistus eivät täsmää, saat tämän ilmoituksen: <b>#pgv_lang[password_mismatch]#</b>.<br /> Sekä salasana- että varmistuskenttä tyhjenevät ja saat kirjoittaa uudestaan kumpaankin kenttään.<br />";
$pgv_lang["edituser_change_lang_help"]	= "~#pgv_lang[change_lang]#~<br /><br /> Tässä voit määrittää tämän sivuston oletuskielen.<br />Ohjelma kykenee tunnistamaan selaimesi <b> oletuskilelen</b> joten useimmiten ohjelman kieliasetukseen ei tarvitse puuttua.<br />Jos kuitenkin selaimesi oletuskieli on englanti, mutta haluat <b>tällä sivustolla</b> käyttää suomea tai hepreaa, voit sen asettaa tässä.<br /><br />";
$pgv_lang["edituser_email_help"]		= "~#pgv_lang[emailadress]#~<br /><br />Oikea sähköpostiosoitteesi on meille tärkeä yhteydenpitoa varten.<br />Jos saat uuden sähköpostiosoitteen esimerkiksi vaihtaessasi palveluntarjoajaa, muista muuttaa se myös tässä.<br />Jos sinulla on useampia sähköpostiosoitteita ja haluat saada postia meiltä toiseen osoitteeseen, vaihda se tässä.<br />";
$pgv_lang["edituser_user_theme_help"]	= "~#pgv_lang[user_theme]#~<br /><br />Tällä sivustolla on useita teemoja.<br />Voit kutsu niitä myös sivuasetuksiksi. Jokaisessa teemassa näkyvät samat tiedot.<br />Ihan kuin sijoittaisit kuvan erilaiseen kehykseen ja ripustaisit sen eri huoneeseen. Kuva ei muutu, mutta tapa jolla sen näet muuttuu.<br />Sen kun kokeilet. Valitse toinen teema, katso sitä, katso toista ja pala siihen josta pidit eniten.<br />Joka kerta kirjautuessasi sivustolle ohjelma näyttää sinun valitsemasi teeman.<br />";
$pgv_lang["edituser_contact_meth_help"]	= "~#pgv_lang[user_contact_method]#~<br />Sähköpostijärjestelmämme ja joitakin muita yhteydenpitomenetelmiä<br />Sähköpostin lähettämismenetelmän asettaa ylläpitäjä. Sitä et voi muuttaa.<br /><b> Viestien vastaanottamismenetelmän</b> voit asettaa itse.<br />Tällä hetkellä voit valita yhden neljästä menetelmästä.";
$pgv_lang["mail_option1_help"]		= "Tällä vaihtoehdolla käytetään PhpGedView-ohjelman omaa sisäistä viestintäjärjestelmää eikä sähköposteja lähetetä.<br />Tällä tavoin saat vain <b>sisäisiä</b> viestejä muilta käyttäjiltä. Kun toinen käyttäjä lähettää sinulle viestin  tässä palvelussa, saat sen viestialueelle omalle OmaGedView-sivulle (ellet ole siirtänyt tätä aluetta sivultasi)<br />";
$pgv_lang["mail_option2_help"]		= "Tämä vaihtoehto on kuin #pgv_lang[messaging]#, mutta yhdellä lisäyksellä.<br />Kopio viestistä lähetetään myös käyttäjätilissäsi olevaan sähköpostiosoitteeseen.<br />Tämä viestintämenetelmä on oletusasetuksena.<br />";
$pgv_lang["mail_option3_help"]		= "Tällä vaihtoehdolla saat viestit vain sähköpostiosoitteeseesi.<br />Muut käyttäjät eivät saavuta sinua sisäisellä viestintäjärjestelmällä.<br />";
$pgv_lang["mail_option4_help"]		= "Tällä vaihtoehdolla et saa viestejä lainkaan.<br />";

//-- Add user

//-- Admin
$pgv_lang["admin_help"]			= "Tällä sivulla ovat linkit asetussivuille, ylläpitosivuille, dokumentointiin ja lokisivuille.<br /><br /><b>Järjestelmäaika</b>, joka sijaitsee heti sivun otsikon alla, näyttää sivustoa ylläpitävän palvelimen aikaa. Näytettävä aika on palvelimen aika kun avasit tai päivitit sivun.<br /><br /><b>VAROITUS</b>Kun näet varoituksen järjestelmäajan alapuolella, merkitsee se sitä, että <b>config.php</b> on vielä muutettavissa! Kun olet konfiguroinut sivustosi, sinun tulisi <b>turvallisuussyistä</b> asettaa tämä tiedosto <b>vain luku-tilaan</b>. Tämä on tehtävä käsin, koska PhpGedView ei pysty sitä (vielä) automaattisesti tekemään.<br /><br />Linkkien \"Lue minut\", \"Käyttäjäopas\" ja \"Lokitiedosto\" lisäksi saa lisätietoa kyseisiltä sivuilta.";

//-- User Admin
$pgv_lang["useradmin_help"]			= "~KÄYTTÄJIEN YLLÄPITO~<br /><br />Tällä sivulla voit hallita nykyisiä käyttäjiä ja lisätä uusia.<br /><br /><b>Nykyiset käyttäjät</b><br />Tässä taulukossa näkyvät nykyiset käyttäjät, heidän tilansa ja oikeutensa.<br />Voit <b>poistaa</b> ja <b>muokata</b> käyttäjiä.<br /><br /><b>Lisää uusi käyttäjä</b><br />Tämä lomake on melkein sama kuin \"Oma käyttäjätilisi\".<br />Monille kohdille ei ylläpitäjälle ole tehty erillistä opastetekstiä. Niissä tapauksissa näet seuraavan viestin:";
$pgv_lang["useradmin_gedcomid_help"]	= "~GEDCOM INDI -TIETUEEN ID-TUNNUS~<br /><br />Tämän GEDCOM-tietueen ID-tunnuksen asettaa ylläpitäjä.<br />Sillä tunnistetaan käyttäjä.<br />Sen avulla käyttäjä myös pääsee käsiksi esi- ja jälkipolvitauluihinsa.<br /><br />Jokaiselle GEDCOM-tiedostolle, jota käytät tässä ohjelmassa, voit asettaa käyttäjän GEDCOM-tietueen ID-tunnuksen.<br />Mikäli käyttäjällä ei ole tietuetta GEDCOM-tiedostossa, jätetään tekstikenttä tyhjäksi.";
$pgv_lang["useradmin_rootid_help"]		= "~ESIPOLVIKAAVION LÄHTÖHENKILÖ~<br /><br />Jokaiselle ohjelman GEDCOM-tiedostolle voit määritellä käyttäjän <b>lähtöhenkilön</b><br />Luultavasti henkilö haluaa käynnistää ohjelman omalla esipolvitaululla, mutta tämä ei ole pakko.<br /><br />Käyttäjä voi myös muuttaa tätä asetusta käyttäjätilissään.";
$pgv_lang["useradmin_can_admin_help"]	= "~KÄYTTÄJÄ VOI YLLÄPITÄÄ VALINTARUUTU~<br /><br />Mikäli tämä ruutu on rastitettu, käyttäjällä on samat oikeudet kuin sinulla tässä ohjelmassa.<dl><dt>Hän voi:</dt><dd>lisätä / poistaa / muokata käyttäjiä</dd><dd>lähettää viestejä kaikille käyttäjille kerralla</dd><dd>muokata tervetuloa-viestejä</dd><dd>muokata ja configuroida kielitiedostoja</dd><dt>Lisäksi:</dt><dd>päivittää ohjelman</dd><dd>muuttaa asetuksia</dd><dd>ylläpitää GEDCOM-tiedostoja</dd><dd>muuttaa yksityisyysasetuksia</dd><dd>ja tehdä kaikkea muuta tässä mainitsematonta.</dt><dd>Mutta ei muuttaa sivuston asetuksia ohjelman ulkopuolella.</dd></dl>";
$pgv_lang["useradmin_sync_gedcom_help"]	= "~#pgv_lang[sync_gedcom]# VALINTARUUTU~<br /><br />Mikäli tämä ruutu on rastitettu ja käyttäjälle on osoitettu GEDCOM ID-tunnus, hänen käyttäjäasetuksensa synkronoituvat automaattisesti GEDCOM-tietojen kanssa. Eli jos käyttäjän GEDCOM-tietuetta muokataan, tietyt tiedot kuten sähköpostiosoite ja nimi kopioituvat käyttäjän käyttäjätilitietoihin. Kun käyttäjätilitietoja muokataan, kopioituvat tiedot vastaavasti GEDCOM-tietueeseen.";
$pgv_lang["useradmin_can_edit_help"]	= "~KÄYTTÄJÄN OIKEUDET~<br /><br />Käyttäjällä voi järjestelmän jokaiselle GEDCOM-tiedostolle olla tietyt pääsy- ja muokkausoikeudet.<br /><br />Asettamalla nämä <b>ei oikeuksia</b>-tilaan, merkitsee se, että käyttäjä ei pääse käsiksi tämän GEDCOM-tiedoston yksityisiin tietoihin. Asettamalla tämä tilaan <b>Lukuoikeus</b> merkitsee se, että käyttäjä ei voi muokata tai hyväksyä tietoja tietokantaan, mutta voi selata yksityistietoja.<br /><br />Asettamalla tämä tilaan <b>muuta</b> käyttäjä voi muokata tietoja, mutta käyttäjän, jolla on <b>hyväksymisoikeudet</b> on hyväksyttävä muutokset ennen kuin ne tallennetaan tietokantaan ja näytetään julkisesti.<br /><br />Asettamalla tämä tilaan <b>hyväksy</b> sallii käyttäjän tehdä muutokset ja hyväksyä muiden tekemät muutokset.<br /><br /><b>Ylläpito</b> antaa käyttäjälle oikeudet muuttaa tämän GEDCOM-tiedoston asetuksia ja yksityisyysmäärittelyjä.<br /><br />Järjestelmän ylläpitäjällä on automaattisesti <b>ylläpito</b>-oikeudet.";
$pgv_lang["useradmin_verified_help"]	= "~KÄYTTÄJÄ VARMENSI ITSENSÄ~<br /><br /><b>Itserekisteröinti</b><br />Käyttäjä voi pyytää itselleen uutta käyttäjätiliä <b>itserekisteröinti</b>-modulilla.<br />Mikäli hän on näin toiminut hän saa sähköpostin, jossa on linkki pyynnön varmentamiseksi.<br />Mikäli hän jo on näin menetellyt on valintaruutu rastitettu ja voit jatkaa seuraavaan vaiheeseen: <b>Ylläpitäjä hyväksynyt käyttäjän</b><br />Mikäli käyttäjä ei ole varmentanut itseänsä, sinun tulee odottaa hyväksymisen kanssa.<br /><br /><b>Lisää käyttäjä manuaalisesti</b><br />Mikäli käytät lomaketta lisätäksesi käyttäjän manuaalisesti, tulevat valintaruudut olemaan jo rastitettuja.";
$pgv_lang["useradmin_verbyadmin_help"]	= "~YLLÄPITÄJÄN HYVÄKSYMÄ~<br /><br />Mikäli käyttäjä on käyttänyt itserekisteröintimodulia ja varmentanut itsensä, on sinun viimeisenä vaiheena hyväksyttävä pyyntö ennen kuin hänen käyttäjätilinsä on voimassa.<br /><br />Hyväksymisesi jälkeen käyttäjä saa sähköpostiviestin, että hänen käyttäjätilinsä on voimassa ja että hän voi kirjautua järjestelmään hakemuksen yhteydessä antamansa käyttäjätunnuksen ja salasanan avulla.";
$pgv_lang["useradmin_edit_user_help"]	= "~PÄIVITÄ KÄYTTÄJÄTILI~<br /><br />Tätä lomaketta ylläpitäjä käyttää päivittämään käyttäjän käyttäjätiliä.<br /><br />Lomake on melko samanlainen kuin lomake \"Lisää käyttäjä\" tai \"Oma käyttäjätilini\".";
$pgv_lang["useradmin_visibleonline_help"]	= "~NÄKYVISSÄ ON-LINE~<br /><br />Mikäli tämä ruutu on rastitettu, muut kirjautuneet voivat nähdä kun olet järjestelmässä ja voit nähdä milloin he ovat järjestelmässä. Mikäli et halua, että muut näkevät sinun olevan järjestelmässä, jätä ruutu rastittamatta. Myöskään sinä et silloin näe muita kirjautuneita.";
$pgv_lang["useradmin_editaccount_help"]	= "~MUUTA KÄYTTÄJÄTIETOJA~<br /><br />Mikäli tämä ruutu on rastitettu tämä käyttäjä voi muuttaa heidän käyttäjätietojaan. Mikäli ruutu ei ole rastitettu, he eivät voi muuttaa käyttäjätietojaan. Tällä tavoin voit luoda yhden käyttäjätunnuksen ja salasanan usealle käyttäjälle yhteisesti ja estää heitä muuttamasta käyttäjätietojaan.";
$pgv_lang["useradmin_relation_priv_help"]	= "~#pgv_lang[user_relationship_priv]#~<br /><br />Mikäli tämä ruutu on rastitettu, käyttäjä pääsee käsiksi tietoihin vain niistä elävistä henkilöistä , joille hän on sukua. Näkyvien sukulaisten sukulasuussuhteen laajuus riippuu <i>#pgv_lang[user_path_length]#</i>-asetuksesta. Voit vaatia yksityisyysasetusta sukulaisuudelle kaikille käyttäjille aktivoimalla GEDCOM yksityisyysasetuksissa olevan globaalin vaihtoehdon.<br /><br />Tämä asetus vaatii, että käyttäjä on kytketty GEDCOM ID-tunnukseen, ennen kuin yksikään elossa oleva henkilö näkyy.<br /><br />";
$pgv_lang["useradmin_path_length_help"]	= "|~#pgv_lang[user_path_length]#~<br /><br />Mikäli <i>#pgv_lang[user_relationship_priv]#</i> on aktivoitu, tämä käyttäjä pääsee käsiksi vain niiden elävien henkilöiden tietoihin, jotka ovat tämän sukulaisuusporrastuksen sisällä.<br /><br />";
$pgv_lang["useradmin_auto_accept_help"]	= "~#pgv_lang[user_auto_accept]#~<br /><br />Rastittamalla tämän ruudun sallit järjestelmän automaattisesti hyväksyä kaikki käyttäjän tekemät muutokset. Käyttäjällä tulee myös olla hyväksytyt oikeudet GEDCOM-tiedostoon, jotta tämä asetus astuisi voimaan.<br /><br />";

$pgv_lang["help_managesites"] 		= "~SIVUSTOJEN YLLÄPITO~<br /><br />Tällä sivulla voit lisätä etäsivustoja ja estää IP-osoitteita.<br /><br />Etäsivuston voi lisätä antamalla sivuston nimi, URL, tietokantatunniste (valinnainen), käyttäjätunnus ja salasana etäpalveluun.<br /><br />IP-osoitteiden esto tehdään antamalla asianmukainen IP-osoitealue. Esimerkiksi 212.10.*.*. Ne etäsivustot, joilla on estolistan ilmoittamat IP-osoitteet, eivät pääse omalle sivustollesi. Voit estää myös yksittäisiä IP-osoitteita.";
$pgv_lang["help_remotesites"]		= "~Etäsivustojen lisäys~<br /><br />Lisätäksesi etäsivuston anna sen nimi, URL, tietokantatunnus (valinnainen) ja käyttäjätunnus ja salasana. Klikkaa Lisää-painiketta. Mikäli etäsivusto sallii kirjautumisen tuntemattomana, jätä käyttäjätunnus ja salasana tyhjäksi.";
$pgv_lang["help_banning"]			= "~IP-osoitteiden esto~<br /><br />Estääksesi etäsivuston pääsyn omaan palveluusi, anna tarkka IP-osoite tai IP-osoitealue, esimerkiksi 212.10.*.*. ja klikkaa Hyväksy painiketta.";
$pgv_lang["help_manual_search_engines"]	= "~Manuaalinen hakurobottimerkintä~<br /><br />PhpGedView toimittaa hakukoneille automaattisesti pieniä tiedostoja, joissa on vähemmän linkkejä. Tieto on rajoitettu henkilöön ja hänen omaan perheeseensä ilman tietoja isovanhemmista tai lapsenlapsista. Useat raportit ja palvelinta kuormittavat sivut kuten kalenterit ovat hakuroboteilta kielletty.<br /><br />Mikäli hakukonetta ei automaattisesti ole tunnistettu ja haluat toimittaa sille indeksoitavaa aineistoa, voit lisätä hakukoneen tähän. Mikäli et halua toimittaa sille tietoa, voit lisätä sen alapuolella olevaan kiellettyjen IP-osoitteiden luetteloon.<br /><br />Mikäli haluat nähdä mitä tietoja annetaan hakukoneelle indeksoitavaksi, lisää oma IP-osoitteesi tähän.<font color=red>VAROITUS:</font> Tämä sulkee sinut ylläpitäjän käyttöliittymästä ja sinun on poistettava IP-osoite kirjautumalla toiseen koneeseen tai käsin muokattava tiedostoa <i>/index/search_engines.php</i>.<br /><br />Mikäli haluat käsin merkitä etäsivuston hakurobotiksi, lisää IP-osoite tai IP-osoitealue (esim. 212.10.*.*) ja klikkaa \"Lähetä\"-painiketta. Useat suositut hakukoneet kuten Google ja Yahoo havaitaan automaattisesti.";
$pgv_lang["search_engine_landing_page"]	= "~Havaittu hakumoottori~<br /><br />PhpGedView tuottaa hakumoottoreille automaattisesti pienemmät datatiedostot vähemmin linkein. Tieto rajoittuu lähiomaisiin ilman tietoa isovanhemmista tai lapsenlapsista. Useat raportit ja palvelinta runsaasti kuormittavat sivut kuten kalenteri, ovat hakurobottien ulottumattomissa.<br /><br />Mikäli hakurobotit pyrkivät sellaisille sivuille  näytetään tämä sivu. Mikäli näet tämän tekstin ohjelma kuvittelee, että olet hakurobotti. Alla on luettelo niistä sivuista, joihin hakuroboteilla on pääsy, ja joilta on saatavissa pienempi datamäärä.<br /><br />Todelliset käyttäjät, jotka seuraavat hakumoottorien antamia linkkejä tälle sivustolle, näkevät koko sivut ja kaiken siinä olevan tiedon eivätkä tätä sivua.";

//-- G E D C O M
$pgv_lang["add_upload_gedcom_help"]	= "~GEDCOM-tiedoston LISÄÄMISEN JA LÄHETYKSEN VÄLINEN ERO~<dl><dt><b>GEDCOM-tiedostojen lähetys</b></dt><dd>Tiedostojen lähettäminen palvelimelle voi tapahtua on-line tilassa. <br />Voit lähettää mistä tahansa paikasta tarvitsematta ftp-ohjelmaa.</dd><dt><b>GEDCOM-tiedostojen lisääminen</b></dt><dd>Mikäli tiedosto on vielä olemassa GEDCOM-kansiossasi, voit käyttää sitä ilman palvelimelle lähettämistä. <br />Joskus on tarve käyttää lisäämistä lähetyksen sijaan joko tiedostokoon tai lähetyskoon rajoitusten vuoksi.</dd></dl>Kummankin toimenpiteen voi suorittaa neljässä yksinkertaisessa vaiheessa. Vain ensimmäinen vaihe on erilainen.<br /><br />";
$pgv_lang["gedcom_configfile_help"]		= "~GEDCOM ASETUSTIEDOSTO~<br /><br />Tähän tiedostoon on tallennettu kaikki GEDCOM-tiedoston perusasetukset. Jokaisella GEDCOM-tiedostolla on oma asetustiedostonsa.<br /><br />Läydät kunkin tiedoston polun ja nimen <b>#pgv_lang[current_gedcoms]#</b>-taulusta sivulla <b>#pgv_lang[gedcom_adm_head]#</b>.<br /><br />";
$pgv_lang["default_gedcom_help"]		= "~GEDCOM OLETUSTIEDOSTO~<br /><br />Mikäli sinulla on enemmän kuin yksi GEDCOM-tiedosto ohjelmassasi, voit tässä määrittää mikä niistä on <b>oletustiedosto</b>.<br /><br />Oletustiedosto on se GEDCOM-tiedosto, joka näkyy vieraille sekä käyttäjille, jotka eivät ole kirjautuneet.<br /><br />Käyttäjät jotka voivat muuttaa tilinsä asetuksia voivat ohittaa tämän määrittelyn ja nähdä haluamansa tietokannan kirjauduttuaan sisään.<br />";
$pgv_lang["delete_gedcom_help"]		= "~POISTA GEDCOM-TIEDOSTO~<br /><br />PhpGedView tuo tietueita GEDCOM-tiedostosta. Kun klikkaat <b>poista</b>, ohjelma pyyhkii ne tietueet, jotka on tuotu GEDCOM-tiedostosta. <br />Varsinainen GEDCOM-tiedosto jää siihen kansioon, minne se on ladattu.<br /><br />Mikäli myöhemmin taas haluat käsitellä kyseistä GEDCOM-tiedostoa, sitä ei tarvitse enää ladata uudestaan palvelimelle vaan voit käyttää vaihtoehtoa <b>Lisää GEDCOM</b>.<br /><br />Klikattuasi \"Poista\", sinun on <b>vahvistettava</b> se ponnahdusikkunassa.";
$pgv_lang["add_gedcom_help"]		= "~LISÄÄ GEDCOM~<br /><br />Kun käytät \"Lisää GEDCOM\" vaihtoehtoa oletetaan, että olet jo ladannut GEDCOM-tiedostosi palvelimelle <i>käyttäen erillistä ohjelmaa</i> kuten esimerkiksi <b>ftp-ohjemaa</b>. <br />Mikäli GEDCOM-tiedostosi ei vielä ole palvelimella, se on toimitettava sinne ennen kuin voit aloittaa lisäämisen.<br /><br />Saat toimintaohjeet vaihe vaiheelta.<br />";
$pgv_lang["add_new_gedcom_help"]		= "~#pgv_lang[add_new_gedcom]#~<br /><br />Voit aloittaa uuden sukutietokannan aivan alusta.<br /><br />Voit toteuttaa sen muutamassa vaiheessa. Vaihe 1 eroaa siitä, mihin olet tottunut lataamisessa ja lisäämisessä. Muut vaiheet ovat tuttuja.<ol><li><b>Vaihe 1: Uuden GEDCOM-tiedoston nimeäminen</b><br />Syötä uuden GEDCOM-tiedoston nimi <u>ilman</u> tiedostopäätettä <b>'.ged'</b>. Uusi tiedosto luodaan siihen kansioon, joka ilmenee syöttökentän yläpuolella.<br />Klikkaa <b>Lisää</b>.</li><li><b>Vaihe 2: Konfigurointisivu</b><br />Tämän sivun tunnet jo GEDCOM-tiedoston konfiguroinnista.</li><li><b>Vaihe 3: Varmenna</b><br />Myös tämän sivun tunnet aiemmasta. Uusi GEDCOM-tiedosto tarkastetaan ja hyväksytään.</li><li><b>Vaihe 4: Tietueiden tuonti</b><br />Koska tuotavana on vain yksi tietue tämä suoritetaan hyvin nopeasti.</li></ol>Nyt voit mennä esipolvikaavioon nähdäksesi ensimmäisen henkilön uudessa GEDCOM-tiedostossasi. Klikkaa henkilön nimeä ja aloita muokkaus. Sen jälkeen voit liittää uusia henkilöitä ensimmäiseen henkilöön.<br /><br />";
$pgv_lang["download_gedcom_help"]	= "~LATAA GEDCOM~<br /><br />Voit ladata GEDCOM-tiedoston sivustoltasi omalle koneellesi.<br /><br />\"Lataa GEDCOM\"-sivulla on mahdollista muuntaa tiedosto muodosta <b>UTF-8</b> muotoon <b>ANSI (ISO-8859-1)</b><br />Tarvitsemasi muoto riippuu ohjelmasta, jolla aiot käsitellä lataamaasi GEDCOM-tiedostoasi.<br />Tarkista ohjelmasi ohjeistuksesta jos et ole varma.";
$pgv_lang["edit_gedcoms_help"]		= "~#pgv_lang[gedcom_adm_head]#~<br /><br />Sivulla #pgv_lang[gedcom_adm_head]# voit ylläpitää kaikkia sukutietokantojasi.<br /><br /><b>#pgv_lang[current_gedcoms]#</b><br />Taulussa <b>#pgv_lang[current_gedcoms]#</b> päällä näet neljällä toiminnolla varustetun toimintopalkin.<ul><li>#pgv_lang[add_gedcom]#</li><li>#pgv_lang[upload_gedcom]#</li><li>#pgv_lang[add_new_gedcom]#</li><li>#pgv_lang[lang_back_admin]#</li></ul>Taulussa <b>#pgv_lang[current_gedcoms]#</b> jokainen tietokanta on listattu erikseen ja sinulla on seuraavat vaihtoehdot jokaiselle niistä:<ul><li>Tuo</li><li>Poista</li><li>Lataa</li><li>Muokkaa asetuksia</li><li>Muokkaa yksityisyysasetuksia</li><li>SearchLog-tiedostot</li></ul>Muokkaa yksityisyysasetuksia näkyy täällä koska joka GEDCOM-tiedostolla on oma yksityisyystiedostonsa.<br /><br />Joka rivin tässä taulussa pitäisi olla itsestään selvä.  PhpGedView voidaan asettaa kirjaamaan ylös kaikki tietokantahaut. SearchLog-tiedostoja voi tarkkailla tältä sivulta löytyvän linkin kautta.<br />#pgv_lang[more_help]#<br />";
$pgv_lang["edit_config_gedcom_help"]	= "~KONFIGUROI GEDCOM~<br /><br />Jokaisella tässä ohjelmassa käyttämälläsi GEDCOM-tiedostolla on oma <b>asetustiedosto</b>nsa.<br /><br />Tällä lomakkeella teet perusasetukset kuten esimerkiksi kieli, kalenterimuoto, sähköpostin asetukset, jne., jne.<br />";
$pgv_lang["import_gedcom_help"]		= "~TUO GEDCOM~<br /><br />Useimmissa tapauksissa GEDCOM-tiedoston tuonti on yksi askel proseduurissa kuten lisäys, lisää uusi tai lataa GEDCOM-tiedosto palvelimelle.<br /><br />Nämä tapahtuvat loogisessa järjestyksessä ja on toteutettava kokonaan, jotta voit käsitellä GEDCOM-tiedostoa. <br />Mikäli et toteuttanut edellä kuvattuja vaiheita, näytetään <b>varoitus</b>, että GEDCOM-tiedosto ei vielä ole tuotu. Klikkaa siinä tapauksessa linkkiä tuodaksesi GEDCOM-tiedoston (uudelleen).<br /><br /><b>Tuonti</b><br /><br />GEDCOM-tiedoston asetukset eivät muutu, kun tuot GEDCOM-tiedoston uudestaan. <br />Olemassa oleva tieto kirjoitetaan yli.";
$pgv_lang["upload_gedcom_help"]		= "~LATAA GEDCOM PALVELIMELLE~<br /><br />Toisin kuin vaihtoehdossa \"Lisää GEDCOM\" palvelimella ei ennestään tarvitse olla GEDCOM-tiedostoa.<br /><br />Vaiheessa 1 valitset GEDCOM-tiedoston omalta koneeltasi. Syötä koko tiedostopolku tekstikenttään tai käytä sivun <b>Selaa</b>-painiketta.<br /><br />Lisää ohjeita löytyy proseduurin muilta sivuilta.<br />";
$pgv_lang["validate_gedcom_help"]		= "~VARMENNA GEDCOM~<br /><br />Tämä on kolmas vaihe toimenpiteessä, jossa lisäät ulkopuolista GEDCOM-tietoa sukututkimuksesi tietokantaan. <br /><br />PhpGedView tarkistaa, että tuodun tiedoston päivämäärän, paikan, merkistön jne. muodot ovat oikeat. Jotkin poikkeamat GEDCOM 5.5.1 standardista voidaan automaattisesti korjata. Esimerkkeinä MacIntosh rivinpäätös ja väärä paikkaformaatti. Jos näin tapahtuu ilmestyy tiedote, että kyseinen tieto on muutettu. Muista poikkeamista annetaan tiedote, jossa on suositeltava ratkaisu. <br /><br /><b>Valittavat työkalut</b><br />Tällä hetkellä on olemassa vain yksi valittava työkalu: <br /><b>Muuta henkilön ID-tunniste...</b>.<br />#pgv_lang[more_config_help]#<br />";
$pgv_lang["convert_ansi2utf_help"]		= "~MUUNNA ANSI MUOTOON UTF-8~<br /><br />Varmistaakseen, että ohjelma käsittelee GEDCOM-tiedostoasi oikein, tiedostojen täytyy olla muodossa UTF-8.<br /><br />Useimmat kolmannen osapuolen sukututkimusohjelmat osaavat viedä GEDCOM-tiedoston UTF-8-muodossa. <br />Mikäli käyttämäsi ohjelma ei osaa sitä tehdä, PhpGedView osaa tehdä muunnoksen.<br /><br />Kun PhpGedView varmentaa ladatun (tai lisätyn) tiedoston, ohjelma havaitsee, mikäli se on ANSI-muodossa.";
$pgv_lang["detected_ansi2utf_help"]		= "~HAVAITTU ANSI-MUOTO~<br /><br />Nyt varmennettava GEDCOM-tiedosto on ANSI-muodossa.<br />Suositellaan, että merkistö muutetaan UTF-8 muotoon<br /><br  />#pgv_lang[convert_ansi2utf_help]#";
$pgv_lang["detected_date_help"]		= "~HAVAITTU VÄÄRÄ PÄIVÄMÄÄRÄMUOTO~ <br /><b>PÄIVÄMÄÄRÄMUOTO MUUTETAAN</b><br /><br />PhpGedView-ohjelman ja <b>GEDCOM 5.5. standardin</b> mukaan voimassa oleva päivämäärämuoto on muotoa DD MMM YYY (esim. 01 JAN 2004).<br /><br />Mikäli ohjelma ilmoittaa GEDCOM-tiedoston varmennuksen jälkeen, että se on havainnut väärän päivämäärämuodon, se muuntaa sen standardin mukaiseen muotoon.<br /><br />Voit kuitenkin valita joko \"<b>päivä</b> ennen kuukautta\" (DD MMM YYYY) tai \"<b>kuukausi</b> ennen päivää\" (MMM DD YYYY). <br />Ensimmäistä vaihtoehtoa suositellaan kuitenkin.";
$pgv_lang["change_indi2id_help"]		= "~MUUTA HEKILÖN ID-TUNNUS~<br /><br />Tämä työkalu laadittiin niille käyttäjille, jotka käyttävät sellaisia GEDCOM-ohjelmia, jotka käyttävät eri henkilön ID-tunnusta joka kerta kun GEDCOM-tiedosto eksportoidaan. Esimerkiksi ensimmäisellä vientikerralla henkilön ID-tunnus on I100, mutta seuraavalla kerralla saman henkilön ID on I234. Nämä muuttuvat tunnukset hankaloittavat PhpGedView-ohjelman ylläpitoa, koska henkilöihin viitataan ID-tunnuksen mukaan.<br /><br />Useimmat sukututkimusohjelmat käyttävät myös RIN ja REFN merkitsintä yksilöimään kunkin henkilön. Tämä työkalu korvaa kaikki GEDCOM-tiedoston ID-arvot toisella määrittelemäsi kentän arvolla. Voit valita joko RIN tai REFN kentän  korvaamaan ID-tunnuksen.<br /><br />";
$pgv_lang["edit_privacy_help"]		= "Tällä sivulla voit tehdä kaikki yksityisyysasetukset valittuun GEDCOM-tiedostoon (tai tiedostoihin, jos niitä on useampia).<br />Voit tarkistaa sivuotsikon alta oletko muokkaamassa oikeata yksityisyystiedostoa. <br />Se näyttää seuraavalta: (tiedostopolku/gedcomtiedostosinimi_priv.php)<br /><br />Mikäli tarvitset lisää asetusarvoja, voit käsin tehdä muutokset yksityisyystiedostoon. Lisätietoa on PhpGedView verkkosivuilla.<br /><br />";
$pgv_lang["BOM_detected_help"]		= "~Byte Order Mark (BOM) havaittu~<br /><br />Ladattavan GEDCOM-tiedostosi alussa on tietty 3-tavuinen koodi. Jotkut ohjelmat käyttävät tätä koodia osoittamaan, että tiedosto on koodattu UTF-8-merkistöllä.<br /><br />Vaikka tämä erikoinen koodi ei olekaan virhe, PhpGedView ei toimi oikein, mikäli tiedostossa on tämä koodi. Sinun tulisi antaa PhpGedView-ohjelman poistaa se.<br /><br />";
$pgv_lang["invalid_header_help"]		= "~VIRHEELLINEN GEDCOM-TIEDOSTON ALKU~<br />GEDCOM-tiedoston ensimmäisen rivin tulee olla HEAD 0. PhpGedView havaitsi, että tiedoston ensimmäinen rivi ei ole 0 HEAD. Kun klikkaat siivoa-painiketta, kaikki rivit enne ensimmäistä 0 HEAD riviä poistetaan GEDCOM-tiedostostasi.<br /><br />Tämä virhe merkitsee yleensä sitä, että se ohjelma, jolla yritit luoda GEDCOM-tiedoston ei tehnyt sitä kunnolla tai kyseessä ei ole GEDCOM-tiedosto.. Tarkista, että latasit oikean GEDCOM-tiedoston ja että se alkaa rivillä 0 HEAD ja päättyy riviin 0 TRLR.";
$pgv_lang["macfile_detected_help"]		= "~HAVAITTU MACINTOSH-TIEDOSTO~<br />PhpGedView havaitsi, että GEDCOM-tiedostosi on luotu MacIntosh-tietokoneella. MacIntosh-tiedostot käyttävät eri rivinloppua (r) kuin Unix (n) tai Windows (rn). PhpGedView-ohjelman funktiot edellyttävät, että GEDCOM-tiedostot ovat joko Unix- tai DOS-tieodstoja. Kun klikkaat siivoa-painiketta, tiedostosi muunnetaan DOS-muotoon.<br />";
$pgv_lang["cleanup_places_help"]		= "~SIIVOA PAIKAT~<br />PhpGedView havaitsi, että GEDCOM-tiedostosi käyttää paikkoja sellaisten merkitsimien kohdalla, joissa ei pitäisi olla paikkoja. Useat sukututkimusohjelmat, kuten Family Tree Maker, luo tällaisia GEDCOM-tiedostoja. PhpGedView toimii tällaisten tiedostojen kanssa, mutta paikkahierarkiaan ilmestyy vääriä paikkoja.<br /><br />Esimerkiksi GEDCOM-tiedostossasi voi olla seuraava koodi:<br />1 SSN<br />2 PLAC 123-45-6789<br />GEDCOM määrittelyn mukaan sen tulisi olla<br />1 SSN 123-45-6789<br />Jos valitset <b>kyllä</b>, PhpGedView havaitsee ja korjaa nämä koodausvirheet.<br />";
$pgv_lang["empty_lines_detected_help"]	= "~HAVAITTU TYHJIÄ RIVEJÄ~<br />PhpGedView havaitsi, että GEDCOM-tiedostossasi on tyhjiä rivejä. Nämä voivat aiheuttaa virheitä ja poistetaan, ennen GEDCOM-tiedoston tuontia.<br />";

//-- Edit Config
$pgv_lang["help_editconfig.php"]		= "~KONFIGUROI PHPGEDVIEW~<br /><br />Tällä sivulla sinun on tehtävä ohjelman yleisasetukset heti sen jälkeen kun olet asentanut PhpGedView-ohjelman palvelimellesi ja käytät sitä ensimmäistä kertaa.<br />#pgv_lang[review_readme]#<br /><br /> Koska nämä asetukset ovat <b>yleisasetuksia</b> ne koskevat koko ohjelmaa ja kaikkia GEDCOM-tiedostoja, joita käytät ohjelmassa.<br />Jokaiselle GEDCOM-tiedostolle voit tehdä omat asetukset.<br />Koska olet tällä asetussivulla, voit klikata linkkiä ylläpidä GEDCOM-tiedostoja heti lomakkeen yläpuolella.<br />Kaikkialla ohjelmassa löydät tämän linkin  OmaGedView-ikonin valikosta.";

//-- merge records
$pgv_lang["help_edit_merge.php"]		= "~#pgv_lang[merge_records]#~<br /><br />Tällä sivulla voit liittää toisiinsa kaksi GEDCOM-tietuetta samasta GEDCOM-tiedostosta. Tämä on hyödyllistä henkilöille, jotka ovat yhdistänet GEDCOM-tiedostoja ja joilla nyt on useita identtisiä henkilöitä, perheitä ja lähteitä.<br /><br />Sivulla on kolme vaihetta:<br /><ul><li><b>Vaiheessa 1</b> pyydetään syöttämään kaksi ID-tunnusta. Tunnusten täytyy olla samaa typpiä. (Et voi yhdistää henkilöä ja perhettä tai perhettä ja lähdettä). Kenttään \"yhdistä tähän\" syötä se ID-tunnus, jonka haluat olevan uuden tietueen yhdistämisen jälkeen. Kenttään \"yhdistä tästä\" syötetään sen tietueen ID, joka on tarkoitus yhdistää ja joka poistetaan tämän jälkeen.</li><li><b>Vaiheessa 2</b> pyydetään valitsemaan ne tiedot, jotka halutaan säilyttää yhdistettävistä tietueista. Klikkaa säilytettävien asioiden vieressä olevia valintaruutuja. </li><li><b>Vaiheessa 3</b> näytetään yhdistämisen tulos. Kuten kaikissa muissakin on-line muutoksissa muutoksen on hyväksyttävä ennen kuin ne astuvat voimaan.</li></ul><br />";

//-- report engine
$pgv_lang["help_reportengine.php"]		= "~RAPORIT~<br /><br />PhpGedView:n raporttimoottori käyttää XML mallipohjia luomaan automaattisesti PDF-raportteja. Ensimmäisenä vaiheena on valittava raporttityyppi. Käytettävissä olevat raporttimallit luodaan \"reports\"-kansiossa olevien raporttien perusteella. Kun olet valinnut raporttimallin, sinun on annettava tälle raportille spesifiset tiedot mistä henkilöstä tai perheestä lähdetään liikkeelle ja näytetäänkö valokuvat. Kun olet valmis ajamaan raportin, klikkaa painiketta \"#pgv_lang[download_report]#\" ladataksesi raportin kovalevyllesi.<br /><br />Voit luoda oman raporttimallin kopioimalla olemassa olevan mallipohjan ja tekemällä muutokset sen XML-koodiin. Lisätäksesi oman raportti, kopioi se \"reports\"-kansioon ja PhpGedView havaitsee sen automaattisesti ja lisää sen \"Valitse raportti\" alasvetovalikkoon.";
$pgv_lang["def_pdf_format_help"]		= "~PDF-TIEDOSTOMUOTO~<br />PhpGedView raportointimoottori tuottaa ladattavia raportteja Adobe&reg; PDF-muodossa. GEDCOM 5.5.1 standardin määrittely, joka on mainittu muualla tässä Help-tiedostossa, on myös ladattavissa PDF-tiedostona. PDF on lyhenne sanoista <b>P</b>ortable <b>D</b>ocument <b>F</b>ormat.<br /><br />PDF-tiedostoja ei voi katsoa tai tulostaa tietokoneesi standardiohjelmistolla. Mikäli sinulla jo on asennettuna koneellesi Acrobat Reader, sinun ei tarvitse päivittää sitä voidaksesi avata PhpGedView-ohjelman tuottamia PDF-raporttitiedostoja.<br /><br />Näiden tiedostojen lukemiseen ja tulostamiseen tarvittava Acrobat Reader on ladattavissa ilmaiseksi osoitteesta  <a href=\"http://www.adobe.com\" target=_blank><b>Adobe Systems Inc.</b></a>. Acrobat Reader on ladattavissa muiltakin sivustoilta, mutta suosittelemme luottamaan <u>vain</u> Adobe Systems Inc. sivustoa. <br /><br />Acrobat Reader on saatavilla useille eri käyttöjärjestelmille kuten Microsoft&reg; Windows ja Apple&reg; Macintosh, ja monella eri kielellä. Mikäli sinulla on Windows 95, käytä Acrobat Reader versiota 5.0.5, koska uudemmat versiot eivät toimi Windows 95 järjestelmässä.<br /><br />";
$pgv_lang["help_ahnentafel.xml"]		= "~#pgv_lang[ahnentafel_report]#~<br />Tämä on raportti valitusta henkilöstä ja hänen esivanhemmistaan tulostettuna vihkosen muotoon. Se alkaa ensimmäisestä henkilöstä ja jatkuu hänen vanhempiinsa, isovanhempiinsa jne. <br /><br />Huomaa, että ahnentafelraportti on saatavissa vain englanniksi tällä hetkellä.<br /><br />";
$pgv_lang["help_birthlist.xml"]			= "~#pgv_lang[birth_report]#~<br />Tässä raportissa voit luetella kaikki henkilöt, jotka ovat syntyneet tiettynä aikana tai tietyssä paikassa.<br /><br />";
$pgv_lang["help_relativelist.xml"]		= "~#pgv_lang[relatives_report]#~<br />Tämä raportti luetteloi kaikki tietyn henkilön sukulaiset. Voit valita mitkä henkilön sukulaisista näytetään raportissa.<ul><li><b>#pgv_lang[child-family]#</b> näyttää henkilön sekä hänen vanhempansa ja sisaruksensa.</li><li><b>#pgv_lang[spouse-family]#</b> näyttää henkilön sekä hänen puolisonsa ja lapsensa.</li><li><b>#pgv_lang[direct-ancestors]#</b> näyttää henkilön, hänen vanhempansa, isovanhempansa, isoisovanhempansa jatkuen sukupuuta ylöspäin suoraan ylenevässä polvessa.</li><li><b>#pgv_lang[ancestors]#</b>näyttää samat kuin </li><li><b>#pgv_lang[ancestors]#</b> ja lisäksi sedät, tädit, isosedät ja -tädit sekä serkut. Serkusten lapsia ei näytetä.</li><li><b>#pgv_lang[descendants]#</b> näyttää henkilön ja kaikki suoraan alenevassa polvessa olevat lapset, lapsenlapset, lapsenlapsenlapset jne.</li><li><b>#pgv_lang[all]#</b> yhdistää #pgv_lang[descendants]# ja #pgv_lang[ancestors]# yhteen raporttiin.</li></ul><br /><br />";
$pgv_lang["help_xml_reports"]		= "~Raporttimoottori~PhpGedView raporttimoottori käyttää XML-mallitiedostoja luomaan PDF-raportteja. Käytettävissä olevat raportit <b>#pgv_lang[select_report]#</b>-luettelossa muodostetaan raportti- XML-tiedostoista, jotka ovat \"report\"-kansiossa. Voit laatia omia raportteja kopioimalla ja muokkaamalla mitä tahansa olemassa olevaa XML-mallitiedostoa. Tallenna muokkaamasi raportti \"reports\"-kansioon ja PhpGedView havaitsee sen automaattisesti ja asettaa sen käytettäväksi <b>#pgv_lang[select_report]#</b> alasvetovalikossa.<br /><br />";

//-- Help Contents
$pgv_lang["help_contents_head_help"]	= "<b>Ohjeen sisältö</b><br /><br />";
$pgv_lang["help_contents_gedcom_info"]	= "GEDCOM tieto";
$pgv_lang["help_contents_gedcom_places"] = "Paikat GEDCOM-tiedostossa";

//-- Admin Help Contents Items
$pgv_lang["admin_help_contents_head_help"]	= "<b>OHJEEN SISÄLTÖ<br /><br />ADMINISTRATOR HELP ITEMS</b> added to the beginning of the list.<br /><br />";
$pgv_lang["ah2_help"]				= "_konfiguroi PhpGedView";
$pgv_lang["ah3_help"]				= "_GEDCOM: vertaa lisää - lataa palvelimelle ";
$pgv_lang["ah4_help"]				= "_GEDCOM: asetustiedosto";
$pgv_lang["ah5_help"]				= "_GEDCOM: oletus";
$pgv_lang["ah6_help"]				= "_GEDCOM: poista";
$pgv_lang["ah7_help"]				= "_GEDCOM: lisää";
$pgv_lang["ah8_help"]				= "_GEDCOM: luo uusi";
$pgv_lang["ah9_help"]				= "_GEDCOM: lataa omalle koneelle";
$pgv_lang["ah10_help"]			= "_GEDCOM: ylläpitosivu";
$pgv_lang["ah11_help"]			= "_GEDCOM: konfiguroi";
$pgv_lang["ah12_help"]			= "_GEDCOM: tuo";
$pgv_lang["ah13_help"]			= "_GEDCOM: lataa palvelimelle";
$pgv_lang["ah14_help"]			= "_GEDCOM: varmenna";
$pgv_lang["ah15_help"]			= "_GEDCOM: muunna ANSI-muodosta UTF-8-muotoon";
$pgv_lang["ah16_help"]			= "_GEDCOM: yksityisyysasetukset";
$pgv_lang["ah17_help"]			= "_GEDCOM: käyttäjien ylläpito";
$pgv_lang["ah18_help"]			= "_ylläpito";
$pgv_lang["ah19_help"]			= "_GEDCOM: mediatyökalu";
$pgv_lang["ah20_help"]			= "_GEDCOM: muuta henkilön ID-tunnus";
$pgv_lang["ah21_help"]			= "_kielitiedostot";
//           22 is in the help_text_vars.php
$pgv_lang["ah23_help"]			= "_Konfiguroi tuettuja kieliä";
$pgv_lang["ah24_help"]			= "_käyttäjätiedon muunnos (Indeksi -->> SQL)";
$pgv_lang["ah25_help"]			= "Käyttäjätietojen varmuuskopio";
$pgv_lang["ah26_help"]			= "_UKK-luettelo: muokkaa";
$pgv_lang["help_statisticsplot.php"] 		= "~Tilasto Graafi~<br /><br />Tämä on yhteenvetosivu, jossa näytetään edellisen sivun syöttötietojen perusteella tietokannastasi lasketut tilastolliset kuvaajat. ";
$pgv_lang["help_statistics.php"] 		= "~Tilasto Graafi~<br /><br />Tällä sivulla voit määritellä ne kriteerit, joiden perusteella laaditaan kuvaajat tietokantasi tilastotiedoista.<br /><br />";
$pgv_lang["stat_help"]				= "~TILASTOLLISTEN KUVAAJIEN VAIHTOEHDOT~<br /><br />Tietokantasi tilastotiedoista voidaan laatia erilaisia kuvaajia.<br /><br />Valitse muuttujat pudotusvalikoista ja säädä sitten vaihtoehtojen arvot sopiviksi.<br /><br />Kuhunkin kuvaajaan sisältyvät numeroarvot riippuvat käytettävissä olevasta aineistosta. Esimerkiksi henkilöitä, joille ei ole ilmoitettu syntymäkuukautta (esimerkiksi vain vuosi '1856') ei voida sisällyttää kuvaajaan syntymistä kuukausittain.<br /><br />";
$pgv_lang["stat_help_x"]			= "~TILASTOKUVAAJIEN VAIHTOEHDOT~<br /><br />~X-AKSELI~<br />Seuraavat vaihtoehdot ovat käytettävissä X-akselilla (vaaka-akselilla). Kukin vaihtoehto esitetään edelleen Y- ja Z-akseleille asetettujen valintojen perusteella.<p style=\"padding-left: 25px\"><b>#pgv_lang[stat_11_mb]#</b>&nbsp;&nbsp;Kunakin kuukautena syntyneet henkilöt.<br /><b>#pgv_lang[stat_12_md]#</b>&nbsp;&nbsp;Kunakin kuukautena kuolleet henkilöt.<br /><b>#pgv_lang[stat_13_mm]#</b>&nbsp;&nbsp;Kunakin kuukautena sattuneet  avioliittoon vihkimiset.<br /><b>#pgv_lang[stat_14_mb1]#</b>&nbsp;&nbsp;Kunakin kuukautena perheelle syntyneet esikoiset.<br /><b>#pgv_lang[stat_15_mm1]#</b>&nbsp;&nbsp;Kunakin kuukautena solmitut ensimmäiset avioliitot.<br /><b>#pgv_lang[stat_16_mmb]#</b>&nbsp;&nbsp;Avioliiton ja ensimmäisen lapsen syntymän välinen aika kuukausina kyseisessä perheessä.<br /><b>#pgv_lang[stat_17_arb]#</b>&nbsp;&nbsp;Ikä kuollessa suhteessa ajanjaksoon, joka sisältää kunkin henkilön syntymävuoden.<br /><b>#pgv_lang[stat_19_arm]#</b>&nbsp;&nbsp;Henkilöiden keskimääräinen ikä heidän avioituessaan.<br /><b>#pgv_lang[stat_20_arm1]#</b>&nbsp;&nbsp;Henkilöiden keskimääräinen ikä heidän avioituessaan ensimmäisen kerran.<br /><b>#pgv_lang[stat_21_nok]#</b>&nbsp;&nbsp;Keskimääräinen perhekoko.<br /><b>#pgv_lang[stat_1_map]#</b>&nbsp;&nbsp;henkilöiden tai tietyn nimisten henkilöiden sijoittuminen maan mukaan.<br /><b>#pgv_lang[stat_2_map]#</b>&nbsp;&nbsp;Synnyinmaa.<br /><b>#pgv_lang[stat_4_map]#</b>&nbsp;&nbsp;Maa, jossa vihitty avioliittoon.<br /><b>#pgv_lang[stat_3_map]#</b>&nbsp;&nbsp;Maa, jossa kuollut..<br /><b>#pgv_lang[stat_9_indi]#</b>&nbsp;&nbsp;Piirakkakaavio henkilöistä, joilla lähde.<br /><b>#pgv_lang[stat_8_fam]#</b>&nbsp;&nbsp;Piirakkakaavio perheistä, joilla lähde.</p><br /><br />";
$pgv_lang["stat_help_y"]			= "~TILASTOKUVAAJIEN VAIHTOEHDOT~<br /><br />Y-AKSELI<br />Seuraavat vaihtoehdot ovat käytettävissä Y-akselilla (pystyakseli). Nämä valinnat vaikuttavat tapaan jolla asiat esitetään X-akselilla.<p style=\"padding-left: 25px\"><b>#pgv_lang[stat_201_num]#</b>&nbsp;&nbsp;esitetään henkilöiden lukumäärä X-akselilla esitettyjen luokkien mukaan jaoteltuna.<br /><b>#pgv_lang[stat_202_perc]#</b>&nbsp;&nbsp;lasketaan ja esitetään kunkin muuttujan suhteellinen osuus X-akselilla esitettyjen luokkien mukaan jaoteltuna.</p><br /><br />";
$pgv_lang["stat_help_z"]			= "~TILASTOKUVAAJIEN VAIHTOEHDOT~<br /><br />Z-AKSELI<br />Seuraavat vaihtoehdot ovat käytettävissä Z-akselilla. Näillä valinnoilla voidaan valita alajaottelu X-akselille määritellyistä luokista.<p style=\"padding-left: 25px\"><b>#pgv_lang[stat_300_none]#</b>&nbsp;&nbsp;Näyttää muuttujat yhtenä palstana kustakin X-akselin luokasta.<br /><b>#pgv_lang[stat_301_mf]#</b>&nbsp;&nbsp;Näyttää muuttujat kahtena palstana (miespuoliset ja naispuoliset)kustakin X-akselin luokasta.<br /><b>#pgv_lang[stat_302_cgp]#</b>&nbsp;&nbsp;Näyttää muuttujat niin monena palstana, kuin on määritetty seuraavassa jaksossa, kustakin X-akselin luokasta.</p><br /><br />";
$pgv_lang["stat_help_gwx"]			= "~TILASTOKUVAAJIEN VAIHTOEHDOT~<br /><br />~X-akselin raja-arvot~</ br>Valitse haluttu ikäjaksotus.<br /><br /> Esimerkiksi <b>#pgv_lang[aft_marr]#</b> kuvaa seuraavan kuukausijaksotuksen: <div style=\"padding-left:30px;\">ennen avioitumista<br />avioitumisesta 8 kuukautta eteenpäin<br />8 - 12<br />12 - 15<br />15 - 18<br />18 - 24<br />24 - 48<br />yli 48 kuukautta avioitumisen jälkeen</div><br /><br />Jos haluat nähdä vuosineljännekset, valitse: <b>vuosineljännekset</b>.<br /><br />";
$pgv_lang["stat_help_gwz"]			= "~TILASTOKUVAAJIEN VAIHTOEHDOT~<br /><br />~Z-akselin raja-arvot~</ br>Valitse alkuvuosi ja jaksotus .<br /><br /> Esimerkiksi <b>vuodesta 1700 jaksolla 50 vuotta</b> kuvaa seuraavat jaksot: <div style=\"padding-left:30px;\">ennen 1700<br />1700 - 1749<br />1750 - 1799<br />1800 - 1849<br />1850 - 1899<br />1900 - 1949<br />1950 - 1999<br />2000 ja sen jälkeen</div><br /><br />";

//-- Find Media Help
$pgv_lang["manage_media_help"]		= "Tällä sivulla voit hallita mediatiedostojasi ja hakemistojasi. <br /><br /> Luodessasi uusia media-alihakemistoja PhpGedView varmistaa, että identtinen hakemistorakenne <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs</b>-hakemiston kanssa säilyy. Kun lataat palvelimelle uusia mediatiedostoja PhpGedView voi luoda pienoiskuvat automaattisesti. <br /><br /> Medialuettelossa olevan kunkin kuvan vierestä löydät seuraavat valinnat. Näytettävät valinnat riippuvat kyseisen mediatiedoston tilasta. <ul><li><b>#pgv_lang[edit]#</b>&nbsp;&nbsp;Klikatessasi tätä valintaa saat näkyviin sivun, jolla voit muuttaa mediakohteen nimen. Mikäli mediakohdetta ei ole linkitetty henkilöön, perheeseen tai lähteeseen aktiivisessa tietokannassa, voit luoda linkin tässä. Voit nimetä tiedoston uudelleen ja muuttaa sen sijaintia <b>#GLOBALS[MEDIA_DIRECTORY]#</b> hakemistorakenteen puitteissa. Tarpeen vaatiessa PhpGedView luo automaattisesti tarvittavat alihakemistot tai puuttuvat pienoiskuvat. </li><li><b>#pgv_lang[edit_raw]#</b>&nbsp;&nbsp;Tämä valinta on käytettävissä vain mikäli ylläpitäjä on sen aktivoinut. Voit tarkastella ja editoida raakaa GEDCOM-dataa, joka liittyy tähän mediakohteeseen. Käytä tätä valintaa varoen. </li><li><b>#pgv_lang[delete_file]#</b>&nbsp;&nbsp;Tällä valinnalla poistat kaiken tiedon mediatiedostosta tässä tietokannassa. Se ei vaikuta muihin tietokantoihin. Mikäli tästä tiedostosta ei ole mainintaa muissa tietokannoissa, se ja siihen kuuluva pienoiskuva poistetaan. </li><li><b>#pgv_lang[remove_object]#</b>&nbsp;&nbsp;Tällä valinnalla poistat kaiken tiedon mediatiedostosta tässä tietokannassa. Se ei vaikuta muihin tietokantoihin. Mediatiedostoa ja siihen kuuluvaa pienoiskuvaa ei poisteta. </li><li><b>#pgv_lang[remove_links]#</b>&nbsp;&nbsp;Tällä valinnalla poistat kaikki linkit mediakohteeseen tässä tietokannassa. Tiedostoa ei poisteta ja mediakohde säilyy tässä tietokannassa. Muihin tietokantoihin ei ole vaikutusta. </li><li><b>#pgv_lang[set_link]#</b>&nbsp;&nbsp;Tällä valinnalla luot linkit mediatiedoston ja henkilöiden, perheiden tai lähteiden välille tässä tietokannassa. Tarpeen vaatiessa PhpGedView luo mediakohteen, jonka tiedoston tietokanta tunnistaa. </li><li><b>#pgv_lang[gen_thumb]#</b>&nbsp;&nbsp;Tällä valinnalla PhpGedView luo puuttuvan pienoiskuvan. </li></ul><br /><br />";
$pgv_lang["simple_filter_help"]		= "~#pgv_lang[filter]#~<br /><br />Yksinkertainen hakusuodatin, joka perustuu syötettyihin merkkeihin. Jokerimerkkejä ei hyväksytä.<br /><br />";
$pgv_lang["show_thumb_help"]		= "~#pgv_lang[show_thumbnail]#~<br /><br />Pienoiskuvat näytetään, mikäli rastitat tämän valintaruudun.<br /><br />";
$pgv_lang["new_dir_help"]			= "~#pgv_lang[add_directory]#~<br /><br />Ylläpito-oikeuksilla sinun on mahdollista luoda kansiorakenne, jolla mediatiedostot pysyvät järjestyksessä. Luomalla kansiot tältä sivulta varmistetaan, että pienoiskuvakansio luodaan ja että kuhunkin kansioon luodaan sopiva index.php.<br /><br />Klikkaa tätä linkkiä nähdäksesi tekstikentän, johon voit syöttää luotavan kansion nimen.<br /><br />";
$pgv_lang["find_media_help"]			= "~#pgv_lang[find_media]#~<br /><br />Tämä mahdollistaa haun tiedostojärjestelmästä löytääksesi mediatiedoston, jonka haluat liittää.<br /><br />";
$pgv_lang["add_media_linkid"]		= "~Link ID~<br /><br />Jokainen mediatiedosto on liitettävä yhteen tai useampaan henkilöön, perheeseen tai lähteeseen tietokannassa.<br /><br />Tällaisen linkin luomiseksi voit lisätä tai hakea henkilön, perheen tai lähteen ID-tunnuksen samanaikaisesti luodessasi mediatiedoston. Voit myös linkin myöhemmin muokkaamalla Ylläpidä mediaa -sivua tai lisäämällä mediatiedosto käyttäen Lisää media -linkkiä henkilö-, perhe- tai lähdesivulla.<br /><br />";
$pgv_lang["upload_server_file_help"] 	= "~#pgv_lang[server_file]#~<br /><br />Palvelimelle ladattava mediatiedosto voidaan ja pitäisikin nimetä uudeellen. Tämä siksi, että omalla tietokoneellasi tiedoston nimellä voi olla jokin merkitys sinulle, mutta vähemmän merkitystä vierailijoille. Ajattele tilannetta, jossa sinä ja joku muu yritätte kummatkin ladata eri tiedoston nimellä \"vaari.jpg\".<br /><br />Tähän kenttään määrittelet uuden nimen lataamallesi tiedostolle. Antamasi nimeä käytetään myös pienoiskuvan nimeämisessä. Pienoiskuva joko ladataan erikseen tai luodaan automaattisesti. Älä lisää tiedostonimen tiedostomuototunnusta (.jpg, .gif, .pdf, .doc jne).<br /><br />Jätä tämä kenttä tyhjäksi, jos haluat säilyttää alkuperäisen nimen.<br /><br />";
$pgv_lang["upload_server_folder_help"] 	= "~#pgv_lang[server_folder]#~<br /><br />Ylläpitäjä on sallinut korkeintaan #GLOBALS[MEDIA_DIRECTORY_LEVELS]# kansiotasoa oletusarvon <b>#GLOBALS[MEDIA_DIRECTORY]#</b> lisäksi. Tämä auttaa median järjestämisessä ja vähentää nimiristiriitojen syntymistä.<br /><br />Tässä kentässä määrittelet sen kansion, johon ladattava mediatiedosto tallennetaan. Vastaava pienoiskuvatiedosto, joka on ladattu erikseen tai luotu automaattisesti, tallennetaan samanlaiseen kansiorakenteeseen alkaen hekemistosta <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b> kansion  <b>#GLOBALS[MEDIA_DIRECTORY]#</b> asemasta. Kohdekansion <b>#GLOBALS[MEDIA_DIRECTORY]#</b> osaa nimestä ei tarvitse lisätä.<br /><br />Mikäli et ole varma tähän lisättävästä tekstistä, ota yhteyttä ylläpitäjään.<br /><br />";
$pgv_lang["view_server_folder_help"] 	= "~#pgv_lang[server_folder]#~<br /><br />Ylläptäjä on sallinut #GLOBALS[MEDIA_DIRECTORY_LEVELS]# kansiotasoa oletuskansion <b>#GLOBALS[MEDIA_DIRECTORY]#</b> alapuolelle. Tämä auttaa mediatiedostojen järjestelyssä ja vähentää samannimisten tiedostojen aiheuttamia ristiriitatilanteita.<br /><br />Tässä kentässä valitset sen mediakansion, jonka sisältöä haluat tarkastella. Kun valitset <b>#pgv_lang[all]#</b>, kaikki mediatiedostot näytetään riippumatta missä kansiossa ne sijaitsevat. Tästä voi syntyä hyvin pitkä luettelo.<br /><br />";

//-- Alive in Year Help

//--Repository Help
$pgv_lang["help_repolist.php"]		= "~#pgv_lang[repo_list]#~<br /><br /> Tällä sivulla näytetään luettelo tietovarastoista. <br /><br />Tietovarastot ovat nimen mukaan järjestetty aakkosjärjestykseen kuten GEDCOM-tiedostossa.<br /><br /><b>TIETOVARASTOT</b><br />Ilman tietovarastoja ei tietokantaamme voi muodostaa. Kaikelle tietokannassa olevalle tiedolle on olemassa lähde ja tämä lähde pidetään tietovarastossa. Se voi olla henkilön henkilökohtainen arkisto, laitos, julkinen tietokanta, jne. Jotta pääsisimme käsiksi lähteeseen haluamme tietää missä se sijaitsee. Kaikki tarpeellinen tieto lähteen saavuttamiseksi pidetään tietovarastotietueessa. <br /><br />Tietovarasto voidaan linkittää moneen lähteeseen.<br /><br />";
$pgv_lang["help_repo.php"]			= "~YKSITYISKOHTAISIA TIETOJA TIETOVARASTOSTA~<br /><br />Tällä sivulla näytetään yksityiskohtaisia tietoja tietovarastosta. Yhdessä lähteiden kanssa tietovarastot ovat sukututkijalle hyvin tärkeitä ja mahdollistavat toisen tutkijan käyttämiä reittejä tiedon löytämiseksi. <br />Tällä sivulla voidaan näyttää tietovaraston nimi, osoite, sähköpostiosoite ja verkkosivun osoite.<br /><br />Tietovarastoa koskevien tietojen jälkeen on luettelo kaikista niistä lähteistä jotka on yhdistetty tähän tietovarastoon. Tällä tavoin voidaan nähdä kaikki tieto joka on saatu tietystä tietovarastosta.<br /><br />Mikäli ylläpitäjä on asettanut käytettäväksi, sivulla näkyy yksi tai kaksi muuta valikkokuvaketta:<br /><b>Näytä GEDCOM-tietue</b> - näyttää tiedon GEDCOM-muodossa.<br /><b>Lisää leikekoriin</b> - tämä tieto voidaan tallentaa leikekoriin. Sieltä voit ladata tiedon omalle koneellesi ja tuoda sen omaan sukututkimusohjelmaasi.<br /><br />Lisäohjeita sivulta löytyy klikkaamalla <b>?</b>";
$pgv_lang["delete_repo_help"]		= "~POISTA TIETOVARASTO GEDCOM-TIEDOSTOSTA~<br /><br />Klikkaamalla tätä merkitset tämän tietovaraston poistetavaksi GEDCOM-tiedostosta.<br />Mitä se merkitsee? <br />Mikäli sinulla on hyvä syy poistaa tämä tietovarasto, klikkaa linkkiä, jolloin aukeaa ponnahdusikkuna jossa kysytään oletko varma vai haluatko perua.<br /><br />Mikäli jatkat tietovaraston poistamista saattaa kestä hetken, ennen kuin uudessa ponnahdusikkunassa ilmoitetaan, että tietovarasto on poistettu.<br /><br />Kun jatkat vierailuasi havaitset, että tietovarasto on edelleen näkyvissä ja käytettävissä entiseen tapaan.<br /><br />Tämä <b>ei ole virhe</b>.<br />Ylläpitäjä saa viestin, että GEDCOM-tiedostoon on tehty muutos ja että olet poistanut tietovaraston. <br />Ylläpitäjä voi hyväksyä (tai hylätä) muutoksen. Vasta sen jälkeen poistaminen todellisuudessa tapahtuu.<br />Mikäli asiassa on epäselvyyksiä, ylläpitäjä ottaa sinun yhteyttä.";
$pgv_lang["show_repo_gedcom_help"]	= "~NÄYTÄ GEDCOMTIETUE~<br /><br />Klikkaamalla tätä linkkiä näytetään ponnahdusikkunassa tietovarastoa koskeva tieto sellaisen kuin se on tallennettu GEDCOM-tiedostoon.";
$pgv_lang["add_repository_clip_help"]	= "~LISÄÄ TIETOVARASTO LEIKEKORIIN~<br /><br />Klikkaamalla tätä linkkiä voit lisätä tietovaraston leikekoriin sellaisen kuin se on tallennettu GEDCOM-tiedostoon.";
$pgv_lang["repolist_listbox_help"]		= "~TIETOVARASTOJEN LUETTELORUUTU~<br /><br />Tässä ruudussa näytetään tietovarastojen nimet sellaisina kuin ne on tallennettu GEDCOM-tiedostoon.<br /><br />Nimet ovat aakkosjärjestyksessä.<br /><br />Klikkaamalla nimeä luettelossa, avautuu tietovarastosivu, jossa on lueteltu kyseiseen tietovarastoon yhdistetyt lähteet.";
$pgv_lang["repos_listbox_help"]		= "~TÄHÄN TIETOVARASTOON YHDISTETYT TIETUEET~<br /><br />Tässä ruudussa näytetään tähän tietovarastoon yhdistettyjen lähteiden nimet. <br />Nimet ovat aakkosjärjestyksessä.<br /><br />Klikkaamalla nimeä luettelossa avautuu kyseistä lähdettä koskeva sivu.";
$pgv_lang["block_move_up_help"]		= "~Muuta luettelon järjestystä~<br /><br />Käytä näitä painikkeita muuttaaksesi luettelon järjestystä. Alueet tulostetaan luettelon osoittamassa järjestyksessä.<br /><br />Korosta siirrettävää kohdetta ja klikkaa sitten painiketta siirtääksesi kohdetta ylös- tai alaspäin.<br /><br />";
$pgv_lang["block_move_right_help"]		= "~Siirrä luettelon kohteita~<br /><br />Käytä näitä painikkeita siirtääksesi luettelon kohteen toiseen luetteloon.<br /><br />Korosta siirrettävä kohde, ja klikkaa sitten painiketta siirtääksesi tai kopioidaksesi sen nuolen suuntaan. Käytä <b>&raquo;</b>- ja <b>&laquo;</b>-painikkeita siirtääksesi kohteen vasemmanpuoleisimmasta luettelosta oikeammanpuoleisimpaan tai päinvastoin. Käytä <b>></b>- ja <b><</b>-painikkeita siirtääksesi korostetun kohteen #pgv_lang[available_blocks]#-luettelon oikealla tai vasemmalla puolella olevaan luetteloon.<br /><br />Kohteet #pgv_lang[available_blocks]#-luettelossa eivät muutu  />#pgv_lang[move_right]#- ja #pgv_lang[move_left]#-painikkeiden klikkaamisesta huolimatta, koska sama alue voi esiintyä samalla sivulla useamman kerran. HTML-alue on hyvä esimerkki siitä, miksi näin haluat menetellä.<br /><br";
$pgv_lang["block_default_index"]		= "~Oletusalueet #pgv_lang[welcome]#-sivulla#<br /><br />Kun tyhjennät luettelot #pgv_lang[main_section]# and #pgv_lang[right_section]#, tai kun klikkaat <b>#pgv_lang[reset_default_blocks]#</b>-painiketta, alue asettuu seuraavasti:<br /><br /><center><table border=\"1\"><tr><td class=\"list_value\"><b>#pgv_lang[main_section]#</b></td><td class=\"list_value\"><b>#pgv_lang[right_section]#</b></td></tr><td>#pgv_lang[gedcom_stats_block]#<br />#pgv_lang[gedcom_news_block]#<br />#pgv_lang[gedcom_favorites_block]#<br />#pgv_lang[review_changes_block]#</td><td>#pgv_lang[gedcom_block]#<br />#pgv_lang[random_media_block]#<br />#pgv_lang[todays_events_block]#<br />#pgv_lang[logged_in_users_block]#</td></tr></table></center><br />";
$pgv_lang["block_default_portal"]		= "~Oletusalueet #pgv_lang[mygedview]#-sivulla~<br /><br />Kun tyhjennät luettelot #pgv_lang[main_section]# ja #pgv_lang[right_section]#, tai klikkaat <b>#pgv_lang[reset_default_blocks]#</b>-painiketta, alue asettuu seuraavasti: <br /><br /><center><table border=\"1\"><tr><td class=\"list_value\"><b>#pgv_lang[main_section]#</b></td><td class=\"list_value\"><b>#pgv_lang[right_section]#</b></td></tr><td>#pgv_lang[todays_events_block]#<br />#pgv_lang[user_messages_block]#<br />#pgv_lang[user_favorites_block]#<br />&nbsp;</td><td>#pgv_lang[welcome_block]#<br />#pgv_lang[random_media_block]#<br />#pgv_lang[upcoming_events_block]#<br />#pgv_lang[logged_in_users_block]#</td></tr></table></center><br />";
$pgv_lang["help_faq.php"] 			= "~Yleisimmät kysymykset~<br />UKK (Usein kysytyt kysymykset) -sivu voi sisältää yleiskatsauksen tai luettelon kysymyksistä ja vastauksista tämän sukututkimussivuston käytöstä.<br /><br />UKK-sivun käyttö on täysin ylläpitäjän hallinnassa. Ylläptäjä valvoo jokaisen asian sisältöä ja myös asioiden esitysjärjestystä sivulla.<br />";
$pgv_lang["text_faq_help"] 			= "UKK (Usein kysytyt kysymykset) -sivu voi sisältää yleiskuvauksen tai luettelon kysymyksistä ja vastauksista tämän sukututkimussivuston käytöstä.<br /><br />Riippuu täysin ylläpitäjästä, miten UKK-sivua käytetään. Ylläpitäjä valvoo jokaisen kohteen sisältöä ja myös niiden järjestystä sivulla.";
$pgv_lang["hs_title_help"] 			= "<center>~#pgv_lang[hs_title]#~</center><br />#pgv_lang[hs_intro]#<br /><br />#pgv_lang[hs_keyword_advice]#<br /><br />#pgv_lang[hs_searchhow_advice]#<br /><br />#pgv_lang[hs_searchin_advice]#";
$pgv_lang["hs_intro"]				= "Voit tehdä hakuja PhpGedView:n ohjejärjestelmästä. #pgv_lang[hs_title]#-ominaisuus tekee mahdolliseksi sen, että hakufunktioita voidaan kontrolloida monipuolisesti. Haun pitäisi onnistua helposti.  ";
$pgv_lang["hs_keyword_advice"] 		= "~#pgv_lang[hs_keyword]#~<br />Lisää sana tai ilmaisu, jonka haluat löytää.<br /><br />Haku ei erottele pieniä ja suuria kirjaimia. Se merkitsee, että jos haet sanaa <b>Henkilö</b>, hakutulokseksi voi tulla <b>Henkilö</b>, <b>henkilö</b> tai <b>HENKILÖ</b>. Haku antaa myös tulokseksi <b>Henkilöt</b> jne., koska haku etsii merkkijonoja eikä sanoja.<br /><br />Voit hakea useita sanoja kerrallaan. Kirjoita kaikki haettavat sanat peräkkäin välilyönnillä erotettuna kuten esimerkiksi <b>henkilö&nbsp;suku&nbsp;lapsi</b>. Kun kirjoitat enemmän kuin yhden sanan, kirjoittamasi asioiden merkitys selkeytyy #pgv_lang[hs_searchhow]#-kentässä.< /br>";
$pgv_lang["hs_searchin_advice"]		= "~#pgv_lang[hs_searchin]#~<br />Tässä valitset haun kohteen.<br /><br />Ylläpitäjä voi tehdä hakuja käyttäjän ohjeesta tai konfiguraatio-ohjeesta tai kummastakin. Tavallisilla käyttäjillä ei ole tätä mahdollisuutta, koska heillä ei ole pääsyä konfigurointiominaisuuksiin. Tavallinen käyttäjä voi kohdistaa haun vain käytäjäohjetiedostoon.<br /><br />Ohjetiedostot sisältävät ohjetekstin lisäksi tiettyjä merkkijonoja joita käytetään luomaan lomakkeita ja muuta aineistoa. Tällä vaihtoehdolla voit valita kohdistetaanko haku koko ohjetiedostoon vai ainoastaan ohjetekstiin.<br />";
$pgv_lang["hs_searchhow_advice"]		= "~#pgv_lang[hs_searchhow]#~<br />Selvennät sitä mitä olet tarkoittanut #pgv_lang[hs_keyword]#-kentässä tekemällä valinnan tässä esitetyistä vaihtoedoista.<br /><dl><dt><b>#pgv_lang[hs_searchany]#</b></dt><dd>Mikäli olet kirjoittanut <b>henkilö&nbsp;perhe&nbsp;lapsi</b>, tämä vaihtoehto hakee  ohjeen, joka sisältää minkä tahansa näistä sanoista. Sanojen järjestyksellä ei ole merkitystä. Haku tapahtuu periaatteella \"Hae tekstiä, joka sisältää sanan <b>henkilö</b> <u>tai</u> <b>perhe</b> <u>tai</u> <b>lapsi</b>\".</dd><br /><dt><b>#pgv_lang[hs_searchall]#</b></dt><dd>Mikäli olet kirjoittanut <b>henkilö&nbsp;perhe&nbsp;lapsi</b>, tämä vaihtoehto hakee  ohjeen, joka sisältää kaikki nämä sanat. Sanojen järjestyksellä ei ole merkitystä. Haku tapahtuu periaatteella \"Hae tekstiä, joka sisältää sanan <b>henkilö</b> <u>ja</u> <b>perhe</b> <u>ja</u> <b>lapsi</b>.\"</dd><br /><dt><b>#pgv_lang[hs_searchsentence]#</b></dt><dd>Mikäli olet kirjoittanut <b>henkilö&nbsp;perhe&nbsp;lapsi</b>, tämä vaihtoehto hakee ohjeen, joka sisältää kaikki nämä sanat tässä järjestyksessä. Haku tapahtuu periaatteella \"Hae tekstiä, joka sisältää sanat <b>henkilö&nbsp;perhe&nbsp;lapsi</b> juuri tässä järjestyksessä ilman mitään muita merkkejä tai sanoja niiden välissä.\" Et todennäköisesti löydä tällaista tekstiä mistään ohjetekstistä.<br /><br />Joitakin rajoituksia: Tietyt erikoismerkit, kuten <b>&quot; &lt; &gt;</b> jne. ovat ohjetekstissä symbolimuodossa eivätkä löydy, jos ne ovat hakusanojesi joukossa. Jotkut ohjetekstit sisältävät tietynlaisia välilyöntejä, joita edustavat <b>&amp;nbsp;</b> etkä löydä merkkijonoja, jotka sisältävät tämän merkin.</dd></dl>";
$pgv_lang["help_dir_editor.php"]		= "~#pgv_lang[index_dir_cleanup]#~<br /><br />Tällä työkalulla ylläpitäjä voi siivota indeksikansion. Ajan mittaan lokitiedostot, vanhat GEDCOM-tiedostot ja vanhat varmuuskopiot voivat täyttää indeksikansion. Koska ohjelma luo useat näistä tiedostoista, na voivat olla verkkopalvelimen käyttäjän omistuksessa, jolloin et voi poistaa niitä. Tällä työkalulla voit poistaa myös ne, vaikka ne olisivatkin verkkopalvelimen käyttäjän omistuksessa.<br /><br />#pgv_lang[index_dir_cleanup_inst]#";
$pgv_lang["register_gedcomid_help"]		= "~#pgv_lang[gedcomid]#~<br /><br />Jokaisella henkilöllä tietokannassa on oma yksilöllinen ID-tunnuksensa. Mikäli tiedät oman ID-tunnuksesi lisää se tähän. Mikäli et tiedä sitä tai et voinut löytää sitä yksityisyysasetusten vuoksi, toimita kommenttikenttään riittävästi tietoa itsestäsi jotta ylläpitäjä tunnistaa sinut voidakseen asettaa ID-tunnuksen.<br /><br />";
$pgv_lang["register_comments_help"]	= "~#pgv_lang[comments]#~<br /><br />Käytä tätä kenttää kertoaksesi ylläpitäjälle miksi haluat käyttäjätilin ja kuinka olet sukua tämän sivuston henkilöille. Voit lisätä tähän myös muita kommentteja, joita sinulla on ylläpitäjälle.<br /><br />";
$pgv_lang["context_help"]			= "Lisää ohjeita saa klikkaamalla <b>?</b> kohteen vieressä sivulla.";
$pgv_lang["edit_URL_help"]			= "Lisää URL-osoite http:// mukaanlukien.<br /><br />Esimerkki URL-osoitteesta on  http://www.phpgedview.net/<br /><br />Jätä tämä kenttä tyhjäksi, mikäli et halua lisätä URL-osoitetta.";
$pgv_lang["edit_EMAIL_help"]		= "Lisää sähköpostiosoite.<br /><br /> Esimerkki sähköpostiosoitteesta on <b>nimi@hotmail.com</b>. Jätä tämä kenttä tyhjäksi, mikäli et halua lisätä sähköpostiosoitetta.";
$pgv_lang["edit_FAX_help"]			= "Lisää telefaxnumero maa- ja suuntanumeroineen. <br /><br />Jätä tämä kenttä tyhjäksi, mikäli et halua lisätä telefaxnumeroa. Esimerkiksi numero Saksassa voi olla +49 25859 56 76 89 ja Yhdysvalloissa tai Kanadassa +1 888 555-1212.";
$pgv_lang["edit_PHON_help"]			= "Lisää puhelinnumero maa- ja suuntanumeroineen.<br /><br />Jätä tämä kenttä tyhjäksi, mikäli et halua lisätä puhelinnumeroa. Esimerkiksi numero Saksassa voi olla +49 25859 56 76 89 ja Yhdysvalloissa tai Kanadassa +1 888 555-1212.";
$pgv_lang["edit_ADDR_help"]		= "Lisää osoite kenttään samalla tavoin kuin kirjoittaisit sen kirjekuoreen.<br /><br />Jätä kenttä tyhjäksi, mikäli et halua lisätä osoitetta.";
$pgv_lang["edit_GIVN_help"]			= "#pgv_lang[edit_given_name_help]#";
$pgv_lang["edit_SPFX_help"]			= "~Sukunimen etuliite~<br /><br />Lisää tai valitse luettelosta sukunimeä edeltävä etuliite. Tällaisia ovat esimerkiksi <b>von</b> Braun, <b>van der</b> Kloot, <b>de</b> Graaf, jne.";
$pgv_lang["edit_SURN_help"]			= "#pgv_lang[edit_surname_help]#";
$pgv_lang["edit_NSFX_help"]			= "#pgv_lang[edit_suffix_help]#";
$pgv_lang["edit__MARNM_help"]		= "~#factarray[_MARNM]#~<br /><br />Lisää tämän henkilön avionimi käyttäen samoja muotosääntöjä kuin Nimi-kentässä. Tämä kenttä ei ole pakollinen.<br /><br />Esimerkiksi mikäli Mary Jane Brown avioitui John Whiten kanssa, voit lisätä (ilman lainausmerkkejä)<ul><li>Amerikkalainen tapa:&nbsp;&nbsp;\"Mary Jane Brown /White/\"</li><li>Eurooppalainen tapa:&nbsp;&nbsp;\"Mary Jane /White/\"</li><li>Vaihtoehtoinen eurooppalainen tapa:&nbsp;&nbsp;\"Mary Jane /White-Brown/\" tai \"Mary Jane /Brown-White/\"</li></ul>Tee näin vain mikäli Mary Jane Brown alkoi käyttää uutta nimeä avioiduttuaan John Whiten kanssa. Joissakin paikoissa, kuten esimerkiksi Kanadan Quebecissä, on laitonta muuttaa nimeä tällä tavoin.<br /><br />Miehet saattavat myös vaihtaa nimeään avioliiton jälkeen käyttäen joko kaksoisnimeä tai joskus ottaen puolison sukunimen.";
$pgv_lang["edit_PEDI_help"]			= "Tämä kenttä kuvaa lapsen suhdetta perheeseensä. Vaihtoehdot ovat: :<ul><li><b>#pgv_lang[unknown]#</b>&nbsp;&nbsp;&nbsp;Lapsen suhdetta perheeseensä ei voi määritellä. Kun tämä vaihtoehto valitaan, #factarray[PEDI]#-kenttää ei kopioida tietokantaa. .<br /><br /></li><li><b>#factarray[BIRT]#</b>&nbsp;&nbsp;&nbsp;Tämä vaihtoehto osoittaa, että lapsi on syntynyt perheeseensä.<br /><br /></li><li><b>#pgv_lang[adopted]#</b>&nbsp;&nbsp;&nbsp; Tämän vaihtoehdon mukaan lapsi on perheensä adoptoima. Tämä <b>ei</b> osoita, etteikö lapsen ja perheen väillä olisi verisiteitä. Se osittaa, että kyseinen perhe on adoptoinut lapsen joskus lapsen syntymän jälkeen. br /><br /></li><li><b>#pgv_lang[foster]#</b>&nbsp;&nbsp;&nbsp; Tämä osoittaa, että lasi on perheen ottolapsi. Yleensä lapsen ja hänen perheensä välillä ei ole verisiteitä.<br /><br /></li><li><b>#pgv_lang[sealing]#</b>&nbsp;&nbsp;&nbsp; Lapsi on sinetöity perheeseen <i>sinetöinti</i>-toimituksessa. Lapsen sinetöinti tapahtuu kun vanhemmat sinetöidään toisiinsa lapsen syntymän jälkeen. Lapset jotka ovat syntyneet vanhempiensa sinetöinnin jälkeen ovat automaattisesti sinetöity perheeseen.<br /><br /></li></ul>";
$pgv_lang["edit_AGNC_help"]		= "~#factarray[AGNC]#~<br /><br />Organisaatio, instituutio, yhteisö, henkilö tai toimielin, jolla on toimivalta.<br /><br />Esimerkiksi henkilön työnantaja, kirkko, joka voi suorittaa rituaaleja tai sakramentteja, tai organisaatio, joka voi luoda ja/tai arkistoida tapahtumia.";
$pgv_lang["edit_SEX_help"]                              = "#pgv_lang[edit_sex_help]#";
$pgv_lang["edit_NAME_help"]                           = "#pgv_lang[edit_name_help]#";
$pgv_lang["edit_add_unlinked_person_help"]	= "~#pgv_lang[add_unlinked_person]#~<br /><br />Käytä tätä lomaketta lisätäksesi yhteydettömän henkilön.<br /><br />Kun lisäät yhteydettömän henkilön sukupuuhusi, henkilö ei liity kehenkään ennen kuin luot yhteyden. Voit myöhemmin luoda yhteyden henkilöiden välille #pgv_lang[indi_info]#-sivun #pgv_lang[relatives]#-välilehdellä.";
$pgv_lang["edit_ROMN_help"]		= "~ROMANISOIDUT NIMET~<br /><br />Useissa kulttuureissa on tavallista kirjoittaa perinteiset nimet perinteisin kirjasimin ja myös nimen romanisoituna versiona sellaisena kuin se kirjoitettaisiin ja äännettäisiin latinalaisin kirjaimin kuten englannissa.<br /><br />Mikäli mieluummin käytät perinteisiä aakkosia, kuten hepreaa, kreikkaa, venäjää, kiinaa tai arabiaa vakionimikentässä, voit käyttää tätä kenttää nimen kirjoittamiseksi latinalaisin kirjaimin. Nimen kummatkin kirjoitusasut näkyvät myös luetteloissa ja kaavioissa.<br /><br />Vaikka tämä kenttä on merkitty termillä \"Romanisoitu\", sen käyttöä ei ole rajoitettu pelkästään latinalaisille aakkosille. Tätä voidaan käyttää japanilaisille nimille, joilla voi olla kolme erialista aakkostustapaa.";
$pgv_lang["edit__HEB_help"]			= "~HEPREALAINEN NIMI~<br /><br />Useissa kulttuureissa on tavallista kirjoittaa perinteiset nimet perinteisin kirjasimin ja myös nimen romanisoituna versiona sellaisena kuin se kirjoitettaisiin ja äännettäisiin latinalaisin kirjaimin kuten englannissa.<br /><br />Mikäli mieluummin käytät latinalaisia aakkosia vakionimikentässä, voit käyttää tätä kenttää nimen kirjoittamiseksi perinteisin kirjasimin, kuten hepreaksi, kreikaksi, venäjäksi, kiinaksi tai arabiaksi. Nimen kummatkin kirjoitusasut näkyvät myös luetteloissa ja kaavioissa.<br /><br />Vaikka tämä kenttä on merkitty termillä \"heprea\", sen käyttö ei ole rajoitettu pelkästään heprealaisille aakkosille.";
$pgv_lang["link_person_id_help"]		= "~#pgv_lang[label_local_id]#~<br /><br />Tähän kenttään lisäät sen henkilön ID-tunnukset, johon liityt (esim. I100).";
$pgv_lang["link_gedcom_id_help"]		= "~#pgv_lang[label_gedcom_id]#~<br /><br />Käytä tätä osiota valitaksesi yhdistettävän henkilön sisältävän vaihtoehtoisen tietokannan tunnisteen.";
$pgv_lang["link_remote_site_help"]		= "~#pgv_lang[label_site]#~<br /><br />Tässä määrittelet ne parametrit, joita tarvitaan kytkeytymiseksi siihen etäsivustoon, jossa yhdistettävä tieto on. Voit joko valita aiemmin käyttämiesi sivustojen luettelosta tai kirjoittamalla  #pgv_lang[label_site_url2]# ja #pgv_lang[label_gedcom_id]# uutta varten.<br /><br /><b>#pgv_lang[label_site_url2]#</b>-kenttään kirjoitat URL-osoitteen päästäksesi verkkokuvaustiedostoon (WDSL), joka kertoo PhjGedView-ohjelmalle miten päästä käsiksi etäsivuston aineistoon. PhpGedView etäsivustolla URL WSDL-tiedosto näyttää seuraavalta: <u>http://www.etapalvelin.com/phpGedView/genservice.php?wsdl.</u><br /><br /><b>#pgv_lang[label_gedcom_id]#</b>-kenttää käytetään lisäämään vaihtoehtoinen tietokantatunnistin sitä vaativille etäsivustoille. PhpGedView-sivustoilla se on GEDCOM-tiedoston nimi.<br /><br /><i>Huomaa: Etäpalvelimien on käytettävä PhpGedView-ohjelman versiota 3.4 tai uudempaa; vanhemmilla versioilla ei ole tätä ominaisuutta.</i>";
$pgv_lang["link_remote_location_help"]	= "~#pgv_lang[label_location]#~<br /><br />Tällä vaihtoehdolla voit valita onko yhdistettävän henkilön tiedot samalla sivustolla, mutta eri sukupuutietokannassa vai onko tieto eri sivustolla, johon pääsee käsiksi internetin välityksellä.<br /><br />Mikäli henkilön tiedot ovat samalla sivustolla, sinun on valittava tietokantatunnistin ja kirjoitettava henkilön ID-tunnus.<br /><br />Etäsivuston ollessa kyseessä, on kirjoitettava sen URL, tietokantatunnistin ja henkilön etä-ID-tunnus.";
$pgv_lang["link_remote_rel_help"]		= "~#pgv_lang[label_rel_to_current]#~<br /><br />Käytä tätä vaihtoehtoa valitaksesi sukulaisuussuhteen, joka on ulkoisella sivustolla olevan henkilön ja omalla sivustolla olevan henkilön välillä. Esimerkiksi valitsemalla <i>Isä</i> merkitsee, että ulkoisella sivustolla oleva henkilö on paikallisesti yhdistettävän henkilön isä.";
$pgv_lang["link_remote_help"]      		= "~#pgv_lang[link_remote]#~<br /><br />Käytä tätä lomaketta yhdistämään henkilö toiseen henkilöön joko toiselta sivustolta tai toisesta sukutietokannasta, johon omalla PhpGedView-ohjelmallasi voit päästä.<br /><br />Lisätäksesi sellaisen yhteyden, sinun on ensin valittava sukulaisuustyyppi, sitten joko PhpGedView-ohjelman ennestään tuntema sivusto tai määriteltävä uusi ja sitten vielä lisättävä sen henkilön ID-tunnus, johon haluat tehdä yhteyden. PhpGedView lataa sitten tarvittavat tiedot etäsivustolta. Ladattavasta tiedosta <u>ei</u> tule osaa omaa tietokantaasi, vaan jää alkuperäiseen paikkaansa ja lisätään niille sivuille, joilla yhdistetty henkilö näkyy.<br /><br />Lisätietoa saat sivun kunkin asian vierestä olevasta ohjelinkistä. Voit myös saada lisätietoa englanninkieliseltä neuvontasivustolta:<a href=\"#PGV_PHPGEDVIEW_WIKI#/en/index.php?title=How_To:Remote_Link_Individuals_Across_Websites_And_Databases\" target=\"_blank\">#PGV_PHPGEDVIEW_WIKI#</a>.";
$pgv_lang["edit_ABBR_help"]			= "~OTSIKKOLYHENNE~<br /><br />Käytä tätä kenttää tallentaaksesi lyhenteen otsikosta. Tätä kenttää käytetään lähteiden otsikkokentän yhteydessä. PhpGedView käyttää oletusarvoisesti ensin otsikkoa ja sitten otsikkolyhennettä.<br /><br />GEDCOM 5.5 määrittelyn perusteella, \"tätä kenttää käytetään antamaan lyhyt otsikko lähdetietueiden lajittelua, tallentamista ja etsimistä varten (s. 62).\" <br /><br />PhpGedView-ohjelmassa otsikkolyhenne on valinnainen, mutta se vaaditaan muissa sukututkimusohjelmissa.";
$pgv_lang["edit_add_unlinked_source_help"]	= "~#pgv_lang[add_unlinked_source]#~<br /><br />Käytä tätä linkkiä lisätäksesi uuden lähteen tietokantaan liittämättä lähdettä toisen tietueen lähdeviitteeseen. Uusi lähde näkyy lähdeluettelossa mutta ei missään kaaviossa tai muuallakaan ohjelmassa ennen kuin se on liitetty lähdeviitteeseen.";
$pgv_lang["random_media_start_slide_help"]	= "~#pgv_lang[random_media_start_slide]#~<br /><br />Tulisiko AJAX-diaesityksen käynnistyä automaattisesti kun sivu on ladattu.<br /><br />Tämä ominaisuus käyttää AJAX-tekniikkaa muuttamaan alueen sisältöä esilataamatta tietoa palvelimelta ja lataamatta koko sivua uudelleen.<br /><br />";

//any updates to the following??
$pgv_lang["random_media_ajax_controls_help"]	= "~#pgv_lang[random_media_ajax_controls]#~<br /><br />Voit käyttää tätä asetusta kytkemään päälle tai pois soittimen ohjauspainikkeet satunnaismedia-alueella.<br /><br />Näillä käyttäjä voi joko hypätä toiseen satunnaiseen kohteeseen tai esittää satunnaisesti valittuja kohteita, kuten esimerkiksi diaesityksen. Diaesitys muuttaa alueen sisältöä lataamatta uudestaan tietoa palvelimelta ja lataamatta koko sivua uudelleen.<br /><br /> ";
$pgv_lang["import_options_help"] 		= "Voit valita lisävaihtoehtoja käytettäväksi GEDCOM-tiedoston tuonnissa.";
$pgv_lang["verify_gedcom_help"]		= "Tässä voit vaihtoehtoisesti joko jatkaa tai keskeyttää tämän GEDCOM-tiedoston latauksen tai tuonnin.";
$pgv_lang["add_gedcom_instructions"]	= "Anna tiedostonimi tälle uudelle GEDCOM-tiedostolle. Uusi GEDCOM-tiedosto luodaan indeksikansioon: #INDEX_DIRECTORY#";
$pgv_lang["no_update_CHAN_help"] 		= "~#pgv_lang[no_update_CHAN]#~<br />Ylläpitäjän on joskus puhdistettava ja korjattava käyttäjän lähettämää tietoa. Esimerkiksi PLAC paikkatieto on korjattava niin, että se sisältää maatiedon. Kun ylläpitäjä tekee tällaisia korjauksia, tieto alkuperäisestä muutoksesta korvataan. Tätä ei ehkä haluta.<br /><br />Kun tämä vaihtoehto valitaan, PhpGedView säilyttää alkuperäisen muutostiedon sen sijaan että korvaisi sen nykyisen istunnon tiedolla. Ylläpitäjä voi myös muuttaa tai poistaa sen tiedon, joka on liitetty alkuperäiseen CHAN merkitsimeen.<br /><br />";
$pgv_lang["edit_SOUR_EVEN_help"]		= "~#pgv_lang[source_events]#~<br /><br />Jokaiseen lähteeseen liittyy tietty tapahtuma, yleensä tietyn ajanjakson ja hallintoalueen sisällä. Esimerkiksi Väestönlaskenta luetteloi väestönlaskenta-tapahtumat ja kirkonkirjat sisältävät syntymä-, vihkimis- ja kuolintapahtumat.<br /><br />Valitse ne tapahtumat, jotka tämä lähde sisältää annettujen tapahtumien luettelosta. Päivämäärät tulee määritellä ajanjakso muodossa <i>FROM 1900 TO 1910</i>. Hallintoalue on sen matalimman tason hallintoalueen nimi, joka sisältää kaikki tämän lähteen nimeämät matalamman tason paikat. Esimerkiksi \"Oneida, Idaho, USA\" on lähteen hallintoalue tapahtumille, jotka esiintyvät Oneidan piirikunnan eri kaupungeissa.\"Idaho, USA\" on lähteen hallintoalue tapahtumille, jotka esiintyvät Oneidan piirikunnan lisäksi myös muissa piirikunnissa Idahon osavaltiossa.<br /><br />";
$pgv_lang["cache_life_help"]			= "~#pgv_lang[cache_life]#~<br /><br />Tehostaakseen toimivuutta tämä PhpGedCom tervetuloasivu tallennetaan välimuistitiedostona. Voit määritellä kuinka usein tämän alueen välimuistitiedosto päivitetään.<br /><br /><ul><li><b>-1</b> merkitsee, että välimuistitiedostoa ei päivitetä automaattisesti. Saadaksesi uuden version kaikki välimuisitiedostot on poistettava. Tämä voidaan tehdä \"Räätälöi tervetuloasivu\"-sivulla.</li><li><b>0</b> (nolla) tarkoittaa, että tätä sivua ei koskaan tallenneta välimuistiin. Joka kerta kun tämä alue näytetään PhpGedCom tervetuloasivulla, näkyviin tulee tuore versio. Tätä asetusta käytetään automaattisesti alueilla, jotka muuttuvat usein, kuten #pgv_lang[logged_in_users_block]# ja #pgv_lang[random_media_block]# alueita.</li><li><b>1</b> (yksi)</b> merkitsee, että välimuistitiedosto päivitetään päivittäin, <b>2</b> merkitsee, että välimuistitiedosto päivitetään joka toinen päivä, <b>7</b> merkitsee, että välimuistitiedosto päivitetään viikoittain, jne.</li></ul><br /><br />";
$pgv_lang["clear_cache_help"]		= "~#pgv_lang[clear_cache]#~<br /><br />Ohjelman toimivuuden tehostamiseksi useat alueet PhpGedView tervetuloasivulla tallennetaan välimuistitedostoiksi indeksikansioon. Useimmat alueiden välimuistitiedostot päivitetään päivittäin, mutta joskus haluat ehkä päivittää ne käsin.<br /><br />Tällä painikkeella voit tehdä päivityksen tarvittaessa.";
$pgv_lang["move_mediadirs_help"]		= "~#pgv_lang[move_mediadirs]#~<br />Kun mediapalomuuri on aktivoitu, multimediatiedostoja voi tallentaa sellaiseen kansioon palvelimella, johon ei pääse internetin kautta. Näillä painikkeilla voit siirtää kokonaisen mediatiedostorakenteen suojatun (ei verkosta osoitettavan) <b>#GLOBALS[MEDIA_FIREWALL_ROOTDIR]##GLOBALS[MEDIA_DIRECTORY]#</b> kansion ja normaalin <b>#GLOBALS[MEDIA_DIRECTORY]#</b> kansion välillä.<br /><br />";
$pgv_lang["edit_ROMN_GIVN_help"]	= "#pgv_lang[edit_ROMN_help]#<br /><br />Tähän kenttään lisätään henkilön etunimet. Esimerkiksi nimestä \"Matti Juhani Suomalainen\" lisätään \"Matti Juhani\" tähän. <br /><br />";
$pgv_lang["edit_ROMN_SURN_help"]	= "#pgv_lang[edit_ROMN_help]#<br /><br />Tähän kenttään lisätään henkilön sukunimi. Esimerkiksi nimestä \"Matti Juhani Suomalainen\" lisätään \"Suomalainen\" tähän. Jos henkilöllä on useita sukunimiä, kuten Espanjassa ja Portugalissa, sukunimet erotetaan toisistaan pilkulla. Tällä osoitetaan, että henkilö listataan kaikkien kyseisten sukunimien alle. Esimerkiksi sukunimi \"Cortes,Vega\" listataan sekä <b>C</b>:n että <b>V</b>:n alle, kun taas sukunimi \"Cortes Vega\" listataan vain <b>C</b>:n alle.<br /><br />";
$pgv_lang["edit__HEB_GIVN_help"]	= "#pgv_lang[edit__HEB_help]#<br /><br /> Tähän kenttään kirjoitat henkilön etunimet. Esimerkiksi nimessä \"Matti Juhani Suomalainen\", tähän kirjoitettavat etunimet ovat \"Matti Juhani \"<br /><br />";
$pgv_lang["edit__HEB_SURN_help"]	= "#pgv_lang[edit__HEB_help]#<br /><br /> Tähän kenttään kirjoitat henkilön sukunimen. Esimerkiksi nimessä \"Matti Juhani Suomalainen\", tähän kirjoitettava sukunimi on \"Suomalainen\".<br /><br />Sellaiset henkilöt, joilla on monta sukunimeä, kuten on tapana esimerkiksi Espanjassa ja Portugalissa, kirjoittavat kunkin sukunimensä pilkulla erotettuna. Tämä osoittaa, että henkilö listataan kunkin sukunimen alle.  Esimerkiksi sukunimi \"Cortes,Vega\" listataan sekä <b>C</b>:n että <b>V</b>:n alle kun taas sukunimi  \"Cortes Vega\" listattan vain <b>C</b>:n alle.<br /><br />";
$pgv_lang["todo_show_other_help"]     = "Näytä &quot;To Do&quot;-tehtävät, jotka on osoitettu  muille käyttäjälle.";
$pgv_lang["todo_show_unassigned_help"]= "Näytä &quot;To Do&quot;-tehtävät, joita ei ole osoitettu kenellekään käyttäjälle.";
$pgv_lang["todo_show_future_help"]= "Näytä &quot;To Do&quot;-tehtävät, jotka on päivätty tulevaisuuteen. Muuten näytetään ainoastaan tehtävät, jotka on päivätty menneisyyteen.";
$pgv_lang["index_common_given_names_help"]		= "~YLEISIMMÄT ETUNIMET~<br />. Tällä aluella näytetään tässä tietokannassa olevat yleisimmät etunimet. Voit valita luettelossa näytettävien nimien lukumäärän.<br /><br />";
$pgv_lang["showUnknown_help"]	= "~#pgv_lang[showUnknown]#~<br />Näytä tai piilota tuntematonta sukupuolta olevien henkilöiden etunimiluettelo. <br /><br />#pgv_lang[block_givn_top10]#-alue piilottaa aina etunimiluettelon kun tietokannassa ei esiinny sitä sukupuolta edustavia henkilöitä. Tällä asetuksella voit piilottaa tuntematonta sukupuolta olevien henkilöiden luettelon vaikka sellaisia henkilöitä olisikin olemassa tietokannassa. <br /><br />";
$pgv_lang["show_marnms_help"]			= "~NÄYTÄ/ÄLÄ NÄYTÄ AVIONIMET~<br /><br />Henkilö- ja perheluettelosivut voit joko sisältää tai olla sisältämättä avionimet. Tämä asetus auttaa hakemaan henkilöitä, joista tiedetään vain avionimi. Avionimet voidaan sisällyttää vain, mikäli ne ovat olemassa tietokannassa. <br /><br />Perheluettelossa avionimiä ei oletusarvoisesti näytetä. Henkilösivuilla oletusarvo asetetaan GEDCOM asetussivulla. <br /><br />Kun muutat tätä asetusta, se jää voimaan kunnes kirjoittaudut ulos tai istuntosi päättyy. <br /><br />";
$pgv_lang["search_exclude_tags_help"]	= "~#pgv_lang[search_tagfilter]#~<br /><br /><b>#pgv_lang[search_tagfon]#</b>-valinta jättää huomiotta hakutoiminnoissa seuraavat GEDCOM-merkitsimet (tagit): <div style=\"padding-left:30px;\"><b>_PGVU</b> - Viimeinen muuttaja<br /><b>CHAN</b> - Viimeisen muutoksen päivämäärä<br /><b>FILE</b> - #factarray[FILE]#<br /><b>FORM</b> - #factarray[FORM]#<br /><b>TYPE</b> - #factarray[TYPE]#<br /><b>SUBM</b> - #factarray[SUBM]#<br /><b>REFN</b> - #factarray[REFN]#</div><br /> Näiden valinnaisesti poisjätettävien merkitsimien lisäksi hakutoiminnot jättävät aina seuraavat merkitsimet huomiotta: <div style=\"padding-left:30px;\"><b>_UID</b> - #factarray[_UID]#<br /><b>RESN</b> - #factarray[RESN]#</div><br /><br /> ";
$pgv_lang["add_opf_child_help"]			= "~#pgv_lang[add_opf_child]#~<br /><br />Klikkaamalla tätä linkkiä voit lisätä henkilölle <u>uuden</u> lapsen ja muodostaa yksilapsisen perheen. <br /><br />Klikkaa vain linkkiä ja saat ponnahdusikkunan, johon lisäät uuden lapsen. Täytä niin monta kenttää kuin voit ja klikkaa <b>Tallenna</b>-painiketta. <br /><br />Siinä kaikki.<br /><br />";
$pgv_lang["gen_missing_thumbs_help"]	= "~#pgv_lang[gen_missing_thumbs]#~<br />Tällä valinnalla luodaan pienoiskuvakkeet kaikille tässä hakemistossa oleville tiedostoille, joilla ei vielä sellaista ole. Tämä on paljon helpompaa kuin klikata erikseen kutakin semmoisen tiedoston  <b>#pgv_lang[gen_thumb]#</b>-linkkiä. <br /><br />Mikäli haluat itse päättää mille tiedostolle haluat luoda sitä vastaavan kuvakkeen, älä käytä tätä valintaa. Klikkaa sitä vastoin asianomaisia <b>#pgv_lang[gen_thumb]#</b>-linkkejä.<br /><br />";
$pgv_lang["stat_help_gax"]		= "~TILASTOKUVAAJIEN VALINTOJA~<br /><br />~X-akselin raja-arvot~<br />Valitse haluttu ikäjaksotus. <br /><br />Esimerkiksi <b>jaksotus 10 vuotta</b> kuvaa seuraavia ikäjaksoja: <div style=\"padding-left:30px;\">nuorempi kuin yksi vuosi<br />yksi – viisi vuotta<br />6 - 10<br />11 - 20<br />21 - 30<br />31 - 40<br />41 - 50<br />51 - 60<br />61 - 70<br />71 - 80<br />81 - 90<br />91 - 100<br /> vanhempi kuin 100 vuotta</div><br /><br />";
$pgv_lang["stat_help_gbx"]		= "~TILASTOKUVAAJIEN VALINTOJA~<br /><br />~X-akselin raja-arvot~<br />Valitse haluttu ikäjaksotus. <br /><br />Esimerkiksi <b>jaksotus kaksi vuotta</b> kuvaa seuraavia ikäjaksoja: <div style=\"padding-left:30px;\">nuorempi kuin 16 vuotta<br />16-18 vuotta<br />19 - 20<br />21 - 22<br />23 - 24<br />25-26<br />27-28<br />29-30<br />31-32<br />33-35<br />36-40<br />41-50<br /> vanhempi kuin 50 vuotta</div><br /><br />";
$pgv_lang["stat_help_gcx"]		= "~TILASTOKUVAAJIEN VALINTOJA~<br /><br />~X-akselin raja-arvot~<br />Valitse haluttu lukujaksotus. <br /><br />Esimerkiksi <b>jaksotus yksi lapsi</b>kuvaa seuraavia lapsilukujaksoja: <div style=\"padding-left:30px;\">ei lapsia<br />yksi lapsi<br />kaksi lasta<br />3, 4, 5, 6, 7, 8, 9, 10 lasta<br />yli 10 lasta</div><br /><br />";
$pgv_lang["chart_type_help"]	= "~TILASTOKUVAAJIEN VALINTOJA~<br /><br />Valitse mitä haluat nähdä karttakuvassa. Voit valita: <p style=\"padding-left: 25px\"><b>#pgv_lang[indi_distribution_chart]#</b>&nbsp;&nbsp;ja nähdä ne maat, joissa tämän tietokannan henkilöt esiintyvät.<br /><b>#pgv_lang[surname_distribution_chart]#</b>&nbsp;&nbsp näyttää ne maat, joissa tämän tietokannan sukunimet esiintyvät.</p><br /><br />";
$pgv_lang["google_chart_surname_help"]	= "~TILASTOKUVAAJIEN VALINTOJA~<br /><br />Valittujen nimien esiintymismäärä näytetään kartalla. Mikäli jätät tämän tyhjäksi, käytetään yleisintä sukunimeä. <br /><br />";
$pgv_lang["chart_area_help"]	= "~TILASTOKUVAAJIEN VAIHTOEHTOJA~ <br /><br />Valitse se maantieteellinen alue, jonka haluat nähdä kartalta. Voit tehdä seuraavat valinnat: <p style=\"padding-left: 25px\"><b>#pgv_lang[world_chart]#</b>&nbsp;&nbsp;näyttää kaikki maanosat.<br /><b>#pgv_lang[europe_chart]#</b>&nbsp;&nbsp;näyttää Euroopan.<br /><b>#pgv_lang[s_america_chart]#</b>&nbsp;&nbsp;näyttää Etelä-Amerikan.<br /><b>#pgv_lang[asia_chart]#</b>&nbsp;&nbsp;näyttää Aasian.<br /><b>#pgv_lang[middle_east_chart]#</b>&nbsp;&nbsp;näyttää Lähi-idän.<br /><b>#pgv_lang[africa_chart]#</b>&nbsp;&nbsp;näyttää Afrikan.</p><br /><br />";
$pgv_lang["help_treenav.php"]		= "~#pgv_lang[interactive_tree]#~<br />Käytä  #pgv_lang[interactive_tree]# tarkistellaksesi henkilön sukupuuta kumpaankin suuntaan. Tämä muistuttaa tiimalasikuvaajaa siinä, että se näyttää juurihenkilön sekä esi- että jälkipolvet. Tämä näkymä on tiivistetympi kun siinä näkyy pariskuntien tai perheiden laatikot henkilölaatikoiden sijasta. <br /><ul><li><b>Vieritys</b><br />Aina kun hiiren kursori muuttuu siirtokursoriksi, voit klikata ja raahata puuta nähdäksesi siitä muita alueita. Raahatessasi puuta uudet sukupolvet ilmestyvät automaattisesti kunnes enempää sukupolvia ei siinä suunnassa enää ole nähtävissä. <br /></li><li><b>Zoomaus</b><br />Voit käyttää puun vasemmalla puolella sijaitsevia kuvakkeita lähentääksesi ja loitontaaksesi kuvaajaa. Loitontaminen näyttää suuremman osan puusta kerralla näytöllä. Loitonnuksessa tekstin koko saattaa pienentyä niin, ettei siitä saa selvää. Kun kursori osoittaa laatikkoa, saat näkyviin suurennetun näkymän laatikon sisällöstä. <br /></li><li><b>Yksityiskohtien laajentaminen</b><br />Klikkaamalla mitä tahansa laatikkoa se laajenee, jolloin näkyviin saadaan lisää tietoja. Laajennetussa tilassa olevan henkilön nimen klikkaaminen avaa henkilön #pgv_lang[indi_info]#-sivun. Klikkaamalla <img src='#GLOBALS[PGV_IMAGE_DIR]#/small/gedcom.gif' width='15px' height='15px' alt='' /> päivittää puun asettamalla kyseisen henkilön juurihenkilöksi. Klikkaamalla <img src='#GLOBALS[PGV_IMAGE_DIR]#/buttons/family.gif' alt='' /> vie suoraan kyseisen perheen sivulle .<br /></li><li><b>Vaihtele puolisoiden näkyminen</b><br /><img src='#GLOBALS[PGV_IMAGE_DIR]#/small/sfamily.gif' width='15px' height='15px' alt='' />-kuvake heti Zoomauspainikeiden alla vaihtaa kaikkien jälkipolvien puolisoiden näkymisen päälle ja pois. Kun näkymä on asetettu näyttämään puolisot, kaikki henkilön puolisot näkyvät laatikossa. Henkilön lapset näkyvät myös. Mikäli näkymässä ei ole tarkoitus näyttää puolisoita, vain viimeisin puoliso ja hänen kanssaan saadut lapset näkyvät. <br /></li><li><b>Laajennettu puu</b><br />#pgv_lang[interactive_tree]# saadaan näkyviin monelta eri sivulta mukaan lukien Puu-välilehdeltä  #pgv_lang[indi_info]#-sivulla ja Kuvaaja-alueelta Tervetuloa-sivulla. Kun puu haetaan näiltä muilta sivuilta, näytetään myös Puu-kuvake Zoomauskuvakkaiden alla. Jos klikkaat <img src='#GLOBALS[PGV_IMAGE_DIR]#/small/gedcom.gif' width='15px' height='15px' alt='' /> avautuu #pgv_lang[interactive_tree]#-sivu.</li></ul><br />";
$pgv_lang["todo_help"] = "~&quot;Tehtävä&quot;-ALUE~<br />Tällä alueella voit ylläpitää tietokannassasi olevaa  <b>_TODO</b>-tehtäviä. <br /><br />Lisätäksesi &quot;tehtäviä&quot; tietueisiisi sinun on ehkä muutettava GEDCOM-asetuksia niin, että <b>_TODO</b>-tiedot ovat niissä tietoluetteloissa, jotka voidaan lisätä henkilöiden, perheiden ja lähteiden tietueisiin. Jokainen näistä luetteloista on itsenäinen. Ne löytyvät GEDCOM-asetusten editointivalintojen osassa. Uusien tietojen järjestyksellä luettelossa ei ole väliä. Voit lisätä uusia tietoja vaikkapa kunkin luettelon alkuun.<br /><br />";
$pgv_lang["search_include_ASSO_help"]	= "~#pgv_lang[search_asso_label]#~<br /><br />Tällä valinnalla PhpGedView näyttää kaikki henkilöt, joilla on läheinen suhde siihen henkilöön tai perheeseen, joka löytyi suoran haun tuloksena. Päinvastainen tapaus, jossa näytettäisiin kaikki ne  henkilöt tai perheet, joilla suoran haun seurauksena löytyneellä henkilöllä on läheinen suhde näihin muihin henkilöihin, ei ole mahdollista.<br /><br /> Esimerkki: Oletetaan, että henkilö <b>A</b> on henkilön </B> kummisetä. Tämä suhde on kirjattu henkilö <b>B<b/>:n GEDCOM-tietueessa ASSO-merkitsimellä. Mitään vastaavaa merkitsintä ei löydy henkilö <b>A</b>:n GEDCOM-tietueessa. <br /><br />Kun tämä valinta on asetettu tilaan <b>#pgv_lang[yes]#</b> ja hakutulos sisältää <b>B<b/>:n, myös <b>A<b/> näkyy hakutuloksena automaattisesti <b>B<b/>:n ASSO-merkitsimen vuoksi. Mikäli hakutulos sisältää <b>A<b/>:n, <b>B<b/> ei sisälly automaattisesti, koska <b>A<b/>:lla ei ole vastaavaa ASSO-merkitsintä <b>A<b/>:n GEDCOM-tietueessa. <br /><br />";
$pgv_lang["sortby_help"]			= "~#pgv_lang[sortby]#~<br />Valitse luettelon järjestys.<br /><br />";
$pgv_lang["medialist_recursive_help"]	= "~#pgv_lang[medialist_recursive]#~<br />Valitsemalla tämän vaihtoehdon, #pgv_lang[multi_title]# suorittaa haun #pgv_lang[filter]#-luettelosta valitusta hakemistosta ja sen alihakemistoista. Mikäli tätä vaihtoehtoa ei valita, hakua ei tehdä alihakemistoista.<br /><br />Löydettyjen mediatiedostojen otsikoista haetan sitten #pgv_lang[filter]#-kenttään syötetty teksti. Näiden kahden toimenpiteen tulos määrää, mitkä mediakohteet listataan.<br /><br />";
$pgv_lang["setperms_help"]			= "~#pgv_lang[setperms]#~<br />Aseta rekursiivisesti suojattujen (ei verkossa osoitettavien) <b>#GLOBALS[MEDIA_FIREWALL_ROOTDIR]##GLOBALS[MEDIA_DIRECTORY]#</b> ja normaalien <b>#GLOBALS[MEDIA_DIRECTORY]#</b> kansioiden käyttöoikeudet päällekirjoitettavaan (RW) tilaan tai lukutilaan (R) <br /><br />";
$pgv_lang["edit_add_unlinked_note_help"]	= "~#pgv_lang[add_unlinked_note]#~<br /><br />Tällä linkillä lisäät uuden jaetun lisätiedon tietokantaasi liittämättä lisätietoa yhteenkään tietueeseen.<br /><br />Uusi lisätieto ilmestyy Jaetut lisätiedot luetteloon, mutta ei näy kaavioilla tai muualla sivuilla kunnes se liitetään yksilöön, perheeseen, tai tapahtumaan.";
$pgv_lang["edit_SHARED_NOTE_help"]		= "~#pgv_lang[shared_note]#~<br /><br />Jaetut lisätiedot ovat vapaamuotoista tekstiä ja tulevat näkyviin sivulla tiedon yksityiskohdissa.<br /><br />Kunkin jaetun lisätiedon voi liittää useampaan kuin yhteen henkilöön, perheeseen, lähteeseen, tai tapahtumaan.<br /><br />";
$pgv_lang["edit_add_SHARED_NOTE_help"]		= "~#pgv_lang[add_shared_note]#~<br />~#pgv_lang[edit_shared_note]#~<br /><br />Jaetut lisätiedot, kuten tavalliset lisätiedot, ovat vapaamuotoista tekstiä. Toisin kuin tavalliset lisätiedot, kunkin jaetun lisätiedon voi liittää useampaan kuin yhteen henkilöön, perheeseen, lähteeseen, tai tapahtumaan.<br /><br />Asiaankuuluvaan ikonia klikkaamalla voit luoda yhteyden olemassa olevaan jaettuun lisätietoon tai luoda uuden jaetun lisätiedon ja samalla luoda yhteys siihen. Jos yhteys olemassa olevaan jaettuun lisätietoon on jo olemassa, voit myös muokata kyseisen lisätiedon sisältöä.<br /><ul><li><b>Liitä olemassa olevaan jaettuun lisätietoon</b><div style=\"padding-left:20px;\">Jos jo tiedät haluamasi jaetun lisätiedon tunnisteen, voit kirjoittaa sen numeron suoraan kenttään.<br /><br />Kun klikkaat <b>#pgv_lang[find_shared_note]#</b> ikonia, voit etsiä kaikkien jaettujen lisätietojen sisällöstä ja valita niistä yhden. Valitun lisätiedon tunniste tulee kenttään automaattisesti.<br /><br />Sinun täytyy klikata nappia <b>#pgv_lang[add]#</b> päivittääksesi alkuperäisen tietueen.</div><br /></li><li><b>Luo uusi jaettu lisätieto</b><div style=\"padding-left:20px;\">Kun klikkaat ikonia <b>#pgv_lang[create_shared_note]#</b>, uusi ikkuna aukeaa. Voit kirjoittaa uuden lisätiedon tekstin kuten haluat. Kuten tavallisten lisätietojen kanssa, voit kirjoittaa lisätietoon URL:n.<br /><br />Kun klikkaat <b>#pgv_lang[save]#</b> -nappia, näet viestin jossa on uuden jaetun lisätiedon tunniste. Sinun tulee klikata tätä viestiä sulkeaksesi muokkausikkunan ja kopioidaksesi tunnisteen suoraan tunnistekenttään. Jos vain suljet ikkunan, uusi tunniste ei kopioidu itsestään.<br /><br />Sinun tulee klikata <b>#pgv_lang[add]#</b> nappia päivittääksesi alkuperäisen tietueen.</div><br /></li><li><b>Muokkaa olemassa olevaan jaettua lisätietoa</b><div style=\"padding-left:20px;\">Kun klikkaat <b>#pgv_lang[edit_shared_note]#</b> ikonia, uusi ikkuna aukeaa. Voit muuttaa olemassa olevan lisätiedon tekstiä kuten haluat. Kuten tavallisten lisätietojan kanssa, voit kirjoittaa URL:n.<br /><br />Kun klikkaat <b>#pgv_lang[save]#</b> nappia, jaetun lisätiedon teksti päivittyy. Voit sulkea ikkunan ja klikata <b>#pgv_lang[save]#</b> nappia uudelleen.<br /><br />Kun muokkaat jaetun lisätiedon tekstiä, muutoksesi näkyy jokaisessa paikassa johon lisätieto on liitetty. Myös uudet liitokset jotka teet muutoksen jälkeen käyttävät päivitettyä tekstiä.</div></li></ul>";
$pgv_lang["add_shared_note_help"]	= "#pgv_lang[multiple_help]#<br />~#pgv_lang[add_shared_note_lbl]#~<br />Kun klikkaat <b>#pgv_lang[add_shared_note]#</b> linkkiä, aukeaa uusi ikkuna. Voit valita liitätkö olemassa olevaan jaettuun lisätietoon, vai luotko uuden lisätiedon ja samalla liität siihen.<br /><br />#pgv_lang[add_facts_general_help]#";
$pgv_lang["sort_style_help"]			= "~#pgv_lang[sort_style]#~<br /><br />Tällä valinnalla määritellään, kuinka tiedot järjestetään.<br /><br />Kun valitset <b>#pgv_lang[by_alpha]#</b>, tiedot laitetaan aakkosjärjestykseen.Kun valitset <b>#pgv_lang[by_anniv]#</b>,tiedot laitetaan vuosipäivän mukaiseen järjestykseen siten, että viimeisimmät ovat alussa.";
$pgv_lang["convertSlashes_help"]	= "~#pgv_lang[convertSlashes]#~<br /><br />Tämä vaihtoehto määrittelee erotellaanko kansioiden nimet mediakohteiden tiedostonimessä vino- vai kenoviivoilla. Valintasi määräytyy tiedot vastaanottavan käyttöjärjestelmän mukaan.<br /><br />Valinta <b>#pgv_lang[forwardSlashes]#</b> on sopiva useimmille muille käyttöjärjestelmille kuin Microsoft Windowsille. Valintaa <b>#pgv_lang[backSlashes]#</b> tulisi käyttää kun tiedot siirretään ohjelmaan joka toimii Microsoft Windowsilla.<br /><br />Tämä ei vaikuta mediapolkuihin jotka ovat URL:ia.<br /><br />";
$pgv_lang["convertPath_help"]		= "~#pgv_lang[convertPath]#~<br /><br />Tämä vaihtoehto määrittelee kiinteän etuosan joka liitetään kaikkiin mediapolkuihin tuotetussa tiedostossa.<br /><br />Esimerkiksi kun mediakansioksi on määritelty \"/media\" ja jos mediatiedostolla on polku \"/media/pictures/xyz.jpg\" ja olet kirjoittanut \"c:\\kuvat\\perhe\" tähän kenttään, tulokseksi tulee \"c:\\kuvat\\perhe/pictures/xyz.jpg\".<br /><br />Näet tästä esimerkistä että:<ul><li>mediakansio poistetaan polusta</li><li>ja tuloksessa ei ole oikeita kansioerottimia.</li></ul><br />Jos haluat pitää mediakansion tuotetuissa poluissa, sinun täytyy lisätä se <b>#pgv_lang[convertPath]#</b> kenttään.<br /><br />Sinun tulee myös käyttää asetusta <b>#pgv_lang[convertSlashes]#</b> varmistaaksesi että kansioiden erottimet ovat yhdenmukaiset ja vastaanottavan käyttöjärjestelmän vaatimusten mukaiset.<br /><br />Tämä ei vaikuta mediapolkuihin jotka ovat URL:ia.<br /><br />";
$pgv_lang["apply_privacy_help"]		= "~#pgv_lang[apply_privacy]#~<br /><br />Kun tämä vaihtoehto on valittu, tarkistetaan tuotetusta tiedostosta yksityisyysasetukset valitun vaihtoehdon mukaan. Tämä voi aiheuttaa joidenkin tietojen poiston. Tuotettu tiedosto sisältää vain tiedot joka ovat tavallisesti käyttäjien nähtävänä joilla on kyseisen tasoiset oikeudet.<br /><br />Jos sinulla on vain #pgv_lang[gedadmin]# -oikeudet, et voi valita että tuotettu tiedosto tehtäisiin #pgv_lang[siteadmin]# -oikeuksien mukaan.<br /><br />";
$pgv_lang["file_type_help"]			= "~#pgv_lang[choose_file_type]#~<br /><br />Valitse muoto jossa tietokanta viedään. Valintasi riippuu sen ohjelman vaatimuksista ja ominaisuuksista johon sinä olet tietoja viemässä. Voit valita:<ul><li>#pgv_lang[def_gedcom_help]#</li><li>#pgv_lang[def_gramps_help]#</li></ul>";
?>
