<?php
/**
 * Spanish language file for PhpGedView
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2010  PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 * @author PGV Developers
 * @translator: Julio Sánchez Fernández
 * @package PhpGedView
 * @subpackage Languages
 * @version $Id: help_text.es.php 6989 2010-11-09 03:26:25Z canajun2eh $
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

$pgv_lang["file_type_help"]			= "~#pgv_lang[choose_file_type]#~<br /><br />Elija el formato deseado de la exportación de la base de datos.  Su elección depende de los requisitos y capacidades del programa al que va destinado el archivo descargado.  Puede escoger entre los siguientes:<ul><li>#pgv_lang[def_gedcom_help]#</li><li>#pgv_lang[def_gramps_help]#</li></ul>";
$pgv_lang["apply_privacy_help"]		= "~#pgv_lang[apply_privacy]#~<br /><br />Si marca esta opción, el archivo de salida pasará por las comprobaciones de privacidad conforme a la opción seleccionada.  Puede que alguna información se omita en la salida. El archivo de salida contendrá sólo la información normalmente visible a un usuario con el nivel de privilegio indicado.<br /><br />Si sólo tiene derechos de #pgv_lang[gedadmin]#, no puede especificar que los datos del archivo de salida se filtren según el nivel de privilegio #pgv_lang[siteadmin]#.<br /><br />";
$pgv_lang["convertPath_help"]		= "~#pgv_lang[convertPath]#~<br /><br />Esta opción define una ruta constante que se antepondrá como prefijo a todas las rutas a objetos audiovisuales en el archivo de salida.<br /><br />Por ejemplo, si el directorio de audiovisuales se ha configurado como \"/media\" y si el archivo audiovisual a exportar tiene la ruta \"/media/fotos/xyz.jpg\" y ha introducido \"c:\\mis fotos\\mi familia\" en este campo, la ruta resultante al archivo será \"c:\\mis fotos\\mi familia/fotos/xyz.jpg\".<br /><br />Notará de en este ejemplo que:<ul><li>el nombre del directorio de audiovisuales actual se eliminará de la ruta</li><li>la ruta resultante no tendrá los separadores de nombre de carpeta correctos.</li></ul><br />Si desea conservar el directorio de audiovisuales en las rutas en el archivo de salida, tendrá que incluir ese nombre en el campo <b>#pgv_lang[convertPath]#</b>.<br /><br />También le convendrá usar la opción <b>#pgv_lang[convertSlashes]#</b> para garantizar que los separadores de nombres de carpeta son consistentes y conformes a los requisitos del sistema operativo destino.<br /><br />Las rutas a audiovisuales que sean en realidad URLs no se modificarán.<br /><br />";
$pgv_lang["convertSlashes_help"]	= "~#pgv_lang[convertSlashes]#~<br /><br />Esta opción determina si los nombres de las carpetas en la especificación FILE de los objetos audiovisuales se deben separar mediante barras normales o barras invertidas.  Su elección depende de los requisitos del sistema operativo destino.<br /><br />La opción <b>#pgv_lang[forwardSlashes]#</b> es apropiada para la mayoría de los sistemas operativos excepto Microsoft Windows.  La opción <b>#pgv_lang[backSlashes]#</b> conviene si el programa destino se ejecuta en un sistema Microsoft Windows.<br /><br />Las rutas a audiovisuales que sean en realidad URLs no se modificarán.<br /><br />";
$pgv_lang["medialist_recursive_help"]	= "~#pgv_lang[medialist_recursive]#~<br />Si se selecciona esta opción, la #pgv_lang[multi_title]# buscará no solamente en el directorio seleccionado de la lista #pgv_lang[filter]# sino también todos sus subdirectorios. Si no se selecciona esta opción, sólo se buscará en el directorio seleccionado.<br /><br />Los títulos de todos los objetos audiovisuales encontrados se examinarán a continuación para ver si contienen el texto introducido en el #pgv_lang[filter]#.  El resultado de estas dos acciones determina los objetos audiovisuales que se listan.<br /><br />";
$pgv_lang["sortby_help"]			= "~#pgv_lang[sortby]#~<br />Seleccione el orden en que desea ver la lista.<br /><br />";
$pgv_lang["help_treenav.php"]		= "~#pgv_lang[interactive_tree]#~<br />Use el #pgv_lang[interactive_tree]# para ver todo el árbol genealógico de una persona en ambas direcciones.  Esta vista se parece a la de Reloj de Arena en que muestra tanto ascendientes como descendientes de una persona raíz dada.  Este diagrama le proporciona una vista más compacta al mostrar cajas para las parejas o las familias en vez de para cada persona.<br /><ul><li><b>Desplazamiento</b><br />Cada vez que su puntero se cambia a un icono Mover, puede hacer clic y arrastrar el árbol para ver otras porciones del árbol.  Según arrastra el árbol se desplegarán automáticamente otras generaciones hasta que no queden más generaciones que ver en esa dirección.<br /></li><li><b>Acercar/alejar</b><br />Puede usar los iconos a la izquierda del árbol para acercar o alejar la vista.  Alejar le permitirá ver más del árbol a la vez.  Según se aleje, el texto puede volverse difícil de leer; si su puntero flota sobre una caja obtendrá una vista ampliada de lo que hay dentro de ella.<br /></li><li><b>Expandir detalles</b><br />Al hacer clic en cualquier caja se expandirá y mostrará una vista más detallada.  Mientras está expandida, hacer clic en el nombre de una persona abrirá su página #pgv_lang[indi_info]#.  Hacer clic en <img src='#GLOBALS[PGV_IMAGE_DIR]#/small/gedcom.gif' width='15px' height='15px' alt='' /> volverá a dibujar el árbol con esa persona como la nueva raíz.  Hacer clic en <img src='#GLOBALS[PGV_IMAGE_DIR]#/buttons/family.gif' alt='' /> le llevará a la página de detalles de esa familia.<br /></li><li><b>Activar/desactivar múltiples cónyuges</b><br />El icono <img src='#GLOBALS[PGV_IMAGE_DIR]#/small/sfamily.gif' width='15px' height='15px' alt='' /> justo bajo los botones de Acercar/alejar mostrará u ocultará los cónyuges múltiples en el lado de descendencia.  En caso de mostrarse, todos los cónyuges de una persona se mostrarán en su misma caja.  También se mostrarán todos los hijos de la persona.  Si se desactiva la opción, sólo se mostrarán el último cónyuge y sus hijos.<br /></li><li><b>Árbol grande</b><br />El #pgv_lang[interactive_tree]# está disponible desde muchas páginas incluyendo la pestaña Árbol de la página #pgv_lang[indi_info]# y en el bloque de Diagramas de la Página de bienvenida.  Si se está viendo el árbol desde una de estas páginas también aparecerá un icono Árbol bajos los iconos de Acercar/alejar.  Si hace clic en <img src='#GLOBALS[PGV_IMAGE_DIR]#/small/gedcom.gif' width='15px' height='15px' alt='' /> se mostrará la página #pgv_lang[interactive_tree]#.</li></ul><br />";

$pgv_lang["move_mediadirs_help"]	= "~#pgv_lang[move_mediadirs]#~<br />Si se activa el Cortafuegos de Objetos Audiovisuales, se pueden almacenar los archivos de los objetos en un directorio del servidor inaccesible desde Internet.<br /><br />Estos botones le permiten mover fácilmente una estructura completa de directorios de objetos entre los directorios de la zona protegida (no accesible directamente desde Internet) <b>#GLOBALS[MEDIA_FIREWALL_ROOTDIR]##GLOBALS[MEDIA_DIRECTORY]#</b> y de la normal <b>#GLOBALS[MEDIA_DIRECTORY]#</b>.<br /><br />";
$pgv_lang["setperms_help"]			= "~#pgv_lang[setperms]#~<br />Fijar recursivamente los permisos en los directorios protegido (no accesible directamente desde la web) <b>#GLOBALS[MEDIA_FIREWALL_ROOTDIR]##GLOBALS[MEDIA_DIRECTORY]#</b> y normal <b>#GLOBALS[MEDIA_DIRECTORY]#</b> a modificable por todos o a sólo lectura por todos.<br /><br />";
$pgv_lang["no_update_CHAN_help"] 	= "~#pgv_lang[no_update_CHAN]#~<br />Los administradores necesitan algunas veces limpiar o corregir los datos enviados por los usuarios.  Por ejemplo, podrían necesitar corregir el lugar de un registro PLAC para que incluya el país.  Si los administradores hacen correcciones así, la información del cambio original resulta normalmente sustituida.  Esto puede no ser deseable.<br /><br />Si se selecciona esta opción, PhpGedView retendrá la información original del cambio en vez de reemplazarla por la de la sesión actual.  Si se selecciona esta opción, los administradores también tendrán la posibilidad de modificar o borrar la información asociada con la etiqueta CHAN original.<br /><br />";
$pgv_lang["edit_SOUR_EVEN_help"]	= "~#pgv_lang[source_events]#~<br /><br />Cada fuente registra eventos específicos, generalmente para un rango de fechas dado y una jurisdicción geográfica determinada.  Por ejemplo, un censo registra eventos censales y los registros parroquiales registran eventos de nacimiento, matrimonio y defunción.<br /><br />Seleccione los eventos registrados por esta fuente de la lista de eventos propuestos. La fecha debería indicarse en formato GEDCOM de rango de fechas como, por ejemplo, <i>FROM 1900 TO 1910</i>.  La jurisdicción geográfica es el nombre de la unidad geográfica más pequeña que engloba todos los lugares mencionados en esta fuente. Por ejemplo, \"Oneida, Idaho, USA\" se utilizaría como la jurisdicción para los eventos ocurridos en las distintas poblaciones del Condado de Oneida. \"Idaho, USA\" sería la jurisdicción si los eventos registrados tuvieran lugar no sólo en el Condado de Oneida, sino en otros condados de Idaho.<br /><br />";
$pgv_lang["cache_life_help"]		= "~#pgv_lang[cache_life]#~<br /><br />Para mejorar el rendimiento, este bloque de la Página de Bienvenida de PhpGedView se recuerda en un archivo.  Puede controlar la frecuencia con la que se refresca este archivo.<br /><br /><ul><li><b>-1</b> significa que el archivo nunca se refresca automáticamente.  Para obtener una copia nueva, tiene que borrar todos los archivos de este tipo.  Puede hacerlo en la página Personalizar Página de Bienvenida.</li><li><b>0</b> (Cero) significa que este bloque nunca se guarda y que cada vez que se presenta en la página de Bienvenida de PhpGedView se presenta un copia fresca.  Este ajuste se utiliza automáticamente para los bloques que cambian frecuentemente como los bloques #pgv_lang[logged_in_users_block]# y #pgv_lang[random_media_block]#.</li><li><b>1</b> (Uno) significa que se crea una copia de este bloque diariamente, <b>2</b> significa que se crea una copia fresca cada dos días, <b>7</b> significa que se crea un copia fresca semanalmente, etc.</li></ul><br /><br />";
$pgv_lang["clear_cache_help"]		= "~#pgv_lang[clear_cache]#~<br /><br />A fin de mejorar el rendimiento, varios de los bloques de la página de Bienvenida se pueden recordar guardándolos como archivos en el directorio de índice.  Los archivos guardados para la mayoría de los bloques se refrescan una vez al día, pero puede haber ocasiones en que desee refrescarlos manualmente.<br /><br />Este botón le permite refrescar los archivos de recuerdo cuando sea necesario.";
$pgv_lang["import_options_help"] 	= "Puede elegir opciones adicionales para la importación de su GEDCOM.";
$pgv_lang["verify_gedcom_help"]	= "Aquí puede escoger si continuar con la carga e importación del archivo GEDCOM o abandonar este paso.";
$pgv_lang["add_gedcom_instructions"]= "Introduzca un nombre para este nuevo GEDCOM.  El nuevo archivo GEDCOM se creará en el directorio de índice: #INDEX_DIRECTORY#";
$pgv_lang["random_media_start_slide_help"]			= "~#pgv_lang[random_media_start_slide]#~<br /><br />Indica si debe arrancar la presentación automáticamente al cargar la página.<br /><br />La presentación cambia el contenido del bloque sin precargar información del servidor y sin recargar la página completa.<br /><br />";
$pgv_lang["random_media_ajax_controls_help"]	= "~#pgv_lang[random_media_ajax_controls]#~<br /><br />Puede utilizar este ajuste para mostrar u ocultar los controles de presentación del bloque de Objeto Audiovisual al Azar.<br /><br />Estos controles permiten al usuario saltar a otro objeto al azar o reproducir los objetos seleccionados como si fueran una presentación. La presentación cambia el contenido del bloque sin precargar información del servidor y sin recargar la página completa.<br /><br />";
$pgv_lang["edit_add_unlinked_source_help"]	= "~#pgv_lang[add_unlinked_source]#~<br /><br />Utilice este vínculo para agregar una nueva fuente a su base de datos sin vincularla a ninguna cita.  La nueva fuente aparecerá en la lista de fuentes, pero no aparecerá en ningún diagrama ni ningún otro lugar en el programa hasta que sea mencionada en una cita.";
$pgv_lang["edit_add_unlinked_note_help"]	= "~#pgv_lang[add_unlinked_note]#~<br /><br />Utilice este vínculo para agregar una nueva nota a su base de datos sin vincularla a ningún registro.<br /><br />La nueva nota aparecerá en la lista de notas compartidas, pero no aparecerá en ningún diagrama ni ningún otro lugar en el programa hasta que sea vinculada a una persona, familia o evento.";
$pgv_lang["link_person_id_help"]	= "~#pgv_lang[label_local_id]#~<br /><br />Introduzca en este campo el ID de la persona con la que se vincula (por ejemplo, I100).";
$pgv_lang["link_gedcom_id_help"]	= "~#pgv_lang[label_gedcom_id]#~<br /><br />Utilice esta sección para seleccionar el identificador de la base de datos alternativa que contiene la persona con la que está vinculando.";
$pgv_lang["link_remote_site_help"]	= "~#pgv_lang[label_site]#~<br /><br />En esta sección se introducen los datos requeridos para conectar con el sitio remoto que contiene los datos con los que quiera vincular. Tiene la opción de escoger de una lista de sitios conocidos que ya ha usado antes o introducir #pgv_lang[label_site_url2]# y #pgv_lang[label_gedcom_id]# para un nuevo sitio.<br /><br />En el campo <b>#pgv_lang[label_site_url2]#</b> introduzca la URL de acceso al archivo de descripción de los servicios web (WSDL) que dice a PhpGedView cómo acceder a los datos en el sitio remoto.  Para un sitio web remoto PhpGedView, la URL del archivo WSDL se parecerá a <u>http://www.remotesite.com/phpGedView/genservice.php?wsdl</u><br /><br />El campo <b>#pgv_lang[label_gedcom_id]#</b> se utiliza para introducir opcionalmente un identificador de la base de datos para los sitios remotos que requieran ese dato.  Para los sitios PhpGedView, se trata del nombre del archivo GEDCOM. <br /><br />Los campos de <b>#pgv_lang[label_username_id]#</b> y <b>#pgv_lang[label_password_id]#</b> son necesarios si la base de datos lo requiere.<br /><br /><i>Nota: Los sitios remotos PhpGedView deben utilizar la versión 4.0 o posterior; las versiones anteriores no tienen esta capacidad.</i>";
$pgv_lang["link_remote_location_help"]	= "~#pgv_lang[label_location]#~<br /><br />Esta opción le permite elegir si los datos de la persona con la que vincula están en este mismo sitio en una base de datos diferente o si se encuentran en otro sitio distinto accesible en Internet.<br /><br />Si la persona está en el mismo sitio, se le pedirá que seleccione el identificador del conjunto de datos y el ID de la persona.<br /><br />Si se trata de otro sitio, se le pedirá que introduzca su URL, un identificador de base de datos y el ID de la persona remota.";
$pgv_lang["link_remote_rel_help"]	= "~#pgv_lang[label_rel_to_current]#~<br /><br />Utilice esta opción para seleccionar qué relación tiene la persona remota con la de este sitio.  Por ejemplo, seleccionar <i>Padre</i> significaría que la persona del sitio remoto es el padre de la persona con la que la estamos vinculando localmente.";
$pgv_lang["link_remote_help"]       = "~#pgv_lang[link_remote]#~<br /><br />Utilice este formulario para vincular unas personas con otras, bien desde otro sitio u otra base de datos genealógica accesible a su copia de PhpGedView.<br /><br />Para agregar un vínculo así, primero debe seleccionar el tipo de relación, después elegir un sitio ya conocido por su PhpGedView o definir un nuevo sitio y, a continuación, introducir el ID en el sitio remoto de la persona con la que quiere vincular.  PhpGedView entonces descargará información automáticamente del sitio remoto según sea necesario.  La información descargada <u>no</u> se incorpora a su base de datos genealógica, queda en el sitio remoto pero aparece en las distintas páginas en las que se muestra a esta persona vinculada remotamente.<br /><br />Para más información sobre cada elemento, compruebe el vínculo de Ayuda que se presenta justo a cada uno de ellos.  También puede consultar la tutoría en inglés para más información: <a href=\"#PGV_PHPGEDVIEW_WIKI#/en/index.php?title=How_To:Remote_Link_Individuals_Across_Websites_And_Databases\" target=\"_blank\">#PGV_PHPGEDVIEW_WIKI#</a>.";

//-- Edit Interface
$pgv_lang["edit_ABBR_help"]			= "~TÍTULO ABREVIADO~<br /><br />Utilice este campo para guardar una versión abreviada del título.  Este campo se utiliza en unión del campo de título en las fuentes. Por omisión, PGV usará primero el título y después el título abreviado.<br /><br />Según la especificación GEDCOM 5.5, \"esta entrada debe proporcionar un título corto utilizado para clasificar, archivar y recuperar los registros de las fuentes (pág 62).\"<br /><br />En PhpGedView, el título abreviado es opcional, pero en otros programas genealógicos es requerido.";
$pgv_lang["edit_ROMN_help"]			= "~NOMBRE ROMANIZADO~<br /><br />En muchas culturas es habitual tener un nombre tradicional escrito con los caracteres tradicionales y también una versión romanizada del nombre como se escribiría o pronunciaría en idiomas basados en el alfabeto latino como el español.<br /><br />Si prefiere utilizar un alfabeto no latino como el hebreo, ruso, chino o árabe para introducir su nombre en los campos estándar de nombre, puede usar este campo para introducir el mismo nombre usando el alfabeto latino. Ambas versiones del nombre aparecerán en las listas y diagramas.<br /><br />Aunque este campo se denomina \"Romanizado\", no está limitado a contener únicamente caracteres basados en el alfabeto latino. Esto puede ser útil con los nombres japoneses donde se puede llegar utilizar tres alfabetos distintos.";
$pgv_lang["edit_ROMN_GIVN_help"]	= "#pgv_lang[edit__ROMN_help]#<br /><br />En este campo debe introducir los nombres de pila de la persona.  Por ejemplo, en el nombre \"John Robert Finlay\", los nombres de pila que deben introducirse aquí son \"John Robert\"<br /><br />";
$pgv_lang["edit_ROMN_SURN_help"]	= "#pgv_lang[edit__ROMN_help]#<br /><br />En este campo se introduce el apellido de la persona.  Por ejemplo, en el nombre \"John Robert Finlay\", el apellido que debe introducirse aquí es \"Finlay\"<br /><br />Las personas con varios apellidos, como es corriente en España y Portugal, deben separar los apellidos mediante una coma.  Esto indica que la persona debe aparece listada bajo cada uno de los apellidos indicados.  Por ejemplo, los apellidos \"Cortés,Vega\" aparecerían tanto en la <b>C</b> como en la <b>V</b>, mientras que el apellido \"Cortés Vega\" sólo aparecería en la <b>C</b>.<br /><br />";
$pgv_lang["edit__HEB_help"]			= "~NOMBRE HEBREO~<br /><br />En muchas culturas es la costumbre tener un nombre tradicional escrito en los caracteres tradicionales y también una versión romanizada del nombres como se escribiría o pronunciaría en idiomas basados en el alfabeto latino como el español.<br /><br />Si prefiere usar el alfabeto latino para introducir el nombre en los campos de nombre estándar, puede usar este campo para introducir el mismo nombre en alfabeto no latino como el griego, hebreo, ruso, árabe o chino. Ambas versiones del nombre aparecerán en las listas y diagramas.<br /><br />Aunque esta campo se denomina \"Hebreo\", no está limitado a contener únicamente caracteres hebreos.";
$pgv_lang["edit__HEB_GIVN_help"]	= "#pgv_lang[edit__HEB_help]#<br /><br />En este campo debe introducir los nombres de pila de la persona.  Por ejemplo, en el nombre \"John Robert Finlay\", los nombres de pila que deben introducirse aquí son \"John Robert\"<br /><br />";
$pgv_lang["edit__HEB_SURN_help"]	= "#pgv_lang[edit__HEB_help]#<br /><br />En este campo se introduce el apellido de la persona.  Por ejemplo, en el nombre \"John Robert Finlay\", el apellido que debe introducirse aquí es \"Finlay\"<br /><br />Las personas con varios apellidos, como es corriente en España y Portugal, deben separar los apellidos mediante una coma.  Esto indica que la persona debe aparece listada bajo cada uno de los apellidos indicados.  Por ejemplo, los apellidos \"Cortés,Vega\" aparecerían tanto en la <b>C</b> como en la <b>V</b>, mientras que el apellido \"Cortés Vega\" sólo aparecería en la <b>C</b>.<br /><br />";
$pgv_lang["edit_SEX_help"]			= "#pgv_lang[edit_sex_help]#";
$pgv_lang["edit_NAME_help"]			= "#pgv_lang[edit_name_help]#";
$pgv_lang["edit_add_unlinked_person_help"]	= "~#pgv_lang[add_unlinked_person]#~<br /><br />Utilice este formulario para agregar una persona desconectada.<br /><br />Si añade una persona desconectada a su árbol genealógico, esta persona no estará vinculada a ninguna otra persona hasta que la vincule.  Posteriormente, puede vincular personas desde la pestaña #pgv_lang[relatives]# en la página #pgv_lang[indi_info]#.";
$pgv_lang["edit_URL_help"]			= "Introduzca la dirección URL incluyendo el http://.<br /><br />Un ejemplo sería: <b>http://www.phpgedview.net/</b> Deje este campo en blanco si no quiere incluir una URL.";
$pgv_lang["edit_EMAIL_help"]		= "Introduzca la dirección de correo electrónico.<br /><br />Un ejemplo sería: <b>name@hotmail.com</b>  Deje en blanco este campo si no desea incluir una dirección de correo electrónico.";
$pgv_lang["edit_FAX_help"]			= "Introduzca el número de fax incluyendo los prefijos de país y de área.<br /><br />Deje en blanco este campo si no desea incluir un número de fax.  Por ejemplo, un número en España podría ser +34 926 123 457 y un número en Estados Unidos o Canadá podría ser +1 888 555-1212.";
$pgv_lang["edit_PHON_help"]			= "Introduzca el número de teléfono incluyendo los prefijos de país y de área.<br /><br />Deje en blanco este campo si no desea incluir un número de teléfono.  Por ejemplo, un número en España podría ser +34 926 123 457 y un número en Estados Unidos o Canadá podría ser +1 888 555-1212.";
$pgv_lang["edit_ADDR_help"]			= "Introduzca la dirección en el campo tal como aparecería en un sobre.<br /><br />Deje en blanco este campo si no desea incluir una dirección.";
$pgv_lang["edit_GIVN_help"]			= "#pgv_lang[edit_given_name_help]#";
$pgv_lang["edit_SPFX_help"]			= "~Prefijo de apellidos~<br /><br />Introduzca o seleccione de la lista las palabras que precedan a la parte principal del Apellido.  Ejemplos son: <b>de la</b> Torre, <b>von</b> Braun, <b>van der</b> Kloot, <b>de</b> Graaf, etc.";
$pgv_lang["edit_SURN_help"]			= "#pgv_lang[edit_surname_help]#";
$pgv_lang["edit_NSFX_help"]			= "#pgv_lang[edit_suffix_help]#";
$pgv_lang["edit__MARNM_help"]		= "~#factarray[_MARNM]#~<br /><br />Introduzca el nombre de casado/a para esta persona, utilizando las misma reglas que para el campo Nombre.  Este campo es opcional.<br /><br />Por ejemplo, si Mary Jane Brown se casó con John White, podría introducir (sin las comillas, por supuesto)<ul><li>Costumbre de Estados Unidos:&nbsp;&nbsp;\"Mary Jane Brown /White/\"</li><li>Costumbre europea habitual:&nbsp;&nbsp;\"Mary Jane /White/\"</li><li>Costumbre europea alternativa:&nbsp;&nbsp;\"Mary Jane /White-Brown/\" o \"Mary Jane /Brown-White/\"</li></ul>Sólo debe hacer esto si Mary Brown utilizó ella misma ese nombre tras casarse con John White.  En algunos sitios, por ejemplo Quebec (Canadá), es ilegal cambiar los nombres de esta manera y en gran parte de la comunidad hispanohablante tampoco es habitual o permitido que la esposa cambie su apellido al casarse.<br /><br />A veces, los hombres también cambian su apellido al casarse, la mayoría de las veces adoptando la forma con guión pero, ocasionalmente adoptando el apellido de la esposa.";
$pgv_lang["edit_PEDI_help"]			= "~#factarray[PEDI]#~<br /><br />Este campo describe la relación del hijo con su familia.  Las posibilidades son:<ul><li><b>#pgv_lang[unknown]#</b>&nbsp;&nbsp;&nbsp;La relación del hijo con sus padres no puede determinarse.  Si se selecciona esta opción, el campo #factarray[PEDI]# no se copiará a la base de datos.<br /><br /></li><li><b>#factarray[BIRT]#</b>&nbsp;&nbsp;&nbsp;Esta opción indica que el hijo está relacionado con su familia por nacimiento.<br /><br /></li><li><b>#pgv_lang[adopted]#</b>&nbsp;&nbsp;&nbsp;Esta opción indica que el hijo fue adoptado por su familia.  Esto <i>no</i> indica que no hay relación de consanguinidad entre el hijo y su familia; muestra que el hijo fue adoptado por la familia en cuestión en algún momento posterior al nacimiento del hijo.<br /><br /></li><li><b>#pgv_lang[foster]#</b>&nbsp;&nbsp;&nbsp;Esta opción indica que el hijo fue acogido por la familia.  Generalmente, no hay consanguinidad entre el hijo y la familia.<br /><br /></li><li><b>#pgv_lang[sealing]#</b>&nbsp;&nbsp;&nbsp;El hijo fue sellado a su familia en una ceremonia de <i>sellamiento</i> SUD.  El sellamiento de un hijo se realiza cuando sus padres fueron sellados entre sí posteriormente al nacimiento del hijo.  Los hijos nacidos tras el sellamiento de los padres están sellados automáticamente a la familia.<br /><br /></li></ul>";
$pgv_lang["edit_AGNC_help"]			= "~#factarray[AGNC]#~<br /><br />La organización, institución, empresa, persona u otra entidad con la autoridad correspondiente.<br /><br />Por ejemplo, el patrono de una persona, o una iglesia que realice ritos o sacramentos, o una organización responsable de la creación o el archivo de los registros.";

$pgv_lang["context_help"]			= "Se puede obtener más ayuda haciendo clic en los <b>?</b> junto a cada dato en la página.";

$pgv_lang["register_gedcomid_help"]	= "~#pgv_lang[gedcomid]#~<br /><br />Cada persona de la base de datos tiene un número ID distinto en este sitio.  Si conoce el número ID de su propio registro, introdúzcalo aquí.  Si no lo conoce o no puede averiguarlo debido a la configuración de privacidad, proporcione por favor suficiente información en el campo Comentarios para permitir al administrador del sitio determinar cuál es el ID de su entrada en la base de datos y rellenarlo por Vd.<br /><br />";
$pgv_lang["register_comments_help"]	= "~#pgv_lang[comments]#~<br /><br />Utilice este campo para comunicar al administrador del sitio por qué solicita una cuenta y cuál es su relación con los datos genealógicos mostrados en este sitio.  También puede utilizar este campo para introducir cualquier otro comentario que tenga para el administrador del sitio.<br /><br />";
$pgv_lang["utf8_ansi_help"]		= "~CONVERTIR DE UTF-8 A ANSI~<br /><br />Para una visualización óptima en la Internet, PhpGedView utiliza el juego de caracteres UTF-8.  Algunos programas como Family Tree Maker por ejemplo, no pueden importar archivos GEDCOM codificados en UTF-8.  Si marca esta casilla, se convertirán los datos de <b>UTF-8</b> a <b>ANSI (ISO-8859-1)</b>.<br /><br />El formato que necesita depende del programa al que vaya a incorporar el archivo GEDCOM descargado.  Si no está seguro, consulte la documentación de ese programa.<br /><br />Tome nota de que para que los caracteres especial permanezcan sin cambio, tendrá que mantener el archivo en UTF-8 y convertirlo a un formato apropiado para ese programa por algún otro medio.  Consulte con el autor o fabricante de su programa.<br /><br />Este <a href='http://es.wikipedia.org/wiki/UTF-8' target='_blank' title='artículo de Wikipedia'><b>Artículo de Wikipedia</b></a> contiene información completa y vínculos acerca de UTF-8.<br /><br />";
$pgv_lang["remove_tags_help"]	= "~ELIMINAR ETIQUETAS PROPIAS DE PGV~<br /><br />Marcar esta opción eliminará las etiquetas particulares de PgpGedView que hayan sido añadidas a los registros.<br /><br />Entre estas etiquetas propias de PhpGedView se incluyen la etiqueta <b>_PGVU</b> que identifica al usuario que hizo el cambio en el sitio y la etiqueta <b>_THUM</b> que indica a PhpGedView que la imagen mencionada debe usarse como una miniatura.<br /><br />Estas etiquetas propias pueden causar errores al importar el GEDCOM resultante descargado en otros programas de genealogía.<br /><br />";
$pgv_lang["download_zipped_help"]	= "~DESCARGAR GEDCOM COMO ARCHIVO ZIP~<br /><br />Si marca esta opción, se creará un archivo comprimido ZIP con una copia del archivo GEDCOM antes de comenzar la descarga. Esto reducirá su tamaño considerablemente, pero necesitará un programa Unzip compatible (WinZIP, por ejemplo) para descomprimir el archivo GEDCOM transmitido antes de poder usarlo.<br /><br />Es una opción útil para descargar grandes archivos GEDCOM.  Existe el riesgo de que el tiempo de descarga del archivo sin comprimir exceda el tiempo de ejecución máximo permitido produciendo descargas incompletas.  La opción ZIP debería reducir el tiempo de descarga en un 75%.<br /><br />";
$pgv_lang["remember_me_help"]	= "~RECUÉRDAME~<br /><br />Marcar esta casilla al entrar permite que PhpGedView le recuerde la próxima vez que visite de modo que no tenga que entrar otra vez.  Esta función fijará una <i>cookie<</i> en su equipo que su navegador enviará automáticamente al sitio la próxima vez que visite el sitio.<br /><br />Cuando vuelva al sitio podrá acceder a información privada y a su página de usuario, pero para poder modificar o administrar se le pedirá que introduzca su usuario y contraseña otra vez.<br /><br /><b>No debe marcar esta casilla si está accediendo al sitio desde un equipo público o desde un equipo que comparte con otras personas.  De lo contrario, cualquier usuario del equipo podrá entrar en el sitio como si fuera Vd.</b>";
$pgv_lang["edit_NCHI_help"]		= "~#factarray[NCHI]#~<br /><br />Introduzca el número de hijos de esta persona o familia.  Es un campo opcional.<br /><br />";
$pgv_lang["edit_TIME_help"]		= "~#factarray[TIME]#~<br /><br />Introduzca la hora de este evento en formato de 24 horas con ceros a la izquierda. La medianoche es 00:00. Ejemplos: 04:50 13:00 20:30.<br /><br />";
$pgv_lang["edit_NOTE_help"]		= "~#factarray[NOTE]#~<br /><br />Las notas son de formato libre y aparecerán en la sección de Detalle de Hechos de la página.<br /><br />";
$pgv_lang["edit_SHARED_NOTE_help"]		= "~#pgv_lang[shared_note]#~<br /><br />Las notas compartidas son texto en formato libre y aparecerán en la sección de detalles del hecho en la página.<br /><br />Cada nota compartida puede vincularse a más de una persona, familia, fuente o evento.<br /><br />";
$pgv_lang["edit_CEME_help"]		= "~#factarray[CEME]#~<br /><br />Introduzca el nombre del cementerio u otro lugar similar donde se depositaron los restos de la persona.<br /><br />";
$pgv_lang["edit_ASSO_help"]		= "~#factarray[ASSO]#~<br /><br />Introduzca el ID GEDCOM asociado.<br /><br />";
$pgv_lang["edit_RELA_help"]		= "~#factarray[RELA]#~<br /><br />Seleccione un nombre de relación de la lista. Seleccionar <b>Padrino</b> significa: <i>Este asociado es el padrino de la persona actual</i>.<br /><br />";
$pgv_lang["show_spouse_help"]			= "~#pgv_lang[show_spouses]#~<br /><br />Por omisión, este diagrama no muestra los cónyuges de los descendientes pues hace el diagrama difícil de leer y entender.  Activar esta opción mostrará los cónyuges en el diagrama.<br /><br />";
$pgv_lang["reorder_families_help"]		= "~#pgv_lang[reorder_families]#~<br /><br />Las familias en la pestaña de #pgv_lang[relatives]# se muestran en el orden en que aparecen en el registro GEDCOM de la persona.  Las familias no se clasifican por fecha de matrimonio porque a menudo las fechas no son conocidas, aunque se conoce el orden de los matrimonios.<br /><br />Esta opción le permite cambiar el orden en que aparecen las familias en la pestaña #pgv_lang[relatives]#.  Si quiere ordenar las familias por la fecha de matrimonio, hay un botón sobre el que hacer clic para ordenarlas de forma automática.<br /><br />";
$pgv_lang["autoContinue_help"]			= "~#pgv_lang[autoContinue]#~<br /><br />Si PhpGedView detecta que la importación del GEDCOM requiere más tiempo que el permitido por el límite de tiempo, mostrará un botón <b>#pgv_lang[del_proceed]#</b> en que debe hacer clic para continuar la importación.<br /><br />Si se fija esta opción a <b>#pgv_lang[yes]#</b>, PhpGedView hará clic <b>#pgv_lang[del_proceed]#</b> en el botón automáticamente por Vd.  Esto hará más llevadero el proceso de hacer clic en el botón repetidamente durante importaciones largas.<br /><br />";
$pgv_lang["firstname_i_help"]		= "~#pgv_lang[firstname_alpha_index]#~<br /><br />El apellido que ha escogido lo tienen más de #GLOBALS[SUBLIST_TRIGGER_I]# personas.<br /><br />Para ayudarle a encontrar la persona que busca, se ha dividido la lista completa en otras más pequeñas según la primera letra del nombre de pila de la persona.  Este segundo índice alfabético funciona igual que el índice de apellidos.<br /><ul><li>Haga clic  en una letra para ver todos los nombres de pila que comienzan con esa letra.</li><li>Escoja <b>#pgv_lang[NN]#</b> para listar todas las personas con nombres de pila desconocidos.</li><li>Si escoge <b>#pgv_lang[all]#</b>, se mostrará la lista completa de personas con los apellidos escogidos.</li></ul>Puesto que hay muchos nombres, puede tardar algún tiempo la presentación de la lista en su pantalla.<br /><br />";
$pgv_lang["firstname_f_help"]		= "~#pgv_lang[firstname_alpha_index]#~<br /><br />El apellido que ha escogido tiene más de #GLOBALS[SUBLIST_TRIGGER_F]# personas.<br /><br />Para ayudarle a encontrar la familia que busca, la lista se partido en listas más pequeñas conforme a la primera letra del nombre de pila de la persona.  Este sub-índice alfabético funciona igual que el índice alfabético de nombres.<br /><ul><li>Haga clic en una letra para ver todos los nombres de pila que comienzan por esa letra.</li><li>Escoja <b>#pgv_lang[NN]#</b> para listar todas las personas con nombres de pila desconocidos.</li><li>Escoger <b>#pgv_lang[all]#</b> mostrará la lista de todas las familias con el apellido escogido.</li></ul>Puesto que hay muchos nombres, puede llevar mucho tiempo mostrar esta lista la en su pantalla.<br /><br />";
$pgv_lang["edit_TYPE_help"]		= "~#factarray[TYPE]#~<br /><br />El campo #factarray[TYPE]# se utiliza para introducir información adicional acerca del elemento.  En la mayoría de los casos, el campo tiene formato libre y puede introducir cualquier cosa que le parezca.<br /><br />";
$pgv_lang["edit_TEMP_help"]		= "~#factarray[TEMP]#~<br /><br />Para las ordenanzas SUD, este campo indica el Templo en que se realizaron.<br /><br />";
$pgv_lang["edit_STAT_help"]		= "~#factarray[STAT]#~<br /><br />Es un campo opcional de estado y se utiliza principalmente para las ordenanzas SUD al procesarlas con el programa TempleReady.<br /><br />";
$pgv_lang["edit__PRIM_help"]		= "~#factarray[_PRIM]#~<br /><br />Utilice este campo para indicar que este objeto audiovisual es el resaltado o primario para la persona a la que está adjunto.  La imagen resaltada es la que se utilizará en los diagramas y en la página de la persona.<br /><br />";
$pgv_lang["edit__THUM_help"]		= "~#factarray[_THUM]#~<br /><br />Esta opción le permite modificar la selección habitual de imagen miniatura.<br /><br />Cada GEDCOM tiene una opción de configuración que especifica si PhpGedView de be enviar la imagen grande o la pequeña al navegador cada vez que la página necesite una miniatura.  La opción &laquo;#factarray[_THUM]#&raquo;, si se fija a <b>#pgv_lang[yes]#</b>, modifica temporalmente el ajuste de la opción de configuración del GEDCOM, de modo que PhpGedView siempre enviará la imagen grande.  No puede hacer que PhpGedView envíe la imagen pequeña si la configuración del GEDCOM especifica que siempre deban usarse las imágenes grandes.<br /><br />PhpGedView no cambia el tamaño de la imagen enviada; el navegador lo hace según las especificaciones de la página que ha recibido.  Esto puede tener consecuencias indeseables si la imagen enviada no es de verdad una miniatura si PhpGedView espera enviar una imagen pequeña.  Esto no es un error:  Algunas veces puede ser deseable mostrar una imagen grande en lugares es que normalmente habría una imagen de tamaño miniatura.<br /><br />Debería evitar fijar la opción &laquo;#factarray[_THUM]#&raquo; a <b>#pgv_lang[yes]#</b>.  Este ajuste causará el envío de un detalle excesivo de las imágenes al navegador que éste tendrá que descartar.  Las descarga de las páginas, especialmente los diagramas con muchas imágenes, puede verse muy ralentizada.<br />";
$pgv_lang["edit_TITL_help"]		= "~#factarray[TITL]#~<br /><br />Introduzca el título del elemento que está modificando.  Si se trata de un objeto audiovisual, introduzca un título descriptivo que permita al usuario identificar el elemento.<br /><br />";
$pgv_lang["edit_FILE_help"]		= "~#factarray[FILE]#~<br /><br />Es el campo más importante en el registro del objeto audiovisual.  Indica qué archivo utilizar. Como mínimo, tiene que introducir el nombre del archivo.  Dependiendo de sus ajustes, puede resultar útil más información acerca de la ubicación del archivo.<br /><br />Puede utilizar el vínculo <b>#pgv_lang[find_media]#</b> para ayudarle a localizar los objetos audiovisuales que ya se hayan subido al sitio.<br /><br />#pgv_lang[readme_help]#<br /><br />";
$pgv_lang["edit_FORM_help"]		= "~#factarray[FORM]#~<br /><br />Es un campo opcional que puede utilizarse para introducir el formato de archivo del objeto audiovisual.  Algunos programas de genealogía pueden mirar este campo para determinar cómo manejar el elemento.  Sin embargo, puesto que los archivos audiovisuales no se transfieren demasiado bien al pasar de un tipo de equipo a otro, este campo no es muy importante.<br /><br />";
$pgv_lang["generate_thumb_help"]		= "~#pgv_lang[auto_thumbnail]#~<br /><br />Su sistema es capaz de generar miniaturas de forma automática para algunos tipos de imágenes.  Puede que exista soporte para archivos BMP, GIF, JPG y PNG.  Los tipos de archivo soportados por su sistema se listan junto a la casilla.<br /><br />Marcando esta casilla, Vd. indica al sistema que va a subir imágenes de estos tipos y que desea que se intenten generar miniaturas para ellas.  Deje la casilla sin marcar si desea proporcionar sus propias miniaturas.<br /><br />";
$pgv_lang["edit_add_NOTE_help"]		= "~#pgv_lang[add_note]#~<br /><br />Esta sección le permite agregar una nueva nota al hecho que está modificando ahora.  Las notas son textos de formato libre y aparecerán entre los detalles del hecho en la página.<br /><br />";
$pgv_lang["edit_add_SHARED_NOTE_help"]		= "~#pgv_lang[add_shared_note]#~<br />~#pgv_lang[edit_shared_note]#~<br /><br />Las notas compartidas, al igual que las normales, son texto en formato libre.  A diferencia de las notas normales, cada nota compartida puede vincularse a más de una persona, familia, fuente o hecho.<br /><br />Haciendo clic en el icono apropiado, puede establecer un vínculo a una nota compartida ya existente o crear una nueva nota compartida y vincularla a la vez.  Si ya se ha establecido un vínculo a una nota compartida, también es posible modificar el contenido de la nota.<br /><ul><li><b>Vincular una nota compartida existente</b><div style=\"padding-left:20px;\">Si ya conoce el número ID de la nota compartida deseada, puede introducir dicho número directamente en el campo.<br /><br />Si hace clic en el icono <b>#pgv_lang[find_shared_note]#</b>, podrá buscar el texto de todas las notas compartidas existentes y escoger una de ellas.  El número ID de la nota escogida se introducirá en el campo automáticamente.<br /><br />Debe hacer clic en el botón <b>#pgv_lang[add]#</b> para actualizar el registro original.</div><br /></li><li><b>Crear una nueva nota compartida</b><div style=\"padding-left:20px;\">Si hace click en el icono <b>#pgv_lang[create_shared_note]#</b>, se abrirá una nueva ventana.  Puede introducir el texto de la nueva nota como desee.  Al igual que en las notas normales, puede introducir URLs.<br /><br />Si hace clic en el botón <b>#pgv_lang[save]#</b>, verá un mensaje con el número ID de la nota compartida recién creada.  Haga clic en este mensaje para cerrar la ventana de edición y al tiempo copiar el nuevo número ID directamente al campo de número ID.  Si simplemente cierra la ventana, el número ID recién creado no se copiará automáticamente.<br /><br />Debe hacer clic en el botón <b>#pgv_lang[add]#</b> para actualizar el registro original.</div><br /></li><li><b>Modificar una nota compartida existente</b><div style=\"padding-left:20px;\">Si hace clic en el icono <b>#pgv_lang[edit_shared_note]#</b>, se abrirá una nueva ventana.  Puede cambiar el texto de la nota compartida existente como desee.  Como con las notas normales, puede introducir URLs.<br /><br />Si hace clic en el botón <b>#pgv_lang[save]#</b>, se actualizará el texto de la nota compartida.  Puede cerrar la ventana y hacer clic en el botón <b>#pgv_lang[save]#</b> de nuevo.<br /><br />Si cambia el texto de una nota compartida, su cambio se reflejará en todos los sitios con vínculos a esta nota compartida.  Nuevos vínculos establecidos después del cambio, también utilizarán el texto actualizado.</div></li></ul>";
$pgv_lang["edit_add_GEDFact_ASSISTED_help"]	= "~USO DEL AYUDANTE DE GEDFACT~<br /><br />Al hacer clic en el \"+\" se abre la ventana del ayudante para notas compartidas de GEDFact.<br />El ayudante proporciona ayuda más específica.<br /><br />Si hace clic en el botón \"Guardar\", el ID de la nota compartida se pegará en el campo.<br /><br />";
$pgv_lang["edit_add_SOUR_help"]		= "~#pgv_lang[add_source]#~<br /><br />Esta sección le permita agregar una nueva cita a una fuente al hecho que está editando.<br /><br />En el campo Fuente debe introducir el ID para la fuente.  Haga clic en el vínculo <b>#pgv_lang[create_source]#</b> si necesita agregar una nueva fuente.  En el campo Detalles de la Cita puede introducir el número de página u otra información que permita a otras personas encontrar esta información en la fuente.  En el campo Texto puede introducir la transcripción textual del fragmento de la fuente.<br /><br />";
$pgv_lang["edit_add_ASSO_help"]		= "~#pgv_lang[add_asso]#~<br /><br />#pgv_lang[add_asso]# le permite vincular un hecho con una persona asociada con el mismo. De esta forma puede, por ejemplo, reflejar el hecho de que una persona fue padrino de otra persona.<br /><br />";
$pgv_lang["edit_QUAY_help"]		= "~#factarray[QUAY]#~<br /><br />Puede usar este campo para grabar la calidad o fiabilidad de los datos encontrados en esta fuente.  Muchas aplicaciones de genealogía utilizan un número en este campo. <b>3</b> podría querer decir que el dato es una fuente primaria, <b>2</b> podría indicar que era una fuente secundaria, <1> podría significar que la información es dudosa y <b>0</b> podría querer decir que la información no es fiable.<br /><br />";
$pgv_lang["edit_PAGE_help"]		= "~#factarray[PAGE]#~<br /><br />En el campo de Detalles de la Cita se introduciría el número de la página u otra información que puede ayudar a alguien a encontrar la información en la fuente.<br /><br />";
$pgv_lang["edit_TEXT_help"]		= "~#factarray[TEXT]#~<br /><br />En este campo se introduciría el texto de la cita de esta fuente.  Por ejemplo, podría tratarse de una transcripción del texto de la fuente o una descripción de lo que había en la cita.<br /><br />";
$pgv_lang["edit_SOUR_help"]		= "~#factarray[SOUR]#~<br /><br />Este campo le permite hacer que esta cita esté vinculada con un registro de fuente diferente.  Este campo requiere un ID de fuente  Junto a este campo se mostrará en título correspondiente al ID de fuente actual.  Utilice el vínculo <b>#pgv_lang[find_id]#</b> para buscar el número ID de la fuente..  Para eliminar completamente la cita, deje este campo en blanco.<br /><br />";
$pgv_lang["edit_edit_raw_help"]	= "~#pgv_lang[edit_raw]#~<br /><br />Esta página le permite editar el registro GEDCOM en bruto.  Debe utilizar esta página con precaución; se requiere un buen dominio del estándar GEDCOM 5.5.1.  Para más información del estándar GEDCOM 5.5.1, lea el tema de ayuda <b>GEDCOM file</b>.<br /><br />PhpGedView proporciona muchas formas de añadir y editar información, pero puede haber ocasiones en que desee editar la estructura GEDCOM en bruto.  Siempre que sea posible, debe utilizar los formularios que se proporcionan para añadir información, pero si es imposible, puede utilizar este formulario.  Al enviar el formulario, se realizarán con sus datos pruebas básicas de conformidad con el estándar y se actualizará el subregistro CHAN.<br /><br />";
$pgv_lang["add_from_clipboard_help"]	= "~#pgv_lang[add_from_clipboard]#~<br />PhpGedView le permite copiar hasta 10 hechos, con todos sus detalles, a un portapapeles.  Este portapapeles es diferente del carrito genealógico que puede utilizar para exportar porciones de su base de datos.<br /><br />Puede seleccionar cualquiera de los hechos del portapapeles y copiar el hecho seleccionado al registro de persona, familia, objeto, fuente o repositorio que se está editando.  Sin embargo, no puede copiar hechos de tipos de registro que no sean similares.  Por ejemplo, no puede copiar un matrimonio a un registro de fuente o de persona porque los matrimonios se asocian sólo a los registros de familia.<br /><br />Esto es muy útil cuando hay que introducir hechos similares, como datos censales, para muchas personas o familias.<br /><br />";
$pgv_lang["edit_PLAC_help"]			= "~#factarray[PLAC]#~<br /><br />Los lugares deben introducirse según los estándares de genealogía.  En genealogía, los lugares se anotan indicando primero la parte más específica del lugar y avanzando a hacia las más generales, utilizando comas para separar los diferentes niveles.  El nivel al que anota la información de lugar debería representar el de la división administrativa o parroquia en la que se conservan los registros vitales de ese lugar.<br /><br />Por ejemplo, un lugar como Salt Lake City se introduciría como \"Salt Lake City, Salt Lake, Utah, EE.UU.\".<br /><br />Examinemos cada parte de este lugar.  La primera, \"Salt Lake City,\" es la ciudad o municipio en la que ocurrió el evento.  En algunos países, puede haber agrupaciones de nivel inferior que sea importante anotar.  En ese caso, vendrían antes del municipio.  La siguiente parte, \"Salt Lake,\" es el condado.  \"Utah\" es el estado y \"EE.UU.\" es el país.  Es importante anotar cada lugar porque los gobiernos mantienen registros de interés genealógico en cada uno de los niveles.<br /><br />Si un nivel es desconocido, deje un espacio entre las comas.  Suponga que en ejemplo anterior Vd. no conocía el condado de Salt Lake City.  En ese caso, debe anotarlo como \"Salt Lake City, , Utah, EE.UU.\".  Suponga que sólo sabe que un persona nació en Utah.  Entonces lo anotaría como \", , Utah, EE.UU.\".  <br /><br />Puede utilizar el vínculo <b>#pgv_lang[find_place]#</b> para ayudarle a encontrar lugares ya presentes en la base de datos.<br /><br />";
$pgv_lang["edit_add_parent_help"]	= "~AGREGAR NUEVO PADRE O MADRE~<br /><br />Con esta página puede añadir un padre o una madre a la persona seleccionada.  Rellene el nombre de esta persona y los datos de su nacimiento y fallecimiento si son conocidos.  Si no conoce algún dato, déjelo en blanco.<br /><br />Para añadir otros datos aparte del nacimiento o el fallecimiento, primero agregue la nueva persona guardando los cambios.  A continuación, haga clic en el nombre de la persona en la página actualizada de la familia o en la pestaña #pgv_lang[relatives]# para ver la página #pgv_lang[indi_info]# del padre o madre.  Desde la página #pgv_lang[indi_info]# puede añadir información más detallada.<br /><br />";
$pgv_lang["edit_add_spouse_help"]	= "~AGREGAR UN NUEVO ESPOSO O ESPOSA~<br /><br />Con esta página puede agregar un cónyuge a la persona seleccionada.  Rellene el nombre de la persona y los datos de su nacimiento y fallecimiento si son conocidos.  Si no conoce algún dato, déjelo en blanco.<br /><br />Para agregar otros hechos aparte del nacimiento y el fallecimiento, primero agregue el cónyuge a la base de datos guardando los cambios.  A continuación, haga clic en el nombre de la persona en la página de la familia actualizada o en en la pestaña #pgv_lang[relatives]# para ver la página #pgv_lang[indi_info]# del cónyuge.  Desde la página #pgv_lang[indi_info]# puede añadir información más detallada.<br /><br />";
$pgv_lang["edit_death_help"] = "~#pgv_lang[death]#~<br /><br />En esta área puede introducir información de la defunción.  Primero introduzca la fecha en que falleció la persona en el formato estándar de fecha para genealogía (1 JAN 2004).  Puede hacer clic en el icono Calendario si requiere ayuda para la introducción de la fecha.  A continuación, introduzca el lugar donde falleció la persona.  Puede utilizar el vínculo <b>#pgv_lang[find_place]#</b> para seleccionar un lugar que ya exista en la base de datos.<br /><br />";
$pgv_lang["edit_birth_help"] = "~#pgv_lang[birth]#~<br /><br />En esta área puede introducir información del nacimiento.  Primero introduzca la fecha en que nación en le formato estándar de fecha para genealogía (1 JAN 2004).  Puede hacer clic en el icono Calendario si requiere ayuda para la introducción de la fecha.  A continuación, introduzca el lugar donde nació la la persona.  Puede utilizar el vínculo <b>#pgv_lang[find_place]#</b> para seleccionar un lugar que ya exista en la base de datos /><br />";
$pgv_lang["edit_sex_help"]	= "~#pgv_lang[sex]#~<br /><br />Elija el sexo apropiado de la lista desplegable.  La opción <b>desconocido</b> indica que no se conoce el sexo de esta persona.<br /><br />";
$pgv_lang["edit_name_help"]	= "~#pgv_lang[name]#~<br /><br />Este campo es el más importante del registro de nombre de una persona.<br /><br />Este campo debería rellenarse automáticamente según se rellenan los demás campos, pero se proporciona para que puede modificar la información según sus propias preferencias.<br /><br />El nombre en esta campo debería introducirse según el estándar GEDCOM 5.5.1 con los apellidos rodeados por barras \"/\".  Por ejemplo, el nombre \"John Robert Finlay Jr.\" debería introducirse así: \"John Robert /Finlay/ Jr.\".<br /><br />";
$pgv_lang["edit_suffix_help"]	= "~#pgv_lang[suffix]#~<br /><br />En este campo opcional puede introducir el sufijo del nombre de la persona.  Ejemplos de sufijos de nombre son \"Sr.\", \"Jr.\" y \"III\".<br /><br />";
$pgv_lang["edit_surname_help"]	= "~#pgv_lang[surname]#~<br /><br />En este campo debe introducir el apellido de la persona.  Por ejemplo, en el nombre \"John Robert Finlay\", el apellido a introducir aquí sería \"Finlay\"<br /><br />Para las personas con varios apellidos, como es corriente en España y Portugal, se deben separar los apellidos por comas.  Esto indica que la persona debe aparecer reflejada en cada uno de los apellidos.  Por ejemplo, el apellido \"Cortés,Vega\" aparecerá tanto en la <b>C></b> como en la <b>V</b>, mientras que el apellido \"Cortés Vega\" sólo aparecerá en la <b>C</b>.<br /><br />";
$pgv_lang["edit_NICK_help"]	= "~#factarray[NICK]#~<br /><br />En este campo se introducen los apodos de la persona.<br />Es un campo opcional.<br /><br />Formas de agregar un apodo:<ul><li>Seleccionar <b>modificar nombre</b>, introducir el apodo y guardar</li><li>Seleccionar <b>agregar nuevo nombre</b>, introducir el apodo Y nombre y guardar</li><li>Seleccionar <b>modificar registro GEDCOM</b> para agregar múltiples registros [2&nbsp;NICK] subordinados al registro [1&nbsp;NAME] principal.</li></ul>";
$pgv_lang["edit_given_name_help"]	= "~#pgv_lang[given_name]#~<br /><br />En este campo debe introducir el o los nombres de pila de la persona.  Por ejemplo, en el nombre \"John Robert Finlay\", los nombres de pila a introducir aquí serían \"John Robert\"<br /><br />";
$pgv_lang["edit_NPFX_help"]			= "~Prefijo de Nombre~<br /><br />Este campo opcional le permite introducir un prefijo al nombre como \"Dr.\" o \"Excmo.Sr.\"<br /><br />";
$pgv_lang["edit_add_child_help"]	= "~#pgv_lang[add_child]#~<br /><br />Con esta página puede agregar un hijo a la familia seleccionada.  Rellene el nombre del hijo y la información de nacimiento y fallecimiento si se conoce.  Si no conoce algún dato, déjelo en blanco.<br /><br />Para agregar otros hechos aparte del nacimiento y el fallecimiento, primero agregue el hijo a la base de datos guardando los cambios.  A continuación, haga clic en el nombre del hijo en la página de la familia actualizada o en la pestaña #pgv_lang[relatives]# para ver la página #pgv_lang[indi_info]# del hijo.  Desde la página #pgv_lang[indi_info]# puede añadir información más detallada.<br /><br />";

$pgv_lang["review_changes_help"]	= "~CAMBIOS PENDIENTES DE REVISIÓN~<br /><br />Este bloque listará todos los registros se han cambiado en el sitio y que aún han de ser revisados y aceptados en la base de datos.<br /><br />";
$pgv_lang["quick_update_name_help"] = "~MODIFICAR NOMBRE~<br /><br />Utilice los campos \"Modificar nombre\" para cambiar el nombre de la persona que está editando.  En el campo Nombre de pila introduzca el o los nombres de pila.  En el campo Apellidos introduzca los apellidos de la persona.  Por ejemplo, si el nombre que desea introducir es \"John Robert Finlay\", debe introducir \"John Robert\" en el campo Nombre de pila y \"Finlay\" en el campo Apellidos.<br /><br />Rellenar estos campos <u>cambiará</u> el nombre de la persona; no añadirá un nuevo nombre.<br /><br /><i>Nota: <u>no</u> debe utilizar este método si el nombre cambia a causa de un matrimonio.  En vez de eso, utilice la opción de añadir un nuevo marido que se muestra más adelante.</i><br /><br />";
$pgv_lang["quick_update_fact_help"] = "~MODIFICAR UN HECHO~<br /><br />Utilice los campos \"Modificar un hecho\" para añadir nueva información del hecho o cambiar un hecho ya existente de la persona que está editando.  Primero elija un hecho de la lista desplegable.  A continuación introduzca la fecha en que ocurrió el hecho en el formato estándar de fecha de genealogía (1 JAN 2004).  Puede hacer clic en el icono de Calendario para obtener ayuda en la selección de la fecha.  Después introduzca el lugar en que ocurrió el hecho.  Puede utilizar el vínculo <b>#pgv_lang[find_place]#</b> para seleccionar un lugar ya existente en la base de datos.<br /><br />Como con todos los demás campos de este formulario, la información que introduzca o bien sustituirá a la que ya está presente o creará nuevas entradas según sea necesario.<br /><br />";
$pgv_lang["quick_update_address_help"] = "~MODIFICAR DIRECCIÓN~<br /><br />Utilice los campos \"Modificar dirección\" para modificar la dirección, número de teléfono o dirección de correo electrónico de la persona que está modificando.<br /><br />Como con los demás campos de este formulario, su información sustituirá a la ya presente en el registro o creará nuevas entradas si es necesario.<br /><br />";
$pgv_lang["quick_update_spouse_help"] = "~AGREGAR UN NUEVO ESPOSO O ESPOSA~<br /><br />Utilice estos campos si quiere añadir un cónyuge a la persona que está modificando.  Introduzca el nombre del cónyuge y sus datos de nacimiento en los campos y la fecha de la boda en la información de matrimonio.  Introduzca las fechas en el formato estándar para genealogía (1 JAN 2004).  Puede hacer clic en el icono Calendario para obtener ayuda en la selección de la fecha.  Puede utilizar el vínculo <b>#pgv_lang[find_place]#</b> para seleccionar un lugar ya existente en la base de datos.<br /><br />Estos campos sólo sirven para añadir un <i>nuevo</i> cónyuge; no sirven para actualizar la información de uno ya registrado.  Para editar la información de alguien ya registrado, cierre esta ventana y haga clic en el nombre de esa persona en la pestaña #pgv_lang[relatives]#.  A continuación haga clic en el menú Editar Persona para editar la información.<br /><br />";
$pgv_lang["quick_update_marriage_help"] = "~MODIFICAR MATRIMONIO~<br /><br />Puede utilizar estos campos junto con los de añadir un nuevo esposo o esposa si desea registrar un matrimonio.  En otro caso, los datos que introduzca en estos campos modificarán la información del último matrimonio de esta persona.  Introduzca las fechas en el formato estándar de fecha para genealogía (1 JAN 2004).  Puede hacer clic en el icono Calendario para obtener ayuda en la selección de una fecha.  Puede utilizar en vínculo <b>#pgv_lang[find_place]#</b> para seleccionar un lugar ya existente en la base de datos.<br /><br />";
$pgv_lang["quick_update_child_help"] = "~AGREGAR UN NUEVO HIJO~<br /><br />Utilice estos campos para añadir un nuevo hijo a esta persona.  Primero, introduzca el nombre del hijo e indique el sexo.  A continuación, introduzca la fecha y lugar del nacimiento. Introduzca las fechas en el formado de fecha estándar para genealogía (1 JAN 2004).  Puede pinchar en el icono de Calendario para obtener ayuda en la selección de la fecha.  Puede utilizar el vínculo <b>#pgv_lang[find_place]#</b> para seleccionar un lugar que ya exista en la base de datos.<br /><br />Estos campos sólo agregarán un <u>nuevo</u> hijo.  No actualizarán la información de un hijo ya registrado.  Para editar la información de alguien que ya existe en la base de datos, cierre esta ventana y haga clic en el nombre de esa persona en la pestaña #pgv_lang[relatives]#.  A continuación, haga clic en el menú de Editar Persona para editar la información.<br /><br />";
$pgv_lang["index_top10_pageviews_help"]		= "~BLOQUE DE REGISTROS MÁS VISTOS~<br /><br />Este bloque lista las 10 personas, familias o fuentes que han sido mostradas más veces. Para que este bloque aparezca el administrador del sitio tiene que haber activado los contadores de Visitas de Registros.<br /><br />";
$pgv_lang["useradmin_user_default_tab_help"]	= "~AJUSTE DE PESTAÑA PREDETERMINADA DE USUARIO~<br /><br />Este ajuste le permite especificar qué pestaña se abrirá automáticamente cuando este usuario acceda a la página #pgv_lang[indi_info]#.  Si se le permite editar su cuenta, el usuario podrá cambiar este ajuste posteriormente.<br /><br />";
$pgv_lang["edituser_user_default_tab_help"]	= "~AJUSTE DE PESTAÑA PREDETERMINADA DE USUARIO~<br /><br />Este ajuste le permite especificar qué pestaña se abre automáticamente cuando se accede a la página #pgv_lang[indi_info]#.<br /><br />";
$pgv_lang["reorder_children_help"]	= "~#pgv_lang[reorder_children]#~<br /><br />Los hijos se muestran en el orden en que aparecen en el registro familiar.  Los hijos no se clasifican automáticamente por fecha de nacimiento porque a menudo las fechas de nacimiento de algunos de los hijos no se conocen mientras que <u>sí</u> se conoce el orden de nacimiento.<br /><br />Esta opción le permitirá cambiar el orden de los hijos en el registro de la familia.  Puesto que puede querer clasificar los hijos por sus fechas de nacimiento, hay un botón sobre el que puede hace clic para hacer esto por Vd.<br /><br />También puede arrastrar y soltar cualquier caja de información para cambiar el orden de los hijos.  Según mueva el cursor sobre una caja de información, su forma cambiará a un par de flechas de doble punta cruzadas. Si empuja y mantiene pulsado el botón izquierdo antes de mover el cursor, la caja de información seguirá al cursor en su movimiento vertical por la lista.  Según se mueva la caja de información, las demás cajas se moverán para hacer sitio.  Cuando suelte el botón izquierdo, la caja de información ocupará su nuevo lugar en la lista.<br /><br />";
$pgv_lang["rss_feed_help"]	= "~AJUSTES PARA EL CANAL RSS~<br /><br />El canal RSS disponible en PhpGedView le permite ver el contenido principal de su página de bienvenida usando un agregador RSS apropiado sin visitar el sitio. La mayoría de los agregadores mostrarán un aviso emergente comunicándole que ha cambiado una de las páginas controladas. Esencialmente, esto permite a cualquiera realizar el seguimiento de su sitio PhpGedView sin tener que visitarlo regularmente.<br /><br />El bloque del canal RSS se utiliza para personalizar el vínculo al canal, permitiendo tipos de canal específicos (la mayoría de los lectores funciona con la mayoría de los tipos, así que el valor predeterminado suele valer) y el módulo específico que le gustaría en su canal. El idioma del canal se decidirá en función del idioma y el GEDCOM activos en PhpGedView cuando se selecciona el canal.<br /><br />Los tipos de canal que pueden generarse incluyen ATOM, RSS 2.0, RSS 1.0, RSS 0.92, HTML y JavaScript. Los primeros cuatro tipos son para agregadores de noticias, mientras que JavaScript y HTML son para permitir incluir los canales en otras páginas web.  Tome nota de que los números de versión del canal RSS indican diferentes estilos, no una versión diferente.<br /><br />Hay una opción para seleccionar identificación que permite al usuario ver, usando un agregador RSS apropiado, cualquier información que vería normalmente si estuviera identificado.  La Autenticación Básica utiliza <i>Basic HTTP Authentication</i> para identificar al usuario.  Mejoras futuras pueden permitir <i>Digest Authentication</i>.<br /><br />Este <a href='http://es.wikipedia.org/wiki/RSS' target='_blank' alt='Artículo de Wikipedia' title='Artículo de Wikipedia'><b>Artículo de Wikipedia</b></a> contiene información completa y vínculos sobre RSS y los distintos formatos de RSS. La <i>Basic HTTP Authentication</i> se discute en este <a href='http://en.wikipedia.org/wiki/Basic_authentication_scheme' target='_blank' alt='Artículo de Wikipedia' title='Artículo de Wikipedia'><b>artículo de Wikipedia</b></a> (en inglés), mientras que la <i>Digest Authentication</i> se discute en este <a http://en.wikipedia.org/wiki/Digest_access_authentication' target='_blank' alt='Artículo de Wikipedia' title='Artículo de Wikipedia'><b>artículo de Wikipedia</b></a> (también in inglés).<br /><br />";

$pgv_lang["upload_media_folder_help"]	= "~#pgv_lang[folder]#~<br /><br />Su configuración de GEDCOM permite hasta #GLOBALS[MEDIA_DIRECTORY_LEVELS]# niveles directorio tras el predeterminado <b>#GLOBALS[MEDIA_DIRECTORY]#</b> donde se almacenan normalmente los archivos audiovisuales. Esto le permite organizar sus archivos audiovisuales y no necesita estar tan preocupado asegurándose de que no hay nombres duplicados.<br /><br />En este campo se especifica el directorio de destino en su servidor donde deba almacenarse el archivo audiovisual.  Asegúrese de prestar atención al uso de mayúsculas o minúsculas, puesto que los nombres de archivos y directorios distinguen entre ellas.<br /><br />Si el nombre de directorio que introduzca aquí no existe, se creará automáticamente. Si introduce más que el número #GLOBALS[MEDIA_DIRECTORY_LEVELS]# de niveles de directorio permitidos por su configuración de GEDCOM, su entrada se truncará de manera consecuente.<br /><br />Las miniaturas se subirán o crearán en una estructura de directorios idéntica, colgando de <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b>.<br /><br />";
$pgv_lang["upload_media_file_help"]		= "~#pgv_lang[media_file]#~<br /><br />En este campo se indica el lugar y nombre, en su equipo local, del archivo audiovisual que desea subir al servidor,  Puede usar el botón <b>Examinar</b> para buscar en su equipo local el archivo deseado.<br /><br />El archivo será subido al servidor con el mismo nombre y será colocado en el directorio indicado en el campo <b>#pgv_lang[folder]#</b>.  Si no ve este campo o no puede cambiarlo, se debe a que no tiene permisos suficientes o que su configuración GEDCOM se ha fijado de modo que no permita niveles de directorio por debajo del <b>#GLOBALS[MEDIA_DIRECTORY]#</b> predeterminado.  En este caso, el archivo audiovisual se subirá al directorio <b>#GLOBALS[MEDIA_DIRECTORY]#</b>.<br /><br />";
$pgv_lang["upload_thumbnail_file_help"]	= "~#pgv_lang[thumbnail]#~<br /><br />En este campo puede especificar la ubicación y nombre, en su equipo local, de la miniatura que desea subir al servidor.  Puede utilizar el botón <b>Examinar</b> para buscar en su equipo local el archivo deseado.  Si se rellena este campo, se ignora la casilla <b>#pgv_lang[auto_thumbnail]#</b>.<br /><br />Si se rellena el campo <b>#pgv_lang[media_file]#</b>, su archivo de miniatura subido recibirá el nombre indicado en ese campo en vez del nombre con el que aparece en su equipo local. Si se deja vacío ese campo, el archivo de miniatura subido se copiará a dos lugares en el servidor, una en el directorio del servidor mencionado en el campo <b>#pgv_lang[folder]#</b> y otras en una estructura de directorios idéntica bajo el directorio <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b>.<br /><br />Si no ve el campo <b>#pgv_lang[folder]#</b> o no puede modificarlo, se debe a que no tiene permisos suficientes o que su configuración del GEDCOM se ha fijado para no permitir niveles de directorio bajo <b>#GLOBALS[MEDIA_DIRECTORY]#</b> donde se guardan normalmente los archivos audiovisuales subidos.<br /><br />";


//-- GENERAL
$pgv_lang["help_header"]			= "Información sobre:";
$pgv_lang["privacy_error_help"]			= "~DETALLES PRIVADOS~<br /><br />Existen varios motivos posibles para este mensaje:<br /><br /><ul><li><b>La información de personas vivas se fijó a \"Privada\"</b><br />Los visitantes y los usuarios registrados que no se han identificado sólo pueden ver la información completa de las personas fallecidas.  Si el administrador del sistema lo permitió, los visitantes pueden registrarse para obtener una cuenta haciendo clic en el botón Entrar y, a continuación, en el vínculo #pgv_lang[requestpassword]#.<br /></li><li><b>Vd. es un usuario registrado...</b><br />Pero no se ha identificado con éxito o estuvo inactivo durante un rato y su sesión caducó.<br /></li><li><b>Debido a privacidad</b><br />Esta persona no quiere que se la muestre en absoluto (Oculta) y puede haber pedido al administrador quedar marcado \"Privado\".  La privacidad se puede fijar a:<br /><ol><li>#pgv_lang[PRIV_USER]#</li><li>#pgv_lang[PRIV_NONE]#</li><li>#pgv_lang[PRIV_HIDE]#</li></ol></li><li><b>Fuera del \"Camino de Parentesco\"</b><br />Incluso si es Vd. un usuario habitual <u>y</u> se ha identificado, aún puede ocurrir que vea este mensaje si la persona que intenta ver no está emparentada con Vd. dentro número de saltos de parentesco (longitud del Camino de Parentesco) fijado por el administrador del sitio para este GEDCOM.<br /><br />Ejemplos:<br />Si la longitud del Camino de Parentesco se fija a <b>1</b>, sólo podrá ver los detalles de su propia familia, padres, hermanos/as (pero no los cónyuges de e hijos/as de sus hermanos/as)<br /><br />Si el Camino de Parentesco se fija <b>2</b>, podrá ver también los detalles de los cónyuges de sus hermanos/as pero no los cónyuges de sus hijos/as.<br /><br />Cuanto mayor sea el ajuste de longitud del Camino de Parentesco, más lejanos serán los parientes que pueda ver.<br /></li></ul><br />Si cree que debería poder ciertos detalles ocultos, póngase con contacto con el administrador utilizando el vínculo de contacto en cualquier página.<br /><br />";
$pgv_lang["more_help"]				= "<br />La ayuda contextual está disponible en todas las pantallas; asegúrese de que la opción <b>#pgv_lang[show_context_help]#</b> del menú de Ayuda está activada y haga clic en el <b>?</b> próximo al tema.<br /><br />";
$pgv_lang["more_config_help"]			= "<br /><b>Más ayuda</b><br />#pgv_lang[context_help]#<br /><br />";
$pgv_lang["start_admin_help"]			= "+++ Comienzo de información extra de Administración +++";
$pgv_lang["end_admin_help"]			= "--- Fin de información extra de Administración ---";
$pgv_lang["multiple_help"]			= "<center>--- Esto es un texto de ayuda general para múltiples páginas ---</center>";
$pgv_lang["header_general_help"]		= "<div class=\"name_head\"><center><b>INFORMACIÓN GENERAL</b></center></div><br />";
$pgv_lang["best_display_help"]			= "~Su pantalla~<br />PhpGedView está diseñado para un tamaño de pantalla de 1024x768 píxeles.  Éste es el tamaño mínimo para que todo se muestre apropiadamente. <br /><br />Si fija el tamaño a un valor inferior (p.ej. 800x600 píxeles), puede tener que realizar desplazamientos horizontales en algunas páginas.<br /><br />";
$pgv_lang["preview_help"]			= "~Impresión~<br />Haciendo clic en el vínculo Previsualización para Impresión se eliminarán los elementos que no quedan bien en una página impresa (menús, casillas de entrada de datos, vínculos sobrantes, los signos de interrogación para la ayuda contextual, etc.)<br /><br />En la versión de esta página de Previsualización para Impresión, obtendrá un vínculo <b>Imprimir</b> en la parte inferior de la página.  Haga clic en él y se obtendrá el diálogo emergente de imprimir, Tras imprimir, haga clic en el vínculo <b>Atrás</b> y se volverá a mostrar la versión normal de la paǵina.<br /><br />Nota: Aunque en la \"Previsualización para Impresión\" se eliminan muchos vínculos de la página mostrada, se sigue pudiendo hacer clic en los demás vínculos.<br /><br />";
$pgv_lang["readme_help"]			= "Para mayor información, consulte <a href=\"readme.txt\"><b>Readme.txt</b></a>.";
$pgv_lang["is_user_help"]			= "--- Este texto de ayuda es similar al que el usuario (o visitante) leerá. ---<br />--- Para ahorrar espacio no se ha hecho una versión especial de administración de este texto. ---";
$pgv_lang["edit_raw_gedcom_help"]	= "~EDITAR GEDCOM EN BRUTO~<br /><br />Si hace clic en este vínculo, se abrirá una nueva ventana con los detalles presentados en esta página en formato GEDCOM en bruto.<br /><br />Aquí podrá modificar los datos GEDCOM directamente. Asegúrese de introducir datos válidos según el estándar GEDCOM 5.5.1, ya que no se realiza ningún tipo de comprobación de validez.  Los datos cambiados o agregados se mostrarán como \"cambios\" en PhpGedView y necesitarán ser aceptados por un usuario que tenga de derecho de Aceptar.<br /><br />";
$pgv_lang["RESN_help_title"]		= "Fijar restricciones en los hechos";
$pgv_lang["RESN_help"]				= "~#pgv_lang[RESN_help_title]#~<br /><br />Además de los ajustes de privacidad generales, PhpGedView tiene la capacidad de fijar restricciones en el acceso y modificación de la información relativa a los hechos de personas y familias. Las restricciones pueden ser fijadas por cualquiera con derecho a actualizar la información, a menos que las reglas de privacidad u otras restricciones previas lo prohíban.<br /><br />Se pueden utilizar los siguientes valores:<br /><ul><li><b>#pgv_lang[none]#</b><br />Los administradores del sitio, los administradores del archivo GEDCOM y los usuarios con derecho a modificar pueden cambiar la información. La información del hecho se muestra conforme a los ajustes de privacidad aplicados por el administrador.</li><li><b>#pgv_lang[locked]#</b><br />Este ajuste no cambia la visibilidad de los datos. Restringe los derechos de modificación a los administradores del sitio y a los administradores del archivo GEDCOM. Si la información se refiere al propio usuario, también la puede ver y, si tiene derechos de modificación, editarla.</li><li><b>#pgv_lang[privacy]#</b><br />Los administradores del sitio y los administradores del archivo GEDCOM pueden ver y editar la información. Si la información se refiere al propio usuario, puede verla y, si tiene derechos de modificación, editarla. Quedará oculta a todos los demás usuarios independientemente de si están identificados o no.</li><li><b>#pgv_lang[confidential]#</b><br />Sólo los administradores del sitio y los administradores del archivo GEDCOM pueden ver y editar la información. Quedará oculta a todos los demás usuarios independientemente de si han identificado o no.</li></ul><br /><table><tr><th></th><th colspan=\"2\">Admin</th><th colspan=\"2\">Prop</th><th colspan=\"2\">Otros</th></tr><tr><th></th><th>L</th><th>E</th><th>L</th><th>E</th><th>L</th><th>E</th></tr><tr><td><img src=\"images/RESN_none.gif\" alt=\"\" /> #pgv_lang[none]#</td><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th></tr><tr><td><img src=\"images/RESN_locked.gif\" alt=\"\" /> #pgv_lang[locked]#</td><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th></tr><tr><td><img src=\"images/RESN_privacy.gif\" alt=\"\" /> #pgv_lang[privacy]#</td><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/checked_qm.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th></tr><tr><td><img src=\"images/RESN_confidential.gif\" alt=\"\" /> #pgv_lang[confidential]#</td><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/checked.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th><th><img src=\"images/forbidden.gif\" alt=\"\" /></th></tr></table><ul><li>L : puede leer</li><li>E : puede escribir</li><li><img src=\"images/checked_qm.gif\" alt=\"\" /> : depende de los ajustes globales de privacidad</li></ul>";


//-- Pages Help-messages
//-- Index-page
$pgv_lang["index_help"]				= "~LA PÁGINA DE BIENVENIDA~<br /><br />Ésta es la página de Bienvenida. Le da la bienvenida al archivo <a href=\"#def_gedcom\">GEDCOM</a> seleccionado.Puede volver a esta página seleccionando Página de Bienvenida en el menú superior. De existir múltiples GEDCOMs en este sitio, puede elegir uno de ellos desde el menú desplegable.<br /><br />Esta página de Ayuda contiene información sobre:<ul><li><a href=\"#index_portal\"><b>Página de Bienvenida</b></a></li><li><a href=\"#header\"><b>Área de Encabezamiento</b></a></li><li><a href=\"#menu\"><b>Menús</b></a></li><li><a href=\"#header_general\"><b>Información General</b></a></li><li><a href=\"#def\"><b>Definiciones</b></a></li></ul><br />";

//-- Index-page Header
$pgv_lang["header_help"]			= "<div class=\"name_head\"><center><b>ENCABEZAMIENTO</b></center></div><br />El encabezamiento se muestra en cada página.<br />El encabezamiento contiene algunos vínculos útiles que puede utilizar en todo el sitio.<br /><br />Puesto que este sitio puede tener diferentes aspectos dependiendo del <a href=\"#def_theme\">tema</a> seleccionado, los encabezamientos pueden verse afectados y los vínculos pueden variar.<br /><br />Los vínculos que podría encontrar son:<ul><li><a href=\"#header_search\"><b>Casilla de Búsqueda</b></a></li><li><a href=\"#header_lang_select\"><b>Selector de Idioma</b></a></li><li><a href=\"#header_user_links\"><b>Vínculos de Usuario</b></a></li><li><a href=\"#header_favorites\"><b>Favoritos</b></a></li><li><a href=\"#header_theme\"><b>Cambiar Tema</b></a></li></ul>";
$pgv_lang["header_search_help"]			= "~Encabezamiento: Buscar~<br />Esta caja de búsqueda es pequeña pero poderosa.  Puede hacer que PhpGedView busque prácticamente cualquier cosa. Si hace clic en el botón <b>></b> o <b>Buscar</b>, irá a la página de Búsqueda y verá los resultados de su búsqueda.  Encontrará ayuda extensa sobre las opciones de búsqueda en la página de Búsqueda.<br /><br />";
$pgv_lang["header_lang_select_help"]		= "~Encabezamiento: Selector de Idiomas~<br />Una de las características más importantes de PhpGedView es que funciona con múltiples idiomas.<br /><br />El idioma en que PhpGedView muestra todas las páginas se determina automáticamente según el Idioma Preferido configurado en el navegador.  Sin embargo, el administrador del sitio puede haber limitado la disponibilidad de algunos idiomas.<br /><br />Dependiendo de la configuración del sitio, Vd. puede que tenga la posibilidad de cambiar el idioma de PhpGedView seleccionando un idioma más adecuado a partir de una lista desplegable o haciendo clic en el icono de una bandera.  Si es un usuarios identificado, puede configurar PhpGedView para que cambie a su idioma preferido después de que se identifique, independientemente de la configuración de su navegador.<br /><br />";
$pgv_lang["header_user_links_help"]		= "~Encabezamiento: Vínculos de Usuario~<br />Vínculos de Usuario es un pequeño bloque con vínculos útiles que pueden encontrarse en el mismo sitio en todas las páginas.  La posición de estos vínculos varía según el tema en efecto actualmente.<br /><br />Si no está identificado, sólo verá en vínculo <b>Entrar</b>.  Después de entrar, verá:<ul><li><b>Identificado como (su nombre)</b>.  Si hace clic en ese vínculo irá a la página de su Cuenta.</li><li>Haga clic en <b>Salir</b> para cancelar la identificación.</li><li>Si tiene derechos de administración, también verá <b>Admin</b>. Si hace clic en este vínculo irá directamente a la página principal de Administración.</li></ul><br />";
$pgv_lang["header_favorites_help"]		= "~Encabezamiento: Favoritos~<br />Esta lista desplegable le mostrará los Favoritos que haya seleccionado en su página personalizada de Portal.  También muestra los Favoritos que el Administrador ha elegido para el GEDCOM actualmente activo.  Si hace clic en alguno de sus Favoritos, irá directamente a la página de #pgv_lang[indi_info]# de esa persona.<br /><br />Más ayuda acerca de agregar Favoritos se encuentra disponible en su página personalizada de Portal.<br /><br />";
$pgv_lang["header_theme_help"]		= "~Encabezamiento: Cambiar Tema~<br />Si está habilitado por el administrador del sitio, la lista desplegable de Cambiar Tema muestra los temas que puede utilizar para ver el sitio.<br /><br />Puede cambiar la apariencia del sitio seleccionando un tema de la lista desplegable.  Si está identificado, también cambiará su tema de usuario al que ha eĺegido de modo que la próxima vez que se identifique seleccionará automáticamente el mismo tema.<br /><br />";

//-- Index-page Menu
$pgv_lang["menu_help"]				= "<div class=\"name_head\"><center><b>MENÚS</b></center></div><br />En los encabezamientos existen menús desplegables asociados a cada icono.<br /><br />Si coloca el cursos sobre algunos iconos aparecerá un submenú.  Si hace clic sobre un icono, se mostrará la primera entrada del submenú.<br /><br />Los siguientes iconos del menú suelen estar disponibles:<ul><li><a href=\"#menu_fam\">#pgv_lang[welcome_page]#</a><br /></li><li><a href=\"#menu_myged\">#pgv_lang[mygedview]#</a><br /></li><li><a href=\"#menu_charts\">#pgv_lang[charts]#</a><br /></li><li><a href=\"#menu_lists\">#pgv_lang[lists]#</a><br /></li><li><a href=\"#menu_annical\">#pgv_lang[anniversary_calendar]#</a><br /></li><li><a href=\"#menu_clip\">#pgv_lang[clippings_cart]#</a><br /></li><li><a href=\"#menu_search\">#pgv_lang[search]#</a><br /></li><li><a href=\"#menu_help\">#pgv_lang[page_help]#</a></li></ul><br />";
$pgv_lang["menu_famtree_help"]			= "~Menú de la Página de Bienvenida~<br />Todas las bases de datos genealógicas disponibles se listan en este menú. Cada base de datos tiene su propia página personalizada de Bienvenida, como esta.  Si sólo hay una base de datos en este sitio, no hay submenú bajo el icono de la página de Bienvenida.<br /><br />";
$pgv_lang["menu_myged_help"]			= "~#pgv_lang[mygedview]# menu~<br />Si ha entrado identificándose, este menú puede incluir las siguientes entradas:<ol><li>#pgv_lang[mygedview]#<br />Le lleva a su propia página de Inicio personalizable.</li><li>#pgv_lang[editowndata]#<br />Puede modificar aquí sus datos personales.</li><li>#pgv_lang[my_pedigree]#<br />Si ha seleccionado una persona Raíz para este GEDCOM, esto le llevará al Árbol de Ascendientes de esa persona.</li><li>#pgv_lang[my_indi]#<br />Este vínculo le llevará a su página #pgv_lang[indi_info]#, donde se muestran todos los datos genealógicos sobre Vd. y su familia.</li></ol><br />";
$pgv_lang["menu_charts_help"]			= "~Menú de Diagramas~<br />Los diagramas disponibles son:<ol><li><a href=\"?help=help_pedigree.php\"><b>#pgv_lang[index_header]#</b></a><br />Esto le llevará al diagrama de Árbol de ascendientes de este archivo GEDCOM. El árbol comenzará por la persona configurada por el administrador.  Si está autenticado, la persona inicial puede ser la que haya configurado en las preferencias de su Cuenta.</li><li><a href=\"?help=help_descendancy.php\"><b>#pgv_lang[descend_chart]#</b></a><br />El diagrama de Descendencia es esencialmente un <a href=\"?help=help_pedigree.php\"><b>#pgv_lang[index_header]#</b></a> al revés.  Esta comparación no es del todo correcta, pero mientras el Árbol de ascendientes le muestra todos los ascendientes de una persona inicial, el diagrama de Descendencia le muestra todos los descendientes de una persona inicial.</li><li><a href=\"?help=help_timeline.php\"><b>#pgv_lang[timeline_chart]#</b></a><br />Aquí puede ver los eventos de una persona a lo largo del tiempo.  Es interesante comparar los eventos de dos o más personas en el mismo cronograma.</li><li><a href=\"?help=help_relationship.php\"><b>#pgv_lang[relationship_chart]#</b></a><br />Aquí puede comprobar el parentesco de una person con Vd. o con otra persona.</li><li><a href=\"?help=help_ancestry.php\"><b>#pgv_lang[ancestry_chart]#</b></a><br />Este diagrama es muy similar al <a href=\"?help=help_pedigree.php\"><b>#pgv_lang[index_header]#</b></a>, pero con más detalles y alternativas de <a href=\"?help=chart_style_help\"><b>#pgv_lang[chart_style]#</b></a> de presentación.</li><li><a href=\"?help=help_fanchart.php\"><b>#pgv_lang[fan_chart]#</b></a><br />Este diagrama es muy similar al de <a href=\"?help=help_pedigree.php\"><b>#pgv_lang[index_header]#</b></a>, pero de una forma más gráfica.</li></ol><br />";
$pgv_lang["menu_lists_help"]			= "~Menú de Listas~<br />Están disponibles las siguientes listas:<ol><li><a href=\"?help=help_indilist.php\"><b>#pgv_lang[individual_list]#</b></a></li><li><a href=\"?help=help_famlist.php\"><b>#pgv_lang[family_list]#</b></a><br />En estas dos listas podrá examinar por orden alfabético las listas de personas o familias de este GEDCOM.</li><li><a href=\"?help=help_sourcelist.php\"><b>#pgv_lang[source_list]#</b></a><br />Esta entrada devuelve una lista de todas las fuentes utilizadas en el GEDCOM.</li><li><a href=\"?help=help_placelist.php\"><b>#pgv_lang[place_list]#</b></a><br />Aquí podrá buscar personas por Lugar. Obtendrá una lista a dos columnas. Las personas se listan a la izquierda, las familias a la derecha.</li><li><a href=\"?help=help_medialist.php\"><b>#pgv_lang[media_list]#</b></a><br />Podrá ver esta entrada, sólo si está habilitada por el administrador del sitio.<br />Mostrará vínculos a todos los archivos audiovisuales utilizados en este GEDCOM.</li></ol><br />";
$pgv_lang["menu_annical_help"]			= "~#pgv_lang[anniversary_calendar]# Menu~<br />El #pgv_lang[anniversary_calendar]# muestra los eventos de un GEDCOM para una fecha, mes o año dados.<ol><li><a href=\"?help=day_month_help\"><b>#pgv_lang[viewday]#</b></a></li><li><a href=\"?help=day_month_help\"><b>#pgv_lang[viewmonth]#</b></a></li><li><a href=\"?help=day_month_help\"><b>#pgv_lang[viewyear]#</b></a><br />Estas entradas del menú le llevarán al #pgv_lang[anniversary_calendar]# para mostrar una lista de todos los eventos para el día, mes o año actuales.</li></ol><br />";
$pgv_lang["menu_clip_help"]			= "~#pgv_lang[clippings_cart]# Menu~<br />Si está habilitado por el administrador de este sitio GEDCOM, verá a este elemento en la barra de menús.<br /><br />El #pgv_lang[clip_cart]# le permite almacenar información de personas, familias y fuentes en un archivo temporal que puede descargar luego en formato GEDCOM 5.5.1.<br /><br />";
$pgv_lang["menu_search_help"]			= "~Menú de Búsqueda~<br />La página de Búsqueda es una versión más poderosa de la caja Buscar en el encabezamiento de cada página.<br /><br />";
$pgv_lang["menu_help_help"]			= "~Menú Ayuda~<br />#pgv_lang[help_help_items]#";

//-- Index-page Portal
$pgv_lang["index_portal_head_help"]		= "<div class=\"name_head\"><center><b>LA PÁGINA DE BIENVENIDA</b></center></div><br />";
$pgv_lang["index_portal_help"]			= "La página de Bienvenida consiste en varios bloques separados y puede personalizarse. En los sitios que tienen más de una base de datos genealógica, puede ver páginas de Bienvenida distintas para cada una.  Dependiendo de cómo haya personalizado el sitio el administrador, podrá ver cualquiera de los bloques siguientes en la página de Bienvenida:<ul><li><a href=\"#index_welcome\"><b>Bienvenida</b></a></li><li><a href=\"#index_login\"><b>Identificación</b></a></li><li><a href=\"#index_events\"><b>Próximos eventos</b></a></li><li><a href=\"#index_onthisday\"><b>En este día en su historia</b></a></li><li><a href=\"#index_charts\"><b>Diagramas</b></a></li><li><a href=\"#index_favorites\"><b>Favoritos del GEDCOM</b></a></li><li><a href=\"#index_stats\"><b>Estadísticas del GEDCOM</b></a></li><li><a href=\"#index_common_surnames\"><b>Apellidos más comunes</b></a></li><li><a href=\"#index_media\"><b>Imagen al azar</b></a></li><li><a href=\"#index_loggedin\"><b>Usuarios conectados</b></a></li><li><a href=\"#gedcom_news\"><b>Novedades del GEDCOM</b></a></li><li><a href=\"#recent_changes\"><b>Cambios recientes</b></a></li></ul><br />";
$pgv_lang["index_welcome_help"]			= "~BLOQUE DE BIENVENIDA~<br />Este bloque de Bienvenida le mostrará:el título de la base de datos actual, la fecha y la hora y, si está habilitado por el administrador, el Contador de Visitas.<br /><br />El Contador de Visitas sólo está disponible en el bloque de Bienvenida y en la página #pgv_lang[indi_info]#.<br />Este contador cuenta las \"Visitas\" a estas páginas, o sea, la cantidad de veces que estas páginas se han visitado.<br />El contador no comprueba la dirección Internet del visitante; cada visita a una página desde <u>cualquier</u> ubicación remota cuenta como otro Impacto.<br /><br />";
$pgv_lang["index_login_help"]			= "~BLOQUE DE ENTRADA~<br />Puede entrar e iniciar sesión autenticada desde casi cualquier página de este programa. Generalmente lo hará en la primera página, puesto que sólo puede acceder a la información restringida cuando está autenticado.<br /><br />Puede entrar introduciendo su <b>nombre de usuario</b> y <b>contraseña</b> y haciendo clic a continuación en el botón Entrar.<br /><br />";
$pgv_lang["index_events_help"]			= "~BLOQUE DE PRÓXIMOS EVENTOS~<br />Este bloque muestra los aniversarios de eventos que se van a dar en el futuro próximo.<br /><br />El administrador determina el plazo máximo de avance.  Puede ajustar la presentación de próximos eventos mediante varias opciones de configuración.<br /><br />#pgv_lang[cal_download_user_help]#";
$pgv_lang["todo_help"] = "~BLOQUE TAREAS PENDIENTES~<br />Este bloque le permite controlar las tareas pendientes marcadas con la etiqueta <b>_TODO</b> en la base de datos.<br /><br />Para agregar tareas a sus registros, primero puede que tenga que modificar la configuración del GEDCOM para que aparezca <b>_TODO</b> en la lista de hechos que se pueden agregar a los registros de personas, familias, fuentes y repositorios.  Cada una de estas listas, que encontrará en la sección de Opciones de Edición de la configuración de GEDCOM, es independiente.  El orden de las entradas en la lista es indiferente, puede agregar las nuevas entradas al comienzo de cada lista.<br /><br />";
$pgv_lang["todo_show_other_help"]     = "Mostrar tareas pendientes asignadas a otros usuarios";
$pgv_lang["todo_show_unassigned_help"]= "Mostrar tareas pendientes no asignadas a ningún usuario";
$pgv_lang["todo_show_future_help"]= "Mostrar tareas pendientes con fechas futuras.  De lo contrario, solamente se muestran las tareas con fechas pasadas.";
$pgv_lang["yahrzeit_help"]			="~BLOQUE DE ANIVERSARIOS DE DEFUNCIÓN~<br />Este bloque muestras los aniversarios de defunción que ocurrirán en un futuro próximo.<br /><br />Estos aniversarios se celebran en la tradición judía, pero ya no son tan corrientes en la tradición Católica Romana.<br /><br />El administrador determina el plazo en el futuro que se analiza.  Puede cambiar la presentación de los próximos aniversarios mediante opciones de configuración.<br /><br />#pgv_lang[cal_download_user_help]#<br /><br />";
$pgv_lang["days_to_show_help"]			= "~#pgv_lang[days_to_show]#~<br /><br />Introduzca el número de días a mostrar.  Este número no puede ser mayor que <b>#DAYS_TO_SHOW_LIMIT#</b>.  Si introduce un valor mayor, se usará el límite.<br /><br />El límite mostrado lo fija el administrador en la configuración de GEDCOM, sección de Presentación y Disposición, subsección Ocultar y Mostrar.";
$pgv_lang["random_media_persons_or_all_help"] = "~#pgv_lang[random_media_persons_or_all]#~<br /><br />Esta opción le permite determinar el tipo de objeto audiovisual a mostrar.<br /><br />Si selecciona <b>#pgv_lang[random_media_persons]#</b>, sólo se muestran objetos relacionados con personas.  Normalmente, se trataría de la foto de una persona.  Si selecciona <b>#pgv_lang[random_media_events]#</b>, sólo se mostrarían los objetos relacionados con hechos o eventos.  Por ejemplo, la imagen de un certificado.  Si selecciona <b>#pgv_lang[all]#</b>, este bloque mostrará objetos de todos los tipos.";
$pgv_lang["random_media_filter_help"] = "~#pgv_lang[filter]#~<br /><br />Puede restringir lo que se le permite mostrar al bloque de Objeto al Azar según el formato y tipo del objeto.  Si se marca una casilla dada, el bloque de Objetos al Azar podrá mostrar objetos de ese formato o tipo.<br /><br />Si hay en su base de datos objetos con formatos o tipos sin casilla correspondiente, se tratarán como si la casilla correspondiente existiera y estuviera marcada.  Por ejemplo, si su base de datos contiene objetos de formato <b><i>pdf</i></b>, el bloque de Objeto al Azar siempre podrá mostrarlos.  De forma similar, si su base de datos contiene objetos de tipo <b><i>especial</i></b>, el bloque de Objeto al Azar siempre podrá mostrarlos.";
$pgv_lang["basic_or_all_help"]			= "~#pgv_lang[basic_or_all]#~<br /><br />Esta opción le permite eliminar algunos eventos con fecha.  Por ejemplo, #factarray[DIV]#, #factarray[CREM]#, #factarray[GRAD]#, #factarray[BARM]#, #factarray[FCOM]#, etc. deberían todos tener fecha.<br /><br />Si selecciona <b>Sí</b>, sólo se mostrarán Nacimientos, Defunciones y Matrimonios. Si selecciona <b>No</b>, se mostrarán todos los eventos con fecha.";
$pgv_lang["style_help"]					= "~#pgv_lang[style]#~<br /><br />Esta opción controla cómo se presenta la información.<br /><br />Si selecciona <b>#pgv_lang[style1]#</b>, la información se muestra en forma de texto, de forma similar a como se muestra en las distintas cajas de los diagramas.  Este formato va bien a los bloques que se muestran en el lado derecho de la página.<br /><br />Si selecciona <b>#pgv_lang[style2]#</b>, la información se presenta de forma tabular y va mejor a los bloques más grandes que se muestran en el lado izquierdo de la página.";
$pgv_lang["sort_style_help"]			= "~#pgv_lang[sort_style]#~<br /><br />Esta opción controla cómo se ordena la información.<br /><br />Si selecciona <b>#pgv_lang[by_alpha]#</b>, la información se muestra en orden alfabético. Si selecciona <b>#pgv_lang[by_anniv]#</b>, la información se ordena por aniversario, con los aniversarios más recientes antes.";
$pgv_lang["cal_dowload_help"]			= "~#pgv_lang[cal_download]#~<br /><br />Esta opción controla si el botón para descargar eventos de calendario se muestra a los usuarios autenticados conectados. El archivo de calendario descargado puede importarse a programas compatibles como Microsoft Outlook para, por ejemplo, generar recordatorios automáticos por correo electrónico de los cumpleaños, aniversarios, etc.<br /><br />Si se fija a <b>#pgv_lang[no]#</b>, el usuario no podrá descargar el archivo de calendario.  Si se fija a <b>#pgv_lang[yes]#</b>, el botón Descargar se mostrará.  Este botón nunca se muestra a los usuarios no autenticados.";
$pgv_lang["cal_download_user_help"]			= "Si se ha identificado, es posible que vea el icono <img src='images/hcal.png' alt='' />. Si hace clic en el icono, descargará los eventos como un archivo de calendario que puede importarse a programas compatibles como Microsoft Outlook para, por ejemplo, generar automáticamente mensajes de correo electrónico recordatorios de aniversarios.<br /><br />Si se ha identificado y no ve este icono, es que el administrador ha desactivado esta facilidad. Los visitantes que no se han identificado no verán este icono y no podrán descargar el archivo de calendario.<br /><br />";
$pgv_lang["index_charts_help"]		= "~#pgv_lang[charts_block]#~<br />Este bloque le permite colocar un diagrama de árbol de ascendientes, descendientes o en \"reloj de arena\" en la página de Bienvenida o del portal MiGedView.  Debido a limitaciones de espacio, el diagrama debería colocarse únicamente en lado izquierdo de la página.<br /><br />Si aparece este bloque en la página de bienvenida, la persona inicial y el tipo de diagrama lo elige el administrador.  Si este bloque aparece en la página personalizada del usuario MiGedView, estas opciones las elige el propio usuario.<br /><br />El comportamiento de estos diagramas es idéntico a su comportamiento cuando aparecen por separado.  Haga clic en la caja de una persona para ver más detalles de la misma.<br /><br />";
$pgv_lang["index_onthisday_help"]		= "~BLOQUE EN ESTE DÍA EN SU HISTORIA~<br />Este bloque es similar al bloque de \"Próximos Eventos\", solo que aquí se muestran los eventos del día actual.<br /><br />#pgv_lang[cal_download_user_help]#";
$pgv_lang["index_favorites_help"]		= "~BLOQUE DE FAVORITOS DEL GEDCOM~<br />El bloque de Favoritos del GEDCOM es muy parecido al bloque \"Mis favoritos\" de la página #pgv_lang[mygedview]#. A diferencia de la configuración de la página Portal, sólo el administrador o un usuario con derechos de administración puede cambiar la lista de de favoritos de este bloque.<br /><br />El objeto de este bloque de Favoritos del GEDCOM es dirigir la atención del visitante a personas de especial interés.  Los favoritos de este GEDCOM se pueden seleccionar de una lista desplegable en el encabezamiento de cada paǵina.<br /><br />Si hace clic en uno de los favoritos del sitio, se le llevará a la página #pgv_lang[indi_info]# de esa persona.<br /><br />";
$pgv_lang["index_add_favorites_help"]	= "~AGREGAR UN FAVORITO~<br />Este formulario le permite agregar un nuevo elemento favorito a su lista de favoritos.  Debe introducir, o bien el ID de la persona, familia o fuente que desea almacenar como uno de los favoritos, o introducir una URL y un título.  El campo Nota es opcional y puede utilizarse para describir el favorito.  Cualquier cosa que se escriba en el campo Nota se mostrará en el bloque de Favoritos detrás del elemento.<br /><br />";
$pgv_lang["index_stats_help"]			= "~BLOQUE DE ESTADÍSTICAS GEDCOM~<br />En este bloque verá algunas estadísticas del GEDCOM actual.<br />Si desea mayor información que la desplegada, puede enviar una nota a la persona de contacto al final de la página.<br /><br />";
$pgv_lang["index_common_names_help"]		= "~APELLIDOS MÁS COMUNES~<br />Este bloque muestra una lista de apellidos frecuentes en esta base de datos junto con el número de repeticiones. Hacer clic en un apellido le llevará a la lista de personas con ese apellido.<br /><br />El administrador determina cuántos apellidos se muestran.<br /><br />";
$pgv_lang["index_common_given_names_help"]		= "~NOMBRES DE PILA MÁS CORRIENTES~<br />Este bloque muestra la lista de los nombres de pila más corrientes en esta base de datos. Muestra hombres y mujeres en columnas.  Aparecerá una tercera columna si hay personas de sexo desconocido.<br /><br />El administrador determina cuántos nombres se muestran.<br /><br />";
$pgv_lang["index_media_help"]			= "~BLOQUE DE IMAGEN AL AZAR~<br />En este bloque, PhpGedView elegirá al azar un archivo audiovisual y la mostrará en cada visita a esta página.<br /><br />Si hace clic en la foto, la verá a tamaño completo.  Bajo la foto tiene un enlace a la persona asociada con la foto.  Si hace clic en el rótulo de la foto, verá la foto en la página #pgv_lang[media_list]#. Si hace clic en el nombre de la persona, irá a la página #pgv_lang[indi_info]# de esa persona.<br /><br />";
$pgv_lang["index_loggedin_help"]		= "~BLOQUE DE USUARIOS PRESENTES~<br />Este bloque le muestra los usuarios presentes actualmente en el sistema.<br /><br />Si no es un administrador, su visión de usuarios presentes está restringida a aquellos que han elegido ser visibles mientras están en línea.  Para que funcione, también debe Vd. haber elegido ser visible mientras está en línea.  Los usuarios que sean invisibles para Vd. se cuentan como si fueran anónimos.<br /><br />";
$pgv_lang["index_gedcom_news_help"]		= "~BLOQUE DE NOVEDADES GEDCOM~<br />Este bloque de Novedades es como un tablón de anuncios para este GEDCOM.  El administrador del sitio podrá colocar aquí anuncios importantes o novedades interesantes.<br /><br />Si tiene algo interesante para publicar, contacte con el administrador del sitio; él puede colgar su mensaje en este tablón de anuncios.<br /><br />";
$pgv_lang["recent_changes_help"]			= "~BLOQUE DE MODIFICACIONES RECIENTES~<br />Este bloque le muestra los cambios más recientes realizados al GEDCOM en función de lo indicado por las etiquetas CHAN del GEDCOM.<br /><br />";
$pgv_lang["gedcom_news_limit_help"]		= "Puede limitar el número de artículos de noticias mostrados, reduciendo asó la altura del bloque de noticias.<br /><br />Esta opción determina si debe haber algún límite o si el límite debe ir según la antigüedad del artículo o según el número de artículos.<br /><br />";
$pgv_lang["gedcom_news_flag_help"]		= "Introduzca el valor límite aquí.<br /><br />Si ha optado por limitar la presentación de noticias por antigüedad, cualquier artículo con más días que los indicados se ocultará.  Si ha optado por limitar la presentación por número, sólo se presentará ese número de artículos recientes. ordenados por fecha.  Los demás artículos quedarán ocultos.<br /><br />Si se introduce cero, el límite quedará desactivado y se mostrarán todos los artículos de noticias.<br /><br />";
$pgv_lang["gedcom_news_archive_help"]	= "Para reducir la altura del bloque de Noticias, el administrador ha ocultado algunos artículos.  Puede revelar estos artículos ocultos haciendo clic en el vínculo <b>#pgv_lang[gedcom_news_archive]#</b>.<br /><br />";
$pgv_lang["index_htmlplus_help"]		= "~#pgv_lang[htmlplus_block_name]#~<br />Este bloque permite al administrador agregar información a las páginas de Índice o de Portal.  Su misión es similar a la de los bloques #pgv_lang[html_block_name]#, #pgv_lang[gedcom_news_block]#, y #pgv_lang[gedcom_stats_block]#, pero el administrador tiene más control sobre su apariencia.<br /><br />";
$pgv_lang["index_htmlplus_title_help"]	= "~#factarray[TITL]#~<br />Este texto debería dejarse en blanco o ser muy breve.  Si está en blanco, el bloque de HTML Avanzado se mostrará en la página de Índice o de Portal como un texto sencillo, igual que el bloque HTML.  Si tiene texto, el bloque de HTML Avanzado se mostrará como los demás bloques, incluso con una barra de título del bloque con el texto que introduzca aquí.<br /><br />";
$pgv_lang["index_htmlplus_template_help"]	= "~#pgv_lang[htmlplus_block_templates]#~<br />Para ayudarle a comenzar con este bloque, hemos creado varias plantillas estándar.  Si selecciona una de estas plantillas, el área de texto contendrá una copia que podrá alterar luego para adaptarla a los requisitos de su sitio.<br /><br />";
$pgv_lang["index_htmlplus_content_help"]	= "~#pgv_lang[htmlplus_block_content]#~<br />A diferencia de los bloques #pgv_lang[html_block_name]#, #pgv_lang[gedcom_news_block]# y #pgv_lang[gedcom_stats_block]#, tiene control completo sobre la apariencia de su bloque.  Puede usar etiquetas HTML y el bloque utiliza las hojas de estilo CSS de su tema activo actualmente.  Se pueden incluir en el texto referencias a información de la base de datos genealógica activa actualmente.<br /><br />Las referencias a la base de datos se indican en el texto rodeando las palabras claves por un par de símbolos <b>&#35;</b>.  Por ejemplo, <b>&#35;totalFamilies&#35;</b> representa el número total de familias en la base de datos.  A veces, puede desear utilizar una referencia a la base de de datos como texto en vez de su verdadero significado.  Para hacerlo, necesita sustituir los símbolos que la rodean por su equivalente simbólico.  Por ejemplo si su texto contiene <b>&amp;&#35;35;totalFamilies&amp;&#35;35;</b> se mostrará como <b>&#35;TOTAL_FAM&#35;</b> en vez de convertirse en una referencia a la base de datos.<br /><br />Para un ejemplo completo de uso de este bloque, estudie la plantilla &quot;#pgv_lang[gedcom_stats_block]#&quot; que se encuentra en el directorio blocks/, utiliza la mayoría de los estilos de etiquetas, incluyendo vínculos a los idiomas y a los textos de ayuda.<br /><br />La plantilla  <b>#pgv_lang[htmlplus_block_keyword]#</b> contiene una lista completa de todas las palabras clave posibles.<br /><br />";
$pgv_lang["index_htmlplus_compat_help"]	= "~#pgv_lang[htmlplus_block_compat]#~<br />Activar la compatibilidad con versiones anteriores de este bloque.  Si se marca, tanto las palabras clave viejas como las nuevas se reconocerán y tratarán.<br /><br />Por ejemplo, el texto <b>&#35;TOTAL_FAM&#35;</b> se reconocerá como equivalente a <b>&#35;totalFamilies&#35;</b>, <b>&#35;FIRST_DEATH_PLACE&#35;</b> a <b>&#35;firstDeathPlace&#35;</b>, <b>&#35;TOP10_BIGFAM&#35;</b> a <b>&#35;topTenLargestFamily&#35;</b>, etc.<br /><br />A menos que sea absolutamente necesario, no debería utilizar el modo de Compatibilidad.<br /><br />";
$pgv_lang["index_htmlplus_gedcom_help"] = "~#pgv_lang[htmlplus_block_gedcom]#~<br />Seleccione la base de datos a la que se aplican las palabras clave.<br /><br />Su sitio aloja varias bases de datos.  Palabras clave como <b>&#35;totalFamilies&#35;</b> sólo pueden referirse a una base de datos.  Puede identificar la base de datos que ha consultarse para todas estas palabras clave.  Cada bloque #pgv_lang[htmlplus_block_name]# sólo puede acceder a una base de datos.<br /><br />";
$pgv_lang["showUnknown_help"]	= "~#pgv_lang[showUnknown]#~<br />Ocultar o mostrar la lista de nombres de pila de personas de sexo desconocido.<br /><br />El bloque #pgv_lang[block_givn_top10]# siempre oculta la lista de nombres de pila si no hay personas de ese sexo en la base de datos.  Esta opción le permite ocultar la lista de personas de sexo desconocido aunque las haya en su base de datos.<br /><br />";

//-- Index-Page Help
$pgv_lang["help_help"]				= "Por supuesto, sería ideal crear un programa tan sencillo y fácil de utilizar que no necesite de ningún tipo de explicación, sería tan sencillo como leer un libro.<br /><br />Aunque PhpGedView es muy complicado, no debería notarlo al utilizarlo, casi todo puede utilizarse sin explicación.  Pero, puesto que puede haber muchos visitantes y usuarios sin mucha experiencia en el uso de computadoras o con la Internet, le ofrecemos algo de ayuda en ciertos sitios.<br /><br />Encontrará las siguientes entradas en el menú de Ayuda:";
$pgv_lang["help_page_help"]			= "<dl><dt><b>Ayuda con esta página*</b></dt><dd>Para todas la páginas existe una \"Ayuda de la Página\" disponible.  Puede hace clic en esta entrada del menú para obtener \"Ayuda de la Página\", donde se le informará sobre los elementos de esa página.<br /><br />La Ayuda de la Página es a menudo breve.  Si necesita más ayuda o información sobre un determinado elemento de una página que la que da la Ayuda de la Página, puede utilizar la función de \"Ayuda Contextual\".</dd></dl>";
$pgv_lang["help_content_help"]		= "<dl><dt><b>Contenido de la Ayuda</b></dt><dd>Si hace clic en esta entrada del menú, obtendrá una página Ayuda con un índice de los principales temas Ayuda.  El volumen de información de Ayuda disponible se irá incrementando según permita el tiempo.</dd></dl>";
$pgv_lang["help_faq_help"]			= "<dl><dt><b>Lista de preguntas frecuentes</b></dt><dd>#pgv_lang[text_faq_help]#</dd></dl>";
$pgv_lang["help_HS_help"]			= "<dl><dt><b>#pgv_lang[hs_title]#</b></dt><dd>#pgv_lang[hs_intro]#</dd></dl>";
$pgv_lang["help_qm_help"]			= "<dl><dt><b>Ocultar / Mostrar Ayuda Contextual*</b></dt><dd>Esta última entrada del menú puede resultarle muy útil. Si hace clic en este vínculo activará o no la \"Ayuda Contextual\".<br /><br />Si la Ayuda Contextual está activada, encontrará un signo de interrogación o un icono similar junto a algunos vínculos, cajas desplegables o botones. Si hace clic en este icono, emergerá una ventana de Ayuda.  Esta pantalla de Ayuda contiene información sobre ese objeto.<br /><br />Por supuesto, al hacer clic en \"Ocultar Ayuda Contextual\" desaparecerán todos los signos de interrogación o iconos, hasta que haga clic de nuevo en \"Mostrar...\".</dd></dl>";

//-- Index-page Definitions
$pgv_lang["def_help"]				= "<div class=\"name_head\"><center><b>#pgv_lang[definitions]#</b></center></div><br />Algunas definiciones de palabras utilizadas en este texto de ayuda:<ul><li><a href=\"#def_gedcom\"><b>GEDCOM</b></a><br /></li><li><a href=\"#def_gedcom_date\"><b>Dates</b></a></li><li><a href=\"#def_pdf_format\"><b>PDF file format</b></a></li><li><a href=\"#def_pgv\"><b>PhpGedView</b></a></li><li><a href=\"#def_portal\"><b>Portal</b></a></li><li><a href=\"#def_theme\"><b>Theme</b></a></li></ul><br />";
$pgv_lang["def_portal_help"]			= "~Portal~<br />El Portal de este sitio es como el salón de recepción de un restaurante o de una biblioteca pública. Es el lugar por el que se entra, pero en el que encontrará información importante como explicaciones, menús, etc.<br /><br />";
$pgv_lang["def_gedcom_help"]			= "~Archivo GEDCOM~<br />Una cita de la Introducción al Estándar GEDCOM 5.5.1:<div class=\"list_value_wrap\">GEDCOM fue desarrollado por el Departamento de Historia Familiar de La Iglesia de Jesucristo de los Santos de los Últimos Días (Iglesia SUD) para proporcionar un formato flexible y uniforme para el intercambio de datos genealógicos entre computadoras.&nbsp; GEDCOM es el acrónimo de <i><b>GE</b></i>nealogical <i><b>D</b></i>ata <i><b>Com</b></i>munication o, en español, Comunicación de Datos Genealógicos.&nbsp; Su propósito es fomentar el intercambio de información genealógica y el desarrollo de un amplio abanico de programas capaces de interoperar entre sí para ayudar a los genealogistas, los historiadores y a otros investigadores.</div><br />Se puede descargar una copia en formato PDF del Estándar <u>borrador</u> GEDCOM 5.5.1, al que se adhiere PhpGedView, aquí:&nbsp; <a href=\"http://www.phpgedview.net/ged551-5.pdf\" target=\"_blank\">GEDCOM 5.5.1 Standard</a>  Este estándar sólo está disponible en inglés.<br /><br />El archivo GEDCOM contiene toda la información acerca de la familia.&nbsp; Todos los hechos, fechas, eventos, etc. se almacenan aquí.&nbsp; Los archivos GEDCOM tienen que seguir reglas estrictas porque deben poderse intercambiar entre muchos programas, en distintas plataformas y sistemas operativos.<br /><br />";
$pgv_lang["def_gedcom_date_help"]		= "~Fechas en un archivo GEDCOM~<br />Aunque el campo de fecha permite introducir datos en formato libre (es decir, que puede teclear lo que quiera), hay algunas reglas acerca de cómo deben introducirse las fechas según el estándar GEDCOM 5.5.1.<ol><li>Una fecha completa se introduce en la forma DD MMM AAAA.  Por ejemplo, <b>01&nbsp;MAR&nbsp;1801</b> o <b>14&nbsp;DEC&nbsp;1950</b>.</li><li>Si desconoce parte de la fecha, puede omitirla.  Por ejemplo: <b>MAR&nbsp;1801</b> or <b>14&nbsp;DEC</b>.</li><li>Si no está seguro o la fecha no está confirmada, podría introducir <b>ABT&nbsp;MAR&nbsp;1801</b> (ABT = hacia), <b>BEF&nbsp;20&nbsp;DEC&nbsp;1950</b> (BEF = antes de), <b>AFT&nbsp;1949</b> (AFT = después de)</li><li>Los rangos de fechas se introducen como <b>FROM&nbsp;MAR&nbsp;1801&nbsp;TO&nbsp;20&nbsp;DEC&nbsp;1810</b> (FROM = desde, TO = hasta) o como <b>BET&nbsp;MAR&nbsp;1801&nbsp;AND&nbsp;20&nbsp;DEC&nbsp;1810</b> (BET = entre, AND = y)<br /><br />La forma <b>FROM</b> indica que el evento descrito ocurrió de manera continua entre las fechas indicadas y se usa normalmente con eventos como un empleo. La forma <b>BET</b> indica un evento que sucedió en alguna fecha entre las indicadas y se utiliza con eventos como el nacimiento.<br /><br />Fechas imprecisas, en las que falta el día del mes o el mes, se interpretan siempre como al primera o última fecha posibles, según si la fecha imprecisa aparece antes o después de la palabra clave separadora.  Por ejemplo, <b>FEB&nbsp;1804</b> se interpreta como <b>01&nbsp;FEB&nbsp;1804</b> si aparece antes de TO o AND, y como <b>29&nbsp;FEB&nbsp;1804</b> si aparece tras TO o AND.</li></ol><b>Asegúrese de introducir las fechas y abreviaturas en <u>inglés</u>,</b> ya que de ese modo los archivos GEDCOM son intercambiables y el programa traducirá correctamente todas la fechas y abreviaturas al idioma activo en cada momento.  Además, PhpGedView hace cálculos con estas fechas.  Si se introducen fechas incorrectas en los campos de fecha, PhpGedView no podrá calcular correctamente.<br /><br />Puede hacer clic en el icono Calendario para recibir ayuda en la selección de una fecha.<br /><br />";
$pgv_lang["def_gramps_help"]		= "~Un archivo de base de datos GRAMPS XML~<br />Cita del proyecto GRAMPS: <div class=\"list_value_wrap\">GRAMPS le ayuda a gestionar su árbol genealógico. Le permite almacenar, modificar e investigar los datos genealógicos. GRAMPS intenta proporcionar todas las capacidades comunes de otros programas genealógicos pero, con especial hincapié, proporcionar una capacidad adicional de integración que no es corriente en estos programas. Se trata de la capacidad de introducir cualquier fragmento de información directamente a GRAMPS y reordenar/manipular algunos/todos de los eventos de datos en la base de datos entera (en cualquier orden o secuencia) para ayudar al usuario en su investigación, análisis y correlación con el potencial de rellenar vacíos en el parentesco.</div><br />Se puede encontrar <a href=\"http://www.gramps-project.org/xml/1.1.0/\" target=\"_blank\">aquí</a> una copia de la especificación del formato GRAMPS XML v1.1.0 tanto en formato de esquema RELAX NG como en formato DTD.<br /><br />Para más información sobre el proyecto GRAMPS, visite <a href=\"http://gramps-project.org/\" target=\"_blank\">http://gramps-project.org/</a>";
$pgv_lang["def_pgv_help"]			= "~PhpGedView~<br />PhpGedView (o PGV) no sólo coloca páginas estáticas en la Web; es dinámico y puede personalizarse en muchos aspectos.<br /><br />PhpGedView fue creado por John Finlay para ver archivos GEDCOM en línea.  John comenzó desarrollando el programa por su cuenta.  Un equipo internacional de desarrolladores y traductores se le ha unido desde entonces y trabaja para mejorar el programa.  Entre las características más significativas que se han añadido o mejorado en el programa, está su extenso apoyo a idiomas distintos del inglés y su capacidad de agregar y modificar eventos en línea.<br /><br />";
$pgv_lang["def_theme_help"]			= "~Tema~<br />Este sitio puede tener diferentes \"aspectos\", llamados Temas.<br /><br />El administrador del sitio elige un Tema por omisión, que verá inicialmente todo el que acceda al sitio. Si el administrador ha activado la posibilidad, los usuarios pueden seleccionar luego sus propios temas.  PhpGedView recuerda el último Tema seleccionado para cada usuario autenticado, de modo que ese usuario verá ese Tema la próxima vez que entre. Los temas se pueden utilizar como una forma de distinguir entre varias bases de datos en el mismo sitio.  Cada base de datos puede tener su propio tema por omisión.<br /><br />";

//-- Index-page MyGEDCOM
$pgv_lang["mygedview_portal_help"]		= "~#pgv_lang[mygedview]#~<br />Esta es su página Personal #pgv_lang[mgv]#.<br /><br />Encontrará aquí vínculos directos para acceder a sus datos personales como <b>Mi cuenta</b>, <b>Mi ficha</b> (esta es su página #pgv_lang[indi_info]#) y <b>Mi Árbol</b>.  Puede tener bloques con <b>Mensajes</b>, un <b>Diario</b> (como un bloc de notas) y muchos otros.<br /><br />La distribución de esta página es similar al de la página de Bienvenida que ve cuando accede por primera vez al sitio.  Mientras que las partes de la la página de Bienvenida son seleccionadas por el administrador del sitio, Vd. puede seleccionar qué partes incluir en esta página personalizada.  Encontrará el vínculo para personalizar esta página en el bloque de Bienvenida o de forma separada si no está presente el bloque de Bienvenida.<br /><br />Puede elegir de entre los siguientes bloques:<ul><li><a href=\"#mygedview_welcome\"><b>Bienvenida</b></a></li><li><a href=\"#mygedview_customize\"><b>Personalizar MiGedView</b></a></li><li><a href=\"#mygedview_message\"><b>Mensajes</b></a></li><li><a href=\"#mygedview_events\"><b>Próximos eventos</b></a></li><li><a href=\"#mygedview_onthisday\"><b>En este día en su historia</b></a></li><li><a href=\"#mygedview_charts\"><b>Diagramas</b></a/</li><li><a href=\"#mygedview_favorites\"><b>Mis favoritos</b></a></li><li><a href=\"#mygedview_stats\"><b>Estadísticas del GEDCOM</b></a></li><li><a href=\"#mygedview_myjournal\"><b>Mi diario</b></a></li><li><a href=\"#mygedview_media\"><b>Objeto al azar</b></a></li><li><a href=\"#mygedview_loggedin\"><b>Usuarios presentes</b></a></li><li><a href=\"#mygedview_recent_changes\"><b>Cambios recientes</b></a></li></ul><br />";
$pgv_lang["mygedview_customize_help"]		= "~PERSONALICE SU #pgv_lang[mygedview]#~<br />Cuando entró aquí por primera vez, ya había algunos bloques en esta página.<br />Si lo desea, puede personalizar esta página de Portal.<br /><br />Si hace clic en este vínculo irá a un formulario en el que puede agregar, mover o quitar bloques.  En ese formulario hay más información.<br /><br />";
$pgv_lang["mygedview_message_help"]		= "~BLOQUE DE MENSAJES~<br />En este bloque, encontrará los mensajes que le hayan enviado otros usuarios o el administrador.  También podrá enviar sus propios mensajes a otros usuarios o al administrador.<br /><br />El sistema de correo PhpGedView está diseñado para ayudar a proteger su privacidad.  No necesita dejar su dirección de correo electrónico aquí y otras personas no podrán verla.<br /><br />Para expandir un mensaje, haga clic en el asunto del mensaje o en el signo \"<b>+</b>\" junto a él.  Puede borrar múltiples mensajes, marcando las casillas próximas a los mensajes que desea eliminar y haciendo clic en el botón \"Borrar mensajes seleccionados\".<br /><br />";
$pgv_lang["mygedview_favorites_help"]		= "~BLOQUE MIS FAVORITOS~<br />Los favoritos son similares a marcadores.<br /><br />Suponga que existe una persona en su Árbol Genealógico cuyo registro desea comprobar regularmente.  Vaya a la página #pgv_lang[indi_info]# de la persona y seleccione la opción <b>Agregar a Mis Favoritos</b> del la lista desplegabla de Favoritos. Habrá añadido un marcador a la persona y habrá sido agregada a su lista de favoritos.<br /><br />Siempre que esté identificado en el sitio, puede hacer clic en un nombre de la lista desplegable \"Mis Favoritos\" del encabezamiento.  Esto lo llevará a la página #pgv_lang[indi_info]# de esa persona.<br /><br />";
$pgv_lang["mygedview_myjournal_help"]		= "~BLOQUE MI DIARIO~<br />Puede utilizar este diario para escribir notas o recordatorios para su propio uso.  Si escribe una nota, seguirá ahí la próxima vez que visite el sitio.<br /><br />Estas notas son privadas y no serán visibles a otros.<br /><br />";
$pgv_lang["mygedview_welcome_help"]		= "~BLOQUE DE BIENVENIDA~<br />El bloque de Bienvenida le muestra:<ul><li>El archivo GEDCOM actual</li><li>La fecha y la hora</li><li>Vínculos a:<ul><li>-#pgv_lang[myuserdata]#</li><li>#pgv_lang[my_pedigree]#</li><li>#pgv_lang[my_indi]#</li><li>#pgv_lang[customize_page]#</li></ul></li></ul><br /><b>Nota:</b>Sólo verá los vínculos a <b>Mi ficha</b> y <b>Mi árbol</b> si tiene un registro en el GEDCOM actual.  Podría tener un registro en un archivo GEDCOM y ver por tanto los vínculos <b>Mi ficha</b> y <b>Mi árbol</b> y en otro archivo GEDCOM distinto no tener registro y estos vínculos no aparecerían.<br /><br />";

//-- Pedigree-page
$pgv_lang["help_pedigree.php"]			= "~PÁGINA DE ÁRBOL DE ASCENDIENTES.~<br /><br />Un árbol de ascendientes de una persona, también llamado <b>árbol de costados</b> es una presentación de todos los ascendientes de esa persona. Los usuarios no autenticados ven el árbol de ascendientes de la persona raíz escogida por el administrador del sitio.  Los usuarios autenticados pueden seleccionar su propia persona raíz.<br /><br />En este contexto, \"Todos los ascendientes\" quiere decir los padres, los padres de los padres y así sucesivamente.  El árbol de ascendientes se muestra de forma gráfica; no es necesario vérselas con varias páginas de texto para ver sus ascendientes.<br /><br />Todas las personas se muestran en cajas de nombre en la pantalla.<br /><ul><li><b>Cajas de nombre en el árbol de ascendientes</b><br />Si la página del árbol de ascendientes se ajusta para mostrar detalles, verá el nombre de la persona más sus fechas de nacimiento y defunción.  Puede hacer clic en el nombre de una persona para ir directamente a la página #pgv_lang[indi_info]# de esa persona.<br /><br />Si se activa <b>Mostrar detalles</b> hay dos iconos dentro de la caja de nombre.</li><li><b>Icono de árbol de ascendientes en la caja de nombre</b><br />Si se activa la opción <b>Mostrar detalles</b>, verá un icono de árbol de ascendientes en la caja de nombre. Dependiendo de los ajustes del sitio, tendrá que dejar flotar el puntero sobre el icono o hacer clic en él.  Cuando lo haga, aparecerá un pequeño submenú.<br /><br />Los elementos <b>#pgv_lang[index_header]#</b> y <b>#pgv_lang[descend_chart]#</b> son similares a los del menú principal, pero la diferencia es la persona de comienzo es en este caso la persona mencionada en esta caja de nombre.  También puede ver <b>#pgv_lang[as_spouse]#</b>. Debajo de esto verá el nombre del cónyuge seguido de los nombres de los hijos.  Se puede hacer clic en cualquiera de los nombres.</li><li><b>La lupa en la caja de nombre</b><br />Dependiendo de los ajustes del sitio, tendrá que dejar flotar el puntero sobre el icono o hacer clic en él.  Esto amplía la caja de nombre de modo que se muestren más detalles.  Verá más fechas y eventos. Se puede hacer clic en los nombres.</li><li><b>Flechas</b><br />A la izquierda o derecha de las cajas de nombres que aparecen más a la izquierda o más a la derecha puede ver flechas.  Si hace clic en una de estas flechas, se desplazará la presentación en el sentido de la flecha.</li></ul><br />#pgv_lang[context_help]#<br /><br />";
$pgv_lang["show_full_help"]			= "~OCULTAR O VER DETALLES~<br /><br />Con esta opción puede escoger entre mostrar todos los detalles de la persona en las cajas de Nombre, u ocultarlos.  Con los detalles ocultos puede mostrar más cajas en una pantalla.<br /><br />Si todos los detalles están ocultos, no se muestra el icono de Zoom que se describe luego.  Sin embargo, si el administrador ha activado la función Zoom, toda la caja actúa como un icono de Zoom para mostrar los detalles completos sobre la persona.<br /><br />Si los detalles no están ocultos y el administrador ha activado la función Zoom (representada normalmente por una lupa) puede ver más detalles incluso sobre la persona.  Si normalmente tiene que hacer clic en el icono de Zoom para ampliar, puede ver detalles ocultos adicionales haciendo clic en ese icono aquí.  De manera similar, si puede ampliar dejando flotar el puntero sobre el icono de Zoom, los detalles ocultos se revelarán al hacer lo mismo aquí.<br /><br />Si hizo clic en el icono de Zoom para mostrar más detalles, puede devolver la caja a su nivel normal de detalle haciendo clic en el icono de Zoom otra vez.  Si obtuvo los detalles adicionales moviendo simplemente el puntero al icono de Zoom, la caja volverá a su nivel de detalle normal cuando aleje el puntero del icono de Zoom,<br /><br />";
$pgv_lang["talloffset_help"]			= "~DISTRIBUCIÓN DE LA PÁGINA~<br /><br />Con esta opción determina la orientación de la distribución de la página.<br /><br />Cambiar este ajuste puede ser útil si quiere hacer una impresión de pantalla o si tiene un tipo diferente de pantalla.<ul><li>El modo <b>#pgv_lang[portrait]#</b> hará el árbol más alto, de modo que un diagrama de 4 generaciones debería caber en una página impresa verticalmente.</li><li>El modo <b>#pgv_lang[landscape]#</b> producirá un árbol más ancho que debería caber en una sola página impresa horizontalmente.</li><li>El modo <b>#pgv_lang[landscape_top]#</b> gira el diagrama 90 grados hacia la izquierda sin girar el contenido de las cajas, de modo que la generación más antigua aparecerá en lo alto del diagrama.</li><li>El modo <b>#pgv_lang[landscape_down]#</b> gira el diagrama 90 grados a la derecha, sin girar el contenido de las cajas, de modo que la generación más antigua quedará en la parte inferior del diagrama.</li></ul<br />";
$pgv_lang["rootid_help"]			= "~NUEVA PERSONA RAÍZ~<br /><br />Si quiere ver el diagrama con una nueva persona de comienzo (raíz), escriba su número ID aquí.<br /> <br /> Si desconoce el ID de esa persona, utilice el vínculo <b>Buscar ID<b>.<br /><br /><b>NÚMERO ID</b><br />Los números ID utilizados en PhpGedView <u>no</u> son los números de identificación asignados por algunas administraciones (por ejemplo, DNI, permiso de conducir o número de pasaporte).  El número ID al que se refiere es simplemente un número utilizado dentro de la base de datos para identificar unívocamente cada persona; fue asignado por el programa de genealogía que creó el archivo GEDCOM que se importó a PhpGedView.<br /><br />";
$pgv_lang["PEDIGREE_GENERATIONS_help"]		= "~NÚMERO DE GENERACIONES~<br /><br />Aquí puede elegir el número de generaciones que se mostrarán en esta página.<br /><br />Lo idóneo para usted depende del tamaño de su pantalla y de si elige ver detalles o no.  El tiempo de proceso aumentará según se aumente el número de generaciones.<br /><br />";

//-- LOGIN-page
$pgv_lang["login_page_help"]			= "~LA PÁGINA DE ENTRADA IDENTIFICADA~<br /><br />En esta página puede entrar como usuario identificado, solicitar una nueva contraseña o solicitar una nueva cuenta de usuario.<br />";
$pgv_lang["username_help"]			= "IDENTIFICADOR~<br /><br />En esta caja escriba su identificador de usuario.<br /><br /><b>El identificador de usuario diferencia entre mayúsculas y minúsculas.</b>  Esto quiere decir que <b>MiNombre</b> <u>no</u> es lo mismo que <b>minombre<b> o que <b>MINOMBRE</b>.<br /><br />";
$pgv_lang["password_help"]			= "~CONTRASEÑA~<br /><br />En esta caja escriba su contraseña.<br /><br /><b>La contraseña diferencia entre mayúsculas y minúsculas.</b>  Esto significa que <b>MiContraseña</b> <u>no</u> es lo mismo que <b>micontraseña</b> o que <b>MICONTRASEÑA</b>.<br /><br />";
$pgv_lang["login_buttons_help"]			= "~BOTONES DE ENTRADA IDENTIFICADA~<br /><br />Aquí puede ver dos botones para la entrada identificada al sistema.<br /><br />La página a la que se le lleve o devuelva dependerá de en qué botón haga clic después de teclear su identificador y su contraseña.<br /><ul><li>El botón <b>#pgv_lang[login]#</b><br />Si hace clic en este botón, regresará a la página de la que procedía, pero ya con los derechos de acceso de usuario identificado.<br /><br />Por ejemplo, si hizo clic sobre <b>#pgv_lang[login]#</b> cuando estaba en la página Árbol de Ascendientes, regresará a la misma página.  Si hace clic en este botón cuando estaba en la página principal de Bienvenida, se le llevará a la página #pgv_lang[mygedview]#.</li><li>El botón <b>#pgv_lang[admin]#</b><br />Si tiene derechos de administración, puede hacer clic en este botón para ir directamente a la página principal de Administración.</li></ul><br />";
$pgv_lang["login_buttons_aut_help"]		= "~BOTONES DEL MODO DE ENTRADA IDENTIFICADA~<br /><br />Aquí puede ver dos botones para la entrada identificada al sistema.<br /><br />Dependiendo de cuál escoja entrará en una zona diferente tras teclear su identificador y su contraseña.<br /><ul><li>El botón <b>#pgv_lang[login]#</b><br />Si hace clic sobre este botón, entrará e irá directamente a su página #pgv_lang[mygedview]# en la que puede modificar sus ajustes, agregar o modificar favoritos, enviar y leer mensajes, etc.</li><li>El botón <b>#pgv_lang[admin]#</b><br />Si tiene derechos de administración, puede hacer clic en este botón para ir directamente a la página principal de Administración.</li></ul><br />";
$pgv_lang["new_password_help"]			= "~SOLICITAR NUEVA CONTRASEÑA~<br /><br />Si olvidó su contraseña, puede hace clic en este vínculo para solicitar una nueva contraseña.<br /><br />Irá a la página \"Solicitud de Contraseña Perdida\".<br /><br />";
$pgv_lang["new_user_help"]			= "~SOLICITAR CUENTA DE USUARIO~<br /><br />Si es un visitante de este sitio, y le gustaría solicitar una cuenta de usuario, puede hacer clic en este vínculo.<br /><br />Irá a la página \"Registro\".<br /><br />";
$pgv_lang["mygedview_login_help"]		= "Para acceder a la página #pgv_lang[mygedview]# debe ser un usuario registrado en el sistema.  En la página #pgv_lang[mygedview]# puede marcar sus personas favoritas, mantener un diario, gestionar mensajes, ver otros usuarios identificados y personalizar diversos aspectos de las páginas de PhpGedView.<br /><br />Introduzca su Identificador y su Contraseña en los campos correspondientes para identificarse a #pgv_lang[mgv]#.<br /><br />";
$pgv_lang["new_user_firstname_help"]		= "~#pgv_lang[firstname]#~<br /><br />In este campo debe introducir su nombre de pila.<br /><br />Necesitamos su nombre y apellidos para determinar si cumple las condiciones para obtener una cuenta en este sitio y cuáles deben ser sus derechos de acceso. Estos nombres serán visibles a otros parientes y usuarios identificados del sitio.<br /><br />";
$pgv_lang["new_user_lastname_help"]		= "~#pgv_lang[firstname]#~<br /><br />In este campo debe introducir su(s) apellido(s).<br /><br />Necesitamos su nombre y apellidos para determinar si cumple las condiciones para obtener una cuenta en este sitio y cuáles deben ser sus derechos de acceso. Estos nombres serán visibles a otros parientes y usuarios identificados del sitio.<br /><br />";
$pgv_lang["register_info_01"]		= "~REQUEST NEW USER ACCOUNT~<br /><br />La cantidad de datos que se puede ver públicamente en este sitio puede estar limitada en aplicación de leyes para la protección de la privacidad. Muchas personas no quieren que sus datos personales estén disponibles públicamente en la Internet. Los datos personales podrían utilizarse para <i>spam</i> o suplantación de identidad.<br /><br />Se permite el acceso a este sitio a todo visitante que tenga una cuenta de usuario.  Después de que el administrador haya verificado y aprobado la solicitud de cuenta, podrá identificarse para entrar.<br /><br />Si se ha activado la Privacidad por Parentesco, tras identificarse sólo podrá acceder a la información privada de sus parientes cercanos. El administrador también puede permitir modificar la base de datos a ciertos usuarios, de modo que puedan modificar o agregar información.<br /><br />Si necesita más asistencia, utilice el vínculo que aparece abajo para ponerse en contacto con el administrador.<br /><br />";
$pgv_lang["register_info_02"]		= "~SOLICITAR NUEVA CUENTA DE USUARIO~<br /><br />La cantidad de información que se puede ver públicamente en este sitio puede estar limitada debido a las leyes que sean aplicables para la protección de la intimidad o de datos de carácter personal. Muchas personas no desean que sus datos personales estén públicamente disponibles en la Internet. Se puede abusar de los datos personales para realizar <i>spam</i> o para robo de identidad.<br /><br />El acceso a este sitio está limitado a los usuarios <u>autorizados</u> únicamente. Después de que el administrador haya verificado y aprobado su solicitud de cuenta, podrá entrar y ver los datos privados.<br /><br />Si se ha activado la Privacidad por Parentesco, sólo podrá acceder a sus parientes cercanos tras entrar. El administrador también puede permitir a ciertos usuarios modificar la base de datos de modo que puedan cambiar o agregar información.<br /><br />Si necesita más asistencia, utilice por favor el vínculo inferior para contactar con el administrador.<br /><br />";
$pgv_lang["register_info_03"]		= "~SOLICITAR NUEVA CUENTA DE USUARIO~<br /><br />La cantidad de datos que se pueden ver públicamente en este sitio puede estar limitada debida a las leyes para protección de la intimidad o de los datos de carácter personal. Muchas personas no desean que sus datos personales estén públicamente disponibles en la Internet. Se puede abusar de los datos personales para realizar <i>spam</i> o robo de identidad.<br /><br />El acceso a este sitio está limitado a <u>solamente familiares</u>. Después de que el administrador haya verificado y aprobado su solicitud de cuenta, podrá entrar y ver los datos privados.<br /><br />Si se ha activado la Privacidad por Parentesco, sólo podrá acceder a sus parientes cercanos tras entrar. El administrador también puede permitir a ciertos usuarios modificar la base de datos de modo que puedan cambiar o agregar información.<br /><br />Si necesita más asistencia, utilice por favor el enlace inferior para contactar con el administrador.<br /><br />";


//-- Descendancy-page
$pgv_lang["help_descendancy.php"]		= "~LA PÁGINA DE DESCENDENCIA~<br /><br />Esta página le mostrará los descendientes de una persona.<br /><br />Puede escoger la persona de comienzo (raíz) para este diagrama de descendencia o puede haber llegado a esta página haciendo clic en el enlace <b>#pgv_lang[descend_chart]#</b> de otra página.  Haga clic en los iconos de flecha para navegar este árbol en la dirección de la flecha.  Haga clic en el icono Diagrama en la caja de cualquier persona para cambiar la raíz del árbol a esa persona.<br /><br />";
$pgv_lang["desc_rootid_help"]			= "#pgv_lang[rootid_help]#";
$pgv_lang["desc_generations_help"]		= "#pgv_lang[PEDIGREE_GENERATIONS_help]#";

//-- Time line-page
$pgv_lang["help_lifespan.php"]			= "~DIAGRAMA DE PERÍODO DE VIDA~<br /><br />En este diagrama se muestran una o más personas en un cronograma horizontal.  Este diagrama le permite ver cómo se solaparon las vidas de las diferentes personas.<br /><br />Puede agregar personas al diagrama de una en una o por grupos familiares utilizando sus IDs.  La lista previa de personas no se pierde por agregar más personas al diagrama.  Puede limpiar el diagrama con el botón <b>Limpiar diagrama</b>.<br /><br />También puede agregar personas al diagrama buscándolas por rango de fechas o por localidad.<br /><br />";
$pgv_lang["lifespan_add_person_help"]			= "#pgv_lang[add_person_help]#~Casilla Incluir Familia Inmediata~<br/>Incluir Familia Inmediata está marcada por omisión.  Déjela marcada para ver el padre, la madre, el cónyuge, hermanos e hijos de la persona que se está agregando al cronograma.  Desmárquela si quiere omitir la familia inmediata.<br/><br/>";
$pgv_lang["help_timeline.php"]			= "~CRONOGRAMA~<br /><br />En este diagrama puede ver una o más personas a lo largo del tiempo.<br />De esta forma puede visualizar gráficamente el estado de dos o más personas en un determinado momento.<br /><br />Si hace clic en el vínculo <b>Cronograma</b> desde otra página ya tendrá una persona en el cronograma.  Si hizo clic en el elemento <b>Cronograma</b> del menú del encabezado de página. tendrá que proporcionar el ID de la persona inicial.<br /><br />";
$pgv_lang["add_person_help"]			= "~AGREGAR PERSONA AL DIAGRAMA~<br /><br />Puede tener varias personas en el diagrama de período de vida.<br /><br />Utilice esta caja para introducir el ID de la persona.  Si no conoce el ID de la persona, puede hacer clic en el vínculo <b>Buscar ID</b> junto a la caja.<br /><br />";
$pgv_lang["remove_person_help"]			= "~SUPRIMIR PERSONA EN EL DIAGRAMA~<br /><br />Haga clic en este vínculo para suprimir la persona del cronograma.<br /><br />";
$pgv_lang["show_age_marker_help"]		= "~VER MARCADOR DE EDAD~<br /><br />Si marca esta casilla, verá un marcador de edad, que podrá deslizar a lo largo del cronograma.<br />Este marcador es una sencilla pero efectiva herramienta para determinar la edad de una persona en un determinado evento.<br />Puede activar o desactivar el marcador de edad para cada persona del diagrama.<br /<br />";
$pgv_lang["timeline_control_help"] = "~CONTROLES DE PERÍODO DE VIDA~<br/><br/>~VELOCIDAD~<br/>Haga clic en el menú desplegable para cambiar la velocidad a la que se desplaza el cronograma.<br/><br/>~Año de comienzo~<br/>Introduzca el año de comienzo del rango.<br/><br/>~Año de fin~<br/>Introduzca el año final del rango.<br/><br/>~Buscar~<br/>Haga clic en el botón Buscar para comenzar la búsqueda de eventos que ocurrieran en el rango identificado por los campos Año de comienzo y Año de fin.<br/><br/>";

//-- Relationship-page
$pgv_lang["help_relationship.php"]		= "~PÁGINA PARENTESCO~<br /><br />En esta página puede mostrar el parentesco entre dos personas.  No hace falta que estas personas sean consanguíneas;  se encontrará cualquier parentesco.<br /><br />";
$pgv_lang["relationship_id_help"]		= "~ID de la PERSONA 1 e ID de la PERSONA 2~<br /><br />Si ha accedido desde otra página haciendo clic en un vínculo como <b>Parentesco conmigo</b>, verá aquí el parentesco entre Vd. y esa otra persona.<br /><br />Si llegó a esta página a través de la entrada en el menú <b>Diagrama de Parentesco</b> en el encabezamiento de cualquier página, tiene que teclear los números identificadores de las dos personas cuyo parentesco desee ver.  Si desconoce el ID de la persona deseada, puede hacer clic en el vínculo <b>Buscar ID</b>.<br /><br />";
$pgv_lang["next_path_help"]			= "~BUSCAR OTRO CAMINO~<br /><br />Haciendo clic sobre este botón se mostrará otra ruta que relaciona igualmente a estas dos personas.  Los caminos encontrados anteriormente pueden mostrarse de nuevo haciendo clic en el vínculo con su número de camino.<br /><br />";
$pgv_lang["follow_spouse_help"]			= "~CASILLA DE BUSCAR PARENTESCO POR MATRIMONIO~<br /><br />Si esta casilla se deja <b>sin</b> marcar, sólo se considerará el parentesco consanguíneo.<br />Si se marca esta casilla, también se miran los parentescos por matrimonio.  Probablemente encontrará más parentescos si deja esta casilla marcada.<br /><br />";
$pgv_lang["line_up_generations_help"]	= "~CASILLA DE ALINEAR GENERACIONES~<br /><br />Si se marca esta casilla, el diagrama contendrá las generaciones del mismo nivel alineadas horizontalmente en la página. Si se deja sin marcar, cada generación aparecerá se dispondrá en un nuevo novel independientemente del tipo de relación.<br /><br />";
$pgv_lang["oldest_top_help"]          = "~CASILLA DE MOSTRAR LO MÁS ANTIGUO ANTES~<br /><br />Cuando se marca esta casilla, el diagrama se presentará de manera que las personas mayores aparezcan al principio.  Cuando no está marcada, las personas más jóvenes aparecen al principio.<br /><br />Nota: Esta opción sólo funciona si se marca también la opción <b>#pgv_lang[line_up_generations]#</b>.<br /><br />";

//-- Ancestry-page
$pgv_lang["help_ancestry.php"]		= "~#pgv_lang[ancestry_chart]# page~<br /><br />La página de Ascendientes es muy similar a la de <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, pero con más detalles y distintas presentaciones de <a href=\"?help=chart_style_help\">#pgv_lang[chart_style]#</a>.<br /><br />Cada ascendiente se muestras con un número distintivo, calculado según el sistema <i>Sosa-Stradonitz</i>:<div style=\"padding-left:30px;\">Números <b>pares</b> para los hombres (hijo*2)<br />Números <b>impares</b> para las mujeres (esposo+1) excepto el caso de <b>1</b></div><br />Ejemplo:<br /><div style=\"padding-left:30px;\">La persona raíz es <b>1</b>, cualquiera que sea su sexo.<br />El padre de <b>1</b> es <b>2</b> (<b>1</b> * 2), la madre es <b>3</b> (<b>2</b> + 1).<br />El padre de <b>2</b> es <b>4</b> (<b>2</b> * 2), la madre es <b>5</b> (<b>4</b> + 1).<br />El padre de <b>3</b> es <b>6</b> (<b>3</b> * 2), la madre es <b>7</b> (<b>6</b> + 1).<br />El padre de <b>7</b> es <b>14</b> (<b>7</b> * 2), la madre es <b>15</b> (<b>14</b> +1).<br />etc.</div><br />";
$pgv_lang["box_width_help"]		= "~ancho de la caja para el #pgv_lang[ancestry_chart]#~</b><br /><br />Aquí puede cambiar el ancho de la caja desde el 50% hasta el 300%.  Al 100% cada caja tiene unos 270 píxeles de ancho.<br /><br />";
$pgv_lang["chart_style_help"]			= "~#pgv_lang[chart_style]#~<br />Hay dos estilos de diagrama disponibles:<ul><li><b>#pgv_lang[chart_list]#</b><br />Árbol vertical, con familias colapsables/expandibles.</li><br /><li><b>#pgv_lang[chart_booklet]#</b><br />Una familia por página, con padres, abuelos y todos los hijos registrados.<br /><br />Este formato es fácil de imprimir para entregar a sus parientes.</li></ul><br />";

//-- Fan chart-page
$pgv_lang["help_fanchart.php"]		= "~#pgv_lang[fan_chart]# page~<br /><br />El diagrama circular o en abanico es muy similar al <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, pero de una forma más gráfica.<br /><br />La persona Raíz se muestra en el centro, sus padres en el primer círculo, sus abuelos en el segundo círculo, y así sucesivamente.<br /><br />Se muestran bajo el nombre los años de nacimiento y defunción si se conocen.<br /><br />Hacer clic en un nombre del diagrama abre un menú de vínculos específico para esa persona.  Desde este menú puede escoger centrar el diagrama en esa persona o en uno de sus parientes cercanos o saltar a la página #pgv_lang[indi_info]# o un diagrama diferente para esa persona.<br /><br />";
$pgv_lang["fan_width_help"]		= "~ancho para #pgv_lang[fan_chart]#~</b><br /><br />Aquí puede cambiar el ancho del diagrama en abanico desde el 50% hasta el 300%.  Al 100% la imagen de salida tiene unos 640 píxeles de ancho.<br /><br />";
$pgv_lang["fan_style_help"]			= "~#pgv_lang[fan_chart]# style~<br /><br />Esta opción controla la apariencia del diagrama en Abanico.<ul><li><b>1/2</b><br />Diagrama en semicírculo 180&deg;</li><br /><li><b>3/4</b><br />Diagrama a tres cuartos 270&deg; llamado en ocasiones <i>Ala de ángel</i></li><br /><li><b>4/4</b><br />Diagrama de círculo completo 360&deg;</li></ul><br />";

//-- Hourglass chart-page
$pgv_lang["help_hourglass.php"]			= "~#pgv_lang[hourglass_chart]#~<br /><br />El diagrama Reloj de Arena muestra los ascendientes y descendientes de la persona raíz escogida en el mismo diagrama.  Este diagrama es una mezcla entre el diagrama de Descendientes y el diagrama de Ascendientes.<br /><br />La persona raíz aparece en el centro de la página con sus descendientes desplegados a su izquierda y sus ascendientes desplegados a su derecha.  En esta vista, cada generación aparece alineada verticalmente a lo largo de la página comenzando con la generación más reciente y terminando con la más antigua.<br /><br />Si aparece una flecha apuntando hacia abajo en la pantalla bajo la persona raíz, se obtendrá al hacer clic en ella una lista de los parientes cercanos de la persona raíz que se puede utilizar para navegar por el diagrama.  Si se selecciona un nombre de esta lista, se actualizará el diagrama tomando como raíz la persona seleccionada.";

//-- Family Book chart-page
$pgv_lang["help_familybook.php"]	= "~#pgv_lang[familybook_chart]#~<br /><br />Este diagrama es muy similar al diagrama Reloj de Arena.  Muestra los ascendientes y descendientes de la persona raíz seleccionada en el mismo diagrama.  También muestra los descendientes de la persona raíz en el mismo formato de Reloj de Arena.<br /><br />La persona raíz queda centrada en el medio de la página con sus descendientes desplegados a su izquierda y sus ascendientes desplegados a su derecha.  En esta vista, cada generación aparece alineada verticalmente a lo largo de la página comenzando con la generación más reciente y terminando con la más antigua.<br /><br />Cada descendiente de la persona raíz se convierte en la persona raíz de un diagrama Reloj de Arena adicional que se muestra en la misma página.  Este proceso se repite hasta que se ha mostrado el número especificado de generaciones de descendientes.";
$pgv_lang["fambook_descent_help"]	= "~#pgv_lang[descent_steps]#~<br /><br />Este valor determina el número de generaciones de descendientes que se muestran en el formato de Reloj de Arena.<br /><br />";

//-- Indilist-page
$pgv_lang["help_indilist.php"]			= "~PÁGINA LISTA de PERSONAS~<br /><br />En esta página puede ver una lista de personas.  Los nombres se muestran con los apellidos primero y clasificados por orden alfabético.<br /><br />El contenido de la lista de nombres depende de:<ol><li>La letra en la que hizo clic en el índice alfabético.</li><li>Si hizo clic en \"Ocultar\" o en \"Mostrar\" Lista de Apellidos.</li></ol>#pgv_lang[context_help]#<br /><br />";
$pgv_lang["alpha_help"]				= "~ÍNDICE ALFABÉTICO~<br /><br />Si hace clic sobre una letra del índice alfabético se mostrará una lista de los nombres que comienzan con la letra que eligió.<br /><br />El penúltimo elemento en el índice alfabético puede ser <b>#pgv_lang[NN]#</b>.  Esta entrada estará presente si hay personas en la base de datos cuyos apellidos no constan o no contienen letras reconocibles.  Los apellidos desconocidos a menudo se graban como <b>?</b> y estos se reconocerán como <b>#pgv_lang[NN]#</b>.  También ocurrirá esto si la persona es desconocida.<br /><br /><b>Nota:</b><br />Los apellidos introducidos como, por ejemplo, <b>Nn</b>, <b>NN</b>, <b>Desconocido</b> o incluso <b>N.N.</b> <u>no</u> se mostrarán en la lista <b>#pgv_lang[NN]#</b>. Los encontrará haciendo clic en <b>N</b> o <b>D</b> porque son las iniciales de esos nombres.  PhpGedView no puede llevar cuenta de todas las posibles formas de introducir nombres desconocidos; no hay convenio reconocido para ello.<br /><br />Al final del índice alfabético verá <b>TODOS</b>. Si hace clic en este vínculo verá una lista de todos los apellidos de la base de datos.<br /><br /><b>¿Faltan letras?</b>Si su índice alfabético parece incompleto porque faltan letras, su base de datos no contiene ningún apellido que comienzo con la letra omitida.<br /><br />";
$pgv_lang["name_list_help"]			= "~LISTA DE NOMBRES~<br /><br />Esta caja mostrará o una lista de apellidos o una lista completa de nombres.  En ambos casos todos los apellidos comenzarán con la inicial sobre la que hizo clic en el índice alfabético, a menos que lo hiciera sobe <b>TODOS</b>.<br /><br />Si se muestra una lista de apellidos o una lista completa de nombres depende del estado del vínculo <b>Ocultar/Mostrar listas de apellidos</b><br /><br />";
$pgv_lang["skip_sublist_help"]			= "~OCULTAR LISTAS DE APELLIDOS~<br /><br />Por omisión en la configuración del sitio al seleccionar un letra del alfabeto se listarán todas las personas agrupadas por apellidos. Si hace clic en este vínculo, se mostrará una lista de todas las personas cuyo apellido comience por la letra del alfabeto seleccionada. Desde ese momento, la lista de personas se mostrará directamente cada vez que haga clic en una nueve inicial de la lista alfabética.<br /><br />Para deshacer esta acción, haga clic en el vínculo.<br /><br />";
$pgv_lang["show_marnms_help"]			= "~INCLUIR/EXCLUIR NOMBRES DE CASADA~<br /><br />Las páginas de personas y familias pueden incluir o excluir los nombres de casada.  Esta opción es útil al buscar personas o familias cuando sólo se conoce el nombre de casada.  Sólo se incluyen los nombres de casada si constan en la base de datos.<br /><br />En la lista de familias, el valor por omisión es excluir.  En la lista de personas, el valor por omisión se ajusta en la página de configuración del GEDCOM.<br /><br />Si cambia esta opción, su selección se memoriza durante su sesión.<br /><br />";

//-- Families-page
$pgv_lang["help_famlist.php"]		= "~PÁGINA LISTA de FAMILIAS~<br /><br />En esta página se muestra una lista de familias.  Los nombre se muestran con los apellidos primero y clasificados en orden alfabético.<br /><br />El contenido de de la lista de nombres depende de:<ol><li>La letra en la que hizo clic en el índice alfabético.</li><li>Si hizo clic en \"Ocultar\" o en \"Mostrar\" Lista de Apellidos.</li></ol>Puede buscar por el apellido del esposo o de la esposa; ambos se incluyen en la lista.<br /><br />#pgv_lang[context_help]#<br /><br />";
$pgv_lang["help_family.php"]			= "~PÁGINA DE DETALLES FAMILIARES~<br /><br />Esta página le mostrará un resumen de la familia elegida en la página previa.<br />Desde arriba hacia abajo, verá las cajas de Detalles Personales del esposo y sus padres, la esposa y sus padres y los hijos.<br /><br />La distribución y contenido de las Cajas Personales es la misma que la que ya conoce de las páginas de Árbol de Ascendientes y de Descendencia.<br /><br />A la derecha de las cajas de los padres, verá una flecha si existen más ascendientes en el archivo. Si hace clic en la flecha, ascenderá una generación para mostrarle una nueva página de familia en los que los que eran padres se muestran ahora como esposos.<br /><br />En el lado derecho de la caja de nombre puede ver un icono de lupa que revelará más detalles de la persona al hacer clic en él. Si hace clic en le nombre se le llevará a la página #pgv_lang[indi_info]# de esa persona.<br /><br />También en el lado derecho encontrará un pequeño menú que le llevará a páginas con diagramas o más información.  Algunas de estas entradas del menú tendrán submenús que aparecerán cuando su puntero se aproxime a la entrada del menú superior.<br /><br />La caja Información del Grupo Familiar muestra todos los hechos conocidos y la información acerca de esta familia, como matrimonio, objetos audiovisuales y notas. En la caja de Información del Hecho, si hace clic en el nombre de un lugar se le llevará a la lista de Lugares, donde se muestran todas las familias y personas conectadas con ese lugar.  Si hace clic en una fecha, saltará al calendario del Día, que mostrará todos los eventos que sucedieron en ese día y mes en la historia. Se puede hacer clic en los objetos audiovisuales, en ese caso se abrirá una nueva ventana en la que se visualizará el objeto. Si hace clic en el rótulo de la foto, la verá en la página #pgv_lang[media_list]#. Si hace clic en un vínculo de Fuente, se mostrarán los detalles correspondientes se mostrarán en la página de Fuente.<br /><br />Bajo las cajas de nombres de los hijos o hijas encontrará el vínculo <b>Agregar un hijo(a) a esta familia</b>.  Junto a las cajas de nombres de los hijos, verá la <b>Información del Grupo Familiar</b>.  Si posee suficientes atribuciones, podrá modificar, borrar y agregar aquí datos y hechos.<br /><br />Como ocurre en la página #pgv_lang[indi_info]#, verá un menú en la esquina superior derecha de la página.  Las entradas de este menú le llevarán a otras páginas en las que puede obtener información acera de esta familia o realizar otras tareas relacionadas con esta familia.#pgv_lang[more_help]#";
$pgv_lang["add_child_help"]			= "~AGREGAR HIJO/A A ESTA FAMILIA~<br /><br />Puede agregar un hijo/a a esta familia haciendo clic en este vínculo.<br /><br />Agregar hijos es fácil: haga clic en el vínculo, rellene las casillas de la ventana emergente y ya está.<br /><br />";
$pgv_lang["show_fam_gedcom_help"]	= "~MOSTRAR REGISTRO GEDCOM~<br /><br />Si hace clic en este vínculo, se mostrará la información de la familia tal como está almacenada en la base de datos.  Se mostrarán datos GEDCOM en bruto.<br /><br />";
$pgv_lang["add_fam_clip_help"]		= "~AGREGAR FAMILIA AL CARRITO GENEALÓGICO~<br /><br />Puede agregar toda o parte de la información de esta familia a su #pgv_lang[clip_cart]#. En la página siguiente puede elegir exactamente cuánta información desea agregar:<ol><li>#pgv_lang[just_family]#</li><li>#pgv_lang[parents_and_family]#</li><li>#pgv_lang[parents_and_child]#</li><li>#pgv_lang[parents_desc]#</li></ol><br />";
$pgv_lang["show_fam_timeline_help"]	= "~MOSTRAR LA PAREJA EN UN CRONOGRAMA~<br /><br />Cuando haga clic en este vínculo será conducido a la página de Cronograma, donde todos los hechos de la pareja se mostrarán en una escala cronológica.<br /><br />";

//-- Source list-page
$pgv_lang["help_sourcelist.php"]		= "~PÁGINA LISTA DE FUENTES~<br /><br />En esta página se muestra un listado las fuentes.<br /><br />A diferencia de las páginas de #pgv_lang[indi_info]# y de Familia, no dispone de un índice alfabético.<br /><br />Una fuente puede ser una persona, una base de datos pública, una institución, un recurso de Internet, etc.  Por la naturaleza completamente aleatoria de las fuentes, es imposible encontrar un criterio de ordenación que tenga sentido en todos los casos. No obstante, PhpGedView <u>sí</u> ordena los nombres de fuentes alfabéticamente.<br /><br /><b>FUENTES</b><br />Sin fuentes no es posible construir nuestra base de datos. Para toda información almacenada en nuestra base de datos existe una fuente. Y ésta puede ser un pariente, una institución, una base de datos pública, registros oficiales o privados, un recurso de Internet, etc.<br /><br />Una fuente puede estar vinculada a muchas personas. Una persona también puede estar vinculada con muchas fuentes. Puede tener diferentes fuentes para cada evento: nacimiento, bautismo, profesión, matrimonio, hijos, etc.<br /><br />";
$pgv_lang["sourcelist_listbox_help"]		= "~CAJA de LISTA de FUENTES~<br /><br />En esta caja puede ver los nombres de las fuentes tal y como se guardan en el archivo Gedcom.<br />Los nombres se muestran en orden alfabético.<br /><br />Cuando seleccione un nombre de la lista, irá a la página de la fuente, donde se muestra una lista de personas y familias vinculadas con esa fuente.";

//-- Sources-page
$pgv_lang["help_source.php"]			= "~PÁGINA de DETALLES de la FUENTE~<br /><br />En esta página se muestran los detalles de la fuente.  Las fuentes son muy importantes para los investigadores genealógicos y le permitirán seguir la pista que utilizó otro investigador para encontrar la información.<br /><br />Puede ver la información sobre el título de la fuentes, su autor, su publicación y el repositorio donde se consultó. Debido a los muchos tipos de fuentes, algunas tienen más información que otras.<br /><br />Si hay un objeto audiovisual como una imagen de un documento conectada a la fuente, puede ver el objeto haciendo clic en él.  Si hace clic en el nombre del objeto, lo verá en la página #pgv_lang[media_list]# page.<br /><br />Tras los detalles de la fuente se muestra una lista de todas las personas y familias conectadas a esta fuente. Esto le permite identificar todos los datos que se obtuvieron de esta fuente.<br /><br />Si el administrador ha activado estas funciones, encontrará uno o dos iconos de menú adicionales en esta página:<ol><li><b>#pgv_lang[view_gedcom]#</b><br />que muestra la información en formato GEDCOM.</li><li><b>#pgv_lang[add_to_cart]#</b><br />que le permite almacenar esta información en su #pgv_lang[clip_cart]# para descargarla posteriormente e importarla a su propio programa de genealogía.</li></ol><br />#pgv_lang[context_help]#<br /><br />";
$pgv_lang["sources_listbox_help"]		= "~REGISTROS que VINCULAN a esta FUENTE~<br /><br />En esta caja puede ver los nombres de las personas y las familias que vinculan con esta fuente.<br />Los nombres se muestran por orden alfabético.<br /><br />Cuando seleccione un nombre de la lista, le llevará a la página de la persona o de la familia.";
$pgv_lang["show_source_gedcom_help"]	= "~MOSTRAR REGISTRO GEDCOM~<br /><br />Si hace clic en este vínculo, se mostrarán los registros de esta fuente en el formato en bruto de la base de datos.<br /><br />";
$pgv_lang["add_source_clip_help"]		= "~AÑADIR FUENTE AL CARRITO~<br /><br />Haciendo clic en este vínculo puede añadir la información de una fuente a su #pgv_lang[clip_cart]# para su posterior descarga e importación a su propio programa de genealogía.<br /><br />";
$pgv_lang["delete_source_help"]			= "~BORRAR FUENTE DEL GEDCOM~<br /><br />Haciendo clic en este vínculo marcará esta fuente para su eliminación de la base de datos.<br /><br />¿Qué significa?<br />Supongamos que tiene una buena razón para eliminar esta fuente de la base de datos. Haga clic en el vínculo.  Se le pedirá que confirme la solicitud de eliminación.  Si decide continuar, puede pasar un poco de tiempo hasta que una nueva ventana aparece diciéndole que la fuente se ha borrado.<br /><br />Cuando continúe con su visita, observará que la fuente todavía es visible y puede utilizarse como si el borrado no hubiera ocurrido.<br /><br /><b>Esto <u>no</u> es un error.</b>  El administrador del sitio recibirá un mensaje advirtiéndole del cambio en la base de datos y de que eliminó la fuente.<br />El administrador puede aceptar o rechazar su cambio.  Sólo después de que el administrador haya aceptado su cambio ocurrirá de verdad el borrado <u>irreversiblemente</u>.  Si hay alguna duda sobre su cambio, el administrador se pondrá en contacto con Vd.<br /><br />";

//-- Persons per Place-page
$pgv_lang["help_placelist.php"]			= "~JERARQUÍA DE LUGARES~<br />(o Personas por Lugar)<br /><br />Esta página le mostrará una jerarquía de ligares del GEDCOM y qué personas o familias están conectadas con un lugar.<br /><br />Si hay cualquier conexión entre una persona o familia y un evento en determinado lugar, PhpGedView la encontrará.<br /><br />Los resultados se muestran en un lista a doble columna, una columna para las personas y una para las familias.<br /><br />#pgv_lang[more_help]#";
$pgv_lang["ppp_default_form_help"]		= "~FORMATO DE ORDEN DE LOS LUGARES~<br /><br /><b>ORDEN POR OMISIÓN</b><br />Esto significa que no constaba un formato de codificación de lugares en este archivo GEDCOM y que se supone el formato por omisión.<br /><br />Si se hubiera encontrado otro formato, se habría mostrado entre los <b>(</b> y <b>)</b> al final de la línea.<br /><br />";
$pgv_lang["ppp_match_one_help"]			= "~FORMATO DE ORDEN DE LOS LUGARES~<br /><br />ORDEN EN EL GEDCOM<br />Los lugares se supone que han sido codificados en el formato de lugar declarado explícitamente en el archivo GEDCOM.  Este valor tiene prioridad sobre el orden por omisión.";
$pgv_lang["ppp_numfound_help"]			= "~CONEXIONES ENCONTRADAS CON EL LUGAR~<br /><br />Aquí se muestra el número de conicidencias encontradas.  Si se muestra una lista con lugares significa que no se ha llegado aún al nivel más bajo.<br /><br />Puede ver todos los registros conectados con este lugar o refinar la búsqueda haciendo clic en otro lugar.<br /><br />";
$pgv_lang["ppp_levels_help"]			= "~NIVELES DE LUGARES~<br /><br />Muestra los niveles que se están mostrando ahora.  La lista que muestra los lugares es en realidad una sublista del nivel que aparece más a la izquierda.<br /><br />EJEMPLO:<br />El orden por omisión es: #pgv_lang[default_form]#<br />Si el nivel actual es \"#pgv_lang[top_level]#\", se listarán todos los países que existen en el Gedcom.<br />Si el nivel actual muestra: \"Estados Unidos, #pgv_lang[top_level]#\", se listarán todos los estados de Estados Unidos.<br />etc.<br /><br />Puede hacer clic en un nivel para volver atrás uno o más pasos.<br /><br />";
$pgv_lang["ppp_placelist_help"]			= "~JERARQUÍA DE LUGARES~<br /><br />En esta lista puede ver los lugares que se han encontrado subordinados al lugar actual que ha escogido.  Si aún no ha seleccionado un lugar, verá una lista de todos los lugares del nivel superior (por ejemplo, países o estados).<br /><br />Se puede hacer clic en los nombres de esta lista; hacer clic en un lugar funciona como un filtro y le mostrará el nivel siguiente inferior al lugar seleccionado.<br /><br />";
$pgv_lang["ppp_placelist_help2"]		= "~LISTA DE LUGARES~<br /><br />En esta lista puede ver los lugares encontrados a este nivel.<br /><br />Los nombres de los lugares de la lista son vínculos y se puede hacer clic en ellos; hacer clic en un lugar funciona como un filtro, le llevará al nivel inmediato inferior.<br /><br />Solamente si se encuentra en el nivel más alto se omite la lista de nombres. En los niveles subordinados se muestra una lista de familias y personas conectadas a ese lugar.<br /><br />";
$pgv_lang["ppp_view_records_help"]		= "~VER TODOS LOS REGISTROS~<br /><br />Hacer clic en este vínculo le mostrará una lista de todas las personas y familias que tienen eventos ocurridos en este lugar. Cuando llegue al final de una jerarquía de lugares, que suele ser una población, se mostrará automáticamente la lista de nombres.<br /><br />";
$pgv_lang["ppp_name_list_help"]			= "~LISTA DE NOMBRES~<br /><br />Muestra una lista completa de personas y familias que están conectadas con ese lugar.<br /><br />Se puede hacer clic en los nombres de la lista.  Si hace clic en un nombre, accederá a la página de Detalles correspondiente.  Si hace clic en un lugar en la parte superior, cambiará el lugar seleccionado.<br /><br />";

//-- Multimedia-page
$pgv_lang["help_medialist.php"]			= "~LISTA DE OBJETOS AUDIOVISUALES~<br /><br />Esta página lista todos los objetos audiovisuales presentes en esta base de datos.<br /><br />Para cada uno de estos objetos puede ver el título o nombre de archivo del objeto, los nombres de las personas o familias conectadas al objetos y las notas acerca del objeto.<br /><br />Hacer clic en el título o nombre del archivo del objeto tiene el mismo efecto que hacer clic en la miniatura.  El objeto se abrirá en el visor de imágenes incorporado a PhpGedView o en el visor especificado en la configuración de su navegador.<br /><br />Si hace clic en el vínculo \"Ver\" próximo a la persona o familia, se le llevará a la página de Detalles correspondiente.<br /><br />";

//-- Upload Media-page
$pgv_lang["help_uploadmedia.php"]		= "~SUBIR ARCHIVOS AUDIOVISUALES~<br /><br />La carga de archivos audiovisuales es simple; aquí encontrará información adicional.<br /><br /><b>Miniaturas</b><br />Las miniaturas deberán tener un tamaño de alrededor de 100 píxeles de ancho.  El nombre del archivo <u>debe</u> ser el mismo que el del original.  Si su sistema puede generar las miniaturas automáticamente, verá un aviso al respecto en la página Subir Archivos Audiovisuales.<br /><br /><b>Subir</b><br />Los archivos se subirán automáticamente al directorio <b>#GLOBALS[MEDIA_DIRECTORY]#</b> para las copias de tamaño normal y a <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b> para las miniaturas.<br /><br />#pgv_lang[readme_help]#";

//-- Anniversaries-page
$pgv_lang["help_calendar.php"]			= "~#pgv_lang[anniversary_calendar]#~<br /><br /><ul><li><a href=\"#calendar_general\"><b>Información general</b></a></li><li><a href=\"#calendar_day\"><b>#pgv_lang[day]#</b></a></li><li><a href=\"#calendar_month\"><b>#pgv_lang[month]#</b></a></li><li><a href=\"#calendar_year\"><b>#pgv_lang[year]#</b></a></li><li><a href=\"#calendar_show\"><b>#pgv_lang[show]# / #pgv_lang[showcal]#</b></a></li><li><a href=\"#calendar_sex\"><b>#pgv_lang[sex]#</b></a></li><li><a href=\"#calendar_event\"><b>Evento</b></a></li><li><a href=\"#calendar_button\"><b>Botones Ver día / Ver mes / Ver años</b></a></li><li><a href=\"#calendar_tip\"><b>Tip</b></a></li></ul><br /><a name=\"calendar_general\"></a>El #pgv_lang[anniversary_calendar]# muestra las personas y familias que están vinculadas a un evento en un cierto día o mes o durante cierto periodo de tiempo. Tiene un sistema de filtrado avanzado para seleccionar la fecha correcta, el periodo y los eventos para Vd.<dl><dt><b>Ver <a href=\"#calendar_day\">día</a></b></dt><dd>Esto muestra los eventos de un cierto día, sin considerar el año. La salida será bien una sola lista con los nombres de personas o familias o una lista a dos columnas con las personas a un lado y las familias al otro.</dd><dt><b>Ver <a href=\"#calendar_month\">mes</a></b></dt><dd>En este calendario se muestran los nombres de personas en familias en cajas para cada día  El calendario se muestra como era en el año tecleado en el campo Año. Se muestran todos los eventos que ocurrieron en el pasado hasta ese año.<br /><br />En combinación con la opción <a href=\"#calendar_show\"><b>#pgv_lang[recent_events]#</b></a>, dará una visión realista del aspecto que tenía un calendario de sus ascendientes.</dd><dt><b>Ver <a href=\"#calendar_year\">año</a></b></dt><dd>Esto muestra los eventos en un cierto año o en un intervalo de años. La salida será una lista con los nombres de personas o familias o una lista a dos columnas con las personas a un lado y las familias al otro.</dd></dl>El día y mes mostrados actualmente se resaltan en el menú del calendario.<br /><br />Se puede hacer clic en todos los nombres y fechas.   Si hace clic en un nombre, se le llevará a la página de Detalles correspondiente. Si hace clic en una fecha saltará al modo \"Hoy\" o \"Año\" que mostrará todos los eventos para el día y mes de la fecha seleccionada.<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_day\"> </a>#pgv_lang[annivers_date_select_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_month\"> </a>#pgv_lang[annivers_month_select_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_year\"> </a>#pgv_lang[annivers_year_select_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_show\"> </a>#pgv_lang[annivers_show_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_sex\"> </a>#pgv_lang[annivers_sex_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_event\"> </a>#pgv_lang[annivers_event_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_button\"> </a>#pgv_lang[day_month_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_tip\"> </a>#pgv_lang[annivers_tip_help]#";
$pgv_lang["annivers_date_select_help"]	= "~SELECTOR DE DÍA~<br /><br />La fila superior del Selector de Fecha es el selector de <b>Día</b>.  Su significado es obvio: Sirve para seleccionar un <u>día</u>.<br /><br />El resultado de hacer clic en un día depende de si está en modo <b>Día</b> o en modo <b>Mes</b>.<br /><dl><dt><b>Modo día</b></dt><dd>En este modo, si hace clic en un día, se refrescará la pantalla y se mostrará la lista para ese día.</dd><dt><b>Modo mes</b></dt><dd>Se presenta el calendario de un cierto mes en la pantalla.  Si hace clic en un día, la pantalla se refrescará, pero seguirá viendo el mismo mes.  La razón de esto es que aún pueda decidir seleccionar otros mes, año o evento antes de hacer clic en los botones <b>#pgv_lang[viewday]#</b> o <b>#pgv_lang[viewmonth]#</b>.<br /><br />Al final de la fila de Día verá un <b>Vínculo Rápido</b> con la fecha de hoy.  Si hace clic en ese <b>Vínculo Rápido</b> se mostrará la lista para hoy en el modo <b>Día</b>, tanto si está en modo <b>Mes</b> como en modo <b>Día</b>.</dd></dl>";
$pgv_lang["annivers_month_select_help"]	= "~SELECTOR DE MES~<br /><br />La fila central de la tabla de Selección es el selector de <b>Mes</b>.  Su significado es obvio: Selecciona un <u>mes</u>.<br /><br />El resultado de hacer clic en un cierto mes depende de si está en modo <b>Día</b> o en modo <b>Mes</b>.<br /><dl><dt><b>Modo día</b></dt><dd>En este modo, si hace clic en un mes, la pantalla se refrescará y se mostrará la lista para ese mes.  Todas las demás selecciones para día, año y eventos permanecerán sin cambios.</dd><dt><b>Modo mes</b></dt><dd>Si tiene un calendario en pantalla y hace clic en un mes de la fila <b>Mes</b>, se mostrará el calendario para ese nuevo mes.<br /><br />Al final de la fila Mes verá un <b>Vínculo rápido</b> con el mes y año actuales.  Hacer clic en ese <b>Vínculo rápido</b> mostrará la lista para ese mes en modo <b>Mes</b>, tanto si está en modo <b>Mes<b> como en modo <b>Día</b>.</dd></dl>";
$pgv_lang["annivers_year_select_help"]	= "~CASILLA DE INTRODUCCIÓN DE AÑO~<br /><br />Esta casilla le permite cambiar el año del calendario.  Teclee un año en la casilla y presione la tecla <b>Intro</b> para cambiar el calendario al de ese año.<br /><br /><b>Funciones avanzadas</b> para <b>#pgv_lang[viewyear]#</b><dl><dt><b>Más de un año</b></dt><dd>Puede buscar fechas en un intervalo de años.<br /><br />Los intervalos de años son <u>inclusivos</u>.  Esto quiere decir que el intervalo de fechas va desde el 1 de enero del primer año hasta el 31 de diciembre del último año mencionado.  Unos cuantos ejemplos de intervalos de años:<br /><br /><b>1992-5</b> para todos los eventos desde 1992 hasta 1995.<br /><b>1972-89</b> para todos los eventos desde 1972 hasta 1989.<br /><b>1610-759</b> para todos los eventos desde 1610 hasta 1759.<br /><b>1880-1905</b> para todos los eventos desde 1880 hasta 1905.<br /><br /><b>880-1105</b> para todos los eventos desde 880 hasta 1105.<br /><br />Para ver todos los eventos de una década o un siglo dados, puede utilizar <b>?</b> en lugar de los dígitos finales. Por ejemplo, <b>197?</b> para todos los eventos desde 1970 hasta 1979 o <b>16??</b> para todos los eventos desde 1600 a 1699.<br /><br />Seleccionar un intervalo de años cambiará el calendario a la vista Año.</dd></dl>";
$pgv_lang["annivers_show_help"]			= "~MOSTRAR EVENTOS DE...~<br />Están disponibles las siguientes opciones:<br /><ol><li><b>Todas las personas</b><br />Con esta opción se muestran todas las personas y familias.</li><li><b>Años recientes (&lt;100 años)</b><br />Con esta opción verá todos los eventos del día o mes elegidos, excepto si han ocurrido hace más de 100 años.</li><li><b>Personas vivas</b><br />Amenos que el administrador haya configurado PhpGedView para que las personas vivas sean visibles para todo le mundo, esta opción solamente estará disponible después de que se haya identificado.<br /><br />Con esta opción, sólo se mostrarán los eventos de personas vivas.</li></ol>Si hace clic en una opción, se mostrarán los eventos que haya elegido.<br /><br />Los ajustes de día, mes y año, así como el modo <b>Día</b> o <b>Mes</b>, permanecen como estaban.<br /><br />";
$pgv_lang["annivers_sex_help"]			= "~SELECTOR DE SEXO~<br />Si se ha identificado o si el administrador no ha activado la opción de privacidad, puede seleccionar una de estas opciones:<ol><li>Icono <b>Todos</b><br />Es la opción por omisión. Se muestran los eventos de todas las personas y familias.</li><li>Icono <b>Hombres</b><br />Sólo se muestran los eventos de las personas de sexo masculino. Sólo se mostrarán las personas de sexo masculino en los eventos familiares.</li><li>Icono <b>Mujeres</b><br />Sólo se muestran los eventos de las personas de sexo femenino. Sólo se mostrarán las personas de sexo femenino en los eventos familiares.</li></ol>Si hace clic en una opción se mostraron los eventos correspondientes a su elección.<br /><br />Los ajustes de día, mes y año, así como el modo de <b>Día</b> o <b>Mes</b>, quedan como estaban.<br /><br />";
$pgv_lang["annivers_event_help"]		= "~SELECTOR DE EVENTOS~<br />Aquí elija si desea mostrar todos los eventos para las personas y familias o sólo una categoría de evento.  No puede seleccionar más de una categoría de evento.<br /><br />Si hace clic en una opción, se mostrarán los eventos seleccionados.<br /><br />Los ajustes de día, mes y año, así como el modo de <b>Día</b> o <b>Mes</b>, permanecen como estaban.<br /><br />";
$pgv_lang["annivers_tip_help"]			= "~CONSEJO~<br />Ajuste el selector de fecha a cualquier fecha en el pasado.<br /><br />Si hace clic en uno de los botones Ver se mostrará una lista o calendario para esa fecha. Todas las edades, aniversarios, etc. se habrán recalculado con respecto a la fecha que fije en el selector de fecha.  Estará viendo el calendario o la lista que hubiera visto su ascendiente en esa fecha años atrás.<br /><br />";
$pgv_lang["day_month_help"]				= "~BOTONES VER DÍA / VER MES / VER AÑO~<br /><ul><li>El botón <b>Ver día</b> muestra los eventos de la fecha elegida en una lista. Se comprueban todos los años, así que sólo se pueden poner aquí el día y el mes. Cambiar el año no surte efecto.  Puede reducir la lista escogiendo la opción <b>Años recientes</b> o <b>Personas vivas</b>.<br /><br />Las edades en la lista se calcularán a partir del año actual.</li><li>El botón <b>Ver Mes</b> mostrará un diagrama de calendario para el mes y año elegidos. Aquí también puede reducir las listas escogiendo la opción <b>Años recientes</b> o <b>Personas vivas</b>.<br /><br />Obtendrá una impresión realista de lo que pudo ser un calendario en la pared de sus antepasados escogiendo un año en el pasado junto con <b>Años recientes</b>. Todas las edades del calendario se muestran relativas al año escrito en la caja Año.</li><li>El botón <b>Ver Año</b> le mostrará una lista de eventos del año elegido.  Aquí también puede reducir la lista escogiendo las opciones <b>Años recientes</b> o <b>Personas vivas</b>.<br /><br />Puede mostrar eventos para un intervalo de años.  Simplemente teclee los años de comienzo y final del intervalo separados por un guión <b>-</b>.  Ejemplos:<br /><b>1992-4</b> para todos los eventos de 1992 a 1994<br /><b>1976-1984</b> para todos los eventos de 1976 a 1984<br /><br />Para ver todos los eventos de una década o siglo dados, puede utilizar <b>?</b> en lugar de los dígitos finales. Por ejemplo, <b>197?</b> para todos los eventos de 1970 a 1979 o <b>16?</b> para todos los eventos de 1600 a 1699.</li></ul>Si quiere <b>cambiar el año</b> Vd. <b>tiene</b> que hacer clic en uno de estos tres botones.  Los demás ajustes permanecen como  estaban.<br /><br />";

//-- Clippings Cart-page
$pgv_lang["help_clippings.php"]			= "~CARRITO DE RECORTES DEL ÁRBOL GENEALÓGICO~<br />El #pgv_lang[clip_cart]# le permite tomar fragmentos (\"recortes\") de este árbol genealógico e irlos añadiendo en un único archivo para su posterior descarga y uso en su propio programa genealógico.  El archivo que se descarga está en formato GEDCOM.<br /><ul><li>¿Cómo hacer recortes?<br />Es realmente sencillo. Cada vez que vea un nombre en el que se pueda hacer clic (persona, familia o fuente) puede ir a la página de Detalles de ese nombre.  Allí verá la opción <b>#pgv_lang[add_to_cart]#</b>.  Si hace clic en ese vínculo se le ofrecerán varias opciones de descarga.</li><li>¿Cómo descargar?<br />Una vez tenga elementos en su carrito, puede descargarlo haciendo clic en el vínculo <b>Descargar ahora</b>.  Siga las instrucciones y los vínculos.</li></ul><br />";
$pgv_lang["clip_download_help"]			= "~DESCARGAR LOS RECORTES~<br /><br />Si hace clic en este vínculo irá a la siguiente página.  Si cualquiera de los recortes de su carrito referencia objetos audiovisuales, también se mostrarán en esa página.<br /><br />Simplemente siga las instrucciones.<br /><br />";
$pgv_lang["empty_cart_help"]			= "~VACIAR EL CARRITO GENEALÓGICO~<br /><br />Si hace clic en este vínculo, se vaciará completamente su #pgv_lang[clip_cart]#.<br /><br />Si no quiere borrar todas las personas, familias, etc. del #pgv_lang[clip_cart]#, puede borrar los elementos individualmente haciendo clic el vínculo <b>Borrar</b>en las cajas de Nombre.  <u>No</u> hay diálogo de confirmación si hace clic en cualquiera de estos vínculos, el borrado solicitado tiene lugar inmediatamente.<br /><br />";
$pgv_lang["add_by_id_help"]				= "~AGREGAR AL CARRITO POR ID~<br /><br />Este campo le permite introducir el número ID de una persona para agregarla al Carrito Genealógico.  Una vez agregado, se le ofrecerán opciones para incluir los parientes de esa persona al carrito.<br /><br />Si no conoce el número ID de una persona, puede buscarla por su nombre haciendo clic en el icono de Persona que se encuentra junto al botón Agregar.<br /><br />";
$pgv_lang["zip_help"]					= "~PONER EN ZIP LA PODA~<br /><br />Seleccione esta opción para guardar su poda en un archivo ZIP.  Para más información sobre los archivos ZIP, visite por favor <a href=\"http://www.winzip.com\" target=\"_blank\">http://www.winzip.com</a>.<br /><br />";
$pgv_lang["include_media_help"]			= "~INCLUIR AUDIOVISUALES~<br /><br />Seleccione esta opción para incluir los archivos audiovisuales asociados a los registros de su carrito.  Si escoge esta opción, se creará un zip automáticamente durante la descarga.<br /><br />";
$pgv_lang["clip_cart_help"]				= "~CARRITO GENEALÓGICO~<br /><br />Esta caja muestra el contenido de su carrito genealógico.  La columna <i>Tipos</i> indica el tipo de cada entrada, que puede ser Persona (INDI), Familia (FAM), Fuente (SOUR), Repositorio (REPO), Nota (NOTE) y Objeto audiovisual (OBJE);  cada uno está representado por su propio icono.  La columna <i>ID</i> muestra el número de ID para cada elemento de ese tipo en particular.  La columna <i>Nombre / Descripción</i> da bien el nombre de la familia o persona, bien la descripción del elemento.  El botón Borrar eliminará ese registro del carrito.  <b>NO se solicita confirmación para el borrado.</b><br /><br />";

//-- GEDCOM Edit Utility
$pgv_lang["show_changes_help"]			= "~MOSTRAR CAMBIOS AL GEDCOM~<br /><br />Cuando le aparezca este mensaje, suceden dos cosas:<br /><br />1. Alguien ha hecho cambios en el Gedcom<br />Pueden haber sido añadidos, borrados o modificados registros.<br /><br />2. Las modificaciones no han sido todavía aprobadas por el administrador.<br />Una vez que las modificaciones hayan sido rechazadas o aprobadas, este mensaje no volverá a aparecer mas.<br /><br /><br />Seleccionando el vínculo puede ver las modificaciones que se hayan producido.<br />Si advierte que alguna nos es correcta, por favor notifíqueselo al administrador.";

//-- Search-page
$pgv_lang["help_search.php"]			= "~PÁGINA DE BÚSQUEDA~<br /><br />Aunque simple en apariencia, con los dos medios de búsqueda tenemos un poderoso motor de búsquedas.<br /><br />En la mayoría de los sitios de genealogía permiten buscar por un apellido.<br />En este sitio puede prácticamente buscar por todo.<br /><br />La caja de búsqueda de la izquierda es la misma que la de la cabecera.<br /><br />Si esta buscando por personas de un año determinado, introduzca ese año. El programa le encontrará todas las conexiones.<br /><br />¿Buscando un nombre o un lugar?<br />Teclee el nombre o el lugar, completo o una parte, y el programa hará el resto.<br /><br />Método de búsqueda por SOUNDEX.<br />En la caja de la derecha, puede buscar por nombres, incluso si no sabe como escribir el nombre.<br /><br />Encontrará más ayuda sobre esto haciendo clic en el signo <b>?</b> sobre las cajas.<br /><br />";
$pgv_lang["search_enter_terms_help"]		= "~ESCRIBA LOS CRITERIOS DE BÚSQUEDA~<br /><br />En esta caja de Búsqueda puede introducir los criterios como fechas, nombres de pila, apellidos, lugares, objetos, etc.<br /><br /><b>Comodines</b><br />Los comodines, como probablemente los conoce (como * o ?), no están permitidos, pero el programa los supone automáticamente.<br /><br />Supongamos que teclea en la caja de Búsqueda lo siguiente: <b>Rosa</b>.  El resultado podría ser, suponiendo que los nombres están en la base de datos: <div style=\"padding-left:30px;\"><b>Rosa</b> Aguiño Otero<br /><b>Rosa</b>lía Fariña Montero<br />María <b>Rosa</b>do Vázquez<br />Juan Antonio López --Nacido 1 enero 1901 Villagarcía de A<b>rosa</b><br />etc.</div><br /><b>Fechas</b><br />Introducir un año en la caja de Búsqueda producirá una list de personas conectada de alguna manera con ese año.<br /><br />Si teclea 1950, el resultado será todas las personas con un evento ocurrido 1950.  Estos eventos podrían ser nacimientos, defunciones, matrimonios, Bar Mitzvahs, sellamientos SUD, etc.<br /><br />Si teclea <b>4 dec</b>, se listarán todas las personas conectadas a un evento que ocurrió un 4 de diciembre de cualquier año.  También se listarán las personas conectadas a eventos ocurridos un 14 o un 24 de diciembre. Como puede ver, los comodines se suponen siempre sin necesidad de teclearlos.  A veces, los resultados pueden ser sorprendentes.<br /><br /><b>Fechas correctas</b><br />PhpGedView busca en los datos tal como están almacenados en el archivo GEDCOM.  Si, por ejemplo, quiere busca un evento ocurrido un 14 de diciembre, debería teclear <b>14&nbsp;dec</b> porque ésta es la manera como se guarda la fecha en la base de datos.<br /><br />Si tecleara <b>dec&nbsp;14</b>, el resultado podría ser una persona conectada con un evento con fecha 08&nbsp;<b>DEC</b>&nbsp;18<b>14</b> (es decir, 8 de diciembre de 1814).  De nuevo, los resultados pueden sorprender.<br /><br />Puede utilizar expresiones regulares en su búsqueda si está familiarizados con ellas.  Por ejemplo, si quisiera encontrar todas las personas con fechas en el siglo XX, podría introducir la búsqueda <b>19[0-9][0-0]</b> y obtendría todas las personas con fechas en el intervalo 1900-1999.<br /><br />Si necesita más ayuda con este sistema de búsqueda, le rogamos nos lo haga saber, para que también podamos extender este archivo de Ayuda.<br /><br />#pgv_lang[soundex_search_help]# #pgv_lang[search_replace_help]#";
$pgv_lang["search_replace_help"]		= "~#pgv_lang[search_replace]#~<br /><br />Aquí puede buscar errores ortográficos u otra información incorrecta y sustituirla por la información correcta.<br /><br /><b>Buscar</b><br />Esta característica realiza una búsqueda como una <a href=\"help_text.php?help=search_enter_terms_help\">búsqueda normal</a>.<br /><br /><b>Reemplazar</b><br />Todos los casos del término buscado que se hallen se reemplazarán por el reemplazo en la base de datos.<br /><br /><b>Por ejemplo...</b><br />Suponga que escribe incorrectamente por error el nombre de su bisabuelo Miguel.  Escribió por error 'Miquel.' <br /><br />En este caso pondría <b>Miquel</b> en el campo de Buscar y <b>Miguel</b> en el campo de Reemplazar.<br />Cada aparición de \"Miquel\" se sustituiría por \"Miguel\"<br /><br /><b>Buscar en...</b><br />Selecciona el alcance de la búsqueda.  Puede limitar la búsqueda a nombres o lugares o no aplicar ninguna limitación (buscar en todo).  La opción <i>#pgv_lang[search_place_word]#</i> sólo buscará su término en el campo lugar como una palabra completa.  Esto significa que si busca <i>UT</i>, sólo encontrará <b>UT</b> y no <i>UT</i> dentro de otras palabras como Connectic<b>ut</b>.<br /><br />No se preocupe si sustituye algo accidentalmente que no quería.  Simplemente haga clic en el vínculo \"Aceptar/Rechazar Cambios\" en la parte inferior de la página para aceptar los cambios que desee y rechazar los que no.<br /><br />Si necesita más ayuda con este sistema de búsqueda, háganoslo saber para que podamos mejorar este archivo de ayuda también.<br /><br />";
$pgv_lang["soundex_search_help"]		= "~#pgv_lang[soundex_search]#~<br /><br />Soundex es un método de asignar códigos a las palabras según su pronunciación.  Esto le permite buscar en la base de datos nombres y lugares si no conoce exactamente cómo están escritos.  PhpGedView puede utilizar dos algoritmos Soundex diferentes que producen resultados completamente distintos.<ul><li><b>Básico</b><br />Este método, patentado en 1918 por Russell, es muy sencillo y puede hacerse a mano.<br /><br />Como el método básico conserva la primera letra del código como parte del código resultante, no resulta de mucha ayuda si no se está seguro de esa primera letra.  El algoritmo Básico no va bien con apellidos originarios de otros idiomas distintos del inglés e incluso con nombres ingleses los resultados pueden sorprender.  Por ejemplo, si se busca <b>Smith</b> por el método Soundex Básico, devolverá no sólo <b>Smith, Smid, Smit, Schmidt, Smyth, Smithe, Smithee, Schmitt</b> que son todas variaciones de <b>Smith</b>, sino también <b>Smead, Sneed, Smoote, Sammett, Shand</b> y <b>Snoddy</b>.  <br /><br /><b>Daitch-Mokotoff</b>Este método, desarrollado en 1985, es mucho más complejo que el método Básico y no se aplica fácilmente a mano.<br /><br />Una búsqueda Soundex con este método produce resultados mucho más precisos.</li></ul>Para detalles sobre ambos algoritmos Soundex, visite esta página web de la <a href=\"http://www.jewishgen.org/infofiles/soundex.html\" target=_blank><b>Jewish Genealogical Society</b></a>.";
$pgv_lang["search_exclude_tags_help"]	= "~#pgv_lang[search_tagfilter]#~<br /><br />La opción <b>#pgv_lang[search_tagfon]#</b> hará que la función Buscar ignore las siguientes etiquetas GEDCOM:<div style=\"padding-left:30px;\"><b>_PGVU</b> - Autor del último cambio<br /><b>CHAN</b> - Fecha del último cambio<br /><b>FILE</b> - #factarray[FILE]#<br /><b>FORM</b> - #factarray[FORM]#<br /><b>TYPE</b> - #factarray[TYPE]#<br /><b>SUBM</b> - #factarray[SUBM]#<br /><b>REFN</b> - #factarray[REFN]#</div><br />Además de estas etiquetas excluidas de forma opcional, la función Buscar siempre excluye las siguientes etiquetas:<div style=\"padding-left:30px;\"><b>_UID</b> - #factarray[_UID]#<br /><b>RESN</b> - #factarray[RESN]#</div><br /><br />";
$pgv_lang["search_include_ASSO_help"]	= "~#pgv_lang[search_asso_label]#~<br /><br />Esta opción hace que PhpGedView muestre todas las personas marcadas con alguna relación con la persona o familia encontrada como resultado directo de la búsqueda.  El caso contrario, mostrar todas las personas o familias con la que la persona encontrada de forma directa por la búsqueda tiene una relación de asociación, no es posible.<br /><br />Ejemplo:  Suponga que la persona <b>A</b> is padrino de la persona <b>B</b>.  Esta relación se registra en el registro GEDCOM de la persona <b>B</b> mediante una etiqueta ASSO.  No existe en el GEDCOM una etiqueta correspondiente en el registro de la persona <b>A</b>.<br /><br />Si se fija esta opción a <b>#pgv_lang[yes]#</b> y entre los resultados de la búsqueda resulta incluida <b>B</b>, <b>A</b> se incluirá automáticamente a causa de la etiqueta ASSO en el registro GEDCOM de <b>B</b>.  Por el contrario, si en la lista de resultados aparece <b>A</b>, <b>B</b> no se incluirá automáticamente puesto que no hay una etiqueta ASSO correspondiente en el registro GEDCOM de la persona <b>A</b>.<br /><br />";

//-- Individual Information-page
$pgv_lang["help_individual.php"]		= "~PÁGINA #pgv_lang[indi_info]#~<br /><br />En esta página se muestran todos los detalles de una persona.<br /><br />Si hay una foto disponible, la verá en la esquina superior izquierda.  Junto a la foto verá los nombres de la persona.<br /><br />Los nombres pueden tener notas y fuentes adjuntas a ellos. Si alguno de los nombres tiene notas o fuentes, las verá listadas bajo los nombres correspondientes.<br /><br />Una persona podría tener un apodo o alias (quizá es conocida por otro nombre). Si es así, se mostrará.<br /><br />Si tiene privilegios para modificar esta persona, también verá vínculos <b>Modificar</b> y <b>Borrar</b> junto a los elementos que pueda modificar.<br /><br />En esta página verá pestañas para <b>#pgv_lang[personal_facts]#</b>, <b>#pgv_lang[notes]#</b>, <b>#pgv_lang[ssourcess]#</b>, <b>#pgv_lang[media]#</b> y <b>#pgv_lang[relatives]#</b>.  Estas pestañas le muestran toda la información acerca de esta persona almacenada en la base de datos.<br /><ul><li>La pestaña <b>#pgv_lang[personal_facts]#</b> le mostrará los hechos y detalles acerca de esta persona y cualquier hecho de sus matrimonios. Hacer clic en cualquier fecha en esta pestaña, le llevará al #pgv_lang[anniversary_calendar]# para esa fecha para que pueda ver qué otros eventos sucedieron el mismo día. Hacer clic en un lugar le llevará a la Jerarquía de Lugares donde podrá ver quién tuvo eventos en el mismo lugar. Para los matrimonios y otros hechos familiares, se muestra el nombre del cónyuge para que pueda ver el cónyuge y también se proporciona un vínculo al registro de la familia.</li><li>La pestaña <b>#pgv_lang[notes]#</b> le mostrará cualquier nota general relacionada con esta persona.</li><li>La pestaña <b>#pgv_lang[ssourcess]#</b> le mostrará todas las fuentes <u>generales</u> para esta persona. Estas fuentes <u>no</u> están vinculadas a hechos de la persona, ni siquiera al nombre de la persona; están asociadas con la persona propiamente dicha.  Hacer clic en el título de una fuente le llevará a una página de Información de Fuente más detallada que mostrará otras personas que también están vinculadas a la misma fuente.</li><li>La pestaña <b>#pgv_lang[media]#</b> listará todas las fotos y otros elementos audiovisuales que están vinculadas a esta persona. Hacer clic en una miniatura de la foto abrirá un vista mayor de la imagen. Hacer clic en el rótulo de la foto le mostrará la foto en la página #pgv_lang[media_list]#.</li><li>La pestaña <b>#pgv_lang[relatives]#</b> lista los padres y hermanos así como los cónyuges e hijos que ha tenido esta persona. Estas personas se listarán en cajas similares a los diagramas que puede que ya ha visto.</li></ul>A la derecha de la pantalla encontrará una caja con vínculos.  Muchos de los vínculos de la caja son los mismos que los vínculos en los menús. Por ejemplo, pinchar en el vínculo <b>#pgv_lang[pedigree_chart]#</b> en los vínculos laterales le llevará al diagrama Árbol de ascendientes para esta persona. Esto es diferente de los vínculos de los menús porque hacer clic en el vínculo <b>#pgv_lang[pedigree_chart]#</b> del menú le llevara otra vez al diagrama Árbol de ascendientes predeterminado para esta base de datos.<br /><br />Uno de los vínculos que podría aparecer en esta lista si ha sido activado por el administrador, es el vínculo <b>#pgv_lang[view_gedcom]#</b>. Este vínculo le mostrará en registro GEDCOM en bruto de esta persona.<br /><br />Si el administrador del sitio ha activado el #pgv_lang[clip_cart]#, también tendrá un vínculo que le permitirá agregar esta persona a su #pgv_lang[clip_cart]#.<br /><br />El vínculo <b>#pgv_lang[relationship_to_me]#</b> sólo aparecerá si está autenticado y se le ha asignado un ID en el GEDCOM. Este vínculo le llevará al diagrama Árbol de ascendientes y le mostrará cómo está emparentada con esta persona.<br /><br />#pgv_lang[context_help]#<br /><br />";
$pgv_lang["delete_person_help"]			= "~BORRAR PERSONA DEL GEDCOM~<br /><br />Si hace clic en esta opción, marcará esta persona para ser borrada de la base de datos.<br /><br />¿Qué significa?<br />Supongamos que tiene un buen motivo para borrar a esta persona de la base de datos. Haga clic en el vínculo.  Se le pedirá que confirme su petición de borrado.  Si decide continuar, puede pasar algún tiempo antes de que vea un mensajes de que se ha borrado la persona.<br /><br />Cuando continúe su visita, notará que la persona todavía es visible y puede usarse como si no se hubiera borrado.<br /><br /><b>Esto <u>no</u> es un error</b>.  El administrador del sitio recibirá un mensaje indicando que se ha realizado un cambio a la base de datos y de que Vd. ha borrado a la persona.<br />El administrador puede aceptar o rechazar su cambio. Sólo cuando el administrador haya aceptado el cambio ocurrirá de verdad el borrado <u>irreversiblemente</u>.  Si hay alguna duda acerca de su cambio, el administrador se pondrá en contacto con Vd.<br /><br />";
$pgv_lang["delete_name_help"]			= "~MODIFICAR o BORRAR NOMBRE DEL GEDCOM~<br /><br /><b>MODIFICAR NOMBRE</b><br />Si hace clic en este vínculo, se abrirá otra ventana.  En ella puede modificar el nombre de la persona.  Simplemente teclee los cambios en los campos y haga clic en el botón, cierra la ventana y ya está.<br /><br /><b>BORRAR NOMBRE</b><br />Haciendo clic en este vínculo, marcará a este nombre para ser borrado de la base de datos.  Tenga presente que borrar el nombre es completamente diferente a borrar la persona.  Borrar el nombre sólo elimina al nombre de la persona. La persona <u>no</u> será borrada.  Si es un nombre alternativo o alias lo que desea borrar, la persona aún conserva sus otros nombres.  Si lo que está borrando es su <u>único</u> nombre, la persona tampoco se borrará, pero aparecerá ahora como <b>#pgv_lang[NN]#</b>.  La persona tampoco se desconectará de sus parientes, fuentes, notas, etc.<br /><br />¿Cómo funciona?<br />Primero se le pedirá que confirme su petición de borrado.  Si decide continuar, puede pasar algún tiempo antes de que se le muestre un mensaje de que el nombre se ha borrado.<br /><br />Cuando continúe su visita, notará que el nombre todavía es visible y puede ser utilizado como si no se hubiera borrado.<br /><br /><b>Esto <u>no</u> es un error.</b>  El administrador del sitio recibirá un mensaje indicando que se han realizado cambios a la base de datos y que Vd. ha borrado al nombre.<br />El administrador puede aceptar o rechazar su cambio. Sólo después de que el administrador acepte su cambio de verdad ocurrirá el cambio <u>irreversiblemente</u>.  Si hay alguna duda sobre su cambio, el administrador se pondrá en contacto con Vd.<br /><br />";
$pgv_lang["add_name_help"]				= "~AGREGAR UN NUEVO NOMBRE~<br /><br />Este vínculo le permitirá agregar otro nombre a esta persona.  A veces, se conoce a las personas por otros nombres o alias.  Este vínculo le permita agregar nuevos nombres a la persona sin cambiar el viejo nombre.<br /><br />";
$pgv_lang["add_sibling_help"]			= "~#pgv_lang[add_sibling]#~<br /><br />Puede agregar un hijo/a a esta familia haciendo clic en este vínculo.  \"Esta familia\", en este caso, es el padre y la madre de la persona principal de esta pantalla.<br /><br />Tenga presente que va a agregar un hermano o hermana a esa persona.  Agregar un hermano o hermana es simple: haga clic en el vínculo, rellene las casillas de la ventana emergente y ya está.<br /><br />Si tiene que agregar un hijo o una hija de la persona principal, desplácese un poco hacia abajo y haga clic en el vínculo en \"#pgv_lang[as_spouse]#\".<br /><br />";
$pgv_lang["add_son_daughter_help"]		= "~#pgv_lang[add_son_daughter]#~<br /><br />Puede agregar un hijo/a a esta familia haciendo clic en este vínculo.  \"Esta familia\", en este caso, es la persona principal de esta ventana y su cónyuge.<br /><br />Tenga presente que va a agregar un hijo o una hija de esa persona.  Agregar un hijo o una hija es simple:  Haga clic en el vínculo, rellene las casillas de la ventana emergente y ya está.<br /><br />Si tiene que agregar un hermano o hermana de la persona principal, desplácese un poco hacia arriba y haga clic en el vínculo en \"#pgv_lang[as_child]#\".<br /><br />";
$pgv_lang["link_child_help"]			= "~#pgv_lang[link_as_child]#~<br /><br />Puede relacionar esta persona como hijo/a de una familia existente haciendo clic en este vínculo.<br /><br />Suponga que los padres de una persona eran desconocidos y descubrió después que los padres tenían ya un registro en esta base de datos.<br /><br />Haga clic en el vínculo, introduzca el ID de la familia de la familia y habrá realizado la tarea.  Si no conoce el ID de la familia, puede buscarlo.<br /><br />";
$pgv_lang["link_husband_help"]			= "~#pgv_lang[link_as_husband]#~<br /><br />Esta entrada le permitirá vincular la persona actual como esposo de una familia ya existente en la base de datos. Haciendo clic en este vínculo, puede agregar esta persona a una familia existente cuyo esposo era desconocido hasta ahora. Esta persona tomará el lugar del esposo previamente desconocido. Todos los eventos, información de matrimonio e hijos, mantendrán sus vínculos actuales con la familia.<br /><br />Simplemente haga clic en el vínculo, introduzca el ID de la familia y habrá completado la tarea. Ésta es una opción de modificación avanzada que sólo debe ser utilizada si la familia que desea vincular ya existe. Si quiere agregar una <u>nueva</u> familia a la persona, utilice el vínculo <b>#pgv_lang[add_new_husb]#</b>.<br /><br />";
$pgv_lang["add_husband_help"]			= "~#pgv_lang[add_new_husb]#~<br /><br />Haciendo clic en este vínculo puede agregar una nueva persona (masculina) y relacionarla a la persona principal como un nuevo esposo.<br /><br />Haga clic en el vínculo y obtendrá una ventana emergente para agregar la nueva persona.  Rellene todas las casillas que pueda y haga clic en el botón <b>Guardar</b>.<br /><br />Eso es todo.<br /><br />";
$pgv_lang["link_new_husb_help"]			= "~#pgv_lang[link_new_husb]#~<br />Esto le permitirá vincular otra persona, ya existente, como un nuevo esposo a esta persona.  Esto creará una nueva familia con el esposo que ha seleccionado.  También tendrá la opción de especificar un matrimonio para esta nueva familia.<br /><br />";
$pgv_lang["add_opf_child_help"]			= "~#pgv_lang[add_opf_child]#~<br /><br />Haciendo clic en este vínculo puede agregar un <u>nuevo</u> hijo a esta persona creando una familia sin cónyuge.<br /><br />Simplemente haga clic en el vínculo y aparecerá una ventana emergente para agregar la nueva persona.  Rellene todos los campos que pueda y haga clic en el botón <b>Guardar</b>.<br /><br />Eso es todo.<br /><br />";
$pgv_lang["link_wife_help"]			= "~#pgv_lang[link_as_wife]#~<br /><br />Este elemento le permitirá relacionar la persona actual como esposa de una familia ya existente en la base de datos.<br /><br />Ésta es una opción de modificación avanzada que sólo debe usarse si la familia con la que desea relacionar la persona ya existe.  Si desea agregar una familia <u>nueva</u> a esta persona, use el vínculo <b>#pgv_lang[add_new_husb]#</b>.<br /><br />";
$pgv_lang["add_wife_help"]			= "~#pgv_lang[add_new_wife]#~<br /><br />Haciendo clic en este vínculo puede agregar una nueva persona (femenina) y relacionarla a la persona principal como una nueva esposa.<br /><br />Haga clic en el vínculo y obtendrá una ventana emergente para agregar la nueva persona.  Rellene todas las casillas que pueda y haga clic en el botón <b>Guardar</b>.<br /><br />Eso es todo.<br /><br />";
$pgv_lang["link_new_wife_help"]			= "~#pgv_lang[link_new_wife]#~<br />Esto le permitirá vincular otra persona ya existente como otra esposa de esta persona.  Esto creará una nueva familia con la esposa que seleccione.  También tendrá la opción de especificar un matrimonio para esta nueva familia.<br /><br />";
$pgv_lang["add_new_parent_help"]		= "#pgv_lang[multiple_help]#<br />~AGREGAR NUEVO PADRE O MADRE~<br /><br />Seguramente existirán muchas personas en el GEDCOM sin registros de padre o madre.<br /><br />En ese caso, en la tabla <b>#pgv_lang[as_child]#</b> de la pestaña <b>#pgv_lang[relatives]#</b> de la página <b>#pgv_lang[indi_info]#</b> encontrará vínculos para agregar un/a <u>nuevo/a</u> padre o madre a la persona.<br /><br />Tenga presente que estos vínculos son para agregar un/a <b>nuevo/a</b> padre o madre.  Si el padre o la madre ya tienen un registro en esta base de datos, debe utilizar el vínculo <b>#pgv_lang[link_as_child]#</b>, que encontrará en esa página <b>#pgv_lang[indi_info]#</b> bajo la última tabla.<br /><br />";
$pgv_lang["show_fact_sources_help"]		= "~#pgv_lang[show_fact_sources]#~<br />~#pgv_lang[show_fact_notes]#~<br />Si marca esta opción, podrá ver todos los registros de fuentes o notas de esta persona.  Si esta opción no se marca, no se mostrarán los registros de fuentes o notas asociados a otros hechos relativos a esta persona.<br /><br />";
$pgv_lang["age_differences_help"]	= "~#pgv_lang[age_differences]#~<br />Si se marca esta casilla, la pestaña de «#pgv_lang[relatives]#» mostrará las diferencias de fechas de la siguiente manera:<br /><ul><li>fechas de nacimientos de las parejas.<br />Un valor negativo indica que la segunda persona es mayor que la primera.<br /><br /></li><li>fecha de matrimonio y fecha de nacimiento del primer hijo.<br />Un valor negativo aquí indica que el hijo nació antes de la fecha de matrimonio o que alguna de las fechas está equivocada.<br /><br /></li><li>fechas de nacimiento de los hermanos.<br />Un valor negativo aquí indica que bien el orden de los hijos está equivocado o que una de las fechas de nacimiento lo está.</li></ul><br /><br />";

//-- Add Facts
$pgv_lang["add_facts_help"]			= "~AGREGAR NUEVOS HECHOS~<br /><br />Aquí puede agregar un hecho al registro que se está modificando.<br /><br />Primero elija un hecho de la lista desplegable y haga clic en el botón <b>Agregar</b>.  En esa lista desplegable se encuentran todos los posibles hechos que se pueden agregar a la base de datos.<br /><br />";
$pgv_lang["add_custom_facts_help"]		= "~Agregar hecho personalizado~<br />Si no halla el hecho que desea agregar en la lista de hechos GEDCOM, también puede introducir un <b>hecho personalizado</b>.<br /><br />Introducir un hecho personalizado es tan simple como introducir uno de los predefinidos.  La única diferencia es que deberá asignar un nombre al hecho en vez de escogerlo de una lista. Deberá hacerlo en el campo superior: <b>#pgv_lang[type]#</b><br /><br />";
$pgv_lang["add_note_help"]			= "#pgv_lang[multiple_help]#<br />~AGREGAR UNA NUEVA NOTA~<br />Si debe agregar una nota a esta persona (o personas), éste es el lugar para hacerlo.<br />El proceso es simple, haga clic en el vínculo y aparecerá una ventana desplegable, donde podrá introducir la nota.<br /><br />Cuando haya finalizado la escritura, haga clic en el botón bajo la casilla y cierre la ventana desplegable.<br /><br />#pgv_lang[add_facts_general_help]#";
$pgv_lang["add_shared_note_help"]	= "#pgv_lang[multiple_help]#<br />~#pgv_lang[add_shared_note_lbl]#~<br />Si hace clic en el vínculo <b>#pgv_lang[add_shared_note]#</b>, se abrirá una nueva ventana.  Puede escoger vincular una nota ya existente o crear una nueva nota compartida y vincularla con este registro al tiempo.<br /><br />#pgv_lang[add_facts_general_help]#";
$pgv_lang["add_source_help"]			= "#pgv_lang[multiple_help]#<br />~AGREGAR NUEVA CITA DE FUENTE~<br />Aquí puede agregar una <b>Cita</b> a una fuente a este registro.<br /><br />Haga clic en el vínculo, se abrirá una ventana y podrá elegir la fuente de la lista (Encontrar ID) o crear una nueva fuente y agregar la Cita.<br /><br />Agregar fuentes es un parte importante de la genealogía porque permite a otros investigadores verificar dónde obtuvo su información.<br /><br />#pgv_lang[add_facts_general_help]#";
$pgv_lang["add_media_help"]			= "~#pgv_lang[add_media]#~<br /><br />Agregar objetos audiovisuales (<i>archivos multimedia</i>) al GEDCOM es una característica muy atractiva.  Aunque este programa ya tiene un buen aspecto sin objetos audiovisuales, si agrega fotos u otros archivos a sus parientes, sólo puede mejorar.<br /><br /><b>Lo que debería entender acerca de los objetos audiovisuales.</b>.<br />Hay muchos formatos de objetos audiovisuales.  Aunque PhpGedView puede manejar la mayoría, hay algunas cosas que considerar.<br /><ul><li><b>Formatos</b><br />Las fotos pueden editarse y guardarse en muchos formatos.  Por ejemplo, .jpg, .png, .bmp, .gif, etc.  Si se usa la misma foto original para crear cada uno de los formatos, la imagen visualizada parecerá tener el mismo tamaño sea cual sea el formato.  Sin embargo, los archivos de las imágenes almacenados en la base de datos variarán de tamaño considerablemente.  Generalmente, las imágenes .jpg se consideran las más eficientes en términos de espacio de almacenamiento.</li><li><b><b>Tamaño de la imagen</b><br />Cuanto mayor sea la imagen original, mayor será el tamaño del archivo resultante. La foto debería caber en la pantalla y no necesitar las barras de desplazamiento para verse por completas; la anchura y altura máximas no deberían ser mayores que la anchura o altura de la pantalla. PhpGedView está diseñado para pantallas de 1024x768 píxeles pero no todo este espacio está disponible para visualizar fotos; el tamaño de la foto debería ajustarse apropiadamente.  Para reducir los tamaños de los archivos, son preferibles fotos más pequeñas.</li><li><b>Resolución</b><br />La resolución de una foto se expresa normalmente en \"dpi\" (dots per inch o puntos por pulgada), pero esto sólo es válido para fotos impresas.  Al considerar fotos mostradas en una pantalla, la única forma correcta es utilizar el número total de puntos o píxeles.  Al imprimir, la foto podría tener una resolución de 150 - 300 dpi o más dependiendo de la impresora. Las resoluciones de pantalla rara vez son mejores que 50 píxeles por pulgada.  Si su foto nunca se imprimirá, no hay problema en bajar su resolución (y, en consecuencia, el tamaño del archivo) sin afectar a la calidad de la imagen.  Si se imprime una foto de baja resolución con ampliación excesiva, su calidad se verá afectada; tendrá una apariencia granulosa.</li><li><b>Cantidad de colores</b><br />Otra forma de que no crezca el tamaño de un archivo es disminuir el número de colores utilizados.  El número de colores pude ir desde puro blanco y negro (dos colores) a colores <i>verdaderos</i> (millones de colores) y muchas opciones intermedias.  Puede ver que cuantos más colores e utilicen, mayor será el tamaño de los archivos.</li><li><b>¿Por qué es importante mantener pequeño el tamaño de los archivos?</b><br /><ul><li>Primero: Nuestro espacio en el servidor es limitado.  Cuantos más archivos grandes haya, más espacio necesitaremos en el servidor. Cuanto más espacio necesitemos, mayores serán nuestros costes.</li><li>Ancho de banda.  Cuantos más datos tenga que enviar nuestro servidor a sitios remotos (el sitio en que está Vd., por ejemplo), más habremos de pagar.  Esto es porque la capacidad de la conexión a la Internet de su servidor está limitada y el enlace tiene que compartirse (y ser pagado) por todas las aplicaciones que se ejecutan en el servidor.  PhpGedView es una de las muchas aplicaciones que comparten el servidor.  El coste se cubre normalmente de forma proporcional según la cantidad de datos que cada aplicación envía y recibe.</li><li>Tiempo de descarga.  Si tiene archivos grandes, el usuario (incluido Vd.) tendrá que esperar mucho tiempo a que descarguen las páginas del servidor.  No todo el mundo disfruta de una conexión por cable, banda ancha o DSL.</li></ul>¿Cómo subir sus archivos audiovisuales?</b><br />Hay dos formas de subir archivos audiovisuales al sitio.  Si tiene muchos archivos que subir, debería ponerse en contacto con el administrador del sitio para acordar el mejor medio.  Si el administrador ha habilitado la opción, puede utilizar el formulario Subir Objetos Audiovisuales bajo su menú #pgv_lang[mgv]. También puede utilizar la opción Subir en el formulario de Objetos para subir objetos audiovisuales.<br /><br />";
$pgv_lang["gen_missing_thumbs_help"]	= "~#pgv_lang[gen_missing_thumbs]#~<br />Esta opción generará miniaturas para todos los archivos del directorio actual que la tengan aún.  Esto es mucho más práctico que hacer clic en el vínculo <b>#pgv_lang[gen_thumb]#</b> en cada uno de esos archivos.<br /><br />Si desea mantener el control sobre qué archivos deben tener miniaturas, no debe usar esta opción.  En vez de ello, haga clic en los vínculos <b>#pgv_lang[gen_thumb]#</b> apropiados.<br /><br />";
$pgv_lang["add_facts_general_help"]      = "~Información general acerca de agregar~<br />Cuando haya agregado un hecho, nota, fuente u objeto audiovisual a un registro de la base de datos, la agregación aún ha de ser aprobada por un usuario que tenga privilegios para Aceptar<br /><br />Hasta que los cambios se hayan aceptado, se identifican como \"pendientes\" mediante un borde de color diferente.  Todos los usuarios con permisos para Modificar pueden ver estos cambios junto con la información original.  Los usuarios que no tienen derechos para Modificar sólo verán la información original.  Cuando la agregación se haya aceptado, los bordes desaparecen y los nuevos datos se mostrarán normalmente, sustituyendo a los viejo.  En ese momento, los usuarios sin derecho para Modificar verán también los nuevos datos.<br /><br />";

//-- Edit user
$pgv_lang["edituser_my_account_help"]		= "Aquí puede modificar sus ajustes y preferencias.<br /><br />Puede cambiar su identificador, su nombre completo, su contraseña, su dirección de correo electrónico, el tema del sitio y su método de contacto preferido.<br /><br />No puede cambiar el ID del registro INDI del GEDCOM, ese cambio debe hacerlo un administrador.";
$pgv_lang["edituser_username_help"]		= "~#pgv_lang[username]#~<br /><br />En esta caja puede modificar su identificador de usuario.  Si ya no le gusta su identificador o tiene otras razones para cambiarlo, puede hacerlo usando este formulario.<br /><br />El identificador de usuario <u>distingue entre mayúsculas y minúsculas</u>. Esto significa que <b>Juan</b> no es lo mismo que <b>juan</b> o que <b>JUAN</b>.<br /><br />Debe utilizar <u>solamente</u> caracteres de alfabetos soportados por PhpGedView.  Puede utilizar letras mayúsculas y minúsculas con o sin marcas diacríticas (como los acentos), números, guión (-) y subrayado (_). <u>No</u> utilice signos de puntuación o espacios.<br /><br />";
$pgv_lang["edituser_firstname_help"]		= "~#pgv_lang[firstname]#~<br /><br />En esta caja puede cambiar su nombre de pila.  Éste es el nombre que otros usuarios ven cuando está conectado.<br /><br />Aunque la decisión de qué poner en este campo es suya, debería avisar al administrador si lo cambia.  Cuando otros ven una persona desconocida conectada, pueden preocuparse y hacer preguntas.  El administrador puede averiguarlo sin que le avise, pero debería evitarle trabajo innecesario.<br /><br />";
$pgv_lang["edituser_lastname_help"]		= "~#pgv_lang[lastname]#~<br /><br />En esta caja puede cambiar sus apellidos.  Éste es el nombre que otros usuarios ven cuando está conectado.<br /><br />Aunque la decisión de qué poner en este campo es suya, debería avisar al administrador si lo cambia.  Cuando otros ven una persona desconocida conectada, pueden preocuparse y hacer preguntas.  El administrador puede averiguarlo sin que le avise, pero debería evitarle trabajo innecesario.<br /><br />";
$pgv_lang["edituser_gedcomid_help"]		= "~#pgv_lang[gedcomid]#~<br /><br />Es un número de identificación que le vincula a sus propios datos en la base de datos.<br /><br />No puede modificar este ID, lo define el administrador.  Si piensa que este ID es incorrecto, póngase en contacto con el administrador para que lo modifique.<br /><br />";
$pgv_lang["edituser_rootid_help"]		= "~#pgv_lang[rootid]#~<br /><br />Es la persona inicial (raíz) en todos sus diagramas.<br /><br />Si, por ejemplo, hiciera clic en el vínculo al Árbol de Ascendientes, vería a esta persona inicial en la caja más a la izquierda.  Esta persona inicial no tiene por qué ser Vd., puede comenzar con cualquier persona (su abuelo o la tía de su madre, por ejemplo), siempre que tenga privilegio para ver esa persona.<br /><br />Este valor cambia la persona inicial por omisión en la mayoría de los diagramas.  Puede cambiar la persona inicial que se usa en la mayoría de los diagramas, pero sólo afecta a ese diagrama en esa ocasión en particular.<br /><br />";
$pgv_lang["edituser_password_help"]		= "~#pgv_lang[password]#~<br /><br />Es una buena costumbre cambiar la contraseña regularmente.  Debe tener presente que todo aquel que conozca su identificador de usuario y contraseña, tendrá acceso a sus datos.<br /><br />Elija una contraseña de por lo menos 6 caracteres, mejor cuanto más larga. Puede utilizar letras mayúsculas y minúsculas con o sin marcas diacríticas (como los acentos), números, guión (-) y subrayado (_).  <u>No</u> utilice signos de puntuación o espacios.  Utilice una combinación de mayúsculas, minúsculas, números y otros caracteres.  Por ejemplo: <b>5Z_q\$P4=r9</b>.<br /><br />Como el identificador de usuario, la contraseña <u>distingue</u> entre mayúsculas y minúsculas.  Esto quiere decir que <b>Contraseña.Secreta!#13<b> no es lo mismo que <b>contraseña.secreta!#13</b> ni que <b>CONTRASEÑA.SECRETA!#13</b>.<br /><br />";
$pgv_lang["edituser_conf_password_help"]	= "~#pgv_lang[confirm]#~<br /><br />Si ha modificado su contraseña, deberá confirmarla.  Esto es para asegurarse de que no cometió un error de tecleo en el campo de contraseña.<br /><br />Si la contraseña y su confirmación no son idénticas, recibirá un mensaje de error apropiado.  Tendrá que volver a teclear tanto la contraseña original y su confirmación.<br /><br />";
$pgv_lang["edituser_change_lang_help"]		= "~#pgv_lang[change_lang]#~<br /><br />Aquí puede cambiar el idioma en que PhpGedView mostrará todas sus páginas y mensajes después de que se haya identificado.<br /><br />La primera vez que accede al sitio, PhpGedView supone que quiere ver todo en el Idioma Preferido de su navegador.  Si es suposición es incorrecta, puede cambiarla aquí.  Por ejemplo, su navegador podría estar configurado para inglés porque es el idioma de mayor presencia en la Internet.  Sin embargo, para cuestiones genealógicas, preferiría ver todo en finlandés o en hebreo.  Aquí es donde puede hacerlo.<br /><br />El administrador controla qué opciones de idioma están disponibles.  Si no aparece su idioma preferido, necesita ponerse en contacto con el administrador.<br /><br />Recuerde que PhpGedView es realmente un proyecto realizado por un equipo internacional de voluntarios sin sueldo.  Los expertos van y vienen.  En consecuencia, el apoyo a idiomas distintos del inglés a veces no es tan bueno como debiera.<br /><br />Si ve a menudo algo que no se ha traducido, se ha traducido incorrectamente o podría redactarse mejor, hagáselo saber a su administrador.  El administrador sabrá cómo ponerse en contacto con el equipo de desarrollo de PhpGedView para que se atienda su asunto.  Mejor aún, aporte algo de su tiempo.  Nos vendría muy bien la ayuda.<br /><br />";
$pgv_lang["edituser_email_help"]		= "~#pgv_lang[emailadress]#~<br /><br />La dirección de correo electrónico es importante para poder contactar con Vd.<br /><br />Si obtiene una nueva dirección de correo electrónico, como suele ocurrir al cambiar de proveedor de Internet, no olvide modificar aquí su dirección aquí también.  No obtendrá ningún mensaje de confirmación de este sitio si cambia la dirección, pero los futuros mensajes para Vd. irán a la nueva dirección.<br /><br />";
$pgv_lang["edituser_user_theme_help"]		= "~#pgv_lang[user_theme]#~<br /><br />Este sitio puede ofrecer distintos aspectos o apariencias.  Otros programas pueden llamarlo \"skins\" (pieles), pero aquí se llaman \"temas\".<br /><br />Cada tema muestra los mismos datos, pero su presentación o incluso su ubicación en la pantalla puede varias.  Es como cambiar el marco a una foto y ponerla en un cuarto diferente también. La foto no cambia, pero se la mira de forma completamente diferente.<br /><br />Pruébelo. Ponga otro tema. Examínelo, pruebe otro. Vuelva al que más le agrade. Cada vez que entre, verá el último tema que usó, ni siquiera tiene que venir a esta página de configuración para cambiar su tema preferido.<br /><br />";
$pgv_lang["edituser_contact_meth_help"]		= "~#pgv_lang[user_contact_method]#~<br />PhpGedView tiene varios métodos de contacto.  El administrador determina qué método se utilizará para contactar con él o ella.  Vd. tiene control sobre el método utilizado para contactar con <u>Vd.</u>.  Dependiendo de la configuración del sitio, algunos de los métodos listados puede no estar disponible.<br />";
$pgv_lang["mail_option1_help"]			= "Seleccionando esta opción se utilizará el sistema interno de mensajería de PhpGedView y no se enviarán correos electrónicos.<br /><br />Sólo recibirá mensajes <u>internos</u> de otros usuarios.  Si otro usuario del sitio le envía un mensaje, ese mensaje aparecerá en el bloque de Mensajes de su página personal #pgv_lang[mygedview]#.  Si ha quitado este bloque de su página #pgv_lang[mygedview]#, no verá ningún mensaje.  No obstante, éstos aparecerán tan pronto como configure la página #pgv_lang[mygedview]# para volver a incluir el bloque de Mensajes.<br /><br />";
$pgv_lang["mail_option2_help"]			= "Esta opción es como la #pgv_lang[messaging]# pero, además se enviará por correo electrónico una copia del mensaje a la dirección indicada en su Cuenta.<br /><br />Es el método de contacto por omisión.<br /><br />";
$pgv_lang["mail_option3_help"]			= "Con esta opción, sólo recibirá mensajes en su dirección de correo electrónico en la dirección que configuró en la página de su Cuenta.  El sistema de mensajería interno de PhpGedView no se utilizará en absoluto y nunca habrá ningún mensaje en el bloque de Mensajes de su página personal #pgv_lang[mygedview]#.<br /><br />";
$pgv_lang["mail_option4_help"]			= "Con esta opción no recibirá ningún mensaje.  Ni siquiera el administrador podrá ponerse en contacto con Vd.<br /><br />";

//-- Admin
$pgv_lang["admin_help"]				= "En esta página encontrará vínculos a las páginas de configuración, administración, documentación y archivos de registro.<br /><br />La <b>#pgv_lang[system_time]#</b>, justo bajo el título de la página, muestra la hora del servidor en el que está alojado su sitio. Esto significa que si el servidor se encuentra en Nueva York y Vd. está en Francia, la hora mostrada parecerá estar atrasada seis horas, a menos, claro está, que el servidor esté funcionando en hora de Greenwich (GMT).  La hora mostrara es la correspondiente al momento que se accedió o refrescó la página.<br /><br /><b>ATENCIÓN</b><br />Si ve un mensaje en rojo bajo la hora del sistema, significa que su archivo <i>config.php</i> todavía es modificable.  Después de configurar su sitio debería, por razones de <b>seguridad</b>, establecer los permisos de este archivo como de sólo lectura.  Deberá realizarlo <u>manualmente</u> ya que PhpGedView no puede hacerlo por Vd.<br /><br />";

//-- User Admin
$pgv_lang["useradmin_help"]			= "~#pgv_lang[user_admin]#~<br /><br />En esta página puede administrar los usuarios actuales y agregar nuevos usuarios.<br /><br /><b>#pgv_lang[current_users]#</b><br />En esta tabla se muestran los usuarios actuales, su estado y sus privilegios.  Puede <b>eliminar</b> o <b>editar</b> usuarios.<br /><br /><b>#pgv_lang[add_user]#</b><br />Este formulario es prácticamente el mismo que el que los usuarios ven en la página <b>#pgv_lang[editowndata]#</b>.<br /><br />Para algunos temas no se redactó un texto de ayuda especial para el administrador.  En esos casos, verá el siguiente mensaje:";
$pgv_lang["useradmin_gedcomid_help"]		= "~#pgv_lang[gedcomid]#~<br /><br />El ~#pgv_lang[gedcomid]#~<br /><br /> identifica al usuario.  Tiene que ser fijado por el administrador.<br /><br />Este ID se utiliza como el ID inicial en varias páginas como <b>#pgv_lang[my_indi]#</b> y <b>#pgv_lang[my_pedigree]#</b>.<br /><br />Puede fijar el ID GEDCOM del usuario de forma diferente en cada GEDCOM.  Si un usuario no tiene registro en un GEDCOM, puede dejar el campo vacío.<br /><br />";
$pgv_lang["useradmin_rootid_help"]		= "~#pgv_lang[rootid]#~<br /><br />Para cada base de datos genealógica, se puede designar una <b>Persona inicial</b> para el usuario.<br /><br />Esta persona inicial no tiene por qué ser el usuario mismo; puede ser cualquier persona.  El usuario querrá probablemente ver el diagrama Árbol de ascendientes comenzando por sí mismo.  Esto se controla, al igual que la persona inicial por omisión en otros diagramas, aquí.<br /><br />Si el usuario tiene privilegios para modificar la información de su propia cuenta, puede cambiar este ajuste aquí por sí mismo.<br /><br />";
$pgv_lang["useradmin_can_admin_help"]		= "~#CASILLA pgv_lang[can_admin]#~<br /><br />Si se marca esta casilla, el usuario tendrá los mismos privilegios que Vd.<dl><dt>Estos privilegios incluyen:</dt><dd>Agregar / Eliminar / Modificar Usuarios</dd><dd>Enviar mensajes generales a todos los usuarios</dd><dd>Modificar los mensajes de Bienvenida</dd><dd>Modificar y configurar los archivos de idioma</dd><dt></dt><dd>Actualizar PhpGedView</dd><dd>Cambiar las configuraciones del programa y de los GEDCOMs</dd><dd>Administrar los GEDCOMs</dd><dd>Cambiar los ajustes de Privacidad</dd><dd>Y cualquier otra cosa no mencionada aquí.</dd></dl><br />El usuario <u>no puede</u> cambiar ninguna otra cosa en el servidor fuera de PhpGedView.";
$pgv_lang["useradmin_sync_gedcom_help"]		= "~CASILLA #pgv_lang[sync_gedcom]#~<br /><br />Si está marcada esta casilla y el usuario tiene un ID de registro GEDCOM asignado, sus ajustes de cuenta se sincronizarán automáticamente con sus datos GEDCOM.  Esto significa que si se modifica el registro GEDCOM del usuario, alguna información como la dirección de correo electrónico y el nombre se copiarán a la cuenta del usuario.  Si se edita la cuenta del usuario, la información correspondiente se copiará al registro GEDCOM.";
$pgv_lang["useradmin_can_edit_help"]	= "~#pgv_lang[can_edit]#~<br /><br />El usuario puede tener diferentes privilegios de acceso y modificación en cada base de datos genealógica del sistema.<ul><li><b>#pgv_lang[none]#:</b> El usuario no puede acceder a los datos privados de este GEDCOM.</li><li><b>#pgv_lang[access]#:</b> El usuario no puede modificar o aceptar datos a la base de datos, pero puede ver los datos privados.</li><li><b>#pgv_lang[edit]#:</b> El usuario puede modificar valores pero otro usuario con privilegios de <b>#pgv_lang[accept]#</b> deberá aprobar los cambios antes de ser agregados a la base de datos y hechos públicos.</li><li><b>#pgv_lang[accept]#:</b> El usuario puede modificar.  También puede modificar y aprobar los cambios hechos por otros usuarios.</li><li><b>#pgv_lang[admin_gedcom]#:</b> El usuarios puede modificar los ajustes de configuración privacidad para <u>este</u> GEDCOM.</li></ul>Los administradores del sistema, identificados mediante la casilla <b>#pgv_lang[can_admin]#</b>, reciben automáticamente privilegios de <b>#pgv_lang[admin_gedcom]#</b>.<br /><br />";
$pgv_lang["useradmin_verified_help"]		= "~#pgv_lang[verified]#~<br /><br /><b>Autorregistro</b><br />Un usuario puede solicitar una nueva cuenta por medio del módulo de <b>Autorregistro</b>.<br />Si lo hace, recibirá un mensaje de correo electrónico con un vínculo para verificar su solicitud.  Una vez el solicitante haya seguido las instrucciones enviadas en el mensaje, podrá ver esta casilla marcada y podrá continuar con el siguiente paso, <b>#pgv_lang[verified_by_admin]#</b>.  Debería esperar a dar su aprobación hasta que aparezca marcada esta casilla.<br /><br /><b>Agregar usuario manualmente</b><br />Si usa este formulario para agregar un usuario manualmente, encontrará esta casilla ya marcada.<br /><br />";
$pgv_lang["useradmin_verbyadmin_help"]		= "~#pgv_lang[verified_by_admin]#~<br /><br />Si un usuario ha utilizado el módulo de Autoverificación y se ha  verificado, el último paso antes de que su cuenta sea activa, es la aprobación del administrador.<br /><br />Después de que haya aprobado la solicitud de la nueva cuenta, el usuario recibirá un correo electrónico.  El mensaje le informará de que su cuenta ya está activa.  A partir de entonces, puede entrar identificándose con el Nombre de Usuario y Contraseña que dio cuando solicitó la cuenta.<br /><br />";
$pgv_lang["useradmin_edit_user_help"]		= "~#pgv_lang[update_user]#~<br /><br />Este formulario lo utiliza el administrador para modificar una cuenta de usuario.<br /><br />El formulario es muy similar a los formularios b>#pgv_lang[add_user]#</b> y <b>#pgv_lang[update_myaccount]#</b>.<br /><br />";
$pgv_lang["useradmin_visibleonline_help"]		= "~VISIBLE SI CONECTADO~<br /><br />Esta casilla controla su visibilidad frente a otros usuarios mientras se encuentra conectado.  También controla su capacidad de ver a otros usuarios configurados como visibles.<br /><br />Si esta casilla no está marcada, Vd. será completamente invisible a otros usuarios y Vd. tampoco podrá ver a otros usuarios conectados.  Si se marca esta casilla, el resultado es exactamente el contrario.  Vd. será visible a otros usuarios y, además, podrá ver a otros usuarios que estén configurados como visibles.<br /><br />";
$pgv_lang["useradmin_editaccount_help"]			= "~MODIFICAR INFORMACIÓN DE LA CUENTA~<br /><br />Si marca esta casilla, este usuario podrá modificar algunos datos de su cuenta.  Aunque generalmente no se recomienda, puede crear una cuenta compartida para varios usuarios.  Esta opción le permite impedir que esos usuario modifique la información de la cuenta compartida.<br /><br />";
$pgv_lang["useradmin_relation_priv_help"]		= "~#pgv_lang[user_relationship_priv]#~<br /><br />Si se marca esta casilla, al usuario sólo se permitirá el acceso a las personas vivas con las que esté emparentado.  Podrán ver a cualquiera que esté dentro de la distancia o longitud de la ruta de parentesco fijada por su ajuste <i>#pgv_lang[user_path_length]#</i>.  Puede requerir que se controle el acceso por parentesco para todos los usuarios activando la opción global en los ajustes de privacidad del GEDCOM.<br /><br />Este ajuste requiere que el usuario esté asociado con un ID GEDCOM para poder ver personas vivas.<br /><br />";
$pgv_lang["useradmin_path_length_help"]			= "~#pgv_lang[user_path_length]#~<br /><br />Si se activa <i>#pgv_lang[user_relationship_priv]#</i>, este usuario sólo podrá ver o editar personas vivas a menos de este número de pasos de parentesco.<br /><br />";
$pgv_lang["useradmin_auto_accept_help"]			= "~#pgv_lang[user_auto_accept]#~<br /><br />Marcando esta casilla permite al sistema aceptar automáticamente cualquier cambio hecho por este usuario.  El usuario debe tener también el privilegio de aceptar cambios en el GEDCOM para que este ajuste surta efecto.<br /><br />";

//-- Manage Sites
$pgv_lang["help_managesites"] 			= "~GESTIONAR SITIOS~<br /><br />En esta página puede agregar sitios remotos y bloquear direcciones IP.<br /><br />Los sitios remotos se puede agregar proporcionando el título del sitio, su URL, identificador de la base de datos (opcional), usuario y contraseña para el servicio web remoto.<br /><br />El bloqueo de direcciones IP se consigue proporcionando cualquier rango de direcciones IP válido. Por ejemplo, 212.10.*.*  Los sitios remotos dentro del los rangos de direcciones IP bloqueados no podrán acceder a su servicio web.  Puede bloquear direcciones IP específicas también.";
//-- Adding Remote Links
$pgv_lang["help_remotesites"]			= "~Agregar sitios remotos~<br /><br />Para agregar un sitio remoto, introduzca el título del sitio, la URL del servicio web remoto, el id de la base de datos (opcional) y el usuario y contraseña. Haga clic en el botón Agregar para completar el proceso.  Si el servidor remoto permite autenticación anónima, debería dejar el usuario y contraseña en blanco.";
//-- IP Address Banning
$pgv_lang["help_banning"]				= "~Exclusión de direcciones IP~<br /><br />Para excluir sitios remotos del acceso a su servicio web, proporcione una dirección IP específica o un rango de direcciones IP válido, por ejemplo, 212.10.*.* y haga clic en el botón Enviar.";
$pgv_lang["help_manual_search_engines"]				= "~Etiquetado manual de arañas de motores de búsqueda~<br /><br />PhpGedView proporciona automáticamente a los motores de búsqueda archivos de datos más pequeños con menos vínculos.  Los datos se limitan a los de la persona y su familia inmediata, sin incluir información de abuelos o nietos.  Muchos informes y páginas costosas para el servidor como el calendario quedan inaccesibles a las arañas.<br /><br />Si un motor de búsqueda no es reconocido automáticamente y desea proporcionarle datos para indexar, puede listarlo aquí. Si no desea proporcionarle datos, puede listarlo más abajo en la sección de IPs excluidas.<br /><br />Si desea ver qué datos se entregan a los motores de búsqueda, puede incluir su propia dirección aquí.  <font color=\"red\">ADVERTENCIA:</font> Hacer esto le dejará sin acceso a la interfaz de administración y tendrá que eliminar la IP conectándose desde otra máquina o modificando manualmente el archivo <i>/index/search_engines.php</i>.<br /><br />Para etiquetar manualmente un sitio remoto como araña de motor de búsqueda, introduzca una dirección IP específica o un rango IP válido, por ejemplo, 212.10.*.* y haga clic en el botón Enviar.  Muchos motores de búsqueda populares como Google y Yahoo se detectarán automáticamente.";

//-- Search_engines.php
$pgv_lang["search_engine_landing_page"]		= "~Detectado motor de búsqueda~<br /><br />PhpGedView proporciona automáticamente a los motores de búsqueda archivos de datos más pequeños con menos vínculos.  Los datos se limitan a la persona y su familia inmediata, sin agregar información de sus abuelos o nietos.  Muchos informes y páginas que requieren mucho trabajo del servidor como el calendario son inaccesibles para las arañas.<br /><br />Si las arañas intentan ir a esas páginas, obtendrán esta página.  Si está viendo este texto, el programa cree que Vd. es una araña de motor de búsqueda.  Más abajo se muestra la lista de páginas que se permite explorar a las arañas y que proporcionan los datos abreviados.<br /><br />Los usuarios auténticos que sigan los vínculos de los motores de búsqueda que apunten a este sitio verán las páginas completas con todos sus datos en vez de esta página.";

//-- G E D C O M
$pgv_lang["add_upload_gedcom_help"]		= "~OPCIONES SUBIR Y AÑADIR~<dl><dt><b>Subir archivos GEDCOM</b></dt><dd>Se pueden subir archivos en línea.  Puede subir el archivo desde cualquier lugar, sin la necesidad de un programa FTP.</dd><dt><b>Añadir archivos GEDCOM</b></dt><dd>Si el archivo ya existe en su directorio GEDCOM, puede usarlo sin necesidad de subirlo.  Algunas veces es necesario utilizar Añadir en lugar de Subir por el tamaño del archivo.</dd></dl>Los procesos Añadir y Subir se realizan en cuatro simples pasos.<br />Sólo el primer paso es diferente entre ambos procedimientos.<br /><br />";
$pgv_lang["gedcom_configfile_help"]		= "~ARCHIVO DE CONFIGURACIÓN GEDCOM~<br /><br />Es el archivo en el que se guardan todos los ajustes básicos de la base de datos genealógica.  Hay un archivo separada para cada base de datos.<br /><br />Encontrará la ruta y nombre de cada archivo de configuración en la tabla <b>#pgv_lang[current_gedcoms]#</b> de la página <b>#pgv_lang[gedcom_adm_head]#</b>.<br /><br />";
$pgv_lang["default_gedcom_help"]		= "~GEDCOM POR OMISIÓN~<br /><br />Si tiene más de una base de datos genealógica, puede establecer aquí cuál se usará por omisión.<br /><br />Esta base de datos por omisión es la que se mostrará a todos los visitantes y usuarios que no se hayan identificado aún.<br /><br />Los usuarios pueden modificar los ajustes de su cuenta para elegir otra base de datos.  En eso caso, la base de datos preferida por el usuario es la que se mostrará en cuanto se identifique.<br /><br />";
$pgv_lang["delete_gedcom_help"]			= "~BORRAR GEDCOM~<br /><br />PhpGedView crea su base de datos a partir de un archivo GEDCOM que se subió previamente. Si selecciona <b>Borrar</b>, esa sección de la base de datos se borrará.  Tiene que confirmar su solicitud de Borrado.<br /><br />A menos que lo haya eliminado deliberadamente fuera de PhpGedView, el archivo original GEDCOM permanecerá en el directorio al que fue subido.  Si posteriormente quiere trabajar con ese archivo GEDCOM de nuevo, no necesita subirlo otra vez. Puede elegir la función <b>#pgv_lang[add_gedcom]#</b>.<br /><br />";
$pgv_lang["add_gedcom_help"]			= "~#pgv_lang[add_gedcom]#~<br /><br />Si utiliza la función <b>#pgv_lang[add_gedcom]#</b>, se supone que ya ha subido el archivo GEDCOM a su servidor mediante un programa o método <u>externo</u> a PhpGedView, por ejemplo, <i>ftp</i> o <i>conexión a red</i>.  El archivo que desea agregar también podría ser un resto de un procedimiento previo de <b>#pgv_lang[upload_gedcom]#</b>.<br /><br />Si el archivo GEDCOM de entrada no existe aún en el servidor, <u>tiene que</u> colocarlos allí lo primero, antes de que pueda comenzar a Agregar.<br /><br />En vez de subir un archivo GEDCOM, puede subir un archivo ZIP que contenga el archivo GEDCOM, bien con PhpGedView, bien usando un programa externo. PhpGedView reconocerá el archivo ZIP automáticamente y extraerá el archivo GEDCOM y su nombre del archivo ZIP.<br /><br />Si ya existe un archivo GEDCOM con el mismo nombre en PhpGedView, será sobrescrito. No obstante, todos los ajustes de GEDCOM hechos con anterioridad se conservarán.<br /><br />Recibirá guía paso a paso durante todo el proceso.<br /><br />";
$pgv_lang["add_new_gedcom_help"]		= "~#pgv_lang[add_new_gedcom]#~<br /><br />Puede comenzar una nueva base de datos genealógica desde cero.<br /><br />Esto procedimiento requiere sólo unos pocos pasos sencillos. El primer paso es diferente de lo que ya conoce acerca de cargar y agregar. Los otros pasos resultarán familiares.<ol><li><b>Dar nombre al nuevo  GEDCOM</b><br />Teclee el nombre del nuevo GEDCOM <u>sin</u> la extensión <b>.ged</b>. El nuevo archivo se creará en el directorio indicado encima del campo donde introdujo el nombre.  Haga clic en <b>Agregar</b>.</li><li><b>Página de configuración</b><br />Ya conoce esta página;  aquí configura los ajustes para su nuevo archivo GEDCOM.</li><li><b>Validar</b><br />Ya conoce esta página; se comprueba el nuevo GEDCOM.  Puesto que no hay nada en él, será aceptado como válido.</li><li><b>Importación de registros</b><br />Puesto que sólo habrá un registro que importar, este paso terminará muy rápidamente.</li></ol>Eso es todo.  Ahora puede ir al Árbol de Ascendientes para ver su primera persona en el nuevo GEDCOM.  Haga clic en el nombre de la persona y comience a modificar.  Tras eso, puede vincular nuevas personas a la primera.<br /><br />";
$pgv_lang["download_gedcom_help"]		= "~#pgv_lang[download_gedcom]#~<br /><br />Desde esta página puede descargar su base de datos genealógica en formato GEDCOM.  Puede desear importar los datos a otro programa genealógico o puede desear compartir la información con otros.<br /><br />#pgv_lang[utf8_ansi_help]#<br /><br />#pgv_lang[remove_tags_help]#<br /><br />#pgv_lang[download_zipped_help]#";
$pgv_lang["edit_gedcoms_help"]			= "~#pgv_lang[gedcom_adm_head]#~<br /><br />La página #pgv_lang[gedcom_adm_head]# es el centro de control para la administración de todas sus bases de datos genealógicas.<br /><br /><b>#pgv_lang[current_gedcoms]#</b><br />En el encabezamiento de la tabla <b>#pgv_lang[current_gedcoms]#</b>, puede ver una barra de acciones con cuatro vínculos.<ul><li>#pgv_lang[add_gedcom]#</li><li>#pgv_lang[upload_gedcom]#</li><li>#pgv_lang[add_new_gedcom]#</li><li>#pgv_lang[lang_back_admin]#</li></ul>En la tabla <b>#pgv_lang[current_gedcoms]#</b>, cada base de datos genealógica se lista por separado y tiene las siguientes opciones para cada una de ellas:<ul><li>Importar</li><li>Borrar</li><li>Descargar</li><li>Modificar configuración</li><li>Modificar privacidad</li><li>Archivos SearchLog</li></ul>Aparece aquí Modificar privacidad porque cada GEDCOM tiene su propio archivo de privacidad.<br /><br />Cada línea de la tabla debería ser autoexplicativa.  PhpGedView puede configurarse para llevar un registro de todas las búsquedas en la bases de datos en archivos SearchLog.  Se pueden inspeccionar los archivos SearchLog mediante los vínculos que se encuentran en esta página.<br />#pgv_lang[more_help]#<br />";
$pgv_lang["edit_config_gedcom_help"]		= "~CONFIGURAR GEDCOM~<br /><br />Cada base de datos genealógica utilizada con PhpGedView tiene su propio <b>archivo de configuración<b>.<br /><br />En este formulario se configuran muchas opciones como el título de la base de datos, el idioma, el formato de calendario, opciones de correo electrónico, registro de búsquedas en la base de datos, cabeceras HTML META, supresión de apellidos de la lista de Apellidos Frecuentes de la base de datos, etc.<br /><br />";
$pgv_lang["import_gedcom_help"]			= "~IMPORTAR GEDCOM~<br /><br />En la mayoría de los casos la importación de un archivo GEDCOM creado externamente es uno de los pasos en los procedimientos de introducción de cambios masivos a la base de datos genealógica.<br /><br />Estos pasos siguen una secuencia lógica y deben realizarse en el orden prescrito para que la base de datos genealógica quede en estado utilizables.<br /><br />Si, por alguna razón, no completó estos pasos en el orden correcto, verá un mensaje de <u>atención</u> avisando de que el GEDCOM no se ha importado aún.  Para corregir el problema, haga clic en el vínculo <b>Importar GEDCOM</b> para importar el archivo.<br /><br />Los ajustes de configuración del GEDCOM existentes no cambiarán si reimporta un GEDCOM.  Los datos existentes, sin embargo, se sobrescribirán.<br /><br />";
$pgv_lang["upload_gedcom_help"]			= "~#pgv_lang[upload_gedcom]#~<br /><br />A diferencia de la función <b>#pgv_lang[add_gedcom]#</b>, el archivo GEDCOM que desea agregar a su base de datos no tiene que estar en su servidor.<br /><br />En el Paso 1 seleccionará un archivo GEDCOM de su propio equipo local. Introduzca la ruta completa y el nombre del archivo en el campo de texto o utilice el botón <b>Examinar</b> disponible en la página.<br /><br />También puede utilizar esta función para subir un archivo ZIP que contenga su archivo GEDCOM. PhpGedView reconocerá el archivo ZIP y extraerá el archivo GEDCOM de su interior automáticamente.<br /><br />Si ya existe un archivo GEDCOM file con el mismo nombre en PhpGedView, resultará sobrescrito tras pedir confirmación. Sin embargo, todos los ajustes del GEDCOM hechos previamente se conservarán.<br /><br />Encontrará más ayuda en otras páginas del procedimiento.<br /><br />";
$pgv_lang["validate_gedcom_help"]		= "~VALIDAR GEDCOM~<br /><br />Es el tercer paso en el procedimiento para agregar datos GEDCOM creados externamente a su base de datos genealógica.<br /><br />PhpGedView comprobará en el archivo de entrada el correcto uso de los formatos de Fecha, formatos de Lugar, Juego de Caracteres, etc.  Algunas de las desviaciones del estándar GEDCOM 5.5.1, al que PhpGedView se adhiere, puede corregirse automáticamente. Por ejemplo, las terminaciones de línea de los equipos Macintosh y el uso incorrecto del formato de Lugar.  En esos casos, verá un mensaje indicando que los datos se han modificado.  Para otras anomalías, verá un mensaje de advertencia con la solución recomendada.<br /><br /><b>Herramientas opcionales</b><br />En este momento sólo existe una herramienta adicional:<br /><b>Cambiar el ID de las personas a...</b>.<br />#pgv_lang[more_config_help]#<br />";
$pgv_lang["convert_ansi2utf_help"]		= "~CONVERTIR ANSI A UTF-8~<br /><br />Para asegurarse que el programa opera correctamente con sus archivos GEDCOM, deberían estar codificados en UTF-8.<br /><br />Muchos programas de Genealogía tienen la opción de exportar un archivo GEDCOM con esta codificación UTF-8.<br />Si el programa que utiliza no ofrece la opción, PhpGedView puede convertirlo.<br /><br />Cuando PhpGedView valida un archivo grabado (o añadido) detectará si el archivo tiene codificación ANSI.";
$pgv_lang["detected_ansi2utf_help"]		= "~DETECTADA CODIFICACIÓN ANSI~<br /><br />El archivo GEDCOM que está siendo validado, tiene codificación ANSI.  Se recomienda encarecidamente que esta codificación se convierta a UTF-8.<br /><br /><br />#pgv_lang[convert_ansi2utf_help]#";
$pgv_lang["detected_date_help"]			= "~SE DETECTÓ UN FORMATO DE FECHA INCORRECTO:~<br /><br /><b>SE MODIFICARÁ EL FORMATO DE LA FECHA</b><br /><br />El formato de fecha estándar para PhpGedView conforme al estándar GEDCOM 5.5.1 es <b>DD&nbsp;MMM&nbsp;AAAA</b> (p.ej. 01&nbsp;JAN&nbsp;2004)<br /><br />Si observa, después de la validación del GEDCOM, un mensaje indicando la detección de formatos de fecha incorrectos, PhpGedView convertirá las fechas de formato incorrecto conforme al estándar.<br /><br />No obstante tiene la opción de elegir \"<b>día</b> antes del mes\" (DD&nbsp;MMM&nbsp;AAAA) o bien \"<b>mes</b> antes del día\" (MMM&nbsp;DD&nbsp;AAAA).<br /><br />Se recomienda la elección del primer formato (día antes del mes).<br /><br />";
$pgv_lang["change_indi2id_help"]		= "~CAMBIAR EL ID DE LAS PERSONAS A ....~<br /><br />Esta herramienta se diseñó para los usuarios cuyos programas de genealogía utilizan un ID GEDCOM para las personas diferente cada vez que se exporta el GEDCOM. Por ejemplo, la primera vez que se exporta el GEDCOM el ID de una persona podría ser I100 y las siguiente vez que se exporta, el ID de la misma persona podría ser I234. Estos IDs cambiantes dificultan la administración de PhpGedView porque por el ID es como se hace referencia a las personas.<br /><br />La mayoría de los programas de genealogía utilizan también las etiquetas RIN o REFN para dar a cada persona un identificador único que puede utilizarse para hacer referencia a la persona.  Esta herramienta sustituirá todos los IDs de personas del archivo GEDCOM por el campo (RIN o REFN) que Vd. especifique.<br /><br />";
$pgv_lang["edit_privacy_help"]			= "En esta página puede realizar todos los ajustes de Privacidad para el GEDCOM seleccionado.<br /><br />Puede comprobar bajo el título de la página si está modificando el archivo de privacidad correcto.  Se muestra así: (ruta/nombredesugedcom_priv.php)<br /><br />Si necesita más ajustes, puede hacer cambios al archivo de privacidad manualmente.  Puede leer más sobre esto en el sitio web de PhpGedView.<br /><br />";
$pgv_lang["BOM_detected_help"]			= "~Detectada marca de orden de octetos (BOM)~<br /><br />El archivo GEDCOM que está importando tiene un código especial de 3 octetos al principio.  Este código especial es utilizado por algunos programas para indicar que el archivo se ha grabado con la codificación de caracteres UTF-8.<br /><br />Aunque este código especial no es realmente un error, PhpGedView no funcionará correctamente si el archivo de entrada lo contiene.  Debería permitir a PhpGedView eliminar el código.<br /><br />";
$pgv_lang["invalid_header_help"]		= "~ENCABEZAMIENTO GEDCOM INVÁLIDO~<br /><br />Un archivo GEDCOM debe comenzar por <b>0&nbsp;HEAD</b>. PhpGedView detectó que el archivo GEDCOM que está importando no tiene <b>0&nbsp;HEAD</b> como primera línea. Si hace clic en el botón Limpiar, se eliminarán todas las líneas anteriores a la primera línea <b>0&nbsp;HEAD</b>.<br /><br />Este error normalmente significa que el programa utilizado para crear el archivo GEDCOM no funciona adecuadamente o que éste no es un archivo GEDCOM. Debería asegurarse de que ha subido el archivo correcto y que éste comienza con la línea <b>0&nbsp;HEAD</b> y finaliza con la línea <b>0&nbsp;TRLR</b>.<br /><br />";
$pgv_lang["macfile_detected_help"]		= "~DETECTADO ARCHIVO MACINTOSH~<br /><br />PhpGedView detectó que su archivo GEDCOM fue creado en una computadora Macintosh.<br /><br />Los archivos de Macintosh terminan cada línea con un código de control CR.  CR es Ctrl+M.<br />Los archivos Unix terminan cada línea con un código de control LF.  LF es Ctrl+J.<br />Windows y DOS utilizan una secuencia de dos códigos, CR seguido de LF.<br /><br />PhpGedView requiere que todos los archivos utilicen terminación de línea Unix o DOS. Si hace clic en el botón Limpiar, sus terminaciones de línea se convertirán apropiadamente.<br /><br />";
$pgv_lang["cleanup_places_help"]		= "~LIMPIEZA DE LUGARES~<br /><br />PhpGedView detectó que su archivo GEDCOM contiene lugares en etiquetas GEDCOM que no deberían tenerlos. Muchos programas de genealogía, tales como el Family Tree Maker, crean archivos GEDCOM de este tipo. PhpGedView funciona con este tipo de archivos pero mostrará algunos lugares incorrectos en la jerarquía de lugares.<br /><br />Por ejemplo, su archivo GEDCOM puede contener la siguiente codificación:<br />1 SSN<br />2 PLAC 123-45-6789<br />Según la especificación GEDCOM esto debería estar escrito así:<br />1 SSN 123-45-6789<br />Al seleccionar <b>Sí</b> PhpGedView automáticamente detectará y corregirá estos errores de codificación.";
$pgv_lang["empty_lines_detected_help"]	= "~LÍNEAS VACÍAS DETECTADAS~<br /><br />PhpGedView detectó que hay líneas vacías en su archivo GEDCOM. Estas líneas pueden causar errores y se eliminarán antes de importar el archivo GEDCOM.<br /><br />";

//-- Edit Config
$pgv_lang["help_editconfig.php"]		= "~CONFIGURAR PhpGedView~<br /><br />En esta página se configuran los ajustes globales de PhpGedView.  Tiene que hacer esto tras instalar PhpGedView al ejecutarlo por primera vez.<br /><br />#pgv_lang[review_readme]#Como estos ajustes son <b>globales</b>, afectan a todo el programa y a todas las bases de datos genealógicas que utilice con PhpGedView.<br /><br />Cada base de datos genealógica también tiene opciones adicionales de configuración que se fijan tras hacer clic en el vínculo <b>#pgv_lang[admin_gedcoms]#</b> en esta página.<br /><br />También puede acceder a la función #pgv_lang[gedcom_adm_head]# desde la página principal de Administración, cuyo vínculo se encuentra bajo el icono #pgv_lang[mgv]# en el encabezamiento de la mayoría de las páginas.  En la página de Administración, el vínculo relevante se llama <b>#pgv_lang[manage_gedcoms]#.</b><br /><br />";

//-- merge records
$pgv_lang["help_edit_merge.php"]		= "~#pgv_lang[merge_records]#~<br /><br />Esta página le permite mezclar dos registros GEDCOM del mismo archivo GEDCOM.<br /><br />Esto es útil para las personas que han mezclado dos archivos GEDCOM y tienen ahora muchas personas, familias y fuentes duplicadas.<br /><br />El proceso consiste en tres pasos.<br /><ol><li>Debe introducir dos IDs GEDCOM.  Los IDs <u>deben</u> ser del mismo tipo.  No puede mezclar una persona y una familia o una familia y una fuente, por ejemplo.<br />En el campo <b>#pgv_lang[merge_to]#</b> introduzca el ID del registro que quiere que sea el nuevo registro tras completar la mezcla.<br />En el campo <b>#pgv_lang[merge_from]#</b> introduzca el ID del registro cuya información se mezclará con la del registro #pgv_lang[merge_to]#.  Este registro se borrará después de la mezcla.</li><li>Puede seleccionar qué datos quiere conservar de los dos registros al mezclarlos.  Simplemente marque las casillas junto a los datos que desee conservar.</li><li>Después, inspeccione los resultados de la mezcla, igual que con otros cambios introducidos.</li></ol>Algún usuario con derechos de Aceptar tendrá que autorizar los cambios para que se hagan permanentes.<br />";

//-- report engine
$pgv_lang["help_reportengine.php"]	= "~INFORMES~<br />Las entradas en el menú de informes generan archivos PDF listos para imprimir.<br /><br />El primer paso es elegir un informe de la lista.  Tras haberlo hecho, se le pedirá que proporcione alguna información específica de ese informe como con qué persona o familia comenzar y si mostrar o no las fotos.  Cuando esté listo para realizar el informe, haga clic en el botón <b>#pgv_lang[download_report]#</b> para descargar el informe a su equipo.<br /><br /><br />#pgv_lang[help_xml_reports]#<br />#pgv_lang[def_pdf_format_help]#<br />#pgv_lang[help_ahnentafel.xml]#<br />#pgv_lang[help_birthlist.xml]#<br />#pgv_lang[help_relativelist.xml]#";
$pgv_lang["def_pdf_format_help"]	= "~FORMATO DE ARCHIVO PDF~<br />El Motor de Informes de PhpGedView produce informes descargables en el formato PDF de Adobe&reg;.  La especificación del estándar GEDCOM 5.5.1, mencionada en otros lugares de este archivo de Ayuda, también puede descargarse como un archivo PDF.  PDF es la abreviatura de <b>P</b>ortable <b>D</b>ocument <b>F</b>ormat.<br /><br />Los archivos PDF no pueden visualizarse con el software estándar de su PC.  Si ya tiene instalado Acrobat Reader (a menudo viene con otros programas), no necesita sustituirlo o actualizarlo para visualizar los archivos producidos por PhpGedView.<br /><br />Acrobat Reader, el programa de visualización e impresión de estos archivos, puede obtenerse libre de cargo de Adobe Systems Inc.  El lector gratuito Adobe&reg; Acrobat Reader puede descargarse del sitio web de <a href=\"http://www.adobe.com/products/acrobat/readstep2.html\" target=\"_blank\"><b>Adobe Systems Inc.</b></a>.  Puede encontrar copias de \"Acrobat Reader\" descargables de otros sitios de Internet, pero recomendamos encarecidamente que confíe <u>sólo</u> en el sitio de Adobe Systems Inc.<br /><br />Acrobat Reader está disponible para muchos sistemas distintos, incluyendo Microsoft&reg; Windows y Apple&reg; Macintosh, en muchos idiomas además del inglés.  Si tiene un sistema Windows 95, asegúrese de descargar Acrobat Reader versión 5.0.5.  Versiones más recientes que la mencionada no se instalarán correctamente en los sistemas Windows 95.<br /><br /><a href=\"http://www.adobe.com/products/acrobat/readstep2.html\" target=\"_blank\"><b>Descargar Adobe Reader aquí</b></a><br /><br />";
$pgv_lang["help_ahnentafel.xml"]	= "~#pgv_lang[ahnentafel_report]#~<br />Es un informe de la persona seleccionada y sus ascendientes en forma de libreta.  Comienza con la primera persona, continúa con sus padres y sigue con sus abuelos, etc.<br /><br />Nótese que el informe Ahnentafel sólo está disponible en inglés en este momento.<br /><br />";
$pgv_lang["help_birthlist.xml"]		= "~#pgv_lang[birth_report]#~<br />Con este informe puede listar todas las personas que nacieron en cierta época o cierto lugar.<br /><br />";
$pgv_lang["help_relativelist.xml"]	= "~#pgv_lang[relatives_report]#~<br />Este informe lista todos los parientes de una persona seleccionada.  Puede elegir cuáles de sus parientes se muestran en el informe.<ul><li><b>#pgv_lang[child-family]#</b> muestra la persona seleccionada, sus padres y sus hermanos.</li><li><b>#pgv_lang[spouse-family]#</b> lista la persona con sus cónyuges e hijos.</li><li><b>#pgv_lang[direct-ancestors]#</b> muestra la persona, sus padres, abuelos, bisabuelos, etc. hasta incluir todos sus ascendientes.</li><li><b>#pgv_lang[ancestors]#</b> lista todas las personas de la lista #pgv_lang[direct-ancestors]# pero se incluyen también los tíos, tíos abuelos, etc., es decir, los hermanos de todos los ascendientes de esta persona.  No lista los hijos de estos tíos.</li><li><b>#pgv_lang[descendants]#</b> lista todos los descendientes de esta persona (hijos, nietos, bisnietos, etc).</li><li><b>#pgv_lang[all]#</b> esta opción es un combinación las opciones #pgv_lang[descendants]# y #pgv_lang[ancestors]# en un mismo informe.</li></ul><br /><br />";
$pgv_lang["help_xml_reports"]	= "~Motor de Informes~<br />El Motor de Informes de PhpGedView utiliza archivos plantilla XML para generar automáticamente informes PDF.<br /><br />Los informes disponibles en la lista <b>#pgv_lang[select_report]#</b> se generan automáticamente a partir de los archivos XML encontrados en el directorio \"reports\".  Puede crear sus propios informes haciendo una copia de cualquiera de las plantillas que se proporcionan y modificándola.  Para añadir su informe personalizado, póngalo en el directorio \"reports\" y PhpGedView lo detectará automáticamente y lo añadirá a la lista desplegables <b>#pgv_lang[select_report]#</b>.<br /><br />";

//-- Help Contents
$pgv_lang["help_contents_head_help"]		= "<b>TEMAS DE AYUDA</b><br /><br />";
$pgv_lang["help_contents_gedcom_info"]		= "Información del GEDCOM";
$pgv_lang["help_contents_gedcom_places"]	= "Lugares en el GEDCOM";

//-- Admin Help Contents Items
$pgv_lang["admin_help_contents_head_help"]	= "<b>TEMAS DE AYUDA<br /><br />TEMAS DE AYUDA DEL ADMINISTRADOR</b> agregados al comienzo de la lista.<br /><br />";
// $pgv_lang["ah1_help"]				= "_Upgrade";
$pgv_lang["ah2_help"]				= "_Configurar PhpGedView";
$pgv_lang["ah3_help"]				= "_GEDCOM: Añadir comparado con Subir";
$pgv_lang["ah4_help"]				= "_GEDCOM: Archivo de configuración";
$pgv_lang["ah5_help"]				= "_GEDCOM: Por omisión";
$pgv_lang["ah6_help"]				= "_GEDCOM: Borrar";
$pgv_lang["ah7_help"]				= "_GEDCOM: Añadir";
$pgv_lang["ah8_help"]				= "_GEDCOM: Crear nuevo";
$pgv_lang["ah9_help"]				= "_GEDCOM: Grabar";
$pgv_lang["ah10_help"]				= "_GEDCOM: Página de administración";
$pgv_lang["ah11_help"]				= "_GEDCOM: Configurar";
$pgv_lang["ah12_help"]				= "_GEDCOM: Importar";
$pgv_lang["ah13_help"]				= "_GEDCOM: Grabar";
$pgv_lang["ah14_help"]				= "_GEDCOM: Validar";
$pgv_lang["ah15_help"]				= "_GEDCOM: Convertir ANSI a UTF-8";
$pgv_lang["ah16_help"]				= "_GEDCOM: Opciones de Privacidad";
$pgv_lang["ah17_help"]				= "_Administración de Usuarios";
$pgv_lang["ah18_help"]				= "_Administración";
$pgv_lang["ah19_help"]				= "_GEDCOM: Herramienta de objetos audiovisuales";
$pgv_lang["ah20_help"]				= "_GEDCOM: Cambiar el ID personal a ........";
$pgv_lang["ah21_help"]				= "_Archivos de Idioma";
//           22 is in the help_text_vars.php
$pgv_lang["ah23_help"]				= "_Configurar los idiomas contemplados";
$pgv_lang["ah24_help"]				= "_Migración de Información de Usuarios (Índice --&gt;&gt; SQL)";
$pgv_lang["ah25_help"]				= "_Copia de seguridad PhpGedView";
$pgv_lang["ah26_help"]				= "_Preguntas Frecuentes: Modificar";

//--Statistics Help
$pgv_lang["help_statisticsplot.php"] = "~Gráfico estadístico~<br /><br />Ésta es la página de resultados que muestra el gráfico estadístico de su base de datos definido por las opciones de la página anterior.<br /><br />";
$pgv_lang["help_statistics.php"] = "~Gráfico estadístico~<br /><br />Esta página le permite determinar los criterios para la producción de un gráfico con diversas estadísticas de su base de datos.<br /><br />";
$pgv_lang["stat_help"]		= "~OPCIONES PARA LAS GRÁFICAS ESTADÍSTICAS~<br /><br />Se pueden producir diversas gráficas estadísticas de su base de datos.<br /><br />Seleccione los parámetros en las cajas desplegables y ajuste las opciones de la segunda sección apropiadamente.<br /><br />Los números incluidos en cada gráfica depende de los datos disponibles. Por ejemplo, las personas sin mes de nacimiento (p.ej. sólo '1856') no se pueden incluir en una gráfica de nacimientos por mes.<br /><br />";
$pgv_lang["stat_help_x"]		= "~OPCIONES PARA LAS GRÁFICAS ESTADÍSTICAS~<br /><br />~EJE X~<br />Se pueden utilizar las siguientes opciones para el eje X (horizontal). Se presenta a continuación cada una según las opciones adicionales fijadas para los ejes Y y Z.<p style=\"padding-left: 25px\"><b>#pgv_lang[stat_11_mb]#</b>&nbsp;&nbsp;personas nacidas cada mes.<br /><b>#pgv_lang[stat_12_md]#</b>&nbsp;&nbsp;personas fallecidas cada mes.<br /><b>#pgv_lang[stat_13_mm]#</b>&nbsp;&nbsp;matrimonios cada mes.<br /><b>#pgv_lang[stat_14_mb1]#</b>&nbsp;&nbsp;primogénitos cada mes.<br /><b>#pgv_lang[stat_15_mm1]#</b>&nbsp;&nbsp;primeros matrimonios por mes.<br /><b>#pgv_lang[stat_16_mmb]#</b>&nbsp;&nbsp;meses entre matrimonio y nacimiento del primogénito de una pareja.<br /><b>#pgv_lang[stat_17_arb]#</b>&nbsp;&nbsp;edad de defunción por época de nacimiento.<br /><b>#pgv_lang[stat_18_ard]#</b>&nbsp;&nbsp;edad de defunción por época de defunción.<br /><b>#pgv_lang[stat_19_arm]#</b>&nbsp;&nbsp;edad media de matrimonio.<br /><b>#pgv_lang[stat_20_arm1]#</b>&nbsp;&nbsp;edad media de primer matrimonio.<br /><b>#pgv_lang[stat_21_nok]#</b>&nbsp;&nbsp;tamaño medio de las familias.<b>#pgv_lang[stat_1_map]#</b>&nbsp;&nbsp;ubicación de todas las personas o las del apellido especificado, por país.<br /><b>#pgv_lang[stat_2_map]#</b>&nbsp;&nbsp;país de nacimiento.<br /><b>#pgv_lang[stat_4_map]#</b>&nbsp;&nbsp;país de matrimonio.<br /><b>#pgv_lang[stat_3_map]#</b>&nbsp;&nbsp;país de defunción.<br /><b>#pgv_lang[stat_9_indi]#</b>&nbsp;&nbsp;diagrama de tarta de las personas con fuentes.<br /><b>#pgv_lang[stat_8_fam]#</b>&nbsp;&nbsp;diagrama de tarta de las familias con fuentes.</p><br /><br />";
$pgv_lang["stat_help_y"]		= "~OPCIONES PARA LAS GRÁFICAS ESTADÍSTICAS~<br /><br />~EJE Y~<br />Se pueden utilizar estas opciones para el eje Y (vertical). Estas opciones alteran la forma en que se presentan los datos del eje X.<p style=\"padding-left: 25px\"><b>#pgv_lang[stat_201_num]#</b>&nbsp;&nbsp;muestra el número de personas en cada categoría definida por el eje X.<br /><b>#pgv_lang[stat_202_perc]#</b>&nbsp;&nbsp;calcula y muestra la proporción de cada una de las categorías del eje X.</p>";
$pgv_lang["stat_help_z"]		= "~OPCIONES PARA LAS GRÁFICAS ESTADÍSTICAS~<br /><br />~Z AXIS~<br />Se pueden utilizar las siguientes opciones para el eje Z. Estas opciones proporcionan una subdivisión de las categorías seleccionadas para el eje X.<p style=\"padding-left: 25px\"><b>#pgv_lang[stat_300_none]#</b>&nbsp;&nbsp;muestra los elementos como una sola columna para cada categoría del eje X.<br /><b>#pgv_lang[stat_301_mf]#</b>&nbsp;&nbsp;muestra los elementos en dos columnas (hombres y mujeres) para cada categoría del eje X.<br /><b>#pgv_lang[stat_302_cgp]#</b>&nbsp;&nbsp;muestra los elementos en varias columnas en función de los períodos de tiempo fijados en la siguiente sección para cada categoría del eje X.</p>";
$pgv_lang["stat_help_gwx"]		= "~OPCIONES PARA LAS GRÁFICAS ESTADÍSTICAS~<br /><br />~límites para el eje X~<br />Seleccione el intervalo de edades deseado.<br /><br />Por ejemplo, <b>#pgv_lang[aft_marr]#</b> describe la siguiente serie de rangos de meses:<div style=\"padding-left:30px;\">antes del matrimonio<br />desde el matrimonio hasta 8 meses después<br />de 8 a 12<br />de 12 a 15<br />de 15 a 18<br />de 18 a 24<br />de 24 a 48<br />más de 48 meses tras el matrimonio</div><br /><br />Si quiere mostrar trimestres, debe escoger: <b>trimestres</b>.<br /><br />";
$pgv_lang["stat_help_gax"]		= "~OPCIONES PARA LAS GRÁFICAS ESTADÍSTICAS~<br /><br />~límites para el eje X~<br />Seleccione el intervalo de edades deseado.<br /><br />Por ejemplo, <b>intervalo 10 años</b> describe la siguiente serie de rangos de edad:<div style=\"padding-left:30px;\">menos de 1 año<br />de uno a 5 años<br />de 5 a 10<br />de 11 a 20<br />de 21 a 30<br />de 31 a 40<br />de 41 a 50<br />de 51 a 60<br />de 61 a 70<br />de 71 a 80<br />de 81 a 90<br />de 91 a 100<br />más de 100 años</div><br /><br />";
$pgv_lang["stat_help_gbx"]		= "~OPCIONES PARA LAS GRÁFICAS ESTADÍSTICAS~<br /><br />~límites para el eje X~<br />Seleccione el intervalo de edades deseado.<br /><br />Por ejemplo, <b>intervalo 2 años</b> describe la siguiente serie de rangos de edad:<div style=\"padding-left:30px;\">menos de 16 años<br />16 a 18<br />19 a 20<br />21 a 22<br />23 a 24<br />25 a 26<br />27 a 28<br />29 a 30<br />31 a 32<br />33 a 35<br />36 a 40<br />41 a 50<br />más de 50 años</div><br /><br />";
$pgv_lang["stat_help_gcx"]		= "~OPCIONES PARA LAS GRÁFICAS ESTADÍSTICAS~<br /><br />~límites para el eje X~<br />Seleccione el intervalo de valor deseado.<br /><br />Por ejemplo, <b>intervalo un hijo</b> describe la siguiente serie de rangos de número de hijos:<div style=\"padding-left:30px;\">sin hijos<br />un hijo<br />dos hijos<br />3, 4, 5, 6, 7, 8, 9, 10 hijos<br />más de 10 hijos</div><br /><br />";
$pgv_lang["stat_help_gwz"]		= "~OPCIONES PARA LAS GRÁFICAS ESTADÍSTICAS~<br /><br />~límites para el eje Z~<br />Seleccione el año de comienzo y el intervalo deseados<br /><br />Por ejemplo, <b>desde 1700 intervalo 50 años</b> describe la siguiente serie de rangos de fechas:<div style=\"padding-left:30px;\">antes de 1700<br />1700 a 1749<br />1750 a 1799<br />1800 a 1849<br />1850 a 1899<br />1900 a 1949<br />1950 a 1999<br />2000 o después</div><br /><br />";
$pgv_lang["chart_type_help"]	= "~OPCIONES PARA LAS GRÁFICAS ESTADÍSTICAS~<br /><br />Seleccione lo que desea ver en el mapa.  Puede escoger:<p style=\"padding-left: 25px\"><b>#pgv_lang[indi_distribution_chart]#</b>&nbsp;&nbsp;muestra los países en que aparecen las personas de esta base de datos.<br /><b>#pgv_lang[surname_distribution_chart]#</b>&nbsp;&nbsp;muestra los países en que aparecen los apellidos especificados.</p><br /><br />";
$pgv_lang["google_chart_surname_help"]	= "~OPCIONES PARA LAS GRÁFICAS ESTADÍSTICAS~<br /><br />El número de repeticiones del nombre especificado se mostrará en el mapa.  Si deja este campo vacío, se utilizará el apellido que más se repita.<br /><br />";
$pgv_lang["chart_area_help"]	= "~OPCIONES PARA LAS GRÁFICAS ESTADÍSTICAS~<br /><br />Seleccione el área geográfica que desea ver en el mapa. Puede escoger:<p style=\"padding-left: 25px\"><b>#pgv_lang[world_chart]#</b>&nbsp;&nbsp;muestra todos los continentes.<br /><b>#pgv_lang[europe_chart]#</b>&nbsp;&nbsp;muestra Europa.<br /><b>#pgv_lang[s_america_chart]#</b>&nbsp;&nbsp;muestra Sudamérica.<br /><b>#pgv_lang[asia_chart]#</b>&nbsp;&nbsp;muestra Asia.<br /><b>#pgv_lang[middle_east_chart]#</b>&nbsp;&nbsp;muestra el Oriente Medio.<br /><b>#pgv_lang[africa_chart]#</b>&nbsp;&nbsp;muestra África.</p><br /><br />";

//-- Find Media Help
$pgv_lang["manage_media_help"]		= "~#pgv_lang[manage_media]#~<br /><br />En esta página puede gestionar fácilmente sus archivos y directorios de objetos audiovisuales.<br /><br />Si crea nuevos subdirectorios para objetos, PhpGedView se asegurará de que se mantiene una estructura de directorios idéntica bajo el directorio <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs</b>.  Si sube nuevos archivos, PhpGedView puede crear automáticamente las miniaturas para Vd.<br /><br />Junto a cada imagen en la lista de Objetos encontrará las siguientes opciones.  Las opciones realmente mostradas dependen del estado actual del archivo de Objeto.<ul><li><b>#pgv_lang[edit]#</b>&nbsp;&nbsp;Si hace clic en esta opción, verá una página donde puede cambiar el título del objeto.  Si el objeto no está aún vinculado a una persona, familia o fuente en la base de datos activa, puede establecer ese vínculo aquí.  Puede cambiar el nombre al archivo o incluso cambiar su ubicación dentro de la estructura de directorios bajo <b>#GLOBALS[MEDIA_DIRECTORY]#</b>.  Si es necesario, PhpGedView creará automáticamente los subdirectorios necesarios o cualquier miniatura que falte.</li><li><b>#pgv_lang[edit_raw]#</b>&nbsp;&nbsp;Esta opción sólo está disponible si el administrador la ha activado.  Puede ver o modificar los datos GEDCOM en bruto asociados con este objeto.  Debe ser muy cuidadoso al usar esta opción.</li><li><b>#pgv_lang[delete_file]#</b>&nbsp;&nbsp;Esta opción le permite borrar todo conocimiento del archivo de Objeto de la base de datos actual.  Las demás bases de datos no se verán afectadas.  Si este archivo de Objeto no se menciona en ninguna otra base de datos, el archivo y su miniatura asociada se eliminarán.</li><li><b>#pgv_lang[remove_object]#</b>&nbsp;&nbsp;Esta opción le permite borrar todo conocimiento del archivo de Objeto de la base de datos actual.  Las demás bases de datos no se verán afectadas.  Ni el archivo de Objeto ni su miniatura asociada se borrarán.</li><li><b>#pgv_lang[remove_links]#</b>&nbsp;&nbsp;Esta opción le permite eliminar todos los vínculos al objeto de la base de datos actual.  El archivo no se borrar y el objeto de la base de datos correspondiente al archivo se mantendrán.  Las demás bases de datos no se verán afectadas.</li><li><b>#pgv_lang[set_link]#</b>&nbsp;&nbsp;Esta opción le permite establecer vínculos entre el archivo de objeto y personas, familias o fuentes de la base de datos actual.  Si es necesario, PhpGedView también creará el objeto de la base de datos asociado al archivo.</li><li><b>#pgv_lang[gen_thumb]#</b>&nbsp;&nbsp;Si selecciona esta opción, PhpGedView creará la miniatura.</li></ul><br /><br />";
$pgv_lang["simple_filter_help"]		= "~#pgv_lang[filter]#~<br /><br />Filtro de búsqueda sencillo basado en los caracteres introducidos, no se admiten comodines.<br /><br />";
$pgv_lang["show_thumb_help"]		= "~#pgv_lang[show_thumbnail]#~<br /><br />Se mostrarán las miniaturas si marca esta casilla.<br /><br />";
$pgv_lang["new_dir_help"]			= "~#pgv_lang[add_directory]#~<br /><br />Como administrador, puede crear la estructura de directorios que requiera para mantener sus archivos audiovisuales organizados.  Crear los directorios desde esta página garantiza que los directorios para miniaturas se crean también, además de crear un archivo index.php en cada directorio.<br /><br />Haga clic en este vínculo para introducir el nombre del directorio que desea crear.<br /><br />";
$pgv_lang["find_media_help"]		= "~#pgv_lang[find_media]#~<br /><br />Aquí puede buscar en la estructura de archivos para localizar el objeto audiovisual con el que quiere vincular.<br /><br />";

//-- Add / Edit Media Help
$pgv_lang["add_media_linkid"]		= "~Vincular ID~<br /><br />Cada objeto audiovisual debería estar asociado con una o más registros de personas, familias o fuentes de su base de datos.<br /><br />Para establecer ese vínculo, puede introducir o buscar el ID de la persona, familia o fuente a la vez que crea el objeto.  También puede establecer el vínculo posteriormente, mediante las opciones de edición de la página Gestionar Objetos Audiovisuales o agregando los objetos mediante el vínculo Agregar Objeto disponible en las páginas de persona, familia o fuente.<br /><br />";
$pgv_lang["upload_server_file_help"] = "~#pgv_lang[server_file]#~<br /><br />El archivo que está subiendo puede llamarse de manera distinta en el servidor y probablemente debería ser distinto.  Esto es así porque a menudo el nombre de archivo local tiene significado para Vd. pero no significa mucho para otros visitantes del sitio.  Considere también la posibilidad de Vd. y otra persona intenten ambos subir archivos diferentes llamados los dos \"abuela.jpg\".<br /><br />En este campo se especifica el nuevo nombre del archivo que se está subiendo.  En nombre que indique se utilizará también para dar nombre a la miniatura, que puede ser subida por separado o generada automáticamente.  No es necesario que introduzca la extensión del nombre de archivo (jpg, gif, pdf, doc, etc.)<br /><br />Deje este campo en blanco para mantener el nombre de archivo original como existía en su equipo local.<br /><br />";
$pgv_lang["upload_server_folder_help"] = "~#pgv_lang[server_folder]#~<br /><br />El administrador ha permitido hasta #GLOBALS[MEDIA_DIRECTORY_LEVELS]# niveles de carpetas por debajo del <b>#GLOBALS[MEDIA_DIRECTORY]#</b> predeterminado.  Esto ayuda a organizar los archivos de los objetos audiovisuales y reduce la posibilidad de conflictos de nombres.<br /><br />En este campo, especifique la carpeta destino donde deba guardarse el archivo audiovisual subido.  La miniatura correspondiente, bien subida independientemente o generada automáticamente, se almacenará en una estructura de carpetas similar a partir de <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b> en vez de <b>#GLOBALS[MEDIA_DIRECTORY]#</b>.  No es necesario que introduzca la parte <b>#GLOBALS[MEDIA_DIRECTORY]#</b> de la carpeta de destino.<br /><br />Si no está seguro de qué introducir aquí, contacte con el administrador del sitio para que le aconseje.<br /><br />";
$pgv_lang["view_server_folder_help"] = "~#pgv_lang[server_folder]#~<br /><br />El administrador ha permitido hasta #GLOBALS[MEDIA_DIRECTORY_LEVELS]# niveles de carpetas por debajo del <b>#GLOBALS[MEDIA_DIRECTORY]#</b> predeterminado.  Esto ayuda a organizar los archivos de los objetos audiovisuales y reduce la posibilidad de conflictos de nombres.<br /><br />En este campo, especifique la carpeta de objetos que desea visualizar.  Si selecciona <b>#pgv_lang[all]#</b>, se mostrarán todos los archivos de objetos independientemente de la carpeta en que estén almacenados.  Esto puede producir una lista muy larga de objetos.<br /><br />";

//--Repository Help
$pgv_lang["help_repolist.php"]		= "~#pgv_lang[repo_list]#~<br /><br />En esta página se muestra una lista de repositorios.<br /><br />Los repositorios se muestran por orden alfabético de sus nombres.<br /><br /><b>REPOSITORIOS</b><br />Sin repositorios no podemos construir nuestra base de datos.  Hay una fuente para cada información de nuestra base de datos y esa fuente se guarda en un repositorio. Repositorio puede ser el archivo personal de una persona, una institución, una base de datos pública, una oficina de registros civiles o religiosos, un recurso de Internet, etc. Para conseguir acceso a una fuente, necesitaremos saber dónde está. Toda la información necesaria para localizar una fuente se almacenaría en el registro Repositorio.<br /><br />Un repositorio puede estar vinculado con muchas fuentes.<br /><br />";
$pgv_lang["help_repo.php"]			= "~#pgv_lang[repo_info]#~<br /><br />Se muestran aquí los detalles del Repositorio. Junto con las fuentes, los repositorios son muy importantes para los investigadores genealógicos.  Con información precisa de fuentes y repositorios, se puede seguir la pista que utilizó otro investigador para encontrar la información.  Tendría que ser posible localizar esa misma información de nuevo.<br /><br />En esta página puede ver la información acerca del título del repositorio, su dirección, correo electrónico y página web.<br /><br />Tras los detalles del repositorio se muestra una lista de todas las fuentes vinculadas a este repositorio.  Esto permite ver toda la información que se obtuvo de un repositorio particular.<br /><br />Si el administrador del sitio lo permitió, podrá ver uno o dos iconos adicionales en esta página:<br /><b>#pgv_lang[view_gedcom]#</b>, que muestra la información en formato GEDCOM.<br /><b>#pgv_lang[add_to_cart]#</b>, que permite almacenar esta información en su #pgv_lang[clip_cart]#. Desde ahí puede descargar la información como un archivo en formato GEDCOM e importarla a su propio programa de genealogía.<br /><br />#pgv_lang[context_help]#<br /><br />";
$pgv_lang["delete_repo_help"]			= "~#pgv_lang[delete_repo]#~<br /><br />Usar esta opción marca este Repositorio para ser borrado de la base de datos.<br /><br />¿Qué significa esto?<br />Supongamos que tiene una buena razón para borrar este repositorio de la base de datos. Vd. hace clic en el vínculo.  Se le pedirá que confirme su solicitud de borrado.  Si decide continuar, puede pasar un poco de tiempo antes de que se le muestre un mensaje indicando que se ha borrado en Repositorio.<br /><br />Si continúa con su visita, notará que el Repositorio está aún visible y que puede utilizarse como si no hubiera sido borrado.<br /><b>Esto <u>no</u> es un error.</b>  El administrador del sitio recibirá un mensaje avisándole de que se ha hecho un cambio a la base de datos y que Vd. borró el Repositorio.<br />El administrador puede aceptar o rechazar su cambio.  Sólo después de que el administrador haya aceptado su cambio será el borrado <u>irreversible</u>.  Si hay alguna duda acerca del cambio, el administrador se pondrá en contacto con Vd.<br /><br />";
$pgv_lang["show_repo_gedcom_help"]	= "~#pgv_lang[view_gedcom]#~<br /><br />Si hace clic en este vínculo, se mostrará en una ventana emergente la información acerca del repositorio tal como está almacenada en la base de datos.<br /><br />";
$pgv_lang["add_repository_clip_help"]		= "~#pgv_lang[add_to_cart]#~<br /><br />Si hace clic en este vínculo puede agregar este repositorio, tal como está almacenado en el archivo GEDCOM, a su #pgv_lang[clip_cart]#.<br /><br />";
$pgv_lang["repolist_listbox_help"]		= "~#pgv_lang[repo_list]#~<br /><br />En esta caja puede ver los nombres de los repositorios tal como están almacenados en la base de datos.<br /><br />Los nombres se muestran en orden alfabético.<br /><br />Si hace clic en un nombre de la lista, irá a la página de #pgv_lang[repo_info]# donde verá la lista de fuentes vinculadas a ese repositorio.<br /><br />";
$pgv_lang["repos_listbox_help"]		= "~#pgv_lang[other_repo_records]#~<br /><br />En estas cajas puede ver los nombres de las fuentes que están vinculadas al repositorio.<br /><br />Los nombres se muestran en orden alfabético.<br /><br />Si hace clic en un nombre de la lista, irá a la página de detalle de esa fuente.<br /><br />";

// Index-Edit
$pgv_lang["block_move_up_help"]		= "~Mover entradas de la lista~<br /><br />Utilice estos botones para reordenar las entradas en la lista.  Los bloques se mostrarán en el orden en que se listan aquí.<br /><br />Resalte la entrada que desea mover y haga clic en un botón para mover la entrada hacia arriba o hacia abajo.<br /><br />";
$pgv_lang["block_move_right_help"]	= "~Mover entradas de la lista~<br /><br />Utilice estos botones para mover una entrada de una lista a otra.<br /><br />Resalte la entrada a mover y haga clic en un botón para mover o copiar esa entrada en la dirección de la flecha.  Utilice los botones <b>&raquo;</b> y <b>&laquo;</b> para mover la entrada resaltada de la lista más a la izquierda a la más a la derecha o viceversa.  Utilice los botones <b>&gt;</b> y <b>&lt;</b> para mover la entrada resaltada entre la lista de #pgv_lang[available_blocks]# y la lista a su derecha o a su izquierda.<br /><br />Las entradas en la lista #pgv_lang[available_blocks]# no cambian, haga lo que haga con los botones #pgv_lang[move_right]# y #pgv_lang[move_left]#.  Esto es así porque el mismo bloque puede aparecer varias veces en la misma página.  El bloque HTML es un buen ejemplo de por qué podría querer hacer esto.<br /><br />";
$pgv_lang["block_default_index"]	= "~Bloques predeterminados en la página #pgv_lang[welcome]#~<br /><br />Si elimina todas las entradas de las listas #pgv_lang[main_section]# y #pgv_lang[right_section]#, o si hace clic en el botón <b>#pgv_lang[reset_default_blocks]#</b>, la lista de bloques quedará como sigue:<br /><br /><center><table border=\"1\"><tr><td class=\"list_value\"><b>#pgv_lang[main_section]#</b></td><td class=\"list_value\"><b>#pgv_lang[right_section]#</b></td></tr><tr><td>#pgv_lang[gedcom_stats_block]#<br />#pgv_lang[gedcom_news_block]#<br />#pgv_lang[gedcom_favorites_block]#<br />#pgv_lang[review_changes_block]#</td><td>#pgv_lang[gedcom_block]#<br />#pgv_lang[random_media_block]#<br />#pgv_lang[todays_events_block]#<br />#pgv_lang[logged_in_users_block]#</td></tr></table></center><br />";
$pgv_lang["block_default_portal"]	= "~Bloques predeterminados en la página #pgv_lang[mygedview]#~<br /><br />Si elimina todas las entradas de la listas #pgv_lang[main_section]# y #pgv_lang[right_section]#, o si hace clic en el botón <b>#pgv_lang[reset_default_blocks]#</b>, la lista de bloques quedará como sigue:<br /><br /><center><table border=\"1\"><tr><td class=\"list_value\"><b>#pgv_lang[main_section]#</b></td><td class=\"list_value\"><b>#pgv_lang[right_section]#</b></td></tr><tr><td>#pgv_lang[todays_events_block]#<br />#pgv_lang[user_messages_block]#<br />#pgv_lang[user_favorites_block]#<br />&nbsp;</td><td>#pgv_lang[welcome_block]#<br />#pgv_lang[random_media_block]#<br />#pgv_lang[upcoming_events_block]#<br />#pgv_lang[logged_in_users_block]#</td></tr></table></center><br />";

// FAQ page
$pgv_lang["help_faq.php"] = "~Preguntas Frecuentes~<br />#pgv_lang[text_faq_help]#<br />";
$pgv_lang["text_faq_help"] = "La página Preguntas Frecuentes puede contener una introducción o una lista de preguntas y respuestas sobre el uso de este sitio de genealogía.<br /><br />El uso de esta página queda completamente en las manos del administrador del sitio. Éste controla el contenido de cada entrada y el orden en que se presentan.";

// Help search
$pgv_lang["hs_title_help"] 			= "<center>~#pgv_lang[hs_title]#~</center><br />#pgv_lang[hs_intro]#<br /><br />#pgv_lang[hs_keyword_advice]#<br /><br />#pgv_lang[hs_searchhow_advice]#<br /><br />#pgv_lang[hs_searchin_advice]#";
$pgv_lang["hs_intro"]				= "Puede buscar en el sistema de Ayuda de PhpGedView.  La característica #pgv_lang[hs_title]# le da un alto grado de control sobre la forma en que funciona la búsqueda; debería poder encontrar lo que busca fácilmente.";
$pgv_lang["hs_keyword_advice"] 		= "~#pgv_lang[hs_keyword]#~<br />Introduzca las palabras o la frase que desee encontrar.<br /><br />La búsqueda no presta atención a la diferencia de mayúsculas y minúsculas no en los términos introducidos ni en el texto examinado.  Esto quiere decir que si busca <b>Persona</b>, encontrará textos que contengan <b>Persona</b>, <b>persona</b>, or <b>PERSONA</b>.  También encontrará textos que contengan <b>personas</b>, etc. puesto que se buscan secuencias de caracteres más que palabras.<br /><br />Puede hacer que se busquen varias palabras a la vez.  Introduzca todas las palabras, separándolas por espacio, así: <b>persona&nbsp;familia&nbsp;hijo</b>.  Si se introduce más de una palabra, el significado de los tecleado se clarifica en el campo #pgv_lang[hs_searchhow]#.<br />";
$pgv_lang["hs_searchin_advice"]		= "~#pgv_lang[hs_searchin]#~<br />Puede determinar el alcance de la búsqueda aquí.<br /><br />Los administradores tienen la posibilidad de buscar en la ayuda de usuario, en la de configuración o en ambas.  Los usuarios no pueden elegir porque no tienen acceso a ninguna de las características de configuración, sólo pueden buscar en la ayuda de usuario.<br /><br />Los archivos de ayuda contienen no sólo texto de ayuda, sino también algunas cadenas de texto que se utilizan para construir formularios de entrada y otro material.  Esta opción le permite controlar si se debe examinar todo el archivo de ayuda o sólo el texto de ayuda.<br />";
$pgv_lang["hs_searchhow_advice"]	= "~#pgv_lang[hs_searchhow]#~<br />Se clarifica el significado de lo que ha introducido en el campo #pgv_lang[hs_keyword]# seleccionando entre las posibilidades presentadas aquí.<br /><dl><dt><b>#pgv_lang[hs_searchany]#</b></dt><dd>Si ha introducido <b>persona&nbsp;familia&nbsp;hijo</b>, esta opción buscará los textos de ayuda que contengan una de las palabras listadas.  El orden de las palabras no importa.  El significado de la búsqueda es: \"Buscar texto de ayuda que contenga <b>persona</b> <u>o</u> <b>familia</b> <u>o</u> <b>hijo</b>\".</dd><dt><b>#pgv_lang[hs_searchall]#</b></dt><dd>Si ha introducido <b>persona&nbsp;familia&nbsp;hijo</b>, esta opción buscará texto de ayuda que contenga todas las palabras listadas.  El orden de las palabras no importa.  El significado de la búsqueda es: \"Buscar texto de ayuda que contenga <b>persona</b> <u>y</u> <b>familia</b> <u>e</u> <b>hijo</b>\".</dd><dt><b>#pgv_lang[hs_searchsentence]#</b></dt><dd>Si ha introducido <b>persona&nbsp;familia&nbsp;hijo</b>, esta opción buscará texto de ayuda que contenga todas las palabras listadas en el orden dado.  El significado de la búsqueda es: \"Buscar texto de ayuda que contenga las palabras <b>persona&nbsp;familia&nbsp;hijo</b> exactamente en ese orden sin otras palabras intercaladas\".  Probablemente no encontrará esta frase en particular en ningún texto de ayuda.<br /><br />Hay algunas limitaciones en este tipo de búsqueda.  Algunos caracteres especiales como <b>&quot; &lt; &gt;</b> etc. se encuentran en el texto de ayuda en forma simbólica y no se encontrará si son parte del texto que introduce.  Algunos textos de ayuda contienen un tipo especial de espacio, representado por <b>&amp;nbsp;</b> y no se encontrarán frases con este carácter.</dd></dl>";

// Directory cleanup tool
$pgv_lang["help_dir_editor.php"]	= "~#pgv_lang[index_dir_cleanup]#~<br /><br />Esta herramienta permite a los administradores del sitio limpiar los archivos del directorio índice.<br /><br />Con el tiempo pueden irse acumulando archivos en el directorio índice como diarios de operaciones, viejos archivos GEDCOM y viejas copias de salvaguarda.  Puesto que muchos de estos los crea el programa, puede que su propietario sea el usuario del servidor web.  Si su propietario es el servidor web, quizá no pueda borrarlos manualmente. Esta herramienta le proporciona una forma de que borre estos archivos incluso si son propiedad del usuario con que se ejecuta el servidor web.<br /><br />#pgv_lang[index_dir_cleanup_inst]#";
?>
