<?php
/**
 * Spanish FAQ texts for PhpGedView
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2010  PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 * @author PGV Developers
 * @translator: Julio Sánchez Fernández
 * @package PhpGedView
 * @subpackage Languages
 * @version $Id: faqlist.es.php 6973 2010-07-08 08:20:44Z jsanchez $
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

$faqlist["FAQ_000_head"] = "\"FAQ\": LO HE OÍDO ALGUNA VEZ PERO ¿QUÉ ES?";
$faqlist["FAQ_000_body"] = "<b>FAQ</b> es la abreviatura de la frase en inglés <b>F</b>requently <b>A</b>sked <b>Q</b>uestion o Pregunta Frecuente.<br /><br />La lista de preguntas frecuentes es una lista de preguntas (junto con sus respuestas) que se hacen muchas veces.  Ha sido compilada por el equipo de PhpGedView y se actualiza a menudo.";

$faqlist["FAQ_010_head"] = "BIENVENIDO A LA LISTA DE PREGUNTAS FRECUENTES DE #GLOBALS[GEDCOM_TITLE]#";
$faqlist["FAQ_010_body"] = "Los miembros de la familia de #GLOBALS[GEDCOM_TITLE]# quisieran aprovechar esta oportunidad para dar la bienvenida a todos nuestros familiares a la genealogía y animarlos a que les entre el gusanillo de investigar sus ascendientes. Se puede convertir fácilmente en una tarea de amor - y odio - puesto que consume una cantidad de tiempo enorme, pero la recompensa es también enorme. Le ofrecemos la oportunidad de disfrutar de la genealogía mediante el uso de <a href=\"http://www.phpgedview.net\" target=\"_blank\">PhpGedView</a>, creado por el talento en programación de John Finlay y su equipo PGV - Un maravilloso programa de genealogía fruto de la tecnología de Código Fuente Abierto.";

$faqlist["FAQ_015_head"] = "¿QUÉ DIFERENCIA HAY ENTRE ESTE ÁRBOL EN PhpGedView Y OTROS ÁRBOLES EN TEXTO O DINÁMICOS?";
$faqlist["FAQ_015_body"] = "Los árboles en texto o dinámicos muestran el árbol de varias maneras, pero ninguna de ellas puede ser configurada, cambiada o actualizada por Vd. Sólo el responsable del sitio puede hacer cambios.<br /><br />PhpGedView es un árbol interactivo.  Cualquiera cuya familia esté en este árbol extendido puede actualizar, agregar y hacer cambios a sus ramas cercanas. (Debe registrarse antes para realizar estos cambios.)";

$faqlist["FAQ_017_head"] = "¿CUÁLES SON LAS PRINCIPALES CARACTERÍSTICAS ESPECIALES DE ESTE ÁRBOL?";
$faqlist["FAQ_017_body"] = "Con PhpGedView puede:<ul><li>Mantener la privacidad de las personas vivas; el administrador determina qué personas puede ver Vd.</li><li>Disfrute de las muchas posibilidades de visualizar el árbol: como distintos diagramas, informes o listas.</li><li>Es un árbol colaborativo; con permiso del administrador, cualquiera puede participar en la actualización del árbol.</li></ul>";

$faqlist["FAQ_020_head"] = "¿NECESITO UNA CUENTA PARA ACCEDER? SI ES ASÍ, ¿CÓMO SOLICITO UNA?";
$faqlist["FAQ_020_body"] = "¿Hace falta que digamos \"Bienvenido, primo\"?<br /><br /><b>NOTA: #GLOBALS[GEDCOM_TITLE]# NO REQUIERE REGISTRARSE para acceder a datos de los parientes fallecidos. Sin embargo, para contribuir información o ver datos de parientes que se suponen vivos, es necesario que se registre y nos indique su parentesco.</b>";
$faqlist["FAQ_020_body2"] = "Los usuarios pueden ver los nombres de todas las personas vivas de la base de datos. También ven datos detallados de las personas fallecidas y de sus parientes cercanos.<br /><br />Los usuarios sin parientes sólo ven nombres de las personas vivas y datos detallados de fallecidos.";
$faqlist["FAQ_020_body3"] = "<ol><li>Los solicitantes deben ser parientes, aunque sean lejanos, o relacionados de alguna manera con alguna persona ya presente en la base de datos o con alguien que debería ser incluido en nuestro sitio;</li><li>Los solicitantes deberían estar dispuestos a visitar y contribuir regularmente a nuestro sitio, proporcionándolos inicialmente su información personal y de su familia cercana y, posteriormente, modificaciones y datos adicionales a nuestros datos actuales;</li><li>Los solicitantes deben prometer proteger la privacidad de los datos de todas las personas vivas incluidas en el sitio y, como se ha indicado, proporcionar su información personal. Los incumplimientos llevarán a la terminación inmediata de los privilegios de acceso y pueden ser causa de acciones legales. Nos tomamos en serio la posibilidad del robo de identidad o el abuso de la información. Por favor, vea más detalles en nuestra sección de Privacidad más adelante.</li></ol>Si cumple las condiciones para registrarse y se compromete a cumplir estas simples políticas y procedimientos, use el <b><a target=\"_blank\" href=\"/phpGedView/login_register.php?action=register\">formulario de registro</a></b> del sitio. Asegúrese de rellenar el breve cuestionario donde debe explicar su parentesco con las personas incluidas en la base de datos y expresar claramente su compromiso con nuestras políticas y reglas de acceso.  La revisaremos y consideraremos su solicitud.";
$faqlist["FAQ_020_body4"] = "La aprobación de una nueva cuenta de usuario debe realizarla manualmente el administrador.  Normalmente tardará entre unos minutos y 24 horas.";

$faqlist["FAQ_022_head"] = "¿POR QUÉ HE DE REGISTRARME?";
$faqlist["FAQ_022_body"] = "Sólo los usuarios registrados pueden ver los nombres de las personas vivas. Si no está registrado, sólo verá \"Privada\" en vez de los nombres de las personas vivas.";

$faqlist["FAQ_025_head"] = "¿CUÁNTO TARDA EN APROBARSE MI SOLICITUD DE REGISTRO?";
$faqlist["FAQ_025_body"] = "La aprobación de una nueva cuenta de usuario tiene que hacerla manualmente el administrador.  Por lo general tardará entre unos pocos minutos y 24 horas.";

$faqlist["FAQ_027_head"] = "ME HE REGISTRADO Y ME HAN APROBADO. VEO LOS NOMBRES DE PERSONAS VIVAS, PERO NO VEO LOS DETALLES DE NINGUNO.";
$faqlist["FAQ_027_body"] = "Para ver los detalles (sólo de sus ramas cercanas), debe formar parte del árbol y debe informar de ello al administrador por correo electrónico.";

$faqlist["FAQ_030_head"] = "¿CÓMO INTRODUZCO DATOS?  ¿QUÉ FORMATOS DEBO USAR?";
$faqlist["FAQ_030_body"] = "He aquí algunas pistas";
$faqlist["FAQ_030_body2"] = " para usuarios autorizados para modificar datos directamente.";
$faqlist["FAQ_030_body3"] = "También puede enviar sus datos por correo electrónico.";
$faqlist["FAQ_030_HELP"] = "<strong>AYUDA</strong>: Hay gran cantidad de ayuda en este sitio, en el encabezado de cada página y en la mayoría de los vínculos y otras palabras marcadas con la imagen \"?\". Si a pesar de todo tiene dudas, pregúntenos por correo electrónico.";
$faqlist["FAQ_030_DATES"] = "<strong>FECHAS</strong>: Usamos el formato de fechas del estándar GEDCOM v5.5. Utilice DD MMM AAAA o 01 JAN 1822 en vez de 1 de enero de 1822 o Ene 1, 1822.  El sistema puede corregir algunos errores menores en la introducción de las fechas, pero no debe contar con que la corrección sea apropiada.";
$faqlist["FAQ_030_HDATES"] = "<strong>FECHAS HEBREAS</strong> se introducen mediante el formato @#DHEBREW@ DD MMM AAAA o @#DHEBREW@ 21 AAV 5705 - Los meses se indican como TSH, CSH, KSL, TVT, SHV, ADR, ADS, NSN, IYR, SVN, TMZ, AAV y ELL conforme al estándar GEDCOM v5.5.";
$faqlist["FAQ_030_PLACES"] = "<strong>LUGARES</strong>: Intentamos, si hay suficiente información, incluir el nombre completo del lugar: población y/o municipio, al igual que el condado, el estado y generalmente agregamos USA (forma preferida - no US, U.S. o U.S.A.) después del estado.  Para otros países, usamos las abreviaturas de tres letras aprobadas por GEDCOM en vez de los nombres de los países: Inglaterra [ENG], Escocia [SCT], Irlanda [IRE], Francoa [FRA], Italia [ITA], etc. El formato preferido es: <i>Indianapolis, Center Twp, Marion Co, Indiana, USA</i>  Los estados no deben abreviarse a dos letras; generalmente no usamos puntos (.) en los nombres o en las poblaciones, como <i>Shelbyville, Addison Twp, Shelby Co, Indiana, USA</i> en vez de <i>Shelbyville, Addison Twp., Shelby Co., IN</i> o <i>Shelbyville, Addison Township, Shelby County, Indiana, U.S.A.</i>";
$faqlist["FAQ_030_PLACES2"] = "<strong>LUGARES</strong>: Intentamos, si se conoce, incluir para los lugares de Estados Unidos el nombre completo: la localidad o municipio, así como el código de dos letras del estado y agregamos USA (forma preferida - no US, U.S. o U.S.A.) después del estado.  Para otros países, usamos la localidad o municipio u el nombre del país. Los formatos preferidos son: <i>Indianapolis, IN, USA</i> y <i>Vilnius, Lithuania</i>.";
$faqlist["FAQ_030_PLACES3"] = "Hay dos formas útiles de averiguar el formato correcto para un lugar:<br /><ul><li>usar el pequeño icono del mundo junto al campo de Lugar para ver qué lugares ya están en la base de datos. Ésta es una buena forma de buscar el condado de una localidad si no lo conoce puesto que probablemente ya existe en nuestros datos. Use el filtro para refinar la búsqueda y haga clic en el resultado deseado que resultará copiado al campo vacío de Lugar,</li><li>haga clic en el signo + bajo el campo Lugar. Verá una serie de campos adicionales para el país, el estado o provincia, el condado y la población. Junto al campo de país aparece una lista desplegable de países con sus códigos estándar de tres letras.</li></ul>";
$faqlist["FAQ_030_PLACES4"] = "Hay dos formas útiles de averiguar el formato correcto para un lugar:<br /><ul><li>use el pequeño icono del mundo junto al campo de Lugar para ver qué lugares ya están en la base de datos. Ésta es una buena forma de buscar el estado de una población si no lo conoce puesto que probablemente ya exista en nuestros datos. Use el filtro para refinar la búsqueda y haga clic en el resultado deseado que resultará copiado al campo vacío de Lugar.</li><li>haga clic en el signo + bajo el campo Lugar. Verá una serie de campos adicionales para el país, el estado o provincia, el condado (N/A) y la población. Junto al campo de país aparece una lista desplegable de países con sus códigos estándar de tres letras.</li></ul>";
$faqlist["FAQ_030_PLACES5"] = "El campo \"Hebreo\" bajo los datos de \"Lugar\" le permite introducir el nombre hebreo del lugar además del nombre en caracteres latinos.";
$faqlist["FAQ_030_NAMES"] = "<strong>NOMBRES</strong>: La introducción de nombres es muy sencilla mediante el formulario y la ayuda que se ofrece.  Normalmente el formulario de entrada de personas ya mostrará campos separados para cada parte del nombre. Si no se muestran, haga clic en el signo + correspondiente.";
$faqlist["FAQ_030_PREFIX"] = "<u>PREFIX</u> se refieren a prefijos del nombre y son generalmente tratamientos como Dr., Excmo., Illtmo., etc.  Tratamientos ordinarios como Sr., Sra., etc. es preferible no incluirlos.";
$faqlist["FAQ_030_GIVN"] = "<u>GIVN</u> - Nombres de pila son aquellos asignados normalmente en el nacimiento.";
$faqlist["FAQ_030_GIVN1"] = " Si el nombre cambia tras el nacimiento, estos nombres adicionales pueden agregarse por separado después de que la persona haya sido registrada en la base de datos.  También pueden introducirse como nombres AKA (alias).<br /><br />Normalmente esperamos que a las personas se las llame por el primero de sus nombres de pila.  Si no es el caos, conviene que indique cuál de los nombres de pila es el preferido colocando un asterisco detrás del mismo.  Por ejemplo, <i>John James Mitchell* Jones</i> indica que esta persona es conocida como \"Mitchell\".  En este caso, \"Mitchell\" no es un apodo, aunque \"Mitch\" podría serlo.";
$faqlist["FAQ_030_GIVN2"] = " Introducimos el nombre de pila con una mayúscula inicial.  El resto se introduce en minúsculas";
$faqlist["FAQ_030_SURNAME"] = "<u>APELLIDO</u> es el nombre de la familia. Se trata del <u>nombre de nacimiento</u> para una persona casada y no el nombre recibido tras el matrimonio. Vea <i>nombre de casada</i> más adelante. Si el nombre cambia tras el nacimiento, estos nombres adicionales pueden introducirse por separado después de que la persona haya sido registrada en la base de datos.  También se pueden añadir como nombres AKA (alias).";
$faqlist["FAQ_030_SURNAME2"] = " Introducimos el apellido con una mayúscula inicial.  El resto lo introducimos en minúsculas";
$faqlist["FAQ_030_SUFFIX"] = "El <u>SUFIJO</u> contiene sufijos del nombre como are Jr, Sr, III, etc.";
$faqlist["FAQ_030_NICKNAME"] = "<u>APODO</u> es el nombre utilizado habitualmente para la persona si es diferente de su nombre de pila; p.ej. <i>Jack</i> podría ser el apodo de John \"Jack\" Arnold, Daniel Wilson tenía como apodo <i>Tuggy</i> y muchas Margarets tienen como apodo <i>Maggie, Nancy, Peggy, Polly</i>, etc.";
$faqlist["FAQ_030_HEBNAME"] = "<u>NOMBRE HEBREO</u> es la traducción hebrea del nombre de la persona en caracteres latinos. Nadie puede tener más de un nombre hebreo. PhpGedView espera que se encierre el apellido en barras. El nombre &#1497;&#1506;&#1511;&#1489; &#1500;&#1493;&#1497; se introduciría como &#1497;&#1506;&#1511;&#1489; /&#1500;&#1493;&#1497;/.";
$faqlist["FAQ_030_AKANAME"] = "<u>NOMBRE ALIAS</u> es un nombre adicional por el que se conoce a una persona. Podría ser el nombre de nacimiento de personas que cambiaron su nombre posteriormente o podría ser un alias, un seudónimo o un nombre artístico. Podría ser también un nombre de casada. El nombre de pila introducido puede ser diferente del nombre de pila del nombre principal. PhpGedView espera que encierre el apellido entre barras. El nombre <i>James Adams</i> se introduciría como <i>James /Adams/</i>.";
$faqlist["FAQ_030_AKANAME2"] = " Los nombres adicionales hebreos o Yiddish también se registran como nombres AKA (alias).";
$faqlist["FAQ_030_MARRNAME"] = "<u>NOMBRE DE CASADA</u> es el nombre que adquiere una persona cuando adopta el apellido del cónyuge. El programa los crea automáticamente al introducir el nuevo apellido en el campo de Nombre de Casada. es decir <i>Mary Jane Smith</i> se casa con <i>John Jones</i> y se convierte en <i>Mary Jane Jones</i> si introduce <i>Jones</i> en el campo de Apellido de Casada.  Los nombres de casada no son exclusivos de las mujeres; se puede introducir un nombre de casada para personas de cualquier sexo.";
$faqlist["FAQ_030_MARRNAME2"] = "Los nombres de casada hebreos adquieren el nombre de pila del nombre de pila hebreo.";
$faqlist["FAQ_030_NAMES2"] = "La opción <i>Modificar nombre</i> que aparece ocasionalmente bajo el nombre de una persona en la página de detalles de la persona le permite modificar cualquier aspecto del nombre de una persona. La opción <i>Borrar nombre</i>, también bajo el nombre de la persona, le permite eliminar el nombre de la información de la persona sin eliminar o cambiar ninguna otra cosa.  Puede modificar y agregar otros nombres a la información de la persona haciendo clic en las opciones <i>Modificar nombre</i> o <i>Agregar nuevo nombre</i> en el submenú <i>Editar</i> del menú <i>Opciones para la persona</i>.  Se puede obtener más información haciendo clic en el icono Ayuda asociado a estas opciones.";
$faqlist["FAQ_030_SOURC"] = "<strong>FUENTES</strong> y <strong>CITAS</strong>: En genealogía, no es suficiente con decir simplemente que algo \"pasó en tal fecha\". A los historiadores les gustan las pruebas. A nosotros también. Por favor, proporcione cualquier información que tenga sobre la fuente de la información que está proporcionando. Compruebe la distintas formas disponibles de introducir información de las fuentes y utilice la opción de NOTAS si tiene dudas o si necesita espacio para escribir. Incluya más de lo que crea necesario, no será demasiado. ¿Tiene preguntas? Pregunte lo que no entienda y estaremos encantados de ayudar.";
$faqlist["FAQ_030_CHNG"] = "<strong>CAMBIOS</strong> y <strong>ENTRADAS</strong>: Los cambios a los datos existentes de una persona o familia no aparecerán hasta que hayan sido aprobadas por un administrador. Aunque comprobamos frecuentemente el sitio, envíenos un mensaje de correo electrónico si quiere que revisemos y aprobemos las adiciones y modificaciones más rápidamente. Los hechos relativos a la creación o modificación de una unidad familiar se introducen en la página de parientes cercanos o en la de la familia. Aquí es donde se anotan matrimonios, divorcios, hijos, censos familiares - cualquier hecho o evento que afecta a toda la unidad familiar. Creemos que cuando hay que agregar varios hijos, es mejor visualizar la familia para esa pareja y agregar cada hijo mediante en vínculo al pie, 'Agregar un hijo a esta familia'.  Es más rápido que usar la página de parientes cercanos puesto que tras cada adición retorna a la página de la persona en vez de a la de parientes cercanos. ¿Tiene preguntas? Pregunte lo que no entienda y estaremos encantados de ayudar.";
$faqlist["FAQ_030_MEDIA"] = "<strong>OBJETOS</strong>: Apreciamos de verdad que aporte fotos, partidas de bautismo, licencias y partidas de matrimonio, partidas de defunción - cualquier cosa que tenga.  Es fácil agregarlas desde su propio disco duro usando la pestaña Objetos, el vínculo Agregar Objeto y la característica de Subir objetos.  También, si tiene preguntas, sugerencias o simplemente desea ayuda, envíenos sus imágenes digitales por correo electrónico y nosotros nos encargaremos de agregarlas.";
$faqlist["FAQ_030_MEDIA2"] = "Al introducir nuevos objetos, considere la posibilidad de establecer un convenio de nombres que no produzca conflictos con facilidad con otros objetos. El sistema le permite examinar su disco duro y subir el documento con un nombre completamente diferente sin afectar a su archivo local. Imagínese cuántos archivos \"john.jpg\" podría haber (bueno, sólo puede haber uno) pero podría sobreescribir el archivo existente si le cabía el nombre. Nos gusta mantener los nombres de archivo cortos (menos de 35 caracteres) pero descriptivos - algo como J_Name-b1820-I23445.jpg o K_Name-I23444-Headstn.jpg. En caso de duda, pregúntenos.";
$faqlist["FAQ_030_NAVIGATE"] = "<strong>NAVEGACIÓN</strong>: Navegamos usando el diagrama circular (abanico) y los diagramas de ascendientes y descendientes. Pruébelos. Recuerde que muchas funciones no funcionan a menos que que tenga su propia página personal enlazada con sus ascendientes.";

$faqlist["FAQ_032_head"] = "¿PUEDO AGREGAR/MODIFICAR LOS DATOS DE CUALQUIER PERSONA DEL ÁRBOL?";
$faqlist["FAQ_032_body"] = "Sí.<br />Debe ser parte del árbol y estar autorizado para hacer modificaciones.  Sólo puede hacer cambios o agregar en sus ramas próximas. También puede enviar sus cambios por correo electrónico.";

$faqlist["FAQ_037_head"] = "TUVE PROBLEMAS MODIFICANDO EL ÁRBOL ¿QUÉ DEBO HACER?";
$faqlist["FAQ_037_body"] = "Puede enviar sus cambios por correo electrónico al administrador<br />en la dirección: #GLOBALS[Webmaster_EMAIL]#";
$faqlist["FAQ_037_body2"] = "Puede enviar sus cambios por correo electrónico al administrador<br />en: #GLOBALS[CONTACT_EMAIL]#";

$faqlist["FAQ_040_head"] = "¿Y QUÉ HAY DE LA PRIVACIDAD?";
$faqlist["FAQ_040_body"] = "<b>#GLOBALS[GEDCOM_TITLE]# cree que la protección de la información personal es muy importante</b>. Las funciones de privacidad del programa PhpGedView son excelentes para la creación de algunas reglas de privacidad - en general nuestro sitio oculta los detalles de las personas vivas o de aquellas con quien no tiene parentesco. Para ver los detalles de las personas vivas tendrá que identificarse en el sistema mediante un usuario y una contraseña. Esta identidad se enlaza con su lugar en el árbol genealógico. Nuestro sitio también utiliza la función de \"privacidad por parentesco\" de PhpGedView. Esta característica le permite ver únicamente la información de las personas definidas como parientes cercanos. Si se ha identificado y ve que algunas personas están marcadas como \"Privada\", quiere decir que está activada esta característica.  Si cree que su acceso está demasiado limitado, envíe un mensaje de correo electrónico al administrador del sitio y explique detalladamente los números de ID de las personas a las que no puede acceder y por qué cree que debería poder ver esta información.";
$faqlist["FAQ_040_body2"] = "Por supuesto, ningún sistema es perfecto o inviolable, así que la posibilidad de acceso no intencionado a los datos es una posibilidad. Hacemos todo lo que podemos para remediar los problemas de privacidad rápidamente. Si tiene objeciones serias a que algunos de sus detalles personales aparezcan aquí, contacte con el administrador mediante el vínculo al formulario que aparece en la parte inferior. Sus detalles pueden eliminarse del sitio, aunque su acceso puede resultar limitado también. Vea la pregunta frecuente sobre qué información se guarda en el sitio.<br /><br /><b>Nos tomamos en serio el abuso de la información, el robo o el mal uso y actuaremos contra los que participen o intenten un robo de identidad basado en los datos de de este sitio. NO copie nuestros datos sobre personas vivas a otros sitios que podrían no protegerlos de forma apropiada y resultaría Vd. responsable de los posibles perjuicios.</b>";

$faqlist["FAQ_050_head"] = "GRACIAS";
$faqlist["FAQ_050_body"] = "La adquisición y mantenimiento de este volumen de información no sería posible sin la ayuda y participación de muchos parientes. La genealogía es muy divertida y una experiencia de aprendizaje maravillosa, ampliando tanto nuestro conocimiento de la familia como el conocimiento general de la geografía y la sociología. Esperamos que lo disfrute tanto como nosotros y nos entusiasma nuestra futura cooperación mutua y la amistad establecida mediante las funciones de PhpGedView y nuestro sitio web #GLOBALS[GEDCOM_TITLE]#.<br /><br />No dude en enviarnos un mensaje para saludar, avisarnos de una corrección o adición necesaria o para preguntar sobre algún parentesco. La mayoría de lo que conocemos está a la vista, sólo los detalles de parientes vivos se ocultan.<br /><br />Gracias otra vez";

?>
