<?php
/**
 * Polish texts
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2010  PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @author Łukasz Wileński <wooc@users.sourceforge.net>
 * @package PhpGedView
 * @subpackage Languages
 * @version $Id: facts.pl.php 6723 2010-01-15 21:55:10Z wooc $
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

// -- Tabela faktów GedCom
$factarray["ABBR"]	= "Skrót";
$factarray["ADDR"]	= "Adres";
$factarray["ADR1"]	= "Adres 1";
$factarray["ADR2"]	= "Adres 2";
$factarray["ADOP"]	= "Adopcja";
$factarray["AFN"]	= "Numer pliku genealogicznego (AFN)";
$factarray["AGE"]	= "W wieku";
$factarray["AGNC"]	= "Instytucja";
$factarray["ALIA"]	= "Znany(a) także jako";
$factarray["ANCE"]	= "Przodkowie";
$factarray["ANCI"]	= "Udział przodków";
$factarray["ANUL"]	= "Unieważnienie";
$factarray["ASSO"]	= "Powiązanie";
$factarray["AUTH"]	= "Autor";
$factarray["BAPL"]	= "Chrzest mormoński";
$factarray["BAPM"]	= "Chrzest baptystyczny";
$factarray["BARM"]	= "Bar micwa";
$factarray["BASM"]	= "Bas micwa";
$factarray["BIRT"]	= "Urodziny";
$factarray["BLES"]	= "Błogosławieństwo";
$factarray["BLOB"]	= "Obiekt binarny";
$factarray["BURI"]	= "Pogrzeb";
$factarray["CALN"]	= "Numer źródła";
$factarray["CAST"]	= "Kasta / Status społeczny";
$factarray["CAUS"]	= "Przyczyna śmierci";
$factarray["CEME"]	= "Cmentarz";
$factarray["CENS"]	= "Spis ludności";
$factarray["CHAN"]	= "Ostatnia zmiana";
$factarray["CHAR"]	= "Zestaw znaków";
$factarray["CHIL"]	= "Dziecko";
$factarray["CHR"]	= "Chrzest";
$factarray["CHRA"]	= "Chrzest dorosłego";
$factarray["CITY"]	= "Miasto";
$factarray["CONF"]	= "Bierzmowanie";
$factarray["CONL"]	= "Bierzmowanie mormońskie";
$factarray["COPR"]	= "Prawa autorskie";
$factarray["CORP"]	= "Korporacja / Firma";
$factarray["CREM"]	= "Kremacja";
$factarray["CTRY"]	= "Kraj";
$factarray["DATA"]	= "Dane";
$factarray["DATE"]	= "Data";
$factarray["DEAT"]	= "Śmierć";
$factarray["DESC"]	= "Potomkowie";
$factarray["DESI"]	= "Udział potomków";
$factarray["DEST"]	= "Cel";
$factarray["DIV"]	= "Rozwód";
$factarray["DIVF"]	= "Uzyskanie rozwodu";
$factarray["DSCR"]	= "Opis";
$factarray["EDUC"]	= "Wykształcenie";
$factarray["EMIG"]	= "Emigracja";
$factarray["ENDL"]	= "Obdarowanie mormońskie";
$factarray["ENGA"]	= "Zaręczyny";
$factarray["EVEN"]	= "Wydarzenie";
$factarray["FAM"]	= "Rodzina";
$factarray["FAMC"]	= "W rodzinie jako dziecko";
$factarray["FAMF"]	= "Plik rodziny";
$factarray["FAMS"]	= "Małżeństwo";
$factarray["FCOM"]	= "Pierwsza Komunia św.";
$factarray["FILE"]	= "Plik zewnętrzny";
$factarray["FORM"]	= "Format";
$factarray["GIVN"]	= "Imiona";
$factarray["GRAD"]	= "Ukończenie szkoły";
$factarray["HUSB"]	= "Mąż";
$factarray["IDNO"]	= "Numer identyfikacyjny";
$factarray["IMMI"]	= "Imigracja";
$factarray["LEGA"]	= "Legatariusz / Zapisobiorca";
$factarray["MARB"]	= "Zapowiedzi przedmałżeńskie";
$factarray["MARC"]	= "Kontrakt małżeński";
$factarray["MARL"]	= "Akt ślubu";
$factarray["MARR"]	= "Ślub";
$factarray["MARS"]	= "Ugoda małżeńska";
$factarray["MEDI"]	= "Typ multimediów";
$factarray["NAME"]	= "Nazwisko i imię";
$factarray["NATI"]	= "Narodowość";
$factarray["NATU"]	= "Naturalizacja";
$factarray["NCHI"]	= "Liczba dzieci";
$factarray["NICK"]	= "Przezwisko";
$factarray["NMR"]	= "Liczba małżeństw";
$factarray["NOTE"]	= "Notatka";
$factarray["NPFX"]	= "Przedrostek";
$factarray["NSFX"]	= "Przyrostek";
$factarray["OBJE"]	= "Obiekt multimedialny";
$factarray["OCCU"]	= "Zawód";
$factarray["ORDI"]	= "Obrządek";
$factarray["ORDN"]	= "Święcenia";
$factarray["PAGE"]	= "Szczegóły źródła";
$factarray["PEDI"]	= "Pochodzenie";
$factarray["PLAC"]	= "Miejsce";
$factarray["PHON"]	= "Telefon";
$factarray["POST"]	= "Kod pocztowy";
$factarray["PROB"]	= "Poświadczenie autentyczności testamentu";
$factarray["PROP"]	= "Własność";
$factarray["PUBL"]	= "Publikacja";
$factarray["QUAY"]	= "Cecha danych";
$factarray["REPO"]	= "Repozytorium";
$factarray["REFN"]	= "Numer referencyjny";
$factarray["RELA"]	= "Pokrewieństwo";
$factarray["RELI"]	= "Wyznanie";
$factarray["RESI"]	= "Miejsce zamieszkania";
$factarray["RESN"]	= "Ograniczenie";
$factarray["RETI"]	= "Przejście na emeryturę";
$factarray["RFN"]	= "Numer katalogowy wpisu";
$factarray["RIN"]	= "Identyfikator wpisu";
$factarray["ROLE"]	= "Rola";
$factarray["SEX"]	= "Płeć";
$factarray["SLGC"]	= "Mormońskie Naznaczenie Dziecka";
$factarray["SLGS"]	= "Mormońskie Naznaczenie Małżonka";
$factarray["SOUR"]	= "Źródło";
$factarray["SPFX"]	= "Przedrostek nazwiska";
$factarray["SSN"]	= "Numer ubezpieczenia (SSN)";
$factarray["STAE"]	= "Stan";
$factarray["STAT"]	= "Status";
$factarray["SUBM"]	= "Dane zebrane przez";
$factarray["SUBN"]	= "Wpis";
$factarray["SURN"]	= "Nazwisko";
$factarray["TEMP"]	= "Świątynia";
$factarray["TEXT"]	= "Tekst";
$factarray["TIME"]	= "Czas";
$factarray["TITL"]	= "Tytuł";
$factarray["TYPE"]	= "Typ";
$factarray["WIFE"]	= "Żona";
$factarray["WILL"]	= "Testament";
$factarray["_EMAIL"]= "Adres email";
$factarray["EMAIL"]	= "Adres email";
$factarray["_TODO"]	= "Do zrobienia";
$factarray["_UID"]	= "Globalny uniwersalny identyfikator";
$factarray["_PRIM"]	= "Wyróżnione zdjęcie";
$factarray["_DBID"]	= "Indentyfikator dołączonej bazy danych";

// These facts are used in specific contexts
$factarray["STAT:DATE"]	= "Data zmiany statusu";
$factarray["DATA:DATE"]	= "Data wpisu w oryginalnym źródle";

$factarray["NAME:_HEB"]	= "Nazwa w języku hebrajskim";
$factarray["PLAC:_HEB"]	= "Miejsce w języku hebrajskim";
$factarray["TITL:_HEB"]	= "Tytuł w języku hebrajskim";
$factarray["NAME:ROMN"]	= "Nazwa zlatynizowanie";
$factarray["PLAC:ROMN"]	= "Miejsce zlatynizowanie";
$factarray["TITL:ROMN"]	= "Tytuł zlatynizowany";
$factarray["NAME:FONE"]	= "Nazwa fonetycznie";
$factarray["PLAC:FONE"]	= "Miejsce fonetycznie";
$factarray["TITL:FONE"]	= "Tytuł fonetycznie";

$factarray["SHARED_NOTE"] = "Wspólna notatka";

//These facts are compounds for the view probabilities page
$factarray["FAMC:HUSB:SURN"]		= "Nazwisko ojca";
$factarray["FAMC:WIFE:SURN"]		= "Nazwisko matki";
$factarray["FAMC:HUSB:BIRT:PLAC"]	= "Miejsce urodzenia ojca";
$factarray["FAMC:WIFE:BIRT:PLAC"]	= "Miejsce urodzenia matki";
$factarray["FAMC:MARR:PLAC"]		= "Miejsce ślubu rodziców";
$factarray["FAMC:HUSB:OCCU"]		= "Zawód ojca";
$factarray[":BIRT:PLAC"]			= "Miejsce urodzenia";
$factarray["FAMS:MARR:PLAC"]		= "Miejsce ślubu";
$factarray["FAMS:MARR:DATE"]		= "Data ślubu";
$factarray["FAMS:SPOUSE:DEAT:PLAC"] = "Miejsce śmierci małżonka";
$factarray["FAMC:HUSB:GIVN"]		= "Imię ojca";
$factarray["FAMS:SPOUSE:BIRT:PLAC"] = "Miejsce urodzenia małżonka";
$factarray["FAMC:WIFE:GIVN"]		= "Imię matki";
$factarray["FAMC:HUSB:FAMC:HUSB:GIVN"] = "Imię dziadka ze strony ojca";
$factarray["FAMC:WIFE:FAMC:WIFE:GIVN"] = "Imię babci ze strony matki";
$factarray["FAMC:WIFE:FAMC:HUSB:GIVN"] = "Imię dziadka ze strony matki";
$factarray["FAMC:HUSB:FAMC:WIFE:GIVN"] = "Imię babci ze strony ojca";
$factarray["FAMS:CHIL:BIRT:PLAC"]	= "Miejsce urodzin dziecka";
$factarray["FAMS:NOTE"]			= "Notatka dot. małżonka";
$factarray["FAMS:CENS:DATE"]	= "Data spisu ludności małżonka";
$factarray["FAMS:CENS:PLAC"]	= "Miejsce spisu ludności małżonka";
$factarray["FAMS:DIV:DATE"]		= "Dara rozwodu małżonka";
$factarray["FAMS:DIV:PLAC"]		= "Miejsce rozwodu małżonka";
$factarray["FAMS:SLGS:DATE"]	= "Data Mormońskiego Naznaczenia Małżonka";
$factarray["FAMS:SLGS:PLAC"]	= "Miejsce Mormońskiego Naznaczenia Małżonka";
$factarray["FAMS:SLGS:TEMP"]	= "Świątynia Mormońskiego Naznaczenia Małżonka";

// These facts are all colon delimited
$factarray["BIRT:PLAC"] = "Miejsce urodzenia";
$factarray["BIRT:DATE"] = "Data urodzenia";
$factarray["BIRT:SOUR"] = "Źródło urodzin";
$factarray["DEAT:PLAC"] = "Miejsce śmierci";
$factarray["DEAT:DATE"] = "Data śmierci";
$factarray["DEAT:SOUR"] = "Źródło śmierci";
$factarray["CHR:PLAC"]  = "Miejsce chrztu";
$factarray["CHR:DATE"]  = "Data chrztu";
$factarray["CHR:SOUR"]	= "Źródło chrztu";
$factarray["CONF:PLAC"] = "Miejsce bierzmowania";
$factarray["CONF:DATE"] = "Data bierzmowania";
$factarray["CONF:SOUR"] = "Źródło bierzmowania";
$factarray["BAPM:PLAC"] = "Miejsce chrztu baptystycznego";
$factarray["BAPM:DATE"] = "Data chrztu baptystycznego";
$factarray["BAPM:SOUR"] = "Źródło chrztu baptystycznego";
$factarray["_BRTM:PLAC"] = "Miejsce Brit Mila";
$factarray["_BRTM:DATE"] = "Data Brit Mila";
$factarray["_BRTM:SOUR"] = "Źródło Brit Mila";
$factarray["BARM:PLAC"] = "Miejsce bar micwy";
$factarray["BARM:DATE"] = "Data bar micwy";
$factarray["BARM:SOUR"] = "Źródło bar micwy";
$factarray["BASM:PLAC"] = "Miejsce bas micwy";
$factarray["BASM:DATE"] = "Data bas micwy";
$factarray["BASM:SOUR"] = "Źródło bas micwy";
$factarray["BURI:PLAC"] = "Miejsce pochówku";
$factarray["BURI:DATE"] = "Data pochówku";
$factarray["BURI:SOUR"] = "Źródło pochówku";
$factarray["FCOM:PLAC"] = "Miejsce pierwszej Komunii św.";
$factarray["FCOM:DATE"] = "Data pierwszej Komunii św.";
$factarray["FCOM:SOUR"] = "Źródło pierwszej Komunii św.";
$factarray["MARB:PLAC"] = "Miejsce zapowiedzi przedmałżeńskich";
$factarray["MARB:DATE"] = "Data zapowiedzi przedmałżeńskich";
$factarray["MARB:SOUR"] = "Źródło zapowiedzi przedmałżeńskich";
$factarray["MARR:PLAC"] = "Miejsce ślubu";
$factarray["MARR:DATE"] = "Data ślubu";
$factarray["MARR:SOUR"] = "Źródło ślubu";
$factarray["ENGA:PLAC"] = "Miejsce zaręczyn";
$factarray["ENGA:DATE"] = "Data zaręczyn";
$factarray["ENGA:SOUR"] = "Źródło zaręczyn";

// Fakty specyficzne dla eksportu GedCom z programu Family Tree Maker
$factarray["_MDCL"] = "Służba medyczna";
$factarray["_DEG"]	= "Stopień";
$factarray["_MILT"] = "Służba wojskowa";
$factarray["_SEPR"] = "Separacja";
$factarray["_DETS"] = "Śmierć jednego z małżonków";
$factarray["CITN"]	= "Obywatelstwo";
$factarray["_FA1"]	= "Fakt 1";
$factarray["_FA2"]	= "Fakt 2";
$factarray["_FA3"]	= "Fakt 3";
$factarray["_FA4"]	= "Fakt 4";
$factarray["_FA5"]	= "Fakt 5";
$factarray["_FA6"]	= "Fakt 6";
$factarray["_FA7"]	= "Fakt 7";
$factarray["_FA8"]	= "Fakt 8";
$factarray["_FA9"]	= "Fakt 9";
$factarray["_FA10"]	= "Fakt 10";
$factarray["_FA11"]	= "Fakt 11";
$factarray["_FA12"]	= "Fakt 12";
$factarray["_FA13"]	= "Fakt 13";
$factarray["_MREL"]	= "Związek z matką";
$factarray["_FREL"]	= "Związek z ojcem";
$factarray["_MSTAT"]= "Status na początku małżeństwa";
$factarray["_MEND"]	= "Status na końcu małżeństwa";
$factarray["_NAMS"]	= "Imiennik";

// Fakty związane z GedCom 5.5.1 
$factarray["FAX"]	= "Faks";
$factarray["FACT"]	= "Fakt";
$factarray["WWW"]	= "Strona WWW";
$factarray["MAP"]	= "Mapa";
$factarray["LATI"]	= "Szerokość geograficzna";
$factarray["LONG"]	= "Długość geograficzna";
$factarray["FONE"]	= "Fonetycznie";
$factarray["ROMN"]	= "Zlatynizowane";

// Fakty związane z PAF
$factarray["_NAME"] = "Nazwisko adresowe";
$factarray["URL"]	= "Adres URL";
$factarray["_URL"]	= "Adres URL";
$factarray["_HEB"]	= "Hebrajskie";
$factarray["_SCBK"] = "Kronika";
$factarray["_TYPE"] = "Rodzaj mediów";
$factarray["_SSHOW"]= "Pokaz slajdów";

// Rootsmagic
$factarray["_SUBQ"]	= "Wersja skrócona";
$factarray["_BIBL"] = "Bibliografia";

// Reunion
$factarray["EMAL"]	= "Adres email";

// Other common customized facts
$factarray["_ADPF"]	= "Adopcja przez ojca";
$factarray["_ADPM"]	= "Adopcja przez matkę";
$factarray["_AKAN"]	= "Znany(a) także jako";
$factarray["_AKA"]	= "Znany(a) także jako";
$factarray["_BRTM"]	= "Obrzezanie";
$factarray["_COML"]	= "Małżeństwo zwyczajowe";
$factarray["_EYEC"]	= "Kolor oczu";
$factarray["_FNRL"]	= "Pogrzeb";
$factarray["_HAIR"]	= "Kolor włosów";
$factarray["_HEIG"]	= "Wzrost";
$factarray["_HOL"]  = "Holokaust";
$factarray["_INTE"]	= "Pochowany(a)";
$factarray["_MARI"]	= "Zapowiedzi";
$factarray["_MBON"]	= "Intercyza";
$factarray["_MEDC"]	= "Stan zdrowia";
$factarray["_MILI"]	= "Służba wojskowa";
$factarray["_NMR"]	= "Nieżonaty/niezamężna";
$factarray["_NLIV"]	= "Nie żyje";
$factarray["_NMAR"]	= "Nigdy nieżonaty/niezamężna";
$factarray["_PRMN"]	= "Stały numer";
$factarray["_WEIG"]	= "Waga";
$factarray["_YART"]	= "Yahrzeit";
$factarray["_MARNM"] = "Po ślubie";
$factarray["_MARNM_SURN"] = "Nazwisko po ślubie";
$factarray["_STAT"]	= "Stan cywilny";
$factarray["COMM"]	= "Komentarz";

// Aldfaer related facts
$factarray["MARR_CIVIL"]	= "Ślub cywilny";
$factarray["MARR_RELIGIOUS"]= "Ślub kościelny";
$factarray["MARR_PARTNERS"] = "Zarejestrowane partnerstwo";
$factarray["MARR_UNKNOWN"]	= "Małżeństwo nieznanego typu";

$factarray["_HNM"]			= "Nazwisko hebrajskie";

// Pseudo-facts for relatives
$factarray["_DEAT_SPOU"] = "Śmierć współmałżonka";
$factarray["_BURI_SPOU"] = "Pogrzeb współmałżonka";
$factarray["_CREM_SPOU"] = "Kremacja współmałżonka";

$factarray["_BIRT_CHIL"] = "Narodziny dziecka";
$factarray["_CHR_CHIL"] = "Chrzest dziecka";
$factarray["_BAPM_CHIL"] = "Chrzest baptystyczny dziecka";
$factarray["__BRTM_CHIL"]= "Obrzezanie dziecka";
$factarray["_ADOP_CHIL"] = "Adopcja dziecka";
$factarray["_MARR_CHIL"] = "Ślub dziecka";
$factarray["_MARB_CHIL"] = "Zapowiedzi przedmałżeńskie dziecka";
$factarray["_DEAT_CHIL"] = "Śmierć dziecka";
$factarray["_BURI_CHIL"] = "Pogrzeb dziecka";
$factarray["_CREM_CHIL"] = "Kremacja dziecka";

$factarray["_BIRT_GCHI"] = "Narodziny wnuka/wnuczki";
$factarray["_CHR_GCHI"] = "Chrzest wnuka/wnuczki";
$factarray["_BAPM_GCHI"] = "Chrzest baptystyczny wnuka/wnuczki";
$factarray["__BRTM_GCHI"]= "Obrzezanie wnuka/wnuczki";
$factarray["_ADOP_GCHI"] = "Adopcja wnuka/wnuczki";
$factarray["_MARR_GCHI"] = "Ślub wnuka/wnuczki";
$factarray["_MARB_GCHI"] = "Zapowiedzi przedmałżeńskie wnuka/wnuczki";
$factarray["_DEAT_GCHI"] = "Śmierć wnuka/wnuczki";
$factarray["_BURI_GCHI"] = "Pogrzeb wnuka/wnuczki";
$factarray["_CREM_GCHI"] = "Kremacja wnuka/wnuczki";

$factarray["_BIRT_GGCH"] = "Narodziny prawnuka/prawnuczki";
$factarray["_CHR_GGCH"] = "Chrzest prawnuka/prawnuczki";
$factarray["_BAPM_GGCH"] = "Chrzest baptystyczny prawnuka/prawnuczki";
$factarray["__BRTM_GGCH"]= "Obrzezanie prawnuka/prawnuczki";
$factarray["_ADOP_GGCH"] = "Adopcja prawnuka/prawnuczki";
$factarray["_MARR_GGCH"] = "Ślub prawnuka/prawnuczki";
$factarray["_MARB_GGCH"] = "Zapowiedzi przedmałżeńskie prawnuka";
$factarray["_DEAT_GGCH"] = "Śmierć prawnuka/prawnuczki";
$factarray["_BURI_GGCH"] = "Pogrzeb prawnuka/prawnuczki";
$factarray["_CREM_GGCH"] = "Kremacja prawnuka/prawnuczki";

$factarray["_MARR_FATH"] = "Ślub ojca";
$factarray["_MARB_FATH"] = "Zapowiedzi przedmałżeńskie ojca";
$factarray["_DEAT_FATH"] = "Śmierć ojca";
$factarray["_BURI_FATH"] = "Pogrzeb ojca";
$factarray["_CREM_FATH"] = "Kremacja ojca";

$factarray["_MARR_FAMC"] = "Ślub rodziców";
$factarray["_MARB_FAMC"] = "Zapowiedzi przedmałżeńskie rodziców";

$factarray["_MARR_MOTH"] = "Ślub matki";
$factarray["_MARB_MOTH"] = "Zapowiedzi przedmałżeńskie matki";
$factarray["_DEAT_MOTH"] = "Śmierć matki";
$factarray["_BURI_MOTH"] = "Pogrzeb matki";
$factarray["_CREM_MOTH"] = "Kremacja matki";

$factarray["_BIRT_SIBL"] = "Narodziny brata/siostry";
$factarray["_CHR_SIBL"] = "Chrzest brata/siostry";
$factarray["_BAPM_SIBL"] = "Chrzest baptystyczny brata/siostry";
$factarray["__BRTM_SIBL"]= "Obrzezanie brata/siostry";
$factarray["_ADOP_SIBL"] = "Adopcja brata/siostry";
$factarray["_MARR_SIBL"] = "Ślub brata/siostry";
$factarray["_MARB_SIBL"] = "Zapowiedzi przedmałżeńskie brata/siostry";
$factarray["_DEAT_SIBL"] = "Śmierć brata/siostry";
$factarray["_BURI_SIBL"] = "Pogrzeb brata/siostry";
$factarray["_CREM_SIBL"] = "Kremacja brata/siostry";

$factarray["_BIRT_HSIB"] = "Narodziny brata przyrodniego/siostry przyrodniej";
$factarray["_CHR_HSIB"] = "Chrzest brata przyrodniego/siostry przyrodniej";
$factarray["_BAPM_HSIB"] = "Chrzest baptystyczny brata przyrodniego/siostry przyrodniej";
$factarray["__BRTM_HSIB"]= "Obrzezanie brata przyrodniego/siostry przyrodniej";
$factarray["_ADOP_HSIB"] = "Adopcja brata przyrodniego/siostry przyrodniej";
$factarray["_MARR_HSIB"] = "Ślub brata przyrodniego/siostry przyrodniej";
$factarray["_MARB_HSIB"] = "Zapowiedzi przedmałżeńskie brata przyrodniego/siostry przyrodniej";
$factarray["_DEAT_HSIB"] = "Śmierć brata przyrodniego/siostry przyrodniej";
$factarray["_BURI_HSIB"] = "Pogrzeb brata przyrodniego/siostry przyrodniej";
$factarray["_CREM_HSIB"] = "Kremacja brata przyrodniego/siostry przyrodniej";

$factarray["_BIRT_NEPH"] = "Narodziny siostrzeńca/bratanka lub siostrzenicy/bratanicy";
$factarray["_CHR_NEPH"] = "Chrzest bratanka/bratanicy lub siostrzeńca/siostrzenicy";
$factarray["_BAPM_NEPH"] = "Chrzest baptystyczny bratanka/bratanicy lub siostrzeńca/siostrzenicy";
$factarray["__BRTM_NEPH"]= "Obrzezanie bratanka/bratanicy lub siostrzeńca/siostrzenicy";
$factarray["_ADOP_NEPH"] = "Adopcja bratanka/bratanicy lub siostrzeńca/siostrzenicy";
$factarray["_MARR_NEPH"] = "Ślub siostrzeńca/bratanka lub siostrzenicy/bratanicy";
$factarray["_MARB_NEPH"] = "Zapowiedzi przedmałżeńskie siostrzeńca/bratanka lub siostrzenicy/bratanicy";
$factarray["_DEAT_NEPH"] = "Śmierć siostrzeńca/bratanka lub siostrzenicy/bratanicy";
$factarray["_BURI_NEPH"] = "Pogrzeb siostrzeńca/bratanka lub siostrzenicy/bratanicy";
$factarray["_CREM_NEPH"] = "Kremacja siostrzeńca/bratanka lub siostrzenicy/bratanicy";

$factarray["_DEAT_GPAR"] = "Śmierć babci/dziadka";
$factarray["_BURI_GPAR"] = "Pogrzeb dziadka/babci";
$factarray["_CREM_GPAR"] = "Kremacja dziadka/babci";

$factarray["_DEAT_GGPA"] = "Śmierć pradziadka/prababci";
$factarray["_BURI_GGPA"] = "Pogrzeb pradziadka/prababci";
$factarray["_CREM_GGPA"] = "Kremacja pradziadka/prababci";

$factarray["_BIRT_FSIB"] = "Narodziny brata/siostry ojca";
$factarray["_CHR_FSIB"] = "Chrzest wuja/ciotki";
$factarray["_BAPM_FSIB"] = "Chrzest baptystyczny wuja/ciotki";
$factarray["__BRTM_FSIB"]= "Obrzezanie wuja/ciotki";
$factarray["_ADOP_FSIB"] = "Adopcja wuja/ciotki";
$factarray["_MARR_FSIB"] = "Ślub brata/siostry ojca";
$factarray["_MARB_FSIB"] = "Zapowiedzi przedmałżeńskie brata/siostry ojca";
$factarray["_DEAT_FSIB"] = "Śmierć brata/siostry ojca";
$factarray["_BURI_FSIB"] = "Pogrzeb rodzeństwa ojca";
$factarray["_CREM_FSIB"] = "Kremacja rodzeństwa ojca";

$factarray["_BIRT_MSIB"] = "Narodziny brata/siostry matki";
$factarray["_CHR_MSIB"] = "Chrzest wuja/ciotki";
$factarray["_BAPM_MSIB"] = "Chrzest baptystyczny wuja/ciotki";
$factarray["__BRTM_MSIB"]= "Obrzezanie wuja/ciotki";
$factarray["_ADOP_MSIB"] = "Adopcja wuja/ciotki";
$factarray["_MARR_MSIB"] = "Ślub brata/siostry matki";
$factarray["_MARB_MSIB"] = "Zapowiedzi przedmałżeńskie brata/siostry matki";
$factarray["_DEAT_MSIB"] = "Śmierć brata/siostry matki";
$factarray["_BURI_MSIB"] = "Pogrzeb rodzeństwa matki";
$factarray["_CREM_MSIB"] = "Kremacja rodzeństwa matki";

$factarray["_BIRT_COUS"] = "Narodziny pierwszego kuzyna/kuzynki";
$factarray["_CHR_COUS"]  = "Chrzest kuzyna/kuzynki";
$factarray["_BAPM_COUS"] = "Chrzest baptystyczny kuzyna/kuzynki";
$factarray["__BRTM_COUS"]= "Obrzezanie kuzyna/kuzynki";
$factarray["_ADOP_COUS"] = "Adopcja kuzyna/kuzynki";
$factarray["_MARR_COUS"] = "Ślub pierwszego kuzyna/kuzynki";
$factarray["_MARB_COUS"] = "Zapowiedzi przedmałżeńskie pierwszego kuzyna/kuzynki";
$factarray["_DEAT_COUS"] = "Śmierć pierwszego kuzyna/kuzynki";
$factarray["_BURI_COUS"] = "Pogrzeb kuzyna/kuzynki";
$factarray["_CREM_COUS"] = "Kremacja kuzyna/kuzynki";

$factarray["_FAMC_EMIG"] = "Emigracja rodziców";
$factarray["_FAMC_RESI"] = "Miejsce zamieszkania rodziców";

//-- PGV Only facts
$factarray["_THUM"] = "Zawsze używać głównego obrazu?";
$factarray["_PGVU"] = "przez";
$factarray["SERV"]	= "Zdalny serwer";
$factarray["_GEDF"] = "Plik GEDCOM";

/*-- Fact abbreviations for use in Chart boxes.
 *			Use these abbreviations in cases where the standard method of using the first
 *			letter of the spelled-out name results in an undesirable abbreviation or where
 *			you want to produce a different result (eg: "x" instead of "M" for "Married").
 *
 *			You can abbreviate any Fact label this way.  The list of abbreviations is
 *			open-ended.
 *
 *			These abbreviations are user-customizable. Just put them into file "extra.xx.php".
 *			The length of these abbreviations is not restricted to 1 letter.
 */

$factAbbrev["BIRT"]		= "Ur.";
$factAbbrev["MARR"]		= "Małż.";
$factAbbrev["DEAT"]		= "Zm.";

?>
