<?php
/**
 * Norwegian texts
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2009  PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * # $Id: facts.no.php 5231 2009-03-19 01:02:56Z canajun2eh $
 *
 * @translator Geir Håkon Eikland
 * @translator Thomas Rindal
 * @package PhpGedView
 * @subpackage Languages
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

// -- Define a fact array to map GEDCOM tags with their Norwegian values
$factarray["ABBR"] = "Forkortelse";
$factarray["ADDR"] = "Adresse";
$factarray["ADR1"] = "Adresse 1";
$factarray["ADR2"] = "Adresse 2";
$factarray["ADOP"] = "Adoptert";
$factarray["AFN"]  = "Slekts-filnr";
$factarray["AGE"]  = "Alder";
$factarray["AGNC"] = "Agentur";
$factarray["ALIA"] = "Alias";
$factarray["ANCE"] = "Forfedre";
$factarray["ANCI"] = "Mangler forfedre...";
$factarray["ANUL"] = "Annullert ekteskap";
$factarray["ASSO"] = "Forbindelser";
$factarray["AUTH"] = "Forfatter";
$factarray["BAPL"] = "Døpt Mormoner";
$factarray["BAPM"] = "Døpt på bekjennelse";
$factarray["BARM"] = "Bar Mitzvah Jødisk sermoni gutt";
$factarray["BASM"] = "Bat Mitzvah Jødisk sermoni jente";
$factarray["BIRT"] = "Født";
$factarray["BLES"] = "Velsignet / Navnefest";
$factarray["BLOB"] = "Binært dataobjekt";
$factarray["BURI"] = "Gravlagt";
$factarray["CALN"] = "Arkivnr./ISBN/ISSN";
$factarray["CAST"] = "Kaste / Sosial status";
$factarray["CAUS"] = "Dødsårsak";
$factarray["CEME"] = "Kirkegård /Gravplass";
$factarray["CENS"] = "Folketelling";
$factarray["CHAN"] = "Sist endret";
$factarray["CHAR"] = "Tegnsett";
$factarray["CHIL"] = "Barn";
$factarray["CHR"]  = "Barnedåp";
$factarray["CHRA"] = "Voksendåp";
$factarray["CITY"] = "Sted/by";
$factarray["CONF"] = "Konfirmasjon";
$factarray["CONL"] = "Konfirmert Mormoner";
$factarray["COPR"] = "Opphavsrett / Copyright";
$factarray["CORP"] = "Bedrifts-/firmanavn";
$factarray["CREM"] = "Kremasjon";
$factarray["CTRY"] = "Land";
$factarray["DATE"] = "Dato";
$factarray["DATA"] = "Data";
$factarray["DEAT"] = "Død";
$factarray["DESC"] = "Etterkommere";
$factarray["DESI"] = "Mangler etterkommer(e)...";
$factarray["DEST"] = "Mål";
$factarray["DIV"]  = "Skilsmisse";
$factarray["DIVF"] = "Skilsmissebegjæring";
$factarray["DSCR"] = "Beskrivelse";
$factarray["EDUC"] = "Utdannelse";
$factarray["EMIG"] = "Utvandret";
$factarray["ENDL"] = "Gave Mormorer";
$factarray["ENGA"] = "Forlovet";
$factarray["EVEN"] = "Hendelse";
$factarray["FAM"]  = "Familie";
$factarray["FAMC"] = "Familie-ID for barn";
$factarray["FAMF"] = "Familiekort";
$factarray["FAMS"] = "Familie-ID for ektefelle/partner";
$factarray["FCOM"] = "Første nattverd-måltid";
$factarray["FILE"] = "Ekstern fil";
$factarray["FORM"] = "Format / type";
$factarray["GIVN"] = "Fornavn";
$factarray["GRAD"] = "Uteksaminert";
$factarray["HUSB"] = "Ektemann";
$factarray["IDNO"] = "Identifikasjonsnr.";
$factarray["IMMI"] = "Innvandret";
$factarray["LEGA"] = "Arving";
$factarray["MARB"] = "Lysning til ekteskap";
$factarray["MARC"] = "Ekteskapskontrakt";
$factarray["MARL"] = "Ekteskapsattest";
$factarray["MARR"] = "Ekteskap";
$factarray["MARS"] = "Ekteskapsavtale";
$factarray["MEDI"] = "Media-type";
$factarray["NAME"] = "Navn";
$factarray["NATI"] = "Nasjonalitet";
$factarray["NATU"] = "Statsborgerskap";
$factarray["NCHI"] = "Antall barn";
$factarray["NICK"] = "Klengenavn";
$factarray["NMR"]  = "Antall ekteskap";
$factarray["NOTE"] = "Note";
$factarray["NPFX"] = "Prefiks";
$factarray["NSFX"] = "Postfiks";
$factarray["OBJE"] = "Multimedia objekt";
$factarray["OCCU"] = "Yrke";
$factarray["ORDI"] = "Rituale Mormoner";
$factarray["ORDN"] = "Ordinert rel. tjeneste";
$factarray["PAGE"] = "Dokument referanse";
$factarray["PEDI"] = "Slektsgrein";
$factarray["PLAC"] = "Stedsnavn";
$factarray["PHON"] = "Telefonnummer.";
$factarray["POST"] = "Postnummer";
$factarray["PROB"] = "Skifte";
$factarray["PROP"] = "Eiendom";
$factarray["PUBL"] = "Publikasjon";
$factarray["QUAY"] = "Datakvalitet (0-3)";
$factarray["REPO"] = "Oppbevaringssted";
$factarray["REFN"] = "Referensenummer";
$factarray["RELA"] = "Forbindelse";
$factarray["RELI"] = "Religion";
$factarray["RESI"] = "Bosted";
$factarray["RESN"] = "Restriksjon";
$factarray["RETI"] = "Pensjonert";
$factarray["RFN"]  = "Ref.nr. (statisk)";
$factarray["RIN"]  = "Ref.nr. (dynamisk)";
$factarray["ROLE"] = "Rolle i hendelse";
$factarray["SEX"]  = "Kjønn";
$factarray["SLGC"] = "Barn-kobling Mormoner";
$factarray["SLGS"] = "Ekteskap-kobling Mormoner";
$factarray["SOUR"] = "Kilde";
$factarray["SPFX"] = "Etternavn prefiks";
$factarray["SSN"]  = "Social Security Number";
$factarray["STAE"] = "Stat/Region";
$factarray["STAT"] = "Status";
$factarray["SUBM"] = "Bidragsgiver/Avsender";
$factarray["SUBN"] = "Del av datasamling";
$factarray["SURN"] = "Etternavn";
$factarray["TEMP"] = "Mormoner kirkekode";
$factarray["TEXT"] = "Kildetekst";
$factarray["TIME"] = "Klokkeslett";
$factarray["TITL"] = "Tittel";
$factarray["TYPE"] = "Type";
$factarray["WIFE"] = "Hustru";
$factarray["WILL"] = "Testamente";
$factarray["_EMAIL"] = "E-post-adresse";
$factarray["EMAIL"] = "E-post-adresse";
$factarray["_TODO"] = "Utestående gjøremål";
$factarray["_UID"] = "Universell ID";
$factarray["_PRIM"]	= "Merket som hovedbilde";
$factarray["_DBID"] = "Linket database ID";

// These facts are used in specific contexts
$factarray["STAT:DATE"] = "Statusendringsdato";

//These facts are compounds for the view probabilities and the advanced search pages
$factarray["FAMC:HUSB:SURN"] = "Farens etternavn";
$factarray["FAMC:WIFE:SURN"] = "Morens etternavn";
$factarray["FAMC:HUSB:BIRT:PLAC"] = "Farens fødested";
$factarray["FAMC:WIFE:BIRT:PLAC"] = "Morens fødested";
$factarray["FAMC:MARR:PLAC"] = "Foreldrenes vielsessted";
$factarray["FAMC:HUSB:OCCU"] = "Farens yrke";
$factarray[":BIRT:PLAC"] = "Fødested";
$factarray["FAMS:MARR:PLAC"] = "Vielsessted";
$factarray["FAMS:MARR:DATE"] = "Vielsesdato";
$factarray["FAMS:SPOUSE:DEAT:PLAC"] = "Ektefellens dødssted";
$factarray["FAMC:HUSB:GIVN"] = "Farens fornavn";
$factarray["FAMS:SPOUSE:BIRT:PLAC"] = "Ektefellens fødested";
$factarray["FAMC:WIFE:GIVN"] = "Morens fornavn";
$factarray["FAMC:HUSB:FAMC:HUSB:GIVN"] = "Farfarens fornavn";
$factarray["FAMC:WIFE:FAMC:WIFE:GIVN"] = "Mormorens fornavn";
$factarray["FAMC:WIFE:FAMC:HUSB:GIVN"] = "Morfarens fornavn";
$factarray["FAMC:HUSB:FAMC:WIFE:GIVN"] = "Farmorens fornavn";
$factarray["FAMS:CHIL:BIRT:PLAC"] = "Barnets fødested";
$factarray["FAMS:NOTE"] = "Ektefelle merknad";
$factarray["FAMS:CENS:DATE"] = "Ektefellens folketellingsdato";
$factarray["FAMS:CENS:PLAC"] = "Ektefellens folketellingssted";
$factarray["FAMS:DIV:DATE"] = "Ektefellens skilsmissedato";
$factarray["FAMS:DIV:PLAC"] = "Ektefellens skilsmissested";
$factarray["FAMS:SLGS:DATE"] = "Dato for LDS besegling av ekteskap";
$factarray["FAMS:SLGS:PLAC"] = "Sted for LDS besegling av ekteskap";
$factarray["FAMS:SLGS:TEMP"] = "Tempel for LDS besegling av ekteskap";

// These facts are all colon delimited
$factarray["BIRT:PLAC"] = "Fødested";
$factarray["BIRT:DATE"] = "Fødselsdato";
$factarray["DEAT:PLAC"] = "Dødssted";
$factarray["DEAT:DATE"] = "Dødsdato";
$factarray["CHR:PLAC"] = "Dåpssted";
$factarray["CHR:DATE"] = "Dåpsdato";
$factarray["BAPM:PLAC"] = "Dåpssted";
$factarray["BAPM:DATE"] = "Dåpsdato";
$factarray["BURI:PLAC"] = "Begravelsens sted";
$factarray["BURI:DATE"] = "Gravlagt dato";
$factarray["MARR:PLAC"] = "Vielsessted";
$factarray["MARR:DATE"] = "Vielsesdato";

// These facts are specific to GEDCOM exports from Family Tree Maker
$factarray["_MDCL"] = "Helse";
$factarray["_DEG"] 	= "Akademisk grad";
$factarray["_MILT"] = "Militærtjeneste";
$factarray["_SEPR"] = "Separert";
$factarray["_DETS"] = "Ektefelles død";
$factarray["CITN"] 	= "Statsborgerskap";
$factarray["_FA1"]	= "Fakta 1";
$factarray["_FA2"]	= "Fakta 2";
$factarray["_FA3"]	= "Fakta 3";
$factarray["_FA4"]	= "Fakta 4";
$factarray["_FA5"]	= "Fakta 5";
$factarray["_FA6"]	= "Fakta 6";
$factarray["_FA7"]	= "Fakta 7";
$factarray["_FA8"]	= "Fakta 8";
$factarray["_FA9"]	= "Fakta 9";
$factarray["_FA10"]	= "Fakta 10";
$factarray["_FA11"]	= "Fakta 11";
$factarray["_FA12"]	= "Fakta 12";
$factarray["_FA13"]	= "Fakta 13";
$factarray["_MREL"]	= "Tilknytning til mor";
$factarray["_FREL"]	= "Tilknytning til far";
$factarray["_MSTAT"] = "Ekteskap start-status";
$factarray["_MEND"]	= "Ekteskap slutt-status";
$factarray["_NAMS"]	= "Navnesak";

// GEDCOM 5.5.1 related facts
$factarray["FAX"]	= "Faks";
$factarray["FACT"]	= "Fakta";
$factarray["WWW"]	= "Hjemmeside";
$factarray["MAP"]	= "Kart";
$factarray["LATI"]	= "Breddegrad";
$factarray["LONG"]	= "Lengdegrad";
$factarray["FONE"]	= "Fonetisk";
$factarray["ROMN"]	= "Romanisert";

// PAF related facts
$factarray["_NAME"]	= "Navn på postmottager";
$factarray["URL"]	= "URL (internett-adresse)";
$factarray["_URL"]	= "URL (internett-adresse)";
$factarray["_HEB"]	= "Hebraisk";
$factarray["_SCBK"] = "Utklippsbok";
$factarray["_TYPE"] = "Media-type";
$factarray["_SSHOW"] = "Lysbildeframvining";

// Rootsmagic
$factarray["_SUBQ"]	= "Kortversjon";
$factarray["_BIBL"] = "Bibliografi";

// Reunion
$factarray["EMAL"]	= "E-postadresse";

// Other common customized facts
$factarray["_ADPF"] = "Adopteret av faren";
$factarray["_ADPM"] = "Adopteret av moren";
$factarray["_AKAN"] = "Også kjent som";
$factarray["_AKA"] 	= "Også kjent som";
$factarray["_BRTM"] = "Brit mila Jødisk omskjæring";
$factarray["_COML"]	= "Samboerskap";
$factarray["_EYEC"] = "Øyefarge";
$factarray["_FNRL"] = "Bisettelse";
$factarray["_HAIR"] = "Hårfarve";
$factarray["_HEIG"] = "Høyde";
$factarray["_HOL"]  = "Holocaust";
$factarray["_INTE"] = "Urnenedsettelse";
$factarray["_MARI"] = "Ekteskaps-intensjon";
$factarray["_MBON"] = "Ekteskapsgaranti";
$factarray["_MEDC"] = "Helsetilstand";
$factarray["_MILI"] = "Milit&oelig;rtjeneste";
$factarray["_NMR"] = "Samboer";
$factarray["_NLIV"] = "Lever ikke";
$factarray["_NMAR"] = "Aldri gift";
$factarray["_PRMN"] = "Permanent nummer";
$factarray["_WEIG"] = "Vekt";
$factarray["_YART"] = "Yartzeit Jødisk fødselsdag";
$factarray["_MARNM"] = "Navn som gift";
$factarray["_MARNM_SURN"] = "Etternavn som gift";
$factarray["_STAT"]	= "Sivilstatus";
$factarray["COMM"]	= "Kommentar";

// Aldfaer related facts
$factarray["MARR_CIVIL"] = "Borgelig vielse";
$factarray["MARR_RELIGIOUS"] = "Kirkelig vielse";
$factarray["MARR_PARTNERS"] = "Registert partnerskap";
$factarray["MARR_UNKNOWN"] = "Ukjent form for vielse";

$factarray["_HNM"] = "Hebraisk navn";

// Pseudo-facts for relatives
$factarray["_DEAT_SPOU"] = "Dødsfall til ektefelle";
$factarray["_BURI_SPOU"] = "Begravelse til ektefelle";
$factarray["_CREM_SPOU"] = "Kremasjon av ektefelle";

$factarray["_BIRT_CHIL"] = "Fødsel til barn";
$factarray["_CHR_CHIL"] = "Barnedåp for barn";
$factarray["_BAPM_CHIL"] = "Dåp forbarn";
$factarray["__BRTM_CHIL"] = "Barns Brit Mila";
$factarray["_ADOP_CHIL"] = "Adopsjon av barn";
$factarray["_MARR_CHIL"] = "Ekteskap til barn";
$factarray["_MARB_CHIL"] = "Lysning av ekteskap til barn";
$factarray["_DEAT_CHIL"] = "Barns dødsfall";
$factarray["_BURI_CHIL"] = "Begravelse av barn";
$factarray["_CREM_CHIL"] = "Kremasjon av barn";

$factarray["_BIRT_GCHI"] = "Fødsel til et barnebarn";
$factarray["_CHR_GCHI"] = "Barnedåp til et barnebarn";
$factarray["_BAPM_GCHI"] = "Dåp for et barnebarn";
$factarray["__BRTM_GCHI"] = "Brit Mila for et barnebarn";
$factarray["_ADOP_GCHI"] = "Adopsjon til et barnebarn";
$factarray["_MARR_GCHI"] = "Ekteskap til et barnebarn";
$factarray["_MARB_GCHI"] = "Lysning av ekteskap for et barnebarn";
$factarray["_DEAT_GCHI"] = "Dødsfall til et barnebarn";
$factarray["_BURI_GCHI"] = "Begravelse av et barnebarn";
$factarray["_CREM_GCHI"] = "Kremasjon av et barnebarn";

$factarray["_BIRT_GGCH"] = "Fødsel til et oldebarn";
$factarray["_CHR_GGCH"] = "Barnedåp for et oldebarn";
$factarray["_BAPM_GGCH"] = "Dåp til et oldebarn";
$factarray["__BRTM_GGCH"] = "Brit Mila til et oldebarn";
$factarray["_ADOP_GGCH"] = "Adopsjon til et oldebarn";
$factarray["_MARR_GGCH"] = "Ekteskap til et oldebarn";
$factarray["_MARB_GGCH"] = "Lysning av ekteskap til et oldebarn";
$factarray["_DEAT_GGCH"] = "Dødsfall til et oldebarn";
$factarray["_BURI_GGCH"] = "Begravelse av et oldebarn";
$factarray["_CREM_GGCH"] = "Kremasjon av et oldebarn";

$factarray["_MARR_FATH"] = "Ekteskap til faren";
$factarray["_MARB_FATH"] = "Lysning av ekteskap til faren";
$factarray["_DEAT_FATH"] = "Farens dødsfall";
$factarray["_BURI_FATH"] = "Farens begravelse";
$factarray["_CREM_FATH"] = "Kremasjon av faren";

$factarray["_MARR_FAMC"] = "Foreldrenes ektekskap";
$factarray["_MARB_FAMC"] = "Lysning av foreldrenes ekteskap";

$factarray["_MARR_MOTH"] = "Morens ekteskap";
$factarray["_MARB_MOTH"] = "Lysning av morens ekteskap";
$factarray["_DEAT_MOTH"] = "Morens dødsfall";
$factarray["_BURI_MOTH"] = "Morens begravelse";
$factarray["_CREM_MOTH"] = "Kremasjon av moren";

$factarray["_BIRT_SIBL"] = "Fødsel til et søsken";
$factarray["_CHR_SIBL"] = "Barnedåp for et søsken";
$factarray["_BAPM_SIBL"] = "Dåp av et søsken";
$factarray["__BRTM_SIBL"] = "Brit Mila for et søsken";
$factarray["_ADOP_SIBL"] = "Adopsjon til et søsken";
$factarray["_MARR_SIBL"] = "Ekteskap til et søsken";
$factarray["_MARB_SIBL"] = "Lysning av ekteskap til et søsken";
$factarray["_DEAT_SIBL"] = "Dødsfall: en av søsknene";
$factarray["_BURI_SIBL"] = "Begravelse av et søsken";
$factarray["_CREM_SIBL"] = "Kremasjon av et søsken";

$factarray["_BIRT_HSIB"] = "Fødsel til et halvsøsken";
$factarray["_CHR_HSIB"] = "Barnedåp for et halvsøsken";
$factarray["_BAPM_HSIB"] = "Dåp av et halvsøsken";
$factarray["__BRTM_HSIB"] = "Brit Mila for et halvsøsken";
$factarray["_ADOP_HSIB"] = "Adopsjon til et halvsøsken";
$factarray["_MARR_HSIB"] = "Ekteskap til et halvsøsken";
$factarray["_MARB_HSIB"] = "Lysning av ekteskap til et halvsøsken";
$factarray["_DEAT_HSIB"] = "Dødsfall til et halvsøsken";
$factarray["_BURI_HSIB"] = "Begravelse av et halvsøsken";
$factarray["_CREM_HSIB"] = "Kremasjon av et halvsøsken";

$factarray["_BIRT_NEPH"] = "Fødsel til et søskenbarn";
$factarray["_CHR_NEPH"] = "Barnedåp for et søskenbarn";
$factarray["_BAPM_NEPH"] = "Dåp for et søskenbarn";
$factarray["__BRTM_NEPH"] = "Brit Mila for et søskenbarn";
$factarray["_ADOP_NEPH"] = "Adopsjon til et søskenbarn";
$factarray["_MARR_NEPH"] = "Ekteskap til et søskenbarn";
$factarray["_MARB_NEPH"] = "Lysning av ekteskap for et søskenbarn";
$factarray["_DEAT_NEPH"] = "Dødsfall til et søskenbarn";
$factarray["_BURI_NEPH"] = "Begravelse av et søskenbarn";
$factarray["_CREM_NEPH"] = "Kremasjon av et søskenbarn";

$factarray["_DEAT_GPAR"] = "Dødsfall til en av besteforeldrene";
$factarray["_BURI_GPAR"] = "Begravelse av en av besteforeldrene";
$factarray["_CREM_GPAR"] = "Kremasjon av en av besteforeldrene";
$factarray["_DEAT_GGPA"] = "Dødsfall til en av oldeforeldrene";
$factarray["_BURI_GGPA"] = "Begravelse av en av oldeforeldrene";
$factarray["_CREM_GGPA"] = "Kremasjon av en av oldeforeldrene";

$factarray["_BIRT_FSIB"] = "Fødsel til en av farens søsken";
$factarray["_CHR_FSIB"] = "Barnedåp for en av farens søsken";
$factarray["_BAPM_FSIB"] = "Dåp for en av farens søsken";
$factarray["__BRTM_FSIB"] = "Brit Mila for en av farens søsken";
$factarray["_ADOP_FSIB"] = "Adopsjon til en av farens søsken";
$factarray["_MARR_FSIB"] = "Ekteskap til en av farens søsken";
$factarray["_MARB_FSIB"] = "Lysning av ekteskap for en av farens søsken";
$factarray["_DEAT_FSIB"] = "Dødsfall til en av farens søsken";
$factarray["_BURI_FSIB"] = "Begravelse av en av farens søsken";
$factarray["_CREM_FSIB"] = "Kremasjon av en av farens søsken";

$factarray["_BIRT_MSIB"] = "Fødsel til en av morens søsken ";
$factarray["_CHR_MSIB"] = "Barnedåp for en av morens søsken";
$factarray["_BAPM_MSIB"] = "Dåp for en av morens søsken";
$factarray["__BRTM_MSIB"] = "Brit Mila for en av morens søsken";
$factarray["_ADOP_MSIB"] = "Adopsjon til en av morens søsken";
$factarray["_MARR_MSIB"] = "Ekteskap til en av morens søsken";
$factarray["_MARB_MSIB"] = "Lysning av ekteksp for en av morens søsken";
$factarray["_DEAT_MSIB"] = "Dødsfall til en av morens søsken";
$factarray["_BURI_MSIB"] = "Begravelse av en av morens søsken";
$factarray["_CREM_MSIB"] = "Kremasjon av en av morens søsken";

$factarray["_BIRT_COUS"] = "Fødsel til en tremenning";
$factarray["_CHR_COUS"]  = "Barnedåp for en tremenning";
$factarray["_BAPM_COUS"] = "Dåp for en tremenning";
$factarray["__BRTM_COUS"] = "Brit Mila for en tremenning";
$factarray["_ADOP_COUS"] = "Adopsjon til en tremenning";
$factarray["_MARR_COUS"] = "Ekteskap til en tremenning";
$factarray["_MARB_COUS"] = "Lysning av ekteskap til en tremenning";
$factarray["_DEAT_COUS"] = "Dødsfall til en tremenning";
$factarray["_BURI_COUS"] = "Begravelse av en tremenning";
$factarray["_CREM_COUS"] = "Kremasjon av en tremenning";

$factarray["_FAMC_EMIG"] = "Foreldrenes emigrasjon";
$factarray["_FAMC_RESI"] = "Foreldrenes bosted";

//-- PGV Only facts
$factarray["_THUM"]	= "Bruke dette bilde som passfoto?";
$factarray["_PGVU"]	= "Sist oppdatert av";
$factarray["SERV"] = "Fjerntjener";
$factarray["_GEDF"] = "GEDCOM-fil";

/*-- Fact abbreviations for use in Chart boxes.
 *		Use these abbreviations in cases where the standard method of using the first
 *		letter of the spelled-out name results in an undesirable abbreviation or where
 *		you want to produce a different result (eg: "x" instead of "M" for "Married").
 *
 *		You can abbreviate any Fact label this way.  The list of abbreviations is
 *		open-ended.
 *
 *		These abbreviations are user-customizable. Just put them into file "extra.xx.php".
 *		The length of these abbreviations is not restricted to 1 letter.
 */

/*-- The following lines have been commented out.  They should serve as examples.

$factAbbrev["BIRT"]		= "B";
$factAbbrev["MARR"]		= "M";
$factAbbrev["DEAT"]		= "D";

 */

?>
