<?php
/**
 * Indonesian Language file for PhpGedView.
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2009  PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 * @author PGV Developers
 * @translator alfarq
 * @package PhpGedView
 * @subpackage Languages
 * @version $Id: facts.id.php 5231 2009-03-19 01:02:56Z canajun2eh $
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

// -- Define a fact array to map GEDCOM tags with their English values
$factarray["ABBR"]			= "Singkatan";
$factarray["ADDR"]			= "Alamat";
$factarray["ADR1"]			= "Alamat 1";
$factarray["ADR2"]			= "Alamat 2";
$factarray["ADOP"]			= "Adopsi";
$factarray["AFN"]			= "Nomor Berkas Leluhur (AFN)";
$factarray["AGE"]			= "Umur";
$factarray["AGNC"]			= "Agensi";
$factarray["ALIA"]			= "Alias";
$factarray["ANCE"]			= "Leluhur";
$factarray["ANCI"]			= "Ancestors Interest";
$factarray["ANUL"]			= "Annulment";
$factarray["ASSO"]			= "Hubungan";
$factarray["AUTH"]			= "Pengarang";
$factarray["BAPL"]			= "Pembaptisan LDS";
$factarray["BAPM"]			= "Pembaptisan";
$factarray["BARM"]			= "Bar Mitzvah";
$factarray["BASM"]			= "Bas Mitzvah";
$factarray["BIRT"]			= "Lahir";
$factarray["BLES"]			= "Pemberkatan";
$factarray["BLOB"]			= "Objek Data Binari";
$factarray["BURI"]			= "Makam";
$factarray["CALN"]			= "Nomor Telepon";
$factarray["CAST"]			= "Kasta / Status Sosial";
$factarray["CAUS"]			= "Sebab kematian";
$factarray["CEME"]  			= "Makam";
$factarray["CENS"]			= "Sensus";
$factarray["CHAN"]			= "Perubahan terakhir";
$factarray["CHAR"]			= "Karakter Set";
$factarray["CHIL"]			= "Anak";
$factarray["CHR"]			= "Pengkristenan";
$factarray["CHRA"]			= "Pengkristenan Dewasa";
$factarray["CITY"]			= "Kota";
$factarray["CONF"]			= "Konfirmasi";
$factarray["CONL"]			= "Konfirmasi LDS";
$factarray["COPR"]			= "Hak Cipta";
$factarray["CORP"]			= "Korporasi / Perusahaan";
$factarray["CREM"]			= "Kremasi";
$factarray["CTRY"]			= "Negara";
$factarray["DATA"]			= "Data";
$factarray["DATE"]			= "Tanggal";
$factarray["DEAT"]			= "Wafat";
$factarray["DESC"]			= "Keturunan";
$factarray["DESI"]			= "Descendants Interest";
$factarray["DEST"]			= "Tujuan";
$factarray["DIV"]			= "Cerai";
$factarray["DIVF"]			= "Divorce filed";
$factarray["DSCR"]			= "Uraian";
$factarray["EDUC"]			= "Pendidikan";
$factarray["EMIG"]			= "Emigrasi";
$factarray["ENDL"]			= "LDS Endowment";
$factarray["ENGA"]			= "Pertunangan";
$factarray["EVEN"]			= "Peristiwa";
$factarray["FAM"]			= "Keluarga";
$factarray["FAMC"]			= "Keluarga Sebagai Anak";
$factarray["FAMF"]			= "Berkas Keluarga";
$factarray["FAMS"]			= "Keluarga Sebagai Pasangan";
$factarray["FCOM"]			= "Komuni Pertama";
$factarray["FILE"]			= "Berkas Luar";
$factarray["FORM"]			= "Format";
$factarray["GIVN"]			= "Nama Depan";
$factarray["GRAD"]			= "Kelulusan";
$factarray["HUSB"]  			= "Suami";
$factarray["IDNO"]			= "Nomor Identifikasi";
$factarray["IMMI"]			= "Imigrasi";
$factarray["LEGA"]			= "Legatee";
$factarray["MARB"]			= "Pengumuman Nikah";
$factarray["MARC"]			= "Pertunangan";
$factarray["MARL"]			= "Surat Nikah";
$factarray["MARR"]			= "Pernikahan";
$factarray["MARS"]			= "Marriage Settlement";
$factarray["MEDI"]			= "Jenis Media";
$factarray["NAME"]			= "Nama";
$factarray["NATI"]			= "Kenegaraan";
$factarray["NATU"]			= "Naturalisasi";
$factarray["NCHI"]			= "Jumlah Anak";
$factarray["NICK"]			= "Nama Panggilan";
$factarray["NMR"]			= "Jumlah Pernikahan";
$factarray["NOTE"]			= "Catatan";
$factarray["NPFX"]			= "Sandangan Nama";
$factarray["NSFX"]			= "Akhiran";
$factarray["OBJE"]			= "Objek Multimedia";
$factarray["OCCU"]			= "Pekerjaan";
$factarray["ORDI"]			= "Ordinance";
$factarray["ORDN"]			= "Ordinasi";
$factarray["PAGE"]			= "Rincian Kutipan";
$factarray["PEDI"]			= "Kerabat";
$factarray["PLAC"]			= "Tempat";
$factarray["PHON"]			= "Telepon";
$factarray["POST"]			= "Kode Pos";
$factarray["PROB"]			= "Probata";
$factarray["PROP"]			= "Properti";
$factarray["PUBL"]			= "Publikasi";
$factarray["QUAY"]			= "Kualitas Data";
$factarray["REPO"]			= "Repositori";
$factarray["REFN"]			= "Nomor Referensi";
$factarray["RELA"]			= "Hubungan";
$factarray["RELI"]			= "Agama";
$factarray["RESI"]			= "Kediaman";
$factarray["RESN"]			= "Terbatas";
$factarray["RETI"]			= "Pensiun";
$factarray["RFN"]			= "Nomor Berkas Rekaman";
$factarray["RIN"]			= "Nomor ID Rekaman";
$factarray["ROLE"]			= "Peran";
$factarray["SEX"]			= "Jender";
$factarray["SLGC"]			= "Pengukuhan Anak LDS";
$factarray["SLGS"]			= "Pengukuhan Pasangan LDS";
$factarray["SOUR"]			= "Sumber";
$factarray["SPFX"]			= "Sandangan Marga";
$factarray["SSN"]			= "Nomor Keamanan Sosial";
$factarray["STAE"]			= "Negara Bagian";
$factarray["STAT"]			= "Status";
$factarray["SUBM"]			= "Pengirim";
$factarray["SUBN"]			= "Pengiriman";
$factarray["SURN"]			= "Marga/Ayah";
$factarray["TEMP"]			= "Kuil";
$factarray["TEXT"]			= "Teks";
$factarray["TIME"]			= "Waktu";
$factarray["TITL"]			= "Judul";
$factarray["TYPE"]			= "Jenis";
$factarray["WIFE"]  			= "Istri";
$factarray["WILL"]			= "Wasiat";
$factarray["_EMAIL"]			= "Alamat Email";
$factarray["EMAIL"]			= "Alamat Email";
$factarray["_TODO"]			= "Hal Untuk Dilakukan";
$factarray["_UID"]			= "Pengenal Universal";
$factarray["_PRIM"]			= "Gambar Terhighlight";
$factarray["_DBID"] 			= "ID Database Terangkai";

// These facts are used in specific contexts
$factarray["STAT:DATE"] 		= "Tanggal Perubahan Status";

//These facts are compounds for the view probabilities page
$factarray["FAMC:HUSB:SURN"]		= "Marga Ayah";
$factarray["FAMC:WIFE:SURN"]		= "Marga Ibu";
$factarray["FAMC:HUSB:BIRT:PLAC"]	= "Tempat Lahir Ayah";
$factarray["FAMC:WIFE:BIRT:PLAC"]	= "Tempat Lahir Ibu";
$factarray["FAMC:MARR:PLAC"]		= "Tempat Nikah Orangtua";
$factarray["FAMC:HUSB:OCCU"]		= "Pekerjaan Ayah";
$factarray[":BIRT:PLAC"]		= "Tempat Lahir";
$factarray["FAMS:MARR:PLAC"]		= "Tempat Nikah";
$factarray["FAMS:MARR:DATE"]		= "Tanggal Nikah";
$factarray["FAMS:SPOUSE:DEAT:PLAC"]	= "Tempat Meninggal Pasangan";
$factarray["FAMC:HUSB:GIVN"]		= "Nama Depan Ayah";
$factarray["FAMS:SPOUSE:BIRT:PLAC"]	= "Tempat Lahir Pasangan";
$factarray["FAMC:WIFE:GIVN"]		= "Nama Depan Ibu";
$factarray["FAMC:HUSB:FAMC:HUSB:GIVN"]	= "Nama Depan Kakek Ayah";
$factarray["FAMC:WIFE:FAMC:WIFE:GIVN"]	= "Nama Depan Nenek Ibu";
$factarray["FAMC:WIFE:FAMC:HUSB:GIVN"]	= "Nama Depan Kakek Ibu";
$factarray["FAMC:HUSB:FAMC:WIFE:GIVN"]	= "Nama Depan Nenek Ayah";
$factarray["FAMS:CHIL:BIRT:PLAC"]	= "Tempat Lahir Anak";

// These facts are all colon delimited
$factarray["BIRT:PLAC"]			= "Tempat Lahir";
$factarray["BIRT:DATE"]			= "Tanggal Lahir";
$factarray["DEAT:PLAC"]			= "Tempat Meninggal";
$factarray["DEAT:DATE"]			= "Tanggal Meninggal";
$factarray["CHR:PLAC"]			= "Tempat Pengkristenan";
$factarray["CHR:DATE"]			= "Tanggal Pengkristenan";
$factarray["BAPM:PLAC"]			= "Tempat Pembaptisan";
$factarray["BAPM:DATE"]			= "Tanggal Pembaptisan";
$factarray["BURI:PLAC"]			= "Tempat Pemakaman";
$factarray["BURI:DATE"]			= "Tanggal Pemakaman";
$factarray["MARR:PLAC"]			= "Tempat Nikah";
$factarray["MARR:DATE"]			= "Tanggal Nikah";

// These facts are specific to GEDCOM exports from Family Tree Maker
$factarray["_MDCL"]			= "Medis";
$factarray["_DEG"]			= "Derajat";
$factarray["_MILT"]			= "Layanan Militer";
$factarray["_SEPR"]			= "Terpisah";
$factarray["_DETS"]			= "Kematian Salah Satu Pasangan";
$factarray["CITN"]			= "Kenegaraan";
$factarray["_FA1"]			= "Fakta 1";
$factarray["_FA2"]			= "Fakta 2";
$factarray["_FA3"]			= "Fakta 3";
$factarray["_FA4"]			= "Fakta 4";
$factarray["_FA5"]			= "Fakta 5";
$factarray["_FA6"]			= "Fakta 6";
$factarray["_FA7"]			= "Fakta 7";
$factarray["_FA8"]			= "Fakta 8";
$factarray["_FA9"]			= "Fakta 9";
$factarray["_FA10"]			= "Fakta 10";
$factarray["_FA11"]			= "Fakta 11";
$factarray["_FA12"]			= "Fakta 12";
$factarray["_FA13"]			= "Fakta 13";
$factarray["_MREL"]			= "Hubungan terhadap Ibu";
$factarray["_FREL"]			= "Hubungan terhadap Ayah";
$factarray["_MSTAT"]			= "Status Awal Pernikahan";
$factarray["_MEND"]			= "Status Akhir Pernikahan";
$factarray["_NAMS"]			= "Namesake";

// GEDCOM 5.5.1 related facts
$factarray["FAX"]			= "FAX";
$factarray["FACT"]			= "Fakta";
$factarray["WWW"]			= "Situs Web";
$factarray["MAP"]			= "Peta";
$factarray["LATI"]			= "Garis Lintang";
$factarray["LONG"]			= "Garis Bujur";
$factarray["FONE"]			= "Fonetik";
$factarray["ROMN"]			= "Latinisasi";

// PAF related facts
$factarray["_NAME"]			= "Nama Mailing List";
$factarray["URL"]			= "URL Web";
$factarray["_URL"]			= "URL Web";
$factarray["_HEB"]			= "Bahasa Yahudi";
$factarray["_SCBK"]			= "Buku Kliping";
$factarray["_TYPE"]			= "Jenis Media";
$factarray["_SSHOW"]			= "Slide Show";

// Rootsmagic
$factarray["_SUBQ"]			= "Versi Pendek";
$factarray["_BIBL"]			= "Daftar Pustaka";

// Reunion
$factarray["EMAL"]			= "Alamat Email";

// Other common customized facts
$factarray["_ADPF"]			= "Diadopsi Ayah";
$factarray["_ADPM"]			= "Diadopsi Ibu";
$factarray["_AKAN"]			= "Juga dikenal sebagai";
$factarray["_AKA"] 			= "Juga dikenal sebagai";
$factarray["_BRTM"]			= "Brit Mila";
$factarray["_COML"]			= "Pernikahan Sipil";
$factarray["_EYEC"]			= "Warna Mata";
$factarray["_FNRL"]			= "Pemakaman";
$factarray["_HAIR"]			= "Warna Rambut";
$factarray["_HEIG"]			= "Tinggi";
$factarray["_HOL"]  			= "Holocaust";
$factarray["_INTE"]			= "Interred";
$factarray["_MARI"]			= "Tujuan Nikah";
$factarray["_MBON"]			= "Ikatan Nikah";
$factarray["_MEDC"]			= "Kondisi Medis";
$factarray["_MILI"]			= "Militer";
$factarray["_NMR"]			= "Tidak menikah";
$factarray["_NLIV"]			= "Tidak hidup";
$factarray["_NMAR"]			= "Tidak pernah menikah";
$factarray["_PRMN"]			= "Nomor Tetap";
$factarray["_WEIG"]			= "Berat";
$factarray["_YART"]			= "Yahrzeit";
$factarray["_MARNM"]			= "Nama Pernikahan";
$factarray["_MARNM_SURN"]		= "Marga Pernikahan";
$factarray["_STAT"]			= "Status Nikah";
$factarray["COMM"]			= "Komentar";

// Aldfaer related facts
$factarray["MARR_CIVIL"]		= "Pernikahan Sipil";
$factarray["MARR_RELIGIOUS"]		= "Pernikahan Agama";
$factarray["MARR_PARTNERS"]		= "Hubungan Terdaftar";
$factarray["MARR_UNKNOWN"]		= "Jenis Nikah Tidak Diketahui";

$factarray["_HNM"]			= "Bahasa Yahudi";

// Pseudo-facts for relatives
$factarray["_DEAT_SPOU"]		= "Kematian pasangan";
$factarray["_BURI_SPOU"]		= "Makam pasangan";
$factarray["_CREM_SPOU"]		= "Kremasi pasangan";

$factarray["_BIRT_CHIL"]		= "Kelahiran anak";
$factarray["_CHR_CHIL"]		= "Pengkristenan anak";
$factarray["_BAPM_CHIL"]		= "Pembaptisan anak";
$factarray["__BRTM_CHIL"]		= "Brit Mila anak";
$factarray["_ADOP_CHIL"]		= "Adopsi anak";
$factarray["_MARR_CHIL"]		= "Pernikahan anak";
$factarray["_MARB_CHIL"]		= "Pengumuman Nikah anak";
$factarray["_DEAT_CHIL"]		= "Kematian anak";
$factarray["_BURI_CHIL"]		= "Makam anak";
$factarray["_CREM_CHIL"]		= "Kremasi of a child";

$factarray["_BIRT_GCHI"]		= "Kelahiran cucu";
$factarray["_CHR_GCHI"]		= "Pengkristenan cucu";
$factarray["_BAPM_GCHI"]		= "Pembaptisan cucu";
$factarray["__BRTM_GCHI"]		= "Brit Mila cucu";
$factarray["_ADOP_GCHI"]		= "Adopsi cucu";
$factarray["_MARR_GCHI"]		= "Pernikahan cucu";
$factarray["_MARB_GCHI"]		= "Pengumuman Nikah cucu";
$factarray["_DEAT_GCHI"]		= "Kematian cucu";
$factarray["_BURI_GCHI"]		= "Pemakaman cucu";
$factarray["_CREM_GCHI"]		= "Kremasi cucu";

$factarray["_BIRT_GGCH"]		= "Kelahiran cicit";
$factarray["_CHR_GGCH"]		= "Pengkristenan cicit";
$factarray["_BAPM_GGCH"]		= "Pembaptisan cicit";
$factarray["__BRTM_GGCH"]		= "Brit Mila cicit";
$factarray["_ADOP_GGCH"]		= "Adopsi cicit";
$factarray["_MARR_GGCH"]		= "Pernikahan cicit";
$factarray["_MARB_GGCH"]		= "Pengumuman Nikah cicit";
$factarray["_DEAT_GGCH"]		= "Kematian cicit";
$factarray["_BURI_GGCH"]		= "Makam cicit";
$factarray["_CREM_GGCH"]		= "Kremasi cicit";

$factarray["_MARR_FATH"]		= "Pernikahan ayah";
$factarray["_MARB_FATH"]		= "Pengumuman Nikah ayah";
$factarray["_DEAT_FATH"]		= "Kematian ayah";
$factarray["_BURI_FATH"]		= "Makam ayah";
$factarray["_CREM_FATH"]		= "Kremasi ayah";

$factarray["_MARR_FAMC"]		= "Pernikahan orangtua";
$factarray["_MARB_FAMC"]		= "Pengumuman Nikah orangtua";

$factarray["_MARR_MOTH"]		= "Pernikahan ibu";
$factarray["_MARB_MOTH"]		= "Pengumuman Nikah ibu";
$factarray["_DEAT_MOTH"]		= "Kematian ibu";
$factarray["_BURI_MOTH"]		= "Makam ibu";
$factarray["_CREM_MOTH"]		= "Kremasi ibu";

$factarray["_BIRT_SIBL"]		= "Kelahiran saudara";
$factarray["_CHR_SIBL"]		= "Pengkristenan saudara";
$factarray["_BAPM_SIBL"]		= "Pembaptisan saudara";
$factarray["__BRTM_SIBL"]		= "Brit Mila saudara";
$factarray["_ADOP_SIBL"]		= "Adopsi saudara";
$factarray["_MARR_SIBL"]		= "Pernikahan saudara";
$factarray["_MARB_SIBL"]		= "Pengumuman Nikah saudara";
$factarray["_DEAT_SIBL"]		= "Kematian saudara";
$factarray["_BURI_SIBL"]		= "Makam saudara";
$factarray["_CREM_SIBL"]		= "Kremasi saudara";

$factarray["_BIRT_HSIB"]		= "Kelahiran saudara seayah/ibu";
$factarray["_CHR_HSIB"]		= "Pengkristenan saudara seayah/ibu";
$factarray["_BAPM_HSIB"]		= "Pembaptisan saudara seayah/ibu";
$factarray["__BRTM_HSIB"]		= "Brit Mila saudara seayah/ibu";
$factarray["_ADOP_HSIB"]		= "Adopsi saudara seayah/ibu";
$factarray["_MARR_HSIB"]		= "Pernikahan saudara seayah/ibu";
$factarray["_MARB_HSIB"]		= "Pengumuman Nikah saudara seayah/ibu";
$factarray["_DEAT_HSIB"]		= "Kematian saudara seayah/ibu";
$factarray["_BURI_HSIB"]		= "Makam saudara seayah/ibu";
$factarray["_CREM_HSIB"]		= "Kremasi saudara seayah/ibu";

$factarray["_BIRT_NEPH"]		= "Kelahiran keponakan";
$factarray["_CHR_NEPH"]		= "Pengkristenan keponakan";
$factarray["_BAPM_NEPH"]		= "Pembaptisan keponakan";
$factarray["__BRTM_NEPH"]		= "Brit Mila of a nephew";
$factarray["_ADOP_NEPH"]		= "Adopsi keponakan";
$factarray["_MARR_NEPH"]		= "Pernikahan keponakan";
$factarray["_MARB_NEPH"]		= "Pengumuman Nikah keponakan";
$factarray["_DEAT_NEPH"]		= "Kematian keponakan";
$factarray["_BURI_NEPH"]		= "Makam keponakan";
$factarray["_CREM_NEPH"]		= "Kremasi keponakan";

$factarray["_DEAT_GPAR"]		= "Kematian kakek-nenek";
$factarray["_BURI_GPAR"]		= "Makam kakek-nenek";
$factarray["_CREM_GPAR"]		= "Kremasi kakek-nenek";

$factarray["_DEAT_GGPA"]		= "Kematian buyut";
$factarray["_BURI_GGPA"]		= "Makam buyut";
$factarray["_CREM_GGPA"]		= "Kremasi buyut";

$factarray["_BIRT_FSIB"]		= "Kelahiran saudara ayah";
$factarray["_CHR_FSIB"]		= "Pengkristenan saudara ayah";
$factarray["_BAPM_FSIB"]		= "Pembaptisan saudara ayah";
$factarray["__BRTM_FSIB"]		= "Brit Mila saudara ayah";
$factarray["_ADOP_FSIB"]		= "Adopsi saudara ayah";
$factarray["_MARR_FSIB"]		= "Pernikahan saudara ayah";
$factarray["_MARB_FSIB"]		= "Pengumuman Nikah saudara ayah";
$factarray["_DEAT_FSIB"]		= "Kematian saudara ayah";
$factarray["_BURI_FSIB"]		= "Makam saudara ayah";
$factarray["_CREM_FSIB"]		= "Kremasi saudara ayah";

$factarray["_BIRT_MSIB"]		= "Kelahiran saudara ibu";
$factarray["_CHR_MSIB"]		= "Pengkristenan saudara ibu";
$factarray["_BAPM_MSIB"]		= "Pembaptisan saudara ibu";
$factarray["__BRTM_MSIB"]		= "Brit Mila saudara ibu";
$factarray["_ADOP_MSIB"]		= "Adopsi saudara ibu";
$factarray["_MARR_MSIB"]		= "Pernikahan saudara ibu";
$factarray["_MARB_MSIB"]		= "Pengumuman Nikah saudara ibu";
$factarray["_DEAT_MSIB"]		= "Kematian saudara ibu";
$factarray["_BURI_MSIB"]		= "Makam saudara ibu";
$factarray["_CREM_MSIB"]		= "Kremasi saudara ibu";

$factarray["_BIRT_COUS"]		= "Kelahiran sepupu sekali";
$factarray["_CHR_COUS"]			= "Pengkristenan sepupu sekali";
$factarray["_BAPM_COUS"]		= "Pembaptisan sepupu sekali";
$factarray["__BRTM_COUS"]		= "Brit Mila sepupu sekali";
$factarray["_ADOP_COUS"]		= "Adopsi sepupu sekali";
$factarray["_MARR_COUS"]		= "Pernikahan sepupu sekali";
$factarray["_MARB_COUS"]		= "Pengumuman Nikah sepupu sekali";
$factarray["_DEAT_COUS"]		= "Kematian sepupu sekali";
$factarray["_BURI_COUS"]		= "Makam sepupu sekali";
$factarray["_CREM_COUS"]		= "Kremasi sepupu sekali";

$factarray["_FAMC_EMIG"]		= "Emigrasi orangtua";
$factarray["_FAMC_RESI"]		= "Tempat tinggal orangtua";

//-- PGV Only facts
$factarray["_THUM"]			= "Gunakan gambar ini sebagai thumbnail?";
$factarray["_PGVU"]			= "oleh"; // last changed by";
$factarray["SERV"]			= "Server Luar";
$factarray["_GEDF"]			= "Berkas GEDCOM";

/*-- Fact abbreviations for use in Chart boxes.
 *		Use these abbreviations in cases where the standard method of using the first
 *		letter of the spelled-out name results in an undesirable abbreviation or where
 *		you want to produce a different result (eg: "x" instead of "M" for "Married").
 *
 *		You can abbreviate any Fact label this way.  The list of abbreviations is
 *		open-ended.
 *
 *		These abbreviations are user-customizable. Just put them into file "extra.xx.php".
 *		The length of these abbreviations is not restricted to 1 letter.
 */

/*-- The following lines have been commented out.  They should serve as examples.

$factAbbrev["BIRT"]			= "B";
$factAbbrev["MARR"]			= "M";
$factAbbrev["DEAT"]			= "D";

 */

?>
