<?php
/**
 * Hungarian texts
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2008  PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 * @author PGV Developers
 * @author Hrotkó Gábor <roti@al.pmmf.hu>
 * @package PhpGedView
 * @subpackage Languages
 * @version $Id: facts.hu.php 6782 2010-01-19 18:25:35Z fisharebest $
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

// -- Define a fact array to map GEDCOM tags with their Hungarian values
$factarray["ABBR"] = "Rövidítés";
$factarray["ADDR"] = "Lakcím";
$factarray["ADR1"] = "Lakcím 1";
$factarray["ADR2"] = "Lakcím 2";
$factarray["ADOP"] = "Örökbefogadás";
$factarray["AFN"]  = "Ősi Állomány Szám (angol AFN)";
$factarray["AGE"]  = "Életkor";
$factarray["AGNC"] = "Képviselet";
$factarray["ALIA"] = "Úgyis mint";
$factarray["ANCE"] = "Ősök";
$factarray["ANCI"] = "Ősök érdeklődése";
$factarray["ANUL"] = "Házasság felbontása";
$factarray["ASSO"] = "Kapcsolódó személyek";
$factarray["AUTH"] = "Szerző";
$factarray["BAPL"] = "UNSZ-keresztség";
$factarray["BAPM"] = "Keresztelés";
$factarray["BARM"] = "Bar Mitzvah";
$factarray["BASM"] = "Bas Mitzvah";
$factarray["BIRT"] = "Született";
$factarray["BLES"] = "Megáldás";
$factarray["BLOB"] = "Bináris adatok";
$factarray["BURI"] = "Temetés";
$factarray["CALN"] = "Gyűjtemény azonosító";
$factarray["CAST"] = "Szociális/társadalmi státusz";
$factarray["CAUS"] = "A halál oka";
$factarray["CEME"]  = "Temető";
$factarray["CENS"] = "Összeírás";
$factarray["CHAN"] = "Utolsó módosítás";
$factarray["CHAR"] = "Kódkészlet";
$factarray["CHIL"] = "Gyermek";
$factarray["CHR"]  = "Katolikus Keresztelés";
$factarray["CHRA"] = "Felnőtt kori keresztség";
$factarray["CITY"] = "Város";
$factarray["CONF"] = "Konfirmáció";
$factarray["CONL"] = "UNSZ-konfirmáció";
$factarray["COPR"] = "Copyright";
$factarray["CORP"] = "Vállalat/Intézmény";
$factarray["CREM"] = "Hamvasztás";
$factarray["CTRY"] = "Ország";
$factarray["DATE"] = "Dátum";
$factarray["DATA"] = "Adat";
$factarray["DEAT"] = "Elhunyt";
$factarray["DESC"] = "Leszármazottak";
$factarray["DEST"] = "Cél";
$factarray["DIV"]  = "Válás";
$factarray["DIVF"] = "Válási akta";
$factarray["DSCR"] = "Leírás";
$factarray["EDUC"] = "Végzettség";
$factarray["EMIG"] = "Kivándorlás";
$factarray["ENDL"] = "UNSZ-szertartás (Endowment)";
$factarray["ENGA"] = "Eljegyzés";
$factarray["EVEN"] = "Esemény";
$factarray["FAM"]  = "Család";
$factarray["FAMC"] = "Családtagok (gyermekként)";
$factarray["FAMF"] = "UNSZ családi akta";
$factarray["FAMS"] = "Családtagok (házastársként)";
$factarray["FCOM"] = "Elsőáldozás";
$factarray["FILE"] = "Külső adatállomány";
$factarray["FORM"] = "Formátum";
$factarray["GIVN"] = "Keresztnév";
$factarray["GRAD"] = "Felsőfokú végzettség";
$factarray["HUSB"]  = "Férj";
$factarray["IDNO"] = "Azonosítószám";
$factarray["IMMI"] = "Bevándorlás";
$factarray["LEGA"] = "Végrendeleti örökös";
$factarray["MARB"] = "Eljegyzés kihirdetése";
$factarray["MARC"] = "Házassági szerződés";
$factarray["MARL"] = "Házassági engedély";
$factarray["MARR"] = "Házasság";
$factarray["MARS"] = "Házasság előtti szerződés";
$factarray["MEDI"] = "Médiatípus";
$factarray["NAME"] = "Név";
$factarray["NATI"] = "Nemzetiség";
$factarray["NATU"] = "Honosítás";
$factarray["NCHI"] = "Gyermekek száma";
$factarray["NICK"] = "Becenév";
$factarray["NMR"]  = "Házasságkötések száma";
$factarray["NOTE"] = "Jegyzet";
$factarray["NPFX"] = "Előtag";
$factarray["NSFX"] = "Utótag";
$factarray["OBJE"] = "Multimédia-elem";
$factarray["OCCU"] = "Foglalkozás";
$factarray["ORDI"] = "UNSZ-szertartás";
$factarray["ORDN"] = "Pappá szentelés";
$factarray["PAGE"] = "Hivatkozás";
$factarray["PEDI"] = "Felmenő rokonság";
$factarray["PLAC"] = "Helyszín";
$factarray["PHON"] = "Telefon";
$factarray["POST"] = "Irányítószám";
$factarray["PROB"] = "Végrendelet hitelesítése";
$factarray["PROP"] = "Tulajdon";
$factarray["PUBL"] = "Publikáció";
$factarray["QUAY"] = "Adat-megbízhatóság";
$factarray["REPO"] = "Szervezet";
$factarray["REFN"] = "Hivatkozási szám";
$factarray["RELA"] = "Kapcsolat";
$factarray["RELI"] = "Vallás";
$factarray["RESI"] = "Lakhely";
$factarray["RESN"] = "Korlátozás";
$factarray["RETI"] = "Nyugdíjazás";
$factarray["RFN"]  = "Adat állomány-azonosító";
$factarray["RIN"]  = "Adat azonosítószáma";
$factarray["ROLE"] = "Szerep";
$factarray["SEX"]  = "Neme";
$factarray["SOUR"] = "Forrás";
$factarray["SPFX"] = "Vezetéknév előtagja";
$factarray["SSN"]  = "Társadalombiztosítási azonosító";
$factarray["STAE"] = "Állam";
$factarray["STAT"] = "Státusz";
$factarray["SUBM"] = "Adatszolgáltató";
$factarray["SUBN"] = "Beadvány";
$factarray["SURN"] = "Vezetéknév";
$factarray["TEMP"] = "Templom";
$factarray["TEXT"] = "Szöveg";
$factarray["TIME"] = "Idő";
$factarray["TITL"] = "Cím";
$factarray["TYPE"] = "Típus";
$factarray["WIFE"]  = "Feleség";
$factarray["WILL"] = "Végrendelet";
$factarray["_EMAIL"] = "Email-cím";
$factarray["EMAIL"] = "Email-cím";
$factarray["_TODO"] = "Tennivalók";
$factarray["_UID"]  = "Általános azonosító";
$factarray["_PGVU"] = "Utoljára módosította";
$factarray["SERV"] = "Távoli szerver";
$factarray["_GEDF"] = "GEDCOM Állomány";
$factarray["_PRIM"] = "Kijelölt kép";
$factarray["_THUM"] = "Használjuk ezt a képet bélyegképként?";

// These facts are specific to GEDCOM exports from Family Tree Maker
$factarray["_MDCL"] = "Orvosi adatok";
$factarray["_DEG"]  = "Fokozat";
$factarray["_MILT"] = "Katonai szolgálat";
$factarray["_SEPR"] = "Különélés";
$factarray["_DETS"] = "Egyik házastárs halála";
$factarray["CITN"]  = "Állampolgárság";
$factarray["_FA1"]	= "1. tény";
$factarray["_FA2"]	= "2. tény";
$factarray["_FA3"]	= "3. tény";
$factarray["_FA4"]	= "4. tény";
$factarray["_FA5"]	= "5. tény";
$factarray["_FA6"]	= "6. tény";
$factarray["_FA7"]	= "7. tény";
$factarray["_FA8"]	= "8. tény";
$factarray["_FA9"]	= "9. tény";
$factarray["_FA10"]	= "10. tény";
$factarray["_FA11"]	= "11. tény";
$factarray["_FA12"]	= "12. tény";
$factarray["_FA13"]	= "13. tény";
$factarray["_MREL"]	= "Kapcsolat az Anyához";
$factarray["_FREL"]	= "Kapcsolat az Apához";
$factarray["_MSTAT"]	= "Házasság kezdési státusza";
$factarray["_MEND"]	= "Házasság végzési státusza";

// GEDCOM 5.5.1 related facts
$factarray["FAX"] 	= "Fax";
$factarray["FACT"] 	= "Tény";
$factarray["WWW"] 	= "Honlap";
$factarray["MAP"] 	= "Térkép";
$factarray["LATI"] 	= "Szélességi fok";
$factarray["LONG"] 	= "Hosszúsági fok";
$factarray["FONE"] 	= "Fonetikus";
$factarray["ROMN"] 	= "Katolizált";
$factarray["_HEB"] 	= "Héber";
$factarray["_SCBK"] = "Gyűjtő könyv";
$factarray["_TYPE"] = "Média típus";
$factarray["_SSHOW"] = "Dia vetítés";

// Rootsmagic
$factarray["_SUBQ"]	= "Rövid változat";
$factarray["_BIBL"] 	= "Irodalomjegyzék";
$factarray["EMAL"]	= "Email cím";

// PAF related facts
$factarray["_NAME"] 	= "Levelezési név";
$factarray["URL"] 	= "Webcím";

// Other common customized facts
$factarray["_ADPF"] 	= "Az apa örökbefogadta";
$factarray["_ADPM"] 	= "Az anya örökbefogadta";
$factarray["_AKA"] 	= "Úgyis mint";
$factarray["_AKAN"]	= "Úgyis mint";
$factarray["_BRTM"]	= "Körülmetélés";
$factarray["_COML"]	= "Általános polgári házasság";
$factarray["_EYEC"] 	= "Szemszín";
$factarray["_FNRL"]	= "Temetés";
$factarray["_HAIR"]	= "Hajszín";
$factarray["_HEIG"] 	= "Magasság";
$factarray["_HOL"]  	= "Tűzáldozat";
$factarray["_INTE"]	= "Interred";
$factarray["_MARI"]	= "Házassági szándék";
$factarray["_MBON"]	= "Marriage bond";
$factarray["_MEDC"] 	= "Egészségi állapot";
$factarray["_MILI"] 	= "Katonai szolgálat";
$factarray["_NMR"]	= "Nem házas";
$factarray["_NLIV"]	= "Nincs életben";
$factarray["_NMAR"] 	= "Soha nem házasodott meg";
$factarray["_PRMN"]	= "Ideiglenes szám";
$factarray["_WEIG"] 	= "Testsúly";
$factarray["_YART"]	= "Jarzeit";
$factarray["_MARNM"]	= "Házasult név";
$factarray["_MARNM_SURN"] = "Házasult vezetéknév";
$factarray["_STAT"]	= "Házassági státusz";
$factarray["COMM"]	= "Megjegyzés";
$factarray["MARR_CIVIL"] = "Polgári esküvő";
$factarray["MARR_RELIGIOUS"] = "Egyházi esküvő";
$factarray["MARR_PARTNERS"] = "Élettársi kapcsolat";
$factarray["MARR_UNKNOWN"] = "Házassági típus nem ismert";
$factarray["_HNM"] = "Héber Név";
$factarray["_DEAT_SPOU"] = "Házastárs halála";
$factarray["_BIRT_CHIL"] = "Gyermek születése";
$factarray["_MARR_CHIL"] = "Gyermek házasságkötése";
$factarray["_DEAT_CHIL"] = "Gyermek halála";
$factarray["_BIRT_GCHI"] = "Unoka születése";
$factarray["_MARR_GCHI"] = "Unoka házasságkötése";
$factarray["_DEAT_GCHI"] = "Unoka halála";
$factarray["_MARR_FATH"] = "Apa házassága";
$factarray["_DEAT_FATH"] = "Apa halála";
$factarray["_MARR_MOTH"] = "Anya házassága";
$factarray["_DEAT_MOTH"] = "Anya halála";
$factarray["_BIRT_SIBL"] = "Testvér születése";
$factarray["_MARR_SIBL"] = "Testvér házassága";
$factarray["_DEAT_SIBL"] = "Testvér halála";
$factarray["_BIRT_HSIB"] = "Féltestvér születése";
$factarray["_MARR_HSIB"] = "Féltestvér házassága";
$factarray["_DEAT_HSIB"] = "Féltestvér halála";
$factarray["_DEAT_GPAR"] = "Nagyszülő halála";
$factarray["_BIRT_FSIB"] = "Apa testvérének születése";
$factarray["_MARR_FSIB"] = "Apa testvérének házassága";
$factarray["_DEAT_FSIB"] = "Apa testvérének halála";
$factarray["_BIRT_MSIB"] = "Anya testvérének születése";
$factarray["_MARR_MSIB"] = "Anya testvérének házassága";
$factarray["_DEAT_MSIB"] = "Anya testvérének halála";
$factarray["_BIRT_COUS"] = "Első unokatestvér születése";
$factarray["_MARR_COUS"] = "Első unokatestvér házassága";
$factarray["_DEAT_COUS"] = "Első unokatestvér halála";

$factarray["BIRT:PLAC"] = "Születési helye";
$factarray["BIRT:DATE"] = "Születési dátum";
$factarray[":BIRT:PLAC"] = "Születésihely";
$factarray["BURI:PLAC"] = "Temetkezés helye";
$factarray["BAPM:DATE"] = "Keresztelés dátuma";
$factarray["BAPM:PLAC"] = "Keresztelés helye";
$factarray["_URL"] = "Web URL";
$factarray["_BURI_SPOU"] = "Házastárs temetése";
$factarray["FAMS:SPOUSE:BIRT:PLAC"] = "Házastárs születési helye";
$factarray["FAMS:CHIL:BIRT:PLAC"] = "Gyermek születési hely";
$factarray["FAMC:HUSB:BIRT:PLAC"] = "Apa születési helye";
$factarray["_NAMS"]	= "Névadója";
$factarray["DEAT:PLAC"] = "Halálesetének helye";
$factarray["DEAT:DATE"] = "Halálesetének dátuma";
$factarray["CHR:PLAC"] = "Katolikus Keresztelés helye";
$factarray["CHR:DATE"] = "Katolikus Keresztelés dátuma";
$factarray["BURI:DATE"] = "Temetkezés dátuma";
$factarray["MARR:PLAC"] = "Házasságkötés helye";
$factarray["MARR:DATE"] = "Házasságkötés dátuma";
$factarray["_CHR_CHIL"] = "Gyermek katolikus keresztelése";
$factarray["_BAPM_CHIL"] = "Gyermek keresztelése";
$factarray["_ADOP_CHIL"] = "Gyermek örökbefogadása";
$factarray["_BURI_CHIL"] = "Gyermek temetése";
$factarray["_CHR_GCHI"] = "Unoka katolikus keresztelése";
$factarray["_BAPM_GCHI"] = "Unoka keresztelése";
$factarray["_ADOP_GCHI"] = "Unoka örökbefogadása";
$factarray["_BURI_GCHI"] = "Unoka temetése";
$factarray["_BIRT_GGCH"] = "Dédunoka születése";
$factarray["_CHR_GGCH"] = "Dédunoka katolikus keresztelése";
$factarray["_BAPM_GGCH"] = "Dédunoka keresztelése";
$factarray["_ADOP_GGCH"] = "Dédunoka örökbefogadása";
$factarray["_MARR_GGCH"] = "Dédunoka házasságkötése";
$factarray["_DEAT_GGCH"] = "Dédunoka halála";
$factarray["_BURI_GGCH"] = "Dédunoka temetése";
$factarray["_BURI_FATH"] = "Apa temetése";
$factarray["_MARR_FAMC"] = "Szülő házasságkötése";
$factarray["_BURI_MOTH"] = "Anya temetése";
$factarray["_CHR_SIBL"] = "Testvér katolikus keresztelése";
$factarray["_BAPM_SIBL"] = "Testvér keresztelése";
$factarray["_ADOP_SIBL"] = "Testvér örökbefogadása";
$factarray["_BURI_SIBL"] = "Testvér temetése";
$factarray["_CHR_HSIB"] = "Féltestvér katolikus keresztelése";
$factarray["_BAPM_HSIB"] = "Féltestvér keresztelése";
$factarray["_ADOP_HSIB"] = "Féltestvér örökbefogadása";
$factarray["_BURI_HSIB"] = "Féltestvér temetése";
$factarray["_BIRT_NEPH"] = "Unokaöcs vagy unokahúg születése";
$factarray["_CHR_NEPH"] = "Unokaöcs vagy unokahúg katolikus keresztelése";
$factarray["_BAPM_NEPH"] = "Unokaöcs vagy unokahúg keresztelése";
$factarray["_ADOP_NEPH"] = "Unokaöcs vagy unokahúg örökbefogadása";
$factarray["_MARR_NEPH"] = "Unokaöcs vagy unokahúg házasságkötése";
$factarray["_DEAT_NEPH"] = "Unokaöcs vagy unokahúg halála";
$factarray["_BURI_NEPH"] = "Unokaöcs vagy unokahúg temetése";
$factarray["_BURI_GPAR"] = "Nagyszülő temetése";
$factarray["_CHR_FSIB"] = "Apa testvérének katolikus keresztelése";
$factarray["_BAPM_FSIB"] = "Apa testvérének keresztelése";
$factarray["_ADOP_FSIB"] = "Apa testvérének örökbefogadása";
$factarray["_BURI_FSIB"] = "Apa testvérének temetése";
$factarray["_CHR_MSIB"] = "Anya testvérének katolikus keresztelése";
$factarray["_BAPM_MSIB"] = "Anya testvérének keresztelése";
$factarray["_ADOP_MSIB"] = "Anya testvérének örökbefogadása";
$factarray["_BURI_MSIB"] = "Anya testvérének temetése";
$factarray["_CHR_COUS"]  = "Első unokatestvér katolikus keresztelése";
$factarray["_BAPM_COUS"] = "Első unokatestvér keresztelése";
$factarray["_ADOP_COUS"] = "Első unokatestvér örökbefogadása";
$factarray["_BURI_COUS"] = "Első unokatestvér temetése";
$factarray["_FAMC_EMIG"] = "Szülők kivándorlása";
$factarray["_FAMC_RESI"] = "Szülők lakóhelye";
$factarray["_CREM_SPOU"] = "Házastárs hamvasztása";
$factarray["_CREM_CHIL"] = "Gyermek hamvasztása";
$factarray["_CREM_GCHI"] = "Unoka hamvasztása";
$factarray["_CREM_GGCH"] = "Dédunoka hamvasztása";
$factarray["_CREM_FATH"] = "Apa hamvasztása";
$factarray["_CREM_MOTH"] = "Anya hamvasztása";
$factarray["_CREM_SIBL"] = "Testvér hamvasztása";
$factarray["_CREM_HSIB"] = "Féltestvér hamvasztása";
$factarray["_CREM_NEPH"] = "Unokaöcs vagy unokahúg hamvasztása";
$factarray["_CREM_GPAR"] = "Nagyszülő hamvasztása";
$factarray["_DEAT_GGPA"] = "Dédnagyszülő halála";
$factarray["_BURI_GGPA"] = "Dédnagyszülő temetése";
$factarray["_CREM_GGPA"] = "Dédnagyszülő hamvasztása";
$factarray["_CREM_FSIB"] = "Apa testvérének hamvasztása";
$factarray["_CREM_MSIB"] = "Anya testvérének hamvasztása";
$factarray["_CREM_COUS"] = "Első unokatestvér hamvasztása";
$factarray["FAMC:WIFE:BIRT:PLAC"] = "Anya születési helye";
$factarray["FAMC:MARR:PLAC"] = "Szülők házasságkötésének helye";
$factarray["FAMC:HUSB:OCCU"] = "Apa foglalkozása";
$factarray["FAMS:MARR:PLAC"] = "Házasságkötés helye";
$factarray["FAMS:MARR:DATE"] = "Házasságkötés dátuma";
$factarray["FAMS:SPOUSE:DEAT:PLAC"] = "Házastárs halálának helye";
$factarray["NAME:_HEB"]	= "Héber neve";
$factarray["PLAC:_HEB"]	= "Héber helység";
$factarray["SHARED_NOTE"]	= "Közös jegyzetek";
$factarray["FAMC:HUSB:SURN"] = "Apa vezetékneve";
$factarray["FAMC:WIFE:SURN"] = "Anya vezetékneve";
$factarray["FAMC:HUSB:GIVN"] = "Apa keresztneve";
$factarray["FAMC:WIFE:GIVN"] = "Anya keresztneve";
$factarray["FAMS:NOTE"] = "Házastárs jegyzet";
$factarray["BIRT:SOUR"] = "Születési Forrás";
$factarray["DEAT:SOUR"] = "Haláleset Forrás";
$factarray["CHR:SOUR"] = "Katolikus Keresztelés Forrás";
$factarray["BAPM:SOUR"] = "Keresztelés Forrás";
$factarray["BURI:SOUR"] = "Temetkezés Forrás";
$factarray["MARR:SOUR"] = "Házasságkötés Forrás";
$factarray["CONF:PLAC"] = "Konfirmáció helye";
$factarray["CONF:DATE"] = "Konfirmáció dátuma";
$factarray["CONF:SOUR"] = "Konfirmáció Forrás";
$factarray["FCOM:PLAC"] = "Elsőáldozás helye";
$factarray["FCOM:DATE"] = "Elsőáldozás dátuma";
$factarray["FCOM:SOUR"] = "Elsőáldozás Forrás";
$factarray["ENGA:PLAC"] = "Eljegyzés helye";
$factarray["ENGA:DATE"] = "Eljegyzés dátuma";
$factarray["ENGA:SOUR"] = "Eljegyzés Forrás";
$factarray["NAME:ROMN"]	= "Katolizált neve";
$factarray["PLAC:ROMN"]	= "Katolizált helység";
$factarray["TITL:_HEB"]	= "Héber Címe";
$factarray["TITL:ROMN"]	= "Katolizált Címe";
$factarray["NAME:FONE"]	= "Fonetikus neve";
$factarray["PLAC:FONE"]	= "Fonetikus helység";
$factarray["TITL:FONE"]	= "Fonetikus Címe";
?>
