<?php
/**
 * Catalan texts
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2009  PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 * @author Antoni Planas i Vilà
 * @package PhpGedView
 * @subpackage Languages
 * @version $Id: facts.ca.php 6487 2009-11-29 17:39:54Z wooc $
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

// -- Define a fact array to map Gedcom tags with their Catalan values

$factarray["ABBR"] = "Abreujament";
$factarray["ADDR"] = "Direcció";
$factarray["ADR1"] = "Direcció 1";
$factarray["ADR2"] = "Direcció 2";
$factarray["ADOP"] = "Adopció";
$factarray["AFN"]  = "Número de fitxer 'Ancestral' (AFN)";
$factarray["AGE"]  = "Edat";
$factarray["AGNC"] = "Agència";
$factarray["ALIA"] = "Àlies";
$factarray["ANCE"] = "Avantpassats";
$factarray["ANCI"] = "Avantpassats insignes";
$factarray["ANUL"] = "Anul·lació";
$factarray["ASSO"] = "Associats";
$factarray["AUTH"] = "Autor";
$factarray["BAPL"] = "Bateig mormó";
$factarray["BAPM"] = "Bateig";
$factarray["BARM"] = "Bar Mitzvà";
$factarray["BASM"] = "Bas Mitzvà";
$factarray["BIRT"] = "Naixement";
$factarray["BLES"] = "Benedicció";
$factarray["BLOB"] = "Objecte de dades binàries";
$factarray["BURI"] = "Enterrament";
$factarray["CALN"] = "Telèfon";
$factarray["CAST"] = "Casta/Estatus social";
$factarray["CAUS"] = "Causa de la mort";
$factarray["CEME"] = "Cementiri";
$factarray["CENS"] = "Empadronament";
$factarray["CHAN"] = "Darrer canvi";
$factarray["CHAR"] = "Joc de Caràcters";
$factarray["CHIL"] = "Fill";
$factarray["CHR"]  = "Bateig";
$factarray["CHRA"] = "Bateig adult";
$factarray["CITY"] = "Població";
$factarray["CONF"] = "Confirmació";
$factarray["CONL"] = "Confirmació mormona";
$factarray["COPR"] = "Copyright";
$factarray["CORP"] = "Corporació / Empresa";
$factarray["CREM"] = "Cremació";
$factarray["CTRY"] = "País";
$factarray["DATA"] = "Dades";
$factarray["DATE"] = "Data";
$factarray["DEAT"] = "Defunció";
$factarray["DESC"] = "Descendents";
$factarray["DESI"] = "Descendents insignes";
$factarray["DEST"] = "Destí";
$factarray["DIV"]  = "Divorci";
$factarray["DIVF"] = "Divorci arxivat";
$factarray["DSCR"] = "Descripció";
$factarray["EDUC"] = "Educació";
$factarray["EMIG"] = "Emigració";
$factarray["ENDL"] = "Dot mormona";
$factarray["ENGA"] = "Prometatge";
$factarray["EVEN"] = "Esdeveniment";
$factarray["FAM"]  = "Família";
$factarray["FAMC"] = "Família com a fill";
$factarray["FAMF"] = "Fitxer de Família";
$factarray["FAMS"] = "Família com a cònjuge";
$factarray["FCOM"] = "Primera Comunió";
$factarray["FILE"] = "Fitxer Extern";
$factarray["FORM"] = "Format";
$factarray["GIVN"] = "Nom/s de Pila";
$factarray["GRAD"] = "Graduació";
$factarray["HUSB"]  = "Marit";
$factarray["IDNO"] = "Número d'Identificació";
$factarray["IMMI"] = "Immigració";
$factarray["LEGA"] = "Legatari/a";
$factarray["MARB"] = "Amonestacions";
$factarray["MARC"] = "Capítols Matrimonials";
$factarray["MARL"] = "Llicència Matrimonial";
$factarray["MARR"] = "Enllaç";
$factarray["MARS"] = "Compromís Matrimonial";
$factarray["MEDI"] = "Tipus de multimèdia";
$factarray["NAME"] = "Nom";
$factarray["NATI"] = "Nacionalitat";
$factarray["NATU"] = "Nacionalització";
$factarray["NCHI"] = "Nombre de fills";
$factarray["NICK"] = "Àlies";
$factarray["NMR"]  = "Nombre de matrimonis";
$factarray["NOTE"] = "Nota";
$factarray["NPFX"] = "Prefix";
$factarray["NSFX"] = "Sufix";
$factarray["OBJE"] = "Objecte multimèdia";
$factarray["OCCU"] = "Ocupació";
$factarray["ORDI"] = "Ordenació mormona";
$factarray["ORDN"] = "Ordenació";
$factarray["PAGE"] = "Detalls de la citació";
$factarray["PEDI"] = "Avantpassats";
$factarray["PLAC"] = "Lloc";
$factarray["PHON"] = "Telèfon";
$factarray["POST"] = "Codi Postal";
$factarray["PROB"] = "Testamentaria";
$factarray["PROP"] = "Propietat";
$factarray["PUBL"] = "Publicació";
$factarray["QUAY"] = "Qualitat de les dades";
$factarray["REPO"] = "Arxiu";
$factarray["REFN"] = "Número de referència";
$factarray["RELA"] = "Parentiu";
$factarray["RELI"] = "Religió";
$factarray["RESI"] = "Residència";
$factarray["RESN"] = "Restricció";
$factarray["RETI"] = "Jubilació";
$factarray["RFN"]  = "Número de fitxer de registre";
$factarray["RIN"]  = "Número ID";
$factarray["ROLE"] = "Rol";
$factarray["SEX"]  = "Sexe";
$factarray["SLGC"] = "Segellament mormó d'un fill";
$factarray["SLGS"] = "Segellament matrimonial mormó";
$factarray["SOUR"] = "Font";
$factarray["SPFX"] = "Prefix del Cognom";
$factarray["SSN"]  = "Número Seguretat Social";
$factarray["STAE"] = "Situació";
$factarray["STAT"] = "Estatus";
$factarray["SUBM"] = "Presentador";
$factarray["SUBN"] = "Presentació";
$factarray["SURN"] = "Cognom";
$factarray["TEMP"] = "Temple";
$factarray["TEXT"] = "Text";
$factarray["TIME"] = "Hora";
$factarray["TITL"] = "Títol";
$factarray["TYPE"] = "Tipus";
$factarray["WIFE"]  = "Esposa";
$factarray["TYPE"] = "Tipus";
$factarray["WILL"] = "Testament";
$factarray["_EMAIL"]= "Correu electrònic";
$factarray["EMAIL"] = "Correu electrònic";
$factarray["_TODO"] = "Fer Ítem";
$factarray["_UID"]  = "Identificador Universal";
$factarray["_PRIM"] = "Imatge principal";
$factarray["_DBID"] = "ID de la base de dades vinculada";
$factarray["STAT:DATE"] = "Data del canvi d'estatus";
$factarray["FAMC:HUSB:SURN"] = "Cognom del pare";
$factarray["FAMC:WIFE:SURN"] = "Cognom de la mare";
$factarray["FAMC:HUSB:BIRT:PLAC"] = "Lloc de naixement del pare";
$factarray["FAMC:WIFE:BIRT:PLAC"] = "Lloc de naixement de la mare";
$factarray["FAMC:MARR:PLAC"] = "Lloc de casament dels pares";
$factarray["FAMC:HUSB:OCCU"] = "Ofici del pare";
$factarray[":BIRT:PLAC"] = "Lloc de naixement";
$factarray["FAMS:MARR:PLAC"] = "Lloc de casament";
$factarray["FAMS:SPOUSE:DEAT:PLAC"] = "Lloc de defunció del cònjuge";
$factarray["FAMC:HUSB:GIVN"] = "Nom de pila del pare";
$factarray["FAMS:SPOUSE:BIRT:PLAC"] = "Lloc de naixement del cònjuge";
$factarray["FAMC:WIFE:GIVN"] = "Nom de pila de la mare";
$factarray["FAMC:HUSB:FAMC:HUSB:GIVN"] = "Nom de pila de l'avi patern";
$factarray["FAMC:WIFE:FAMC:WIFE:GIVN"] = "Nom de pila de l'àvia materna";
$factarray["FAMC:WIFE:FAMC:HUSB:GIVN"] = "Nom de pila de l'avi matern";
$factarray["FAMC:HUSB:FAMC:WIFE:GIVN"] = "Nom de pila de l'àvia paterna";
$factarray["FAMS:CHIL:BIRT:PLAC"] = "Lloc de naixement del fill/a";
$factarray["BIRT:PLAC"] = "Lloc de naixement";
$factarray["DEAT:PLAC"] = "Lloc de defunció";
$factarray["CHR:PLAC"] = "Lloc de bateig";
$factarray["BAPM:PLAC"] = "Lloc de bateig";
$factarray["BURI:PLAC"] = "Lloc d'enterrament";
$factarray["MARR:PLAC"] = "Lloc de casament";


// These facts are specific to gedcom exports from Family Tree Maker
$factarray["_MDCL"]	= "Metge";
$factarray["_DEG"]	= "Grau";
$factarray["_MILT"]	= "Servei Militar";
$factarray["_SEPR"]	= "Separat";
$factarray["_DETS"]	= "Defunció d'un Cònjuge";
$factarray["CITN"]	= "Ciutadania";
$factarray["_FA1"] 	= "Esdeveniment 1";
$factarray["_FA2"] 	= "Esdeveniment 2";
$factarray["_FA3"] 	= "Esdeveniment 3";
$factarray["_FA4"] 	= "Esdeveniment 4";
$factarray["_FA5"] 	= "Esdeveniment 5";
$factarray["_FA6"] 	= "Esdeveniment 6";
$factarray["_FA7"] 	= "Esdeveniment 7";
$factarray["_FA8"] 	= "Esdeveniment 8";
$factarray["_FA9"] 	= "Esdeveniment 9";
$factarray["_FA10"] 	= "Esdeveniment 10";
$factarray["_FA11"] 	= "Esdeveniment 11";
$factarray["_FA12"] 	= "Esdeveniment 12";
$factarray["_FA13"] 	= "Esdeveniment 13";
$factarray["_MREL"] 	= "Enllaç amb la Mare";
$factarray["_FREL"] 	= "Enllaç amb el Pare";
$factarray["_FA1"] 	= "Esdeveniment: Matrimoni";
$factarray["_MSTAT"] 	= "Inici d'estatus matrimonial";
$factarray["_MEND"] 	= "Casament, fi de situació";

// GEDCOM 5.5.1 related facts
$factarray["FAX"] 	= "FAX";
$factarray["FACT"] 	= "Esdeveniment";
$factarray["WWW"] 	= "Pàgina Web";
$factarray["MAP"] 	= "Mapa";
$factarray["LATI"] 	= "Latitud";
$factarray["LONG"] 	= "Longitud";
$factarray["FONE"] 	= "Fonètic";
$factarray["ROMN"] 	= "Romanitzat";

// PAF related facts
$factarray["_NAME"] 	= "Nom de correu";
$factarray["URL"] 	= "Web URL";
$factarray["_URL"] 	= "Web URL";
$factarray["_HEB"] 	= "Hebreu";
$factarray["_SCBK"] 	= "Àlbum de retalls";
$factarray["_TYPE"] 	= "Tipus de multimèdia";
$factarray["_SSHOW"] 	= "Presentació de diapositives";

// Rootsmagic
$factarray["_SUBQ"]	= "Versió breu";
$factarray["_BIBL"] 	= "Bibliografia";

// Reunion
$factarray["EMAL"]	= "Adreça de correu electrònic";

// Other common customized facts
$factarray["_ADPF"]	= "Adoptat pel pare";
$factarray["_ADPM"]	= "Adoptat per la mare";
$factarray["_AKAN"]	= "Àlies";
$factarray["_AKA"] 	= "Àlies";
$factarray["_BRTM"]	= "Circumcisió";
$factarray["_COML"]	= "Matrimoni Civil";
$factarray["_EYEC"]	= "Color d'ulls";
$factarray["_FNRL"]	= "Funeral";
$factarray["_HAIR"]	= "Color dels cabells";
$factarray["_HEIG"]	= "Alçada";
$factarray["_HOL"]  = "Holocaustre";
$factarray["_INTE"]	= "Enterrat";
$factarray["_MARI"]	= "Petició de matrimoni";
$factarray["_MBON"]	= "Compromís matrimonial";
$factarray["_MEDC"]	= "Condició mèdica";
$factarray["_MILI"]	= "Militar";
$factarray["_NMR"]	= "No casats";
$factarray["_NLIV"]	= "No és viu";
$factarray["_NMAR"]	= "Mai casat";
$factarray["_PRMN"]	= "Número Permanent";
$factarray["_SEPR"]	= "Separat";
$factarray["_WEIG"]	= "Pes";
$factarray["_YART"]	= "Yartzeit";
$factarray["_MARNM"]	= "Nom de casada";
$factarray["_MARNM_SURN"] = "Cognom de casada";
$factarray["_STAT"]	= "Situació matrimonial";
$factarray["COMM"]	= "Comentari";

// Aldfaer related facts
$factarray["MARR_CIVIL"] 	= "Matrimoni civil";
$factarray["MARR_RELIGIOUS"] 	= "Matrimoni religiós";
$factarray["MARR_PARTNERS"] 	= "Parella de fet";
$factarray["MARR_UNKNOWN"] 	= "Tipus d'enllaç desconegut";

$factarray["_HNM"] = "Hebrew Name";

// Pseudo-facts for relatives
$factarray["_DEAT_SPOU"] = "Defunció del cònjuge";

$factarray["_BIRT_CHIL"] = "Naixement d'un fill";
$factarray["_MARR_CHIL"] = "Casament d'un/a fill/a";
$factarray["_DEAT_CHIL"] = "Defunció d'un/a fill/a";

$factarray["_BIRT_GCHI"] = "Naixement d'un/a nét/a";
$factarray["_MARR_GCHI"] = "Casament d'un/a nét/a";
$factarray["_DEAT_GCHI"] = "Defunció d'un/a nét/a";
$factarray["_BIRT_GGCH"] = "Naixement d'un/a besnét/a";
$factarray["_MARR_GGCH"] = "Casament d'un/na besnét/ta";
$factarray["_DEAT_GGCH"] = "Defunció d'un/a besnét/a";

$factarray["_MARR_FATH"] = "Casament del pare";
$factarray["_DEAT_FATH"] = "Defunció del pare";

$factarray["_MARR_MOTH"] = "Casament de la mare";
$factarray["_DEAT_MOTH"] = "Defunció de la mare";

$factarray["_BIRT_SIBL"] = "Naixement d'un/a germà/na";
$factarray["_MARR_SIBL"] = "Casament d'un/a germà/na";
$factarray["_DEAT_SIBL"] = "Defunció d'un/a germà/na";

$factarray["_BIRT_HSIB"] = "Naixement d'un/a germanastre/a";
$factarray["_MARR_HSIB"] = "Casament d'un/a germanastre/a";
$factarray["_DEAT_HSIB"] = "Defunció d'un/a germanastre/a";
$factarray["_BIRT_NEPH"] = "Naixement d'un nét o néta";
$factarray["_MARR_NEPH"] = "Casament d'un nét o néta";
$factarray["_DEAT_NEPH"] = "Defunció d'un nét o néta";

$factarray["_DEAT_GPAR"] = "Defunció d'un/a avi/a";
$factarray["_DEAT_GGPA"] = "Defunció d'un besavi";

$factarray["_BIRT_FSIB"] = "Naixement d'un oncle patern";
$factarray["_MARR_FSIB"] = "Casament d'un oncle patern";
$factarray["_DEAT_FSIB"] = "Defunció d'un oncle/tieta patern/a";

$factarray["_BIRT_MSIB"] = "Naixement d'un oncle/tieta matern/a";
$factarray["_MARR_MSIB"] = "Casament d'un oncle/tieta matern/a";
$factarray["_DEAT_MSIB"] = "Defunció d'un oncle/tieta matern/a";

$factarray["_BIRT_COUS"] = "Naixement d'un/a cosí/na germà/na";
$factarray["_MARR_COUS"] = "Casament d'un/a cosí/na germà/na";
$factarray["_DEAT_COUS"] = "Defunció d'un/a cosí/na germà/na";
$factarray["_FAMC_EMIG"] = "Emigració dels pares";
$factarray["_FAMC_RESI"] = "Residència dels pares";

//-- PGV Only facts
$factarray["_THUM"]	= "Emprar aquesta imatge per la miniatura?";
$factarray["_PGVU"]	= "Autor";
$factarray["SERV"] 	= "Servidor remot";
$factarray["FAMS:MARR:DATE"] = "Data de casament";
$factarray["BIRT:DATE"] = "Data de naixement";
$factarray["DEAT:DATE"] = "Data de defunció";
$factarray["CHR:DATE"] = "Data de bateig";
$factarray["BAPM:DATE"] = "Data de bateig";
$factarray["MARR:DATE"] = "Data de casament";
$factarray["BURI:DATE"] = "Data d'enterrament";
$factarray["_NAMS"]	= "Homònim";
$factarray["_BURI_SPOU"] = "Enterrament del cònjuge";
$factarray["_CREM_SPOU"] = "Cremació del cònjuge";
$factarray["_BAPM_CHIL"] = "Bateig d'un fill";
$factarray["__BRTM_CHIL"] = "Circumcisió d'un fill";
$factarray["_ADOP_CHIL"] = "Adopció d'un fill";
$factarray["_BURI_CHIL"] = "Entrerrament d'un fill";
$factarray["_CREM_CHIL"] = "Cremació d'un fill";
$factarray["_BAPM_GCHI"] = "Baptisme d'un nét";
$factarray["__BRTM_GCHI"] = "Circumcisió d'un nét";
$factarray["_ADOP_GCHI"] = "Adopció d'un nét";
$factarray["_BURI_GCHI"] = "Enterrament d'un nét";
$factarray["_CREM_GCHI"] = "Cremació d'un nét";
$factarray["_BAPM_GGCH"] = "Bateig d'un besnét";
$factarray["_ADOP_GGCH"] = "Adopció d'un besnét";
$factarray["_BURI_GGCH"] = "Entrerrament d'un besnét";
$factarray["_BURI_FATH"] = "Enterrament del pare";
$factarray["_CREM_FATH"] = "Cremació del pare";
$factarray["_MARR_FAMC"] = "Casament dels pares";
$factarray["_BURI_MOTH"] = "Enterrament de la mare";
$factarray["_CREM_MOTH"] = "Cremació de la mare";
$factarray["_BURI_SIBL"] = "Enterrament d'un germà";
$factarray["_ADOP_HSIB"] = "Adopció d'un germanastre";
$factarray["_BAPM_NEPH"] = "Bateig d'un nebot o neboda";
$factarray["_CREM_NEPH"] = "Cremació d'un nebot o neboda";
$factarray["_BURI_GPAR"] = "Enterrament d'un avi";
$factarray["_CREM_GPAR"] = "Cremació d'un avi";
$factarray["_BURI_GGPA"] = "Enterrament d'un besavi";
$factarray["_CREM_GGPA"] = "Cremació d'un besavi";
$factarray["_BAPM_FSIB"] = "Bateig d'un oncle patern";
$factarray["__BRTM_FSIB"] = "Circumcisió d'un oncle patern";
$factarray["_ADOP_FSIB"] = "Adopció d'un oncle patern";
$factarray["_BURI_FSIB"] = "Enterrament d'un oncle patern";
$factarray["_CREM_FSIB"] = "Cremació d'un oncle patern";
$factarray["__BRTM_MSIB"] = "Circumcisió d'un oncle matern";
$factarray["_ADOP_MSIB"] = "Adopció d'un oncle matern";
$factarray["_BURI_MSIB"] = "Enterrament d'un oncle matern";
$factarray["_BAPM_COUS"] = "Bateig d'un cosí germà";
$factarray["_BURI_COUS"] = "Enterrament d'un cosí germà";
$factarray["_CREM_COUS"] = "Cremació d'un cosí germà";
$factarray["_MARB_CHIL"] = "Amonestacions d'un fill/a";
$factarray["_MARB_GCHI"] = "Amonestacions d'un";
$factarray["_MARB_GCHI"] = "Amonestacions d'un nét";
$factarray["__BRTM_GGCH"] = "Circumcisió d'un besnét";
$factarray["_MARB_GGCH"] = "Amonestacions d'un besnét";
$factarray["_CREM_GGCH"] = "Cremació d'un besnét";
$factarray["_MARB_FATH"] = "Amonestacions del pare";
$factarray["_MARB_FAMC"] = "Amonestacions dels pares";
$factarray["_MARB_MOTH"] = "Amonestacions de la mare";
$factarray["_BAPM_SIBL"] = "Bateig d'un germà";
$factarray["_CREM_SIBL"] = "Cremació d'un germà";
$factarray["_BAPM_HSIB"] = "Bateig d'un germanastre";
$factarray["__BRTM_HSIB"] = "Circumcisió d'un germanastre";
$factarray["_MARB_HSIB"] = "Amonestacions d'un germanastre";
$factarray["_BURI_HSIB"] = "Enterrament d'un germanastre";
$factarray["_CREM_HSIB"] = "Cremació d'un germanastre";
$factarray["__BRTM_NEPH"] = "Circumcisió d'un nebot";
$factarray["_ADOP_NEPH"] = "Adopció d'un nebot o neboda";
$factarray["_MARB_NEPH"] = "Amonestacions d'un nebot o neboda";
$factarray["_BURI_NEPH"] = "Enterrament d'un nebot o neboda";
$factarray["_MARB_FSIB"] = "Amonestacions d'un oncle patern";
$factarray["_BAPM_MSIB"] = "Bateig d'un oncle matern";
$factarray["_MARB_MSIB"] = "Amonestacions d'un oncle matern";
$factarray["_CREM_MSIB"] = "Cremació d'un oncle matern";
$factarray["_CHR_COUS"]  = "Bateig d'un cosí-germà";
$factarray["__BRTM_COUS"] = "Circumcisió d'un cosí germà";
$factarray["_ADOP_COUS"] = "Adopció d'un cosí-germà";
$factarray["_MARB_COUS"] = "Amonestacions d'un cosí germà";
$factarray["__BRTM_SIBL"] = "Circumcisió d'un germà";
$factarray["_ADOP_SIBL"] = "Adopció d'un germà";
$factarray["_MARB_SIBL"] = "Amonestacions d'un germà";
$factarray["DATA:DATE"] = "Data d'entrada a la font original";
$factarray["_GEDF"] 	= "Fitxer GEDCOM";
$factarray["NAME:_HEB"]	= "Nom en hebreu";
$factarray["PLAC:_HEB"]	= "Lloc en hebreu";
$factarray["TITL:_HEB"]	= "Títol en hebreu";
$factarray["NAME:ROMN"]	= "Nom romanitzat";
$factarray["PLAC:ROMN"]	= "Lloc romanitzat";
$factarray["TITL:ROMN"]	= "Títol romanitzat";
$factarray["NAME:FONE"]	= "Nom fonètic";
$factarray["PLAC:FONE"]	= "Lloc fonètic";
$factarray["TITL:FONE"]	= "Títol fonètic";
$factarray["SHARED_NOTE"]	= "Nota compartida";
$factarray["FAMS:NOTE"] = "Nota dels cònjuges";
$factarray["FAMS:CENS:DATE"] = "Data d'empadronament dels cònjuges";
$factarray["FAMS:CENS:PLAC"] = "Lloc d'empadronament dels cònjuges";
$factarray["FAMS:DIV:DATE"] = "Data de divorci dels cònjuges";
$factarray["FAMS:DIV:PLAC"] = "Lloc de divorci dels cònjuges";
$factarray["FAMS:SLGS:DATE"] = "Data de segellament SUD dels cònjuges";
$factarray["FAMS:SLGS:PLAC"] = "Lloc de segellament SUD dels cònjuges";
$factarray["FAMS:SLGS:TEMP"] = "Temple de segellament SUD dels cònjuges";
$factarray["_CHR_CHIL"] = "Bateig d'un/a fill/a";
$factarray["_CHR_GCHI"] = "Bateig d'un nét";
$factarray["_CHR_GGCH"] = "Bateig d'un besnét";
$factarray["_CHR_SIBL"] = "Bateig d'un germà";
$factarray["_CHR_HSIB"] = "Bateig d'un gesmanastre";
$factarray["_CHR_NEPH"] = "Bateig d'un nebot o neboda";
$factarray["_CHR_FSIB"] = "Bateig d'un oncle";
$factarray["_CHR_MSIB"] = "Bateig d'una tieta";
?>
