<?php
/**
 * Slovak Language file for PhpGedView.
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2009  PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 * @package PhpGedView
 * @subpackage Languages
 * @author Peter Moravčík
 * @version $Id: configure_help.sk.php 4863 2009-01-21 22:03:52Z canajun2eh $
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

//-- SPRÁVY KONFIGURAČNÉHO SÚBORU
$pgv_lang["gedcom_conf"]		= "Základný GEDCOM";
$pgv_lang["media_conf"]			= "Multimédia";
$pgv_lang["media_general_conf"]	= "Hlavný";
$pgv_lang["media_firewall_conf"]	= "Media Firewall";
$pgv_lang["accpriv_conf"]		= "Prístup a utajenie";
$pgv_lang["displ_conf"]			= "Zobrazenie a rozvrhnutie";
$pgv_lang["displ_names_conf"]		= "Mená";
$pgv_lang["displ_comsurn_conf"] 	= "Časté priezviská";
$pgv_lang["displ_layout_conf"]		= "Rozvrhnutie";
$pgv_lang["displ_hide_conf"]		= "Skryť a zobraziť";
$pgv_lang["editopt_conf"]		= "Upraviť nastavenia";
$pgv_lang["useropt_conf"]		= "Uživateľské nastavenia";
$pgv_lang["contact_conf"]		= "Kontaktné informácie";
$pgv_lang["meta_conf"]			= "Konfiguračné možnosti META tagov";
$pgv_lang["gedconf_head"]		= "Nastavenie GEDCOMu";
$pgv_lang["other_theme"]		= "Ďalší, prosím vypíšte";
$pgv_lang["performing_update"]		= "Vykonávanie aktualizácie.";
$pgv_lang["config_file_read"]		= "Konfiguračný súbor je načítaný.";
$pgv_lang["does_not_exist"]		= "neexistuje";
$pgv_lang["media_drive_letter"]		= "Cesta k mediálnym súborom by nemala obsahovať písmeno disku; nemuseli by sa potom zobraziť.";
$pgv_lang["db_setup_bad"]		= "Aktuálne nastavenie vašej databázy je zlé. Prosím skontrolujte parametre  databázového pripojenia a nastavte ho znova.";
$pgv_lang["bad_host_user_pass"]		= "PhpGedView nebolo schopné naviazať spojenie z vašou MySQL databázou. Skontrolujte položky host, uživateľské_meno a heslo, abyste sa uistili, že ste všetko nastavili správne.";
$pgv_lang["bad_database_name"]		= "PhpGedView vytvorilo spojenie s vašou MySQL databázou, ale nebolo schopné používať databázu s názvom, ktorý ste zadali. Skontrolujte, či táto databáza existuje a či uživateľ, ktorého uživateľské_meno ste zadali, má zodpovedajúce práva pre prácu s touto databázou.";
$pgv_lang["db"]				= "Databáza";
$pgv_lang["dbase"]			= "dBase";
$pgv_lang["current_gedcoms"]		= "Súčasné GEDCOM súbory";
$pgv_lang["ged_gedcom"]			= "Súbory GEDCOM";
$pgv_lang["ged_title"]			= "Nadpis GEDCOMu";
$pgv_lang["ged_config"]			= "Konfiguračný súbor";
$pgv_lang["ged_search"]			= "Súbory protokolov";
$pgv_lang["ged_change"]			= "ChangeLog súbory";
$pgv_lang["ged_privacy"]		= "Súbor utajenia";
$pgv_lang["disabled"]			= "Vypnuté";
$pgv_lang["mouseover"]			= "Po prejdení myšou";
$pgv_lang["mousedown"]			= "Po zídení myšou dolu";
$pgv_lang["click"]			= "Po kliknutí myšou";
$pgv_lang["enter_db_pass"]		= "Z bezpečnostných dôvodov musíte pred upravovaním nastavení zadať uživateľské meno a heslo do databázy.";
$pgv_lang["DBTYPE"]			= "Typ databázy";
$pgv_lang["DBTYPE_help"]		= "Typ podporovanej PEAR databázy, ku ktorej sa má pripojiť. Možnosti sú: MySQL, PostgreSQL, Oracle a SQLite. MySQL a PostgreSQL vyžadujú knihovňu inštalovanú v PHP. SQLite je inštalovaná ako implicitná v PHP 5.<br /><br />Pre SQLite nemusíte mať nastavené #pgv_lang[DBHOST]#, #pgv_lang[DBUSER]#, alebo #pgv_lang[DBPASS]#, Ale musíte mať nastavenú  cestu ku vašej databáze v poli #pgv_lang[DBNAME]#.";
$pgv_lang["DBHOST"]			= "Host databáza";
$pgv_lang["DBHOST_help"]		= "DNS alebo IP adresa počítača, na ktorom je nainštalovaný váš databázový server. Toto nastavenie je ignorované ak používate SQLite databázu.";
$pgv_lang["DBUSER"]			= "Uživateľské meno ku databáze";
$pgv_lang["DBUSER_help"]		= "Ku vstupu do vašej databázy je vyžadované uživateľské meno a heslo. Toto nastavenie je ignorované u SQLite databázy.";
$pgv_lang["DBPASS"]			= "Heslo ku databáze";
$pgv_lang["DBPASS_help"]		= "Heslo ku databáze pre uživateľa, ktorého uživateľské meno ste zadali do políčka #pgv_lang[DBUSER]#.Toto nastavenie je ignorované ak používate SQLite databázu.";
$pgv_lang["DBNAME"]			= "Meno databázy";
$pgv_lang["DBNAME_help"]		= "Databáza na vašom serveri, ktorú má PhpGedView použiť.<br /><br />Uživateľ, ktorého uživateľské meno jste zadali do políčka #pgv_lang[DBUSER]#, musí mať práva Vytvoriť, Vložiť, Obnoviť, Zmazať a Vyberať z databázy. Pre SQLite musíte nastaviť súbor a adresár, pre ktorým má PHP právo zapisovať, napríklad váš indexový adresár (index/phpgedview.db).";
$pgv_lang["TBLPREFIX_help"]		= "Prefix pripisovaný do názvov tabuliek vytvorených aplikáciou PhpGedView.  Zmenou tejto hodnoty môžete zaistiť používanie jednej fyzickej databázy viacerými aplikáciami PhpGedView, ale každá bude používať vlastné tabuľky. Napríklad \"test\" pre testovaciu inštaláciu a \"production\" pre ostrú inštaláciu PhpGedView.";
$pgv_lang["server_url_note"]		= "Toto by mal byť odkaz na vašu zložku z PhpGedView. Toto nastavenie by ste mali meniť jedine v prípade, ak ste si istý tým, čo robíte. PhpGedView nastavilo SERVER_URL na #GUESS_URL#";
$pgv_lang["ALLOW_CHANGE_GEDCOM_help"]	= "Ak nastavíte túto hodnotu na <b>Ano</b>, povolíte tým návštevníkom vašich stránok možnosť prepnout medzi GEDCOM súbormi, ak ich máte viacej.<br /><br />Ak je nastavené <b>Ne</b>, ani návštevníci, <b>ani</b> prihlásený uživatelia nebudú môcť prepínať medzi GEDCOM súbormi.";
$pgv_lang["upload_path"]		= "Cesta načítania";
$pgv_lang["upload_path_help"]		= "~#pgv_lang[upload_path]#~<br /><br />To je cesta ku GEDCOM súboru, ktorý chcete načítať. Pre nájdenie cesty, kliknite na <b>Prehliadať</b>, nájdite váš GEDCOM súbor a potom kliknite na <b>Otvoriť</b>.";
$pgv_lang["gedcom_path"]		= "Meno a cesta ku GEDCOM súboru";
$pgv_lang["gedcom_path_help"]		= "Najskôr nahrajte GEDCOM súbor do umiestnenia prístupného PHP na vašom serveri. Potom zadajte cestu a názov tohoto súboru ako napríklad: <b>./index/name.ged</b>.<br /><br />Podívajte sa do súboru <a href=\"readme.txt\">Readme.txt</a> pre ďalšie informácie.";
$pgv_lang["CHARACTER_SET"]		= "Znaková sada (kódovanie)";
$pgv_lang["CHARACTER_SET_help"]		= "Toto je znaková sada vášho GEDCOM súboru. UTF-8 je implicitná hodnota a mala by fungovať väčšine uživateľov. Ak exportujete váš GEDCOM súbor s kódovaním Windows, potom by ste sem mali napísať WINDOWS.<br /><br />POZOR: PHP NEPODPORUJE kódovanie UNICODE (UTF-16), takže to ani neskúšajte. Sťažovať si môžete iba autorom PHP :-).<br /><br />Ak potrebujete zmeniť kódovanie vášho exportovaného GEDCOM súboru tak si otvorte *.ged súbor (je to bežný textový súbor) v editore (napríklad Notepad) a vyberte možnosť \"Uložiť ako\" a zmeňte pritom kódovanie na UTF-8.";
$pgv_lang["LANGUAGE"]			= "Jazyk";
$pgv_lang["LANGUAGE_help"]		= "Určite implicitný jazyk pre svoje stránky. Uživatelia majú možnosť si toto nastavenie zmeniť buď pomocou nastavenia prehliadača alebo formulárom dolu na stránke (ak je nastavené <b>#pgv_lang[ENABLE_MULTI_LANGUAGE]#</b>= true).";
$pgv_lang["ENABLE_MULTI_LANGUAGE"]	= "Povoliť uživateľom zmenu jazyka";
$pgv_lang["ENABLE_MULTI_LANGUAGE_help"]	= "Nastavte na 'ano', ak chcete povoliť uživateľom vybrať si iný jazyk zo zoznamu dolu na stránke a pre možnosť nastavenia implicitného jazyka podľa jazykového nastavenia prehliadača.";
$pgv_lang["CALENDAR_FORMAT"]		= "Formát kalendára";
$pgv_lang["CALENDAR_FORMAT_help"]	= "Toto vám umožňuje určiť typ kalendára, ktorý chcete použiť u tohoto GEDCOM súboru. Hebrejský je rovnaký ako židovský z hebrejskými znakmi.  Pozor: Hodnoty použité pre dátumy v židovskom / hebrejskom kalendári sú vypočítané z dátumov gregoriánskeho / juliánskeho kalendára. Pretože v židovskom kalendári začínajú dni súmrakom, akákoľvek udalosť medzi súmrakom a polnocou sa zobrazí s dátumom posunutým o jeden deň dopredu vzhľadom ku správnemu židovskému dátumu. Zobrazenie hebrejštiny nemusí fungovať v starých verziách prehliadačov. Niektoré staré verzie prehliadača zobrazia hebrejštinu pozpiatky alebo vôbec nie.";
$pgv_lang["DISPLAY_JEWISH_THOUSANDS"]	= "Zobraziť hebrejské tisíce";
$pgv_lang["DISPLAY_JEWISH_THOUSANDS_help"]	= "Ukázať \"Alafim\" v hebrejskom kalendári. Nastavenie na \"ano\" zpôsobí zobrazenie roku 1969 ako <span lang=\"he-IL\" dir='rtl'>&#1492;'&#160;&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm;, zatiaľ, ak je nastavená hodnota \"nie\", bude zobrazené <span lang=\"he-IL\" dir='rtl'>&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm;. Toto nemá vplyv na nastavenie židovského roku. Rok bude zobrazený ako 5729 bez ohľadu na toto nastavenie.<br />Pozor: Toto nastavenie je podobné konštante CAL_JEWISH_ADD_ALAFIM v PHP 5.0 Calendar.";
$pgv_lang["DISPLAY_JEWISH_GERESHAYIM"]		= "Zobraziť hebrejský Gershayim";
$pgv_lang["DISPLAY_JEWISH_GERESHAYIM_help"]	= "Pri zobrazovaní hebrejských dátumov používať jednoduché a dvojité úvodzovky. Ak túto hodnotu nastavíte na \"ano\", zobrazí sa dátum 8. februára 1969 ako  <span lang='he-IL' dir='rtl'>&#1499;'&#160;&#1513;&#1489;&#1496;&#160;&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm;, zatiaľ čo hodnota \"nie\" znamená zobrazenie <span lang='he-IL' dir='rtl'>&#1499;&#160;&#1513;&#1489;&#1496;&#160;&#1514;&#1513;&#1499;&#1496;</span>&lrm;. Toto nemá žiadny vplyv na nastavenie židovského roku, pretože úvodzovky sa v židovských dátumoch zapísaných latinkou nepoužívajú.<br />Pozor: Toto nastavenie sa podobá konštantám CAL_JEWISH_ADD_ALAFIM_GERESH a CAL_JEWISH_ADD_GERESHAYIM v PHP 5.0 Calendar. Toto jediné nastavenie postihuje oboje.";
$pgv_lang["JEWISH_ASHKENAZ_PRONUNCIATION"]	= "Židovská výslovnosť Ashkenazi";
$pgv_lang["JEWISH_ASHKENAZ_PRONUNCIATION_help"]	= "Použiť židovskú výslovnosť \"Ashkenazi\".<br />Ak je táto hodnota nastavená na \"ano\", pre mesiace Cheshvan a Teves bude použitá výslovnosť \"Ashkenazi\". Ak nastavíte hodnotu na \"nie\", budú mesiace zmenené na Hesvan a Tevet. <br />Toto má vplyv len na židovské nastavenie. Ak zvolíte hebrejské nastavenie, bude použitá hebrejská abeceda.";
$pgv_lang["USE_RTL_FUNCTIONS"]			= "Použi RTL spracovanie";
$pgv_lang["USE_RTL_FUNCTIONS_help"]		= "Použijte toto nastavení pre správné zobrazenie GEDCOM dát v RTL jazykoch. Ak nastavíte <b>Ano</b> tak databáza bude spracovaná tak, aby správne zobrazila RTL dáta, toto nastavenie môže spomaliť spracovanie.";
$pgv_lang["DEFAULT_PEDIGREE_GENERATIONS"]	= "Počet generácií vo vývode";
$pgv_lang["DEFAULT_PEDIGREE_GENERATIONS_help"]	= "Nastavte implicitný počet generácií, ktoré sa majú zobraziť vo vývodoch.";
$pgv_lang["MAX_PEDIGREE_GENERATIONS"]		= "Maximálny počet generácií vo vývode";
$pgv_lang["MAX_PEDIGREE_GENERATIONS_help"]	= "Nastavte maximálny počet generácií, ktorý sa môže zobraziť vo vývodoch.";
$pgv_lang["MAX_DESCENDANCY_GENERATIONS"]	= "Maximálny počet generácií v rozrode";
$pgv_lang["MAX_DESCENDANCY_GENERATIONS_help"]	= "Nastavte maximálny počet generácií, ktorý sa môže zobraziť v rozrodoch.";
$pgv_lang["USE_RIN"]			= "Použiť RIN# miesto GEDCOM ID";
$pgv_lang["USE_RIN_help"]		= "Zvolte ANO, ak chcete pri dotaze na ID osôb v konfiguračných súboroch, uživateľských nastaveniach a schémach použiť číslo RIN miesto GEDCOM ID.  To je užitočné v prípade, že váš genealogický program neexportuje GEDCOM súbormi s konkurenčnými ID a miesto toho používa rovnaký RIN.";
$pgv_lang["GENERATE_GUID"]		= "Automaticky vytvoriť globálne unikátne ID";
$pgv_lang["GENERATE_GUID_help"]	= "~#pgv_lang[GENERATE_GUID]#~<br /><br /><b>GUID</b> v tomto význame je skratkou pre «Globálne unikátne ID».<br /><br />GUID sú určené k identifikácii každej osoby, obvykle sú využívané centrálnymi organizáciami ako je Family History Center of the LDS Church v Salt Lake City, alebo kompatibilnými programami bežiacimi na vašom serveri na určenie či sa jedná o tú istú osobu bez ohľadu na pôvod GEDCOMu. Ciel Family History Center je mať centrálny archív genealogických údajov a sprístupniť ich na WEBe. To umožní sprístupniť údaje akémukoľvek programu a aktualizovať ich vlastné údaje.<br /><br />Ak nezamýšľate zdieľať tento GEDCOM s niekým iným, nemusíte nechať PhpGedView vytvoriť tieto GUID; ak tak ale urobíte nemá to žiadny iný dôsledok ako zväčšenie vášho GEDCOMu.<br />";
$pgv_lang["PEDIGREE_ROOT_ID"]		= "Implicitná osoba pre vývod a rozrod";
$pgv_lang["PEDIGREE_ROOT_ID_help"]	= "Zvolte ID osoby, ktorá sa má implicitne zobrazovať vo vývodoch a rozrodoch.";
$pgv_lang["GEDCOM_ID_PREFIX"]		= "GEDCOM ID Prefix";
$pgv_lang["GEDCOM_ID_PREFIX_help"]	= "Tento prefix bude pridaný vo vývode, rozrode a iných schémach v prípade, že uživatelia sami prefix ku ID nedoplnia.";
$pgv_lang["FAM_ID_PREFIX"]		= "Rodina&nbsp;ID prefix";
$pgv_lang["FAM_ID_PREFIX_help"]		= "Ked bude online pridaný záznam pre rodinu do PhpGedView vygeneruje sa automaticky nové ID. Toto ID bude mať nastavený prefix.";
$pgv_lang["AUTO_GENERATE_THUMBS"]	= "Automaticky generovať náhľady";
$pgv_lang["AUTO_GENERATE_THUMBS_help"]	= "|~#pgv_lang[AUTO_GENERATE_THUMBS]#~<br /><br />Systém by mal automaticky generovať náhľady pre obrázky, ktoré ich nemajú. Vaša PHP inštalácia nepodporuje túto funkčnosť.<br />";
$pgv_lang["phpinfo_help"]		= "~#pgv_lang[phpinfo]#~<br /><br />Táto stránka poskytuje rozšírené informácie o servere na ktorom je hostovaný  PhpGedView. Veľa konfiguračných detailov o softvare na servere, ktorý je relevantný pre PHP a PhpGedView, môže byť zobrazených.<br />";
$pgv_lang["config_help_help"]		= "~#pgv_lang[config_help]#~<br /><br />Táto stránka odsahuje hlavné položky nápovedy Konfigurácie. Môžete si infiormácie zobraziť, alebo vytlačiť pre neskoršie použitie.<br />";
$pgv_lang["more_help_advice"]		= "<br /><b>Ďalšia nápoveda</b><br />Ďalšia nápoveda je dostupná po kliknutí na <b>?</b> vedľa položky na stránke.<br />";
$pgv_lang["THUMBNAIL_WIDTH"]		= "Šírka generovaných náhľadov";
$pgv_lang["THUMBNAIL_WIDTH_help"]	= "~#pgv_lang[THUMBNAIL_WIDTH]#~<br /><br />Toto je šírka (v pixeloch) ktorú program použije keď automaticky generuje náhľady. Implicitné nastavenie je 100.<br />";
$pgv_lang["SOURCE_ID_PREFIX"]		= "Zdroj&nbsp;ID prefix";
$pgv_lang["SOURCE_ID_PREFIX_help"]	= "Keď bude online pridaný záznam pre zdroj do PhpGedView, vygeneruje sa automaticky nové ID. Toto ID bude mať nastavený prefix.";
$pgv_lang["REPO_ID_PREFIX"]		= "Prameň&nbsp;ID prefix";
$pgv_lang["REPO_ID_PREFIX_help"]	= "Ak bude online pridaný záznam prameňa do PhpGedView, ID bude generované automaticky. Nové ID prameňa bude mať tento prefix.";
$pgv_lang["PEDIGREE_FULL_DETAILS"]	= "Zobraziť podrobnosti o narodení a úmrtí vo vývode a rozrode";
$pgv_lang["PEDIGREE_FULL_DETAILS_help"]	= "Určuje, či implicitne zobrazovať, alebo nezobrazovať informácie o narodení a úmrtí osôb.";
$pgv_lang["PEDIGREE_LAYOUT"]		= "Implicitné rozvrhnutie vývodu";
$pgv_lang["PEDIGREE_LAYOUT_help"]	= "Toto nastavenie určuje, či budú vývody orientované na šírku, alebo na výšku.";
$pgv_lang["SHOW_EMPTY_BOXES"]		= "Zobrazovať vo vývode i prázdne políčka";
$pgv_lang["SHOW_EMPTY_BOXES_help"]	= "Určuje, či sa majú, alebo nemajú zobrazovať vo vývode i prázdne políčka.";
$pgv_lang["ZOOM_BOXES"]			= "Zväčšovanie políčok v schémach";
$pgv_lang["ZOOM_BOXES_help"]		= "Umožňuje uživateľovi zväčšiť jednotlivé políčka (rámčeky) v rodokmeni a získať viacej informácií. Ak chcete túto vlastnosť vypnúť, nastavte <b>#pgv_lang[disabled]#</b>. Ak nastavíte na <b>#pgv_lang[mouseover]#</b>, zväčší sa rámček, keď uživateľ prejede cez ikonku v rámčeku kurzorom. Ak nastavíte na <b>#pgv_lang[click]#</b>, zväčší sa rámček, keď uživateľ klikne na ikonku v rámčeku.";
$pgv_lang["LINK_ICONS"]			= "PopUp odkazy v schémach";
$pgv_lang["LINK_ICONS_help"]		= "Umožní uživateľovi vybrať odkaz na iné schémy a blízke príbuzné osoby.  Ak nastavíte <b>#pgv_lang[disabled]#</b>, táto vlastnosť bude vypnutá. Ak nastavíte <b>#pgv_lang[mouseover]#</b>, odkazy sa zobrazia, keď uživateľ prejde kurzorom cez ikonku v rámčeku. Ak nastavíte <b>#pgv_lang[click]#</b>, zobrazia sa odkazy v prípade, že uživateľ na ikonku klikne.";
$pgv_lang["ABBREVIATE_CHART_LABELS"]	= "Skrátené popisky pre schémy";
$pgv_lang["ABBREVIATE_CHART_LABELS_help"]	= "Skracovať, či neskracovať v schémach popisky - napr. 'Narodenie' nahradiť len prvým písmenom 'N'.";
$pgv_lang["SHOW_PARENTS_AGE"]			= "Zobraziť vek rodičov pri narodení detí";
$pgv_lang["SHOW_PARENTS_AGE_help"]		= "Toto nastavenie určuje či sa v schémach zobrazí vek rodičov pri narodení detí";
$pgv_lang["SHOW_RELATIVES_EVENTS"]      	= "Zobraziť udalosti blízkych príbuzných na stránke osoby";
$pgv_lang["SHOW_RELATIVES_EVENTS_help"] 	= "~#pgv_lang[SHOW_RELATIVES_EVENTS]#~<br /><br />Narodenia, sobáše a úmrtia príbuzných sú dôležité udalosti v živote. Táto voľba riadi či sú alebo nie sú zobrazené tieto udalosti na záložke  <i>Osobné údaje a detaily</i> na stránke osoby.<br /><br />Udalosti ovplyvnené touto voľbou sú:<ul><li>Úmrtie partnera</li><li>Narodenie a úmrtie detí</li><li>Úmrtie rodičov</li><li>Narodenie a úmrtie súrodencov</li><li>Úmrtie starých rodičov</li><li>Narodenie a úmrtie súrodencov rodičov</li></ul><br />";
$pgv_lang["EXPAND_RELATIVES_EVENTS"]    	= "Automaticky ukázať zoznam udalostí";
$pgv_lang["EXPAND_RELATIVES_EVENTS_help"] 	= "~#pgv_lang[EXPAND_RELATIVES_EVENTS]#~<br /><br />Táto voľba určuje či bude alebo nebude automaticky zobrazený obsah zoznamu <i>Udalosti blízkych príbuzných</i>.<br />";
$pgv_lang["EXPAND_SOURCES"]      		= "Automaticky zobraziť zdroje";
$pgv_lang["EXPAND_SOURCES_help"] 		= "~#pgv_lang[EXPAND_SOURCES]#~<br /><br />Táto voľba určuje či bude alebo nebude automaticky zobrazený obsah záznamov  <i>Zdroje</i> na stránke osoby.<br />";
$pgv_lang["HIDE_LIVE_PEOPLE"]		= "Zapnúť utajovanie";
$pgv_lang["HIDE_LIVE_PEOPLE_help"]	= "Táto voľba zapne všetky nastavenia utajenia dát a schová podrobnosti o žijúcich ľuďoch. Za žijúce osoby sú považované tie, u ktorých nie je akákoľvek udalosť staršia, než koľko rokov je nastavené v premennej \$MAX_ALIVE_AGE, a tie, ktoré nemajú deti narodené skôr než pred \$MAX_ALIVE_AGE rokmi.";
$pgv_lang["REQUIRE_AUTHENTICATION"]	= "Vyžadovať autorizáciu návštevníkov";
$pgv_lang["REQUIRE_AUTHENTICATION_help"]= "Zapnutie tejto voľby donúti všetkých uživateľov prihlásiť sa do systému, aby si mohli zobraziť údaje na tejto stránke.";
$pgv_lang["WELCOME_TEXT_AUTH_MODE"]	= "Úvodný text prihlasovacej stránky v autorizačnom móde";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_help"]	= "Tu môžete zvoliť text, ktorý sa zobrazí na prihlasovacej stránke, ak je autorizačný mód nastavený na ano. Prosím, vyberte najvhodnejší prednastavený text.<br />Môžete zadať i svoj vlastný text, ale ten nebude mať preklad do iných jazykov.<br /><br />Prednastavené texty sú:<br /><br /><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT1]# :</b><br /><br />#pgv_lang[welcome_text_auth_mode_1]#<br /><br /><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT2]# :</b><br /><br />#pgv_lang[welcome_text_auth_mode_2]#<br /><br /><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT3]# :</b><br /><br />#pgv_lang[welcome_text_auth_mode_3]#";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT0"]	= "Prednastavený text";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT1"]	= "Prednastavený text, ktorý hovorí, že všetci uživatelia môžu zažiadať o zriadenie uživateľského účtu";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT2"]	= "Prednastavený text, ktorý hovorí, že administrátor rozhodne v prípade žiadosti o účet";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT3"]	= "Prednastavený text, ktorý hovorí, že o zriadenie uživateľského účtu môžu žiadať iba členovia rodiny";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT4"]	= "Vybrať uživateľom definovaný text uložený pod týmto políčkom";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST"]	= "Vlastný úvodný text pre autorizačný mód";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_help"]	= "Ak ste v predchádzajúcej voľbe vybrali možnosť vlastného úvodného textu, potom tento text môžete napísať sem.<br />Tento text NEBUDE preložený do ďalších jazykov; zobrazí sa vždy presne tak, ako ho teraz napíšete.<br />Môžete používať i HTML tagy.";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_HEAD"] = "Štandardná hlavička pre uživateľský úvodný text";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_HEAD_help"] = "Zvoľte túto možnosť, ak chcete mať pred svojím vlastným úvodným textom viacjazyčnú hlavičku.<br /><br />Ak je nastavené na \"ano\", hlavička bude vyzerať takto:<div class=\"list_value_wrap\">#pgv_lang[welcome_text_cust_head]#</div>";
$pgv_lang["SHOW_REGISTER_CAUTION"]			= "Zobraziť uživateľov suhlas na stránke «Žiadosť o nový uživateľský účet».";
$pgv_lang["SHOW_REGISTER_CAUTION_help"]		= "~#pgv_lang[SHOW_REGISTER_CAUTION]#~<br /><br />Ak nastavíte <b>#pgv_lang[yes]#</b>, zobrazí sa následujúca správa pod pod poľami «#pgv_lang[requestaccount]#» na stránke:<div class=\"list_value_wrap\">#pgv_lang[acceptable_use]#</div>";
$pgv_lang["CHECK_CHILD_DATES"]		= "Skontrolovať údaje detí";
$pgv_lang["CHECK_CHILD_DATES_help"]	= "Skontrolovať údaje detí, aby bolo možné rozhodnúť, či je daná osoba mŕtva. Táto voľba môže na starších systémoch a veľkých GEDCOMoch spomaliť časové odozvy vašich stránok.";
$pgv_lang["MAX_ALIVE_AGE"]		= "Vek, od ktorého je možno osobu považovať za mŕtvu";
$pgv_lang["MAX_ALIVE_AGE_help"]		= "Maximálny vek, v ktorom môže byť u osoby zaznamenaná \"udalosť\" alebo maximálny vek ich detí, aby bolo možné rozhodnúť, či je mŕtva alebo nie.";
$pgv_lang["SHOW_GEDCOM_RECORD"]		= "Umožniť uživateľom prezerať čisté GEDCOM záznamy";
$pgv_lang["SHOW_GEDCOM_RECORD_help"]	= "Ak nastavíte \"ano\", budú pridané odkazy na osoby, pramene a rodiny, čo uživateľom umožní otvárať ďalšie okná s neupravenými záznamami získanými priamo zo súborov GEDCOM.";
$pgv_lang["ALLOW_EDIT_GEDCOM"]		= "Zapnúť online editáciu";
$pgv_lang["ALLOW_EDIT_GEDCOM_help"]	= "Zapíná vlastnosť pre úpravy tohoto GEDCOM súboru online, aby uživatelia z oprávnením k úpravám mohli tento GEDCOM aktualizovať online.";
$pgv_lang["EDIT_AUTOCLOSE"]		= "Automaticky zatvoriť editačné okno";
$pgv_lang["EDIT_AUTOCLOSE_help"]	= "~#pgv_lang[EDIT_AUTOCLOSE]#~<br /><br />Táto voľba riadi či bude, alebo nebude automaticky zatvorené editačné okno po úspešnom uložení zmien.<br />";
$pgv_lang["INDEX_DIRECTORY_help"]	= "Cesta k adresáru z oprávnením čítať a zapisovať, do ktorého by malo PhpGedView ukladať \"Index súbory\" (včetne lomítka \"/\").";
$pgv_lang["POSTAL_CODE"]  		= "Pozícia poštového smerovacieho čísla";
$pgv_lang["POSTAL_CODE_help"] 		= "~#pgv_lang[POSTAL_CODE]#~<br /><br />Rôzne krajiny používajú rôzne spôsoby zápisu adries. Táto voľba vám umožňuje nastaviť umiestnenie PSČ buď pred, alebo za meno mesta.<br />";
$pgv_lang["SUBLIST_TRIGGER_I"]		= "Maximálny počet priezvísk";
$pgv_lang["SUBLIST_TRIGGER_I_help"]	= "~#pgv_lang[SUBLIST_TRIGGER_I]#~<br /><br />Dlhý zoznam osôb s rovnakým priezviskom môže byť rozdelený na menšie podľa prvého písmena v mene osôb.<br /><br />Táto voľba určuje kedy sa zobrazí rozdelený zoznam. Nastavte hodnotu na nulu, ak chcete rozdelenie úplne vypnúť.<br />";
$pgv_lang["SUBLIST_TRIGGER_F"]		= "Maximálny počet priezvísk rodin";
$pgv_lang["SUBLIST_TRIGGER_F_help"]	= "~#pgv_lang[SUBLIST_TRIGGER_F]#~<br /><br />Dlhý zoznam rodín s rovnakým priezviskom môže byť rozdelený na menšie podľa prvého písmena v mene osôb.<br /><br />Táto voľba určuje kedy sa zobrazí rozdelený zoznam. Nastavte hodnotu na nulu, ak chcete rozdelenie úplne vypnúť.<br />";
$pgv_lang["SURNAME_LIST_STYLE"]		= "Štýl zoznamu priezvísk";
$pgv_lang["SURNAME_LIST_STYLE_help"]	= "~#pgv_lang[SURNAME_LIST_STYLE]#~<br /><br />Zoznam priezvísk, ktorý sa zobrazí v bloku #pgv_lang[block_top10]#,  #pgv_lang[individual_list]#, a v #pgv_lang[family_list]#, môže byť zobrazený v roznych štýloch.<ul><li><b>#pgv_lang[style2]#</b>&nbsp;&nbsp;&nbsp;V tomto štýle sú priezviská zobrazené v tabuľke, ktorá môže byť triedená buď podľa priezviska, alebo podľa výskytu.</li><li><b>#pgv_lang[style3]#</b>&nbsp;&nbsp;&nbsp;V tomto štýle sú priezviská zobrazené v zozname a veľkosť fontu použitá pre každé meno je závislá od počtu výskytu mena v databazi. Zoznam nie je možné triediť.</li></ul><br />";
$pgv_lang["NAME_FROM_GEDCOM"]		= "Získať názov pre zobrazenie zo súboru GEDCOM";
$pgv_lang["NAME_FROM_GEDCOM_help"]	= "PhpGedView implicitne používa meno uložené v indexoch pre získanie mena osoby. U niektorých formátov GEDCOM a jazykov sa mená uložené v indexoch nezobrazujú správne a najlepší spôsob, ako získať korektné meno ku zobrazeniu, je zo súboru GEDCOM. Španielské mená sú toho dobrým príkladom. Španielské mená majú takúto podobu: Krstné meno, priezvisko otca, priezvisko matky. Keby boli použité indexy triedenia a zobrazovania, boli by mená zobrazena v tomto tvare: Krstné meno, priezvisko matky, priezvisko otca  čo je nesprávne. Ak sa vrátime pre meno do súboru GEDCOM, dostaneme správne meno. Na druhú stranu, opätovné získavanie mien z GEDCOM súborov spomalí program.";
$pgv_lang["SHOW_ID_NUMBERS_help"]	= "Ukázať ve schémach za menami osôb ich ID čísla v zátvorkach.";
$pgv_lang["SHOW_LAST_CHANGE"]		= "Zobraziť zoznam GEDCOM záznamov s posledným dátumom zmeny";
$pgv_lang["SHOW_LAST_CHANGE_help"]	= "~#pgv_lang[SHOW_LAST_CHANGE]#~<br /><br />Táto voľba riadi či sa má, alebo nemá zobraziť zoznam GEDCOM záznamov s posledným dátumom zmeny.<br />";
$pgv_lang["SHOW_PEDIGREE_PLACES"]	= "Úrovne miest k zobrazeniu v políčkach osôb";
$pgv_lang["SHOW_PEDIGREE_PLACES_help"]	= "Toto nastavenie určuje, koľko informácií o mieste bude zobrazené v políčku osoby v rodokmeni. Ak nastavíte hodnotu 9, zaistíte zobrazenie všetkých úrovní miest. Ak nastavíte hodnotu 0, všetky miesta budou schované. Ak nastavíte hodnotu 1, bude zobrazená prvá úroveň, ak nastavíte 2, budú zobrazené prvé dve úrovne atd.";
$pgv_lang["MULTI_MEDIA"]		= "Zapnúť použitie multimédií";
$pgv_lang["MULTI_MEDIA_help"]		= "GEDCOM 5.5 vám umožňuje k vášmu GEDCOMu pripojiť odkazy na obrázky, videá a ďalšie multimediálne súbory. Ak vo svojom GEDCOMe nemáte multimediálne súbory, môžete túto vlastnosť vypnúť nastavením hodnoty na 'nie'. <br />Pre ďalšie informácie o pridávaní multimediálnych súborov do svojich stránok sa podívajte do súboru <a href=\"readme.txt\">readme.txt</a>.";
$pgv_lang["MEDIA_EXTERNAL"]		= "Uchovávať odkazy";
$pgv_lang["MEDIA_EXTERNAL_help"]	= "Ak bude nájdený multimediálny odkaz začínajúci napr. http://, ftp://, mms://, potom bude v tejto podobe uchovaný, ak zvolíte \"ano\". Napríklad: http://www.myfamily.com/photo/otec.jpg zostane http://www.myfamily.com/photo/otec.jpg. Ak bude nastavené \"nie\", z odkazom sa bude nakladať ako zo štandardným a bude použitá zložka médií. Napríklad http://www.myfamily.com/photo/otec.jpg sa zmení na ./media/otec.jpg";
$pgv_lang["MEDIA_DIRECTORY"]		= "Zložka Multimédií";
$pgv_lang["MEDIA_DIRECTORY_help"]	= "Cesta k multimediálnym súborom musí byť relatívna cesta v rámci PhpGedView, ako napr. ./media/ (včetne lomítka \"/\").";
$pgv_lang["MEDIA_DIRECTORY_LEVELS"]	= "Úroveň prehľadávania multimediálnych zložiek";
$pgv_lang["MEDIA_DIRECTORY_LEVELS_help"]= "Pri nastavení 0 budú ignorované všetky zložky nachádzajúce sa v ceste ku mediálnemu súboru. Ak bude hodnota rovná 1, bude použitá tiež prvá rodičovská zložka obsahujúca tento súbor. Zvyšovanie čísel povedie ku zvyšovaniu počtu rodičovských adresárov obsiahnutých v danej ceste. <br />Napríklad: Keď pripojíte ku svojmu GEDCOMu obrázok s cestou ako je C:\\Documents and Settings\\User\\My Documents\\My Pictures\\Genealogy\\Surname Line\\otec.jpg, potom s hodnotou 0 bude táto cesta prevedená do podoby ./media/otec.jpg. V prípade hodnoty rovnej 1 bude cesta ./media/Surname Line/otec.jpg, atd.  Väčšine ľudí bude stačiť používať nastavenie s 0. Ale je možné, že niekteré mediálne súbory budú mať rovnaké názvy, a potom by došlo k ich prepísaniu. Toto nastavenie vám umožňuje uchovať si vo svojich súboroch systém a zabrániť tak kolízii názvov.";
$pgv_lang["SHOW_HIGHLIGHT_IMAGES_help"]	= "Ak máte na svojich stránkach povolené multimediálne súbory, potom môžete mať v rodokmeni zobrazené náhľady obrázkov vedľa mena osoby v rámčeku. V súčasnej dobe používa PhpGedView prvý multimediálny súbor zo zoznamu k danému záznamu. U ľudí z viacerými obrázkami by ste mali zariadiť, aby ten, ktorý chcete zobraziť bol na prvom mieste.<br />Pre ďalšie informácie o vkladaní obrázkov na svoje stránky sa podívajte do časti Multimédia v súbore <a href=\"readme.txt\">readme.txt</a>.";
$pgv_lang["USE_THUMBS_MAIN"]		= "Pre hlavný obrázok na stránke o osobe použiť náhľad";
$pgv_lang["USE_THUMBS_MAIN_help"]	= "To záleží na tom, ako chcete skladovať svoje obrázky. Môže byť pre vás výhodnejšie zvoliť u mena na stránke osoby zobrazenie náhľadu. Ak sú vaše obrázky veľké, môže trvať dlhú dobu, než sa stiahnu. A ak sú vaše náhľady uložené vo vysokej kvalite, môžu sa použiť namiesto orginálnych obrázkov. Zvoľte \"ano\", ak chcete použiť náhľady, alebo ponechajte \"nie\", ak majú byť použité orginálne obrázky.";
$pgv_lang["SHOW_MEDIA_FILENAME"]		= "Zobraziť mená súborov v Media Viewer";
$pgv_lang["SHOW_MEDIA_FILENAME_help"]	= "~#pgv_lang[SHOW_MEDIA_FILENAME]#~<br /><br />Media Viewer môže zobraziť mená súborov Médií, keď sú zobrazené. Táto voľba určuje či uživatelia uvidia mená súborov alebo nie.<br /><br />Môžete ukryť mená súborov z dôvodu ochrany.<br /><br />";
$pgv_lang["SHOW_MEDIA_DOWNLOAD"]		= "Zobraziť linky v  Media Viewer";
$pgv_lang["SHOW_MEDIA_DOWNLOAD_help"]	= "~#pgv_lang[SHOW_MEDIA_DOWNLOAD]#~<br /><br />Media Viewer môže zobraziť linky, kliknutím na ne môžete načítať súbory médií na lokálne PC.<br /><br />Môžete ukryť linky z dôvodu ochrany.<br /><br />";
$pgv_lang["ENABLE_CLIPPINGS_CART"]	= "Zapnúť schránku výstrižkov";
$pgv_lang["ENABLE_CLIPPINGS_CART_help"]	= "Schránka výstrižkov umožní návštevníkom vašich stránok pridávať si ľudí z vašej databázy do súboru GEDCOM výstrižkov, ktorý si potom môžu stiahnúť a tieto údaje pridať do svojho rodokmeňa.";
$pgv_lang["HIDE_GEDCOM_ERRORS"]		= "Ukryť chyby GEDCOM";
$pgv_lang["HIDE_GEDCOM_ERRORS_help"]	= "Ak nastavíte hodnotu na 'ano', budú ukryté výpisy chýb zpôsobených aplikáciou PhpGedView, keď nepochopí zápis vo vašom GEDCOM súbore. PhpGedView vynakladá veľké úsilie k tomu, aby bolo kompatibilné zo štandardom GEDCOM 5.5, ale mnoho genealogických programov vkladá do súborov vlastné tagy. Pre ďalšie informácie pozrite do súboru <a href=\"readme.txt\">readme.txt</a>.";
$pgv_lang["WORD_WRAPPED_NOTES"]		= "Na miesta, kde boli poznámky, vložiť medzery";
$pgv_lang["WORD_WRAPPED_NOTES_help"]	= "Niektoré genealogické programy vkladajú poznámky na rozhranie slov, zatiaľ čo iné ich zapisujú kamkoľvek. To môže mať za následok, že PhpGedView spojí slová dohromady. Ak zvolíte 'ano', bude vložená medzera medzi všetky slová, tam kde sú v GEDCOM súbore ukončené.";
$pgv_lang["SHOW_CONTEXT_HELP"]		= "Zobraziť <b>?</b> odkazujúci na nápovedu";
$pgv_lang["SHOW_CONTEXT_HELP_help"]	= "Táto voľba zapne na stránkach zobrazenie otáznikov odkazujúcich na nápovedu hneď vedľa volieb, takže návštevníci budú môcť získať kontextovú nápovedu k voľbám (výberu možností) na stránkach.";
$pgv_lang["DAYS_TO_SHOW_LIMIT"]		= "Denný limit bloku Aktuálnych udalostí";
$pgv_lang["DAYS_TO_SHOW_LIMIT_help"] 	= "~#pgv_lang[DAYS_TO_SHOW_LIMIT]#~<br /><br />Vložte maximálny počet dní pre zobrazenie v bloku Aktuálnych udalostí. Toto číslo nesmie byť väčšie než 30. Ak zadáte väčšiu hodnotu bude použitá hodnotu 30.<br /><br />Hodnota ktorú sem vložíte určuje ako ďaleko dopredu PhpGedView hľadá aktuálne udalosti. Výsledky hľadania, vykonaného raz denne, sú zkopírované do dočasného súboru.<br /><br />Žiadne bloky Aktuálnych udalostí na Index alebo Portál stránkach nevyžadujú viac dní než je táto hodnota. Čím väčšiu hodnotu nastavíte, tým väčší bude denný výber z databázi a tým dlhšie budete čakať na zobrazenie ak požadujete zobraziť väčší počet dní než je toto nastavenie.<br />";
$pgv_lang["COMMON_NAMES_THRESHOLD"]	= "Minimálna četnosť výskytu priezviska potrebná k tomu, aby sa objavilo medzi najčastejšími priezviskami";
$pgv_lang["COMMON_NAMES_THRESHOLD_help"]= "Toto číslo udáva, koľkokrát sa musí nejaké priezvisko v GEDCOMe vyskytovať, aby bolo zobrazené na úvodnej stránke medzi najčastejšími priezviskami.";
$pgv_lang["COMMON_NAMES_ADD"]		= "Priezviská, ktoré sa majú pridať k najčastejšie sa vyskytujúcim (oddelujte čiarkou)";
$pgv_lang["COMMON_NAMES_ADD_help"]	= "Ak je četnosť výskytu priezviska nižšia než nastavený limit, neobjaví sa medzi priezviskami z najčastejším výskytom. Potom tu môžete také priezvisko pridať ručne. Ak zadáte viacej než jedno, musia byť oddelené čiarkou. V priezviskách sa rozlišujú malé a veľké písmená.";
$pgv_lang["COMMON_NAMES_REMOVE"]	= "Priezviská, ktoré sa majú odstrániť z najčastejšie sa vyskytujúcích (oddeľujte čiarkou)";
$pgv_lang["COMMON_NAMES_REMOVE_help"]	= "Ak chcete nejaké priezvisko odstrániť zo zoznamu najčastejších priezvísk, a nechcete meniť limit, môžete tak urobiť tu. Ak zadáte viacej než jedno, musia byť oddelené čiarkou. V priezviskách sa rozlišujú malé a veľké písmená. Priezviská budú taktiež odstránené zo zoznamu Top-10 na uvítacej stránke.";
$pgv_lang["HOME_SITE_URL"]		= "URL hlavnej stránky";
$pgv_lang["HOME_SITE_URL_help"]		= "URL vkladané do zasielaných hlavičiek k tomu, aby vygenerovalo odkaz na vašu hlavnú stránku.";
$pgv_lang["HOME_SITE_TEXT"]		= "Text k hlavnej stránke";
$pgv_lang["HOME_SITE_TEXT_help"]	= "Text použitý pri vygenerovaní odkazu na vašu hlavnú stránku.";
$pgv_lang["CONTACT_EMAIL"]		= "Kontaktný uživateľ pre tento rodokmeň";
$pgv_lang["CONTACT_EMAIL_help"]		= "Uživateľ, ktorého môžu návštevníci kontaktovať v súvislosti s rodokmeňom.";
$pgv_lang["CONTACT_METHOD"]		= "Spôsob kontaktu";
$pgv_lang["CONTACT_METHOD_help"]	= "Spôsob, akým sa budú návštevníci obracať na \"Kontaktného uživateľa\" zo svojimi otázkami k rodokmeňu. Možnosť <b>#pgv_lang[mailto]#</b> znamená použitie e-mailového odkazu, na ktorý môžu návštevníci kliknúť a poslať e-mail cez svojho e-mailového klienta. Voľba <b>#pgv_lang[messaging]#</b> zaistí použitie systému zasielania správ vstavaného v PhpGedView bez použitia e-mailu. Voľba <b>#pgv_lang[messaging2]#</b> je implicitná; ak je nastavená, použije sa vnútorný systém PhpGedView, avšak kópia správy sa odošle tiež e-mailom. Voľba <b>#pgv_lang[messaging3]#</b> umožní PhpGedView spracovávať správy a odosielať ich e-mailom, ale neumožní ukladanie správ do databázy. Ak zvolíte možnosť <b>#pgv_lang[no_messaging]#</b>, nebudú vás môcť návštevníci vašich stránok kontaktovat.";
$pgv_lang["PHPGEDVIEW_EMAIL"]		= "PhpGedView adresa pre odpoveď";
$pgv_lang["PHPGEDVIEW_EMAIL_help"]	= "~#pgv_lang[PHPGEDVIEW_EMAIL]#~<br /><br />E-mail adresa bude použitá v poli &laquo;Od:&raquo; v e-mailoch ktoré PhpGedView odosiela automaticky.<br /><br />PhpGedView môže automaticky vytvoriť e-maily na upozornenie administrátorov o zmenách, ktoré čakajú na kontrolu. PhpGedView taktiež posiela upozornenie uživateľom, ktorý žiadajú o založenie účtu.<br /><br />Obvykle pole &laquo;Od:&raquo; automaticky vytvorených e-mailov obsahuje niečo takéto <i>Od: phpgedview-noreply@yoursite</i> pre upozornenie, že nie je potrebná odpoveď. Z dôvodu ochrany proti SPAMu prípadne inému zneužitiu, niektoré e-mail systémy požadujú vyplnenie poľa &laquo;Od:&raquo; platnou adresou a nebudú akceptovať mail odoslaný z adresy <i>phpgedview-noreply</i>.<br />";
$pgv_lang["WEBMASTER_EMAIL"]		= "Kontaktný uživateľ pre technickú podporu";
$pgv_lang["WEBMASTER_EMAIL_help"]	= "Uživateľ, ktorého by návštevníci mali kontaktovať v prípade, že narazia na vašich stránkach na problémy technického rázu.";
$pgv_lang["SUPPORT_METHOD"]		= "Spôsob technickej podpory";
$pgv_lang["SUPPORT_METHOD_help"]	= "Spôsob, akým budú návštevníci kontaktovať \"Uživateľa pre technickú podporu\". Možnosť <b>#pgv_lang[mailto]#</b> znamená použitie e-mailového odkazu, na ktorý môžu návštevníci kliknúť a poslať e-mail cez svojho e-mailového klienta. Voľba <b>#pgv_lang[messaging]#</b> zaistí použitie systému zasielania správ vstavaného v PhpGedView bez použitia e-mailu. Voľba <b>#pgv_lang[messaging2]#</b> je implicitná; ak je nastavená, použije sa vnútorný systém PhpGedView, ale kópia správy sa odošle tiež e-mailom. Voľba <b>#pgv_lang[messaging3]#</b> umožní PhpGedView spracovávať správy a odosielať ich e-mailom, ale neumožní ukladanie správ do databázy. Ak zvolíte možnosť <b>#pgv_lang[no_messaging]#</b>, nebudú vás môcť návštevníci vašich stránok kontaktovať.";
$pgv_lang["SHOW_FACT_ICONS"] 		= "Zobraziť ikonu Údaj";
$pgv_lang["SHOW_FACT_ICONS_help"]	= "~#pgv_lang[SHOW_FACT_ICONS]#~<br /><br />Nastavte na <b>#pgv_lang[yes]#</b> pre zobrazenie ikon vedľa mena údaja na stránke #pgv_lang[personal_facts]#. Ikony údajov budú zobrazené iba vtedy, ak existujú v adresári <i>images/facts</i> pre aktuálny motív.<br />";
$pgv_lang["FAVICON"]			= "Ikona Obľúbených";
$pgv_lang["FAVICON_help"]		= "Zmeňte toto nastavenie, ak chcete vybrať inú ikonu, ktorá sa má návštevníkom vašich stránok zobraziť v menu obľúbených odkazov, keď si vaše stránky zaradia medzi Obľúbené.";
$pgv_lang["THEME_DIR"]			= "Zložka motívov:";
$pgv_lang["THEME_DIR_help"]		= "Zložka, v ktorej sa majú uchovávať súbory motívov pre PhpGedView. Ktorýkoľvek zo štandardných motívov PhpGedView si môžete upraviť tak, aby ste svojim stránkam dodali orginálny vzhľad. Pre ďalšie informácie sa podívajte do časti \"Theme Customization\" v súbore <a href=\"readme.txt\">readme.txt</a>.";
$pgv_lang["TIME_LIMIT"]			= "Časový limit PHP";
$pgv_lang["TIME_LIMIT_help"]		= "Maximálny čas, udaný v sekundách, po ktorý môže PhpGedView bežať.  Implicitná je 1 minúta. V závislosti na veľkosti vášho GEDCOM súboru možno budete potrebovať zvýšiť tento limit kvôli vytvoreniu indexov. Ak nastavíte túto hodnotu na 0, bude môcť PHP bežať neobmedzene.<br />VAROVANIE: Nastavenie na 0 alebo na veľmi vysoké číslo môže na niektorých operačných systémoch spôsobiť zatuhnutie vašich stránok do doby, než skončí vykonávanie skriptu. Nastavenie na 0 znamená, že nemusí skončiť nikdy, takže bude nutné na servere ukončit proces (zhodiť) alebo server reštartovať. Veľmi rozsiahle schémy rodokmeňa sa môžu načítať veľmi dlho; ak necháte túto hodnotu čo najnižšiu, ako je to len možné, vyhnete sa nebezpečiu, že server, na ktorom sú umiestnené vaše stránky, niekto preťaží napr. požiadavkom na 1000 – generačnú schému.";
$pgv_lang["PGV_SESSION_SAVE_PATH_help"]	= "Cesta, kam sa majú ukladať súbory session aplikácie PhpGedView. Niektorý hostitelia nemajú správne nakonfigurované PHP, takže sa sessions nepredávajú medzi stránkami. Toto nastavenie umožní administrátorom stránok tento nedostatok napraviť tým, že sa tieto súbory uložia do niektorej lokálnej zložky. Ak potrebujete tento spôsob použiť, potom je vhodné súbory ukladať napr. do zložky ./index/. Implicitne je toto políčko ponechané prázdne, tzn. že sa prejaví nastavenie uložené v súbore php.ini.";
$pgv_lang["SERVER_URL_help"]		= "Ak používate https alebo iný port než je implicitný, budete sem musieť vložiť URL pre prístup na váš server.";
$pgv_lang["LOGIN_URL"]			= "Prihlasovacia URL";
$pgv_lang["LOGIN_URL_help"]		= "Prihlasovacie URL nemusíte zadávať, ak nechcete, aby boli uživatelia pri prihlasovaní presmerovaný na inú adresu. Táto možnosť je však veľmi užitočná ak chcete v priebehu prihlasovania prepnúť z http na https.  Musí obsahovať celú adresu súboru login.php (napr. https://www.vasserver.cz/phpgedview/login.php).";
$pgv_lang["PGV_SESSION_TIME_help"]	= "Čas, udaný v sekundách, po ktorý zostávajú sessions PhpGedView aktívne pred vyžiadaním prihlásenia. Implicitný je 30 minút.";
$pgv_lang["SHOW_STATS"]			= "Ukázať štatistiku prevedenia";
$pgv_lang["SHOW_STATS_help"]		= "Zobraziť na päte každej stránky štatistiku prevedenia a dotazy na databázu.";
$pgv_lang["SHOW_COUNTER"]		= "Zobraziť počitadlo prístupov";
$pgv_lang["SHOW_COUNTER_help"]		= "Zobrazuje počitadlo prístupov (návštevníkov) na vstupnej bráne na jednotlivých stránkach.";
$pgv_lang["USE_REGISTRATION_MODULE_help"]	= "Umožní uživateľom vytvoriť si na vašich stránkach svoj účet.<br /><br />Návštevník obdrží e-mailom správu s kódom pre potvrdenie operácie.<br />Po overení bude musieť administrátor registráciu potvrdiť, aby bol účet aktivovaný.";
$pgv_lang["ALLOW_USER_THEMES_help"]	= "Umožniť uživateľom vybrať si vlastný motív.";
$pgv_lang["PGV_SIMPLE_MAIL_help"] 	= "V normálnych e-mailových hlavičkách v externých e-mailoch je použitá ako e-mailová adresa, tak i meno. Niektoré e-mailové systémy túto formu neprijímajú. Ak zvolíte ano, použije sa iba e-mailová adresa.";
$pgv_lang["gedcom_title"]		= "#pgv_lang[ged_title]#";
$pgv_lang["gedcom_title_help"]		= "Vložte nadpis popisujúci obsah tohoto GEDCOMu, ktorý sa zobrazí návštevníkom pri výbere GEDCOMu k prezeraniu.";
$pgv_lang["LOGFILE_CREATE"]		= "Archivovať Log súbory";
$pgv_lang["LOGFILE_CREATE_help"]	= "Ako dlouho by mal program archivovať log súbory.";
$pgv_lang["PGV_MEMORY_LIMIT_help"]	= "Maximálna veľkosť pamäte, ktorú môžu zaplniť skripty PhpGedView.  Implicitná hodnota je 32MB. Mnoho hostingov túto voľbu vypíná vo svojom nastavení PHP, takže zmena tejto hodnoty nemusí v skutočnosti ovplyvniť nastavenie veľkosti pamäte.";
$pgv_lang["PGV_STORE_MESSAGES_help"]	= "Určuje, či môžu byť správy poslané cez PhpGedView ukladané do databázy. Ak je nastavené 'Ano', potom budú môcť uživatelia dostávať správy, keď sa prihlásia do PhpGedView. Ak je nastavené 'Nie', potom sa budú správy odosielať iba e-mailom.";
$pgv_lang["ALLOW_THEME_DROPDOWN"]	= "Zobraziť rolovacie menu pre zmenu motívu";
$pgv_lang["ALLOW_THEME_DROPDOWN_help"]	= "Umožňuje uživateľovi zvoliť si vlastný motív z rolovacieho menu (ak je zabudované v aktuálnom motíve. Premenná <b>#pgv_lang[ALLOW_USER_THEMES]#</b> musí byť tiež nastavená na \"Ano\".";
$pgv_lang["MAX_VIEW_RATE"]		= "Maximálny počet zobrazení stránky";
$pgv_lang["MAX_VIEW_RATE_help"]		= "~#pgv_lang[MAX_VIEW_RATE]#~<br /><br />Táto voľba obmedzuje počet zobrazení stránky jedným uživateľom.<br /><br />Ak je tento počet prekročený, PhpGedView považuje tento režim za pokus o hacking (útok na stránky); režim bude zrušený zo zodpovedajúcou hláškou. Tieto dve hodnoty by mali vymedzit rozumný limit na množstvo  stiahnutých bajtov zo serveru. Táto vlastnosť môže byť vypnutá nastavením časového intervalu na 0.";
$pgv_lang["META_AUTHOR"]		= "META tag o autorovi";
$pgv_lang["META_AUTHOR_help"]		= "Hodnota, ktorá má byť v hlavičke HTML stránky zapísaná do meta tagu o autorovi. Ponechajte prázdne, ak chcete použiť celé meno kontaktného uživateľa.";
$pgv_lang["META_AUTHOR_descr"]		= "Ponechajte toto políčko prázdné, ak chcete, aby bolo použité celé meno kontaktného uživateľa.";
$pgv_lang["META_PUBLISHER"]		= "META tag o vydavateľovi";
$pgv_lang["META_PUBLISHER_help"]	= "Hodnota, ktorá sa má zapísať do meta tagu o vydavateľovi v hlavičke HTML stránky. Ponechajte toto políčko prázdne, ak chcete, aby bolo použité celé meno kontaktného uživateľa.";
$pgv_lang["META_PUBLISHER_descr"]	= "Ponechajte toto políčko prázdne, ak chcete, aby bolo použité celé meno kontaktného uživateľa.";
$pgv_lang["META_COPYRIGHT"]		= "META tag o copyrightu";
$pgv_lang["META_COPYRIGHT_help"]	= "Hodnota, ktorá sa má zapísať do meta tagu o copyrightu v hlavičke HTML stránky. Ponechajte toto políčko prázdné, ak chcete, aby bolo použité celé meno kontaktného uživateľa.";
$pgv_lang["META_COPYRIGHT_descr"]	= "Ponechajte toto políčko prázdne, ak chcete, aby bolo použité celé meno kontaktného uživateľa.";
$pgv_lang["META_DESCRIPTION"]		= "META tag s popisom";
$pgv_lang["META_DESCRIPTION_help"]	= "Hodnota, ktorá sa má v hlavičke HTML stránky zapísať do meta tagu s popisom. Ponechajte políčko prázdne, ak chcete, aby bol použitý súčasný nadpis tohoto GEDCOMu.";
$pgv_lang["META_DESCRIPTION_descr"]	= "Ponechajte toto políčko prázdne, ak chcete, aby bol použitý súčasný nadpis tohoto GEDCOMu.";
$pgv_lang["META_PAGE_TOPIC"]		= "META tag o téme stránky";
$pgv_lang["META_PAGE_TOPIC_help"]	= "Hodnota, ktorá sa má v hlavičke HTML stránky zapísať do meta tagu popisujúceho tématické zameranie stránky. Ponechajte políčko prázdne, ak chcete, aby bol použitý súčasný popis tohoto GEDCOMu.";
$pgv_lang["META_PAGE_TOPIC_descr"]	= "Ponechajte toto políčko prázdne, ak chcete, aby bol použitý súčasný nadpis tohoto GEDCOMu.";
$pgv_lang["META_AUDIENCE"]		= "META tag Audiencia";
$pgv_lang["META_AUDIENCE_help"]		= "Hodnota, ktorá sa má v hlavičke HTML stránky zapísať do meta tagu popisujúceho skupinu ľudí, pre ktorých sú stránky určené.";
$pgv_lang["META_PAGE_TYPE"]		= "META tag typu stránky";
$pgv_lang["META_PAGE_TYPE_help"]	= "Hodnota, ktorá sa má v hlavičke HTML stránky zapísať do meta tagu popisujúceho typ stránky.";
$pgv_lang["META_ROBOTS"]		= "META tag robotov";
$pgv_lang["META_ROBOTS_help"]		= "Hodnota, ktorá sa má v hlavičke HTML stránky zapísať do meta tagu pre robotov. Mnoho robotov toto nastavenie ignoruje.";
$pgv_lang["META_REVISIT"]		= "Jak často by mal webový pavúk kontrolovať META tag";
$pgv_lang["META_REVISIT_help"]		= "Hodnota, ktorá sa má zapísať do hlavičky HTML stránky do meta tagu revízia. Mnoho webových pavúkov túto hodnotu ignoruje.";
$pgv_lang["META_KEYWORDS"]		= "META tag kľúčových slov";
$pgv_lang["META_KEYWORDS_help"]		= "Hodnota, ktorá má byť zapísaná v hlavičke HTML stránky do meta tagu kľúčových slov. Mnoho vyhľadávačov používa kľúčové slová pre presnejšie zaradenie vašej stránky. Zoznam najčastejších priezvísk, ktorý sa objavuje v bloku štatistiky GEDCOMu na úvodnej stránke, bude automaticky pridaný ku slovám, ktoré sem vpíšete.";
$pgv_lang["META_SURNAME_KEYWORDS"]	= "Pridať najčastejšie sa vyskytujúce priezviská do poľa META tagu kľúčových slov";
$pgv_lang["META_SURNAME_KEYWORDS_help"]	= "Ak nastavíte túto voľbu na \"Ano\" tak priezviská zo zoznamu #pgv_lang[common_surnames]# budú pridané do poľa META tagu kľúčové slová.";
$pgv_lang["META_TITLE"]			= "Pridať do hlavičkového tagu TITLE (nadpis)";
$pgv_lang["META_TITLE_help"]		= "Čokoľvek napíšete do tohoto riadku, bude pridané do nadpisu HTML stránky medzi riadny nadpis a slovo PhpGedView.";
$pgv_lang["ENABLE_RSS"]			= "Povoliť RSS";
$pgv_lang["ENABLE_RSS_help"]		= "~#pgv_lang[ENABLE_RSS]#~<br /><br />Táto voľba vám umožňuje povoliť RSS správy.<br /><br />RSS umožní uživateľom monitorovať zmeny vašich stránok bez nutnosti pravidelne sa prihlasovať. Ak príliš veľa uživatelov využije túto možnosť  alebo frekvencia obnovenia pre týchto uživateľov je príliš vysoká, RSS môže zabrať príliš veľkú kapacitu servera.<br />";
$pgv_lang["RSS_FORMAT"]			= "RSS formát";
$pgv_lang["RSS_FORMAT_help"]		= "~#pgv_lang[RSS_FORMAT]#~<br /><br />Formát RSS bude použitý ako default formát noviniek RSS pre túto stránku. 4íselná prípona <u>neindikuje</u> verziu, ale formáty. Napríklad, RSS 2.0 nie je novšia než RSS 1.0, ale iný formát. Prehliadače noviniek sú schopné čítať ktorýkoľvek formát. Nie je rozdiel medzi ATOM a ATOM 0.3. Oba používajú ATOM 0.3 draft špecifikáciu.<br />";
$pgv_lang["SECURITY_CHECK_GEDCOM_DOWNLOADABLE"] = "Kontrolovať stiahnuteľné GEDCOM súbory";
$pgv_lang["SECURITY_CHECK_GEDCOM_DOWNLOADABLE_help"] = "~#pgv_lang[SECURITY_CHECK_GEDCOM_DOWNLOADABLE]#~<br /><br />Z bezpečnostných dôvodov by GEDCOM súbor  nemal byť uložený na mieste odkial môže byť priamo stiahnutý a tak obísť kontrolu utajenia. Táto voľba môže spôsobiť problémy z výkonom niektorých serverov.<br /><br />Ak ste si istý že  GEDCOM súbor je uložený v adresári do ktorého nie je priamy prístup z Internetu, tak môžete bezpečne vypnúť túto možnosť.<br />";
$pgv_lang["gedcom_download_secure"]	= "#GEDCOM# nemôže byť načítaný.";
$pgv_lang["welcome_new2"]			= "<br /><br />Pretože vidíte túto stránku, máte správne nainštalovaný PhpGedView na vašom servere a môžete začať konfiguráciu podľa vašich potrieb.<br /><br />";
$pgv_lang["welcome_new_help"]			= "Toto okno s nápovedou vás povedie nastavením systému. Budete meniť nastavenie rôznych políčok a toto okno vám poradí, čo môžete zvoliť práve u danej položky. Toto okno môžete zatvoriť a ak ho budete chcieť opäť otvoriť, stačí kliknúť na otáznik \"?\" vedľa popisu upravovaného políčka.";
$pgv_lang["return_editconfig"]			= "Ku konfigurovaniu sa môžete kedykoľvek vrátiť, keď otvoríte v prehliadači súbor <i>edit_config.php</i> alebo kliknete na odkaz <b>Konfigurácia</b> na stránke <b>#pgv_lang[gedcom_adm_head]#</b><br />";
$pgv_lang["return_editconfig_gedcom"]		= "Ku konfigurovaní sa môžete kedykoľvek vrátiť kliknutím na odkaz: <b>Upraviť</b> v tabuľke <b>#pgv_lang[current_gedcoms]#</b> alebo na stránke <b>#pgv_lang[gedcom_adm_head]#</b> alebo otvorením súboru </i>editconfig_gedcom.php</i> vo svojom prehliadači.<br />";
$pgv_lang["save_config"] 			= "Uložiť konfiguráciu";
$pgv_lang["download_gedconf"]			= "Stiahnúť konfiguráciu GEDCOM.";
$pgv_lang["not_writable"]			= "Zistili sme, že PHP do vášho konfiguračného súboru nemôže zapisovať. Môžete použiť tlačítko <b>#pgv_lang[download_file]#</b> pre uloženie svojho nastavenia do súboru, ktorý budete môcť ručne nahrať (uploadovať).";
$pgv_lang["upload_to_index"]			= "Nahrať súbor do zložky index: ";
$pgv_lang["import_sql"]				= "Vo vašom index adresári boli nájdené SQL súbory. Od okamžiku keď ste použili User Migration tool, máte možnost importovať informácie do vašej databázi. Želáte si pokúsiť sa teraz o import týchto súborov do vašej databázi? Všetky uživateľsky závislé informácie (uživatelia, novinky, obľúbené, bloky, rozvrhnutia, a správy) vo vašej databáze budú stratené.<br /><br />Ak zvolíte \"Pokračovať\", PhpGedView sa pokusí  importovať údaje. Ak import nebude úspešný, budete vyzvaný k založeniu účtu administrátora.<br /><br />";

//-- edit privacy messages
$pgv_lang["edit_privacy"]			= "Upraviť utajenie";
$pgv_lang["edit_privacy_title"]			= "Upraviť nastavenie utajenia v GEDCOMe";
$pgv_lang["save_changed_settings"]		= "Uložiť zmeny";
$pgv_lang["add_new_pp_setting"]			= "Pridať nové nastavenie osobného utajenia";
$pgv_lang["add_new_up_setting"]			= "Pridať nové nastavenie uživateľského utajenia";
$pgv_lang["add_new_gf_setting"]			= "Pridať nové nastavenie utajenia globálnych údajov";
$pgv_lang["add_new_pf_setting"]			= "Pridať nové nastavenie utajenia osobných údajov";
$pgv_lang["file_read_error"]			= "C H Y B A !!! Nejde načítať súbor s nastavením utajenia!";
$pgv_lang["edit_exist_person_privacy_settings"]	= "Upraviť existujúce nastavenie osobného utajenia";
$pgv_lang["edit_exist_user_privacy_settings"]	= "Upraviť existujúce nastavenie uživateľského utajenia";
$pgv_lang["edit_exist_global_facts_settings"]	= "Upraviť existujúce nastavenie utajenia globálnych údajov";
$pgv_lang["edit_exist_person_facts_settings"]	= "Upraviť existujúce nastavenie utajenia osobných údajov";
$pgv_lang["general_privacy"]			= "Všeobecné nastavenie utajenia";
$pgv_lang["general_privacy_help"]		= "<b>#pgv_lang[general_settings]#.</b><br />Toto nastavenie bude vaším implicitným nastavením pre konkrétny GEDCOM.<br />Podívajte sa pod titulok stránky, aby ste si overili, že upravujete správný GEDCOM.<br /><br />To zároveň znamená, že pre každý GEDCOM (ak máte viacej než jeden) vo vašam PhpGedView môžete mať samostané nastavenie.<br /><br />Toto všeobecné nastavenie môžete \"prebiť\" použitím ďalších formulárov utajenia na stránke #pgv_lang[edit_privacy_title]#.<br />#pgv_lang[more_config_help]#";
$pgv_lang["person_privacy"]			= "Nastavenie utajenia osôb";
$pgv_lang["accessible_by"]			= "Komu ukázať?";
$pgv_lang["hide"]				= "Skryť";
$pgv_lang["show_question"]			= "Ukázať?";
$pgv_lang["user_name"]				= "Uživateľské meno";
$pgv_lang["name_of_fact"]			= "Názov údaja";
$pgv_lang["choice"]				= "Voľba";
$pgv_lang["fact_show"]				= "Zobraziť údaj";
$pgv_lang["fact_details"]			= "Zobraziť podrobnosti o údaji";
$pgv_lang["privacy_header"]			= "Upraviť nastavenie utajenia vovnútri";
$pgv_lang["unable_to_find_privacy_indi"]	= "Nie je možné nájsť osobu s ID";
$pgv_lang["save_and_import"]			= "Po uložení konfigurácie tohoto GEDCOMu, bude potrebné importovať GEDCOM súbor kliknutím na tlačítko <b>Importovať GEDCOM</b> alebo výberom z menu <b>Admin->Správa GEDCOM súborov->Importovať</b>";
$pgv_lang["SHOW_LIVING_NAMES"]			= "Ukázať mená žijúcich osôb";
$pgv_lang["USE_RELATIONSHIP_PRIVACY"]		= "Použiť príbuzenské utajenie";
$pgv_lang["MAX_RELATION_PATH_LENGTH"]		= "Max. príbuzenská vzdialenosť";
$pgv_lang["CHECK_MARRIAGE_RELATIONS"]		= "Kontrolovať príbuznosť sňatkom";
$pgv_lang["SHOW_DEAD_PEOPLE"]			= "Zobraziť mená zomrelých osôb";
$pgv_lang["help_info"]				= "Kliknutím na červený &quot;?&quot; u popisky každej bunky získate nápovedu.";
$pgv_lang["SHOW_LIVING_NAMES_help"]		= "Zobraziť mená žijúcich osôb<br /><br />Mená žijúcich osôb by mali byť zobrazované verejne.";
$pgv_lang["SHOW_RESEARCH_ASSISTANT"]		= "Zobraziť bádateľského asistenta";
$pgv_lang["SHOW_RESEARCH_ASSISTANT_help"]	= "~#pgv_lang[SHOW_RESEARCH_ASSISTANT]#~<br /><br />Ktorý typ uživateľa môže vidieť modul Bádateľský asistent, ak je tento nainštalovaný?";
$pgv_lang["USE_RELATIONSHIP_PRIVACY_help"]	= "Použíť príbuzenské utajenie.<br /><br />Hodnota 'Nie' znamená, že autorizovaný uživatelia uvidia údaje všetkých žijúcich osôb.<br />Hodnota 'Ano' znamená, že uživatelia si budú môcť prezerať súkromné údaje iba u svojich príbuzných.";
$pgv_lang["MAX_RELATION_PATH_LENGTH_help"]	= "Max. príbuzenská vzdialenosť<br /><br />Ak je voľba #pgv_lang[USE_RELATIONSHIP_PRIVACY] zapnutá, prihlásený uživatelia si budú môcť prezerať a upravovať údaje u osôb maximálne do tejto príbuzenskej vzdialenosti.";
$pgv_lang["CHECK_MARRIAGE_RELATIONS_help"]	= "Skontrolovať sňatkové vzťahy<br /><br />Skontrolovať príbuznosť sňatkom.";
$pgv_lang["SHOW_DEAD_PEOPLE_help"]		= "Zobraziť mená zomrelých osôb<br /><br />Nastaviť úroveň utajenia všetkým zomrelým ľuďom";
$pgv_lang["person_privacy_help"]		= "<b>#pgv_lang[person_privacy_settings]#.</b><br />Toto nastavenie umožňuje administrátorom prepísať implicitné nastavenie konkrétnej osoby v GEDCOMe. Predpokladajme napríklad, že ste mali dieťa, ktoré zomrelo v útlom veku. Normálne, pretože je to dieťa mŕtve, by boli údaje o ňom prístupné všetkým uživateľom. Ale informácie o vás a všetkých ostatných z vašej rodiny sú ešte súkromné. Nechcete odstrániť záznam o úmrtí dieťaťa; chcete tieto údaje zaradiť medzi súkromné. Ak ID tohoto dieťaťa bolo I100, mali by ste zadať nasledujúce nastavenie utajenia: <br /><br />ID: I100<br />Komu ukázať: \"Ukázať iba autorizovaným uživateľom\"<br /><br />Obdobný postup môžeme použiť v inom prípade. Ak by sme chceli zverejniť údaje o niekom (ID 101), o kom by sme vedeli, že už nežije, ale nemali by sme dátum jeho úmrtia, mohli by sme to urobiť nasledovne:<br /><br />ID: I101<br />Komu ukázať: \"Ukázať verejne\".";
$pgv_lang["user_privacy"]			= "Nastavenie utajenia pre uživateľa";
$pgv_lang["user_privacy_help"]			= "<b>#pgv_lang[user_privacy_settings]#.</b><br />Toto nastavenie umožní administrátorom prepisovať implicitné nastavenie utajenia osôb podľa prihlasovacieho mena návštevníka.<br /><br />Takže, ak by sme nechceli, aby si mohol uživateľ s uživateľským menom \"John\" prezerať moje osobné údaje, a moje ID v GEDCOMe by bolo 100, moholi by sme to nakonfigurovať týmto spôsobom:<br /><br />Uživateľské meno: John<br />ID: I100<br />Ukázať?: \"Skryť\"<br /><br />a moje osobné údaje by boli skryté iba uživateľovi s uživ. menom \"John\".<br /><br />Pre zobrazovanie podrobností o osobe I101 (tie sú obvykle skryté, ak predpokladáme, že I101 je ešte živý) uživateľovi \"John\" nastavte:<br /><br />Uživateľské meno: John<br />ID: I101<br />Ukázať?: \"Ukázať\".";
$pgv_lang["global_facts"]			= "Globálne nastavenie utajenia údajov";
$pgv_lang["global_facts_help"]			= "<b>#pgv_lang[global_facts_settings]#.</b><br />Nastavenie \"global_facts\" definuje globálne údaje, ktoré by mali byť skryté pre všetky osoby v GEDCOMe.<br /><br />Prvok [\"Názov údaja\"] určuje, ktorý údaj by mal byť skrytý. Prvok [\"Voľba\"] vyberie údaj samotný alebo súvisiacu informáciu. Prvok [\"Komu ukázať\"] určuje, na akej úrovni prístupu sa má údaj zobraziť.<br /><br />Pole \$global_facts má zaistiť skrytie istých údajov podľa GEDCOM tagu u osôb živých i zomrelých. Implicitne je verejnosti skrytý tag SSN. Je to z toho dôvodu, aby nedochádzalo ku krádežiam \"social security numbers\" a totožnosti vašich zomrelých príbuzných, čo se týká asi predovšetkým USA. <br />Ak by sme chceli skryť všetky manželstvá vo svojom GEDCOMe, mohli by sme nastaviť:<br /><br />Názov údaja: (MARR) - Manželstvo<br />Voľba: \"Skryť údaj\"<br />Komu ukázať?: \"Zobraziť iba autorizovaným uživateľom\"<br /><br />Názov údaja: (MARR) - Manželstvo<br />Voľba: \"Zobraziť podrobnosti\"<br />Komu ukázať?: \"Zobraziť iba autorizovaným uživateľom\"<br /><br />Toto nastavenie zaistí skrytie údajov o sňatkoch a súvisiace informácie všetkým okrem administrátorov.<br /><br />Na rozdiel od všetkých ostatných nastavení, môžete v \"global_facts\" skryť údaje i adminom. To kvôli naprostému utajeniu údajov, ktoré chceme uchovať v tajnosti.";
$pgv_lang["person_facts"]			= "Nastavenie utajenia pre osobu";
$pgv_lang["person_facts_help"]			= "<b>#pgv_lang[person_facts_settings]#.</b><br />Toto nastavenie definuje údaje, ktoré sa majú pre určitú osobu v GEDCOMe skryť a úroveň, na ktorej majú byť skryté.<br /><br />Prvým prvkom je ID osoby, druhým  údaj.<br />Prvok [\"Voľba\"] vyberie údaj samotný alebo súvisiace informácie. Prvok [\"Komu ukázať\"] určuje, na akej úrovni bude údaj zobrazený.<br /><br />Pole \$person_facts funguje rovnako ako pole \$global_facts s tým rozdielom, že naviac zadávate ID osoby, pre ktorú chcete údaje skryť. Tak by sme mohli napríklad skryť záznam o sňatku pre určitú osobu.";
$pgv_lang["select_privacyfile_button"]		= "Vybrať súbor utajenia";
$pgv_lang["PRIVACY_BY_YEAR"]			= "Nastaviť utajenie podľa veku udalosti";
$pgv_lang["PRIVACY_BY_YEAR_help"]		= "Nastavenie utajenia podľa veku spôsobí, že budú skryté údaje o osobách podľa toho, pred akou dobou k nim došlo, nezávisle na tom, či je daná osoba doteraz nažive, alebo nie. Táto vlastnosť súvisí s nastavením \"Vek, od ktorého je možné osobu považovať za mŕtvu\". Napríklad, keď nastavíte zmienenú položku veku na 100 a túto voľbu nastavíte na \"Ano\", potom informácie o všetkých osobách narodených pred menej než 100 rokmi (živých i mŕtvych) budú označené za súkromné. Vezmite prosím na vedomie, že táto voľba spomalí načítanie stránok.";
$pgv_lang["lang_edit_help"]			= "~#pgv_lang[translator_tools]#~<br /><br />Táto stránka je určená pre prekľadateľov programu. Vy môžete prekladať, porovnávať a exportovať súbory jazykov. Tu je tiež nastavenie pomáhajúce prekľadateľom určiť orginálny text ktorý je zobrazený PhpGedView.<br /><br />Môžete použiť nasledujúce možnosti a pomôcky:<br />";

//-- pomôcka pre úpravu jazyka
$pgv_lang["edit_langdiff"]		= "Upraviť a nastaviť jazyk";
$pgv_lang["bom_check"]			= "Kontrola jazykového súboru na BOM";
$pgv_lang["bom_check_help"]		= "Tento nástroj skontroluje všetky jazykové súbory, či neobsahujú BOM (signatúru UTF-8 - tj. Byte Order Mark). Ak áno, bude z týchto súborov odstránené.";
$pgv_lang["bom_check_desc"]		= "Táto kontrola zanalyzuje všetky jazykové súbory na existenciu  BOM (Byte Order Mark). Ak bude nájdená, tak ju odstráni zz súborov. Tento špeciálny kód spôsobuje nefunkčnosť niektorých častí PhpGedView.";
$pgv_lang["lang_debug"]			= "Voľba Help Text Debug";
$pgv_lang["lang_debug_help"]		= "~#pgv_lang[lang_debug]#~<br /><br />#pgv_lang[lang_debug_desc]#<br />";
$pgv_lang["lang_debug_desc"]		= "Ak zaktivujete túto voľbu, názvy jazykových premenných použitých v texte, budú zobrazené v okne nápovedy. To pomôže prekladateľom určiť názov premennej v prípade, že text musí byť upravený.<br /><br />Toto nastavenie je platné iba pre vaše aktuálne PhpGedView okno.";
$pgv_lang["lang_debug_use"]		= "Použiť Help Text Debug.";
$pgv_lang["bom_not_found"]		= "Žiadne BOM nebolo nájdené.";
$pgv_lang["bom_found"]			= "BOM bolo nájdené v ";
$pgv_lang["edit_lang_utility"]		= "Nástroj pre úpravu jazykových súborov";
$pgv_lang["edit_lang_utility_help"]	= "Túto pomôcku môžete použiť k úprave obsahu jazykových súborov použitím obsahu súboru anglického. Vypíše sa vám obsah pôvodného anglického súboru a súboru vami vybraného jazyka. Po kliknutí na správu vami zvoleného jazyka sa otvorí nové okno, v ktorom môžete správu zmeniť a uložiť.";
$pgv_lang["edit_lang_utility_desc"]	= "Túto pomôcku môžete použiť k úprave obsahu jazykových súborov použitím obsahu súboru anglického. Vypíše sa vám obsah pôvodného anglického súboru a súboru vami vybraného jazyka. Po kliknutí na správu vami zvoleného jazyka sa otvorí nové okno, v ktorom môžete správu zmeniť a uložiť.";
$pgv_lang["edit_lang_utility_warning"]	= "POZOR!<br /><br />Ak by ste se rozhodli použiť tlačítko <b>#pgv_lang[close_window_without_refresh]#</b>, mali by ste vedieť, že neuvidíte na obrazovke jazykového editoru priamo svoje zmeny, pokiaľ neurobíte manuálne znovu-načítanie stránky a to môže spôsobiť poškodenie vášho jazykového súboru, ak pridáte správu, ktorá doteraz nie je v jazykovom súbore alebo ak iba upravíte správu, ktorú ste upravovali ihneď predtým.<br /><br />Takže, ak si nie ste 100% istý, čo robíte, nepoužívajte prosím tlačítko <b>#pgv_lang[close_window_without_refresh]#</b>.";
$pgv_lang["language_to_edit"]		= "Jazyk, ktorý sa má upraviť";
$pgv_lang["language_to_edit_help"]	= "~#pgv_lang[language_to_edit]#~<br /><br />V tomto zozname vyberte jazyk, kterého texty chcete editovať.<br />";
$pgv_lang["file_to_edit"]		= "Typ jazykového súboru, ktorý sa má upraviť";
$pgv_lang["file_to_edit_help"]		= "~#pgv_lang[file_to_edit]#~<br /><br />#pgv_lang[lang_file_descriptions]#";
$pgv_lang["check"]			= "Skontrolovať";
$pgv_lang["lang_file_descriptions"]	= "~#pgv_lang[file_to_edit]#~<br /><br />PhpGedView má implementovanú podporu pre mnoho rôznych jazykov. To je urobené tak, že všetky texty, ktoré sa zobrazujú uživateľom sú uložené v súboroch oddelených od hlavného programu. Pre každý podporovaný jazyk je určená sada piatich súborov a variabilný text je uložený podľa funkcie v jednom z týchto súborov. V prípade, že text ešte nie je preložený PhpGedView použije anglickú verziu. .<br /><br />Súbory v každom jazykovej sade sú:<br /><ul><li><b><i>configure_help.xx.php</i></b>&nbsp;&nbsp;Tento súbor obsahuje termíny, obvyklé výrazy, a Help texty použité v priebehu konfigurácie PhpGedView. Help texty nie sú určené k zobrazeniu bežným uživateľom.</li><br /><li><b><i>countries.xx.php</i></b>&nbsp;&nbsp;Tento súbor obsahuje zoznam mien štátov a krajov z Web stránky úradu  Statistics Division, United Nations Department of Economic and Social Affairs. To je relevantné <a href=\"http://unstats.un.org/unsd/methods/m49/m49alpha.htm\" target=_blank><b>link</b></a> pre anglický zoznam. Zoznam je dostupný v angličtine alebo francúzštine.</li><br /><li><b><i>facts.xx.php</i></b>&nbsp;&nbsp;Tento súbor obsahuje textové ekvivalenty kódov GEDCOM údajov obsiahnutých v GEDCOM 5.5.1 Standard. Tiež obsahuje dodatočné kódy údajov ktoré nie sú v GEDCOM Standard ale sú používané v rôznych genealogických programoch.<br /><br />Anglickú kópiu Gedcom Standard si môžete stiahnuť vo formáte PDF z adrey <a href=\"http://www.phpgedview.net/ged551-5.pdf\" target=_blank><b>GEDCOM 5.5.1 Standard</b></a>.</li><br /><li><b><i>help_text.xx.php</i></b>&nbsp;&nbsp;Tento súbor obsahuje Help texty pre bežných uživateľov. Niektoré z týchto textov su určené administrátorom a sú skryté uživateľom, ktorý nemajú administrátorské práva.</li><br /><li><b><i>lang.xx.php</i></b>&nbsp;&nbsp;Veľa termínov a obvyklých výrazov je uložených v tomto súbore.</li></ul>";
$pgv_lang["lang_save"]			= "Uložiť";
$pgv_lang["contents"]			= "Obsah";
$pgv_lang["listing"]			= "Výpis";
$pgv_lang["no_content"]			= "Bez obsahu";
$pgv_lang["editlang"]			= "Editácia";
$pgv_lang["editlang_help"]		= "Upraviť správu z jazykového súboru";
$pgv_lang["savelang"]			= "Uložiť";
$pgv_lang["savelang_help"]		= "Uložiť upravenú správu";
$pgv_lang["original_message"]		= "Pôvodná správa";
$pgv_lang["message_to_edit"]		= "Správa k úprave";
$pgv_lang["changed_message"]		= "Zmenený obsah";
$pgv_lang["message_empty_warning"]	= "-> Upozornenie!!! Táto správa je v súbore [#LANGUAGE_FILE#] prázdna <-";
$pgv_lang["language_to_export"]		= "Jazyk na exportovanie";
$pgv_lang["language_to_export_help"]	= "~#pgv_lang[language_to_export]#~<br /><br />Z tohoto zoznamu si môžete vybrať jazyk, ktorého texty chcete exportovať.<br /><br />Program exportuje iba obsah súboru <i>configure_help_text.php</i>. Výstupom je HTML súbor, ktorý si môžete vytlačť z vašeho prehliadača.<br />";
$pgv_lang["export_lang_utility"]	= "Pomôcka pre exportovanie jazykového súboru";
$pgv_lang["export"]			= "Export";
$pgv_lang["export_lang_utility_help"]	= "V tomto module si môžete vybrať jazyk a kliknutím na tlačítko EXPORT exportovať správy s nápovedou zo súboru Configuration_help pre zvolený jazyk pre vytvorenie dokumentácie.";
$pgv_lang["export_lang_utility_desc"]	= "Môžete vytvoriť dokumentáciu pre administrátorov.<br /><br />Táto pomôcka vytvorí HTML verziu súboru Configuration Help v zvolenom jazyku. Môžete si zobraziť tento súbor vo vašom prehliadači a vytlačiť ho.";
$pgv_lang["export_ok"]			= "Správy s nápovedou boli exportované";
$pgv_lang["compare_lang_utility"]	= "Pomôcka pre porovnávanie jazykových súborov";
$pgv_lang["compare_lang_utility_help"]	= "~#pgv_lang[compare_lang_utility]#~<br /><br />#pgv_lang[compare_lang_utility_desc]#<br />";
$pgv_lang["compare_lang_utility_desc"]	= "Tento modul porovná dva jazykové súbory a vytvorí zoznam rozdielov medzi nimi.<br />O všetkých zmenách v Anglickej verzii si prečítajte v súbore [<a href=\"languages/LANG_CHANGELOG.txt\" target=\"_blank\">LANG_CHANGELOG.txt</a>]. Anglické verzie jazykových súborov sú používané ako referenčné pre všetky ďalšie jazyky.";
$pgv_lang["new_language"]		= "Zdrojový jazyk";
$pgv_lang["new_language_help"]		= "~#pgv_lang[new_language]#~<br /><br />Tu môžete zvoliť jazyk, ktorého správy chcete porovnať so správami iného jazyka.<br/><br/>Všetky zmeny a doplnky sa robia najskôr v <b>anglických</b> jazykových súboroch.<br />";
$pgv_lang["old_language"]		= "Druhý jazyk";
$pgv_lang["old_language_help"]		= "~#pgv_lang[old_language]#~<br /><br />Tu môžete vybrať jazyk, ktorý chcete použiť pre porovnanie z jazykom vybraným v políčku <b>Zdroj</b>.<br/><br/> Potom, čo si vyberiete, kliknite na tlačítko <b>Porovnať</b> a zobrazí sa vám zoznam všetkých rozdielov medzi zvolenými jazykovými súbormi.<br /><br />Upozorňujeme, že:<br /><b>Časti navyše</b> znamená: Táto položka <b>je v</b> zdrojovom súbore, ale <b>nie je</b> v súbore druhého jazyka.<br /><br /><b>Chýbajúce časti</b> znamená: V zdrojovom súbore táto položka už <b>nie je</b>, ale v súbore druhého jazyka (ešte) <b>je</b>. To znamená, že texty v sekcii Chýbajúce časti už nie sú používané a boli odstránené z Anglických súborov. Môžete bezpečne zmazať tieto texty zo  súborov druhého jazyka.<br />";
$pgv_lang["compare"]			= "Porovnať";
$pgv_lang["comparing"]			= "Porovnávané jazykové soubory";
$pgv_lang["additions"]			= "Časti navyše";
$pgv_lang["no_additions"]		= "Žiadne časti navyše";
$pgv_lang["subtractions"]		= "Chýbajúce časti";
$pgv_lang["no_subtractions"]		= "Žiadne chýbajúce časti";
$pgv_lang["config_lang_utility"]	= "Konfigurácia podporovaných jazykov";
$pgv_lang["config_lang_utility_help"]	= "~#pgv_lang[config_lang_utility]#~<br /><br />Tento modul vám pomôže upravovať nastavenia špecifické pre daný jazyk pre použitie v PhpGedView.<br />Všimnite si prosím, že, ak ste zmenili pôvodné jazykové nastavenie PhpGedView, bol vo vašej zložke #INDEX_DIRECTORY# vytvorený nový súbor (#INDEX_DIRECTORY#lang_settings.php).<br />Všetky vaše ďalšie zmeny sa budú zapisovať do tohoto súboru a PhpGedView bude používať iba TENTO súbor.<br />Takže, ak by ste mali ťažkosti zo svojím národným nastavením, prosím skontrolujte si, či tento nový súbor máte v zložke #INDEX_DIRECTORY#!";
$pgv_lang["active"]			= "Aktívny";
$pgv_lang["active_help"]		= "Umožniť uživateľom vybrať si tento jazyk, ak je povolená zmena jazyka.";
$pgv_lang["edit_settings"]		= "Upraviť nastavenie";
$pgv_lang["lang_edit"]			= "Upraviť";
$pgv_lang["lang_language"]		= "Jazyk";
$pgv_lang["export_filename"]		= "Názov súboru obsahujúceho exportované dáta:";
$pgv_lang["lang_back"]			= "Pre úpravu a nastavenie jazyka sa vráťte späť do hlavného menu.";
$pgv_lang["lang_back_admin"]		= "Späť do menu Admina";
$pgv_lang["lang_back_manage_gedcoms"]	= "Späť do menu správy GEDCOMov";
$pgv_lang["lang_name_czech"]		= "Čeština";
$pgv_lang["lang_name_chinese"]		= "Čínština";
$pgv_lang["lang_name_danish"]		= "Dánčina";
$pgv_lang["lang_name_dutch"]		= "Holandčina";
$pgv_lang["lang_name_english"]		= "Angličtina";
$pgv_lang["lang_name_finnish"]		= "Fínčina";
$pgv_lang["lang_name_french"]		= "Francúzština";
$pgv_lang["lang_name_german"]		= "Nemčina";
$pgv_lang["lang_name_hebrew"]		= "Hebrejčina";
$pgv_lang["lang_name_hungarian"]	= "Maďarčina";
$pgv_lang["lang_name_italian"]		= "Taliančina";
$pgv_lang["lang_name_norwegian"]	= "Nórčina";
$pgv_lang["lang_name_polish"]		= "Poľština";
$pgv_lang["lang_name_portuguese"]	= "Portugalčina";
$pgv_lang["lang_name_portuguese-br"]	= "Brazilská portugalčina";
$pgv_lang["lang_name_russian"]		= "Ruština";
$pgv_lang["lang_name_spanish"]		= "Španielčina";
$pgv_lang["lang_name_spanish-ar"]	= "Latinsko-americká španielčina";
$pgv_lang["lang_name_swedish"]		= "Švédčina";
$pgv_lang["lang_name_turkish"]		= "Turečtina";
$pgv_lang["lang_name_greek"]		= "Gréčtina";
$pgv_lang["lang_name_arabic"]		= "Arabčina";
$pgv_lang["lang_name_lithuanian"]	= "Litovčina";
$pgv_lang["lang_name_vietnamese"]	= "Vietnamčina";
$pgv_lang["lang_name_slovak"]		= "Slovenčina";
$pgv_lang["lang_name_estonian"]		= "Estónčina";
$pgv_lang["lang_new_language"]		= "Nový jazyk";
$pgv_lang["original_lang_name"]		= "Ako tento jazyk označuje jazyk #D_LANGNAME#";
$pgv_lang["original_lang_name_help"]	= "Ako sa tento jazyk nazýva v tomto jazyku?<br /><br />Angličtina je v anglickom jazyku: English<br />Nemčina je v nemeckom jazyku: Deutsch<br />Holandčina je v holandskom jazyku: Nederlands<br />atd.";
$pgv_lang["lang_shortcut"]		= "Skratka jazyku pre jazykový súbor.";
$pgv_lang["lang_shortcut_help"]		= "Tento kód definuje skratku, ktorú používa PhpGedView pre zvolený jazyk.<br />Bežne to býva prvá skratka uvedená v 'Language detection codes', čo je možné definovať v nasledujúcom políčku v okne národného (jazykového) nastavenia.";
$pgv_lang["lang_langcode"]		= "Kód pre rozoznanie jazyka";
$pgv_lang["lang_langcode_help"]		= "Tento kód umožňuje PhpGedView rozoznať jazykové nastavenie prehliadača, ktorý aktuálny uživateľ používa k prezeraniu vašich stránok PhpGedView. Jednotlivé kódy musia byť oddelené stredníkom ';'";
$pgv_lang["lang_filenames"]		= "Jazykové súbory";
$pgv_lang["lang_filenames_help"]	= "~#pgv_lang[lang_filenames]#~<br /><br />#pgv_lang[lang_file_descriptions]#";
$pgv_lang["flagsfile"]			= "Súbor s vlajkou";
$pgv_lang["flagsfile_help"]		= "Názov a cesta k obrázku s národnou vlajkou pre označený jazyk.";
$pgv_lang["text_direction"]		= "Smer textu";
$pgv_lang["text_direction_help"]	= "Definuje smer, ktorým sa píše vo zvolenom jazyku. Všetky západné jazyky normálne používajú pre čítanie a písanie textov smer zľava doprava. Ale u jazykov ako arabčina alebo hebrejčina je smer opačný.";
$pgv_lang["date_format"]		= "Formát dátumu";
$pgv_lang["date_format_help"]		= "Toto políčko definuje formát dátumu, ktorý sa bude používať všeobecne v genealogických prácach vo zvolenom jazyku.<br /><br />Premenné, ktoré môžete používať, sú:<br />D pre deň<br />M pre mesiac<br />Y pre rok.<br /><br />Môžete zmeniť poradie týchto premenných a tiež do nich pridať vymedzujúce znaky.<br /><br />Štandardné nastavenie tejto premennej je 'D M Y', čo znamená, že dátumy v GEDCOM záznamoch budou vypadať takto 'DATE 20 Nov 1965' je v PhpGedView zobrazené ako '20 November 1965'.<br /><br />Napríklad na Slovensku je obsah tohoto políčka: 'D. M Y', čo znamená, že dátum z nášho príkladu bude v slovenčine: '20. November 1965'.<br /><br />Iný príklad je maďarčina, ktorá definuje dátum 'Y M D' a 'náš' dátum by sa v PhpGedView zobrazil ako '1965 November 20' (keby bol v maďarčine 11. mesiac November).<br />Iným príkladom je fínčina, ktorá definuje dátum 'D. M#ta# Y'. Táto definícia znamená, že vo fínčine sa všetky mesiace, u ktorých je v GEDCOM zázname uvedený i deň, zobrazí ako 20. Novemberta 1965 (keby November bol fínsky názov pre 11. mesiac).";
$pgv_lang["time_format"]		= "Formát času";
$pgv_lang["time_format_help"]		= "Toto políčko definuje formát času, ktorý sa bude používať pre daný jazyk.<br /><br />Premenné, ktoré môžete použiť, sú:<br />a – malé písmeno: dopoludnia a odpoludnia - 'am' alebo 'pm'<br />A – veľké písmeno: dopoludnia a odpoludnia - 'AM' alebo 'PM'<br />B – Vzorový internetový čas 000 až 999<br />c – dátum ISO 8601 (pridané v PHP 5) 2004-02-12T15:19:21+00:00<br />d – Deň mesiaca, 2 číslica (nula na začiatku) 01 až 31<br />D – Textová skratka dňa, tri písmená Mon až Sun<br />F – Mesiac celým slovom, ako napr. January alebo March January až December<br />g – 12-hodinový formát bez nuly na začiatku 1 až 12<br />G – 24-hodinový formát bez nuly na začiatku 0 až 23<br />h - 12-hodinový formát s nulou na začiatku 01 až 12<br />H - 24-hodinový formát s nulou na začiatku 00 až 23<br />i – Minúty s nulou na začiatku 00 až 59<br />I - (veľké i) Ak je, alebo nie je dátum uložený v letnom čase. 1 - ak je v letnom čase, inak 0.<br />j – Deň v mesiaci bez nuly na začiatku 1 až 31<br />l - (malé 'L') Deň v týždni celým slovom Sunday až Saturday<br />L – Ak je to prestupný rok. 1 - ak je to prestupný rok, inak 0.<br />m – Číselné vyjadrenie mesiaca s nulou na začiatku 01 až 12<br />M – Textová skratka mesiaca, tri mesiace Jan až Dec<br />n – Číselné vyjadrenie masiaca bez nuly na začiatku 1 až 12<br />O – Rozdiel oproti času v Greenwich (GMT) v hodinách Napríklad: +0200<br />r – formátovanie času RFC 2822 Napríklad: Thu, 21 Dec 2000 16:01:07 +0200<br />s – Sekundy s nulou na začiatku 00 až 59<br />S – Anglická skratková prípona dňa v mesiaci, 2 znaky st, nd, rd alebo th. Funguje dobre s j<br />t – Počet dní v danom mesiaci 28 až 31<br />T – Nastavená časová zóna na tomto zariadení Napríklad: CEST, EST, MDT ...<br />U – Sekundy od Unixového obdobia (January 1 1970 00:00:00 GMT)<br />w – Číselné vyjadrenie dňa v týždni 0 (pre nedeľu) až 6 (pre sobotu)<br />W – číslo týždňa v roku ISO-8601, týždne začínajúce v pondelok (pridané v PHP 4.1.0) Napríklad: 42 (42. týždeň v roku)<br />Y – Vyjadrenie roku štyrmi číslicami Napríklad: 1999 alebo 2003<br />y – Dvojciferné vyjadrenie roku Napríklad: 99 alebo 03<br />z – Deň v roku (počínajúc 0) 0 až 365<br />Z – Vyváženie časovej zóny v sekundách. Vyváženie časových pásiem západne od UTC je vždy záporné, a pro tie východne od UTC je vždy kladné. -43200 až 43200<br /><br />Môžete zmeniť poradie týchto premenných a tiež do nich pridať vymedzujúce znaky.<br />Napríklad v nemčine je obsah tohoto políčka: 'H:i:s', čo vytvorí výstup ako: '09:01:25'.<br />V angličtine je štandardná definícia tohoto pole: 'g:i:sa', čo vytvorí výstup ako: '9:01:25am'.";
$pgv_lang["week_start"]			= "Počiatočný deň týždňa";
$pgv_lang["week_start_help"]		= "Deň, ktorým začíná týždeň pre tento jazyk. Pre väčšinu jazykov začíná týždeň nedeľou, ale pre niektoré začíná v pondelok alebo v iné dni.";
$pgv_lang["name_reverse"]		= "Priezvisko na prvom mieste";
$pgv_lang["name_reverse_help"]		= "V niektorých jazykoch by malo byť priezvisko zobrazené ako prvé namiesto implicitného zobrazenia na poslednom mieste. Ak zapnete túto voľbu, budú sa priezviská zobrazovať na prvom mieste.";
$pgv_lang["ltr"]			= "Zľava doprava";
$pgv_lang["rtl"]			= "Zprava doľava";
$pgv_lang["file_does_not_exist"]	= "CHYBA! Súbor neexistuje...";
$pgv_lang["optional_file_not_exist"]	= "Tento nepovinný súbor neexistuje.";
$pgv_lang["alphabet_upper"]		= "Veľké písmená abecedy";
$pgv_lang["alphabet_upper_help"]	= "Veľké písmená abecedy používané týmto jazykom. Táto abeceda sa používá k triedeniu zoznamu mien zapísaných veľkými písmenami v aplikácii PhpGedView vo zvolenom jazyku.";
$pgv_lang["alphabet_lower"]		= "Malé písmená abecedy";
$pgv_lang["alphabet_lower_help"]	= "Malé písmená abecedy používané týmto jazykom. Táto abeceda sa používa k triedeniu zoznamu mien zapísaných malými písmenami v aplikáci PhpGedView vo zvolenom jazyku.";
$pgv_lang["multi_letter_alphabet"]	= "Viacpísmenná abeceda";
$pgv_lang["multi_letter_alphabet_help"]	= "~#pgv_lang[multi_letter_alphabet]#~<br /><br />Viacpísmenné kombinácie ktoré sú chápané ako jedno písmeno pri triedení zoznamov mien a titulov v tomto jazyku.<br /><br />Niektoré jazyky, maďarský a slovenský napríklad, považujú niektoré kombinácie písmen za odlišné písmená z vlastným významom. Poradie v ktorom špecifikujete tieto kombinácie určí poradie v ktorom budú vložené do normálnej abecedy v priebehu triedenia. To je dôležité ak niekoľko viacpísmenných kombinácií má rovnaké prvé písmeno. Z výnimkou <b>ch</b>, táto kombinácia písmen je vložená do normálnej abecdy podla jej prvého písmena. <b>ch</b> je vždy vložené za  <b>h</b>.<br />";
$pgv_lang["dictionary_sort"]		= "Použiť pri triedení slovníkové pravidlá";
$pgv_lang["dictionary_sort_help"]	= "~#pgv_lang[dictionary_sort]#~<br /><br />Táto voľba riadi ako sú spracované písmená s diakritickými znakmi pri triedení zoznamov mien a titulov.<br /><br />Ak nastavíte <b>#pgv_lang[yes]#</b>, všetky písmená s diakritickými znamienkami budú považované ako keby nemali žiadne znamienka. Diakritické znamienka budú zohľadnené iba vtedy keď vyhodnocované dve slová sú inak identické. Ak nastavíte <b>#pgv_lang[no]#</b>, všetky písmená budú považované za rozdielne bez ohľadu na prítomnosť, alebo neprítomnosť diakritického znamienka.<br />";
$pgv_lang["lang_config_write_error"]	= "Chyba v priebehu zápisu jazykového nastavenia do súboru [language_settings.php]. Skontrolujte práva a skúste to znovu.";
$pgv_lang["translation_forum"]		= "Odkaz do fóra prekladov PhpGedView na SourceForge";
$pgv_lang["translation_forum_help"]	= "Tento odkaz - <a href=\"http://sourceforge.net/forum/forum.php?forum_id=294245\" target=_blank><b>link</b></a> otvorí nové okno prehliadača, v ktorom budete presmerovaný do fóra prekladov PhpGedView, kde môžete prediskutovať špecifické problémy prekladu.";
$pgv_lang["translation_forum_desc"]	= "Tento odkaz - <a href=\"http://sourceforge.net/forum/forum.php?forum_id=294245\" target=_blank><b>link</b></a> otvorí nové okno prehliadača, v ktorom budete presmerovaný do fóra prekladov PhpGedView, kde môžete prediskutovať špecifické problémy prekladu.";
$pgv_lang["lang_set_file_read_error"]	= "C H Y B A !!! Nedá sa otvoriť súbor <b>lang_settings.php</b>!";
$pgv_lang["add_new_language_help"]	= "Tento nástroj môžete použiť pre pridanie nového doteraz nepodporovaného jazyka do PhpGedView. Vyplňte prosím všetky potrebné políčka v nasledujúcom okne. Po vytvorení nových súborov budete môcť upravovať texty správ pre daný jazyk.";
$pgv_lang["add_new_language_desc"]	= "Tento nástroj môžete použiť pre pridanie nového doteraz nepodporovaného jazyka do PhpGedView.<br /><br />Môžete nastaviť všetky štandardné nastavenia nového jazyka. To zahrnuje kód pre určenie jazyka, spôsob triedenia, prvý deň v týždni , spôsob zobrazenia času a dátumu, abecedu atd.<br /><br />Môžete získať ďalšiu nápovedu o nastavení jazyka podporované PhpGedView tak že vyberiete jazyk a kliknete na tlačítko <b>#pgv_lang[add_new_lang_button]#</b>.<br /><br />Ďalšia nápoveda je na stránke Konfigurácia.<br />";
$pgv_lang["add_new_lang_button"]	= "Pridať nový jazyk";
$pgv_lang["hide_translated"]		= "Skryť preložené";
$pgv_lang["hide_translated_help"]	= "~#pgv_lang[hide_translated]#~<br /><br />Ak nastavíte  <b>Ano</b> tak uvidíte iba tie texty z vybraného jazyka, ktoré ešte nie sú preložené. To znamená, že nové texty <u>neboli</u> nájdené v cielovom jazykovom súbore.<br /><br />Niektoré jazykové súbory obsahujú Anglické texty pre rôzne nepreložené texty. Tento program neidentifikuje tieto nepreložené položky, pretože už sú uložené v cielovom súbore. Vychádzame z predpokladu, \"Ak je text uložený v cielovom súbore, tak musí byť už preložený.\"<br />";
$pgv_lang["lang_file_write_error"]	= "C H Y B A !!!<br /><br />Zmeny nebolo možné do zvoleného jazykového súboru zapísať!<br />Skontrolujte práva zápisu pre súbor <b>#lang_filename#</b>";
$pgv_lang["no_open"]			= "C H Y B A !!!<br /><br />Nie je možné otvoriť súbor #lang_filename#</b>";
$pgv_lang["users_langs"]		= "Uživateľské jazyky";
$pgv_lang["configured_languages"]	= "Použité jazyky";
$pgv_lang["um_header"] 			= "Nástroj pre presun informácií o uživateľoch";
$pgv_lang["um_proceed"] 		= "Pokračovať v exporte uživateľských datových súborov?<br /><br />";
$pgv_lang["um_creating"] 		= "Kopírovanie";
$pgv_lang["um_sql_index"] 		= "Tento nástroj vytvorí <i>authenticate.php</i> a niekoľko ďaľších <i>.dat</i> súborov vo vašom index adresári. Po vytvorení môžete prepnúť všetkých uživateľov a ich správy, obľúbené, novinky a MyGedView layout do Index módu.<br /><br />Poznámka: Po prepnutí do Index módu musíte tiež importovať váš GEDCOM súbor ešte raz.<br /><br />";
$pgv_lang["um_file_create_fail1"] 	= "Nebolo možné vytvoriť nový súbor; súbor s týmto názvom už existuje:";
$pgv_lang["um_file_create_fail2"] 	= "Nie je možné skopírovať";
$pgv_lang["um_file_create_fail3"] 	= "Skontrolujte prístupové práva k tejto zložke.";
$pgv_lang["um_file_create_succ1"] 	= "Vytvorenie nového súboru prebehlo úspešne:";
$pgv_lang["um_file_not_created"] 	= "Súbor nebol vytvorený.";
$pgv_lang["um_nomsg"] 			= "Zdá sa, že v tejto chvíli v systéme nie sú žiadne správy.";
$pgv_lang["um_nofav"] 			= "Zdá sa, že v tejto chvíli v systéme nie sú žiadne obľúbené.";
$pgv_lang["um_nonews"] 			= "Zdá sa, že v tejto chvíli v systéme nie sú žiadne novinky.";
$pgv_lang["um_noblocks"] 		= "Zdá sa, že v tejto chvíli v systéme nie sú žiadne bloky.";
$pgv_lang["um_index_sql"] 		= "Tento nástroj importuje <i>authenticate.php</i> a ďaľšie <i>.dat</i> súbory z vašeho index adresára do vašej databázy.";
$pgv_lang["um_noaction"] 		= "Nemusíte uživateľov informovať o migrácii na SQL mód.br /><br />Ak prepnete na SQL mód, musíte reštartovať User Migration tool kvôli importu všetkývh dát do SQL databázy. PhpGedView použije existujúce súbory z Index módu.<br /><br /><b><u>Nesmiete</u> presunúť <i>authenticate.php</i> a <i>.dat</i> súbory z vašeho adresára INDEX  pri migrácii.</b><br />";
$pgv_lang["um_import"] 			= "Import";
$pgv_lang["um_export"] 			= "Export";
$pgv_lang["um_explain"] 		= "Tento nástroj exportuje uživateľské dáta z SQL do Index módu, alebo opačne z Index módu do tabuliek SQL.<br /><br />Uživateľské dáta, obľúbené, definície blokov, správy a novinky budú opäť dostupné po skončení importu.<br /><br />POZOR.<br /><br />Nemôžete použiť tento nástroj na prenos dát medzi rôznymi verziami PhpGedView.<br /><br />IMPORT.<br /><br />Ak vyberiete možnost importu uživateľských datových súborov z Index módu, všetky uživateľské dáta v databázy budú <u>prepísané</u>. Tento nástroj nespojuje dáta. Keď spustíte import, nie je žiadna možnosť ako sa dostať k starým dáta pomocou PhPGedView.<br /><br /><b>EXPORT</b><br />Ak exportujete uživateľské dáta zvašej SQL databázy do Index Mód súborov, vytvorí sa  </i>authenticate.php</i> a ďalšie <i>.dat</i> súbory vo vašom index adresári. V prípade, že tu už existujú súbory rovnakého mena program vás vyzve k potvrdeniu či ich môže prepísať. Po preponutí do Index módu sú všetky dáta okamžite dostupné.<br /><br /><b>Poznámka:</b> Po prepnutí do Index Módu musíte urobiť opäť import vášho GEDCOM súboru.<br /><br />";
$pgv_lang["um_tool_help"] 		= "~#pgv_lang[um_header]#~<br /><br />#pgv_lang[um_explain]#";
$pgv_lang["um_sql_index_help"] 		= "~Presunúť uživateľov z SQL do Index módu~<br /><br />#pgv_lang[um_sql_index]#";
$pgv_lang["um_index_sql_help"] 		= "~Presunúť uživateľov z Index do SQL módu~<br /><br />#pgv_lang[um_index_sql]#";
$pgv_lang["um_imp_users"] 		= "Import uživateľov";
$pgv_lang["um_imp_blocks"] 		= "Import blokov";
$pgv_lang["um_imp_favorites"] 		= "Import obľúbených";
$pgv_lang["um_imp_messages"] 		= "Import správ";
$pgv_lang["um_imp_news"] 		= "Import noviniek";
$pgv_lang["um_nousers"] 		= "Súbor <i>authenticate.php</i> nebol najdený vo vašom index adresári. Import bol zastavený.";
$pgv_lang["um_imp_succ"] 		= "Import prebehol v poriadku";
$pgv_lang["um_imp_fail"] 		= "Import neprebehol v poriadku";
$pgv_lang["um_backup"] 			= "Záloha (backup)";
$pgv_lang["um_zip_succ"] 		= "ZIP súbor bol vytvorený";
$pgv_lang["um_zip_dl"] 			= "Načítať zálohu (ZIP súbor)";
$pgv_lang["um_bu_explain"] 		= "Tento nástroj môže urobiť zálohu niektorých dát z PhpGedView. Dáta ktoré vyberiete budú skopírované do ZIP súboru, tento súbor môžete načítať na ľubovolné miesto. ZIP súbor je uložený vo vašom index adresári, až dokiaľ ho nezmažete manuálne.";
$pgv_lang["um_bu_help"] 		= "~#pgv_lang[um_backup]#~<br /><br />#pgv_lang[um_bu_explain]#";
$pgv_lang["um_bu_config"] 		= "Súbory konfigurácie PhpGedView";
$pgv_lang["um_bu_gedcoms"] 		= "GEDCOM súbory";
$pgv_lang["um_bu_gedsets"] 		= "GEDCOM - súbory nastavenia, konfigurácie a privátnosti";
$pgv_lang["um_bu_logs"] 		= "GEDCOM počitadlá, Search logy a PhpGedView logfiles";
$pgv_lang["um_bu_usinfo"] 		= "Uživateľské nastavenia, nastavenia blokov, správy, novinky";
$pgv_lang["um_bu_media"]		= "Súbory médií";
$pgv_lang["um_mk_bu"] 			= "Urobiť zálohu (backup)";
$pgv_lang["um_nofiles"] 		= "Nebol nájdený žiadny súbor na zálohovanie.";
$pgv_lang["um_files_exist"] 		= "Jeden, alebo viacej súborov už existuje. Chcete ich prepísať?";
$pgv_lang["um_results"]			= "Výsledky";
$pgv_lang["preview_faq_item"] 		= "Zobraziť všetky položky FAQ";
$pgv_lang["preview_faq_item_help"] 	= "~#pgv_lang[preview_faq_item]#~<br />Táto voľba umožňuje administrátorovi zobraziť stránku FAQ bez editačných volieb a linkov.<br /><br /> Okrem jedného tlačítka <b>Upraviť</b> nad prvou položkou FAQ bude zobrazenie stránky FAQ rovnaké ako ho uvidia obyčajný uživatelia. Toto špeciálne tlačítko <b>Upraviť</b> vás vráti do plnej funkčnosti Upraviť.<br />";
$pgv_lang["restore_faq_edits"] 		= "Obnoviť funkčnosť Upraviť FAQ";
$pgv_lang["restore_faq_edits_help"] 	= "~#pgv_lang[restore_faq_edits]#~<br />Táto voľba obnoví stránku FAQ do režimu ako ju vidí obvykle administrátor, tak že jednotlivé položky FAQ môžu byť editované.<br />";
$pgv_lang["add_faq_item"] 		= "Pridať položku FAQ";
$pgv_lang["add_faq_item_help"] 		= "~#pgv_lang[add_faq_item]#~<br />Táto voľba vám umožňuje pridať položku na stránku FAQ.<br />";
$pgv_lang["edit_faq_item"] 		= "Upraviť položku FAQ";
$pgv_lang["edit_faq_item_help"] 	= "~#pgv_lang[edit_faq_item]#~<br />Táto voľba vám umožňuje upraviť položku na stránke FAQ.<br />";
$pgv_lang["delete_faq_item"] 		= "Zmazať položku FAQ";
$pgv_lang["delete_faq_item_help"] 	= "~#pgv_lang[delete_faq_item]#~<br />Táto voľba vám umožňuje zmazať položku na stránke FAQ<br />";
$pgv_lang["moveup_faq_item"] 		= "Presunúť položku FAQ hore";
$pgv_lang["moveup_faq_item_help"] 	= "~#pgv_lang[moveup_faq_item]#~<br />Táto voľba vám umožní presunúť položku vyššie na stránke FAQ.<br /><br />Vždy keď použijete túto možnosť bude číslo pozície položky FAQ zmenšené o 1. Rovnaký efekt môžete dosiahnúť priamo zmenou čísla pozície položky FAQ. Pozor ak viacej položiek FAQ má rovnaké číslo tak bude zobrazená iba jedna.<br />";
$pgv_lang["movedown_faq_item"] 		= "Presunúť položku FAQ dole";
$pgv_lang["movedown_faq_item_help"] 	= "~#pgv_lang[movedown_faq_item]#~<br />Táto voľba vám umožní presunúť položku nižšiee na stránke FAQ.<br /><br />Vždy keď použijete túto možnosť bude číslo pozície položky FAQ zväčšené o 1. Rovnaký efekt môžete dosiahnúť priamo zmenou čísla pozície položky FAQ. Pozor ak viacej položiek FAQ má rovnaké číslo tak bude zobrazená iba jedna.<br />";
$pgv_lang["add_faq_header_help"] 	= "~FAQ Hlavička~<br />Tu je titulok, alebo predmet položky FAQ.<br /><br />Text môže byť formátovaný; HTML tagy ako <b> a <br> sú povolené, rovnako HTML entity ako  & a &nbsp;. Nie je tu žiadna možnosť zadať tagy tak, aby boli interpretované ako text.<br />";
$pgv_lang["add_faq_body_help"] 		= "~FAQ telo~<br />Tu je vložený text položky FAQ.<br /><br />Text môže byť formátovaný; HTML tagy ako  <b> a <br> sú povolené, rovnako HTML entity ako  &amp; a &nbsp;. Nie je tu žiadna možnosť zadať HTML tagy tak aby boli interpretované ako text.<br />";
$pgv_lang["add_faq_order_help"] 	= "~FAQ Pozícia~<br />Toto pole riadi poradie v ktorom sú polžky FAQ zobrazené.<br /><br />Nemusíte zadávať čísla sekvenčne. Ak necháte prázdne miesta v číselnom poradí, môžete vložiť ďalšie položky neskoršie. Napríklad, ak použijete čísla 1, 6, 11, 16, môžete neskoršie vložiť položky s chýbajúcimi číslami. Záporné čísla a nula sú dovolené, a môžu byť použité na vloženie položiek pred prvú položku.<br /><br />Ak má viac než jedna položka FAQ rovnaké číslo pozície tak bude zobrazená iba jedna.<br />";
$pgv_lang["add_faq_visibility_help"] = "~#pgv_lang[add_faq_visibility]#~<br />Môžete určiť či FAQ bude zobrazené nbez ohľadu na GEDCOMe, alebo či bude zobrazné iba z aktuálnym GEDCOMom.<br /><ul><li><b>#pgv_lang[all]#</b>&nbsp;&nbsp;&nbsp;FAQ bude zobrazené na zozname všetkých FAQ, bez ohľadu na GEDCOM.</li><li><b>#GLOBALS[GEDCOM]#</b>&nbsp;&nbsp;&nbsp;FAQ bude zobrazené iba na zozname FAQ aktuálneho aktívneho GEDCOMu.</li></ul><br />";
$pgv_lang["time_limit_help"]		= "~#pgv_lang[time_limit]#~<br /><br />Maximálny čas importu, ktorý je povolený na zpracovanie GEDCOM súboru.";
$pgv_lang["media_import_help"] 		= "~#pgv_lang[media_import]#~<br />Tento import konvertuje  multimediálne súbory vo vašom GEDCOM súbore na multimediálne záznamy. Napríklad, nasledujúci súbor bude zmenený z:<blockquote><code>1 OBJE<br />2 FORM jpg<br />2 FILE media/staramama.jpg<br />2 TITL Obrazok starej mamy</code></blockquote>na:<blockquote><code>0 @M1@ OBJE<br />1 FORM jpg<br />1 FILE media/staramama.jpg<br />1 TITL Obrazok starej mamy</code></blockquote>Nový  multimediálny záznam bude uložený v databáze oddelene. Linky na externé súbory multimédií budú zmenené na odkazy na nové multimediálne záznamy, ktoré naopak budú obsahovať odkaz na externý súbor. Napríklad, nasledujúci GEDCOM záznam bude zmenený z:<blockquote><code>0 @I1@ INDI<br />1 NAME Your/Name/<br />1 OBJE<br />2 FORM jpg<br />2 FILE media/staramama.jpg<br />2 TITL Obrazok starej mamy</code></blockquote>na:<blockquote><code>0 @I1@ INDI<br />1 NAME Your/Name/<br />1 OBJE @M1@<br /></code></blockquote>Výhoda použitia multimediálnych záznamov je, že umožňujú jednoducho spravovať vaše médiá. Ak zmeníte titulok multimediálneho záznamu, zmení sa pre všetky GEDCOM záznamy ktoré sú prepojené s týmto multimediálnym záznamom. Niekoľko ľudí, rodín alebo zdrojov môže byť prepojených s tým istým multimediálnym záznamom.";
$pgv_lang["SHOW_SOURCES"]		= "Zobraziť zdroje";
$pgv_lang["SHOW_SOURCES_help"]		= "Nastavenie úrovne utajenia pre zdroje. Ak uživateľ nemá prístup ku zdrojom, tak položka menu Zoznam zdrojov bude ukrytá a tabuľka zdrojov na stránke detailov osoby sa nezobrazí. ";
$pgv_lang["REQUIRE_ADMIN_AUTH_REGISTRATION_help"]	= "Ak je voľba <b>#pgv_lang[USE_REGISTRATION_MODULE]#</b> nastavená na Ano tak administrátor musí schváliť registráciu nového uživateľa.<br /><br />Nastavte na <b>Yes</b> ak chcete aby nový uživatelia boli verifikovaný a schválený než sa budú môcť prihlásiť. Ak nastavíte <b>No</b>, <b>#pgv_lang[verified_by_admin]#</b> checkbox bude označený automaticky v tom okamžiku keď uživateľ verifikuje svoj účet, a tak sa može ihneď prihlásiť bez schválenia administrátorom.";
$pgv_lang["SPLIT_PLACES"]		= "Rozdeliť miesta v editačnom móde";
$pgv_lang["SPLIT_PLACES_help"]		= "Nastavte na <b>Yes</b> ak chcete rozdeliť miesta čiarkou do polí pre ľahšiu editáciu. Napríklad:<br /><ol><li>Implicitne mód<br /><u>Miesto</u>: Half Moon Bay, San Mateo, California, USA<br /><br /><li>Oddelene<br /><u>Zem</u>: USA<br /><u>Štát</u>: California<br/><u>Kraj</u>: San Mateo<br/><u>Mesto</u>: Half Moon Bay</ol>";
$pgv_lang["ALLOW_REMEMBER_ME_help"]	= "Mnohé stránky dovoľujú, ak chcete, uložiť uživateľské meno a heslo v PC, ktoré sa dajú použiť pri ďalšej návšteve stránky. Zapnutie tejto voľby spôsobí vloženie checkboxu <b>Uložiť v tomto počítači?<b> na prihlasovaciu stránku. Ak uživateľ označí checkbox, povolí PhpGedView uložiť cookie v uživateľovom PC. Táto cookie umožňuje PhpGedView uložiť údaje o uživateľovi medzi návštevami stránky z toho istého PC.";
$pgv_lang["UNDERLINE_NAME_QUOTES"]	= "Podčiarknúť mená v závorkách";
$pgv_lang["UNDERLINE_NAME_QUOTES_help"]	= "Mnoho programov označuje preferované mená v GEDCOMe uzatvorením do zátvoriek. Obvyklá konvencie pre preferované maná je ich podčiarknutie. Povolením tejto voľby zkonvertujete všetky mená uzatvorené v zátvorkách na <span> with a CSS class of \"starredname\".<br /><br />Napríklad, ak je meno v GEDCOMe 1&nbsp;NAME&nbsp;Gustave&nbsp;\"Jean&nbsp;Paul\"&nbsp;Charles&nbsp;/Wilson/ povolenie tejto voľby zmení časť mena uzatvoreného v zátvorkách na  <span&nbsp;class=\"starredname\">Jean&nbsp;Paul</span> pre tlačové výstupy. V závislosti na ďaľších nastaveniach môže prehliadač zobrazovať meno ako  <b>Gustave&nbsp;<u>Jean&nbsp;Paul</u>&nbsp;Charles&nbsp;Wilson</b> alebo <b>Wilson,&nbsp;Gustave&nbsp;<u>Jean&nbsp;Paul</u> Charles</b>";
$pgv_lang["PRIVACY_BY_RESN"]		= "Použiť GEDCOM (RESN) k nastaveniu utajenia";
$pgv_lang["PRIVACY_BY_RESN_help"]	= "Špecifikácia GEDCOM 5.5.1 zahrňuje možnosť použitia RESN tagy k nastaveniu Utajenia pre osoby a údaje v GEDCOM súbore. Zapnutím tejto voľby poviete programu aby kontroloval pre úroveň 1 RESN tagy v GEDCOM záznamoch. Úroveň 2+ RESN tagu je automaticky aplikovaná a nebude ovplyvnená týmto nastavením. Pozor! Toto nastavenie môže spomaliť niektoré funkcie PhpGedView, ako napríklad vygenerovanie Zoznamu osôb.";
$pgv_lang["SHOW_LDS_AT_GLANCE"]		= "Zobraziť kód LDS obradu v schémach.";
$pgv_lang["SHOW_LDS_AT_GLANCE_help"]	= "Nastavenie tejto voľby na <b>Yes</b> dovolí zobraziť kód statusu pre LDS obrad v schémach.<ul><li><b>B</b> - Baptism</li><li><b>E</b> - Endowed</li><li><b>S</b> - Sealed to spouse</li><li><b>P</b> - Sealed to parents</li></ul>Osoba, ktorá má absolvované všetky obrady, má pred menom zobrazený kód <b>BESP</b>. Chýbajúci obrad je indikovaný <b>_</b> miesto písmena označujúceho príslušný obrad. Napríklad, <b>BE__</b> indikuje chýbajúce <b>S</b> a <b>P</b> obrady.";
$pgv_lang["GEDCOM_DEFAULT_TAB"]		= "Implicitné záložky ku zobrazeniu na osobných stránkach";
$pgv_lang["GEDCOM_DEFAULT_TAB_help"]	= "Táto voľba dovolí vybrať, ktoré záložky budú automaticky zobrazené pri otvorení na osobných stránkach.";
$pgv_lang["SHOW_MARRIED_NAMES"]		= "Zobraziť priezviská po sobáši na osobných stránkach";
$pgv_lang["SHOW_MARRIED_NAMES_help"]	= "Táto voľba zobrazí priezviská po sobáši u žien na ich osobných stránkach. Toto vyžaduje aby boli tieto priezviská pri načítaní GEDCOM súboru odhadnuté aplikáciou PhpGedView.";
$pgv_lang["SHOW_QUICK_RESN"]		= "Zobraziť polia s utajenými údajmi na formulári #pgv_lang[quick_update_title]#";
$pgv_lang["SHOW_QUICK_RESN_help"]	= "Táto voľba vám umožňuje povoliť alebo zakázať polia s utajenými údajmi na formulári #pgv_lang[quick_update_title]#. Tieto polia dovolia uživateľovi, ktorý pridáva informácie pomocou formulára potlačiť implicitné nastavenie utajenia pre údaje, ktoré zapisuje.";
$pgv_lang["USE_QUICK_UPDATE"]		= "Použiť formulár #pgv_lang[quick_update_title]#";
$pgv_lang["USE_QUICK_UPDATE_help"]	= "Táto voľba umožňuje uživateľom prihlásiť sa a odoslať zmeny pomocou formulára #pgv_lang[quick_update_title]#.";
$pgv_lang["SEARCHLOG_CREATE"]		= "Archivácia SearchLog súborov";
$pgv_lang["SEARCHLOG_CREATE_help"]	= "Ako často bude program archivovať SearchLog súbory.";
$pgv_lang["CHANGELOG_CREATE"]		= "Archivácia ChangeLog súborov";
$pgv_lang["CHANGELOG_CREATE_help"]	= "~#pgv_lang[CHANGELOG_CREATE]#~<br /><br />Ako často má program archivovať Changelog súbory.";
$pgv_lang["CHART_BOX_TAGS"]		= "Ďalšie údaje k zobrazeniu v schémach";
$pgv_lang["CHART_BOX_TAGS_help"]	= "Tu môžete uviesť zoznam údajov k doplneniu štandardne zobrazovaného narodenia a úmrtia, ktoré chcete doplniť do políčok v schémach, napríklad vo Vývode. Údaje musia byť oddelené čiarkou alebo medzerou a musia byť definované pomocou tagov z GEDCOM 5.5.1 štandardu. Napríklad, ak chcete zobraziť povolanie zadajte do zoznamu \"OCCU\".";
$pgv_lang["LANG_SELECTION_help"]	= "~#pgv_lang[LANG_SELECTION]#~<br /><br />Môžete zmeniť zoznam jazykov podporovaných vašimi PhpGedView stránkami označením alebo odznačením príslušného jazyka. Vaši uživatelia si potom môžu vyberať jazyk.<br /><br />To isté môžete urobiť pomocou linku <b>#pgv_lang[enable_disable_lang]#</b> v menu #pgv_lang[admin]#, kde tiež môžete meniť nastavenia ako je ikona zástavy jazyka, formát datumu alebo či má byť zobrazované priezvisko ako prvé.<br />";
$pgv_lang["MEDIA_ID_PREFIX"]		= "Média&nbsp;ID prefix";
$pgv_lang["MEDIA_ID_PREFIX_help"]	= "~#pgv_lang[MEDIA_ID_PREFIX]#~<br /><br />Keď je pridaný online nový mediálny záznam do PhpGedView je automaticky generované ID. Toto ID bude mať zadaný prefix.<br />";
$pgv_lang["new_gedcom_title"]		= "Genealógia z [#GEDCOMFILE#]";
$pgv_lang["USE_MEDIA_VIEWER"]		= "Použiť Media Viewer";
$pgv_lang["USE_MEDIA_VIEWER_help"]	= "~#pgv_lang[USE_MEDIA_VIEWER]#~<br /><br />Nastavte túto hodnotu na <b>Ano</b>, ak uživatelia kliknú na obrázky na vašej stránke otvorí sa stránka Media View obsiahnuté vo verzii 4.1. Stránka Media View zobrazí detaily obrázku a umožní upraviť obrázok. <br /><br />Nastavenie hodnoty na <b>Nie</b> poskytne zobrazenie vo formáte predchádzajúcich verzií PhpGedView pred verziou 4.1 Ak kliknete na obrázok tak sa otvorí v plnom rozlíšení v novom okne.<br /><br />";
$pgv_lang["USE_MEDIA_FIREWALL"]		= "Použiť Media Firewall";
$pgv_lang["USE_MEDIA_FIREWALL_help"]	= "~#pgv_lang[USE_MEDIA_FIREWALL]#~<br /><br />Prečítajte si vo Wiki popis ako použiť Media Firewall. <a href=\"http://wiki.phpgedview.net/en/index.php/Media_Firewall\" target=\"_blank\">http://wiki.phpgedview.net/en/index.php/Media_Firewall</a><br /><br />";
$pgv_lang["MEDIA_FIREWALL_ROOTDIR"]			= "Koreňový adresár Media Firewallu";
$pgv_lang["MEDIA_FIREWALL_ROOTDIR_help"]	= "~#pgv_lang[MEDIA_FIREWALL_ROOTDIR]#~<br /><br />Adresár v ktorom môže byť založený zabezpečený adresár Médií. Ak je toto pole prázdne, tak bude použitý adresár <b>#GLOBALS[INDEX_DIRECTORY]#</b>.<br /><br />";
$pgv_lang["SYNC_GEDCOM_FILE_help"] 	= "~#pgv_lang[SYNC_GEDCOM_FILE]#~<br /><br />V starších verziách PGV čakajúce zmeny boli ukladané v súbore GEDCOM a zmenené záznamy, ktoré boli 'akceptované' v databáze. Počínajúc verziou 4.1 už nie sú čakajúce zmeny ukladané v súbore GEDCOM ale v súbore zmien. <br /><br />Nastavenie tejto hodnoty na ano spôsobí aktualizáciu súboru GEDCOM keď budú zmeny akceptované v databáze. To udrží súbor GEDCOM synchronizovaný s databázou. Pre väčšiu kompatibilitu s predošlými verziami je default hodnota tohoto pola nastavená na ano.<br /><br />Môžete ju prestaviť na nie ak chcete šetriť pamäťou, keď akceptujete zmeny.<br />";
$pgv_lang["SYNC_GEDCOM_FILE"]		= "Synchronizovať zmeny v súbore GEDCOM";
$pgv_lang["COMMIT_COMMAND_help"] 	= "~#pgv_lang[COMMIT_COMMAND]#~<br /><br />Ak si želáte použiť riadenie verzií ako napríklad CVS na archiváciu zmien vo vašom GEDCOMe, konfigurácie alebo nastavenia utajenia, zadajte príkaz sem. Ponechajte box prázdny ak nechcete použiť systém riadenia verzií. Platné voľby sú <b>cvs</b> and <b>svn</b>.<br />";
$pgv_lang["COMMIT_COMMAND"] 		= "Príkaz na riadenie verzií";
$pgv_lang["SHOW_MULTISITE_SEARCH_help"]	= "~#pgv_lang[SHOW_MULTISITE_SEARCH]#~<br /><br />Mnohostránové vyhľadávanie dovolí uživateľom hľadať naprieč stránkami PhpGedView ktoré máte nastavené administrátorom v Správe stránok alebo ktoré sú vzdialene pripojené. Táto voľba určuje či je mnohostránkové hľadanie povolené pre všetkých alebo iba pre autorizavaných užívateľov.<br />";
$pgv_lang["SHOW_MULTISITE_SEARCH"]	= "Zobraziť mnohostránkové vyhľadanie";
$pgv_lang["SHOW_NO_WATERMARK"]			= "Kto môže vidieť obrázky bez vodoznaku?";
$pgv_lang["SHOW_NO_WATERMARK_help"]		= "~#pgv_lang[SHOW_NO_WATERMARK]#~<br /><br />Ak je aktívny Media Firewall, užívatelia uvidia vodoznak ak nemajú oprávnenia na úrovni špecifikovanej tu.<br />";
$pgv_lang["WATERMARK_THUMB"]			= "Pridať vodoznak do náhľadov?";
$pgv_lang["WATERMARK_THUMB_help"]		= "~#pgv_lang[WATERMARK_THUMB]#~<br /><br />Majú byť náhľady označené vodoznakom ak je aktívny Media Firewall? Váš zoznam médií bude načítaný rýchlejšie bez vodoznaku.<br />";
$pgv_lang["DBPERSIST"]			= "Použiť trvalé spojenie s databázou";
$pgv_lang["DBPERSIST_help"]		= "Určuje že PhpGedView by mal použiť trvalé spojenie s databázou keď s ňou komunikuje.<br /><br />Ak nastavíte <b>Ano</b>, PhpGedView zrýchli komunikáciu s databázou. Na druhej, strane to môže spôsobiť problémy ak v host konfigurácii máte nastavenú príliš nízku hodnotu pre maximálny počet pripojení. Ak si nie ste istý že nastavenie hostu podporuje trvalé pripojenie mal by ste nastaviť hodnotu na <b>Nie</b>.<br />";
?>
